/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');
const { join } = require('lodash');

const courseCountApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const id2str = require(`${libs}/middlewares/id2str`);

const config = require(`${libs}/config`);

const addMissing = require(`${libs}/middlewares/addMissing`);

let rqf = new ReqQueryFields();

let rqfMapfor = new ReqQueryFields();

courseCountApp.get('/upper_adm_dependency', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 7; ++i) {
        req.result.push({
            id: i,
            name: id2str.upperAdmDependency(i)
        });
    };
    next();
}, response('upper_adm_dependency'));

courseCountApp.get('/years', (req, res, next) => {
    req.sql.from('curso_ens_superior')
    .field('DISTINCT curso_ens_superior.ano_censo', 'year')
    .where('curso_ens_superior.ano_censo > 2010');
    next();
}, query, response('years'));

courseCountApp.get('/year_range', (req, res, next) => {
    req.sql.from('curso_ens_superior')
    .field('MIN(curso_ens_superior.ano_censo)', 'start_year')
    .field('MAX(curso_ens_superior.ano_censo)', 'end_year');
    next();
}, query, response('range'));

courseCountApp.get('/academic_organization', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 5; ++i) {
        req.result.push({
            id: i,
            name: id2str.academicOrganization(i)
        });
    };
    next();
}, response('academic_organization'));

courseCountApp.get('/ocde_geral', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 8; ++i) {
        req.result.push({
            id: i,
            name: id2str.ocdeGeral(i)
        });
    };
    next();
}, response('ocde_geral'));

courseCountApp.get('/ocde_specific', (req, res, next) => {
    req.result = [];
    const defaultCase = null;
    for(let i = 1; i <= 86; ++i) {
        let obj = {
            id: i,
            name: id2str.ocdeSpecific(i)
        };
        if (obj.name !== id2str.ocdeSpecific(defaultCase)){
            req.result.push(obj);
        }
    };
    req.result.push({
        id: defaultCase,
        name: id2str.ocdeSpecific(defaultCase)
    });
    next();
}, response('ocde_specific'));

courseCountApp.get('/ocde_detailed', (req, res, next) => {
    req.result = [];
    const defaultCase = null;
    for(let i = 142; i <= 863; ++i) {
        let obj = {
            id: i,
            name: id2str.ocdeDetailed(i)
        };
        if (obj.name !== id2str.ocdeDetailed(defaultCase)){
            req.result.push(obj);
        }
    };
    req.result.push({
        id: defaultCase,
        name: id2str.ocdeDetailed(defaultCase)
    });
    next();
}, response('ocde_detailed'));

courseCountApp.get('/cine_geral', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 10; ++i) {
        req.result.push({
            id: i,
            name: id2str.cineGeral(i)
        });
    };
    next();
}, response('cine_geral'));

courseCountApp.get('/cine_specific', (req, res, next) => {
    req.result = [];
    const defaultCase = null;
    for(let i = 1; i <= 104; ++i) {
        let obj = {
            id: i,
            name: id2str.cineSpecific(i)
        };
        if (obj.name !== id2str.cineSpecific(defaultCase)){
            req.result.push(obj);
        }
    };
    req.result.push({
        id: defaultCase,
        name: id2str.cineSpecific(defaultCase)
    });
    next();
}, response('cine_specific'));

courseCountApp.get('/cine_detailed', (req, res, next) => {
    req.result = [];
    const defaultCase = null;
    for(let i = 11; i <= 1041; ++i) {
        let obj = {
            id: i,
            name: id2str.cineDetailed(i)
        };
        if (obj.name !== id2str.cineDetailed(defaultCase)){
            req.result.push(obj);
        }
    };
    req.result.push({
        id: defaultCase,
        name: id2str.cineDetailed(defaultCase)
    });
    next();
}, response('cine_detailed'));

courseCountApp.get('/academic_level', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 4; ++i) {
        req.result.push({
            id: i,
            name: id2str.academicLevel(i)
        });
    };
    next();
}, response('academic_level'));

courseCountApp.get('/upper_education_mod', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 2; ++i) {
        req.result.push({
            id: i,
            name: id2str.upperEducationMod(i)
        });
    };
    next();
}, response('upper_education_mod'));

courseCountApp.get('/is_free', (req, res, next) => {
    req.result = [
        {id: null, name: 'Não Classificado'},
        {id: 0, name: 'Não'},
        {id: 1, name: 'Sim'}
    ];
    next();
}, response('is_free'));

courseCountApp.get('/night_time', (req, res, next) => {
    req.result = [{
        id: 9, 
        name: id2str.nightTime(9)
    }];
    for(let i = 0; i <= 1; ++i) {
        req.result.push({
            id: i,
            name: id2str.nightTime(i)
        })
    }
    next();
}, response('night_time'));

courseCountApp.get('/university', (req, res, next) => {
    req.sql.from('curso_ens_superior')
    .field('DISTINCT curso_ens_superior.nome_ies', 'nome')
    .field('curso_ens_superior.cod_ies', 'cod')
    next();
}, query, response('university'));

courseCountApp.get('/localoffer', (req, res, next) => {
    req.sql.from('localoferta_ens_superior', 'l')
    .field('DISTINCT l.nome', 'localoffer_name')
    .field('l.cod_local_oferta', 'localoffer_id');
    next();
}, query, response('localoffer'));


rqfMapfor.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValueToField({
    name: 'state',
    table: 'municipio',
    tableField: 'estado_id',
    resultField: 'state_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'estado_id',
	    table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'cod_municipio',
        foreignTable: 'localoferta_ens_superior'
    }
}, 'filter').addValue({
    name: 'mesoregion',
    table: 'municipio',
    tableField: ['nome_mesorregiao', 'mesorregiao_id'],
    resultField: ['mesoregion_name', 'mesoregion_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'mesorregiao_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'cod_municipio',
        foreignTable: 'localoferta_ens_superior'
    }
}).addValue({
    name: 'microregion',
    table: 'municipio',
    tableField: ['nome_microrregiao', 'microrregiao_id'],
    resultField: ['microregion_name', 'microregion_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'microrregiao_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'cod_municipio',
        foreignTable: 'localoferta_ens_superior'
    }
}).addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['id', 'nome'],
    resultField: ['city_id', 'city_name'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'cod_municipio',
        foreignTable: 'localoferta_ens_superior'
    }
}).addValue({
    name:'academic_level',
    table: 'curso_ens_superior',
    tableField: 'cod_grau_academico',
    resultField: 'academic_level_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_grau_academico'
    }
}).addValue({
    name: 'min_year',
    table: 'localoferta_ens_superior',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        table: 'localoferta_ens_superior',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: 'localoferta_ens_superior',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        table: 'localoferta_ens_superior',
        field: 'ano_censo'
    }
}).addValue({
    name:'course',
    table: 'curso_ens_superior',
    tableField: 'nome_curso',
    resultField: 'course_name',
    where: {
        relation: 'LIKE',
        type: 'string',
        field: 'nome_curso'
    }
}).addValueToField({
    name: 'campi',
    table: 'localoferta_ens_superior',
    tableField: ['cod_local_oferta', 'nome'],
    resultField: ['campi_id', 'campi_name'],
    where: {
	    relation: '=',
	    type: 'integer',
	    field: 'cod_local_oferta',
	    table: 'localoferta_ens_superior'
    }
}, 'filter').addValue({
    name:'upper_adm_dependency',
    table: 'curso_ens_superior',
    tableField: 'par_categoria_administrativa',
    resultField: 'upper_adm_dependency_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'par_categoria_administrativa'
    }
}).addValue({
    name:'upper_education_mod',
    table: 'curso_ens_superior',
    tableField: 'cod_modalidade_ensino',
    resultField: 'upper_education_mod_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_modalidade_ensino'
    }
}).addValue({
    name:'academic_organization',
    table: 'curso_ens_superior',
    tableField: 'cod_organizacao_academica',
    resultField: 'academic_organization_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_organizacao_academica'
    }
})


rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'region',
    table: 'localoferta_ens_superior',
    tableField: ['nome_regiao', 'cod_regiao'],
    resultField: ['region_name', 'region_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_regiao',
	    table: 'localoferta_ens_superior'
    },
    join: {
        primary: ['ano_censo', 'cod_curso'],
        foreign: ['ano_censo', 'cod_curso'],
        foreignTable: 'curso_ens_superior'
    }
}).addValue({
    name: 'state',
    table: 'localoferta_ens_superior',
    tableField: ['sigla_uf_t', 'cod_uf_t'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_uf',
	    table: 'localoferta_ens_superior'
    },
    join: {
        primary: ['ano_censo', 'cod_curso'],
        foreign: ['ano_censo', 'cod_curso'],
        foreignTable: 'curso_ens_superior'
    }
}).addValue({
    name: 'mesoregion',
    table: 'municipio',
    tableField: ['nome_mesorregiao', 'mesorregiao_id'],
    resultField: ['mesoregion_name', 'mesoregion_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'mesorregiao_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'cod_municipio_curso',
        foreignTable: 'curso_ens_superior'
    }
}).addValue({
    name: 'microregion',
    table: 'municipio',
    tableField: ['nome_microrregiao', 'microrregiao_id'],
    resultField: ['microregion_name', 'microregion_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'microrregiao_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'cod_municipio_curso',
        foreignTable: 'curso_ens_superior'
    }
}).addValue({
    name: 'city',
    table: 'localoferta_ens_superior',
    tableField: ['cod_municipio_t', 'nome_municipio_t'],
    resultField: ['city_id', 'city_name'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_municipio',
        table: 'localoferta_ens_superior'
    },
    join: {
        primary: ['ano_censo', 'cod_curso'],
        foreign: ['ano_censo', 'cod_curso'],
        foreignTable: 'curso_ens_superior'
    }
}).addValue({
    name: 'localoffer',
    table: 'localoferta_ens_superior',
    tableField: ['cod_local_oferta', 'nome'],
    resultField: ['localoffer_id', 'localoffer_name'],
    where: {
	    relation: '=',
	    type: 'integer',
	    field: 'cod_curso',
	    table: 'curso_ens_superior'
    },
    join: {
        primary: ['ano_censo', 'cod_curso'],
	    foreign: ['ano_censo', 'cod_curso'],
	    foreignTable: 'curso_ens_superior'
    }
}).addValue({
    name: 'campi',
    table: 'localoferta_ens_superior',
    tableField: ['cod_local_oferta', 'nome'],
    resultField: ['campi_id', 'campi_name'],
    where: {
	    relation: '=',
	    type: 'integer',
	    field: 'cod_curso',
	    table: 'curso_ens_superior'
    },
    join: {
        primary: ['ano_censo', 'cod_curso'],
	    foreign: ['ano_censo', 'cod_curso'],
	    foreignTable: 'curso_ens_superior'
    }
}).addValue({
    name: 'university',
    table: 'curso_ens_superior',
    tableField: ['cod_ies', 'nome_ies'],
    resultField: ['university_id', 'university_name'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_ies'
    }
}).addValue({
    name: 'universityLocalOffer',
    table: 'curso_ens_superior',
    tableField: ['cod_ies', 'nome_ies'],
    resultField: ['university_id', 'university_name'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_ies'
    }
}).addValue({
    name:'upper_adm_dependency',
    table: 'curso_ens_superior',
    tableField: 'par_categoria_administrativa',
    resultField: 'upper_adm_dependency_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'par_categoria_administrativa'
    }
}).addValue({
    name:'academic_organization',
    table: 'curso_ens_superior',
    tableField: 'cod_organizacao_academica',
    resultField: 'academic_organization_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_organizacao_academica'
    }
}).addValue({
    name:'course',
    table: 'curso_ens_superior',
    tableField: 'nome_curso',
    resultField: 'course_name',
    where: {
        relation: 'LIKE',
        type: 'string',
        field: 'nome_curso'
    }
}).addValue({
    name:'ocde_specific',
    table: 'curso_ens_superior',
    tableField: ['cod_ocde_area_especifica', 'nome_ocde_area_especifica'],
    resultField: ['ocde_specific_id', 'ocde_specific_name'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_ocde_area_especifica'
    }
}).addValue({
    name:'ocde_geral',
    table: 'curso_ens_superior',
    tableField: ['cod_ocde_area_geral', 'nome_ocde_area_geral'],
    resultField: ['ocde_geral_id', 'ocde_geral_name'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_ocde_area_geral'
    }
}).addValue({
    name:'ocde_detailed',
    table: 'curso_ens_superior',
    tableField: ['cod_ocde_area_detalhada', 'nome_ocde_area_detalhada'],
    resultField: ['ocde_detailed_id', 'ocde_detailed_name'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_ocde_area_detalhada'
    }
}).addValue({
    name:'cine_specific',
    table: 'curso_ens_superior',
    tableField: ['cod_cine_area_especifica', 'nome_cine_area_especifica'],
    resultField: ['cine_specific_id', 'cine_specific_name'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_cine_area_especifica'
    }
}).addValue({
    name:'cine_geral',
    table: 'curso_ens_superior',
    tableField: ['cod_cine_area_geral', 'nome_cine_area_geral'],
    resultField: ['cine_geral_id', 'cine_geral_name'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_cine_area_geral'
    }
}).addValue({
    name:'cine_detailed',
    table: 'curso_ens_superior',
    tableField: ['cod_cine_area_detalhada', 'nome_cine_area_detalhada'],
    resultField: ['cine_detailed_id', 'cine_detailed_name'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_cine_area_detalhada'
    }
}).addValue({
    name:'academic_level',
    table: 'curso_ens_superior',
    tableField: 'cod_grau_academico',
    resultField: 'academic_level_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_grau_academico'
    }
}).addValue({
    name:'upper_education_mod',
    table: 'curso_ens_superior',
    tableField: 'cod_modalidade_ensino',
    resultField: 'upper_education_mod_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_modalidade_ensino'
    }
}).addValue({
    name:'is_free',
    table: 'curso_ens_superior',
    tableField: 'gratuito',
    resultField: 'is_free_id',
    where: {
        relation: '=',
        type: 'boolean',
        field: 'gratuito'
    }
}).addValue({
    name:'night_time',
    table: 'curso_ens_superior',
    tableField: 'noturno_curso_t',
    resultField: 'night_time_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'noturno_curso_t'
    }
}).addValue({
    name:'situation',
    table: 'curso_ens_superior',
    tableField: 'cod_situacao_curso',
    resultField: 'situacao_curso_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_situacao_curso'
    }
}).addValue({
    name:'year',
    table: 'curso_ens_superior',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '=',
        type: 'integer',
        field: 'ano_censo'
    }
}).addValue({
    name: 'min_year',
    table: 'curso_ens_superior',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        table: 'curso_ens_superior',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: 'curso_ens_superior',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        table: 'curso_ens_superior',
        field: 'ano_censo'
    }
})

courseCountApp.get('/count_by_name', rqfMapfor.parse(), (req, res, next) => {
    req.sql.from('localoferta_ens_superior')
    .field('COUNT(DISTINCT localoferta_ens_superior.cod_curso)', 'total')
    .field('localoferta_ens_superior.ano_censo', 'year')
    .join ('curso_ens_superior ON (localoferta_ens_superior.cod_curso = curso_ens_superior.cod_curso) AND (localoferta_ens_superior.ano_censo = curso_ens_superior.ano_censo)')
    .where('curso_ens_superior.cod_nivel_academico = 1')
    .where('curso_ens_superior.tipo_atributo_ingresso <> 1 OR curso_ens_superior.tipo_atributo_ingresso is NULL')
    .group('localoferta_ens_superior.ano_censo')
    .order('localoferta_ens_superior.ano_censo')
    
    next();
}, rqfMapfor.build(), query, (req, res, next) =>{
    if ('course' in req.dims){
        var total_course = req.result.reduce((total, cur) => {return total += cur.total}, 0)
        for (var course of req.result){
            course.percentage = Number((( course.total / total_course ) * 100).toFixed(2))
        }
    }
    next();
}, id2str.transform(), response('count_by_name'));

courseCountApp.get('/', rqf.parse(), (req, res, next) => {
    if ("localoffer" in req.dims || "campi" in req.dims) {
        if ("university" in req.dims || "universityLocalOffer" in req.dims) {
            req.sql.from('curso_ens_superior')
                .field('curso_ens_superior.ano_censo', 'year')
                .field('COUNT(localoferta_ens_superior.cod_local_oferta)', 'total')
                .where('curso_ens_superior.tipo_atributo_ingresso <> 1 OR curso_ens_superior.tipo_atributo_ingresso is NULL')
                .where('curso_ens_superior.cod_nivel_academico = 1')
                .group('curso_ens_superior.ano_censo')
                .order('curso_ens_superior.ano_censo')
                .order('localoferta_ens_superior.cod_local_oferta');
        } else {
            req.sql.from('curso_ens_superior')
                .field('curso_ens_superior.ano_censo', 'year')
                .field('COUNT(localoferta_ens_superior.cod_local_oferta)', 'total')
                .field('localoferta_ens_superior.cod_ies', 'university_id')
                .field('curso_ens_superior.nome_ies', 'university_name')
                .where('curso_ens_superior.tipo_atributo_ingresso <> 1 OR curso_ens_superior.tipo_atributo_ingresso is NULL')
                .where('curso_ens_superior.cod_nivel_academico = 1')
                .group('curso_ens_superior.ano_censo')
                .group('localoferta_ens_superior.cod_ies')
                .group('curso_ens_superior.nome_ies')
                .order('curso_ens_superior.ano_censo')
                .order('localoferta_ens_superior.cod_local_oferta');
        }
    } else if (("state" in req.dims) || ("city" in req.dims) || ("microregion" in req.dims) || ("mesoregion" in req.dims) || ("region" in req.dims) || 
        ("state" in req.filter) || ("city" in req.filter) || ("microregion" in req.filter) || ("mesoregion" in req.filter) || ("region" in req.filter) ) {
        if ("course" in req.dims){
            req.sql.from('curso_ens_superior')
                .field('COUNT(*)', 'total')
                .field("'Brasil'", 'name')
                .field('curso_ens_superior.ano_censo', 'year')
                .group('curso_ens_superior.ano_censo')
                .order('curso_ens_superior.ano_censo')
                .where('curso_ens_superior.cod_nivel_academico = 1')
        }
        else{
            req.sql.from('curso_ens_superior')
                .field('COUNT(DISTINCT curso_ens_superior.cod_curso)', 'total')
                .field("'Brasil'", 'name')
                .field('curso_ens_superior.ano_censo', 'year')
                .group('curso_ens_superior.ano_censo')
                .order('curso_ens_superior.ano_censo')
                .where('curso_ens_superior.tipo_atributo_ingresso <> 1 OR curso_ens_superior.tipo_atributo_ingresso is NULL')
                .where('curso_ens_superior.cod_nivel_academico = 1');
        }
        
    } else if ("university" in req.dims || "universityLocalOffer" in req.dims) {
        req.sql.from('curso_ens_superior')
            .field('COUNT(curso_ens_superior.cod_curso)', 'total')
            .field("'Brasil'", 'name')
            .field('curso_ens_superior.ano_censo', 'year')
            .group('curso_ens_superior.cod_ies')
            .group('curso_ens_superior.ano_censo')
            .order('curso_ens_superior.cod_ies')
            .order('curso_ens_superior.ano_censo')
            .where('curso_ens_superior.tipo_atributo_ingresso <> 1 OR curso_ens_superior.tipo_atributo_ingresso is NULL')
            .where('curso_ens_superior.cod_nivel_academico = 1');
    } else {
        req.sql.from('curso_ens_superior')
            .field('COUNT(curso_ens_superior.cod_curso)', 'total')
            .field("'Brasil'", 'name')
            .field('curso_ens_superior.ano_censo', 'year')
            .group('curso_ens_superior.ano_censo')
            .order('curso_ens_superior.ano_censo')
            .where('curso_ens_superior.tipo_atributo_ingresso <> 1 OR curso_ens_superior.tipo_atributo_ingresso is NULL')
            .where('curso_ens_superior.cod_nivel_academico = 1');
    }
    next();
}, rqf.build(), query, (req, res, next) =>{
    if ('course' in req.dims){
        var total_course = req.result.reduce((total, cur) => {return total += cur.total}, 0)
        for (var course of req.result){
            course.percentage = Number((( course.total / total_course ) * 100).toFixed(2))
        }
    }
    next();
}, id2str.transform(), addMissing(rqf), response('course_count'));

module.exports = courseCountApp;
