const express = require('express');

const portalMecInepApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const id2str = require(`${libs}/middlewares/id2str`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const addMissing = require(`${libs}/middlewares/addMissing`);

const config = require(`${libs}/config`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'school_cod',
    table: 'escola',
    tableField: 'id',
    resultField: 'school_cod_id',
    where: {
        relation: '=',
        type: 'integer',
        table: 'escola',
        field: 'id'
    }
});

portalMecInepApp.get('/', rqf.parse(), (req, res, next) => {

    req.sql.field('DISTINCT escola.id', 'id')
    .field('escola.nome_escola', 'name')
    .from('escola')
    .join('estado', null, 'estado.id=escola.estado_id')
    .field('estado.nome', 'state_name')
    .join('municipio', null, 'municipio.id=escola.municipio_id')
    .field('municipio.nome', 'city_name')

    next();

}, rqf.build(), query, response('portalMec_inep'));

module.exports = portalMecInepApp;
