const express = require('express');

const regionApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const config = require(`${libs}/config`); 

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

regionApp.use(cache('15 day'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addValue({
    name: 'id',
    table: '@',
    tableField: 'id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id',
        table: '@'
    }
}).addValue({
    name: 'id_not',
    table: '@',
    tableField: 'id',
    where: {
        relation: '<>',
        type: 'integer',
        field: 'id',
        table: '@'
    }
}).addField({
    name: 'search',
    field: false,
    where: true
}).addValueToField({
    name: 'name',
    table: '@',
    tableField: 'nome',
    where: {
        relation: 'LIKE',
        type: 'string',
        field: 'nome',
        table: '@'
    }
}, 'search');

regionApp.get('/', rqf.parse(), (req, res, next) => {
    req.sql.from('regiao')
        .field('id')
        .field('nome', 'name');
    next();
}, rqf.build(), query, response('region'));

module.exports = regionApp;
