/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const distributionApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const multiQuery = require(`${libs}/middlewares/multiQuery`);

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const id2str = require(`${libs}/middlewares/id2str`);

const config = require(`${libs}/config`); 

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

distributionApp.use(cache('15 day'));

rqf.addField({
    name: 'dims',
    field: true,
    where: false
}).addField({
    name: 'filter',
    field: false,
    where: true
}).addValueToField({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'municipio_id',
        table: 'fatores_matricula'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'fatores_matricula'
    }
}, 'dims').addValueToField({
    name: 'city',
    table: 'municipio',
    tableField: 'nome',
    resultField: 'city_name',
    where: {
        relation: '=',
        type: 'integer',
        field: 'municipio_id',
        table: 'fatores_matricula'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'fatores_matricula'
    }
}, 'filter').addValue({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'estado_id',
        table: 'fatores_matricula'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'fatores_matricula'
    }
}).addValue({
    name: 'region',
    table: 'regiao',
    tableField: ['nome', 'id'],
    resultField: ['region_name', 'region_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'regiao_id',
        foreignTable: 'fatores_matricula'
    }
})

// Return all cities
distributionApp.get('/', rqf.parse(), (req, res, next) => {
    req.querySet = [];
    req.queryIndex = {};

    let relation = req.sql.clone();
    relation.from('relacao_fatores_matricula').field('*');
    req.queryIndex.relation = req.querySet.push(relation) - 1;

    req.sql.from('fatores_matricula')
    .field('fatores_matricula.municipio_id', 'municipio_id')
    .field('fatores_matricula."mais_CRE_0"')
	.field('fatores_matricula."mais_CRE_1"')
	.field('fatores_matricula."mais_CRE_2"')
	.field('fatores_matricula."mais_CRE_3"')
	.field('fatores_matricula."mais_PRE"')
	.field('fatores_matricula."mais_EFAI"')
	.field('fatores_matricula."mais_EFAF"')
	.field('fatores_matricula."mais_EM"')
	.field('fatores_matricula."mais_EJA"')
	.field('fatores_matricula."menos_CRE_0"')
	.field('fatores_matricula."menos_CRE_1"')
	.field('fatores_matricula."menos_CRE_2"')
	.field('fatores_matricula."menos_CRE_3"')
	.field('fatores_matricula."menos_PRE"')
	.field('fatores_matricula."menos_EFAI"')
	.field('fatores_matricula."menos_EFAF"')
	.field('fatores_matricula."menos_EM"')
	.field('fatores_matricula."menos_EJA"')
    .group('fatores_matricula.municipio_id')
    .group('fatores_matricula."mais_CRE_0"')
	.group('fatores_matricula."mais_CRE_1"')
	.group('fatores_matricula."mais_CRE_2"')
	.group('fatores_matricula."mais_CRE_3"')
	.group('fatores_matricula."mais_PRE"')
	.group('fatores_matricula."mais_EFAI"')
	.group('fatores_matricula."mais_EFAF"')
	.group('fatores_matricula."mais_EM"')
	.group('fatores_matricula."mais_EJA"')
	.group('fatores_matricula."menos_CRE_0"')
	.group('fatores_matricula."menos_CRE_1"')
	.group('fatores_matricula."menos_CRE_2"')
	.group('fatores_matricula."menos_CRE_3"')
	.group('fatores_matricula."menos_PRE"')
	.group('fatores_matricula."menos_EFAI"')
	.group('fatores_matricula."menos_EFAF"')
	.group('fatores_matricula."menos_EM"')
	.group('fatores_matricula."menos_EJA"');

    if(typeof req.dims.state !== 'undefined' || typeof req.filter.state !== 'undefined') {
        req.sql.where('fatores_matricula.nivel = \'UF\'');
    } else {
        req.sql.where('fatores_matricula.nivel = \'BR\'');
    }

    next();
}, rqf.build(), query, (req, res, next) => {
    req.enrollmentFactor = req.result;
    next();
}, multiQuery, (req, res, next) => {
    let relation = req.result[req.queryIndex.relation];
    let result = [];
    let first = true;
    req.enrollmentFactor.forEach((city) => {
        // if(first) console.log(city);
        let obj = {
            level: city.nivel,
            region_id: city.regiao_id,
            region_name: city.region_name,
            state_id: city.state_id,
            state_name: city.state_name,
            city_id: city.municipio_id,
            city_name: city.city_name,
            series: []
        };
        // if(first) console.log(obj);
        first = false;
        relation.forEach((serie) => {
            obj.series.push({
                serie_id: serie.id,
                distribution_factor_addition: city[serie.fator_adicao],
                distribution_factor_reduction: city[serie.fator_reducao]
            });
        });
        result.push(obj);
    });
    req.result = result;
    next();
}, response('ditributionFactor'));

module.exports = distributionApp;
