/*
Copyright (C) 2024 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const potentialRevenueApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const id2str = require(`${libs}/middlewares/id2str`);

const config = require(`${libs}/config`); 

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

const aggregateData = require(`${libs}/middlewares/aggregateData`);

let rqf = new ReqQueryFields();

potentialRevenueApp.use(cache('15 day'));

potentialRevenueApp.get('/years', (req, res, next) => {
    req.sql.from('receitas')
    .field('DISTINCT receitas.ano', 'year')
    .where('receitas.ano is not null')
    next();
}, query, response('years'))

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'min_year',
    table: 'receitas',
    tableField: 'ano',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        field: 'ano'
    }
}).addValue({
    name: 'max_year',
    table: 'receitas',
    tableField: 'ano',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        field: 'ano'
    }
}).addValue({
    name: 'region',
    table: 'estado',
    tableField: ['nome_ente', 'cod_ibge', 'id', 'regiao_id'],
    resultField: ['state_name', 'state_cod_ibge', 'state_id', 'region_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'regiao_id',
    },
    join: {
        primary: 'id',
        foreign: 'cod_ibge',
        foreignTable: 'receitas'
    }
})


potentialRevenueApp.get('/', rqf.parse(), rqf.build(),  (req, res, next) => {

    if (req.query.dims && req.query.dims.includes('receita_potencial')) {
        let whereCondition = req.query.filter.includes("region") ? "" : "receitas.cod_ibge = 0";
        let filterId;
        const filters = req.query.filter.split(",");
        filters.forEach((filter) => {
            if (filter.includes("state") || filter.includes("city")) {
                filterId = Number(filter.split(":")[1].replace(/"/g, ""));
                whereCondition = `receitas.cod_ibge = ${filterId}`
            }
        })

        req.sql.from('receitas')
        .field('receitas.ano', 'year')
        .field('receitas.ano', 'total_ano')
        .field('receitas.nome_ente', 'total_nome_ente')
        .field('receitas.receitas', 'total_receitas')
        .field('matriculas_publica', 'total_matriculas_publica')
        .field('matriculas_publicas_mais_conveniada', 'total_matriculas_publicas_mais_conveniada')
        .where(`${whereCondition}`)
        .order('receitas.ano');
    }

    next();
}, query, aggregateData, id2str.transform(false), response('potentialRevenue'));

module.exports = potentialRevenueApp;