const express = require('express');

const pubApp = express();

const libs = `${process.cwd()}/libs`;

const config = require(`${libs}/config`);

const log = require(`${libs}/log`)(module);

const Publication = require(`${libs}/models/publication`);

const File = require(`${libs}/models/file`);

const response = require(`${libs}/middlewares/response`);

const email = require(`${libs}/middlewares/email`);

const passport = require('passport');

const fileWorker = require('./file.controller.js');

let upload = require('../middlewares/multer.config.js');

const authorized = require(`${libs}/middlewares/authorize.js`);

function emailSyntax(email) {
  const regex = /^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;
  return regex.test(email);
}

pubApp.get('/', async (req, res, next) => {
  const ordenar = req.query.order || 'DESC';
  const filter = req.query.filter || 'all';
  const page = parseInt(req.query.page) || 1; // Current page number
  const pageSize = parseInt(req.query.pageSize) || 5; // Number of items per page
  if (filter === 'all') {
    const totalCount = await Publication.count();
    const offset = (page - 1) * pageSize;

    const publis = await Publication.findAll({
      offset,
      limit: pageSize,
      order: [
        ['created_at', ordenar],
      ],
    });

    res.json({
      page,
      pageSize,
      totalCount,
      data: publis,
    });
  }
  else {
    const totalCount = await Publication.count({ where: { is_draft: filter } });
    const offset = (page - 1) * pageSize;

    const publis = await Publication.findAll({
      offset,
      limit: pageSize,
      order: [
        ['created_at', ordenar],
      ],
      where: {
        is_draft: filter
      }
    });

    res.json({
      page,
      pageSize,
      totalCount,
      data: publis,
    });
  }
});

pubApp.get('/homepage', async (req, res, next)=> {
  const page = parseInt(req.query.page) || 1; // Current page number
  const pageSize = parseInt(req.query.pageSize) || 5; // Number of items per page
  const totalCount = await Publication.count({ where: { is_headline: true } });
  const offset = (page - 1) * pageSize;
  const publis = await Publication.findAll({
    offset,
    limit: pageSize, 
    where:{
      is_headline:true
    }
  });
  res.json({
    page,
    pageSize,
    totalCount,
    data: publis,
  });
});

pubApp.get('/type', async (req, res, next) => {
  const page = parseInt(req.query.page) || 1; // Current page number
  const pageSize = parseInt(req.query.pageSize) || 5; // Number of items per page
  const tipo = req.query.tipo || 'all';
  console.log(tipo);
  if(tipo === 'all'){
    const totalCount = await Publication.count();
    const offset = (page - 1) * pageSize;

    const publis = await Publication.findAll({
      offset,
      limit: pageSize,
    });

    res.json({
      page,
      pageSize,
      totalCount,
      data: publis,
    });
  }
  else{
    const totalCount = await Publication.count({ where: { filter: tipo } });
    const offset = (page - 1) * pageSize;
    const publis = await Publication.findAll({
      offset,
      limit: pageSize,
      where: {
        filter: tipo
      }
    });
    res.json({
      page,
      pageSize,
      totalCount,
      data: publis,
    });
  }
});


pubApp.get('/:id', async (req, res, next) => {
  let pb = await Publication.findByPk(req.params.id).catch(function (err) {
    log.error(err);
    return next(err);
  }
  );
  if (!pb) {
    res.statusCode = 404;
    res.json({ msg: "A publicação não está cadastrada" });
  }
  else {
    let publ = pb.toJSON();
    publ.Filename = null;
    const file_ = await File.findByPk(pb.upload).catch((err) => {
      log.error(err);
      return next(err);
    });
    if (file_) {
      publ.Filename = file_.name;
    }
    req.result = publ;
    next();
  }
}, response('publication'));

pubApp.post('/', passport.authenticate('bearer', { session: false }), authorized('criar publicacao'), upload.single('file'), async (req, res, next) => {
  let _file_id = null
  if (req.file) {
    _file_id = await fileWorker.uploadFile(req.file);
    if (!_file_id)
      console.log("NAO ARQUIVO");
  }
  let data = JSON.parse(req.body.data);
  let pb = await Publication.create({
    id: 0,
    filter: data.categoria,
    title: data.title,
    authors: data.autores,
    organization: data.organizacao,
    year: data.ano,
    text: data.texto,
    link: data.link,
    upload: _file_id,
    is_draft: data.rascunho,
    is_headline: data.homepage,
    volume: data.volume,
    pages: data.pagina
  }).catch(function (err) {
    log.error(err);
    let errors = [];
    for (let errName in err.errors) {
      errors.push(err.errors[errName].message);
    }
    log.error(errors);
    res.statusCode = 400;
    return res.json({ err, errors });
    // handle error;
  });
  req.result = pb.toJSON();
  next();
}, response('publication'));

pubApp.post('/edit', passport.authenticate('bearer', { session: false }), authorized('editar publicacao'), upload.single('file'), async (req, res, next) => {
  let _file_id = null
  if (req.file) {
    _file_id = await fileWorker.uploadFile(req.file);
    if (!_file_id)
      console.log("NAO ARQUIVO");
  }
  let data = JSON.parse(req.body.data);
  console.log(data);
  let pb = await Publication.findByPk(data.id).catch(function (err) {
    log.error(err);
    return next(err);
  });
  pb.filter = data.categoria || pb.filter;
  pb.title = data.title || pb.title;
  pb.authors = data.autores || pb.authors;
  pb.organization = data.organizacao || pb.organization;
  pb.year = data.ano || pb.year;
  pb.text = data.texto || pb.text;
  pb.link = data.link || pb.link;
  pb.is_headline = data.homepage || pb.is_headline;
  pb.is_draft = data.rascunho || pb.is_draft;
  pb.upload = _file_id || pb.upload;
  pb.volume = data.volume || pb.volume;
  pb.pages = data.pagina || pb.pages;

  pb.save().catch(function (err) {
    log.error(err);
    let errors = [];
    for (let errName in err.errors) {
      errors.push(err.errors[errName].message);
    }
    log.error(errors);
    res.statusCode = 400;
    return res.json({ err, errors });
    // handle error;
  });

  req.result = pb.toJSON();
  next();
}, response('publication'));

pubApp.delete('/:id', passport.authenticate('bearer', { session: false }), authorized('apagar publicacao'), async (req, res, next) => {
  await Publication.destroy({ where: { id: req.params.id } }).catch(function (err) {
    if (err) {
      log.error(err);
      return next({ err });
    }
  });
  return next({ msg: 'Publication Deleted', status: 200 });
});

module.exports = pubApp;
