const express = require('express');

const resetTokenApp = express();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const ResetToken = require(`${libs}/models/resetToken`);

const User = require(`${libs}/models/user`);

resetTokenApp.get('/:token', async (req, res, next) => {
    let token = req.params.token;
    let rToken = await ResetToken.findOne({where:{ token: token} }).catch(function (err) {
        if (err) {
            log.error(err);
            return next({ err });
        }
    });
    console.log(rToken);
    if (!rToken) {
        res.statusCode = 401;
        return next({ msg: 'Token not found', status: 401 });
    }
    if (rToken.hasExpired()) {
        res.statusCode = 410;
        await ResetToken.destroy({where:{ token: token}}).catch(function (err) {
            if (err) {
                log.error(err);
                return next({ err });
            }
        })
        return next({ msg: 'Token expired', status: 410 });
    }
    let _user = await User.findByPk(rToken.user_id).catch(function (err) {
        if (err) {
            log.error(err);
            return next({ err });
        }
    })
    let u = _user.toJSON();
    delete u.salt;
    delete u.hashed_password;
    res.json({ user: u });
});

resetTokenApp.post('/:token', async (req, res, next) => {
    let token = req.params.token;
    let rToken = await ResetToken.findOne({where:{ token: token}}).catch(function (err) {
        if (err) {
            log.error(err);
            return next({ err });
        }
    })
    if (!rToken) {
        res.statusCode = 404;
        return next({ msg: 'Token not found', status: 404 });
    }
    let _user = await User.findByPk(rToken.user_id).catch(function (err) {
        if (err) {
            log.error(err);
            return next({ err });
        }
    })
    await _user.update({password:req.body.password});
    _user.save().catch(function (err) {
        if (err) {
            log.error(err);
            return next({ err });
        }
    })
    await ResetToken.destroy({where:{token: token} }).catch(function (err) {
        if (err) {
            log.error(err);
            return next({ err });
        }
    })
    res.json({ msg: "Senha alterada com sucesso" });
});

module.exports = resetTokenApp;
