/*
Copyright (C) 2024 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const studentRevenueApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const aggregateData = require(`${libs}/middlewares/aggregateData`);

const id2str = require(`${libs}/middlewares/id2str`);

const config = require(`${libs}/config`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: { include: [200] } }).middleware;

let rqf = new ReqQueryFields();

// studentRevenueApp.use(cache('15 day'));

studentRevenueApp.get('/years', (req, res, next) => {
    req.sql.from('receitas')
        .field('DISTINCT receitas.ano', 'year')
        .where('receitas.ano is not null')
    next();
}, query, response('years'));

studentRevenueApp.get('/type', (req, res, next) => {
    req.result = []

    req.result.push({ id: 1, name: "Rede Estadual" });
    req.result.push({ id: 2, name: "Rede Municipal" });
    next();
}, response('type'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'min_year',
    table: 'receitas',
    tableField: 'ano',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        field: 'ano'
    }
}).addValue({
    name: 'max_year',
    table: 'receitas',
    tableField: 'ano',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        field: 'ano'
    }
}).addValue({
    name: 'region',
    table: 'estado',
    tableField: ['nome_ente', 'cod_ibge', 'id', 'regiao_id'],
    resultField: ['state_name', 'state_cod_ibge', 'state_id', 'region_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'regiao_id',
    },
    join: {
        primary: 'id',
        foreign: 'cod_ibge',
        foreignTable: 'receitas'
    }
})

studentRevenueApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
    if (req.query.dims && req.query.dims.includes('receitas')) {
        let obj = {};
        let whereCondition = req.query.filter.includes("region") ? "" : "receitas.cod_ibge = 0";

        let typeFilter = false;
        let filterId;
        const filters = req.query.filter.split(",");
        filters.forEach((filter) => {
            if (filter.includes("state") || filter.includes("city")) {
                filterId = Number(filter.split(":")[1].replace(/"/g, ""));
                whereCondition = `receitas.cod_ibge = ${filterId}`
            }
        })

        if (req.query.filter) {
            const jsonString = `{${req.query.filter.replace(/(\w+):/g, '"$1":')}}`;
            obj = JSON.parse(jsonString);
            if (obj.type) {
                if (obj.type.includes("1") && !obj.type.includes("2")) {
                    whereCondition = "receitas.cod_ibge >= 11 and receitas.cod_ibge <= 53"
                }
                else if (obj.type.includes("2") && !obj.type.includes("1")) {
                    whereCondition = "receitas.cod_ibge > 53"
                }

                typeFilter = true;
            }
        }
        if (!typeFilter || (typeFilter && (!obj.state && !obj.city && !obj.region))) {
            req.sql.from('receitas')
                .field('receitas.ano', 'year')
                .field(`SUM(receitas) / SUM(matriculas_publica)`, '(total_receita_aluno_ano_publica)')
                .field(`SUM(receitas) / SUM(matriculas_publica) / 12`, 'total_receita_aluno_mes_publica')
                .field(`SUM(receitas) / SUM(matriculas_publicas_mais_conveniada)`, 'total_receita_aluno_ano_publica_mais_conveniada')
                .field(`SUM(receitas) / SUM(matriculas_publicas_mais_conveniada) / 12`, 'total_receita_aluno_mes_publica_mais_conveniada')
                .where(`${whereCondition}`)
                .group('receitas.ano')
                .order('receitas.ano')
        }
    }

    next();
}, query, aggregateData, id2str.transform(false), response('student_revenue'));

module.exports = studentRevenueApp;
