const express = require('express');

const courseStudentsApp = express.Router();

const libs = `${process.cwd()}/libs`;

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const response = require(`${libs}/middlewares/response`);

const id2str = require(`${libs}/middlewares/id2str`);

let rqf = new ReqQueryFields();

courseStudentsApp.get('/enrolled_vacancies_freshmen', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 3; ++i) {
        req.result.push({
            id: i,
            name: id2str.enrolledVacanciesFreshmen(i)
        });
    };
    next();
}, response('enrolled_vacancies_freshmen'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
})
.addValueToField({
    name: 'state',
    table: 'ies_ens_superior',
    tableField: 'cod_uf_ies',
    resultField: 'state_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_uf_ies',
	    table: 'ies_ens_superior'
    }
}, 'filter')
.addValueToField({
    name: 'min_year',
    table: 'curso_ens_superior',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        field: 'ano_censo',
        table: 'curso_ens_superior'
    }
}, 'filter')
.addValueToField({
    name: 'max_year',
    table: 'curso_ens_superior',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        field: 'ano_censo',
        table: 'ies_ens_superior'
    }
}, 'filter')
.addValue({
    name: 'upper_adm_dependency',
    table: 'curso_ens_superior',
    tableField: 'par_categoria_administrativa',
    resultField: 'upper_adm_dependency_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'par_categoria_administrativa', //cod_categoria_administrativa
        table: 'curso_ens_superior'
    }
})
.addValue({
    name: 'course',
    table: 'curso_ens_superior',
    tableField: 'nome_curso',
    resultField: 'course_name',
    where: {
        relation: '=',
        type: 'string',
        field: 'nome_curso',
        table: 'curso_ens_superior'
    }
})
.addValue({
    name: 'upper_education_mod',
    table: 'curso_ens_superior',
    tableField: 'cod_modalidade_ensino',
    resultField: 'upper_education_mod_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_modalidade_ensino',
        table: 'curso_ens_superior'
    }
})
.addValue({
    name: 'academic_organization',
    table: 'curso_ens_superior',
    tableField: 'cod_organizacao_academica',
    resultField: 'academic_organization_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_organizacao_academica',
        table: 'curso_ens_superior'
    }
})
.addValue({
    name: 'mesoregion',
    table: 'municipio',
    tableField: ['nome_mesorregiao', 'mesorregiao_id'],
    resultField: ['mesoregion_name', 'mesoregion_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'mesorregiao_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'cod_municipio_ies',
        foreignTable: 'ies_ens_superior'
    }
})
.addValue({
    name: 'microregion',
    table: 'municipio',
    tableField: ['nome_microrregiao', 'microrregiao_id'],
    resultField: ['microregion_name', 'microregion_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'microrregiao_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'cod_municipio_ies',
        foreignTable: 'ies_ens_superior'
    }
})
.addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['id', 'nome'],
    resultField: ['city_id', 'city_name'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'cod_municipio_ies',
        foreignTable: 'ies_ens_superior'
    }
})



courseStudentsApp.get('/', rqf.parse(), (req, res, next) => {
    req.sql.field("curso_ens_superior.ano_censo", "year")
    .field("SUM(curso_ens_superior.quantidade_inscritos_total)", "inscritos_total")
    .field("SUM(curso_ens_superior.quantidade_vagas_totais)", "vagas_totais")
    .field("SUM(curso_ens_superior.quantidade_ingresso_curso)", "ingresso_curso")
    .from("curso_ens_superior")
    .join("ies_ens_superior ON curso_ens_superior.ano_censo = ies_ens_superior.ano_censo AND curso_ens_superior.cod_ies = ies_ens_superior.cod_ies")
    .where("curso_ens_superior.cod_nivel_academico = 1")
    .where("curso_ens_superior.cod_grau_academico = 2 OR curso_ens_superior.cod_grau_academico = 4")
    .group("curso_ens_superior.ano_censo")
    .order("curso_ens_superior.ano_censo")
    next();

}, rqf.build(), query, (req, res, next) => {
    for (var res of req.result){
        res.inscritos_total = Number(res.inscritos_total);
        res.vagas_totais = Number(res.vagas_totais);
        res.ingresso_curso = Number(res.ingresso_curso);
        res.total = null;
    }

    next();
}, id2str.transform(), response('course_students'))

module.exports = courseStudentsApp;
