const express = require('express');

const educationYearsApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const response = require(`${libs}/middlewares/response`);

const config = require(`${libs}/config`);

const id2str = require(`${libs}/middlewares/id2str`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

educationYearsApp.use(cache('15 day'));

educationYearsApp.get('/', (req, res, next) => {
    req.result = [];
    for(let i = 1; i <= 7; ++i) {
        let edLvlShort = {
            id: i,
            name: id2str.educationLevelShort(i),
            schoolYears: []
        };

        for(let j = i*10; j <= (i*10 + 9); ++j) {

            let schoolYear = {
                id: j,
                name: id2str.schoolYear(j)
            };

            if(schoolYear.name !== id2str.schoolYear(99)) {
                edLvlShort.schoolYears.push(schoolYear);
            }
        }
        if(edLvlShort.name !== id2str.schoolYear(99)) {
            req.result.push(edLvlShort);
        }
    }
    next();
}, response('educationYears'));

module.exports = educationYearsApp;
