/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');
const { result } = require('lodash');

const federativeEntityApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const aggregateData = require(`${libs}/middlewares/aggregateData`);

const id2str = require(`${libs}/middlewares/id2str`);

const config = require(`${libs}/config`);

const addMissing = require(`${libs}/middlewares/addMissing`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

federativeEntityApp.use(cache('15 day'));

let rqf = new ReqQueryFields();

federativeEntityApp.get('/years', (req, res, next) => {
    req.sql.from('escola')
    .field('DISTINCT escola.ano_censo', 'year')
    .where('escola.ano_censo >= 2021')
    next();
}, query, response('years'));

federativeEntityApp.get('/adm_dependency', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 5; i++) {
        req.result.push({
            id: i, name: id2str.admDependency(i)
        });
    }
    next();
}, response('adm_dependency'));

federativeEntityApp.get('/education_degree_entity', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 4; i++) {
        req.result.push({
            id: i, name: id2str.educationDegreeEntity(i)
        });
    }
    next();
}, response('education_degree_entity'));

federativeEntityApp.get('/adm_dependency_detailed', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 9; i++) {
        req.result.push({
            id: i, name: id2str.admDependencyPriv(i)
        });
    }
    next();
}, response('adm_dependency_detailed'));

federativeEntityApp.get('/education_level_mod_agg', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 13; i++) {
        req.result.push({
            id: i, name: id2str.educationLevelMod(i)
        });
    }
    next();
}, response('education_level_mod_agg'));

federativeEntityApp.get('/integral_time_agg', (req, res, next) => {
    req.result = []

    for (let i = 0; i <= 3; i++) {
        req.result.push({
            id: i, name: id2str.integralTime(i)
        });
    }
    next();
}, response('integral_time_agg')); 

federativeEntityApp.get('/location', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 2; i++) {
        req.result.push({
            id: i, name: id2str.location(i)
        });
    }
    next();
}, response('location'));

federativeEntityApp.get('/diff_location', (req, res, next) => {
    req.result = []

    for (let i = 0; i <= 4; i++) {
        req.result.push({
            id: i, name: id2str.diffLocation(i)
        });
    }

    req.result.push({
        id: 8, name: 'Área onde se localizam povos e comunidades tradicionais'
    })

    next();
}, response('diff_location'));

federativeEntityApp.get('/modality_integral_time', (req, res, next) => {
    req.result = []

    for (let i = 0; i <= 7; i++) {
        req.result.push({
            id: i, name: id2str.educationLevelBasic(i)
        });
    }

    next();
}, response('modality_integral_time'));

federativeEntityApp.get('/gender', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 2; i++) {
        req.result.push({
            id: i, name: id2str.gender(i)
        });
    }

    next();
}, response('gender'));

federativeEntityApp.get('/age_range', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 7; i++) {
        req.result.push({
            id: i, name: id2str.ageRangeAggregate(i)
        });
    }

    next();
}, response('age_range'));

federativeEntityApp.get('/ethnic_group', (req, res, next) => {
    req.result = []

    for (let i = 0; i <= 6; i++) {
        req.result.push({
            id: i, name: id2str.ethnicGroup(i)
        });
    }

    next();
}, response('ethnic_group'));

federativeEntityApp.get('/period_agg', (req, res, next) => {
    req.result = []

    for (let i = 0; i <= 5; i++) {
        req.result.push({
            id: i, name: id2str.period(i)
        });
    }

    next();
}, response('period_agg'));

federativeEntityApp.get('/region', (req, res, next) => {
    req.result = []

    for (let i = 0; i <= 5; i++) {
        req.result.push({
            id: i, name: id2str.regionCode(i)
        });
    }

    next();
}, response('period_agg'));

federativeEntityApp.get('/state', (req, res, next) => {
    req.result = []
    for (let i = 11; i < 54; i++) {
        if (id2str.stateName(i) !== 'Não declarada') {
            req.result.push({
                id: i, name: id2str.stateName(i)
            });
        }
    }

    next();
}, response('state'));

federativeEntityApp.get('/special_education_entity', (req, res, next) => {
    req.result = []

    for (let i = 1; i <= 2; i++) {
        req.result.push({
            id: i, name: id2str.specialEducationEntity(i)
        });
    }

    next();
}, response('special_education_entity'));


rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'region',
    table: 'regiao',
    tableField: ['nome', 'id'],
    resultField: ['region_name', 'region_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'cod_reg',
        foreignTable: 'docentes_sinopse'
    }
}).addValue({
    name: 'mesoregion',
    table: 'municipio',
    tableField: ['nome_mesorregiao', 'mesorregiao_id'],
    resultField: ['mesoregion_name', 'mesoregion_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'mesorregiao_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'escola'
    }
}).addValue({
    name: 'microregion',
    table: 'municipio',
    tableField: ['nome_microrregiao', 'microrregiao_id'],
    resultField: ['microregion_name', 'microregion_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'microrregiao_id',
        table: 'municipio'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'escola'
    }
}).addValue({
    name: 'min_year',
    table: 'docentes_sinopse',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        field: 'ano_censo',
    },
}).addValue({
    name: 'max_year',
    table: 'docentes_sinopse',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        field: 'ano_censo',
    },
}).addValueToField({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'cod_uf',
        foreignTable: 'docentes_sinopse'
    }
}, 'dims').addValueToField({
    name: 'state',
    table: 'estado',
    tableField: 'nome',
    resultField: 'state_name',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'cod_uf',
        foreignTable: 'docentes_sinopse'
    }
}, 'filter').addValueToField({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'cod_mun',
        foreignTable: 'docentes_sinopse'
    }
}, 'dims').addValueToField({
    name: 'city',
    table: 'municipio',
    tableField: 'nome',
    resultField: 'city_name',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'cod_mun',
        foreignTable: 'docentes_sinopse'
    }
}, 'filter').addValueToField({
    name: 'school',
    table: 'docentes_sinopse',
    tableField: ['nome_escola', 'id'],
    resultField: ['school_name', 'school_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: ['id', 'ano_censo'],
        foreign: ['escola_id', 'ano_censo'],
        foreignTable: 'escola'
    }
}, 'dims').addValueToField({
    name: 'locale_id',
    table: 'docentes_sinopse',
    tableField: 'localizacao_id',
    resultField: 'locale_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'localizacao_id'
    }
}, 'dims').addValueToField({
    name: 'school_id',
    table: 'docentes_sinopse',
    tableField: 'id',
    resultField: 'school_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: ['id', 'ano_censo'],
        foreign: ['escola_id', 'ano_censo'],
        foreignTable: 'escola'
    }
}, 'dims').addValueToField({
    name: 'school',
    table: 'docentes_sinopse',
    tableField: 'nome_escola',
    resultField: 'school_name',
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: ['id', 'ano_censo'],
        foreign: ['escola_id', 'ano_censo'],
        foreignTable: 'escola'
    }
}, 'filter').addValue({
    name: 'location',
    table: 'docentes_sinopse',
    tableField: 'localizacao_id',
    resultField: 'location_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'localizacao_id'
    }
});

federativeEntityApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
    let whereRule = '';
    const filtersObject = {}

    req.query.filter.split(',').forEach((filter) => {
        let [key, value] = filter.split(':');
        filtersObject[key] = Number(JSON.parse(value));
    })

    if (req.query.filter && req.query.filter.includes('city')) {
        whereRule = 'docentes_sinopse.cod_mun = ' + filtersObject.city;
    }
    else if (req.query.filter && req.query.filter.includes('state')) {
        whereRule = 'docentes_sinopse.cod_uf = ' + filtersObject.state + 
            ((req.query.dims && req.query.dims.includes('city')) ? '' : ' AND docentes_sinopse.cod_mun = 0');
    }
    else if (req.query.filter && req.query.filter.includes('region')) {
        whereRule = 'docentes_sinopse.cod_reg = ' + filtersObject.region + 
            ((req.query.dims !== undefined && req.query.dims.includes('state')) 
                ? ' AND docentes_sinopse.cod_mun = 0'
                : (req.query.dims !== undefined && req.query.dims.includes('city')) 
                    ? '' 
                    : ' AND docentes_sinopse.cod_uf = 0');
                
    }
    else {
        whereRule = (req.query.dims && req.query.dims.includes('region')) 
            ? 'docentes_sinopse.cod_uf = 0'
            : (req.query.dims && req.query.dims.includes('state'))
                ? 'docentes_sinopse.cod_mun = 0' 
                : (req.query.dims && req.query.dims.includes('city'))
                    ? ''
                    : 'docentes_sinopse.cod_reg = 0'
                
    }

    console.log(whereRule);

    if (req.query.dims && req.query.dims.includes('education_level_mod_entity_seg'))
    {
        req.sql.from('docentes_sinopse')
        .field('SUM(docentes_sinopse.num_doc_ed_inf_total)', 'total_doc_ed_inf_total')
        .field('SUM(docentes_sinopse.num_doc_en_fund_total)', 'total_doc_en_fund_total')
        .field('SUM(docentes_sinopse.num_doc_en_medio_total)', 'total_doc_en_medio_total')
        .field('SUM(docentes_sinopse.num_doc_ed_prof_total)', 'total_doc_ed_prof_total')
        .field('SUM(docentes_sinopse.num_doc_ed_prof_tec_total)', 'total_doc_ed_prof_tec_total')
        .field('SUM(docentes_sinopse.num_doc_ed_prof_fic_total)', 'total_doc_ed_prof_fic_total')
        .field('SUM(docentes_sinopse.num_doc_eja_total)', 'total_doc_eja_total')
        .field('docentes_sinopse.ano_censo', 'year')
        .group('docentes_sinopse.ano_censo')
        .order('docentes_sinopse.ano_censo')
        .where(whereRule);
    }
    else if (req.query.dims && req.query.dims.includes('education_level_mod_entity_agg'))
    {
        req.sql.from('docentes_sinopse')
        .field('SUM(docentes_sinopse.num_doc_ed_inf_creche)', 'total_doc_ed_inf_creche')
        .field('SUM(docentes_sinopse.num_doc_ed_inf_pre_escola)', 'total_doc_ed_inf_pre_escola')
        .field('SUM(docentes_sinopse.num_doc_en_fund_anos_iniciais)', 'total_doc_en_fund_anos_iniciais')
        .field('SUM(docentes_sinopse.num_doc_en_fund_anos_finais)', 'total_doc_en_fund_anos_finais')
        .field('SUM(docentes_sinopse.num_doc_en_medio_propedeutico)', 'total_doc_en_medio_propedeutico')
        .field('SUM(docentes_sinopse.num_doc_en_medio_normal_magisterio)', 'total_doc_en_medio_normal_magisterio')
        .field('SUM(docentes_sinopse.num_doc_en_medio_integrado)', 'total_doc_en_medio_integrado')
        .field('SUM(docentes_sinopse.num_doc_ed_prof_en_medio)', 'total_doc_ed_prof_en_medio')
        .field('SUM(docentes_sinopse.num_doc_ed_prof_tec_concomitante)', 'total_doc_ed_prof_tec_concomitante')
        .field('SUM(docentes_sinopse.num_doc_ed_prof_tec_subsequente)', 'total_doc_ed_prof_tec_subsequente')
        .field('SUM(docentes_sinopse.num_doc_ed_prof_tec_misto)', 'total_doc_ed_prof_tec_misto')
        .field('SUM(docentes_sinopse.num_doc_ed_prof_fic_concomitante)', 'total_doc_ed_prof_fic_concomitante')
        .field('SUM(docentes_sinopse.num_doc_ed_prof_fic_integrado_eja)', 'total_doc_ed_prof_fic_integrado_eja')
        .field('SUM(docentes_sinopse.num_doc_eja_en_fund)', 'total_doc_eja_en_fund')
        .field('SUM(docentes_sinopse.num_doc_eja_en_medio)', 'total_doc_eja_en_medio')
        .field('docentes_sinopse.ano_censo', 'year')
        .group('docentes_sinopse.ano_censo')
        .order('docentes_sinopse.ano_censo')
        .where(whereRule);
    }
    else if (req.query.dims && req.query.dims.includes('special_education_entity'))
    {
        req.sql.from('docentes_sinopse')
        .field('SUM(docentes_sinopse.num_doc_ed_especial_classe_comum)', 'total_doc_ed_especial_classe_comum')
        .field('SUM(docentes_sinopse.num_doc_ed_especial_classe_exclusiva)', 'total_doc_ed_especial_classe_exclusiva')
        .field('docentes_sinopse.ano_censo', 'year')
        .group('docentes_sinopse.ano_censo')
        .order('docentes_sinopse.ano_censo')
        .where(whereRule);
    }
    else if (req.query.dims && req.query.dims.includes('adm_dependency_entity_agg'))
    {
        req.sql.from('docentes_sinopse')
        .field('SUM(docentes_sinopse.num_doc_dependencia_adm_pub)', 'total_doc_dependencia_adm_pub')
        .field('SUM(docentes_sinopse.num_doc_dependencia_adm_priv)', 'total_doc_dependencia_adm_priv')
        .field('docentes_sinopse.ano_censo', 'year')
        .group('docentes_sinopse.ano_censo')
        .order('docentes_sinopse.ano_censo')
        .where(whereRule);
    }
    else if (req.query.dims && req.query.dims.includes('adm_dependency_entity'))
    {
        req.sql.from('docentes_sinopse')
        .field('SUM(docentes_sinopse.num_doc_dependencia_adm_federal)', 'total_doc_dependencia_adm_federal')
        .field('SUM(docentes_sinopse.num_doc_dependencia_adm_estadual)', 'total_doc_dependencia_adm_estadual')
        .field('SUM(docentes_sinopse.num_doc_dependencia_adm_municipal)', 'total_doc_dependencia_adm_municipal')
        .field('SUM(docentes_sinopse.num_doc_dependencia_adm_priv)', 'total_doc_dependencia_adm_priv')
        .field('docentes_sinopse.ano_censo', 'year')
        .group('docentes_sinopse.ano_censo')
        .order('docentes_sinopse.ano_censo')
        .where(whereRule);
    }
    else if (req.query.dims && req.query.dims.includes('education_degree_entity'))
        {
            req.sql.from('docentes_sinopse')
            .field('SUM(docentes_sinopse.num_doc_esc_en_fund)', 'total_num_doc_esc_en_fund')
            .field('SUM(docentes_sinopse.num_doc_esc_en_medio)', 'total_num_doc_esc_en_medio')
            .field('SUM(docentes_sinopse.num_doc_esc_grad_com_licenciatura)', 'total_num_doc_esc_grad_com_licenciatura')
            .field('SUM(docentes_sinopse.num_doc_esc_grad_sem_licenciatura)', 'total_num_doc_esc_grad_sem_licenciatura')
            .field('docentes_sinopse.ano_censo', 'year')
            .group('docentes_sinopse.ano_censo')
            .order('docentes_sinopse.ano_censo')
            .where(whereRule);
        }
    else if (req.query.dims && req.query.dims.includes('location_entity'))
    {
        req.sql.from('docentes_sinopse')
        .field('SUM(docentes_sinopse.num_doc_loc_urbana_total)', 'total_doc_loc_urbana_total')
        .field('SUM(docentes_sinopse.num_doc_loc_rural_total)', 'total_doc_loc_rural_total')
        .field('docentes_sinopse.ano_censo', 'year')
        .group('docentes_sinopse.ano_censo')
        .order('docentes_sinopse.ano_censo')
        .where(whereRule);
    }
    else if (req.query.dims && req.query.dims.includes('gender_entity'))
    {
        req.sql.from('docentes_sinopse')
        .field('SUM(docentes_sinopse.num_doc_masc_total)', 'total_doc_masc_total')
        .field('SUM(docentes_sinopse.num_doc_fem_total)', 'total_doc_fem_total')
        .field('docentes_sinopse.ano_censo', 'year')
        .group('docentes_sinopse.ano_censo')
        .order('docentes_sinopse.ano_censo')
        .where(whereRule);
    }
    else if (req.query.dims && req.query.dims.includes('age_range_entity'))
    {
        req.sql.from('docentes_sinopse')
        .field('SUM(docentes_sinopse.num_doc_fem_24 + docentes_sinopse.num_doc_masc_24)', 'total_doc_24')
        .field('SUM(docentes_sinopse.num_doc_fem_25_29 + docentes_sinopse.num_doc_masc_25_29)', 'total_doc_25_29')
        .field('SUM(docentes_sinopse.num_doc_fem_30_39 + docentes_sinopse.num_doc_masc_30_39)', 'total_doc_30_39')
        .field('SUM(docentes_sinopse.num_doc_fem_40_49 + docentes_sinopse.num_doc_masc_40_49)', 'total_doc_40_49')
        .field('SUM(docentes_sinopse.num_doc_fem_50_54 + docentes_sinopse.num_doc_masc_50_54)', 'total_doc_50_54')
        .field('SUM(docentes_sinopse.num_doc_fem_55_59 + docentes_sinopse.num_doc_masc_55_59)', 'total_doc_55_59')
        .field('SUM(docentes_sinopse.num_doc_fem_60_mais + docentes_sinopse.num_doc_masc_60_mais)', 'total_doc_60_mais')
        .field('docentes_sinopse.ano_censo', 'year')
        .group('docentes_sinopse.ano_censo')
        .order('docentes_sinopse.ano_censo')
        .where(whereRule);
    }
    else if (req.query.dims && req.query.dims.includes('post_graduation_entity'))
    {
        req.sql.from('docentes_sinopse')
        .field('SUM(docentes_sinopse.num_doc_esc_pos_grad_especializacao)', 'total_doc_esc_pos_grad_especializacao')
        .field('SUM(docentes_sinopse.num_doc_esc_pos_grad_mestrado)', 'total_doc_esc_pos_grad_mestrado')
        .field('SUM(docentes_sinopse.num_doc_esc_pos_grad_doutorado)', 'total_doc_esc_pos_grad_doutorado')
        .field('docentes_sinopse.ano_censo', 'year')
        .group('docentes_sinopse.ano_censo')
        .order('docentes_sinopse.ano_censo')
        .where(whereRule);
    }
    else if (req.query.dims && req.query.dims.includes('contract_type_entity'))
    {
            req.sql.from('docentes_sinopse')
            .field('SUM(docentes_sinopse.num_doc_vinc_concursado_efetivo_estavel_total)', 'total_doc_vinc_concursado_efetivo_estavel_total')
            .field('SUM(docentes_sinopse.num_doc_vinc_contrato_temp_total)', 'total_doc_vinc_contrato_temp_total')
            .field('SUM(docentes_sinopse.num_doc_vinc_contrato_terceirizado_total)', 'total_doc_vinc_contrato_terceirizado_total')
            .field('SUM(docentes_sinopse.num_doc_vinc_contrato_clt_total)', 'total_doc_vinc_contrato_clt_total')
            .field('docentes_sinopse.ano_censo', 'year')
            .group('docentes_sinopse.ano_censo')
            .order('docentes_sinopse.ano_censo')
            .where(whereRule);
    }
    else if ((req.query.dims && req.query.dims.includes('state')) || (req.query.filter && req.query.filter.includes('state'))) {
        req.sql.from('docentes_sinopse')
        .field('SUM(docentes_sinopse.num_doc_ed_bas_total)', 'total')
        .field('docentes_sinopse.ano_censo', 'year')
        .group('docentes_sinopse.ano_censo')
        .order('docentes_sinopse.ano_censo')
        .where(whereRule);
    }
    else if ((req.query.dims && req.query.dims.includes('region')) || (req.query.filter && req.query.filter.includes('region'))) {
        req.sql.from('docentes_sinopse')
        .field('SUM(docentes_sinopse.num_doc_ed_bas_total)', 'total')
        .field('docentes_sinopse.ano_censo', 'year')
        .group('docentes_sinopse.ano_censo')
        .order('docentes_sinopse.ano_censo')
        .where(whereRule);
    }
    else {
        req.sql.from('docentes_sinopse')
        .field('SUM(docentes_sinopse.num_doc_ed_bas_total)', 'total')
        .field('docentes_sinopse.ano_censo', 'year')
        .group('docentes_sinopse.ano_censo')
        .order('docentes_sinopse.ano_censo')
        .where(whereRule);
    }
    next();
}, query, aggregateData, id2str.transform(false), response('federative_entity'));

module.exports = federativeEntityApp;
