/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const populationApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const id2str = require(`${libs}/middlewares/id2str`);

const addMissing = require(`${libs}/middlewares/addMissing`);

const config = require(`${libs}/config`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

populationApp.use(cache('15 day'));

populationApp.get('/year_range', (req, res, next) => {
    req.sql.from('ibge_pib')
    .field('MIN(ibge_pib.ano_censo)', 'start_year')
    .field('MAX(ibge_pib.ano_censo)', 'end_year');
    next();
}, query, response('range'));

populationApp.get('/years', (req, res, next) => {
    req.sql.from('ibge_pib').
    field('DISTINCT ibge_pib.ano_censo', 'year');
    next();
}, query, response('years'));

// populationApp.get('/city_size', (req, res, next) => {
//     req.result = [
//         {id: 1, name: "0 - 5000"},
//         {id: 2, name: "5001 - 10000"},
//         {id: 3, name: "10001 - 20000"},
//         {id: 4, name: "20001 - 50000"},
//         {id: 5, name: "50001 - 100000"},
//         {id: 6, name: "100001 - 500000"},
//         {id: 7, name: "mais que 500000"}
//     ];
//     next();
// }, response('city_size'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'municipio_id',
        table: 'ibge_pib'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'ibge_pib'
    }
}).addValue({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'estado_id',
        table: 'ibge_pib'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'ibge_pib'
    }
}).addValue({
    name: 'region',
    table: 'regiao',
    tableField: ['nome', 'id'],
    resultField: ['region_name', 'region_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'regiao_id',
        table: 'ibge_pib'
    },
    join: {
        primary: 'id',
        foreign: 'regiao_id',
        foreignTable: 'ibge_pib'
    }
}).addValue({
    name: 'min_year',
    table: 'ibge_pib',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: 'ibge_pib',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        field: 'ano_censo'
    }
});

populationApp.get('/', rqf.parse(), rqf.build(), (req, res, next) => {
  req.sql.from('ibge_pib')
    .field('SUM(ibge_pib.populacao)', 'total')
    .field('ibge_pib.ano_censo', 'year')
    .group('ibge_pib.ano_censo')
    .order('ibge_pib.ano_censo')

   next();
}, query, addMissing(rqf), id2str.transform(false), response('population'));

module.exports = populationApp;
