/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const siopeApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const multiQuery = require(`${libs}/middlewares/multiQuery`);

const response = require(`${libs}/middlewares/response`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const id2str = require(`${libs}/middlewares/id2str`);

const config = require(`${libs}/config`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();

siopeApp.use(cache('15 day'));

siopeApp.get('/years', (req, res, next) => {
    req.sql.from('siope_mun')
    .field('DISTINCT siope_mun.ano_censo', 'year');
    next();
}, query, (req, res, next) => {
    req.oldResult = req.result;

    req.sql = squel.select();

    req.sql.from('siope_uf')
    .field('DISTINCT siope_uf.ano_censo', 'year');
    next();
}, query, (req, res, next) => {
    let result = Object.assign(req.oldResult, req.result);
    req.result = result;
    next();
}, response('years'));

rqf.addField({
    name: 'filter',
    field: true,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'municipio_id',
        table: 'siope_mun'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'siope_mun'
    }
}).addValue({
    name: 'state',
    table: 'estado',
    tableField: ['id','nome','sigla'],
    resultField: ['state_id','state_name','state_abbreviation'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'estado_id',
        table: '@'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: '@'
    }
}).addValue({
    name: 'min_year',
    table: '@',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        table: '@',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: '@',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        table: '@',
        field: 'ano_censo'
    }
});



siopeApp.get('/', rqf.parse(), (req, res, next) => {
    req.querySet = [];
    req.queryIndex = {};

    let siopeUf = req.sql.clone();
    siopeUf.from('siope_uf')
    .field('siope_uf.ano_censo', 'year')
    .field('siope_uf.estado_id', 'state_id')
    .field('siope_uf.fundeb', 'fundeb')
    .field('siope_uf.total_impostos', 'impostos')
    .field('siope_uf.total_mde', 'MDE')
    .group('siope_uf.ano_censo')
    .group('siope_uf.estado_id')
    .group('siope_uf.fundeb')
    .group('siope_uf.total_impostos')
    .group('siope_uf.total_mde')
    .order('siope_uf.ano_censo');
    req.queryIndex.siopeUf = req.querySet.push(siopeUf) - 1;

    let siopeMun = req.sql.clone();
    siopeMun.from('siope_mun')
    .field('siope_mun.ano_censo', 'year')
    .field('siope_mun.estado_id', 'state_id')
    .field('siope_mun.municipio_id', 'city_id')
    .field('siope_mun.fundeb', 'fundeb')
    .field('siope_mun.total_impostos', 'impostos')
    .field('siope_mun.total_mde', 'MDE')
    .group('siope_mun.ano_censo')
    .group('siope_mun.estado_id')
    .group('siope_mun.municipio_id')
    .group('siope_mun.fundeb')
    .group('siope_mun.total_impostos')
    .group('siope_mun.total_mde')
    .order('siope_mun.ano_censo');
    req.queryIndex.siopeMun = req.querySet.push(siopeMun) - 1;

    next();
}, rqf.multibuild(), multiQuery, (req, res, next) => {

    let result = []

    req.result[req.queryIndex.siopeUf].forEach((item) => {
        result.push(item)
    });
    req.result[req.queryIndex.siopeMun].forEach((item) => {
        result.push(item)
    });

    req.result = result;
    next();

}, response('siope'));

module.exports = siopeApp;
