const express = require('express');

const studentsAeeApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const id2str = require(`${libs}/middlewares/id2str`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const request = require(`request`);

const config = require(`${libs}/config`);

const passport = require('passport');

const download = require(`${libs}/middlewares/downloadDatabase`);

const addMissing = require(`${libs}/middlewares/addMissing`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

let rqf = new ReqQueryFields();
let rqfCount = new ReqQueryFields();

// cubApp.get('/year_range', (req, res, next) => {

//     req.sql.from('cub')
//     .field('MIN(cub.ano_censo)', 'start_year')
//     .field('MAX(cub.ano_censo)', 'end_year');
//     next();
// }, query, response('range'));

// cubApp.get('/years', (req, res, next) => {
//     req.sql.from('cub')
//     .field('DISTINCT cub.ano_censo', 'year');
//     next();
// }, query, response('years'));

// cubApp.get('/months', (req, res, next) => {
//     req.sql.from('cub')
//     .field('DISTINCT cub.mes_censo', 'month');
//     next();
// }, query, response('months'));

// cubApp.get('/years_months', (req, res, next) => {
//     req.sql.from('cub')
//     .field('DISTINCT cub.ano_censo AS "year", cub.mes_censo AS "month"');
//     next();
// }, query, response('years_months'));

// cubApp.get('/price_type', (req, res, next) => {
//     req.sql.from('cub')
//     .field('DISTINCT cub.tipo_preco', 'price_type');
//     next();
// }, query, response('price_type'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValueToField({ 
    name: 'state', // working
    table: 'estado',
    tableField: ['sigla', 'id'],
    resultField: ['sigla_uf', 'cod_uf'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'estado_id',
        table: 'numero_estudantes_aee'
    },
    join: {
        primary: 'id',
        foreign: 'estado_id',
        foreignTable: 'numero_estudantes_aee'
    }
}, 'filter').addValueToField({
    name: 'city', // working
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'municipio_id',
        foreignTable: 'numero_estudantes_aee'
    }
}, 'filter').addValue({
    name: 'region', // working
    table: 'regiao',
    tableField: ['nome', 'id'],
    resultField: ['region_name', 'region_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: 'id',
        foreign: 'regiao_id',
        foreignTable: 'numero_estudantes_aee'
    }
}).addValueToField({
    name: 'school', // working
    table: 'escola',
    tableField: ['nome_escola', 'id'],
    resultField: ['school_name', 'school_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'id'
    },
    join: {
        primary: ['id', 'ano_censo'],
        foreign: ['escola_id', 'ano_censo'],
        foreignTable: 'numero_estudantes_aee'
    }
}, 'filter').addValueToField({
    name: 'locale_id', // working
    table: 'numero_estudantes_aee',
    tableField: 'localidade_area_rural',
    resultField: 'locale_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'localidade_area_rural'
    }
}, 'filter').addValue({
    name: 'ethnic_group', // working
    table: 'numero_estudantes_aee',
    tableField: 'cor_raca_id',
    resultField: 'ethnic_group_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cor_raca_id'
    }
}).addValue({
    name: 'adm_dependency', // working
    table: 'numero_estudantes_aee',
    tableField: 'dependencia_adm_priv',
    resultField: 'adm_dependency_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'dependencia_adm_priv'
    }
}).addValue({
    name:'age_range_all', // working
    table: 'numero_estudantes_aee',
    tableField: 'faixa_etaria_31_03',
    resultField: 'age_range_all_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'faixa_etaria_31_03'
    }
  }).addValue({
    name: 'gender', // working
    table: 'numero_estudantes_aee',
    tableField: 'sexo',
    resultField: 'gender_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'sexo'
    }
}).addValue({
    name: 'activity_days', // working
    table: 'numero_estudantes_aee',
    tableField: 'dias_atividade',
    resultField: 'activity_days_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'dias_atividade'
    }
}).addField({
    name: 'special_service', // working
    table: 'numero_estudantes_aee',
    tableField: 'disc_atendimento_especiais',
    resultField: 'special_service_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'disc_atendimento_especiais'
    }
});

studentsAeeApp.get('/', rqf.parse(), (req, res, next) => {
    req.sql.from('numero_estudantes_aee')
    .field('numero_estudantes_aee.ano_censo')
    .field('COUNT(distinct numero_estudantes_aee.id_aluno)', 'total')
    .group('numero_estudantes_aee.ano_censo')
    .order('numero_estudantes_aee.ano_censo')
    next();
}, rqf.build(), (req, res, next) => {
    console.log(req.sql.toString());
    next();
}, query, id2str.transform(), response('studentsAee'));

module.exports = studentsAeeApp;
