''/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of simcaq-node.

simcaq-node is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

simcaq-node is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with simcaq-node.  If not, see <https://www.gnu.org/licenses/>.
*/

const express = require('express');

const universityLocalOfferApp = express.Router();

const libs = `${process.cwd()}/libs`;

const log = require(`${libs}/log`)(module);

const squel = require('squel');

const query = require(`${libs}/middlewares/query`).query;

const response = require(`${libs}/middlewares/response`);

const id2str = require(`${libs}/middlewares/id2str`);

const ReqQueryFields = require(`${libs}/middlewares/reqQueryFields`);

const request = require(`request`);

const config = require(`${libs}/config`);

const cache = require('apicache').options({ debug: config.debug, statusCodes: {include: [200]} }).middleware;

const addMissing = require(`${libs}/middlewares/addMissing`);

let rqf = new ReqQueryFields();

universityLocalOfferApp.use(cache('15 day'));

rqf.addField({
    name: 'filter',
    field: false,
    where: true
}).addField({
    name: 'dims',
    field: true,
    where: false
}).addValue({
    name: 'city',
    table: 'municipio',
    tableField: ['nome', 'id'],
    resultField: ['city_name', 'city_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_municipio',
        table: 'localoferta_ens_superior'
    },
    join: {
        primary: 'id',
        foreign: 'cod_municipio',
        foreignTable: 'localoferta_ens_superior'
    }
}).addValue({
    name: 'region',
    table: 'regiao',
    tableField: ['nome', 'id'],
    resultField: ['region_name', 'region_id'],
    where: {
        relation: 'LIKE',
        type: 'string',
        field: 'id'
    },
    join: {
        primary: 'nome',
        foreign: 'nome_regiao',
        foreignTable: 'localoferta_ens_superior'
    }

}).addValue({
    name: 'min_year',
    table: 'localoferta_ens_superior',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '>=',
        type: 'integer',
        table: 'localoferta_ens_superior',
        field: 'ano_censo'
    }
}).addValue({
    name: 'max_year',
    table: 'localoferta_ens_superior',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '<=',
        type: 'integer',
        table: 'localoferta_ens_superior',
        field: 'ano_censo'
    }
}).addValue({
    name: 'state',
    table: 'estado',
    tableField: ['nome', 'id'],
    resultField: ['state_name', 'state_id'],
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_uf',
        table: 'localoferta_ens_superior'
    },
    join: {
        primary: 'id',
        foreign: 'cod_uf',
        foreignTable: 'localoferta_ens_superior'
    }
}).addValueToField({
    name: 'university',
    table: 'localoferta_ens_superior',
    tableField: 'cod_ies',
    resultField: 'university_id',
    where: {
        relation: '=',
        type: 'integer',
        field: 'cod_ies',
        table: 'localoferta_ens_superior'
    }
}, 'filter').addValue({
    name: 'year',
    table: 'localoferta_ens_superior',
    tableField: 'ano_censo',
    resultField: 'year',
    where: {
        relation: '=',
        type: 'integer',
        table: 'localoferta_ens_superior',
        field: 'ano_censo'
    }
});


universityLocalOfferApp.get('/', rqf.parse(),  rqf.build(), (req, res, next) => {
    req.sql.from('localoferta_ens_superior')
        .field('distinct localoferta_ens_superior.cod_ies', 'id')
        .field('localoferta_ens_superior.cod_local_oferta', 'localoffer_id')
        .field('localoferta_ens_superior.ano_censo', 'year')
        .field('ies_ens_superior.nome_ies', 'name')
        .field('localoferta_ens_superior.nome', 'localoffer_name')
        .field('localoferta_ens_superior.cod_uf', 'state_id')
        .field('localoferta_ens_superior.cod_municipio', 'city_id')
        .field('localoferta_ens_superior.cod_regiao', 'region_id')
        .join('ies_ens_superior', null, 'localoferta_ens_superior.cod_ies=ies_ens_superior.cod_ies AND localoferta_ens_superior.ano_censo=ies_ens_superior.ano_censo')
        .where('localoferta_ens_superior.nome IS NOT NULL AND ies_ens_superior.nome_ies IS NOT NULL');
    next();

}, query, response('universityLocalOfferApp'));

module.exports = universityLocalOfferApp;
