const express = require('express');

const userApp = express();

const libs = `${process.cwd()}/libs`;

const config = require(`${libs}/config`);

const log = require(`${libs}/log`)(module);

const User = require(`${libs}/models/user`);

const VerificationToken = require(`${libs}/models/verificationToken`);

const ResetToken = require(`${libs}/models/resetToken`);

const response = require(`${libs}/middlewares/response`);

const email = require(`${libs}/middlewares/email`);

const passport = require('passport');

const uuid = require('node-uuid');

function emailSyntax(email) {
  const regex = /^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()[\]\.,;:\s@\"]+\.)+[^<>()[\]\.,;:\s@\"]{2,})$/i;
  return regex.test(email);
}

userApp.get('/schooling', (req, res, next) => {
  req.result = [
    'Não estudou',
    'Ensino Fundamental Incompleto',
    'Ensino Fundamental Completo',
    'Ensino Médio',
    'Graduação',
    'Mestrado',
    'Doutorado'
  ];
  next();
}, response('schooling'));

userApp.get('/segment', (req, res, next) => {
  req.result = [
    'Gestores e equipe gestora das secretarias e ministério da Educação',
    'Gestores dos órgãos de planejamento e finanças (das três esferas de governo)',
    'Agentes do poder legislativo',
    'Agentes dos conselhos de educação',
    'Profissionais da educação',
    'Sindicato',
    'Sociedade civil interessada no financiamento da Educação Básica de qualidade',
    'Comunidade acadêmica',
    'Imprensa',
    'Outro [citar segmento]'
  ];
  next();
}, response('segment'));

userApp.get('/role', (req, res, next) => {
  req.result = [
    { "Gestores e equipe gestora das secretarias e ministério da Educação": ["Dirigente municipal, estadual e federal", "Secretário do MEC", "Servidor da área de planejamento educacional", "Membro de associação de gestores (Ex. Undime, Consed, etc)", "Outro [citar função]"] },
    { "Gestores dos órgãos de planejamento e finanças (das três esferas de governo)": ["Equipe gestora dos órgãos de planejamento", "Equipe gestora dos órgãos de finanças", "Outro [citar função]"] },
    { "Agentes do poder legislativo": ["Parlamentar", "Assessor/a parlamentar", "Auditor/a dos tribunais de conta", "Conselheiro/a de tribunais de conta.", "Outro [citar função]"] },
    { "Agentes dos conselhos de educação": ["Conselheiro/a municipais, estaduais e federais", "Conselheiro/a do Fundeb", "Outro [citar função]"] },
    { "Profissionais da educação": ["Professor/a da Educação Básica", "Profissional da educação não-docente", "Outro [citar função]"] },
    { "Sindicato": ["Agente de sindicatos"] },
    { "Sociedade civil interessada no financiamento da Educação Básica de qualidade": ["Membro de fóruns educacionais", "Membro de ONGs e demais entidades sem fins lucrativos", "Estudante da educação básica e membro de entidades estudantis", "Pais e membros de entidades de pais", "Outro [citar função]"] },
    { "Comunidade acadêmica": ["Pesquisador/a", "Estudantes de graduação e pós-graduação", "Representantes de entidades de pesquisa (Ex.: ANPED, ANPAE e FINEDUCA)", "Outro [citar função]"] },
    { "Imprensa": ["Jornalista", "Outro [citar função]"] },
    { "Outro [citar segmento]": [] }
  ]
  next();
}, response('role'));

/*
userApp.get('/', passport.authenticate('bearer', {session: false}), (req, res, next) => {
  User.find((err, users) => {
    if(err) {
      log.error(err);
      return next(err);
    }

    let result = [];
    users.forEach((user) => {
      let u = user.toObject();
      delete u.hashedPassword;
      delete u.salt;
      result.push(u);
    });
    req.result = result;
    next();
  });
}, response('users'));
*/

userApp.get('/me', passport.authenticate('bearer', { session: false }), (req, res, next) => {
  let u = req.user.toJSON();
  u._id = u.id;
  u.institutionName = u.institution_name;
  u.receiveEmails = u.receive_email;
  u.receive_emails = u.receive_email;
  delete u.id;
  delete u.institution_name;
  delete u.receive_email;
  delete u.hashed_password;
  delete u.salt;

  req.result = u;
  next();
}, response('user'));

function isEmpty(str) {
  return (!str || str.length === 0 );
}

userApp.get('/:id', (req, res, next) => {
  User.findByPk(req.params.id).then((user) => {
    if (!user) {
      res.statusCode = 404;
      res.json({ msg: "O usuário não está cadastrado" });
    } else {
      let u = user.toJSON();
      u._id = u.id;
      u.institutionName = u.institution_name;
      u.receiveEmails = u.receive_email;
      u.receive_emails = u.receive_email;
      delete u.id;
      delete u.institution_name;
      delete u.receive_email;
      delete u.hashed_password;
      delete u.salt;
      req.result = u;
      next();
    }
  }).catch(function (err) {
    log.error(err);
    return next(err);
  });
}, response('user'));

userApp.post('/', async (req, res, next) => {
  if (typeof req.body.password === 'undefined' || !req.body.password) {
    res.statusCode = 400;
    return res.json({ errors: ["O campo senha é obrigatório"] });
  } 
  else {
    let user = await User.create({
      id: 0,
      email: req.body.email,
      password: req.body.password,
      hashed_password: 0,
      salt: 0,
      name: req.body.name,
      nickname: req.body.nickname,
      cpf: req.body.cpf,
      cep: req.body.cep,
      complement: req.body.complement,
      address: req.body.address,
      phone: req.body.phone,
      schooling: req.body.schooling,
      course: req.body.course,
      segment: req.body.segment,
      role: req.body.role,
      institution_name: req.body.institutionName,
      state: req.body.state,
      city: req.body.city,
      receive_email: false || req.body.receiveEmails || req.body.receive_emails,
      origin: req.body.origin,
      citesegment: req.body.citesegment,
      citerole: req.body.citerole,
      admin: false,
      role_id: 0
    }).catch(function (err) {
      log.error(err);
      let errors = [];
      for (let errName in err.errors) {
        errors.push(err.errors[errName].message);
      }
      log.error(errors);
      res.statusCode = 400;
      return res.json({ err, errors });
      // handle error;
    });
    let tokenValue = uuid.v4();
    const verificationToken = VerificationToken.create({
      user_id: user.id,
      token: tokenValue,
      verified: false
    });
    if (!verificationToken) {
      res.statusCode = 404;
      return res.json({ msg: "Couldn't create Verification Token" });
    }
    let url = config.default.lde.url + '/verify';
    let text = `Olá, ${user.name}, seja bem vindo/a ao Laboratório de Dados Educacionais.\n\nClique neste link para confirmar sua conta: ${url}/${tokenValue}`;
    // Send confirmation email
    let mailOptions = {
      to: `"${user.name} <${user.email}>"`,
      subject: "Confirme seu cadastro - Laboratório de Dados Educacionais",
      text
    }
    email(mailOptions, (err, info) => {
      if (err) {
        log.error(err);
        res.json({ msg: 'Message not delivered, user created but not confirmed' });
      }
      if (info) {
        log.info(`Message ${info.messageId} sent: ${info.response}`);
        log.info(`Usuário ${user.email} foi criado`);
      }
      res.json({ msg: 'User created' });
    });
  }
});

userApp.put('/:id', passport.authenticate('bearer', { session: false }), async (req, res, next) => {
  let user = await User.findByPk(req.params.id).catch(function (err) {
    if (err) {
      log.error(err);
      return next({ err });
    }
  })
  if (!user) {
    res.statusCode = 404;
    return next({
      err: {
        message: 'Usuário não encontrado'
      }
    });
  }

  user.email = req.body.email || user.email;
  user.name = req.body.name || user.name;
  user.nickname = req.body.nickname || user.nickname || user.name;
  user.cep = req.body.cep || user.cep;
  user.complement = req.body.complement || user.complement;
  user.address = req.body.address || user.address;
  user.phone = req.body.phone || user.phone;
  user.schooling = req.body.schooling || user.schooling;
  user.course = req.body.course || user.course;
  user.segment = req.body.segment || user.segment;
  user.role = req.body.role || user.role;
  user.institutionName = req.body.institutionName || user.institutionName;
  user.state = req.body.state || user.state;
  user.city = req.body.city || user.city;
  user.receive_email = req.body.receiveEmails || req.body.receive_emails || user.receive_email;
  user.citesegment = req.body.citesegment || user.citesegment;
  user.citerole = req.body.citerole || user.citerole;

  if((!isEmpty(req.body.password)) && (!isEmpty(req.body.newpassword))){
    if (req.body.password != req.body.newpassword) {
      if (user.checkPassword(user, req.body.password)) {
          await user.update({password:req.body.newpassword});
        } 
      else {
        res.statusCode = 500;
        return res.json({
          error: {
            message: 'A senha atual está incorreta'
          }
        });
      }
    } else {
      res.statusCode = 500;
      return res.json({
        error: {
          message: 'A nova senha é a mesma da senha atual'
        }
      });
    }
  }

  user.save().catch(err => {
    if (err) {
      log.error(err);
      return next({ message: 'Erro ao atualizar usuário' });
    }})
  let u = user.toJSON();
  u._id = u.id;
  u.institutionName = u.institution_name;
  u.receiveEmails = u.receive_email;
  u.receive_emails = u.receive_email;
  delete u.id;
  delete u.institution_name;
  delete u.receive_email;
  delete u.hashed_password;
  delete u.salt;
  delete u.password;
  res.json({ user: u });

});


userApp.get('/reset/password', async (req, res, next) => {
  let emailAddress = req.query.email;
  let user = await User.findOne({ where: { email: emailAddress } }).catch(function (err) {
    log.error(err);
    let errors = [];
    for (let errName in err.errors) {
      errors.push(err.errors[errName].message);
    }
    log.error(errors);
    res.statusCode = 400;
    return res.json({ err, errors });
    // handle error;
  });
  console.log(user);
  if (!user) {
    res.statusCode = 404;
    res.json({ msg: "O usuário não está cadastrado" });
  }
  else {
    let tokenValue = uuid.v4();
    const rt = await ResetToken.create({
      user_id: user.id,
      token: tokenValue,
      reset: false
    });
    if (!rt) {
      res.statusCode = 404;
      return res.json({ msg: "Couldn't create Reset Password Token" });
    }
    let url = config.default.lde.url + '/reset-password';
    let text = `Olá, ${user.name}.\n\nRecebemos uma solicitação para redefinir sua senha do Laboratório de Dados Educacionais. Clique neste link para redefinir a sua senha: ${url}/${tokenValue}`;
    let mailOptions = {
      to: `"${user.name} <${user.email}>"`,
      subject: "Redefinição de Senha - Laboratório de Dados Educacionais",
      text
    }
    console.log(mailOptions);
    email(mailOptions, (err, info) => {
      if (err) {
        log.error(err);
        res.json({ msg: 'Undelivered Reset Password Mail' });
      }
      res.json({ msg: 'Reset Password Mail Successfully Delivered' });
    });
  }
});

module.exports = userApp;
