import React from "react";
import { makeStyles } from "@material-ui/core/styles";
import Grid from "@material-ui/core/Grid";
import Paper from "@material-ui/core/Paper";
import TextField from "@material-ui/core/TextField";
import DeleteOutlinedIcon from "@material-ui/icons/DeleteOutlined";
import IconButton from "@material-ui/core/IconButton";
import Select from "@material-ui/core/Select";
import MenuItem from "@material-ui/core/MenuItem";
import AddCircleIcon from "@material-ui/icons/AddCircle";
import CloseIcon from "@material-ui/icons/Close";
import Switch from "@material-ui/core/Switch";
import FormControlLabel from "@material-ui/core/FormControlLabel";
import Typography from "@material-ui/core/Typography";
import Radio from "@material-ui/core/Radio";
import RadioGroup from "@material-ui/core/RadioGroup";

import FieldFooterOptions from "./FieldFooterOptions";

const useStyles = makeStyles(theme => ({
  paper: {
    padding: theme.spacing(3),
    width: theme.spacing(100),
    minheight: theme.spacing(16),
    margin: theme.spacing(2)
  },
  questionsGrid: {
    marginBottom: "20px"
  }
}));

function FormFieldRadio(props) {
  const classes = useStyles();

  const [selectedValue, setSelectedValue] = React.useState();

  const handleChange = event => {
    setSelectedValue(event.target.value);
  };

  const options = props.options.map(function(x) {
    return (
      <span>
        {x.value}
        <Radio
          checked={selectedValue === x.value}
          onChange={handleChange}
          value={x.value}
        />
      </span>
    );
  });

  return (
    <Paper className={classes.paper}>
      <Grid container>
        <Grid item xs={12} className={classes.questionsGrid}>
          <Typography variant="h6" gutterBottom>
            {props.question}
          </Typography>
        </Grid>
        <Grid
          item
          container
          direction="column"
          justify="flex-start"
          alignItems="flex-start"
          xs={5}
          className={classes.questionsGrid}
        >
          <RadioGroup>{options}</RadioGroup>
        </Grid>
      </Grid>
    </Paper>
  );
}

export default FormFieldRadio;
