import React from 'react';
import { makeStyles } from '@material-ui/core/styles';
import Grid from '@material-ui/core/Grid';
import Paper from '@material-ui/core/Paper';
import TextField from '@material-ui/core/TextField';
import DeleteOutlinedIcon from '@material-ui/icons/DeleteOutlined';
import IconButton from '@material-ui/core/IconButton';
import Select from '@material-ui/core/Select';
import MenuItem from '@material-ui/core/MenuItem';
import AddCircleIcon from '@material-ui/icons/AddCircle';
import CloseIcon from '@material-ui/icons/Close';
import Switch from '@material-ui/core/Switch';
import FormControlLabel from '@material-ui/core/FormControlLabel';

function FieldFooterOptions(props) {

	return (
			<>
			<FormControlLabel
				control={
				<Switch
					onChange={e => props.setRequiredField(props.idq) }
					value="required"
					color="primary"
					checked={props.required}
				/>
				}
				label="Obrigatória"
			/>
			<IconButton aria-label="delete" onClick={() => { props.deleteFromForm(props.idq) } }>
				<DeleteOutlinedIcon />
			</IconButton>
			</>
	);


}


export default FieldFooterOptions;