import React from 'react';
import { makeStyles } from '@material-ui/core/styles';
import Grid from '@material-ui/core/Grid';
import Paper from '@material-ui/core/Paper';
import TextField from '@material-ui/core/TextField';
import DeleteOutlinedIcon from '@material-ui/icons/DeleteOutlined';
import IconButton from '@material-ui/core/IconButton';
import Select from '@material-ui/core/Select';
import MenuItem from '@material-ui/core/MenuItem';
import AddCircleIcon from '@material-ui/icons/AddCircle';
import CloseIcon from '@material-ui/icons/Close';
import Switch from '@material-ui/core/Switch';
import FormControlLabel from '@material-ui/core/FormControlLabel';

import FieldFooterOptions from './FieldFooterOptions';


const useStyles = makeStyles(theme => ({
  paper: {
    padding: theme.spacing(3),
    width: theme.spacing(100),
    minheight: theme.spacing(16),
    margin: theme.spacing(2)
  },
  questionsGrid: {
    marginBottom: '20px'
  },
}));



function FormFieldSelect(props) {
  const classes = useStyles();

  return (
    <Paper className={classes.paper}>
      <Grid container>
        <Grid item xs={12} className={classes.questionsGrid}>
          <TextField value={props.question} label="sua pergunta" 
                      onChange={e => props.setQuestionField(e.target.value, props.idq)}/>
        </Grid>
        <Grid item container
          direction="column"
          justify="flex-start"
          alignItems="flex-start" xs={5} className={classes.questionsGrid}
        >
          {
          props.options.map((x, index) => {
            return  <Grid container>
                      <Grid item xs={11}>
                        <TextField label={"opção "+index} value={x} fullWidth
                                  onChange={e => props.setSelectOption(e.target.value, props.idq, index)} />
                      </Grid>
                      <Grid item xs={1}>
                        <IconButton aria-label="remove option"
                                    onClick={() => { props.removeSelectOption(props.idq, index) } }>
                          <CloseIcon />
                        </IconButton>
                      </Grid>
                    </Grid>
          })
          }
        </Grid>
        <Grid item container 
          direction="column"
          justify="flex-start"
          alignItems="flex-start"
          xs={4}
        >
          <IconButton aria-label="add option" onClick={() => { props.addSelectOption(props.idq) } }>
            <AddCircleIcon />
          </IconButton>
        </Grid>
        <Grid item container
          direction="row"
          justify="flex-end"
          alignItems="flex-end"
          xs={3}
        >
          <FieldFooterOptions deleteFromForm={props.deleteFromForm} idq={props.idq}
                              setRequiredField={props.setRequiredField} required={props.required} />
        </Grid>
      </Grid>
    </Paper>
  );

}

export default FormFieldSelect;