import React from 'react';
import { makeStyles } from '@material-ui/core/styles';
import Grid from '@material-ui/core/Grid';
import Paper from '@material-ui/core/Paper';
import TextField from '@material-ui/core/TextField';
import DeleteOutlinedIcon from '@material-ui/icons/DeleteOutlined';
import IconButton from '@material-ui/core/IconButton';

import FieldFooterOptions from './FieldFooterOptions';

const useStyles = makeStyles(theme => ({
  paper: {
    padding: theme.spacing(3),
    width: theme.spacing(100),
    height: theme.spacing(16),
    margin: theme.spacing(2)
  },
  questionsGrid: {
    marginBottom: '20px'
  },
}));

function FormFieldText(props) {
  const classes = useStyles();

  return (
    <Paper className={classes.paper}>
      <Grid container>
        <Grid item xs={12} className={classes.questionsGrid}>
          <TextField value={props.question} label="sua pergunta"
                      onChange={e => props.setQuestionField(e.target.value, props.idq)}/>
        </Grid>
        <Grid item xs={9} className={classes.questionsGrid}>
          <TextField
            disabled
            id="outlined-disabled"
            label=""
            defaultValue="Resposta curta"
          />
        </Grid>
        <Grid item container
          direction="row"
          justify="flex-end"
          alignItems="flex-end"
          xs={3}
        >
          <FieldFooterOptions deleteFromForm={props.deleteFromForm} idq={props.idq}
                              setRequiredField={props.setRequiredField} required={props.required} />
        </Grid>
      </Grid>
    </Paper>
  );

}

export default FormFieldText;