import React from "react";
import Grid from "@material-ui/core/Grid";
import logo from "./header_imgs/imgsimmc-01.png";
import { makeStyles } from "@material-ui/core";
import MenuListComposition from "./header_components/MenuList";

const useStyles = makeStyles(theme => ({
  header: {
    background: "#05a5dd",
    width: "auto",
    display: "flex",
    flexDirection: "column",
    justifyContent: "center",
    height: "13%"
  },
  simmc: {
    marginTop: "5%",
    fontSize: "15px",
    color: "#ffffff",
    marginLeft: "2%",
    ["@media (max-width:1040px)"]: {
      display: "none"
    },
    ["@media (max-height:681px)"]: {
      display: "none"
    }
  },
  form_creator: {
    color: "#ffffff",
    marginTop: "10%",
    ["@media (max-width:599px)"]: {
      fontSize: "21px",
      ["@media (max-width:525px)"]: {
        marginTop: "5%",
        marginLeft: "10%"
      },
      ["@media (max-width:337px)"]: {
        fontSize: "19px"
      }
    },
    ["@media (max-height:681px)"]: {
      marginTop: "5%"
    }
  },
  link: {
    textDecoration: "none"
  },
  logo: {
    marginLeft: "2.5%",
    marginTop: "4%",
    width: "85px",
    ["@media (max-width:525px)"]: {
      width: "65px",
      ["@media (max-width:338px)"]: {
        marginTop: "3%"
      }
    },
    ["@media (max-height:681px)"]: {
      width: "65px"
    }
  },
  userImgContainer: {
    display: "flex",
    flexDirection: "column"
  }
}));

export default function Header() {
  const classes = useStyles();

  return (
    <Grid>
      <header className={classes.header} alignItems="center ">
        <Grid container item>
          <Grid container item xs={3} sm={3} md={4}>
            <a
              href="https://simmc.c3sl.ufpr.br/"
              title="Ir para a página inicial do SIMMC"
            >
              <img
                src={logo}
                alt="logo"
                href="localhost3000/#/signup"
                className={classes.logo}
                maxWidth="100px"
              />
            </a>
            <Grid
              container
              item
              xs={5}
              sm={6}
              md={7}
              alignContent="flexstart"
              alignItems="start"
            >
              <a
                href="https://simmc.c3sl.ufpr.br/"
                title="Ir para a página inicial do SIMMC"
                className={classes.link}
              >
                <h2 className={classes.simmc}>
                  Sistema Integrado de Monitoramento do Ministério da Ciência,
                  Tecnologia, Inovações e Comunicações
                </h2>
              </a>
            </Grid>
          </Grid>
          <Grid container item xs={6} sm={6} md={4} justify="center">
            <a
              href="https://google.com.br" // mudar para a main page quando estiver feita
              title="Ir para a página inicial do Gerenciador de Formulários"
              className={classes.link}
            >
              <h2 className={classes.form_creator}>
                Gerenciador de Formulários
              </h2>
            </a>
          </Grid>
          <Grid
            container
            item
            xs={3}
            sm={3}
            md={4}
            className={classes.userImgContainer}
            justify="center"
            alignContent="flex-end"
          >
            <MenuListComposition />
          </Grid>
        </Grid>
      </header>
    </Grid>
  );
}
