import React from "react";
import Button from "@material-ui/core/Button";
import ClickAwayListener from "@material-ui/core/ClickAwayListener";
import Grow from "@material-ui/core/Grow";
import Paper from "@material-ui/core/Paper";
import Popper from "@material-ui/core/Popper";
import MenuItem from "@material-ui/core/MenuItem";
import MenuList from "@material-ui/core/MenuList";
import { makeStyles } from "@material-ui/core/styles";
import UserImg from "./../header_imgs/user.png";

import { Avatar } from "@material-ui/core";

const useStyles = makeStyles(theme => ({
  menuPopUp: {
    alignContent: "start",
    ["@media (max-width:346px)"]: {
      width: "23%"
    }
  },
  menuPopUpText: {
    ["@media (max-width:525px)"]: {
      fontSize: "13px"
    }
  },
  popUpPaper: {
    marginRight: "14%",
    ["@media (max-width:525px)"]: {
      marginRight: "0"
    }
  },
  menuList: {
    alignItems: "flex-start",
    color: "grey"
  }
}));

/**
 * Para fazer com que o componente não apareça em telas em que o usuário não está logado, basta fazer uma função de verificação para tal e retornar o componente,
 * caso logado, ou NULL, caso não-logado.
 */

function MenuListComposition(props) {
  const [open, setOpen] = React.useState(false);

  const prevOpen = React.useRef(open);

  const anchorRef = React.useRef(null);
  const handleToggle = () => {
    setOpen(prevOpen => !prevOpen);
  };
  const handleClose = event => {
    if (anchorRef.current && anchorRef.current.contains(event.target)) {
      return;
    }
    setOpen(false);
  };
  function handleListKeyDown(event) {
    if (event.key === "Tab") {
      event.preventDefault();
      setOpen(false);
    }
  }
  React.useEffect(() => {
    if (prevOpen.current === true && open === false) {
      anchorRef.current.focus();
    }

    prevOpen.current = open;
  }, [open]);

  const classes = useStyles();

  return (
    <div>
      <Button
        id="notWhiteButton"
        ref={anchorRef}
        aria-controls={open ? "menu-list-grow" : undefined}
        aria-haspopup="true"
        onClick={handleToggle}
      >
        <Avatar alt="user_avatar" src={UserImg} className={classes.userImg} />{" "}
      </Button>
      <Popper
        open={open}
        anchorEl={anchorRef.current}
        role={undefined}
        transition
        disablePortal
        className={classes.menuPopUp}
      >
        {({ TransitionProps, placement }) => (
          <Grow
            {...TransitionProps}
            style={{
              transformOrigin:
                placement === "bottom" ? "center top" : "center bottom"
            }}
          >
            <Paper className={classes.popUpPaper}>
              <ClickAwayListener onClickAway={handleClose}>
                <MenuList
                  className={classes.menuList}
                  autoFocusItem={open}
                  id="menu-list-grow"
                  onKeyDown={handleListKeyDown}
                  alignContent="flex-start"
                >
                  <MenuItem
                    onClick={handleClose}
                    className={classes.menuPopUpText}
                  >
                    Perfil
                  </MenuItem>
                  <MenuItem
                    onClick={handleClose}
                    className={classes.menuPopUpText}
                  >
                    Logout
                  </MenuItem>
                </MenuList>
              </ClickAwayListener>
            </Paper>
          </Grow>
        )}
      </Popper>
    </div>
  );
}

export default MenuListComposition;
