import React, { useState, useEffect } from 'react';
import { useParams } from "react-router-dom";
import { makeStyles } from '@material-ui/core/styles';
import Grid from '@material-ui/core/Grid';
import Paper from '@material-ui/core/Paper';
import TextField from '@material-ui/core/TextField';
import AddIcon from '@material-ui/icons/Add';
import IconButton from '@material-ui/core/IconButton';
import ReorderIcon from '@material-ui/icons/Reorder';
import RadioButtonCheckedIcon from '@material-ui/icons/RadioButtonChecked';
import CheckBoxOutlineBlankIcon from '@material-ui/icons/CheckBoxOutlineBlank';
import Button from '@material-ui/core/Button';
import axios from 'axios';

import FormFieldText from '../components/fieldsAnswerForm/FormFieldText';
import FormFieldSelect from '../components/fieldsAnswerForm/FormFieldSelect';
import FormFieldRadio from '../components/fieldsAnswerForm/FormFieldRadio';
import FormFieldCheckbox from '../components/fieldsAnswerForm/FormFieldCheckbox';
import FormFieldTitle from '../components/fieldsAnswerForm/FormFieldTitle';

import config from '../config';


const useStyles = makeStyles(theme => ({
  menu: {
    width: theme.spacing(6),
    minheight: theme.spacing(15),
    position: 'fixed',
    top: theme.spacing(10),
    left: '90%',
    padding: theme.spacing(1)
  },
}));

function AnwserForm() {
  const classes = useStyles();

  const { id } = useParams();

  const [formData, setFormData] = useState(0);

  function getForm(id) {
    axios.get(`${config.genformsapi.url}/form/${id}`)
      .then(res => {
        console.log(res);
        console.log(res.data);
        setFormData(res.data);
      });
	}
	
	function answerForm() {
    axios.post(`${config.genformsapi.url}/form`)
      .then(res => {
        console.log(res);
        console.log(res.data);
      });
  }

  useEffect(() => {
    getForm(id);
  }, []);

  return (
    <div>
      <Grid
        container
        direction="column"
        alignItems="center"
        justify="center"
      >

        {
          formData ? 
          <div>
            <FormFieldTitle title={formData.title} description={formData.description}/>
            {
              formData.inputs.map((x, index) => {
                if(x.type === 0)
                  return <FormFieldText question={x.question}/>
                else if(x.type === 4)
                  return <FormFieldSelect question={x.question} options={x.sugestions}/>
                else if(x.type === 2)
                  return <FormFieldRadio question={x.question} options={x.sugestions}/>
                else if(x.type === 1)
                  return <FormFieldCheckbox question={x.question} options={x.sugestions}/>
              })
            } 
          </div> : <p>Loading...</p>
        }
        <Button variant="contained" color="primary" onClick={answerForm}>
          Responder
        </Button>
      </Grid>
    </div>
  );
}

export default AnwserForm;
