import React, { useState } from 'react';
import { makeStyles } from '@material-ui/core/styles';
import Grid from '@material-ui/core/Grid';
import Paper from '@material-ui/core/Paper';
import TextField from '@material-ui/core/TextField';
import AddIcon from '@material-ui/icons/Add';
import IconButton from '@material-ui/core/IconButton';
import ReorderIcon from '@material-ui/icons/Reorder';
import RadioButtonCheckedIcon from '@material-ui/icons/RadioButtonChecked';
import CheckBoxOutlineBlankIcon from '@material-ui/icons/CheckBoxOutlineBlank';
import Button from '@material-ui/core/Button';
import axios from 'axios';

import FormFieldText from '../components/fieldsCreateForm/FormFieldText';
import FormFieldSelect from '../components/fieldsCreateForm/FormFieldSelect';
import FormFieldRadio from '../components/fieldsCreateForm/FormFieldRadio';
import FormFieldCheckbox from '../components/fieldsCreateForm/FormFieldCheckbox';
import FormFieldTitle from '../components/fieldsCreateForm/FormFieldTitle';

import config from '../config';


const useStyles = makeStyles(theme => ({
  menu: {
    width: theme.spacing(6),
    minheight: theme.spacing(15),
    position: 'fixed',
    top: theme.spacing(10),
    left: '90%',
    padding: theme.spacing(1)
  },
}));

function CreateForm() {
  const classes = useStyles();

  const [form, setForm] = useState([{type: "title", title: "", description: ""}]);

  function addToFormQuestion() {
    setForm([...form, {type: "question", required: false, question: ""}]);
    console.log(form);
  }

  function addToFormSelect() {
    setForm([...form, {type: "select", question: "", required: false, options: [""]}]);
    console.log(form);
  }

  function addToFormRadio() {
    setForm([...form, {type: "radio", question: "", required: false, options: [""]}]);
    console.log(form);
  }

  function addToFormCheckbox() {
    setForm([...form, {type: "checkbox", question: "", required: false, options: [""]}]);
    console.log(form);
  }

  function addSelectOption(index) {
    form[index].options.push("");
    setForm([...form]);
    console.log(form);
  }

  function deleteFromForm(index) {
    console.log(index);
    form.splice(index, 1)
    console.log(form);
    setForm([...form]);
  }

  function removeSelectOption(index, idopt) {
    form[index].options.splice(idopt, 1);
    setForm([...form]);
    console.log(form);
  }

  function setQuestionField(value, index) {
    form[index].question = value;
    setForm([...form]);
    console.log(form);
  }
  
  function setSelectOption(value, index, idopt) {
    form[index].options[idopt] = value;
    setForm([...form]);
    console.log(form);
  }

  function setRequiredField(index) {
    form[index].required = !form[index].required;
    setForm([...form]);
    console.log(form);
  }

  function setTitleField(value, index) {
    form[index].title = value;
    setForm([...form]);
    console.log(form);
  }

  function setDescriptionField(value, index) {
    form[index].description = value;
    setForm([...form]);
    console.log(form);
  }

  function createForm() {
    let json = {
      title: form[0].title,
      description: form[0].description,
      inputs: []
    }
    
    form.forEach(function(x, index){
      if(x.type === "question") {
        json.inputs.push({
          "placement": index-1,
          "description": "Adicionar esse campo no front",
          "question": x.question,
          "enabled": true,
          "type": 0, // question type = 0
          "validation": x.required ? [{"type": 2, "arguments": ""}] : []
        });
      } else if(x.type === "select") {
        json.inputs.push({
          "placement": index-1,
          "description": "Adicionar esse campo no front",
          "question": x.question,
          "enabled": true,
          "type": 3, // select type = 3
          "validation": x.required ? [{"type": 2, "arguments": ""}] : [],
          "sugestions": x.options.map(function(y, index) { return {value: y, placement: index} })
        });
      } else if(x.type === "checkbox") {
        json.inputs.push({
          "placement": index-1,
          "description": "Adicionar esse campo no front",
          "question": x.question,
          "enabled": true,
          "type": 1, // checkbox type = 1
          "validation": x.required ? [{"type": 2, "arguments": ""}] : [],
          "sugestions": x.options.map(function(y, index) { return {value: y, placement: index} })
        });
      } else if(x.type === "radio") {
        json.inputs.push({
          "placement": index-1,
          "description": "Adicionar esse campo no front",
          "question": x.question,
          "enabled": true,
          "type": 2, // radio type = 2
          "validation": x.required ? [{"type": 2, "arguments": ""}] : [],
          "sugestions": x.options.map(function(y, index) { return {value: y, placement: index} })
        });
      }
    });
    

    console.log(json);
    axios.post(`${config.genformsapi.url}/form`, json )
      .then(res => {
        console.log(res);
        console.log(res.data);

        window.location.reload();
      });
    
  }

  return (
    <div>
      <Grid
        container
        direction="column"
        alignItems="center"
        justify="center"
      >
        {
          form.map((x, index) => {
            if(x.type === "question")
              return <FormFieldText question={x.question} idq={index} 
                                    deleteFromForm={deleteFromForm} setQuestionField={setQuestionField} 
                                    setRequiredField={setRequiredField} required={x.required}/>
            else if(x.type === "select")
              return <FormFieldSelect question={x.question} options={x.options} idq={index} 
                                      deleteFromForm={deleteFromForm} addSelectOption={addSelectOption}
                                      removeSelectOption={removeSelectOption} setSelectOption={setSelectOption} 
                                      setQuestionField={setQuestionField} setRequiredField={setRequiredField} 
                                      required={x.required} />
            else if(x.type === "radio")
            return <FormFieldRadio question={x.question} options={x.options} idq={index} 
                                    deleteFromForm={deleteFromForm} addSelectOption={addSelectOption}
                                    removeSelectOption={removeSelectOption} setSelectOption={setSelectOption} 
                                    setQuestionField={setQuestionField} setRequiredField={setRequiredField} 
                                    required={x.required} />
            else if(x.type === "checkbox")
              return <FormFieldCheckbox question={x.question} options={x.options} idq={index} 
                                    deleteFromForm={deleteFromForm} addSelectOption={addSelectOption}
                                    removeSelectOption={removeSelectOption} setSelectOption={setSelectOption} 
                                    setQuestionField={setQuestionField} setRequiredField={setRequiredField} 
                                    required={x.required} />
            else if(x.type === "title")
              return <FormFieldTitle question={x.question} idq={index} 
                                    deleteFromForm={deleteFromForm} setTitleField={setTitleField} 
                                    setDescriptionField={setDescriptionField}/>
          })
        }
        <Button variant="contained" color="primary" onClick={createForm}>
          Criar
        </Button>
      </Grid>
    
      <Paper className={classes.menu}>
        <Grid
          container
          spacing={0}
          direction="column"
          alignItems="center"
          justify="center"
        >
          <Grid item xs={0}>
            <IconButton aria-label="add question" onClick={addToFormQuestion}>
              <AddIcon />
            </IconButton>
            <IconButton aria-label="add select" onClick={addToFormSelect}>
              <ReorderIcon />
            </IconButton>
            <IconButton aria-label="add radio" onClick={addToFormRadio}>
              <RadioButtonCheckedIcon />
            </IconButton>
            <IconButton aria-label="add checkbox" onClick={addToFormCheckbox}>
              <CheckBoxOutlineBlankIcon />
            </IconButton>
          </Grid>
        </Grid>
      </Paper>
    
    </div>
  );
}

export default CreateForm;
