import React from "react";
import { HashRouter, Route } from "react-router-dom";
import "./global.css";
import CreateForm from "./pages/CreateForm";
import AnswerForm from "./pages/AnswerForm";
import Header from "./components/header/header";
import Footer from "./components/footer/footer";
import SignUp from "./pages/SignUp";
import SignIn from "./pages/SignIn";

function App() {
  return (
    <HashRouter>
      <Header />
      <Route path="/create" component={CreateForm} />
      <Route path="/answer/:id" component={AnswerForm} />
      <Route path="/SignUp" component={SignUp} />
      <Route path="/SignIn" component={SignIn} />
      <Footer />
    </HashRouter>
  );
}

export default App;
