import React from "react";
import Grid from "@material-ui/core/Grid";
import { createMuiTheme, MuiThemeProvider } from "@material-ui/core";
import IconButton from "@material-ui/core/IconButton";
import { makeStyles } from "@material-ui/core/styles";
import KeyboardArrowRightIcon from "@material-ui/icons/KeyboardArrowRight";
import FormInput from "../components/fieldsSignUp/FormInput";
import Paper from "@material-ui/core/Paper";
import api from "../api";

const useStyles = makeStyles(theme => ({
  register: {
    maxWidth: "1000px",
    background: "#ffffff",
    borderRadius: "2px",
    padding: "2% 1%",
    margin: "0 auto",
    marginTop: "9%",
    width: "95%"
  },
  custom_strong: {
    fontSize: "25px",
    textAlign: "center",
    display: "block",
    color: "#46525d"
  },
  strong_description: {
    fontSize: "14px",
    color: "#c2c6ca"
  },
  form: {
    marginTop: "3%",
    alignItems: "center",
    textAlign: "center"
  },
  button: {
    type: "submit",
    width: "30%",
    marginTop: "4%",
    background: "#6ec46c",
    borderRadius: "2px",
    padding: "10px 20px",
    fontSize: "18px",
    "&:hover": {
      backgroundColor: "rgb(25, 109, 23)"
    },
    ["@media (max-width:550px)"]: {
      width: "55%"
    }
  }
}));
export default function SignUp() {
  const classes = useStyles();
  const [values, setValues] = React.useState({
    name: "",
    email: "",
    password: "",
    password_confirm: "",
    nameError: false,
    emailError: false
  });
  async function update(prop, event) {
    await setValues({ ...values, [prop]: event.target.value });
  }

  const handleChange = prop => event => {
    switch (prop) {
      case "name":
        if (!checkName()) {
          values.nameError = true;
        } else {
          values.nameError = false;
        }
        break;
      case "email":
        if (!checkEmail()) {
          values.emailError = true;
        } else {
          values.emailError = false;
        }
    }
    update(prop, event);
  };
  function checkPassword() {
    if (values.password !== values.password_confirm) {
      alert("As senhas não conferem");
      return false;
    }
    return true;
  }
  function checkName() {
    if (/^[a-zA-Z ]+$/.test(values.name) && !(/^$|\s+/.test(values.name)) &&values.name.length <= 225) {
      return true;
    }
    return false;
  }
  function checkEmail() {
    if (/^[a-zA-Z0-9._-]+@[a-zA-Z0-9]+\.[A-Za-z]+$/.test(values.email)) {
      return true;
    }
    return false;
  }
  function verifyValues() {
    if (
      values.name &&
      values.email &&
      values.password &&
      values.password_confirm
    ) {
      return true;
    }
    return false;
  }
  // Ficou com essa configuração porque as funções para verificar nome e email são chamadas em 'tempo real' para deixar o campo em vermelho.
  function verifyValuesContent() {
    if (!checkName()){
      alert("Nome inválido");
      return false;
    }else if (!checkEmail()) {
      alert("Email invalido");
      return false;
    }else if (!checkPassword()){
      return false;
    }
    else{
      return true;
    }
  }
  async function handleSubmit() {
    const response = await api
      .post(`/user/signUp`, {
        email: values.email,
        name: values.name,
        hash: values.password
      })
      .then(function(error) {
        if (!error.response) {
          alert("Usuário criado com sucesso");
          // redirecionar para a main page
        }
      })
      .catch(function(error) {
        if (error.response) {
          switch (error.response.data.error) {
            case 'duplicate key value violates unique constraint "form_user_name_key"':
              alert("Você já tem uma conta.");
              break;
            case "Email exists on the database.":
              alert("Email já cadastrado");
              break;
            case "data and salt arguments required":
              alert(
                "Ocorreu um erro com sua senha. Tente novamente em alguns minutos ou tente mudá-la"
              );
            default:
              alert("Um erro ocorreu. Tente novamente mais tarde.");
          }
          return;
          // console.log(error.response.data);
        }
      });
  }
  function submit() {
    if (verifyValues()) {
      if (verifyValuesContent()) {
        handleSubmit();
      }
    }
  }
  const theme = createMuiTheme({
    overrides: {
      root: {
        color: "white"
      },
      MuiInput: {
        underline: {
          "&:before": {
            borderBottom: "1px solid #35c7fc"
          },
          "&:after": {
            borderBottom: "1px solid #3f51b5"
          }
        }
      },
    }
  });
  return (
    <MuiThemeProvider theme={theme}>
      <Paper className={classes.register} justify="center">
        <strong className={classes.custom_strong}>
          Cadastro de Usuário
          <p className={classes.strong_description}>
            Insira as informações abaixo
          </p>
        </strong>
        <form className={classes.form} autocomplete="off">
          <Grid>
            <FormInput
              label="Nome Completo"
              param="name"
              onUpdate={handleChange}
              error={values.nameError}
            />
          </Grid>
          <Grid>
            <FormInput
              label="E-mail"
              param="email"
              onUpdate={handleChange}
              verify={checkEmail}
              error={values.emailError}
            />
          </Grid>
          <Grid>
            <FormInput label="Senha" param="password" onUpdate={handleChange} />
          </Grid>
          <Grid>
            <FormInput
              label="Confirmar Senha"
              param="password_confirm"
              onUpdate={handleChange}
            />
          </Grid>
          <Grid>
            <IconButton
              type="submit"
              size="medium"
              className={classes.button}
              id="whiteTextedButton"
              onClick={() => submit()}
            >
              <KeyboardArrowRightIcon />
              Cadastre-se
            </IconButton>
          </Grid>
        </form>
      </Paper>
    </MuiThemeProvider>
  );
}
