CREATE TABLE cad_unico_ag 
AS 
SELECT 
    familias_cadunico.ano_censo,
    familias_cadunico.renda_media,
    familias_cadunico.cod_especie_domicilio,
    familias_cadunico.ind_tipo_familia,
    familias_cadunico.cod_local_domicilio,
    familias_cadunico.cod_iluminacao_domicilio,
    familias_cadunico.cod_destino_lixo_domicilio,
    familias_cadunico.cod_abastecimento_agua_domicilio,
    familias_cadunico.marca_programa_bolsa_familia,
    familias_cadunico.ind_familia_quilombola,    
    pessoas_cadunico.atividade_extrativista,
    pessoas_cadunico.idade,
    pessoas_cadunico.codigo_ibge,
    pessoas_cadunico.concluiu_frequentou,
    pessoas_cadunico.ano_serie_frequentou,
    pessoas_cadunico.curso_frequentou,
    COUNT(*) AS Total 
    
FROM 
    familias_cadunico 
        INNER JOIN 
    pessoas_cadunico 
        ON (familias_cadunico.id_familia=pessoas_cadunico.id_familia) 


GROUP BY 
    familias_cadunico.ano_censo, 
    familias_cadunico.renda_media, 
    familias_cadunico.cod_especie_domicilio,
    familias_cadunico.ind_tipo_familia, 
    familias_cadunico.cod_local_domicilio,
    familias_cadunico.cod_iluminacao_domicilio,
    familias_cadunico.cod_destino_lixo_domicilio,
    familias_cadunico.cod_abastecimento_agua_domicilio,
    familias_cadunico.marca_programa_bolsa_familia,
    familias_cadunico.ind_familia_quilombola,    
    pessoas_cadunico.atividade_extrativista,
    pessoas_cadunico.idade,
    pessoas_cadunico.codigo_ibge, 
    pessoas_cadunico.concluiu_frequentou, 
    pessoas_cadunico.ano_serie_frequentou, 
    pessoas_cadunico.curso_frequentou 

ORDER BY 
    familias_cadunico.ano_censo ASC, 
    familias_cadunico.renda_media ASC, 
    familias_cadunico.cod_especie_domicilio ASC, 
    familias_cadunico.ind_tipo_familia,
    familias_cadunico.cod_local_domicilio,
    familias_cadunico.cod_iluminacao_domicilio,
    familias_cadunico.cod_destino_lixo_domicilio,
    familias_cadunico.cod_abastecimento_agua_domicilio,
    familias_cadunico.marca_programa_bolsa_familia,
    familias_cadunico.ind_familia_quilombola,    
    pessoas_cadunico.atividade_extrativista,
    pessoas_cadunico.idade ASC,
    pessoas_cadunico.codigo_ibge ASC, 
    pessoas_cadunico.concluiu_frequentou ASC, 
    pessoas_cadunico.ano_serie_frequentou ASC, 
    pessoas_cadunico.curso_frequentou ASC
    ;