CREATE TABLE evader_ag 
AS 
SELECT 
    aluno_ens_superior.turno_aluno, 
    aluno_ens_superior.descricao_genero_aluno, 
    aluno_ens_superior.cor_raca_aluno, 
    aluno_ens_superior.nome_curso, 
    aluno_ens_superior.nome_ies, 
    aluno_ens_superior.cod_ies, 
    ies_ens_superior.nome_regiao_ies, 
    ies_ens_superior.sigla_uf_ies, 
    aluno_ens_superior.ano_censo, 
    COUNT(*) AS total 
    
FROM 
    aluno_ens_superior
        INNER JOIN 
    ies_ens_superior 
        ON (aluno_ens_superior.cod_ies = ies_ens_superior.cod_ies) 

WHERE 
    (aluno_ens_superior.cod_aluno_situacao IN (4,5,7)) AND 
    (aluno_ens_superior.reserva_vagas = 1) AND 
    (aluno_ens_superior.cod_categoria_administrativa IN (1)) AND 
    (aluno_ens_superior.cod_organizacao_academica IN (1, 4, 5)) AND 
    (aluno_ens_superior.ano_censo = ies_ens_superior.ano_censo) 
    
GROUP BY  
    aluno_ens_superior.turno_aluno, 
    aluno_ens_superior.descricao_genero_aluno, 
    aluno_ens_superior.cor_raca_aluno, 
    aluno_ens_superior.nome_curso, 
    aluno_ens_superior.nome_ies, 
    aluno_ens_superior.cod_ies, 
    aluno_ens_superior.ano_censo, 
    ies_ens_superior.nome_regiao_ies, 
    ies_ens_superior.sigla_uf_ies, 
    aluno_ens_superior.ano_censo 
    
ORDER BY 
    aluno_ens_superior.turno_aluno ASC, 
    aluno_ens_superior.descricao_genero_aluno ASC, 
    aluno_ens_superior.cor_raca_aluno ASC, 
    aluno_ens_superior.nome_curso ASC, 
    aluno_ens_superior.nome_ies ASC, 
    aluno_ens_superior.cod_ies ASC, 
    aluno_ens_superior.ano_censo ASC, 
    ies_ens_superior.nome_regiao_ies ASC, 
    ies_ens_superior.sigla_uf_ies ASC, 
    aluno_ens_superior.ano_censo ASC
;