CREATE TABLE extracurricular_activities_ag 
AS 
SELECT 
    aluno_ens_superior.turno_aluno,
    aluno_ens_superior.descricao_genero_aluno,
    aluno_ens_superior.cor_raca_aluno,
    aluno_ens_superior.nome_curso,
    aluno_ens_superior.cod_ies,
    aluno_ens_superior.nome_ies,
    aluno_ens_superior.ano_censo,
    COUNT(*) AS total 
FROM 
    aluno_ens_superior 
WHERE 
    (reserva_vagas = 1) AND 
    (bolsa_extensao = 1) AND 
    (cod_categoria_administrativa IN (1)) AND 
    (cod_organizacao_academica IN (1, 4, 5)) 
GROUP BY 
    aluno_ens_superior.turno_aluno, 
    aluno_ens_superior.descricao_genero_aluno, 
    aluno_ens_superior.cor_raca_aluno, 
    aluno_ens_superior.nome_curso, 
    aluno_ens_superior.cod_ies, 
    aluno_ens_superior.nome_ies, 
    aluno_ens_superior.ano_censo 
ORDER BY 
    aluno_ens_superior.turno_aluno ASC, 
    aluno_ens_superior.descricao_genero_aluno ASC, 
    aluno_ens_superior.cor_raca_aluno ASC, 
    aluno_ens_superior.nome_curso ASC, 
    aluno_ens_superior.cod_ies ASC, 
    aluno_ens_superior.nome_ies ASC, 
    aluno_ens_superior.ano_censo ASC
;