CREATE TABLE fies_ag 
AS 
SELECT 
    fies.codigo_contrato_fies,
    fies.genero,
    fies.raca_cor,
    fies.nome_ies,
    fies.codigo_ies,
    fies.campus,
    fies.codigo_campus,
    fies.percentual_solicitado_financiamento,
    fies.tipo_fianca,
    fies.sigla_uf,
    estado.regiao_id,
    fies.curso, 
    ano_censo,
    COUNT(*) AS total 
    
FROM 
    fies 
        INNER JOIN 
    estado 
        ON (fies.sigla_uf=estado.sigla) 
WHERE  
    (ano = ano_censo)
GROUP BY 
    fies.codigo_contrato_fies,
    fies.genero, 
    fies.curso, 
    fies.raca_cor, 
    fies.nome_ies, 
    fies.codigo_ies, 
    fies.campus, 
    fies.codigo_campus, 
    fies.percentual_solicitado_financiamento, 
    fies.tipo_fianca, 
    fies.sigla_uf, 
    estado.regiao_id, 
    fies.ano_censo, 
    ano_censo 
ORDER BY 
    fies.genero ASC,
    fies.curso ASC,  
    fies.raca_cor ASC, 
    fies.nome_ies ASC, 
    fies.codigo_ies ASC, 
    fies.campus ASC, 
    fies.codigo_campus ASC, 
    fies.percentual_solicitado_financiamento ASC, 
    fies.tipo_fianca ASC, 
    fies.sigla_uf ASC, 
    estado.regiao_id ASC, 
    fies.ano_censo ASC, 
    ano_censo ASC
