CREATE TABLE institution_ag 
AS 
SELECT 
    inst.ano_censo, 
    nome_ies, 
    cod_ies 
    
FROM 
    ies_ens_superior as inst 

WHERE 
    (ano_censo = (
        SELECT 
            MAX(ano_censo) 
        FROM ies_ens_superior as ies 
        WHERE inst.cod_ies = ies.cod_ies)
    ) AND 
    (cod_categoria_administrativa IN (1)) AND 
    (cod_organizacao_academica IN (1, 4, 5)) 

GROUP BY 
    inst.ano_censo, 
    nome_ies, 
    cod_ies 

ORDER BY 
    inst.ano_censo ASC, 
    nome_ies ASC
;