CREATE TABLE institution_fies_ag 
AS 
SELECT 
    fies_temp.ano_censo, 
    fies_temp.codigo_ies, 
    fies_temp.nome_ies 

FROM 
    (
        SELECT 
            distinct codigo_ies, 
            nome_ies, 
            ano_censo 
        FROM 
            fies
    ) AS fies_temp 


GROUP BY 
    fies_temp.ano_censo, 
    fies_temp.codigo_ies, 
    fies_temp.nome_ies 

ORDER BY 
    fies_temp.ano_censo ASC, 
    fies_temp.codigo_ies ASC
;