CREATE TABLE institution_private_ag 
AS 
SELECT 
    inst.ano_censo, 
    nome_ies, 
    cod_ies 
FROM 
    ies_ens_superior as inst 

WHERE 
    (ano_censo = 
        (
            SELECT 
                MAX(ano_censo) 
            FROM 
                ies_ens_superior as ies 
            WHERE 
                inst.cod_ies = ies.cod_ies
        )
    ) 

GROUP BY 
    inst.ano_censo, 
    nome_ies, 
    cod_ies 

ORDER BY 
    inst.ano_censo ASC, 
    nome_ies ASC