CREATE TABLE pnad_ag 
AS 
SELECT 
    pnad.cor_raca_original,
    pnad.rede_ensino,
    pnad.area_rede_publica_ensino,
    pnad.curso_que_frequenta,
    estado.sigla,
    estado.regiao_id,
    ano_censo,
    COUNT(*) AS total 

FROM 
    pnad 
        INNER JOIN 
    estado ON (pnad.estado_id=estado.id) 

WHERE 
    (idade >= 18) AND 
    (idade <= 24) 

GROUP BY 
    pnad.cor_raca_original, 
    pnad.rede_ensino, 
    pnad.area_rede_publica_ensino, 
    pnad.curso_que_frequenta, 
    estado.sigla, 
    estado.regiao_id, 
    ano_censo 

ORDER BY 
    pnad.cor_raca_original ASC, 
    pnad.rede_ensino ASC, 
    pnad.area_rede_publica_ensino ASC, 
    pnad.curso_que_frequenta ASC, 
    estado.sigla ASC, 
    estado.regiao_id ASC, 
    ano_censo ASC
;