CREATE TABLE prouni_ag 
AS 
SELECT 
    prouni.genero_beneficiario,
    prouni.raca_beneficiario,
    prouni.nome_curso,
    prouni.nome_ies,
    prouni.tipo,
    prouni.sigla_uf_beneficiario,
    prouni.regiao_beneficiario,
    prouni.ano_censo,
    prouni.nome_turno_curso,
    COUNT(*) AS total 

FROM 
    prouni 

GROUP BY 
    prouni.genero_beneficiario, 
    prouni.raca_beneficiario, 
    prouni.nome_curso, 
    prouni.nome_ies, 
    prouni.tipo, 
    prouni.sigla_uf_beneficiario, 
    prouni.regiao_beneficiario, 
    prouni.nome_turno_curso,
    prouni.ano_censo

ORDER BY 
    prouni.genero_beneficiario ASC, 
    prouni.raca_beneficiario ASC, 
    prouni.nome_curso ASC, 
    prouni.nome_ies ASC, 
    prouni.tipo ASC, 
    prouni.sigla_uf_beneficiario ASC, 
    prouni.regiao_beneficiario ASC, 
    prouni.nome_turno_curso ASC,
    prouni.ano_censo ASC
;
