CREATE TABLE student_loans_ag 
AS 
SELECT 
    aluno_ens_superior.turno_aluno,
    aluno_ens_superior.descricao_genero_aluno,
    aluno_ens_superior.cor_raca_aluno,
    aluno_ens_superior.nome_curso,
    aluno_ens_superior.cod_ies,
    aluno_ens_superior.nome_ies,
    aluno_ens_superior.financiamento_reembolsavel_fies,
    aluno_ens_superior.financiamento_reembolsavel_estadual,
    aluno_ens_superior.financiamento_reembolsavel_municipal,
    aluno_ens_superior.financiamento_reembolsavel_prog_ies,
    aluno_ens_superior.financiamento_reembolsavel_entidade_externa,
    aluno_ens_superior.financiamento_reembolsavel_outra,
    aluno_ens_superior.financiamento_naoreembolsavel_prouni_integral,
    aluno_ens_superior.financiamento_naoreembolsavel_prouni_parcial,
    aluno_ens_superior.financiamento_naoreembolsavel_estadual,
    aluno_ens_superior.financiamento_naoreembolsavel_municipal,
    aluno_ens_superior.financiamento_naoreembolsavel_prog_ies,
    aluno_ens_superior.financiamento_naoreembolsavel_entidade_externa,
    aluno_ens_superior.financiamento_naoreembolsavel_outra,
    aluno_ens_superior.ano_censo,
    COUNT(*) AS total 
    
FROM 
    aluno_ens_superior 
    
WHERE 
    (reserva_vagas = 1) AND 
    (financiamento_estudantil = 1) AND 
    (cod_organizacao_academica IN (1, 4, 5)) 

GROUP BY  
    aluno_ens_superior.turno_aluno, 
    aluno_ens_superior.descricao_genero_aluno, 
    aluno_ens_superior.cor_raca_aluno, 
    aluno_ens_superior.nome_curso, 
    aluno_ens_superior.cod_ies, 
    aluno_ens_superior.nome_ies, 
    aluno_ens_superior.financiamento_reembolsavel_fies, 
    aluno_ens_superior.financiamento_reembolsavel_estadual, 
    aluno_ens_superior.financiamento_reembolsavel_municipal, 
    aluno_ens_superior.financiamento_reembolsavel_prog_ies, 
    aluno_ens_superior.financiamento_reembolsavel_entidade_externa, 
    aluno_ens_superior.financiamento_reembolsavel_outra, 
    aluno_ens_superior.financiamento_naoreembolsavel_prouni_integral, 
    aluno_ens_superior.financiamento_naoreembolsavel_prouni_parcial, 
    aluno_ens_superior.financiamento_naoreembolsavel_estadual, 
    aluno_ens_superior.financiamento_naoreembolsavel_municipal, 
    aluno_ens_superior.financiamento_naoreembolsavel_prog_ies, 
    aluno_ens_superior.financiamento_naoreembolsavel_entidade_externa, 
    aluno_ens_superior.financiamento_naoreembolsavel_outra, 
    aluno_ens_superior.ano_censo 

ORDER BY  
    aluno_ens_superior.turno_aluno ASC, 
    aluno_ens_superior.descricao_genero_aluno ASC, 
    aluno_ens_superior.cor_raca_aluno ASC, 
    aluno_ens_superior.nome_curso ASC, 
    aluno_ens_superior.cod_ies ASC, 
    aluno_ens_superior.nome_ies ASC, 
    aluno_ens_superior.financiamento_reembolsavel_fies ASC, 
    aluno_ens_superior.financiamento_reembolsavel_estadual ASC, 
    aluno_ens_superior.financiamento_reembolsavel_municipal ASC, 
    aluno_ens_superior.financiamento_reembolsavel_prog_ies ASC, 
    aluno_ens_superior.financiamento_reembolsavel_entidade_externa ASC, 
    aluno_ens_superior.financiamento_reembolsavel_outra ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_prouni_integral ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_prouni_parcial ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_estadual ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_municipal ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_prog_ies ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_entidade_externa ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_outra ASC, 
    aluno_ens_superior.ano_censo ASC
;