--
--Copyright (C) 2019 Centro de Computacao Cientifica e Software Livre
--Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR
--
--This file is part of SMPPIR-Tables.
--
--SMPPIR-Tables is free software: you can redistribute it and/or modify
--it under the terms of the GNU General Public License as published by
--the Free Software Foundation, either version 3 of the License, or
--(at your option) any later version.
--
--SMPPIR-Tables is distributed in the hope that it will be useful,
--but WITHOUT ANY WARRANTY; without even the implied warranty of
--MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--GNU General Public License for more details.
--
--You should have received a copy of the GNU General Public License
--along with SMPPIR-Tables.  If not, see <https://www.gnu.org/licenses/>.
--

CREATE TABLE cad_unico_ag 
AS 
SELECT
    familias_cadunico.ano_censo,
    familias_cadunico.renda_media,
    familias_cadunico.cod_especie_domicilio,
    familias_cadunico.ind_tipo_familia,
    familias_cadunico.cod_local_domicilio,
    familias_cadunico.cod_iluminacao_domicilio,
    familias_cadunico.cod_destino_lixo_domicilio,
    familias_cadunico.cod_abastecimento_agua_domicilio,
    familias_cadunico.marca_programa_bolsa_familia,
    familias_cadunico.ind_familia_quilombola,    
    familias_cadunico.cod_escoa_sanitario_domicilio,
    pessoas_cadunico.atividade_extrativista,
    pessoas_cadunico.idade,
    pessoas_cadunico.codigo_ibge,
    pessoas_cadunico.concluiu_frequentou,
    pessoas_cadunico.ano_serie_frequentou,
    pessoas_cadunico.curso_frequentou,
    pessoas_cadunico.genero,
    geographic.nome_regiao,
    geographic.sigla_estado,
    COUNT(*) AS Total 
    
FROM

    -- Data from CadUnico
    familias_cadunico 
        INNER JOIN 
    pessoas_cadunico 
        ON (familias_cadunico.id_familia=pessoas_cadunico.id_familia AND familias_cadunico.ano_censo=pessoas_cadunico.ano_censo) 
        INNER JOIN 
        
    -- Geogrphic (State/Region) data    
    (
        SELECT 
            municipio.id AS municipio_id,
            regiao.nome AS nome_regiao,
            estado.sigla AS sigla_estado
        FROM
            estado INNER JOIN municipio ON (estado.id = municipio.estado_id)
                INNER JOIN regiao ON (regiao.id = estado.regiao_id)
    ) AS geographic ON (geographic.municipio_id = pessoas_cadunico.codigo_ibge)
    

GROUP BY 
    familias_cadunico.ano_censo, 
    familias_cadunico.renda_media, 
    familias_cadunico.cod_especie_domicilio,
    familias_cadunico.ind_tipo_familia, 
    familias_cadunico.cod_local_domicilio,
    familias_cadunico.cod_iluminacao_domicilio,
    familias_cadunico.cod_destino_lixo_domicilio,
    familias_cadunico.cod_abastecimento_agua_domicilio,
    familias_cadunico.marca_programa_bolsa_familia,
    familias_cadunico.ind_familia_quilombola,  
    familias_cadunico.cod_escoa_sanitario_domicilio, 
    pessoas_cadunico.atividade_extrativista,
    pessoas_cadunico.idade,
    pessoas_cadunico.codigo_ibge, 
    pessoas_cadunico.concluiu_frequentou, 
    pessoas_cadunico.ano_serie_frequentou, 
    pessoas_cadunico.curso_frequentou,
    pessoas_cadunico.genero,
    geographic.nome_regiao,
    geographic.sigla_estado

ORDER BY 
    familias_cadunico.ano_censo ASC, 
    familias_cadunico.renda_media ASC, 
    familias_cadunico.cod_especie_domicilio ASC, 
    familias_cadunico.ind_tipo_familia,
    familias_cadunico.cod_local_domicilio,
    familias_cadunico.cod_iluminacao_domicilio,
    familias_cadunico.cod_destino_lixo_domicilio,
    familias_cadunico.cod_abastecimento_agua_domicilio,
    familias_cadunico.marca_programa_bolsa_familia,
    familias_cadunico.ind_familia_quilombola,    
    pessoas_cadunico.atividade_extrativista,
    pessoas_cadunico.idade ASC,
    pessoas_cadunico.codigo_ibge ASC, 
    pessoas_cadunico.concluiu_frequentou ASC, 
    pessoas_cadunico.ano_serie_frequentou ASC, 
    pessoas_cadunico.curso_frequentou ASC,
    geographic.nome_regiao ASC,
    geographic.sigla_estado ASC
    ;