/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of HOTMapper.

HOTMapper is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

HOTMapper is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with HOTMapper.  If not, see <https://www.gnu.org/licenses/>.
*/

-- depends: docente, turma
-- SimCAQ: tabela de docentes por escola --

CREATE TABLE docente_por_escola
AS
SELECT
    COUNT(DISTINCT docente.id_docente) AS "total_professores",
    docente.ano_censo,
    docente.escola_id,
    docente.dependencia_adm_id,
    docente.dependencia_adm_priv,
    docente.localizacao_id,
    docente.localidade_area_rural,
    docente.escola_municipio_id AS "municipio_id",
    docente.escola_estado_id AS "estado_id",
    docente.escola_regiao_id AS "regiao_id"
FROM
    docente INNER JOIN turma ON (docente.turma_id=turma.id AND docente.ano_censo=turma.ano_censo)
WHERE
    ((docente.tipo_docente <= 6) AND (turma.tipo_turma_id <= 3) AND (docente.dependencia_adm_id = 2 OR docente.dependencia_adm_id = 3 OR docente.dependencia_adm_id = 4))
GROUP BY
    docente.ano_censo,
    docente.escola_id,
    docente.dependencia_adm_id,
    docente.dependencia_adm_priv,
    docente.localizacao_id,
    docente.localidade_area_rural,
    docente.escola_municipio_id,
    docente.escola_estado_id,
    docente.escola_regiao_id
ORDER BY
    docente.ano_censo ASC, docente.escola_id ASC
;
