--
--Copyright (C) 2019 Centro de Computacao Cientifica e Software Livre
--Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR
--
--This file is part of SMPPIR-Tables.
--
--SMPPIR-Tables is free software: you can redistribute it and/or modify
--it under the terms of the GNU General Public License as published by
--the Free Software Foundation, either version 3 of the License, or
--(at your option) any later version.
--
--SMPPIR-Tables is distributed in the hope that it will be useful,
--but WITHOUT ANY WARRANTY; without even the implied warranty of
--MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--GNU General Public License for more details.
--
--You should have received a copy of the GNU General Public License
--along with SMPPIR-Tables.  If not, see <https://www.gnu.org/licenses/>.
--

CREATE TABLE education_ag 
AS 
SELECT 
    aluno_ens_superior.ano_censo,
    aluno_ens_superior.cor_raca_aluno,
    ies_ens_superior.nome_regiao_ies,
    ies_ens_superior.sigla_uf_ies,
    aluno_ens_superior.reserva_vagas,
    aluno_ens_superior.ingressante,
    COUNT(*) AS Total
    
FROM
    aluno_ens_superior
        INNER JOIN
    ies_ens_superior
        ON (aluno_ens_superior.cod_ies = ies_ens_superior.cod_ies)
        
WHERE
    (aluno_ens_superior.cod_categoria_administrativa IN (1)) AND 
    (aluno_ens_superior.cod_organizacao_academica IN (1, 4, 5)) AND
    (aluno_ens_superior.matriculado IN (1)) AND
    (aluno_ens_superior.ano_censo = ies_ens_superior.ano_censo)
    
GROUP BY
    aluno_ens_superior.ano_censo,
    aluno_ens_superior.cor_raca_aluno,
    ies_ens_superior.nome_regiao_ies,
    ies_ens_superior.sigla_uf_ies,
    aluno_ens_superior.reserva_vagas,
    aluno_ens_superior.ingressante
    
ORDER BY
    aluno_ens_superior.ano_censo ASC,
    aluno_ens_superior.cor_raca_aluno ASC,
    ies_ens_superior.nome_regiao_ies ASC,
    ies_ens_superior.sigla_uf_ies ASC,
    aluno_ens_superior.reserva_vagas ASC,
    aluno_ens_superior.ingressante ASC
;