/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of HOTMapper.

HOTMapper is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

HOTMapper is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with HOTMapper.  If not, see <https://www.gnu.org/licenses/>.
*/

-- msqldump dump table ibge_pib Thu Apr 12 11:01:08 2018
-- MonetDB v11.23.7 (Jun2016-SP1), 'mapi:monetdb://mjolnir:50000/simcaq_dev4'
CREATE TABLE "sys"."ibge_pib" (
	"ano_censo"              INTEGER       NOT NULL,
	"estado_id"              INTEGER,
	"regiao_id"              INTEGER,
	"municipio_id"           INTEGER       NOT NULL,
	"pib"                    DOUBLE,
	"populacao"              BIGINT,
	"pib_per_capita"         DOUBLE,
	"nivel_renda_per_capita" TINYINT,
	CONSTRAINT "ibge_pib_ano_censo_municipio_id_pkey" PRIMARY KEY ("ano_censo", "municipio_id"),
	CONSTRAINT "ibge_pib_estado_id_fkey" FOREIGN KEY ("estado_id") REFERENCES "sys"."estado" ("id"),
	CONSTRAINT "ibge_pib_municipio_id_fkey" FOREIGN KEY ("municipio_id") REFERENCES "sys"."municipio" ("id"),
	CONSTRAINT "ibge_pib_regiao_id_fkey" FOREIGN KEY ("regiao_id") REFERENCES "sys"."regiao" ("id")
);
COPY 27835 RECORDS INTO "sys"."ibge_pib" FROM stdin USING DELIMITERS '\t','\n','"';
2010	21	2	2111003	4.505167e+07	19966	2256.42	1
2010	21	2	2110278	3.167607e+07	13821	2291.88	1
2010	21	2	2109403	3.287764e+07	13896	2365.98	1
2010	21	2	2111722	2.840042e+07	11987	2369.27	1
2010	21	2	2107209	3.084765e+07	12467	2474.34	1
2010	21	2	2110237	2.892311e+07	11661	2480.33	1
2010	21	2	2112100	6.96464e+07	28007	2486.75	1
2010	21	2	2108405	3.512906e+07	13807	2544.29	1
2010	21	2	2105104	6.449384e+07	25147	2564.67	1
2010	21	2	2100873	3.598342e+07	13957	2578.16	1
2010	21	2	2100832	3.86297e+07	14959	2582.37	1
2010	21	2	2101301	4.340485e+07	16626	2610.66	1
2010	21	2	2110906	3.188833e+07	12163	2621.75	1
2010	21	2	2105005	6.884659e+07	26197	2628.03	1
2010	21	2	2102408	2.79589e+07	10632	2629.69	1
2010	21	2	2103125	2.114711e+07	7988	2647.36	1
2010	21	2	2111078	4.547986e+07	17104	2659.02	1
2010	21	2	2111789	2.926206e+07	10924	2678.69	1
2010	21	2	2110401	4.784124e+07	17802	2687.41	1
2010	29	2	2905156	3.680284e+07	13666	2693.02	1
2010	29	2	2923050	4.059779e+07	15057	2696.27	1
2010	21	2	2103158	3.413912e+07	12517	2727.42	1
2010	21	2	2108256	6.216941e+07	22731	2735.01	1
2010	21	2	2100204	5.989984e+07	21852	2741.16	1
2010	29	2	2901502	2.821847e+07	10248	2753.56	1
2010	21	2	2101905	5.624726e+07	20339	2765.49	1
2010	21	2	2108058	4.015622e+07	14498	2769.78	1
2010	21	2	2101103	3.182589e+07	11425	2785.64	1
2010	21	2	2102507	5.123305e+07	18348	2792.3	1
2010	15	1	1504505	6.923235e+07	24789	2792.87	1
2010	21	2	2108306	9.607143e+07	34246	2805.33	1
2010	22	2	2203255	1.179686e+07	4182	2820.87	1
2010	21	2	2103109	2.926836e+07	10300	2841.59	1
2010	21	2	2100154	3.294509e+07	11590	2842.54	1
2010	21	2	2103901	3.043633e+07	10634	2862.17	1
2010	21	2	2106607	8.871599e+07	30930	2868.28	1
2010	21	2	2100105	1.724659e+07	5957	2895.18	1
2010	15	1	1501956	7.667344e+07	26476	2895.96	1
2010	21	2	2109809	1.1328722e+08	39060	2900.34	1
2010	21	2	2106805	4.13277e+07	14213	2907.74	1
2010	21	2	2101350	1.553794e+07	5304	2929.48	1
2010	22	2	2203453	2.712798e+07	9246	2934.02	1
2010	22	2	2203750	1.491547e+07	5076	2938.43	1
2010	21	2	2112506	1.5511743e+08	52711	2942.79	1
2010	21	2	2106300	5.193035e+07	17633	2945.07	1
2010	21	2	2104651	3.520852e+07	11922	2953.24	1
2010	21	2	2104909	3.576239e+07	12105	2954.35	1
2010	21	2	2104503	3.02082e+07	10205	2960.14	1
2010	21	2	2107100	5.278076e+07	17805	2964.38	1
2010	21	2	2106201	1.931157e+07	6510	2966.45	1
2010	22	2	2206050	1.850332e+07	6222	2973.85	1
2010	21	2	2106904	9.46478e+07	31748	2981.22	1
2010	21	2	2100402	3.044954e+07	10211	2982.03	1
2010	21	2	2107456	3.915199e+07	13122	2983.69	1
2010	22	2	2209971	2.189486e+07	7337	2984.17	1
2010	22	2	2206357	2.022659e+07	6770	2987.68	1
2010	21	2	2110500	1.2174444e+08	40717	2990.02	1
2010	21	2	2107605	5.614985e+07	18766	2992.11	1
2010	21	2	2102374	2.525968e+07	8442	2992.14	1
2010	22	2	2203271	1.461531e+07	4870	3001.09	1
2010	29	2	2924702	3.843641e+07	12789	3005.43	1
2010	22	2	2201960	2.392997e+07	7961	3005.9	1
2010	22	2	2201770	1.894421e+07	6299	3007.5	1
2010	21	2	2109304	3.227817e+07	10729	3008.5	1
2010	22	2	2201051	2.266009e+07	7503	3020.14	1
2010	21	2	2104404	5.298788e+07	17485	3030.48	1
2010	21	2	2106375	4.266041e+07	14066	3032.87	1
2010	22	2	2200103	1.556649e+07	5114	3043.9	1
2010	21	2	2102358	4.496955e+07	14770	3044.65	1
2010	29	2	2911303	3.265616e+07	10720	3046.28	1
2010	29	2	2921054	3.393415e+07	11134	3047.79	1
2010	22	2	2202174	2.074249e+07	6803	3049.02	1
2010	29	2	2903953	3.087993e+07	10123	3050.47	1
2010	22	2	2205409	4.216982e+07	13822	3050.92	1
2010	22	2	2203305	4.050298e+07	13274	3051.3	1
2010	22	2	2201945	1.892883e+07	6193	3056.49	1
2010	21	2	2106631	4.219956e+07	13796	3058.83	1
2010	21	2	2102309	7.005854e+07	22886	3061.2	1
2010	29	2	2920452	3.856399e+07	12594	3062.09	1
2010	21	2	2104081	2.815516e+07	9180	3067.01	1
2010	21	2	2102705	6.281232e+07	20457	3070.46	1
2010	22	2	2207793	1.158121e+07	3757	3082.57	1
2010	21	2	2105476	4.753054e+07	15397	3087	1
2010	23	2	2313351	5.198384e+07	16836	3087.66	1
2010	22	2	2208502	3.678344e+07	11897	3091.82	1
2010	22	2	2202406	3.388069e+07	10956	3092.43	1
2010	21	2	2112605	7.611529e+07	24548	3100.67	1
2010	23	2	2303600	5.832323e+07	18745	3111.4	1
2010	21	2	2111904	3.248271e+07	10431	3114.05	1
2010	29	2	2925709	4.265697e+07	13657	3123.45	1
2010	29	2	2932457	5.318469e+07	17010	3126.67	1
2010	22	2	2208874	1.333311e+07	4263	3127.64	1
2010	22	2	2202059	3.106484e+07	9927	3129.33	1
2010	21	2	2105807	3.363916e+07	10736	3133.3	1
2010	22	2	2201309	1.014302e+07	3234	3136.37	1
2010	29	2	2912509	4.445609e+07	14171	3137.12	1
2010	23	2	2311009	3.766088e+07	12003	3137.62	1
2010	13	1	1301803	6.965371e+07	22199	3137.7	1
2010	22	2	2205458	1.600696e+07	5100	3138.62	1
2010	29	2	2906402	2.796774e+07	8895	3144.21	1
2010	22	2	2209559	1.356365e+07	4313	3144.83	1
2010	22	2	2209658	1.753303e+07	5575	3144.94	1
2010	21	2	2101731	2.05425e+07	6527	3147.31	1
2010	22	2	2211357	1.546453e+07	4913	3147.67	1
2010	27	2	2707206	4.369432e+07	13873	3149.59	1
2010	29	2	2900504	3.419833e+07	10855	3150.47	1
2010	21	2	2100477	9.776194e+07	31028	3150.77	1
2010	21	2	2110104	9.204827e+07	29172	3155.36	1
2010	29	2	2922656	3.916051e+07	12398	3158.62	1
2010	27	2	2708956	4.121329e+07	13047	3158.83	1
2010	21	2	2102077	4.683955e+07	14823	3159.92	1
2010	29	2	2904753	6.215147e+07	19589	3172.77	1
2010	21	2	2106508	6.950198e+07	21832	3183.49	1
2010	23	2	2300408	5.165566e+07	16207	3187.24	1
2010	21	2	2105906	4.921733e+07	15407	3194.48	1
2010	22	2	2201929	1.726111e+07	5393	3200.65	1
2010	22	2	2209955	1.490606e+07	4648	3206.98	1
2010	29	2	2918753	4.470788e+07	13934	3208.55	1
2010	23	2	2307908	3.279589e+07	10220	3208.99	1
2010	29	2	2921450	3.374147e+07	10512	3209.8	1
2010	21	2	2110203	1.0400514e+08	32365	3213.51	1
2010	22	2	2210359	1.427502e+07	4423	3227.45	1
2010	22	2	2205557	2.584656e+07	8008	3227.59	1
2010	22	2	2210409	5.859625e+07	18149	3228.62	1
2010	21	2	2112456	7.377718e+07	22850	3228.76	1
2010	22	2	2204907	2.654993e+07	8218	3230.7	1
2010	23	2	2305654	3.663259e+07	11335	3231.81	1
2010	22	2	2206670	2.103205e+07	6499	3236.2	1
2010	22	2	2201606	3.210059e+07	9911	3238.88	1
2010	21	2	2100303	7.763762e+07	23952	3241.38	1
2010	22	2	2206100	3.399422e+07	10485	3242.18	1
2010	15	1	1502806	9.282241e+07	28582	3247.58	1
2010	31	3	3162450	3.807377e+07	11715	3250	1
2010	21	2	2112704	1.606401e+08	49415	3250.84	1
2010	21	2	2111706	6.78731e+07	20870	3252.18	1
2010	21	2	2108801	5.647749e+07	17358	3253.69	1
2010	22	2	2200707	2.959531e+07	9094	3254.38	1
2010	22	2	2202026	2.598092e+07	7977	3256.98	1
2010	21	2	2100709	8.24353e+07	25294	3259.09	1
2010	22	2	2204550	1.437181e+07	4401	3265.58	1
2010	22	2	2206753	1.489213e+07	4560	3265.82	1
2010	21	2	2107803	1.1305239e+08	34613	3266.18	1
2010	29	2	2922805	2.434529e+07	7438	3273.1	1
2010	27	2	2709202	8.429959e+07	25710	3278.86	1
2010	22	2	2210904	1.484848e+07	4528	3279.26	1
2010	22	2	2201101	3.630044e+07	11067	3280.06	1
2010	22	2	2209377	1.689668e+07	5149	3281.55	1
2010	22	2	2201572	1.077749e+07	3284	3281.82	1
2010	22	2	2206704	2.406297e+07	7327	3284.15	1
2010	15	1	1500909	1.3330783e+08	40499	3291.63	1
2010	21	2	2104602	5.265009e+07	15983	3294.13	1
2010	22	2	2209351	1.620799e+07	4920	3294.31	1
2010	22	2	2205573	2.116439e+07	6422	3295.61	1
2010	22	2	2210656	3.172126e+07	9619	3297.77	1
2010	21	2	2100956	1.0420815e+08	31568	3301.07	1
2010	29	2	2925931	3.152807e+07	9548	3302.06	1
2010	15	1	1501105	7.884513e+07	23855	3305.18	1
2010	29	2	2901205	8.438731e+07	25500	3309.31	1
2010	21	2	2109452	8.715208e+07	26280	3316.29	1
2010	29	2	2907558	2.934398e+07	8847	3316.83	1
2010	22	2	2206902	2.15614e+07	6498	3318.16	1
2010	23	2	2313559	4.7858e+07	14415	3320.01	1
2010	21	2	2105922	3.640782e+07	10954	3323.7	1
2010	21	2	2111748	3.414072e+07	10253	3329.83	1
2010	22	2	2206696	2.819163e+07	8464	3330.77	1
2010	21	2	2102606	6.163683e+07	18505	3330.82	1
2010	29	2	2901809	3.670902e+07	11019	3331.43	1
2010	22	2	2205854	2.605174e+07	7816	3333.13	1
2010	29	2	2924504	5.210802e+07	15629	3334.06	1
2010	23	2	2301257	3.504773e+07	10500	3337.88	1
2010	21	2	2100907	1.422202e+08	42600	3338.5	1
2010	22	2	2210375	8.55913e+06	2561	3342.1	1
2010	29	2	2924306	6.01521e+07	17985	3344.57	1
2010	22	2	2207777	2.04306e+07	6106	3345.99	1
2010	29	2	2903235	4.561303e+07	13626	3347.5	1
2010	21	2	2111508	1.3091873e+08	39109	3347.53	1
2010	21	2	2103703	1.0915595e+08	32594	3348.96	1
2010	22	2	2202117	1.574514e+07	4696	3352.88	1
2010	27	2	2702553	5.787874e+07	17254	3354.51	1
2010	22	2	2207504	4.612551e+07	13745	3355.8	1
2010	22	2	2203354	2.240804e+07	6677	3356	1
2010	22	2	2202703	8.745653e+07	26044	3358.03	1
2010	21	2	2104628	2.465478e+07	7337	3360.34	1
2010	22	2	2200301	4.590394e+07	13654	3361.94	1
2010	27	2	2701803	2.788392e+07	8290	3363.56	1
2010	22	2	2206209	1.0868539e+08	32292	3365.71	1
2010	22	2	2202505	3.440197e+07	10212	3368.78	1
2010	15	1	1503507	1.0574794e+08	31382	3369.7	1
2010	21	2	2102200	9.113162e+07	27042	3370	1
2010	29	2	2904001	4.615573e+07	13695	3370.26	1
2010	29	2	2931806	5.74578e+07	17032	3373.52	1
2010	22	2	2200251	2.48244e+07	7349	3377.93	1
2010	29	2	2919801	1.5932924e+08	47067	3385.16	1
2010	22	2	2202729	1.887552e+07	5572	3387.57	1
2010	23	2	2311900	5.338959e+07	15754	3388.95	1
2010	22	2	2207553	1.40555e+07	4147	3389.32	1
2010	31	3	3126505	3.4737e+07	10244	3390.96	1
2010	23	2	2305266	4.390525e+07	12928	3396.14	1
2010	21	2	2109056	2.059026e+07	6062	3396.61	1
2010	15	1	1506104	3.487871e+07	10268	3396.84	1
2010	29	2	2924405	1.1148006e+08	32815	3397.23	1
2010	29	2	2910008	4.366993e+07	12841	3400.82	1
2010	23	2	2302305	1.0503786e+08	30873	3402.26	1
2010	15	1	1507961	3.489702e+07	10254	3403.26	1
2010	29	2	2919900	2.748191e+07	8067	3406.71	1
2010	23	2	2300606	2.334189e+07	6851	3407.08	1
2010	22	2	2202075	1.139607e+07	3343	3408.93	1
2010	13	1	1303700	8.350132e+07	24487	3410.03	1
2010	21	2	2100550	2.193445e+07	6431	3410.74	1
2010	29	2	2919108	3.079208e+07	9027	3411.11	1
2010	29	2	2904100	7.519314e+07	22042	3411.36	1
2010	23	2	2309458	8.193122e+07	24012	3412.09	1
2010	21	2	2104008	6.297796e+07	18456	3412.33	1
2010	29	2	2906709	9.536864e+07	27916	3416.27	1
2010	21	2	2100600	1.2954514e+08	37894	3418.62	1
2010	27	2	2703304	6.123977e+07	17902	3420.83	1
2010	29	2	2913804	5.246174e+07	15334	3421.27	1
2010	22	2	2209500	1.250233e+07	3653	3422.48	1
2010	21	2	2105450	2.920135e+07	8526	3424.98	1
2010	15	1	1507102	5.787132e+07	16891	3426.16	1
2010	23	2	2303931	4.403881e+07	12853	3426.34	1
2010	29	2	2901601	5.854235e+07	17078	3427.94	1
2010	23	2	2313757	6.44788e+07	18807	3428.45	1
2010	23	2	2308005	1.2069128e+08	35201	3428.63	1
2010	22	2	2209708	2.160702e+07	6301	3429.14	1
2010	29	2	2918506	5.164911e+07	15053	3431.15	1
2010	22	2	2203008	2.688073e+07	7831	3432.6	1
2010	13	1	1304237	5.85731e+07	17056	3434.16	1
2010	29	2	2923035	3.666213e+07	10673	3435.04	1
2010	23	2	2300507	3.701461e+07	10773	3435.87	1
2010	26	2	2612802	3.77972e+07	10991	3438.92	1
2010	21	2	2106003	3.9256e+07	11415	3438.98	1
2010	22	2	2205250	1.481986e+07	4309	3439.28	1
2010	29	2	2919959	2.41898e+07	7031	3440.45	1
2010	22	2	2202802	1.54293e+07	4484	3440.97	1
2010	29	2	2933059	4.744929e+07	13787	3441.6	1
2010	21	2	2101772	4.118563e+07	11946	3447.65	1
2010	29	2	2907103	9.787877e+07	28378	3449.11	1
2010	21	2	2101806	1.888091e+07	5473	3449.83	1
2010	22	2	2202554	1.665347e+07	4825	3451.5	1
2010	21	2	2102903	7.606552e+07	22008	3456.27	1
2010	29	2	2924603	6.953815e+07	20119	3456.34	1
2010	22	2	2203420	1.474659e+07	4264	3458.39	1
2010	21	2	2103604	2.1330186e+08	61653	3459.72	1
2010	29	2	2922052	4.249745e+07	12270	3463.53	1
2010	27	2	2706604	2.572425e+07	7426	3464.08	1
2010	13	1	1303908	1.0887905e+08	31426	3464.62	1
2010	15	1	1506112	4.300023e+07	12411	3464.69	1
2010	29	2	2930808	5.51286e+07	15899	3467.43	1
2010	29	2	2901908	6.145708e+07	17720	3468.23	1
2010	29	2	2906899	3.547664e+07	10225	3469.6	1
2010	22	2	2209856	1.543369e+07	4445	3472.15	1
2010	22	2	2201507	8.962771e+07	25786	3475.83	1
2010	22	2	2202091	1.971101e+07	5668	3477.6	1
2010	22	2	2208106	4.074991e+07	11713	3479.03	1
2010	23	2	2300101	3.65428e+07	10489	3483.92	1
2010	15	1	1508035	9.570299e+07	27466	3484.42	1
2010	21	2	2111672	2.076841e+07	5957	3486.39	1
2010	23	2	2308203	4.777869e+07	13693	3489.28	1
2010	29	2	2924108	2.407344e+07	6896	3490.93	1
2010	22	2	2200053	2.356497e+07	6749	3491.62	1
2010	21	2	2104701	2.145162e+07	6140	3493.75	1
2010	27	2	2706109	3.812877e+07	10911	3494.53	1
2010	21	2	2111631	2.130684e+07	6090	3498.66	1
2010	23	2	2306504	6.520824e+07	18626	3500.93	1
2010	31	3	3116100	5.314218e+07	15165	3504.26	1
2010	29	2	2922854	2.816856e+07	8034	3506.17	1
2010	22	2	2209450	7.21777e+06	2058	3507.17	1
2010	21	2	2101970	2.79139e+07	7949	3511.62	1
2010	23	2	2304707	1.8504115e+08	52670	3513.22	1
2010	31	3	3108255	3.397806e+07	9671	3513.4	1
2010	27	2	2708402	1.0592115e+08	30140	3514.3	1
2010	22	2	2209104	2.117603e+07	6025	3514.69	1
2010	23	2	2310951	3.591772e+07	10216	3515.83	1
2010	31	3	3138658	2.954524e+07	8401	3516.87	1
2010	26	2	2603207	9.350314e+07	26577	3518.2	1
2010	21	2	2107001	3.315822e+07	9424	3518.49	1
2010	27	2	2702504	3.829161e+07	10879	3519.77	1
2010	29	2	2921500	1.8432454e+08	52360	3520.33	1
2010	23	2	2300903	4.905665e+07	13927	3522.41	1
2010	22	2	2207959	1.477754e+07	4192	3525.18	1
2010	21	2	2107704	7.094764e+07	20104	3529.03	1
2010	21	2	2108702	7.7716e+07	22016	3529.98	1
2010	23	2	2309409	9.704922e+07	27461	3534.07	1
2010	22	2	2209807	1.682627e+07	4754	3539.39	1
2010	21	2	2103174	6.24072e+07	17622	3541.44	1
2010	29	2	2902708	1.748115e+08	49342	3542.85	1
2010	21	2	2112902	1.1072346e+08	31234	3544.97	1
2010	15	1	1501006	5.594816e+07	15767	3548.43	1
2010	22	2	2205540	9.43068e+06	2656	3550.71	1
2010	29	2	2930402	5.469746e+07	15401	3551.55	1
2010	29	2	2904506	3.816731e+07	10718	3561.05	1
2010	29	2	2906105	3.342236e+07	9382	3562.39	1
2010	22	2	2209302	1.964098e+07	5513	3562.67	1
2010	29	2	2909000	2.910816e+07	8169	3563.25	1
2010	29	2	2900207	6.084871e+07	17072	3564.24	1
2010	22	2	2204006	1.864429e+07	5230	3564.87	1
2010	22	2	2208650	3.053823e+07	8565	3565.47	1
2010	27	2	2705002	8.810445e+07	24702	3566.69	1
2010	27	2	2701605	6.154872e+07	17248	3568.46	1
2010	15	1	1503101	1.0374361e+08	29060	3569.98	1
2010	15	1	1505601	2.810612e+07	7868	3572.21	1
2010	29	2	2904852	6.194641e+07	17327	3575.14	1
2010	22	2	2205524	1.92257e+07	5377	3575.54	1
2010	22	2	2202737	1.362678e+07	3811	3575.64	1
2010	22	2	2206803	2.937589e+07	8214	3576.32	1
2010	21	2	2101707	1.9670491e+08	54991	3577.04	1
2010	22	2	2209609	1.098431e+07	3069	3579.12	1
2010	22	2	2211704	1.532339e+07	4280	3580.23	1
2010	22	2	2206506	2.64637e+07	7391	3580.53	1
2010	22	2	2201739	2.1553e+07	6015	3583.21	1
2010	22	2	2201002	1.680106e+07	4688	3583.84	1
2010	21	2	2108504	1.1162946e+08	31145	3584.19	1
2010	23	2	2303006	7.175609e+07	20020	3584.22	1
2010	22	2	2204105	1.607745e+07	4483	3586.31	1
2010	21	2	2111953	1.653437e+07	4610	3586.63	1
2010	22	2	2206720	2.884407e+07	8039	3588.02	1
2010	22	2	2202778	2.668034e+07	7433	3589.44	1
2010	23	2	2313708	2.708905e+07	7545	3590.33	1
2010	23	2	2307502	1.116661e+08	31096	3591.01	1
2010	23	2	2311264	7.152715e+07	19918	3591.08	1
2010	22	2	2204709	5.339251e+07	14868	3591.1	1
2010	29	2	2905305	6.181443e+07	17212	3591.36	1
2010	29	2	2921807	4.483442e+07	12482	3591.93	1
2010	21	2	2105609	5.548936e+07	15437	3594.57	1
2010	22	2	2205565	1.626027e+07	4523	3595.02	1
2010	21	2	2112308	1.4134164e+08	39257	3600.42	1
2010	22	2	2210706	5.107496e+07	14185	3600.63	1
2010	26	2	2612901	5.021514e+07	13939	3602.49	1
2010	13	1	1303601	6.537631e+07	18133	3605.38	1
2010	26	2	2612471	4.244648e+07	11769	3606.63	1
2010	23	2	2304657	5.429315e+07	15052	3607.04	1
2010	29	2	2918605	2.876571e+07	7972	3608.34	1
2010	15	1	1503002	2.952056e+07	8181	3608.43	1
2010	21	2	2107506	3.7848203e+08	104881	3608.68	1
2010	21	2	2111805	6.137372e+07	17007	3608.73	1
2010	26	2	2614808	7.967576e+07	22073	3609.65	1
2010	31	3	3154507	3.382953e+07	9360	3614.27	1
2010	29	2	2917409	4.940336e+07	13656	3617.7	1
2010	23	2	2313252	3.225083e+07	8910	3619.62	1
2010	21	2	2111250	2.714676e+07	7496	3621.5	1
2010	15	1	1507474	7.476909e+07	20644	3621.83	1
2010	23	2	2303303	6.727958e+07	18567	3623.61	1
2010	27	2	2704203	9.782358e+07	26992	3624.17	1
2010	21	2	2105351	5.169797e+07	14264	3624.37	1
2010	21	2	2103554	5.230536e+07	14428	3625.27	1
2010	29	2	2913002	5.627417e+07	15519	3626.15	1
2010	23	2	2308377	4.641676e+07	12800	3626.31	1
2010	29	2	2911659	3.765498e+07	10383	3626.6	1
2010	27	2	2706208	1.855989e+07	5112	3630.65	1
2010	29	2	2931509	7.800587e+07	21484	3630.88	1
2010	29	2	2926806	5.374036e+07	14786	3634.54	1
2010	21	2	2107902	6.391278e+07	17576	3636.37	1
2010	31	3	3139250	2.299498e+07	6321	3637.87	1
2010	31	3	3146750	2.519885e+07	6925	3638.82	1
2010	29	2	2920304	3.076837e+07	8452	3640.37	1
2010	13	1	1300409	9.366283e+07	25715	3642.34	1
2010	21	2	2107357	6.972828e+07	19125	3645.92	1
2010	31	3	3143153	1.700795e+07	4664	3646.65	1
2010	22	2	2210508	4.976322e+07	13645	3646.99	1
2010	23	2	2309003	5.144678e+07	14102	3648.19	1
2010	13	1	1303304	7.808392e+07	21389	3650.66	1
2010	22	2	2209906	2.248811e+07	6157	3652.45	1
2010	23	2	2308906	7.562872e+07	20703	3653.03	1
2010	21	2	2107308	1.682326e+07	4600	3657.23	1
2010	23	2	2304004	8.053769e+07	22018	3657.81	1
2010	29	2	2914307	4.390388e+07	11988	3662.32	1
2010	21	2	2102150	3.864322e+07	10540	3666.34	1
2010	23	2	2313906	4.727596e+07	12894	3666.51	1
2010	31	3	3145307	1.1267847e+08	30726	3667.2	1
2010	29	2	2921401	5.986024e+07	16323	3667.23	1
2010	22	2	2205953	2.864796e+07	7810	3668.11	1
2010	27	2	2706422	3.758661e+07	10246	3668.42	1
2010	23	2	2312809	2.513825e+07	6852	3668.75	1
2010	13	1	1301654	5.164572e+07	14074	3669.58	1
2010	29	2	2902005	5.042221e+07	13732	3671.88	1
2010	22	2	2207850	1.346324e+07	3666	3672.46	1
2010	22	2	2209005	2.361251e+07	6429	3672.81	1
2010	22	2	2201919	1.948181e+07	5304	3673.04	1
2010	29	2	2928307	3.2281e+07	8781	3676.23	1
2010	29	2	2924801	8.241339e+07	22411	3677.36	1
2010	22	2	2202133	2.056453e+07	5592	3677.49	1
2010	21	2	2109759	2.599318e+07	7063	3680.19	1
2010	21	2	2112852	4.14326e+07	11258	3680.28	1
2010	29	2	2928505	3.557104e+07	9658	3683.07	1
2010	27	2	2705408	2.558071e+07	6944	3683.86	1
2010	23	2	2312007	1.1054324e+08	29977	3687.6	1
2010	22	2	2202851	1.674684e+07	4541	3687.92	1
2010	21	2	2105203	4.075841e+07	11047	3689.55	1
2010	22	2	2205003	4.09505e+07	11099	3689.57	1
2010	13	1	1300680	5.507577e+07	14921	3691.16	1
2010	29	2	2923704	1.0881661e+08	29475	3691.83	1
2010	29	2	2902609	7.414247e+07	20069	3694.38	1
2010	23	2	2301802	2.226814e+07	6026	3695.34	1
2010	31	3	3165552	4.024682e+07	10885	3697.46	1
2010	15	1	1502608	4.209434e+07	11382	3698.33	1
2010	22	2	2204808	3.450517e+07	9326	3699.89	1
2010	23	2	2308807	2.98694e+07	8069	3701.75	1
2010	29	2	2922706	6.198069e+07	16727	3705.43	1
2010	26	2	2609154	6.747618e+07	18187	3710.13	1
2010	22	2	2209872	2.083005e+07	5608	3714.35	1
2010	23	2	2304905	3.799956e+07	10228	3715.25	1
2010	29	2	2903003	5.202498e+07	13997	3716.87	1
2010	23	2	2308500	1.5875766e+08	42707	3717.37	1
2010	22	2	2204154	1.070545e+07	2879	3718.46	1
2010	29	2	2926905	4.436363e+07	11923	3720.84	1
2010	29	2	2927903	3.856437e+07	10363	3721.35	1
2010	29	2	2923308	3.083994e+07	8287	3721.48	1
2010	29	2	2912608	1.813449e+07	4865	3727.54	1
2010	29	2	2915353	4.92439e+07	13209	3728.06	1
2010	25	2	2509008	4.011428e+07	10759	3728.44	1
2010	21	2	2112803	1.8440243e+08	49452	3728.92	1
2010	22	2	2207900	1.3984166e+08	37500	3729.11	1
2010	23	2	2303105	6.850561e+07	18348	3733.68	1
2010	26	2	2601052	6.77484e+07	18144	3733.93	1
2010	31	3	3135357	3.101749e+07	8305	3734.8	1
2010	22	2	2207355	1.257287e+07	3366	3735.26	1
2010	29	2	2904803	4.276627e+07	11448	3735.7	1
2010	15	1	1506195	1.4974511e+08	40068	3737.27	1
2010	31	3	3135456	2.659931e+07	7117	3737.43	1
2010	22	2	2202539	2.06388e+07	5522	3737.56	1
2010	29	2	2912400	6.361703e+07	17021	3737.56	1
2010	29	2	2903508	5.993573e+07	16026	3739.91	1
2010	26	2	2612554	4.985063e+07	13322	3741.98	1
2010	29	2	2903706	5.766931e+07	15409	3742.57	1
2010	26	2	2605608	8.301611e+07	22171	3744.36	1
2010	22	2	2210391	1.11439e+07	2976	3744.59	1
2010	22	2	2205599	1.817334e+07	4853	3744.76	1
2010	22	2	2210201	2.47505e+07	6608	3745.54	1
2010	23	2	2308609	6.257657e+07	16706	3745.75	1
2010	21	2	2101608	3.0978957e+08	82692	3746.31	1
2010	13	1	1302801	6.505395e+07	17364	3746.48	1
2010	27	2	2707107	8.637237e+07	23052	3746.85	1
2010	29	2	2929255	6.909921e+07	18419	3751.52	1
2010	23	2	2311959	5.798694e+07	15453	3752.47	1
2010	31	3	3130051	4.031636e+07	10737	3754.9	1
2010	21	2	2102325	2.4498233e+08	65226	3755.9	1
2010	29	2	2917003	1.3569314e+08	36112	3757.56	1
2010	29	2	2906600	4.96273e+07	13205	3758.22	1
2010	27	2	2704609	3.861962e+07	10276	3758.23	1
2010	15	1	1508209	1.8017412e+08	47902	3761.31	1
2010	22	2	2202109	2.033784e+07	5406	3762.09	1
2010	21	2	2108454	7.62757e+07	20274	3762.24	1
2010	22	2	2208809	6.619345e+07	17576	3766.13	1
2010	22	2	2201988	1.452184e+07	3852	3769.95	1
2010	22	2	2210300	2.140665e+07	5677	3770.77	1
2010	22	2	2207751	1.714399e+07	4546	3771.23	1
2010	29	2	2902658	4.456142e+07	11811	3772.87	1
2010	26	2	2604304	4.067764e+07	10778	3774.14	1
2010	26	2	2606903	4.446749e+07	11780	3774.83	1
2010	15	1	1504406	1.0043022e+08	26605	3774.86	1
2010	23	2	2305332	4.279009e+07	11335	3775.04	1
2010	22	2	2204204	3.253905e+07	8619	3775.27	1
2010	25	2	2514453	2.079568e+07	5508	3775.54	1
2010	22	2	2200954	9.22069e+06	2442	3775.88	1
2010	15	1	1507904	8.684742e+07	22995	3776.8	1
2010	23	2	2310506	1.5842178e+08	41942	3777.16	1
2010	29	2	2926400	1.1577787e+08	30651	3777.3	1
2010	29	2	2929800	4.477781e+07	11847	3779.67	1
2010	29	2	2901304	5.272636e+07	13948	3780.21	1
2010	29	2	2913408	5.746918e+07	15194	3782.36	1
2010	23	2	2306108	8.452516e+07	22347	3782.39	1
2010	22	2	2208700	3.179307e+07	8403	3783.54	1
2010	22	2	2204600	1.427109e+07	3771	3784.43	1
2010	22	2	2208601	1.167525e+07	3085	3784.52	1
2010	22	2	2202711	1.7126e+07	4525	3784.75	1
2010	23	2	2310308	1.1859164e+08	31320	3786.45	1
2010	29	2	2901155	6.040406e+07	15952	3786.61	1
2010	23	2	2307205	2.897461e+07	7649	3788.03	1
2010	21	2	2106672	3.079521e+07	8118	3793.45	1
2010	23	2	2303907	4.789512e+07	12617	3796.08	1
2010	22	2	2206001	1.691854e+07	4456	3796.8	1
2010	24	2	2403509	3.979273e+07	10480	3797.02	1
2010	23	2	2303204	1.0020263e+08	26387	3797.42	1
2010	22	2	2203859	9.42663e+06	2482	3798	1
2010	22	2	2201200	1.7048563e+08	44850	3801.24	1
2010	22	2	2200608	2.536294e+07	6670	3802.54	1
2010	21	2	2113009	1.2049355e+08	31654	3806.58	1
2010	27	2	2700102	7.377374e+07	19376	3807.48	1
2010	29	2	2914109	3.539795e+07	9290	3810.33	1
2010	21	2	2105708	1.7572026e+08	46108	3811.06	1
2010	13	1	1303007	6.966439e+07	18278	3811.38	1
2010	27	2	2706000	4.214538e+07	11057	3811.65	1
2010	23	2	2303402	6.387658e+07	16746	3814.44	1
2010	29	2	2924058	5.246243e+07	13752	3814.89	1
2010	22	2	2205532	1.723403e+07	4517	3815.37	1
2010	22	2	2201556	1.441604e+07	3778	3815.79	1
2010	15	1	1506302	7.701837e+07	20184	3815.81	1
2010	31	3	3131158	6.369996e+07	16692	3816.2	1
2010	25	2	2515401	3.904241e+07	10230	3816.46	1
2010	15	1	1506559	7.413519e+07	19422	3817.07	1
2010	15	1	1503200	1.368194e+08	35843	3817.19	1
2010	21	2	2109205	4.40914e+07	11537	3821.74	1
2010	22	2	2200277	1.968692e+07	5151	3821.96	1
2010	13	1	1300060	3.694084e+07	9657	3825.29	1
2010	29	2	2905909	1.0745894e+08	28091	3825.39	1
2010	23	2	2305902	1.4521399e+08	37874	3834.13	1
2010	31	3	3157658	2.321811e+07	6055	3834.54	1
2010	29	2	2905503	4.791386e+07	12485	3837.71	1
2010	29	2	2924900	3.386512e+07	8822	3838.71	1
2010	15	1	1502004	7.8541e+07	20460	3838.76	1
2010	22	2	2210953	1.0586e+07	2755	3842.47	1
2010	27	2	2709004	2.352943e+07	6122	3843.42	1
2010	29	2	2928950	3.544286e+07	9221	3843.71	1
2010	31	3	3127073	2.284461e+07	5940	3845.89	1
2010	29	2	2914208	2.693823e+07	7002	3847.22	1
2010	23	2	2310902	5.964097e+07	15501	3847.56	1
2010	23	2	2301604	8.63702e+07	22448	3847.57	1
2010	29	2	2907608	6.554266e+07	17027	3849.34	1
2010	15	1	1502905	1.3277077e+08	34490	3849.54	1
2010	15	1	1500701	9.537583e+07	24771	3850.3	1
2010	26	2	2601805	4.62269e+07	12005	3850.64	1
2010	29	2	2921609	3.192938e+07	8285	3853.88	1
2010	23	2	2304277	2.641897e+07	6853	3855.1	1
2010	21	2	2105963	4.064313e+07	10536	3857.55	1
2010	21	2	2110807	1.808964e+07	4688	3858.71	1
2010	26	2	2611533	2.59902e+07	6735	3858.98	1
2010	29	2	2923209	8.43397e+07	21839	3861.88	1
2010	15	1	1505908	1.3139239e+08	33951	3870.06	1
2010	23	2	2313203	9.855151e+07	25455	3871.6	1
2010	31	3	3136520	1.772943e+07	4577	3873.59	1
2010	29	2	2919603	4.35223e+07	11229	3875.88	1
2010	29	2	2913507	9.980911e+07	25724	3880	1
2010	13	1	1300904	4.939364e+07	12727	3881.01	1
2010	23	2	2301208	9.87485e+07	25405	3886.97	1
2010	25	2	2513109	4.656531e+07	11976	3888.22	1
2010	29	2	2910859	6.512581e+07	16749	3888.34	1
2010	29	2	2930600	4.802255e+07	12347	3889.41	1
2010	26	2	2602506	2.845025e+07	7307	3893.56	1
2010	26	2	2605806	5.543498e+07	14231	3895.37	1
2010	22	2	2209153	1.478335e+07	3794	3896.51	1
2010	25	2	2506707	4.424677e+07	11352	3897.71	1
2010	22	2	2202455	1.51085e+07	3876	3897.96	1
2010	29	2	2913309	2.048394e+07	5255	3897.99	1
2010	29	2	2931103	3.124103e+07	8008	3901.23	1
2010	22	2	2207207	2.594929e+07	6651	3901.56	1
2010	29	2	2909703	5.184064e+07	13280	3903.66	1
2010	22	2	2202251	1.532396e+07	3922	3907.18	1
2010	29	2	2932408	5.335462e+07	13655	3907.33	1
2010	21	2	2111532	4.699093e+07	12025	3907.77	1
2010	26	2	2605400	8.052683e+07	20588	3911.35	1
2010	15	1	1502509	8.2705e+07	21138	3912.62	1
2010	15	1	1501808	3.6343958e+08	92865	3913.63	1
2010	21	2	2108009	7.083543e+07	18079	3918.11	1
2010	29	2	2927606	5.901522e+07	15059	3918.93	1
2010	29	2	2904209	4.374323e+07	11162	3918.94	1
2010	22	2	2201176	1.509701e+07	3852	3919.27	1
2010	29	2	2923407	8.144739e+07	20779	3919.7	1
2010	22	2	2208858	1.661825e+07	4238	3921.25	1
2010	22	2	2211407	1.701135e+07	4336	3923.28	1
2010	21	2	2107407	7.2604e+07	18505	3923.48	1
2010	29	2	2922904	9.475805e+07	24132	3926.66	1
2010	15	1	1502103	4.7501073e+08	120904	3928.83	1
2010	26	2	2607703	5.454349e+07	13882	3929.08	1
2010	31	3	3160454	2.726106e+07	6938	3929.24	1
2010	23	2	2310803	6.196199e+07	15764	3930.6	1
2010	29	2	2900405	6.18258e+07	15726	3931.44	1
2010	22	2	2203800	1.717591e+07	4368	3932.21	1
2010	21	2	2101004	1.1198476e+08	28477	3932.46	1
2010	21	2	2103406	1.8432776e+08	46792	3939.3	1
2010	29	2	2930154	1.2479326e+08	31646	3943.41	1
2010	21	2	2100436	9.71045e+07	24596	3947.98	1
2010	29	2	2907905	6.2261e+07	15764	3949.57	1
2010	26	2	2612455	5.371164e+07	13594	3951.13	1
2010	26	2	2600807	8.840108e+07	22363	3953.01	1
2010	23	2	2301703	9.715222e+07	24573	3953.62	1
2010	13	1	1300102	6.442401e+07	16289	3955.06	1
2010	23	2	2304269	3.596848e+07	9094	3955.19	1
2010	15	1	1504307	1.1232176e+08	28376	3958.34	1
2010	26	2	2606507	7.234049e+07	18271	3959.31	1
2010	22	2	2206654	1.610703e+07	4068	3959.45	1
2010	29	2	2908705	6.68703e+07	16888	3959.63	1
2010	15	1	1506906	2.433459e+07	6145	3960.06	1
2010	26	2	2608701	6.184144e+07	15615	3960.39	1
2010	29	2	2906808	1.3039402e+08	32923	3960.58	1
2010	23	2	2304301	7.530098e+07	19007	3961.75	1
2010	29	2	2907707	4.25515e+07	10734	3964.18	1
2010	29	2	2919405	4.883965e+07	12320	3964.26	1
2010	22	2	2205201	7.140806e+07	18008	3965.35	1
2010	29	2	2922201	2.899385e+07	7310	3966.33	1
2010	25	2	2509909	4.19474e+07	10566	3970.04	1
2010	26	2	2602605	1.7942701e+08	45192	3970.33	1
2010	31	3	3149150	4.095178e+07	10310	3972.04	1
2010	22	2	2204659	3.542061e+07	8914	3973.59	1
2010	21	2	2112274	2.228163e+07	5607	3973.9	1
2010	22	2	2200509	6.812905e+07	17141	3974.62	1
2010	21	2	2104206	6.007346e+07	15108	3976.27	1
2010	21	2	2103505	1.5574755e+08	39167	3976.5	1
2010	31	3	3140555	3.133865e+07	7880	3976.99	1
2010	31	3	3155207	2.418159e+07	6078	3978.54	1
2010	22	2	2206951	1.297175e+07	3260	3979.06	1
2010	24	2	2400604	1.944035e+07	4880	3983.68	1
2010	23	2	2301505	3.050613e+07	7657	3984.08	1
2010	27	2	2706406	9.490038e+07	23809	3985.9	1
2010	23	2	2302057	5.770035e+07	14475	3986.21	1
2010	13	1	1303957	4.261281e+07	10688	3986.98	1
2010	23	2	2304236	6.815351e+07	17077	3990.95	1
2010	24	2	2403301	2.087499e+07	5228	3992.92	1
2010	27	2	2701506	3.607543e+07	9032	3994.18	1
2010	24	2	2407708	4.562889e+07	11418	3996.22	1
2010	29	2	2933158	5.248197e+07	13127	3998.02	1
2010	22	2	2200905	2.312481e+07	5781	4000.14	1
2010	26	2	2603926	4.715489e+07	11782	4002.28	1
2010	22	2	2204352	2.193687e+07	5475	4006.73	1
2010	31	3	3145356	4.144343e+07	10342	4007.29	1
2010	21	2	2102002	1.5666039e+08	39093	4007.38	1
2010	29	2	2920106	7.751374e+07	19335	4008.99	1
2010	25	2	2516409	4.118371e+07	10263	4012.83	1
2010	23	2	2314102	2.2061857e+08	54961	4014.09	1
2010	26	2	2603702	9.851909e+07	24536	4015.29	1
2010	23	2	2300804	2.805263e+07	6984	4016.7	1
2010	22	2	2201804	1.745848e+07	4346	4017.14	1
2010	23	2	2306603	7.595074e+07	18894	4019.83	1
2010	26	2	2614006	7.374443e+07	18331	4022.94	1
2010	31	3	3156502	3.129092e+07	7777	4023.52	1
2010	21	2	2109601	1.5932499e+08	39582	4025.19	1
2010	22	2	2211506	1.202732e+07	2987	4026.55	1
2010	25	2	2507606	3.00343e+07	7459	4026.59	1
2010	27	2	2700706	6.877665e+07	17076	4027.68	1
2010	26	2	2612109	3.74268e+07	9287	4030.02	1
2010	29	2	2932002	9.795193e+07	24302	4030.61	1
2010	21	2	2109270	6.912869e+07	17143	4032.47	1
2010	29	2	2920403	5.80331e+07	14390	4032.88	1
2010	26	2	2608602	4.888724e+07	12121	4033.27	1
2010	22	2	2203107	4.025622e+07	9981	4033.29	1
2010	26	2	2610202	1.0349545e+08	25654	4034.28	1
2010	22	2	2207603	4.143292e+07	10265	4036.33	1
2010	21	2	2104073	3.277671e+07	8120	4036.54	1
2010	21	2	2102101	1.3450012e+08	33314	4037.35	1
2010	29	2	2924652	4.177759e+07	10345	4038.43	1
2010	29	2	2924678	3.973308e+07	9835	4039.97	1
2010	23	2	2307106	1.0786746e+08	26697	4040.43	1
2010	21	2	2106409	6.111666e+07	15123	4041.31	1
2010	31	3	3127503	2.393627e+07	5919	4043.97	1
2010	31	3	3162401	1.0259391e+08	25362	4045.18	1
2010	24	2	2412906	4.397326e+07	10868	4046.12	1
2010	22	2	2207108	1.064205e+07	2630	4046.41	1
2010	29	2	2928406	1.0627236e+08	26261	4046.77	1
2010	26	2	2615805	9.819197e+07	24254	4048.49	1
2010	25	2	2514305	2.433399e+07	6010	4048.92	1
2010	22	2	2203206	4.361532e+07	10765	4051.59	1
2010	29	2	2910305	3.222827e+07	7952	4052.85	1
2010	21	2	2108108	8.144551e+07	20087	4054.64	1
2010	31	3	3170008	4.735825e+07	11677	4055.69	1
2010	22	2	2208205	7.183286e+07	17693	4059.96	1
2010	29	2	2908309	7.272311e+07	17895	4063.88	1
2010	31	3	3144656	3.981255e+07	9795	4064.58	1
2010	31	3	3129657	2.502682e+07	6155	4066.1	1
2010	29	2	2915007	6.071895e+07	14932	4066.36	1
2010	23	2	2301950	7.97054e+07	19574	4072	1
2010	25	2	2511509	4.558735e+07	11191	4073.57	1
2010	22	2	2210052	2.094282e+07	5141	4073.69	1
2010	29	2	2906204	9.803674e+07	24055	4075.52	1
2010	21	2	2111409	8.214876e+07	20156	4075.65	1
2010	22	2	2205151	2.33186e+07	5719	4077.39	1
2010	22	2	2203503	5.920221e+07	14499	4083.19	1
2010	25	2	2500908	5.167113e+07	12653	4083.71	1
2010	26	2	2603900	7.590914e+07	18585	4084.43	1
2010	29	2	2925600	5.619332e+07	13756	4085	1
2010	23	2	2302909	6.97083e+07	17063	4085.35	1
2010	22	2	2210979	1.070779e+07	2621	4085.38	1
2010	29	2	2925907	1.1130052e+08	27243	4085.47	1
2010	15	1	1503309	2.3708237e+08	58023	4086.01	1
2010	29	2	2928000	1.3817967e+08	33816	4086.22	1
2010	24	2	2413300	2.34815e+07	5746	4086.58	1
2010	31	3	3133907	2.37001e+07	5798	4087.63	1
2010	31	3	3166956	1.809119e+07	4425	4088.4	1
2010	26	2	2616100	3.741925e+07	9142	4093.11	1
2010	25	2	2501203	2.64843e+07	6470	4093.4	1
2010	25	2	2503555	2.789685e+07	6814	4094.05	1
2010	21	2	2106706	8.377518e+07	20434	4099.79	1
2010	22	2	2205706	1.1653821e+08	28422	4100.28	1
2010	26	2	2602001	1.4432328e+08	35178	4102.66	1
2010	23	2	2304806	1.899268e+07	4626	4105.64	1
2010	15	1	1504901	1.4060397e+08	34237	4106.78	1
2010	13	1	1300607	1.3714114e+08	33391	4107.13	1
2010	27	2	2702009	4.489355e+07	10926	4108.87	1
2010	25	2	2508505	2.944967e+07	7164	4110.79	1
2010	27	2	2701209	4.193716e+07	10197	4112.7	1
2010	22	2	2200400	1.5970168e+08	38823	4113.58	1
2010	25	2	2513000	1.443517e+07	3508	4114.93	1
2010	24	2	2410108	5.742176e+07	13947	4117.14	1
2010	26	2	2605905	1.1498764e+08	27915	4119.21	1
2010	15	1	1505007	5.629598e+07	13660	4121.23	1
2010	23	2	2304251	9.264522e+07	22480	4121.23	1
2010	25	2	2517209	2.080233e+07	5045	4123.36	1
2010	25	2	2500502	5.602731e+07	13577	4126.63	1
2010	31	3	3143450	3.083718e+07	7472	4127.03	1
2010	15	1	1506401	3.369844e+07	8163	4128.19	1
2010	29	2	2913101	7.363701e+07	17832	4129.49	1
2010	25	2	2502102	2.376956e+07	5751	4133.12	1
2010	27	2	2705903	2.048958e+07	4957	4133.46	1
2010	15	1	1507508	5.439824e+07	13149	4137.06	1
2010	23	2	2307635	7.482958e+07	18085	4137.66	1
2010	15	1	1500107	5.8379345e+08	141054	4138.79	1
2010	25	2	2514800	1.649946e+07	3985	4140.39	1
2010	22	2	2207306	1.680703e+07	4059	4140.68	1
2010	29	2	2926509	5.907878e+07	14267	4140.94	1
2010	29	2	2930204	1.5505942e+08	37431	4142.54	1
2010	31	3	3117836	2.936693e+07	7089	4142.6	1
2010	25	2	2501302	7.911592e+07	19089	4144.58	1
2010	25	2	2508000	4.072657e+07	9826	4144.78	1
2010	29	2	2925808	1.0189576e+08	24583	4144.97	1
2010	13	1	1300029	5.836468e+07	14080	4145.22	1
2010	24	2	2402105	4.255568e+07	10266	4145.3	1
2010	21	2	2109239	2.641209e+07	6370	4146.32	1
2010	31	3	3170909	7.934153e+07	19126	4148.36	1
2010	21	2	2111029	5.110054e+07	12315	4149.46	1
2010	13	1	1304401	7.358824e+07	17731	4150.26	1
2010	26	2	2606101	1.232072e+08	29675	4151.89	1
2010	29	2	2900108	3.456438e+07	8324	4152.38	1
2010	31	3	3136504	4.284907e+07	10319	4152.44	1
2010	23	2	2301307	8.591891e+07	20689	4152.88	1
2010	29	2	2911857	5.170274e+07	12444	4154.83	1
2010	31	3	3160306	4.900733e+07	11780	4160.21	1
2010	23	2	2312106	7.149396e+07	17181	4161.22	1
2010	23	2	2311108	6.274847e+07	15065	4165.18	1
2010	15	1	1501600	5.678823e+07	13630	4166.41	1
2010	27	2	2703106	1.0498926e+08	25197	4166.74	1
2010	23	2	2305209	8.059979e+07	19342	4167.09	1
2010	29	2	2930907	4.763534e+07	11428	4168.3	1
2010	29	2	2932804	7.585573e+07	18193	4169.5	1
2010	23	2	2300309	2.1340249e+08	51171	4170.38	1
2010	15	1	1506351	7.154531e+07	17154	4170.77	1
2010	27	2	2708204	2.806877e+07	6720	4176.9	1
2010	31	3	3171600	5.693974e+07	13625	4179.06	1
2010	26	2	2615201	3.870037e+07	9256	4181.11	1
2010	13	1	1303106	1.286367e+08	30761	4181.81	1
2010	29	2	2923605	8.792675e+07	20998	4187.39	1
2010	23	2	2305704	5.031319e+07	12014	4187.88	1
2010	31	3	3116308	2.742122e+07	6547	4188.36	1
2010	15	1	1508308	2.3750891e+08	56681	4190.27	1
2010	29	2	2919157	1.0756468e+08	25651	4193.39	1
2010	21	2	2104677	1.0654025e+08	25402	4194.17	1
2010	29	2	2906824	6.608319e+07	15755	4194.43	1
2010	31	3	3137007	7.13145e+07	16999	4195.22	1
2010	23	2	2304350	9.146594e+07	21786	4198.38	1
2010	29	2	2904407	4.672615e+07	11127	4199.35	1
2010	25	2	2506251	3.517827e+07	8376	4199.89	1
2010	23	2	2311231	2.575042e+07	6129	4201.41	1
2010	27	2	2703809	9.488669e+07	22581	4202.06	1
2010	26	2	2608107	1.2916129e+08	30735	4202.42	1
2010	29	2	2909505	2.118983e+07	5042	4202.66	1
2010	25	2	2514602	1.360648e+07	3233	4208.62	1
2010	26	2	2600500	1.6844356e+08	40007	4210.35	1
2010	31	3	3132305	4.968832e+07	11798	4211.59	1
2010	22	2	2210383	8.89948e+06	2113	4211.77	1
2010	29	2	2930758	5.077272e+07	12051	4213.15	1
2010	31	3	3153103	2.332951e+07	5537	4213.39	1
2010	29	2	2903607	6.257167e+07	14833	4218.41	1
2010	29	2	2933109	3.654956e+07	8664	4218.55	1
2010	22	2	2208304	1.1621869e+08	27548	4218.77	1
2010	22	2	2203701	1.5934574e+08	37765	4219.4	1
2010	23	2	2310407	4.772237e+07	11308	4220.23	1
2010	21	2	2104099	7.503827e+07	17780	4220.37	1
2010	13	1	1301605	9.566197e+07	22659	4221.81	1
2010	29	2	2925006	1.0345554e+08	24497	4223.19	1
2010	13	1	1303502	7.668617e+07	18153	4224.43	1
2010	31	3	3108701	1.965813e+07	4650	4227.56	1
2010	29	2	2905107	4.391825e+07	10376	4232.68	1
2010	23	2	2308104	1.8716394e+08	44217	4232.85	1
2010	25	2	2503506	7.101481e+07	16755	4238.43	1
2010	25	2	2501575	3.478261e+07	8205	4239.2	1
2010	23	2	2303808	1.0413199e+08	24538	4243.7	1
2010	23	2	2306207	3.107457e+07	7321	4244.58	1
2010	25	2	2500106	4.011029e+07	9449	4244.92	1
2010	24	2	2412302	5.246819e+07	12359	4245.34	1
2010	15	1	1507979	7.198433e+07	16952	4246.36	1
2010	15	1	1504109	3.447081e+07	8115	4247.79	1
2010	25	2	2505352	2.081455e+07	4900	4247.87	1
2010	31	3	3115409	1.470882e+07	3462	4248.65	1
2010	31	3	3118106	2.102492e+07	4947	4250.03	1
2010	25	2	2509156	2.625324e+07	6173	4252.91	1
2010	29	2	2922730	3.234727e+07	7602	4255.1	1
2010	22	2	2202752	2.56864e+07	6035	4256.24	1
2010	29	2	2929354	2.433412e+07	5715	4257.94	1
2010	29	2	2916203	4.678754e+07	10986	4258.83	1
2010	29	2	2922102	1.040033e+08	24419	4259.11	1
2010	29	2	2931004	8.535267e+07	20022	4262.94	1
2010	31	3	3153905	6.542304e+07	15345	4263.48	1
2010	27	2	2707602	4.897427e+07	11486	4263.82	1
2010	26	2	2607000	8.152011e+07	19081	4272.32	1
2010	23	2	2311207	4.39039e+07	10276	4272.47	1
2010	23	2	2309904	2.558153e+07	5986	4273.56	1
2010	26	2	2614709	5.431132e+07	12704	4275.14	1
2010	29	2	2925253	6.729517e+07	15741	4275.15	1
2010	29	2	2924207	7.265934e+07	16995	4275.34	1
2010	25	2	2509503	2.13375e+07	4990	4276.05	1
2010	24	2	2403202	2.777308e+07	6495	4276.07	1
2010	24	2	2409308	5.117235e+07	11964	4277.19	1
2010	23	2	2300150	6.566211e+07	15337	4281.29	1
2010	24	2	2406502	5.990383e+07	13990	4281.9	1
2010	21	2	2102556	5.729045e+07	13369	4285.32	1
2010	22	2	2207934	1.032797e+07	2410	4285.47	1
2010	15	1	1505700	1.1142583e+08	25989	4287.42	1
2010	26	2	2614600	1.1340027e+08	26430	4290.59	1
2010	26	2	2600401	1.4181875e+08	33046	4291.56	1
2010	31	3	3122207	3.020176e+07	7036	4292.46	1
2010	23	2	2308302	1.2156264e+08	28317	4292.92	1
2010	24	2	2408805	2.080003e+07	4845	4293.09	1
2010	29	2	2908606	1.0130778e+08	23594	4293.79	1
2010	21	2	2104305	4.567458e+07	10635	4294.74	1
2010	15	1	1507706	9.832359e+07	22890	4295.48	1
2010	26	2	2612703	5.59504e+07	13023	4296.28	1
2010	25	2	2515104	4.74359e+07	11041	4296.34	1
2010	21	2	2110856	4.3952e+07	10226	4298.06	1
2010	25	2	2508109	2.011927e+07	4681	4298.07	1
2010	27	2	2705804	3.651123e+07	8491	4299.99	1
2010	29	2	2912004	4.33364e+07	10077	4300.53	1
2010	26	2	2602803	2.2374955e+08	51990	4303.7	1
2010	25	2	2502003	3.074406e+07	7143	4304.08	1
2010	31	3	3106507	5.297975e+07	12307	4304.85	1
2010	25	2	2514552	1.817639e+07	4219	4308.22	1
2010	31	3	3146552	2.556874e+07	5934	4308.85	1
2010	29	2	2927101	3.351885e+07	7779	4308.89	1
2010	26	2	2601508	4.890495e+07	11349	4309.19	1
2010	24	2	2414753	1.647013e+07	3821	4310.42	1
2010	13	1	1300508	1.1798269e+08	27361	4312.08	1
2010	25	2	2512804	3.586526e+07	8314	4313.84	1
2010	26	2	2601300	5.506877e+07	12765	4314.04	1
2010	24	2	2413102	2.436208e+07	5645	4315.69	1
2010	26	2	2612307	6.596256e+07	15283	4316.07	1
2010	25	2	2505204	2.976007e+07	6889	4319.94	1
2010	25	2	2505709	4.546578e+07	10517	4323.07	1
2010	24	2	2405108	2.939354e+07	6796	4325.12	1
2010	25	2	2506608	2.608895e+07	6031	4325.81	1
2010	31	3	3147956	2.421348e+07	5594	4328.47	1
2010	23	2	2307403	1.0316947e+08	23809	4333.21	1
2010	26	2	2610509	1.2426034e+08	28664	4335.07	1
2010	23	2	2304954	1.0447929e+08	24091	4336.86	1
2010	25	2	2513158	2.889455e+07	6661	4337.87	1
2010	25	2	2514107	1.907123e+07	4396	4338.31	1
2010	29	2	2910909	2.336625e+07	5385	4339.14	1
2010	26	2	2603405	2.453459e+07	5651	4341.64	1
2010	21	2	2102036	1.2354735e+08	28456	4341.7	1
2010	29	2	2902104	2.2418945e+08	51636	4341.73	1
2010	31	3	3128204	4.438581e+07	10223	4341.76	1
2010	23	2	2310001	3.850722e+07	8869	4341.78	1
2010	29	2	2923100	1.0833804e+08	24943	4343.42	1
2010	29	2	2933604	1.9797315e+08	45562	4345.14	1
2010	25	2	2513356	1.538379e+07	3539	4346.93	1
2010	29	2	2926301	1.4381563e+08	33081	4347.38	1
2010	25	2	2511806	4.486169e+07	10319	4347.48	1
2010	29	2	2929370	4.440147e+07	10213	4347.54	1
2010	22	2	2202653	2.191541e+07	5039	4349.16	1
2010	26	2	2614303	4.848046e+07	11137	4353.1	1
2010	31	3	3130655	3.189529e+07	7327	4353.12	1
2010	26	2	2608404	6.3128e+07	14494	4355.46	1
2010	29	2	2920205	6.973504e+07	16008	4356.26	1
2010	26	2	2604700	7.59043e+07	17421	4357.06	1
2010	31	3	3109253	1.73867e+07	3990	4357.57	1
2010	29	2	2907806	1.408035e+08	32304	4358.7	1
2010	13	1	1303809	1.6258317e+08	37300	4358.8	1
2010	17	1	1720200	4.573146e+07	10490	4359.53	1
2010	25	2	2510402	3.024063e+07	6931	4363.1	1
2010	23	2	2314003	1.6774456e+08	38442	4363.58	1
2010	23	2	2313005	7.710724e+07	17657	4366.95	1
2010	25	2	2510204	2.650845e+07	6070	4367.13	1
2010	21	2	2101939	2.619023e+07	5996	4367.95	1
2010	21	2	2106326	8.363456e+07	19142	4369.17	1
2010	22	2	2210102	1.617043e+07	3700	4370.39	1
2010	29	2	2923506	3.674759e+07	8408	4370.55	1
2010	25	2	2508554	1.723122e+07	3942	4371.19	1
2010	31	3	3141702	2.654556e+07	6072	4371.8	1
2010	29	2	2917201	7.927983e+07	18127	4373.58	1
2010	26	2	2614402	2.515876e+07	5744	4380.01	1
2010	29	2	2932309	1.0959408e+08	25015	4381.13	1
2010	31	3	3166501	1.849271e+07	4220	4382.16	1
2010	26	2	2613503	1.4304073e+08	32620	4385.06	1
2010	31	3	3136009	6.548096e+07	14930	4385.86	1
2010	21	2	2103752	5.505584e+07	12551	4386.57	1
2010	22	2	2209757	1.239774e+07	2825	4388.58	1
2010	26	2	2608008	6.938661e+07	15810	4388.78	1
2010	31	3	3127057	2.057447e+07	4687	4389.69	1
2010	29	2	2918209	6.184911e+07	14087	4390.51	1
2010	13	1	1301506	7.169025e+07	16328	4390.63	1
2010	24	2	2405306	3.95573e+07	9009	4390.86	1
2010	23	2	2302404	2.3069748e+08	52521	4392.48	1
2010	26	2	2610301	4.832289e+07	11001	4392.59	1
2010	29	2	2911253	2.003493e+07	4561	4392.66	1
2010	24	2	2400307	4.783508e+07	10879	4397.01	1
2010	24	2	2400901	3.037589e+07	6907	4397.84	1
2010	15	1	1507466	2.315505e+07	5265	4397.92	1
2010	27	2	2702900	1.6113916e+08	36625	4399.7	1
2010	31	3	3134004	6.344184e+07	14407	4403.54	1
2010	25	2	2505600	2.913537e+07	6616	4403.77	1
2010	29	2	2911501	3.675062e+07	8344	4404.44	1
2010	13	1	1301100	1.437266e+08	32631	4404.6	1
2010	25	2	2510006	3.206923e+07	7280	4405.11	1
2010	25	2	2512036	1.654337e+07	3752	4409.21	1
2010	26	2	2615706	6.619828e+07	15006	4411.45	1
2010	23	2	2302008	9.497547e+07	21528	4411.72	1
2010	25	2	2508703	1.773315e+07	4019	4412.33	1
2010	26	2	2616209	8.066058e+07	18267	4415.64	1
2010	13	1	1304104	8.43592e+07	19077	4422.04	1
2010	22	2	2203602	2.064333e+07	4667	4423.25	1
2010	29	2	2902302	3.800045e+07	8590	4423.8	1
2010	25	2	2502607	2.723646e+07	6156	4424.38	1
2010	31	3	3158102	2.341868e+07	5293	4424.46	1
2010	21	2	2112233	8.385299e+07	18951	4424.73	1
2010	31	3	3156007	6.039871e+07	13648	4425.46	1
2010	25	2	2509602	1.995649e+07	4508	4426.9	1
2010	29	2	2920809	4.652579e+07	10508	4427.65	1
2010	24	2	2401701	4.178594e+07	9432	4430.23	1
2010	21	2	2105989	3.067912e+07	6923	4431.48	1
2010	29	2	2908804	2.066966e+07	4663	4432.69	1
2010	29	2	2902203	4.452557e+07	10039	4435.26	1
2010	29	2	2909604	8.896536e+07	20056	4435.85	1
2010	29	2	2930006	4.601099e+07	10372	4436.08	1
2010	26	2	2610103	3.632856e+07	8188	4436.81	1
2010	21	2	2106359	3.569713e+07	8045	4437.18	1
2010	15	1	1507805	5.77363e+07	12998	4441.94	1
2010	25	2	2509800	4.207432e+07	9469	4443.38	1
2010	21	2	2112407	1.5095428e+08	33956	4445.58	1
2010	25	2	2502052	1.367771e+07	3075	4448.04	1
2010	26	2	2611200	5.000507e+07	11242	4448.06	1
2010	31	3	3142007	5.802287e+07	13043	4448.58	1
2010	29	2	2910206	1.723742e+07	3873	4450.66	1
2010	31	3	3150570	3.212497e+07	7215	4452.52	1
2010	31	3	3136959	2.544266e+07	5708	4457.37	1
2010	29	2	2931905	2.3360236e+08	52391	4458.83	1
2010	26	2	2605301	1.4117863e+08	31636	4462.59	1
2010	25	2	2517001	4.151672e+07	9300	4464.16	1
2010	25	2	2505402	3.568197e+07	7991	4465.27	1
2010	25	2	2516607	6.298585e+07	14103	4466.13	1
2010	27	2	2702603	9.52942e+07	21325	4468.66	1
2010	22	2	2202604	8.195075e+07	18338	4468.9	1
2010	31	3	3141801	1.3766996e+08	30803	4469.37	1
2010	31	3	3170529	6.082009e+07	13605	4470.42	1
2010	13	1	1302108	3.258977e+07	7289	4471.09	1
2010	24	2	2405405	2.469536e+07	5522	4472.18	1
2010	26	2	2608057	6.255727e+07	13982	4474.13	1
2010	29	2	2909406	6.102815e+07	13638	4474.86	1
2010	21	2	2114007	2.2458563e+08	50160	4477.39	1
2010	27	2	2703700	2.491597e+07	5562	4479.68	1
2010	29	2	2929701	8.32904e+07	18588	4480.87	1
2010	25	2	2502300	2.257206e+07	5037	4481.25	1
2010	22	2	2205508	1.6623886e+08	37095	4481.44	1
2010	15	1	1502301	2.3262154e+08	51899	4482.2	1
2010	22	2	2210938	2.794976e+07	6235	4482.72	1
2010	25	2	2509206	5.806243e+07	12910	4497.48	1
2010	15	1	1501709	5.0927161e+08	113165	4500.26	1
2010	24	2	2401305	4.181106e+07	9289	4501.14	1
2010	13	1	1302207	4.874668e+07	10822	4504.41	1
2010	22	2	2209401	2.707942e+07	6008	4507.23	1
2010	31	3	3170651	2.134222e+07	4733	4509.24	1
2010	31	3	3113008	1.0076475e+08	22343	4509.9	1
2010	29	2	2928059	6.013311e+07	13332	4510.43	1
2010	31	3	3126752	2.617567e+07	5803	4510.71	1
2010	24	2	2407252	1.595427e+07	3536	4511.96	1
2010	26	2	2608255	4.785417e+07	10604	4512.84	1
2010	29	2	2923902	4.898077e+07	10853	4513.11	1
2010	23	2	2303659	4.494134e+07	9951	4516.26	1
2010	31	3	3135803	1.0920801e+08	24179	4516.65	1
2010	21	2	2103208	3.3108617e+08	73281	4518.04	1
2010	24	2	2403806	4.04852e+07	8959	4518.94	1
2010	24	2	2409100	5.021072e+07	11111	4519.01	1
2010	31	3	3116803	4.078763e+07	9024	4519.91	1
2010	29	2	2914406	1.0218814e+08	22607	4520.2	1
2010	27	2	2709400	1.1501847e+08	25444	4520.46	1
2010	29	2	2911006	4.819287e+07	10660	4520.91	1
2010	31	3	3126950	1.506398e+07	3329	4525.08	1
2010	21	2	2101509	8.064625e+07	17816	4526.62	1
2010	22	2	2205300	1.984144e+07	4383	4526.91	1
2010	29	2	2933406	4.066861e+07	8983	4527.29	1
2010	31	3	3166204	4.622271e+07	10202	4530.75	1
2010	35	3	3504701	1.782289e+07	3932	4532.78	1
2010	22	2	2205805	1.1202067e+08	24711	4533.23	1
2010	23	2	2309300	1.4045753e+08	30977	4534.25	1
2010	24	2	2414100	4.494206e+07	9911	4534.56	1
2010	13	1	1304062	2.3707785e+08	52279	4534.86	1
2010	25	2	2502409	4.902801e+07	10806	4537.11	1
2010	23	2	2311702	8.831774e+07	19460	4538.42	1
2010	21	2	2105948	3.539845e+07	7799	4538.84	1
2010	25	2	2508802	2.547556e+07	5612	4539.48	1
2010	31	3	3142908	9.993401e+07	22000	4542.45	1
2010	29	2	2933000	1.1166238e+08	24579	4543	1
2010	31	3	3146206	2.735371e+07	6021	4543.05	1
2010	31	3	3152204	1.709998e+08	37638	4543.28	1
2010	13	1	1300805	1.5653195e+08	34452	4543.48	1
2010	22	2	2201408	3.003789e+07	6609	4545	1
2010	13	1	1300201	6.889557e+07	15149	4547.86	1
2010	22	2	2205359	1.346404e+07	2960	4548.66	1
2010	25	2	2516508	6.797114e+07	14938	4550.22	1
2010	25	2	2516805	4.200164e+07	9223	4554.01	1
2010	29	2	2925758	1.0864904e+08	23857	4554.18	1
2010	29	2	2916609	4.649156e+07	10207	4554.87	1
2010	24	2	2408607	1.800612e+07	3952	4556.21	1
2010	26	2	2613206	9.707879e+07	21305	4556.62	1
2010	24	2	2410702	1.442264e+07	3165	4556.92	1
2010	25	2	2510105	4.801518e+07	10533	4558.55	1
2010	15	1	1503408	4.588537e+07	10064	4559.36	1
2010	24	2	2413003	2.749356e+07	6030	4559.46	1
2010	23	2	2304608	2.834363e+07	6216	4559.79	1
2010	29	2	2926707	5.918786e+07	12979	4560.28	1
2010	25	2	2513505	2.432065e+07	5332	4561.26	1
2010	24	2	2400505	6.150339e+07	13475	4564.26	1
2010	22	2	2205904	2.377896e+07	5209	4564.98	1
2010	24	2	2407302	3.773427e+07	8265	4565.55	1
2010	25	2	2501005	8.624075e+07	18886	4566.39	1
2010	31	3	3138682	2.924905e+07	6405	4566.6	1
2010	24	2	2410900	3.228592e+07	7067	4568.55	1
2010	25	2	2500775	3.507267e+07	7676	4569.13	1
2010	29	2	2921203	1.2097043e+08	26466	4570.79	1
2010	25	2	2509396	2.715902e+07	5939	4573	1
2010	25	2	2512309	9.735011e+07	21283	4574.08	1
2010	29	2	2920502	1.1259522e+08	24615	4574.25	1
2010	29	2	2903805	8.238942e+07	18000	4577.19	1
2010	31	3	3134707	5.55759e+07	12134	4580.18	1
2010	29	2	2930766	5.774987e+07	12603	4582.23	1
2010	23	2	2302701	1.2151013e+08	26510	4583.56	1
2010	31	3	3150802	7.9011e+07	17230	4585.66	1
2010	15	1	1501204	1.6927396e+08	36907	4586.5	1
2010	24	2	2402808	2.47944e+07	5405	4587.31	1
2010	22	2	2202083	3.287214e+07	7163	4589.16	1
2010	31	3	3145877	3.349103e+07	7284	4597.89	1
2010	22	2	2200459	2.322655e+07	5051	4598.41	1
2010	15	1	1504976	6.735364e+07	14645	4599.09	1
2010	25	2	2505303	1.152706e+07	2505	4601.62	1
2010	27	2	2704401	8.69871e+07	18901	4602.25	1
2010	29	2	2912103	1.1156479e+08	24241	4602.32	1
2010	25	2	2504207	2.215041e+07	4812	4603.16	1
2010	21	2	2105401	2.8611821e+08	62123	4605.67	1
2010	24	2	2406304	3.220576e+07	6992	4606.09	1
2010	15	1	1500305	1.6129316e+08	35017	4606.14	1
2010	26	2	2604155	6.352719e+07	13791	4606.42	1
2010	25	2	2506103	5.255595e+07	11409	4606.53	1
2010	23	2	2312601	5.684161e+07	12336	4607.78	1
2010	29	2	2916906	5.851032e+07	12693	4609.65	1
2010	21	2	2108900	9.090534e+07	19705	4613.31	1
2010	29	2	2917334	5.031461e+07	10905	4613.9	1
2010	23	2	2305407	3.0201597e+08	65453	4614.24	1
2010	29	2	2931053	7.444622e+07	16133	4614.53	1
2010	17	1	1718303	3.535641e+07	7661	4615.12	1
2010	29	2	2920601	1.9761414e+08	42815	4615.54	1
2010	24	2	2405009	3.658138e+07	7925	4615.95	1
2010	31	3	3162658	1.878022e+07	4066	4618.84	1
2010	23	2	2306702	8.252557e+07	17867	4618.88	1
2010	21	2	2111201	7.5281338e+08	162925	4620.61	1
2010	26	2	2603306	5.140427e+07	11125	4620.61	1
2010	31	3	3129301	4.773736e+07	10331	4620.79	1
2010	22	2	2210003	9.037216e+07	19553	4621.91	1
2010	22	2	2210805	5.584009e+07	12078	4623.29	1
2010	31	3	3161106	2.4926215e+08	53898	4624.7	1
2010	31	3	3145372	2.290665e+07	4953	4624.8	1
2010	25	2	2502805	6.07079e+07	13123	4626.07	1
2010	25	2	2509107	9.795152e+07	21173	4626.25	1
2010	27	2	2704906	1.689828e+07	3652	4627.13	1
2010	24	2	2409332	2.204206e+07	4762	4628.74	1
2010	22	2	2202000	8.832902e+07	19074	4630.86	1
2010	24	2	2411700	1.810227e+07	3909	4630.92	1
2010	25	2	2514206	3.506366e+07	7564	4635.6	1
2010	21	2	2102754	4.960041e+07	10698	4636.42	1
2010	26	2	2601003	4.734194e+07	10204	4639.55	1
2010	29	2	2931608	6.896252e+07	14850	4643.94	1
2010	31	3	3119500	4.234106e+07	9117	4644.19	1
2010	29	2	2923357	7.654721e+07	16477	4645.7	1
2010	24	2	2414803	4.982567e+07	10725	4645.75	1
2010	25	2	2512408	6.01091e+07	12929	4649.17	1
2010	24	2	2413706	2.337686e+07	5020	4656.74	1
2010	27	2	2702207	2.572508e+07	5523	4657.81	1
2010	31	3	3123304	2.067976e+07	4439	4658.65	1
2010	29	2	2917102	9.275904e+07	19911	4658.68	1
2010	25	2	2500205	2.576784e+07	5530	4659.65	1
2010	15	1	1505650	1.1156985e+08	23930	4662.34	1
2010	27	2	2702355	1.0561601e+08	22643	4664.4	1
2010	27	2	2701308	9.520773e+07	20410	4664.76	1
2010	29	2	2908200	9.521791e+07	20408	4665.71	1
2010	22	2	2200202	7.682473e+07	16461	4667.08	1
2010	29	2	2909901	1.5011835e+08	32165	4667.13	1
2010	25	2	2500536	2.445785e+07	5239	4668.42	1
2010	22	2	2205516	2.221141e+07	4757	4669.21	1
2010	21	2	2111102	1.1642119e+08	24913	4673.11	1
2010	29	2	2921708	1.6455878e+08	35207	4674.04	1
2010	31	3	3156601	4.63348e+07	9908	4676.5	1
2010	26	2	2612406	1.0275699e+08	21960	4679.28	1
2010	29	2	2926103	5.643115e+07	12059	4679.59	1
2010	26	2	2616506	6.597173e+07	14092	4681.5	1
2010	26	2	2615102	3.154483e+07	6737	4682.33	1
2010	31	3	3115474	2.388964e+07	5102	4682.41	1
2010	29	2	2919702	8.013976e+07	17088	4689.83	1
2010	26	2	2602209	1.7743447e+08	37828	4690.56	1
2010	31	3	3122454	4.208302e+07	8970	4691.53	1
2010	24	2	2406205	2.9222e+07	6228	4692.04	1
2010	26	2	2607307	1.3196981e+08	28120	4693.09	1
2010	27	2	2704807	6.390011e+07	13614	4693.71	1
2010	31	3	3113107	1.543489e+07	3288	4694.31	1
2010	29	2	2932101	9.278783e+07	19759	4695.98	1
2010	28	2	2802700	3.922055e+07	8348	4698.2	1
2010	29	2	2901403	6.615396e+07	14073	4700.77	1
2010	21	2	2110609	1.2447817e+08	26480	4700.84	1
2010	25	2	2504157	3.318888e+07	7058	4702.31	1
2010	25	2	2511004	1.750742e+07	3721	4705.03	1
2010	29	2	2907202	3.0557871e+08	64944	4705.26	1
2010	31	3	3117009	3.910816e+07	8309	4706.72	1
2010	26	2	2600203	8.280548e+07	17588	4708.07	1
2010	15	1	1503705	2.4133439e+08	51258	4708.23	1
2010	31	3	3148806	1.584418e+07	3365	4708.52	1
2010	26	2	2609907	3.0298499e+08	64335	4709.49	1
2010	26	2	2608305	6.457008e+07	13709	4710.05	1
2010	23	2	2308351	6.161306e+07	13078	4711.2	1
2010	27	2	2705705	9.597857e+07	20367	4712.46	1
2010	25	2	2515005	3.156089e+07	6696	4713.39	1
2010	29	2	2918308	6.654859e+07	14115	4714.74	1
2010	17	1	1721109	3.111505e+07	6598	4715.83	1
2010	24	2	2407005	4.534275e+07	9612	4717.31	1
2010	26	2	2604403	5.838633e+07	12375	4718.09	1
2010	29	2	2930303	8.545809e+07	18112	4718.31	1
2010	25	2	2502904	2.925909e+07	6197	4721.49	1
2010	15	1	1506203	1.7674943e+08	37430	4722.13	1
2010	25	2	2509370	1.275968e+07	2702	4722.31	1
2010	22	2	2205276	2.190102e+07	4637	4723.1	1
2010	24	2	2411007	2.086726e+07	4417	4724.31	1
2010	23	2	2305803	1.904431e+08	40300	4725.64	2
2010	31	3	3160207	1.95442e+07	4135	4726.53	2
2010	25	2	2501708	2.652812e+07	5611	4727.88	2
2010	25	2	2501906	8.079453e+07	17083	4729.53	2
2010	29	2	2918100	1.7817591e+08	37661	4731.05	2
2010	26	2	2607109	2.127716e+07	4496	4732.46	2
2010	26	2	2606705	3.565526e+07	7534	4732.58	2
2010	31	3	3129608	3.709885e+07	7839	4732.6	2
2010	29	2	2914505	1.3020114e+08	27492	4735.96	2
2010	29	2	2908002	9.941986e+07	20964	4742.41	2
2010	26	2	2613107	1.6738476e+08	35278	4744.74	2
2010	17	1	1707405	4.496558e+07	9476	4745.21	2
2010	22	2	2208551	1.215304e+07	2559	4749.14	2
2010	25	2	2509057	3.615141e+07	7611	4749.89	2
2010	24	2	2412500	1.0532313e+08	22159	4753.06	2
2010	25	2	2505501	1.667989e+07	3508	4754.82	2
2010	31	3	3100500	4.896631e+07	10298	4754.93	2
2010	24	2	2411908	1.842145e+07	3874	4755.15	2
2010	29	2	2902807	1.0079763e+08	21190	4756.85	2
2010	31	3	3105509	2.726718e+07	5727	4761.16	2
2010	31	3	3121803	4.165119e+07	8739	4766.13	2
2010	29	2	2910404	1.1338532e+08	23786	4766.89	2
2010	24	2	2413409	3.706872e+07	7770	4770.75	2
2010	25	2	2503407	1.69783e+07	3557	4773.21	2
2010	13	1	1300631	7.400777e+07	15500	4774.69	2
2010	29	2	2927507	9.103444e+07	19064	4775.2	2
2010	26	2	2604601	1.1603701e+08	24298	4775.58	2
2010	24	2	2414159	2.581972e+07	5406	4776.12	2
2010	31	3	3125408	2.453772e+07	5137	4776.66	2
2010	31	3	3104452	2.279523e+07	4770	4778.87	2
2010	27	2	2707503	9.240409e+07	19314	4784.31	2
2010	27	2	2705309	2.526365e+07	5280	4784.78	2
2010	17	1	1720804	4.377622e+07	9148	4785.33	2
2010	26	2	2615003	1.1935515e+08	24923	4788.96	2
2010	26	2	2609303	6.852579e+07	14308	4789.33	2
2010	29	2	2902500	6.640024e+07	13863	4789.75	2
2010	31	3	3124302	1.4910754e+08	31113	4792.45	2
2010	31	3	3106655	2.096203e+07	4371	4795.71	2
2010	29	2	2918357	1.072758e+08	22359	4797.88	2
2010	24	2	2403756	1.367456e+07	2850	4798.09	2
2010	25	2	2510501	1.740704e+07	3627	4799.29	2
2010	25	2	2503605	3.465554e+07	7220	4799.94	2
2010	25	2	2513653	1.255326e+07	2615	4800.48	2
2010	23	2	2309201	6.846939e+07	14256	4802.85	2
2010	31	3	3125606	3.308797e+07	6887	4804.41	2
2010	31	3	3102506	2.427619e+07	5052	4805.26	2
2010	31	3	3107802	7.389321e+07	15376	4805.75	2
2010	15	1	1501758	3.520356e+07	7324	4806.6	2
2010	24	2	2406007	2.820734e+07	5868	4806.98	2
2010	24	2	2410603	1.476025e+07	3070	4807.9	2
2010	25	2	2516003	1.2842741e+08	26689	4812	2
2010	23	2	2301851	8.334775e+07	17320	4812.23	2
2010	52	5	5200258	7.6759718e+08	159505	4812.37	2
2010	21	2	2111052	5.209025e+07	10823	4812.92	2
2010	15	1	1505494	3.604626e+07	7487	4814.51	2
2010	15	1	1504604	1.2884117e+08	26745	4817.39	2
2010	26	2	2607604	1.081505e+08	22449	4817.61	2
2010	25	2	2500809	8.29929e+07	17224	4818.44	2
2010	25	2	2512747	1.578605e+07	3274	4821.64	2
2010	25	2	2502201	1.157178e+07	2399	4823.58	2
2010	24	2	2409803	6.813086e+07	14119	4825.47	2
2010	27	2	2701407	2.4530083e+08	50831	4825.81	2
2010	29	2	2927804	3.221251e+07	6673	4827.29	2
2010	15	1	1503077	1.2102653e+08	25051	4831.21	2
2010	31	3	3138351	2.327564e+07	4814	4834.99	2
2010	15	1	1506005	1.4150074e+08	29265	4835.15	2
2010	17	1	1712405	1.804607e+07	3731	4836.79	2
2010	23	2	2308401	1.6570144e+08	34258	4836.87	2
2010	24	2	2413557	2.197068e+07	4538	4841.49	2
2010	22	2	2205102	5.169293e+07	10677	4841.52	2
2010	31	3	3158201	6.97303e+07	14399	4842.72	2
2010	25	2	2515203	1.568639e+07	3239	4842.97	2
2010	15	1	1502756	1.3668521e+08	28221	4843.39	2
2010	25	2	2504405	8.895763e+07	18366	4843.6	2
2010	21	2	2110005	3.3658821e+08	69392	4850.53	2
2010	24	2	2406601	3.671978e+07	7565	4853.9	2
2010	31	3	3169505	3.053845e+07	6291	4854.31	2
2010	29	2	2925105	2.172904e+08	44760	4854.57	2
2010	24	2	2411502	1.0784654e+08	22214	4854.89	2
2010	13	1	1300300	1.5478498e+08	31876	4855.85	2
2010	31	3	3123858	2.512625e+07	5172	4858.13	2
2010	21	2	2110708	1.6348599e+08	33630	4861.31	2
2010	31	3	3166303	3.465343e+07	7125	4863.64	2
2010	31	3	3171907	2.752802e+07	5659	4864.47	2
2010	22	2	2211100	2.0750413e+08	42657	4864.48	2
2010	25	2	2510303	2.123731e+07	4365	4865.36	2
2010	22	2	2211605	1.496689e+07	3076	4865.7	2
2010	31	3	3157252	3.73687e+07	7679	4866.35	2
2010	25	2	2504801	7.372719e+07	15149	4866.8	2
2010	31	3	3152402	7.626411e+07	15668	4867.51	2
2010	29	2	2901957	3.632775e+07	7463	4867.71	2
2010	24	2	2410504	2.284199e+07	4692	4868.28	2
2010	29	2	2911402	7.33851e+07	15073	4868.65	2
2010	25	2	2505279	2.538521e+07	5214	4868.66	2
2010	25	2	2504033	2.727876e+07	5601	4870.34	2
2010	24	2	2410306	4.273652e+07	8774	4870.81	2
2010	29	2	2926004	1.9074642e+08	39149	4872.32	2
2010	31	3	3102209	2.165074e+07	4443	4873	2
2010	29	2	2902401	6.627929e+07	13599	4873.84	2
2010	28	2	2805406	1.5049159e+08	30877	4873.91	2
2010	29	2	2919058	4.050306e+07	8305	4876.95	2
2010	31	3	3104700	7.048655e+07	14451	4877.62	2
2010	25	2	2513927	2.01838e+07	4138	4877.67	2
2010	26	2	2607950	5.616427e+07	11513	4878.33	2
2010	31	3	3121001	2.542723e+07	5210	4880.47	2
2010	24	2	2407807	1.0087998e+08	20670	4880.5	2
2010	25	2	2513604	3.546444e+07	7266	4880.88	2
2010	31	3	3120151	2.948289e+07	6040	4881.27	2
2010	31	3	3100609	7.417003e+07	15193	4881.86	2
2010	25	2	2500304	1.3905994e+08	28482	4882.38	2
2010	15	1	1504950	9.846543e+07	20159	4884.44	2
2010	31	3	3164209	5.025881e+07	10285	4886.61	2
2010	25	2	2508208	3.601543e+07	7370	4886.76	2
2010	31	3	3120300	2.815501e+07	5760	4888.02	2
2010	27	2	2701357	3.225736e+07	6599	4888.22	2
2010	25	2	2517407	1.014808e+07	2075	4890.64	2
2010	23	2	2313302	2.7268954e+08	55755	4890.85	2
2010	24	2	2414704	2.556757e+07	5227	4891.44	2
2010	23	2	2302800	3.6441506e+08	74486	4892.4	2
2010	25	2	2512721	2.827325e+07	5779	4892.41	2
2010	21	2	2111763	8.813115e+07	18010	4893.46	2
2010	24	2	2405900	1.273116e+07	2601	4894.72	2
2010	25	2	2501609	6.932063e+07	14160	4895.52	2
2010	22	2	2202307	9.814609e+07	20035	4898.73	2
2010	35	3	3505351	2.565766e+07	5236	4900.24	2
2010	24	2	2413508	3.22633e+07	6581	4902.49	2
2010	29	2	2910776	3.030053e+07	6179	4903.79	2
2010	24	2	2404903	2.730959e+07	5568	4904.74	2
2010	26	2	2615904	3.887049e+07	7925	4904.79	2
2010	31	3	3146255	2.861554e+07	5834	4904.96	2
2010	25	2	2507408	3.698229e+07	7538	4906.11	2
2010	24	2	2406809	2.263682e+07	4614	4906.12	2
2010	24	2	2406155	1.759584e+07	3585	4908.18	2
2010	31	3	3153301	1.453007e+07	2959	4910.47	2
2010	31	3	3148509	4.217907e+07	8589	4910.82	2
2010	24	2	2411106	1.765572e+07	3595	4911.19	2
2010	26	2	2602704	6.159408e+07	12537	4912.98	2
2010	15	1	1507151	1.1368973e+08	23140	4913.13	2
2010	25	2	2513307	2.638009e+07	5369	4913.41	2
2010	27	2	2700201	8.560774e+07	17423	4913.49	2
2010	25	2	2506806	8.937276e+07	18180	4915.99	2
2010	24	2	2412807	3.986926e+07	8106	4918.49	2
2010	15	1	1508159	2.9458801e+08	59881	4919.56	2
2010	17	1	1720101	2.270786e+07	4615	4920.45	2
2010	52	5	5215231	4.67546e+08	95013	4920.86	2
2010	24	2	2402907	2.349351e+07	4774	4921.14	2
2010	25	2	2513943	1.190989e+07	2420	4921.44	2
2010	31	3	3155603	1.4313215e+08	29075	4922.86	2
2010	23	2	2300705	8.055912e+07	16360	4924.15	2
2010	25	2	2507309	6.871118e+07	13952	4924.83	2
2010	24	2	2407401	4.054167e+07	8228	4927.28	2
2010	17	1	1718808	1.906058e+07	3868	4927.76	2
2010	17	1	1717800	2.241561e+07	4548	4928.67	2
2010	31	3	3151909	4.435359e+07	8998	4929.27	2
2010	25	2	2515609	1.579772e+07	3204	4930.62	2
2010	13	1	1301704	2.1755006e+08	44116	4931.32	2
2010	26	2	2601607	9.982005e+07	20236	4932.8	2
2010	23	2	2311355	7.399781e+07	15000	4933.19	2
2010	31	3	3162708	1.1019852e+08	22334	4934.11	2
2010	26	2	2606309	3.383763e+07	6857	4934.76	2
2010	31	3	3118809	1.2851868e+08	26035	4936.38	2
2010	27	2	2709103	9.391851e+07	19020	4937.88	2
2010	29	2	2933174	4.505736e+07	9121	4939.96	2
2010	26	2	2616001	7.937609e+07	16064	4941.24	2
2010	24	2	2412708	3.078926e+07	6223	4947.66	2
2010	13	1	1301407	1.51777e+08	30666	4949.36	2
2010	29	2	2920908	7.249908e+07	14640	4952.12	2
2010	24	2	2404002	2.097248e+07	4233	4954.52	2
2010	24	2	2406700	5.14529e+07	10385	4954.54	2
2010	25	2	2501534	2.093518e+07	4222	4958.59	2
2010	25	2	2506202	1.454798e+07	2933	4960.1	2
2010	25	2	2505105	9.897401e+07	19950	4961.1	2
2010	25	2	2507705	8.328223e+07	16776	4964.37	2
2010	31	3	3155108	2.588574e+07	5213	4965.61	2
2010	25	2	2512754	2.117384e+07	4264	4965.72	2
2010	23	2	2305605	1.271396e+08	25586	4969.11	2
2010	31	3	3170057	5.987379e+07	12040	4972.91	2
2010	31	3	3108503	3.233917e+07	6497	4977.55	2
2010	24	2	2414506	5.31061e+07	10669	4977.61	2
2010	29	2	2931707	6.376015e+07	12806	4978.93	2
2010	31	3	3103702	4.066047e+07	8165	4979.85	2
2010	23	2	2305308	1.1860406e+08	23810	4981.27	2
2010	26	2	2611705	9.553926e+07	19158	4986.91	2
2010	23	2	2304509	6.482785e+07	12991	4990.21	2
2010	25	2	2503100	2.513839e+07	5035	4992.73	2
2010	31	3	3139201	9.382914e+07	18787	4994.37	2
2010	13	1	1302306	8.974531e+07	17964	4995.84	2
2010	31	3	3152170	5.668001e+07	11345	4996.03	2
2010	13	1	1303205	7.384617e+07	14780	4996.36	2
2010	31	3	3136579	2.282454e+07	4566	4998.8	2
2010	22	2	2211308	1.0160405e+08	20325	4998.97	2
2010	23	2	2303956	9.4614e+07	18920	5000.74	2
2010	17	1	1720309	2.142167e+07	4283	5001.56	2
2010	29	2	2917805	8.238549e+07	16467	5003.07	2
2010	24	2	2408508	2.351535e+07	4699	5004.33	2
2010	52	5	5219753	3.1616683e+08	63166	5005.33	2
2010	31	3	3119906	1.868044e+07	3732	5005.48	2
2010	26	2	2610806	1.048703e+08	20950	5005.74	2
2010	25	2	2505006	3.437959e+07	6868	5005.76	2
2010	25	2	2503902	2.878272e+07	5749	5006.56	2
2010	23	2	2310100	6.012154e+07	12005	5008.04	2
2010	25	2	2504074	1.952782e+07	3899	5008.42	2
2010	25	2	2511400	9.132037e+07	18226	5010.45	2
2010	24	2	2403905	1.440734e+07	2874	5012.99	2
2010	25	2	2509404	6.262895e+07	12490	5014.33	2
2010	26	2	2604908	8.615236e+07	17166	5018.78	2
2010	24	2	2408409	2.159434e+07	4301	5020.77	2
2010	24	2	2401909	1.659536e+07	3304	5022.81	2
2010	25	2	2504900	8.169555e+07	16257	5025.25	2
2010	25	2	2512762	2.092599e+07	4164	5025.45	2
2010	31	3	3131802	5.373755e+07	10692	5025.96	2
2010	29	2	2918704	1.960933e+07	3901	5026.74	2
2010	31	3	3161601	2.206447e+07	4389	5027.22	2
2010	31	3	3167707	2.929928e+07	5828	5027.33	2
2010	23	2	2304459	7.46671e+07	14851	5027.75	2
2010	21	2	2103307	5.9390785e+08	118072	5030.05	2
2010	29	2	2916708	3.862534e+07	7678	5030.65	2
2010	24	2	2410207	3.671039e+07	7297	5030.89	2
2010	26	2	2603504	8.605657e+07	17104	5031.37	2
2010	31	3	3105202	2.510191e+07	4988	5032.46	2
2010	17	1	1711951	1.774424e+07	3525	5033.83	2
2010	31	3	3148400	2.475651e+07	4918	5033.86	2
2010	31	3	3169109	2.90081e+07	5761	5035.25	2
2010	29	2	2917607	2.5703684e+08	51019	5038.06	2
2010	31	3	3146305	9.49959e+07	18852	5039.04	2
2010	21	2	2103257	6.851729e+07	13593	5040.63	2
2010	31	3	3112059	2.113805e+07	4190	5044.88	2
2010	13	1	1301001	1.2969745e+08	25700	5046.59	2
2010	17	1	1703800	4.931007e+07	9770	5047.09	2
2010	25	2	2513984	1.69851e+07	3364	5049.08	2
2010	24	2	2407609	2.114863e+07	4188	5049.82	2
2010	24	2	2401503	1.999353e+07	3957	5052.7	2
2010	27	2	2703007	7.648439e+07	15133	5054.15	2
2010	24	2	2410801	2.101019e+07	4157	5054.17	2
2010	29	2	2914000	3.0000186e+08	59352	5054.62	2
2010	26	2	2603801	9.909143e+07	19593	5057.49	2
2010	25	2	2506400	7.017176e+07	13872	5058.52	2
2010	29	2	2909109	7.240227e+07	14301	5062.74	2
2010	26	2	2601409	2.0623351e+08	40720	5064.67	2
2010	15	1	1507201	1.5111824e+08	29827	5066.49	2
2010	21	2	2104800	3.1369798e+08	61903	5067.57	2
2010	35	3	3522653	1.968619e+07	3884	5068.53	2
2010	24	2	2401800	5.868839e+07	11577	5069.4	2
2010	24	2	2400406	1.513362e+07	2984	5071.59	2
2010	31	3	3138906	3.53789e+07	6974	5072.97	2
2010	15	1	1505809	2.6477153e+08	52166	5075.56	2
2010	25	2	2511905	8.645133e+07	17032	5075.82	2
2010	25	2	2512705	8.92727e+07	17582	5077.51	2
2010	13	1	1300706	1.5188874e+08	29880	5083.29	2
2010	29	2	2928208	1.2584494e+08	24747	5085.26	2
2010	17	1	1718758	3.183386e+07	6259	5086.09	2
2010	22	2	2201705	2.705469e+07	5319	5086.42	2
2010	23	2	2310852	9.512869e+07	18691	5089.55	2
2010	13	1	1300086	5.191334e+07	10193	5093.04	2
2010	21	2	2110302	7.277627e+07	14288	5093.52	2
2010	24	2	2401602	2.605135e+07	5110	5098.11	2
2010	31	3	3142700	8.086397e+07	15859	5098.93	2
2010	15	1	1507003	1.3600475e+08	26673	5098.97	2
2010	29	2	2929107	1.0357399e+08	20305	5100.91	2
2010	26	2	2608453	8.15729e+07	15990	5101.49	2
2010	24	2	2412104	3.017649e+07	5914	5102.55	2
2010	26	2	2600302	1.1574281e+08	22680	5103.3	2
2010	29	2	2915106	6.662427e+07	13053	5104.13	2
2010	31	3	3163508	3.345073e+07	6553	5104.64	2
2010	31	3	3108602	1.5939568e+08	31221	5105.4	2
2010	26	2	2610400	1.0328423e+08	20227	5106.26	2
2010	25	2	2500734	1.06621e+07	2088	5106.37	2
2010	31	3	3148301	4.733372e+07	9269	5106.67	2
2010	26	2	2613602	1.6258907e+08	31838	5106.76	2
2010	25	2	2507804	3.393063e+07	6643	5107.73	2
2010	24	2	2414001	7.24044e+07	14175	5107.89	2
2010	31	3	3157377	2.249004e+07	4397	5114.86	2
2010	22	2	2203404	3.370999e+07	6587	5117.65	2
2010	29	2	2911600	1.0147189e+08	19826	5118.12	2
2010	25	2	2507903	5.243345e+07	10240	5120.45	2
2010	15	1	1503804	2.6311936e+08	51375	5121.54	2
2010	31	3	3140100	2.162135e+07	4219	5124.76	2
2010	23	2	2306009	7.035826e+07	13725	5126.29	2
2010	25	2	2510907	6.042038e+07	11783	5127.76	2
2010	29	2	2912301	8.09629e+07	15786	5128.78	2
2010	23	2	2313500	2.6384297e+08	51432	5129.94	2
2010	35	3	3513603	1.1222535e+08	21874	5130.54	2
2010	28	2	2806909	1.74268e+07	3395	5133.08	2
2010	31	3	3163409	2.893189e+07	5636	5133.41	2
2010	26	2	2613404	9.331297e+07	18172	5134.99	2
2010	31	3	3130556	3.293474e+07	6412	5136.42	2
2010	31	3	3168408	7.342349e+07	14294	5136.67	2
2010	27	2	2704104	9.383902e+07	18253	5141.02	2
2010	25	2	2516151	1.631758e+07	3173	5142.64	2
2010	21	2	2105658	2.067554e+07	4020	5143.17	2
2010	25	2	2501104	1.2268706e+08	23837	5146.92	2
2010	31	3	3144359	3.267688e+07	6341	5153.27	2
2010	24	2	2410405	4.345859e+07	8432	5154.01	2
2010	31	3	3112208	2.454181e+07	4758	5158.01	2
2010	29	2	2906303	1.6678485e+08	32331	5158.67	2
2010	25	2	2500700	9.395903e+07	18201	5162.3	2
2010	31	3	3115458	3.461612e+07	6705	5162.73	2
2010	17	1	1703891	1.905806e+07	3690	5164.79	2
2010	23	2	2312700	1.3689905e+08	26494	5167.17	2
2010	25	2	2507200	5.271391e+07	10201	5167.52	2
2010	25	2	2504504	3.408559e+07	6587	5174.68	2
2010	21	2	2105500	1.0551245e+08	20381	5177	2
2010	31	3	3141009	6.568807e+07	12685	5178.4	2
2010	29	2	2922250	5.320249e+07	10272	5179.37	2
2010	25	2	2516706	7.331674e+07	14153	5180.3	2
2010	31	3	3111150	1.909423e+07	3685	5181.61	2
2010	31	3	3128253	2.446649e+07	4719	5184.68	2
2010	52	5	5221080	1.563825e+07	3016	5185.1	2
2010	25	2	2501401	4.154754e+07	8007	5188.9	2
2010	31	3	3135209	3.397179e+08	65464	5189.38	2
2010	25	2	2513968	1.480172e+07	2851	5191.76	2
2010	25	2	2512077	2.06557e+07	3978	5192.48	2
2010	24	2	2406908	1.886697e+07	3633	5193.22	2
2010	21	2	2109551	3.788104e+07	7294	5193.45	2
2010	29	2	2925402	5.108185e+07	9829	5197.05	2
2010	24	2	2414456	1.749405e+07	3366	5197.28	2
2010	25	2	2508406	1.476617e+07	2841	5197.53	2
2010	31	3	3162609	4.094051e+07	7874	5199.45	2
2010	29	2	2900900	3.308819e+07	6360	5202.55	2
2010	31	3	3139300	1.0326444e+08	19846	5203.29	2
2010	24	2	2401859	3.13043e+07	6016	5203.51	2
2010	25	2	2513208	3.367403e+07	6471	5203.84	2
2010	31	3	3134301	3.195648e+07	6139	5205.49	2
2010	31	3	3122108	2.569987e+07	4937	5205.56	2
2010	23	2	2304103	3.795667e+08	72853	5210.04	2
2010	25	2	2511707	2.687697e+07	5155	5213.77	2
2010	25	2	2501153	1.004849e+07	1927	5214.58	2
2010	13	1	1301308	1.2060317e+08	23119	5216.63	2
2010	31	3	3112653	2.571356e+07	4929	5216.79	2
2010	31	3	3135605	4.179328e+07	8010	5217.64	2
2010	26	2	2607505	1.3703713e+08	26264	5217.68	2
2010	31	3	3165560	1.485526e+07	2847	5217.86	2
2010	22	2	2208403	3.2280882e+08	61840	5220.06	2
2010	29	2	2932705	1.0360836e+08	19840	5222.2	2
2010	24	2	2402709	5.701726e+07	10916	5223.27	2
2010	25	2	2516300	8.397574e+07	16072	5224.97	2
2010	24	2	2409704	3.745883e+07	7168	5225.84	2
2010	31	3	3121704	2.011927e+07	3848	5228.5	2
2010	24	2	2404606	6.378611e+07	12188	5233.52	2
2010	31	3	3144201	1.651754e+07	3154	5237.01	2
2010	13	1	1302900	2.7161091e+08	51847	5238.7	2
2010	29	2	2908903	1.1753604e+08	22431	5239.89	2
2010	25	2	2515807	3.697e+07	7054	5241	2
2010	21	2	2100808	7.29771e+07	13923	5241.48	2
2010	26	2	2608800	1.9195073e+08	36606	5243.7	2
2010	22	2	2210623	1.866358e+07	3559	5244.05	2
2010	35	3	3543501	3.233385e+07	6165	5244.74	2
2010	29	2	2927200	1.5671302e+08	29869	5246.68	2
2010	29	2	2912707	1.1865383e+08	22610	5247.85	2
2010	29	2	2915809	1.2131152e+08	23106	5250.22	2
2010	29	2	2919306	5.447525e+07	10368	5254.17	2
2010	27	2	2700508	7.479251e+07	14228	5256.71	2
2010	28	2	2801603	2.964741e+07	5633	5263.17	2
2010	31	3	3117405	2.351079e+07	4467	5263.22	2
2010	27	2	2702801	6.496186e+07	12339	5264.76	2
2010	31	3	3119203	5.40971e+07	10274	5265.44	2
2010	31	3	3132800	1.20319e+07	2283	5270.21	2
2010	25	2	2505238	3.269091e+07	6198	5274.43	2
2010	31	3	3112901	4.765897e+07	9033	5276.1	2
2010	25	2	2514701	2.115756e+07	4010	5276.2	2
2010	25	2	2507101	8.974283e+07	16998	5279.61	2
2010	29	2	2922409	1.1335047e+08	21466	5280.47	2
2010	27	2	2705507	1.4108034e+08	26706	5282.72	2
2010	27	2	2700904	3.716672e+07	7032	5285.37	2
2010	31	3	3171154	2.479533e+07	4689	5287.98	2
2010	31	3	3158607	2.038662e+07	3854	5289.73	2
2010	29	2	2921302	5.453046e+07	10306	5291.14	2
2010	31	3	3105707	3.252726e+07	6147	5291.57	2
2010	23	2	2312205	2.2630284e+08	42759	5292.52	2
2010	24	2	2412559	4.588021e+07	8659	5298.56	2
2010	27	2	2700805	2.411406e+07	4551	5298.63	2
2010	24	2	2410009	1.832247e+07	3453	5306.25	2
2010	28	2	2805109	4.681294e+07	8821	5306.99	2
2010	29	2	2905008	1.1807057e+08	22231	5311.08	2
2010	31	3	3126802	3.122991e+07	5880	5311.21	2
2010	24	2	2407500	5.545977e+07	10442	5311.22	2
2010	31	3	3100906	9.820124e+07	18482	5313.34	2
2010	31	3	3127354	1.57524e+07	2964	5314.58	2
2010	29	2	2922607	6.659999e+07	12530	5315.24	2
2010	31	3	3170578	3.43272e+07	6457	5316.28	2
2010	31	3	3122504	2.770188e+07	5210	5317.06	2
2010	25	2	2508307	1.378995e+08	25911	5322.04	2
2010	15	1	1507953	4.222009e+08	79299	5324.16	2
2010	25	2	2514909	4.126234e+07	7748	5325.55	2
2010	24	2	2411205	1.9054862e+08	35759	5328.69	2
2010	27	2	2708907	7.791047e+07	14604	5334.87	2
2010	31	3	3166105	1.863732e+07	3493	5335.62	2
2010	29	2	2901007	1.8345402e+08	34340	5342.28	2
2010	31	3	3164472	3.067125e+07	5739	5344.36	2
2010	25	2	2504108	1.271356e+07	2378	5346.32	2
2010	13	1	1301951	4.298473e+07	8040	5346.36	2
2010	26	2	2609006	1.2785921e+08	23907	5348.19	2
2010	13	1	1302702	2.5145033e+08	47011	5348.76	2
2010	31	3	3164100	2.979611e+07	5570	5349.39	2
2010	25	2	2515971	3.939726e+07	7363	5350.71	2
2010	31	3	3125952	5.542452e+07	10351	5354.51	2
2010	26	2	2600609	7.373536e+07	13761	5358.29	2
2010	26	2	2600708	2.0048015e+08	37414	5358.43	2
2010	23	2	2312304	2.3689074e+08	44186	5361.22	2
2010	22	2	2210607	1.7353043e+08	32347	5364.65	2
2010	35	3	3540754	1.0417407e+08	19413	5366.2	2
2010	29	2	2933455	6.701753e+07	12485	5367.84	2
2010	25	2	2515500	6.964001e+07	12971	5368.9	2
2010	31	3	3137908	1.855589e+07	3456	5369.18	2
2010	25	2	2501351	1.89247e+07	3522	5373.28	2
2010	17	1	1712801	1.697364e+07	3158	5374.81	2
2010	25	2	2513851	1.418644e+07	2638	5377.73	2
2010	31	3	3116001	3.037539e+07	5647	5379.03	2
2010	26	2	2613701	5.5385559e+08	102956	5379.54	2
2010	25	2	2515302	2.6981158e+08	50151	5379.98	2
2010	24	2	2409209	1.560308e+07	2899	5382.23	2
2010	31	3	3133204	6.381459e+07	11850	5385.2	2
2010	31	3	3166006	3.066267e+07	5689	5389.82	2
2010	28	2	2804706	3.364851e+07	6242	5390.66	2
2010	15	1	1505205	1.542216e+08	28595	5393.31	2
2010	31	3	3167806	3.064687e+07	5678	5397.48	2
2010	22	2	2207009	1.9240152e+08	35646	5397.56	2
2010	23	2	2309508	1.155543e+08	21392	5401.75	2
2010	31	3	3152303	5.623372e+07	10410	5401.89	2
2010	29	2	2923803	1.5010832e+08	27782	5403.08	2
2010	24	2	2413607	3.10854e+07	5752	5404.28	2
2010	31	3	3124104	3.2544596e+08	60153	5410.3	2
2010	25	2	2506905	1.3252086e+08	24483	5412.77	2
2010	28	2	2802403	6.202862e+07	11458	5413.56	2
2010	24	2	2406106	9.580571e+07	17692	5415.2	2
2010	31	3	3140605	2.489302e+07	4595	5417.42	2
2010	31	3	3106606	2.43697e+07	4498	5417.9	2
2010	29	2	2916807	1.0052593e+08	18548	5419.77	2
2010	31	3	3103405	1.9541347e+08	36041	5421.98	2
2010	15	1	1507300	4.9505516e+08	91293	5422.71	2
2010	27	2	2705101	1.290572e+08	23780	5427.13	2
2010	31	3	3171501	1.830049e+07	3371	5428.8	2
2010	31	3	3140308	2.183885e+07	4021	5431.2	2
2010	31	3	3154101	5.599259e+07	10301	5435.65	2
2010	17	1	1714302	2.385049e+07	4386	5437.87	2
2010	31	3	3101805	3.902499e+07	7172	5441.3	2
2010	15	1	1500859	1.1155149e+08	20493	5443.39	2
2010	24	2	2400109	6.00841e+07	11035	5444.87	2
2010	31	3	3167608	9.965742e+07	18302	5445.17	2
2010	25	2	2515930	2.394258e+07	4395	5447.69	2
2010	25	2	2512507	2.2369745e+08	41054	5448.86	2
2010	24	2	2407906	1.235443e+07	2266	5452.09	2
2010	29	2	2928109	2.2000823e+08	40316	5457.09	2
2010	25	2	2501500	1.1926396e+08	21854	5457.31	2
2010	31	3	3160959	2.944862e+07	5396	5457.49	2
2010	31	3	3122801	1.634915e+07	2994	5460.64	2
2010	23	2	2302503	2.4682828e+08	45190	5462.01	2
2010	31	3	3120839	2.556848e+07	4680	5463.35	2
2010	13	1	1302405	2.0532458e+08	37574	5464.54	2
2010	24	2	2408706	2.110405e+07	3862	5464.54	2
2010	21	2	2105427	1.3604885e+08	24891	5465.78	2
2010	25	2	2505907	1.813552e+07	3317	5467.45	2
2010	13	1	1302553	1.2471392e+08	22807	5468.23	2
2010	26	2	2600104	1.9190376e+08	35091	5468.75	2
2010	27	2	2703403	2.960671e+07	5413	5469.56	2
2010	31	3	3162807	8.5079e+07	15538	5475.54	2
2010	24	2	2408953	5.509818e+07	10060	5476.96	2
2010	27	2	2708006	2.4621596e+08	44949	5477.67	2
2010	26	2	2602100	2.4936741e+08	45506	5479.88	2
2010	24	2	2405504	1.428867e+07	2607	5480.89	2
2010	52	5	5203962	1.819716e+07	3319	5482.72	2
2010	31	3	3106804	2.082221e+07	3796	5485.3	2
2010	29	2	2922300	1.58542e+08	28897	5486.45	2
2010	21	2	2103802	1.2443421e+08	22673	5488.21	2
2010	29	2	2926608	2.6502375e+08	48271	5490.33	2
2010	31	3	3162575	2.847204e+07	5183	5493.35	2
2010	31	3	3143807	3.438259e+07	6257	5495.06	2
2010	35	3	3540853	1.573477e+07	2863	5495.9	2
2010	31	3	3157336	4.327484e+07	7870	5498.71	2
2010	25	2	2513802	2.519584e+07	4581	5500.07	2
2010	31	3	3121407	3.851318e+07	7002	5500.31	2
2010	29	2	2931400	4.343018e+07	7895	5500.97	2
2010	17	1	1710706	3.316853e+07	6029	5501.5	2
2010	26	2	2605004	1.2880313e+08	23392	5506.29	2
2010	31	3	3120870	3.816916e+07	6930	5507.82	2
2010	35	3	3521200	2.371454e+07	4302	5512.45	2
2010	52	5	5212709	3.795752e+07	6885	5513.07	2
2010	26	2	2609709	1.2610112e+08	22865	5515.03	2
2010	29	2	2906873	1.4637879e+08	26529	5517.69	2
2010	31	3	3123809	3.932377e+07	7125	5519.13	2
2010	29	2	2925956	1.41173e+08	25555	5524.28	2
2010	28	2	2803708	3.541977e+07	6411	5524.84	2
2010	29	2	2929909	2.3104891e+08	41815	5525.5	2
2010	23	2	2305001	2.0895158e+08	37777	5531.19	2
2010	15	1	1505403	9.015601e+07	16296	5532.4	2
2010	27	2	2705200	8.680119e+07	15682	5535.08	2
2010	31	3	3127339	2.845019e+07	5139	5536.13	2
2010	28	2	2804201	7.541089e+07	13621	5536.37	2
2010	51	5	5100508	5.518306e+07	9951	5545.48	2
2010	31	3	3162252	2.58791e+07	4659	5554.65	2
2010	28	2	2803104	2.76662e+07	4972	5564.4	2
2010	17	1	1718501	2.100184e+07	3768	5573.74	2
2010	23	2	2306553	2.0896234e+08	37462	5577.98	2
2010	23	2	2306256	2.0002001e+08	35838	5581.23	2
2010	31	3	3135506	7.170001e+07	12845	5581.94	2
2010	24	2	2409605	1.442848e+07	2583	5585.94	2
2010	25	2	2516755	1.573297e+07	2816	5586.99	2
2010	24	2	2413805	1.295973e+07	2317	5593.32	2
2010	24	2	2414902	9.05144e+06	1618	5594.21	2
2010	22	2	2206605	5.791319e+07	10349	5596.02	2
2010	21	2	2110039	1.2675604e+08	22644	5597.78	2
2010	31	3	3102852	4.48235e+07	8003	5600.84	2
2010	15	1	1505064	3.4795099e+08	62124	5600.91	2
2010	31	3	3165909	2.56441e+07	4574	5606.49	2
2010	26	2	2605152	9.486265e+07	16915	5608.2	2
2010	17	1	1703008	5.861228e+07	10446	5610.98	2
2010	15	1	1503093	1.7078171e+08	30437	5610.99	2
2010	31	3	3152131	2.226182e+07	3966	5613.17	2
2010	15	1	1505486	2.2494718e+08	40052	5616.38	2
2010	23	2	2313955	9.87904e+07	17584	5618.2	2
2010	31	3	3140159	7.42433e+07	13214	5618.53	2
2010	29	2	2904308	8.028554e+07	14282	5621.45	2
2010	31	3	3157609	2.237792e+07	3979	5624.01	2
2010	24	2	2405207	3.009001e+07	5350	5624.3	2
2010	27	2	2708808	1.8002288e+08	32007	5624.48	2
2010	31	3	3150539	2.488591e+07	4420	5630.3	2
2010	25	2	2506509	1.778627e+07	3159	5630.35	2
2010	31	3	3126901	5.027513e+07	8924	5633.7	2
2010	26	2	2604205	2.1314075e+08	37830	5634.17	2
2010	26	2	2610905	3.5386425e+08	62793	5635.41	2
2010	29	2	2911808	1.2508401e+08	22195	5635.68	2
2010	17	1	1702901	5.229124e+07	9275	5637.87	2
2010	29	2	2915908	4.281165e+07	7591	5639.79	2
2010	29	2	2902906	1.9634008e+08	34788	5643.9	2
2010	31	3	3163300	2.166815e+07	3837	5647.16	2
2010	31	3	3161650	1.969185e+07	3487	5647.22	2
2010	23	2	2310704	2.0010023e+08	35412	5650.63	2
2010	26	2	2603454	8.1685653e+08	144506	5652.75	2
2010	17	1	1715101	2.126961e+07	3762	5653.8	2
2010	23	2	2307254	9.613655e+07	17002	5654.43	2
2010	31	3	3141405	1.1903833e+08	21037	5658.52	2
2010	29	2	2922508	1.5439157e+08	27269	5661.8	2
2010	29	2	2931202	1.0645509e+08	18791	5665.22	2
2010	25	2	2510600	1.658809e+07	2928	5665.33	2
2010	13	1	1303403	5.783372e+08	102066	5666.31	2
2010	31	3	3115706	3.844576e+07	6774	5675.49	2
2010	26	2	2600906	1.2454702e+08	21925	5680.59	2
2010	31	3	3125507	1.726536e+07	3039	5681.26	2
2010	31	3	3158409	2.058095e+07	3622	5682.21	2
2010	27	2	2701902	4.062216e+07	7146	5684.6	2
2010	25	2	2514503	1.0857095e+08	19099	5684.64	2
2010	24	2	2404705	7.880017e+07	13855	5687.49	2
2010	25	2	2511103	4.252824e+07	7475	5689.4	2
2010	29	2	2900306	8.440773e+07	14830	5691.69	2
2010	31	3	3159100	2.176174e+07	3822	5693.81	2
2010	25	2	2512606	9.67518e+06	1699	5694.63	2
2010	15	1	1501576	8.683585e+07	15246	5695.65	2
2010	23	2	2300200	3.2775617e+08	57542	5695.95	2
2010	15	1	1504703	3.9870613e+08	69921	5702.24	2
2010	13	1	1304203	3.5016915e+08	61399	5703.17	2
2010	27	2	2707404	4.80169e+07	8419	5703.4	2
2010	29	2	2909208	9.73596e+07	17066	5704.89	2
2010	31	3	3163003	2.325922e+07	4075	5707.78	2
2010	25	2	2514404	2.717419e+07	4760	5708.86	2
2010	25	2	2516904	8.329863e+07	14584	5711.64	2
2010	35	3	3516309	8.8362119e+08	154538	5717.82	2
2010	31	3	3100401	2.244023e+07	3924	5718.71	2
2010	29	2	2907301	1.4548039e+08	25419	5723.29	2
2010	21	2	2108603	4.4726612e+08	78147	5723.39	2
2010	25	2	2503803	3.226279e+07	5637	5723.4	2
2010	31	3	3148707	1.365051e+08	23843	5725.16	2
2010	13	1	1304005	4.836996e+07	8445	5727.64	2
2010	25	2	2511301	8.857971e+07	15465	5727.75	2
2010	31	3	3132107	1.0168071e+08	17739	5732.04	2
2010	31	3	3168051	1.800309e+07	3137	5738.95	2
2010	17	1	1718550	2.403482e+07	4183	5745.83	2
2010	17	1	1718006	1.606113e+07	2795	5746.38	2
2010	31	3	3127305	4.005932e+07	6966	5750.69	2
2010	31	3	3134608	9.844676e+07	17119	5750.73	2
2010	52	5	5206701	1.896722e+07	3297	5752.87	2
2010	25	2	2503753	1.747589e+07	3033	5761.91	2
2010	25	2	2505808	2.098219e+07	3640	5764.34	2
2010	31	3	3113503	5.283227e+07	9158	5768.97	2
2010	28	2	2806404	4.062517e+07	7038	5772.26	2
2010	31	3	3141603	5.987793e+07	10372	5773.04	2
2010	31	3	3116506	4.492613e+07	7781	5773.82	2
2010	29	2	2915403	4.202335e+07	7278	5774.02	2
2010	24	2	2403004	4.608836e+07	7968	5784.18	2
2010	13	1	1300144	1.0451779e+08	18059	5787.57	2
2010	31	3	3130903	1.404991e+08	24269	5789.24	2
2010	29	2	2906006	3.8585135e+08	66638	5790.26	2
2010	31	3	3167103	1.2068522e+08	20833	5792.98	2
2010	25	2	2511608	4.043689e+07	6978	5794.91	2
2010	31	3	3125002	2.174835e+07	3752	5796.47	2
2010	27	2	2704005	1.3833312e+08	23854	5799.16	2
2010	26	2	2606606	1.5642609e+08	26959	5802.37	2
2010	26	2	2602407	5.13714e+07	8851	5804.02	2
2010	26	2	2613800	9.870156e+07	17000	5805.97	2
2010	31	3	3127370	1.773524e+07	3054	5807.22	2
2010	29	2	2903102	3.681927e+07	6336	5811.12	2
2010	24	2	2404853	4.04123e+07	6952	5813.05	2
2010	29	2	2919009	2.286249e+07	3930	5817.43	2
2010	15	1	1501725	1.0450414e+08	17960	5818.72	2
2010	35	3	3522158	1.87877e+07	3228	5820.23	2
2010	31	3	3141504	3.686537e+07	6329	5824.83	2
2010	31	3	3158904	5.012297e+07	8603	5826.22	2
2010	31	3	3150406	2.707218e+07	4645	5828.24	2
2010	31	3	3150000	2.406515e+07	4129	5828.32	2
2010	25	2	2500577	1.379766e+07	2366	5831.64	2
2010	29	2	2908408	3.6191173e+08	62042	5833.33	2
2010	17	1	1717909	4.189481e+07	7180	5834.93	2
2010	28	2	2805604	1.5829024e+08	27124	5835.8	2
2010	31	3	3122603	2.64656e+07	4535	5835.85	2
2010	35	3	3515350	5.594396e+07	9585	5836.62	2
2010	29	2	2929404	6.081225e+07	10414	5839.47	2
2010	31	3	3171030	4.87704e+07	8350	5840.77	2
2010	31	3	3125903	6.330804e+07	10837	5841.84	2
2010	31	3	3157401	2.920474e+07	4996	5845.62	2
2010	21	2	2107258	2.85628e+07	4885	5847.04	2
2010	26	2	2602308	2.1970109e+08	37570	5847.78	2
2010	31	3	3154606	1.73369881e+09	296376	5849.66	2
2010	25	2	2514008	2.542462e+07	4344	5852.81	2
2010	31	3	3144904	2.222367e+07	3793	5859.13	2
2010	31	3	3146701	3.838109e+07	6545	5864.18	2
2010	31	3	3148608	1.0135167e+08	17270	5868.65	2
2010	50	5	5004809	4.488479e+07	7645	5871.13	2
2010	17	1	1701903	3.709388e+07	6317	5872.07	2
2010	15	1	1506708	3.2976735e+08	56132	5874.85	2
2010	22	2	2202208	2.6550612e+08	45180	5876.63	2
2010	24	2	2403400	3.424186e+07	5822	5881.46	2
2010	29	2	2900355	9.2381e+07	15706	5881.89	2
2010	31	3	3114808	2.679666e+07	4555	5882.91	2
2010	22	2	2206308	7.37141e+06	1253	5883.01	2
2010	31	3	3148756	3.932831e+07	6673	5893.65	2
2010	23	2	2302107	1.9668839e+08	33326	5901.95	2
2010	51	5	5100102	3.255889e+07	5516	5902.63	2
2010	31	3	3132008	2.941512e+07	4982	5904.28	2
2010	29	2	2905800	2.0764892e+08	35160	5905.83	2
2010	29	2	2914703	3.643468e+08	61623	5912.51	2
2010	25	2	2502508	9.988161e+07	16889	5914	2
2010	28	2	2807402	2.8413912e+08	48039	5914.76	2
2010	29	2	2911907	1.5239663e+08	25735	5921.77	2
2010	31	3	3122009	1.133159e+08	19131	5923.16	2
2010	17	1	1701309	3.484397e+07	5882	5923.83	2
2010	26	2	2613305	1.2143555e+08	20489	5926.87	2
2010	27	2	2703601	4.597071e+07	7752	5930.17	2
2010	24	2	2400802	6.854939e+07	11553	5933.47	2
2010	28	2	2805802	1.1512106e+08	19394	5935.91	2
2010	23	2	2311603	1.5685902e+08	26423	5936.46	2
2010	29	2	2920700	1.1337591e+08	19097	5936.84	2
2010	29	2	2927309	7.996605e+07	13465	5938.81	2
2010	31	3	3161403	3.078684e+07	5184	5938.82	2
2010	15	1	1508001	3.3591301e+08	56514	5943.89	2
2010	31	3	3165701	4.300292e+07	7230	5947.85	2
2010	17	1	1720002	1.470279e+07	2471	5950.14	2
2010	26	2	2609105	8.117878e+07	13632	5955.02	2
2010	25	2	2504702	2.794749e+07	4692	5956.41	2
2010	17	1	1704105	1.527886e+07	2565	5956.67	2
2010	22	2	2207405	2.976253e+07	4993	5960.85	2
2010	31	3	3125804	1.808072e+07	3033	5961.33	2
2010	31	3	3147501	1.052934e+07	1766	5962.26	2
2010	23	2	2301406	6.873922e+07	11529	5962.29	2
2010	31	3	3157500	2.749237e+07	4610	5963.64	2
2010	31	3	3115201	2.363687e+07	3961	5967.4	2
2010	24	2	2405603	8.06829e+07	13511	5971.65	2
2010	26	2	2614105	2.0149286e+08	33723	5974.94	2
2010	26	2	2601102	4.6279097e+08	77363	5982.07	2
2010	29	2	2913903	2.6578414e+08	44430	5982.09	2
2010	28	2	2803005	2.3262292e+08	38886	5982.18	2
2010	26	2	2611804	2.6594547e+08	44445	5983.7	2
2010	29	2	2918555	3.873783e+07	6467	5990.08	2
2010	29	2	2901106	1.5097971e+08	25190	5993.64	2
2010	13	1	1304302	1.0201992e+08	17019	5994.47	2
2010	31	3	3122900	3.599385e+07	6001	5997.98	2
2010	31	3	3126604	2.919392e+07	4867	5998.34	2
2010	27	2	2709152	2.4703742e+08	41158	6002.17	2
2010	29	2	2926657	5.147567e+07	8573	6004.39	2
2010	25	2	2507002	1.393084e+08	23195	6005.97	2
2010	29	2	2905602	1.8919186e+08	31468	6012.2	2
2010	52	5	5205497	3.3609054e+08	55883	6014.18	2
2010	28	2	2802205	3.203776e+07	5325	6016.48	2
2010	21	2	2102804	1.4428156e+08	23979	6017	2
2010	31	3	3123106	3.14328e+07	5223	6018.15	2
2010	31	3	3136553	2.6349e+07	4376	6021.25	2
2010	31	3	3154457	4.824142e+07	8007	6024.91	2
2010	29	2	2903904	3.8289706e+08	63508	6029.12	2
2010	26	2	2615607	1.5747898e+08	26116	6029.98	2
2010	31	3	3159902	1.0462386e+08	17349	6030.54	2
2010	31	3	3113800	1.483832e+07	2460	6031.84	2
2010	26	2	2609402	3.4281407e+08	56767	6038.97	2
2010	26	2	2610608	3.1072634e+08	51374	6048.32	2
2010	28	2	2802502	1.76309e+07	2914	6050.41	2
2010	31	3	3167301	1.326543e+07	2192	6051.75	2
2010	17	1	1717008	2.727539e+07	4506	6053.13	2
2010	31	3	3168507	6.868803e+07	11346	6053.94	2
2010	23	2	2307809	1.4958035e+08	24707	6054.17	2
2010	31	3	3126703	1.5087628e+08	24918	6054.91	2
2010	26	2	2607653	2.1450641e+08	35398	6059.85	2
2010	31	3	3103306	1.247363e+07	2057	6063.99	2
2010	17	1	1715002	2.28745e+07	3770	6067.51	2
2010	21	2	2101202	6.0705728e+08	99960	6073	2
2010	23	2	2306405	7.0498021e+08	116065	6074.01	2
2010	28	2	2807303	1.796437e+07	2957	6075.2	2
2010	15	1	1502939	3.1183202e+08	51318	6076.46	2
2010	22	2	2205607	3.209688e+07	5281	6077.8	2
2010	31	3	3172202	1.55184e+07	2553	6078.5	2
2010	52	5	5213509	4.708424e+07	7742	6081.66	2
2010	17	1	1705607	2.543684e+07	4182	6082.46	2
2010	25	2	2510709	1.358226e+07	2233	6082.52	2
2010	23	2	2310258	1.8286843e+08	30041	6087.3	2
2010	31	3	3139904	8.66326e+07	14216	6094.02	2
2010	52	5	5201702	1.1158716e+08	18310	6094.33	2
2010	31	3	3151008	4.885966e+07	8016	6095.27	2
2010	25	2	2509701	1.880055e+08	30844	6095.37	2
2010	17	1	1703826	1.309694e+07	2148	6097.27	2
2010	29	2	2914901	1.4860186e+08	24340	6105.25	2
2010	23	2	2310605	5.023558e+07	8226	6106.93	2
2010	29	2	2918803	1.3563132e+08	22206	6107.87	2
2010	31	3	3156809	9.594755e+07	15707	6108.59	2
2010	26	2	2604502	1.2233883e+08	20020	6110.83	2
2010	26	2	2615508	7.987358e+07	13055	6118.24	2
2010	29	2	2903300	3.948757e+07	6453	6119.26	2
2010	31	3	3165503	3.425336e+07	5597	6119.95	2
2010	52	5	5217609	4.9946474e+08	81612	6119.99	2
2010	31	3	3163201	2.446814e+07	3996	6123.16	2
2010	13	1	1300839	6.68606e+07	10909	6128.94	2
2010	15	1	1508050	1.035151e+08	16885	6130.6	2
2010	29	2	2905206	2.9147118e+08	47524	6133.14	2
2010	27	2	2707008	1.758853e+07	2866	6136.96	2
2010	29	2	2906857	7.074713e+07	11527	6137.51	2
2010	23	2	2300754	2.408311e+08	39233	6138.48	2
2010	31	3	3163805	4.145542e+07	6750	6141.54	2
2010	31	3	3145851	2.755578e+07	4486	6142.62	2
2010	29	2	2916104	1.275742e+08	20760	6145.19	2
2010	31	3	3167905	2.50718e+07	4076	6151.08	2
2010	31	3	3157302	2.831776e+07	4603	6152.02	2
2010	31	3	3136801	2.531158e+07	4110	6158.53	2
2010	27	2	2701100	6.519783e+07	10586	6158.87	2
2010	27	2	2706802	1.0613919e+08	17219	6164.07	2
2010	15	1	1506500	3.6669778e+08	59476	6165.47	2
2010	52	5	5209408	2.62988e+07	4262	6170.53	2
2010	17	1	1702208	1.9336108e+08	31324	6172.94	2
2010	31	3	3156106	3.043908e+07	4931	6173	2
2010	17	1	1703073	2.545806e+07	4123	6174.64	2
2010	31	3	3109204	6.364234e+07	10291	6184.27	2
2010	29	2	2915700	4.888759e+07	7904	6185.17	2
2010	29	2	2900603	2.847444e+07	4602	6187.4	2
2010	23	2	2313104	1.8092437e+08	29210	6193.92	2
2010	29	2	2931301	1.0239926e+08	16528	6195.5	2
2010	28	2	2801900	2.362402e+07	3813	6195.65	2
2010	35	3	3554656	1.398532e+07	2257	6196.42	2
2010	31	3	3102407	2.198576e+07	3548	6196.66	2
2010	28	2	2800209	1.2443213e+08	20066	6201.14	2
2010	31	3	3118908	5.375924e+07	8667	6202.75	2
2010	31	3	3108107	4.228744e+07	6816	6204.14	2
2010	12	1	1200302	2.0052081e+08	32311	6205.96	2
2010	26	2	2611507	1.501889e+08	24187	6209.49	2
2010	17	1	1721208	1.4054214e+08	22608	6216.48	2
2010	31	3	3150158	4.421566e+07	7101	6226.68	2
2010	25	2	2504306	1.7912514e+08	28766	6226.97	2
2010	25	2	2514651	1.048717e+07	1684	6227.54	2
2010	25	2	2503308	5.945511e+07	9546	6228.28	2
2010	28	2	2806206	1.206846e+08	19362	6233.06	2
2010	27	2	2706505	9.212708e+07	14772	6236.6	2
2010	24	2	2414308	1.431995e+07	2295	6239.63	2
2010	25	2	2504850	1.105195e+07	1771	6240.52	2
2010	17	1	1703909	2.871548e+07	4601	6241.14	2
2010	21	2	2109106	2.7925258e+08	44719	6244.61	2
2010	17	1	1701002	6.177104e+07	9873	6256.56	2
2010	12	1	1200336	9.54187e+07	15246	6258.61	2
2010	31	3	3120102	2.631803e+07	4204	6260.24	2
2010	24	2	2412609	9.942183e+07	15866	6266.35	2
2010	29	2	2916005	1.2660951e+08	20199	6268.11	2
2010	23	2	2302602	3.7721058e+08	60163	6269.81	2
2010	26	2	2603108	1.1808031e+08	18833	6269.86	2
2010	15	1	1504059	1.7497192e+08	27892	6273.19	2
2010	35	3	3503505	2.316875e+07	3693	6273.69	2
2010	24	2	2414407	1.950796e+08	31076	6277.5	2
2010	29	2	2929057	8.191867e+07	13042	6281.14	2
2010	31	3	3171808	6.641534e+07	10572	6282.19	2
2010	22	2	2206407	6.496423e+07	10337	6284.63	2
2010	32	3	3204005	1.3529408e+08	21520	6286.9	2
2010	21	2	2112209	9.7715259e+08	155396	6288.15	2
2010	25	2	2512101	2.0217723e+08	32117	6295.02	2
2010	24	2	2402402	4.677198e+07	7429	6295.86	2
2010	29	2	2929602	1.0458652e+08	16597	6301.53	2
2010	50	5	5006358	7.785965e+07	12355	6301.87	2
2010	23	2	2313609	2.00408e+08	31792	6303.72	2
2010	41	4	4113254	4.009957e+07	6361	6303.97	2
2010	27	2	2706307	4.4415218e+08	70434	6305.93	2
2010	15	1	1502954	2.0032612e+08	31745	6310.48	2
2010	31	3	3150901	3.294015e+07	5219	6311.58	2
2010	12	1	1200328	4.1234e+07	6531	6313.58	2
2010	17	1	1705557	2.949863e+07	4669	6317.98	2
2010	17	1	1702703	2.178864e+07	3446	6322.88	2
2010	26	2	2608909	3.5164262e+08	55574	6327.47	2
2010	31	3	3170305	1.708719e+07	2700	6328.59	2
2010	31	3	3165602	1.253239e+07	1980	6329.49	2
2010	31	3	3144672	2.362291e+07	3732	6329.83	2
2010	51	5	5107776	4.68533e+07	7399	6332.38	2
2010	31	3	3123700	6.50962e+07	10276	6334.78	2
2010	25	2	2512903	1.4558296e+08	22979	6335.48	2
2010	25	2	2512200	2.443486e+07	3854	6340.13	2
2010	23	2	2311405	4.5601806e+08	71912	6341.33	2
2010	28	2	2806800	6.507218e+07	10257	6344.17	2
2010	28	2	2805505	1.3943163e+08	21968	6347.03	2
2010	15	1	1507409	9.649396e+07	15196	6349.96	2
2010	29	2	2929750	7.11378e+07	11201	6351.02	2
2010	15	1	1502772	1.1629501e+08	18295	6356.66	2
2010	25	2	2513406	9.37135e+07	14729	6362.52	2
2010	29	2	2916500	2.0537317e+08	32278	6362.64	2
2010	22	2	2202901	1.6169984e+08	25408	6364.13	2
2010	41	4	4123857	7.317942e+07	11497	6365.09	2
2010	17	1	1702554	1.0168563e+08	15965	6369.28	2
2010	23	2	2309102	7.318469e+07	11485	6372.2	2
2010	31	3	3121100	5.081742e+07	7971	6375.29	2
2010	31	3	3160108	2.609199e+07	4090	6379.46	2
2010	31	3	3154002	1.520352e+08	23818	6383.21	2
2010	31	3	3150208	2.594514e+07	4063	6385.71	2
2010	52	5	5203559	4.813803e+07	7536	6387.74	2
2010	29	2	2901700	7.378445e+07	11548	6389.37	2
2010	27	2	2706448	7.252647e+07	11349	6390.56	2
2010	17	1	1709005	7.720418e+07	12064	6399.55	2
2010	29	2	2911204	1.9428028e+08	30329	6405.76	2
2010	21	2	2111573	2.839243e+07	4428	6412.02	2
2010	28	2	2807501	8.257148e+07	12873	6414.32	2
2010	29	2	2932606	1.0583936e+08	16499	6414.9	2
2010	12	1	1200609	2.2796251e+08	35526	6416.78	2
2010	31	3	3131208	1.1659574e+08	18169	6417.29	2
2010	29	2	2912905	1.2163098e+08	18946	6419.88	2
2010	31	3	3142403	4.512287e+07	7028	6420.44	2
2010	25	2	2512788	1.105777e+07	1722	6421.47	2
2010	28	2	2801009	1.0768403e+08	16766	6422.76	2
2010	31	3	3156205	1.359135e+07	2116	6423.13	2
2010	28	2	2804102	7.093654e+07	11034	6428.9	2
2010	28	2	2805307	5.380768e+07	8369	6429.4	2
2010	35	3	3552007	3.723946e+07	5792	6429.47	2
2010	25	2	2508604	7.5428e+07	11730	6430.35	2
2010	17	1	1720937	1.250824e+07	1945	6430.97	2
2010	35	3	3538501	9.084139e+07	14107	6439.46	2
2010	31	3	3158706	1.44068e+07	2235	6445.99	2
2010	24	2	2404804	1.337714e+07	2074	6449.92	2
2010	24	2	2408904	1.3125476e+08	20347	6450.82	2
2010	28	2	2804607	1.5868291e+08	24579	6456.04	2
2010	26	2	2601201	4.4713263e+08	69157	6465.47	2
2010	21	2	2105153	8.114212e+07	12543	6469.12	2
2010	31	3	3154200	7.065945e+07	10918	6471.83	2
2010	24	2	2415008	1.85989e+07	2872	6475.94	2
2010	24	2	2405801	2.0854496e+08	32203	6475.95	2
2010	31	3	3153202	2.530219e+07	3907	6476.12	2
2010	35	3	3501400	3.012148e+07	4650	6477.74	2
2010	27	2	2703502	4.526644e+07	6986	6479.59	2
2010	31	3	3145406	1.283691e+07	1981	6480.02	2
2010	35	3	3556354	5.708378e+07	8801	6486.06	2
2010	27	2	2708709	4.650517e+07	7170	6486.08	2
2010	41	4	4117503	2.3317164e+08	35941	6487.62	2
2010	31	3	3137304	2.743675e+07	4227	6490.83	2
2010	26	2	2605509	7.424766e+07	11437	6491.88	2
2010	32	3	3200508	4.878632e+07	7513	6493.59	2
2010	26	2	2601904	3.8101716e+08	58675	6493.69	2
2010	15	1	1507458	1.6643915e+08	25584	6505.6	2
2010	17	1	1707207	4.659427e+07	7161	6506.67	2
2010	17	1	1715150	1.487473e+07	2286	6506.88	2
2010	31	3	3142304	3.063773e+07	4700	6518.67	2
2010	25	2	2513901	2.013088e+08	30880	6519.07	2
2010	31	3	3102100	7.930831e+07	12158	6523.14	2
2010	31	3	3147808	1.360177e+07	2084	6526.76	2
2010	31	3	3169208	6.233258e+07	9542	6532.44	2
2010	31	3	3129400	3.286356e+07	5029	6534.81	2
2010	17	1	1719004	1.650197e+07	2523	6540.62	2
2010	26	2	2613008	3.4834241e+08	53232	6543.85	2
2010	31	3	3107703	3.597198e+07	5495	6546.31	2
2010	31	3	3104403	1.899508e+07	2901	6547.77	2
2010	43	4	4304713	4.790184e+07	7313	6550.23	2
2010	31	3	3144375	2.154128e+07	3288	6551.48	2
2010	27	2	2700409	2.907606e+08	44379	6551.76	2
2010	31	3	3124906	6.913197e+07	10541	6558.39	2
2010	35	3	3509957	2.87736e+07	4387	6558.83	2
2010	25	2	2516102	9.015655e+07	13739	6562.09	2
2010	31	3	3155900	3.473111e+07	5292	6562.95	2
2010	15	1	1507607	3.3832977e+08	51527	6566.07	2
2010	31	3	3168002	2.0290321e+08	30894	6567.72	2
2010	15	1	1502707	2.9903403e+08	45530	6567.85	2
2010	24	2	2403608	1.6129537e+08	24550	6570.08	2
2010	31	3	3165578	3.435082e+07	5225	6574.32	2
2010	12	1	1200393	6.031759e+07	9172	6576.28	2
2010	52	5	5205802	6.804146e+07	10344	6577.87	2
2010	29	2	2927705	1.7235419e+08	26198	6578.91	2
2010	25	2	2517100	1.64857e+07	2504	6583.75	2
2010	31	3	3155405	5.74456e+07	8715	6591.58	2
2010	23	2	2308708	4.0929254e+08	62086	6592.35	2
2010	31	3	3156452	2.79695e+07	4242	6593.47	2
2010	26	2	2616183	5.206169e+07	7894	6595.1	2
2010	13	1	1304260	7.855902e+07	11906	6598.27	2
2010	21	2	2103000	1.02508564e+09	155202	6604.85	2
2010	29	2	2902252	6.873565e+07	10403	6607.29	2
2010	31	3	3145059	4.891278e+07	7398	6611.62	2
2010	27	2	2701704	1.1300223e+08	17077	6617.22	2
2010	31	3	3123528	4.901077e+07	7402	6621.29	2
2010	15	1	1506609	1.5253352e+08	23033	6622.39	2
2010	24	2	2409506	2.332478e+07	3521	6624.48	2
2010	32	3	3203304	9.024681e+07	13600	6635.8	2
2010	22	2	2207702	9.6740789e+08	145729	6638.4	2
2010	28	2	2801108	2.621441e+07	3947	6641.6	2
2010	23	2	2311504	1.2907285e+08	19422	6645.7	2
2010	31	3	3135076	3.36904e+07	5068	6647.67	2
2010	31	3	3159407	2.381979e+07	3583	6648	2
2010	23	2	2302206	3.2800878e+08	49334	6648.74	2
2010	17	1	1715705	3.294381e+07	4954	6649.94	2
2010	27	2	2707305	1.7118248e+08	25718	6656.14	2
2010	17	1	1711803	1.485324e+07	2231	6657.66	2
2010	31	3	3155009	1.643438e+07	2468	6658.99	2
2010	29	2	2919504	2.8450791e+08	42705	6662.17	2
2010	31	3	3163607	1.727185e+07	2592	6663.52	2
2010	52	5	5204953	3.346467e+07	5022	6663.61	2
2010	29	2	2932200	1.379392e+08	20697	6664.7	2
2010	27	2	2706703	4.0252926e+08	60389	6665.61	2
2010	31	3	3149408	1.192705e+07	1789	6666.88	2
2010	52	5	5209903	8.299365e+07	12438	6672.59	2
2010	52	5	5207907	8.049284e+07	12058	6675.47	2
2010	51	5	5106422	2.0535135e+08	30762	6675.49	2
2010	29	2	2917300	1.7771917e+08	26592	6683.18	2
2010	31	3	3136405	2.878396e+07	4305	6686.17	2
2010	31	3	3157104	4.593515e+07	6862	6694.13	2
2010	23	2	2312502	5.290101e+07	7902	6694.64	2
2010	31	3	3149101	7.679394e+07	11467	6696.95	2
2010	43	4	4315404	6.84679e+07	10222	6698.09	2
2010	35	3	3542800	2.249324e+07	3358	6698.4	2
2010	28	2	2800100	1.525326e+07	2275	6704.73	2
2010	35	3	3503604	7.097981e+07	10581	6708.23	2
2010	31	3	3120607	3.186177e+07	4749	6709.15	2
2010	28	2	2800704	5.197657e+07	7745	6710.98	2
2010	28	2	2800506	1.1343086e+08	16882	6719.04	2
2010	26	2	2611309	1.6160096e+08	24033	6724.13	2
2010	31	3	3127388	2.461124e+07	3659	6726.22	2
2010	15	1	1501451	1.0987128e+08	16324	6730.66	2
2010	31	3	3151305	7.316338e+07	10866	6733.24	2
2010	24	2	2414605	8.754383e+07	12985	6741.92	2
2010	31	3	3149952	4.741197e+07	7030	6744.23	2
2010	24	2	2404200	1.5161359e+08	22467	6748.28	2
2010	25	2	2512002	1.1491061e+08	17020	6751.5	2
2010	14	1	1400704	5.500976e+07	8147	6752.15	2
2010	24	2	2406403	1.806937e+07	2674	6757.43	2
2010	26	2	2609204	8.283189e+07	12257	6757.93	2
2010	51	5	5107297	2.434049e+07	3601	6759.37	2
2010	31	3	3134103	3.945262e+07	5836	6760.22	2
2010	12	1	1200351	9.600493e+07	14200	6760.91	2
2010	31	3	3140852	6.747713e+07	9977	6763.27	2
2010	15	1	1504422	7.3217062e+08	108251	6763.64	2
2010	25	2	2515906	4.219636e+07	6238	6764.41	2
2010	31	3	3160504	1.202377e+07	1777	6766.33	2
2010	35	3	3505401	5.229933e+07	7729	6766.64	2
2010	29	2	2922755	4.499804e+07	6648	6768.66	2
2010	29	2	2929008	9.545968e+07	14099	6770.67	2
2010	41	4	4119509	6.315876e+08	93279	6770.95	2
2010	26	2	2603009	2.0918028e+08	30883	6773.31	2
2010	27	2	2707909	4.669926e+07	6893	6774.88	2
2010	31	3	3144003	1.8073798e+08	26672	6776.32	2
2010	17	1	1708304	3.366316e+07	4960	6786.93	2
2010	26	2	2605103	2.3283406e+08	34305	6787.18	2
2010	29	2	2913200	1.7259997e+08	25422	6789.39	2
2010	31	3	3120003	2.125991e+07	3129	6794.47	2
2010	29	2	2929305	2.2635206e+08	33289	6799.61	2
2010	17	1	1700251	1.623444e+07	2387	6801.19	2
2010	31	3	3107901	7.116742e+07	10457	6805.72	2
2010	24	2	2413904	8.055619e+07	11836	6806.03	2
2010	31	3	3111309	7.846513e+07	11518	6812.39	2
2010	41	4	4122651	3.807167e+07	5586	6815.55	2
2010	26	2	2614501	3.983805e+08	58444	6816.45	2
2010	28	2	2803906	8.21861e+07	12056	6817.03	2
2010	31	3	3101706	2.64551e+08	38779	6822.02	2
2010	17	1	1718881	1.97464e+07	2894	6823.22	2
2010	52	5	5220686	4.448218e+07	6512	6830.8	2
2010	35	3	3525805	3.027864e+07	4430	6834.91	2
2010	27	2	2703908	2.873146e+07	4202	6837.57	2
2010	31	3	3121506	2.058582e+07	3009	6841.42	2
2010	23	2	2306900	2.3562397e+08	34416	6846.35	2
2010	41	4	4100400	7.0690091e+08	103245	6846.83	2
2010	31	3	3129004	5.956277e+07	8697	6848.66	2
2010	35	3	3554201	3.294362e+07	4809	6850.41	2
2010	23	2	2313401	4.7228879e+08	68901	6854.6	2
2010	31	3	3119104	1.6394462e+08	23901	6859.32	2
2010	41	4	4117271	5.06952e+07	7389	6860.9	2
2010	29	2	2908101	1.2475554e+08	18182	6861.49	2
2010	31	3	3101300	1.859229e+07	2709	6863.16	2
2010	15	1	1500404	3.6181275e+08	52714	6863.69	2
2010	29	2	2930501	5.309687e+08	77285	6870.27	2
2010	31	3	3123908	9.811702e+07	14262	6879.61	2
2010	31	3	3164506	7.325838e+07	10647	6880.66	2
2010	15	1	1508357	9.275623e+07	13480	6881.03	2
2010	31	3	3110400	2.171339e+07	3154	6884.4	2
2010	35	3	3549607	2.82504e+07	4097	6895.39	2
2010	31	3	3105301	3.683426e+07	5340	6897.8	2
2010	31	3	3127206	2.661346e+07	3854	6905.41	2
2010	17	1	1718659	1.184768e+07	1714	6912.3	2
2010	24	2	2401651	1.676248e+07	2425	6912.36	2
2010	52	5	5201801	5.789723e+07	8375	6913.1	2
2010	51	5	5106778	7.434584e+07	10754	6913.32	2
2010	29	2	2911709	5.4490675e+08	78801	6914.97	2
2010	32	3	3200359	5.050718e+07	7303	6915.95	2
2010	12	1	1200054	4.201745e+07	6075	6916.45	2
2010	31	3	3165008	7.309562e+07	10553	6926.53	2
2010	31	3	3135902	3.306389e+07	4768	6934.54	2
2010	31	3	3116159	7.49315e+07	10792	6943.25	2
2010	31	3	3135050	2.334056e+08	33587	6949.28	2
2010	52	5	5212055	1.593474e+07	2293	6949.3	2
2010	43	4	4300604	1.36073208e+09	195718	6952.51	2
2010	52	5	5214861	5.92042e+07	8514	6953.75	2
2010	35	3	3532306	4.647113e+07	6681	6955.71	2
2010	52	5	5208301	3.455168e+07	4967	6956.25	2
2010	24	2	2408300	2.472594e+08	35541	6957.02	2
2010	27	2	2704500	2.0003231e+08	28746	6958.61	2
2010	17	1	1716653	3.515773e+07	5052	6959.17	2
2010	17	1	1710508	4.945908e+07	7104	6962.15	2
2010	12	1	1200500	2.6452813e+08	37993	6962.55	2
2010	21	2	2108207	2.7507764e+08	39481	6967.34	2
2010	31	3	3102704	6.246458e+07	8962	6969.94	2
2010	26	2	2616308	2.1425762e+08	30731	6972.04	2
2010	24	2	2402600	4.7313973e+08	67844	6973.94	2
2010	51	5	5101605	5.297441e+07	7591	6978.58	2
2010	31	3	3138005	4.513216e+07	6465	6981	2
2010	51	5	5102793	7.669686e+07	10985	6981.96	2
2010	12	1	1200344	5.580285e+07	7989	6984.96	2
2010	31	3	3121902	2.302086e+07	3292	6992.97	2
2010	41	4	4128807	4.212263e+07	6011	7007.59	2
2010	27	2	2709301	4.3745748e+08	62401	7010.42	2
2010	35	3	3551207	2.539587e+07	3622	7011.56	2
2010	31	3	3161007	1.2173135e+08	17352	7015.41	2
2010	31	3	3112505	6.23219e+07	8880	7018.23	2
2010	31	3	3124609	1.733921e+07	2470	7019.92	2
2010	17	1	1707702	5.968668e+07	8502	7020.31	2
2010	29	2	2930105	5.2253727e+08	74431	7020.43	2
2010	15	1	1505635	8.921127e+07	12703	7022.85	2
2010	31	3	3132503	2.2598261e+08	32177	7023.11	2
2010	31	3	3132701	1.6017399e+08	22797	7026.1	2
2010	24	2	2411809	2.390492e+07	3401	7028.79	2
2010	22	2	2204402	7.309291e+07	10393	7032.9	2
2010	35	3	3535101	7.69738e+07	10938	7037.28	2
2010	35	3	3523305	1.0895947e+08	15471	7042.82	2
2010	15	1	1505551	4.25322e+07	6029	7054.6	2
2010	31	3	3161056	2.386001e+07	3382	7055	2
2010	50	5	5005202	1.3887785e+08	19653	7066.5	2
2010	23	2	2309805	8.205379e+07	11607	7069.34	2
2010	24	2	2408201	1.6864135e+08	23818	7080.42	2
2010	26	2	2607406	3.09614e+07	4369	7086.61	2
2010	31	3	3171402	2.645088e+07	3732	7087.59	2
2010	32	3	3203809	1.0208168e+08	14396	7090.97	2
2010	15	1	1503754	9.966036e+07	14040	7098.32	2
2010	31	3	3159308	3.548108e+07	4996	7101.9	2
2010	43	4	4300646	5.200913e+07	7323	7102.16	2
2010	31	3	3169059	2.806064e+07	3950	7103.96	2
2010	31	3	3104502	1.2559115e+08	17674	7105.98	2
2010	15	1	1506187	3.3388e+08	46974	7107.76	2
2010	25	2	2500403	1.3993764e+08	19686	7108.49	2
2010	15	1	1504802	3.9423623e+08	55459	7108.61	2
2010	29	2	2923001	2.7396375e+08	38537	7109.11	2
2010	31	3	3138302	2.284056e+07	3205	7126.54	2
2010	17	1	1703107	3.809921e+07	5346	7126.68	2
2010	31	3	3171071	3.94356e+07	5533	7127.34	2
2010	31	3	3101631	4.337906e+07	6078	7137.06	2
2010	50	5	5003157	1.0039832e+08	14064	7138.67	2
2010	23	2	2307007	2.3018901e+08	32239	7140.08	2
2010	27	2	2707701	4.8969986e+08	68512	7147.65	2
2010	27	2	2702405	3.4373329e+08	48090	7147.71	2
2010	51	5	5106109	8.287362e+07	11592	7149.21	2
2010	23	2	2311306	5.7633363e+08	80605	7150.1	2
2010	26	2	2606408	5.4870848e+08	76669	7156.85	2
2010	35	3	3523800	5.399939e+07	7545	7156.98	2
2010	31	3	3133303	1.5030426e+08	21001	7157	2
2010	52	5	5207808	8.315939e+07	11603	7167.06	2
2010	52	5	5220702	2.022374e+07	2821	7169	2
2010	26	2	2610707	2.15569609e+09	300611	7171.05	2
2010	41	4	4117800	1.0666705e+08	14870	7173.31	2
2010	31	3	3108552	1.0218915e+08	14226	7183.27	2
2010	31	3	3118403	1.597575e+08	22232	7185.93	2
2010	32	3	3201803	3.247764e+07	4515	7193.28	2
2010	52	5	5219704	7.4139e+07	10304	7195.17	2
2010	31	3	3120805	1.0504916e+08	14596	7197.12	2
2010	28	2	2800670	1.8393745e+08	25528	7205.32	2
2010	25	2	2508901	3.0503659e+08	42330	7206.16	2
2010	31	3	3109105	7.851176e+07	10892	7208.2	2
2010	31	3	3159506	4.111486e+07	5700	7213.13	2
2010	29	2	2914653	2.0490559e+08	28399	7215.24	2
2010	15	1	1500347	1.8087325e+08	25061	7217.32	2
2010	23	2	2303501	4.774337e+08	66124	7220.28	2
2010	26	2	2612604	2.8550162e+08	39473	7232.83	2
2010	31	3	3100807	2.92924e+07	4049	7234.48	2
2010	31	3	3154150	4.748419e+07	6561	7237.34	2
2010	31	3	3153608	6.935994e+07	9576	7243.1	2
2010	43	4	4302055	1.671156e+07	2307	7243.85	2
2010	31	3	3102050	3.839063e+07	5297	7247.62	2
2010	29	2	2920007	6.365856e+07	8782	7248.75	2
2010	31	3	3118502	1.251957e+07	1727	7249.32	2
2010	23	2	2307700	8.200901e+08	112926	7262.19	2
2010	31	3	3158508	5.81281e+07	8004	7262.38	2
2010	31	3	3114105	9.987909e+07	13752	7262.88	2
2010	24	2	2413359	7.467256e+07	10281	7263.16	2
2010	33	3	3302270	6.9296707e+08	95391	7264.49	2
2010	23	2	2306801	7.562311e+07	10405	7267.96	2
2010	29	2	2913705	2.6387667e+08	36290	7271.33	2
2010	31	3	3108909	1.0664599e+08	14663	7273.14	2
2010	35	3	3536802	4.20539e+07	5780	7275.76	2
2010	28	2	2801702	1.2021784e+08	16519	7277.55	2
2010	15	1	1506583	1.253161e+08	17198	7286.67	2
2010	41	4	4115002	4.994968e+07	6854	7287.67	2
2010	31	3	3119609	2.177054e+07	2983	7298.2	2
2010	17	1	1722081	8.02234e+07	10978	7307.65	2
2010	21	2	2109502	1.4776222e+08	20218	7308.45	2
2010	25	2	2502706	3.737344e+07	5111	7312.35	2
2010	25	2	2504355	3.324636e+07	4546	7313.32	2
2010	28	2	2806701	5.7730835e+08	78876	7319.19	2
2010	29	2	2933208	2.7512915e+08	37587	7319.8	2
2010	41	4	4117206	4.030522e+07	5506	7320.24	2
2010	12	1	1200708	1.1725989e+08	16016	7321.42	2
2010	29	2	2933505	1.6245078e+08	22181	7323.87	2
2010	17	1	1720903	1.103502e+08	15053	7330.78	2
2010	31	3	3136603	4.073412e+07	5554	7334.2	2
2010	31	3	3135100	4.9011518e+08	66803	7336.72	2
2010	32	3	3203163	7.942843e+07	10825	7337.5	2
2010	32	3	3202553	6.585603e+07	8964	7346.72	2
2010	24	2	2411429	1.856967e+07	2526	7351.41	2
2010	31	3	3111903	4.111371e+07	5589	7356.18	2
2010	31	3	3112307	2.560758e+08	34796	7359.35	2
2010	25	2	2506004	2.2885562e+08	31095	7359.88	3
2010	41	4	4114708	4.38364e+07	5956	7360.04	3
2010	31	3	3152709	6.182914e+07	8395	7365	3
2010	43	4	4301859	2.275494e+07	3089	7366.44	3
2010	17	1	1714203	6.630832e+07	9000	7367.59	3
2010	15	1	1505106	3.6316853e+08	49254	7373.38	3
2010	52	5	5208103	3.606705e+07	4891	7374.17	3
2010	35	3	3514007	5.856974e+07	7941	7375.61	3
2010	31	3	3138708	4.003351e+07	5425	7379.45	3
2010	51	5	5107404	3.056888e+07	4142	7380.22	3
2010	35	3	3551405	8.311151e+07	11259	7381.78	3
2010	17	1	1702158	3.721233e+07	5030	7398.08	3
2010	28	2	2807600	1.6765673e+08	22660	7398.8	3
2010	35	3	3522802	1.0765047e+08	14546	7400.69	3
2010	31	3	3137403	9.079293e+07	12267	7401.4	3
2010	51	5	5106653	4.022961e+07	5427	7412.86	3
2010	17	1	1713700	1.546701e+07	2085	7418.23	3
2010	22	2	2203230	3.48971e+07	4704	7418.6	3
2010	31	3	3127404	3.13093e+07	4220	7419.27	3
2010	31	3	3122470	2.83592e+07	3817	7429.71	3
2010	31	3	3145703	1.578885e+07	2123	7437.05	3
2010	41	4	4109500	5.854248e+07	7870	7438.69	3
2010	41	4	4107124	2.611275e+07	3510	7439.53	3
2010	31	3	3124401	3.295587e+07	4429	7440.93	3
2010	24	2	2412401	3.148805e+07	4231	7442.22	3
2010	24	2	2405702	9.017687e+07	12115	7443.41	3
2010	41	4	4102505	9.422347e+07	12653	7446.73	3
2010	52	5	5205521	2.624844e+07	3523	7450.59	3
2010	31	3	3159001	2.99984e+07	4023	7456.72	3
2010	28	2	2805208	4.458197e+07	5973	7463.92	3
2010	31	3	3164803	1.206645e+07	1616	7466.86	3
2010	29	2	2921104	1.6094674e+08	21541	7471.65	3
2010	52	5	5221452	2.568547e+07	3435	7477.57	3
2010	31	3	3138609	1.2095532e+08	16166	7482.08	3
2010	26	2	2608206	1.1808312e+08	15774	7485.93	3
2010	41	4	4124707	8.493851e+07	11336	7492.81	3
2010	28	2	2806602	8.535154e+07	11389	7494.21	3
2010	21	2	2104107	8.727046e+07	11644	7494.89	3
2010	28	2	2807105	2.9097335e+08	38724	7514.03	3
2010	28	2	2807006	2.782657e+07	3702	7516.63	3
2010	32	3	3202454	1.6808809e+08	22346	7522.07	3
2010	27	2	2703205	1.7526286e+08	23298	7522.66	3
2010	13	1	1301852	3.0644563e+08	40735	7522.91	3
2010	35	3	3523701	4.449135e+07	5914	7523.06	3
2010	27	2	2702108	1.5066595e+08	20022	7525.02	3
2010	13	1	1303569	1.9386321e+08	25758	7526.33	3
2010	35	3	3548302	2.114209e+07	2806	7534.6	3
2010	17	1	1706100	5.439268e+07	7218	7535.7	3
2010	31	3	3138674	4.70087e+07	6236	7538.28	3
2010	29	2	2910701	4.2451619e+08	56312	7538.65	3
2010	32	3	3200169	8.874546e+07	11771	7539.33	3
2010	31	3	3167004	1.505993e+07	1996	7545.05	3
2010	15	1	1503457	3.8776677e+08	51383	7546.6	3
2010	29	2	2903409	1.6524488e+08	21838	7566.85	3
2010	17	1	1706506	3.995877e+07	5273	7577.99	3
2010	28	2	2802809	1.2023153e+08	15861	7580.32	3
2010	41	4	4108551	2.53009e+07	3337	7581.93	3
2010	31	3	3149606	3.089799e+07	4075	7582.33	3
2010	31	3	3148202	4.017488e+07	5298	7583.03	3
2010	24	2	2402204	2.3446682e+08	30900	7587.92	3
2010	41	4	4103057	6.003335e+07	7911	7588.59	3
2010	41	4	4126207	5.111902e+07	6736	7588.93	3
2010	29	2	2928604	4.3878383e+08	57811	7589.97	3
2010	31	3	3128105	1.0503166e+08	13838	7590.09	3
2010	25	2	2510659	9.54231e+06	1256	7597.38	3
2010	51	5	5106273	2.846429e+07	3746	7598.58	3
2010	13	1	1302504	6.4743991e+08	85144	7604.06	3
2010	31	3	3149507	2.408889e+07	3165	7611.02	3
2010	31	3	3139607	2.0646134e+08	27115	7614.28	3
2010	31	3	3146602	1.187973e+07	1560	7615.21	3
2010	51	5	5103353	1.9136675e+08	25127	7615.98	3
2010	31	3	3160801	3.49079e+07	4577	7626.81	3
2010	17	1	1701101	3.214086e+07	4213	7628.97	3
2010	31	3	3101201	4.713239e+07	6173	7635.25	3
2010	35	3	3533106	1.663396e+07	2178	7637.26	3
2010	31	3	3157005	2.9927228e+08	39182	7638	3
2010	21	2	2106102	8.691753e+07	11374	7641.77	3
2010	16	1	1600253	3.26328e+07	4267	7647.71	3
2010	31	3	3171709	6.598328e+07	8626	7649.35	3
2010	31	3	3110202	3.096506e+07	4047	7651.36	3
2010	15	1	1502855	9.383461e+07	12262	7652.47	3
2010	52	5	5218300	2.4042282e+08	31417	7652.63	3
2010	17	1	1716703	6.586663e+07	8607	7652.68	3
2010	17	1	1703305	2.884925e+07	3768	7656.38	3
2010	52	5	5214903	2.65582e+07	3468	7658.08	3
2010	31	3	3105004	6.064086e+07	7917	7659.58	3
2010	17	1	1711506	2.687767e+07	3507	7664.01	3
2010	26	2	2609501	2.3599967e+08	30782	7666.81	3
2010	41	4	4100509	1.5730202e+08	20516	7667.28	3
2010	27	2	2701001	1.9770709e+08	25780	7669.01	3
2010	31	3	3134806	5.754856e+07	7502	7671.1	3
2010	17	1	1706001	3.846633e+07	5009	7679.44	3
2010	31	3	3169703	1.3862798e+08	18046	7681.92	3
2010	35	3	3512605	3.842383e+07	5001	7683.23	3
2010	41	4	4117057	8.639205e+07	11239	7686.81	3
2010	17	1	1720150	1.111665e+07	1445	7693.18	3
2010	29	2	2904050	1.1429128e+08	14851	7695.86	3
2010	41	4	4115457	3.835412e+07	4983	7696.99	3
2010	52	5	5221700	1.0639297e+08	13821	7697.92	3
2010	32	3	3204807	8.019318e+07	10417	7698.3	3
2010	26	2	2614857	1.5982734e+08	20745	7704.38	3
2010	12	1	1200385	1.3263266e+08	17203	7709.86	3
2010	31	3	3160009	2.727529e+07	3534	7717.97	3
2010	51	5	5100359	4.055332e+07	5249	7725.91	3
2010	29	2	2904902	2.475653e+08	32035	7727.96	3
2010	51	5	5105309	1.723351e+07	2229	7731.5	3
2010	31	3	3128402	6.724411e+07	8688	7739.88	3
2010	12	1	1200807	1.1466146e+08	14806	7744.26	3
2010	17	1	1713809	4.450364e+07	5746	7745.15	3
2010	15	1	1504000	1.9395972e+08	25028	7749.71	3
2010	31	3	3110103	3.851963e+07	4970	7750.43	3
2010	29	2	2915304	5.513238e+07	7110	7754.2	3
2010	17	1	1712454	2.033397e+07	2622	7755.14	3
2010	29	2	2915601	4.9152222e+08	63355	7758.22	3
2010	31	3	3164902	1.638117e+07	2110	7763.59	3
2010	12	1	1200435	3.585518e+07	4612	7774.32	3
2010	28	2	2806008	1.3343546e+08	17163	7774.6	3
2010	31	3	3121308	3.699805e+07	4757	7777.6	3
2010	31	3	3110004	3.1735435e+08	40786	7780.96	3
2010	31	3	3157278	2.172115e+07	2789	7788.15	3
2010	28	2	2806503	2.922381e+07	3752	7788.86	3
2010	31	3	3161205	5.053602e+07	6487	7790.35	3
2010	52	5	5209457	1.797073e+07	2306	7793.03	3
2010	28	2	2802601	4.406205e+07	5648	7801.35	3
2010	31	3	3142502	1.842536e+07	2360	7807.36	3
2010	31	3	3150604	5.003129e+07	6406	7810.07	3
2010	35	3	3520004	1.8272764e+08	23370	7818.9	3
2010	52	5	5209291	1.855311e+07	2372	7821.71	3
2010	32	3	3203007	2.1386221e+08	27340	7822.32	3
2010	17	1	1713957	2.467685e+07	3152	7828.95	3
2010	41	4	4103503	6.317258e+07	8069	7829.05	3
2010	31	3	3126000	5.173427e+07	6603	7834.96	3
2010	15	1	1506807	2.30969151e+09	294774	7835.47	3
2010	25	2	2515708	2.332109e+07	2975	7839.02	3
2010	32	3	3200102	2.4370723e+08	31086	7839.77	3
2010	13	1	1301159	1.880225e+08	23963	7846.37	3
2010	17	1	1717206	2.291979e+07	2920	7849.24	3
2010	35	3	3527702	3.949185e+07	5030	7851.26	3
2010	31	3	3111705	3.636029e+07	4631	7851.5	3
2010	11	1	1100080	1.0758305e+08	13700	7852.78	3
2010	26	2	2605202	4.9904036e+08	63535	7854.57	3
2010	28	2	2800407	7.620483e+07	9699	7856.98	3
2010	17	1	1712504	3.423525e+07	4352	7866.56	3
2010	31	3	3140407	2.336665e+07	2968	7872.86	3
2010	35	3	3528601	7.086836e+07	8999	7875.14	3
2010	31	3	3124203	1.80099e+08	22859	7878.69	3
2010	31	3	3126406	2.128267e+07	2701	7879.55	3
2010	15	1	1500131	5.35987e+07	6792	7891.45	3
2010	32	3	3203700	1.4510123e+08	18387	7891.51	3
2010	51	5	5103379	1.1834226e+08	14987	7896.33	3
2010	29	2	2904704	1.4732412e+08	18622	7911.29	3
2010	31	3	3102001	1.0855562e+08	13714	7915.68	3
2010	26	2	2615409	2.8207631e+08	35631	7916.6	3
2010	51	5	5107701	1.4004166e+08	17682	7920.01	3
2010	52	5	5205208	3.699024e+07	4670	7920.82	3
2010	25	2	2509339	3.419323e+07	4316	7922.43	3
2010	31	3	3142254	3.618697e+07	4561	7934	3
2010	29	2	2913457	1.0594753e+08	13347	7937.93	3
2010	31	3	3108404	1.1863543e+08	14935	7943.45	3
2010	31	3	3115607	9.62753e+06	1212	7943.5	3
2010	28	2	2803500	7.5470103e+08	94852	7956.62	3
2010	31	3	3130606	5.494102e+07	6904	7957.85	3
2010	17	1	1701051	2.52233e+07	3169	7959.39	3
2010	31	3	3127602	9.309332e+07	11687	7965.54	3
2010	43	4	4300638	5.062631e+07	6355	7966.37	3
2010	31	3	3162302	2.177188e+07	2732	7969.21	3
2010	52	5	5208400	8.51917e+07	10681	7976	3
2010	52	5	5215603	2.2098059e+08	27689	7980.81	3
2010	26	2	2608750	1.8135191e+08	22719	7982.39	3
2010	31	3	3110806	2.841123e+07	3559	7982.92	3
2010	31	3	3164001	6.66886e+07	8353	7983.79	3
2010	28	2	2805000	2.3698e+07	2968	7984.5	3
2010	41	4	4121901	1.0805153e+08	13522	7990.8	3
2010	23	2	2310209	2.5287192e+08	31638	7992.66	3
2010	51	5	5106703	1.425744e+07	1783	7996.32	3
2010	52	5	5209606	2.853178e+07	3568	7996.57	3
2010	52	5	5204904	1.4713405e+08	18395	7998.59	3
2010	28	2	2804458	6.809118e+07	8510	8001.31	3
2010	52	5	5210158	2.276338e+07	2844	8004	3
2010	31	3	3103009	7.664261e+07	9573	8006.12	3
2010	32	3	3202652	9.391861e+07	11729	8007.38	3
2010	52	5	5204557	2.660243e+07	3322	8007.96	3
2010	31	3	3131109	5.390574e+07	6729	8010.96	3
2010	15	1	1500958	2.1296071e+08	26579	8012.37	3
2010	31	3	3102803	9.738629e+07	12146	8017.97	3
2010	51	5	5106174	2.422798e+07	3021	8019.85	3
2010	15	1	1500602	8.4240787e+08	105030	8020.64	3
2010	31	3	3100302	1.0681397e+08	13311	8024.49	3
2010	17	1	1702307	5.410251e+07	6742	8024.7	3
2010	31	3	3145505	2.03285e+07	2533	8025.46	3
2010	28	2	2801306	2.4702487e+08	30769	8028.37	3
2010	35	3	3556602	8.646148e+07	10769	8028.74	3
2010	43	4	4306353	2.304078e+07	2866	8039.35	3
2010	32	3	3203106	8.754534e+07	10888	8040.53	3
2010	31	3	3146404	3.724143e+07	4631	8041.77	3
2010	41	4	4111704	3.938914e+07	4895	8046.81	3
2010	43	4	4318507	2.0544191e+08	25523	8049.29	3
2010	27	2	2705606	9.716103e+07	12069	8050.46	3
2010	31	3	3170479	2.612265e+07	3238	8067.53	3
2010	17	1	1707108	5.134341e+07	6363	8069.06	3
2010	25	2	2501807	8.0609092e+08	99758	8080.46	3
2010	52	5	5214879	2.28478e+07	2826	8084.85	3
2010	35	3	3542503	5.923244e+07	7325	8086.34	3
2010	17	1	1713601	5.433118e+07	6717	8088.61	3
2010	29	2	2910750	1.4278108e+08	17652	8088.66	3
2010	52	5	5200100	1.2749772e+08	15752	8094.07	3
2010	31	3	3120201	9.147459e+07	11301	8094.38	3
2010	31	3	3125309	2.735716e+07	3377	8101.02	3
2010	17	1	1716307	3.719938e+07	4588	8107.97	3
2010	35	3	3533304	2.790022e+07	3441	8108.17	3
2010	35	3	3510609	3.00008476e+09	369908	8110.35	3
2010	23	2	2304202	9.8540991e+08	121462	8112.91	3
2010	28	2	2803807	2.8117e+07	3461	8123.95	3
2010	29	2	2907509	4.1510316e+08	51075	8127.33	3
2010	31	3	3107208	4.064111e+07	5000	8128.22	3
2010	26	2	2610004	4.8410668e+08	59524	8132.97	3
2010	29	2	2914604	5.4033122e+08	66404	8137.03	3
2010	29	2	2928802	3.9008114e+08	47901	8143.49	3
2010	43	4	4323002	1.94882025e+09	239234	8146.08	3
2010	35	3	3545001	1.2754623e+08	15639	8155.65	3
2010	41	4	4115507	3.755701e+07	4599	8166.34	3
2010	31	3	3122405	4.703892e+07	5760	8166.48	3
2010	31	3	3107000	2.151664e+07	2634	8168.81	3
2010	35	3	3505005	2.545449e+07	3116	8168.96	3
2010	28	2	2804409	1.5124835e+08	18511	8170.73	3
2010	17	1	1715754	6.001334e+07	7342	8173.98	3
2010	27	2	2708501	2.6499871e+08	32416	8174.94	3
2010	16	1	1600709	1.0167586e+08	12435	8176.59	3
2010	31	3	3106408	6.162842e+07	7536	8177.87	3
2010	43	4	4311734	2.451882e+07	2997	8181.12	3
2010	43	4	4301107	1.113662e+08	13608	8183.88	3
2010	52	5	5215801	1.914549e+07	2339	8185.33	3
2010	41	4	4104402	1.3641269e+08	16662	8187.05	3
2010	23	2	2309706	5.9162651e+08	72249	8188.72	3
2010	32	3	3201100	7.768843e+07	9479	8195.85	3
2010	31	3	3104908	1.4994412e+08	18292	8197.25	3
2010	31	3	3165206	5.455781e+07	6655	8198.02	3
2010	31	3	3153806	1.53131e+07	1866	8206.38	3
2010	15	1	1500206	4.4076745e+08	53605	8222.51	3
2010	23	2	2311801	5.7530432e+08	69892	8231.33	3
2010	35	3	3520608	3.977583e+07	4828	8238.57	3
2010	52	5	5209200	1.1536272e+08	14002	8239.02	3
2010	52	5	5211404	7.044088e+07	8549	8239.66	3
2010	28	2	2803401	1.0669165e+08	12947	8240.65	3
2010	14	1	1400027	7.690122e+07	9330	8242.36	3
2010	35	3	3548203	5.374061e+07	6516	8247.48	3
2010	25	2	2510808	8.3094869e+08	100695	8252.13	3
2010	43	4	4305124	5.286143e+07	6404	8254.44	3
2010	17	1	1700350	4.676386e+07	5663	8257.79	3
2010	52	5	5204607	2.797314e+07	3387	8258.97	3
2010	35	3	3542305	3.20486e+07	3879	8262.08	3
2010	29	2	2918001	1.25550334e+09	151921	8264.19	3
2010	31	3	3120409	4.138646e+07	5007	8265.72	3
2010	31	3	3114006	9.042564e+07	10927	8275.43	3
2010	42	4	4202073	6.822322e+07	8244	8275.5	3
2010	35	3	3503950	1.497267e+07	1809	8276.77	3
2010	31	3	3116704	5.838604e+07	7054	8277.01	3
2010	35	3	3526308	4.006792e+07	4840	8278.5	3
2010	51	5	5107263	2.462333e+07	2974	8279.53	3
2010	52	5	5204854	5.19325e+07	6270	8282.7	3
2010	14	1	1400050	1.3496739e+08	16286	8287.33	3
2010	17	1	1700400	6.294227e+07	7595	8287.33	3
2010	23	2	2305357	1.5250765e+08	18393	8291.61	3
2010	31	3	3155801	1.4200329e+08	17123	8293.13	3
2010	43	4	4300307	5.84293e+07	7045	8293.73	3
2010	17	1	1718865	5.476361e+07	6599	8298.77	3
2010	51	5	5102603	1.1809738e+08	14222	8303.85	3
2010	26	2	2612505	7.2701546e+08	87538	8305.14	3
2010	31	3	3128501	3.266293e+07	3932	8306.95	3
2010	35	3	3550001	8.644812e+07	10404	8309.12	3
2010	43	4	4301750	5.834816e+07	7018	8314.07	3
2010	52	5	5206800	2.283949e+07	2747	8314.34	3
2010	35	3	3529807	1.0012964e+08	12042	8315.03	3
2010	31	3	3114600	3.286652e+07	3952	8316.43	3
2010	24	2	2400208	4.4298696e+08	53245	8319.79	3
2010	24	2	2411601	2.475556e+07	2974	8324	3
2010	31	3	3121605	3.8194843e+08	45884	8324.22	3
2010	51	5	5106208	3.825041e+07	4593	8327.98	3
2010	17	1	1704600	1.112733e+07	1335	8335.08	3
2010	43	4	4311775	5.759268e+07	6908	8337.1	3
2010	17	1	1720499	3.655637e+07	4384	8338.59	3
2010	14	1	1400407	7.444217e+07	8926	8339.93	3
2010	23	2	2301109	5.7708067e+08	69167	8343.29	3
2010	52	5	5213772	3.434091e+07	4114	8347.33	3
2010	25	2	2516201	5.4934663e+08	65807	8347.84	3
2010	31	3	3158805	3.855114e+07	4613	8357.06	3
2010	26	2	2611903	1.8517601e+08	22140	8363.87	3
2010	35	3	3510302	1.4681585e+08	17533	8373.69	3
2010	16	1	1600808	1.0428532e+08	12445	8379.7	3
2010	31	3	3140209	2.33695e+07	2788	8382.18	3
2010	29	2	2918456	8.34982e+07	9960	8383.35	3
2010	31	3	3115904	2.341407e+07	2792	8386.13	3
2010	42	4	4204178	3.008659e+07	3585	8392.35	3
2010	23	2	2301901	4.6471548e+08	55373	8392.46	3
2010	29	2	2917508	6.660352e+08	79285	8400.52	3
2010	17	1	1710904	2.968905e+07	3534	8400.98	3
2010	32	3	3202009	5.37663e+07	6399	8402.3	3
2010	52	5	5221858	1.11749933e+09	132947	8405.6	3
2010	31	3	3124005	1.5099005e+08	17958	8407.95	3
2010	31	3	3112406	5.96237e+07	7089	8410.73	3
2010	51	5	5106000	5.417025e+07	6438	8414.14	3
2010	51	5	5101308	8.714898e+07	10355	8416.13	3
2010	29	2	2900801	1.7946458e+08	21319	8418.06	3
2010	31	3	3162559	8.630611e+07	10245	8424.22	3
2010	17	1	1705102	2.763736e+07	3280	8426.03	3
2010	31	3	3107307	3.932551e+08	46595	8439.86	3
2010	51	5	5106851	3.071402e+07	3639	8440.24	3
2010	22	2	2207801	1.6713447e+08	19783	8448.39	3
2010	41	4	4104253	2.0989272e+08	24836	8451.15	3
2010	32	3	3204252	5.898301e+07	6979	8451.5	3
2010	31	3	3159357	5.538685e+07	6552	8453.43	3
2010	31	3	3130002	2.423707e+07	2866	8456.76	3
2010	29	2	2907004	7.000301e+07	8271	8463.67	3
2010	41	4	4113759	4.365608e+07	5156	8467.04	3
2010	33	3	3301405	1.7953154e+08	21200	8468.47	3
2010	41	4	4125357	5.121629e+07	6047	8469.7	3
2010	31	3	3145802	2.707824e+07	3197	8469.89	3
2010	41	4	4127882	5.301138e+07	6258	8470.98	3
2010	17	1	1703206	3.784778e+07	4467	8472.75	3
2010	26	2	2612000	9.525273e+07	11242	8472.93	3
2010	35	3	3521606	6.600618e+07	7787	8476.46	3
2010	26	2	2605707	2.4829038e+08	29284	8478.7	3
2010	41	4	4105201	1.4370365e+08	16948	8479.09	3
2010	31	3	3149705	7.557034e+07	8912	8479.62	3
2010	51	5	5103254	2.237934e+08	26390	8480.23	3
2010	24	2	2409407	2.3535954e+08	27733	8486.62	3
2010	31	3	3155306	4.472661e+07	5267	8491.86	3
2010	43	4	4307104	5.741781e+07	6757	8497.53	3
2010	52	5	5201603	3.218571e+07	3785	8503.49	3
2010	52	5	5210562	3.835315e+07	4508	8507.8	3
2010	26	2	2609808	1.1215882e+08	13176	8512.36	3
2010	41	4	4104451	1.1031945e+08	12952	8517.56	3
2010	31	3	3129202	5.213683e+07	6120	8519.09	3
2010	16	1	1600055	3.756344e+07	4409	8519.72	3
2010	51	5	5106505	2.7074673e+08	31778	8519.94	3
2010	31	3	3139805	1.0017974e+08	11758	8520.13	3
2010	16	1	1600212	3.950246e+07	4634	8524.48	3
2010	52	5	5213855	2.017683e+07	2365	8531.43	3
2010	41	4	4115739	3.262566e+07	3822	8536.28	3
2010	35	3	3539400	1.0306653e+08	12072	8537.65	3
2010	52	5	5219506	2.480783e+07	2905	8539.7	3
2010	31	3	3104809	4.24085e+07	4962	8546.65	3
2010	35	3	3543006	1.561711e+08	18272	8547.02	3
2010	41	4	4107009	1.1904849e+08	13924	8549.88	3
2010	50	5	5000708	2.0411911e+08	23846	8559.89	3
2010	52	5	5212006	2.568191e+07	3000	8560.64	3
2010	31	3	3168309	3.246328e+07	3792	8560.99	3
2010	31	3	3116209	2.384465e+07	2785	8561.81	3
2010	52	5	5210604	4.648402e+07	5429	8562.17	3
2010	42	4	4205175	2.584782e+07	3018	8564.55	3
2010	41	4	4105102	9.575156e+07	11178	8566.07	3
2010	31	3	3137700	1.6809209e+08	19616	8569.13	3
2010	24	2	2402006	5.3796788e+08	62727	8576.34	3
2010	41	4	4111308	3.075557e+07	3585	8578.96	3
2010	51	5	5103437	4.202187e+07	4898	8579.39	3
2010	21	2	2109908	6.7090773e+08	78182	8581.36	3
2010	41	4	4115101	8.782717e+07	10224	8590.29	3
2010	52	5	5200050	5.904294e+07	6868	8596.82	3
2010	41	4	4124004	4.513074e+07	5249	8597.97	3
2010	31	3	3137502	1.4743055e+08	17136	8603.56	3
2010	23	2	2307304	2.15133492e+09	249936	8607.54	3
2010	35	3	3527801	3.747556e+07	4353	8609.13	3
2010	43	4	4311254	5.326861e+07	6185	8612.55	3
2010	31	3	3117702	1.1153436e+08	12950	8612.69	3
2010	31	3	3159704	2.779003e+07	3224	8619.73	3
2010	51	5	5106315	1.72842e+07	2005	8620.55	3
2010	31	3	3165800	1.610946e+07	1868	8623.91	3
2010	33	3	3302858	1.45283433e+09	168403	8627.13	3
2010	41	4	4110201	9.440928e+07	10943	8627.37	3
2010	41	4	4121000	1.0138717e+08	11749	8629.43	3
2010	28	2	2804300	6.34273e+07	7342	8638.97	3
2010	41	4	4107652	7.0628919e+08	81687	8646.29	3
2010	43	4	4305173	8.889801e+07	10280	8647.67	3
2010	32	3	3200201	2.6621508e+08	30784	8647.84	3
2010	52	5	5214101	3.32312e+07	3842	8649.45	3
2010	33	3	3306156	8.22121e+07	9503	8651.17	3
2010	29	2	2932903	7.6801785e+08	88729	8655.77	3
2010	17	1	1713304	1.0932296e+08	12626	8658.56	3
2010	29	2	2909802	5.0728422e+08	58584	8659.09	3
2010	12	1	1200427	1.2422149e+08	14334	8666.21	3
2010	52	5	5203104	3.221318e+07	3714	8673.45	3
2010	31	3	3119708	2.863825e+07	3301	8675.63	3
2010	52	5	5204656	3.170424e+07	3654	8676.58	3
2010	31	3	3109600	3.170636e+07	3654	8677.16	3
2010	52	5	5213004	9.998835e+07	11516	8682.56	3
2010	41	4	4100459	3.739146e+07	4306	8683.57	3
2010	31	3	3118700	8.068364e+07	9287	8687.8	3
2010	33	3	3305901	8.933453e+07	10281	8689.28	3
2010	35	3	3549003	2.427001e+07	2793	8689.59	3
2010	42	4	4201950	8.334116e+07	9590	8690.42	3
2010	15	1	1500800	4.10051265e+09	471744	8692.24	3
2010	31	3	3138500	4.648722e+07	5347	8694.08	3
2010	41	4	4117214	3.401931e+07	3911	8698.37	3
2010	31	3	3117504	1.5589457e+08	17914	8702.39	3
2010	27	2	2707800	5.795461e+07	6656	8707.12	3
2010	16	1	1600279	3.4680264e+08	39805	8712.54	3
2010	24	2	2402501	8.520169e+07	9775	8716.29	3
2010	35	3	3554607	2.306799e+07	2646	8718.06	3
2010	52	5	5200159	2.164763e+07	2483	8718.34	3
2010	17	1	1717503	5.839495e+07	6696	8720.87	3
2010	35	3	3544103	3.8451533e+08	44084	8722.33	3
2010	43	4	4323101	4.611164e+07	5285	8725	3
2010	29	2	2933257	5.940579e+07	6802	8733.58	3
2010	41	4	4122156	1.1941059e+08	13660	8741.62	3
2010	25	2	2506301	4.8390379e+08	55340	8744.2	3
2010	11	1	1100148	1.7365129e+08	19845	8750.38	3
2010	11	1	1100130	2.7220091e+08	31107	8750.47	3
2010	41	4	4100905	4.763951e+07	5444	8750.83	3
2010	23	2	2303709	2.84260608e+09	324738	8753.54	3
2010	26	2	2615300	4.7133856e+08	53823	8757.2	3
2010	31	3	3166709	7.372805e+07	8419	8757.34	3
2010	51	5	5103007	1.559755e+08	17799	8763.16	3
2010	41	4	4126256	7.259726e+08	82842	8763.34	3
2010	31	3	3135308	3.461745e+07	3950	8763.91	3
2010	35	3	3525508	1.0322305e+08	11771	8769.27	3
2010	42	4	4217253	4.132522e+07	4710	8773.93	3
2010	42	4	4201000	7.574496e+07	8627	8779.99	3
2010	31	3	3112000	1.2816077e+08	14592	8782.95	3
2010	41	4	4112504	1.0828892e+08	12325	8786.12	3
2010	31	3	3144409	4.089012e+07	4650	8793.57	3
2010	14	1	1400282	7.632746e+07	8676	8797.54	3
2010	31	3	3130507	1.0108993e+08	11488	8799.61	3
2010	31	3	3129905	2.997322e+07	3406	8800.12	3
2010	27	2	2708303	1.9979085e+08	22689	8805.63	3
2010	31	3	3123205	1.2147995e+08	13781	8815.03	3
2010	51	5	5105176	9.933753e+07	11269	8815.11	3
2010	35	3	3505609	2.5132439e+08	28503	8817.47	3
2010	31	3	3104304	1.2119761e+08	13729	8827.85	3
2010	31	3	3106903	1.205599e+08	13653	8830.29	3
2010	52	5	5205513	1.5357597e+08	17391	8830.77	3
2010	52	5	5211206	2.3040947e+08	26085	8833.03	3
2010	31	3	3142106	9.058619e+07	10251	8836.81	3
2010	35	3	3553658	2.409673e+07	2726	8839.59	3
2010	14	1	1400605	5.970616e+07	6750	8845.36	3
2010	31	3	3166402	1.583724e+07	1790	8847.62	3
2010	31	3	3129806	1.40702461e+09	159026	8847.76	3
2010	41	4	4103479	3.7928e+07	4285	8851.34	3
2010	31	3	3106101	3.013104e+07	3404	8851.66	3
2010	31	3	3144607	2.2775475e+08	25721	8854.82	3
2010	32	3	3204500	1.0855537e+08	12255	8858.05	3
2010	31	3	3117207	2.435219e+07	2749	8858.56	3
2010	43	4	4304689	1.0290243e+08	11613	8860.97	3
2010	16	1	1600402	1.5094569e+08	17030	8863.52	3
2010	31	3	3119401	9.2004011e+08	103797	8863.84	3
2010	15	1	1501907	2.2809664e+08	25700	8875.36	3
2010	43	4	4315107	9.376003e+07	10560	8878.79	3
2010	43	4	4310702	3.70355e+07	4171	8879.28	3
2010	11	1	1100403	1.5223517e+08	17144	8879.79	3
2010	21	2	2104552	1.4123265e+08	15895	8885.35	3
2010	31	3	3161502	9.107309e+07	10246	8888.65	3
2010	12	1	1200104	1.9069891e+08	21438	8895.37	3
2010	41	4	4116406	3.411502e+07	3834	8898.02	3
2010	29	2	2918902	3.322001e+07	3733	8899.01	3
2010	26	2	2614204	3.5879743e+08	40306	8901.84	3
2010	32	3	3202256	9.686568e+07	10874	8908.01	3
2010	17	1	1707553	3.390604e+07	3805	8910.92	3
2010	24	2	2403103	3.8026845e+08	42668	8912.26	3
2010	31	3	3149002	1.949342e+07	2187	8913.32	3
2010	31	3	3112109	4.643217e+07	5209	8913.83	3
2010	27	2	2700300	1.90887927e+09	214067	8917.2	3
2010	41	4	4103156	3.389379e+07	3796	8928.82	3
2010	51	5	5107750	3.487479e+07	3903	8935.38	3
2010	35	3	3534906	1.1557725e+08	12934	8935.92	3
2010	35	3	3533254	4.107237e+07	4595	8938.49	3
2010	35	3	3506706	1.2215125e+08	13658	8943.57	3
2010	35	3	3537909	2.3640557e+08	26411	8951.03	3
2010	27	2	2700607	6.780881e+07	7573	8954.02	3
2010	43	4	4317004	7.388949e+07	8244	8962.82	3
2010	31	3	3145455	4.718361e+07	5264	8963.45	3
2010	52	5	5215256	3.546873e+07	3953	8972.61	3
2010	31	3	3131505	8.547384e+07	9522	8976.46	3
2010	52	5	5200803	7.26506e+07	8093	8976.97	3
2010	31	3	3115805	9.21962e+07	10270	8977.23	3
2010	23	2	2307601	5.0577821e+08	56281	8986.66	3
2010	43	4	4321436	8.877409e+07	9878	8987.05	3
2010	43	4	4304507	4.788219e+08	53268	8988.92	3
2010	31	3	3113305	2.9120895e+08	32321	9009.9	3
2010	35	3	3537206	9.204849e+07	10213	9012.87	3
2010	52	5	5214705	2.031556e+07	2254	9013.11	3
2010	31	3	3128907	6.572412e+07	7290	9015.65	3
2010	22	2	2201903	2.0410307e+08	22632	9018.34	3
2010	24	2	2401404	7.73401e+07	8569	9025.57	3
2010	28	2	2806305	1.2572372e+08	13914	9035.77	3
2010	14	1	1400233	7.331805e+07	8114	9035.99	3
2010	26	2	2600054	8.5329133e+08	94428	9036.42	3
2010	21	2	2106755	2.1999942e+08	24331	9041.94	3
2010	31	3	3162906	2.2677496e+08	25062	9048.56	3
2010	43	4	4320354	4.702606e+07	5197	9048.69	3
2010	14	1	1400175	1.2472031e+08	13778	9052.13	3
2010	33	3	3303955	2.0571192e+08	22724	9052.63	3
2010	17	1	1703883	2.087788e+07	2305	9057.65	3
2010	31	3	3120508	9.2542e+07	10214	9060.31	3
2010	52	5	5221908	3.317464e+07	3661	9061.63	3
2010	42	4	4212254	6.017164e+07	6631	9074.29	3
2010	26	2	2604809	1.1309422e+08	12458	9078.04	3
2010	35	3	3503158	2.264291e+07	2492	9086.24	3
2010	23	2	2305100	3.785426e+07	4165	9088.66	3
2010	29	2	2918407	1.79972081e+09	197984	9090.23	3
2010	31	3	3122355	5.348859e+07	5884	9090.52	3
2010	35	3	3518008	1.789941e+07	1969	9090.61	3
2010	41	4	4121752	6.664059e+07	7327	9095.21	3
2010	35	3	3555505	4.028372e+07	4429	9095.44	3
2010	41	4	4108452	4.9247e+07	5414	9096.23	3
2010	41	4	4108700	6.028922e+07	6625	9100.26	3
2010	41	4	4113429	3.616148e+07	3972	9104.1	3
2010	41	4	4108650	6.834604e+07	7504	9107.95	3
2010	35	3	3516804	3.820877e+07	4193	9112.51	3
2010	31	3	3157203	2.5383605e+08	27850	9114.4	3
2010	41	4	4120309	3.664636e+07	4020	9116.01	3
2010	41	4	4109203	4.78875e+07	5247	9126.64	3
2010	31	3	3114907	2.047837e+07	2242	9133.97	3
2010	32	3	3201159	1.0889262e+08	11921	9134.52	3
2010	41	4	4110805	9.685568e+07	10602	9135.6	3
2010	35	3	3553906	6.038361e+07	6605	9142.11	3
2010	31	3	3115508	1.9869481e+08	21719	9148.43	3
2010	32	3	3202702	1.293457e+08	14134	9151.39	3
2010	41	4	4116208	1.4384945e+08	15718	9151.89	3
2010	52	5	5209804	3.688729e+07	4029	9155.44	3
2010	12	1	1200450	1.8461961e+08	20153	9160.9	3
2010	43	4	4306908	2.2479015e+08	24537	9161.27	3
2010	23	2	2305506	8.8447378e+08	96523	9163.35	3
2010	51	5	5102694	4.37459e+07	4767	9176.82	3
2010	17	1	1711100	2.23905e+07	2439	9180.19	3
2010	51	5	5108808	4.525321e+07	4929	9181.01	3
2010	33	3	3300159	9.378812e+07	10215	9181.41	3
2010	17	1	1703602	1.897024e+07	2066	9182.11	3
2010	43	4	4314605	1.8215792e+08	19831	9185.51	3
2010	31	3	3137809	1.7975368e+08	19569	9185.63	3
2010	50	5	5004007	9.130117e+07	9928	9196.33	3
2010	26	2	2607802	1.4436676e+08	15698	9196.51	3
2010	42	4	4209409	4.7449518e+08	51554	9203.85	3
2010	35	3	3553104	5.426726e+07	5894	9207.2	3
2010	35	3	3553500	7.382038e+07	8015	9210.28	3
2010	31	3	3136900	8.509619e+07	9238	9211.54	3
2010	28	2	2804508	2.9977226e+08	32514	9219.79	3
2010	43	4	4321477	5.961566e+07	6461	9227	3
2010	51	5	5107206	4.674701e+07	5061	9236.71	3
2010	35	3	3541109	3.809156e+07	4123	9238.8	3
2010	31	3	3132206	1.143439e+08	12371	9242.9	3
2010	32	3	3202306	2.575988e+08	27853	9248.51	3
2010	17	1	1720655	4.689999e+07	5071	9248.67	3
2010	29	2	2925501	2.5538763e+08	27612	9249.15	3
2010	52	5	5220280	1.841653e+07	1991	9249.89	3
2010	33	3	3303005	2.4830539e+08	26829	9255.11	3
2010	52	5	5202601	3.378725e+07	3650	9256.78	3
2010	35	3	3556958	1.608872e+07	1737	9262.36	3
2010	33	3	3301157	1.1615436e+08	12540	9262.71	3
2010	26	2	2609600	3.47982298e+09	375559	9265.72	3
2010	31	3	3114709	3.106486e+07	3350	9273.09	3
2010	42	4	4210704	2.63354e+07	2838	9279.56	3
2010	52	5	5200605	6.370468e+07	6864	9280.98	3
2010	26	2	2606002	1.20119347e+09	129392	9283.37	3
2010	17	1	1718907	4.241927e+07	4568	9286.18	3
2010	31	3	3119005	3.190707e+07	3435	9288.81	3
2010	31	3	3141900	3.567794e+07	3840	9291.13	3
2010	22	2	2208007	6.8282784e+08	73417	9300.68	3
2010	41	4	4107751	7.714697e+07	8293	9302.66	3
2010	29	2	2910503	3.7122101e+08	39883	9307.75	3
2010	15	1	1503606	9.0610652e+08	97343	9308.39	3
2010	52	5	5207535	6.498215e+07	6980	9309.76	3
2010	16	1	1600204	8.34854e+07	8964	9313.41	3
2010	29	2	2925303	1.18126296e+09	126770	9318.16	3
2010	43	4	4301636	1.0117163e+08	10855	9320.28	3
2010	11	1	1100502	9.542009e+07	10237	9321.1	3
2010	52	5	5203939	2.387162e+07	2561	9321.21	3
2010	35	3	3518909	4.434697e+07	4754	9328.35	3
2010	43	4	4314704	9.817181e+07	10524	9328.37	3
2010	29	2	2916856	1.3565967e+08	14539	9330.74	3
2010	25	2	2503704	5.4532117e+08	58437	9331.78	3
2010	31	3	3132909	9.659836e+07	10349	9334.08	3
2010	42	4	4203204	5.8174887e+08	62289	9339.51	3
2010	31	3	3169000	1.4793094e+08	15839	9339.66	3
2010	42	4	4207205	1.0902037e+08	11672	9340.33	3
2010	43	4	4308300	1.0006325e+08	10712	9341.23	3
2010	35	3	3520301	2.6946576e+08	28844	9342.18	3
2010	11	1	1100379	1.1997401e+08	12826	9353.97	3
2010	11	1	1101708	1.2135937e+08	12969	9357.65	3
2010	33	3	3301876	2.139658e+08	22858	9360.65	3
2010	52	5	5207501	3.108716e+07	3318	9369.25	3
2010	17	1	1703701	4.86124e+07	5188	9370.16	3
2010	51	5	5104104	3.0144221e+08	32150	9376.12	3
2010	43	4	4302006	1.0441034e+08	11133	9378.46	3
2010	23	2	2313807	1.8549676e+08	19765	9385.11	3
2010	41	4	4119954	1.963687e+08	20919	9387.1	3
2010	31	3	3151701	1.498849e+08	15961	9390.7	3
2010	31	3	3108305	1.6087825e+08	17129	9392.16	3
2010	31	3	3130200	8.714748e+07	9265	9406.1	3
2010	31	3	3102902	1.0453344e+08	11112	9407.26	3
2010	29	2	2931350	1.30292548e+09	138491	9408.02	3
2010	15	1	1504455	2.5821791e+08	27442	9409.59	3
2010	35	3	3531100	4.3587425e+08	46310	9412.1	3
2010	35	3	3549201	2.417069e+07	2566	9419.6	3
2010	43	4	4321832	2.744578e+07	2912	9425.06	3
2010	26	2	2613909	7.4690834e+08	79241	9425.78	3
2010	43	4	4322152	4.143335e+07	4395	9427.38	3
2010	50	5	5007703	1.016453e+08	10780	9429.06	3
2010	41	4	4113809	4.330332e+07	4592	9430.17	3
2010	35	3	3500808	3.669411e+07	3891	9430.51	3
2010	33	3	3300456	4.42712352e+09	469261	9434.25	3
2010	11	1	1101435	7.073861e+07	7498	9434.33	3
2010	31	3	3122702	4.899391e+07	5193	9434.61	3
2010	35	3	3538907	2.1441083e+08	22724	9435.44	3
2010	14	1	1400472	2.4146487e+08	25587	9437.01	3
2010	31	3	3154903	1.3404531e+08	14198	9441.14	3
2010	31	3	3108008	1.6287401e+08	17244	9445.26	3
2010	35	3	3534104	5.759834e+07	6097	9447	3
2010	15	1	1502202	6.0146376e+08	63628	9452.82	3
2010	31	3	3110301	1.2884937e+08	13630	9453.37	3
2010	41	4	4124202	2.583994e+07	2732	9458.25	3
2010	41	4	4103206	6.213486e+07	6568	9460.24	3
2010	52	5	5216908	2.616878e+07	2766	9460.88	3
2010	41	4	4106803	1.707514e+08	18043	9463.58	3
2010	35	3	3509304	9.238341e+07	9759	9466.48	3
2010	16	1	1600501	1.9337129e+08	20426	9466.92	3
2010	35	3	3546900	7.807222e+07	8246	9467.89	3
2010	52	5	5208806	3.225925e+08	34061	9471.02	3
2010	17	1	1709807	1.553553e+07	1639	9478.67	3
2010	41	4	4123709	8.299691e+07	8755	9479.94	3
2010	42	4	4202081	2.755781e+07	2906	9483.07	3
2010	52	5	5216809	9.755482e+07	10285	9485.15	3
2010	52	5	5219803	1.0658137e+08	11236	9485.7	3
2010	14	1	1400209	1.7439357e+08	18384	9486.16	3
2010	31	3	3133501	2.0284811e+08	21377	9489.08	3
2010	41	4	4128401	1.0885952e+08	11472	9489.15	3
2010	31	3	3100104	6.367222e+07	6704	9497.65	3
2010	26	2	2604007	7.1155219e+08	74851	9506.25	3
2010	11	1	1100700	1.204401e+08	12669	9506.68	3
2010	41	4	4124400	1.7979706e+08	18905	9510.56	3
2010	50	5	5003488	9.856361e+07	10362	9512.03	3
2010	43	4	4311429	2.366155e+07	2487	9514.09	3
2010	41	4	4108007	1.0685472e+08	11220	9523.59	3
2010	52	5	5210307	2.750574e+07	2888	9524.15	3
2010	41	4	4113304	2.9324566e+08	30783	9526.22	3
2010	11	1	1100346	1.6068881e+08	16864	9528.51	3
2010	35	3	3552700	1.3998959e+08	14686	9532.18	3
2010	22	2	2203909	5.5009979e+08	57707	9532.64	3
2010	31	3	3103603	2.691071e+07	2823	9532.66	3
2010	29	2	2915502	2.0114039e+08	21094	9535.43	3
2010	41	4	4126900	5.563836e+07	5834	9536.91	3
2010	35	3	3507159	3.408712e+07	3571	9545.54	3
2010	35	3	3546504	5.319493e+07	5568	9553.69	3
2010	52	5	5218391	3.099302e+07	3244	9553.95	3
2010	43	4	4311122	3.991481e+07	4177	9555.86	3
2010	33	3	3303609	4.5065273e+08	47074	9573.28	3
2010	43	4	4310504	7.734494e+07	8078	9574.76	3
2010	29	2	2901353	1.3809756e+08	14417	9578.8	3
2010	31	3	3158003	1.0123024e+08	10561	9585.29	3
2010	12	1	1200252	1.4499703e+08	15126	9585.95	3
2010	31	3	3165305	6.718843e+07	7008	9587.39	3
2010	52	5	5219902	5.866113e+07	6117	9589.85	3
2010	51	5	5107800	1.7662148e+08	18409	9594.3	3
2010	31	3	3142205	1.3257878e+08	13800	9607.16	3
2010	31	3	3170503	9.890704e+07	10291	9611.02	3
2010	29	2	2932507	2.3173923e+08	24106	9613.34	3
2010	33	3	3302809	1.7247224e+08	17940	9613.84	3
2010	11	1	1101203	9.969242e+07	10354	9628.4	3
2010	52	5	5210208	3.0113768e+08	31274	9629.01	3
2010	35	3	3541901	1.0905655e+08	11325	9629.72	3
2010	35	3	3544707	2.306613e+07	2395	9630.95	3
2010	43	4	4312450	6.00688e+07	6231	9640.31	3
2010	52	5	5202155	7.243513e+07	7513	9641.31	3
2010	31	3	3109501	1.332857e+08	13823	9642.31	3
2010	52	5	5208905	2.3877966e+08	24745	9649.61	3
2010	52	5	5215009	7.846229e+07	8129	9652.15	3
2010	35	3	3540259	3.934473e+07	4074	9657.52	3
2010	52	5	5221007	3.419285e+07	3540	9659	3
2010	41	4	4112702	1.1456659e+08	11859	9660.73	3
2010	31	3	3140902	1.7054512e+08	17639	9668.64	3
2010	41	4	4116109	1.2190763e+08	12606	9670.6	3
2010	41	4	4107520	1.905904e+07	1970	9674.64	3
2010	11	1	1101302	1.148687e+08	11869	9678.04	3
2010	35	3	3529104	2.045083e+07	2113	9678.58	3
2010	35	3	3520426	8.740194e+07	9027	9682.28	3
2010	11	1	1100338	2.1843124e+08	22552	9685.67	3
2010	52	5	5212808	1.0327141e+08	10659	9688.66	3
2010	42	4	4214151	2.67224e+07	2758	9689.05	3
2010	31	3	3118304	1.12994066e+09	116527	9696.81	3
2010	16	1	1600105	7.762768e+07	8005	9697.4	3
2010	27	2	2706901	3.2318993e+08	33312	9701.91	3
2010	35	3	3505104	6.399891e+07	6593	9707.1	3
2010	32	3	3203403	2.5141639e+08	25898	9707.95	3
2010	31	3	3159209	8.778067e+07	9031	9719.93	3
2010	12	1	1200013	1.2191473e+08	12538	9723.62	3
2010	33	3	3301603	1.0632363e+08	10933	9725.02	3
2010	43	4	4311601	5.621318e+07	5780	9725.46	3
2010	41	4	4110904	4.444414e+07	4568	9729.45	3
2010	21	2	2100055	1.01203714e+09	104013	9729.91	3
2010	35	3	3531704	4.012502e+07	4123	9732	3
2010	32	3	3204054	2.3161389e+08	23789	9736.18	3
2010	14	1	1400506	6.601025e+07	6778	9738.9	3
2010	31	3	3153707	3.229465e+07	3315	9741.98	3
2010	35	3	3546306	2.9200969e+08	29974	9742.1	3
2010	52	5	5200829	3.335969e+07	3424	9742.9	3
2010	32	3	3200136	9.272626e+07	9517	9743.22	3
2010	23	2	2309607	6.0277023e+08	61846	9746.31	3
2010	52	5	5207600	6.157741e+07	6318	9746.35	3
2010	11	1	1101484	5.872697e+07	6018	9758.55	3
2010	43	4	4314068	5.040976e+07	5159	9771.23	3
2010	11	1	1101757	9.148029e+07	9361	9772.49	3
2010	43	4	4316428	2.536728e+07	2595	9775.44	3
2010	26	2	2611408	1.3139873e+08	13439	9777.42	3
2010	13	1	1301902	8.4963655e+08	86840	9783.93	3
2010	31	3	3161809	1.0181944e+08	10405	9785.63	3
2010	41	4	4122172	3.813978e+07	3897	9786.96	3
2010	35	3	3534807	7.628854e+07	7794	9788.11	3
2010	42	4	4215075	4.739025e+07	4838	9795.42	3
2010	41	4	4118808	1.3349334e+08	13622	9799.83	3
2010	43	4	4318101	1.8882139e+08	19258	9804.83	3
2010	16	1	1600550	3.712577e+07	3783	9813.84	3
2010	41	4	4102901	1.5597429e+08	15883	9820.2	3
2010	41	4	4119251	2.573686e+07	2620	9823.23	3
2010	12	1	1200203	7.7104022e+08	78444	9829.18	3
2010	31	3	3126208	8.036957e+07	8173	9833.55	3
2010	14	1	1400456	1.0281361e+08	10448	9840.51	3
2010	41	4	4123105	3.744412e+07	3804	9843.35	3
2010	52	5	5221403	1.02875436e+09	104506	9843.97	3
2010	35	3	3543238	2.153299e+07	2187	9845.9	3
2010	42	4	4206009	1.2812339e+08	13012	9846.56	3
2010	41	4	4106555	3.941581e+07	4003	9846.57	3
2010	31	3	3167400	5.936525e+07	6029	9846.62	3
2010	17	1	1718840	3.276317e+07	3326	9850.62	3
2010	31	3	3154309	1.684392e+08	17099	9850.82	3
2010	31	3	3111002	2.0402628e+08	20701	9855.87	3
2010	35	3	3501806	5.628033e+07	5706	9863.36	3
2010	32	3	3201704	1.1535531e+08	11686	9871.24	3
2010	31	3	3113909	1.1683821e+08	11836	9871.43	3
2010	52	5	5219605	3.942068e+07	3991	9877.39	3
2010	41	4	4118006	1.1639054e+08	11781	9879.51	3
2010	31	3	3128808	7.126969e+07	7210	9884.84	3
2010	35	3	3513900	1.1088513e+08	11209	9892.51	3
2010	35	3	3508702	1.8348678e+08	18536	9898.94	3
2010	42	4	4215653	7.975473e+07	8054	9902.5	3
2010	52	5	5219407	6.861644e+07	6928	9904.22	3
2010	43	4	4312104	5.065195e+07	5111	9910.38	3
2010	14	1	1400159	1.0856754e+08	10951	9913.94	3
2010	11	1	1101609	1.0553546e+08	10644	9915.02	3
2010	43	4	4315073	1.836852e+07	1852	9918.21	3
2010	31	3	3151404	2.5139143e+08	25339	9921.13	3
2010	42	4	4216800	9.201862e+07	9273	9923.28	3
2010	52	5	5221304	2.79702e+07	2817	9929.07	3
2010	14	1	1400308	1.4725238e+08	14814	9940.08	3
2010	43	4	4306502	1.4295681e+08	14380	9941.36	3
2010	26	2	2608503	2.0550522e+08	20653	9950.38	3
2010	43	4	4315008	5.395012e+07	5421	9952.06	3
2010	51	5	5106299	1.0642081e+08	10690	9955.17	3
2010	43	4	4301073	2.719e+07	2730	9959.71	3
2010	15	1	1501253	3.42149e+07	3434	9963.57	3
2010	52	5	5213905	4.986817e+07	5005	9963.67	3
2010	11	1	1101476	3.510545e+07	3523	9964.65	3
2010	43	4	4319356	3.305302e+07	3317	9964.73	3
2010	15	1	1506138	7.5244273e+08	75505	9965.47	3
2010	35	3	3548401	4.266925e+07	4281	9967.12	3
2010	31	3	3100203	2.2632464e+08	22700	9970.25	3
2010	43	4	4314498	4.492297e+07	4503	9976.23	3
2010	41	4	4122107	3.327021e+07	3334	9979.07	3
2010	35	3	3554805	4.0901213e+08	40985	9979.56	3
2010	51	5	5102850	8.216179e+07	8231	9981.99	3
2010	43	4	4310538	5.005167e+07	5011	9988.36	3
2010	24	2	2402303	1.9563873e+08	19582	9990.74	3
2010	24	2	2401008	3.4748536e+08	34777	9991.82	3
2010	35	3	3522109	8.6987298e+08	87053	9992.45	3
2010	31	3	3153509	8.317497e+07	8323	9993.39	3
2010	13	1	1302009	8.202898e+07	8200	10003.53	3
2010	28	2	2802908	8.7051995e+08	86981	10008.16	3
2010	35	3	3518503	1.4581891e+08	14568	10009.54	3
2010	43	4	4309159	3.974588e+07	3970	10011.56	3
2010	35	3	3523107	3.22239209e+09	321854	10011.97	3
2010	43	4	4305132	4.461299e+07	4454	10016.39	3
2010	51	5	5108352	3.064803e+07	3058	10022.25	3
2010	35	3	3530003	2.836184e+07	2827	10032.49	3
2010	31	3	3150109	2.853491e+07	2844	10033.37	3
2010	35	3	3557204	1.2157832e+08	12114	10036.18	3
2010	41	4	4103107	1.104632e+08	11005	10037.55	3
2010	51	5	5106455	2.736379e+07	2726	10038.07	3
2010	31	3	3109402	2.7027858e+08	26921	10039.69	3
2010	35	3	3515103	6.3097663e+08	62846	10040.04	3
2010	35	3	3510708	1.185126e+08	11798	10045.14	3
2010	15	1	1502400	1.73892333e+09	173096	10046.01	3
2010	41	4	4128500	1.9393236e+08	19294	10051.43	3
2010	31	3	3160405	2.6129956e+08	25989	10054.24	3
2010	31	3	3128006	3.1439969e+08	31266	10055.64	3
2010	41	4	4110078	1.1341953e+08	11276	10058.49	3
2010	35	3	3501301	2.3656585e+08	23506	10064.06	3
2010	41	4	4113106	4.532034e+07	4503	10064.48	3
2010	43	4	4312377	3.118201e+07	3098	10065.21	3
2010	11	1	1101500	1.1728083e+08	11649	10067.89	3
2010	31	3	3113404	8.5912532e+08	85322	10069.21	3
2010	32	3	3204401	1.1411455e+08	11333	10069.23	3
2010	33	3	3305133	7.052154e+07	7003	10070.19	3
2010	17	1	1718709	2.588395e+07	2570	10071.58	3
2010	35	3	3517307	5.464191e+07	5425	10072.24	3
2010	51	5	5107883	1.375805e+07	1365	10079.16	3
2010	32	3	3204955	1.1377552e+08	11287	10080.23	3
2010	52	5	5211800	4.2224504e+08	41888	10080.33	3
2010	35	3	3514502	1.2349697e+08	12251	10080.56	3
2010	41	4	4121208	1.7232438e+08	17088	10084.53	3
2010	31	3	3102308	1.5392326e+08	15263	10084.73	3
2010	31	3	3141207	3.795422e+07	3763	10086.16	3
2010	33	3	3303104	1.5222975e+08	15077	10096.82	3
2010	50	5	5005806	1.4536724e+08	14396	10097.75	3
2010	17	1	1721307	2.117627e+07	2097	10098.37	3
2010	31	3	3131000	5.840709e+07	5781	10103.29	3
2010	52	5	5207105	2.504648e+07	2479	10103.46	3
2010	35	3	3551009	3.36063538e+09	332424	10109.48	3
2010	35	3	3523503	1.8257274e+08	18052	10113.71	3
2010	52	5	5203401	8.521123e+07	8423	10116.49	3
2010	41	4	4125456	3.878756e+07	3831	10124.66	3
2010	31	3	3158953	2.7605619e+08	27258	10127.53	3
2010	52	5	5221577	2.974129e+07	2935	10133.32	3
2010	41	4	4100608	1.3844276e+08	13662	10133.42	3
2010	41	4	4112306	4.977423e+07	4910	10137.32	3
2010	35	3	3541208	1.3732969e+08	13544	10139.52	3
2010	50	5	5007950	1.0358302e+08	10215	10140.29	3
2010	41	4	4110300	3.03139e+07	2988	10145.21	3
2010	43	4	4307203	5.243056e+07	5167	10147.2	3
2010	32	3	3204351	1.7804119e+08	17538	10151.74	3
2010	28	2	2801405	2.02939e+08	19990	10152.03	3
2010	35	3	3521507	7.394975e+07	7284	10152.35	3
2010	52	5	5220157	4.692925e+07	4617	10164.45	3
2010	31	3	3169802	4.735281e+07	4658	10165.91	3
2010	42	4	4204459	2.499693e+07	2458	10169.62	3
2010	41	4	4106209	1.6161836e+08	15892	10169.79	3
2010	35	3	3540507	8.474877e+07	8333	10170.26	3
2010	35	3	3523206	4.8756817e+08	47939	10170.6	3
2010	15	1	1501782	5.3405206e+08	52497	10173	3
2010	11	1	1101401	1.434167e+08	14090	10178.62	3
2010	12	1	1200138	8.626496e+07	8474	10179.96	3
2010	51	5	5106158	1.1840018e+08	11630	10180.58	3
2010	41	4	4125407	6.62886e+07	6511	10181.02	3
2010	33	3	3304102	1.8094837e+08	17771	10182.23	3
2010	43	4	4303400	5.163415e+07	5071	10182.24	3
2010	31	3	3101102	2.542959e+08	24969	10184.46	3
2010	17	1	1705508	3.1449096e+08	30879	10184.62	3
2010	31	3	3139102	4.988966e+07	4898	10185.72	3
2010	31	3	3111200	5.2470139e+08	51509	10186.6	3
2010	51	5	5102504	8.9599156e+08	87912	10191.91	3
2010	41	4	4107157	5.125289e+07	5027	10195.52	3
2010	31	3	3150505	8.399118e+07	8236	10198.05	3
2010	41	4	4108106	2.590689e+07	2540	10199.56	3
2010	35	3	3508603	3.0701888e+08	30099	10200.3	3
2010	41	4	4106001	8.445506e+07	8279	10201.12	3
2010	15	1	1503903	4.8075158e+08	47123	10202.06	3
2010	35	3	3538600	2.5648827e+08	25139	10202.8	3
2010	11	1	1101559	5.000115e+07	4893	10218.91	3
2010	43	4	4320651	2.508309e+07	2452	10229.64	3
2010	42	4	4205159	3.686848e+07	3604	10229.88	3
2010	31	3	3111606	2.8261748e+08	27623	10231.24	3
2010	43	4	4321352	5.47524e+07	5351	10232.18	3
2010	35	3	3543808	1.017621e+08	9935	10242.79	3
2010	52	5	5215900	3.648624e+07	3561	10246.06	3
2010	35	3	3544202	1.0835554e+08	10574	10247.36	3
2010	42	4	4215687	2.967739e+07	2896	10247.72	3
2010	35	3	3538204	1.3451999e+08	13104	10265.57	3
2010	31	3	3117108	1.0077729e+08	9814	10268.73	3
2010	41	4	4102406	3.3065034e+08	32182	10274.39	3
2010	42	4	4202156	2.707395e+07	2635	10274.74	3
2010	50	5	5003454	1.2467187e+08	12131	10277.13	3
2010	32	3	3201001	1.4598615e+08	14199	10281.44	3
2010	41	4	4116802	7.635091e+07	7425	10282.95	3
2010	41	4	4114351	3.216569e+07	3127	10286.44	3
2010	43	4	4314555	2.836419e+07	2757	10288.06	3
2010	24	2	2411056	3.793582e+07	3687	10289.08	3
2010	51	5	5106190	3.576502e+07	3475	10292.09	3
2010	50	5	5003801	1.958188e+08	19024	10293.25	3
2010	43	4	4320263	7.368513e+07	7158	10294.09	3
2010	52	5	5200902	3.713428e+07	3607	10295.06	3
2010	52	5	5204706	1.1449322e+08	11115	10300.78	3
2010	24	2	2412203	4.0969552e+08	39771	10301.36	3
2010	52	5	5210901	1.9038431e+08	18481	10301.62	3
2010	31	3	3117900	1.0796191e+08	10480	10301.71	3
2010	15	1	1502764	1.0797698e+08	10478	10305.11	3
2010	43	4	4319737	2.728627e+07	2647	10308.38	3
2010	41	4	4123956	3.680383e+07	3570	10309.2	3
2010	31	3	3157906	1.5480122e+08	15011	10312.52	3
2010	33	3	3304904	1.032720148e+10	999901	10328.22	3
2010	35	3	3556800	1.7889468e+08	17307	10336.55	3
2010	25	2	2513703	1.2448829e+09	120333	10345.32	3
2010	15	1	1508084	3.4835792e+08	33651	10352.08	3
2010	33	3	3301504	2.1128235e+08	20403	10355.46	3
2010	35	3	3551108	9.350862e+07	9027	10358.77	3
2010	35	3	3548609	1.0841179e+08	10462	10362.43	3
2010	42	4	4206207	1.102204e+08	10636	10362.96	3
2010	33	3	3302304	7.763955e+07	7491	10364.38	3
2010	41	4	4120606	5.062479e+08	48793	10375.42	3
2010	11	1	1100064	1.930926e+08	18602	10380.21	3
2010	11	1	1100452	3.3626486e+08	32385	10383.35	3
2010	52	5	5214804	2.148543e+07	2069	10384.45	3
2010	31	3	3101003	1.3215165e+08	12718	10390.91	3
2010	11	1	1101450	4.998624e+07	4810	10392.15	3
2010	32	3	3204708	3.3111996e+08	31859	10393.29	3
2010	51	5	5106265	7.347495e+07	7069	10393.97	3
2010	33	3	3302502	2.37239497e+09	228150	10398.4	3
2010	43	4	4302451	7.980425e+07	7673	10400.66	3
2010	43	4	4300505	8.34888e+07	8027	10401	3
2010	35	3	3501509	3.124557e+07	3000	10415.19	3
2010	28	2	2804003	1.7027263e+08	16338	10421.88	3
2010	41	4	4117008	8.500434e+07	8153	10426.14	3
2010	35	3	3527504	2.351423e+07	2255	10427.6	3
2010	41	4	4100103	8.085397e+07	7753	10428.73	3
2010	35	3	3536570	1.855064e+07	1778	10433.43	3
2010	41	4	4125555	2.189242e+07	2098	10434.9	3
2010	35	3	3526209	2.998242e+08	28732	10435.2	3
2010	52	5	5200506	2.133816e+07	2044	10439.41	3
2010	33	3	3304805	3.921057e+08	37553	10441.39	3
2010	43	4	4309753	4.565308e+07	4371	10444.54	3
2010	41	4	4117297	2.952842e+07	2827	10445.14	3
2010	35	3	3527009	7.010064e+07	6708	10450.3	3
2010	21	2	2109007	2.2476191e+08	21506	10451.13	3
2010	41	4	4125001	1.2053182e+08	11523	10460.11	3
2010	43	4	4309126	2.373946e+07	2269	10462.52	3
2010	35	3	3532108	4.38599e+07	4186	10477.76	3
2010	31	3	3140530	7.519774e+07	7173	10483.44	3
2010	17	1	1712009	2.908404e+07	2773	10488.29	3
2010	31	3	3120706	4.128067e+07	3934	10493.31	3
2010	43	4	4315305	2.417146e+08	23021	10499.74	3
2010	41	4	4126009	9.061817e+07	8629	10501.58	3
2010	43	4	4319208	6.015412e+07	5727	10503.6	3
2010	35	3	3507704	5.27399e+07	5021	10503.86	3
2010	31	3	3110707	1.3303749e+08	12658	10510.15	3
2010	52	5	5219357	3.868692e+07	3680	10512.75	3
2010	35	3	3536257	2.138246e+07	2032	10522.86	3
2010	31	3	3143203	2.237104e+08	21246	10529.53	3
2010	31	3	3163904	5.308085e+07	5040	10531.91	3
2010	41	4	4100301	8.712627e+07	8270	10535.22	3
2010	31	3	3139706	7.541508e+07	7156	10538.72	3
2010	35	3	3517604	1.8959393e+08	17988	10540.02	3
2010	31	3	3137106	8.010496e+07	7598	10542.9	3
2010	31	3	3139508	2.2545015e+08	21366	10551.82	3
2010	31	3	3130804	2.78226e+07	2636	10554.86	3
2010	11	1	1100254	2.3558886e+08	22319	10555.53	3
2010	33	3	3305604	2.2549132e+08	21360	10556.71	3
2010	35	3	3550209	3.320341e+08	31452	10556.85	3
2010	33	3	3305208	9.2922616e+08	88013	10557.83	3
2010	11	1	1101005	1.1113003e+08	10513	10570.72	3
2010	23	2	2301000	7.6834812e+08	72651	10575.88	3
2010	31	3	3101409	3.081614e+07	2913	10578.83	3
2010	42	4	4210209	3.468882e+07	3279	10579.09	3
2010	41	4	4127908	9.201547e+07	8697	10580.14	3
2010	35	3	3552908	6.046309e+07	5714	10581.57	3
2010	31	3	3160603	3.43082e+07	3240	10588.95	3
2010	43	4	4317103	8.7386832e+08	82513	10590.67	3
2010	11	1	1101104	9.069048e+07	8561	10593.45	3
2010	35	3	3530201	1.8086177e+08	17064	10599.03	3
2010	41	4	4117305	2.4767677e+08	23364	10600.79	3
2010	42	4	4207601	5.037868e+07	4752	10601.57	3
2010	51	5	5101209	1.160924e+07	1095	10602.05	3
2010	29	2	2917904	1.0945073e+08	10322	10603.64	3
2010	50	5	5004106	1.0994034e+08	10368	10603.81	3
2010	41	4	4127304	1.6179493e+08	15256	10605.33	3
2010	35	3	3515400	1.6252201e+08	15324	10605.72	3
2010	41	4	4113502	2.2506289e+08	21211	10610.67	3
2010	52	5	5217302	2.4474458e+08	23065	10611.08	3
2010	43	4	4306072	3.000201e+07	2826	10616.42	3
2010	41	4	4112405	9.075535e+07	8547	10618.39	3
2010	28	2	2805703	3.0229909e+08	28457	10623.01	3
2010	16	1	1600600	1.07542819e+09	101203	10626.45	3
2010	35	3	3544509	3.042468e+07	2862	10630.57	3
2010	41	4	4109609	3.4118436e+08	32088	10632.77	3
2010	43	4	4311981	4.007187e+07	3768	10634.78	3
2010	29	2	2907400	2.776053e+07	2609	10640.29	3
2010	41	4	4120705	7.499011e+07	7044	10645.96	3
2010	35	3	3506300	1.1478749e+08	10777	10651.15	3
2010	52	5	5214051	6.840944e+07	6422	10652.36	3
2010	43	4	4305454	1.3480145e+08	12654	10652.87	3
2010	31	3	3123403	1.53487e+07	1440	10658.82	3
2010	35	3	3544806	5.809773e+07	5450	10660.13	3
2010	41	4	4111001	7.20567e+07	6759	10660.85	3
2010	31	3	3110905	1.6458309e+08	15435	10662.98	3
2010	43	4	4313490	4.242347e+07	3978	10664.52	3
2010	41	4	4103958	4.347302e+07	4076	10665.61	3
2010	50	5	5005608	2.7322701e+08	25615	10666.68	3
2010	35	3	3553005	1.1550995e+08	10825	10670.66	3
2010	41	4	4100202	6.809634e+07	6374	10683.45	3
2010	43	4	4305116	3.170894e+07	2967	10687.21	3
2010	41	4	4102752	4.213263e+07	3939	10696.28	3
2010	32	3	3202900	1.1639855e+08	10881	10697.41	3
2010	29	2	2912806	8.516995e+07	7960	10699.74	3
2010	35	3	3529203	2.5969597e+08	24260	10704.7	3
2010	35	3	3519402	1.1640272e+08	10868	10710.59	3
2010	50	5	5003504	5.750591e+07	5365	10718.72	3
2010	41	4	4107546	5.01462e+07	4677	10721.87	3
2010	52	5	5213400	1.890489e+07	1763	10723.14	3
2010	15	1	1507755	5.412628e+07	5047	10724.45	3
2010	11	1	1100015	2.6207688e+08	24422	10731.18	3
2010	42	4	4205357	1.70478e+07	1588	10735.39	3
2010	52	5	5216304	9.791854e+07	9119	10737.86	3
2010	50	5	5005004	2.6161727e+08	24363	10738.3	3
2010	35	3	3532843	2.272127e+07	2114	10748	3
2010	31	3	3156700	1.35678237e+09	126219	10749.43	3
2010	33	3	3305554	8.4082538e+08	78183	10754.58	3
2010	41	4	4120200	2.721996e+07	2531	10754.63	3
2010	42	4	4217956	1.889925e+07	1757	10756.55	3
2010	31	3	3105103	2.4431715e+08	22709	10758.6	3
2010	25	2	2511202	2.9108744e+08	27034	10767.46	3
2010	41	4	4119608	3.5170443e+08	32645	10773.61	3
2010	31	3	3170602	2.331673e+07	2163	10779.81	3
2010	41	4	4105706	1.8578453e+08	17232	10781.37	3
2010	17	1	1718899	2.294592e+07	2128	10782.86	3
2010	31	3	3120904	8.0019677e+08	74184	10786.65	3
2010	35	3	3551504	4.2061121e+08	38891	10815.13	3
2010	31	3	3137536	9.346779e+07	8631	10829.31	3
2010	33	3	3303856	2.85723e+08	26381	10830.64	3
2010	41	4	4121307	4.285899e+07	3955	10836.66	3
2010	11	1	1101492	1.7360963e+08	16019	10837.73	3
2010	41	4	4109906	9.58287e+07	8839	10841.58	3
2010	43	4	4306700	3.687645e+07	3401	10842.83	3
2010	43	4	4300455	4.663737e+07	4301	10843.38	3
2010	11	1	1100098	3.1178784e+08	28741	10848.19	3
2010	52	5	5208004	1.08594857e+09	100084	10850.37	3
2010	26	2	2604106	3.41737838e+09	314951	10850.51	3
2010	35	3	3514205	2.275286e+07	2096	10855.37	3
2010	33	3	3303203	1.70986591e+09	157483	10857.46	3
2010	17	1	1715507	1.123755e+07	1035	10857.54	3
2010	43	4	4314159	8.737302e+07	8047	10857.84	3
2010	11	1	1101807	8.926296e+07	8218	10861.88	3
2010	35	3	3537602	6.4957729e+08	59793	10863.77	3
2010	31	3	3162104	3.4561437e+08	31807	10865.98	3
2010	50	5	5007307	5.478112e+07	5040	10869.27	3
2010	32	3	3205176	1.5033421e+08	13830	10870.15	3
2010	35	3	3535200	1.042247e+08	9584	10874.86	3
2010	17	1	1720259	3.164588e+07	2910	10874.87	3
2010	31	3	3168606	1.46571472e+09	134733	10878.66	3
2010	51	5	5107180	9.661257e+07	8880	10879.79	3
2010	35	3	3502408	4.067772e+07	3738	10882.22	3
2010	17	1	1718402	4.011915e+07	3685	10887.15	3
2010	50	5	5002100	2.5239645e+08	23175	10890.89	3
2010	41	4	4124905	6.437216e+07	5909	10893.92	3
2010	52	5	5208509	5.739018e+07	5268	10894.11	3
2010	51	5	5103809	4.146273e+07	3805	10896.91	3
2010	32	3	3200300	1.5217049e+08	13960	10900.46	3
2010	31	3	3131406	4.47689e+07	4106	10903.29	3
2010	52	5	5206503	3.878435e+07	3555	10909.8	3
2010	31	3	3115102	1.9015301e+08	17428	10910.78	3
2010	31	3	3114402	2.2287131e+08	20426	10911.16	3
2010	41	4	4119707	4.468541e+07	4095	10912.19	3
2010	35	3	3528908	4.273677e+07	3916	10913.37	3
2010	33	3	3305109	5.01543174e+09	459356	10918.4	3
2010	51	5	5105200	1.2489934e+08	11434	10923.5	3
2010	43	4	4307450	3.574216e+07	3272	10923.64	3
2010	31	3	3127909	1.500301e+07	1373	10927.17	3
2010	35	3	3526506	9.604488e+07	8782	10936.56	3
2010	35	3	3533007	2.0974579e+08	19178	10936.79	3
2010	35	3	3545100	5.269419e+07	4818	10936.94	3
2010	43	4	4315057	2.784801e+07	2544	10946.54	3
2010	31	3	3112703	1.5558465e+08	14206	10952.04	3
2010	35	3	3510203	5.058457e+08	46178	10954.26	3
2010	41	4	4101655	3.893198e+07	3554	10954.41	3
2010	43	4	4314027	8.037718e+07	7336	10956.54	3
2010	24	2	2411403	1.5134323e+08	13798	10968.49	3
2010	31	3	3144102	2.2421497e+08	20432	10973.72	3
2010	41	4	4128633	6.292975e+07	5734	10974.84	3
2010	31	3	3113602	6.917844e+07	6302	10977.22	3
2010	31	3	3157807	2.23085168e+09	203184	10979.47	3
2010	35	3	3508009	2.0394959e+08	18566	10985.11	3
2010	42	4	4205431	2.858844e+07	2601	10991.33	3
2010	43	4	4313441	2.503265e+07	2277	10993.7	3
2010	31	3	3101904	2.032876e+08	18490	10994.46	3
2010	43	4	4320677	1.1071922e+08	10067	10998.23	3
2010	43	4	4315552	3.977043e+07	3616	10998.46	3
2010	41	4	4109708	3.1594893e+08	28725	10999.09	3
2010	41	4	4103305	8.664e+07	7877	10999.11	3
2010	43	4	4321493	3.249548e+07	2952	11007.95	3
2010	31	3	3145604	4.3449229e+08	39469	11008.44	3
2010	52	5	5203807	6.066876e+07	5509	11012.66	3
2010	17	1	1702406	1.1722879e+08	10643	11014.64	3
2010	41	4	4114500	1.4512973e+08	13164	11024.74	3
2010	43	4	4301602	1.28806766e+09	116792	11028.73	3
2010	11	1	1100031	6.961111e+07	6309	11033.62	3
2010	35	3	3519709	7.8595902e+08	71228	11034.41	3
2010	31	3	3171303	7.9739451e+08	72244	11037.52	3
2010	32	3	3202108	2.5642278e+08	23223	11041.76	3
2010	52	5	5218003	4.6823653e+08	42356	11054.79	3
2010	43	4	4316303	7.967725e+07	7206	11057.07	3
2010	41	4	4125902	2.760237e+07	2494	11067.51	3
2010	43	4	4322905	5.880157e+07	5311	11071.66	3
2010	43	4	4320453	2.525795e+07	2281	11073.19	3
2010	35	3	3547700	2.2700371e+08	20498	11074.43	3
2010	43	4	4323457	4.674772e+07	4221	11075.03	3
2010	33	3	3305752	3.4047923e+08	30731	11079.34	3
2010	41	4	4105805	2.36060031e+09	213027	11081.23	3
2010	31	3	3165404	6.917325e+07	6241	11083.68	3
2010	17	1	1702000	9.739754e+07	8786	11085.54	3
2010	31	3	3129103	6.804462e+07	6137	11087.6	3
2010	42	4	4212502	2.788103e+08	25140	11090.31	3
2010	35	3	3554409	9.432612e+07	8505	11090.67	3
2010	51	5	5100805	9.47046e+07	8538	11092.13	3
2010	51	5	5107859	1.1693015e+08	10531	11103.42	3
2010	41	4	4123808	1.4585327e+08	13134	11105.02	3
2010	31	3	3107109	4.2774708e+08	38509	11107.72	3
2010	11	1	1100296	9.881832e+07	8886	11120.68	3
2010	52	5	5215207	3.911857e+07	3516	11125.87	3
2010	21	2	2101251	1.6651285e+08	14965	11126.82	3
2010	43	4	4312054	4.526917e+07	4068	11128.11	3
2010	52	5	5219456	3.52886e+07	3170	11132.05	3
2010	41	4	4100806	1.1465497e+08	10298	11133.71	3
2010	31	3	3160702	5.1548355e+08	46289	11136.2	3
2010	33	3	3301900	2.42972889e+09	218090	11140.95	3
2010	35	3	3520202	9.832408e+07	8825	11141.54	3
2010	31	3	3109709	1.2294711e+08	11034	11142.57	3
2010	35	3	3516002	1.4319352e+08	12849	11144.33	3
2010	43	4	4315156	6.868203e+07	6161	11147.87	3
2010	11	1	1100908	3.993632e+07	3581	11152.28	3
2010	43	4	4317400	5.4760939e+08	49082	11157.03	3
2010	43	4	4311239	2.970075e+07	2662	11157.3	3
2010	43	4	4319406	1.8286642e+08	16371	11170.14	3
2010	43	4	4308052	2.868464e+07	2567	11174.38	3
2010	24	2	2401453	2.7043173e+08	24187	11180.87	3
2010	41	4	4119806	1.5286447e+08	13668	11184.11	3
2010	43	4	4320859	4.620453e+07	4131	11184.83	3
2010	31	3	3117801	1.1620244e+08	10388	11186.22	3
2010	35	3	3521705	1.9983951e+08	17861	11188.6	3
2010	43	4	4303707	6.846776e+07	6117	11193.03	3
2010	17	1	1718204	5.5011531e+08	49143	11194.17	3
2010	35	3	3506607	3.1985763e+08	28573	11194.4	4
2010	41	4	4116950	5.721298e+07	5110	11196.28	4
2010	43	4	4301404	1.1453864e+08	10229	11197.44	4
2010	43	4	4304663	2.7205571e+08	24294	11198.47	4
2010	26	2	2616407	1.46194673e+09	130540	11199.22	4
2010	41	4	4119202	6.957757e+07	6210	11204.12	4
2010	31	3	3143401	2.3757802e+08	21203	11204.92	4
2010	26	2	2601706	8.1169218e+08	72412	11209.36	4
2010	33	3	3302106	2.5688501e+08	22902	11216.71	4
2010	35	3	3526100	2.1617327e+08	19269	11218.71	4
2010	43	4	4312443	3.575023e+07	3185	11224.56	4
2010	32	3	3201902	3.5732314e+08	31824	11228.1	4
2010	42	4	4219150	3.153261e+07	2808	11229.56	4
2010	35	3	3538303	3.977806e+07	3541	11233.57	4
2010	41	4	4107736	6.665145e+07	5932	11235.91	4
2010	51	5	5108055	1.2700456e+08	11302	11237.35	4
2010	15	1	1501501	5.8084668e+08	51663	11242.99	4
2010	42	4	4215059	2.739222e+07	2436	11244.75	4
2010	51	5	5105580	1.3498006e+08	11994	11253.97	4
2010	43	4	4318804	4.8523471e+08	43114	11254.69	4
2010	52	5	5203575	3.947568e+07	3503	11269.11	4
2010	41	4	4123402	1.1764891e+08	10436	11273.37	4
2010	31	3	3143500	9.311425e+07	8256	11278.37	4
2010	33	3	3300902	1.6726216e+08	14829	11279.4	4
2010	52	5	5204102	1.1887434e+08	10539	11279.47	4
2010	31	3	3138401	5.7737654e+08	51136	11291	4
2010	31	3	3145109	1.736092e+08	15373	11293.12	4
2010	43	4	4312252	8.621866e+07	7631	11298.47	4
2010	52	5	5201207	1.149145e+07	1017	11299.36	4
2010	41	4	4111506	3.5965504e+08	31812	11305.64	4
2010	31	3	3146909	1.6037864e+08	14171	11317.38	4
2010	31	3	3115003	3.233396e+07	2857	11317.45	4
2010	43	4	4321667	1.1597162e+08	10239	11326.46	4
2010	43	4	4305447	5.607509e+07	4944	11342.05	4
2010	52	5	5219738	5.319938e+07	4690	11343.15	4
2010	41	4	4116000	2.108017e+07	1858	11345.62	4
2010	43	4	4318457	3.087332e+07	2720	11350.49	4
2010	31	3	3152600	7.054209e+07	6213	11353.95	4
2010	43	4	4312302	5.512563e+07	4855	11354.4	4
2010	43	4	4308805	9.596966e+07	8452	11354.67	4
2010	35	3	3556404	4.4597471e+08	39266	11357.78	4
2010	35	3	3535408	1.6590643e+08	14603	11361.12	4
2010	43	4	4318432	2.994197e+07	2635	11363.18	4
2010	15	1	1506161	2.0144904e+08	17722	11367.17	4
2010	35	3	3555406	8.9660034e+08	78870	11368.08	4
2010	35	3	3553807	2.5355902e+08	22294	11373.42	4
2010	52	5	5208608	6.7733388e+08	59545	11375.16	4
2010	31	3	3114204	2.2789053e+08	20018	11384.28	4
2010	32	3	3203601	6.458623e+07	5672	11386.85	4
2010	35	3	3509106	5.739362e+07	5039	11389.88	4
2010	35	3	3541505	4.3206836e+08	37915	11395.71	4
2010	31	3	3166907	8.593361e+07	7540	11397.03	4
2010	42	4	4213609	3.8185064e+08	33497	11399.55	4
2010	51	5	5107107	2.1618475e+08	18963	11400.35	4
2010	31	3	3164407	5.64259e+07	4948	11403.78	4
2010	42	4	4215356	4.517923e+07	3961	11406.02	4
2010	35	3	3503109	6.989044e+07	6123	11414.41	4
2010	35	3	3549508	9.596394e+07	8407	11414.77	4
2010	31	3	3143005	1.4919299e+08	13061	11422.78	4
2010	43	4	4311908	5.872505e+07	5134	11438.46	4
2010	29	2	2910107	1.298966e+08	11355	11439.59	4
2010	43	4	4302659	5.351213e+07	4677	11441.55	4
2010	43	4	4313805	7.919165e+07	6920	11443.88	4
2010	29	2	2933307	3.50682368e+09	306374	11446.22	4
2010	31	3	3162203	7.8931e+07	6890	11455.88	4
2010	41	4	4126652	3.892006e+07	3394	11467.31	4
2010	41	4	4128625	3.676545e+07	3206	11467.7	4
2010	32	3	3201605	3.2664596e+08	28477	11470.52	4
2010	51	5	5106828	1.2569651e+08	10950	11479.13	4
2010	43	4	4318051	3.358853e+07	2926	11479.33	4
2010	43	4	4322541	5.880053e+07	5121	11482.24	4
2010	41	4	4106100	4.166921e+07	3627	11488.62	4
2010	41	4	4115705	3.3814009e+08	29426	11491.2	4
2010	35	3	3532801	6.773114e+07	5891	11497.39	4
2010	31	3	3116407	5.224665e+07	4544	11497.94	4
2010	32	3	3204609	2.5084929e+08	21815	11498.94	4
2010	29	2	2912202	1.989778e+08	17301	11500.94	4
2010	41	4	4127205	1.8161267e+08	15791	11501.02	4
2010	31	3	3106002	1.1515138e+08	10012	11501.34	4
2010	35	3	3516606	8.063873e+07	7011	11501.74	4
2010	42	4	4202057	9.688175e+07	8423	11502.05	4
2010	41	4	4116307	4.230576e+07	3678	11502.38	4
2010	31	3	3147709	9.44131e+07	8199	11515.2	4
2010	43	4	4302907	1.5758773e+08	13685	11515.36	4
2010	33	3	3304755	4.7629376e+08	41357	11516.64	4
2010	41	4	4100707	1.1732396e+08	10179	11526.08	4
2010	41	4	4109757	6.992495e+07	6066	11527.36	4
2010	52	5	5213053	3.096147e+07	2685	11531.27	4
2010	52	5	5204201	1.634423e+07	1417	11534.39	4
2010	11	1	1100809	2.2832149e+08	19782	11541.88	4
2010	41	4	4119004	7.809221e+07	6764	11545.27	4
2010	51	5	5104500	2.779575e+07	2407	11547.88	4
2010	35	3	3502903	3.1564252e+08	27323	11552.26	4
2010	41	4	4110607	1.7294543e+08	14964	11557.43	4
2010	35	3	3547403	2.939273e+07	2543	11558.29	4
2010	35	3	3533809	3.090028e+07	2673	11560.15	4
2010	29	2	2929503	4.873367e+08	42153	11561.14	4
2010	29	2	2904605	7.465144e+08	64550	11564.9	4
2010	41	4	4127809	1.0178267e+08	8788	11582.01	4
2010	50	5	5000609	4.0242925e+08	34739	11584.36	4
2010	43	4	4305157	2.800035e+07	2417	11584.75	4
2010	51	5	5108204	4.675672e+07	4036	11584.92	4
2010	41	4	4121703	2.9184522e+08	25177	11591.74	4
2010	13	1	1303536	3.1453523e+08	27121	11597.48	4
2010	41	4	4106456	8.395338e+07	7238	11598.97	4
2010	51	5	5108600	2.4834342e+08	21403	11603.21	4
2010	43	4	4313391	4.473633e+07	3855	11604.75	4
2010	41	4	4124053	2.4188146e+08	20834	11609.94	4
2010	35	3	3521150	5.177992e+07	4459	11612.45	4
2010	41	4	4128302	2.862508e+07	2465	11612.61	4
2010	43	4	4312005	2.566596e+07	2210	11613.56	4
2010	52	5	5214408	9.14953e+07	7874	11619.93	4
2010	35	3	3537800	6.0680105e+08	52214	11621.42	4
2010	31	3	3165107	8.245365e+07	7093	11624.65	4
2010	32	3	3204906	1.26848969e+09	109067	11630.37	4
2010	35	3	3550803	1.4081995e+08	12100	11638.01	4
2010	41	4	4121505	1.6499867e+08	14176	11639.3	4
2010	17	1	1708205	2.1455835e+08	18428	11643.06	4
2010	41	4	4115408	1.6198525e+08	13909	11646.07	4
2010	43	4	4321600	4.8542755e+08	41655	11653.52	4
2010	33	3	3302056	1.6348241e+08	14027	11654.84	4
2010	42	4	4217154	2.219344e+07	1904	11656.22	4
2010	35	3	3526605	7.679632e+07	6586	11660.54	4
2010	52	5	5212956	5.147083e+07	4414	11660.81	4
2010	50	5	5001102	5.3255458e+08	45623	11672.94	4
2010	26	2	2611101	3.43415511e+09	294081	11677.58	4
2010	43	4	4315701	4.3914553e+08	37602	11678.78	4
2010	31	3	3125200	2.74233e+07	2348	11679.43	4
2010	41	4	4118303	3.261147e+07	2791	11684.51	4
2010	31	3	3169604	2.8263269e+08	24185	11686.28	4
2010	15	1	1505031	2.9361291e+08	25106	11694.93	4
2010	35	3	3521002	3.3107356e+08	28301	11698.3	4
2010	35	3	3504909	1.1956211e+08	10220	11698.84	4
2010	42	4	4211801	8.641418e+07	7371	11723.54	4
2010	41	4	4108320	7.541713e+07	6424	11739.9	4
2010	43	4	4311007	3.2812845e+08	27942	11743.2	4
2010	52	5	5220009	1.2042011e+08	10254	11743.72	4
2010	31	3	3160900	4.126996e+07	3512	11751.13	4
2010	51	5	5101852	6.147787e+07	5231	11752.6	4
2010	22	2	2209203	7.164798e+07	6096	11753.28	4
2010	26	2	2607901	7.58620013e+09	644699	11767.04	4
2010	43	4	4309571	3.476961e+07	2954	11770.35	4
2010	51	5	5106216	1.4290759e+08	12132	11779.39	4
2010	41	4	4112900	4.046118e+07	3433	11785.95	4
2010	52	5	5203609	3.818657e+07	3240	11785.98	4
2010	23	2	2312403	5.179674e+08	43947	11786.18	4
2010	41	4	4120408	5.629413e+07	4775	11789.35	4
2010	42	4	4215901	3.54642e+07	3008	11789.96	4
2010	31	3	3152907	1.0394853e+08	8808	11801.6	4
2010	24	2	2413201	4.631005e+07	3924	11801.75	4
2010	42	4	4219853	3.532722e+07	2991	11811.17	4
2010	35	3	3553203	6.434576e+07	5447	11813.06	4
2010	32	3	3205150	1.0246525e+08	8672	11815.64	4
2010	41	4	4121257	4.884924e+07	4134	11816.46	4
2010	35	3	3530409	5.076757e+07	4295	11820.16	4
2010	51	5	5106257	2.3023659e+08	19475	11822.16	4
2010	15	1	1505437	3.2602877e+08	27564	11828.06	4
2010	41	4	4102604	1.1520379e+08	9737	11831.55	4
2010	43	4	4319307	7.534314e+07	6367	11833.38	4
2010	43	4	4323754	4.130548e+07	3485	11852.36	4
2010	31	3	3114501	2.0212736e+08	17050	11854.98	4
2010	51	5	5103957	3.705581e+07	3125	11857.86	4
2010	33	3	3304409	2.0637825e+08	17401	11860.14	4
2010	21	2	2105302	2.93619368e+09	247553	11860.87	4
2010	41	4	4124103	5.0670209e+08	42688	11869.9	4
2010	32	3	3200904	4.8258979e+08	40610	11883.52	4
2010	33	3	3300605	4.2056441e+08	35384	11885.72	4
2010	31	3	3123007	1.1062104e+08	9303	11890.9	4
2010	42	4	4216404	8.326653e+07	7002	11891.82	4
2010	35	3	3552106	4.3640708e+08	36695	11892.82	4
2010	35	3	3504206	1.6905415e+08	14205	11901.03	4
2010	43	4	4321402	1.6328878e+08	13716	11904.99	4
2010	41	4	4117602	5.1069244e+08	42887	11907.86	4
2010	41	4	4111258	2.8459482e+08	23899	11908.23	4
2010	35	3	3542008	7.156843e+07	6008	11912.19	4
2010	26	2	2606200	9.0154202e+08	75648	11917.59	4
2010	28	2	2800605	2.9838679e+08	25012	11929.75	4
2010	35	3	3517208	1.2736209e+08	10671	11935.35	4
2010	22	2	2208908	8.167313e+07	6841	11938.77	4
2010	43	4	4312203	5.85875e+07	4907	11939.58	4
2010	43	4	4322376	2.928949e+07	2453	11940.27	4
2010	29	2	2914802	2.44470219e+09	204710	11942.27	4
2010	32	3	3200805	3.4744014e+08	29086	11945.27	4
2010	41	4	4127007	1.2282401e+08	10277	11951.35	4
2010	31	3	3107505	7.783964e+07	6513	11951.43	4
2010	17	1	1720853	2.078752e+07	1739	11953.72	4
2010	35	3	3547650	1.730318e+07	1447	11957.97	4
2010	52	5	5220454	1.00953686e+09	84399	11961.48	4
2010	35	3	3543709	1.2456828e+08	10414	11961.62	4
2010	17	1	1709302	2.7772742e+08	23212	11964.82	4
2010	52	5	5211008	9.393619e+07	7851	11964.87	4
2010	43	4	4311106	1.3733522e+08	11478	11965.08	4
2010	35	3	3530102	3.2881594e+08	27475	11967.82	4
2010	29	2	2928703	1.08868569e+09	90949	11970.29	4
2010	42	4	4209607	1.7208747e+08	14366	11978.8	4
2010	43	4	4318465	2.642671e+07	2204	11990.34	4
2010	41	4	4123907	1.4912883e+08	12437	11990.74	4
2010	52	5	5202502	9.003945e+07	7506	11995.66	4
2010	43	4	4309654	7.255253e+07	6048	11996.12	4
2010	41	4	4126702	5.595945e+07	4664	11998.17	4
2010	42	4	4209177	2.578769e+07	2148	12005.44	4
2010	42	4	4213807	8.728744e+07	7270	12006.53	4
2010	35	3	3547205	1.970494e+07	1641	12007.89	4
2010	51	5	5106752	4.9706542e+08	41386	12010.47	4
2010	29	2	2926202	2.6360461e+08	21941	12014.25	4
2010	35	3	3537701	6.357661e+07	5287	12025.08	4
2010	31	3	3111507	1.7094056e+08	14213	12027.06	4
2010	41	4	4114104	2.380544e+08	19784	12032.67	4
2010	35	3	3553856	6.198821e+07	5149	12038.88	4
2010	16	1	1600238	6.950765e+07	5772	12042.21	4
2010	33	3	3301850	6.2036757e+08	51487	12049.01	4
2010	35	3	3543600	4.141018e+07	3436	12051.86	4
2010	31	3	3168200	2.257544e+07	1873	12053.09	4
2010	31	3	3152006	3.5072272e+08	29083	12059.37	4
2010	52	5	5210000	5.815525e+08	48212	12062.4	4
2010	43	4	4319802	1.0180717e+08	8440	12062.46	4
2010	43	4	4302808	4.0679999e+08	33700	12071.22	4
2010	52	5	5211602	3.214813e+07	2663	12072.15	4
2010	32	3	3203908	5.5570661e+08	46020	12075.33	4
2010	31	3	3143906	1.21809495e+09	100861	12076.97	4
2010	35	3	3506904	1.1213946e+08	9282	12081.39	4
2010	17	1	1706258	1.892042e+07	1566	12082	4
2010	43	4	4320800	3.6325473e+08	30065	12082.31	4
2010	43	4	4308409	8.474694e+07	7014	12082.54	4
2010	31	3	3153400	2.241628e+08	18546	12086.85	4
2010	31	3	3114303	3.5963148e+08	29752	12087.64	4
2010	35	3	3511201	8.615619e+07	7127	12088.7	4
2010	35	3	3535903	4.612762e+07	3815	12091.12	4
2010	43	4	4304853	1.943203e+07	1607	12092.12	4
2010	42	4	4207809	1.1529978e+08	9534	12093.54	4
2010	43	4	4322400	1.51854683e+09	125507	12099.3	4
2010	51	5	5105150	4.75733e+08	39260	12117.5	4
2010	41	4	4107306	7.064398e+07	5829	12119.4	4
2010	41	4	4122503	1.3990914e+08	11544	12119.64	4
2010	52	5	5221601	4.4795752e+08	36949	12123.67	4
2010	52	5	5218904	2.2855737e+08	18848	12126.35	4
2010	41	4	4116604	4.220681e+07	3480	12128.39	4
2010	17	1	1707306	5.572895e+07	4589	12144.03	4
2010	31	3	3167509	3.081335e+07	2537	12145.58	4
2010	31	3	3162500	1.02524318e+09	84404	12146.86	4
2010	43	4	4303202	5.911503e+07	4865	12151.08	4
2010	41	4	4109302	1.7725182e+08	14583	12154.69	4
2010	35	3	3554904	6.599079e+07	5428	12157.48	4
2010	35	3	3555109	1.7350583e+08	14262	12165.6	4
2010	35	3	3519253	7.75932e+07	6377	12167.66	4
2010	42	4	4208450	1.798322e+08	14775	12171.38	4
2010	51	5	5107198	2.677916e+07	2199	12177.88	4
2010	52	5	5220207	2.7156884e+08	22294	12181.25	4
2010	32	3	3202405	1.28184569e+09	105227	12181.72	4
2010	52	5	5217708	2.0854927e+08	17112	12187.31	4
2010	21	2	2100501	1.3120197e+08	10765	12187.83	4
2010	35	3	3549300	2.56359e+07	2103	12190.15	4
2010	26	2	2606804	1.24401927e+09	101987	12197.82	4
2010	43	4	4322327	4.296285e+07	3522	12198.42	4
2010	42	4	4203709	1.2936591e+08	10603	12200.88	4
2010	52	5	5205703	3.207916e+07	2629	12202.04	4
2010	35	3	3515129	3.696348e+07	3024	12223.37	4
2010	31	3	3138104	7.940514e+07	6490	12235	4
2010	35	3	3535606	2.1280232e+08	17384	12241.27	4
2010	41	4	4103909	1.8870055e+08	15393	12258.85	4
2010	29	2	2906907	2.6280302e+08	21437	12259.32	4
2010	35	3	3516408	1.61387277e+09	131603	12263.19	4
2010	41	4	4102109	3.0342322e+08	24704	12282.35	4
2010	41	4	4107603	2.0052132e+08	16317	12289.1	4
2010	35	3	3515806	2.15309e+07	1752	12289.33	4
2010	28	2	2804805	1.97686428e+09	160829	12291.72	4
2010	41	4	4126603	2.2678342e+08	18446	12294.45	4
2010	23	2	2306306	5.9479111e+08	48366	12297.71	4
2010	51	5	5103700	1.3452941e+08	10933	12304.89	4
2010	31	3	3169406	6.6262856e+08	53825	12310.8	4
2010	12	1	1200179	1.0853109e+08	8810	12319.08	4
2010	41	4	4110102	3.5054287e+08	28455	12319.2	4
2010	15	1	1508407	5.0025605e+08	40573	12329.78	4
2010	33	3	3300209	1.38176242e+09	112028	12334.08	4
2010	28	2	2805901	1.1534838e+08	9351	12335.41	4
2010	52	5	5221502	5.969233e+07	4839	12335.67	4
2010	51	5	5108956	9.988533e+07	8088	12349.82	4
2010	41	4	4123006	1.6904927e+08	13672	12364.63	4
2010	31	3	3158300	8.951139e+07	7239	12365.16	4
2010	43	4	4304614	2.234532e+07	1807	12365.97	4
2010	35	3	3502606	5.497735e+07	4444	12371.14	4
2010	31	3	3123601	3.1267349e+08	25266	12375.27	4
2010	11	1	1100288	6.2784822e+08	50672	12390.44	4
2010	43	4	4322525	4.031813e+07	3253	12394.14	4
2010	31	3	3140506	1.5604428e+08	12589	12395.29	4
2010	31	3	3168903	8.560694e+07	6906	12396.02	4
2010	41	4	4128559	1.1126694e+08	8973	12400.19	4
2010	35	3	3514700	7.839495e+07	6318	12408.19	4
2010	43	4	4321105	2.0660413e+08	16649	12409.4	4
2010	41	4	4126678	1.5181822e+08	12232	12411.56	4
2010	43	4	4300570	3.609745e+07	2908	12413.15	4
2010	52	5	5212501	2.16716422e+09	174546	12416.01	4
2010	21	2	2104057	4.4375145e+08	35738	12416.8	4
2010	41	4	4120150	4.544465e+07	3659	12419.96	4
2010	35	3	3514601	1.0121265e+08	8143	12429.41	4
2010	41	4	4109005	4.832079e+07	3886	12434.58	4
2010	31	3	3104601	1.6226022e+08	13049	12434.69	4
2010	32	3	3204658	9.969796e+07	8016	12437.37	4
2010	41	4	4107900	7.370877e+07	5921	12448.7	4
2010	27	2	2703759	1.4985e+08	12035	12451.18	4
2010	31	3	3163706	5.1895371e+08	41664	12455.69	4
2010	35	3	3540101	4.33351e+07	3479	12456.19	4
2010	41	4	4112207	8.144401e+07	6536	12460.83	4
2010	43	4	4322343	2.861272e+07	2296	12461.99	4
2010	31	3	3116605	3.2137509e+08	25777	12467.51	4
2010	35	3	3542909	1.5130491e+08	12129	12474.64	4
2010	35	3	3533700	5.194457e+07	4163	12477.68	4
2010	31	3	3105608	1.57886691e+09	126325	12498.45	4
2010	35	3	3538808	3.5642273e+08	28489	12510.89	4
2010	32	3	3205036	2.3968182e+08	19141	12521.91	4
2010	43	4	4310579	2.92658e+07	2337	12522.81	4
2010	41	4	4107702	6.015566e+07	4802	12527.21	4
2010	35	3	3520707	4.893304e+07	3906	12527.66	4
2010	32	3	3205010	2.9905142e+08	23860	12533.59	4
2010	24	2	2414209	1.4326462e+08	11402	12564.87	4
2010	35	3	3541000	3.27666252e+09	260769	12565.38	4
2010	43	4	4314506	1.6069169e+08	12787	12566.8	4
2010	41	4	4125209	1.1420353e+08	9085	12570.56	4
2010	43	4	4315503	1.9924933e+08	15850	12570.94	4
2010	15	1	1508126	5.4523047e+08	43345	12578.85	4
2010	43	4	4306056	9.15898e+07	7280	12581.02	4
2010	31	3	3164308	8.413054e+07	6686	12583.09	4
2010	11	1	1100155	4.7750132e+08	37941	12585.36	4
2010	16	1	1600535	2.1198542e+08	16825	12599.43	4
2010	21	2	2111607	2.2028613e+08	17480	12602.18	4
2010	42	4	4201505	9.744717e+07	7730	12606.36	4
2010	35	3	3500758	6.16026e+07	4886	12607.98	4
2010	41	4	4106506	2.7416982e+08	21737	12613.05	4
2010	31	3	3146008	3.9854423e+08	31580	12620.15	4
2010	31	3	3103108	2.112569e+07	1673	12627.43	4
2010	11	1	1100262	4.193402e+07	3316	12645.97	4
2010	42	4	4211876	2.230172e+07	1763	12649.87	4
2010	17	1	1700301	6.525646e+07	5158	12651.5	4
2010	31	3	3113701	2.5413656e+08	20087	12651.79	4
2010	41	4	4123600	2.303849e+07	1818	12672.44	4
2010	42	4	4207759	5.390591e+07	4253	12674.8	4
2010	35	3	3515707	2.13326268e+09	168290	12676.11	4
2010	31	3	3136108	6.881739e+07	5427	12680.56	4
2010	35	3	3507100	2.4997345e+08	19703	12687.08	4
2010	35	3	3536901	3.249406e+07	2561	12688.04	4
2010	43	4	4304200	3.8356239e+08	30176	12710.84	4
2010	42	4	4202503	5.602737e+07	4400	12733.49	4
2010	33	3	3301801	1.6867717e+08	13239	12740.93	4
2010	52	5	5201405	5.80858106e+09	455735	12745.52	4
2010	42	4	4218251	9.134891e+07	7165	12749.32	4
2010	33	3	3303500	1.014281827e+10	795212	12754.86	4
2010	24	2	2403707	7.313948e+07	5734	12755.4	4
2010	41	4	4108809	3.9129872e+08	30669	12758.77	4
2010	35	3	3550506	9.197923e+07	7208	12760.71	4
2010	42	4	4205704	2.3153391e+08	18144	12760.91	4
2010	43	4	4315909	7.332796e+07	5743	12768.23	4
2010	43	4	4302709	2.6063311e+08	20405	12773	4
2010	41	4	4108908	7.913237e+07	6194	12775.65	4
2010	43	4	4319364	2.411989e+07	1886	12788.91	4
2010	35	3	3554706	1.1932733e+08	9330	12789.64	4
2010	43	4	4306205	1.5771532e+08	12331	12790.15	4
2010	35	3	3500402	9.696445e+07	7580	12792.14	4
2010	43	4	4309951	5.199638e+07	4061	12803.84	4
2010	42	4	4205001	1.8957528e+08	14801	12808.28	4
2010	42	4	4208807	2.2148164e+08	17291	12809.07	4
2010	42	4	4201109	4.118115e+07	3214	12813.05	4
2010	31	3	3144508	1.0193068e+08	7953	12816.63	4
2010	35	3	3539004	1.3615341e+08	10623	12816.85	4
2010	31	3	3121209	8.755637e+07	6830	12819.38	4
2010	31	3	3147402	2.8950046e+08	22571	12826.21	4
2010	17	1	1716109	5.7008004e+08	44432	12830.39	4
2010	42	4	4218400	8.824784e+07	6877	12832.32	4
2010	35	3	3521804	3.0817399e+08	24015	12832.56	4
2010	31	3	3163102	5.391819e+07	4201	12834.61	4
2010	51	5	5103056	1.4084449e+08	10972	12836.72	4
2010	43	4	4302600	4.753963e+07	3702	12841.61	4
2010	31	3	3166600	1.048438e+07	815	12864.27	4
2010	35	3	3550407	4.0776329e+08	31688	12868.07	4
2010	41	4	4103404	3.469738e+07	2695	12874.72	4
2010	41	4	4117107	1.6828782e+08	13069	12876.87	4
2010	31	3	3144300	5.2563526e+08	40816	12878.17	4
2010	35	3	3534500	3.271739e+07	2539	12885.93	4
2010	29	2	2910800	7.17990605e+09	556756	12895.97	4
2010	35	3	3532405	2.116691e+08	16413	12896.43	4
2010	35	3	3556008	1.6405024e+08	12720	12897.03	4
2010	29	2	2900702	1.83351923e+09	142160	12897.57	4
2010	43	4	4314407	4.22793952e+09	327778	12898.79	4
2010	43	4	4315206	5.349521e+07	4147	12899.74	4
2010	52	5	5217203	1.4551866e+08	11268	12914.33	4
2010	50	5	5008008	2.2167945e+08	17162	12916.88	4
2010	35	3	3503802	5.7238024e+08	44270	12929.3	4
2010	35	3	3528106	9.916339e+07	7663	12940.54	4
2010	42	4	4204152	3.588775e+07	2773	12941.85	4
2010	51	5	5101001	4.169338e+07	3221	12944.23	4
2010	43	4	4304408	5.0812838e+08	39238	12949.91	4
2010	25	2	2504009	4.99296229e+09	385276	12959.44	4
2010	41	4	4101051	3.712921e+07	2865	12959.58	4
2010	42	4	4202099	2.434133e+07	1878	12961.3	4
2010	31	3	3102605	4.8367325e+08	37302	12966.42	4
2010	31	3	3112802	1.0615653e+08	8185	12969.64	4
2010	31	3	3119807	4.398433e+07	3391	12970.9	4
2010	52	5	5212204	2.4760607e+08	19086	12973.18	4
2010	41	4	4105409	2.5538478e+08	19673	12981.49	4
2010	42	4	4209904	1.3303554e+08	10248	12981.61	4
2010	35	3	3520442	3.2553664e+08	25071	12984.59	4
2010	43	4	4318424	6.136637e+07	4726	12984.84	4
2010	31	3	3124500	1.408901e+08	10844	12992.45	4
2010	42	4	4210852	3.266148e+07	2513	12997.01	4
2010	31	3	3168804	9.10178e+07	7002	12998.83	4
2010	35	3	3538105	1.9557827e+08	15043	13001.28	4
2010	35	3	3507803	2.744854e+08	21105	13005.7	4
2010	41	4	4105607	1.4396127e+08	11067	13008.16	4
2010	35	3	3512308	2.1221891e+08	16302	13017.97	4
2010	52	5	5221197	8.545752e+07	6562	13023.09	4
2010	50	5	5005681	2.2205227e+08	17035	13035.06	4
2010	11	1	1100056	2.2202119e+08	17030	13037.06	4
2010	11	1	1100072	1.1476827e+08	8802	13038.89	4
2010	32	3	3205101	8.4760703e+08	64999	13040.31	4
2010	41	4	4128609	1.0276523e+08	7879	13042.93	4
2010	42	4	4218756	6.045207e+07	4633	13048.15	4
2010	22	2	2211001	1.062769422e+10	814439	13049.1	4
2010	35	3	3523008	5.690083e+07	4360	13050.65	4
2010	17	1	1707652	6.969463e+07	5340	13051.43	4
2010	43	4	4301552	4.783702e+07	3665	13052.39	4
2010	28	2	2804904	1.7150044e+08	13137	13054.76	4
2010	42	4	4204756	2.457004e+07	1882	13055.28	4
2010	41	4	4107850	6.170168e+07	4725	13058.56	4
2010	32	3	3204104	3.1214126e+08	23891	13065.22	4
2010	52	5	5212600	3.10721e+07	2378	13066.48	4
2010	42	4	4213302	6.401998e+07	4895	13078.65	4
2010	43	4	4321956	7.569984e+07	5787	13081.02	4
2010	52	5	5200852	7.207055e+07	5508	13084.7	4
2010	50	5	5007406	2.4728571e+08	18892	13089.44	4
2010	35	3	3509403	3.0601876e+08	23378	13090.03	4
2010	43	4	4305439	7.751707e+07	5919	13096.31	4
2010	31	3	3127701	3.45406121e+09	263594	13103.72	4
2010	32	3	3203502	2.3399044e+08	17854	13105.77	4
2010	52	5	5219100	7.538398e+07	5751	13107.98	4
2010	43	4	4316402	5.2112502e+08	39751	13109.73	4
2010	41	4	4102802	1.9780965e+08	15080	13117.35	4
2010	41	4	4120507	1.4212433e+08	10832	13120.78	4
2010	35	3	3514924	4.093784e+07	3120	13121.1	4
2010	43	4	4321329	3.897451e+07	2970	13122.73	4
2010	35	3	3504404	1.4844027e+08	11311	13123.53	4
2010	35	3	3508900	5.347845e+07	4072	13133.21	4
2010	42	4	4202206	1.3584094e+08	10331	13148.87	4
2010	35	3	3514809	1.9259435e+08	14645	13150.86	4
2010	43	4	4310553	4.525354e+07	3441	13151.27	4
2010	43	4	4307302	1.0363441e+08	7878	13154.91	4
2010	35	3	3548104	7.8196e+07	5943	13157.66	4
2010	31	3	3147204	2.663387e+08	20241	13158.38	4
2010	17	1	1702109	1.98066765e+09	150520	13158.83	4
2010	33	3	3304607	1.3601219e+08	10321	13178.2	4
2010	42	4	4205555	3.268239e+07	2480	13178.38	4
2010	35	3	3553609	1.6806666e+08	12743	13188.94	4
2010	41	4	4117255	1.3684302e+08	10369	13197.32	4
2010	50	5	5003108	6.417232e+07	4862	13198.75	4
2010	31	3	3125705	1.8649359e+08	14121	13206.83	4
2010	25	2	2503001	2.6904144e+08	20363	13212.27	4
2010	41	4	4125753	8.583441e+07	6492	13221.57	4
2010	42	4	4218954	3.283993e+07	2482	13231.24	4
2010	35	3	3520400	3.7295193e+08	28176	13236.51	4
2010	11	1	1100940	2.1021776e+08	15873	13243.73	4
2010	42	4	4215307	9.746651e+07	7357	13248.13	4
2010	31	3	3147907	1.40857915e+09	106313	13249.36	4
2010	27	2	2704302	1.23698013e+10	932608	13263.67	4
2010	25	2	2500601	2.3894936e+08	18001	13274.23	4
2010	43	4	4323705	3.662946e+07	2759	13276.35	4
2010	51	5	5107743	2.521455e+07	1899	13277.8	4
2010	35	3	3517505	2.3752168e+08	17885	13280.5	4
2010	43	4	4314753	2.679398e+07	2017	13284.07	4
2010	41	4	4103800	9.614743e+07	7236	13287.37	4
2010	31	3	3135001	3.964247e+07	2982	13293.92	4
2010	43	4	4320602	5.109286e+07	3842	13298.51	4
2010	35	3	3501707	4.5937494e+08	34522	13306.73	4
2010	32	3	3201407	4.6343057e+08	34826	13307.03	4
2010	51	5	5103304	2.4172291e+08	18157	13312.93	4
2010	35	3	3506409	9.394097e+07	7052	13321.18	4
2010	42	4	4204905	1.1512568e+08	8638	13327.82	4
2010	51	5	5107941	1.3217763e+08	9917	13328.39	4
2010	43	4	4301909	1.6761753e+08	12568	13336.85	4
2010	52	5	5219001	1.0090012e+08	7563	13341.28	4
2010	43	4	4317707	1.4961899e+08	11210	13346.92	4
2010	41	4	4123303	1.0811467e+08	8093	13359.03	4
2010	43	4	4310652	3.459853e+07	2589	13363.67	4
2010	35	3	3527256	2.840797e+07	2123	13381.05	4
2010	31	3	3143302	4.84367509e+09	361971	13381.39	4
2010	31	3	3134509	5.237786e+07	3913	13385.6	4
2010	35	3	3522406	1.17501656e+09	87765	13388.21	4
2010	11	1	1100601	7.670081e+07	5727	13392.84	4
2010	42	4	4215554	3.190569e+07	2382	13394.49	4
2010	41	4	4122800	5.899799e+07	4403	13399.5	4
2010	41	4	4105003	1.3683176e+08	10208	13404.37	4
2010	32	3	3203353	1.4894431e+08	11107	13409.95	4
2010	43	4	4302402	1.5418021e+08	11472	13439.7	4
2010	35	3	3527405	2.6734105e+08	19885	13444.36	4
2010	51	5	5104906	1.0352582e+08	7696	13451.9	4
2010	52	5	5210802	6.815403e+07	5066	13453.22	4
2010	43	4	4301057	1.0424789e+08	7744	13461.76	4
2010	41	4	4127858	1.593405e+08	11824	13476.02	4
2010	41	4	4108601	3.9123155e+08	29024	13479.59	4
2010	43	4	4311700	7.435215e+07	5515	13481.8	4
2010	31	3	3112604	2.0623957e+08	15297	13482.35	4
2010	31	3	3105905	2.6463329e+08	19623	13485.87	4
2010	31	3	3134905	3.0746322e+08	22797	13487	4
2010	50	5	5006606	1.0504149e+09	77866	13490.03	4
2010	43	4	4321634	3.852242e+07	2855	13492.97	4
2010	27	2	2702306	7.0392719e+08	52160	13495.54	4
2010	35	3	3511607	2.0982726e+08	15547	13496.32	4
2010	21	2	2110658	9.427244e+07	6983	13500.28	4
2010	41	4	4118402	1.10175687e+09	81595	13502.75	4
2010	43	4	4301925	2.704872e+07	2003	13504.1	4
2010	15	1	1501402	1.880103914e+10	1392031	13506.19	4
2010	43	4	4314209	1.0559347e+08	7817	13508.18	4
2010	35	3	3519006	1.1747421e+08	8696	13508.99	4
2010	31	3	3126109	8.79186e+08	65064	13512.63	4
2010	35	3	3543204	6.033581e+07	4464	13516.09	4
2010	41	4	4128658	5.342632e+07	3950	13525.65	4
2010	35	3	3512209	3.414236e+08	25242	13526.01	4
2010	35	3	3517109	6.190948e+07	4577	13526.21	4
2010	42	4	4205100	5.037027e+07	3723	13529.48	4
2010	31	3	3142809	2.6541351e+08	19616	13530.46	4
2010	35	3	3500501	2.3368408e+08	17261	13538.27	4
2010	32	3	3203346	1.9311433e+08	14249	13552.83	4
2010	35	3	3519907	1.0338757e+08	7627	13555.47	4
2010	31	3	3164431	3.793988e+07	2798	13559.64	4
2010	23	2	2312908	2.55378508e+09	188271	13564.41	4
2010	43	4	4305371	4.709569e+07	3471	13568.33	4
2010	35	3	3546256	2.651279e+07	1953	13575.42	4
2010	52	5	5212105	9.64942e+07	7108	13575.44	4
2010	52	5	5215652	4.591569e+07	3382	13576.49	4
2010	51	5	5105622	3.4401104e+08	25331	13580.63	4
2010	43	4	4306007	1.9132784e+08	14085	13583.8	4
2010	43	4	4304697	3.582015e+07	2636	13588.83	4
2010	52	5	5212907	2.816366e+07	2072	13592.5	4
2010	43	4	4315172	2.719134e+07	2000	13595.67	4
2010	41	4	4109104	3.015871e+07	2218	13597.26	4
2010	35	3	3515905	4.086781e+07	3003	13609	4
2010	42	4	4219358	7.088462e+07	5208	13610.72	4
2010	52	5	5205406	2.8177288e+08	20686	13621.43	4
2010	35	3	3517000	1.4680683e+08	10777	13622.24	4
2010	31	3	3152105	7.8159573e+08	57361	13625.91	4
2010	51	5	5104203	1.8901383e+08	13867	13630.48	4
2010	31	3	3136306	6.1703552e+08	45260	13633.13	4
2010	31	3	3127800	2.0490333e+08	15026	13636.59	4
2010	41	4	4117453	7.763132e+07	5690	13643.47	4
2010	52	5	5205059	4.964775e+07	3638	13646.99	4
2010	31	3	3135704	7.035604e+07	5153	13653.41	4
2010	35	3	3555802	1.2064709e+08	8836	13654.04	4
2010	17	1	1714880	1.4602701e+08	10686	13665.26	4
2010	29	2	2903276	1.9401097e+08	14189	13673.34	4
2010	41	4	4111555	1.0290637e+08	7524	13677.08	4
2010	43	4	4305801	1.3323908e+08	9741	13678.17	4
2010	43	4	4317251	2.349117e+07	1717	13681.52	4
2010	52	5	5209952	1.8752628e+08	13703	13685.05	4
2010	29	2	2910727	1.3722662e+09	100246	13688.99	4
2010	41	4	4126306	2.5217012e+08	18410	13697.45	4
2010	35	3	3530904	4.475195e+07	3266	13702.37	4
2010	43	4	4300406	1.06442481e+09	77673	13703.92	4
2010	31	3	3149903	2.759991e+08	20140	13704.03	4
2010	31	3	3145208	1.01051616e+09	73719	13707.68	4
2010	41	4	4128203	7.2333453e+08	52753	13711.72	4
2010	41	4	4118451	6.614335e+07	4823	13714.15	4
2010	41	4	4103354	7.866397e+07	5735	13716.47	4
2010	51	5	5103106	7.542946e+07	5498	13719.44	4
2010	41	4	4113007	9.076505e+07	6613	13725.25	4
2010	42	4	4200051	3.643583e+07	2653	13733.82	4
2010	31	3	3147600	2.1436174e+08	15584	13755.24	4
2010	41	4	4125605	5.6773713e+08	41257	13760.99	4
2010	35	3	3514957	3.3343e+07	2423	13761.04	4
2010	43	4	4302378	3.203761e+07	2328	13761.86	4
2010	50	5	5002803	7.432771e+07	5400	13764.39	4
2010	42	4	4215679	1.2071301e+08	8767	13769.02	4
2010	52	5	5202809	3.376357e+07	2451	13775.43	4
2010	42	4	4206603	6.764464e+07	4908	13782.53	4
2010	35	3	3515301	3.667961e+07	2661	13784.14	4
2010	41	4	4104709	1.889868e+08	13706	13788.62	4
2010	35	3	3528502	1.11612781e+09	80920	13792.98	4
2010	50	5	5000807	1.1717782e+08	8494	13795.36	4
2010	35	3	3504800	1.1263268e+08	8160	13803.02	4
2010	24	2	2403251	2.79428475e+09	202413	13804.87	4
2010	43	4	4310850	5.677797e+07	4111	13811.23	4
2010	51	5	5103205	4.2630029e+08	30864	13812.22	4
2010	31	3	3107406	6.3034085e+08	45626	13815.39	4
2010	35	3	3554300	2.9556258e+08	21389	13818.44	4
2010	43	4	4319604	3.2888694e+08	23798	13819.94	4
2010	35	3	3525102	5.2147098e+08	37725	13822.96	4
2010	16	1	1600303	5.50389637e+09	397913	13831.91	4
2010	17	1	1707009	2.6435721e+08	19110	13833.45	4
2010	32	3	3203130	2.1880925e+08	15808	13841.68	4
2010	41	4	4111803	5.4134223e+08	39093	13847.55	4
2010	33	3	3305703	2.0667577e+08	14920	13852.26	4
2010	51	5	5100250	6.8297365e+08	49233	13872.27	4
2010	43	4	4306320	4.427315e+07	3190	13878.73	4
2010	35	3	3537503	1.0364821e+08	7468	13878.98	4
2010	42	4	4200705	1.3066814e+08	9410	13886.09	4
2010	41	4	4106605	2.8364506e+08	20419	13891.23	4
2010	31	3	3138807	2.4305489e+08	17492	13895.2	4
2010	31	3	3153004	4.565799e+07	3285	13898.93	4
2010	43	4	4320552	8.131107e+07	5850	13899.33	4
2010	41	4	4111100	8.308199e+07	5977	13900.28	4
2010	43	4	4323507	3.938402e+07	2832	13906.79	4
2010	31	3	3148905	5.396843e+07	3878	13916.56	4
2010	41	4	4111605	4.186428e+07	3008	13917.65	4
2010	33	3	3303708	5.7230449e+08	41088	13928.75	4
2010	31	3	3139409	1.10945752e+09	79635	13931.78	4
2010	29	2	2913606	2.56719716e+09	184231	13934.66	4
2010	31	3	3143609	3.712211e+07	2661	13950.44	4
2010	41	4	4110706	7.8530246e+08	56288	13951.51	4
2010	41	4	4108205	1.05263e+08	7543	13955.06	4
2010	43	4	4320206	1.5215152e+08	10902	13956.29	4
2010	43	4	4310413	3.164838e+07	2267	13960.47	4
2010	42	4	4213401	1.5402837e+08	11031	13963.23	4
2010	51	5	5104559	6.383426e+07	4570	13968.11	4
2010	42	4	4218905	1.4948912e+08	10702	13968.34	4
2010	31	3	3154705	5.348322e+07	3826	13978.89	4
2010	29	2	2903201	1.9215783e+09	137428	13982.44	4
2010	43	4	4303301	6.930455e+07	4954	13989.61	4
2010	41	4	4116505	2.006487e+07	1433	14002	4
2010	41	4	4103602	3.3447177e+08	23871	14011.64	4
2010	42	4	4218103	7.448498e+07	5308	14032.59	4
2010	50	5	5002209	2.7519371e+08	19598	14041.93	4
2010	52	5	5207253	1.1085891e+08	7892	14047	4
2010	42	4	4214102	3.208934e+07	2284	14049.62	4
2010	42	4	4202438	4.624754e+07	3290	14057	4
2010	50	5	5004700	3.1431494e+08	22355	14060.16	4
2010	41	4	4118105	1.4433457e+08	10256	14073.18	4
2010	41	4	4102208	5.507814e+07	3913	14075.68	4
2010	31	3	3108800	7.086287e+07	5034	14076.85	4
2010	35	3	3531506	2.6652749e+08	18931	14078.89	4
2010	42	4	4201604	4.932004e+07	3500	14091.44	4
2010	50	5	5004502	2.9427142e+08	20879	14094.13	4
2010	31	3	3142601	1.1516915e+08	8168	14100.04	4
2010	51	5	5105101	4.6209705e+08	32769	14101.65	4
2010	52	5	5212303	1.1109811e+08	7875	14107.7	4
2010	35	3	3516507	3.818093e+07	2705	14114.95	4
2010	43	4	4305835	2.156955e+07	1528	14116.2	4
2010	22	2	2201150	1.4845142e+08	10516	14116.72	4
2010	43	4	4305587	3.42013e+07	2420	14132.77	4
2010	35	3	3502507	4.960622e+08	35043	14155.81	4
2010	35	3	3519303	4.3493393e+08	30724	14156.16	4
2010	41	4	4123824	5.558001e+07	3926	14156.91	4
2010	43	4	4321204	7.7421144e+08	54656	14165.17	4
2010	43	4	4315149	3.520524e+07	2485	14167.1	4
2010	41	4	4101150	4.054183e+07	2861	14170.51	4
2010	43	4	4314050	7.2960655e+08	51481	14172.35	4
2010	43	4	4314035	4.984226e+07	3511	14196.03	4
2010	35	3	3503000	7.315184e+07	5150	14204.24	4
2010	35	3	3519204	9.118876e+07	6419	14206.07	4
2010	43	4	4305934	2.451228e+07	1725	14210.02	4
2010	43	4	4310330	2.510657e+08	17667	14211	4
2010	42	4	4216057	7.135765e+07	5019	14217.5	4
2010	43	4	4314456	3.575908e+07	2515	14218.32	4
2010	43	4	4317954	3.499704e+07	2461	14220.66	4
2010	33	3	3306107	1.02259636e+09	71894	14223.67	4
2010	51	5	5103858	8.943931e+07	6287	14226.07	4
2010	31	3	3170750	8.634883e+07	6065	14237.24	4
2010	52	5	5222005	1.7869942e+08	12549	14240.13	4
2010	50	5	5008404	8.40704e+07	5901	14246.81	4
2010	33	3	3306206	4.9105094e+08	34439	14258.57	4
2010	35	3	3509700	6.8191597e+08	47824	14258.87	4
2010	35	3	3553708	7.6980359e+08	53985	14259.58	4
2010	43	4	4311759	1.008883e+08	7074	14261.85	4
2010	42	4	4210308	1.0667702e+08	7479	14263.54	4
2010	51	5	5107354	7.512838e+07	5267	14263.98	4
2010	52	5	5203203	1.2412586e+08	8701	14265.7	4
2010	52	5	5206305	4.185366e+07	2933	14269.91	4
2010	31	3	3133600	1.2377037e+08	8673	14270.77	4
2010	52	5	5200209	2.873994e+07	2012	14284.26	4
2010	17	1	1720978	3.660621e+07	2562	14288.14	4
2010	43	4	4313425	5.611656e+07	3927	14289.93	4
2010	35	3	3551900	2.2179625e+08	15504	14305.74	4
2010	50	5	5004601	2.664822e+08	18618	14313.15	4
2010	35	3	3517703	2.8437139e+08	19864	14315.92	4
2010	41	4	4123204	5.22218e+07	3646	14323.04	4
2010	43	4	4315453	3.088442e+07	2155	14331.52	4
2010	51	5	5107578	5.071656e+07	3538	14334.81	4
2010	31	3	3103207	3.22328e+07	2247	14344.81	4
2010	52	5	5217401	4.1200965e+08	28691	14360.24	4
2010	11	1	1100106	5.9816705e+08	41646	14363.13	4
2010	22	2	2205581	5.549726e+07	3863	14366.36	4
2010	31	3	3162005	3.4355018e+08	23909	14369.07	4
2010	50	5	5006259	7.106402e+07	4944	14373.79	4
2010	31	3	3148004	1.99695516e+09	138836	14383.55	4
2010	35	3	3501103	5.905646e+07	4105	14386.47	4
2010	41	4	4112751	1.2950138e+08	9001	14387.44	4
2010	33	3	3304706	5.8405591e+08	40569	14396.61	4
2010	31	3	3128303	2.6942537e+08	18714	14397	4
2010	35	3	3525409	4.561486e+07	3168	14398.63	4
2010	41	4	4116901	3.8332908e+08	26613	14403.83	4
2010	33	3	3300258	4.0009366e+08	27770	14407.41	4
2010	51	5	5101407	2.6786394e+08	18581	14416.01	4
2010	35	3	3540903	2.5090134e+08	17404	14416.3	4
2010	42	4	4207650	1.2132311e+08	8413	14420.91	4
2010	32	3	3200706	1.419837e+08	9840	14429.24	4
2010	42	4	4202875	4.116203e+07	2852	14432.69	4
2010	41	4	4124301	3.481619e+07	2412	14434.57	4
2010	35	3	3516853	6.381167e+07	4420	14437.03	4
2010	35	3	3551603	3.8064379e+08	26362	14439.11	4
2010	43	4	4317608	5.7310619e+08	39679	14443.56	4
2010	35	3	3545605	2.0718016e+08	14333	14454.77	4
2010	52	5	5200308	3.4466162e+08	23828	14464.56	4
2010	35	3	3522000	4.722075e+07	3263	14471.57	4
2010	41	4	4110656	3.731605e+07	2578	14474.81	4
2010	41	4	4101408	1.74996449e+09	120884	14476.39	4
2010	52	5	5209705	2.518654e+08	17398	14476.69	4
2010	35	3	3545407	1.2730662e+08	8787	14488.06	4
2010	42	4	4208708	1.5379162e+08	10608	14497.7	4
2010	17	1	1703057	4.529633e+07	3124	14499.46	4
2010	31	3	3140704	4.0396731e+08	27856	14501.99	4
2010	31	3	3127107	7.7552092e+08	53474	14502.77	4
2010	31	3	3123502	2.672382e+07	1841	14515.92	4
2010	31	3	3109907	1.4850198e+08	10227	14520.58	4
2010	31	3	3124708	5.108638e+07	3515	14533.82	4
2010	43	4	4317301	4.5086925e+08	31002	14543.23	4
2010	42	4	4215109	1.5876069e+08	10914	14546.52	4
2010	31	3	3115300	1.01591919e+09	69810	14552.63	4
2010	41	4	4120333	5.001806e+07	3434	14565.54	4
2010	35	3	3509452	8.110162e+07	5567	14568.28	4
2010	41	4	4128104	1.46737096e+09	100716	14569.39	4
2010	42	4	4203402	1.0907945e+08	7486	14571.13	4
2010	42	4	4211108	1.2167695e+08	8348	14575.58	4
2010	41	4	4106571	6.229827e+07	4274	14576.1	4
2010	41	4	4120101	6.581124e+07	4515	14576.13	4
2010	41	4	4118857	8.232787e+07	5648	14576.46	4
2010	35	3	3547106	4.126744e+07	2831	14576.98	4
2010	43	4	4303004	1.22214757e+09	83827	14579.4	4
2010	43	4	4321501	5.0524224e+08	34646	14582.99	4
2010	41	4	4127965	2.019616e+08	13838	14594.71	4
2010	15	1	1505502	1.42723867e+09	97788	14595.23	4
2010	33	3	3302908	3.5976377e+08	24647	14596.66	4
2010	32	3	3204203	2.6465297e+08	18123	14603.15	4
2010	35	3	3512803	8.5925337e+08	58821	14607.94	4
2010	35	3	3528205	5.353119e+07	3664	14610.04	4
2010	52	5	5220058	2.474841e+07	1692	14626.72	4
2010	52	5	5209937	8.343511e+07	5702	14632.6	4
2010	43	4	4318614	3.046706e+07	2082	14633.55	4
2010	41	4	4117404	4.947347e+07	3380	14637.12	4
2010	24	2	2404309	1.8116003e+08	12373	14641.56	4
2010	35	3	3514304	1.2603921e+08	8607	14643.8	4
2010	43	4	4300109	2.4507081e+08	16729	14649.46	4
2010	52	5	5203500	3.0387105e+08	20729	14659.22	4
2010	31	3	3161304	8.505481e+07	5800	14664.62	4
2010	51	5	5108105	5.040477e+07	3437	14665.34	4
2010	43	4	4300703	8.913924e+07	6073	14677.96	4
2010	35	3	3531605	5.966493e+07	4063	14684.94	4
2010	33	3	3302700	1.87327335e+09	127519	14690.15	4
2010	42	4	4215208	8.154819e+07	5551	14690.72	4
2010	42	4	4201703	1.0899561e+08	7419	14691.42	4
2010	52	5	5210406	5.202564e+08	35412	14691.53	4
2010	35	3	3517802	1.2395696e+08	8435	14695.55	4
2010	31	3	3130101	5.1293953e+08	34879	14706.26	4
2010	43	4	4308003	9.813175e+07	6672	14708	4
2010	31	3	3107604	5.71088e+07	3882	14711.18	4
2010	31	3	3111101	2.8377617e+08	19285	14714.86	4
2010	43	4	4304101	5.142201e+07	3494	14717.23	4
2010	41	4	4104428	2.2062208e+08	14982	14725.81	4
2010	31	3	3103900	1.1615714e+08	7884	14733.27	4
2010	33	3	3304144	2.03247071e+09	137938	14734.67	4
2010	24	2	2409902	1.9801022e+08	13436	14737.29	4
2010	42	4	4209151	6.961354e+07	4720	14748.63	4
2010	42	4	4206801	4.978546e+07	3373	14759.99	4
2010	35	3	3521309	2.0880871e+08	14146	14760.97	4
2010	43	4	4313466	2.596166e+07	1757	14776.13	4
2010	31	3	3109303	3.3634856e+08	22729	14798.21	4
2010	43	4	4321857	6.483571e+07	4381	14799.3	4
2010	41	4	4114807	4.7345344e+08	31972	14808.38	4
2010	35	3	3513306	3.362449e+07	2270	14812.55	4
2010	15	1	1504208	3.45862464e+09	233462	14814.51	4
2010	35	3	3540408	6.257761e+07	4223	14818.28	4
2010	43	4	4310751	3.194976e+07	2156	14819	4
2010	51	5	5105507	2.1480633e+08	14491	14823.43	4
2010	43	4	4301206	1.877767e+08	12648	14846.36	4
2010	42	4	4207403	8.48202e+07	5709	14857.28	4
2010	41	4	4101200	2.8068715e+08	18891	14858.25	4
2010	41	4	4127601	2.1588703e+08	14526	14862.11	4
2010	11	1	1100320	3.2447591e+08	21824	14867.85	4
2010	41	4	4113403	6.165754e+07	4145	14875.16	4
2010	43	4	4314787	2.606414e+07	1750	14893.8	4
2010	43	4	4310306	6.103824e+07	4098	14894.64	4
2010	41	4	4106852	4.711447e+07	3162	14900.21	4
2010	41	4	4101853	3.656441e+07	2453	14906	4
2010	31	3	3171204	1.56116216e+09	104612	14923.36	4
2010	35	3	3504503	1.2377118e+09	82935	14923.88	4
2010	35	3	3515657	2.333013e+07	1563	14926.51	4
2010	35	3	3537305	8.7379433e+08	58529	14929.25	4
2010	42	4	4217105	4.795109e+07	3211	14933.38	4
2010	32	3	3201308	5.21118328e+09	348933	14934.62	4
2010	51	5	5108303	5.627038e+07	3767	14937.72	4
2010	42	4	4206702	3.1743634e+08	21233	14950.14	4
2010	42	4	4201901	8.302456e+07	5552	14953.99	4
2010	50	5	5006408	1.1915115e+08	7967	14955.59	4
2010	43	4	4302303	1.7291922e+08	11556	14963.59	4
2010	35	3	3539707	4.776908e+07	3192	14965.25	4
2010	29	2	2916401	1.02259967e+09	68314	14969.11	4
2010	41	4	4109401	2.50759318e+09	167463	14974.01	4
2010	25	2	2504603	3.2078222e+08	21418	14977.23	4
2010	50	5	5006903	2.3021443e+08	15369	14979.14	4
2010	33	3	3302205	1.43622198e+09	95876	14979.99	4
2010	41	4	4104501	2.7731668e+08	18512	14980.37	4
2010	52	5	5200134	3.0394584e+08	20283	14985.25	4
2010	25	2	2507507	1.08439578e+10	723514	14987.9	4
2010	35	3	3507407	2.1780937e+08	14532	14988.26	4
2010	43	4	4311643	2.436799e+07	1624	15004.92	4
2010	41	4	4128534	1.4961832e+08	9967	15011.37	4
2010	41	4	4103040	9.83376e+07	6549	15015.67	4
2010	35	3	3555307	2.970628e+07	1978	15018.34	4
2010	41	4	4110953	1.3558829e+08	9027	15020.3	4
2010	35	3	3552601	1.7088665e+08	11366	15034.9	4
2010	31	3	3151503	4.7965495e+08	31885	15043.28	4
2010	31	3	3162922	3.8547653e+08	25619	15046.51	4
2010	43	4	4312625	2.727966e+07	1813	15046.7	4
2010	35	3	3546108	3.136181e+07	2084	15048.85	4
2010	42	4	4206751	2.927479e+07	1945	15051.3	4
2010	51	5	5107008	2.6512013e+08	17602	15061.93	4
2010	51	5	5103361	5.106204e+07	3388	15071.44	4
2010	50	5	5004304	2.2445121e+08	14887	15076.99	4
2010	31	3	3131604	9.749543e+07	6464	15082.83	4
2010	11	1	1100049	1.18649409e+09	78601	15095.15	4
2010	42	4	4204400	1.5418099e+08	10213	15096.54	4
2010	11	1	1100023	1.36469378e+09	90354	15103.86	4
2010	35	3	3543105	6.457866e+07	4273	15113.19	4
2010	31	3	3133402	2.0659155e+08	13669	15113.87	4
2010	52	5	5222203	7.167577e+07	4742	15115.09	4
2010	23	2	2304400	3.700183077e+10	2447409	15118.78	4
2010	32	3	3202603	1.8927645e+08	12514	15125.18	4
2010	35	3	3537404	3.7762019e+08	24959	15129.62	4
2010	41	4	4104105	1.0781801e+08	7125	15132.35	4
2010	35	3	3544608	7.908477e+07	5226	15132.94	4
2010	43	4	4318903	5.2297778e+08	34558	15133.33	4
2010	43	4	4305959	5.929259e+07	3917	15137.25	4
2010	33	3	3305307	1.3486395e+08	8906	15143.04	4
2010	42	4	4215604	3.127038e+07	2065	15143.04	4
2010	41	4	4119400	3.5497169e+08	23425	15153.54	4
2010	41	4	4107504	2.1095707e+08	13920	15154.96	4
2010	41	4	4101309	1.1140742e+08	7351	15155.41	4
2010	50	5	5004908	9.614045e+07	6341	15161.72	4
2010	26	2	2612208	8.5889371e+08	56641	15163.82	4
2010	41	4	4113452	8.132995e+07	5363	15165.01	4
2010	41	4	4109658	9.041936e+07	5960	15171.03	4
2010	43	4	4306759	3.080568e+07	2030	15175.21	4
2010	32	3	3204559	5.1886401e+08	34178	15181.23	4
2010	43	4	4309555	6.460421e+07	4254	15186.7	4
2010	52	5	5206602	4.496798e+07	2961	15186.76	4
2010	35	3	3510807	4.3028288e+08	28312	15197.9	4
2010	17	1	1716505	1.7546804e+08	11542	15202.57	4
2010	41	4	4111209	1.6012913e+08	10532	15204.06	4
2010	15	1	1503044	2.7103598e+08	17825	15205.38	4
2010	24	2	2407104	1.057411e+09	69538	15206.23	4
2010	41	4	4108957	1.2024205e+08	7900	15220.51	4
2010	50	5	5006309	6.1146882e+08	40174	15220.51	4
2010	29	2	2927408	4.076268673e+10	2676606	15229.24	4
2010	42	4	4205209	6.630289e+07	4353	15231.54	4
2010	52	5	5201306	3.0886391e+08	20272	15235.99	4
2010	35	3	3549953	2.1328906e+08	13985	15251.27	4
2010	43	4	4316105	1.559908e+08	10228	15251.35	4
2010	43	4	4316006	2.9737539e+08	19493	15255.5	4
2010	25	2	2509305	1.1297007e+08	7404	15257.98	4
2010	42	4	4200903	8.011482e+07	5250	15259.97	4
2010	29	2	2921005	6.1377734e+08	40210	15264.3	4
2010	42	4	4215505	2.402646e+08	15740	15264.59	4
2010	12	1	1200401	5.12585132e+09	335796	15264.78	4
2010	33	3	3301207	2.6620313e+08	17439	15264.82	4
2010	35	3	3535804	2.7192975e+08	17810	15268.37	4
2010	42	4	4209458	2.275225e+07	1490	15269.97	4
2010	43	4	4314076	9.188347e+07	6011	15285.89	4
2010	35	3	3518701	4.4431421e+09	290607	15289.18	4
2010	31	3	3141306	5.265943e+07	3444	15290.19	4
2010	41	4	4112603	2.154621e+07	1409	15291.84	4
2010	31	3	3165537	3.9485173e+08	25798	15305.52	4
2010	31	3	3108206	8.9843e+07	5867	15313.28	4
2010	43	4	4320701	2.187559e+08	14285	15313.68	4
2010	11	1	1100114	7.9729643e+08	52043	15319.96	4
2010	43	4	4301701	1.0006435e+08	6529	15326.14	4
2010	43	4	4320321	4.313362e+07	2814	15328.22	4
2010	43	4	4312708	1.8512084e+08	12076	15329.65	4
2010	43	4	4300877	7.462834e+07	4868	15330.39	4
2010	35	3	3546009	2.1124736e+08	13770	15341.13	4
2010	52	5	5219308	5.5935422e+08	36459	15342.01	4
2010	35	3	3536208	2.8314813e+08	18453	15344.29	4
2010	43	4	4316907	4.00638403e+09	261027	15348.54	4
2010	41	4	4101002	2.656803e+08	17308	15350.14	4
2010	35	3	3528304	4.912088e+07	3200	15350.28	4
2010	43	4	4315131	2.879386e+07	1875	15356.72	4
2010	43	4	4312179	2.764316e+07	1799	15365.85	4
2010	35	3	3532702	6.580788e+07	4274	15397.26	4
2010	51	5	5106802	8.392809e+07	5448	15405.3	4
2010	35	3	3503356	2.966804e+07	1925	15411.97	4
2010	42	4	4208955	2.723238e+07	1766	15420.38	4
2010	31	3	3170800	5.5217491e+08	35804	15422.16	4
2010	35	3	3541307	6.3746572e+08	41324	15426.04	4
2010	43	4	4313607	6.545737e+07	4243	15427.14	4
2010	31	3	3139003	5.9681944e+08	38684	15428.07	4
2010	43	4	4306304	7.239997e+07	4683	15460.17	4
2010	43	4	4308250	3.120085e+07	2018	15461.27	4
2010	42	4	4214409	9.504995e+07	6147	15462.82	4
2010	42	4	4209805	5.203554e+07	3365	15463.76	4
2010	51	5	5108402	3.9085803e+09	252709	15466.72	4
2010	42	4	4214508	9.585885e+07	6195	15473.58	4
2010	31	3	3149200	5.403458e+07	3490	15482.69	4
2010	42	4	4215455	1.610844e+08	10402	15485.91	4
2010	43	4	4322558	3.073126e+07	1984	15489.55	4
2010	42	4	4206405	1.627076e+08	10498	15498.91	4
2010	41	4	4111407	1.9869373e+08	12806	15515.67	4
2010	43	4	4310876	3.889844e+07	2507	15515.93	4
2010	41	4	4128005	3.3463828e+08	21562	15519.82	4
2010	42	4	4206900	2.6920262e+08	17342	15523.16	4
2010	35	3	3522208	2.36661314e+09	152380	15531	4
2010	52	5	5218607	1.6332727e+08	10516	15531.31	4
2010	33	3	3300308	1.47328434e+09	94855	15531.96	4
2010	31	3	3148103	1.28227479e+09	82541	15535	4
2010	41	4	4119657	4.373934e+07	2814	15543.48	4
2010	42	4	4212601	4.644991e+07	2988	15545.49	4
2010	43	4	4304630	6.5365526e+08	42047	15545.82	4
2010	50	5	5002902	3.2544313e+08	20932	15547.64	4
2010	35	3	3525854	4.354908e+07	2801	15547.69	4
2010	43	4	4316204	8.592271e+07	5520	15565.71	4
2010	31	3	3166808	1.6412413e+08	10541	15570.07	4
2010	43	4	4308433	3.85204e+07	2473	15576.38	4
2010	35	3	3510005	4.661577e+08	29911	15584.82	4
2010	41	4	4104204	1.75339975e+09	112486	15587.72	4
2010	43	4	4302204	1.0253224e+08	6576	15591.89	4
2010	31	3	3144706	2.7350732e+08	17540	15593.35	4
2010	52	5	5220603	2.9799893e+08	19096	15605.31	4
2010	35	3	3504602	2.2805994e+08	14605	15615.2	4
2010	42	4	4209706	1.852635e+08	11862	15618.23	4
2010	43	4	4319703	5.672583e+07	3632	15618.34	4
2010	35	3	3519808	1.1663089e+08	7462	15629.98	4
2010	52	5	5209150	7.735655e+07	4948	15633.9	4
2010	51	5	5101803	8.8233092e+08	56423	15637.79	4
2010	41	4	4126801	2.283805e+08	14600	15642.5	4
2010	43	4	4306973	4.647598e+07	2970	15648.48	4
2010	35	3	3515608	8.661916e+07	5534	15652.18	4
2010	43	4	4311502	1.2005982e+08	7669	15655.21	4
2010	42	4	4203253	4.310551e+07	2753	15657.65	4
2010	41	4	4121406	2.5598203e+08	16348	15658.31	4
2010	43	4	4318408	3.4680586e+08	22141	15663.51	4
2010	27	2	2702702	6.786204e+07	4332	15665.29	4
2010	43	4	4310405	1.0377403e+08	6618	15680.57	4
2010	41	4	4115754	1.3412855e+08	8553	15682.05	4
2010	35	3	3528007	2.5504725e+08	16246	15699.08	4
2010	43	4	4306932	1.4045535e+08	8938	15714.4	4
2010	42	4	4216503	3.9020726e+08	24812	15726.55	4
2010	24	2	2412005	1.38000279e+09	87700	15735.49	4
2010	43	4	4318440	4.372578e+07	2774	15762.72	4
2010	43	4	4302253	4.37931e+07	2778	15764.25	4
2010	35	3	3508801	2.6196362e+08	16612	15769.54	4
2010	35	3	3533502	5.7751017e+08	36612	15773.79	4
2010	43	4	4317509	1.20399571e+09	76304	15778.93	4
2010	41	4	4124020	1.633332e+08	10342	15793.19	4
2010	51	5	5106307	3.0470298e+08	19280	15804.1	4
2010	52	5	5203302	3.87922e+08	24539	15808.39	4
2010	43	4	4307864	4.080115e+07	2579	15820.53	4
2010	35	3	3539905	8.537255e+07	5395	15824.38	4
2010	32	3	3205069	3.2390945e+08	20468	15825.16	4
2010	42	4	4213906	2.728316e+07	1724	15825.5	4
2010	35	3	3555000	1.00587495e+09	63492	15842.55	4
2010	35	3	3516200	5.05691828e+09	318785	15863.1	4
2010	43	4	4318200	3.2608101e+08	20540	15875.41	4
2010	41	4	4115606	2.5525532e+08	16077	15877.05	4
2010	42	4	4203105	9.872665e+07	6218	15877.56	4
2010	43	4	4321907	3.8063722e+08	23973	15877.75	4
2010	35	3	3503406	1.2456646e+08	7842	15884.53	4
2010	42	4	4213708	2.3541505e+08	14812	15893.54	4
2010	43	4	4316758	9.046996e+07	5692	15894.23	4
2010	11	1	1100122	1.8553587e+09	116587	15913.94	4
2010	33	3	3300506	4.0418656e+08	25398	15914.11	4
2010	41	4	4114302	3.5392477e+08	22235	15917.46	4
2010	35	3	3524808	7.4834464e+08	47012	15918.16	4
2010	43	4	4318002	9.8226469e+08	61662	15929.82	4
2010	52	5	5215306	2.2777733e+08	14292	15937.4	4
2010	43	4	4305504	7.847581e+07	4922	15943.89	4
2010	35	3	3510500	1.60917749e+09	100899	15948.4	4
2010	35	3	3543303	1.80380037e+09	113043	15956.76	4
2010	16	1	1600154	1.7195938e+08	10773	15962.07	4
2010	35	3	3532504	1.4022945e+08	8777	15976.92	4
2010	43	4	4300554	2.952727e+07	1848	15977.96	4
2010	31	3	3147303	3.0985929e+08	19392	15978.72	4
2010	41	4	4125100	2.1905809e+08	13704	15984.97	4
2010	35	3	3524600	2.7492984e+08	17196	15988.01	4
2010	43	4	4313953	1.5823467e+08	9895	15991.38	4
2010	43	4	4306601	6.2245495e+08	38916	15994.83	4
2010	42	4	4200754	3.207725e+07	2005	15998.63	4
2010	43	4	4312476	9.096204e+07	5680	16014.44	4
2010	43	4	4313086	3.916313e+07	2445	16017.64	4
2010	35	3	3524204	1.0562521e+08	6592	16023.24	4
2010	11	1	1100189	5.4086156e+08	33754	16023.63	4
2010	31	3	3122306	3.4174886e+09	213076	16038.82	4
2010	41	4	4103024	4.440862e+07	2768	16043.58	4
2010	33	3	3303401	2.92104712e+09	182016	16048.3	4
2010	35	3	3509601	1.18943996e+09	74114	16048.79	4
2010	41	4	4106407	7.5318209e+08	46925	16050.76	4
2010	52	5	5220108	4.8236423e+08	30050	16052.05	4
2010	52	5	5211305	1.011213e+08	6298	16056.1	4
2010	42	4	4206108	9.993697e+07	6223	16059.29	4
2010	35	3	3513207	1.2199353e+08	7591	16070.81	4
2010	24	2	2408102	1.291897225e+10	803811	16072.15	4
2010	41	4	4102703	4.382922e+07	2727	16072.32	4
2010	17	1	1709500	1.23437356e+09	76765	16079.9	4
2010	52	5	5213806	6.6743997e+08	41457	16099.57	4
2010	43	4	4322301	1.3798765e+08	8557	16125.7	4
2010	31	3	3143708	5.487983e+07	3399	16145.88	4
2010	43	4	4303608	1.057162e+08	6545	16152.21	4
2010	43	4	4301305	2.9833475e+08	18469	16153.27	4
2010	35	3	3518107	1.0341851e+08	6400	16159.14	4
2010	42	4	4201406	9.9156935e+08	61339	16165.4	4
2010	41	4	4101903	2.6477579e+08	16368	16176.43	4
2010	35	3	3514403	6.9988895e+08	43263	16177.54	4
2010	52	5	5214507	3.9146391e+08	24189	16183.55	4
2010	43	4	4309704	7.961658e+07	4919	16185.52	4
2010	52	5	5214838	1.9281443e+08	11911	16187.93	4
2010	43	4	4320578	3.442868e+07	2126	16194.11	4
2010	31	3	3138203	1.49400195e+09	92171	16209.02	4
2010	35	3	3519600	8.6180395e+08	53166	16209.68	4
2010	29	2	2917706	4.9184118e+08	30342	16209.91	4
2010	43	4	4322707	3.8882328e+08	23986	16210.43	4
2010	41	4	4120358	9.133193e+07	5632	16216.61	4
2010	41	4	4126108	8.680045e+07	5349	16227.42	4
2010	43	4	4322186	2.55456e+07	1574	16229.73	4
2010	31	3	3143104	7.4343999e+08	45799	16232.67	4
2010	35	3	3514106	4.0223988e+08	24768	16240.31	4
2010	43	4	4313656	1.7819298e+08	10971	16242.18	4
2010	52	5	5213707	1.2995507e+08	8000	16244.38	4
2010	42	4	4214904	7.22563e+07	4446	16251.98	4
2010	35	3	3524105	6.2915184e+08	38699	16257.57	4
2010	43	4	4321303	4.2490549e+08	26135	16258.1	4
2010	43	4	4305009	1.5158598e+08	9323	16259.36	4
2010	50	5	5003751	1.8993652e+08	11680	16261.69	4
2010	42	4	4207684	1.106499e+08	6802	16267.26	4
2010	35	3	3527900	4.40198e+07	2703	16285.53	4
2010	42	4	4202107	3.6551057e+08	22403	16315.25	4
2010	31	3	3164704	1.06114796e+09	65034	16316.82	4
2010	52	5	5206404	2.5757552e+08	15762	16341.55	4
2010	51	5	5104542	8.597574e+07	5260	16345.2	4
2010	27	2	2708600	8.9234106e+08	54591	16345.94	4
2010	52	5	5212253	2.058037e+07	1259	16346.6	4
2010	35	3	3501004	2.5532213e+08	15609	16357.37	4
2010	43	4	4306130	3.504453e+07	2141	16368.3	4
2010	35	3	3516903	1.7477428e+08	10674	16373.83	4
2010	52	5	5217104	3.9382735e+08	24033	16386.94	4
2010	42	4	4215000	6.5364583e+08	39849	16403.07	4
2010	41	4	4105904	3.6656102e+08	22347	16403.14	4
2010	35	3	3506508	1.78419093e+09	108722	16410.58	4
2010	35	3	3502309	9.28144e+07	5648	16433.14	4
2010	35	3	3527207	1.35660503e+09	82553	16433.14	4
2010	35	3	3530508	1.08974645e+09	66303	16435.85	4
2010	35	3	3545159	1.1604977e+08	7059	16439.97	4
2010	43	4	4319109	9.495609e+07	5773	16448.31	4
2010	31	3	3101508	5.6499318e+08	34341	16452.44	4
2010	35	3	3554755	2.540866e+07	1544	16456.39	4
2010	41	4	4108403	1.29981994e+09	78957	16462.38	4
2010	43	4	4318309	9.9697976e+08	60508	16476.83	4
2010	42	4	4202131	9.894272e+07	6004	16479.47	4
2010	43	4	4303509	1.03439526e+09	62759	16482.02	4
2010	35	3	3516705	7.1099545e+08	43124	16487.23	4
2010	50	5	5003306	5.307021e+08	32180	16491.68	4
2010	35	3	3552304	1.227101e+08	7440	16493.29	4
2010	42	4	4217709	4.3922226e+08	26626	16495.99	4
2010	35	3	3540200	6.6394209e+08	40245	16497.5	4
2010	42	4	4212700	1.0114966e+08	6131	16498.07	4
2010	43	4	4312500	2.0016795e+08	12130	16501.89	4
2010	43	4	4306734	8.769303e+07	5313	16505.37	4
2010	42	4	4202602	1.4764852e+08	8942	16511.8	4
2010	35	3	3532058	7.083931e+07	4290	16512.66	4
2010	41	4	4121109	8.398792e+07	5085	16516.8	4
2010	35	3	3515509	1.06948075e+09	64707	16528.05	4
2010	43	4	4319752	3.21375e+07	1944	16531.63	4
2010	42	4	4212809	2.8233231e+08	17074	16535.8	4
2010	50	5	5002605	2.2573095e+08	13648	16539.49	4
2010	29	2	2910602	5.5051758e+08	33278	16542.99	4
2010	41	4	4124806	1.754795e+08	10607	16543.74	4
2010	35	3	3521903	2.4078244e+08	14553	16545.21	4
2010	25	2	2502151	1.0299413e+08	6224	16547.9	4
2010	43	4	4306551	4.220257e+07	2550	16550.03	4
2010	31	3	3172004	6.2815152e+08	37952	16551.21	4
2010	35	3	3547007	8.967786e+07	5418	16551.84	4
2010	35	3	3553401	3.9816494e+08	24055	16552.27	4
2010	43	4	4320230	4.986131e+07	3011	16559.72	4
2010	17	1	1721257	2.60707e+07	1574	16563.34	4
2010	35	3	3542602	8.9941451e+08	54279	16570.21	4
2010	42	4	4211652	4.560956e+07	2750	16585.29	4
2010	35	3	3555901	2.074947e+07	1251	16586.3	4
2010	41	4	4104907	1.1132196e+09	67082	16594.91	4
2010	41	4	4115309	1.0411822e+08	6269	16608.43	4
2010	51	5	5105606	2.3541335e+08	14172	16611.16	4
2010	31	3	3132602	6.782881e+07	4079	16628.78	4
2010	22	2	2204303	1.8497959e+08	11122	16631.86	4
2010	33	3	3300803	9.0600624e+08	54370	16663.72	4
2010	17	1	1711902	1.702201e+08	10215	16663.74	4
2010	42	4	4202800	4.837907e+08	29018	16672.09	4
2010	35	3	3541059	7.678478e+07	4599	16695.97	4
2010	52	5	5221809	5.11047e+07	3058	16711.81	4
2010	43	4	4315750	7.234386e+07	4327	16719.17	4
2010	42	4	4207106	2.0664283e+08	12356	16724.09	4
2010	41	4	4114203	5.4636999e+08	32669	16724.42	4
2010	35	3	3535507	7.0733552e+08	42281	16729.39	4
2010	35	3	3549250	2.978045e+07	1780	16730.59	4
2010	42	4	4214607	1.1870023e+08	7094	16732.48	4
2010	43	4	4323804	2.0798122e+08	12405	16765.92	4
2010	35	3	3529906	3.4535885e+08	20595	16769.06	4
2010	35	3	3507456	3.851548e+07	2295	16782.34	4
2010	43	4	4308706	9.84121e+07	5862	16788.14	4
2010	35	3	3520905	2.3094919e+08	13746	16801.19	4
2010	35	3	3502705	4.2337276e+08	25196	16803.17	4
2010	41	4	4113205	7.5521986e+08	44936	16806.57	4
2010	50	5	5005152	9.921861e+07	5900	16816.71	4
2010	43	4	4317558	3.597287e+07	2139	16817.61	4
2010	28	2	2800308	9.60394468e+09	570937	16821.37	4
2010	31	3	3110509	3.5458108e+08	21074	16825.52	4
2010	32	3	3201506	1.88247757e+09	111794	16838.81	4
2010	32	3	3201209	3.19890297e+09	189878	16847.15	4
2010	41	4	4102000	5.5687972e+08	33028	16860.84	4
2010	42	4	4203154	5.699122e+07	3380	16861.31	4
2010	42	4	4210407	1.0812398e+08	6409	16870.65	4
2010	41	4	4125803	1.7148291e+08	10164	16871.6	4
2010	35	3	3536000	1.8301769e+08	10844	16877.32	4
2010	31	3	3109808	4.23211e+07	2506	16887.91	4
2010	41	4	4115853	8.534344e+07	5046	16913.09	4
2010	31	3	3170438	7.483462e+07	4424	16915.6	5
2010	51	5	5108857	4.954189e+07	2925	16937.4	5
2010	41	4	4122008	2.3875839e+08	14093	16941.63	5
2010	43	4	4312427	4.659878e+07	2749	16951.17	5
2010	42	4	4212007	1.3163876e+08	7765	16952.83	5
2010	42	4	4211058	1.5800409e+08	9312	16967.79	5
2010	41	4	4110508	2.40239e+08	14153	16974.42	5
2010	42	4	4201273	7.120372e+07	4193	16981.57	5
2010	52	5	5204508	1.19747122e+09	70463	16994.33	5
2010	51	5	5100201	3.5455013e+08	20844	17009.7	5
2010	17	1	1703867	6.392672e+07	3754	17028.96	5
2010	41	4	4114906	1.5081185e+08	8855	17031.26	5
2010	31	3	3113206	3.9773635e+08	23341	17040.24	5
2010	42	4	4203303	2.0033809e+08	11748	17052.95	5
2010	35	3	3500303	5.4917496e+08	32168	17072.09	5
2010	24	2	2408003	4.43842412e+09	259886	17078.35	5
2010	50	5	5007109	3.581515e+08	20967	17081.68	5
2010	41	4	4108502	2.3362429e+08	13667	17094.04	5
2010	28	2	2807204	1.3688709e+08	8006	17098.06	5
2010	31	3	3137205	7.8665864e+08	45999	17101.65	5
2010	35	3	3526001	3.2033901e+08	18726	17106.64	5
2010	35	3	3513850	2.889346e+07	1689	17106.84	5
2010	42	4	4200804	1.0919567e+08	6378	17120.68	5
2010	43	4	4320008	2.24280759e+09	130988	17122.24	5
2010	42	4	4204806	6.4679702e+08	37774	17122.81	5
2010	15	1	1500503	5.768674e+08	33665	17135.52	5
2010	42	4	4214706	1.7618706e+08	10280	17138.82	5
2010	31	3	3170404	1.33006764e+09	77590	17142.26	5
2010	35	3	3556503	1.8374574e+09	107146	17149.1	5
2010	28	2	2802304	2.3770194e+08	13854	17157.64	5
2010	41	4	4104006	6.6511902e+08	38756	17161.7	5
2010	35	3	3500204	6.105915e+07	3557	17165.91	5
2010	43	4	4318499	3.778611e+07	2200	17175.5	5
2010	41	4	4107405	1.0481585e+08	6101	17180.11	5
2010	35	3	3542701	1.1317857e+08	6587	17182.11	5
2010	42	4	4202305	1.00111558e+09	58238	17190.07	5
2010	28	2	2802106	1.10818537e+09	64464	17190.76	5
2010	51	5	5103908	8.628239e+07	5018	17194.58	5
2010	28	2	2803203	5.2363461e+08	30428	17208.97	5
2010	43	4	4321808	4.0832382e+08	23726	17209.97	5
2010	42	4	4200309	8.435193e+07	4901	17211.17	5
2010	31	3	3109451	1.1108695e+08	6453	17214.78	5
2010	21	2	2101400	1.43880967e+09	83537	17223.62	5
2010	42	4	4216354	5.922545e+07	3438	17226.72	5
2010	17	1	1700707	1.4437189e+08	8380	17228.15	5
2010	43	4	4312955	3.378147e+07	1960	17235.44	5
2010	29	2	2921906	1.8188942e+08	10548	17243.97	5
2010	43	4	4304002	9.413916e+07	5459	17244.76	5
2010	31	3	3171006	3.4020702e+08	19721	17251	5
2010	35	3	3511300	1.374595e+08	7968	17251.44	5
2010	35	3	3545704	9.874104e+07	5723	17253.37	5
2010	41	4	4116703	2.049477e+08	11871	17264.57	5
2010	32	3	3203056	4.2690596e+08	24718	17271.06	5
2010	35	3	3532603	1.8530869e+08	10725	17278.2	5
2010	22	2	2210631	7.113252e+07	4116	17281.95	5
2010	35	3	3547502	4.5722085e+08	26420	17305.86	5
2010	43	4	4306452	5.679171e+07	3280	17314.54	5
2010	41	4	4104055	7.63305e+07	4407	17320.29	5
2010	52	5	5219209	5.442503e+07	3142	17321.78	5
2010	41	4	4105508	1.21257894e+09	69962	17331.97	5
2010	43	4	4319372	4.980985e+07	2873	17337.22	5
2010	42	4	4216255	1.047375e+08	6035	17355.01	5
2010	31	3	3159803	3.1514917e+08	18157	17356.9	5
2010	43	4	4306379	5.318181e+07	3064	17356.99	5
2010	24	2	2404408	1.631042e+08	9393	17364.44	5
2010	42	4	4201653	3.917869e+07	2256	17366.44	5
2010	35	3	3509809	7.890639e+07	4539	17384.09	5
2010	35	3	3534708	1.79104255e+09	103026	17384.37	5
2010	31	3	3134202	1.68914654e+09	97159	17385.38	5
2010	31	3	3119302	4.7905645e+08	27551	17387.99	5
2010	51	5	5101902	2.6571005e+08	15280	17389.4	5
2010	51	5	5104807	4.4647471e+08	25666	17395.57	5
2010	41	4	4116059	1.822133e+08	10474	17396.73	5
2010	42	4	4201802	5.745536e+07	3300	17410.72	5
2010	51	5	5107958	1.46426322e+09	84076	17415.95	5
2010	21	2	2109700	9.554047e+07	5484	17421.68	5
2010	31	3	3101607	1.28440245e+09	73722	17422.24	5
2010	29	2	2927002	6.4702926e+08	37127	17427.46	5
2010	50	5	5005707	8.0793606e+08	46355	17429.32	5
2010	42	4	4208302	7.9863831e+08	45814	17432.19	5
2010	35	3	3518602	6.1883132e+08	35491	17436.29	5
2010	50	5	5007505	8.585631e+07	4922	17443.38	5
2010	42	4	4217402	2.6742418e+08	15316	17460.45	5
2010	42	4	4207304	7.019694e+08	40200	17461.93	5
2010	42	4	4216701	2.3878071e+08	13672	17464.94	5
2010	43	4	4315958	4.448497e+07	2546	17472.49	5
2010	31	3	3104205	6.3961562e+08	36582	17484.44	5
2010	43	4	4322855	3.45262e+07	1974	17490.48	5
2010	51	5	5108501	1.7908547e+08	10235	17497.36	5
2010	42	4	4212403	7.190768e+07	4107	17508.57	5
2010	43	4	4317806	2.446385e+08	13970	17511.7	5
2010	51	5	5102702	3.2753498e+08	18701	17514.3	5
2010	35	3	3504008	1.66686668e+09	95156	17517.2	5
2010	35	3	3531209	1.2537452e+08	7148	17539.8	5
2010	50	5	5002159	1.4009595e+08	7986	17542.69	5
2010	35	3	3553302	3.9324499e+08	22410	17547.75	5
2010	43	4	4302584	3.863202e+07	2200	17560.01	5
2010	52	5	5215405	7.097111e+07	4040	17567.11	5
2010	41	4	4117701	5.6501676e+08	32125	17588.07	5
2010	41	4	4110052	3.931126e+07	2233	17604.69	5
2010	35	3	3512506	9.224581e+07	5238	17610.88	5
2010	31	3	3103801	4.884989e+07	2772	17622.61	5
2010	43	4	4304952	5.301149e+07	3007	17629.36	5
2010	35	3	3540606	8.6262692e+08	48914	17635.58	5
2010	41	4	4123501	4.1313203e+08	23425	17636.37	5
2010	35	3	3550902	2.5366167e+08	14350	17676.77	5
2010	43	4	4313102	1.1218106e+08	6345	17680.23	5
2010	31	3	3114550	1.6739283e+08	9467	17681.72	5
2010	33	3	3305802	2.89677768e+09	163805	17684.31	5
2010	42	4	4209300	2.77185629e+09	156737	17684.76	5
2010	42	4	4208104	3.5964036e+08	20315	17703.19	5
2010	42	4	4210050	3.233548e+07	1826	17708.37	5
2010	41	4	4112108	3.5927481e+08	20283	17713.1	5
2010	52	5	5216007	4.743061e+07	2676	17724.44	5
2010	43	4	4314175	3.931435e+07	2218	17725.13	5
2010	41	4	4101705	2.3832616e+08	13424	17753.74	5
2010	43	4	4319505	3.8976027e+08	21944	17761.59	5
2010	41	4	4113734	1.300203e+08	7317	17769.62	5
2010	41	4	4121604	1.2102207e+08	6810	17771.23	5
2010	43	4	4319711	3.853051e+07	2168	17772.37	5
2010	42	4	4200200	1.6580008e+08	9328	17774.45	5
2010	43	4	4307559	1.0686732e+08	6011	17778.63	5
2010	31	3	3110608	4.7126962e+08	26491	17789.8	5
2010	43	4	4307815	6.458683e+07	3628	17802.32	5
2010	35	3	3526704	1.63452323e+09	91804	17804.49	5
2010	35	3	3539202	4.4009153e+08	24718	17804.5	5
2010	50	5	5000906	1.4626812e+08	8215	17805.01	5
2010	42	4	4210035	9.975028e+07	5599	17815.73	5
2010	35	3	3544301	1.7114654e+08	9606	17816.63	5
2010	42	4	4219200	1.1212657e+08	6293	17817.66	5
2010	35	3	3537156	5.231769e+07	2936	17819.38	5
2010	35	3	3522307	2.57400651e+09	144416	17823.55	5
2010	52	5	5218508	7.7185284e+08	43243	17849.2	5
2010	33	3	3302452	9.408368e+07	5269	17856.08	5
2010	35	3	3535309	3.7961118e+08	21257	17858.17	5
2010	41	4	4126504	2.797985e+08	15637	17893.36	5
2010	52	5	5222302	9.206286e+07	5145	17893.66	5
2010	31	3	3154408	8.397127e+07	4686	17919.61	5
2010	31	3	3154804	1.6299552e+08	9095	17921.44	5
2010	51	5	5107248	7.305949e+07	4075	17928.71	5
2010	41	4	4115804	7.5025839e+08	41830	17935.89	5
2010	35	3	3557105	1.52049715e+09	84728	17945.63	5
2010	50	5	5003207	1.86375951e+09	103772	17960.14	5
2010	35	3	3515194	7.627809e+07	4246	17964.69	5
2010	43	4	4310603	6.8570983e+08	38166	17966.51	5
2010	17	1	1721000	4.10295229e+09	228297	17971.99	5
2010	43	4	4313003	5.724119e+07	3184	17977.76	5
2010	21	2	2111300	1.821148754e+10	1011943	17996.55	5
2010	35	3	3547908	1.1345458e+08	6304	17997.24	5
2010	42	4	4209854	8.356003e+07	4642	18000.87	5
2010	43	4	4308904	2.9101998e+08	16156	18013.12	5
2010	14	1	1400100	5.12325574e+09	284258	18023.26	5
2010	35	3	3536604	1.5480228e+08	8589	18023.32	5
2010	35	3	3515152	2.8362697e+08	15719	18043.58	5
2010	29	2	2902054	2.0875563e+08	11569	18044.4	5
2010	31	3	3162955	3.5740157e+08	19801	18049.67	5
2010	31	3	3118205	1.1783932e+08	6527	18054.13	5
2010	41	4	4106308	2.9460288e+08	16302	18071.58	5
2010	50	5	5003900	5.299885e+07	2927	18106.88	5
2010	43	4	4316600	2.7852149e+08	15373	18117.58	5
2010	35	3	3520103	5.0675579e+08	27960	18124.31	5
2010	27	2	2708105	1.9873022e+08	10961	18130.66	5
2010	43	4	4300851	6.699357e+07	3693	18140.69	5
2010	43	4	4310439	1.0915606e+08	6017	18141.28	5
2010	41	4	4127957	1.4515103e+08	7997	18150.68	5
2010	35	3	3530300	9.7718097e+08	53809	18160.18	5
2010	52	5	5222054	1.3389937e+08	7371	18165.7	5
2010	50	5	5007901	7.6448823e+08	42076	18169.22	5
2010	42	4	4216305	4.7764767e+08	26260	18189.17	5
2010	52	5	5214606	7.708764e+08	42380	18189.63	5
2010	35	3	3511003	3.2757688e+08	18006	18192.65	5
2010	35	3	3537107	7.5606088e+08	41549	18196.85	5
2010	35	3	3515004	4.37342147e+09	240007	18222.06	5
2010	52	5	5204003	1.3398027e+08	7346	18238.53	5
2010	41	4	4115903	4.244737e+07	2327	18241.24	5
2010	35	3	3511706	2.7534114e+08	15086	18251.43	5
2010	35	3	3544905	1.9288512e+08	10568	18251.81	5
2010	35	3	3511409	3.1999827e+08	17532	18252.24	5
2010	41	4	4103701	1.7668398e+09	96735	18264.74	5
2010	41	4	4107553	6.342614e+07	3472	18267.9	5
2010	29	2	2909307	5.7161261e+08	31259	18286.34	5
2010	42	4	4212239	7.468678e+07	4080	18305.58	5
2010	43	4	4300208	1.328231e+08	7255	18307.8	5
2010	31	3	3104106	1.7425623e+08	9509	18325.4	5
2010	41	4	4114005	2.5608783e+08	13968	18333.89	5
2010	52	5	5220264	6.897968e+07	3761	18340.78	5
2010	35	3	3555208	3.540458e+07	1927	18372.9	5
2010	43	4	4318622	6.04908e+07	3290	18386.26	5
2010	31	3	3111804	2.0897618e+08	11357	18400.65	5
2010	42	4	4219408	6.634225e+07	3601	18423.28	5
2010	43	4	4322103	1.0879256e+08	5901	18436.29	5
2010	42	4	4210803	1.2931321e+08	7002	18468.04	5
2010	35	3	3550605	1.45740071e+09	78873	18477.82	5
2010	42	4	4202537	4.669211e+07	2526	18484.6	5
2010	41	4	4122602	1.6649045e+08	9005	18488.67	5
2010	35	3	3546603	5.4113846e+08	29235	18509.95	5
2010	43	4	4309902	1.330815e+08	7175	18547.94	5
2010	52	5	5201454	4.513668e+07	2433	18551.86	5
2010	41	4	4101101	3.8272521e+08	20615	18565.38	5
2010	41	4	4122305	5.8070081e+08	31261	18575.89	5
2010	17	1	1712157	2.981743e+07	1605	18577.84	5
2010	41	4	4104808	5.31706309e+09	286172	18579.96	5
2010	42	4	4215695	2.722085e+07	1465	18580.79	5
2010	51	5	5101258	2.8628155e+08	15387	18605.42	5
2010	42	4	4203808	9.823571e+08	52775	18614.06	5
2010	43	4	4308656	6.023228e+07	3233	18630.46	5
2010	41	4	4117222	1.4211471e+08	7625	18638	5
2010	41	4	4120655	9.057183e+07	4856	18651.53	5
2010	52	5	5207352	6.963358e+07	3733	18653.52	5
2010	35	3	3557303	1.87415e+08	10044	18659.4	5
2010	43	4	4308102	2.3075616e+08	12359	18671.1	5
2010	43	4	4309407	4.2631461e+08	22810	18689.81	5
2010	43	4	4306924	2.861318e+07	1530	18701.43	5
2010	31	3	3137601	9.8277418e+08	52526	18710.24	5
2010	43	4	4313706	6.4262769e+08	34335	18716.4	5
2010	31	3	3147105	1.57711132e+09	84252	18718.98	5
2010	41	4	4112801	2.0095905e+08	10735	18719.99	5
2010	41	4	4118709	1.2949899e+08	6913	18732.68	5
2010	42	4	4211892	4.408777e+07	2353	18736.83	5
2010	35	3	3557006	2.04269117e+09	108872	18762.32	5
2010	43	4	4305871	4.613775e+07	2459	18762.81	5
2010	52	5	5203906	1.6995783e+08	9056	18767.43	5
2010	35	3	3531407	4.0911671e+08	21748	18811.69	5
2010	35	3	3546801	9.493795e+08	50464	18813.01	5
2010	35	3	3513405	1.45001325e+09	77070	18814.24	5
2010	35	3	3507902	4.0609279e+08	21580	18818.02	5
2010	43	4	4313037	8.791664e+07	4671	18821.8	5
2010	42	4	4211405	8.048133e+07	4275	18826.04	5
2010	42	4	4200556	4.564984e+07	2424	18832.44	5
2010	41	4	4124608	1.1966784e+08	6352	18839.4	5
2010	35	3	3556107	2.0789587e+08	11031	18846.51	5
2010	26	2	2603603	1.535633e+08	8147	18849.06	5
2010	41	4	4107207	6.8262729e+08	36198	18858.15	5
2010	43	4	4318481	7.723421e+07	4094	18865.22	5
2010	11	1	1101468	4.381205e+07	2322	18868.24	5
2010	35	3	3550100	7.2487909e+08	38390	18881.98	5
2010	43	4	4310900	6.857461e+07	3630	18891.08	5
2010	35	3	3525003	2.04905043e+09	108436	18896.4	5
2010	35	3	3500105	6.3909051e+08	33797	18909.68	5
2010	42	4	4210100	1.00151275e+09	52920	18925.03	5
2010	42	4	4204194	5.233197e+07	2764	18933.42	5
2010	50	5	5006200	8.6483843e+08	45599	18966.17	5
2010	51	5	5107305	3.2497186e+08	17128	18973.14	5
2010	43	4	4322533	2.1021065e+08	11077	18977.22	5
2010	11	1	1100304	1.4471873e+09	76187	18995.2	5
2010	35	3	3533205	5.837478e+07	3072	19002.21	5
2010	31	3	3133006	2.6637351e+08	14007	19017.17	5
2010	35	3	3551801	2.4745042e+08	13006	19025.87	5
2010	35	3	3521408	3.8153131e+08	20047	19031.84	5
2010	43	4	4305900	1.4748738e+08	7748	19035.54	5
2010	35	3	3539509	6.7289693e+08	35314	19054.68	5
2010	42	4	4216008	1.9606367e+08	10284	19064.92	5
2010	42	4	4207908	1.9926627e+08	10450	19068.54	5
2010	35	3	3517901	1.9031324e+08	9976	19077.11	5
2010	43	4	4317905	2.7450049e+08	14378	19091.7	5
2010	31	3	3119955	1.1135003e+08	5821	19129.02	5
2010	32	3	3205200	7.92890478e+09	414420	19132.53	5
2010	31	3	3136702	9.91251513e+09	517872	19140.86	5
2010	43	4	4303673	6.21585e+07	3247	19143.36	5
2010	50	5	5002704	1.508912002e+10	787204	19167.99	5
2010	31	3	3161700	1.1990852e+08	6252	19179.23	5
2010	43	4	4307500	2.9244021e+08	15240	19188.99	5
2010	41	4	4112959	1.466312e+08	7641	19190.05	5
2010	43	4	4321626	4.443112e+07	2314	19201	5
2010	50	5	5003702	3.76544218e+09	196068	19204.78	5
2010	35	3	3518206	5.8812371e+08	30600	19219.73	5
2010	35	3	3510104	5.128466e+07	2668	19222.14	5
2010	43	4	4304309	1.256804e+08	6535	19231.89	5
2010	50	5	5002001	2.1041791e+08	10938	19237.33	5
2010	43	4	4303806	1.0598731e+08	5509	19238.94	5
2010	42	4	4205456	4.3387427e+08	22548	19242.25	5
2010	35	3	3555703	3.080224e+07	1599	19263.44	5
2010	17	1	1716208	1.9926787e+08	10335	19280.88	5
2010	35	3	3506102	1.44695118e+09	75044	19281.37	5
2010	35	3	3545803	3.47548671e+09	180148	19292.4	5
2010	22	2	2204501	1.9810553e+08	10268	19293.49	5
2010	41	4	4121356	5.495152e+07	2847	19301.55	5
2010	41	4	4127403	3.2363759e+08	16763	19306.66	5
2010	42	4	4205506	6.6722692e+08	34555	19309.13	5
2010	17	1	1718451	4.568691e+07	2366	19309.77	5
2010	42	4	4216107	1.8338948e+08	9496	19312.29	5
2010	35	3	3534609	5.9748456e+08	30917	19325.44	5
2010	31	3	3149309	1.13493842e+09	58696	19335.87	5
2010	31	3	3133808	1.65741071e+09	85396	19408.53	5
2010	35	3	3525706	6.3611948e+08	32774	19409.27	5
2010	42	4	4207007	1.14274198e+09	58859	19414.91	5
2010	42	4	4204004	1.8568384e+08	9558	19427.06	5
2010	35	3	3525300	2.54801574e+09	131068	19440.41	5
2010	43	4	4301651	1.1163217e+08	5742	19441.34	5
2010	33	3	3300407	3.46017262e+09	177861	19454.36	5
2010	42	4	4208609	7.868998e+07	4041	19472.9	5
2010	42	4	4205191	3.995957e+07	2050	19492.47	5
2010	41	4	4104303	1.70232333e+09	87287	19502.6	5
2010	43	4	4313359	6.532446e+07	3347	19517.32	5
2010	42	4	4212304	1.3061621e+08	6692	19518.26	5
2010	43	4	4300802	2.5058472e+08	12837	19520.51	5
2010	43	4	4304705	1.15795901e+09	59301	19526.8	5
2010	50	5	5004403	1.5021759e+08	7686	19544.31	5
2010	43	4	4309258	3.126234e+07	1598	19563.42	5
2010	31	3	3103504	2.14778869e+09	109779	19564.66	5
2010	35	3	3542206	5.6299656e+08	28773	19566.84	5
2010	35	3	3554953	1.161294e+08	5935	19566.87	5
2010	24	2	2400703	2.4088545e+08	12306	19574.63	5
2010	42	4	4211900	2.68568864e+09	137199	19575.13	5
2010	29	2	2924009	2.12408306e+09	108419	19591.43	5
2010	26	2	2607752	4.6477975e+08	23723	19591.95	5
2010	35	3	3512704	7.60398e+07	3874	19628.24	5
2010	35	3	3500907	7.490159e+07	3814	19638.59	5
2010	43	4	4309506	1.5941111e+08	8115	19644.01	5
2010	35	3	3515186	8.2424814e+08	41919	19662.88	5
2010	52	5	5205000	1.7579541e+08	8939	19666.12	5
2010	51	5	5105002	2.0578561e+08	10461	19671.7	5
2010	41	4	4113908	2.5546565e+08	12973	19692.1	5
2010	29	2	2917359	1.7682949e+08	8976	19700.26	5
2010	33	3	3305505	1.46444629e+09	74221	19730.89	5
2010	35	3	3518859	1.377714e+08	6966	19777.69	5
2010	42	4	4202453	2.832362e+08	14312	19790.12	5
2010	43	4	4315800	2.0368967e+08	10287	19800.69	5
2010	43	4	4322509	1.2147649e+09	61345	19802.18	5
2010	42	4	4214003	2.9479344e+08	14886	19803.4	5
2010	35	3	3513108	6.277255e+08	31688	19809.57	5
2010	17	1	1703842	1.6123273e+08	8139	19809.89	5
2010	43	4	4301503	1.4059858e+08	7097	19810.99	5
2010	51	5	5107909	2.24064072e+09	113082	19814.3	5
2010	27	2	2704708	9.118865e+08	45994	19826.21	5
2010	42	4	4211850	4.504746e+07	2271	19835.96	5
2010	35	3	3519501	1.3341085e+08	6725	19838.04	5
2010	43	4	4321469	5.410472e+07	2724	19862.23	5
2010	42	4	4217808	3.4318154e+08	17265	19877.3	5
2010	43	4	4306767	6.825317e+08	34335	19878.6	5
2010	35	3	3505203	6.2839618e+08	31603	19884.07	5
2010	31	3	3138625	1.3700983e+08	6890	19885.32	5
2010	17	1	1713205	4.1191704e+08	20692	19907.07	5
2010	43	4	4313334	4.852228e+07	2437	19910.66	5
2010	35	3	3535002	2.2009974e+08	11052	19914.92	5
2010	43	4	4311304	5.4833125e+08	27529	19918.31	5
2010	24	2	2401206	2.5765967e+08	12931	19925.73	5
2010	35	3	3519105	1.995223e+08	10010	19932.3	5
2010	50	5	5001508	1.3152187e+08	6598	19933.6	5
2010	11	1	1100924	1.6571635e+08	8304	19956.21	5
2010	35	3	3532900	1.8575823e+08	9301	19971.86	5
2010	29	2	2919926	3.4739391e+08	17384	19983.54	5
2010	35	3	3540804	3.0916656e+08	15453	20006.9	5
2010	31	3	3169901	2.03056882e+09	101466	20012.31	5
2010	43	4	4315354	7.311785e+07	3653	20015.84	5
2010	42	4	4208500	4.4591626e+08	22255	20036.68	5
2010	17	1	1722107	2.3019188e+08	11484	20044.57	5
2010	31	3	3147006	1.70110534e+09	84687	20086.97	5
2010	42	4	4200606	1.1146192e+08	5546	20097.71	5
2010	43	4	4323358	4.327113e+07	2152	20107.4	5
2010	35	3	3506805	2.1842288e+08	10862	20108.9	5
2010	42	4	4204608	3.87077119e+09	192236	20135.52	5
2010	41	4	4127502	3.8955282e+08	19332	20150.67	5
2010	42	4	4209508	1.2103347e+08	6005	20155.45	5
2010	42	4	4210605	2.9580555e+08	14668	20166.73	5
2010	43	4	4303558	5.232668e+07	2591	20195.55	5
2010	31	3	3171105	7.005785e+07	3466	20212.88	5
2010	41	4	4120853	7.691322e+07	3804	20219.04	5
2010	31	3	3146503	1.6219614e+08	8015	20236.57	5
2010	35	3	3555604	1.9180082e+08	9475	20242.83	5
2010	31	3	3128709	1.00273556e+09	49491	20260.97	5
2010	42	4	4212106	3.2493095e+08	16021	20281.56	5
2010	43	4	4319000	4.0832928e+08	20105	20309.84	5
2010	43	4	4302501	1.3999591e+08	6887	20327.56	5
2010	35	3	3549409	9.4588732e+08	46524	20331.17	5
2010	42	4	4218707	1.98040385e+09	97281	20357.56	5
2010	43	4	4301800	1.0902388e+08	5355	20359.27	5
2010	35	3	3505906	1.15370659e+09	56481	20426.45	5
2010	41	4	4127700	2.4382457e+09	119353	20428.86	5
2010	31	3	3172103	1.0345527e+08	5063	20433.59	5
2010	31	3	3141108	6.7386845e+08	32973	20436.98	5
2010	43	4	4316956	1.2394346e+08	6053	20476.37	5
2010	52	5	5219712	9.08509e+07	4430	20508.1	5
2010	50	5	5002407	5.2908216e+08	25763	20536.51	5
2010	35	3	3548005	4.238579e+08	20635	20540.73	5
2010	42	4	4204509	2.8459074e+08	13852	20545.1	5
2010	29	2	2930774	4.5291819e+08	21988	20598.43	5
2010	43	4	4310207	1.62712538e+09	78920	20617.4	5
2010	43	4	4320503	1.2982457e+08	6294	20626.72	5
2010	41	4	4128708	1.3440241e+08	6509	20648.7	5
2010	35	3	3532157	5.594663e+07	2707	20667.39	5
2010	42	4	4216909	4.5091979e+08	21797	20687.24	5
2010	50	5	5007554	1.5006921e+08	7254	20687.79	5
2010	43	4	4322350	3.078431e+07	1487	20702.29	5
2010	42	4	4203907	4.3039592e+08	20771	20721	5
2010	51	5	5106182	1.1333123e+08	5469	20722.48	5
2010	31	3	3169307	1.50890537e+09	72796	20727.86	5
2010	41	4	4103222	6.84106e+07	3296	20755.64	5
2010	41	4	4122701	1.2660746e+08	6095	20772.35	5
2010	23	2	2305233	1.14648514e+09	55154	20786.98	5
2010	42	4	4203501	1.9481892e+08	9370	20791.77	5
2010	43	4	4318705	4.45533618e+09	214210	20798.92	5
2010	52	5	5218706	9.482998e+07	4556	20814.31	5
2010	41	4	4110003	8.317561e+07	3992	20835.57	5
2010	35	3	3525201	4.966296e+08	23827	20843.14	5
2010	35	3	3528700	1.0030756e+08	4812	20845.3	5
2010	52	5	5214002	2.7997208e+08	13403	20888.76	5
2010	31	3	3129509	4.8618837e+08	23265	20897.85	5
2010	43	4	4307609	8.901554e+08	42589	20901.06	5
2010	35	3	3534757	1.7572406e+08	8406	20904.6	5
2010	43	4	4311130	7.474561e+07	3575	20907.86	5
2010	43	4	4311205	4.0943339e+08	19579	20911.86	5
2010	35	3	3542404	3.8694904e+08	18496	20920.69	5
2010	43	4	4319901	1.57177447e+09	75020	20951.41	5
2010	41	4	4107538	8.218422e+07	3922	20954.67	5
2010	50	5	5001243	2.1502011e+08	10255	20967.34	5
2010	31	3	3152808	5.411734e+08	25805	20971.65	5
2010	42	4	4212205	3.7615395e+08	17931	20977.86	5
2010	35	3	3549102	1.75594084e+09	83661	20988.76	5
2010	51	5	5108907	1.3835871e+08	6590	20995.25	5
2010	35	3	3529005	4.55106874e+09	216684	21003.25	5
2010	41	4	4114609	9.8358899e+08	46799	21017.31	5
2010	33	3	3304300	1.16837661e+09	55586	21019.26	5
2010	31	3	3133105	2.9849205e+08	14183	21045.76	5
2010	41	4	4103008	9.618351e+07	4568	21055.94	5
2010	43	4	4314001	1.4352736e+08	6812	21069.78	5
2010	43	4	4313201	4.0198476e+08	19058	21092.7	5
2010	35	3	3525607	8.72832e+07	4138	21093.09	5
2010	43	4	4320107	4.4968356e+08	21312	21100.02	5
2010	33	3	3304128	2.7082579e+08	12831	21107.15	5
2010	43	4	4314100	3.90372156e+09	184869	21116.15	5
2010	42	4	4217303	1.9042097e+08	9016	21120.34	5
2010	43	4	4309803	9.949119e+07	4710	21123.4	5
2010	50	5	5007935	3.1424842e+08	14867	21137.31	5
2010	41	4	4125704	5.4443216e+08	25755	21138.89	5
2010	35	3	3556453	9.1094e+08	42946	21211.29	5
2010	43	4	4312138	5.240126e+07	2470	21215.09	5
2010	22	2	2211209	4.2763242e+08	20152	21220.35	5
2010	43	4	4314134	4.662061e+07	2196	21229.79	5
2010	35	3	3522703	8.5055984e+08	40064	21230.03	5
2010	43	4	4316733	3.513759e+07	1655	21231.17	5
2010	52	5	5204409	3.5573286e+08	16734	21258.09	5
2010	35	3	3541703	2.7272317e+08	12828	21259.99	5
2010	31	3	3117306	4.9018955e+08	23055	21261.75	5
2010	41	4	4122404	1.23099376e+09	57870	21271.71	5
2010	42	4	4217600	2.7647821e+08	12995	21275.74	5
2010	43	4	4311791	5.377475e+07	2527	21280.08	5
2010	41	4	4118907	2.1725663e+08	10208	21282.98	5
2010	11	1	1100205	9.09382382e+09	426558	21319.08	5
2010	41	4	4113700	1.082298321e+10	506645	21362.06	5
2010	43	4	4306809	4.3822636e+08	20514	21362.31	5
2010	50	5	5007976	7.51801e+07	3512	21406.63	5
2010	35	3	3554003	2.31517997e+09	107975	21441.81	5
2010	23	2	2307650	4.49979024e+09	209748	21453.32	5
2010	52	5	5215702	5.0059335e+08	23333	21454.31	5
2010	42	4	4201307	5.3259984e+08	24814	21463.68	5
2010	35	3	3520806	7.798846e+07	3630	21484.42	5
2010	41	4	4119905	6.69873346e+09	311697	21491.17	5
2010	43	4	4308508	6.2051316e+08	28848	21509.75	5
2010	33	3	3303807	8.0920311e+08	37575	21535.68	5
2010	35	3	3531308	1.00463366e+09	46647	21536.94	5
2010	24	2	2407203	6.2409467e+08	28974	21539.82	5
2010	35	3	3516101	6.093677e+07	2829	21540.04	5
2010	31	3	3151206	1.15126932e+09	53379	21567.83	5
2010	41	4	4112009	7.0364582e+08	32616	21573.64	5
2010	42	4	4215703	4.2786272e+08	19830	21576.54	5
2010	43	4	4315321	5.850483e+07	2710	21588.5	5
2010	42	4	4211256	6.246279e+07	2890	21613.42	5
2010	43	4	4305405	8.742235e+07	4044	21617.79	5
2010	35	3	3508207	8.768512e+07	4055	21623.95	5
2010	42	4	4218301	3.9228232e+08	18131	21636	5
2010	35	3	3542107	1.8677916e+08	8624	21658.07	5
2010	35	3	3511102	2.44410199e+09	112843	21659.31	5
2010	43	4	4317202	1.48646194e+09	68595	21670.12	5
2010	43	4	4302352	2.5559385e+08	11792	21675.19	5
2010	42	4	4203006	1.53445946e+09	70735	21693.07	5
2010	41	4	4106704	9.905349e+07	4563	21707.98	5
2010	26	2	2611606	3.336968057e+10	1536934	21711.85	5
2010	41	4	4118501	1.57392741e+09	72373	21747.44	5
2010	35	3	3546405	9.5698066e+08	43929	21784.71	5
2010	35	3	3539301	1.52860904e+09	70138	21794.31	5
2010	26	2	2605459	5.733096e+07	2629	21807.13	5
2010	35	3	3544400	5.958377e+07	2729	21833.55	5
2010	35	3	3523602	3.3911049e+08	15528	21838.65	5
2010	32	3	3203320	7.4605864e+08	34147	21848.44	5
2010	17	1	1715259	5.371449e+07	2457	21861.82	5
2010	35	3	3556305	4.9512032e+08	22617	21891.51	5
2010	42	4	4205803	3.2327644e+08	14762	21899.23	5
2010	52	5	5209101	7.1214352e+08	32481	21924.93	5
2010	35	3	3541406	4.56333513e+09	207625	21978.74	5
2010	43	4	4312351	3.390305e+07	1542	21986.41	5
2010	31	3	3132404	1.99381124e+09	90679	21987.57	5
2010	41	4	4103370	7.073998e+07	3209	22044.24	5
2010	42	4	4211207	3.5561307e+08	16126	22052.16	5
2010	42	4	4219002	4.4647963e+08	20222	22078.91	5
2010	43	4	4312757	7.014496e+07	3177	22078.99	5
2010	43	4	4323606	3.464615e+07	1569	22081.68	5
2010	43	4	4309001	3.7733549e+08	17085	22085.78	5
2010	50	5	5005103	8.88036e+07	4017	22106.94	5
2010	35	3	3526407	5.5834784e+08	25246	22116.29	5
2010	35	3	3507605	3.24551469e+09	146663	22129.06	5
2010	52	5	5213103	1.17343387e+09	52964	22155.31	5
2010	42	4	4212270	9.812634e+07	4429	22155.42	5
2010	50	5	5001003	4.9448103e+08	22305	22169.07	5
2010	32	3	3202207	3.7789126e+08	17028	22192.35	5
2010	42	4	4219606	9.194433e+07	4142	22198.05	5
2010	43	4	4305850	5.468322e+07	2457	22256.09	5
2010	17	1	1712702	4.939392e+07	2219	22259.54	5
2010	42	4	4205605	7.739322e+07	3475	22271.43	5
2010	43	4	4307054	6.879777e+07	3088	22279.07	5
2010	52	5	5208707	2.903801118e+10	1301892	22304.47	5
2010	35	3	3505500	2.50064829e+09	112102	22306.9	5
2010	43	4	4320909	4.2958811e+08	19252	22313.95	5
2010	15	1	1501303	2.22714961e+09	99800	22316.13	5
2010	31	3	3157708	2.5314539e+08	11343	22317.32	5
2010	43	4	4316477	5.957899e+07	2669	22322.59	5
2010	51	5	5105903	3.3527866e+08	15011	22335.53	5
2010	42	4	4211454	9.531413e+07	4267	22337.5	5
2010	35	3	3529401	9.32342432e+09	417281	22343.28	5
2010	29	2	2919207	3.65217771e+09	163414	22349.23	5
2010	35	3	3552809	5.47336006e+09	244719	22365.9	5
2010	42	4	4218004	6.929199e+08	30973	22371.74	5
2010	52	5	5202353	7.345352e+07	3278	22408.03	5
2010	35	3	3541653	7.257591e+07	3236	22427.66	5
2010	41	4	4107801	1.1341695e+08	5050	22458.8	5
2010	52	5	5201504	8.560741e+07	3811	22463.24	5
2010	42	4	4213351	7.42587e+07	3303	22482.2	5
2010	42	4	4204103	9.923959e+07	4406	22523.74	5
2010	42	4	4219705	5.7934887e+08	25697	22545.39	5
2010	43	4	4316436	6.471088e+07	2869	22555.2	5
2010	42	4	4204251	3.4233983e+08	15171	22565.41	5
2010	31	3	3149804	3.248575e+08	14391	22573.66	5
2010	43	4	4319125	7.232785e+07	3201	22595.39	5
2010	51	5	5101704	7.0356174e+08	31058	22653.16	5
2010	35	3	3510906	5.954601e+07	2627	22666.92	5
2010	42	4	4215406	9.755097e+07	4301	22681	5
2010	35	3	3536406	1.4388524e+08	6342	22687.68	5
2010	42	4	4207700	1.6388556e+08	7220	22698.83	5
2010	43	4	4306106	1.42649556e+09	62825	22705.86	5
2010	35	3	3540705	1.16879196e+09	51407	22736.05	5
2010	41	4	4126355	1.0387256e+08	4568	22739.18	5
2010	51	5	5103403	1.254177859e+10	551350	22747.4	5
2010	35	3	3502804	4.13200118e+09	181618	22751.06	5
2010	35	3	3532827	1.9388229e+08	8515	22769.5	5
2010	52	5	5206206	1.06033612e+09	46568	22769.63	5
2010	35	3	3545308	9.1458929e+08	40141	22784.42	5
2010	35	3	3510401	1.1071568e+09	48573	22793.67	5
2010	42	4	4218608	1.4952625e+08	6554	22814.5	5
2010	35	3	3549706	1.18511529e+09	51910	22830.19	5
2010	35	3	3539103	3.5914074e+08	15727	22835.93	5
2010	42	4	4212056	5.426029e+07	2376	22836.82	5
2010	42	4	4208401	3.5239258e+08	15430	22838.14	5
2010	35	3	3524303	1.6376905e+09	71667	22851.39	5
2010	35	3	3502002	9.818826e+07	4289	22893.04	5
2010	43	4	4318606	1.5834313e+08	6906	22928.34	5
2010	32	3	3202504	2.5585244e+08	11158	22929.96	5
2010	42	4	4210902	9.286877e+07	4047	22947.56	5
2010	51	5	5103601	1.8665621e+08	8131	22956.12	5
2010	42	4	4202701	1.025896e+08	4468	22960.97	5
2010	35	3	3505807	4.7028616e+08	20461	22984.51	5
2010	50	5	5001904	4.5572647e+08	19825	22987.46	5
2010	35	3	3508306	1.003912e+08	4365	22999.13	5
2010	42	4	4214300	6.33211e+07	2748	23042.61	5
2010	41	4	4101606	5.966087e+08	25856	23074.28	5
2010	35	3	3509007	1.99887639e+09	86623	23075.58	5
2010	41	4	4113601	1.0134817e+08	4392	23075.63	5
2010	35	3	3506359	1.0979803e+09	47572	23080.39	5
2010	43	4	4313375	5.243609e+08	22706	23093.49	5
2010	31	3	3136207	1.69701997e+09	73451	23104.11	5
2010	43	4	4313011	6.360368e+07	2751	23120.2	5
2010	43	4	4313409	5.53687961e+09	239051	23161.92	5
2010	32	3	3203205	3.27511529e+09	141254	23186	5
2010	31	3	3156403	8.356155e+07	3601	23205.09	5
2010	35	3	3504305	1.1539741e+08	4959	23270.3	5
2010	52	5	5208152	7.643935e+07	3275	23340.26	5
2010	52	5	5200175	1.1893416e+08	5095	23343.31	5
2010	41	4	4126405	1.3596572e+08	5817	23373.86	5
2010	35	3	3508108	3.6076551e+08	15418	23398.98	5
2010	31	3	3155504	2.7890786e+08	11898	23441.58	5
2010	50	5	5000203	3.3843409e+08	14429	23455.13	5
2010	42	4	4211504	2.8607449e+08	12179	23489.16	5
2010	42	4	4211306	1.42338331e+09	60588	23492.83	5
2010	42	4	4217550	7.742101e+07	3285	23568.04	5
2010	42	4	4219507	1.04149099e+09	44102	23615.5	5
2010	35	3	3547601	5.6381816e+08	23871	23619.38	5
2010	35	3	3528809	3.1517754e+08	13344	23619.42	5
2010	35	3	3500550	1.3225483e+08	5598	23625.37	5
2010	35	3	3507506	3.01275326e+09	127370	23653.55	5
2010	35	3	3546207	9.459133e+07	3998	23659.66	5
2010	33	3	3306008	1.8357637e+09	77503	23686.36	5
2010	35	3	3513702	7.3734211e+08	31053	23744.63	5
2010	43	4	4300034	1.0447556e+08	4394	23776.87	5
2010	43	4	4305306	2.2301252e+08	9377	23782.93	5
2010	31	3	3156908	5.6795364e+08	23880	23783.65	5
2010	35	3	3533908	1.18586607e+09	49792	23816.4	5
2010	35	3	3501202	9.297757e+07	3901	23834.29	5
2010	35	3	3506003	8.20765455e+09	344039	23856.76	5
2010	52	5	5211701	1.4709658e+08	6164	23863.82	5
2010	35	3	3535705	1.4099913e+08	5907	23869.84	5
2010	31	3	3135407	1.2882127e+08	5396	23873.47	5
2010	26	2	2602902	4.42298912e+09	185123	23892.16	5
2010	31	3	3152501	3.12304746e+09	130586	23915.64	5
2010	35	3	3549805	9.77085969e+09	408435	23922.68	5
2010	41	4	4115200	8.55496751e+09	357117	23955.64	5
2010	42	4	4218855	6.979104e+07	2910	23983.17	5
2010	43	4	4323770	6.70258e+07	2793	23997.78	5
2010	43	4	4322202	5.3517461e+08	22286	24013.94	5
2010	43	4	4320305	1.1842448e+08	4929	24026.07	5
2010	41	4	4125308	1.3246082e+08	5508	24048.81	5
2010	35	3	3529708	4.9201483e+08	20442	24068.82	5
2010	42	4	4201257	2.3141263e+08	9605	24092.93	5
2010	41	4	4109807	1.16194583e+09	48200	24106.76	5
2010	42	4	4204558	3.5710391e+08	14794	24138.43	5
2010	35	3	3530607	9.38990902e+09	387241	24248.23	5
2010	42	4	4216602	5.11525489e+09	210513	24299	5
2010	41	4	4105300	2.6822091e+08	11032	24312.99	5
2010	42	4	4204301	1.66996085e+09	68627	24333.88	5
2010	31	3	3150307	1.1465002e+08	4709	24347	5
2010	43	4	4323200	7.392781e+07	3036	24350.4	5
2010	35	3	3502200	5.4119369e+08	22211	24366.02	5
2010	41	4	4108304	6.24551284e+09	256081	24388.82	5
2010	41	4	4119301	7.3735602e+08	30233	24389.11	5
2010	52	5	5211503	2.26936163e+09	92942	24416.97	5
2010	43	4	4305603	8.679208e+07	3550	24448.47	5
2010	17	1	1708254	5.925217e+07	2423	24454.05	5
2010	51	5	5108006	2.5416305e+08	10390	24462.28	5
2010	33	3	3303906	7.24442472e+09	296044	24470.77	5
2010	35	3	3510153	1.0700403e+08	4369	24491.65	5
2010	41	4	4118600	1.3314552e+08	5430	24520.35	5
2010	31	3	3151800	3.74208055e+09	152496	24538.88	5
2010	35	3	3522901	2.9892754e+08	12181	24540.48	5
2010	43	4	4321006	2.5734011e+08	10452	24621.14	5
2010	43	4	4311155	2.0515904e+08	8329	24631.89	5
2010	42	4	4205902	1.42762541e+09	57958	24632.07	5
2010	43	4	4312153	9.530249e+07	3869	24632.33	5
2010	31	3	3170107	7.29971954e+09	296000	24661.21	5
2010	43	4	4314803	7.6165715e+08	30881	24664.26	5
2010	51	5	5107602	4.82613245e+09	195550	24679.79	5
2010	35	3	3532868	2.784076e+07	1127	24703.43	5
2010	42	4	4213005	7.781104e+07	3147	24725.46	5
2010	42	4	4217204	8.9806708e+08	36295	24743.55	5
2010	51	5	5107065	3.2221471e+08	13021	24745.77	5
2010	35	3	3557154	5.780197e+07	2334	24765.2	5
2010	43	4	4308458	1.1338299e+08	4577	24772.34	5
2010	43	4	4304903	2.1423505e+08	8648	24772.79	5
2010	31	3	3159605	9.3623352e+08	37784	24778.57	5
2010	52	5	5219258	1.1855814e+08	4768	24865.38	5
2010	41	4	4120002	3.5303249e+08	14183	24891.24	5
2010	31	3	3106200	5.920307409e+10	2375444	24922.95	5
2010	43	4	4307005	2.39741541e+09	96105	24945.79	5
2010	35	3	3552502	6.55527132e+09	262568	24965.99	5
2010	42	4	4211009	2.56172e+08	10231	25038.8	5
2010	43	4	4305355	8.8572039e+08	35363	25046.53	5
2010	42	4	4204202	4.60429679e+09	183561	25083.2	5
2010	31	3	3168705	2.03676611e+09	81119	25108.37	5
2010	35	3	3511904	1.7749346e+08	7064	25126.48	5
2010	43	4	4316501	1.6969529e+08	6747	25151.22	5
2010	41	4	4101507	2.62139344e+09	104161	25166.75	5
2010	33	3	3305406	4.4063566e+08	17504	25173.43	5
2010	42	4	4217758	6.965486e+07	2766	25182.52	5
2010	52	5	5218805	4.45048674e+09	176502	25214.94	5
2010	35	3	3529500	1.17038e+08	4640	25223.71	5
2010	42	4	4215752	6.757586e+07	2679	25224.29	5
2010	29	2	2915205	3.8395278e+08	15210	25243.44	5
2010	42	4	4215802	1.88916426e+09	74797	25257.22	5
2010	42	4	4202008	2.73540778e+09	108107	25302.78	5
2010	42	4	4214805	1.54868469e+09	61196	25306.96	5
2010	42	4	4208005	1.6265831e+08	6427	25308.59	5
2010	43	4	4311270	4.05275e+07	1598	25361.39	5
2010	42	4	4213153	6.754693e+07	2659	25403.13	5
2010	43	4	4312674	4.376943e+07	1721	25432.56	5
2010	35	3	3531902	7.4148648e+08	29127	25457.02	5
2010	33	3	3300225	2.9112092e+08	11421	25489.97	5
2010	52	5	5211909	2.24441253e+09	88048	25490.78	5
2010	33	3	3300951	2.0894425e+08	8183	25533.94	5
2010	43	4	4310801	5.0799699e+08	19877	25557.03	5
2010	43	4	4319158	1.8971642e+08	7421	25564.8	5
2010	43	4	4320404	3.641231e+08	14243	25565.06	5
2010	51	5	5106281	1.5456752e+08	6043	25577.94	5
2010	43	4	4321451	6.9740845e+08	27265	25578.89	5
2010	43	4	4305702	1.6768163e+08	6552	25592.43	5
2010	35	3	3526803	1.57399044e+09	61454	25612.5	5
2010	42	4	4218806	3.0408476e+08	11854	25652.5	5
2010	35	3	3500600	6.935157e+07	2703	25657.26	5
2010	35	3	3502101	1.42212583e+09	55317	25708.66	5
2010	41	4	4111902	3.1610941e+08	12256	25792.22	5
2010	41	4	4127106	1.8042869e+09	69878	25820.53	5
2010	33	3	3303302	1.258790064e+10	487327	25830.5	5
2010	31	3	3116902	7.678774e+07	2972	25837.06	5
2010	35	3	3505302	9.1110019e+08	35256	25842.42	5
2010	35	3	3544004	7.6412294e+08	29508	25895.45	5
2010	15	1	1505304	1.63554514e+09	62963	25976.29	5
2010	35	3	3522505	5.22015821e+09	200874	25987.23	5
2010	43	4	4307708	2.09648597e+09	80669	25988.74	5
2010	42	4	4207502	1.42528299e+09	54794	26011.66	5
2010	43	4	4315602	5.14312072e+09	197253	26073.73	5
2010	42	4	4200101	4.4616727e+08	17100	26091.65	5
2010	43	4	4322608	1.72210911e+09	65964	26106.8	5
2010	35	3	3518404	2.92768435e+09	112091	26118.82	5
2010	51	5	5100409	2.6963482e+08	10321	26124.87	5
2010	35	3	3529658	4.930404e+07	1886	26142.12	5
2010	43	4	4311718	1.2406993e+08	4742	26164.05	5
2010	35	3	3530706	3.59300357e+09	137286	26171.67	5
2010	43	4	4310009	5.0581082e+08	19312	26191.53	5
2010	35	3	3538006	3.85590632e+09	147034	26224.59	5
2010	35	3	3503208	5.47443746e+09	208725	26227.99	5
2010	43	4	4306429	5.65924e+07	2157	26236.62	5
2010	35	3	3536109	1.464775e+08	5582	26241.04	5
2010	31	3	3170701	3.23414535e+09	123120	26268.24	5
2010	35	3	3534302	1.04621663e+09	39781	26299.41	5
2010	41	4	4122909	1.3632818e+08	5178	26328.35	5
2010	43	4	4310462	5.118776e+07	1944	26331.15	5
2010	13	1	1301209	1.99879345e+09	75909	26331.44	5
2010	22	2	2200806	8.020648e+07	3046	26331.74	5
2010	42	4	4200507	1.6113958e+08	6109	26377.41	5
2010	29	2	2906501	2.19197782e+09	83077	26384.89	5
2010	41	4	4122206	8.0951778e+08	30662	26401.34	5
2010	15	1	1508100	2.56610514e+09	97109	26425	5
2010	51	5	5106232	4.6408251e+08	17529	26475.13	5
2010	28	2	2803609	7.123803e+08	26903	26479.59	5
2010	29	2	2908507	7.9823283e+08	30123	26499.11	5
2010	42	4	4217907	2.30221e+08	8674	26541.5	5
2010	51	5	5106372	4.1655351e+08	15693	26543.91	5
2010	35	3	3503901	1.98847733e+09	74818	26577.53	5
2010	51	5	5103452	2.258059e+08	8494	26584.17	5
2010	42	4	4211702	5.7047167e+08	21395	26663.78	5
2010	41	4	4121802	2.8519761e+08	10690	26678.92	5
2010	31	3	3130309	2.1426713e+08	8031	26680.01	5
2010	43	4	4317756	5.306128e+07	1987	26704.22	5
2010	42	4	4205407	1.127667973e+10	421203	26772.55	5
2010	43	4	4322806	6.1232458e+08	22815	26838.68	5
2010	50	5	5000252	1.2276576e+08	4570	26863.4	5
2010	43	4	4323408	1.1376854e+08	4221	26952.98	5
2010	41	4	4115358	1.5345606e+08	5691	26964.69	5
2010	43	4	4300059	1.0054786e+08	3726	26985.47	5
2010	43	4	4315313	4.798019e+07	1778	26985.49	5
2010	35	3	3512902	1.9476867e+08	7214	26998.71	5
2010	25	2	2503209	1.56437639e+09	57926	27006.46	5
2010	35	3	3503307	3.21162507e+09	118898	27011.6	5
2010	33	3	3301702	2.310767943e+10	855046	27025.07	5
2010	35	3	3548054	2.0625688e+08	7627	27042.99	5
2010	35	3	3514908	4.2735136e+08	15796	27054.4	5
2010	50	5	5000856	2.4849549e+08	9170	27098.74	5
2010	41	4	4110409	1.1651967e+08	4299	27103.9	5
2010	35	3	3528403	1.1719962e+09	43225	27113.85	5
2010	52	5	5204300	3.6044366e+08	13279	27143.89	5
2010	42	4	4211603	3.6166365e+08	13316	27160.08	5
2010	42	4	4218202	1.00034986e+09	36817	27170.87	5
2010	31	3	3167202	5.82062754e+09	214071	27190.17	5
2010	24	2	2401107	6.8802572e+08	25263	27234.52	5
2010	43	4	4323309	8.757424e+07	3207	27307.22	5
2010	51	5	5107156	7.059364e+07	2578	27383.1	5
2010	43	4	4301008	5.1507961e+08	18783	27422.65	5
2010	31	3	3104007	2.57318264e+09	93683	27466.91	5
2010	35	3	3529302	2.11072668e+09	76799	27483.78	5
2010	43	4	4308201	7.4672031e+08	27135	27518.71	5
2010	41	4	4124509	1.4515965e+08	5269	27549.75	5
2010	29	2	2930709	3.25403897e+09	118020	27571.93	5
2010	51	5	5107925	1.83449901e+09	66506	27583.96	5
2010	52	5	5210109	6.8380423e+08	24745	27634.04	5
2010	35	3	3526902	7.6299133e+09	276010	27643.61	5
2010	35	3	3517406	1.03445524e+09	37412	27650.36	5
2010	50	5	5003256	5.4485943e+08	19689	27673.29	5
2010	35	3	3513801	1.0699784e+10	386039	27716.85	5
2010	52	5	5220504	2.0736927e+08	7477	27734.29	5
2010	43	4	4312385	7.40765e+07	2670	27744.01	5
2010	13	1	1302603	5.016882118e+10	1802525	27832.52	5
2010	41	4	4117909	7.9883038e+08	28692	27841.57	5
2010	31	3	3150703	1.2989847e+08	4664	27851.3	5
2010	35	3	3543253	2.0671625e+08	7419	27863.09	5
2010	43	4	4307807	8.5416454e+08	30628	27888.36	5
2010	50	5	5006002	4.5868405e+08	16433	27912.37	5
2010	35	3	3532009	3.2894063e+08	11775	27935.51	5
2010	43	4	4309100	9.0401954e+08	32300	27988.22	5
2010	42	4	4219309	1.32193006e+09	47204	28004.62	5
2010	42	4	4217501	4.7475925e+08	16922	28055.74	5
2010	35	3	3522604	1.9242543e+09	68365	28146.78	5
2010	42	4	4206306	5.2038193e+08	18433	28230.99	5
2010	35	3	3536307	3.6739901e+08	13002	28257.12	5
2010	43	4	4301875	1.1351611e+08	4016	28265.96	5
2010	42	4	4210506	6.277032e+08	22104	28397.72	5
2010	29	2	2925204	9.3910174e+08	33064	28402.54	5
2010	50	5	5002308	3.3528121e+08	11804	28404.03	5
2010	50	5	5007695	6.2991799e+08	22164	28420.77	5
2010	31	3	3128600	1.8676355e+08	6569	28431.05	5
2010	29	2	2916302	2.9849616e+08	10497	28436.33	5
2010	35	3	3547809	1.916451029e+10	673914	28437.62	5
2010	51	5	5105234	1.5476654e+08	5438	28460.19	5
2010	43	4	4309209	7.29581259e+09	255762	28525.79	5
2010	42	4	4211751	4.6884193e+08	16348	28678.86	5
2010	51	5	5106240	2.6520421e+08	9245	28686.23	5
2010	26	2	2611002	9.3234538e+08	32485	28700.8	5
2010	41	4	4107108	1.5863898e+08	5524	28718.14	5
2010	43	4	4314779	1.1077822e+08	3857	28721.34	5
2010	43	4	4305207	3.8202785e+08	13289	28747.67	5
2010	42	4	4206504	1.01220964e+09	35186	28767.4	5
2010	31	3	3140803	3.8735334e+08	13435	28831.66	5
2010	31	3	3164605	1.6771202e+08	5805	28890.96	5
2010	29	2	2911105	6.5106914e+08	22534	28892.75	5
2010	43	4	4313904	1.10016118e+09	38068	28899.89	5
2010	41	4	4118204	4.06812785e+09	140450	28964.95	5
2010	31	3	3121258	2.3518715e+08	8107	29010.38	5
2010	35	3	3556909	2.0008145e+08	6889	29043.61	5
2010	43	4	4307906	1.85376624e+09	63641	29128.49	5
2010	35	3	3518800	3.567151022e+10	1222357	29182.56	5
2010	43	4	4303905	1.75404531e+09	60081	29194.68	5
2010	51	5	5107040	1.52229113e+09	52114	29210.79	5
2010	28	2	2803302	4.9388861e+08	16874	29269.21	5
2010	35	3	3504107	3.70972744e+09	126614	29299.5	5
2010	43	4	4300661	3.565721e+07	1216	29323.36	5
2010	43	4	4307401	9.301051e+07	3169	29350.11	5
2010	43	4	4308854	4.923296e+07	1677	29357.76	5
2010	35	3	3511508	1.16602531e+09	39649	29408.69	5
2010	35	3	3509254	8.3539146e+08	28371	29445.26	5
2010	43	4	4300471	6.075723e+07	2062	29465.19	5
2010	33	3	3305158	5.9702596e+08	20252	29479.85	5
2010	31	3	3151602	3.0687772e+08	10393	29527.35	5
2010	42	4	4200408	2.0561675e+08	6960	29542.64	5
2010	35	3	3531001	6.305557e+07	2134	29548.06	5
2010	42	4	4207577	8.116384e+07	2743	29589.44	5
2010	43	4	4311403	2.11884816e+09	71481	29642.12	5
2010	51	5	5102678	9.3712938e+08	31612	29644.74	5
2010	35	3	3512001	5.1627958e+08	17373	29717.35	5
2010	50	5	5005400	1.11371858e+09	37407	29773	5
2010	35	3	3532207	1.2784284e+08	4289	29807.14	5
2010	43	4	4316709	2.6323359e+08	8829	29814.65	5
2010	43	4	4314308	1.1871715e+08	3973	29880.98	5
2010	52	5	5213087	9.3091465e+08	31149	29885.86	5
2010	31	3	3111408	2.0550996e+08	6870	29914.11	5
2010	43	4	4302238	7.265373e+07	2425	29960.3	5
2010	42	4	4202578	6.402303e+07	2132	30029.56	5
2010	35	3	3523909	4.63375709e+09	154200	30050.31	5
2010	51	5	5105259	1.3715298e+09	45545	30113.73	5
2010	43	4	4321709	7.200605e+08	23855	30184.89	5
2010	35	3	3543402	1.828084444e+10	605114	30210.58	5
2010	43	4	4313508	1.23902458e+09	40941	30263.66	5
2010	35	3	3543907	5.63938358e+09	186299	30270.61	5
2010	43	4	4314902	4.272499184e+10	1409939	30302.72	5
2010	43	4	4313300	6.9196903e+08	22830	30309.64	5
2010	43	4	4311809	1.10337373e+09	36383	30326.63	5
2010	43	4	4311627	1.5870877e+08	5229	30351.65	5
2010	23	2	2304285	1.40407063e+09	46047	30492.12	5
2010	42	4	4205308	3.2504924e+08	10658	30498.15	5
2010	52	5	5207402	3.4362045e+08	11266	30500.66	5
2010	31	3	3155702	4.3257965e+08	14167	30534.32	5
2010	43	4	4309308	2.91055991e+09	95230	30563.48	5
2010	35	3	3548906	6.80556631e+09	221936	30664.54	5
2010	42	4	4210555	6.758319e+07	2203	30677.8	5
2010	42	4	4217006	3.372958e+08	10993	30682.78	5
2010	42	4	4207858	6.452802e+07	2096	30786.27	5
2010	41	4	4120903	9.4256622e+08	30585	30817.92	5
2010	31	3	3117603	1.5951109e+08	5162	30901.03	5
2010	43	4	4312401	1.84097408e+09	59436	30974.06	5
2010	43	4	4301958	7.341526e+07	2367	31016.16	5
2010	52	5	5205901	2.5354476e+08	8164	31056.44	5
2010	52	5	5216403	3.3757759e+08	10860	31084.49	5
2010	24	2	2404101	6.68587e+07	2150	31097.07	5
2010	35	3	3533403	1.59846342e+09	51278	31172.5	5
2010	42	4	4203956	6.7662699e+08	21689	31196.78	5
2010	42	4	4210001	3.2604817e+08	10449	31203.77	5
2010	35	3	3545209	3.29686813e+09	105569	31229.51	5
2010	50	5	5005251	2.0298089e+08	6493	31261.5	5
2010	31	3	3131307	7.52060384e+09	239177	31443.67	5
2010	42	4	4202859	1.0878927e+08	3457	31469.27	5
2010	42	4	4218509	1.9968448e+08	6342	31486.04	5
2010	29	2	2919553	1.89974472e+09	60179	31568.23	5
2010	31	3	3170206	1.89505775e+10	600285	31569.3	5
2010	35	3	3536703	1.31329501e+09	41530	31622.8	5
2010	35	3	3524402	6.68281858e+09	211308	31625.96	5
2010	43	4	4313060	5.8050779e+08	18346	31642.2	5
2010	43	4	4308078	1.1714402e+08	3697	31686.24	5
2010	42	4	4202909	3.34622526e+09	105495	31719.28	5
2010	31	3	3118601	1.914263636e+10	603048	31743.14	5
2010	32	3	3205002	1.304817608e+10	409324	31877.38	5
2010	35	3	3529609	1.2309186e+08	3851	31963.61	5
2010	35	3	3530805	2.76185785e+09	86244	32023.77	5
2010	42	4	4202404	9.90862131e+09	309214	32044.54	5
2010	43	4	4310108	1.02067717e+09	31663	32235.64	5
2010	35	3	3515202	2.6473727e+08	8208	32253.57	5
2010	35	3	3548500	1.354694287e+10	419757	32273.3	5
2010	31	3	3105400	9.2014327e+08	28432	32362.95	5
2010	35	3	3507001	1.5701334e+09	48323	32492.47	5
2010	52	5	5205307	3.0542155e+08	9394	32512.41	5
2010	35	3	3527108	2.32582519e+09	71493	32532.21	5
2010	35	3	3508504	2.76567995e+09	84844	32597.24	5
2010	43	4	4302105	3.50800719e+09	107341	32680.96	5
2010	41	4	4119152	3.83470061e+09	117166	32728.78	5
2010	52	5	5204805	1.9858519e+08	6057	32786.06	5
2010	43	4	4307831	9.191221e+07	2797	32861	5
2010	33	3	3304557	2.0815359465e+11	6323037	32919.88	5
2010	52	5	5201108	1.106052446e+10	335032	33013.34	5
2010	43	4	4308607	1.01387819e+09	30692	33033.96	5
2010	35	3	3534005	1.2901513e+08	3884	33217.08	5
2010	41	4	4103453	4.8339878e+08	14551	33221	5
2010	43	4	4304671	1.2926359e+08	3890	33229.71	5
2010	29	2	2910057	2.2061789e+09	66373	33239.1	5
2010	41	4	4106902	5.812278825e+10	1746896	33272.04	5
2010	35	3	3521101	2.0067043e+08	6016	33356.12	5
2010	41	4	4102307	3.7739293e+08	11294	33415.35	5
2010	42	4	4212908	5.4657897e+08	16335	33460.6	5
2010	35	3	3523404	3.39463037e+09	101450	33461.12	5
2010	35	3	3552205	1.972144076e+10	586311	33636.48	5
2010	35	3	3513009	6.79620303e+09	201023	33808.09	5
2010	35	3	3519055	3.8199294e+08	11292	33828.63	5
2010	35	3	3508405	1.41208925e+09	41643	33909.4	5
2010	50	5	5007208	1.03941324e+09	30647	33915.66	5
2010	35	3	3539608	1.5171272e+08	4472	33925.03	5
2010	35	3	3551702	3.74269727e+09	110094	33995.47	5
2010	43	4	4305975	9.615951e+07	2826	34026.72	5
2010	33	3	3304508	2.9175721e+08	8545	34143.62	5
2010	35	3	3552551	1.1573578e+08	3383	34210.99	5
2010	35	3	3538709	1.250166248e+10	364872	34263.15	5
2010	35	3	3501608	7.23608994e+09	210701	34342.93	5
2010	43	4	4306403	9.4705817e+08	27572	34348.55	5
2010	42	4	4209003	9.319636e+08	27005	34510.78	5
2010	31	3	3133758	5.1768501e+08	14950	34627.76	5
2010	29	2	2928901	9.5903535e+08	27692	34632.22	5
2010	41	4	4104659	6.6449273e+08	19171	34661.35	5
2010	31	3	3151107	3.5965771e+08	10366	34695.9	5
2010	31	3	3169356	9.834474e+08	28315	34732.38	5
2010	43	4	4312807	1.3915662e+08	4003	34763.08	5
2010	35	3	3554508	1.28386068e+09	36827	34861.94	5
2010	29	2	2922003	1.26466514e+09	36043	35087.68	5
2010	51	5	5106224	1.11245294e+09	31633	35167.48	5
2010	35	3	3509908	4.3018114e+08	12226	35185.76	5
2010	42	4	4213500	5.6792599e+08	16118	35235.51	5
2010	42	4	4213203	9.7988783e+08	27772	35283.3	5
2010	43	4	4316808	4.17662839e+09	118287	35309.28	5
2010	35	3	3509502	3.819502224e+10	1080999	35333.08	5
2010	42	4	4209201	7.767277e+07	2197	35354.01	5
2010	35	3	3540002	7.0668933e+08	19963	35399.96	5
2010	42	4	4209102	1.825254031e+10	515250	35424.63	5
2010	43	4	4302154	7.498903e+07	2114	35472.58	5
2010	52	5	5205455	2.6908115e+08	7548	35649.33	5
2010	42	4	4214201	3.6618516e+08	10251	35721.9	5
2010	51	5	5103502	7.2947112e+08	20420	35723.37	5
2010	43	4	4303103	4.2482393e+09	118294	35912.55	5
2010	35	3	3528858	9.478743e+07	2633	35999.78	5
2010	51	5	5100300	5.6569049e+08	15670	36100.22	5
2010	31	3	3129707	4.4032623e+08	12177	36160.48	5
2010	31	3	3156304	2.4851856e+08	6863	36211.36	5
2010	43	4	4310363	1.0975615e+08	3025	36283.02	5
2010	31	3	3136652	8.0663908e+08	22221	36300.76	5
2010	52	5	5213756	3.8521248e+08	10576	36423.27	5
2010	33	3	3301108	7.2281755e+08	19826	36458.06	5
2010	52	5	5218102	1.4121835e+08	3839	36785.19	5
2010	35	3	3556206	3.93779552e+09	106968	36812.84	5
2010	43	4	4316451	4.3844571e+08	11880	36906.2	5
2010	35	3	3539806	3.92273158e+09	106033	36995.38	5
2010	41	4	4119103	4.1523219e+08	11214	37028.02	5
2010	41	4	4120804	7.3294436e+08	19786	37043.58	5
2010	51	5	5102637	1.02635051e+09	27574	37221.68	5
2010	35	3	3507308	1.5900986e+08	4268	37256.29	5
2010	35	3	3512100	2.241706e+08	5994	37399.17	5
2010	33	3	3300100	6.33131797e+09	169270	37403.66	5
2010	33	3	3306305	9.6566165e+09	257996	37429.33	5
2010	35	3	3501905	2.46521606e+09	65836	37444.8	5
2010	51	5	5107792	1.4173496e+08	3757	37725.57	5
2010	31	3	3131703	4.13715546e+09	109551	37764.65	5
2010	43	4	4305108	1.647120125e+10	435482	37822.92	5
2010	35	3	3520509	7.65129181e+09	201848	37906.21	5
2010	42	4	4206652	1.7763936e+08	4675	37997.72	5
2010	35	3	3524907	2.0337985e+08	5350	38014.93	5
2010	43	4	4302220	9.382655e+07	2441	38437.75	5
2010	24	2	2410256	2.0060846e+08	5217	38452.84	5
2010	50	5	5008305	3.9170734e+09	101722	38507.63	5
2010	42	4	4208906	5.51580592e+09	143206	38516.58	5
2010	43	4	4316972	9.1181e+07	2352	38767.43	5
2010	42	4	4204707	4.114564e+08	10613	38769.09	5
2010	43	4	4312658	6.1849824e+08	15938	38806.52	5
2010	50	5	5002951	7.6755953e+08	19654	39053.6	5
2010	43	4	4312609	1.8745503e+08	4791	39126.49	5
2010	43	4	4304606	1.271801401e+10	324025	39250.1	5
2010	31	3	3109006	1.33518009e+09	34013	39254.99	5
2010	31	3	3100708	7.934957e+07	2020	39281.97	5
2010	35	3	3552403	9.48810151e+09	241437	39298.46	5
2010	35	3	3531803	1.92468534e+09	48971	39302.55	5
2010	35	3	3506201	1.0546799e+08	2674	39442.03	5
2010	41	4	4107256	2.9394291e+08	7446	39476.62	5
2010	35	3	3541604	1.41135171e+09	35688	39546.95	5
2010	42	4	4218350	1.3964608e+08	3527	39593.45	5
2010	31	3	3118007	1.92267368e+09	48550	39601.93	5
2010	33	3	3304003	1.0451342e+09	26309	39725.35	5
2010	42	4	4203600	1.3070332e+09	32829	39813.37	5
2010	35	3	3550308	4.5049198799e+11	11244369	40063.79	5
2010	43	4	4304804	1.01071657e+09	25193	40118.94	5
2010	42	4	4201208	3.0052272e+08	7455	40311.57	5
2010	17	1	1716604	4.2189177e+08	10389	40609.47	5
2010	28	2	2802007	1.7575742e+08	4326	40628.16	5
2010	51	5	5104526	2.0973769e+08	5123	40940.4	5
2010	28	2	2801504	5.5604429e+08	13500	41188.47	5
2010	35	3	3549904	2.584813044e+10	627544	41189.35	5
2010	31	3	3131901	1.8793388e+09	45484	41318.68	5
2010	52	5	5218052	1.3839548e+08	3347	41349.11	5
2010	35	3	3553955	5.3598003e+08	12883	41603.67	5
2010	35	3	3546702	9.0167166e+08	21644	41659.2	5
2010	41	4	4114401	7.1054833e+08	17041	41696.4	5
2010	43	4	4304655	1.2968537e+08	3107	41739.74	5
2010	35	3	3537008	6.6016215e+08	15699	42051.22	5
2010	35	3	3547304	4.60321873e+09	108875	42279.85	5
2010	43	4	4309050	2.9173003e+08	6885	42371.83	5
2010	35	3	3540309	1.0693515e+08	2523	42384.12	5
2010	52	5	5215504	2.3150524e+08	5446	42509.23	5
2010	33	3	3302007	4.64983079e+09	109163	42595.3	5
2010	35	3	3533601	2.9174618e+08	6817	42796.86	5
2010	35	3	3518305	1.11140491e+09	25861	42976.1	5
2010	32	3	3202801	1.34540606e+09	30988	43417	5
2010	35	3	3524501	2.463623e+08	5657	43549.99	5
2010	35	3	3534203	2.4922867e+08	5678	43893.74	5
2010	31	3	3134400	1.52902805e+09	34440	44396.87	5
2010	35	3	3544251	8.7686092e+08	19691	44531.05	5
2010	35	3	3554102	1.244970143e+10	278724	44666.77	5
2010	33	3	3300936	6.0402655e+08	13348	45252.21	5
2010	35	3	3519071	8.76344571e+09	192225	45589.52	5
2010	51	5	5107875	8.2796304e+08	18080	45794.42	5
2010	43	4	4314423	2.389613e+08	5182	46113.72	5
2010	52	5	5218789	1.5359156e+08	3311	46388.27	5
2010	43	4	4322251	1.8364775e+08	3919	46860.87	5
2010	41	4	4104600	7.0761537e+08	14936	47376.5	5
2010	42	4	4219176	2.2743417e+08	4795	47431.53	5
2010	42	4	4219101	1.6804269e+08	3535	47536.83	5
2010	51	5	5104609	5.4910869e+08	11493	47777.66	5
2010	43	4	4304622	8.41054e+07	1753	47977.98	5
2010	31	3	3145000	6.1792179e+08	12823	48188.55	5
2010	33	3	3304201	5.77784741e+09	119801	48228.71	5
2010	51	5	5100607	3.9261101e+08	8100	48470.5	5
2010	43	4	4312906	4.2920963e+08	8840	48553.13	5
2010	43	4	4309605	8.9286101e+08	18350	48657.28	5
2010	33	3	3302601	1.77236704e+09	36311	48810.75	5
2010	35	3	3555356	2.6115188e+08	5286	49404.44	5
2010	42	4	4216206	2.10772996e+09	42569	49513.26	5
2010	33	3	3300704	9.30107944e+09	186222	49946.19	5
2010	42	4	4204350	1.8934581e+08	3787	49998.89	5
2010	35	3	3500709	1.73627058e+09	34532	50280.05	5
2010	31	3	3130705	3.134969e+08	6181	50719.45	5
2010	29	2	2905701	1.24460268e+10	242984	51221.59	5
2010	31	3	3130408	3.0036821e+08	5863	51231.15	5
2010	35	3	3503703	4.3915548e+08	8547	51381.24	5
2010	35	3	3507753	1.3222089e+08	2573	51387.83	5
2010	35	3	3524006	2.30403569e+09	44825	51400.68	5
2010	35	3	3550704	3.82014771e+09	73833	51740.38	5
2010	33	3	3302254	1.49506259e+09	28852	51818.33	5
2010	32	3	3200607	4.24623693e+09	81746	51944.28	5
2010	31	3	3106309	1.22391003e+09	23397	52310.55	5
2010	21	2	2112001	4.1113013e+08	7796	52736.04	5
2010	31	3	3146107	3.71384216e+09	70227	52883.39	5
2010	42	4	4208203	1.006038068e+10	183388	54858.45	5
2010	35	3	3548708	4.255743174e+10	765203	55615.87	5
2010	53	5	5300108	1.441741016e+11	2562963	56252.9	5
2010	24	2	2404507	7.0190846e+08	12431	56464.36	5
2010	52	5	5206909	1.1632051e+08	2050	56741.71	5
2010	31	3	3127008	8.0850459e+08	14047	57557.1	5
2010	52	5	5205109	5.01878476e+09	86597	57955.64	5
2010	31	3	3145901	2.04766834e+09	35260	58073.41	5
2010	35	3	3512407	1.2272079e+09	21085	58202.89	5
2010	33	3	3301306	2.07165989e+09	35373	58566.13	5
2010	52	5	5204250	4.8916872e+08	8267	59171.25	5
2010	52	5	5221551	2.6472975e+08	4399	60179.53	5
2010	51	5	5102686	3.0220314e+08	5019	60211.82	5
2010	31	3	3124807	4.520503e+08	7457	60620.93	5
2010	31	3	3168101	2.4969817e+08	4102	60872.3	5
2010	31	3	3115359	2.9763094e+08	4839	61506.7	5
2010	35	3	3502754	1.05680123e+09	17085	61855.5	5
2010	31	3	3106705	2.338491344e+10	377547	61939.08	5
2010	35	3	3525904	2.315549548e+10	370251	62539.99	5
2010	35	3	3545506	2.3872582e+08	3699	64537.93	5
2010	32	3	3205309	2.118394021e+10	325453	65090.63	5
2010	35	3	3534401	4.349978523e+10	666469	65269.03	5
2010	41	4	4125506	1.723800781e+10	263488	65422.36	5
2010	33	3	3302403	1.361337324e+10	206748	65845.25	5
2010	31	3	3125101	1.88476351e+09	28564	65983.88	5
2010	31	3	3126307	2.7161572e+08	4098	66280.07	5
2010	31	3	3144805	5.3825638e+09	81162	66318.77	5
2010	28	2	2806107	6.168072e+08	9222	66884.32	5
2010	26	2	2607208	5.40448637e+09	80542	67101.47	5
2010	33	3	3300233	1.86929715e+09	27538	67880.64	5
2010	31	3	3140001	3.69016056e+09	54179	68110.53	5
2010	35	3	3527603	7.752231e+08	11286	68688.92	5
2010	35	3	3541802	1.9342102e+08	2808	68882.13	5
2010	28	2	2801207	1.70983119e+09	24693	69243.56	5
2010	51	5	5107768	1.7078842e+08	2466	69257.27	5
2010	35	3	3556701	4.6237679e+09	63685	72603.72	5
2010	43	4	4304358	6.5954717e+08	8776	75153.51	5
2010	35	3	3507209	6.052465e+07	805	75185.9	5
2010	41	4	4101804	8.99387171e+09	119207	75447.51	5
2010	43	4	4314472	3.3862697e+08	4471	75738.53	5
2010	43	4	4312617	2.2790778e+08	2977	76556.19	5
2010	52	5	5220405	1.31451281e+09	17086	76935.08	5
2010	35	3	3551306	2.355562e+08	3031	77715.67	5
2010	15	1	1502152	2.12009197e+09	26727	79323.98	5
2010	35	3	3513504	9.4660005e+09	118797	79682.15	5
2010	35	3	3548807	1.220513381e+10	149571	81600.94	5
2010	33	3	3301009	3.868438887e+10	463545	83453.36	5
2010	33	3	3304524	8.95787741e+09	105757	84702.45	5
2010	35	3	3509205	5.46080241e+09	64113	85174.65	5
2010	29	2	2905404	1.39735581e+09	15366	90938.16	5
2010	35	3	3524709	4.10491259e+09	44331	92596.89	5
2010	35	3	3501152	1.56653504e+09	16845	92997.03	5
2010	31	3	3162948	6.3537081e+08	6778	93740.16	5
2010	52	5	5216452	2.8266111e+08	2950	95817.33	5
2010	15	1	1505536	1.498516989e+10	153942	97342.96	5
2010	31	3	3117876	5.8114485e+08	5943	97786.45	5
2010	31	3	3133709	9.7568409e+08	9938	98177.11	5
2010	43	4	4306957	3.0815672e+08	3080	100050.88	5
2010	42	4	4213104	5.2893303e+08	4786	110516.72	5
2010	35	3	3505708	3.00187045e+10	240656	124736.99	5
2010	52	5	5205471	9.3292519e+08	7004	133198.91	5
2010	43	4	4314464	3.1950443e+08	2130	150002.08	5
2010	31	3	3103751	9.9613092e+08	6233	159815.65	5
2010	29	2	2929206	5.32391379e+09	33172	160494.21	5
2010	35	3	3527306	6.02735563e+09	37153	162230.66	5
2010	52	5	5200555	7.4210826e+08	4505	164729.91	5
2010	43	4	4300901	1.09118218e+09	6568	166136.14	5
2010	35	3	3536505	1.414134927e+10	82150	172140.59	5
2010	32	3	3200409	4.43488365e+09	23894	185606.58	5
2010	33	3	3305000	6.09972876e+09	32767	186154.63	5
2010	33	3	3304151	3.79112234e+09	20244	187271.41	5
2010	41	4	4126272	9.9220135e+08	5007	198162.84	5
2010	31	3	3161908	1.95164232e+09	9782	199513.63	5
2010	43	4	4322004	5.67054087e+09	25811	219694.74	5
2010	50	5	5007802	1.47124228e+09	6277	234386.22	5
2010	32	3	3204302	3.08202694e+09	10315	298790.78	5
2010	33	3	3304110	5.17474599e+09	16574	312220.71	5
2011	21	2	2110278	3.641135e+07	14143	2574.51	1
2011	21	2	2110906	3.326423e+07	11908	2793.44	1
2011	21	2	2111722	3.437839e+07	12301	2794.76	1
2011	29	2	2923050	4.315506e+07	15059	2865.73	1
2011	21	2	2107209	3.702728e+07	12785	2896.15	1
2011	21	2	2112100	8.442729e+07	28120	3002.39	1
2011	21	2	2111789	3.345495e+07	11080	3019.4	1
2011	21	2	2110237	3.620433e+07	11937	3032.95	1
2011	21	2	2108405	4.285101e+07	13844	3095.28	1
2011	21	2	2105104	7.892537e+07	25426	3104.12	1
2011	21	2	2101301	5.236045e+07	16687	3137.8	1
2011	21	2	2105005	8.357169e+07	26567	3145.7	1
2011	29	2	2905156	4.344099e+07	13727	3164.64	1
2011	21	2	2103125	2.540403e+07	8006	3173.12	1
2011	21	2	2109403	4.499842e+07	14158	3178.3	1
2011	21	2	2100832	4.860848e+07	15256	3186.19	1
2011	21	2	2102408	3.407296e+07	10668	3193.94	1
2011	21	2	2106607	1.0030077e+08	31307	3203.78	1
2011	21	2	2100402	3.62168e+07	11225	3226.44	1
2011	21	2	2108306	1.1297944e+08	34717	3254.3	1
2011	21	2	2111003	6.520027e+07	19997	3260.5	1
2011	21	2	2111078	5.694337e+07	17423	3268.29	1
2011	21	2	2106631	4.676247e+07	14283	3273.99	1
2011	21	2	2108256	7.58509e+07	23099	3283.73	1
2011	22	2	2206050	2.073982e+07	6240	3323.69	1
2011	22	2	2203453	3.08719e+07	9271	3329.94	1
2011	22	2	2203255	1.407382e+07	4225	3331.08	1
2011	22	2	2202174	2.30216e+07	6885	3343.73	1
2011	21	2	2101905	6.94557e+07	20725	3351.3	1
2011	21	2	2106201	2.20229e+07	6571	3351.53	1
2011	13	1	1301803	7.680824e+07	22867	3358.91	1
2011	29	2	2920452	4.276978e+07	12707	3365.84	1
2011	15	1	1504505	8.458496e+07	25096	3370.46	1
2011	21	2	2109304	3.655005e+07	10843	3370.84	1
2011	22	2	2201945	2.105212e+07	6242	3372.66	1
2011	21	2	2110500	1.3975846e+08	41421	3374.1	1
2011	21	2	2101103	3.882375e+07	11505	3374.51	1
2011	21	2	2102358	5.01767e+07	14858	3377.08	1
2011	29	2	2919108	3.193103e+07	9413	3392.23	1
2011	21	2	2108058	5.00348e+07	14749	3392.42	1
2011	22	2	2201770	2.166958e+07	6383	3394.89	1
2011	22	2	2209971	2.544844e+07	7459	3411.78	1
2011	27	2	2709202	8.831769e+07	25880	3412.58	1
2011	21	2	2106805	4.884247e+07	14312	3412.69	1
2011	21	2	2101772	4.164953e+07	12194	3415.58	1
2011	21	2	2103109	3.534156e+07	10336	3419.27	1
2011	29	2	2924702	4.276473e+07	12506	3419.54	1
2011	29	2	2903953	3.445708e+07	10054	3427.2	1
2011	15	1	1501956	9.380371e+07	27332	3432.01	1
2011	22	2	2203750	1.752733e+07	5104	3434.04	1
2011	21	2	2102309	7.916199e+07	23011	3440.18	1
2011	21	2	2102606	6.553018e+07	19046	3440.63	1
2011	23	2	2303600	6.556228e+07	18991	3452.28	1
2011	29	2	2901502	3.570583e+07	10336	3454.51	1
2011	29	2	2925907	9.461106e+07	27294	3466.37	1
2011	21	2	2106375	4.895674e+07	14118	3467.68	1
2011	29	2	2913804	5.27472e+07	15176	3475.7	1
2011	29	2	2900504	3.760102e+07	10802	3480.93	1
2011	29	2	2921450	3.574527e+07	10265	3482.25	1
2011	23	2	2313559	5.098846e+07	14632	3484.72	1
2011	21	2	2112704	1.7613459e+08	50541	3484.98	1
2011	21	2	2106904	1.1218863e+08	32157	3488.78	1
2011	29	2	2918753	4.911279e+07	14063	3492.34	1
2011	22	2	2208502	4.191778e+07	11999	3493.44	1
2011	22	2	2206100	3.685621e+07	10531	3499.78	1
2011	22	2	2202406	3.860457e+07	11024	3501.87	1
2011	21	2	2102374	2.989381e+07	8528	3505.37	1
2011	22	2	2202059	3.521725e+07	10038	3508.39	1
2011	21	2	2100105	2.108095e+07	6000	3513.49	1
2011	27	2	2708956	4.615656e+07	13129	3515.62	1
2011	29	2	2932457	6.054628e+07	17220	3516.04	1
2011	21	2	2102507	6.49556e+07	18473	3516.25	1
2011	21	2	2100154	4.138016e+07	11726	3528.92	1
2011	22	2	2207793	1.344286e+07	3809	3529.24	1
2011	21	2	2102077	5.322596e+07	15071	3531.68	1
2011	21	2	2103901	3.798034e+07	10744	3535.03	1
2011	22	2	2201960	2.834218e+07	8013	3537.02	1
2011	22	2	2205854	2.793853e+07	7897	3537.87	1
2011	29	2	2925709	4.779018e+07	13484	3544.21	1
2011	21	2	2107456	4.769782e+07	13416	3555.29	1
2011	21	2	2105476	5.543931e+07	15589	3556.31	1
2011	22	2	2202026	2.856465e+07	8027	3558.57	1
2011	29	2	2910008	4.487956e+07	12609	3559.33	1
2011	22	2	2205409	4.938887e+07	13874	3559.82	1
2011	21	2	2110401	6.376351e+07	17904	3561.41	1
2011	22	2	2201051	2.690351e+07	7547	3564.8	1
2011	22	2	2206357	2.413417e+07	6759	3570.67	1
2011	21	2	2111953	1.941713e+07	5437	3571.29	1
2011	22	2	2205573	2.311274e+07	6471	3571.74	1
2011	23	2	2307908	3.701145e+07	10338	3580.14	1
2011	21	2	2107100	6.465191e+07	18028	3586.19	1
2011	29	2	2911303	3.822647e+07	10657	3586.98	1
2011	21	2	2100873	4.128381e+07	11508	3587.4	1
2011	29	2	2925931	3.422806e+07	9534	3590.1	1
2011	22	2	2209658	2.022654e+07	5628	3593.91	1
2011	15	1	1501105	8.867192e+07	24644	3598.11	1
2011	29	2	2906402	3.173473e+07	8806	3603.76	1
2011	29	2	2907558	3.184007e+07	8830	3605.9	1
2011	21	2	2107803	1.2549735e+08	34791	3607.18	1
2011	23	2	2311009	4.339938e+07	12022	3610	1
2011	29	2	2901809	4.021476e+07	11124	3615.14	1
2011	21	2	2104081	3.407816e+07	9415	3619.56	1
2011	21	2	2106300	6.495885e+07	17938	3621.3	1
2011	21	2	2109809	1.4393574e+08	39744	3621.57	1
2011	22	2	2200301	4.986717e+07	13735	3630.66	1
2011	29	2	2912509	5.171766e+07	14229	3634.67	1
2011	21	2	2103158	4.229088e+07	11632	3635.74	1
2011	21	2	2104909	4.379898e+07	12039	3638.09	1
2011	29	2	2901601	6.310099e+07	17303	3646.82	1
2011	23	2	2313351	6.237614e+07	17081	3651.79	1
2011	29	2	2904753	7.204967e+07	19729	3651.97	1
2011	21	2	2112506	1.9633646e+08	53724	3654.54	1
2011	21	2	2104503	3.762333e+07	10290	3656.3	1
2011	27	2	2707206	5.099578e+07	13922	3662.96	1
2011	22	2	2203271	1.808811e+07	4931	3668.24	1
2011	21	2	2111904	3.833601e+07	10450	3668.52	1
2011	29	2	2921054	4.126223e+07	11246	3669.06	1
2011	15	1	1503507	1.154418e+08	31429	3673.1	1
2011	29	2	2922805	2.756911e+07	7500	3675.88	1
2011	22	2	2202703	9.913016e+07	26923	3681.99	1
2011	29	2	2904100	8.114604e+07	22031	3683.27	1
2011	22	2	2205458	1.899993e+07	5158	3683.58	1
2011	22	2	2201606	3.662276e+07	9927	3689.21	1
2011	21	2	2100204	7.965927e+07	21564	3694.09	1
2011	21	2	2100600	1.420568e+08	38451	3694.49	1
2011	22	2	2205557	2.993486e+07	8097	3697.03	1
2011	21	2	2104701	2.273127e+07	6145	3699.15	1
2011	21	2	2104602	5.954999e+07	16096	3699.68	1
2011	22	2	2206696	3.180971e+07	8591	3702.68	1
2011	21	2	2108801	6.509837e+07	17555	3708.25	1
2011	22	2	2201101	4.142717e+07	11164	3710.78	1
2011	21	2	2105922	4.061362e+07	10922	3718.51	1
2011	21	2	2105807	4.02004e+07	10798	3722.95	1
2011	21	2	2111748	3.867263e+07	10386	3723.53	1
2011	31	3	3126505	3.814826e+07	10244	3723.96	1
2011	31	3	3162450	4.405473e+07	11829	3724.3	1
2011	21	2	2111706	7.841544e+07	21052	3724.85	1
2011	21	2	2102705	7.698791e+07	20667	3725.16	1
2011	27	2	2703809	8.467973e+07	22717	3727.59	1
2011	21	2	2106508	8.235983e+07	22089	3728.55	1
2011	22	2	2206209	1.2127329e+08	32477	3734.13	1
2011	22	2	2210656	3.612802e+07	9663	3738.8	1
2011	21	2	2104404	6.554072e+07	17514	3742.19	1
2011	21	2	2107605	7.07733e+07	18896	3745.41	1
2011	29	2	2900207	6.515779e+07	17380	3749.01	1
2011	29	2	2924405	1.2381062e+08	33021	3749.45	1
2011	15	1	1502806	1.0950343e+08	29204	3749.6	1
2011	29	2	2922656	4.655644e+07	12415	3750.02	1
2011	29	2	2901205	9.402066e+07	25049	3753.47	1
2011	21	2	2100303	9.14339e+07	24346	3755.6	1
2011	22	2	2206753	1.731485e+07	4610	3755.93	1
2011	22	2	2211357	1.838602e+07	4894	3756.85	1
2011	21	2	2100477	1.1727815e+08	31125	3767.97	1
2011	21	2	2110104	1.1101765e+08	29460	3768.42	1
2011	22	2	2201929	2.047434e+07	5433	3768.51	1
2011	29	2	2915353	5.040503e+07	13350	3775.66	1
2011	22	2	2206704	2.757022e+07	7284	3785.04	1
2011	27	2	2706604	2.810485e+07	7419	3788.23	1
2011	21	2	2100550	2.467998e+07	6508	3792.25	1
2011	22	2	2203354	2.549788e+07	6722	3793.2	1
2011	29	2	2922854	3.05521e+07	8044	3798.12	1
2011	31	3	3108255	3.728392e+07	9812	3799.83	1
2011	22	2	2208874	1.631506e+07	4293	3800.39	1
2011	21	2	2103703	1.2385038e+08	32568	3802.82	1
2011	27	2	2702553	6.593672e+07	17332	3804.33	1
2011	15	1	1503002	3.05829e+07	8035	3806.21	1
2011	29	2	2919801	1.8080923e+08	47490	3807.31	1
2011	27	2	2701803	3.206989e+07	8421	3808.32	1
2011	22	2	2206670	2.489672e+07	6537	3808.59	1
2011	29	2	2928307	3.354162e+07	8806	3808.95	1
2011	15	1	1506104	3.931688e+07	10311	3813.1	1
2011	27	2	2703304	6.829805e+07	17908	3813.83	1
2011	22	2	2203305	5.08941e+07	13339	3815.44	1
2011	29	2	2921500	1.9925702e+08	52178	3818.79	1
2011	21	2	2101806	2.097835e+07	5483	3826.07	1
2011	31	3	3116100	5.814976e+07	15187	3828.92	1
2011	22	2	2209955	1.789977e+07	4673	3830.47	1
2011	29	2	2931806	6.434194e+07	16796	3830.79	1
2011	22	2	2210359	1.703106e+07	4439	3836.69	1
2011	29	2	2903235	5.282093e+07	13766	3837.06	1
2011	15	1	1507961	4.000584e+07	10416	3840.81	1
2011	29	2	2919900	3.085809e+07	8032	3841.89	1
2011	23	2	2304657	5.791398e+07	15068	3843.51	1
2011	27	2	2706208	1.984782e+07	5158	3847.97	1
2011	22	2	2202117	1.830157e+07	4755	3848.91	1
2011	26	2	2603207	1.0304036e+08	26765	3849.82	1
2011	27	2	2706422	3.956346e+07	10274	3850.83	1
2011	29	2	2907103	1.096036e+08	28451	3852.36	1
2011	23	2	2304707	2.0124022e+08	52223	3853.48	1
2011	21	2	2104628	2.853773e+07	7401	3855.93	1
2011	23	2	2308005	1.3736376e+08	35623	3856.04	1
2011	21	2	2107308	1.771892e+07	4594	3856.97	1
2011	21	2	2100709	9.88635e+07	25629	3857.49	1
2011	21	2	2100907	1.6658417e+08	43089	3866.05	1
2011	29	2	2923035	4.192511e+07	10840	3867.63	1
2011	29	2	2924108	2.684804e+07	6936	3870.82	1
2011	31	3	3129657	2.375996e+07	6126	3878.54	1
2011	27	2	2706109	4.26287e+07	10977	3883.46	1
2011	21	2	2105963	5.002603e+07	12879	3884.31	1
2011	25	2	2515401	4.00786e+07	10317	3884.71	1
2011	21	2	2104651	3.964357e+07	10205	3884.72	1
2011	29	2	2922052	4.661419e+07	11992	3887.11	1
2011	22	2	2210409	7.030112e+07	18083	3887.69	1
2011	26	2	2612471	4.604027e+07	11836	3889.85	1
2011	22	2	2202091	2.214397e+07	5686	3894.47	1
2011	29	2	2924603	7.818595e+07	20064	3896.83	1
2011	21	2	2107704	7.904125e+07	20276	3898.27	1
2011	29	2	2924207	6.635812e+07	17020	3898.83	1
2011	22	2	2201572	1.301303e+07	3337	3899.62	1
2011	29	2	2924306	6.795948e+07	17417	3901.9	1
2011	21	2	2101970	3.186785e+07	8166	3902.5	1
2011	29	2	2904001	5.389679e+07	13796	3906.7	1
2011	21	2	2107001	3.655586e+07	9342	3913.07	1
2011	22	2	2200103	1.987862e+07	5080	3913.11	1
2011	29	2	2906709	1.0862526e+08	27747	3914.85	1
2011	22	2	2209377	2.016399e+07	5147	3917.62	1
2011	29	2	2930808	6.262921e+07	15986	3917.75	1
2011	22	2	2204907	3.238791e+07	8265	3918.68	1
2011	29	2	2904852	6.852569e+07	17457	3925.4	1
2011	23	2	2300903	5.513576e+07	14032	3929.29	1
2011	22	2	2203008	3.109756e+07	7904	3934.41	1
2011	22	2	2201507	1.019654e+08	25901	3936.74	1
2011	15	1	1502608	4.508856e+07	11439	3941.65	1
2011	15	1	1501600	5.490992e+07	13923	3943.83	1
2011	23	2	2304004	8.718647e+07	22106	3944.02	1
2011	29	2	2926905	4.715639e+07	11933	3951.76	1
2011	29	2	2933059	5.465034e+07	13811	3957.02	1
2011	22	2	2202505	4.08924e+07	10332	3957.84	1
2011	27	2	2701605	6.836443e+07	17244	3964.53	1
2011	22	2	2202778	2.95315e+07	7447	3965.56	1
2011	21	2	2107902	7.048157e+07	17773	3965.65	1
2011	22	2	2210904	1.788569e+07	4509	3966.66	1
2011	27	2	2708402	1.2031573e+08	30323	3967.8	1
2011	22	2	2203420	1.692437e+07	4263	3970.06	1
2011	22	2	2209005	2.493659e+07	6278	3972.06	1
2011	23	2	2309458	9.617975e+07	24193	3975.52	1
2011	29	2	2905909	1.1184163e+08	28124	3976.73	1
2011	13	1	1303700	9.826236e+07	24689	3980.01	1
2011	21	2	2110203	1.3184085e+08	33117	3981.06	1
2011	29	2	2911659	3.999931e+07	10039	3984.39	1
2011	31	3	3143153	1.862771e+07	4675	3984.54	1
2011	27	2	2704203	1.0848695e+08	27215	3986.29	1
2011	29	2	2901908	7.104754e+07	17805	3990.31	1
2011	22	2	2202729	2.239279e+07	5605	3995.15	1
2011	22	2	2200707	3.694283e+07	9244	3996.41	1
2011	22	2	2205540	1.075442e+07	2689	3999.41	1
2011	21	2	2105450	3.516723e+07	8793	3999.46	1
2011	21	2	2100956	1.275499e+08	31835	4006.59	1
2011	21	2	2109056	2.406441e+07	6004	4008.06	1
2011	29	2	2906899	4.028133e+07	10048	4008.89	1
2011	29	2	2923209	8.76087e+07	21822	4014.7	1
2011	29	2	2917409	5.487592e+07	13664	4016.1	1
2011	26	2	2614808	9.018199e+07	22450	4017.02	1
2011	29	2	2931509	8.653212e+07	21533	4018.58	1
2011	21	2	2111250	3.019862e+07	7501	4025.95	1
2011	22	2	2210375	1.033687e+07	2567	4026.83	1
2011	23	2	2308906	8.426409e+07	20913	4029.27	1
2011	26	2	2612554	5.427396e+07	13468	4029.85	1
2011	22	2	2206902	2.611007e+07	6478	4030.58	1
2011	29	2	2909000	3.30755e+07	8205	4031.14	1
2011	23	2	2302305	1.2542691e+08	31072	4036.65	1
2011	23	2	2303303	7.499939e+07	18577	4037.22	1
2011	13	1	1303908	1.2955281e+08	32060	4040.95	1
2011	22	2	2205250	1.75311e+07	4334	4045.01	1
2011	29	2	2924801	9.189104e+07	22658	4055.57	1
2011	21	2	2103604	2.5231253e+08	62190	4057.12	1
2011	21	2	2102903	9.03367e+07	22266	4057.16	1
2011	22	2	2202851	1.846967e+07	4551	4058.38	1
2011	15	1	1506112	5.08483e+07	12527	4059.1	1
2011	21	2	2112456	9.45354e+07	23277	4061.32	1
2011	26	2	2601052	7.47278e+07	18390	4063.5	1
2011	21	2	2109759	2.907753e+07	7155	4063.95	1
2011	21	2	2107506	4.3801725e+08	107764	4064.6	1
2011	23	2	2304905	4.20287e+07	10339	4065.06	1
2011	22	2	2202075	1.37495e+07	3379	4069.1	1
2011	22	2	2202737	1.564194e+07	3842	4071.3	1
2011	23	2	2308203	5.652169e+07	13874	4073.93	1
2011	22	2	2204550	1.79965e+07	4417	4074.37	1
2011	29	2	2918506	6.124629e+07	15028	4075.48	1
2011	21	2	2112605	1.0237456e+08	25108	4077.37	1
2011	29	2	2902658	4.82452e+07	11827	4079.24	1
2011	27	2	2702504	4.439552e+07	10866	4085.73	1
2011	22	2	2210508	5.608851e+07	13726	4086.3	1
2011	29	2	2902708	2.0324685e+08	49736	4086.51	1
2011	22	2	2209559	1.767101e+07	4323	4087.67	1
2011	31	3	3135357	3.400313e+07	8315	4089.37	1
2011	22	2	2207777	2.513156e+07	6142	4091.75	1
2011	23	2	2303006	8.332869e+07	20359	4092.97	1
2011	22	2	2207504	5.678242e+07	13868	4094.49	1
2011	21	2	2105351	5.051591e+07	12337	4094.67	1
2011	29	2	2913002	6.383802e+07	15590	4094.81	1
2011	31	3	3130051	4.445999e+07	10856	4095.43	1
2011	31	3	3135456	2.937445e+07	7165	4099.71	1
2011	15	1	1503101	1.2102871e+08	29520	4099.89	1
2011	29	2	2930402	6.236046e+07	15194	4104.28	1
2011	21	2	2112803	2.0478708e+08	49883	4105.35	1
2011	21	2	2111508	1.6184534e+08	39418	4105.87	1
2011	29	2	2906105	3.861492e+07	9403	4106.66	1
2011	15	1	1507474	8.585014e+07	20890	4109.63	1
2011	23	2	2310951	4.232642e+07	10292	4112.56	1
2011	22	2	2206720	3.351396e+07	8149	4112.65	1
2011	23	2	2308807	3.351963e+07	8149	4113.34	1
2011	31	3	3139250	2.606281e+07	6336	4113.45	1
2011	29	2	2927606	6.120143e+07	14876	4114.11	1
2011	29	2	2919959	2.698124e+07	6554	4116.76	1
2011	23	2	2308377	5.316976e+07	12907	4119.45	1
2011	31	3	3138658	3.485251e+07	8453	4123.09	1
2011	22	2	2202554	2.009249e+07	4871	4124.92	1
2011	22	2	2208106	4.855928e+07	11766	4127.09	1
2011	15	1	1500909	1.6958382e+08	41072	4128.94	1
2011	27	2	2707107	9.616405e+07	23279	4130.94	1
2011	22	2	2206803	3.422138e+07	8283	4131.52	1
2011	22	2	2209906	2.528128e+07	6118	4132.28	1
2011	21	2	2109452	1.1174971e+08	27037	4133.21	1
2011	31	3	3146750	2.805836e+07	6781	4137.79	1
2011	27	2	2702009	4.489767e+07	10845	4139.94	1
2011	23	2	2300606	2.877488e+07	6946	4142.65	1
2011	23	2	2311900	6.511492e+07	15716	4143.22	1
2011	29	2	2926806	6.181433e+07	14917	4143.89	1
2011	15	1	1504109	3.379864e+07	8148	4148.09	1
2011	22	2	2207959	1.747005e+07	4211	4148.67	1
2011	22	2	2205565	1.881391e+07	4529	4154.1	1
2011	22	2	2207355	1.412148e+07	3399	4154.6	1
2011	29	2	2932002	1.0035897e+08	24152	4155.31	1
2011	29	2	2915007	6.232157e+07	14995	4156.16	1
2011	23	2	2300507	4.51628e+07	10865	4156.72	1
2011	22	2	2208601	1.281794e+07	3083	4157.62	1
2011	21	2	2105906	6.457444e+07	15520	4160.72	1
2011	29	2	2920304	3.507153e+07	8428	4161.31	1
2011	31	3	3137007	7.111432e+07	17084	4162.63	1
2011	29	2	2901155	6.645919e+07	15962	4163.59	1
2011	23	2	2303907	5.26777e+07	12650	4164.25	1
2011	23	2	2303204	1.1010114e+08	26433	4165.29	1
2011	15	1	1505601	3.27505e+07	7862	4165.67	1
2011	22	2	2209807	1.997612e+07	4793	4167.77	1
2011	22	2	2209872	2.36141e+07	5664	4169.16	1
2011	27	2	2703007	6.326788e+07	15165	4171.97	1
2011	29	2	2929255	7.688907e+07	18429	4172.18	1
2011	15	1	1508035	1.1606149e+08	27817	4172.32	1
2011	15	1	1506195	1.7226449e+08	41272	4173.88	1
2011	29	2	2924504	6.539417e+07	15662	4175.34	1
2011	27	2	2705002	1.0302872e+08	24673	4175.77	1
2011	15	1	1501006	6.643375e+07	15875	4184.8	1
2011	29	2	2929800	4.976485e+07	11884	4187.55	1
2011	22	2	2200053	2.845878e+07	6795	4188.19	1
2011	22	2	2201309	1.359137e+07	3245	4188.4	1
2011	29	2	2903508	6.669107e+07	15915	4190.45	1
2011	29	2	2918605	3.259352e+07	7778	4190.48	1
2011	21	2	2108702	9.160844e+07	21860	4190.69	1
2011	25	2	2514453	2.328398e+07	5555	4191.54	1
2011	22	2	2208650	3.613859e+07	8617	4193.87	1
2011	23	2	2306504	7.896544e+07	18821	4195.6	1
2011	22	2	2204154	1.225778e+07	2921	4196.43	1
2011	29	2	2921609	3.46533e+07	8256	4197.35	1
2011	23	2	2303105	7.710943e+07	18369	4197.8	1
2011	21	2	2105203	4.688972e+07	11167	4198.95	1
2011	29	2	2903003	5.85904e+07	13950	4200.03	1
2011	21	2	2106003	4.821533e+07	11475	4201.77	1
2011	26	2	2605806	6.049668e+07	14394	4202.91	1
2011	29	2	2912608	2.047478e+07	4870	4204.27	1
2011	29	2	2922201	3.09096e+07	7346	4207.68	1
2011	15	1	1507904	9.776714e+07	23235	4207.75	1
2011	31	3	3157658	2.558595e+07	6079	4208.91	1
2011	27	2	2704609	4.219591e+07	10023	4209.91	1
2011	29	2	2922706	7.043702e+07	16731	4209.97	1
2011	22	2	2205524	2.276683e+07	5407	4210.62	1
2011	23	2	2313757	7.971252e+07	18914	4214.47	1
2011	24	2	2403509	4.410651e+07	10457	4217.89	1
2011	21	2	2107407	7.892304e+07	18711	4218	1
2011	23	2	2312007	1.2759629e+08	30234	4220.29	1
2011	21	2	2112274	2.37573e+07	5624	4224.27	1
2011	23	2	2313708	3.191382e+07	7554	4224.76	1
2011	21	2	2107357	8.196781e+07	19401	4224.93	1
2011	22	2	2209609	1.2862e+07	3044	4225.36	1
2011	29	2	2919603	4.740123e+07	11215	4226.59	1
2011	21	2	2105708	1.9740794e+08	46701	4227.06	1
2011	29	2	2911857	5.557473e+07	13145	4227.82	1
2011	26	2	2602605	1.9340404e+08	45723	4229.91	1
2011	23	2	2301257	4.455216e+07	10529	4231.38	1
2011	22	2	2209351	1.89071e+07	4468	4231.67	1
2011	27	2	2702207	2.351741e+07	5557	4232.03	1
2011	29	2	2917003	1.5305993e+08	36157	4233.2	1
2011	22	2	2209856	1.889704e+07	4461	4236.05	1
2011	22	2	2210706	6.029507e+07	14225	4238.67	1
2011	22	2	2201002	1.98177e+07	4672	4241.8	1
2011	29	2	2928505	4.124978e+07	9722	4242.93	1
2011	23	2	2303931	5.482917e+07	12919	4244.07	1
2011	29	2	2904803	4.676733e+07	11016	4245.4	1
2011	22	2	2205953	3.37272e+07	7938	4248.83	1
2011	29	2	2922904	1.0286416e+08	24202	4250.23	1
2011	31	3	3154507	3.979065e+07	9361	4250.68	1
2011	21	2	2101350	2.271072e+07	5341	4252.15	1
2011	21	2	2106326	8.33237e+07	19566	4258.6	1
2011	22	2	2202711	1.936429e+07	4547	4258.69	1
2011	25	2	2509008	4.593397e+07	10781	4260.64	1
2011	23	2	2308500	1.82363e+08	42793	4261.51	1
2011	22	2	2207900	1.6022154e+08	37596	4261.66	1
2011	29	2	2901304	5.947233e+07	13951	4262.94	1
2011	29	2	2910859	7.12652e+07	16706	4265.84	1
2011	21	2	2101707	2.3970161e+08	56123	4271	1
2011	15	1	1507102	7.257843e+07	16991	4271.58	1
2011	29	2	2902609	8.566303e+07	20046	4273.32	1
2011	29	2	2914109	3.99359e+07	9343	4274.42	1
2011	21	2	2103554	6.291827e+07	14718	4274.92	1
2011	21	2	2108504	1.3421202e+08	31384	4276.45	1
2011	29	2	2902005	5.844385e+07	13641	4284.43	1
2011	29	2	2912400	7.347191e+07	17145	4285.33	1
2011	22	2	2200608	2.855773e+07	6664	4285.37	1
2011	22	2	2205003	4.790098e+07	11165	4290.28	1
2011	22	2	2202802	1.92491e+07	4486	4290.93	1
2011	21	2	2105609	6.705423e+07	15626	4291.2	1
2011	29	2	2905503	5.398937e+07	12576	4293.05	1
2011	22	2	2211704	1.847098e+07	4302	4293.58	1
2011	23	2	2307502	1.334561e+08	31082	4293.68	1
2011	23	2	2313906	5.579195e+07	12991	4294.66	1
2011	22	2	2209708	2.704058e+07	6294	4296.25	1
2011	26	2	2605400	8.894988e+07	20703	4296.47	1
2011	29	2	2904506	4.554673e+07	10596	4298.48	1
2011	27	2	2706406	1.0204274e+08	23730	4300.16	1
2011	22	2	2204659	3.871498e+07	8993	4305.01	1
2011	26	2	2609154	7.957639e+07	18472	4307.95	1
2011	21	2	2108454	9.263293e+07	21498	4308.91	1
2011	15	1	1506559	8.372902e+07	19426	4310.15	1
2011	27	2	2702900	1.60011e+08	37118	4310.87	1
2011	29	2	2913507	1.1114373e+08	25768	4313.25	1
2011	22	2	2200954	1.052884e+07	2441	4313.33	1
2011	23	2	2304277	2.970185e+07	6882	4315.87	1
2011	29	2	2904209	4.770354e+07	11050	4317.06	1
2011	22	2	2204808	4.062499e+07	9397	4323.19	1
2011	29	2	2914307	5.002229e+07	11564	4325.69	1
2011	22	2	2202539	2.414508e+07	5580	4327.08	1
2011	21	2	2104008	7.754921e+07	17917	4328.25	1
2011	29	2	2903706	6.51595e+07	15048	4330.11	1
2011	21	2	2111029	6.779469e+07	15649	4332.21	1
2011	22	2	2203800	1.893587e+07	4366	4337.12	1
2011	29	2	2924900	3.853762e+07	8884	4337.87	1
2011	26	2	2608701	6.792335e+07	15649	4340.43	1
2011	22	2	2204105	1.918043e+07	4419	4340.44	1
2011	21	2	2111631	2.570344e+07	5921	4341.06	1
2011	27	2	2706000	4.819168e+07	11100	4341.59	1
2011	29	2	2930204	1.6421338e+08	37806	4343.58	1
2011	29	2	2932408	5.923701e+07	13634	4344.8	1
2011	25	2	2506707	4.950192e+07	11388	4346.85	1
2011	22	2	2209500	1.593873e+07	3664	4350.09	1
2011	29	2	2927903	4.497846e+07	10337	4351.21	1
2011	22	2	2201739	2.623729e+07	6029	4351.85	1
2011	29	2	2903607	6.463006e+07	14851	4351.9	1
2011	31	3	3162401	1.1018856e+08	25307	4354.07	1
2011	29	2	2923704	1.2924143e+08	29682	4354.2	1
2011	26	2	2602001	1.5426509e+08	35422	4355.06	1
2011	26	2	2606903	5.140596e+07	11802	4355.7	1
2011	21	2	2103174	8.531246e+07	19581	4356.9	1
2011	21	2	2111805	7.475705e+07	17147	4359.77	1
2011	29	2	2905305	7.544743e+07	17305	4359.86	1
2011	23	2	2305902	1.6489056e+08	37809	4361.15	1
2011	29	2	2909208	7.352006e+07	16855	4361.91	1
2011	26	2	2612109	4.140446e+07	9479	4368.02	1
2011	31	3	3145307	1.3432072e+08	30746	4368.72	1
2011	22	2	2210953	1.215763e+07	2780	4373.25	1
2011	26	2	2600807	9.785568e+07	22371	4374.22	1
2011	29	2	2921807	5.466326e+07	12496	4374.46	1
2011	23	2	2310902	6.846581e+07	15647	4375.65	1
2011	22	2	2204600	1.654192e+07	3777	4379.64	1
2011	29	2	2931103	3.513457e+07	8022	4379.78	1
2011	21	2	2100436	1.0942725e+08	24969	4382.52	1
2011	29	2	2906808	1.4457632e+08	32982	4383.49	1
2011	23	2	2301802	2.653891e+07	6050	4386.6	1
2011	27	2	2705408	3.04672e+07	6945	4386.93	1
2011	15	1	1506302	9.025724e+07	20572	4387.38	1
2011	22	2	2209104	2.653309e+07	6047	4387.81	1
2011	22	2	2202455	1.718405e+07	3913	4391.53	1
2011	29	2	2907905	6.952126e+07	15821	4394.24	1
2011	27	2	2707602	5.013203e+07	11404	4396	1
2011	31	3	3127073	2.585183e+07	5876	4399.56	1
2011	29	2	2906824	6.971225e+07	15839	4401.3	1
2011	22	2	2204709	6.550567e+07	14878	4402.85	1
2011	29	2	2921401	7.241252e+07	16445	4403.32	1
2011	21	2	2103406	2.0750866e+08	47099	4405.8	1
2011	31	3	3116308	2.891661e+07	6563	4406	1
2011	13	1	1300409	1.1386579e+08	25835	4407.42	1
2011	23	2	2300408	7.201669e+07	16338	4407.93	1
2011	27	2	2702355	1.0054511e+08	22784	4412.97	1
2011	21	2	2111532	5.346277e+07	12113	4413.67	1
2011	31	3	3128204	4.516391e+07	10221	4418.74	1
2011	29	2	2920106	8.505179e+07	19243	4419.88	1
2011	23	2	2314102	2.4626372e+08	55687	4422.28	1
2011	22	2	2210300	2.519477e+07	5697	4422.46	1
2011	29	2	2919157	1.1375304e+08	25717	4423.26	1
2011	29	2	2928950	4.090259e+07	9247	4423.34	1
2011	25	2	2513000	1.576094e+07	3561	4425.99	1
2011	22	2	2207553	1.730761e+07	3908	4428.76	1
2011	29	2	2913309	2.333823e+07	5269	4429.35	1
2011	22	2	2200277	2.287989e+07	5163	4431.51	1
2011	26	2	2612802	4.896669e+07	11048	4432.18	1
2011	21	2	2109205	5.19625e+07	11722	4432.9	1
2011	29	2	2910305	3.528947e+07	7954	4436.69	1
2011	22	2	2201988	1.680465e+07	3786	4438.63	1
2011	26	2	2615805	1.0965453e+08	24704	4438.74	1
2011	26	2	2610202	1.1380557e+08	25628	4440.67	1
2011	24	2	2402105	4.596988e+07	10348	4442.39	1
2011	13	1	1301654	6.304406e+07	14189	4443.16	1
2011	27	2	2705804	3.822981e+07	8601	4444.81	1
2011	21	2	2108009	8.120524e+07	18268	4445.22	1
2011	26	2	2606507	8.188177e+07	18412	4447.2	1
2011	31	3	3117836	3.180347e+07	7149	4448.66	1
2011	25	2	2516409	4.595875e+07	10330	4449.06	1
2011	31	3	3136520	2.022067e+07	4543	4450.95	1
2011	23	2	2309003	6.287245e+07	14125	4451.15	1
2011	13	1	1304237	7.657578e+07	17200	4452.08	1
2011	29	2	2909703	5.938001e+07	13328	4455.28	1
2011	29	2	2926400	1.3743173e+08	30840	4456.28	1
2011	31	3	3160454	3.11056e+07	6979	4457.03	1
2011	22	2	2201176	1.719307e+07	3855	4459.94	1
2011	21	2	2104206	6.751984e+07	15137	4460.58	1
2011	21	2	2106706	9.143082e+07	20495	4461.13	1
2011	27	2	2709004	2.716815e+07	6086	4464.04	1
2011	29	2	2907707	4.806144e+07	10765	4464.6	1
2011	15	1	1507979	7.649027e+07	17130	4465.28	1
2011	31	3	3170008	5.251792e+07	11751	4469.23	1
2011	22	2	2211407	1.93343e+07	4326	4469.32	1
2011	26	2	2605608	9.913372e+07	22166	4472.33	1
2011	29	2	2924652	4.607628e+07	10295	4475.6	1
2011	23	2	2312809	3.111795e+07	6948	4478.69	1
2011	26	2	2603926	5.325117e+07	11888	4479.4	1
2011	25	2	2506608	2.689724e+07	6004	4479.89	1
2011	29	2	2928406	1.1838205e+08	26425	4479.93	1
2011	26	2	2601805	5.401598e+07	12057	4480.05	1
2011	22	2	2207108	1.189709e+07	2653	4484.39	1
2011	15	1	1500701	1.1326651e+08	25254	4485.09	1
2011	21	2	2112308	1.7743318e+08	39560	4485.17	1
2011	27	2	2702603	9.570927e+07	21338	4485.39	1
2011	26	2	2612901	6.346505e+07	14137	4489.29	1
2011	26	2	2606101	1.307837e+08	29132	4489.35	1
2011	22	2	2204204	3.917872e+07	8727	4489.37	1
2011	23	2	2307106	1.1997589e+08	26710	4491.8	1
2011	15	1	1508209	2.1781423e+08	48482	4492.68	1
2011	31	3	3113008	1.0095599e+08	22448	4497.33	1
2011	22	2	2201919	2.409414e+07	5357	4497.69	1
2011	15	1	1506906	2.787226e+07	6196	4498.43	1
2011	22	2	2207850	1.640322e+07	3646	4498.96	1
2011	25	2	2503506	7.534157e+07	16743	4499.88	1
2011	21	2	2112852	5.224451e+07	11608	4500.73	1
2011	22	2	2206001	2.005362e+07	4455	4501.37	1
2011	31	3	3143450	3.392453e+07	7533	4503.45	1
2011	27	2	2705903	2.236472e+07	4966	4503.57	1
2011	22	2	2208809	7.910485e+07	17563	4504.06	1
2011	31	3	3131158	7.606267e+07	16876	4507.15	1
2011	29	2	2908705	7.602757e+07	16842	4514.16	1
2011	22	2	2201200	2.039526e+08	45154	4516.82	1
2011	22	2	2210391	1.343819e+07	2975	4517.04	1
2011	25	2	2508505	3.244668e+07	7177	4520.93	1
2011	25	2	2503555	3.095836e+07	6847	4521.45	1
2011	29	2	2924678	4.44075e+07	9816	4523.99	1
2011	24	2	2413300	2.594645e+07	5734	4525.02	1
2011	29	2	2914208	3.179508e+07	7024	4526.63	1
2011	29	2	2905107	4.613641e+07	10188	4528.5	1
2011	15	1	1502103	5.5560648e+08	122683	4528.8	1
2011	21	2	2108108	9.237119e+07	20396	4528.89	1
2011	21	2	2102556	6.120683e+07	13511	4530.15	1
2011	29	2	2913101	8.065145e+07	17801	4530.73	1
2011	31	3	3164506	4.792673e+07	10574	4532.51	1
2011	29	2	2925808	1.1153056e+08	24602	4533.39	1
2011	15	1	1502905	1.5831074e+08	34919	4533.66	1
2011	27	2	2701209	4.645451e+07	10245	4534.36	1
2011	25	2	2507606	3.404063e+07	7506	4535.12	1
2011	21	2	2113009	1.4370779e+08	31684	4535.66	1
2011	29	2	2918209	6.41673e+07	14147	4535.75	1
2011	15	1	1501808	4.2565937e+08	93835	4536.25	1
2011	29	2	2917201	8.267607e+07	18216	4538.65	1
2011	29	2	2902104	2.3601622e+08	51994	4539.3	1
2011	21	2	2102002	1.7892543e+08	39401	4541.14	1
2011	29	2	2924058	6.234979e+07	13729	4541.47	1
2011	15	1	1504406	1.2168602e+08	26750	4549.01	1
2011	31	3	3149150	4.743952e+07	10426	4550.12	1
2011	25	2	2502102	2.588573e+07	5687	4551.74	1
2011	22	2	2206506	3.389896e+07	7440	4556.31	1
2011	23	2	2305654	5.172005e+07	11351	4556.43	1
2011	29	2	2933604	2.0789326e+08	45599	4559.16	1
2011	25	2	2514800	1.812002e+07	3974	4559.64	1
2011	21	2	2109239	2.950847e+07	6471	4560.11	1
2011	26	2	2602506	3.333671e+07	7310	4560.43	1
2011	22	2	2209450	9.46588e+06	2074	4564.07	1
2011	13	1	1300680	6.995279e+07	15325	4564.62	1
2011	29	2	2906600	6.059887e+07	13271	4566.26	1
2011	22	2	2200400	1.7825039e+08	39031	4566.89	1
2011	21	2	2101608	3.8146042e+08	83454	4570.91	1
2011	22	2	2203503	6.606225e+07	14452	4571.15	1
2011	26	2	2615201	4.30367e+07	9409	4573.99	1
2011	25	2	2514305	2.758968e+07	6031	4574.64	1
2011	23	2	2301505	3.503843e+07	7659	4574.8	1
2011	23	2	2310308	1.4290839e+08	31233	4575.56	1
2011	26	2	2603900	8.540356e+07	18642	4581.24	1
2011	23	2	2302057	6.652927e+07	14519	4582.22	1
2011	23	2	2302008	9.9156e+07	21630	4584.19	1
2011	31	3	3145356	4.75373e+07	10368	4585	1
2011	29	2	2904407	5.120349e+07	11164	4586.48	1
2011	25	2	2500908	5.850609e+07	12738	4593.04	1
2011	29	2	2933158	5.969287e+07	12991	4594.94	1
2011	24	2	2407708	5.227068e+07	11372	4596.44	1
2011	23	2	2304350	1.0166736e+08	22116	4597	1
2011	25	2	2512408	5.974982e+07	12996	4597.55	1
2011	22	2	2208700	3.884425e+07	8448	4598.04	1
2011	15	1	1505908	1.5987616e+08	34756	4599.96	1
2011	29	2	2913408	7.003168e+07	15222	4600.69	1
2011	22	2	2208858	1.948635e+07	4235	4601.26	1
2011	26	2	2608602	5.624797e+07	12221	4602.57	1
2011	24	2	2410108	6.482723e+07	14079	4604.53	1
2011	25	2	2506251	3.854733e+07	8365	4608.17	1
2011	21	2	2111672	2.804238e+07	6077	4614.51	1
2011	29	2	2922102	1.136964e+08	24635	4615.24	1
2011	29	2	2930766	5.656852e+07	12256	4615.58	1
2011	22	2	2202109	2.507006e+07	5429	4617.8	1
2011	23	2	2304251	1.0478562e+08	22687	4618.75	1
2011	23	2	2310506	1.9392379e+08	41979	4619.54	1
2011	29	2	2906204	1.1204461e+08	24252	4620.02	1
2011	21	2	2112902	1.4510832e+08	31406	4620.4	1
2011	23	2	2306207	3.40731e+07	7373	4621.33	1
2011	15	1	1502509	9.837402e+07	21286	4621.54	1
2011	13	1	1300904	6.40045e+07	13843	4623.6	1
2011	29	2	2930600	5.735788e+07	12405	4623.77	1
2011	29	2	2923506	3.922347e+07	8479	4625.96	1
2011	25	2	2501203	3.008975e+07	6504	4626.35	1
2011	29	2	2933109	4.030533e+07	8711	4626.95	1
2011	29	2	2933406	4.161566e+07	8984	4632.2	1
2011	22	2	2205532	2.109551e+07	4554	4632.3	1
2011	26	2	2614303	5.158706e+07	11134	4633.29	1
2011	22	2	2209302	2.58125e+07	5570	4634.2	1
2011	22	2	2206951	1.527247e+07	3295	4635.04	1
2011	31	3	3165552	5.103204e+07	11008	4635.91	1
2011	23	2	2301208	1.1820186e+08	25493	4636.64	1
2011	25	2	2513109	5.5509e+07	11971	4636.96	1
2011	26	2	2607703	6.406614e+07	13814	4637.77	1
2011	23	2	2304954	1.1323234e+08	24414	4638.01	1
2011	27	2	2703106	1.1670483e+08	25158	4638.88	1
2011	25	2	2511806	4.795718e+07	10336	4639.82	1
2011	22	2	2203859	1.154835e+07	2488	4641.62	1
2011	29	2	2919405	5.707921e+07	12295	4642.47	1
2011	21	2	2102200	1.2648647e+08	27235	4644.26	1
2011	29	2	2932309	1.1748043e+08	25295	4644.41	1
2011	29	2	2906857	5.346119e+07	11506	4646.37	1
2011	27	2	2704104	8.418423e+07	18117	4646.7	1
2011	25	2	2501302	8.851561e+07	19049	4646.73	1
2011	22	2	2201804	2.037688e+07	4382	4650.13	1
2011	22	2	2209153	1.781604e+07	3830	4651.71	1
2011	21	2	2102325	3.0858546e+08	66326	4652.56	1
2011	29	2	2902302	4.008828e+07	8616	4652.77	1
2011	31	3	3146305	8.819716e+07	18955	4652.98	1
2011	29	2	2907806	1.5070488e+08	32387	4653.25	1
2011	23	2	2309904	2.799376e+07	6012	4656.31	1
2011	15	1	1504307	1.3253302e+08	28438	4660.42	1
2011	26	2	2612455	6.420578e+07	13773	4661.71	1
2011	23	2	2304236	8.007681e+07	17173	4662.95	1
2011	25	2	2501575	3.822697e+07	8198	4662.96	1
2011	23	2	2310803	7.367214e+07	15798	4663.38	1
2011	13	1	1303007	8.630624e+07	18503	4664.45	1
2011	31	3	3156007	6.321325e+07	13549	4665.53	1
2011	31	3	3136504	4.834204e+07	10360	4666.22	1
2011	15	1	1503077	1.1710837e+08	25097	4666.23	1
2011	13	1	1303601	8.739754e+07	18729	4666.43	1
2011	29	2	2930154	1.4739342e+08	31581	4667.15	1
2011	25	2	2500106	4.448896e+07	9532	4667.33	1
2011	25	2	2505352	2.309153e+07	4946	4668.73	1
2011	31	3	3120870	3.261878e+07	6986	4669.16	1
2011	15	1	1503309	2.7334788e+08	58498	4672.77	1
2011	25	2	2500502	6.384192e+07	13660	4673.64	1
2011	13	1	1302801	8.209781e+07	17563	4674.48	1
2011	29	2	2923100	1.1701026e+08	25023	4676.11	1
2011	31	3	3155207	2.807971e+07	6004	4676.83	1
2011	13	1	1304401	8.544578e+07	18265	4678.12	1
2011	26	2	2603702	1.1457871e+08	24491	4678.4	1
2011	25	2	2508000	4.589961e+07	9810	4678.86	1
2011	25	2	2517209	2.374334e+07	5074	4679.41	1
2011	25	2	2510204	2.826889e+07	6041	4679.51	1
2011	22	2	2205805	1.1594942e+08	24774	4680.29	1
2011	25	2	2505709	4.905032e+07	10477	4681.71	1
2011	22	2	2211506	1.402157e+07	2993	4684.79	1
2011	27	2	2707503	9.0932e+07	19410	4684.8	1
2011	23	2	2304806	2.153952e+07	4590	4692.71	1
2011	21	2	2104099	8.197913e+07	17464	4694.18	1
2011	24	2	2403301	2.472195e+07	5265	4695.53	1
2011	31	3	3146552	2.790434e+07	5942	4696.12	1
2011	29	2	2930758	5.685993e+07	12107	4696.45	1
2011	22	2	2207751	2.148284e+07	4573	4697.76	1
2011	29	2	2929370	4.812899e+07	10238	4701.01	1
2011	22	2	2205706	1.351369e+08	28725	4704.5	1
2011	21	2	2111409	9.393551e+07	19952	4708.08	1
2011	22	2	2203701	1.7936581e+08	38049	4714.07	1
2011	22	2	2203107	4.732331e+07	10036	4715.36	1
2011	13	1	1303809	1.8158166e+08	38507	4715.55	1
2011	29	2	2907608	8.034746e+07	17035	4716.61	1
2011	22	2	2200509	8.091495e+07	17155	4716.7	1
2011	25	2	2515104	5.245733e+07	11119	4717.81	1
2011	23	2	2306108	1.0648947e+08	22537	4725.1	1
2011	25	2	2510006	3.433717e+07	7266	4725.73	1
2011	23	2	2305332	5.433953e+07	11481	4733	1
2011	22	2	2202133	2.674915e+07	5649	4735.2	1
2011	15	1	1505007	6.556337e+07	13844	4735.87	1
2011	24	2	2412302	5.867592e+07	12385	4737.66	1
2011	29	2	2920403	6.740575e+07	14221	4739.87	1
2011	24	2	2400307	5.144893e+07	10843	4744.9	1
2011	25	2	2509206	6.16675e+07	12995	4745.48	1
2011	29	2	2930006	4.968578e+07	10469	4745.99	1
2011	23	2	2304269	4.343074e+07	9150	4746.53	1
2011	24	2	2412906	5.141069e+07	10830	4747.06	1
2011	22	2	2200905	2.73616e+07	5761	4749.45	1
2011	26	2	2612307	7.284432e+07	15333	4750.82	1
2011	25	2	2514602	1.554311e+07	3269	4754.7	1
2011	25	2	2505204	3.264182e+07	6861	4757.59	1
2011	22	2	2204006	2.490593e+07	5234	4758.49	1
2011	22	2	2202251	1.859854e+07	3907	4760.31	1
2011	23	2	2300804	3.342217e+07	7021	4760.32	1
2011	29	2	2920809	4.985677e+07	10473	4760.51	1
2011	29	2	2923605	1.0057579e+08	21115	4763.24	1
2011	23	2	2303402	8.033515e+07	16863	4763.99	1
2011	31	3	3160306	5.596459e+07	11747	4764.16	1
2011	22	2	2208304	1.322898e+08	27766	4764.45	1
2011	22	2	2207207	3.180241e+07	6673	4765.83	1
2011	29	2	2900405	7.53689e+07	15809	4767.47	1
2011	26	2	2601300	6.159008e+07	12918	4767.77	1
2011	23	2	2304301	9.028207e+07	18932	4768.75	1
2011	21	2	2110807	2.227292e+07	4669	4770.38	1
2011	29	2	2911253	2.16378e+07	4535	4771.29	1
2011	31	3	3106507	5.844691e+07	12248	4771.96	1
2011	25	2	2509156	2.966525e+07	6216	4772.4	1
2011	31	3	3138682	3.067594e+07	6422	4776.7	1
2011	26	2	2616100	4.378492e+07	9165	4777.41	1
2011	21	2	2106672	3.89801e+07	8157	4778.73	1
2011	25	2	2514107	2.097907e+07	4390	4778.83	1
2011	23	2	2300101	5.094252e+07	10659	4779.3	1
2011	29	2	2932804	8.733486e+07	18272	4779.71	1
2011	29	2	2931608	7.142402e+07	14941	4780.4	1
2011	29	2	2920601	2.0565013e+08	42967	4786.23	1
2011	22	2	2207603	4.953339e+07	10348	4786.76	1
2011	27	2	2700706	8.259187e+07	17251	4787.66	1
2011	23	2	2301307	9.943875e+07	20768	4788.08	1
2011	21	2	2103752	6.03774e+07	12603	4790.72	1
2011	23	2	2303808	1.1774828e+08	24576	4791.19	1
2011	25	2	2516607	6.776458e+07	14143	4791.39	1
2011	26	2	2602209	1.8163413e+08	37889	4793.85	1
2011	29	2	2926004	1.8776411e+08	39165	4794.18	1
2011	22	2	2204352	2.490469e+07	5194	4794.89	1
2011	26	2	2601508	5.472028e+07	11409	4796.24	1
2011	22	2	2205599	2.35257e+07	4905	4796.27	1
2011	31	3	3140555	3.806568e+07	7935	4797.19	1
2011	26	2	2602803	2.5292054e+08	52715	4797.89	1
2011	22	2	2205151	2.733164e+07	5696	4798.39	1
2011	31	3	3166956	2.138139e+07	4455	4799.41	1
2011	21	2	2109270	8.36603e+07	17430	4799.79	1
2011	29	2	2916609	4.892941e+07	10194	4799.82	1
2011	25	2	2509909	5.07212e+07	10567	4799.96	1
2011	31	3	3146206	2.880476e+07	6001	4799.99	1
2011	22	2	2202752	2.935283e+07	6115	4800.14	1
2011	23	2	2301950	9.490725e+07	19769	4800.81	1
2011	22	2	2202000	9.195927e+07	19144	4803.56	1
2011	29	2	2923407	1.0013816e+08	20836	4806.02	1
2011	26	2	2600500	1.9500291e+08	40511	4813.58	1
2011	31	3	3166501	2.032584e+07	4222	4814.27	1
2011	22	2	2205102	5.154215e+07	10704	4815.22	1
2011	22	2	2210938	3.044185e+07	6321	4815.99	1
2011	17	1	1720200	5.124714e+07	10635	4818.72	1
2011	29	2	2908309	8.577248e+07	17796	4819.76	1
2011	26	2	2610509	1.3779994e+08	28590	4819.87	1
2011	23	2	2310001	4.300108e+07	8920	4820.75	1
2011	25	2	2514552	2.006657e+07	4162	4821.38	1
2011	26	2	2611533	3.245423e+07	6731	4821.61	1
2011	25	2	2512036	1.806846e+07	3746	4823.4	1
2011	31	3	3136009	7.22498e+07	14971	4825.98	1
2011	25	2	2505402	3.867742e+07	8014	4826.23	1
2011	29	2	2916203	5.169975e+07	10711	4826.79	1
2011	26	2	2605905	1.3623583e+08	28213	4828.83	1
2011	29	2	2909604	9.720723e+07	20124	4830.41	1
2011	29	2	2917102	9.630195e+07	19928	4832.49	1
2011	29	2	2926509	6.916302e+07	14305	4834.88	1
2011	13	1	1303205	7.307769e+07	15113	4835.42	1
2011	25	2	2508554	1.92772e+07	3985	4837.44	1
2011	26	2	2614006	8.888392e+07	18369	4838.8	1
2011	27	2	2708204	3.257203e+07	6731	4839.11	1
2011	25	2	2512804	4.034008e+07	8334	4840.42	1
2011	15	1	1507466	2.594817e+07	5360	4841.08	1
2011	26	2	2614600	1.2885502e+08	26609	4842.54	1
2011	15	1	1502004	1.0079092e+08	20801	4845.48	1
2011	22	2	2210201	3.190256e+07	6583	4846.2	1
2011	29	2	2927101	3.835425e+07	7912	4847.6	1
2011	26	2	2605301	1.5323091e+08	31576	4852.76	1
2011	29	2	2930907	5.554711e+07	11432	4858.91	1
2011	22	2	2202653	2.482753e+07	5108	4860.52	1
2011	31	3	3109253	1.942767e+07	3996	4861.78	1
2011	31	3	3170909	9.292715e+07	19112	4862.24	1
2011	25	2	2508703	1.949577e+07	4009	4863	1
2011	15	1	1506401	4.075211e+07	8378	4864.18	1
2011	25	2	2509503	2.466632e+07	5069	4866.11	1
2011	25	2	2508109	2.272848e+07	4669	4867.95	1
2011	24	2	2406304	3.425467e+07	7035	4869.18	1
2011	23	2	2314003	1.8845577e+08	38698	4869.91	1
2011	22	2	2210383	1.032276e+07	2117	4876.13	1
2011	25	2	2511509	5.491933e+07	11262	4876.52	1
2011	26	2	2608107	1.5137553e+08	31029	4878.52	1
2011	31	3	3122207	3.450111e+07	7070	4879.93	1
2011	29	2	2921203	1.2854112e+08	26329	4882.11	1
2011	29	2	2900108	4.241121e+07	8687	4882.15	1
2011	21	2	2109601	1.9550015e+08	40030	4883.84	1
2011	31	3	3115474	2.485031e+07	5084	4887.95	1
2011	22	2	2205300	2.141982e+07	4381	4889.25	1
2011	31	3	3129301	5.068194e+07	10361	4891.61	1
2011	23	2	2305266	6.335464e+07	12950	4892.25	1
2011	21	2	2112233	9.369616e+07	19149	4893.01	1
2011	26	2	2614709	6.223165e+07	12710	4896.27	1
2011	22	2	2202604	8.978447e+07	18336	4896.62	1
2011	23	2	2311108	7.354547e+07	15016	4897.81	1
2011	31	3	3156502	3.715856e+07	7586	4898.31	1
2011	15	1	1506351	8.613942e+07	17584	4898.74	1
2011	23	2	2311959	7.631352e+07	15571	4901	1
2011	31	3	3150570	3.544489e+07	7232	4901.12	1
2011	15	1	1502301	2.5515587e+08	52057	4901.47	1
2011	25	2	2513158	3.256587e+07	6643	4902.28	1
2011	26	2	2607000	9.574664e+07	19527	4903.29	1
2011	29	2	2903805	8.803827e+07	17944	4906.28	1
2011	29	2	2911501	4.020605e+07	8191	4908.56	1
2011	29	2	2918100	1.8620708e+08	37926	4909.75	1
2011	26	2	2608057	6.886976e+07	14026	4910.15	1
2011	24	2	2401701	4.668767e+07	9504	4912.42	1
2011	25	2	2514206	3.715959e+07	7562	4913.99	1
2011	22	2	2206654	1.995608e+07	4061	4914.08	1
2011	31	3	3162658	2.010568e+07	4091	4914.61	1
2011	31	3	3127057	2.295662e+07	4671	4914.71	1
2011	25	2	2510105	5.174768e+07	10524	4917.11	1
2011	21	2	2104677	1.2471246e+08	25362	4917.3	1
2011	26	2	2611200	5.530571e+07	11247	4917.37	1
2011	22	2	2207934	1.193451e+07	2427	4917.39	1
2011	25	2	2513604	3.550979e+07	7219	4918.93	1
2011	24	2	2400901	3.403581e+07	6919	4919.18	1
2011	24	2	2405306	4.482879e+07	9113	4919.21	1
2011	29	2	2920502	1.2213079e+08	24822	4920.26	1
2011	31	3	3147956	2.762623e+07	5611	4923.58	1
2011	31	3	3141702	2.96236e+07	6016	4924.14	1
2011	21	2	2105989	3.454803e+07	7016	4924.18	1
2011	26	2	2604700	8.614364e+07	17491	4925.03	1
2011	31	3	3116803	4.433103e+07	8998	4926.76	1
2011	25	2	2509370	1.342169e+07	2724	4927.2	1
2011	31	3	3142007	6.447701e+07	13080	4929.44	1
2011	25	2	2502003	3.526619e+07	7154	4929.58	1
2011	31	3	3144656	4.856559e+07	9851	4930.02	1
2011	13	1	1300508	1.3669822e+08	27722	4931.04	1
2011	29	2	2925600	6.79545e+07	13779	4931.74	1
2011	23	2	2313203	1.2542081e+08	25424	4933.17	1
2011	22	2	2205201	8.98197e+07	18202	4934.61	1
2011	15	1	1508308	2.8207255e+08	57148	4935.83	1
2011	26	2	2616209	9.122179e+07	18473	4938.11	1
2011	29	2	2931905	2.5975664e+08	52579	4940.31	1
2011	24	2	2413102	2.810473e+07	5684	4944.53	1
2011	22	2	2201556	1.887371e+07	3817	4944.65	1
2011	26	2	2608255	5.278265e+07	10674	4944.97	1
2011	22	2	2210052	2.557832e+07	5169	4948.41	1
2011	25	2	2516805	4.571183e+07	9233	4950.92	1
2011	13	1	1301100	1.6404544e+08	33132	4951.27	1
2011	29	2	2909505	2.498012e+07	5045	4951.46	1
2011	25	2	2502805	6.546388e+07	13220	4951.88	1
2011	27	2	2704401	9.407947e+07	18994	4953.12	1
2011	25	2	2500536	2.60687e+07	5261	4955.08	1
2011	29	2	2910909	2.676305e+07	5401	4955.2	1
2011	23	2	2302909	8.491089e+07	17134	4955.7	1
2011	26	2	2608008	7.890222e+07	15909	4959.6	1
2011	25	2	2510402	3.403732e+07	6862	4960.26	1
2011	31	3	3171600	6.754115e+07	13615	4960.79	1
2011	26	2	2603306	5.501824e+07	11088	4961.96	1
2011	21	2	2106409	7.652934e+07	15408	4966.86	1
2011	27	2	2703700	2.752486e+07	5541	4967.49	1
2011	15	1	1505700	1.319796e+08	26560	4969.11	1
2011	13	1	1300060	4.78906e+07	9633	4971.51	1
2011	15	1	1500107	7.0988361e+08	142785	4971.7	1
2011	23	2	2301604	1.1206864e+08	22541	4971.77	1
2011	26	2	2610103	4.023763e+07	8086	4976.21	1
2011	31	3	3142254	2.27883e+07	4577	4978.87	1
2011	25	2	2509396	2.993532e+07	6009	4981.75	1
2011	29	2	2910206	1.935499e+07	3884	4983.26	1
2011	24	2	2402808	2.693901e+07	5405	4984.09	1
2011	21	2	2104073	4.072878e+07	8171	4984.55	1
2011	26	2	2604403	6.233198e+07	12504	4984.96	1
2011	31	3	3170651	2.370622e+07	4755	4985.53	1
2011	29	2	2923357	8.23018e+07	16503	4987.08	1
2011	25	2	2505600	3.288179e+07	6593	4987.38	1
2011	29	2	2923308	4.144844e+07	8307	4989.58	1
2011	29	2	2911006	5.292331e+07	10605	4990.41	1
2011	21	2	2102101	1.6875265e+08	33808	4991.5	1
2011	13	1	1300607	1.7081591e+08	34194	4995.49	1
2011	26	2	2614402	2.878081e+07	5761	4995.8	1
2011	26	2	2604155	6.895082e+07	13799	4996.8	1
2011	31	3	3115409	1.737253e+07	3476	4997.85	1
2011	31	3	3105509	2.839726e+07	5681	4998.64	1
2011	23	2	2300309	2.5729973e+08	51469	4999.12	1
2011	25	2	2509602	2.26919e+07	4539	4999.32	1
2011	15	1	1505650	1.2370752e+08	24744	4999.5	1
2011	21	2	2103505	1.9693348e+08	39388	4999.83	1
2011	21	2	2101004	1.4325874e+08	28651	5000.13	1
2011	23	2	2312106	8.600456e+07	17195	5001.72	1
2011	31	3	3158102	2.638037e+07	5273	5002.91	1
2011	22	2	2209757	1.433064e+07	2864	5003.71	1
2011	24	2	2405108	3.412964e+07	6820	5004.35	1
2011	31	3	3153905	7.719353e+07	15423	5005.09	1
2011	26	2	2602704	6.295949e+07	12578	5005.52	1
2011	21	2	2110609	1.3404141e+08	26765	5008.09	1
2011	29	2	2908804	2.323527e+07	4638	5009.76	1
2011	24	2	2408607	1.992684e+07	3977	5010.52	1
2011	31	3	3155108	2.612064e+07	5204	5019.34	1
2011	25	2	2506103	5.708405e+07	11368	5021.47	1
2011	22	2	2205516	2.40019e+07	4775	5026.57	1
2011	15	1	1502855	6.279091e+07	12487	5028.5	1
2011	23	2	2307205	3.867768e+07	7691	5028.95	1
2011	25	2	2509800	4.782345e+07	9506	5030.87	1
2011	29	2	2912004	4.947731e+07	9831	5032.79	1
2011	31	3	3118106	2.489958e+07	4947	5033.27	1
2011	15	1	1504901	1.7556259e+08	34875	5034.05	1
2011	29	2	2926707	6.519924e+07	12948	5035.47	1
2011	26	2	2612703	6.606846e+07	13120	5035.71	1
2011	29	2	2921708	1.7747534e+08	35208	5040.77	1
2011	13	1	1301605	1.1602292e+08	23011	5042.06	1
2011	13	1	1303957	5.537192e+07	10978	5043.9	1
2011	22	2	2203602	2.373937e+07	4702	5048.78	1
2011	31	3	3107802	7.726578e+07	15302	5049.39	1
2011	31	3	3153103	2.784471e+07	5514	5049.82	1
2011	24	2	2407252	1.80925e+07	3582	5050.95	1
2011	29	2	2908002	1.0325981e+08	20442	5051.36	1
2011	22	2	2210979	1.334758e+07	2642	5052.07	1
2011	22	2	2205276	2.366222e+07	4683	5052.79	1
2011	29	2	2908606	1.2063019e+08	23866	5054.48	1
2011	23	2	2308302	1.4291466e+08	28259	5057.31	1
2011	29	2	2929354	2.863703e+07	5662	5057.76	1
2011	22	2	2205508	1.8924002e+08	37410	5058.54	1
2011	29	2	2923902	5.405055e+07	10684	5059.02	1
2011	24	2	2413706	2.563318e+07	5064	5061.84	1
2011	23	2	2305209	9.839926e+07	19439	5061.95	1
2011	25	2	2517001	4.712548e+07	9307	5063.45	1
2011	29	2	2931053	8.217212e+07	16228	5063.6	1
2011	24	2	2403202	3.287915e+07	6488	5067.69	1
2011	25	2	2504207	2.441681e+07	4817	5068.88	1
2011	23	2	2300150	7.862556e+07	15509	5069.67	1
2011	25	2	2508802	2.84272e+07	5607	5069.95	1
2011	25	2	2511707	2.603164e+07	5134	5070.44	1
2011	25	2	2509107	1.0759627e+08	21216	5071.47	1
2011	31	3	3125606	3.513e+07	6926	5072.19	1
2011	23	2	2311231	3.122456e+07	6154	5073.86	1
2011	13	1	1300201	7.88788e+07	15545	5074.22	1
2011	29	2	2928059	6.691675e+07	13182	5076.37	1
2011	22	2	2210102	1.874071e+07	3691	5077.41	1
2011	29	2	2912103	1.2142342e+08	23910	5078.35	1
2011	26	2	2606705	3.830956e+07	7542	5079.5	1
2011	25	2	2504157	3.60501e+07	7096	5080.34	1
2011	26	2	2612406	1.139851e+08	22434	5080.91	1
2011	25	2	2502607	3.123072e+07	6145	5082.3	1
2011	29	2	2907202	3.3366092e+08	65647	5082.65	1
2011	31	3	3133907	2.925498e+07	5754	5084.29	1
2011	23	2	2311264	1.0190811e+08	20042	5084.73	1
2011	21	2	2105500	1.2022713e+08	23641	5085.53	1
2011	23	2	2307635	9.331037e+07	18336	5088.92	1
2011	21	2	2108900	9.976192e+07	19592	5091.97	1
2011	25	2	2502300	2.555631e+07	5016	5094.96	1
2011	27	2	2701308	1.0457368e+08	20520	5096.18	1
2011	31	3	3161106	2.7529467e+08	54007	5097.39	1
2011	21	2	2101939	3.086867e+07	6055	5098.05	1
2011	25	2	2502052	1.588124e+07	3115	5098.31	1
2011	23	2	2307403	1.2183972e+08	23898	5098.32	1
2011	26	2	2613206	1.092908e+08	21433	5099.18	1
2011	24	2	2413557	2.325484e+07	4559	5100.86	1
2011	23	2	2313005	9.042767e+07	17718	5103.72	1
2011	26	2	2606309	3.528347e+07	6913	5103.93	1
2011	31	3	3134707	6.202425e+07	12138	5109.92	1
2011	15	1	1504604	1.3909516e+08	27207	5112.48	1
2011	23	2	2311207	5.299129e+07	10364	5113.02	1
2011	31	3	3121803	4.414635e+07	8628	5116.64	1
2011	22	2	2205359	1.513096e+07	2956	5118.73	1
2011	21	2	2102036	1.503703e+08	29374	5119.16	1
2011	26	2	2609907	3.3291115e+08	64944	5126.13	1
2011	24	2	2407005	4.944988e+07	9646	5126.46	1
2011	31	3	3108701	2.359389e+07	4601	5127.99	1
2011	22	2	2200251	3.78407e+07	7378	5128.86	1
2011	21	2	2101731	3.396682e+07	6622	5129.39	1
2011	29	2	2914406	1.1761926e+08	22929	5129.72	1
2011	26	2	2610301	5.670378e+07	11052	5130.63	1
2011	31	3	3166204	5.239998e+07	10210	5132.22	1
2011	25	2	2511004	1.911444e+07	3724	5132.77	1
2011	15	1	1501204	1.9552284e+08	38092	5132.91	1
2011	24	2	2414753	1.979375e+07	3852	5138.56	1
2011	26	2	2613503	1.6799279e+08	32692	5138.65	1
2011	22	2	2207306	2.083292e+07	4054	5138.86	1
2011	22	2	2200202	8.53162e+07	16600	5139.53	1
2011	22	2	2208205	9.130115e+07	17761	5140.54	1
2011	23	2	2306603	9.84797e+07	19152	5142.01	1
2011	24	2	2405405	2.808324e+07	5461	5142.51	1
2011	25	2	2516508	7.722985e+07	15016	5143.17	1
2011	29	2	2933000	1.2836377e+08	24958	5143.19	1
2011	25	2	2501005	9.802622e+07	19054	5144.65	1
2011	29	2	2914505	1.4240433e+08	27643	5151.55	1
2011	26	2	2604304	5.602044e+07	10873	5152.25	1
2011	31	3	3127503	3.060101e+07	5937	5154.29	1
2011	24	2	2400604	2.501267e+07	4847	5160.44	1
2011	25	2	2510303	2.282074e+07	4422	5160.73	1
2011	25	2	2505501	1.828651e+07	3543	5161.31	1
2011	25	2	2507705	8.734699e+07	16923	5161.44	1
2011	23	2	2305407	3.3913501e+08	65682	5163.29	1
2011	24	2	2414704	2.713e+07	5254	5163.69	1
2011	25	2	2515203	1.684574e+07	3262	5164.24	1
2011	29	2	2930303	9.320224e+07	18036	5167.57	1
2011	25	2	2501609	7.386204e+07	14287	5169.88	1
2011	31	3	3145372	2.581112e+07	4991	5171.53	1
2011	31	3	3150802	8.921677e+07	17250	5171.99	1
2011	29	2	2925758	1.2516912e+08	24187	5175.06	1
2011	23	2	2305704	6.234691e+07	12046	5175.74	1
2011	15	1	1507706	1.2063427e+08	23307	5175.88	1
2011	24	2	2410306	4.609628e+07	8904	5177.03	1
2011	25	2	2512747	1.709981e+07	3303	5177.05	1
2011	31	3	3126950	1.73111e+07	3340	5182.96	1
2011	31	3	3157500	2.372879e+07	4576	5185.49	1
2011	24	2	2409308	6.236121e+07	12025	5185.96	1
2011	31	3	3141801	1.599757e+08	30824	5189.97	1
2011	31	3	3152204	1.952055e+08	37607	5190.67	1
2011	24	2	2407302	4.286211e+07	8257	5191	1
2011	26	2	2603405	2.933203e+07	5646	5195.19	1
2011	31	3	3131802	5.5954e+07	10760	5200.19	1
2011	21	2	2103208	3.8626291e+08	74274	5200.51	1
2011	21	2	2105401	3.2785022e+08	63024	5201.99	1
2011	31	3	3152170	5.935104e+07	11408	5202.58	1
2011	22	2	2202083	3.76916e+07	7243	5203.87	1
2011	27	2	2704906	1.883812e+07	3620	5203.9	1
2011	29	2	2925006	1.2855476e+08	24694	5205.91	1
2011	25	2	2513356	1.842508e+07	3539	5206.3	1
2011	23	2	2309300	1.6189345e+08	31090	5207.25	1
2011	23	2	2313252	4.628536e+07	8887	5208.21	1
2011	25	2	2501708	2.941194e+07	5646	5209.34	1
2011	29	2	2918357	1.188422e+08	22812	5209.64	1
2011	24	2	2409803	7.381412e+07	14160	5212.86	1
2011	26	2	2615706	7.819869e+07	14997	5214.29	1
2011	27	2	2701506	4.721477e+07	9046	5219.41	1
2011	25	2	2509404	6.509402e+07	12468	5220.89	1
2011	24	2	2406007	3.063593e+07	5865	5223.52	1
2011	22	2	2210003	1.0292166e+08	19703	5223.65	1
2011	23	2	2302404	2.751484e+08	52667	5224.3	1
2011	29	2	2919702	9.034145e+07	17285	5226.58	1
2011	24	2	2400505	7.050464e+07	13487	5227.6	1
2011	28	2	2802700	4.367352e+07	8354	5227.86	1
2011	25	2	2500205	2.887722e+07	5522	5229.49	1
2011	25	2	2513653	1.370371e+07	2619	5232.42	1
2011	21	2	2102754	5.604781e+07	10710	5233.22	1
2011	31	3	3162708	1.1743132e+08	22420	5237.79	1
2011	31	3	3162609	4.100395e+07	7827	5238.78	1
2011	29	2	2909406	7.138125e+07	13625	5238.99	1
2011	25	2	2506806	9.554133e+07	18235	5239.45	1
2011	29	2	2932101	1.0344822e+08	19728	5243.73	1
2011	27	2	2705309	2.760588e+07	5263	5245.27	1
2011	25	2	2504801	7.954018e+07	15151	5249.83	1
2011	31	3	3132305	6.237958e+07	11879	5251.25	1
2011	23	2	2300705	8.632655e+07	16434	5252.92	1
2011	21	2	2106359	4.084264e+07	7772	5255.1	1
2011	31	3	3169505	3.325995e+07	6329	5255.17	1
2011	13	1	1301506	8.744019e+07	16635	5256.4	1
2011	31	3	3156601	5.225548e+07	9939	5257.62	1
2011	26	2	2604601	1.2869431e+08	24473	5258.62	1
2011	27	2	2702801	6.499088e+07	12352	5261.57	1
2011	17	1	1712405	1.959698e+07	3721	5266.59	1
2011	25	2	2502409	5.754547e+07	10925	5267.32	1
2011	21	2	2110856	5.535009e+07	10507	5267.93	1
2011	25	2	2502904	3.276542e+07	6218	5269.45	1
2011	29	2	2922730	4.013847e+07	7616	5270.28	1
2011	23	2	2304608	3.333432e+07	6322	5272.75	1
2011	15	1	1507805	6.780357e+07	12840	5280.65	1
2011	25	2	2500775	4.097285e+07	7756	5282.73	1
2011	24	2	2406502	7.465627e+07	14131	5283.16	1
2011	26	2	2607307	1.5062645e+08	28510	5283.28	1
2011	23	2	2312601	6.551271e+07	12397	5284.56	1
2011	24	2	2410207	3.894782e+07	7365	5288.23	1
2011	28	2	2805406	1.6527656e+08	31253	5288.34	1
2011	27	2	2705705	1.0812871e+08	20437	5290.83	1
2011	24	2	2404606	6.518283e+07	12319	5291.24	1
2011	13	1	1300300	1.7329507e+08	32733	5294.2	1
2011	15	1	1503705	2.7190696e+08	51341	5296.1	1
2011	29	2	2925253	8.285811e+07	15632	5300.54	1
2011	23	2	2301703	1.3004201e+08	24517	5304.16	1
2011	31	3	3134004	7.66657e+07	14447	5306.69	1
2011	29	2	2901403	7.451582e+07	14032	5310.42	1
2011	24	2	2414803	5.78441e+07	10888	5312.65	1
2011	24	2	2406601	4.049929e+07	7623	5312.78	1
2011	26	2	2601003	5.466699e+07	10288	5313.66	1
2011	25	2	2507408	4.011085e+07	7548	5314.1	1
2011	27	2	2709103	1.0197521e+08	19172	5318.97	1
2011	29	2	2910701	3.0126239e+08	56631	5319.74	1
2011	25	2	2512721	3.083703e+07	5795	5321.32	1
2011	26	2	2604205	2.0399492e+08	38324	5322.9	1
2011	31	3	3163003	2.177061e+07	4089	5324.19	1
2011	31	3	3100500	5.422706e+07	10183	5325.25	1
2011	13	1	1303304	1.1601716e+08	21784	5325.8	1
2011	24	2	2407807	1.1099357e+08	20825	5329.82	1
2011	26	2	2611705	1.0276979e+08	19277	5331.21	1
2011	24	2	2410504	2.520716e+07	4727	5332.59	1
2011	21	2	2112407	1.8214974e+08	34136	5336	1
2011	26	2	2607950	6.132614e+07	11490	5337.35	1
2011	26	2	2600203	9.498325e+07	17784	5340.94	1
2011	15	1	1501709	6.1298219e+08	114720	5343.29	1
2011	25	2	2505303	1.337933e+07	2501	5349.59	1
2011	25	2	2512309	1.1513916e+08	21518	5350.83	1
2011	23	2	2306009	7.369071e+07	13766	5353.1	1
2011	26	2	2615102	3.625299e+07	6771	5354.16	1
2011	24	2	2411007	2.365346e+07	4415	5357.52	1
2011	23	2	2308609	8.966206e+07	16733	5358.4	1
2011	17	1	1720101	2.505953e+07	4675	5360.33	1
2011	23	2	2302701	1.4252635e+08	26579	5362.37	1
2011	29	2	2902401	7.146005e+07	13323	5363.66	1
2011	26	2	2604908	9.300423e+07	17329	5366.97	1
2011	25	2	2508208	3.967497e+07	7392	5367.28	1
2011	24	2	2406205	3.367056e+07	6273	5367.54	1
2011	25	2	2500809	9.209699e+07	17158	5367.58	1
2011	25	2	2504405	9.875482e+07	18397	5367.99	1
2011	17	1	1718303	4.15034e+07	7727	5371.22	1
2011	25	2	2503407	1.920183e+07	3574	5372.64	1
2011	25	2	2512754	2.30436e+07	4289	5372.72	1
2011	15	1	1505494	4.01923e+07	7470	5380.5	2
2011	15	1	1500305	1.909056e+08	35467	5382.63	2
2011	22	2	2201408	3.550496e+07	6594	5384.43	2
2011	31	3	3136959	3.071618e+07	5703	5385.97	2
2011	26	2	2615003	1.3635942e+08	25298	5390.13	2
2011	25	2	2513505	2.85577e+07	5298	5390.28	2
2011	24	2	2412807	4.369507e+07	8105	5391.13	2
2011	26	2	2608305	7.443745e+07	13804	5392.46	2
2011	21	2	2111102	1.3449968e+08	24927	5395.74	2
2011	21	2	2114007	2.7876459e+08	51615	5400.84	2
2011	31	3	3112653	2.687018e+07	4973	5403.21	2
2011	15	1	1504976	8.035343e+07	14859	5407.73	2
2011	25	2	2505006	3.73359e+07	6903	5408.65	2
2011	21	2	2103257	7.477856e+07	13825	5408.94	2
2011	13	1	1303502	9.872867e+07	18249	5410.09	2
2011	21	2	2110708	1.8207724e+08	33650	5410.91	2
2011	25	2	2505105	1.0812037e+08	19981	5411.16	2
2011	26	2	2603504	9.342096e+07	17257	5413.51	2
2011	27	2	2704807	7.314137e+07	13502	5417.08	2
2011	28	2	2801603	3.062966e+07	5653	5418.3	2
2011	24	2	2405009	4.357301e+07	8040	5419.53	2
2011	25	2	2511400	9.889623e+07	18248	5419.57	2
2011	24	2	2410702	1.736653e+07	3204	5420.26	2
2011	31	3	3122108	2.675632e+07	4935	5421.75	2
2011	17	1	1718808	2.13949e+07	3946	5421.92	2
2011	29	2	2911402	8.186705e+07	15096	5423.1	2
2011	26	2	2601607	1.0985703e+08	20257	5423.16	2
2011	13	1	1303106	1.6938296e+08	31232	5423.38	2
2011	31	3	3153301	1.605519e+07	2960	5424.05	2
2011	23	2	2303956	1.0272106e+08	18931	5426.08	2
2011	31	3	3152402	8.539776e+07	15736	5426.9	2
2011	31	3	3119500	4.947504e+07	9116	5427.27	2
2011	25	2	2506400	7.532078e+07	13875	5428.52	2
2011	21	2	2105948	4.219746e+07	7769	5431.52	2
2011	24	2	2406155	1.960588e+07	3609	5432.5	2
2011	26	2	2609303	7.824826e+07	14400	5433.91	2
2011	15	1	1506203	2.050153e+08	37726	5434.32	2
2011	22	2	2211100	2.3300628e+08	42873	5434.8	2
2011	17	1	1703800	5.391045e+07	9916	5436.71	2
2011	29	2	2927804	3.605348e+07	6630	5437.93	2
2011	25	2	2510501	1.990902e+07	3661	5438.14	2
2011	21	2	2101509	9.615616e+07	17681	5438.39	2
2011	15	1	1506005	1.5956181e+08	29337	5438.93	2
2011	25	2	2506202	1.595945e+07	2934	5439.49	2
2011	24	2	2414100	5.420237e+07	9961	5441.46	2
2011	25	2	2507804	3.643288e+07	6695	5441.8	2
2011	25	2	2513208	3.521709e+07	6471	5442.3	2
2011	25	2	2516003	1.443215e+08	26505	5445.07	2
2011	29	2	2928208	1.354685e+08	24871	5446.85	2
2011	26	2	2603801	1.067628e+08	19596	5448.19	2
2011	24	2	2405900	1.417718e+07	2602	5448.57	2
2011	17	1	1707405	5.242089e+07	9619	5449.72	2
2011	24	2	2402907	2.604245e+07	4778	5450.49	2
2011	24	2	2412500	1.2162789e+08	22314	5450.74	2
2011	15	1	1505809	2.9036356e+08	53257	5452.12	2
2011	21	2	2103307	6.4658036e+08	118568	5453.25	2
2011	31	3	3106655	2.399988e+07	4401	5453.28	2
2011	29	2	2916708	4.208094e+07	7715	5454.43	2
2011	31	3	3135803	1.3215261e+08	24226	5454.99	2
2011	29	2	2927507	1.0463874e+08	19180	5455.62	2
2011	17	1	1721109	3.715442e+07	6809	5456.66	2
2011	27	2	2701100	5.74491e+07	10527	5457.31	2
2011	31	3	3170578	3.522745e+07	6455	5457.39	2
2011	31	3	3120151	3.33243e+07	6105	5458.53	2
2011	26	2	2616506	7.714596e+07	14132	5458.96	2
2011	22	2	2203206	5.927543e+07	10857	5459.65	2
2011	15	1	1501758	3.992466e+07	7306	5464.64	2
2011	23	2	2311702	1.055511e+08	19315	5464.72	2
2011	25	2	2512762	2.296969e+07	4201	5467.67	2
2011	17	1	1717800	2.484178e+07	4542	5469.35	2
2011	13	1	1302207	6.086001e+07	11126	5470.07	2
2011	31	3	3125408	2.788527e+07	5097	5470.92	2
2011	31	3	3105202	2.715686e+07	4962	5472.97	2
2011	26	2	2600708	2.0492785e+08	37433	5474.52	2
2011	23	2	2310407	6.205061e+07	11334	5474.73	2
2011	25	2	2515807	3.850649e+07	7031	5476.67	2
2011	29	2	2926103	6.66696e+07	12170	5478.19	2
2011	31	3	3102506	2.751295e+07	5021	5479.58	2
2011	52	5	5200258	8.9589862e+08	163495	5479.67	2
2011	22	2	2210805	6.668936e+07	12166	5481.62	2
2011	31	3	3157377	2.394212e+07	4366	5483.77	2
2011	25	2	2504900	8.861286e+07	16158	5484.15	2
2011	29	2	2901957	4.073709e+07	7428	5484.26	2
2011	21	2	2108603	4.3265708e+08	78876	5485.28	2
2011	29	2	2916906	6.93359e+07	12640	5485.44	2
2011	29	2	2909109	7.826318e+07	14258	5489.07	2
2011	25	2	2517407	1.148896e+07	2093	5489.23	2
2011	29	2	2933174	4.96673e+07	9047	5489.92	2
2011	31	3	3144201	1.733435e+07	3157	5490.77	2
2011	25	2	2513943	1.339766e+07	2438	5495.35	2
2011	15	1	1507508	7.268186e+07	13225	5495.79	2
2011	24	2	2407401	4.539305e+07	8256	5498.19	2
2011	24	2	2403756	1.578483e+07	2870	5499.94	2
2011	24	2	2401859	3.317144e+07	6030	5501.07	2
2011	25	2	2516151	1.769278e+07	3213	5506.62	2
2011	29	2	2908200	1.1356104e+08	20612	5509.46	2
2011	13	1	1304062	2.9416265e+08	53374	5511.35	2
2011	24	2	2410603	1.693722e+07	3072	5513.42	2
2011	25	2	2513307	2.951394e+07	5352	5514.56	2
2011	31	3	3142908	1.2057416e+08	21853	5517.51	2
2011	25	2	2501906	9.457769e+07	17131	5520.85	2
2011	26	2	2613107	1.9554369e+08	35416	5521.34	2
2011	26	2	2610806	1.1595944e+08	20998	5522.4	2
2011	28	2	2804201	7.612387e+07	13784	5522.63	2
2011	31	3	3148509	4.732785e+07	8565	5525.73	2
2011	25	2	2514909	4.271403e+07	7728	5527.18	2
2011	23	2	2309409	1.5233081e+08	27556	5528.05	2
2011	27	2	2705507	1.4857578e+08	26867	5530.05	2
2011	24	2	2413003	3.351921e+07	6059	5532.14	2
2011	25	2	2515005	3.73043e+07	6743	5532.3	2
2011	15	1	1507409	8.369096e+07	15123	5534.02	2
2011	23	2	2305803	2.2381537e+08	40440	5534.5	2
2011	29	2	2902500	7.70462e+07	13919	5535.33	2
2011	29	2	2932705	1.0927849e+08	19738	5536.45	2
2011	29	2	2900355	8.766224e+07	15810	5544.73	2
2011	25	2	2503902	3.199896e+07	5771	5544.79	2
2011	15	1	1502756	1.5955227e+08	28774	5545.02	2
2011	31	3	3151909	4.949316e+07	8920	5548.56	2
2011	25	2	2507309	7.754135e+07	13967	5551.75	2
2011	31	3	3133204	6.594611e+07	11878	5551.95	2
2011	25	2	2501534	2.391773e+07	4301	5560.97	2
2011	24	2	2413508	3.631605e+07	6530	5561.42	2
2011	23	2	2305308	1.3318607e+08	23935	5564.49	2
2011	31	3	3138351	2.676974e+07	4810	5565.43	2
2011	35	3	3513603	1.2131153e+08	21773	5571.65	2
2011	24	2	2410801	2.316054e+07	4153	5576.82	2
2011	31	3	3127339	2.86131e+07	5130	5577.6	2
2011	29	2	2929701	1.0609635e+08	19010	5581.08	2
2011	31	3	3135209	3.6620214e+08	65606	5581.84	2
2011	31	3	3148400	2.738763e+07	4904	5584.75	2
2011	28	2	2805109	4.973037e+07	8903	5585.8	2
2011	35	3	3522653	2.180898e+07	3904	5586.32	2
2011	31	3	3124302	1.7389145e+08	31124	5587.05	2
2011	31	3	3126752	3.213678e+07	5752	5587.06	2
2011	31	3	3170529	7.77227e+07	13911	5587.14	2
2011	25	2	2512705	9.945202e+07	17786	5591.59	2
2011	27	2	2705606	6.814827e+07	12184	5593.26	2
2011	25	2	2513984	1.878165e+07	3357	5594.77	2
2011	13	1	1300631	8.859443e+07	15828	5597.32	2
2011	29	2	2908903	1.2467488e+08	22273	5597.58	2
2011	22	2	2209401	3.399471e+07	6073	5597.68	2
2011	29	2	2925105	2.5037726e+08	44723	5598.4	2
2011	29	2	2906303	1.7997195e+08	32116	5603.81	2
2011	29	2	2923803	1.5619037e+08	27870	5604.25	2
2011	31	3	3121001	2.928631e+07	5225	5605.04	2
2011	25	2	2515500	7.309287e+07	13038	5606.14	2
2011	25	2	2508406	1.581272e+07	2820	5607.35	2
2011	29	2	2920205	8.995644e+07	16037	5609.31	2
2011	29	2	2922409	1.2082003e+08	21530	5611.71	2
2011	17	1	1720804	5.121603e+07	9122	5614.56	2
2011	26	2	2614105	1.9065119e+08	33951	5615.48	2
2011	25	2	2503100	2.860708e+07	5093	5616.94	2
2011	25	2	2513968	1.620455e+07	2883	5620.72	2
2011	25	2	2501104	1.3301637e+08	23653	5623.66	2
2011	25	2	2504074	2.208076e+07	3925	5625.67	2
2011	24	2	2400406	1.691561e+07	3004	5631.03	2
2011	31	3	3121704	2.163137e+07	3839	5634.64	2
2011	31	3	3138906	3.934643e+07	6981	5636.22	2
2011	31	3	3118809	1.4686766e+08	26057	5636.4	2
2011	21	2	2110005	4.2013671e+08	74501	5639.34	2
2011	24	2	2411908	2.202773e+07	3905	5640.9	2
2011	25	2	2504504	3.71866e+07	6591	5642.03	2
2011	25	2	2505279	2.934819e+07	5201	5642.8	2
2011	21	2	2111201	9.3362944e+08	165418	5644.06	2
2011	27	2	2700508	8.156943e+07	14451	5644.55	2
2011	23	2	2309201	8.143021e+07	14424	5645.47	2
2011	31	3	3150539	2.522035e+07	4467	5645.92	2
2011	24	2	2411700	2.233938e+07	3956	5646.96	2
2011	25	2	2510907	6.681153e+07	11829	5648.11	2
2011	31	3	3139300	1.1098315e+08	19649	5648.28	2
2011	29	2	2927200	1.692897e+08	29950	5652.41	2
2011	23	2	2311355	8.46305e+07	14955	5659.01	2
2011	29	2	2912301	8.959896e+07	15830	5660.07	2
2011	29	2	2918704	2.187807e+07	3865	5660.56	2
2011	27	2	2700805	2.517301e+07	4446	5661.95	2
2011	31	3	3119906	2.10912e+07	3723	5665.11	2
2011	23	2	2306702	1.0115027e+08	17851	5666.36	2
2011	25	2	2516300	9.146384e+07	16139	5667.26	2
2011	24	2	2406809	2.617969e+07	4619	5667.83	2
2011	28	2	2806404	4.033794e+07	7108	5675.01	2
2011	25	2	2503803	3.220074e+07	5674	5675.14	2
2011	52	5	5215231	5.484924e+08	96603	5677.8	2
2011	13	1	1302900	3.0198681e+08	53173	5679.33	2
2011	22	2	2202307	1.1473579e+08	20201	5679.71	2
2011	25	2	2515609	1.810801e+07	3187	5681.84	2
2011	26	2	2600302	1.3007409e+08	22882	5684.56	2
2011	31	3	3117009	4.637353e+07	8152	5688.61	2
2011	24	2	2411502	1.2737366e+08	22378	5691.91	2
2011	31	3	3157336	4.51331e+07	7929	5692.15	2
2011	27	2	2700904	4.009467e+07	7043	5692.84	2
2011	23	2	2310100	6.929383e+07	12170	5693.82	2
2011	25	2	2508307	1.4828327e+08	26035	5695.54	2
2011	25	2	2514701	2.289294e+07	4019	5696.18	2
2011	28	2	2804706	3.563895e+07	6255	5697.67	2
2011	29	2	2917607	2.9257569e+08	51328	5700.12	2
2011	24	2	2410900	4.086158e+07	7168	5700.55	2
2011	15	1	1503200	2.0618684e+08	36155	5702.86	2
2011	17	1	1703891	2.124592e+07	3725	5703.6	2
2011	24	2	2403806	5.110063e+07	8958	5704.47	2
2011	31	3	3104452	2.746345e+07	4810	5709.66	2
2011	24	2	2407500	6.072165e+07	10629	5712.83	2
2011	29	2	2914000	3.380474e+08	59169	5713.25	2
2011	26	2	2613602	1.8292018e+08	32011	5714.29	2
2011	31	3	3169109	3.318711e+07	5806	5716	2
2011	13	1	1300029	8.141795e+07	14237	5718.76	2
2011	25	2	2500700	1.0409483e+08	18199	5719.81	2
2011	31	3	3122504	2.971181e+07	5189	5725.92	2
2011	29	2	2917805	9.570547e+07	16701	5730.52	2
2011	29	2	2919058	4.771597e+07	8326	5730.96	2
2011	26	2	2607604	1.2818901e+08	22347	5736.3	2
2011	31	3	3158201	8.260773e+07	14399	5737.05	2
2011	29	2	2929107	1.1666687e+08	20317	5742.33	2
2011	52	5	5221080	1.751516e+07	3050	5742.67	2
2011	31	3	3171907	3.230565e+07	5624	5744.25	2
2011	28	2	2802403	6.553751e+07	11409	5744.37	2
2011	31	3	3161601	2.494612e+07	4341	5746.63	2
2011	24	2	2409704	4.088064e+07	7107	5752.17	2
2011	24	2	2401305	5.358719e+07	9310	5755.87	2
2011	22	2	2211308	1.1720754e+08	20360	5756.76	2
2011	25	2	2503605	4.153691e+07	7212	5759.42	2
2011	25	2	2500734	1.211897e+07	2104	5759.97	2
2011	31	3	3106606	2.594544e+07	4503	5761.81	2
2011	29	2	2928000	1.9628062e+08	34060	5762.79	2
2011	29	2	2925402	5.443967e+07	9444	5764.47	2
2011	23	2	2302800	4.3169864e+08	74847	5767.75	2
2011	31	3	3126901	5.178873e+07	8978	5768.4	2
2011	26	2	2616001	9.374313e+07	16251	5768.45	2
2011	26	2	2600609	7.993288e+07	13853	5770.08	2
2011	15	1	1503804	3.0139121e+08	52191	5774.77	2
2011	31	3	3139201	1.0827057e+08	18740	5777.51	2
2011	31	3	3163409	3.240426e+07	5608	5778.22	2
2011	25	2	2500304	1.6428084e+08	28427	5779.04	2
2011	23	2	2304509	7.560433e+07	13080	5780.15	2
2011	29	2	2910776	3.572801e+07	6181	5780.3	2
2011	29	2	2919009	2.258997e+07	3908	5780.44	2
2011	31	3	3122454	5.30302e+07	9166	5785.53	2
2011	31	3	3113107	1.894214e+07	3274	5785.63	2
2011	29	2	2900900	3.613958e+07	6242	5789.74	2
2011	29	2	2902203	5.854661e+07	10111	5790.39	2
2011	22	2	2208403	3.5882171e+08	61963	5790.9	2
2011	29	2	2911600	1.1510483e+08	19873	5792.02	2
2011	26	2	2603108	1.0982583e+08	18956	5793.72	2
2011	35	3	3543501	3.52646e+07	6085	5795.33	2
2011	25	2	2504033	3.309902e+07	5711	5795.66	2
2011	28	2	2805604	1.5800065e+08	27260	5796.06	2
2011	17	1	1720309	2.511272e+07	4331	5798.37	2
2011	31	3	3155603	1.6961648e+08	29242	5800.44	2
2011	25	2	2502201	1.401966e+07	2416	5802.84	2
2011	31	3	3111150	2.14352e+07	3693	5804.28	2
2011	21	2	2111052	6.297335e+07	10849	5804.53	2
2011	25	2	2507200	5.960937e+07	10265	5807.05	2
2011	31	3	3167707	3.366013e+07	5796	5807.48	2
2011	26	2	2608453	9.414682e+07	16211	5807.59	2
2011	31	3	3108602	1.8184459e+08	31286	5812.33	2
2011	24	2	2404903	3.250582e+07	5587	5818.12	2
2011	26	2	2607505	1.5255164e+08	26215	5819.25	2
2011	28	2	2805505	1.2900864e+08	22138	5827.47	2
2011	29	2	2926301	1.9364886e+08	33222	5828.93	2
2011	31	3	3154101	6.009879e+07	10308	5830.31	2
2011	24	2	2413409	4.543764e+07	7788	5834.31	2
2011	23	2	2310852	1.1067769e+08	18970	5834.35	2
2011	29	2	2922300	1.6874362e+08	28922	5834.44	2
2011	35	3	3540853	1.732417e+07	2968	5836.98	2
2011	29	2	2915106	7.550598e+07	12926	5841.4	2
2011	24	2	2401503	2.305868e+07	3947	5842.08	2
2011	27	2	2701902	4.174861e+07	7146	5842.23	2
2011	24	2	2412104	3.470398e+07	5940	5842.42	2
2011	27	2	2701407	3.0137828e+08	51584	5842.48	2
2011	31	3	3115458	3.892729e+07	6661	5844.06	2
2011	31	3	3134301	3.57674e+07	6120	5844.35	2
2011	52	5	5219753	3.7482626e+08	64120	5845.7	2
2011	24	2	2406700	6.114195e+07	10457	5846.99	2
2011	31	3	3121407	4.103037e+07	7017	5847.28	2
2011	26	2	2615904	4.644374e+07	7938	5850.81	2
2011	35	3	3504701	2.277139e+07	3886	5859.85	2
2011	26	2	2609006	1.4085942e+08	24035	5860.6	2
2011	25	2	2511905	1.0125285e+08	17262	5865.65	2
2011	31	3	3141504	3.716425e+07	6335	5866.5	2
2011	31	3	3130655	4.296221e+07	7323	5866.75	2
2011	24	2	2408706	2.254473e+07	3842	5867.97	2
2011	17	1	1718758	3.677549e+07	6267	5868.12	2
2011	29	2	2919504	2.5301805e+08	43110	5869.13	2
2011	25	2	2514503	1.1263697e+08	19190	5869.57	2
2011	29	2	2912707	1.3308096e+08	22641	5877.87	2
2011	15	1	1507201	1.7654626e+08	30034	5878.21	2
2011	24	2	2414159	3.224797e+07	5483	5881.45	2
2011	31	3	3163508	3.844524e+07	6535	5882.98	2
2011	17	1	1712801	1.869849e+07	3178	5883.73	2
2011	29	2	2918308	8.057273e+07	13691	5885.09	2
2011	25	2	2513927	2.460741e+07	4181	5885.53	2
2011	23	2	2309508	1.257095e+08	21341	5890.52	2
2011	29	2	2922607	7.449775e+07	12632	5897.54	2
2011	31	3	3112059	2.492436e+07	4223	5902.05	2
2011	31	3	3135605	4.693506e+07	7948	5905.27	2
2011	24	2	2401602	3.040021e+07	5145	5908.69	2
2011	24	2	2414001	8.469301e+07	14333	5908.95	2
2011	26	2	2609105	8.190048e+07	13857	5910.4	2
2011	28	2	2805802	1.1469672e+08	19401	5911.9	2
2011	31	3	3143807	3.68185e+07	6227	5912.72	2
2011	29	2	2920908	8.591983e+07	14520	5917.34	2
2011	31	3	3104700	8.456383e+07	14280	5921.84	2
2011	25	2	2516706	8.441649e+07	14255	5921.89	2
2011	29	2	2915809	1.3521572e+08	22828	5923.24	2
2011	17	1	1703008	6.186781e+07	10432	5930.58	2
2011	24	2	2404002	2.495215e+07	4207	5931.1	2
2011	31	3	3103405	2.1374821e+08	36037	5931.35	2
2011	26	2	2610400	1.2058177e+08	20327	5932.1	2
2011	24	2	2402709	6.48314e+07	10922	5935.85	2
2011	23	2	2312304	2.6424799e+08	44507	5937.22	2
2011	15	1	1503408	6.071257e+07	10218	5941.73	2
2011	31	3	3127354	1.769419e+07	2977	5943.63	2
2011	31	3	3164100	3.288272e+07	5531	5945.17	2
2011	25	2	2507101	1.0214575e+08	17179	5945.97	2
2011	31	3	3100609	8.9193e+07	14996	5947.79	2
2011	15	1	1507151	1.3906578e+08	23370	5950.61	2
2011	31	3	3146255	3.501911e+07	5881	5954.62	2
2011	25	2	2501500	1.2982137e+08	21801	5954.84	2
2011	25	2	2501401	4.843008e+07	8130	5956.96	2
2011	31	3	3140308	2.388947e+07	4010	5957.47	2
2011	21	2	2105427	1.4896483e+08	24997	5959.31	2
2011	31	3	3108503	3.857694e+07	6472	5960.59	2
2011	31	3	3123858	3.094722e+07	5185	5968.61	2
2011	27	2	2701704	1.0119113e+08	16953	5968.92	2
2011	24	2	2410405	5.096059e+07	8537	5969.38	2
2011	15	1	1507953	4.9229163e+08	82434	5971.95	2
2011	24	2	2414456	2.000752e+07	3347	5977.75	2
2011	23	2	2313500	3.1070452e+08	51952	5980.61	2
2011	25	2	2501153	1.144769e+07	1914	5981.03	2
2011	31	3	3140605	2.737334e+07	4576	5981.94	2
2011	25	2	2513802	2.735641e+07	4570	5986.09	2
2011	31	3	3161650	2.119038e+07	3534	5996.15	2
2011	13	1	1300805	2.1285095e+08	35448	6004.6	2
2011	35	3	3521200	2.569915e+07	4279	6005.88	2
2011	22	2	2210623	2.112849e+07	3517	6007.53	2
2011	21	2	2109551	4.438201e+07	7382	6012.19	2
2011	29	2	2931707	7.695256e+07	12798	6012.86	2
2011	26	2	2613305	1.2357559e+08	20538	6016.92	2
2011	31	3	3120300	3.474553e+07	5774	6017.58	2
2011	29	2	2921302	6.654378e+07	11057	6018.25	2
2011	15	1	1507003	1.6369187e+08	27199	6018.3	2
2011	15	1	1505205	1.7459668e+08	29005	6019.54	2
2011	29	2	2922250	6.234335e+07	10354	6021.19	2
2011	29	2	2910404	1.44342e+08	23968	6022.28	2
2011	21	2	2104800	3.8070391e+08	63203	6023.51	2
2011	22	2	2203404	3.9858e+07	6617	6023.58	2
2011	29	2	2919306	6.312831e+07	10480	6023.69	2
2011	25	2	2509057	4.648876e+07	7717	6024.2	2
2011	24	2	2409332	2.915413e+07	4838	6026.07	2
2011	25	2	2505238	3.741062e+07	6208	6026.2	2
2011	25	2	2504702	2.826466e+07	4690	6026.58	2
2011	31	3	3140100	2.535842e+07	4204	6031.98	2
2011	27	2	2706505	8.917273e+07	14783	6032.11	2
2011	29	2	2906006	4.040874e+08	66967	6034.13	2
2011	21	2	2110302	8.626434e+07	14291	6036.27	2
2011	29	2	2901007	2.0898403e+08	34602	6039.65	2
2011	31	3	3107208	3.025308e+07	5009	6039.74	2
2011	15	1	1504950	1.2243842e+08	20256	6044.55	2
2011	24	2	2411106	2.169839e+07	3589	6045.8	2
2011	25	2	2507903	6.217712e+07	10283	6046.59	2
2011	26	2	2608404	8.835146e+07	14603	6050.23	2
2011	25	2	2515930	2.703253e+07	4468	6050.25	2
2011	17	1	1714302	2.61897e+07	4328	6051.23	2
2011	29	2	2922508	1.656087e+08	27366	6051.62	2
2011	31	3	3123304	2.68698e+07	4437	6055.85	2
2011	13	1	1302108	4.474346e+07	7388	6056.23	2
2011	24	2	2412708	3.751442e+07	6194	6056.57	2
2011	25	2	2511301	9.394624e+07	15511	6056.75	2
2011	31	3	3116506	4.690695e+07	7743	6057.98	2
2011	21	2	2105658	2.366725e+07	3904	6062.31	2
2011	27	2	2709400	1.5367895e+08	25342	6064.2	2
2011	29	2	2900306	8.91312e+07	14692	6066.65	2
2011	31	3	3117405	2.70781e+07	4463	6067.24	2
2011	27	2	2703403	3.251294e+07	5357	6069.24	2
2011	17	1	1711951	2.186397e+07	3602	6069.95	2
2011	24	2	2409100	6.872342e+07	11313	6074.73	2
2011	31	3	3122801	1.817244e+07	2991	6075.71	2
2011	25	2	2515971	4.502852e+07	7411	6075.9	2
2011	15	1	1503093	1.8860779e+08	31031	6078.04	2
2011	29	2	2918803	1.3644476e+08	22444	6079.34	2
2011	31	3	3142700	9.572666e+07	15745	6079.81	2
2011	15	1	1507300	5.8185505e+08	95694	6080.37	2
2011	31	3	3106804	2.281116e+07	3748	6086.22	2
2011	15	1	1501576	9.417051e+07	15467	6088.48	2
2011	25	2	2512507	2.5145626e+08	41298	6088.82	2
2011	21	2	2107258	3.020922e+07	4961	6089.34	2
2011	28	2	2806206	1.1816721e+08	19403	6090.15	2
2011	31	3	3100906	1.1286887e+08	18528	6091.8	2
2011	25	2	2501351	2.172759e+07	3566	6092.99	2
2011	27	2	2701357	4.04031e+07	6627	6096.74	2
2011	31	3	3122603	2.758288e+07	4523	6098.36	2
2011	25	2	2513851	1.601531e+07	2626	6098.75	2
2011	31	3	3161056	2.060343e+07	3377	6101.11	2
2011	29	2	2916807	1.1387551e+08	18664	6101.35	2
2011	26	2	2606606	1.6585324e+08	27155	6107.65	2
2011	23	2	2313302	3.4214005e+08	56017	6107.79	2
2011	31	3	3137908	2.102798e+07	3442	6109.23	2
2011	29	2	2905008	1.3684102e+08	22396	6110.06	2
2011	23	2	2301851	1.0638617e+08	17403	6113.09	2
2011	31	3	3124104	3.7464968e+08	61283	6113.44	2
2011	23	2	2312205	2.61952e+08	42793	6121.38	2
2011	24	2	2403905	1.754735e+07	2863	6129.01	2
2011	26	2	2610905	3.8813496e+08	63320	6129.74	2
2011	24	2	2408409	2.626545e+07	4283	6132.49	2
2011	13	1	1300706	1.8956544e+08	30906	6133.61	2
2011	27	2	2700201	1.0669914e+08	17392	6134.95	2
2011	31	3	3152131	2.449081e+07	3991	6136.51	2
2011	26	2	2603454	8.9401505e+08	145676	6137.01	2
2011	23	2	2304459	9.22452e+07	15029	6137.81	2
2011	31	3	3148806	2.040985e+07	3323	6142	2
2011	31	3	3105707	3.706961e+07	6035	6142.44	2
2011	29	2	2931004	1.2292527e+08	20007	6144.11	2
2011	31	3	3115706	4.173406e+07	6790	6146.4	2
2011	26	2	2609709	1.4099078e+08	22938	6146.6	2
2011	24	2	2405504	1.600038e+07	2603	6146.9	2
2011	26	2	2601409	2.512068e+08	40855	6148.74	2
2011	25	2	2504108	1.482399e+07	2410	6151.03	2
2011	29	2	2902807	1.2907701e+08	20974	6154.14	2
2011	23	2	2308401	2.1189697e+08	34404	6159.08	2
2011	31	3	3123809	4.39022e+07	7125	6161.71	2
2011	22	2	2205904	3.216704e+07	5218	6164.63	2
2011	24	2	2401909	2.060681e+07	3342	6166.01	2
2011	31	3	3141009	7.800525e+07	12646	6168.37	2
2011	25	2	2506509	1.968646e+07	3188	6175.17	2
2011	26	2	2600906	1.3580517e+08	21988	6176.33	2
2011	31	3	3168051	1.934525e+07	3131	6178.62	2
2011	15	1	1505403	1.0172719e+08	16458	6181.02	2
2011	29	2	2925956	1.4160648e+08	22896	6184.77	2
2011	24	2	2412559	5.414856e+07	8754	6185.58	2
2011	31	3	3168408	8.835685e+07	14279	6187.89	2
2011	23	2	2301406	7.095358e+07	11466	6188.17	2
2011	24	2	2406106	1.0968374e+08	17721	6189.48	2
2011	17	1	1720002	1.532594e+07	2476	6189.8	2
2011	29	2	2911907	1.5803698e+08	25524	6191.7	2
2011	23	2	2312502	4.857746e+07	7843	6193.73	2
2011	21	2	2102804	1.4850388e+08	23957	6198.77	2
2011	17	1	1718006	1.752599e+07	2827	6199.5	2
2011	13	1	1302306	1.1256096e+08	18145	6203.41	2
2011	26	2	2607109	2.787508e+07	4491	6206.88	2
2011	21	2	2106102	7.135678e+07	11495	6207.64	2
2011	31	3	3144359	3.97176e+07	6398	6207.82	2
2011	26	2	2608800	2.2951469e+08	36968	6208.47	2
2011	22	2	2201705	3.313486e+07	5335	6210.85	2
2011	25	2	2516904	9.10207e+07	14654	6211.32	2
2011	23	2	2308351	8.124174e+07	13074	6213.99	2
2011	29	2	2909901	2.0136941e+08	32403	6214.53	2
2011	29	2	2928109	2.5017762e+08	40236	6217.76	2
2011	26	2	2605004	1.4599846e+08	23468	6221.17	2
2011	24	2	2409209	1.810909e+07	2910	6223.06	2
2011	35	3	3540754	1.2355482e+08	19842	6226.93	2
2011	28	2	2807501	8.007206e+07	12857	6227.9	2
2011	22	2	2207009	2.2289404e+08	35788	6228.18	2
2011	22	2	2211605	1.889473e+07	3033	6229.72	2
2011	24	2	2408953	6.310115e+07	10124	6232.83	2
2011	29	2	2910750	1.0972275e+08	17603	6233.18	2
2011	25	2	2506905	1.5232354e+08	24426	6236.12	2
2011	13	1	1304260	7.498535e+07	12017	6239.94	2
2011	52	5	5203962	2.070113e+07	3317	6240.92	2
2011	17	1	1702901	5.81166e+07	9310	6242.38	2
2011	24	2	2408508	2.936845e+07	4702	6245.95	2
2011	23	2	2307254	1.0857021e+08	17380	6246.85	2
2011	25	2	2511608	4.321753e+07	6915	6249.82	2
2011	23	2	2304103	4.5613177e+08	72959	6251.89	2
2011	23	2	2305001	2.3768427e+08	37986	6257.15	2
2011	26	2	2601102	4.8686751e+08	77794	6258.42	2
2011	29	2	2929909	2.6282652e+08	41984	6260.16	2
2011	23	2	2305605	1.603834e+08	25597	6265.71	2
2011	24	2	2413607	3.635906e+07	5801	6267.72	2
2011	28	2	2802502	1.86268e+07	2970	6271.65	2
2011	26	2	2600401	2.0977433e+08	33446	6272.03	2
2011	31	3	3167103	1.3061079e+08	20822	6272.73	2
2011	31	3	3102852	5.047655e+07	8045	6274.28	2
2011	29	2	2931400	4.90893e+07	7820	6277.4	2
2011	51	5	5100508	6.391507e+07	10180	6278.49	2
2011	21	2	2112209	9.8929725e+08	157438	6283.73	2
2011	31	3	3152303	6.593131e+07	10490	6285.16	2
2011	23	2	2306553	2.3899014e+08	38018	6286.24	2
2011	28	2	2803005	2.4636116e+08	39176	6288.57	2
2011	23	2	2303659	6.292475e+07	10004	6289.96	2
2011	31	3	3156809	9.850913e+07	15661	6290.09	2
2011	31	3	3166006	3.579128e+07	5687	6293.53	2
2011	29	2	2911808	1.3853442e+08	22000	6297.02	2
2011	27	2	2708006	2.8463886e+08	45197	6297.74	2
2011	25	2	2505907	2.102373e+07	3337	6300.19	2
2011	26	2	2604502	1.2794635e+08	20270	6312.1	2
2011	12	1	1200302	2.0506471e+08	32487	6312.21	2
2011	31	3	3164209	6.611067e+07	10468	6315.5	2
2011	31	3	3159100	2.408233e+07	3813	6315.85	2
2011	31	3	3162252	2.953869e+07	4676	6317.09	2
2011	31	3	3112208	2.998306e+07	4739	6326.87	2
2011	28	2	2802205	3.383773e+07	5344	6331.91	2
2011	31	3	3129608	4.995746e+07	7885	6335.76	2
2011	13	1	1301407	1.9656617e+08	31020	6336.76	2
2011	24	2	2414506	6.741428e+07	10626	6344.28	2
2011	29	2	2908408	3.9719984e+08	62545	6350.63	2
2011	29	2	2917334	6.942733e+07	10932	6350.83	2
2011	31	3	3100401	2.491466e+07	3923	6350.92	2
2011	21	2	2110039	1.4522777e+08	22843	6357.65	2
2011	31	3	3101805	4.572623e+07	7188	6361.47	2
2011	24	2	2414308	1.466471e+07	2304	6364.89	2
2011	35	3	3554656	1.44043e+07	2263	6365.13	2
2011	28	2	2807402	3.0817925e+08	48414	6365.5	2
2011	29	2	2915403	4.594197e+07	7212	6370.21	2
2011	17	1	1702208	2.0226833e+08	31738	6373.06	2
2011	31	3	3165701	4.641168e+07	7279	6376.11	2
2011	29	2	2929404	6.670192e+07	10445	6386.01	2
2011	31	3	3113503	5.853902e+07	9162	6389.33	2
2011	26	2	2602100	2.9234957e+08	45747	6390.57	2
2011	21	2	2109106	2.8867656e+08	45155	6393.01	2
2011	31	3	3132008	3.213531e+07	5022	6398.91	2
2011	25	2	2512077	2.567911e+07	4013	6398.98	2
2011	31	3	3162807	9.956287e+07	15556	6400.29	2
2011	25	2	2503753	1.950994e+07	3048	6400.9	2
2011	13	1	1301704	2.8871467e+08	45105	6400.95	2
2011	31	3	3132800	1.447719e+07	2261	6403	2
2011	15	1	1500859	1.37034e+08	21398	6404.06	2
2011	25	2	2511103	4.831948e+07	7541	6407.57	2
2011	12	1	1200393	6.055409e+07	9448	6409.2	2
2011	26	2	2611804	2.8672225e+08	44728	6410.35	2
2011	31	3	3165909	2.903768e+07	4527	6414.33	2
2011	28	2	2807006	2.385572e+07	3718	6416.28	2
2011	31	3	3165560	1.811674e+07	2823	6417.55	2
2011	26	2	2611507	1.5623832e+08	24343	6418.2	2
2011	31	3	3157609	2.535924e+07	3951	6418.43	2
2011	50	5	5004809	5.042339e+07	7854	6420.09	2
2011	29	2	2906873	1.7223036e+08	26826	6420.28	2
2011	27	2	2706448	7.44831e+07	11601	6420.4	2
2011	23	2	2308104	2.8613837e+08	44543	6423.87	2
2011	23	2	2307809	1.6088041e+08	25032	6426.99	2
2011	31	3	3165503	3.638142e+07	5657	6431.22	2
2011	13	1	1302405	2.4687084e+08	38373	6433.45	2
2011	31	3	3126802	3.778448e+07	5872	6434.69	2
2011	31	3	3132107	1.1421214e+08	17741	6437.75	2
2011	29	2	2926608	3.0709277e+08	47701	6437.87	2
2011	31	3	3120003	1.989531e+07	3088	6442.78	2
2011	17	1	1703826	1.390833e+07	2158	6445.01	2
2011	31	3	3146701	4.218334e+07	6544	6446.11	2
2011	31	3	3102209	2.827291e+07	4386	6446.17	2
2011	27	2	2705200	1.0301687e+08	15966	6452.27	2
2011	15	1	1505064	4.1040196e+08	63604	6452.46	2
2011	21	2	2101202	6.4942048e+08	100615	6454.51	2
2011	29	2	2901700	7.458731e+07	11549	6458.33	2
2011	31	3	3125002	2.434268e+07	3765	6465.52	2
2011	12	1	1200351	9.495569e+07	14683	6467.05	2
2011	17	1	1715002	2.467364e+07	3815	6467.53	2
2011	52	5	5212709	4.546406e+07	7028	6468.99	2
2011	35	3	3516309	1.00986098e+09	156064	6470.81	2
2011	15	1	1505486	2.6438421e+08	40831	6475.09	2
2011	31	3	3123700	6.70307e+07	10352	6475.14	2
2011	29	2	2905602	2.0421361e+08	31505	6481.94	2
2011	17	1	1701051	2.073677e+07	3197	6486.32	2
2011	31	3	3145877	4.767605e+07	7348	6488.3	2
2011	15	1	1506708	3.7677696e+08	58067	6488.66	2
2011	22	2	2210607	2.1250676e+08	32745	6489.75	2
2011	31	3	3119203	6.64199e+07	10230	6492.66	2
2011	24	2	2413805	1.519812e+07	2340	6494.92	2
2011	23	2	2313955	1.1477027e+08	17670	6495.21	2
2011	31	3	3150000	2.685786e+07	4135	6495.25	2
2011	22	2	2206308	8.08692e+06	1245	6495.52	2
2011	23	2	2313104	1.9076524e+08	29366	6496.13	2
2011	29	2	2927309	8.898853e+07	13693	6498.83	2
2011	31	3	3158409	2.367925e+07	3643	6499.93	2
2011	31	3	3114808	2.953646e+07	4543	6501.53	2
2011	25	2	2505808	2.358969e+07	3625	6507.5	2
2011	15	1	1505106	3.2274545e+08	49552	6513.27	2
2011	24	2	2407906	1.459907e+07	2240	6517.44	2
2011	29	2	2933455	8.098591e+07	12420	6520.6	2
2011	31	3	3170057	7.870745e+07	12068	6522	2
2011	31	3	3157252	5.036581e+07	7719	6524.91	2
2011	27	2	2707404	5.41741e+07	8291	6534.09	2
2011	26	2	2615508	8.565693e+07	13106	6535.7	2
2011	22	2	2202208	2.9637504e+08	45338	6537.01	2
2011	29	2	2929750	7.373707e+07	11279	6537.55	2
2011	29	2	2900603	2.987758e+07	4569	6539.2	2
2011	31	3	3140159	8.767351e+07	13396	6544.75	2
2011	17	1	1717909	4.751129e+07	7258	6546.06	2
2011	25	2	2514008	2.834324e+07	4329	6547.3	2
2011	13	1	1301001	1.6994463e+08	25955	6547.66	2
2011	24	2	2404705	9.170275e+07	14005	6547.86	2
2011	26	2	2602308	2.4593837e+08	37552	6549.27	2
2011	31	3	3163300	2.510748e+07	3832	6552.06	2
2011	25	2	2504850	1.170898e+07	1787	6552.31	2
2011	31	3	3125804	2.009354e+07	3066	6553.67	2
2011	31	3	3103306	1.34785e+07	2056	6555.69	2
2011	31	3	3135076	3.347828e+07	5094	6572.1	2
2011	25	2	2502706	3.378956e+07	5141	6572.57	2
2011	28	2	2803708	4.237661e+07	6447	6573.07	2
2011	25	2	2502508	1.1159552e+08	16967	6577.21	2
2011	24	2	2414902	1.069497e+07	1626	6577.47	2
2011	25	2	2513406	9.718126e+07	14774	6577.86	2
2011	29	2	2931301	1.0839813e+08	16475	6579.55	2
2011	52	5	5206701	2.166387e+07	3292	6580.76	2
2011	17	1	1718659	1.154931e+07	1755	6580.8	2
2011	25	2	2510600	1.934046e+07	2937	6585.11	2
2011	26	2	2609402	3.773776e+08	57271	6589.33	2
2011	27	2	2707008	1.886207e+07	2862	6590.52	2
2011	23	2	2302602	3.9915749e+08	60520	6595.46	2
2011	24	2	2400109	7.27375e+07	11024	6598.1	2
2011	31	3	3157401	3.27489e+07	4963	6598.61	2
2011	21	2	2111763	9.602583e+07	14550	6599.71	2
2011	24	2	2405207	3.516289e+07	5326	6602.12	2
2011	26	2	2600104	2.3280604e+08	35255	6603.49	2
2011	31	3	3139904	9.374196e+07	14186	6608.06	2
2011	17	1	1704105	1.716134e+07	2597	6608.14	2
2011	31	3	3125903	7.08609e+07	10723	6608.31	2
2011	28	2	2801900	2.531526e+07	3826	6616.64	2
2011	29	2	2911204	2.0251762e+08	30580	6622.55	2
2011	31	3	3125507	2.029622e+07	3064	6624.09	2
2011	29	2	2920700	1.2694071e+08	19158	6625.99	2
2011	27	2	2700102	1.2880457e+08	19433	6628.14	2
2011	21	2	2103802	1.5074262e+08	22737	6629.84	2
2011	29	2	2915908	5.034908e+07	7594	6630.11	2
2011	28	2	2803104	3.289602e+07	4957	6636.28	2
2011	52	5	5205497	3.7924379e+08	57108	6640.82	2
2011	25	2	2503308	6.392525e+07	9617	6647.11	2
2011	23	2	2310258	2.0216816e+08	30393	6651.8	2
2011	29	2	2907301	1.6952141e+08	25483	6652.33	2
2011	31	3	3136801	2.747949e+07	4130	6653.63	2
2011	25	2	2509701	2.0698019e+08	31095	6656.38	2
2011	24	2	2414407	2.0860721e+08	31336	6657.11	2
2011	25	2	2514404	3.151613e+07	4734	6657.4	2
2011	31	3	3134608	1.159606e+08	17411	6660.19	2
2011	23	2	2302107	2.2388254e+08	33597	6663.77	2
2011	31	3	3160207	2.73309e+07	4101	6664.45	2
2011	25	2	2512606	1.153222e+07	1730	6666.02	2
2011	25	2	2512101	2.1415257e+08	32122	6666.85	2
2011	23	2	2300200	3.8816811e+08	58210	6668.41	2
2011	15	1	1504802	3.7113788e+08	55636	6670.82	2
2011	23	2	2306256	2.4237476e+08	36324	6672.58	2
2011	31	3	3102704	6.009006e+07	8993	6681.87	2
2011	31	3	3148608	1.1541003e+08	17266	6684.24	2
2011	29	2	2902252	6.918416e+07	10349	6685.11	2
2011	31	3	3143708	2.256118e+07	3374	6686.77	2
2011	13	1	1301951	5.35689e+07	8010	6687.75	2
2011	24	2	2409605	1.720277e+07	2571	6691.08	2
2011	25	2	2515906	4.154756e+07	6206	6694.74	2
2011	25	2	2513901	2.091829e+08	31237	6696.64	2
2011	15	1	1502954	2.1413508e+08	31954	6701.35	2
2011	31	3	3167806	3.831695e+07	5716	6703.45	2
2011	29	2	2914901	1.6629765e+08	24794	6707.17	2
2011	28	2	2804102	7.391317e+07	11020	6707.18	2
2011	31	3	3127305	4.647415e+07	6929	6707.19	2
2011	29	2	2915700	5.278797e+07	7869	6708.35	2
2011	17	1	1718501	2.561812e+07	3817	6711.58	2
2011	29	2	2918555	4.293812e+07	6397	6712.23	2
2011	35	3	3552007	3.909413e+07	5824	6712.59	2
2011	17	1	1718550	2.84105e+07	4231	6714.84	2
2011	23	2	2310605	5.58867e+07	8319	6717.96	2
2011	17	1	1705607	2.801343e+07	4168	6721.07	2
2011	31	3	3130556	4.346137e+07	6464	6723.6	2
2011	31	3	3154606	2.01582155e+09	299729	6725.48	2
2011	52	5	5213509	5.247035e+07	7795	6731.28	2
2011	26	2	2607653	2.3850806e+08	35430	6731.81	2
2011	31	3	3113800	1.657689e+07	2462	6733.1	2
2011	22	2	2208551	1.739638e+07	2583	6734.95	2
2011	12	1	1200336	1.0476847e+08	15554	6735.79	2
2011	31	3	3154457	5.399341e+07	8010	6740.75	2
2011	29	2	2931202	1.2784361e+08	18965	6741.03	2
2011	24	2	2406908	2.47083e+07	3665	6741.69	2
2011	25	2	2504306	1.9510941e+08	28922	6746.06	2
2011	31	3	3168507	7.671113e+07	11371	6746.21	2
2011	15	1	1504703	4.8161907e+08	71329	6752.08	2
2011	15	1	1504059	1.899719e+08	28100	6760.57	2
2011	17	1	1709005	8.211686e+07	12143	6762.49	2
2011	31	3	3141603	7.034424e+07	10392	6769.08	2
2011	35	3	3505351	3.570806e+07	5275	6769.3	2
2011	31	3	3140407	1.993558e+07	2944	6771.6	2
2011	26	2	2610608	3.511038e+08	51835	6773.49	2
2011	12	1	1200328	4.56713e+07	6740	6776.16	2
2011	29	2	2929602	1.1262169e+08	16603	6783.21	2
2011	31	3	3131208	1.2426808e+08	18315	6785.04	2
2011	23	2	2311603	1.8016235e+08	26540	6788.33	2
2011	25	2	2507002	1.5854934e+08	23351	6789.83	2
2011	21	2	2100808	9.665355e+07	14220	6797.02	2
2011	31	3	3155900	3.606445e+07	5304	6799.48	2
2011	24	2	2412609	1.0880405e+08	15999	6800.68	2
2011	15	1	1500404	3.6071271e+08	53004	6805.39	2
2011	28	2	2801009	1.1480937e+08	16870	6805.53	2
2011	31	3	3132701	1.5536482e+08	22820	6808.27	2
2011	29	2	2904308	9.668599e+07	14201	6808.39	2
2011	41	4	4109500	5.342692e+07	7839	6815.53	2
2011	28	2	2806909	2.358179e+07	3460	6815.55	2
2011	23	2	2306405	8.0275909e+08	117720	6819.22	2
2011	17	1	1720937	1.339045e+07	1963	6821.42	2
2011	29	2	2903102	4.213033e+07	6174	6823.83	2
2011	23	2	2312700	1.8032149e+08	26425	6823.9	2
2011	31	3	3145406	1.332141e+07	1951	6827.99	2
2011	29	2	2929057	8.985799e+07	13147	6834.87	2
2011	31	3	3147501	1.198504e+07	1753	6836.87	2
2011	31	3	3125952	7.112042e+07	10402	6837.19	2
2011	26	2	2613404	1.2657096e+08	18504	6840.19	2
2011	51	5	5100102	3.761192e+07	5493	6847.25	2
2011	35	3	3503505	2.537002e+07	3704	6849.36	2
2011	17	1	1701309	4.014066e+07	5860	6849.94	2
2011	25	2	2510709	1.544604e+07	2253	6855.76	2
2011	13	1	1300086	7.197101e+07	10495	6857.65	2
2011	29	2	2916104	1.4307375e+08	20862	6858.1	2
2011	35	3	3515350	6.543177e+07	9537	6860.83	2
2011	15	1	1500958	1.859896e+08	27070	6870.69	2
2011	26	2	2605152	1.1759469e+08	17110	6872.86	2
2011	29	2	2903904	4.4095506e+08	64121	6876.92	2
2011	17	1	1717008	3.090283e+07	4493	6877.99	2
2011	17	1	1710706	4.132047e+07	6002	6884.45	2
2011	29	2	2914703	4.2619526e+08	61838	6892.13	2
2011	52	5	5201702	1.2708658e+08	18437	6893.02	2
2011	29	2	2912905	1.2714461e+08	18443	6893.92	2
2011	25	2	2512788	1.207931e+07	1752	6894.58	2
2011	31	3	3171030	5.81685e+07	8436	6895.27	2
2011	22	2	2206407	7.13078e+07	10335	6899.64	2
2011	29	2	2926657	5.988544e+07	8675	6903.22	2
2011	23	2	2302503	3.15626e+08	45708	6905.27	2
2011	29	2	2905800	2.4369185e+08	35275	6908.34	2
2011	31	3	3145851	3.112315e+07	4504	6910.11	2
2011	31	3	3120839	3.251269e+07	4705	6910.24	2
2011	25	2	2516755	1.965019e+07	2840	6919.08	2
2011	28	2	2807303	2.06381e+07	2982	6920.89	2
2011	51	5	5107404	2.913051e+07	4209	6921	2
2011	13	1	1302702	3.3019918e+08	47707	6921.4	2
2011	31	3	3150158	5.01789e+07	7246	6925.05	2
2011	29	2	2916500	2.2626008e+08	32641	6931.78	2
2011	27	2	2703502	4.834343e+07	6973	6932.95	2
2011	31	3	3165578	3.624989e+07	5226	6936.45	2
2011	27	2	2708808	2.2363829e+08	32232	6938.39	2
2011	15	1	1508001	3.971273e+08	57228	6939.39	2
2011	31	3	3150406	3.24268e+07	4669	6945.13	2
2011	28	2	2800209	1.4023057e+08	20188	6946.23	2
2011	31	3	3148707	1.6572784e+08	23857	6946.72	2
2011	31	3	3115201	2.743285e+07	3949	6946.78	2
2011	31	3	3158706	1.566182e+07	2254	6948.46	2
2011	26	2	2605103	2.3734273e+08	34154	6949.19	2
2011	28	2	2803906	8.400896e+07	12086	6950.93	2
2011	29	2	2932200	1.4223261e+08	20449	6955.48	2
2011	21	2	2103000	1.08739632e+09	156327	6955.91	2
2011	31	3	3167301	1.529237e+07	2197	6960.57	2
2011	28	2	2800506	1.1844234e+08	17014	6961.46	2
2011	24	2	2411403	9.498633e+07	13642	6962.79	2
2011	29	2	2929008	9.84032e+07	14129	6964.63	2
2011	25	2	2500577	1.657076e+07	2379	6965.43	2
2011	31	3	3126604	3.409445e+07	4892	6969.43	2
2011	31	3	3127206	2.718923e+07	3900	6971.6	2
2011	24	2	2400802	8.049761e+07	11544	6973.11	2
2011	22	2	2202901	1.785574e+08	25575	6981.72	2
2011	27	2	2706802	1.2036176e+08	17236	6983.16	2
2011	31	3	3149952	4.893165e+07	7005	6985.25	2
2011	26	2	2613800	1.1928924e+08	17077	6985.37	2
2011	26	2	2602407	6.176046e+07	8839	6987.27	2
2011	31	3	3156205	1.490532e+07	2133	6987.96	2
2011	24	2	2415008	2.026294e+07	2899	6989.63	2
2011	27	2	2708907	1.0356897e+08	14815	6990.82	2
2011	31	3	3156106	3.416513e+07	4887	6991.02	2
2011	28	2	2805208	4.2197e+07	6029	6999	2
2011	25	2	2516102	9.711026e+07	13868	7002.47	2
2011	29	2	2916005	1.4094433e+08	20114	7007.28	2
2011	15	1	1507607	3.6687153e+08	52350	7008.05	2
2011	31	3	3171154	3.292874e+07	4698	7009.1	2
2011	21	2	2111573	3.127265e+07	4456	7018.1	2
2011	31	3	3141405	1.4723879e+08	20979	7018.39	2
2011	31	3	3171808	7.406753e+07	10553	7018.62	2
2011	31	3	3162575	3.684302e+07	5249	7019.05	2
2011	31	3	3118908	6.09622e+07	8679	7024.1	2
2011	31	3	3156452	3.01137e+07	4277	7040.85	2
2011	29	2	2903300	4.428139e+07	6285	7045.57	2
2011	23	2	2310704	2.5093814e+08	35615	7045.86	2
2011	26	2	2615607	1.8638364e+08	26438	7049.84	2
2011	31	3	3137304	2.968657e+07	4208	7054.79	2
2011	31	3	3164472	4.101183e+07	5813	7055.19	2
2011	26	2	2603009	2.2014278e+08	31191	7057.89	2
2011	31	3	3136579	3.240479e+07	4591	7058.33	2
2011	23	2	2308708	4.3682952e+08	61886	7058.62	2
2011	31	3	3136405	3.062814e+07	4339	7058.8	2
2011	17	1	1719004	1.803753e+07	2555	7059.7	2
2011	24	2	2408300	2.5147955e+08	35618	7060.46	2
2011	31	3	3116001	3.985216e+07	5644	7060.98	2
2011	31	3	3155009	1.74932e+07	2477	7062.25	2
2011	35	3	3542800	2.364744e+07	3347	7065.26	2
2011	13	1	1300144	1.2951882e+08	18326	7067.49	2
2011	17	1	1701002	6.944076e+07	9816	7074.24	2
2011	24	2	2402600	4.8524559e+08	68580	7075.61	2
2011	28	2	2806800	7.322604e+07	10349	7075.66	2
2011	26	2	2612604	2.8080895e+08	39629	7085.95	2
2011	25	2	2512903	1.6320211e+08	23028	7087.12	2
2011	26	2	2605509	8.13905e+07	11484	7087.29	2
2011	24	2	2404804	1.482759e+07	2091	7091.15	2
2011	43	4	4304713	5.238928e+07	7382	7096.89	2
2011	17	1	1701903	4.532818e+07	6387	7096.94	2
2011	52	5	5203559	5.469227e+07	7704	7099.2	2
2011	31	3	3148301	6.603798e+07	9289	7109.27	2
2011	29	2	2913903	3.1617178e+08	44465	7110.58	2
2011	28	2	2801702	1.1870765e+08	16692	7111.65	2
2011	25	2	2515302	3.5819381e+08	50358	7112.95	2
2011	31	3	3170305	1.915927e+07	2693	7114.47	2
2011	29	2	2913200	1.8160102e+08	25522	7115.47	2
2011	27	2	2703601	5.567772e+07	7823	7117.18	2
2011	23	2	2313609	2.2904738e+08	32148	7124.78	2
2011	52	5	5207907	8.846994e+07	12416	7125.48	2
2011	17	1	1720259	2.083906e+07	2924	7126.9	2
2011	26	2	2608909	3.9502661e+08	55391	7131.6	2
2011	31	3	3112901	6.453268e+07	9046	7133.84	2
2011	32	3	3204005	1.5443578e+08	21636	7137.91	2
2011	15	1	1506500	4.3355232e+08	60713	7141.01	2
2011	31	3	3107901	7.466374e+07	10453	7142.8	2
2011	24	2	2411205	2.5822278e+08	36143	7144.48	2
2011	31	3	3166105	2.498793e+07	3496	7147.58	2
2011	27	2	2704005	1.7028456e+08	23824	7147.61	2
2011	29	2	2901106	1.7970523e+08	25134	7149.89	2
2011	29	2	2922755	4.727391e+07	6609	7152.96	2
2011	24	2	2402402	5.364722e+07	7495	7157.73	2
2011	31	3	3167905	2.89641e+07	4042	7165.78	2
2011	31	3	3157302	3.263653e+07	4551	7171.29	2
2011	17	1	1702703	2.491489e+07	3473	7173.88	2
2011	31	3	3103702	5.864295e+07	8171	7176.96	2
2011	31	3	3163805	4.859137e+07	6770	7177.46	2
2011	27	2	2705101	1.7080774e+08	23768	7186.46	2
2011	31	3	3150901	3.763901e+07	5236	7188.5	2
2011	31	3	3120102	3.036398e+07	4220	7195.26	2
2011	17	1	1715101	2.749337e+07	3817	7202.87	2
2011	31	3	3136553	3.193672e+07	4432	7205.94	2
2011	12	1	1200435	3.516422e+07	4879	7207.26	2
2011	17	1	1721208	1.6300245e+08	22607	7210.26	2
2011	35	3	3556354	6.449693e+07	8942	7212.81	2
2011	24	2	2406403	1.926691e+07	2670	7216.07	2
2011	25	2	2512200	2.804903e+07	3887	7216.11	2
2011	24	2	2405603	9.843745e+07	13623	7225.83	2
2011	31	3	3116704	5.127567e+07	7095	7227.01	2
2011	23	2	2311405	5.2695714e+08	72866	7231.87	2
2011	24	2	2405801	2.3472508e+08	32456	7232.1	2
2011	17	1	1715150	1.654326e+07	2287	7233.61	2
2011	17	1	1707702	6.169081e+07	8528	7233.91	2
2011	17	1	1703073	3.016287e+07	4165	7241.99	2
2011	24	2	2404853	5.061286e+07	6985	7245.93	2
2011	24	2	2401800	8.462151e+07	11675	7248.09	2
2011	31	3	3144904	2.730797e+07	3767	7249.26	2
2011	52	5	5217609	5.9670229e+08	82258	7254.03	2
2011	23	2	2309102	8.47927e+07	11684	7257.16	2
2011	31	3	3151008	5.852828e+07	8064	7257.97	2
2011	26	2	2605202	4.642701e+08	63963	7258.42	2
2011	15	1	1508159	3.2494701e+08	44758	7260.09	2
2011	31	3	3122900	4.398688e+07	6051	7269.36	2
2011	26	2	2608206	1.1460533e+08	15762	7270.99	2
2011	28	2	2802809	1.1670014e+08	16037	7276.93	2
2011	17	1	1703909	3.401404e+07	4674	7277.29	2
2011	31	3	3127370	2.242887e+07	3079	7284.47	2
2011	26	2	2616183	5.70137e+07	7823	7287.96	2
2011	27	2	2708709	5.294969e+07	7264	7289.33	2
2011	12	1	1200500	2.8226104e+08	38709	7291.87	2
2011	29	2	2932606	1.2020138e+08	16480	7293.77	2
2011	31	3	3147808	1.51261e+07	2073	7296.72	2
2011	17	1	1711803	1.622861e+07	2224	7297.04	2
2011	12	1	1200609	2.6441196e+08	36186	7307.02	2
2011	31	3	3102100	8.792208e+07	12029	7309.18	2
2011	31	3	3108107	4.98164e+07	6815	7309.82	2
2011	13	1	1304005	6.21135e+07	8495	7311.77	2
2011	21	2	2104107	8.973341e+07	12271	7312.64	2
2011	31	3	3163201	2.935195e+07	4011	7317.86	2
2011	27	2	2709152	3.0369532e+08	41480	7321.49	2
2011	17	1	1702554	1.184622e+08	16180	7321.52	2
2011	31	3	3155405	6.39138e+07	8725	7325.36	2
2011	21	2	2108207	2.8941604e+08	39419	7342.04	2
2011	31	3	3101300	1.984581e+07	2703	7342.14	2
2011	25	2	2517100	1.865147e+07	2539	7345.99	2
2011	12	1	1200344	5.954764e+07	8105	7347.03	2
2011	31	3	3104403	2.117729e+07	2881	7350.67	2
2011	52	5	5205802	7.658518e+07	10414	7354.06	2
2011	31	3	3165602	1.467345e+07	1988	7381.01	2
2011	22	2	2206605	7.650078e+07	10354	7388.52	2
2011	31	3	3128253	3.501088e+07	4738	7389.38	2
2011	31	3	3109204	7.623182e+07	10287	7410.5	2
2011	26	2	2609808	9.901406e+07	13361	7410.68	2
2011	29	2	2933505	1.6339055e+08	22047	7411.01	2
2011	17	1	1718881	2.184958e+07	2946	7416.69	2
2011	31	3	3120607	3.544927e+07	4779	7417.72	2
2011	35	3	3526308	3.586532e+07	4833	7420.92	2
2011	26	2	2609204	8.974862e+07	12093	7421.54	2
2011	31	3	3105004	5.860871e+07	7895	7423.52	2
2011	31	3	3171501	2.487789e+07	3350	7426.24	2
2011	31	3	3158607	2.874126e+07	3867	7432.44	2
2011	31	3	3124609	1.82606e+07	2455	7438.13	2
2011	27	2	2706307	5.2508849e+08	70556	7442.15	2
2011	26	2	2601904	4.3738275e+08	58768	7442.53	2
2011	22	2	2207702	1.09407476e+09	146736	7456.08	2
2011	13	1	1302553	1.7584393e+08	23576	7458.6	2
2011	35	3	3543006	1.3461491e+08	18042	7461.2	2
2011	29	2	2927705	1.9737425e+08	26447	7463.01	2
2011	31	3	3142304	3.514802e+07	4706	7468.77	2
2011	29	2	2905206	3.5599977e+08	47647	7471.61	2
2011	31	3	3138005	4.85108e+07	6492	7472.4	2
2011	35	3	3538501	1.048731e+08	14024	7478.12	2
2011	17	1	1708304	3.712967e+07	4965	7478.28	2
2011	31	3	3159407	2.664858e+07	3563	7479.25	2
2011	50	5	5006358	9.359825e+07	12514	7479.48	2
2011	15	1	1504422	8.2928937e+08	110842	7481.73	2
2011	29	2	2929305	2.5267651e+08	33766	7483.16	2
2011	13	1	1303403	7.7040104e+08	102946	7483.55	2
2011	26	2	2614501	4.4260683e+08	59144	7483.55	2
2011	35	3	3532306	4.98216e+07	6657	7484.09	2
2011	31	3	3161403	3.849445e+07	5139	7490.65	2
2011	52	5	5209408	3.166017e+07	4226	7491.76	2
2011	52	5	5209903	9.39576e+07	12540	7492.63	2
2011	41	4	4117206	4.137059e+07	5521	7493.31	2
2011	35	3	3535101	8.340112e+07	11126	7496.06	2
2011	23	2	2300754	2.9807378e+08	39762	7496.45	2
2011	31	3	3112505	6.715935e+07	8957	7497.97	2
2011	23	2	2307700	8.6597905e+08	115465	7499.93	2
2011	28	2	2800670	1.9230459e+08	25632	7502.52	2
2011	31	3	3110806	2.683741e+07	3576	7504.87	2
2011	17	1	1710508	5.34929e+07	7127	7505.67	2
2011	25	2	2514651	1.274078e+07	1696	7512.25	2
2011	29	2	2930501	5.8091984e+08	77309	7514.26	2
2011	31	3	3160504	1.333703e+07	1774	7518.06	2
2011	35	3	3523305	1.1739837e+08	15614	7518.79	2
2011	12	1	1200054	4.658085e+07	6192	7522.75	2
2011	24	2	2403608	1.8785652e+08	24953	7528.41	2
2011	28	2	2801108	2.983324e+07	3956	7541.26	2
2011	31	3	3142403	5.33302e+07	7068	7545.3	2
2011	52	5	5201801	6.427054e+07	8514	7548.81	2
2011	31	3	3149408	1.348292e+07	1785	7553.45	2
2011	31	3	3127404	3.195791e+07	4228	7558.64	2
2011	31	3	3154200	8.2908e+07	10958	7565.98	2
2011	17	1	1707207	5.414622e+07	7153	7569.72	2
2011	31	3	3130903	1.8379704e+08	24248	7579.88	2
2011	31	3	3123908	1.0866914e+08	14329	7583.86	2
2011	28	2	2800704	5.910247e+07	7792	7585.02	2
2011	52	5	5204953	3.634315e+07	4787	7592.05	2
2011	31	3	3127602	8.874716e+07	11681	7597.56	2
2011	52	5	5212055	1.75857e+07	2314	7599.7	2
2011	31	3	3101706	2.9680643e+08	39036	7603.4	2
2011	35	3	3505401	5.855846e+07	7700	7604.99	2
2011	35	3	3522158	2.456252e+07	3229	7606.85	2
2011	31	3	3151305	8.265442e+07	10841	7624.24	2
2011	31	3	3133303	1.6044991e+08	20981	7647.39	2
2011	22	2	2205607	4.021626e+07	5255	7652.95	2
2011	31	3	3164803	1.225628e+07	1601	7655.39	2
2011	35	3	3503604	8.117636e+07	10601	7657.42	2
2011	26	2	2613701	7.9668223e+08	103854	7671.18	2
2011	41	4	4122651	4.2324e+07	5512	7678.52	2
2011	22	2	2200459	3.92892e+07	5115	7681.17	2
2011	51	5	5107297	2.791805e+07	3634	7682.46	2
2011	23	2	2311306	6.2588225e+08	81445	7684.72	2
2011	14	1	1400704	6.590516e+07	8573	7687.53	2
2011	12	1	1200427	1.1405836e+08	14832	7690.02	2
2011	23	2	2313401	5.365033e+08	69723	7694.78	2
2011	15	1	1502939	4.0244521e+08	52224	7706.14	2
2011	31	3	3136603	4.288531e+07	5565	7706.26	2
2011	28	2	2800407	8.30483e+07	10772	7709.64	2
2011	29	2	2914653	2.2053544e+08	28593	7712.92	2
2011	31	3	3121100	6.14636e+07	7967	7714.77	2
2011	26	2	2601201	5.3510419e+08	69346	7716.44	2
2011	15	1	1506609	1.7900432e+08	23194	7717.7	2
2011	24	2	2408201	1.8645868e+08	24149	7721.18	2
2011	35	3	3551207	2.790686e+07	3614	7721.87	2
2011	31	3	3167004	1.538209e+07	1990	7729.69	2
2011	31	3	3167608	1.4238436e+08	18408	7734.92	2
2011	31	3	3105301	4.158552e+07	5372	7741.16	2
2011	41	4	4113254	4.883354e+07	6308	7741.52	2
2011	51	5	5107776	5.796434e+07	7484	7745.1	2
2011	41	4	4128807	4.627975e+07	5975	7745.57	2
2011	15	1	1507458	1.9700476e+08	25429	7747.25	2
2011	24	2	2403400	4.521327e+07	5835	7748.63	2
2011	33	3	3302270	7.4730505e+08	96430	7749.72	2
2011	43	4	4300646	5.670961e+07	7317	7750.39	2
2011	31	3	3134103	4.530876e+07	5845	7751.71	2
2011	51	5	5106422	2.4168101e+08	31170	7753.64	2
2011	24	2	2405702	9.399912e+07	12119	7756.34	2
2011	31	3	3104502	1.3707321e+08	17672	7756.52	2
2011	31	3	3136108	4.137831e+07	5334	7757.46	2
2011	29	2	2920007	6.90416e+07	8894	7762.72	2
2011	31	3	3158904	6.661413e+07	8581	7762.98	2
2011	41	4	4115457	3.827221e+07	4929	7764.7	2
2011	41	4	4123857	8.803216e+07	11336	7765.72	2
2011	28	2	2805000	2.330531e+07	3001	7765.85	2
2011	31	3	3169208	7.282458e+07	9375	7767.96	2
2011	27	2	2706703	4.712875e+08	60638	7772.15	2
2011	17	1	1700251	1.870973e+07	2407	7773.05	2
2011	27	2	2709301	4.8716629e+08	62645	7776.62	2
2011	17	1	1716653	3.959448e+07	5090	7778.88	2
2011	35	3	3556602	8.370954e+07	10745	7790.56	2
2011	35	3	3551405	9.00184e+07	11549	7794.48	2
2011	31	3	3138302	2.497517e+07	3204	7795	2
2011	35	3	3523701	4.640825e+07	5953	7795.77	2
2011	31	3	3132503	2.5258656e+08	32388	7798.77	2
2011	23	2	2303501	5.2158038e+08	66834	7804.12	2
2011	32	3	3200508	5.857262e+07	7505	7804.48	2
2011	17	1	1705557	3.654824e+07	4681	7807.78	2
2011	15	1	1508050	1.3352255e+08	17093	7811.53	2
2011	52	5	5207808	9.156647e+07	11709	7820.18	2
2011	29	2	2923001	3.0548408e+08	39054	7822.09	2
2011	43	4	4300604	1.5377169e+09	196572	7822.66	2
2011	31	3	3123106	4.076931e+07	5211	7823.7	2
2011	31	3	3158508	6.231504e+07	7963	7825.57	2
2011	31	3	3172202	1.996218e+07	2550	7828.3	2
2011	32	3	3203304	1.0752498e+08	13721	7836.53	2
2011	31	3	3129400	3.943386e+07	5029	7841.29	2
2011	31	3	3107505	5.090406e+07	6491	7842.25	2
2011	29	2	2930105	5.881221e+08	74937	7848.22	2
2011	29	2	2902906	2.7561513e+08	35084	7855.86	2
2011	28	2	2804607	1.947411e+08	24764	7863.88	2
2011	25	2	2508604	9.344152e+07	11882	7864.12	2
2011	52	5	5220686	5.145161e+07	6537	7870.83	2
2011	24	2	2409506	2.741448e+07	3483	7870.94	2
2011	17	1	1721307	1.695862e+07	2154	7873.08	2
2011	31	3	3131109	5.331858e+07	6771	7874.55	2
2011	23	2	2309805	9.172008e+07	11646	7875.67	2
2011	25	2	2504355	3.601952e+07	4571	7880.01	2
2011	43	4	4315404	8.145849e+07	10328	7887.15	2
2011	31	3	3169059	3.123569e+07	3960	7887.8	2
2011	15	1	1502707	3.6080142e+08	45724	7890.85	2
2011	13	1	1304104	1.421778e+08	18010	7894.38	2
2011	31	3	3107703	4.377391e+07	5543	7897.15	2
2011	41	4	4115002	5.422251e+07	6866	7897.25	2
2011	31	3	3121506	2.370053e+07	3000	7900.18	2
2011	31	3	3168002	2.464711e+08	31192	7901.74	2
2011	31	3	3109105	8.606154e+07	10889	7903.53	2
2011	31	3	3144375	2.592417e+07	3280	7903.71	2
2011	31	3	3115904	2.23283e+07	2825	7903.82	2
2011	31	3	3153202	3.064876e+07	3877	7905.28	2
2011	35	3	3536802	4.584231e+07	5794	7912.03	2
2011	31	3	3119609	2.369779e+07	2990	7925.68	2
2011	51	5	5101605	6.012326e+07	7585	7926.6	2
2011	31	3	3166303	5.660132e+07	7139	7928.47	2
2011	50	5	5005202	1.5831363e+08	19948	7936.32	2
2011	35	3	3525805	3.537172e+07	4451	7946.91	2
2011	27	2	2700409	3.5453799e+08	44612	7947.14	2
2011	28	2	2806701	6.3625254e+08	79956	7957.53	2
2011	25	2	2508901	3.3926397e+08	42602	7963.57	2
2011	15	1	1503754	1.1327536e+08	14223	7964.24	2
2011	31	3	3171071	4.430617e+07	5559	7970.17	2
2011	31	3	3160959	4.328442e+07	5425	7978.69	2
2011	51	5	5107701	1.4053496e+08	17601	7984.49	2
2011	31	3	3165008	8.454693e+07	10586	7986.67	2
2011	22	2	2207801	1.5868695e+08	19867	7987.46	2
2011	12	1	1200708	1.3086718e+08	16370	7994.33	2
2011	24	2	2404200	1.8275241e+08	22851	7997.57	2
2011	41	4	4100400	8.3502895e+08	104350	8002.19	2
2011	27	2	2703908	3.341513e+07	4172	8009.38	2
2011	31	3	3159308	3.986261e+07	4976	8010.98	2
2011	28	2	2802601	4.531635e+07	5655	8013.5	2
2011	25	2	2506004	2.5106822e+08	31320	8016.23	2
2011	52	5	5220702	2.274512e+07	2837	8017.31	2
2011	31	3	3146602	1.246581e+07	1554	8021.75	2
2011	21	2	2109502	1.6164116e+08	20150	8021.89	2
2011	35	3	3514007	6.435888e+07	8011	8033.81	2
2011	31	3	3154002	1.9115336e+08	23783	8037.39	2
2011	17	1	1706001	4.069519e+07	5061	8040.94	2
2011	26	2	2611309	1.9383626e+08	24100	8043	2
2011	52	5	5204557	2.708104e+07	3361	8057.44	2
2011	41	4	4110201	8.822543e+07	10942	8063.01	2
2011	35	3	3533106	1.762678e+07	2184	8070.87	2
2011	17	1	1702158	4.116429e+07	5095	8079.35	2
2011	25	2	2512002	1.390555e+08	17198	8085.56	2
2011	29	2	2911709	6.4238513e+08	79394	8091.1	2
2011	28	2	2807600	1.838672e+08	22709	8096.67	2
2011	43	4	4318507	2.0760185e+08	25635	8098.38	2
2011	43	4	4301859	2.509671e+07	3097	8103.56	2
2011	31	3	3116209	2.247842e+07	2772	8109.1	2
2011	31	3	3164902	1.72053e+07	2121	8111.88	2
2011	15	1	1502772	1.4761511e+08	18197	8112.06	2
2011	31	3	3101201	4.98292e+07	6139	8116.83	2
2011	23	2	2307007	2.6321491e+08	32428	8116.9	2
2011	32	3	3203163	8.791712e+07	10818	8126.93	2
2011	29	2	2918456	8.235552e+07	10129	8130.67	2
2011	26	2	2616308	2.5124543e+08	30879	8136.45	2
2011	29	2	2901353	1.1667874e+08	14310	8153.65	2
2011	31	3	3135506	1.0425924e+08	12786	8154.17	2
2011	23	2	2306900	2.8042522e+08	34362	8160.91	2
2011	29	2	2903409	1.7907669e+08	21935	8163.97	2
2011	17	1	1716307	3.762931e+07	4608	8166.08	2
2011	31	3	3121308	3.909621e+07	4787	8167.16	2
2011	41	4	4119509	7.7210217e+08	94518	8168.84	2
2011	29	2	2913705	3.0088151e+08	36822	8171.24	2
2011	28	2	2801306	2.5409494e+08	31087	8173.67	2
2011	31	3	3118502	1.416982e+07	1730	8190.65	2
2011	52	5	5205521	2.876711e+07	3510	8195.76	2
2011	35	3	3554201	3.909168e+07	4769	8197.04	2
2011	15	1	1506583	1.4503127e+08	17686	8200.34	2
2011	15	1	1506187	3.8963286e+08	47509	8201.24	2
2011	12	1	1200807	1.2481581e+08	15213	8204.55	2
2011	26	2	2608750	1.891739e+08	23039	8211.03	2
2011	27	2	2707305	2.1220528e+08	25843	8211.33	2
2011	52	5	5203104	3.141065e+07	3825	8211.94	2
2011	31	3	3157104	5.639146e+07	6866	8213.15	2
2011	51	5	5106778	8.964914e+07	10912	8215.65	2
2011	41	4	4117503	2.9870511e+08	36333	8221.32	2
2011	52	5	5209457	1.856378e+07	2258	8221.34	2
2011	15	1	1508357	1.1188425e+08	13607	8222.55	2
2011	28	2	2804409	1.5239031e+08	18500	8237.31	2
2011	31	3	3137403	1.014571e+08	12316	8237.83	2
2011	35	3	3523800	6.223676e+07	7553	8240.01	2
2011	13	1	1300839	9.181397e+07	11142	8240.35	2
2011	51	5	5103379	1.2737463e+08	15455	8241.65	2
2011	31	3	3159001	3.336246e+07	4045	8247.83	2
2011	29	2	2921104	1.781847e+08	21602	8248.53	2
2011	43	4	4302055	1.87726e+07	2275	8251.69	2
2011	35	3	3528908	3.236179e+07	3921	8253.45	2
2011	35	3	3548302	2.332533e+07	2825	8256.76	2
2011	28	2	2803401	1.0678557e+08	12932	8257.47	2
2011	41	4	4117057	9.254585e+07	11206	8258.6	2
2011	31	3	3120805	1.2103983e+08	14655	8259.29	2
2011	43	4	4301107	1.1258777e+08	13627	8262.11	2
2011	23	2	2304202	1.01406842e+09	122717	8263.47	2
2011	21	2	2102150	4.350903e+07	5265	8263.82	2
2011	15	1	1505635	1.0496873e+08	12699	8265.91	2
2011	29	2	2932507	1.9462727e+08	23542	8267.24	2
2011	24	2	2411809	2.822843e+07	3414	8268.43	2
2011	31	3	3103108	1.374259e+07	1662	8268.71	2
2011	32	3	3203809	1.194995e+08	14452	8268.72	2
2011	31	3	3161007	1.434736e+08	17336	8276.05	2
2011	15	1	1500347	2.0929508e+08	25286	8277.11	2
2011	31	3	3142502	1.940366e+07	2344	8278.01	2
2011	31	3	3160108	3.367247e+07	4063	8287.59	2
2011	29	2	2928604	4.8060389e+08	57891	8301.88	2
2011	31	3	3122470	3.151613e+07	3796	8302.46	2
2011	29	2	2933208	3.1690406e+08	38168	8302.87	2
2011	27	2	2704500	2.4347741e+08	29280	8315.49	2
2011	31	3	3127388	3.067274e+07	3685	8323.67	2
2011	28	2	2806503	3.132021e+07	3761	8327.63	3
2011	31	3	3126703	2.0841367e+08	25016	8331.21	3
2011	17	1	1720150	1.208235e+07	1450	8332.65	3
2011	15	1	1501725	1.2981422e+08	15575	8334.78	3
2011	51	5	5106109	9.652409e+07	11579	8336.13	3
2011	31	3	3129004	7.224201e+07	8665	8337.22	3
2011	24	2	2402204	2.6041671e+08	31216	8342.41	3
2011	31	3	3121902	2.755483e+07	3302	8344.89	3
2011	31	3	3118403	1.8602237e+08	22281	8348.92	3
2011	35	3	3503158	2.075185e+07	2484	8354.21	3
2011	41	4	4114708	4.95102e+07	5924	8357.56	3
2011	32	3	3200359	6.139899e+07	7345	8359.29	3
2011	29	2	2917300	2.2381568e+08	26764	8362.56	3
2011	31	3	3116159	9.270562e+07	11077	8369.2	3
2011	35	3	3522802	1.219521e+08	14564	8373.53	3
2011	26	2	2606408	6.4668474e+08	77164	8380.65	3
2011	41	4	4126207	5.638029e+07	6726	8382.44	3
2011	23	2	2306801	8.837088e+07	10528	8393.89	3
2011	31	3	3157005	3.3053667e+08	39367	8396.29	3
2011	52	5	5221452	2.90374e+07	3454	8406.89	3
2011	16	1	1600253	3.67745e+07	4371	8413.29	3
2011	31	3	3163607	2.195812e+07	2609	8416.3	3
2011	23	2	2302206	4.1974067e+08	49846	8420.75	3
2011	24	2	2413904	1.000429e+08	11860	8435.32	3
2011	31	3	3128501	3.300695e+07	3911	8439.52	3
2011	31	3	3140852	8.512747e+07	10085	8441	3
2011	31	3	3160009	2.989597e+07	3540	8445.19	3
2011	28	2	2806602	9.685972e+07	11467	8446.82	3
2011	17	1	1706506	4.51958e+07	5350	8447.81	3
2011	42	4	4212254	5.744253e+07	6798	8449.92	3
2011	28	2	2804458	7.204465e+07	8526	8449.99	3
2011	17	1	1703305	3.27796e+07	3879	8450.53	3
2011	17	1	1706100	6.110888e+07	7228	8454.47	3
2011	31	3	3122009	1.6224774e+08	19188	8455.69	3
2011	31	3	3135100	5.6858842e+08	67199	8461.26	3
2011	41	4	4100509	1.7446209e+08	20615	8462.87	3
2011	41	4	4117271	6.129434e+07	7239	8467.24	3
2011	32	3	3203106	9.260068e+07	10932	8470.61	3
2011	43	4	4304689	9.94965e+07	11734	8479.33	3
2011	28	2	2800100	1.935889e+07	2283	8479.58	3
2011	28	2	2806008	1.4677387e+08	17307	8480.61	3
2011	29	2	2900801	1.8100657e+08	21300	8497.96	3
2011	31	3	3145059	6.299139e+07	7399	8513.5	3
2011	52	5	5208400	9.10752e+07	10697	8514.09	3
2011	25	2	2510659	1.05863e+07	1243	8516.73	3
2011	15	1	1505551	5.070005e+07	5950	8521.02	3
2011	43	4	4306353	2.405173e+07	2822	8522.94	3
2011	43	4	4307104	5.752321e+07	6746	8527.01	3
2011	31	3	3153806	1.592193e+07	1867	8528.08	3
2011	31	3	3157278	2.40632e+07	2821	8530.02	3
2011	31	3	3146404	3.938029e+07	4611	8540.51	3
2011	17	1	1712454	2.280548e+07	2669	8544.58	3
2011	52	5	5209291	2.002962e+07	2344	8545.06	3
2011	31	3	3101631	5.256343e+07	6150	8546.9	3
2011	24	2	2403004	6.798751e+07	7954	8547.59	3
2011	35	3	3527801	3.731001e+07	4363	8551.46	3
2011	17	1	1713957	2.727546e+07	3189	8552.98	3
2011	25	2	2501807	8.5655754e+08	100137	8553.86	3
2011	28	2	2804300	6.299896e+07	7363	8556.15	3
2011	11	1	1100080	1.2001796e+08	14023	8558.65	3
2011	52	5	5214903	2.956653e+07	3453	8562.56	3
2011	17	1	1720499	3.713839e+07	4332	8573.03	3
2011	35	3	3520004	2.009865e+08	23420	8581.83	3
2011	28	2	2803500	8.2186007e+08	95746	8583.75	3
2011	32	3	3200169	1.0041215e+08	11696	8585.17	3
2011	23	2	2309706	6.3429248e+08	73881	8585.33	3
2011	31	3	3160801	3.992186e+07	4642	8600.14	3
2011	17	1	1703107	4.621743e+07	5370	8606.6	3
2011	52	5	5208103	4.158875e+07	4829	8612.29	3
2011	52	5	5218300	2.7417955e+08	31833	8613.06	3
2011	41	4	4117800	1.2669879e+08	14699	8619.55	3
2011	35	3	3520608	4.152483e+07	4817	8620.48	3
2011	29	2	2904050	1.2931667e+08	14983	8630.89	3
2011	21	2	2105153	1.1055735e+08	12806	8633.25	3
2011	33	3	3302858	1.4607228e+09	168966	8645.07	3
2011	50	5	5003157	1.225288e+08	14161	8652.55	3
2011	26	2	2611903	1.928348e+08	22258	8663.62	3
2011	26	2	2607406	3.832773e+07	4423	8665.55	3
2011	52	5	5213772	3.594497e+07	4148	8665.61	3
2011	31	3	3108909	1.267184e+08	14623	8665.69	3
2011	31	3	3111705	4.002477e+07	4616	8670.88	3
2011	31	3	3171709	7.475027e+07	8618	8673.74	3
2011	16	1	1600808	1.1038514e+08	12725	8674.67	3
2011	35	3	3545001	1.3658446e+08	15734	8680.85	3
2011	31	3	3159357	5.735882e+07	6605	8684.15	3
2011	26	2	2609501	2.6848901e+08	30915	8684.75	3
2011	43	4	4311734	2.603306e+07	2996	8689.27	3
2011	32	3	3202553	7.769138e+07	8938	8692.26	3
2011	35	3	3501400	4.078579e+07	4692	8692.62	3
2011	16	1	1600709	1.1285599e+08	12981	8693.94	3
2011	15	1	1504000	2.2142997e+08	25440	8704.01	3
2011	28	2	2803807	3.028822e+07	3476	8713.53	3
2011	43	4	4305124	5.546886e+07	6362	8718.78	3
2011	31	3	3138708	4.727182e+07	5418	8724.96	3
2011	31	3	3159902	1.5219389e+08	17440	8726.71	3
2011	31	3	3104809	4.316296e+07	4945	8728.61	3
2011	51	5	5106505	2.7821079e+08	31857	8733.11	3
2011	32	3	3203700	1.597988e+08	18298	8733.13	3
2011	31	3	3128402	7.592194e+07	8691	8735.7	3
2011	29	2	2933257	5.889148e+07	6740	8737.61	3
2011	17	1	1715705	4.421189e+07	5058	8740.98	3
2011	31	3	3135050	2.9790264e+08	34071	8743.58	3
2011	35	3	3549607	3.561312e+07	4072	8745.85	3
2011	28	2	2805307	7.397802e+07	8455	8749.62	3
2011	31	3	3139607	2.3749622e+08	27130	8754.01	3
2011	52	5	5209606	3.135623e+07	3581	8756.28	3
2011	15	1	1506807	2.60184048e+09	297040	8759.23	3
2011	31	3	3149606	3.597991e+07	4104	8767.03	3
2011	51	5	5102793	9.552383e+07	10890	8771.7	3
2011	51	5	5105309	1.9333e+07	2204	8771.78	3
2011	12	1	1200385	1.5272447e+08	17401	8776.76	3
2011	42	4	4215653	7.087578e+07	8073	8779.36	3
2011	43	4	4323002	2.11059714e+09	240302	8783.1	3
2011	31	3	3124906	9.314529e+07	10600	8787.29	3
2011	31	3	3126000	5.864705e+07	6674	8787.39	3
2011	13	1	1304203	5.3975387e+08	61223	8816.19	3
2011	32	3	3201100	8.373516e+07	9496	8817.94	3
2011	31	3	3158003	9.319438e+07	10568	8818.54	3
2011	31	3	3153608	8.533644e+07	9676	8819.39	3
2011	24	2	2414605	1.16076e+08	13146	8829.76	3
2011	52	5	5219704	8.985348e+07	10171	8834.28	3
2011	27	2	2707701	6.0886264e+08	68885	8838.83	3
2011	29	2	2915601	5.5810311e+08	63053	8851.33	3
2011	35	3	3533304	3.094891e+07	3495	8855.2	3
2011	31	3	3138609	1.4334946e+08	16183	8858.03	3
2011	35	3	3542305	3.419912e+07	3860	8859.88	3
2011	35	3	3537206	9.11669e+07	10283	8865.79	3
2011	25	2	2510808	8.9939539e+08	101359	8873.36	3
2011	17	1	1714203	8.004192e+07	9011	8882.69	3
2011	21	2	2109908	6.9305537e+08	78020	8883.05	3
2011	29	2	2928802	4.3002199e+08	48397	8885.3	3
2011	51	5	5106653	4.909945e+07	5523	8890	3
2011	32	3	3202454	2.0114504e+08	22609	8896.68	3
2011	17	1	1713700	1.872481e+07	2102	8908.09	3
2011	17	1	1718865	5.958402e+07	6683	8915.76	3
2011	35	3	3553658	2.431552e+07	2727	8916.58	3
2011	21	2	2106755	2.2364427e+08	25065	8922.57	3
2011	42	4	4202073	7.54042e+07	8448	8925.69	3
2011	52	5	5214879	2.531507e+07	2833	8935.78	3
2011	31	3	3149101	1.0212584e+08	11426	8938.02	3
2011	35	3	3527702	4.549499e+07	5089	8939.87	3
2011	43	4	4315107	9.402943e+07	10510	8946.66	3
2011	31	3	3115607	1.078073e+07	1204	8954.1	3
2011	31	3	3170479	2.895115e+07	3233	8954.89	3
2011	24	2	2411429	2.273572e+07	2538	8958.12	3
2011	31	3	3144672	3.293797e+07	3674	8965.15	3
2011	32	3	3200102	2.7801824e+08	31004	8967.17	3
2011	24	2	2411601	2.64136e+07	2945	8968.96	3
2011	31	3	3139805	1.0621173e+08	11840	8970.58	3
2011	17	1	1718709	2.327643e+07	2594	8973.18	3
2011	41	4	4104253	2.2598151e+08	25184	8973.22	3
2011	17	1	1715754	6.606248e+07	7360	8975.88	3
2011	17	1	1711506	3.174846e+07	3537	8976.1	3
2011	26	2	2610707	2.72335885e+09	303401	8976.1	3
2011	24	2	2412401	3.83161e+07	4266	8981.74	3
2011	25	2	2500403	1.776963e+08	19766	8990	3
2011	14	1	1400407	8.234692e+07	9156	8993.77	3
2011	17	1	1722081	9.937443e+07	11036	9004.57	3
2011	31	3	3145703	1.9126e+07	2122	9013.19	3
2011	31	3	3144003	2.4031465e+08	26659	9014.39	3
2011	24	2	2408904	1.8444097e+08	20434	9026.18	3
2011	52	5	5205208	4.257509e+07	4714	9031.63	3
2011	32	3	3201803	4.061271e+07	4493	9039.11	3
2011	31	3	3150208	3.675338e+07	4065	9041.42	3
2011	26	2	2614204	3.6984071e+08	40853	9052.96	3
2011	31	3	3135902	4.316178e+07	4764	9059.99	3
2011	43	4	4305173	9.443489e+07	10422	9061.11	3
2011	23	2	2305357	1.683082e+08	18572	9062.47	3
2011	41	4	4103057	7.136479e+07	7872	9065.65	3
2011	26	2	2614857	1.9023335e+08	20979	9067.8	3
2011	41	4	4105201	1.5401069e+08	16983	9068.52	3
2011	43	4	4311775	6.236195e+07	6875	9070.83	3
2011	14	1	1400050	1.4819689e+08	16337	9071.24	3
2011	52	5	5214861	7.696335e+07	8475	9081.22	3
2011	31	3	3126406	2.475661e+07	2726	9081.66	3
2011	29	2	2904902	2.9225213e+08	32150	9090.27	3
2011	23	2	2301901	5.0869577e+08	55960	9090.35	3
2011	17	1	1716703	7.787276e+07	8555	9102.6	3
2011	31	3	3108552	1.3150773e+08	14438	9108.44	3
2011	31	3	3132909	9.406902e+07	10321	9114.33	3
2011	28	2	2806305	1.1912546e+08	13064	9118.61	3
2011	52	5	5210604	4.940736e+07	5418	9119.11	3
2011	26	2	2613008	4.9122344e+08	53847	9122.58	3
2011	31	3	3169703	1.6658372e+08	18222	9141.9	3
2011	42	4	4217253	4.37986e+07	4790	9143.76	3
2011	15	1	1501907	2.3824022e+08	26053	9144.44	3
2011	51	5	5102603	1.3219915e+08	14450	9148.73	3
2011	31	3	3121605	4.2130348e+08	46005	9157.78	3
2011	31	3	3149705	8.388052e+07	9159	9158.26	3
2011	41	4	4128633	5.227007e+07	5706	9160.54	3
2011	14	1	1400282	8.242682e+07	8997	9161.59	3
2011	17	1	1710904	3.255372e+07	3552	9164.9	3
2011	41	4	4121901	1.2361429e+08	13462	9182.46	3
2011	17	1	1713304	1.1652383e+08	12687	9184.51	3
2011	29	2	2915304	6.490461e+07	7061	9191.99	3
2011	41	4	4124202	2.497823e+07	2716	9196.7	3
2011	23	2	2311801	6.5138333e+08	70794	9201.11	3
2011	31	3	3154903	1.2999367e+08	14120	9206.35	3
2011	35	3	3510609	3.42020222e+09	371502	9206.42	3
2011	28	2	2801405	1.85803e+08	20179	9207.74	3
2011	41	4	4100905	5.069666e+07	5504	9210.88	3
2011	17	1	1712504	4.083513e+07	4431	9215.78	3
2011	51	5	5103254	2.5452695e+08	27616	9216.65	3
2011	35	3	3521606	7.2048e+07	7815	9219.19	3
2011	41	4	4108551	3.041551e+07	3299	9219.61	3
2011	52	5	5201603	3.484781e+07	3778	9223.88	3
2011	17	1	1700350	5.197944e+07	5633	9227.67	3
2011	31	3	3102803	1.1227078e+08	12163	9230.52	3
2011	23	2	2310209	2.950409e+08	31951	9234.17	3
2011	51	5	5106273	3.480309e+07	3768	9236.49	3
2011	13	1	1301852	3.8272418e+08	41374	9250.35	3
2011	41	4	4102505	1.1604638e+08	12545	9250.41	3
2011	41	4	4115507	4.259599e+07	4603	9253.96	3
2011	26	2	2610004	5.5413507e+08	59813	9264.46	3
2011	35	3	3550001	9.631758e+07	10395	9265.76	3
2011	31	3	3129905	3.140203e+07	3389	9265.87	3
2011	31	3	3130606	6.433428e+07	6941	9268.73	3
2011	31	3	3111903	5.177584e+07	5584	9272.18	3
2011	52	5	5200803	7.535205e+07	8125	9274.1	3
2011	31	3	3150604	5.935534e+07	6399	9275.72	3
2011	31	3	3138500	4.928323e+07	5312	9277.72	3
2011	31	3	3129806	1.49403276e+09	160943	9282.99	3
2011	51	5	5100359	5.01734e+07	5403	9286.21	3
2011	31	3	3109600	3.386168e+07	3645	9289.9	3
2011	16	1	1600212	4.465416e+07	4805	9293.27	3
2011	31	3	3149507	2.952745e+07	3177	9294.13	3
2011	31	3	3148756	6.234076e+07	6707	9294.88	3
2011	41	4	4103503	7.533334e+07	8100	9300.41	3
2011	31	3	3103009	8.868845e+07	9529	9307.22	3
2011	28	2	2807105	3.6167209e+08	38847	9310.17	3
2011	12	1	1200104	2.0347879e+08	21837	9318.07	3
2011	15	1	1500131	6.378497e+07	6844	9319.84	3
2011	31	3	3110202	3.763228e+07	4037	9321.84	3
2011	17	1	1707108	5.975338e+07	6409	9323.35	3
2011	17	1	1704600	1.249922e+07	1340	9327.77	3
2011	31	3	3102001	1.2850007e+08	13774	9329.18	3
2011	43	4	4300307	6.473604e+07	6935	9334.69	3
2011	51	5	5106703	1.628197e+07	1744	9335.99	3
2011	29	2	2932903	8.360936e+08	89510	9340.78	3
2011	17	1	1717206	2.734728e+07	2927	9343.11	3
2011	29	2	2914604	6.2519919e+08	66865	9350.17	3
2011	24	2	2401651	2.243422e+07	2399	9351.49	3
2011	35	3	3531704	3.890503e+07	4159	9354.42	3
2011	15	1	1503457	4.98873e+08	53318	9356.56	3
2011	17	1	1702307	6.290089e+07	6721	9358.86	3
2011	31	3	3108404	1.3970504e+08	14907	9371.77	3
2011	52	5	5212006	2.801448e+07	2989	9372.52	3
2011	52	5	5221700	1.2956729e+08	13818	9376.7	3
2011	15	1	1500206	5.0371562e+08	53680	9383.67	3
2011	52	5	5204904	1.7375972e+08	18515	9384.81	3
2011	33	3	3301405	2.0164822e+08	21416	9415.77	3
2011	35	3	3505005	2.958494e+07	3141	9418.96	3
2011	35	3	3529104	1.985476e+07	2107	9423.23	3
2011	31	3	3117504	1.6824743e+08	17853	9424.04	3
2011	26	2	2611408	1.2779544e+08	13560	9424.44	3
2011	17	1	1703206	4.194333e+07	4449	9427.59	3
2011	17	1	1717503	6.394914e+07	6783	9427.85	3
2011	26	2	2612000	1.0424775e+08	11056	9429.07	3
2011	31	3	3148202	5.016494e+07	5320	9429.5	3
2011	11	1	1101757	8.977224e+07	9511	9438.78	3
2011	31	3	3112406	6.672185e+07	7064	9445.34	3
2011	24	2	2410009	3.294725e+07	3488	9445.89	3
2011	15	1	1504455	2.6272246e+08	27785	9455.55	3
2011	31	3	3110400	2.955357e+07	3125	9457.14	3
2011	52	5	5215801	2.210202e+07	2337	9457.43	3
2011	29	2	2918407	1.88929433e+09	199761	9457.77	3
2011	52	5	5200100	1.5216294e+08	16088	9458.16	3
2011	23	2	2307601	5.373558e+08	56774	9464.82	3
2011	24	2	2409407	2.6479112e+08	27975	9465.28	3
2011	25	2	2516201	6.2632201e+08	66136	9470.21	3
2011	31	3	3107000	2.478263e+07	2616	9473.48	3
2011	43	4	4310702	3.874153e+07	4089	9474.57	3
2011	17	1	1720903	1.4402904e+08	15196	9478.09	3
2011	43	4	4321436	9.459186e+07	9976	9481.94	3
2011	31	3	3152709	8.015648e+07	8444	9492.71	3
2011	31	3	3155306	5.055952e+07	5325	9494.75	3
2011	11	1	1100130	3.0179239e+08	31780	9496.3	3
2011	35	3	3512605	4.70645e+07	4956	9496.47	3
2011	26	2	2612505	8.5256423e+08	89773	9496.89	3
2011	11	1	1100148	1.8899216e+08	19883	9505.21	3
2011	31	3	3106101	3.233683e+07	3402	9505.24	3
2011	35	3	3549201	2.432786e+07	2559	9506.78	3
2011	35	3	3548203	6.179866e+07	6499	9508.95	3
2011	35	3	3510302	1.6912529e+08	17785	9509.43	3
2011	17	1	1705102	3.117374e+07	3278	9509.99	3
2011	51	5	5106174	2.958503e+07	3110	9512.87	3
2011	29	2	2910107	1.0852831e+08	11405	9515.85	3
2011	52	5	5200050	6.684834e+07	7023	9518.49	3
2011	41	4	4113759	4.876313e+07	5122	9520.33	3
2011	15	1	1503606	9.3032224e+08	97704	9521.84	3
2011	29	2	2925501	2.6416426e+08	27661	9550.06	3
2011	31	3	3131505	9.135293e+07	9565	9550.75	3
2011	31	3	3114006	1.0475516e+08	10968	9550.98	3
2011	35	3	3544103	4.2506588e+08	44503	9551.4	3
2011	29	2	2904704	1.7735201e+08	18566	9552.52	3
2011	31	3	3104908	1.7546133e+08	18368	9552.56	3
2011	31	3	3141900	3.669584e+07	3841	9553.72	3
2011	31	3	3158805	4.417737e+07	4623	9556	3
2011	25	2	2509339	4.150039e+07	4340	9562.3	3
2011	31	3	3112307	3.358425e+08	35090	9570.89	3
2011	35	3	3533254	4.496178e+07	4697	9572.45	3
2011	16	1	1600055	4.274317e+07	4464	9575.08	3
2011	12	1	1200203	7.5848334e+08	79174	9579.95	3
2011	35	3	3553104	5.670943e+07	5916	9585.77	3
2011	31	3	3107307	4.5006416e+08	46950	9586.03	3
2011	52	5	5216809	9.8528e+07	10276	9588.17	3
2011	31	3	3165206	6.416205e+07	6690	9590.74	3
2011	27	2	2701001	2.4843042e+08	25895	9593.76	3
2011	41	4	4120309	3.855698e+07	4018	9596.06	3
2011	35	3	3516804	4.070016e+07	4240	9599.09	3
2011	31	3	3117702	1.2500712e+08	13001	9615.19	3
2011	27	2	2702405	4.6665039e+08	48493	9623.05	3
2011	41	4	4127882	6.216731e+07	6460	9623.42	3
2011	32	3	3200201	2.9574018e+08	30696	9634.49	3
2011	31	3	3119708	3.190604e+07	3310	9639.29	3
2011	26	2	2608503	1.9951383e+08	20697	9639.75	3
2011	41	4	4125357	5.783344e+07	5998	9642.12	3
2011	52	5	5213855	2.262954e+07	2346	9646.01	3
2011	52	5	5210562	4.367428e+07	4523	9656.04	3
2011	17	1	1702406	1.0254379e+08	10619	9656.63	3
2011	35	3	3534906	1.2836499e+08	13281	9665.31	3
2011	31	3	3115508	2.0964779e+08	21673	9673.22	3
2011	32	3	3202009	6.207336e+07	6414	9677.79	3
2011	35	3	3556958	1.686058e+07	1742	9678.86	3
2011	41	4	4121000	1.1378352e+08	11752	9682.06	3
2011	42	4	4216800	8.895873e+07	9188	9682.06	3
2011	15	1	1500800	4.63145859e+09	477999	9689.26	3
2011	52	5	5214101	3.723062e+07	3841	9692.95	3
2011	21	2	2104552	1.5783227e+08	16280	9694.86	3
2011	35	3	3518008	1.908074e+07	1968	9695.5	3
2011	51	5	5106208	4.358255e+07	4495	9695.78	3
2011	16	1	1600279	3.9592471e+08	40820	9699.28	3
2011	26	2	2615300	5.2029866e+08	53589	9709.06	3
2011	14	1	1400027	9.357252e+07	9637	9709.71	3
2011	41	4	4115739	3.65836e+07	3766	9714.18	3
2011	29	2	2908101	1.7675176e+08	18195	9714.3	3
2011	26	2	2605707	2.8800796e+08	29635	9718.51	3
2011	17	1	1700400	7.30738e+07	7518	9719.85	3
2011	25	2	2515708	2.902115e+07	2985	9722.33	3
2011	31	3	3122405	5.6207e+07	5781	9722.71	3
2011	43	4	4306502	1.4047298e+08	14443	9726.03	3
2011	23	2	2311504	1.9076417e+08	19608	9728.89	3
2011	31	3	3172103	4.953337e+07	5082	9746.83	3
2011	43	4	4321352	5.217915e+07	5352	9749.47	3
2011	35	3	3549003	2.719073e+07	2788	9752.77	3
2011	26	2	2615409	3.5713607e+08	36610	9755.15	3
2011	29	2	2917508	7.750128e+08	79417	9758.78	3
2011	35	3	3528601	8.831058e+07	9048	9760.23	3
2011	17	1	1703883	2.285369e+07	2340	9766.53	3
2011	35	3	3525508	1.1597093e+08	11873	9767.62	3
2011	35	3	3534807	7.668619e+07	7851	9767.7	3
2011	41	4	4117214	3.839782e+07	3931	9767.95	3
2011	35	3	3546900	8.088847e+07	8279	9770.32	3
2011	31	3	3111309	1.1218865e+08	11480	9772.53	3
2011	25	2	2506301	5.441499e+08	55657	9776.85	3
2011	43	4	4304507	5.221753e+08	53399	9778.75	3
2011	31	3	3155801	1.6788485e+08	17168	9778.94	3
2011	50	5	5000708	2.3411733e+08	23940	9779.34	3
2011	51	5	5103437	4.789045e+07	4893	9787.54	3
2011	35	3	3502408	3.684467e+07	3764	9788.7	3
2011	31	3	3109402	2.6433225e+08	27001	9789.72	3
2011	23	2	2307304	2.47550446e+09	252841	9790.76	3
2011	29	2	2907509	5.0339346e+08	51411	9791.55	3
2011	52	5	5211206	2.5534833e+08	26078	9791.71	3
2011	43	4	4320354	5.113813e+07	5222	9792.83	3
2011	33	3	3303955	2.2494042e+08	22968	9793.64	3
2011	15	1	1501451	1.6115305e+08	16451	9795.94	3
2011	22	2	2207405	4.877874e+07	4978	9798.86	3
2011	35	3	3505609	2.8250595e+08	28826	9800.39	3
2011	27	2	2708303	2.2356013e+08	22798	9806.13	3
2011	35	3	3553906	6.548157e+07	6671	9815.86	3
2011	13	1	1301159	2.4011407e+08	24442	9823.83	3
2011	11	1	1101609	1.0432763e+08	10612	9831.1	3
2011	35	3	3546504	5.46304e+07	5555	9834.45	3
2011	29	2	2918001	1.49625794e+09	152138	9834.87	3
2011	35	3	3501509	2.964784e+07	3013	9839.97	3
2011	43	4	4311254	6.140867e+07	6240	9841.13	3
2011	17	1	1707553	3.742511e+07	3802	9843.53	3
2011	35	3	3546306	2.9808463e+08	30268	9848.18	3
2011	27	2	2702108	1.9929474e+08	20213	9859.73	3
2011	41	4	4126256	8.255692e+08	83724	9860.6	3
2011	14	1	1400605	6.766841e+07	6861	9862.76	3
2011	41	4	4110078	1.1261406e+08	11413	9867.17	3
2011	31	3	3134806	7.412885e+07	7511	9869.37	3
2011	52	5	5209200	1.3802785e+08	13985	9869.71	3
2011	17	1	1713601	6.758833e+07	6833	9891.46	3
2011	51	5	5107206	5.016999e+07	5069	9897.41	3
2011	23	2	2313807	1.9825923e+08	20031	9897.62	3
2011	31	3	3110103	4.964188e+07	5015	9898.68	3
2011	29	2	2909802	5.8568221e+08	59045	9919.25	3
2011	52	5	5215603	2.7916734e+08	28144	9919.25	3
2011	52	5	5215256	3.965733e+07	3997	9921.77	3
2011	23	2	2303709	3.28305986e+09	330855	9922.96	3
2011	35	3	3552700	1.4719461e+08	14817	9934.17	3
2011	31	3	3114600	3.927322e+07	3953	9935.04	3
2011	31	3	3162906	2.4992616e+08	25155	9935.45	3
2011	35	3	3555505	4.420043e+07	4448	9937.15	3
2011	32	3	3204252	6.991455e+07	7034	9939.52	3
2011	51	5	5103353	2.5530722e+08	25684	9940.32	3
2011	52	5	5219506	2.843259e+07	2860	9941.47	3
2011	31	3	3123528	7.412959e+07	7456	9942.27	3
2011	31	3	3161502	1.0404303e+08	10459	9947.7	3
2011	41	4	4112504	1.2161866e+08	12221	9951.61	3
2011	42	4	4207205	1.1489259e+08	11540	9956.03	3
2011	43	4	4301636	1.1075815e+08	11118	9962.06	3
2011	31	3	3145802	3.050991e+07	3061	9967.3	3
2011	23	2	2305506	9.7055239e+08	97331	9971.67	3
2011	31	3	3124005	1.7968437e+08	18018	9972.49	3
2011	16	1	1600402	1.7375211e+08	17420	9974.29	3
2011	35	3	3529807	1.2056567e+08	12087	9974.82	3
2011	26	2	2600054	9.4617898e+08	94843	9976.27	3
2011	32	3	3203007	2.7360066e+08	27422	9977.41	3
2011	35	3	3500808	3.898028e+07	3906	9979.59	3
2011	35	3	3554607	2.636642e+07	2640	9987.28	3
2011	52	5	5204656	3.652624e+07	3653	9998.97	3
2011	11	1	1100502	1.0084589e+08	10084	10000.58	3
2011	32	3	3204500	1.2224223e+08	12223	10001	3
2011	29	2	2931350	1.40751148e+09	140710	10002.92	3
2011	28	2	2804508	3.2960192e+08	32926	10010.38	3
2011	51	5	5101308	1.0236542e+08	10218	10018.15	3
2011	52	5	5214705	2.269255e+07	2265	10018.79	3
2011	35	3	3508702	1.8589252e+08	18551	10020.62	3
2011	51	5	5106851	3.579303e+07	3568	10031.68	3
2011	41	4	4122156	1.3702094e+08	13652	10036.69	3
2011	14	1	1400233	8.331342e+07	8300	10037.76	3
2011	43	4	4300638	6.426244e+07	6401	10039.44	3
2011	35	3	3539400	1.2244065e+08	12187	10046.82	3
2011	41	4	4107009	1.4080886e+08	14002	10056.34	3
2011	43	4	4312450	6.285884e+07	6245	10065.47	3
2011	31	3	3166402	1.806672e+07	1793	10076.25	3
2011	35	3	3520426	9.275316e+07	9204	10077.48	3
2011	31	3	3100807	4.124654e+07	4092	10079.8	3
2011	52	5	5219605	3.97413e+07	3942	10081.51	3
2011	31	3	3101003	1.289968e+08	12787	10088.12	3
2011	33	3	3302809	1.8148273e+08	17981	10093.03	3
2011	51	5	5106315	2.087514e+07	2068	10094.36	3
2011	43	4	4314704	1.0571808e+08	10465	10102.06	3
2011	41	4	4104451	1.3095556e+08	12963	10102.26	3
2011	52	5	5219902	6.193946e+07	6128	10107.61	3
2011	43	4	4321832	2.921991e+07	2890	10110.7	3
2011	35	3	3554409	8.659415e+07	8563	10112.6	3
2011	11	1	1101708	1.298447e+08	12828	10121.98	3
2011	27	2	2700300	2.18757228e+09	216108	10122.59	3
2011	11	1	1100403	1.7666398e+08	17444	10127.49	3
2011	52	5	5203939	2.588172e+07	2553	10137.77	3
2011	31	3	3120409	5.08503e+07	5015	10139.64	3
2011	11	1	1101302	1.1947807e+08	11781	10141.59	3
2011	35	3	3509304	9.963642e+07	9814	10152.48	3
2011	52	5	5210901	1.9098612e+08	18806	10155.59	3
2011	42	4	4209409	5.2683583e+08	51869	10157.05	3
2011	43	4	4314209	7.913511e+07	7789	10159.86	3
2011	43	4	4323101	5.307904e+07	5221	10166.45	3
2011	23	2	2301109	7.0955793e+08	69771	10169.81	3
2011	31	3	3113305	3.2883285e+08	32325	10172.71	3
2011	41	4	4116208	1.6031647e+08	15753	10176.88	3
2011	35	3	3517307	5.538396e+07	5442	10177.13	3
2011	41	4	4103156	3.837355e+07	3769	10181.36	3
2011	52	5	5204854	6.476424e+07	6361	10181.46	3
2011	35	3	3526100	1.9498438e+08	19149	10182.48	3
2011	52	5	5206800	2.813509e+07	2761	10190.18	3
2011	41	4	4115101	1.041718e+08	10219	10193.93	3
2011	52	5	5221858	1.38611554e+09	135909	10198.85	3
2011	13	1	1303569	2.687156e+08	26344	10200.26	3
2011	31	3	3123205	1.4011757e+08	13732	10203.73	3
2011	35	3	3553500	8.133796e+07	7970	10205.52	3
2011	26	2	2604007	7.7290893e+08	75706	10209.35	3
2011	41	4	4107652	8.4880534e+08	83118	10212.05	3
2011	43	4	4314605	2.0299295e+08	19874	10214	3
2011	35	3	3544707	2.443769e+07	2392	10216.42	3
2011	31	3	3153707	3.399586e+07	3325	10224.32	3
2011	11	1	1101435	7.604973e+07	7437	10225.86	3
2011	41	4	4105102	1.1403258e+08	11142	10234.48	3
2011	14	1	1400456	1.0955589e+08	10698	10240.78	3
2011	32	3	3204054	2.4518591e+08	23935	10243.82	3
2011	43	4	4301073	2.811029e+07	2743	10248.01	3
2011	17	1	1703602	2.127027e+07	2075	10250.73	3
2011	24	2	2407609	4.331663e+07	4225	10252.46	3
2011	43	4	4311122	4.235525e+07	4129	10257.99	3
2011	43	4	4317004	8.427475e+07	8213	10261.14	3
2011	41	4	4100459	4.207456e+07	4100	10262.09	3
2011	33	3	3300159	1.0659595e+08	10382	10267.38	3
2011	33	3	3301876	2.4108378e+08	23475	10269.81	3
2011	26	2	2609600	3.88936895e+09	378538	10274.71	3
2011	41	4	4103479	4.382735e+07	4263	10280.87	3
2011	31	3	3119401	1.07132129e+09	104174	10283.96	3
2011	31	3	3142106	1.0580335e+08	10288	10284.15	3
2011	42	4	4210704	2.893178e+07	2811	10292.34	3
2011	31	3	3125309	3.457599e+07	3359	10293.54	3
2011	52	5	5204607	3.5043e+07	3404	10294.65	3
2011	31	3	3110004	4.231623e+08	41092	10297.92	3
2011	51	5	5105176	1.2022622e+08	11671	10301.28	3
2011	41	4	4104402	1.6988154e+08	16491	10301.47	3
2011	31	3	3137502	1.7755088e+08	17228	10305.95	3
2011	41	4	4107751	8.491154e+07	8236	10309.8	3
2011	41	4	4123709	9.002357e+07	8730	10311.98	3
2011	33	3	3303609	4.9167488e+08	47635	10321.71	3
2011	31	3	3166709	8.701746e+07	8430	10322.36	3
2011	43	4	4301750	7.27697e+07	7046	10327.8	3
2011	13	1	1302504	8.8948109e+08	86078	10333.43	3
2011	31	3	3149002	2.299902e+07	2220	10359.92	3
2011	35	3	3534104	6.34163e+07	6120	10362.14	3
2011	16	1	1600501	2.1866857e+08	21095	10365.9	3
2011	31	3	3114105	1.4353847e+08	13843	10369.03	3
2011	12	1	1200252	1.5966412e+08	15394	10371.84	3
2011	11	1	1101484	6.161616e+07	5939	10374.84	3
2011	14	1	1400175	1.4851224e+08	14312	10376.76	3
2011	31	3	3169000	1.6501546e+08	15886	10387.48	3
2011	33	3	3303005	2.7871519e+08	26827	10389.35	3
2011	41	4	4103107	1.1570814e+08	11136	10390.46	3
2011	41	4	4119954	2.2266565e+08	21427	10391.83	3
2011	27	2	2707800	6.891405e+07	6631	10392.71	3
2011	41	4	4111704	5.119749e+07	4926	10393.32	3
2011	52	5	5207535	7.226091e+07	6950	10397.25	3
2011	43	4	4306908	2.558173e+08	24604	10397.39	3
2011	16	1	1600105	8.467634e+07	8142	10399.94	3
2011	31	3	3106903	1.4286034e+08	13720	10412.56	3
2011	31	3	3102902	1.1595843e+08	11133	10415.74	3
2011	31	3	3124401	4.636947e+07	4450	10420.11	3
2011	52	5	5218391	3.36324e+07	3227	10422.19	3
2011	31	3	3168309	3.9805e+07	3818	10425.62	3
2011	17	1	1711100	2.545693e+07	2440	10433.17	3
2011	43	4	4312377	3.244863e+07	3107	10443.72	3
2011	41	4	4100301	8.722924e+07	8351	10445.36	3
2011	31	3	3128808	7.505196e+07	7185	10445.64	3
2011	25	2	2503704	6.1459951e+08	58794	10453.44	3
2011	15	1	1502202	6.7099814e+08	64140	10461.46	3
2011	31	3	3161205	6.789469e+07	6480	10477.58	3
2011	52	5	5202155	7.886933e+07	7526	10479.58	3
2011	26	2	2606002	1.36628478e+09	130303	10485.44	3
2011	41	4	4121208	1.8069883e+08	17229	10488.06	3
2011	52	5	5220157	4.889591e+07	4658	10497.19	3
2011	29	2	2913457	1.3839873e+08	13183	10498.27	3
2011	51	5	5103007	1.887935e+08	17980	10500.19	3
2011	31	3	3145505	2.682911e+07	2555	10500.63	3
2011	11	1	1100346	1.7457431e+08	16625	10500.71	3
2011	41	4	4107124	3.676826e+07	3499	10508.22	3
2011	52	5	5208301	5.197509e+07	4946	10508.51	3
2011	22	2	2208007	7.8825865e+08	74967	10514.74	3
2011	42	4	4206207	1.1250689e+08	10698	10516.63	3
2011	35	3	3521150	4.77373e+07	4539	10517.14	3
2011	52	5	5221007	3.722162e+07	3538	10520.52	3
2011	35	3	3531100	4.9613353e+08	47153	10521.78	3
2011	52	5	5221908	3.862057e+07	3670	10523.31	3
2011	31	3	3108305	1.823345e+08	17324	10524.97	3
2011	52	5	5221403	1.118547e+09	106256	10526.91	3
2011	42	4	4203204	6.7378299e+08	63967	10533.29	3
2011	16	1	1600550	4.119334e+07	3909	10538.08	3
2011	42	4	4215356	4.156463e+07	3943	10541.37	3
2011	31	3	3122702	5.475433e+07	5194	10541.84	3
2011	41	4	4123956	3.799829e+07	3601	10552.15	3
2011	26	2	2604809	1.3122682e+08	12435	10553.02	3
2011	35	3	3540507	8.930261e+07	8455	10562.11	3
2011	31	3	3129202	6.503691e+07	6157	10563.08	3
2011	43	4	4302006	1.1743176e+08	11117	10563.26	3
2011	52	5	5200829	3.661471e+07	3462	10576.17	3
2011	51	5	5107263	3.174544e+07	3001	10578.29	3
2011	11	1	1100379	1.3569125e+08	12825	10580.21	3
2011	42	4	4201000	9.003969e+07	8497	10596.64	3
2011	52	5	5200159	2.627578e+07	2479	10599.35	3
2011	41	4	4110805	1.1205598e+08	10568	10603.33	3
2011	24	2	2402006	6.6976598e+08	63148	10606.29	3
2011	52	5	5219803	1.2111775e+08	11398	10626.23	3
2011	21	2	2100055	1.11851959e+09	105255	10626.76	3
2011	24	2	2401404	9.176442e+07	8631	10631.96	3
2011	42	4	4201950	1.0496007e+08	9858	10647.2	3
2011	35	3	3510708	1.2594231e+08	11821	10654.12	3
2011	52	5	5220280	2.124785e+07	1994	10655.89	3
2011	35	3	3521705	1.8951463e+08	17778	10660.06	3
2011	52	5	5209804	4.258336e+07	3990	10672.52	3
2011	24	2	2403103	4.5719729e+08	42795	10683.43	3
2011	31	3	3102050	5.710723e+07	5345	10684.23	3
2011	35	3	3518909	5.123394e+07	4790	10696.02	3
2011	31	3	3102308	1.6298088e+08	15236	10697.09	3
2011	52	5	5203401	9.043761e+07	8451	10701.41	3
2011	43	4	4315305	2.4568529e+08	22946	10707.11	3
2011	31	3	3119104	2.5566304e+08	23866	10712.44	3
2011	35	3	3557204	1.2972642e+08	12108	10714.11	3
2011	29	2	2915502	2.2482439e+08	20978	10717.15	3
2011	42	4	4217154	2.0326e+07	1896	10720.46	3
2011	52	5	5212808	1.131571e+08	10550	10725.79	3
2011	31	3	3171402	3.985206e+07	3715	10727.34	3
2011	50	5	5004007	1.0643627e+08	9919	10730.54	3
2011	31	3	3140209	3.00805e+07	2803	10731.54	3
2011	52	5	5202601	3.869804e+07	3606	10731.57	3
2011	31	3	3154150	7.106433e+07	6619	10736.41	3
2011	35	3	3542503	8.084384e+07	7522	10747.65	3
2011	43	4	4308805	9.056092e+07	8425	10749.07	3
2011	33	3	3300456	5.07759394e+09	472008	10757.43	3
2011	28	2	2804904	1.4277548e+08	13260	10767.38	3
2011	11	1	1100338	2.4936946e+08	23143	10775.16	3
2011	52	5	5208905	2.6450055e+08	24544	10776.59	3
2011	35	3	3551009	3.60986504e+09	334663	10786.57	3
2011	13	1	1300102	1.8021133e+08	16701	10790.45	3
2011	35	3	3519253	7.157103e+07	6631	10793.4	3
2011	35	3	3503950	1.949767e+07	1806	10796.05	3
2011	31	3	3144300	4.4037676e+08	40774	10800.43	3
2011	33	3	3301157	1.3621327e+08	12601	10809.72	3
2011	23	2	2305100	4.390648e+07	4059	10817.07	3
2011	32	3	3204401	1.2267823e+08	11330	10827.73	3
2011	42	4	4204178	3.83584e+07	3542	10829.59	3
2011	29	2	2925303	1.40071008e+09	129325	10830.93	3
2011	31	3	3165305	7.665004e+07	7073	10836.99	3
2011	50	5	5007703	1.1671943e+08	10769	10838.47	3
2011	41	4	4112702	1.2918068e+08	11918	10839.12	3
2011	52	5	5207600	6.789587e+07	6263	10840.79	3
2011	35	3	3517208	1.16919e+08	10782	10843.91	3
2011	32	3	3204807	1.129617e+08	10403	10858.57	3
2011	31	3	3118304	1.2767316e+09	117562	10860.07	3
2011	22	2	2204402	1.1313654e+08	10416	10861.8	3
2011	33	3	3301504	2.2350111e+08	20571	10864.86	3
2011	32	3	3202306	3.0479451e+08	28033	10872.7	3
2011	33	3	3303104	1.6396181e+08	15079	10873.52	3
2011	35	3	3522109	9.6041488e+08	88214	10887.33	3
2011	51	5	5108808	5.310122e+07	4877	10888.09	3
2011	31	3	3128105	1.5135456e+08	13892	10895.09	3
2011	51	5	5107750	4.186313e+07	3842	10896.18	3
2011	15	1	1502400	1.91993057e+09	176116	10901.51	3
2011	33	3	3306156	1.0472721e+08	9600	10909.08	3
2011	31	3	3130200	1.0269187e+08	9411	10911.9	3
2011	31	3	3160603	3.515758e+07	3219	10921.89	3
2011	11	1	1101005	1.1225306e+08	10272	10928.06	3
2011	42	4	4216404	7.670631e+07	7019	10928.38	3
2011	43	4	4314498	4.94241e+07	4522	10929.7	3
2011	35	3	3501806	6.24689e+07	5715	10930.69	3
2011	31	3	3100203	2.4840921e+08	22716	10935.43	3
2011	42	4	4206009	1.4337642e+08	13107	10938.92	3
2011	35	3	3532108	4.598937e+07	4203	10942.03	3
2011	31	3	3124203	2.5223944e+08	23035	10950.27	3
2011	35	3	3549508	9.235067e+07	8432	10952.4	3
2011	52	5	5210208	3.4268923e+08	31273	10957.99	3
2011	31	3	3159704	3.543413e+07	3233	10960.14	3
2011	31	3	3104304	1.5180995e+08	13847	10963.38	3
2011	43	4	4312252	8.398058e+07	7655	10970.68	3
2011	31	3	3161809	1.1613593e+08	10585	10971.75	3
2011	35	3	3507704	5.571808e+07	5070	10989.76	3
2011	52	5	5207105	2.723528e+07	2478	10990.83	3
2011	43	4	4319356	3.684649e+07	3352	10992.39	3
2011	43	4	4305132	4.912146e+07	4467	10996.52	3
2011	14	1	1400209	2.0588349e+08	18714	11001.58	3
2011	41	4	4126900	6.383494e+07	5802	11002.23	3
2011	21	2	2110658	7.742342e+07	7037	11002.33	3
2011	43	4	4312443	3.473277e+07	3156	11005.31	3
2011	35	3	3537909	2.9275637e+08	26595	11007.95	3
2011	52	5	5211800	4.6830999e+08	42530	11011.29	3
2011	52	5	5213004	1.2902471e+08	11717	11011.75	3
2011	35	3	3540259	4.53286e+07	4116	11012.78	3
2011	50	5	5003488	1.1513283e+08	10442	11025.94	3
2011	17	1	1712009	3.094928e+07	2806	11029.68	3
2011	35	3	3548401	4.757229e+07	4313	11029.98	3
2011	23	2	2309607	6.9729019e+08	63202	11032.72	3
2011	35	3	3521507	8.079724e+07	7323	11033.35	3
2011	43	4	4310504	8.822371e+07	7989	11043.15	3
2011	35	3	3523503	2.0170316e+08	18253	11050.41	3
2011	35	3	3548609	1.1577948e+08	10477	11050.82	3
2011	42	4	4214151	3.061896e+07	2770	11053.78	3
2011	11	1	1101476	3.830214e+07	3464	11057.2	3
2011	41	4	4113304	3.4121042e+08	30835	11065.69	3
2011	31	3	3114907	2.483657e+07	2243	11072.93	3
2011	43	4	4322152	4.87622e+07	4402	11077.28	3
2011	22	2	2203909	6.419123e+08	57928	11081.21	3
2011	27	2	2707909	7.681458e+07	6930	11084.35	3
2011	43	4	4311981	4.180028e+07	3771	11084.67	3
2011	33	3	3305901	1.144078e+08	10309	11097.86	3
2011	31	3	3100302	1.4770432e+08	13309	11098.08	3
2011	31	3	3154309	1.8980239e+08	17098	11100.85	3
2011	35	3	3541208	1.4972787e+08	13487	11101.64	3
2011	35	3	3537701	5.926816e+07	5338	11103.06	3
2011	51	5	5106000	7.077148e+07	6374	11103.15	3
2011	41	4	4106803	2.0074475e+08	18069	11109.9	3
2011	35	3	3541901	1.2751988e+08	11478	11109.94	3
2011	41	4	4121752	8.173713e+07	7356	11111.63	3
2011	41	4	4102901	1.7665535e+08	15892	11115.99	3
2011	31	3	3128907	8.152755e+07	7333	11117.9	3
2011	35	3	3505104	7.396121e+07	6652	11118.64	3
2011	35	3	3523206	5.3416657e+08	48040	11119.2	3
2011	31	3	3162302	3.03857e+07	2730	11130.29	3
2011	35	3	3516002	1.446334e+08	12982	11141.07	3
2011	29	2	2903276	1.5987045e+08	14346	11143.9	3
2011	43	4	4300505	8.755861e+07	7856	11145.44	3
2011	52	5	5200605	7.735124e+07	6939	11147.32	3
2011	27	2	2703205	2.612469e+08	23434	11148.2	3
2011	17	1	1713809	6.496108e+07	5826	11150.2	3
2011	43	4	4306072	3.148354e+07	2823	11152.51	3
2011	31	3	3110301	1.5279727e+08	13700	11153.09	3
2011	31	3	3142205	1.5519013e+08	13911	11155.93	3
2011	35	3	3545100	5.412892e+07	4851	11158.3	3
2011	31	3	3128006	3.5215934e+08	31526	11170.44	3
2011	12	1	1200013	1.4276079e+08	12779	11171.52	3
2011	42	4	4215075	5.377346e+07	4813	11172.55	3
2011	41	4	4119251	2.938486e+07	2630	11172.95	3
2011	35	3	3535200	1.0648169e+08	9528	11175.66	3
2011	41	4	4114351	3.44052e+07	3076	11185.05	3
2011	15	1	1506138	8.5574848e+08	76501	11186.11	3
2011	12	1	1200450	2.2806263e+08	20387	11186.67	3
2011	42	4	4202081	3.229028e+07	2886	11188.59	3
2011	27	2	2700607	8.58103e+07	7666	11193.62	3
2011	43	4	4310538	5.646527e+07	5044	11194.54	3
2011	41	4	4103206	7.378398e+07	6591	11194.66	3
2011	35	3	3513900	1.247987e+08	11146	11196.73	3
2011	41	4	4111308	3.940236e+07	3517	11203.4	3
2011	41	4	4110904	5.104231e+07	4553	11210.7	3
2011	35	3	3508900	4.566101e+07	4072	11213.41	3
2011	35	3	3515103	7.0894684e+08	63219	11214.14	3
2011	31	3	3137700	2.200927e+08	19616	11220.06	3
2011	17	1	1701101	4.788371e+07	4267	11221.87	3
2011	52	5	5210307	3.231557e+07	2879	11224.58	3
2011	52	5	5208806	3.9122446e+08	34852	11225.31	3
2011	31	3	3159209	1.0116172e+08	9008	11230.21	3
2011	31	3	3132206	1.3990775e+08	12455	11233.06	3
2011	14	1	1400159	1.243402e+08	11068	11234.21	3
2011	43	4	4318101	2.1502023e+08	19135	11237.01	3
2011	17	1	1705508	3.5144741e+08	31263	11241.64	3
2011	33	3	3302502	2.57430842e+09	228972	11242.9	3
2011	35	3	3538907	2.5756465e+08	22905	11244.91	3
2011	24	2	2413359	1.1750857e+08	10445	11250.22	3
2011	41	4	4107157	5.669289e+07	5039	11250.82	3
2011	42	4	4205159	4.101292e+07	3645	11251.83	3
2011	35	3	3538600	2.8420246e+08	25252	11254.65	3
2011	11	1	1100064	2.0642524e+08	18338	11256.69	3
2011	31	3	3130002	3.237434e+07	2875	11260.64	3
2011	31	3	3101409	3.287361e+07	2919	11261.94	3
2011	41	4	4108650	8.402373e+07	7459	11264.74	3
2011	31	3	3120904	8.4192878e+08	74734	11265.67	3
2011	43	4	4320263	7.963845e+07	7069	11265.87	3
2011	43	4	4320651	2.732264e+07	2425	11267.07	3
2011	27	2	2706901	3.7712375e+08	33467	11268.53	3
2011	43	4	4321477	7.197446e+07	6382	11277.73	3
2011	41	4	4108007	1.2582626e+08	11148	11286.89	3
2011	24	2	2400208	6.0553619e+08	53636	11289.73	3
2011	52	5	5221577	3.303184e+07	2925	11292.94	3
2011	43	4	4308300	1.204073e+08	10662	11293.13	3
2011	26	2	2613909	9.020316e+08	79871	11293.61	3
2011	42	4	4215687	3.226937e+07	2857	11294.84	3
2011	35	3	3546256	2.223014e+07	1966	11307.29	3
2011	35	3	3523107	3.68856524e+09	325518	11331.37	3
2011	35	3	3526209	3.2764009e+08	28912	11332.32	3
2011	41	4	4124707	1.281376e+08	11306	11333.59	3
2011	35	3	3538204	1.5040225e+08	13268	11335.71	3
2011	28	2	2805703	3.2345035e+08	28533	11336.01	3
2011	33	3	3304904	1.142847103e+10	1008065	11337.04	3
2011	35	3	3508603	3.4381456e+08	30313	11342.15	3
2011	35	3	3554805	4.7028749e+08	41457	11343.98	3
2011	52	5	5219407	8.018158e+07	7066	11347.52	3
2011	41	4	4127908	9.845754e+07	8671	11354.81	3
2011	31	3	3151404	2.9011994e+08	25545	11357.21	3
2011	28	2	2802908	9.9658732e+08	87747	11357.51	3
2011	41	4	4124004	5.930285e+07	5220	11360.7	3
2011	29	2	2907400	2.990143e+07	2632	11360.73	3
2011	31	3	3139706	8.223604e+07	7235	11366.42	3
2011	11	1	1101203	1.1688064e+08	10277	11373.03	3
2011	11	1	1100254	2.5051006e+08	22009	11382.16	3
2011	33	3	3303203	1.79509028e+09	157710	11382.22	3
2011	31	3	3130507	1.3165272e+08	11562	11386.67	3
2011	50	5	5005608	2.9371114e+08	25794	11386.8	3
2011	15	1	1501782	6.1540338e+08	54032	11389.61	3
2011	41	4	4109609	3.698074e+08	32467	11390.25	3
2011	27	2	2708501	3.7174354e+08	32633	11391.64	3
2011	35	3	3535903	4.364276e+07	3830	11394.98	3
2011	14	1	1400472	2.8270339e+08	24808	11395.65	3
2011	41	4	4116406	4.47791e+07	3929	11397.07	3
2011	17	1	1718840	3.793114e+07	3326	11404.43	3
2011	35	3	3541109	4.686421e+07	4109	11405.26	3
2011	31	3	3114709	3.837045e+07	3361	11416.38	3
2011	21	2	2109007	2.4994529e+08	21890	11418.24	3
2011	11	1	1101807	9.233568e+07	8084	11422.03	3
2011	31	3	3120201	1.3053412e+08	11422	11428.31	3
2011	11	1	1101450	5.60266e+07	4902	11429.33	3
2011	51	5	5107883	1.592145e+07	1393	11429.62	3
2011	41	4	4118006	1.3649349e+08	11929	11442.16	3
2011	41	4	4125456	4.360737e+07	3810	11445.5	3
2011	35	3	3530003	3.248386e+07	2838	11446.04	3
2011	41	4	4116000	2.123948e+07	1855	11449.86	3
2011	50	5	5004106	1.1813753e+08	10309	11459.65	3
2011	35	3	3553856	5.964946e+07	5204	11462.23	3
2011	51	5	5108352	3.498533e+07	3052	11463.08	3
2011	33	3	3305604	2.4484425e+08	21356	11464.89	3
2011	41	4	4102752	4.476412e+07	3903	11469.16	3
2011	52	5	5221304	3.234292e+07	2819	11473.19	3
2011	35	3	3509106	5.857578e+07	5105	11474.2	3
2011	51	5	5102504	1.01469308e+09	88428	11474.79	3
2011	35	3	3554904	6.251925e+07	5448	11475.63	3
2011	35	3	3536257	2.344403e+07	2039	11497.81	3
2011	41	4	4100608	1.5798206e+08	13736	11501.31	3
2011	31	3	3158953	3.2177413e+08	27965	11506.32	3
2011	29	2	2917904	1.1922292e+08	10355	11513.56	3
2011	17	1	1718899	2.476443e+07	2150	11518.34	3
2011	43	4	4320859	4.813801e+07	4175	11530.06	3
2011	31	3	3133501	2.4664732e+08	21388	11532.04	3
2011	41	4	4108452	6.16649e+07	5347	11532.62	3
2011	15	1	1508084	3.9599177e+08	34334	11533.52	3
2011	35	3	3501301	2.7241271e+08	23579	11553.19	3
2011	41	4	4128401	1.3218825e+08	11441	11553.91	3
2011	11	1	1101500	1.3433286e+08	11624	11556.51	3
2011	33	3	3304607	1.1924335e+08	10310	11565.8	3
2011	24	2	2412203	4.6442133e+08	40150	11567.16	3
2011	31	3	3160405	3.0275873e+08	26168	11569.81	3
2011	11	1	1100452	3.8085165e+08	32899	11576.39	3
2011	11	1	1100015	2.8050958e+08	24228	11577.91	3
2011	50	5	5007950	1.1961466e+08	10330	11579.35	3
2011	42	4	4205357	1.839092e+07	1587	11588.48	3
2011	35	3	3535606	2.0203381e+08	17418	11599.14	3
2011	43	4	4303400	5.83915e+07	5032	11604.03	3
2011	35	3	3517604	2.0736998e+08	17866	11606.96	3
2011	35	3	3538303	4.115145e+07	3542	11618.14	3
2011	31	3	3165800	2.126132e+07	1830	11618.21	3
2011	52	5	5214051	7.331974e+07	6310	11619.61	3
2011	33	3	3301850	6.1028822e+08	52522	11619.67	3
2011	41	4	4109203	5.994654e+07	5159	11619.8	3
2011	41	4	4122107	3.855717e+07	3318	11620.61	3
2011	51	5	5102694	5.546306e+07	4771	11625.04	3
2011	43	4	4319208	6.597301e+07	5675	11625.2	3
2011	35	3	3503109	7.128553e+07	6128	11632.76	3
2011	35	3	3532843	2.429182e+07	2086	11645.17	3
2011	25	2	2513703	1.41151808e+09	121166	11649.46	3
2011	43	4	4316428	3.019289e+07	2591	11652.99	3
2011	35	3	3514502	1.425692e+08	12234	11653.52	3
2011	41	4	4107520	2.267183e+07	1945	11656.47	3
2011	35	3	3518503	1.7382324e+08	14901	11665.21	3
2011	42	4	4215901	3.49061e+07	2992	11666.48	3
2011	43	4	4315008	6.228812e+07	5338	11668.81	3
2011	41	4	4113429	4.56372e+07	3911	11668.93	3
2011	31	3	3101102	2.9116724e+08	24948	11670.97	3
2011	35	3	3507159	4.201223e+07	3598	11676.55	3
2011	41	4	4100202	7.391876e+07	6328	11681.22	3
2011	32	3	3201704	1.3715888e+08	11741	11682.04	3
2011	52	5	5217302	2.7038756e+08	23142	11683.85	3
2011	41	4	4128500	2.253077e+08	19278	11687.3	3
2011	43	4	4315073	2.113253e+07	1806	11701.29	3
2011	43	4	4314555	3.17411e+07	2712	11703.94	3
2011	31	3	3160702	5.4142734e+08	46246	11707.55	3
2011	31	3	3141207	4.397805e+07	3756	11708.75	3
2011	35	3	3527504	2.642978e+07	2257	11710.14	3
2011	35	3	3500402	8.926007e+07	7619	11715.46	3
2011	11	1	1101559	5.662273e+07	4832	11718.28	3
2011	17	1	1715507	1.223436e+07	1044	11718.74	3
2011	52	5	5200506	2.397921e+07	2046	11720.04	3
2011	35	3	3530409	5.086197e+07	4338	11724.75	3
2011	41	4	4106209	1.8871292e+08	16095	11724.94	3
2011	31	3	3118700	1.0865555e+08	9265	11727.53	3
2011	31	3	3131000	6.806799e+07	5804	11727.77	3
2011	51	5	5108600	2.5610023e+08	21828	11732.65	3
2011	35	3	3528205	4.29146e+07	3657	11734.92	3
2011	31	3	3108008	2.0260592e+08	17257	11740.51	3
2011	43	4	4311429	2.923073e+07	2489	11743.96	3
2011	51	5	5106828	1.3051811e+08	11111	11746.75	3
2011	42	4	4213807	8.543955e+07	7266	11758.82	3
2011	51	5	5102850	9.719171e+07	8265	11759.43	3
2011	15	1	1503903	5.6814114e+08	48306	11761.3	3
2011	41	4	4106555	4.624708e+07	3930	11767.7	3
2011	17	1	1702000	1.0293396e+08	8744	11771.95	3
2011	32	3	3202108	2.730112e+08	23154	11791.1	3
2011	52	5	5218904	2.2379952e+08	18979	11791.96	3
2011	41	4	4116109	1.4796068e+08	12546	11793.45	3
2011	52	5	5213400	2.057189e+07	1744	11795.81	3
2011	41	4	4123105	4.433302e+07	3757	11800.11	3
2011	11	1	1100700	1.5058229e+08	12758	11802.97	3
2011	52	5	5216908	3.222995e+07	2730	11805.84	3
2011	15	1	1505031	2.9680844e+08	25138	11807.16	3
2011	42	4	4202156	3.118102e+07	2639	11815.47	3
2011	31	3	3102407	4.194414e+07	3548	11821.91	3
2011	13	1	1302009	9.791122e+07	8281	11823.6	3
2011	43	4	4305454	1.5324012e+08	12959	11825	3
2011	41	4	4127809	1.0295936e+08	8704	11828.97	3
2011	52	5	5211404	1.0171566e+08	8598	11830.15	3
2011	43	4	4305447	5.89188e+07	4978	11835.84	3
2011	35	3	3556800	2.0598356e+08	17400	11838.14	3
2011	35	3	3510203	5.4620002e+08	46136	11838.91	3
2011	35	3	3519402	1.3037849e+08	11008	11843.98	3
2011	35	3	3516606	8.228114e+07	6947	11844.13	3
2011	24	2	2401453	2.9121174e+08	24586	11844.62	3
2011	35	3	3533007	2.2932656e+08	19346	11853.95	3
2011	31	3	3104601	1.5595004e+08	13145	11863.83	3
2011	32	3	3202900	1.2860452e+08	10840	11863.89	3
2011	35	3	3506300	1.2792312e+08	10780	11866.71	3
2011	14	1	1400506	8.186663e+07	6898	11868.17	3
2011	31	3	3140902	2.1060099e+08	17743	11869.53	3
2011	43	4	4309753	5.192304e+07	4374	11870.84	3
2011	35	3	3543238	2.594132e+07	2185	11872.46	3
2011	31	3	3157807	2.4270994e+09	204327	11878.51	3
2011	52	5	5203575	4.246965e+07	3573	11886.27	3
2011	43	4	4309159	4.748854e+07	3994	11889.97	3
2011	31	3	3168606	1.60766561e+09	135154	11895.06	3
2011	12	1	1200138	1.0270242e+08	8629	11902.01	3
2011	41	4	4120606	5.8242411e+08	48933	11902.48	3
2011	42	4	4207601	5.624713e+07	4725	11904.15	3
2011	35	3	3543105	5.125203e+07	4304	11908	3
2011	31	3	3139102	5.857464e+07	4918	11910.26	3
2011	29	2	2916856	1.6419635e+08	13775	11919.88	3
2011	15	1	1506161	2.1115414e+08	17713	11920.86	3
2011	35	3	3527009	8.12414e+07	6814	11922.72	3
2011	31	3	3166907	8.999738e+07	7545	11928.08	3
2011	31	3	3167509	3.033126e+07	2542	11932.05	3
2011	35	3	3544202	1.2803315e+08	10730	11932.26	3
2011	23	2	2301000	8.7788138e+08	73562	11933.9	3
2011	35	3	3511201	8.557818e+07	7171	11933.92	3
2011	35	3	3514809	1.7521588e+08	14680	11935.69	3
2011	50	5	5007307	5.975082e+07	5006	11935.84	3
2011	43	4	4311007	3.3158828e+08	27766	11942.24	3
2011	41	4	4110300	3.577121e+07	2994	11947.63	3
2011	52	5	5200902	4.264017e+07	3568	11950.72	3
2011	51	5	5104104	3.8872668e+08	32525	11951.63	3
2011	50	5	5002100	2.7866856e+08	23290	11965.16	3
2011	31	3	3146909	1.7121223e+08	14306	11967.86	3
2011	33	3	3305208	1.07412887e+09	89739	11969.48	3
2011	29	2	2907004	1.0733379e+08	8966	11971.2	3
2011	43	4	4313490	4.773399e+07	3987	11972.41	3
2011	43	4	4302659	5.628997e+07	4701	11974.04	3
2011	43	4	4301602	1.40038017e+09	116944	11974.79	3
2011	41	4	4102406	3.8418372e+08	32066	11981.03	3
2011	31	3	3127909	1.645043e+07	1373	11981.37	3
2011	43	4	4312104	6.084903e+07	5076	11987.59	3
2011	11	1	1100098	3.4758109e+08	28963	12000.87	3
2011	31	3	3137106	9.113072e+07	7592	12003.52	3
2011	35	3	3514205	2.512273e+07	2092	12008.95	3
2011	33	3	3304102	2.1495324e+08	17899	12009.23	3
2011	35	3	3504909	1.232668e+08	10263	12010.8	3
2011	43	4	4317103	9.8273651e+08	81821	12010.81	3
2011	43	4	4321667	1.2344789e+08	10271	12019.07	3
2011	31	3	3111606	3.3311454e+08	27682	12033.62	3
2011	33	3	3303856	3.1856697e+08	26469	12035.47	3
2011	51	5	5106265	9.042632e+07	7512	12037.58	3
2011	41	4	4122172	4.710893e+07	3909	12051.4	3
2011	24	2	2413201	4.787095e+07	3972	12052.1	3
2011	52	5	5201207	1.241765e+07	1030	12055.97	3
2011	17	1	1718907	5.533114e+07	4588	12059.97	3
2011	31	3	3111200	6.2391616e+08	51725	12062.18	3
2011	42	4	4203709	1.2951186e+08	10726	12074.57	3
2011	43	4	4314068	6.258423e+07	5183	12074.9	3
2011	33	3	3304409	2.115218e+08	17517	12075.23	3
2011	31	3	3144102	2.4667477e+08	20418	12081.24	3
2011	41	4	4119707	4.95969e+07	4103	12087.96	3
2011	43	4	4321493	3.549787e+07	2934	12098.8	3
2011	41	4	4108106	3.088262e+07	2552	12101.34	3
2011	42	4	4210209	3.982715e+07	3290	12105.52	3
2011	33	3	3305307	1.0817781e+08	8933	12109.91	3
2011	52	5	5203609	3.958203e+07	3268	12112	3
2011	43	4	4302451	9.281799e+07	7662	12114.07	3
2011	31	3	3114204	2.4529485e+08	20232	12124.1	3
2011	25	2	2511202	3.3208802e+08	27389	12124.87	3
2011	52	5	5210158	3.451806e+07	2846	12128.62	3
2011	35	3	3508009	2.2604468e+08	18635	12130.11	3
2011	31	3	3162104	3.9011201e+08	32141	12137.52	3
2011	31	3	3112000	1.7733695e+08	14606	12141.38	3
2011	35	3	3515400	1.8647593e+08	15344	12153.02	3
2011	41	4	4118303	3.430073e+07	2822	12154.76	3
2011	32	3	3201902	3.8859632e+08	31946	12164.16	3
2011	31	3	3117900	1.2898347e+08	10602	12165.96	3
2011	43	4	4314027	8.940781e+07	7346	12170.95	3
2011	35	3	3551504	4.7914934e+08	39360	12173.51	3
2011	42	4	4205431	3.15599e+07	2592	12175.89	3
2011	51	5	5101209	1.31254e+07	1077	12187	3
2011	35	3	3547650	1.771267e+07	1453	12190.41	3
2011	43	4	4304663	2.9688438e+08	24343	12195.88	3
2011	32	3	3202702	1.7208532e+08	14107	12198.58	3
2011	43	4	4308433	3.013362e+07	2469	12204.79	3
2011	41	4	4112405	1.0509712e+08	8610	12206.4	3
2011	41	4	4124400	2.3169922e+08	18972	12212.69	3
2011	32	3	3200136	1.1618893e+08	9513	12213.7	3
2011	35	3	3544806	6.743593e+07	5520	12216.65	3
2011	31	3	3120706	4.827633e+07	3951	12218.76	3
2011	35	3	3533700	5.088489e+07	4163	12223.13	3
2011	43	4	4320453	2.749714e+07	2249	12226.39	3
2011	50	5	5001102	5.5989118e+08	45781	12229.77	3
2011	52	5	5208004	1.2442026e+09	101731	12230.32	3
2011	35	3	3547700	2.5016826e+08	20454	12230.77	3
2011	31	3	3111002	2.5325795e+08	20697	12236.46	3
2011	15	1	1507755	6.294757e+07	5144	12237.09	3
2011	35	3	3553005	1.3571197e+08	11086	12241.74	3
2011	35	3	3549300	2.568948e+07	2098	12244.75	3
2011	32	3	3204708	3.9513023e+08	32264	12246.78	3
2011	41	4	4117602	5.3297297e+08	43508	1.225e+04	3
2011	43	4	4319737	3.24553e+07	2649	12251.9	3
2011	35	3	3519709	8.8002557e+08	71742	12266.53	3
2011	41	4	4113502	2.6166691e+08	21328	12268.7	3
2011	41	4	4108700	8.013485e+07	6530	12271.8	3
2011	52	5	5204102	1.3132459e+08	10700	12273.33	3
2011	41	4	4115705	3.6624515e+08	29831	12277.33	3
2011	43	4	4311601	7.023028e+07	5720	12278.02	3
2011	52	5	5219456	3.910865e+07	3185	12279.01	3
2011	42	4	4219150	3.408813e+07	2776	12279.59	3
2011	41	4	4118808	1.6749503e+08	13635	12284.2	3
2011	31	3	3156700	1.56132629e+09	127097	12284.53	3
2011	50	5	5005004	3.0091622e+08	24485	12289.82	3
2011	11	1	1101492	2.009059e+08	16341	12294.59	3
2011	42	4	4218103	6.526165e+07	5307	12297.28	3
2011	17	1	1700301	6.539136e+07	5317	12298.55	3
2011	41	4	4109757	7.481105e+07	6081	12302.43	3
2011	31	3	3138674	7.666245e+07	6230	12305.37	3
2011	31	3	3144409	5.735982e+07	4660	12308.97	3
2011	31	3	3165404	7.759683e+07	6302	12313.05	3
2011	41	4	4117305	2.8632629e+08	23240	12320.41	3
2011	32	3	3203601	6.946528e+07	5637	12323.09	3
2011	26	2	2604106	3.93928268e+09	319580	12326.44	3
2011	35	3	3500758	6.138483e+07	4979	12328.75	3
2011	50	5	5003504	6.673638e+07	5413	12328.91	3
2011	29	2	2904605	7.9934535e+08	64790	12337.48	3
2011	52	5	5218003	5.2552709e+08	42568	12345.59	3
2011	35	3	3553203	6.719781e+07	5443	12345.73	3
2011	41	4	4117297	3.48768e+07	2825	12345.77	3
2011	15	1	1501253	4.204282e+07	3405	12347.38	3
2011	17	1	1703701	6.433743e+07	5209	12351.21	3
2011	41	4	4111506	3.9287815e+08	31782	12361.66	3
2011	51	5	5106158	1.4839396e+08	12004	12362.04	3
2011	31	3	3167400	7.475888e+07	6041	12375.25	3
2011	43	4	4323457	5.220995e+07	4218	12377.89	3
2011	31	3	3117207	3.406722e+07	2752	12379.08	3
2011	31	3	3100104	8.327908e+07	6724	12385.35	3
2011	32	3	3202652	1.4654068e+08	11829	12388.26	3
2011	35	3	3541505	4.7025002e+08	37954	1.239e+04	3
2011	16	1	1600600	1.27449043e+09	102861	12390.41	3
2011	31	3	3144607	3.1999336e+08	25803	12401.4	3
2011	35	3	3543808	1.2298214e+08	9911	12408.65	3
2011	11	1	1101401	1.7627418e+08	14204	12410.18	3
2011	50	5	5003454	1.5140722e+08	12200	12410.43	3
2011	11	1	1100031	7.721719e+07	6221	12412.34	3
2011	35	3	3526605	8.238737e+07	6635	12417.09	3
2011	35	3	3530201	2.1269527e+08	17124	12420.89	3
2011	41	4	4125001	1.4158789e+08	11397	12423.26	3
2011	31	3	3113404	1.06631985e+09	85811	12426.38	3
2011	41	4	4111001	8.372653e+07	6734	12433.4	3
2011	43	4	4313391	4.823202e+07	3878	12437.34	3
2011	43	4	4320677	1.2513866e+08	10058	12441.7	3
2011	32	3	3201001	1.7722079e+08	14239	12446.15	3
2011	41	4	4116802	9.005162e+07	7234	12448.39	3
2011	14	1	1400308	1.8753932e+08	15065	12448.68	3
2011	17	1	1709807	2.086983e+07	1676	12452.16	3
2011	32	3	3204351	2.1959516e+08	17623	12460.71	3
2011	35	3	3520707	4.850586e+07	3892	12462.97	3
2011	43	4	4309126	2.803671e+07	2248	12471.85	3
2011	29	2	2912806	1.0021375e+08	8023	12490.81	3
2011	32	3	3203403	3.2346052e+08	25880	12498.47	3
2011	35	3	3550803	1.5089357e+08	12072	12499.47	3
2011	32	3	3204955	1.4180514e+08	11341	12503.76	3
2011	51	5	5106190	4.360428e+07	3487	12504.81	3
2011	31	3	3109501	1.7298949e+08	13831	12507.37	3
2011	52	5	5208509	6.614595e+07	5288	12508.69	3
2011	52	5	5215207	4.339608e+07	3469	12509.68	3
2011	43	4	4318457	3.377134e+07	2699	12512.54	3
2011	31	3	3150505	1.03466e+08	8268	12514.03	3
2011	33	3	3301801	1.6675627e+08	13324	12515.48	3
2011	11	1	1100809	2.5398236e+08	20292	12516.38	3
2011	31	3	3136900	1.1716446e+08	9358	12520.25	3
2011	43	4	4322400	1.56926066e+09	125320	12522.03	3
2011	42	4	4202057	1.0790692e+08	8614	12526.92	3
2011	42	4	4218400	8.63102e+07	6889	12528.7	3
2011	29	2	2906907	2.6964382e+08	21515	12532.83	3
2011	52	5	5206503	4.446253e+07	3547	12535.25	3
2011	43	4	4319406	2.0459382e+08	16321	12535.62	3
2011	51	5	5105580	1.4820107e+08	11819	12539.22	3
2011	31	3	3103207	2.822883e+07	2251	12540.57	3
2011	31	3	3138401	6.4307262e+08	51210	12557.56	3
2011	35	3	3515806	2.1604e+07	1720	12560.46	3
2011	15	1	1502764	1.3587122e+08	10811	12567.87	3
2011	31	3	3145604	4.9873411e+08	39637	12582.54	3
2011	52	5	5210000	6.1136863e+08	48580	12584.78	3
2011	31	3	3165107	8.910387e+07	7077	12590.63	3
2011	31	3	3130804	3.326966e+07	2640	12602.14	3
2011	11	1	1100296	1.0936623e+08	8678	12602.7	3
2011	31	3	3145455	6.735083e+07	5343	12605.43	3
2011	51	5	5100805	1.0989823e+08	8713	12613.13	3
2011	26	2	2611101	3.78119999e+09	299752	12614.43	3
2011	52	5	5214804	2.615026e+07	2073	12614.7	3
2011	41	4	4124905	7.443117e+07	5898	12619.73	3
2011	15	1	1501501	6.6784365e+08	52888	12627.51	3
2011	42	4	4215059	3.07889e+07	2438	12628.75	3
2011	35	3	3515129	3.827576e+07	3030	12632.27	3
2011	43	4	4308409	8.807915e+07	6970	12636.89	3
2011	52	5	5208608	7.6261451e+08	60347	12637.16	3
2011	43	4	4316303	9.046839e+07	7158	12638.78	3
2011	11	1	1100908	4.457921e+07	3527	12639.41	3
2011	28	2	2804003	2.0750627e+08	16412	12643.57	3
2011	50	5	5005806	1.813191e+08	14338	12646.05	3
2011	43	4	4311106	1.4412813e+08	11396	12647.26	3
2011	16	1	1600204	1.1610039e+08	9175	12653.99	3
2011	43	4	4303202	6.1734e+07	4876	12660.79	3
2011	41	4	4107546	5.853447e+07	4623	12661.58	3
2011	51	5	5103809	4.759988e+07	3757	12669.65	3
2011	31	3	3115805	1.3010716e+08	10269	12669.9	3
2011	35	3	3551108	1.1558943e+08	9121	12672.89	3
2011	31	3	3171303	9.225387e+08	72786	12674.67	3
2011	31	3	3137809	2.4924327e+08	19655	12680.91	3
2011	26	2	2601706	9.2223124e+08	72719	12682.12	3
2011	41	4	4113809	5.854599e+07	4613	12691.52	3
2011	29	2	2933307	3.93758922e+09	310129	12696.62	3
2011	31	3	3113602	8.044635e+07	6336	12696.71	3
2011	52	5	5204706	1.4253814e+08	11224	12699.41	3
2011	31	3	3116407	5.799727e+07	4566	12701.99	3
2011	22	2	2201903	2.9401785e+08	23144	12703.85	3
2011	33	3	3304805	4.7768094e+08	37601	12703.94	3
2011	33	3	3305554	1.00611463e+09	79179	12706.84	3
2011	41	4	4125407	8.230634e+07	6476	12709.44	3
2011	31	3	3103603	3.580656e+07	2817	12710.88	3
2011	42	4	4210852	3.17314e+07	2495	12718	3
2011	42	4	4217956	2.223134e+07	1748	12718.16	3
2011	41	4	4119004	8.542836e+07	6716	12720.13	3
2011	17	1	1708205	2.342015e+08	18398	12729.73	3
2011	31	3	3151701	2.0398537e+08	16022	12731.58	3
2011	16	1	1600535	2.1970111e+08	17252	12734.82	3
2011	41	4	4112306	6.246543e+07	4904	12737.65	3
2011	35	3	3506607	3.678562e+08	28877	12738.73	3
2011	41	4	4128625	4.028973e+07	3162	12741.85	3
2011	41	4	4113106	5.692601e+07	4465	12749.39	3
2011	42	4	4213609	4.2864005e+08	33619	12749.93	3
2011	31	3	3101904	2.3720195e+08	18600	12752.79	3
2011	43	4	4321600	5.4116174e+08	42395	12764.75	3
2011	43	4	4322327	4.478838e+07	3508	12767.5	3
2011	35	3	3547205	2.070919e+07	1622	12767.69	3
2011	42	4	4205555	3.110749e+07	2436	12769.91	3
2011	13	1	1301902	1.1233697e+09	87970	12769.92	3
2011	31	3	3120508	1.3027824e+08	10201	12771.12	3
2011	12	1	1200179	1.1614875e+08	9088	12780.45	3
2011	41	4	4119806	1.7406705e+08	13619	12781.19	3
2011	24	2	2411056	4.761023e+07	3725	12781.27	3
2011	15	1	1500602	1.28818241e+09	100736	12787.71	4
2011	32	3	3202256	1.4058283e+08	10990	12791.89	4
2011	41	4	4109906	1.1192276e+08	8747	12795.56	4
2011	43	4	4307203	6.560432e+07	5126	12798.35	4
2011	31	3	3112703	1.8295869e+08	14290	12803.27	4
2011	41	4	4105805	2.76251948e+09	215242	12834.48	4
2011	43	4	4306551	3.266182e+07	2544	12838.76	4
2011	33	3	3301603	1.4101618e+08	10976	12847.68	4
2011	52	5	5215009	1.0618477e+08	8261	12853.74	4
2011	52	5	5219357	4.749248e+07	3694	12856.65	4
2011	41	4	4115408	1.7898199e+08	13919	12858.83	4
2011	43	4	4322376	3.132795e+07	2436	12860.41	4
2011	42	4	4209706	1.5247133e+08	11850	12866.78	4
2011	29	2	2910503	5.1505005e+08	40029	12866.92	4
2011	35	3	3540101	4.459961e+07	3465	12871.46	4
2011	41	4	4123808	1.7049988e+08	13242	12875.69	4
2011	43	4	4321105	2.1446325e+08	16655	12876.81	4
2011	35	3	3544509	3.710144e+07	2881	12877.97	4
2011	41	4	4106100	4.700711e+07	3650	12878.66	4
2011	35	3	3550209	4.0584177e+08	31501	12883.46	4
2011	31	3	3160900	4.550722e+07	3531	12887.91	4
2011	33	3	3300605	4.5829094e+08	35546	12892.9	4
2011	41	4	4121505	1.8349568e+08	14216	12907.69	4
2011	42	4	4201109	4.147907e+07	3213	12909.76	4
2011	32	3	3200904	5.2789561e+08	40884	12912.03	4
2011	35	3	3538105	1.9616632e+08	15188	12915.88	4
2011	35	3	3520202	1.1477234e+08	8873	12935.01	4
2011	43	4	4315057	3.264366e+07	2523	12938.43	4
2011	33	3	3302304	9.647917e+07	7455	12941.54	4
2011	43	4	4319307	8.155396e+07	6301	12943.02	4
2011	43	4	4317400	6.3444929e+08	49005	12946.62	4
2011	31	3	3145109	2.0060263e+08	15489	12951.3	4
2011	28	2	2804805	2.11170011e+09	163047	12951.48	4
2011	41	4	4120200	3.276459e+07	2529	12955.55	4
2011	43	4	4302907	1.7557553e+08	13551	12956.65	4
2011	32	3	3205036	2.4962142e+08	19265	12957.25	4
2011	52	5	5203807	7.162795e+07	5527	12959.64	4
2011	43	4	4318804	5.5858128e+08	43067	12970.05	4
2011	32	3	3204906	1.43261385e+09	110454	12970.23	4
2011	52	5	5221601	4.828247e+08	37190	12982.65	4
2011	35	3	3532405	2.1513314e+08	16568	12984.86	4
2011	26	2	2606200	9.8692812e+08	75987	12988.12	4
2011	21	2	2111607	2.2959173e+08	17674	12990.37	4
2011	41	4	4110607	1.9327253e+08	14869	12998.35	4
2011	41	4	4119608	4.2117628e+08	32391	13002.88	4
2011	17	1	1706258	2.052045e+07	1578	13004.09	4
2011	43	4	4314159	1.0492377e+08	8068	13004.93	4
2011	42	4	4212502	3.3446665e+08	25714	13007.18	4
2011	35	3	3535408	1.9064934e+08	14655	13009.17	4
2011	35	3	3536901	3.313241e+07	2545	13018.63	4
2011	41	4	4116950	6.627409e+07	5086	13030.69	4
2011	43	4	4312005	2.85458e+07	2190	13034.61	4
2011	42	4	4219358	6.757619e+07	5184	13035.53	4
2011	50	5	5003801	2.4807918e+08	19030	13036.22	4
2011	31	3	3143203	2.7700769e+08	21236	13044.25	4
2011	32	3	3201159	1.5570991e+08	11933	13048.68	4
2011	35	3	3556404	5.1551709e+08	39494	13053.05	4
2011	35	3	3543709	1.360631e+08	10421	13056.63	4
2011	35	3	3555109	1.8739685e+08	14345	13063.57	4
2011	41	4	4121257	5.429404e+07	4155	13067.16	4
2011	31	3	3135704	6.736639e+07	5155	13068.16	4
2011	35	3	3537800	6.8366354e+08	52298	13072.46	4
2011	31	3	3150109	3.699194e+07	2829	13075.98	4
2011	42	4	4209151	6.18827e+07	4731	13080.26	4
2011	35	3	3553807	2.9189411e+08	22315	13080.62	4
2011	43	4	4303707	7.914048e+07	6049	13083.23	4
2011	35	3	3555406	1.04298823e+09	79718	13083.47	4
2011	41	4	4125902	3.236994e+07	2473	13089.34	4
2011	31	3	3134509	5.100983e+07	3896	13092.87	4
2011	35	3	3550506	9.458979e+07	7222	13097.45	4
2011	21	2	2105302	3.26209609e+09	248806	13111	4
2011	43	4	4315552	4.63339e+07	3533	13114.61	4
2011	17	1	1718451	3.14674e+07	2399	13116.88	4
2011	43	4	4322541	6.801215e+07	5178	13134.83	4
2011	52	5	5202502	1.008905e+08	7681	13135.07	4
2011	41	4	4100806	1.3612422e+08	10363	13135.6	4
2011	43	4	4312203	6.380255e+07	4855	13141.62	4
2011	43	4	4318051	3.857324e+07	2934	13146.98	4
2011	35	3	3532801	7.859289e+07	5978	13147.02	4
2011	43	4	4300455	5.549197e+07	4220	13149.76	4
2011	31	3	3143401	2.8206173e+08	21434	13159.55	4
2011	32	3	3202405	1.40285339e+09	106583	13162.07	4
2011	32	3	3204609	2.8866689e+08	21916	13171.51	4
2011	43	4	4305116	3.889877e+07	2953	13172.63	4
2011	35	3	3552106	4.8741136e+08	36992	13176.13	4
2011	31	3	3143500	1.0943401e+08	8305	13176.88	4
2011	31	3	3115102	2.2960682e+08	17423	13178.37	4
2011	43	4	4306700	4.433018e+07	3363	13181.74	4
2011	35	3	3543600	4.542253e+07	3445	13185.06	4
2011	52	5	5220009	1.3887472e+08	10528	13190.99	4
2011	11	1	1100940	2.1879008e+08	16570	13203.99	4
2011	21	2	2104305	1.3896536e+08	10523	13205.87	4
2011	41	4	4108320	8.427247e+07	6377	13215.07	4
2011	43	4	4307450	4.275717e+07	3235	13217.05	4
2011	24	2	2401008	4.6007909e+08	34809	13217.25	4
2011	41	4	4106001	1.0987175e+08	8312	13218.45	4
2011	31	3	3123403	1.913019e+07	1447	13220.59	4
2011	35	3	3517000	1.4274023e+08	10796	13221.58	4
2011	43	4	4311908	6.690189e+07	5060	13221.72	4
2011	43	4	4301404	1.3517077e+08	10223	13222.22	4
2011	42	4	4211801	9.732516e+07	7360	13223.53	4
2011	50	5	5000609	4.6479138e+08	35133	13229.48	4
2011	51	5	5106257	2.6172838e+08	19783	13229.96	4
2011	35	3	3525409	4.17087e+07	3151	13236.65	4
2011	43	4	4322525	4.331596e+07	3269	13250.52	4
2011	52	5	5219001	1.0011746e+08	7552	13257.08	4
2011	35	3	3521002	3.8547283e+08	29062	13263.81	4
2011	41	4	4126009	1.1451509e+08	8632	13266.34	4
2011	31	3	3164001	1.0997216e+08	8289	13267.24	4
2011	41	4	4105706	2.27692e+08	17156	13271.86	4
2011	29	2	2928703	1.22202365e+09	92049	13275.79	4
2011	43	4	4315701	4.9887911e+08	37577	13276.18	4
2011	32	3	3201605	3.7992205e+08	28600	13283.99	4
2011	31	3	3110707	1.6751555e+08	12607	13287.5	4
2011	31	3	3110905	2.0647095e+08	15536	13289.84	4
2011	23	2	2312403	5.9228244e+08	44526	13301.95	4
2011	29	2	2912202	2.3345486e+08	17548	13303.79	4
2011	31	3	3119005	4.578261e+07	3441	13305.03	4
2011	43	4	4319802	1.1241978e+08	8448	13307.27	4
2011	31	3	3143005	1.7384297e+08	13055	13316.2	4
2011	31	3	3116605	3.4654058e+08	26021	13317.73	4
2011	31	3	3159506	7.552198e+07	5670	13319.57	4
2011	51	5	5107800	2.4906736e+08	18696	13321.96	4
2011	42	4	4200705	1.2595187e+08	9453	13324.01	4
2011	29	2	2914802	2.73531e+09	205286	13324.39	4
2011	35	3	3502903	3.714095e+08	27874	13324.59	4
2011	42	4	4211058	1.245561e+08	9347	13325.78	4
2011	52	5	5204201	1.881204e+07	1411	13332.42	4
2011	43	4	4310652	3.421118e+07	2565	13337.69	4
2011	31	3	3168804	9.40849e+07	7054	13337.81	4
2011	52	5	5216304	1.2233635e+08	9170	13340.93	4
2011	42	4	4202099	2.481528e+07	1860	13341.55	4
2011	29	2	2916401	9.2220921e+08	69067	13352.39	4
2011	26	2	2607901	8.684332e+09	649788	13364.87	4
2011	33	3	3302106	3.0597147e+08	22892	13365.87	4
2011	35	3	3533809	3.54177e+07	2649	13370.22	4
2011	51	5	5108055	1.4853581e+08	11107	13373.17	4
2011	43	4	4315156	8.237124e+07	6158	13376.3	4
2011	43	4	4302402	1.5431007e+08	11525	13389.16	4
2011	21	2	2104057	4.9334336e+08	36826	13396.6	4
2011	33	3	3301900	2.95361466e+09	220352	13404.07	4
2011	35	3	3504404	1.5423749e+08	11501	13410.79	4
2011	35	3	3513207	1.0280848e+08	7666	13410.97	4
2011	35	3	3516408	1.79098549e+09	133407	13424.97	4
2011	42	4	4219853	4.05308e+07	3019	13425.24	4
2011	41	4	4102604	1.3119339e+08	9766	13433.69	4
2011	52	5	5205703	3.501579e+07	2606	13436.6	4
2011	52	5	5211008	1.0219253e+08	7604	13439.31	4
2011	43	4	4302808	4.518124e+08	33617	1.344e+04	4
2011	35	3	3528106	1.0335001e+08	7685	13448.28	4
2011	31	3	3117108	1.3254481e+08	9855	13449.5	4
2011	31	3	3135001	4.038177e+07	3001	13456.1	4
2011	11	1	1101104	1.171042e+08	8700	13460.25	4
2011	11	1	1100155	5.0778965e+08	37702	13468.51	4
2011	32	3	3200300	1.8833486e+08	13982	13469.81	4
2011	43	4	4309571	3.981895e+07	2954	13479.67	4
2011	31	3	3105608	1.71495539e+09	127218	13480.45	4
2011	52	5	5212501	2.38858362e+09	177099	13487.28	4
2011	35	3	3542909	1.6462078e+08	12204	13489.08	4
2011	31	3	3143906	1.36844202e+09	101431	13491.36	4
2011	43	4	4322905	7.087955e+07	5252	13495.73	4
2011	31	3	3139508	2.9004585e+08	21487	13498.67	4
2011	35	3	3514924	4.268529e+07	3162	13499.46	4
2011	41	4	4127304	2.0703949e+08	15331	13504.63	4
2011	52	5	5220058	2.24824e+07	1664	13511.05	4
2011	43	4	4314753	2.730061e+07	2020	13515.15	4
2011	43	4	4323507	3.813407e+07	2820	13522.72	4
2011	41	4	4124053	2.8443658e+08	21031	13524.63	4
2011	41	4	4106456	9.816797e+07	7256	13529.21	4
2011	35	3	3539004	1.444379e+08	10668	13539.36	4
2011	33	3	3300209	1.5473248e+09	114250	13543.32	4
2011	43	4	4321402	1.8528536e+08	13672	13552.18	4
2011	42	4	4207809	1.3013996e+08	9595	13563.31	4
2011	31	3	3106408	1.0236153e+08	7545	13566.8	4
2011	43	4	4304408	5.3809636e+08	39660	13567.73	4
2011	43	4	4301909	1.7136152e+08	12628	13569.96	4
2011	31	3	3117801	1.42522e+08	10500	13573.52	4
2011	41	4	4114500	1.788979e+08	13177	13576.53	4
2011	41	4	4120705	9.597921e+07	7069	13577.48	4
2011	52	5	5220207	3.0216045e+08	22244	13583.91	4
2011	31	3	3135308	5.400141e+07	3975	13585.26	4
2011	51	5	5106455	3.68868e+07	2715	13586.3	4
2011	35	3	3526506	1.2310707e+08	9060	13587.98	4
2011	32	3	3203908	6.2864963e+08	46263	13588.6	4
2011	35	3	3506904	1.3307749e+08	9792	13590.43	4
2011	35	3	3509403	3.2041133e+08	23571	13593.46	4
2011	41	4	4103305	1.054624e+08	7758	13594.02	4
2011	43	4	4304853	2.153295e+07	1584	13594.04	4
2011	43	4	4313805	9.415695e+07	6919	13608.46	4
2011	33	3	3305752	4.2320382e+08	31091	13611.78	4
2011	43	4	4312054	5.520493e+07	4055	13614.04	4
2011	43	4	4305157	3.271613e+07	2403	13614.7	4
2011	31	3	3152907	1.1955877e+08	8776	13623.38	4
2011	41	4	4126702	6.401449e+07	4696	13631.71	4
2011	43	4	4321329	4.049674e+07	2970	13635.27	4
2011	41	4	4111258	3.3063885e+08	24236	13642.47	4
2011	42	4	4201505	1.0672547e+08	7821	13646.01	4
2011	35	3	3502606	6.022117e+07	4413	13646.31	4
2011	32	3	3205010	3.3127477e+08	24271	13649	4
2011	41	4	4124103	5.8588793e+08	42920	13650.7	4
2011	41	4	4117008	1.1106272e+08	8135	13652.46	4
2011	35	3	3516853	6.066521e+07	4442	13657.18	4
2011	51	5	5103957	4.258391e+07	3118	13657.45	4
2011	42	4	4208807	2.3901759e+08	17496	13661.27	4
2011	24	2	2414209	1.593771e+08	11665	13662.85	4
2011	51	5	5107107	2.5885744e+08	18945	13663.63	4
2011	31	3	3162203	9.47586e+07	6935	13663.82	4
2011	43	4	4310553	4.696721e+07	3437	13665.18	4
2011	26	2	2616407	1.78917319e+09	130924	13665.74	4
2011	31	3	3164431	3.850556e+07	2816	13673.85	4
2011	52	5	5214408	1.0900985e+08	7970	13677.52	4
2011	31	3	3114501	2.3629963e+08	17256	13693.77	4
2011	43	4	4302709	2.7971747e+08	20413	13702.91	4
2011	42	4	4205100	5.143531e+07	3753	13705.12	4
2011	43	4	4323754	4.727217e+07	3448	13710.03	4
2011	43	4	4311239	3.673001e+07	2678	13715.46	4
2011	26	2	2606804	1.42064011e+09	103537	13721.09	4
2011	42	4	4214102	3.13367e+07	2283	13726.11	4
2011	32	3	3200805	4.0092625e+08	29178	13740.7	4
2011	35	3	3527256	2.938457e+07	2138	13743.95	4
2011	35	3	3529203	3.3505821e+08	24363	13752.75	4
2011	31	3	3106002	1.3782147e+08	10017	13758.76	4
2011	17	1	1709302	3.2261753e+08	23445	13760.61	4
2011	52	5	5211602	3.631411e+07	2638	13765.77	4
2011	31	3	3147402	3.1315565e+08	22731	13776.59	4
2011	29	2	2918902	5.178039e+07	3758	13778.71	4
2011	41	4	4116307	5.093447e+07	3693	13792.17	4
2011	43	4	4302600	5.055595e+07	3664	13798.02	4
2011	31	3	3140506	1.7485229e+08	12672	13798.32	4
2011	43	4	4306056	1.0122129e+08	7330	13809.18	4
2011	35	3	3515707	2.35354337e+09	170297	13820.23	4
2011	41	4	4100707	1.4021416e+08	10135	13834.65	4
2011	43	4	4304200	4.1805872e+08	30216	13835.67	4
2011	35	3	3512308	2.2690596e+08	16395	13839.95	4
2011	35	3	3541000	3.70006366e+09	267307	13842	4
2011	41	4	4125555	2.907394e+07	2100	13844.73	4
2011	31	3	3125705	1.9694018e+08	14224	13845.63	4
2011	52	5	5218607	1.4608235e+08	10548	13849.29	4
2011	43	4	4306007	1.9410702e+08	14000	13864.79	4
2011	41	4	4114104	2.7761539e+08	20008	13875.22	4
2011	31	3	3109709	1.5376346e+08	11071	13888.85	4
2011	22	2	2203230	6.587394e+07	4741	13894.52	4
2011	43	4	4314506	1.7670033e+08	12710	13902.46	4
2011	42	4	4204756	2.627122e+07	1887	13922.22	4
2011	35	3	3553609	1.7712395e+08	12722	13922.65	4
2011	42	4	4211892	3.274642e+07	2352	13922.8	4
2011	17	1	1718402	5.118478e+07	3676	13924.04	4
2011	33	3	3303500	1.112746123e+10	799047	13925.92	4
2011	31	3	3170602	3.008075e+07	2160	13926.27	4
2011	42	4	4218954	3.45249e+07	2479	13926.95	4
2011	31	3	3162559	1.4434557e+08	10363	13928.94	4
2011	41	4	4102109	3.4527688e+08	24780	13933.69	4
2011	52	5	5220454	1.21097728e+09	86849	13943.48	4
2011	31	3	3170503	1.4343673e+08	10285	13946.21	4
2011	31	3	3124500	1.5184387e+08	10882	13953.67	4
2011	17	1	1702109	2.13982756e+09	153351	13953.79	4
2011	41	4	4103958	5.659606e+07	4054	13960.55	4
2011	43	4	4300570	4.08387e+07	2924	13966.72	4
2011	35	3	3547403	3.540433e+07	2532	13982.75	4
2011	35	3	3517109	6.403897e+07	4576	13994.53	4
2011	43	4	4304697	3.698445e+07	2642	13998.66	4
2011	42	4	4208708	1.4819345e+08	10585	14000.33	4
2011	23	2	2312908	2.67120772e+09	190724	14005.62	4
2011	43	4	4302378	3.207968e+07	2290	14008.59	4
2011	35	3	3504206	1.9975069e+08	14255	14012.68	4
2011	43	4	4310751	2.985603e+07	2130	14016.92	4
2011	31	3	3163706	5.8901546e+08	42021	14017.17	4
2011	35	3	3552908	8.068783e+07	5752	14027.79	4
2011	32	3	3204104	3.3806953e+08	24093	14031.86	4
2011	17	1	1720978	3.62339e+07	2582	14033.27	4
2011	31	3	3125200	3.297996e+07	2350	14034.03	4
2011	28	2	2800605	3.5834853e+08	25527	14038.02	4
2011	31	3	3127701	3.7198946e+09	264960	14039.46	4
2011	41	4	4103909	2.1440277e+08	15270	14040.78	4
2011	43	4	4305439	8.391781e+07	5975	14044.82	4
2011	51	5	5106752	5.8682694e+08	41741	14058.77	4
2011	42	4	4215679	1.2319321e+08	8762	14059.94	4
2011	41	4	4121703	3.5537292e+08	25264	14066.38	4
2011	41	4	4107736	8.301569e+07	5899	14072.84	4
2011	43	4	4318432	3.635805e+07	2580	14092.27	4
2011	42	4	4205704	2.6100265e+08	18520	14093.02	4
2011	31	3	3148905	5.470528e+07	3880	14099.3	4
2011	35	3	3550407	4.5094429e+08	31951	14113.62	4
2011	35	3	3538808	4.0252439e+08	28520	14113.76	4
2011	35	3	3542701	9.406375e+07	6664	14115.21	4
2011	43	4	4304614	2.535173e+07	1796	14115.66	4
2011	21	2	2100501	1.5270737e+08	10812	14123.88	4
2011	43	4	4310330	2.5547232e+08	18087	14124.64	4
2011	50	5	5003108	7.006553e+07	4960	14126.11	4
2011	35	3	3521804	3.4260847e+08	24236	14136.35	4
2011	17	1	1718204	6.9964473e+08	49465	14144.24	4
2011	52	5	5217708	2.4304964e+08	17165	14159.61	4
2011	29	2	2913606	2.63180635e+09	185801	14164.65	4
2011	35	3	3527405	2.8342556e+08	20003	14169.15	4
2011	51	5	5108204	5.688474e+07	4013	14175.12	4
2011	26	2	2607802	2.2328946e+08	15749	14178.01	4
2011	50	5	5008008	2.4913199e+08	17567	14181.82	4
2011	31	3	3164407	7.088506e+07	4997	14185.52	4
2011	35	3	3556008	1.8136437e+08	12782	14189.04	4
2011	31	3	3152006	4.1635812e+08	29337	14192.25	4
2011	52	5	5207501	4.704876e+07	3315	14192.69	4
2011	31	3	3143609	3.74611e+07	2637	14205.95	4
2011	41	4	4112207	9.111676e+07	6413	14208.13	4
2011	25	2	2504009	5.50864194e+09	387644	14210.57	4
2011	41	4	4126603	2.6510714e+08	18643	14220.2	4
2011	50	5	5007406	2.6954425e+08	18948	14225.47	4
2011	11	1	1100320	3.1127099e+08	21879	14226.93	4
2011	31	3	3126208	1.1817371e+08	8305	14229.22	4
2011	24	2	2403251	2.96644478e+09	208426	14232.6	4
2011	52	5	5210802	7.150635e+07	5017	14252.81	4
2011	32	3	3205150	1.2404108e+08	8699	14259.23	4
2011	31	3	3162500	1.21108042e+09	84919	14261.6	4
2011	17	1	1716109	6.4340652e+08	45054	14280.79	4
2011	15	1	1508407	5.8530197e+08	40984	14281.23	4
2011	33	3	3300902	2.1193405e+08	14840	14281.27	4
2011	42	4	4203154	4.829611e+07	3381	14284.56	4
2011	43	4	4309654	8.71765e+07	6096	14300.61	4
2011	31	3	3147709	1.1693836e+08	8176	14302.64	4
2011	31	3	3169802	6.708818e+07	4690	14304.52	4
2011	43	4	4308052	3.633796e+07	2540	14306.28	4
2011	31	3	3129103	8.700144e+07	6080	14309.45	4
2011	43	4	4300406	1.10413877e+09	77140	14313.44	4
2011	41	4	4109708	4.1414804e+08	28928	14316.51	4
2011	51	5	5103205	4.4348115e+08	30975	14317.39	4
2011	52	5	5212907	2.984905e+07	2084	14322.96	4
2011	35	3	3524600	2.4678844e+08	17221	14330.67	4
2011	32	3	3204658	1.1516758e+08	8036	14331.46	4
2011	31	3	3137536	1.2486288e+08	8710	14335.58	4
2011	35	3	3506409	1.0215475e+08	7122	14343.55	4
2011	41	4	4117107	1.8735204e+08	13060	14345.49	4
2011	31	3	3157203	4.040014e+08	28160	14346.64	4
2011	31	3	3107109	5.542479e+08	38627	14348.72	4
2011	41	4	4128559	1.281076e+08	8921	14360.23	4
2011	41	4	4123006	1.9766451e+08	13761	14364.11	4
2011	42	4	4209607	2.0723312e+08	14426	14365.25	4
2011	35	3	3501707	5.0212417e+08	34954	14365.28	4
2011	31	3	3122355	8.575297e+07	5967	14371.2	4
2011	43	4	4311700	7.896431e+07	5494	14372.83	4
2011	35	3	3543204	6.390606e+07	4443	14383.54	4
2011	29	2	2900702	2.05499261e+09	142870	14383.65	4
2011	41	4	4121307	5.66609e+07	3937	14391.9	4
2011	42	4	4202206	1.5017486e+08	10434	14392.84	4
2011	31	3	3138104	9.328743e+07	6479	14398.43	4
2011	41	4	4126652	4.829275e+07	3354	14398.55	4
2011	41	4	4109005	5.588859e+07	3878	14411.7	4
2011	11	1	1100262	4.822978e+07	3346	14414.16	4
2011	43	4	4312500	1.7530738e+08	12160	14416.72	4
2011	41	4	4110102	4.1497452e+08	28759	14429.38	4
2011	35	3	3531605	5.863351e+07	4062	14434.64	4
2011	35	3	3514601	1.1963123e+08	8284	14441.24	4
2011	32	3	3203346	2.0834592e+08	14422	14446.4	4
2011	35	3	3554706	1.3536064e+08	9368	14449.26	4
2011	50	5	5002803	7.896224e+07	5460	14461.95	4
2011	43	4	4318309	8.7464115e+08	60452	14468.36	4
2011	41	4	4107306	8.438762e+07	5832	14469.76	4
2011	17	1	1707009	2.8064449e+08	19395	14469.94	4
2011	42	4	4218905	1.553571e+08	10734	14473.36	4
2011	43	4	4318622	4.786089e+07	3305	14481.36	4
2011	41	4	4127205	2.2976114e+08	15864	14483.18	4
2011	51	5	5107180	1.3037774e+08	9002	14483.2	4
2011	42	4	4210308	1.0900074e+08	7523	14489	4
2011	32	3	3201407	5.0608233e+08	34900	14500.93	4
2011	35	3	3512209	3.6877315e+08	25425	14504.35	4
2011	41	4	4120150	5.254718e+07	3622	14507.78	4
2011	33	3	3304755	6.0023137e+08	41371	14508.51	4
2011	17	1	1720655	7.393105e+07	5095	14510.51	4
2011	25	2	2500601	2.6368898e+08	18168	14513.92	4
2011	35	3	3511607	2.2853173e+08	15744	14515.48	4
2011	28	2	2805901	1.3701283e+08	9434	14523.3	4
2011	41	4	4109302	2.0888684e+08	14381	14525.2	4
2011	43	4	4310850	5.907945e+07	4065	14533.69	4
2011	43	4	4317301	4.4783715e+08	30813	14534.03	4
2011	33	3	3303708	6.0127184e+08	41367	14535.06	4
2011	22	2	2205581	5.657108e+07	3892	14535.22	4
2011	52	5	5213053	3.892996e+07	2677	14542.38	4
2011	35	3	3542008	8.799613e+07	6048	14549.62	4
2011	31	3	3163904	7.283491e+07	4996	14578.64	4
2011	42	4	4200903	7.596536e+07	5210	14580.68	4
2011	52	5	5212303	1.1508305e+08	7891	14584.09	4
2011	41	4	4101309	1.0718069e+08	7347	14588.36	4
2011	31	3	3113701	2.908179e+08	19922	14597.83	4
2011	43	4	4301925	2.879724e+07	1972	14603.06	4
2011	43	4	4322343	3.311206e+07	2267	14606.11	4
2011	31	3	3113206	3.436123e+08	23522	14608.12	4
2011	24	2	2402303	2.8694133e+08	19635	14613.77	4
2011	43	4	4304101	5.074187e+07	3472	14614.59	4
2011	52	5	5205406	3.0435821e+08	20825	14615.04	4
2011	11	1	1100601	8.426231e+07	5764	14618.72	4
2011	23	2	2306306	7.151315e+08	48908	14621.97	4
2011	43	4	4323705	4.039531e+07	2762	14625.39	4
2011	42	4	4218756	6.761724e+07	4622	14629.43	4
2011	35	3	3551801	1.8948675e+08	12951	14631.05	4
2011	43	4	4321956	8.466852e+07	5777	14656.14	4
2011	43	4	4314035	5.179535e+07	3532	14664.6	4
2011	43	4	4319364	2.778068e+07	1894	14667.73	4
2011	35	3	3531506	2.7701158e+08	18884	14669.12	4
2011	35	3	3524204	9.694057e+07	6605	14676.85	4
2011	31	3	3123601	3.7401652e+08	25472	14683.44	4
2011	35	3	3541059	6.829264e+07	4649	14689.75	4
2011	42	4	4201901	8.160772e+07	5555	14690.86	4
2011	41	4	4120101	6.665105e+07	4536	14693.79	4
2011	43	4	4306205	1.8185443e+08	12371	14700.06	4
2011	52	5	5221502	7.081182e+07	4817	14700.4	4
2011	29	2	2910800	8.26948423e+09	562466	14702.19	4
2011	35	3	3503802	6.621265e+08	45026	14705.43	4
2011	52	5	5221197	9.819425e+07	6675	14710.75	4
2011	35	3	3514700	9.23902e+07	6279	14714.16	4
2011	41	4	4120507	1.5955214e+08	10840	14718.83	4
2011	41	4	4127007	1.5374949e+08	10444	14721.32	4
2011	43	4	4318465	3.211873e+07	2179	14740.12	4
2011	43	4	4315503	2.3442612e+08	15869	14772.58	4
2011	43	4	4305587	3.571268e+07	2417	14775.62	4
2011	51	5	5108956	1.2116029e+08	8191	14791.88	4
2011	35	3	3536570	2.631537e+07	1779	14792.23	4
2011	43	4	4313441	3.353542e+07	2267	14792.86	4
2011	41	4	4126678	1.843032e+08	12458	14793.96	4
2011	22	2	2211001	1.217425504e+10	822364	14803.97	4
2011	33	3	3306107	1.07028984e+09	72268	14810.01	4
2011	42	4	4207759	6.260473e+07	4227	14810.68	4
2011	52	5	5215405	5.941875e+07	4010	14817.64	4
2011	42	4	4218251	1.071437e+08	7219	14841.9	4
2011	43	4	4320602	5.66814e+07	3819	14841.95	4
2011	29	2	2917706	4.5370896e+08	30560	14846.5	4
2011	41	4	4128302	3.674889e+07	2474	14854.04	4
2011	31	3	3169406	8.0341387e+08	54078	14856.58	4
2011	41	4	4128203	7.8836236e+08	53059	14858.22	4
2011	42	4	4207403	8.53326e+07	5743	14858.54	4
2011	43	4	4317707	1.6488595e+08	11097	14858.61	4
2011	11	1	1100288	7.5630495e+08	50899	14858.94	4
2011	31	3	3166600	1.205848e+07	811	14868.65	4
2011	43	4	4317251	2.571118e+07	1729	14870.55	4
2011	52	5	5212600	3.527608e+07	2372	14871.87	4
2011	41	4	4117255	1.5445123e+08	10376	14885.43	4
2011	31	3	3147600	2.3278942e+08	15638	14886.14	4
2011	31	3	3131406	6.126152e+07	4114	14890.99	4
2011	41	4	4125753	9.589131e+07	6431	14910.79	4
2011	42	4	4215307	1.1016079e+08	7386	14914.81	4
2011	31	3	3143302	5.46096775e+09	366135	14915.18	4
2011	35	3	3514957	3.610133e+07	2419	14924.07	4
2011	27	2	2704302	1.40801158e+10	943110	14929.45	4
2011	41	4	4128658	5.899094e+07	3951	14930.64	4
2011	29	2	2910727	1.5168871e+09	101432	14954.72	4
2011	31	3	3146008	4.7467082e+08	31734	14957.8	4
2011	35	3	3530102	4.1289265e+08	27602	14958.79	4
2011	35	3	3528502	1.235284e+09	82556	14962.98	4
2011	42	4	4215505	2.3690577e+08	15831	14964.68	4
2011	41	4	4101200	2.8239726e+08	18870	14965.41	4
2011	43	4	4310579	3.470512e+07	2318	14972.01	4
2011	35	3	3506706	2.0572151e+08	13728	14985.54	4
2011	17	1	1707306	6.888309e+07	4595	14990.88	4
2011	35	3	3530904	4.918667e+07	3279	15000.51	4
2011	42	4	4216057	7.577061e+07	5051	15001.11	4
2011	33	3	3305109	6.8939143e+09	459379	15007.03	4
2011	31	3	3105103	3.4239708e+08	22814	15008.2	4
2011	35	3	3517505	2.7257907e+08	18160	15009.86	4
2011	51	5	5107859	1.6097653e+08	10716	15022.07	4
2011	41	4	4104709	2.0640086e+08	13737	15025.18	4
2011	35	3	3545605	2.1638409e+08	14401	15025.63	4
2011	35	3	3544608	7.871677e+07	5238	15028.02	4
2011	50	5	5005681	2.578119e+08	17149	15033.64	4
2011	31	3	3112109	7.85882e+07	5226	15037.93	4
2011	43	4	4305934	2.577179e+07	1713	15044.83	4
2011	51	5	5105150	5.9206873e+08	39351	15045.84	4
2011	29	2	2929503	6.3690593e+08	42322	15049.05	4
2011	31	3	3115003	4.3285e+07	2876	15050.42	4
2011	43	4	4301206	1.9195954e+08	12742	15065.1	4
2011	35	3	3525102	5.7547472e+08	38194	15067.15	4
2011	43	4	4301057	1.1948423e+08	7930	15067.37	4
2011	35	3	3522406	1.32812005e+09	88129	15070.18	4
2011	43	4	4321634	4.269565e+07	2833	15070.82	4
2011	35	3	3551900	2.3588506e+08	15647	15075.42	4
2011	43	4	4320701	2.1589004e+08	14317	15079.28	4
2011	41	4	4116901	4.0256374e+08	26684	15086.33	4
2011	31	3	3126109	9.853003e+08	65299	15089.06	4
2011	41	4	4123907	1.8651256e+08	12356	15094.9	4
2011	31	3	3133600	1.3230833e+08	8765	15095.07	4
2011	41	4	4118402	1.238397e+09	82039	15095.22	4
2011	41	4	4100103	1.1684927e+08	7727	15122.2	4
2011	43	4	4318424	7.125159e+07	4711	15124.51	4
2011	52	5	5220108	4.5876954e+08	30315	15133.42	4
2011	35	3	3519808	1.1374376e+08	7515	15135.56	4
2011	51	5	5100250	7.4677011e+08	49332	15137.64	4
2011	41	4	4122800	6.550407e+07	4327	15138.45	4
2011	41	4	4107603	2.4796467e+08	16369	15148.43	4
2011	50	5	5006903	2.3525743e+08	15530	15148.58	4
2011	43	4	4315453	3.24979e+07	2145	15150.54	4
2011	42	4	4213302	7.385131e+07	4873	15155.2	4
2011	41	4	4112900	5.178061e+07	3416	15158.26	4
2011	43	4	4320800	4.560484e+08	30069	15166.73	4
2011	52	5	5217203	1.6977937e+08	11188	15175.13	4
2011	43	4	4321204	8.3163148e+08	54783	15180.47	4
2011	52	5	5212204	2.8984046e+08	19086	15186.02	4
2011	52	5	5200308	3.6605231e+08	24104	15186.37	4
2011	31	3	3169604	3.6883812e+08	24271	15196.66	4
2011	43	4	4301552	5.547039e+07	3648	15205.7	4
2011	41	4	4116604	5.279218e+07	3470	15213.89	4
2011	16	1	1600303	6.19691844e+09	407023	15224.98	4
2011	42	4	4204152	4.211388e+07	2766	15225.55	4
2011	32	3	3203502	2.7244716e+08	17894	15225.62	4
2011	31	3	3101508	5.2389186e+08	34406	15226.76	4
2011	31	3	3147907	1.63114437e+09	106987	15246.19	4
2011	41	4	4117453	8.710329e+07	5709	15257.19	4
2011	31	3	3147204	3.1054813e+08	20346	15263.35	4
2011	42	4	4209805	5.094974e+07	3337	15268.13	4
2011	51	5	5105101	5.031258e+08	32948	15270.3	4
2011	35	3	3507100	3.0868627e+08	20199	15282.25	4
2011	15	1	1501402	2.142684713e+10	1402056	15282.45	4
2011	52	5	5219738	7.381802e+07	4826	15295.9	4
2011	24	2	2407104	1.07984836e+09	70587	15298.12	4
2011	41	4	4103800	1.1135538e+08	7279	15298.17	4
2011	35	3	3503406	1.2066068e+08	7887	15298.68	4
2011	42	4	4204905	1.3166171e+08	8597	15314.84	4
2011	41	4	4126306	2.8277221e+08	18463	15315.62	4
2011	31	3	3114303	4.5575979e+08	29757	15316.05	4
2011	24	2	2403707	8.807543e+07	5750	15317.47	4
2011	52	5	5206305	4.493581e+07	2933	15320.77	4
2011	35	3	3515301	4.077776e+07	2661	15324.22	4
2011	17	1	1720853	2.70226e+07	1763	15327.62	4
2011	33	3	3302056	2.1732883e+08	14174	15332.92	4
2011	35	3	3547106	4.346273e+07	2834	15336.18	4
2011	41	4	4103040	1.0025389e+08	6537	15336.38	4
2011	35	3	3509957	6.819761e+07	4445	15342.54	4
2011	31	3	3107406	7.0678063e+08	46061	15344.45	4
2011	11	1	1100056	2.601421e+08	16939	15357.58	4
2011	25	2	2502151	9.723931e+07	6323	15378.67	4
2011	16	1	1600238	9.196201e+07	5974	15393.71	4
2011	35	3	3520442	3.8716001e+08	25146	15396.49	4
2011	42	4	4206702	3.2847622e+08	21331	15399.01	4
2011	41	4	4107850	7.25586e+07	4711	15401.95	4
2011	52	5	5201306	3.1358818e+08	20353	15407.47	4
2011	35	3	3537602	9.3083696e+08	60412	15408.15	4
2011	41	4	4101655	5.419085e+07	3515	15417.03	4
2011	43	4	4316402	6.1058592e+08	39604	15417.28	4
2011	35	3	3500501	2.675886e+08	17354	15419.42	4
2011	52	5	5215900	5.485187e+07	3557	15420.82	4
2011	41	4	4103404	4.1846e+07	2712	15429.94	4
2011	13	1	1304302	2.6226018e+08	16996	15430.7	4
2011	41	4	4127601	2.2703947e+08	14712	15432.26	4
2011	52	5	5215652	5.212018e+07	3376	15438.44	4
2011	35	3	3540408	6.494836e+07	4206	15441.84	4
2011	32	3	3205176	2.1358179e+08	13827	15446.72	4
2011	41	4	4120408	7.447377e+07	4821	15447.79	4
2011	41	4	4108601	4.4740408e+08	28962	15447.97	4
2011	35	3	3555802	1.3654515e+08	8837	15451.53	4
2011	33	3	3301207	2.719738e+08	17599	15453.93	4
2011	43	4	4315909	8.875717e+07	5743	15454.84	4
2011	43	4	4313607	6.49381e+07	4198	15468.82	4
2011	43	4	4309951	6.263369e+07	4049	15468.93	4
2011	43	4	4319604	3.6720091e+08	23735	15470.86	4
2011	41	4	4118451	7.553665e+07	4882	15472.48	4
2011	35	3	3519204	9.890024e+07	6392	15472.5	4
2011	51	5	5103361	5.335515e+07	3447	15478.72	4
2011	26	2	2612208	8.8251419e+08	56992	15484.88	4
2011	33	3	3300308	1.47576362e+09	95260	15491.95	4
2011	35	3	3549953	2.1863117e+08	14110	15494.77	4
2011	35	3	3541307	6.4270969e+08	41474	15496.69	4
2011	43	4	4317608	6.1827361e+08	39889	15499.85	4
2011	35	3	3555307	3.023089e+07	1949	15510.97	4
2011	35	3	3535804	2.7928958e+08	17985	15529.03	4
2011	35	3	3502309	8.912977e+07	5739	15530.54	4
2011	41	4	4113007	1.0307946e+08	6634	15538.06	4
2011	51	5	5103304	2.8627497e+08	18419	15542.37	4
2011	35	3	3507803	3.3291903e+08	21412	15548.25	4
2011	52	5	5212105	1.1100644e+08	7135	15558.02	4
2011	33	3	3306206	5.3912065e+08	34638	15564.43	4
2011	35	3	3519907	1.193401e+08	7657	15585.75	4
2011	42	4	4206751	3.032187e+07	1945	15589.65	4
2011	31	3	3153509	1.2953406e+08	8308	15591.49	4
2011	52	5	5205513	2.7476839e+08	17621	15593.23	4
2011	31	3	3154705	5.991628e+07	3842	15595.08	4
2011	52	5	5201405	7.25817794e+09	465093	15605.86	4
2011	31	3	3114402	3.1991913e+08	20480	15621.05	4
2011	41	4	4106506	3.3793305e+08	21630	15623.35	4
2011	43	4	4322533	1.7375024e+08	11117	15629.24	4
2011	43	4	4305801	1.5237206e+08	9747	15632.71	4
2011	42	4	4214607	1.11281e+08	7118	15633.74	4
2011	42	4	4211108	1.3048502e+08	8346	15634.44	4
2011	31	3	3111507	2.2380521e+08	14313	15636.5	4
2011	42	4	4205001	2.3236778e+08	14855	15642.39	4
2011	43	4	4315206	6.441365e+07	4114	15657.18	4
2011	31	3	3102605	5.8874877e+08	37601	15657.8	4
2011	41	4	4123402	1.6531017e+08	10552	15666.24	4
2011	41	4	4102802	2.3629717e+08	15083	15666.46	4
2011	43	4	4317954	3.829079e+07	2444	15667.26	4
2011	50	5	5004700	3.5087959e+08	22395	15667.76	4
2011	35	3	3512803	9.3934547e+08	59938	15671.95	4
2011	17	1	1707652	8.342882e+07	5323	15673.27	4
2011	31	3	3108800	7.840311e+07	5001	15677.49	4
2011	41	4	4125100	2.1659738e+08	13803	15692.05	4
2011	41	4	4125605	6.5313606e+08	41617	15693.97	4
2011	43	4	4314050	8.1644314e+08	52019	15695.09	4
2011	42	4	4216503	3.9201519e+08	24964	15703.22	4
2011	31	3	3147303	3.0659329e+08	19524	15703.41	4
2011	52	5	5213905	7.769758e+07	4947	15706	4
2011	33	3	3304706	6.4012137e+08	40735	15714.28	4
2011	15	1	1500503	5.2785919e+08	33588	15715.71	4
2011	42	4	4214508	9.697009e+07	6167	15724.03	4
2011	42	4	4202503	6.952616e+07	4420	15729.9	4
2011	41	4	4101408	1.91828708e+09	121924	15733.47	4
2011	31	3	3140704	4.4285371e+08	28141	15736.96	4
2011	31	3	3115300	1.10586744e+09	70201	15752.87	4
2011	43	4	4321857	6.876366e+07	4363	15760.64	4
2011	31	3	3145208	1.20604668e+09	76482	15769.03	4
2011	41	4	4108502	2.1530777e+08	13652	15771.15	4
2011	35	3	3515657	2.48598e+07	1574	15794.03	4
2011	32	3	3203130	2.5031804e+08	15848	15794.93	4
2011	31	3	3123007	1.4807597e+08	9372	15799.83	4
2011	35	3	3509700	7.6004242e+08	48061	15814.12	4
2011	43	4	4320552	9.323052e+07	5895	15815.19	4
2011	41	4	4109104	3.519619e+07	2225	15818.51	4
2011	51	5	5101001	5.032095e+07	3180	15824.2	4
2011	43	4	4311502	1.2099904e+08	7646	15825.14	4
2011	31	3	3152600	9.780153e+07	6178	15830.61	4
2011	41	4	4125209	1.4357137e+08	9068	15832.75	4
2011	35	3	3520905	2.1778812e+08	13749	15840.29	4
2011	41	4	4128609	1.2380783e+08	7814	15844.36	4
2011	35	3	3545407	1.3977182e+08	8814	15857.93	4
2011	35	3	3518107	1.0167727e+08	6411	15859.81	4
2011	35	3	3546108	3.305593e+07	2082	15877.01	4
2011	52	5	5218706	7.276762e+07	4582	15881.19	4
2011	31	3	3153400	2.9607151e+08	18639	15884.52	4
2011	41	4	4127858	1.8786561e+08	11825	15887.15	4
2011	42	4	4202131	9.574222e+07	6026	15888.19	4
2011	50	5	5004908	1.020042e+08	6415	15900.89	4
2011	42	4	4213401	1.7606391e+08	11068	15907.47	4
2011	43	4	4314456	3.999386e+07	2514	15908.46	4
2011	31	3	3109907	1.6460629e+08	10345	15911.68	4
2011	24	2	2412005	1.41811821e+09	89045	15925.86	4
2011	43	4	4305371	5.493974e+07	3448	15933.8	4
2011	43	4	4321501	5.5682442e+08	34946	15933.85	4
2011	35	3	3504602	2.3644808e+08	14838	15935.31	4
2011	35	3	3537503	1.2029978e+08	7549	15935.86	4
2011	43	4	4315172	3.175028e+07	1992	15938.9	4
2011	35	3	3515194	6.835051e+07	4288	15939.95	4
2011	41	4	4108809	4.9200924e+08	30861	15942.75	4
2011	11	1	1100049	1.25902429e+09	78959	15945.29	4
2011	42	4	4215109	1.7491405e+08	10964	15953.49	4
2011	28	2	2802304	2.2367696e+08	14020	15954.13	4
2011	35	3	3552601	1.8236268e+08	11430	15954.74	4
2011	41	4	4101150	4.571438e+07	2861	15978.46	4
2011	35	3	3503000	8.283276e+07	5182	15984.71	4
2011	50	5	5002209	3.1634728e+08	19789	15986.02	4
2011	52	5	5209705	2.834376e+08	17729	15987.23	4
2011	42	4	4210407	1.0348564e+08	6471	15992.22	4
2011	52	5	5212956	7.047085e+07	4406	15994.29	4
2011	43	4	4311643	2.606496e+07	1629	16000.59	4
2011	31	3	3138807	2.8060371e+08	17537	16000.67	4
2011	31	3	3105905	3.1519989e+08	19695	16004.06	4
2011	52	5	5200209	3.199744e+07	1999	16006.72	4
2011	35	3	3536208	2.9626132e+08	18508	16007.2	4
2011	29	2	2926202	3.5129236e+08	21939	16012.23	4
2011	43	4	4314407	5.26652695e+09	328865	16014.25	4
2011	15	1	1504208	3.82299822e+09	238708	16015.38	4
2011	35	3	3517703	3.1931238e+08	19931	16020.89	4
2011	41	4	4106605	3.273687e+08	20431	16023.14	4
2011	43	4	4305835	2.44083e+07	1523	16026.46	4
2011	42	4	4214409	9.848836e+07	6145	16027.4	4
2011	52	5	5219100	9.315845e+07	5812	16028.64	4
2011	31	3	3112802	1.3194285e+08	8218	16055.35	4
2011	31	3	3157906	2.4267532e+08	15111	16059.51	4
2011	51	5	5106216	1.9556635e+08	12174	16064.26	4
2011	43	4	4301305	2.9587824e+08	18418	16064.62	4
2011	41	4	4122503	1.8277804e+08	11377	16065.57	4
2011	35	3	3553708	8.6982751e+08	54136	16067.45	4
2011	52	5	5209952	2.2224617e+08	13831	16068.7	4
2011	33	3	3302205	1.55191909e+09	96542	16075.07	4
2011	42	4	4215554	3.805851e+07	2367	16078.79	4
2011	43	4	4313466	2.819603e+07	1751	16102.81	4
2011	35	3	3534500	4.083766e+07	2536	16103.18	4
2011	42	4	4204459	3.967977e+07	2464	16103.8	4
2011	31	3	3162922	4.2039612e+08	26104	16104.66	4
2011	12	1	1200401	5.51668712e+09	342299	16116.57	4
2011	41	4	4111407	2.0776188e+08	12886	16123.07	4
2011	32	3	3204559	5.5777334e+08	34591	16124.81	4
2011	22	2	2210631	6.67353e+07	4138	16127.43	4
2011	52	5	5217401	4.6701519e+08	28957	16127.89	4
2011	41	4	4107900	9.670321e+07	5994	16133.34	4
2011	43	4	4306320	5.082065e+07	3150	16133.54	4
2011	41	4	4123600	2.900238e+07	1797	16139.33	4
2011	51	5	5103700	1.8169461e+08	11253	16146.33	4
2011	41	4	4105003	1.645963e+08	10186	16159.07	4
2011	35	3	3519006	1.414666e+08	8751	16165.76	4
2011	42	4	4202438	5.341722e+07	3303	16172.33	4
2011	43	4	4318408	3.6046392e+08	22277	16180.99	4
2011	43	4	4301701	1.0564893e+08	6525	16191.41	4
2011	41	4	4127965	2.2220703e+08	13717	16199.39	4
2011	41	4	4108957	1.2895878e+08	7959	16202.89	4
2011	42	4	4201703	1.2075476e+08	7449	16210.87	4
2011	43	4	4313656	1.7798912e+08	10978	16213.26	4
2011	42	4	4205191	3.325334e+07	2050	16221.14	4
2011	52	5	5210406	5.8312972e+08	35947	16221.93	4
2011	17	1	1709500	1.25985735e+09	77655	16223.78	4
2011	25	2	2507507	1.191543458e+10	733155	16252.27	4
2011	35	3	3548104	9.634277e+07	5927	16254.9	4
2011	17	1	1714880	1.7535556e+08	10786	16257.7	4
2011	35	3	3551603	4.3223185e+08	26582	16260.32	4
2011	32	3	3205101	1.07170931e+09	65888	16265.62	4
2011	41	4	4123303	1.3102629e+08	8055	16266.45	4
2011	41	4	4108205	1.2118906e+08	7448	16271.36	4
2011	33	3	3300803	8.9032644e+08	54713	16272.67	4
2011	25	2	2503001	3.3425654e+08	20510	16297.25	4
2011	41	4	4103602	3.9118898e+08	23974	16317.22	4
2011	43	4	4302303	1.8769279e+08	11482	16346.7	4
2011	52	5	5207253	1.2826462e+08	7841	16358.2	4
2011	42	4	4201802	5.384602e+07	3291	16361.6	4
2011	51	5	5107578	5.952862e+07	3638	16363.01	4
2011	31	3	3113909	1.9402952e+08	11855	16366.89	4
2011	41	4	4110706	9.2501564e+08	56503	16371.09	4
2011	50	5	5008404	9.680608e+07	5911	16377.28	4
2011	41	4	4111803	6.4022113e+08	39083	16381.06	4
2011	35	3	3501103	6.701173e+07	4090	16384.29	4
2011	41	4	4105409	3.2195401e+08	19613	16415.34	4
2011	32	3	3200706	1.6363261e+08	9967	16417.44	4
2011	51	5	5108303	6.120192e+07	3727	16421.23	4
2011	29	2	2903201	2.28872085e+09	139285	16431.93	4
2011	51	5	5105200	1.8723008e+08	11382	16449.66	4
2011	29	2	2927408	4.43161518e+10	2693606	16452.35	4
2011	35	3	3504800	1.3538248e+08	8223	16463.88	4
2011	43	4	4307302	1.2821888e+08	7779	16482.69	4
2011	35	3	3503356	3.143631e+07	1907	16484.69	4
2011	41	4	4104105	1.1847037e+08	7186	16486.27	4
2011	43	4	4318200	3.3980256e+08	20600	16495.27	4
2011	50	5	5006606	1.30602884e+09	79174	16495.68	4
2011	41	4	4104501	3.0622057e+08	18549	16508.74	4
2011	42	4	4212601	4.905404e+07	2970	16516.51	4
2011	43	4	4318614	3.49146e+07	2108	16562.9	4
2011	35	3	3539707	5.329769e+07	3217	16567.51	4
2011	31	3	3149903	3.3459734e+08	20191	16571.61	4
2011	43	4	4306601	6.4276574e+08	38782	16573.82	4
2011	43	4	4310306	6.78245e+07	4091	16578.95	4
2011	31	3	3144706	2.9036004e+08	17511	16581.58	4
2011	41	4	4119400	3.9126137e+08	23561	16606.31	4
2011	11	1	1100114	8.6162274e+08	51883	16607.03	4
2011	41	4	4119202	1.0321909e+08	6215	16608.06	4
2011	52	5	5206602	4.906842e+07	2954	16610.84	4
2011	41	4	4101051	4.758143e+07	2864	16613.63	4
2011	35	3	3519303	5.1608592e+08	31062	16614.7	4
2011	33	3	3303401	3.03647827e+09	182748	16615.66	4
2011	41	4	4128534	1.6796914e+08	10106	16620.73	4
2011	43	4	4312476	9.52862e+07	5730	16629.35	4
2011	31	3	3140530	1.2123285e+08	7288	16634.58	4
2011	33	3	3304144	2.31616749e+09	139188	16640.57	4
2011	42	4	4206603	8.196115e+07	4925	16641.86	4
2011	42	4	4206801	5.586815e+07	3357	16642.28	4
2011	31	3	3168903	1.1409356e+08	6855	16643.84	4
2011	42	4	4210050	3.032448e+07	1821	16652.65	4
2011	31	3	3170800	6.0169733e+08	36129	16654.14	4
2011	50	5	5000807	1.4215681e+08	8535	16655.75	4
2011	43	4	4300851	6.129623e+07	3676	16674.71	4
2011	51	5	5103056	1.855651e+08	11122	16684.51	4
2011	23	2	2304400	4.139456065e+10	2476589	16714.34	4
2011	50	5	5006408	1.3263322e+08	7924	16738.17	4
2011	31	3	3148004	2.34190217e+09	139849	16745.93	4
2011	35	3	3507407	2.4503981e+08	14632	16746.84	4
2011	43	4	4303004	1.39972957e+09	83517	16759.82	4
2011	50	5	5004304	2.5093284e+08	14972	16760.14	4
2011	43	4	4313086	4.116012e+07	2455	16765.83	4
2011	43	4	4304952	5.063773e+07	3019	16773.01	4
2011	11	1	1100072	1.4541205e+08	8655	16800.93	4
2011	43	4	4302204	1.1053333e+08	6574	16813.71	4
2011	43	4	4322558	3.352112e+07	1992	16827.87	4
2011	35	3	3522208	2.59892593e+09	154374	16835.26	4
2011	43	4	4320206	1.8305685e+08	10863	16851.41	4
2011	41	4	4128104	1.70974614e+09	101443	16854.25	4
2011	43	4	4315131	3.119925e+07	1851	16855.35	4
2011	42	4	4215604	3.491006e+07	2070	16864.77	4
2011	31	3	3166808	1.7950735e+08	10638	16874.16	4
2011	43	4	4311759	1.1944279e+08	7078	16875.22	4
2011	35	3	3502507	5.9102098e+08	35015	16879.08	4
2011	42	4	4213906	2.888963e+07	1711	16884.65	4
2011	35	3	3501004	2.6371575e+08	15617	16886.45	4
2011	35	3	3532058	7.305847e+07	4323	16899.95	4
2011	50	5	5006259	8.157924e+07	4827	16900.61	4
2011	41	4	4107702	8.11145e+07	4792	16927.07	4
2011	42	4	4204194	4.702749e+07	2778	16928.54	4
2011	31	3	3112604	2.6002122e+08	15359	16929.57	4
2011	51	5	5104906	1.3114737e+08	7740	16944.1	4
2011	35	3	3526001	3.1958521e+08	18859	16946.03	4
2011	15	1	1505502	1.68558838e+09	99460	16947.4	4
2011	31	3	3163102	7.244591e+07	4273	16954.34	4
2011	43	4	4321303	4.4279283e+08	26108	16960.04	4
2011	35	3	3508801	2.8292963e+08	16670	16972.38	4
2011	31	3	3164704	1.11198421e+09	65491	16979.19	4
2011	42	4	4215752	4.486833e+07	2642	16982.71	4
2011	43	4	4300109	2.8336484e+08	16666	17002.57	4
2011	51	5	5107743	3.344693e+07	1967	17004.03	4
2011	42	4	4201273	7.140785e+07	4196	17018.08	4
2011	51	5	5104559	7.636452e+07	4483	17034.25	4
2011	41	4	4113452	9.02125e+07	5295	17037.3	4
2011	41	4	4106571	7.276436e+07	4270	17040.83	4
2011	41	4	4110508	2.4226918e+08	14215	17043.21	4
2011	42	4	4207650	1.4409528e+08	8450	17052.7	4
2011	42	4	4215455	1.8033754e+08	10575	17053.2	4
2011	35	3	3518701	4.9933298e+09	292744	17056.98	4
2011	11	1	1100106	7.1538613e+08	41934	17059.81	4
2011	43	4	4312302	8.262489e+07	4842	17064.21	4
2011	31	3	3144508	1.3676788e+08	8009	17076.77	4
2011	35	3	3537305	1.00434474e+09	58808	17078.37	4
2011	31	3	3107604	6.687626e+07	3915	17082.06	4
2011	43	4	4305959	6.669077e+07	3904	17082.68	4
2011	35	3	3529906	3.500607e+08	20455	17113.7	4
2011	35	3	3532702	7.448751e+07	4352	17115.7	4
2011	42	4	4212700	1.0464027e+08	6110	17126.07	4
2011	42	4	4210803	1.198022e+08	6994	17129.28	4
2011	50	5	5003751	2.0115788e+08	11743	17130.02	4
2011	35	3	3554300	3.6826371e+08	21493	17134.12	4
2011	35	3	3555901	2.12503e+07	1240	17137.34	4
2011	35	3	3524808	8.0683263e+08	47076	17138.94	4
2011	41	4	4123204	6.195738e+07	3614	17143.71	4
2011	43	4	4322186	2.678101e+07	1562	17145.33	4
2011	22	2	2209203	1.0460889e+08	6101	17146.19	4
2011	43	4	4306759	3.469082e+07	2023	17148.2	4
2011	41	4	4104428	2.5804679e+08	15045	17151.66	4
2011	50	5	5006309	6.9197742e+08	40330	17157.88	4
2011	43	4	4316105	1.7568595e+08	10235	17165.21	4
2011	43	4	4314787	2.97124e+07	1729	17184.73	4
2011	43	4	4315149	4.325415e+07	2516	17191.63	4
2011	32	3	3202603	2.1676909e+08	12603	17199.8	4
2011	42	4	4217105	5.513456e+07	3205	17202.67	4
2011	42	4	4209458	2.553883e+07	1484	17209.46	4
2011	42	4	4213708	2.5864289e+08	15011	17230.22	4
2011	42	4	4216305	4.6762295e+08	27135	17233.2	4
2011	43	4	4318002	1.05871951e+09	61426	17235.69	4
2011	31	3	3134905	3.9789368e+08	23062	17253.22	4
2011	43	4	4321907	4.1260328e+08	23912	17255.07	4
2011	51	5	5104203	2.4227781e+08	14038	17258.71	4
2011	52	5	5211305	1.0989616e+08	6366	17262.98	4
2011	15	1	1505437	4.8289525e+08	27965	17267.84	4
2011	42	4	4216354	5.976791e+07	3457	17288.95	4
2011	43	4	4306304	8.089854e+07	4679	17289.71	4
2011	31	3	3123502	3.192105e+07	1846	17292.01	4
2011	41	4	4105607	1.933509e+08	11180	17294.36	4
2011	32	3	3205069	3.5933993e+08	20776	17295.92	4
2011	41	4	4109401	2.91327686e+09	168349	17304.98	4
2011	35	3	3527900	4.672642e+07	2700	17306.08	4
2011	42	4	4212270	7.61648e+07	4400	17310.18	4
2011	35	3	3518859	1.2141313e+08	7012	17315.05	4
2011	43	4	4302253	4.806861e+07	2772	17340.77	4
2011	43	4	4319703	6.238202e+07	3596	17347.61	4
2011	52	5	5222203	8.410315e+07	4847	17351.59	4
2011	35	3	3541653	5.693777e+07	3281	17353.79	4
2011	35	3	3527207	1.43934694e+09	82887	17365.17	4
2011	35	3	3510807	4.9362357e+08	28423	17367.05	4
2011	43	4	4303608	1.1323342e+08	6520	17367.09	4
2011	51	5	5108402	4.44367859e+09	255449	17395.56	4
2011	35	3	3516705	7.5031788e+08	43112	17403.92	4
2011	31	3	3162005	4.1822184e+08	24029	17404.88	4
2011	43	4	4307864	4.504401e+07	2588	17404.95	4
2011	43	4	4303301	8.594095e+07	4934	17418.11	4
2011	52	5	5203302	4.3489281e+08	24965	17420.1	4
2011	35	3	3510005	5.215313e+08	29931	17424.45	4
2011	31	3	3128303	3.2628315e+08	18721	17428.72	4
2011	43	4	4316907	4.57309837e+09	262369	17430.03	4
2011	41	4	4116505	2.509114e+07	1439	17436.51	4
2011	31	3	3119807	5.878116e+07	3370	17442.48	4
2011	17	1	1721257	2.79968e+07	1605	17443.49	4
2011	41	4	4114302	3.9424243e+08	22580	17459.81	4
2011	43	4	4320008	2.29772527e+09	131587	17461.64	4
2011	52	5	5202809	4.271525e+07	2446	17463.31	4
2011	31	3	3136306	7.9563189e+08	45559	17463.77	4
2011	43	4	4310413	3.946296e+07	2259	17469.22	4
2011	52	5	5205059	6.324502e+07	3620	17471	4
2011	41	4	4105904	3.9244772e+08	22452	17479.41	4
2011	43	4	4319711	3.799888e+07	2171	17502.94	4
2011	35	3	3533502	6.4634265e+08	36913	17509.89	4
2011	35	3	3532504	1.5348079e+08	8762	17516.64	4
2011	11	1	1100122	2.0562204e+09	117363	17520.18	4
2011	52	5	5214838	2.102484e+08	11994	17529.46	4
2011	41	4	4101002	3.0568583e+08	17438	17529.87	4
2011	43	4	4312625	3.186086e+07	1817	17534.87	4
2011	35	3	3504503	1.46335137e+09	83430	17539.87	4
2011	33	3	3305133	1.236949e+08	7049	17547.87	4
2011	43	4	4303509	1.1051862e+09	62947	17557.41	4
2011	43	4	4309555	7.550896e+07	4300	17560.22	4
2011	35	3	3521903	2.564576e+08	14582	17587.27	4
2011	27	2	2703759	2.1046563e+08	11957	17601.88	4
2011	42	4	4217709	4.734033e+08	26894	17602.56	4
2011	43	4	4316204	9.634929e+07	5473	17604.47	4
2011	51	5	5105622	4.4907687e+08	25495	17614.31	4
2011	35	3	3537404	4.3998795e+08	24957	17629.84	4
2011	31	3	3138203	1.64378412e+09	93231	17631.3	4
2011	35	3	3539905	9.597126e+07	5443	17632.05	4
2011	35	3	3547908	1.1197522e+08	6346	17645.01	4
2011	35	3	3554953	1.0596808e+08	6005	17646.64	4
2011	52	5	5222005	2.2314353e+08	12644	17648.18	4
2011	35	3	3547007	9.656137e+07	5470	17652.9	4
2011	31	3	3132602	7.242074e+07	4102	17654.98	4
2011	33	3	3302908	4.361374e+08	24699	17658.1	4
2011	31	3	3152105	1.01637626e+09	57551	17660.44	4
2011	35	3	3500303	5.7370185e+08	32452	17678.47	4
2011	43	4	4300703	1.0713835e+08	6054	17697.12	4
2011	43	4	4316006	3.4718722e+08	19611	17703.7	4
2011	42	4	4216255	1.0730379e+08	6055	17721.52	4
2011	43	4	4315750	7.712528e+07	4350	17729.95	4
2011	25	2	2504603	3.8635064e+08	21783	17736.34	4
2011	11	1	1100189	6.0273218e+08	33981	17737.33	4
2011	43	4	4304630	7.6146042e+08	42926	17738.91	4
2011	42	4	4200309	8.788447e+07	4954	17740.1	4
2011	52	5	5203500	3.7380633e+08	21071	17740.32	4
2011	41	4	4102208	6.936346e+07	3906	17758.18	4
2011	41	4	4118105	1.8365823e+08	10338	17765.35	4
2011	32	3	3201308	6.2314198e+09	350615	17772.83	4
2011	35	3	3528007	2.8979126e+08	16298	17780.79	4
2011	15	1	1508126	8.0372323e+08	45190	17785.42	4
2011	50	5	5002902	3.7420772e+08	21034	17790.61	4
2011	35	3	3515905	5.316271e+07	2987	17798.03	4
2011	42	4	4203402	1.3247021e+08	7440	17805.14	4
2011	35	3	3543303	2.02592678e+09	113726	17814.1	4
2011	52	5	5217104	4.2901906e+08	24062	17829.73	4
2011	43	4	4313425	6.891255e+07	3865	17829.9	4
2011	41	4	4111555	1.3482991e+08	7560	17834.64	4
2011	41	4	4121406	2.9192301e+08	16363	17840.43	4
2011	31	3	3153004	5.880294e+07	3295	17846.11	4
2011	42	4	4200754	3.565772e+07	1998	17846.71	4
2011	35	3	3510500	1.83014328e+09	102523	17851.05	4
2011	51	5	5107198	3.957294e+07	2216	17857.82	4
2011	50	5	5003306	5.7621825e+08	32259	17862.25	4
2011	31	3	3121209	1.2242064e+08	6850	17871.63	4
2011	43	4	4317509	1.36409665e+09	76239	17892.37	4
2011	31	3	3127107	9.6665829e+08	53998	17901.74	4
2011	43	4	4318440	4.958252e+07	2767	17919.23	4
2011	43	4	4320578	3.778498e+07	2107	17933.07	4
2011	35	3	3540200	7.3635895e+08	41055	17935.91	4
2011	35	3	3518602	6.425489e+08	35824	17936.27	4
2011	31	3	3139409	1.44441526e+09	80530	17936.36	4
2011	43	4	4309704	8.782338e+07	4896	17937.78	4
2011	52	5	5214507	4.4211645e+08	24643	17940.85	4
2011	35	3	3546009	2.4797347e+08	13821	17941.79	4
2011	50	5	5004601	3.3792117e+08	18833	17943.03	4
2011	21	2	2109700	9.882813e+07	5505	17952.43	4
2011	22	2	2204303	2.011977e+08	11202	17960.87	4
2011	42	4	4207304	7.2770735e+08	40514	17961.87	4
2011	33	3	3300506	4.5889334e+08	25539	17968.34	4
2011	35	3	3509452	1.007507e+08	5595	18007.27	4
2011	21	2	2101400	1.53870436e+09	85322	18034.09	4
2011	42	4	4202875	5.076155e+07	2814	18038.93	4
2011	11	1	1100023	1.65188502e+09	91570	18039.59	4
2011	43	4	4318903	6.2068242e+08	34393	18046.77	4
2011	43	4	4312179	3.21596e+07	1782	18046.92	4
2011	52	5	5215306	2.5981095e+08	14395	18048.69	4
2011	43	4	4322707	4.3750443e+08	24189	18086.92	4
2011	43	4	4300877	8.917584e+07	4928	18095.75	4
2011	50	5	5002605	2.4689624e+08	13617	18131.47	4
2011	24	2	2408102	1.470197432e+10	810780	18133.12	4
2011	41	4	4103024	4.969262e+07	2738	18149.24	4
2011	43	4	4313953	1.7814124e+08	9812	18155.45	4
2011	35	3	3519600	9.7523604e+08	53660	18174.36	4
2011	31	3	3168200	3.403197e+07	1871	18189.18	4
2011	35	3	3514403	7.9078201e+08	43470	18191.44	4
2011	35	3	3530508	1.20746078e+09	66345	18199.73	4
2011	29	2	2927002	6.8225862e+08	37464	18211.05	4
2011	32	3	3201209	3.4792363e+09	191042	18211.89	4
2011	41	4	4123824	7.122723e+07	3910	18216.68	4
2011	41	4	4111605	5.515978e+07	3027	18222.59	4
2011	43	4	4321626	4.21796e+07	2312	18243.77	4
2011	35	3	3535002	2.0445499e+08	11201	18253.28	4
2011	35	3	3554755	2.84393e+07	1557	18265.45	4
2011	41	4	4118857	1.0382738e+08	5681	18276.25	4
2011	50	5	5004502	3.8748527e+08	21159	18313.02	4
2011	42	4	4203105	1.1373924e+08	6209	18318.45	4
2011	52	5	5205000	1.6524681e+08	9014	18332.24	4
2011	42	4	4202602	1.6544658e+08	9017	18348.3	4
2011	31	3	3137205	8.539614e+08	46539	18349.37	4
2011	35	3	3516200	5.8934344e+09	321012	18358.92	4
2011	43	4	4323804	2.3433179e+08	12760	18364.56	4
2011	35	3	3522000	6.048199e+07	3293	18366.84	4
2011	31	3	3122306	3.95520752e+09	215247	18375.2	4
2011	41	4	4108908	1.1432792e+08	6220	18380.69	4
2011	42	4	4215000	7.3543011e+08	40011	18380.7	4
2011	35	3	3509601	1.37622055e+09	74869	18381.71	4
2011	42	4	4209904	1.9093132e+08	10387	18381.76	4
2011	31	3	3110509	3.8836494e+08	21122	18386.75	4
2011	35	3	3555000	1.16839543e+09	63487	18403.7	4
2011	43	4	4322301	1.5613806e+08	8482	18408.16	4
2011	41	4	4126801	2.7093617e+08	14712	18416	4
2011	41	4	4121109	9.278447e+07	5037	18420.58	4
2011	51	5	5103106	1.0132806e+08	5500	18423.28	4
2011	43	4	4313003	5.884644e+07	3191	18441.38	4
2011	35	3	3521309	2.6417369e+08	14323	18444.02	4
2011	51	5	5101803	1.04968576e+09	56903	18446.93	4
2011	35	3	3536604	1.5862573e+08	8598	18449.14	4
2011	35	3	3515509	1.19792156e+09	64931	18449.15	4
2011	41	4	4109658	1.0855356e+08	5883	18452.07	4
2011	42	4	4200051	4.881054e+07	2644	18460.87	4
2011	35	3	3513850	3.129942e+07	1695	18465.74	4
2011	35	3	3502705	4.6239296e+08	25040	18466.17	4
2011	42	4	4207908	1.9403257e+08	10503	18474.01	4
2011	42	4	4215208	1.0130488e+08	5479	18489.67	4
2011	52	5	5221809	5.682126e+07	3072	18496.5	4
2011	42	4	4205456	4.2364823e+08	22871	18523.38	4
2011	41	4	4113403	7.63891e+07	4123	18527.55	4
2011	35	3	3545704	1.0629732e+08	5734	18538.08	4
2011	31	3	3149200	6.489458e+07	3500	18541.31	4
2011	35	3	3542602	1.00767937e+09	54301	18557.29	4
2011	41	4	4112603	2.599908e+07	1401	18557.52	4
2011	41	4	4112751	1.6587094e+08	8938	18557.95	4
2011	31	3	3110608	4.9678809e+08	26759	18565.27	4
2011	43	4	4306452	6.096081e+07	3283	18568.63	4
2011	41	4	4120333	6.420176e+07	3456	18576.9	4
2011	41	4	4108403	1.48430539e+09	79850	18588.67	4
2011	31	3	3172004	7.1296334e+08	38353	18589.51	4
2011	43	4	4314076	1.1242712e+08	6046	18595.29	4
2011	25	2	2509305	1.4006032e+08	7526	18610.19	4
2011	52	5	5212253	2.383896e+07	1280	18624.18	4
2011	41	4	4102703	5.081222e+07	2728	18626.18	4
2011	43	4	4310439	1.1290815e+08	6059	18634.78	4
2011	35	3	3537156	5.492508e+07	2947	18637.63	4
2011	42	4	4205209	8.128972e+07	4359	18648.71	4
2011	42	4	4209300	2.92230205e+09	156665	18653.19	4
2011	35	3	3550902	2.6862496e+08	14398	18657.1	4
2011	28	2	2800308	1.081713268e+10	579563	18664.29	4
2011	35	3	3523008	8.210424e+07	4397	18672.78	4
2011	35	3	3553302	4.1870195e+08	22418	18677.04	4
2011	52	5	5200852	1.0373407e+08	5553	18680.73	4
2011	24	2	2402501	1.8470758e+08	9883	18689.42	4
2011	41	4	4107405	1.1367845e+08	6082	18690.97	4
2011	42	4	4202800	5.4870209e+08	29351	18694.49	4
2011	41	4	4102000	6.1783106e+08	33003	18720.45	4
2011	35	3	3511706	2.8537299e+08	15243	18721.58	4
2011	41	4	4111100	1.1201107e+08	5981	18727.82	4
2011	35	3	3556503	2.02613725e+09	108186	18728.28	4
2011	17	1	1721000	4.40718356e+09	235316	18728.79	4
2011	31	3	3164308	1.2578301e+08	6714	18734.44	4
2011	42	4	4219408	6.795076e+07	3627	18734.7	4
2011	51	5	5104500	4.54266e+07	2424	18740.35	4
2011	42	4	4206405	1.9619007e+08	10457	18761.6	4
2011	43	4	4314175	4.105077e+07	2188	18761.78	4
2011	41	4	4103354	1.0695918e+08	5700	18764.77	4
2011	35	3	3525854	5.341182e+07	2845	18773.93	4
2011	41	4	4114203	6.1508775e+08	32755	18778.44	4
2011	33	3	3302452	9.952512e+07	5299	18781.87	4
2011	31	3	3142601	1.5409514e+08	8203	18785.22	4
2011	31	3	3142809	3.7087878e+08	19743	18785.33	4
2011	41	4	4106407	8.8310562e+08	46934	18815.9	4
2011	41	4	4113205	8.5053507e+08	45137	18843.41	4
2011	50	5	5007901	8.2090629e+08	43564	18843.68	4
2011	43	4	4320230	5.647096e+07	2996	18848.79	4
2011	43	4	4306130	3.978564e+07	2110	18855.75	4
2011	51	5	5101258	2.9184249e+08	15470	18865.06	4
2011	41	4	4126108	1.0138028e+08	5373	18868.47	4
2011	41	4	4119657	5.369267e+07	2845	18872.64	4
2011	43	4	4308250	3.762224e+07	1992	18886.67	4
2011	43	4	4319372	5.430426e+07	2874	18895.01	4
2011	33	3	3305703	2.8276352e+08	14956	18906.36	4
2011	41	4	4101853	4.576404e+07	2420	18910.76	4
2011	35	3	3553401	4.5734515e+08	24168	18923.58	4
2011	35	3	3512506	1.0050828e+08	5302	18956.67	4
2011	35	3	3515608	1.0506258e+08	5542	18957.52	4
2011	41	4	4111209	2.0168923e+08	10637	18961.1	4
2011	29	2	2924009	2.07470115e+09	109310	18979.98	4
2011	43	4	4312708	2.2808299e+08	12017	18980.03	4
2011	31	3	3127800	2.8664777e+08	15086	19000.91	4
2011	31	3	3148103	1.58078297e+09	83188	19002.54	4
2011	31	3	3111101	3.6760154e+08	19342	19005.35	4
2011	33	3	3300258	5.3242912e+08	28010	19008.54	4
2011	35	3	3513306	4.277908e+07	2249	19021.38	4
2011	41	4	4115754	1.6588716e+08	8715	19034.67	4
2011	35	3	3506508	2.09219197e+09	109836	19048.33	4
2011	14	1	1400100	5.53988797e+09	290741	19054.37	4
2011	43	4	4320321	5.347543e+07	2806	19057.53	4
2011	35	3	3524105	7.4110144e+08	38882	19060.27	4
2011	35	3	3557006	2.09420739e+09	109798	19073.27	4
2011	43	4	4310603	7.2564839e+08	38036	19077.94	4
2011	31	3	3139003	7.442586e+08	38981	19092.86	4
2011	43	4	4306924	2.827976e+07	1481	19095.05	4
2011	52	5	5219308	6.9993119e+08	36617	19114.92	4
2011	42	4	4209177	4.097107e+07	2143	19118.56	4
2011	35	3	3516507	5.17663e+07	2707	19123.12	4
2011	21	2	2101251	2.9209885e+08	15264	19136.45	4
2011	11	1	1100304	1.49147733e+09	77937	19136.96	4
2011	41	4	4115853	9.72439e+07	5080	19142.5	4
2011	41	4	4117404	6.468386e+07	3379	19142.9	4
2011	42	4	4200507	1.1748902e+08	6136	19147.49	4
2011	42	4	4203501	1.7803529e+08	9295	19153.88	4
2011	42	4	4200200	1.8081326e+08	9440	19153.95	4
2011	41	4	4110953	1.7616077e+08	9195	19158.32	4
2011	35	3	3545159	1.3716988e+08	7156	19168.51	4
2011	42	4	4200606	1.0770433e+08	5618	19171.29	4
2011	42	4	4206900	3.3519131e+08	17448	19210.87	4
2011	42	4	4214003	2.9008443e+08	15084	19231.27	4
2011	41	4	4114807	6.1948039e+08	32209	19233.15	4
2011	35	3	3534708	1.99748352e+09	103739	19254.89	4
2011	17	1	1716208	1.9903208e+08	10333	19261.79	4
2011	35	3	3555208	3.723499e+07	1933	19262.8	4
2011	35	3	3500204	6.841395e+07	3548	19282.4	4
2011	35	3	3510104	5.156944e+07	2673	19292.72	4
2011	35	3	3546801	9.8349803e+08	50969	19296	4
2011	32	3	3201506	2.17022272e+09	112432	19302.54	4
2011	24	2	2408003	5.08383314e+09	263344	19304.91	4
2011	41	4	4120358	1.0772955e+08	5580	19306.37	4
2011	43	4	4308706	1.1248196e+08	5822	19320.16	4
2011	51	5	5105606	2.7815935e+08	14396	19321.99	4
2011	42	4	4214904	8.617228e+07	4456	19338.48	4
2011	41	4	4124301	4.601105e+07	2379	19340.5	4
2011	33	3	3305505	1.46844796e+09	75906	19345.61	4
2011	42	4	4204806	7.3285072e+08	37878	19347.66	4
2011	31	3	3124708	6.79668e+07	3510	19363.76	4
2011	29	2	2930774	4.2758066e+08	22056	19386.14	4
2011	43	4	4304002	1.0406254e+08	5363	19403.79	4
2011	43	4	4304309	1.2599684e+08	6493	19405.03	4
2011	41	4	4107504	2.6978672e+08	13893	19418.9	4
2011	21	2	2111300	1.995297006e+10	1027430	19420.27	4
2011	42	4	4208500	4.3630384e+08	22462	19424.09	4
2011	51	5	5107958	1.65735411e+09	85319	19425.38	4
2011	41	4	4110656	4.954345e+07	2550	19428.8	4
2011	43	4	4322509	1.19895998e+09	61650	19447.85	4
2011	42	4	4202453	2.8635729e+08	14722	19450.98	4
2011	17	1	1711902	2.0465816e+08	10521	19452.35	4
2011	35	3	3509809	8.885312e+07	4567	19455.47	4
2011	35	3	3539509	6.9405487e+08	35626	19481.7	4
2011	43	4	4321808	4.6169321e+08	23695	19484.84	4
2011	42	4	4201406	1.20454464e+09	61817	19485.65	4
2011	22	2	2208908	1.3508724e+08	6932	19487.48	4
2011	31	3	3131604	1.2689599e+08	6511	19489.48	5
2011	42	4	4208302	9.227116e+08	47327	19496.52	5
2011	52	5	5220603	3.7439196e+08	19193	19506.69	5
2011	51	5	5105507	2.8555909e+08	14634	19513.4	5
2011	41	4	4104204	2.22354205e+09	113882	19524.96	5
2011	29	2	2921005	7.9790818e+08	40866	19524.99	5
2011	52	5	5213707	1.5599443e+08	7987	19531.04	5
2011	43	4	4306379	5.965321e+07	3054	19532.81	5
2011	42	4	4216701	2.6732719e+08	13685	19534.32	5
2011	35	3	3552304	1.4540295e+08	7441	19540.78	5
2011	35	3	3547502	5.18274e+08	26505	19553.82	5
2011	42	4	4201604	6.850556e+07	3503	19556.25	5
2011	24	2	2409902	2.6598543e+08	13588	19575.02	5
2011	41	4	4115606	3.1736815e+08	16212	19576.13	5
2011	22	2	2204501	2.0102175e+08	10268	19577.5	5
2011	43	4	4319505	4.3278115e+08	22104	19579.31	5
2011	31	3	3103900	1.5685277e+08	8011	19579.67	5
2011	42	4	4200804	1.2382004e+08	6323	19582.48	5
2011	43	4	4310876	4.933972e+07	2519	19587.03	5
2011	41	4	4125803	2.0020093e+08	10221	19587.22	5
2011	50	5	5005152	1.1704419e+08	5971	19602.11	5
2011	35	3	3544905	2.0942011e+08	10664	19638.05	5
2011	43	4	4306932	1.7449859e+08	8880	19650.74	5
2011	41	4	4115309	1.2357634e+08	6288	19652.73	5
2011	35	3	3511409	3.4842441e+08	17716	19667.22	5
2011	31	3	3108206	1.1448734e+08	5821	19667.98	5
2011	43	4	4319109	1.1276422e+08	5731	19676.19	5
2011	42	4	4206108	1.2292101e+08	6246	19679.96	5
2011	43	4	4305504	9.652478e+07	4897	19711	5
2011	43	4	4322855	3.857421e+07	1956	19720.97	5
2011	41	4	4104907	1.32853694e+09	67353	19724.99	5
2011	31	3	3134202	1.92909061e+09	97792	19726.47	5
2011	35	3	3550100	7.5927925e+08	38480	19731.79	5
2011	33	3	3305802	3.27423425e+09	165716	19758.11	5
2011	41	4	4101903	3.2058692e+08	16225	19758.82	5
2011	31	3	3171204	2.10823955e+09	106685	19761.35	5
2011	31	3	3143104	9.073719e+08	45916	19761.56	5
2011	42	4	4217402	3.1235021e+08	15790	19781.52	5
2011	41	4	4128005	4.2503935e+08	21479	19788.6	5
2011	52	5	5216007	5.294087e+07	2675	19790.98	5
2011	50	5	5003900	5.823104e+07	2937	19826.71	5
2011	50	5	5007505	9.862094e+07	4972	19835.27	5
2011	52	5	5203906	1.8011105e+08	9080	19836.02	5
2011	35	3	3555703	3.210215e+07	1618	19840.64	5
2011	28	2	2802106	1.28640204e+09	64825	19844.23	5
2011	51	5	5107008	3.4565197e+08	17413	19850.23	5
2011	35	3	3557105	1.69524507e+09	85387	19853.67	5
2011	35	3	3504008	1.90229428e+09	95750	19867.3	5
2011	42	4	4210100	1.05670841e+09	53141	19884.99	5
2011	42	4	4203253	5.43786e+07	2733	19897.04	5
2011	35	3	3535507	8.4538236e+08	42483	19899.31	5
2011	31	3	3141306	6.924472e+07	3476	19920.8	5
2011	31	3	3104106	1.9184689e+08	9623	19936.29	5
2011	41	4	4116059	2.089863e+08	10478	19945.25	5
2011	52	5	5222054	1.4922971e+08	7476	19961.17	5
2011	51	5	5106307	3.9150473e+08	19594	19980.85	5
2011	27	2	2702306	1.05343171e+09	52716	19983.15	5
2011	41	4	4110052	4.464313e+07	2233	19992.45	5
2011	52	5	5204508	1.44091124e+09	72071	19992.94	5
2011	43	4	4318499	4.370185e+07	2185	20000.85	5
2011	35	3	3532603	2.154434e+08	10766	20011.46	5
2011	13	1	1303536	5.5905238e+08	27926	20019.06	5
2011	35	3	3539202	4.9858247e+08	24893	20029.02	5
2011	43	4	4313102	1.2724004e+08	6345	20053.59	5
2011	31	3	3103504	2.2142363e+09	110402	20056.12	5
2011	31	3	3161700	1.2711115e+08	6328	20087.1	5
2011	52	5	5213806	8.4018302e+08	41804	20098.15	5
2011	33	3	3300407	3.58469664e+09	178355	20098.66	5
2011	52	5	5204409	3.4014892e+08	16917	20106.93	5
2011	42	4	4202305	1.18647685e+09	58984	20115.23	5
2011	31	3	3136702	1.049036137e+10	520811	20142.36	5
2011	41	4	4105508	1.42896045e+09	70922	20148.34	5
2011	31	3	3169901	2.07159872e+09	102782	20155.27	5
2011	17	1	1715259	5.003717e+07	2481	20168.15	5
2011	35	3	3523602	3.1748676e+08	15731	20182.24	5
2011	51	5	5107354	1.0629324e+08	5266	20184.82	5
2011	35	3	3536000	2.1880969e+08	10825	20213.37	5
2011	35	3	3500105	6.8368922e+08	33821	20214.93	5
2011	35	3	3537107	8.4993872e+08	42045	20214.98	5
2011	43	4	4315800	2.0949168e+08	10362	20217.3	5
2011	27	2	2702702	8.87656e+07	4385	20243.01	5
2011	43	4	4312955	3.927674e+07	1940	20245.74	5
2011	35	3	3530300	1.09801511e+09	54212	20254.1	5
2011	43	4	4317905	2.9051707e+08	14339	20260.62	5
2011	41	4	4122305	6.3771683e+08	31471	20263.63	5
2011	31	3	3147105	1.72428759e+09	85076	20267.61	5
2011	52	5	5219209	6.318171e+07	3117	20270.04	5
2011	52	5	5200134	4.1450139e+08	20431	20287.87	5
2011	41	4	4122008	2.8766845e+08	14176	20292.64	5
2011	42	4	4208609	8.185079e+07	4030	20310.37	5
2011	50	5	5003207	2.1192363e+09	104318	20315.15	5
2011	29	2	2919926	3.6141247e+08	17786	20320.05	5
2011	35	3	3550605	1.62133445e+09	79757	20328.43	5
2011	50	5	5002159	1.6174836e+08	7956	20330.36	5
2011	42	4	4211652	5.540241e+07	2724	20338.62	5
2011	51	5	5104807	5.2461633e+08	25790	20341.85	5
2011	35	3	3512704	7.897547e+07	3881	20349.26	5
2011	43	4	4309407	4.6858117e+08	23026	20350.09	5
2011	41	4	4122602	1.8376923e+08	9025	20362.24	5
2011	43	4	4317558	4.346012e+07	2134	20365.57	5
2011	42	4	4207858	4.238159e+07	2081	20365.97	5
2011	35	3	3532900	1.9274503e+08	9453	20389.83	5
2011	43	4	4303673	6.633246e+07	3253	20391.17	5
2011	35	3	3526704	1.88903203e+09	92601	20399.69	5
2011	35	3	3557303	2.0679377e+08	10136	20401.91	5
2011	42	4	4215695	2.95563e+07	1448	20411.81	5
2011	35	3	3522307	2.97688364e+09	145822	20414.5	5
2011	43	4	4300554	3.727836e+07	1826	20415.31	5
2011	35	3	3525003	2.24042879e+09	109614	20439.26	5
2011	31	3	3137601	1.09695128e+09	53645	20448.34	5
2011	31	3	3101607	1.51998862e+09	74298	20458	5
2011	42	4	4212809	3.5919213e+08	17552	20464.46	5
2011	43	4	4316758	1.1801124e+08	5766	20466.74	5
2011	43	4	4308904	3.3009788e+08	16127	20468.65	5
2011	13	1	1301308	4.840443e+08	23644	20472.18	5
2011	43	4	4308656	6.557793e+07	3201	20486.7	5
2011	41	4	4117701	6.6049462e+08	32232	20491.89	5
2011	31	3	3135407	1.0946673e+08	5341	20495.55	5
2011	43	4	4312427	5.688691e+07	2774	20507.18	5
2011	52	5	5207352	7.646076e+07	3728	20509.86	5
2011	43	4	4309258	3.255712e+07	1587	20514.88	5
2011	52	5	5201454	4.983129e+07	2429	20515.14	5
2011	31	3	3151503	6.5932731e+08	32121	20526.36	5
2011	43	4	4305900	1.5802384e+08	7696	20533.24	5
2011	15	1	1503044	3.705261e+08	18036	20543.7	5
2011	43	4	4309902	1.4735858e+08	7172	20546.37	5
2011	42	4	4205506	7.1337974e+08	34677	20572.13	5
2011	43	4	4318481	8.535687e+07	4149	20572.88	5
2011	35	3	3535309	4.3670489e+08	21224	20575.99	5
2011	35	3	3514106	5.130635e+08	24933	20577.69	5
2011	42	4	4200556	4.974769e+07	2417	20582.41	5
2011	35	3	3556107	2.3103987e+08	11223	20586.28	5
2011	35	3	3516903	2.1952162e+08	10658	20596.89	5
2011	35	3	3520103	5.7902545e+08	28108	20600.02	5
2011	35	3	3531407	4.5339343e+08	22002	20606.92	5
2011	35	3	3540606	1.01425958e+09	49153	20634.74	5
2011	41	4	4124020	2.1256253e+08	10300	20637.14	5
2011	32	3	3205200	8.66530097e+09	419854	20638.84	5
2011	41	4	4123501	4.8913439e+08	23638	20692.71	5
2011	51	5	5107305	3.6132568e+08	17461	20693.3	5
2011	50	5	5007554	1.5126052e+08	7307	20700.77	5
2011	42	4	4210035	1.1602389e+08	5603	20707.46	5
2011	41	4	4104006	8.0977616e+08	39092	20714.63	5
2011	43	4	4306734	1.0854898e+08	5236	20731.28	5
2011	24	2	2408805	1.012957e+08	4885	20736.07	5
2011	42	4	4212304	1.4002257e+08	6751	20741.01	5
2011	42	4	4209854	9.60835e+07	4632	20743.42	5
2011	50	5	5001508	1.3741729e+08	6624	20745.36	5
2011	43	4	4316956	1.2601735e+08	6066	20774.37	5
2011	27	2	2708105	2.2612132e+08	10875	20792.76	5
2011	35	3	3518206	6.3940679e+08	30732	20805.9	5
2011	41	4	4122909	1.0718791e+08	5150	20813.19	5
2011	42	4	4212403	8.523552e+07	4093	20824.7	5
2011	50	5	5007109	4.4308279e+08	21271	20830.37	5
2011	35	3	3517901	2.097428e+08	10063	20842.97	5
2011	42	4	4207007	1.24287702e+09	59616	20848.04	5
2011	42	4	4212205	3.7573135e+08	18013	20858.9	5
2011	41	4	4116703	2.4482621e+08	11730	20871.8	5
2011	42	4	4203808	1.10353209e+09	52853	20879.27	5
2011	35	3	3511300	1.687503e+08	8070	20910.82	5
2011	51	5	5105002	2.1449382e+08	10255	20916.02	5
2011	24	2	2404507	2.6633142e+08	12731	20919.91	5
2011	35	3	3531209	1.5112363e+08	7216	20942.85	5
2011	52	5	5218508	9.1630367e+08	43735	20951.27	5
2011	17	1	1713205	4.2750453e+08	20396	20960.21	5
2011	41	4	4117222	1.6077254e+08	7665	20974.89	5
2011	35	3	3515152	3.3891422e+08	16158	20975.01	5
2011	43	4	4308102	2.6103896e+08	12440	20983.84	5
2011	43	4	4310405	1.3779965e+08	6566	20986.85	5
2011	43	4	4305009	1.9444275e+08	9256	21007.21	5
2011	41	4	4106852	6.600382e+07	3140	21020.32	5
2011	50	5	5005707	9.9321405e+08	47174	21054.27	5
2011	35	3	3517802	1.7687124e+08	8400	21056.1	5
2011	43	4	4316600	3.2479148e+08	15422	21060.27	5
2011	33	3	3305158	4.2999607e+08	20398	21080.31	5
2011	42	4	4217808	3.6609287e+08	17337	21116.28	5
2011	35	3	3528304	6.726366e+07	3184	21125.52	5
2011	43	4	4313359	7.115257e+07	3367	21132.33	5
2011	31	3	3133105	3.0163127e+08	14272	21134.48	5
2011	11	1	1100924	1.7998108e+08	8515	21136.94	5
2011	31	3	3158300	1.524669e+08	7209	21149.52	5
2011	31	3	3154804	1.9457789e+08	9200	21149.77	5
2011	35	3	3555604	2.0103619e+08	9505	21150.57	5
2011	51	5	5100201	4.5148181e+08	21325	21171.48	5
2011	43	4	4313037	1.0003363e+08	4722	21184.59	5
2011	41	4	4106308	3.4665725e+08	16352	21199.68	5
2011	31	3	3119302	5.8455553e+08	27555	21214.14	5
2011	52	5	5203203	1.889566e+08	8906	21216.78	5
2011	52	5	5220264	8.020197e+07	3779	21223.07	5
2011	41	4	4112801	2.2961465e+08	10819	21223.28	5
2011	31	3	3170750	1.3076028e+08	6158	21234.21	5
2011	23	2	2305233	1.20691558e+09	56830	21237.3	5
2011	52	5	5209937	1.2180443e+08	5735	21238.78	5
2011	42	4	4219200	1.3376287e+08	6287	21276.1	5
2011	43	4	4306973	6.312773e+07	2966	21283.79	5
2011	43	4	4301875	8.562267e+07	4022	21288.58	5
2011	35	3	3513405	1.64667777e+09	77312	21299.12	5
2011	28	2	2803203	6.5663793e+08	30798	21320.8	5
2011	42	4	4212239	8.584875e+07	4026	21323.58	5
2011	35	3	3515004	5.17729023e+09	242730	21329.42	5
2011	43	4	4307815	7.739347e+07	3624	21355.81	5
2011	31	3	3114550	2.0330144e+08	9515	21366.41	5
2011	42	4	4212007	1.6526415e+08	7732	21374.05	5
2011	27	2	2708600	1.18704846e+09	55463	21402.53	5
2011	43	4	4306767	7.4710531e+08	34887	21415.01	5
2011	26	2	2607752	5.1508486e+08	24050	21417.25	5
2011	24	2	2404309	2.6612704e+08	12421	21425.57	5
2011	43	4	4308508	6.2201615e+08	29003	21446.61	5
2011	41	4	4121604	1.4591856e+08	6801	21455.46	5
2011	35	3	3532157	5.884073e+07	2741	21466.88	5
2011	42	4	4204004	2.0728719e+08	9653	21473.86	5
2011	43	4	4309506	1.7287441e+08	8048	21480.42	5
2011	35	3	3544400	5.930142e+07	2760	21486.02	5
2011	43	4	4322103	1.2616194e+08	5867	21503.65	5
2011	35	3	3534609	6.6700665e+08	31015	21505.94	5
2011	42	4	4204400	2.1912441e+08	10189	21505.98	5
2011	41	4	4127957	1.7205199e+08	7996	21517.26	5
2011	24	2	2401206	2.8079059e+08	13047	21521.47	5
2011	35	3	3544301	2.0831995e+08	9678	21525.1	5
2011	31	3	3109451	1.3997078e+08	6494	21553.86	5
2011	31	3	3109808	5.44081e+07	2521	21581.95	5
2011	41	4	4101101	4.4316432e+08	20530	21586.18	5
2011	41	4	4110003	8.663096e+07	4012	21592.96	5
2011	31	3	3154408	1.0198864e+08	4723	21594.04	5
2011	50	5	5004403	1.6542917e+08	7654	21613.43	5
2011	43	4	4300802	2.7725193e+08	12827	21614.71	5
2011	42	4	4216008	2.2419223e+08	10363	21633.91	5
2011	33	3	3304128	2.8022942e+08	12952	21636	5
2011	33	3	3304300	1.21239619e+09	56001	21649.55	5
2011	31	3	3162955	4.3668578e+08	20168	21652.41	5
2011	41	4	4103701	2.10885177e+09	97390	21653.68	5
2011	31	3	3141108	7.4296264e+08	34295	21663.88	5
2011	43	4	4315958	5.464096e+07	2522	21665.73	5
2011	35	3	3511003	3.9571404e+08	18238	21697.23	5
2011	31	3	3171006	4.2934419e+08	19785	21700.49	5
2011	52	5	5222302	1.1282082e+08	5196	21713.01	5
2011	42	4	4209508	1.3198919e+08	6077	21719.47	5
2011	41	4	4118709	1.5088339e+08	6940	21741.12	5
2011	41	4	4107207	7.9373915e+08	36501	21745.68	5
2011	41	4	4115804	9.1639203e+08	42124	21754.63	5
2011	51	5	5106232	3.8665155e+08	17771	21757.44	5
2011	32	3	3203353	2.4364545e+08	11198	21757.94	5
2011	41	4	4113734	1.5893104e+08	7298	21777.34	5
2011	41	4	4104808	6.30745677e+09	289340	21799.46	5
2011	41	4	4126504	3.4194754e+08	15676	21813.44	5
2011	35	3	3507902	4.7578081e+08	21787	21837.83	5
2011	42	4	4201653	4.931608e+07	2257	21850.28	5
2011	43	4	4302501	1.4897262e+08	6817	21853.1	5
2011	26	2	2603603	1.7875983e+08	8180	21853.28	5
2011	41	4	4101705	2.9381889e+08	13445	21853.39	5
2011	43	4	4319000	4.4137613e+08	20191	21860.04	5
2011	31	3	3133006	3.0919261e+08	14142	21863.43	5
2011	43	4	4302584	4.787479e+07	2189	21870.62	5
2011	51	5	5108105	7.541141e+07	3436	21947.44	5
2011	43	4	4317806	3.0589887e+08	13933	21954.99	5
2011	35	3	3541703	2.8345041e+08	12887	21995.07	5
2011	16	1	1600154	2.4842764e+08	11292	22000.32	5
2011	35	3	3548005	4.589451e+08	20844	22018.09	5
2011	27	2	2704708	1.02946065e+09	46754	22018.66	5
2011	43	4	4318705	4.75295073e+09	215664	22038.68	5
2011	42	4	4214706	2.2894424e+08	10388	22039.3	5
2011	43	4	4301800	1.1774271e+08	5339	22053.33	5
2011	35	3	3515186	9.2701243e+08	42017	22062.79	5
2011	52	5	5204003	1.6346233e+08	7400	22089.5	5
2011	28	2	2807204	1.7867277e+08	8088	22091.09	5
2011	51	5	5101704	7.1017382e+08	32134	22100.39	5
2011	43	4	4323606	3.463017e+07	1566	22113.78	5
2011	43	4	4307609	9.5457958e+08	43146	22124.41	5
2011	43	4	4308003	1.4734906e+08	6660	22124.48	5
2011	50	5	5002704	1.761933027e+10	796252	22127.83	5
2011	43	4	4301651	1.2771812e+08	5768	22142.53	5
2011	17	1	1703057	7.00197e+07	3162	22144.12	5
2011	35	3	3546603	6.5260519e+08	29449	22160.52	5
2011	50	5	5002001	2.4295344e+08	10960	22167.28	5
2011	35	3	3542206	6.3875606e+08	28807	22173.64	5
2011	31	3	3170404	1.73300579e+09	78144	22177.08	5
2011	35	3	3521408	4.5185164e+08	20373	22178.94	5
2011	43	4	4307559	1.3331123e+08	5995	22237.07	5
2011	50	5	5000906	1.8391923e+08	8270	22239.33	5
2011	31	3	3165537	5.8874958e+08	26470	22242.15	5
2011	35	3	3525706	7.3594104e+08	33074	22251.35	5
2011	42	4	4207684	1.5252216e+08	6850	22266.01	5
2011	31	3	3133402	3.0745296e+08	13797	22284.04	5
2011	52	5	5209150	1.1197217e+08	5022	22296.33	5
2011	43	4	4319901	1.68267614e+09	75430	22307.78	5
2011	41	4	4104055	9.709004e+07	4352	22309.29	5
2011	35	3	3513108	7.1267514e+08	31943	22310.84	5
2011	31	3	3130101	7.9513905e+08	35620	22322.83	5
2011	43	4	4310900	8.082419e+07	3620	22327.13	5
2011	41	4	4112108	4.5361107e+08	20315	22328.87	5
2011	33	3	3300951	1.8315151e+08	8200	22335.55	5
2011	41	4	4114906	1.9776246e+08	8848	22351.09	5
2011	42	4	4211900	3.1334735e+09	139990	22383.55	5
2011	42	4	4211306	1.39247968e+09	62187	22391.81	5
2011	35	3	3525300	2.96905268e+09	132494	22408.96	5
2011	43	4	4322350	3.262527e+07	1455	22422.87	5
2011	43	4	4302352	2.6843351e+08	11966	22433.02	5
2011	29	2	2910602	7.4521475e+08	33217	22434.74	5
2011	42	4	4217600	2.9350581e+08	13069	22458.17	5
2011	41	4	4124608	1.4408477e+08	6389	22552.01	5
2011	31	3	3133808	1.94365941e+09	86124	22568.15	5
2011	35	3	3534757	1.9336824e+08	8568	22568.66	5
2011	35	3	3545803	4.08065078e+09	180772	22573.47	5
2011	31	3	3103801	6.277115e+07	2778	22595.81	5
2011	43	4	4311304	6.2143839e+08	27495	22601.87	5
2011	35	3	3500907	8.673878e+07	3837	22605.88	5
2011	35	3	3540804	3.5241524e+08	15587	22609.56	5
2011	52	5	5211701	1.3908673e+08	6151	22612.05	5
2011	52	5	5214606	9.6478493e+08	42652	22619.92	5
2011	43	4	4306809	4.6740991e+08	20663	22620.62	5
2011	35	3	3549250	4.046927e+07	1789	22621.17	5
2011	42	4	4203303	2.6596466e+08	11757	22621.81	5
2011	43	4	4303558	5.89646e+07	2600	22678.69	5
2011	35	3	3546405	1.00133441e+09	44152	22679.25	5
2011	52	5	5206404	3.603141e+08	15844	22741.36	5
2011	51	5	5107909	2.63909992e+09	116014	22748.12	5
2011	51	5	5101852	1.2372816e+08	5437	22756.7	5
2011	50	5	5007976	8.029344e+07	3520	22810.63	5
2011	35	3	3507456	5.294486e+07	2321	22811.23	5
2011	41	4	4112959	1.7349475e+08	7604	22816.25	5
2011	31	3	3132404	2.08255452e+09	91159	22845.3	5
2011	31	3	3169307	1.67647046e+09	73339	22859.19	5
2011	35	3	3542404	4.2557403e+08	18609	22869.26	5
2011	43	4	4321469	6.281232e+07	2746	22874.11	5
2011	35	3	3519501	1.5576237e+08	6804	22892.76	5
2011	43	4	4303806	1.257279e+08	5491	22897.09	5
2011	42	4	4219705	5.9417755e+08	25933	22912.03	5
2011	50	5	5007935	3.4920769e+08	15240	22913.89	5
2011	52	5	5202353	7.385404e+07	3222	22921.8	5
2011	35	3	3508306	9.972902e+07	4343	22963.16	5
2011	35	3	3505807	4.6948047e+08	20435	22974.33	5
2011	41	4	4114005	3.187518e+08	13870	22981.38	5
2011	35	3	3533205	7.234796e+07	3146	22996.81	5
2011	41	4	4127403	3.8636744e+08	16795	23004.91	5
2011	31	3	3109303	5.2756801e+08	22917	23020.81	5
2011	35	3	3529658	4.33667e+07	1883	23030.64	5
2011	52	5	5200175	1.1834775e+08	5138	23033.82	5
2011	35	3	3506102	1.72903783e+09	75052	23037.86	5
2011	41	4	4112009	7.5515165e+08	32747	23060.18	5
2011	42	4	4218707	2.2562077e+09	97833	23061.83	5
2011	41	4	4104303	2.02364734e+09	87710	23072.03	5
2011	43	4	4301503	1.6253836e+08	7042	23081.28	5
2011	35	3	3528700	1.1315506e+08	4898	23102.3	5
2011	51	5	5104542	1.2527957e+08	5420	23114.31	5
2011	52	5	5215702	5.4946062e+08	23762	23123.5	5
2011	51	5	5106299	2.4784415e+08	10718	23124.1	5
2011	35	3	3556305	5.2922314e+08	22884	23126.34	5
2011	11	1	1101468	5.324952e+07	2299	23162.04	5
2011	43	4	4319752	4.55649e+07	1965	23188.24	5
2011	31	3	3149309	1.37360889e+09	59213	23197.76	5
2011	35	3	3514304	1.9982487e+08	8610	23208.46	5
2011	35	3	3520806	8.480812e+07	3654	23209.67	5
2011	35	3	3549102	1.95312322e+09	84119	23218.57	5
2011	31	3	3118205	1.5245159e+08	6559	23243.11	5
2011	35	3	3505906	1.32243382e+09	56888	23246.27	5
2011	35	3	3509007	2.04234444e+09	87704	23286.79	5
2011	35	3	3529005	5.08399662e+09	218229	23296.61	5
2011	35	3	3529401	9.81310804e+09	421184	23298.86	5
2011	31	3	3104205	8.5976821e+08	36898	23301.21	5
2011	29	2	2902054	2.7095726e+08	11602	23354.36	5
2011	51	5	5107941	2.3039011e+08	9863	23359.03	5
2011	32	3	3202504	2.6310607e+08	11258	23370.59	5
2011	32	3	3204203	4.2933685e+08	18364	23379.27	5
2011	42	4	4207106	2.9248948e+08	12492	23414.14	5
2011	41	4	4113908	3.0456526e+08	13002	23424.49	5
2011	35	3	3531001	5.015367e+07	2138	23458.22	5
2011	35	3	3549409	1.10066476e+09	46891	23472.84	5
2011	52	5	5213103	1.26872335e+09	54003	23493.57	5
2011	43	4	4311791	5.961178e+07	2537	23496.96	5
2011	42	4	4202701	1.0642533e+08	4527	23509.02	5
2011	43	4	4304705	1.39767602e+09	59445	23512.09	5
2011	43	4	4312351	3.60399e+07	1532	23524.74	5
2011	50	5	5000203	3.4572446e+08	14686	23541.09	5
2011	41	4	4120655	1.134754e+08	4820	23542.61	5
2011	42	4	4203907	4.927014e+08	20919	23552.82	5
2011	43	4	4320107	5.0808601e+08	21525	23604.46	5
2011	31	3	3161304	1.3727972e+08	5815	23607.86	5
2011	35	3	3511904	1.6983523e+08	7193	23611.18	5
2011	42	4	4217303	2.1426347e+08	9070	23623.32	5
2011	41	4	4127700	2.85707525e+09	120934	23625.08	5
2011	42	4	4219606	9.746323e+07	4122	23644.65	5
2011	23	2	2307650	5.00588479e+09	211267	23694.59	5
2011	43	4	4313706	8.0983784e+08	34170	23700.26	5
2011	42	4	4215703	4.7620424e+08	20082	23712.99	5
2011	50	5	5006200	1.10012175e+09	46369	23725.37	5
2011	42	4	4218806	2.8335581e+08	11929	23753.53	5
2011	41	4	4124806	2.5081156e+08	10553	23766.85	5
2011	35	3	3531308	1.11411067e+09	46875	23767.69	5
2011	43	4	4313201	4.5715689e+08	19211	23796.62	5
2011	42	4	4213351	7.883336e+07	3310	23816.72	5
2011	41	4	4106704	1.0836823e+08	4548	23827.67	5
2011	41	4	4107801	1.1994772e+08	5032	23836.99	5
2011	52	5	5214002	3.2464682e+08	13575	23915.05	5
2011	31	3	3152808	6.2133268e+08	25973	23922.25	5
2011	17	1	1722107	2.7478517e+08	11471	23954.77	5
2011	43	4	4307500	3.6510374e+08	15241	23955.37	5
2011	15	1	1501303	2.46039752e+09	102668	23964.6	5
2011	43	4	4320503	1.4876672e+08	6205	23975.3	5
2011	35	3	3536406	1.5393442e+08	6419	23981.06	5
2011	51	5	5103908	1.2183079e+08	5080	23982.44	5
2011	42	4	4216107	2.277839e+08	9488	24007.58	5
2011	17	1	1703867	9.163185e+07	3815	24018.83	5
2011	35	3	3541406	5.02163552e+09	209025	24024.09	5
2011	50	5	5005103	9.629198e+07	4008	24024.94	5
2011	51	5	5103601	1.9615142e+08	8153	24058.8	5
2011	51	5	5101407	4.5831335e+08	19006	24114.14	5
2011	35	3	3526407	6.1495754e+08	25490	24125.44	5
2011	41	4	4121356	6.828068e+07	2827	24153.05	5
2011	42	4	4204509	3.3834305e+08	14006	24157.01	5
2011	51	5	5103403	1.344007506e+10	556299	24159.8	5
2011	41	4	4107538	9.596707e+07	3972	24160.89	5
2011	35	3	3508108	3.754469e+08	15539	24161.59	5
2011	43	4	4320305	1.1927824e+08	4935	24169.86	5
2011	24	2	2404101	5.377379e+07	2223	24189.74	5
2011	50	5	5003702	4.79996065e+09	198422	24190.67	5
2011	43	4	4314001	1.6677039e+08	6873	24264.57	5
2011	41	4	4122404	1.42118977e+09	58511	24289.27	5
2011	43	4	4305871	5.977255e+07	2460	24297.79	5
2011	42	4	4202537	6.228602e+07	2563	24302	5
2011	42	4	4211504	3.0070024e+08	12370	24308.83	5
2011	41	4	4114609	1.14986136e+09	47266	24327.45	5
2011	35	3	3549706	1.2660777e+09	52040	24328.93	5
2011	35	3	3505500	2.74281046e+09	112730	24330.79	5
2011	26	2	2611606	3.763087861e+10	1546516	24332.68	5
2011	41	4	4118501	1.78294775e+09	73148	24374.52	5
2011	31	3	3159803	4.4576155e+08	18275	24391.88	5
2011	35	3	3552809	6.05416605e+09	248127	24399.47	5
2011	35	3	3505203	7.7763198e+08	31852	24413.91	5
2011	24	2	2404408	2.3191113e+08	9481	24460.62	5
2011	41	4	4107553	8.403954e+07	3435	24465.66	5
2011	43	4	4314134	5.387059e+07	2201	24475.51	5
2011	42	4	4208104	4.9918561e+08	20395	24475.88	5
2011	35	3	3554003	2.65723883e+09	108393	24514.86	5
2011	41	4	4113700	1.253409406e+10	511279	24515.17	5
2011	42	4	4204608	4.75866558e+09	193989	24530.59	5
2011	35	3	3539301	1.73154811e+09	70482	24567.24	5
2011	52	5	5210109	6.1169508e+08	24897	24569.03	5
2011	43	4	4305850	6.001316e+07	2439	24605.64	5
2011	41	4	4103008	1.1134763e+08	4523	24618.09	5
2011	43	4	4305355	8.8059167e+08	35732	24644.34	5
2011	41	4	4127502	4.7865392e+08	19414	24655.09	5
2011	17	1	1703842	2.0554559e+08	8331	24672.38	5
2011	43	4	4315354	9.03411e+07	3659	24690.11	5
2011	35	3	3500550	1.3913235e+08	5630	24712.67	5
2011	35	3	3501202	9.590554e+07	3865	24813.85	5
2011	43	4	4309803	1.1671421e+08	4701	24827.53	5
2011	35	3	3556453	1.08753555e+09	43789	24835.82	5
2011	42	4	4214300	6.849891e+07	2757	24845.45	5
2011	31	3	3147006	2.12629219e+09	85448	24884.05	5
2011	43	4	4320909	4.8890025e+08	19640	24893.09	5
2011	52	5	5209101	8.1171682e+08	32597	24901.58	5
2011	50	5	5001003	5.6428588e+08	22621	24945.22	5
2011	26	2	2605459	6.673527e+07	2675	24947.76	5
2011	43	4	4323358	5.347176e+07	2143	24951.82	5
2011	52	5	5206206	1.18625698e+09	47537	24954.39	5
2011	42	4	4203006	1.78096742e+09	71334	24966.6	5
2011	35	3	3502002	1.0859811e+08	4348	24976.57	5
2011	43	4	4314100	4.65021868e+09	186083	24990.02	5
2011	42	4	4208005	1.5998105e+08	6401	24993.13	5
2011	33	3	3302700	3.2841462e+09	131355	25002.06	5
2011	50	5	5000252	1.1602835e+08	4638	25016.89	5
2011	31	3	3117306	5.8785041e+08	23495	25020.23	5
2011	41	4	4119905	7.87509724e+09	314518	25038.62	5
2011	33	3	3306008	1.95058633e+09	77851	25055.38	5
2011	43	4	4317202	1.72544357e+09	68862	25056.54	5
2011	35	3	3557154	5.927826e+07	2365	25064.8	5
2011	32	3	3203056	6.2889043e+08	25073	25082.38	5
2011	35	3	3510906	6.56973e+07	2616	25113.65	5
2011	52	5	5219258	1.2118256e+08	4815	25167.72	5
2011	29	2	2919207	4.21082586e+09	167309	25167.96	5
2011	52	5	5208707	3.318166425e+10	1318149	25172.92	5
2011	35	3	3535705	1.496847e+08	5934	25224.92	5
2011	42	4	4204251	3.8528524e+08	15269	25233.17	5
2011	35	3	3502804	4.61065145e+09	182526	25260.24	5
2011	43	4	4316477	6.750019e+07	2670	25280.97	5
2011	35	3	3507605	3.75201052e+09	148411	25281.22	5
2011	41	4	4125704	6.542469e+08	25872	25287.84	5
2011	41	4	4126355	1.1533464e+08	4555	25320.45	5
2011	35	3	3511102	2.87346427e+09	113356	25349.03	5
2011	42	4	4218608	1.6770497e+08	6612	25363.73	5
2011	29	2	2921906	2.623708e+08	10342	25369.45	5
2011	22	2	2201150	2.7280039e+08	10727	25431.19	5
2011	31	3	3119955	1.485024e+08	5837	25441.56	5
2011	42	4	4210605	3.7769905e+08	14837	25456.56	5
2011	51	5	5108857	7.588028e+07	2980	25463.18	5
2011	41	4	4118600	1.3930107e+08	5463	25499.01	5
2011	41	4	4120853	9.732231e+07	3816	25503.75	5
2011	15	1	1505304	1.63076527e+09	63905	25518.59	5
2011	35	3	3540705	1.31969745e+09	51705	25523.59	5
2011	35	3	3533908	1.28509312e+09	50332	25532.33	5
2011	35	3	3542107	2.2051621e+08	8632	25546.36	5
2011	29	2	2909307	8.0037518e+08	31324	25551.5	5
2011	35	3	3525201	6.2292313e+08	24370	25561.06	5
2011	11	1	1100205	1.113925499e+10	435732	25564.46	5
2011	51	5	5101902	4.0359123e+08	15783	25571.26	5
2011	50	5	5001904	5.1464325e+08	20119	25579.96	5
2011	17	1	1700707	2.1403073e+08	8364	25589.52	5
2011	24	2	2400703	3.2149828e+08	12521	25676.73	5
2011	42	4	4218301	4.6790949e+08	18207	25699.43	5
2011	43	4	4318606	1.7717444e+08	6893	25703.53	5
2011	41	4	4101606	6.6963692e+08	26007	25748.33	5
2011	31	3	3151206	1.38048255e+09	53604	25753.35	5
2011	31	3	3129509	6.0258208e+08	23385	25767.89	5
2011	35	3	3500600	7.142927e+07	2771	25777.44	5
2011	51	5	5102702	4.9026987e+08	19011	25788.75	5
2011	35	3	3524303	1.8575276e+09	71989	25802.94	5
2011	33	3	3301702	2.223712685e+10	861158	25822.35	5
2011	35	3	3507506	3.32875912e+09	128789	25846.61	5
2011	35	3	3525607	1.0790895e+08	4174	25852.65	5
2011	43	4	4313334	6.254167e+07	2416	25886.45	5
2011	43	4	4307054	7.997754e+07	3089	25891.08	5
2011	35	3	3530607	1.016635938e+10	392196	25921.63	5
2011	51	5	5105234	1.4237679e+08	5492	25924.4	5
2011	41	4	4115903	6.001109e+07	2314	25933.92	5
2011	43	4	4313409	6.20412443e+09	239151	25942.29	5
2011	35	3	3522703	1.04362374e+09	40228	25942.72	5
2011	35	3	3547601	6.2424514e+08	24049	25957.22	5
2011	43	4	4312757	8.349716e+07	3215	25971.12	5
2011	42	4	4219002	5.2761345e+08	20291	26002.34	5
2011	41	4	4109807	1.26594286e+09	48662	26015.02	5
2011	42	4	4207700	1.8865592e+08	7245	26039.46	5
2011	32	3	3202207	4.5157668e+08	17334	26051.5	5
2011	35	3	3545308	1.05576876e+09	40521	26054.85	5
2011	43	4	4323770	7.321558e+07	2807	26083.21	5
2011	33	3	3305406	4.5853225e+08	17554	26121.24	5
2011	43	4	4310207	2.06886468e+09	79160	26135.23	5
2011	35	3	3548054	2.0081816e+08	7680	26148.2	5
2011	41	4	4108304	6.69360375e+09	255900	26157.11	5
2011	43	4	4309001	4.4343971e+08	16947	26166.27	5
2011	43	4	4300034	1.1595917e+08	4430	26175.89	5
2011	43	4	4300208	1.8934342e+08	7221	26221.22	5
2011	52	5	5207402	2.9758071e+08	11347	26225.5	5
2011	42	4	4212106	4.2011937e+08	16019	26226.32	5
2011	35	3	3529708	5.4107488e+08	20561	26315.59	5
2011	35	3	3506003	9.10801138e+09	346077	26317.88	5
2011	52	5	5219712	1.1731251e+08	4452	26350.52	5
2011	42	4	4210902	1.0684515e+08	4054	26355.49	5
2011	42	4	4218004	8.3126721e+08	31533	26361.82	5
2011	41	4	4103222	8.665912e+07	3286	26372.22	5
2011	35	3	3519105	2.6765539e+08	10146	26380.39	5
2011	52	5	5220504	1.9950371e+08	7561	26385.89	5
2011	35	3	3546207	1.0671414e+08	4039	26420.93	5
2011	42	4	4216909	5.8033669e+08	21964	26422.18	5
2011	35	3	3510153	1.1728007e+08	4438	26426.33	5
2011	43	4	4320404	3.842566e+08	14511	26480.37	5
2011	24	2	2407203	7.735681e+08	29204	26488.43	5
2011	42	4	4205803	3.9788892e+08	15021	26488.84	5
2011	31	3	3171105	9.357224e+07	3530	26507.72	5
2011	42	4	4205175	8.035425e+07	3031	26510.8	5
2011	35	3	3506805	2.9078236e+08	10968	26511.89	5
2011	42	4	4208450	4.0361302e+08	15218	26522.08	5
2011	31	3	3168705	2.17855732e+09	81993	26570.04	5
2011	52	5	5201504	1.0190004e+08	3832	26591.87	5
2011	43	4	4319125	8.51438e+07	3198	26624.08	5
2011	42	4	4201307	6.9000431e+08	25860	26682.3	5
2011	42	4	4217501	4.5323646e+08	16971	26706.53	5
2011	42	4	4204103	1.1611071e+08	4346	26716.68	5
2011	31	3	3138625	1.8573271e+08	6946	26739.52	5
2011	42	4	4213005	8.51911e+07	3180	26789.65	5
2011	42	4	4204301	1.85124262e+09	69048	26810.95	5
2011	31	3	3111804	3.0631166e+08	11422	26817.69	5
2011	35	3	3510401	1.31800941e+09	49122	26831.35	5
2011	43	4	4311205	5.236868e+08	19515	26835.09	5
2011	35	3	3532868	3.050251e+07	1136	26850.8	5
2011	43	4	4314803	8.431781e+08	31401	26851.95	5
2011	43	4	4316733	4.435233e+07	1651	26863.92	5
2011	43	4	4311718	1.2676611e+08	4716	26880.01	5
2011	31	3	3136207	1.99310153e+09	74142	26882.22	5
2011	42	4	4204558	3.9340569e+08	14613	26921.62	5
2011	43	4	4311130	9.595183e+07	3562	26937.63	5
2011	31	3	3159605	1.03202792e+09	38253	26979.01	5
2011	35	3	3514908	4.2993051e+08	15920	27005.69	5
2011	31	3	3152501	3.58882555e+09	132445	27096.72	5
2011	26	2	2611002	8.9155684e+08	32889	27108.06	5
2011	42	4	4211207	4.4066741e+08	16247	27123	5
2011	42	4	4205902	1.59670472e+09	58869	27123.01	5
2011	31	3	3170107	8.12574053e+09	299361	27143.62	5
2011	43	4	4308078	1.0221478e+08	3764	27155.89	5
2011	41	4	4113601	1.2029141e+08	4427	27172.22	5
2011	35	3	3549805	1.120053824e+10	412076	27180.76	5
2011	35	3	3516101	7.632652e+07	2807	27191.49	5
2011	41	4	4103370	8.588622e+07	3157	27205.01	5
2011	41	4	4115200	9.86106585e+09	362329	27215.78	5
2011	35	3	3552502	7.21954008e+09	265074	27235.94	5
2011	41	4	4128708	1.7824032e+08	6531	27291.43	5
2011	41	4	4105300	3.0246601e+08	11078	27303.3	5
2011	43	4	4310801	5.5259997e+08	20224	27323.97	5
2011	43	4	4321006	2.8549231e+08	10440	27346.01	5
2011	43	4	4315602	5.41742173e+09	198049	27353.95	5
2011	43	4	4312138	6.762492e+07	2472	27356.36	5
2011	43	4	4307708	2.21174782e+09	80810	27369.73	5
2011	42	4	4205605	9.348675e+07	3414	27383.35	5
2011	35	3	3518404	3.09555763e+09	112675	27473.33	5
2011	42	4	4211850	6.222838e+07	2265	27473.9	5
2011	42	4	4217758	7.531132e+07	2740	27485.88	5
2011	52	5	5204300	3.7089433e+08	13491	27491.98	5
2011	43	4	4305306	2.5711676e+08	9349	27502.06	5
2011	42	4	4202008	3.04618737e+09	110748	27505.57	5
2011	52	5	5208152	9.154387e+07	3328	27507.17	5
2011	35	3	3539103	4.3997592e+08	15990	27515.69	5
2011	17	1	1716505	3.2305037e+08	11732	27535.83	5
2011	51	5	5106372	4.3882003e+08	15920	27564.07	5
2011	31	3	3156908	6.6498382e+08	24093	27600.71	5
2011	41	4	4121802	2.9432253e+08	10661	27607.4	5
2011	31	3	3151800	4.25212711e+09	153726	27660.43	5
2011	50	5	5000856	2.5807251e+08	9326	27672.37	5
2011	52	5	5211503	2.59479352e+09	93763	27673.96	5
2011	41	4	4127106	1.9529926e+09	70535	27688.28	5
2011	51	5	5107602	5.51045859e+09	198950	27697.71	5
2011	35	3	3552551	9.516855e+07	3429	27754.02	5
2011	31	3	3116902	8.278479e+07	2982	27761.5	5
2011	22	2	2211209	5.6624036e+08	20390	27770.49	5
2011	35	3	3536109	1.5690052e+08	5648	27779.84	5
2011	35	3	3531902	8.1678786e+08	29400	27781.9	5
2011	31	3	3106200	6.631519175e+10	2385640	27797.65	5
2011	51	5	5106182	1.5411049e+08	5544	27797.71	5
2011	43	4	4304903	2.4104169e+08	8668	27808.22	5
2011	42	4	4219507	1.24207479e+09	44643	27822.39	5
2011	42	4	4211454	1.1936406e+08	4268	27967.21	5
2011	43	4	4313375	6.5045363e+08	23251	27975.3	5
2011	42	4	4217204	1.02474896e+09	36612	27989.43	5
2011	25	2	2503209	1.65603183e+09	59104	28018.95	5
2011	43	4	4316436	7.977683e+07	2844	28050.93	5
2011	50	5	5001243	2.9246746e+08	10420	28067.89	5
2011	31	3	3150307	1.3160536e+08	4682	28108.79	5
2011	17	1	1708254	6.868874e+07	2433	28232.12	5
2011	41	4	4119301	8.5749796e+08	30347	28256.43	5
2011	43	4	4311627	1.4947849e+08	5290	28256.8	5
2011	15	1	1508100	2.79947477e+09	98919	28300.68	5
2011	51	5	5108501	2.9264076e+08	10326	28340.19	5
2011	35	3	3503901	2.15889459e+09	76112	28364.71	5
2011	42	4	4208955	4.963169e+07	1749	28377.18	5
2011	43	4	4322608	1.88189483e+09	66308	28381.11	5
2011	42	4	4216602	6.04304457e+09	212587	28426.22	5
2011	29	2	2930709	3.40493597e+09	119760	28431.33	5
2011	42	4	4204202	5.320638e+09	186337	28553.85	5
2011	31	3	3170701	3.54754163e+09	124162	28571.88	5
2011	43	4	4304671	1.1308847e+08	3951	28622.75	5
2011	35	3	3513702	8.936034e+08	31220	28622.79	5
2011	42	4	4207502	1.60894832e+09	55980	28741.48	5
2011	43	4	4315321	7.798239e+07	2712	28754.57	5
2011	35	3	3534302	1.15230359e+09	40071	28756.55	5
2011	35	3	3526803	1.78334809e+09	61919	28801.31	5
2011	41	4	4111902	3.5504899e+08	12325	28807.22	5
2011	35	3	3522901	3.5471349e+08	12312	28810.39	5
2011	35	3	3520400	8.2956734e+08	28761	28843.48	5
2011	35	3	3520301	8.3502826e+08	28950	28843.81	5
2011	43	4	4306106	1.80205402e+09	62474	28844.86	5
2011	42	4	4214805	1.78731889e+09	61931	28859.84	5
2011	43	4	4305405	1.1583094e+08	4011	28878.32	5
2011	42	4	4203956	6.3408791e+08	21913	28936.61	5
2011	50	5	5002407	7.575256e+08	26156	28961.83	5
2011	35	3	3530706	4.00520794e+09	138245	28971.81	5
2011	35	3	3503208	6.11656009e+09	210673	29033.43	5
2011	35	3	3522505	5.9163118e+09	203712	29042.53	5
2011	51	5	5105903	4.3593464e+08	15003	29056.5	5
2011	52	5	5211909	2.5919115e+09	88970	29132.42	5
2011	43	4	4303905	1.76406119e+09	60539	29139.25	5
2011	35	3	3544004	8.734478e+08	29963	29150.88	5
2011	31	3	3155504	3.4768849e+08	11913	29185.64	5
2011	31	3	3128709	1.44870171e+09	49614	29199.45	5
2011	43	4	4321451	8.1058519e+08	27743	29217.65	5
2011	29	2	2906501	2.44508303e+09	83648	29230.62	5
2011	42	4	4217907	2.5341668e+08	8668	29235.89	5
2011	33	3	3300225	3.3802379e+08	11540	29291.49	5
2011	43	4	4316501	2.0002035e+08	6827	29298.42	5
2011	43	4	4307005	2.83844258e+09	96757	29335.79	5
2011	41	4	4101507	3.10009318e+09	105588	29360.28	5
2011	24	2	2401107	7.4998485e+08	25529	29377.76	5
2011	41	4	4125308	1.6220064e+08	5512	29426.82	5
2011	43	4	4313011	8.066626e+07	2741	29429.5	5
2011	26	2	2602902	5.51810064e+09	187159	29483.49	5
2011	35	3	3517406	1.10959968e+09	37619	29495.73	5
2011	29	2	2908507	8.980178e+08	30425	29515.79	5
2011	41	4	4122701	1.8160949e+08	6149	29534.8	5
2011	42	4	4200408	2.0625345e+08	6971	29587.36	5
2011	31	3	3167202	6.40375248e+09	216400	29592.2	5
2011	35	3	3532009	3.5252401e+08	11912	29594.02	5
2011	29	2	2915205	4.4608879e+08	15053	29634.54	5
2011	42	4	4212056	7.102739e+07	2392	29693.72	5
2011	31	3	3121258	2.4727034e+08	8322	29712.85	5
2011	42	4	4211751	4.9091542e+08	16517	29721.83	5
2011	35	3	3508207	1.2158726e+08	4083	29778.9	5
2011	42	4	4205407	1.273161847e+10	427298	29795.64	5
2011	43	4	4323309	9.59801e+07	3217	29835.28	5
2011	35	3	3521101	1.8340946e+08	6145	29846.94	5
2011	31	3	3146503	2.3974667e+08	8031	29852.65	5
2011	43	4	4311270	4.784939e+07	1596	29980.82	5
2011	42	4	4215802	2.26501717e+09	75520	29992.28	5
2011	35	3	3513801	1.166327391e+10	388576	30015.43	5
2011	29	2	2916302	3.1368417e+08	10446	30029.12	5
2011	43	4	4321709	7.2744052e+08	24188	30074.44	5
2011	31	3	3128600	1.9733091e+08	6559	30085.52	5
2011	35	3	3540903	5.3331638e+08	17720	30096.86	5
2011	13	1	1302603	5.552864011e+10	1832424	30303.38	5
2011	42	4	4210001	3.2216765e+08	10628	30313.1	5
2011	43	4	4319158	2.2519601e+08	7429	30313.1	5
2011	35	3	3538006	4.5143862e+09	148605	30378.43	5
2011	52	5	5218805	5.50393098e+09	181020	30405.1	5
2011	51	5	5103858	1.9531757e+08	6423	30409.09	5
2011	51	5	5100409	3.195932e+08	10505	30422.96	5
2011	43	4	4317756	6.045614e+07	1986	30441.16	5
2011	31	3	3104007	2.88710299e+09	94799	30454.99	5
2011	35	3	3502200	6.8404549e+08	22434	30491.46	5
2011	42	4	4202107	6.9869556e+08	22913	30493.41	5
2011	43	4	4312153	1.1951771e+08	3916	30520.35	5
2011	31	3	3140803	4.1267049e+08	13521	30520.71	5
2011	35	3	3529500	1.4374387e+08	4708	30531.83	5
2011	50	5	5006002	5.1710877e+08	16930	30543.93	5
2011	42	4	4218855	8.791081e+07	2874	30588.31	5
2011	43	4	4300059	1.1369935e+08	3717	30589.01	5
2011	51	5	5106802	1.6623149e+08	5433	30596.63	5
2011	35	3	3503307	3.6710079e+09	119968	30599.89	5
2011	43	4	4307401	9.707369e+07	3172	30603.31	5
2011	41	4	4122206	9.4113174e+08	30751	30604.91	5
2011	35	3	3504305	1.5277213e+08	4987	30634.07	5
2011	42	4	4211256	8.869878e+07	2888	30712.87	5
2011	42	4	4217550	1.0081421e+08	3282	30717.31	5
2011	43	4	4323200	9.282815e+07	3017	30768.36	5
2011	43	4	4305603	1.0809194e+08	3510	30795.42	5
2011	43	4	4312385	8.177903e+07	2653	30825.11	5
2011	43	4	4322202	6.9041892e+08	22384	30844.3	5
2011	42	4	4208401	4.7970967e+08	15518	30913.11	5
2011	29	2	2917359	2.7359012e+08	8849	30917.63	5
2011	43	4	4310009	5.9879711e+08	19364	30923.21	5
2011	41	4	4120002	4.3507057e+08	14060	30943.85	5
2011	35	3	3543253	2.3000585e+08	7425	30977.22	5
2011	43	4	4309209	7.98445199e+09	257428	31016.25	5
2011	35	3	3526902	8.63036868e+09	278093	31034.11	5
2011	43	4	4310462	6.021943e+07	1936	31105.08	5
2011	42	4	4219309	1.48194621e+09	47618	31121.55	5
2011	32	3	3203205	4.46731729e+09	143509	31129.18	5
2011	35	3	3512902	2.2421944e+08	7202	31132.94	5
2011	35	3	3505302	1.09778382e+09	35228	31162.25	5
2011	41	4	4126405	1.7977903e+08	5763	31195.39	5
2011	42	4	4211702	6.7118771e+08	21498	31220.94	5
2011	28	2	2803609	8.4878542e+08	27177	31231.76	5
2011	35	3	3556909	2.2051848e+08	7050	31279.22	5
2011	50	5	5007695	7.0747126e+08	22617	31280.51	5
2011	35	3	3502101	1.7314884e+09	55348	31283.67	5
2011	43	4	4305207	4.1739063e+08	13337	31295.69	5
2011	31	3	3170438	1.3781076e+08	4402	31306.4	5
2011	33	3	3303906	9.28790289e+09	296565	31318.27	5
2011	33	3	3303302	1.534608901e+10	489720	31336.46	5
2011	35	3	3529302	2.41971005e+09	77173	31354.36	5
2011	43	4	4301958	7.474578e+07	2378	31432.2	5
2011	43	4	4307906	2.02120545e+09	64275	31446.21	5
2011	43	4	4309100	1.02397855e+09	32556	31452.84	5
2011	43	4	4305702	2.0671408e+08	6557	31525.71	5
2011	29	2	2922003	1.15651581e+09	36638	31566.02	5
2011	35	3	3522604	2.17723174e+09	68934	31584.29	5
2011	42	4	4218202	1.17996009e+09	37344	31597.05	5
2011	52	5	5205307	2.9738492e+08	9411	31599.71	5
2011	42	4	4201257	3.0613539e+08	9683	31615.76	5
2011	35	3	3518800	3.90826239e+10	1233436	31685.98	5
2011	43	4	4311155	2.6423988e+08	8335	31702.45	5
2011	41	4	4118907	3.26135e+08	10280	31725.19	5
2011	43	4	4306429	6.813637e+07	2142	31809.7	5
2011	43	4	4323408	1.3459901e+08	4225	31857.75	5
2011	41	4	4115358	1.8061901e+08	5669	31860.82	5
2011	43	4	4308201	8.7296709e+08	27391	31870.58	5
2011	43	4	4313508	1.3159435e+09	41273	31883.88	5
2011	35	3	3539608	1.4436478e+08	4524	31910.87	5
2011	42	4	4206306	6.0184186e+08	18849	31929.64	5
2011	35	3	3515202	2.6208084e+08	8205	31941.6	5
2011	43	4	4313904	1.22928972e+09	38477	31948.69	5
2011	31	3	3170206	1.955321005e+10	611904	31954.7	5
2011	43	4	4313300	7.4182065e+08	23175	32009.52	5
2011	35	3	3547809	2.174084894e+10	678486	32043.18	5
2011	35	3	3529609	1.2338606e+08	3842	32115.06	5
2011	42	4	4206504	1.15352674e+09	35918	32115.56	5
2011	35	3	3509254	9.126643e+08	28307	32241.65	5
2011	41	4	4120903	9.9504613e+08	30854	32250.15	5
2011	42	4	4211603	4.35542e+08	13448	32387.12	5
2011	43	4	4312674	5.557709e+07	1715	32406.46	5
2011	35	3	3528403	1.40967315e+09	43473	32426.41	5
2011	35	3	3534005	1.2726571e+08	3921	32457.46	5
2011	35	3	3506359	1.59105252e+09	48997	32472.45	5
2011	41	4	4117909	9.3938005e+08	28907	32496.63	5
2011	51	5	5103452	2.7973628e+08	8605	32508.57	5
2011	43	4	4304606	1.060553545e+10	325189	32613.45	5
2011	42	4	4213153	8.708384e+07	2670	32615.67	5
2011	43	4	4322806	7.5303165e+08	23067	32645.41	5
2011	41	4	4107108	1.7893752e+08	5472	32700.57	5
2011	51	5	5100300	5.225745e+08	15969	32724.31	5
2011	43	4	4311403	2.36784855e+09	72338	32733.12	5
2011	43	4	4308458	1.4883135e+08	4544	32753.38	5
2011	35	3	3512001	5.7150796e+08	17426	32796.28	5
2011	35	3	3543402	2.012779869e+10	612340	32870.3	5
2011	50	5	5007208	1.02987303e+09	31279	32925.38	5
2011	42	4	4211405	1.429191e+08	4332	32991.48	5
2011	43	4	4309308	3.14456209e+09	95273	33005.81	5
2011	43	4	4307807	1.01893853e+09	30867	33010.61	5
2011	43	4	4312401	1.97458548e+09	59812	33013.2	5
2011	22	2	2200806	1.0083438e+08	3054	33017.15	5
2011	42	4	4210506	7.3963041e+08	22376	33054.63	5
2011	41	4	4119152	3.91301254e+09	118334	33067.53	5
2011	42	4	4207577	9.115564e+07	2754	33099.36	5
2011	31	3	3118601	2.022091302e+10	608715	33219.02	5
2011	43	4	4316972	7.873928e+07	2366	33279.49	5
2011	35	3	3548906	7.46465978e+09	224173	33298.66	5
2011	43	4	4315313	5.930671e+07	1777	33374.63	5
2011	42	4	4211009	3.4581284e+08	10347	33421.56	5
2011	42	4	4205308	3.5604084e+08	10653	33421.65	5
2011	35	3	3511508	1.35018345e+09	40393	33426.17	5
2011	35	3	3527108	2.40705241e+09	71853	33499.68	5
2011	35	3	3504107	4.28547574e+09	127778	33538.45	5
2011	51	5	5108907	2.2800169e+08	6793	33564.21	5
2011	31	3	3130309	2.6924014e+08	8011	33608.81	5
2011	31	3	3131307	8.13146022e+09	241539	33665.21	5
2011	42	4	4202909	3.62816423e+09	107764	33667.68	5
2011	31	3	3151107	3.4987693e+08	10390	33674.39	5
2011	17	1	1712157	5.519693e+07	1636	33738.96	5
2011	52	5	5216403	3.6720025e+08	10866	33793.51	5
2011	31	3	3169356	9.7093268e+08	28683	33850.46	5
2011	23	2	2304285	1.59508824e+09	47030	33916.4	5
2011	32	3	3205002	1.413890691e+10	416029	33985.39	5
2011	35	3	3528809	4.5460259e+08	13358	34032.23	5
2011	50	5	5005400	1.30272827e+09	38264	34045.79	5
2011	42	4	4202578	7.259166e+07	2131	34064.6	5
2011	41	4	4124509	1.7975072e+08	5276	34069.51	5
2011	33	3	3301108	6.7683745e+08	19830	34131.99	5
2011	43	4	4314902	4.828817102e+10	1413094	34171.95	5
2011	41	4	4118204	4.84281051e+09	141477	34230.37	5
2011	52	5	5205901	2.8483031e+08	8299	34321.04	5
2011	42	4	4201208	2.5868822e+08	7537	34322.44	5
2011	35	3	3524402	7.32353993e+09	212744	34424.19	5
2011	43	4	4316451	4.1090695e+08	11907	34509.7	5
2011	35	3	3536307	4.5285849e+08	13122	34511.39	5
2011	29	2	2925204	1.16041832e+09	33595	34541.4	5
2011	43	4	4314779	1.3329187e+08	3854	34585.33	5
2011	35	3	3543907	6.5134015e+09	187638	34712.59	5
2011	52	5	5201108	1.175314428e+10	338545	34716.64	5
2011	35	3	3551702	3.89351848e+09	111257	34995.72	5
2011	43	4	4300661	4.283707e+07	1224	34997.61	5
2011	31	3	3156403	1.2564342e+08	3586	35037.21	5
2011	35	3	3512100	2.1022187e+08	5998	35048.66	5
2011	17	1	1712702	7.963576e+07	2268	35112.77	5
2011	31	3	3149804	5.1160776e+08	14561	35135.48	5
2011	35	3	3530805	3.05822154e+09	86892	35195.66	5
2011	35	3	3533403	1.82887812e+09	51946	35207.29	5
2011	43	4	4304358	3.1079125e+08	8826	35213.15	5
2011	35	3	3536703	1.47479977e+09	41872	35221.62	5
2011	42	4	4217006	3.956828e+08	11178	35398.35	5
2011	35	3	3532827	3.047952e+08	8609	35404.25	5
2011	42	4	4202404	1.10829825e+10	312635	35450.23	5
2011	31	3	3164605	2.0903948e+08	5894	35466.49	5
2011	43	4	4310108	1.14001364e+09	32036	35585.39	5
2011	51	5	5107248	1.4679458e+08	4123	35603.83	5
2011	43	4	4300471	7.319682e+07	2054	35636.23	5
2011	42	4	4209102	1.867510299e+10	520905	35851.26	5
2011	31	3	3136652	8.1296002e+08	22649	35893.86	5
2011	31	3	3111408	2.5165311e+08	6989	36007.03	5
2011	35	3	3523909	5.60364599e+09	155589	36015.7	5
2011	35	3	3532207	1.5610448e+08	4330	36051.84	5
2011	43	4	4314308	1.4272495e+08	3957	36068.98	5
2011	29	2	2910057	2.45673303e+09	68061	36096.05	5
2011	33	3	3304557	2.2956779888e+11	6355949	36118.57	5
2011	43	4	4302105	3.92784533e+09	108481	36207.68	5
2011	31	3	3105400	1.04637064e+09	28830	36294.51	5
2011	51	5	5106281	2.1618337e+08	5924	36492.8	5
2011	43	4	4308607	1.13243408e+09	31014	36513.64	5
2011	42	4	4213500	6.0412241e+08	16496	36622.36	5
2011	43	4	4308854	6.143955e+07	1670	36790.15	5
2011	35	3	3545209	3.917572e+09	106465	36796.81	5
2011	31	3	3157708	4.2664456e+08	11588	36817.79	5
2011	35	3	3548500	1.544774579e+10	419509	36823.4	5
2011	31	3	3151602	3.8835299e+08	10545	36828.16	5
2011	35	3	3523404	3.79600252e+09	103028	36844.38	5
2011	43	4	4306403	1.03362667e+09	27967	36958.8	5
2011	31	3	3156304	2.5829864e+08	6982	36994.94	5
2011	35	3	3508504	3.1682982e+09	85414	37093.43	5
2011	42	4	4210555	8.04981e+07	2169	37113	5
2011	35	3	3507001	1.83965906e+09	49385	37251.37	5
2011	33	3	3306305	9.66411896e+09	259012	37311.47	5
2011	42	4	4218509	2.4104751e+08	6457	37331.19	5
2011	41	4	4106902	6.592488346e+10	1764541	37360.92	5
2011	51	5	5102678	1.22178724e+09	32692	37372.67	5
2011	50	5	5003256	7.5399072e+08	20027	37648.71	5
2011	35	3	3528858	1.003018e+08	2664	37650.83	5
2011	35	3	3519055	4.3934956e+08	11613	37832.56	5
2011	43	4	4311809	1.4006523e+09	36979	37876.97	5
2011	52	5	5213087	1.17624186e+09	30966	37984.95	5
2011	43	4	4302238	9.259863e+07	2436	38012.57	5
2011	43	4	4301008	7.2125921e+08	18924	38113.46	5
2011	31	3	3117603	1.9828263e+08	5187	38226.84	5
2011	43	4	4312807	1.5576375e+08	4060	38365.46	5
2011	29	2	2919553	2.4338023e+09	63290	38454.77	5
2011	43	4	4313060	7.1547592e+08	18598	38470.58	5
2011	52	5	5218102	1.4818108e+08	3850	38488.59	5
2011	52	5	5204805	2.3796215e+08	6178	38517.67	5
2011	35	3	3552205	2.298502844e+10	593776	38709.93	5
2011	28	2	2803302	6.6206365e+08	17042	38848.94	5
2011	42	4	4211876	6.76366e+07	1741	38849.28	5
2011	35	3	3513009	7.97133156e+09	205154	38855.36	5
2011	43	4	4316709	3.4028107e+08	8738	38942.67	5
2011	35	3	3554508	1.4503569e+09	37229	38957.72	5
2011	42	4	4209003	1.06507886e+09	27247	39089.77	5
2011	35	3	3552403	9.50770877e+09	242960	39132.82	5
2011	33	3	3300100	6.78669196e+09	173370	39145.71	5
2011	41	4	4119103	4.4610624e+08	11347	39314.91	5
2011	31	3	3133758	5.9230282e+08	15042	39376.6	5
2011	51	5	5108006	4.2224582e+08	10723	39377.58	5
2011	35	3	3520509	8.13687112e+09	205808	39536.22	5
2011	43	4	4302154	8.344248e+07	2109	39564.95	5
2011	51	5	5107156	1.0246923e+08	2584	39655.27	5
2011	35	3	3539806	4.23531216e+09	106797	39657.59	5
2011	42	4	4202859	1.3793711e+08	3478	39659.89	5
2011	51	5	5105259	1.88740266e+09	47571	39675.49	5
2011	42	4	4200101	6.8066245e+08	17151	39686.46	5
2011	43	4	4303103	4.74810461e+09	119101	39866.2	5
2011	33	3	3304003	1.06317921e+09	26637	39913.62	5
2011	35	3	3549904	2.551874036e+10	636876	40068.62	5
2011	35	3	3556206	4.35662094e+09	108622	40108.09	5
2011	35	3	3538709	1.473211062e+10	367290	40110.3	5
2011	51	5	5107925	2.76649485e+09	68894	40155.82	5
2011	42	4	4218350	1.4304119e+08	3557	40214	5
2011	43	4	4312609	1.9347455e+08	4796	40340.82	5
2011	33	3	3303807	1.54061159e+09	38147	40386.18	5
2011	35	3	3501608	8.61651041e+09	212791	40492.83	5
2011	51	5	5107040	2.15380478e+09	53004	40634.76	5
2011	43	4	4310363	1.2299258e+08	3026	40645.27	5
2011	43	4	4316808	4.84531658e+09	119199	40648.97	5
2011	35	3	3506201	1.0989364e+08	2696	40761.74	5
2011	41	4	4102307	4.6621363e+08	11422	40817.16	5
2011	35	3	3509502	4.461374767e+10	1090386	40915.55	5
2011	43	4	4305975	1.1583444e+08	2815	41149	5
2011	41	4	4104659	8.026599e+08	19494	41174.72	5
2011	35	3	3540002	8.3398065e+08	20102	41487.45	5
2011	35	3	3524907	2.2660235e+08	5454	41547.92	5
2011	31	3	3150703	1.9962852e+08	4803	41563.3	5
2011	43	4	4307831	1.1488683e+08	2759	41640.75	5
2011	31	3	3129707	5.1371564e+08	12326	41677.4	5
2011	31	3	3106309	9.9531149e+08	23695	42005.13	5
2011	42	4	4212908	7.0205803e+08	16638	42196.06	5
2011	31	3	3155702	5.9761514e+08	14150	42234.29	5
2011	42	4	4213203	1.1910737e+09	28192	42248.64	5
2011	51	5	5107065	5.7053223e+08	13476	42336.91	5
2011	41	4	4107256	3.1967199e+08	7544	42374.34	5
2011	17	1	1716604	4.4536076e+08	10509	42378.99	5
2011	50	5	5008305	4.39183194e+09	103536	42418.4	5
2011	43	4	4305108	1.880036623e+10	441332	42599.15	5
2011	42	4	4209201	9.381963e+07	2201	42625.91	5
2011	42	4	4203600	1.41261145e+09	33073	42711.92	5
2011	13	1	1301209	3.28412986e+09	76646	42848.03	5
2011	50	5	5005251	2.8135094e+08	6565	42856.2	5
2011	35	3	3507308	1.850779e+08	4309	42951.47	5
2011	35	3	3501905	2.86009061e+09	66246	43173.79	5
2011	42	4	4215406	1.8712894e+08	4332	43196.89	5
2011	31	3	3145000	5.6682954e+08	13067	43378.71	5
2011	33	3	3304508	3.7473945e+08	8633	43407.79	5
2011	43	4	4309050	3.0470193e+08	6984	43628.57	5
2011	35	3	3507753	1.1440817e+08	2594	44104.92	5
2011	35	3	3550308	5.019644213e+11	11316119	44358.35	5
2011	42	4	4208906	6.54682863e+09	145782	44908.35	5
2011	35	3	3508405	1.90840342e+09	42257	45161.83	5
2011	43	4	4304804	1.15578267e+09	25551	45234.34	5
2011	43	4	4304622	7.893406e+07	1742	45312.32	5
2011	52	5	5218052	1.5391265e+08	3388	45428.76	5
2011	41	4	4120804	9.1765045e+08	20135	45574.89	5
2011	35	3	3541604	1.65564359e+09	36025	45958.18	5
2011	52	5	5215504	2.5748212e+08	5559	46318.07	5
2011	29	2	2911105	1.06008358e+09	22854	46385.03	5
2011	41	4	4114401	7.8854757e+08	16994	46401.53	5
2011	35	3	3531803	2.3129686e+09	49841	46406.95	5
2011	35	3	3544251	8.9939911e+08	19343	46497.4	5
2011	35	3	3519071	9.108279e+09	195776	46523.98	5
2011	35	3	3554102	1.312585889e+10	281336	46655.45	5
2011	42	4	4206652	2.1833657e+08	4678	46673.06	5
2011	50	5	5002951	9.4942537e+08	20262	46857.44	5
2011	41	4	4103453	7.0135255e+08	14933	46966.62	5
2011	33	3	3302007	5.22160542e+09	111171	46969.13	5
2011	41	4	4110409	2.0249867e+08	4306	47027.09	5
2011	43	4	4312658	7.5562635e+08	16053	47070.72	5
2011	52	5	5213756	5.0823752e+08	10790	47102.64	5
2011	35	3	3541802	1.3505679e+08	2857	47272.24	5
2011	31	3	3131703	5.25301652e+09	110663	47468.59	5
2011	35	3	3537008	7.4890611e+08	15755	47534.5	5
2011	35	3	3518305	1.24769002e+09	26147	47718.29	5
2011	29	2	2905701	1.196689039e+10	249206	48020.07	5
2011	43	4	4304655	1.5176724e+08	3147	48226	5
2011	35	3	3524501	2.7916046e+08	5776	48331.1	5
2011	42	4	4214201	4.9351878e+08	10211	48332.07	5
2011	35	3	3534203	2.8090796e+08	5792	48499.3	5
2011	35	3	3546702	1.07995208e+09	22074	48924.17	5
2011	51	5	5102637	1.38656523e+09	28340	48926.08	5
2011	35	3	3553955	6.3889806e+08	13050	48957.71	5
2011	43	4	4302220	1.2010919e+08	2439	49245.26	5
2011	43	4	4314423	2.590317e+08	5222	49603.92	5
2011	33	3	3304201	6.02000604e+09	120938	49777.62	5
2011	42	4	4204707	5.3115937e+08	10643	49906.92	5
2011	35	3	3500709	1.74262742e+09	34681	50247.32	5
2011	43	4	4322251	2.032787e+08	3999	50832.38	5
2011	35	3	3540309	1.2866447e+08	2517	51118.18	5
2011	41	4	4104600	7.6871029e+08	15016	51192.75	5
2011	35	3	3533601	3.5145725e+08	6856	51262.73	5
2011	35	3	3547304	5.73469162e+09	111422	51468.22	5
2011	33	3	3302601	1.92508805e+09	37343	51551.51	5
2011	42	4	4219176	2.4640221e+08	4765	51710.85	5
2011	51	5	5106224	1.71103262e+09	33034	51796.11	5
2011	31	3	3134400	1.80856025e+09	34890	51836.06	5
2011	28	2	2801504	7.1740085e+08	13822	51902.83	5
2011	51	5	5106240	4.9429578e+08	9492	52074.99	5
2011	51	5	5103502	1.06626202e+09	20475	52076.29	5
2011	29	2	2928901	1.48718122e+09	28301	52548.72	5
2011	35	3	3524006	2.46066583e+09	46294	53153.02	5
2011	24	2	2410256	2.8233054e+08	5306	53209.68	5
2011	42	4	4204350	2.0325254e+08	3819	53221.4	5
2011	52	5	5218789	1.8208831e+08	3406	53461.04	5
2011	28	2	2802007	2.3608354e+08	4408	53557.97	5
2011	35	3	3555356	2.8849034e+08	5372	53702.6	5
2011	28	2	2806107	5.0443938e+08	9384	53755.26	5
2011	31	3	3131901	2.51115883e+09	46029	54556.02	5
2011	35	3	3507209	4.429487e+07	806	54956.42	5
2011	43	4	4309605	1.02168342e+09	18398	55532.31	5
2011	31	3	3118007	2.75514985e+09	49077	56139.33	5
2011	35	3	3550704	4.23989433e+09	75163	56409.33	5
2011	35	3	3503703	4.8909891e+08	8630	56674.26	5
2011	31	3	3106705	2.18357664e+10	383571	56927.57	5
2011	50	5	5002308	6.7482733e+08	11817	57106.49	5
2011	31	3	3100708	1.1601742e+08	2020	57434.37	5
2011	51	5	5100607	4.8087502e+08	8349	57596.72	5
2011	52	5	5221551	2.6386881e+08	4467	59070.7	5
2011	53	5	5300108	1.5456895396e+11	2609998	59221.87	5
2011	52	5	5205109	5.23554777e+09	88354	59256.49	5
2011	33	3	3300936	8.1208543e+08	13697	59289.29	5
2011	51	5	5104526	3.2125829e+08	5382	59691.25	5
2011	31	3	3124807	4.4749653e+08	7490	59745.87	5
2011	35	3	3548708	4.649038944e+10	770253	60357.3	5
2011	43	4	4312906	5.3915994e+08	8918	60457.5	5
2011	41	4	4101804	7.33963183e+09	121032	60642.08	5
2011	32	3	3203320	2.10423836e+09	34412	61148.39	5
2011	42	4	4216206	2.65656875e+09	43305	61345.54	5
2011	35	3	3513504	7.34460884e+09	119520	61450.88	5
2011	35	3	3551306	1.9042519e+08	3069	62047.96	5
2011	52	5	5205455	4.8071632e+08	7625	63044.76	5
2011	31	3	3109006	2.19447174e+09	34538	63537.89	5
2011	32	3	3200607	5.29368493e+09	83152	63662.75	5
2011	52	5	5204250	5.2769129e+08	8234	64086.87	5
2011	28	2	2801207	1.62207147e+09	25219	64319.42	5
2011	51	5	5107875	1.22604268e+09	18880	64938.7	5
2011	51	5	5107792	2.5349449e+08	3898	65031.94	5
2011	35	3	3512407	1.39156689e+09	21348	65184.88	5
2011	42	4	4208203	1.217889431e+10	186127	65433.25	5
2011	33	3	3300704	1.261272061e+10	190787	66108.91	5
2011	21	2	2112001	5.2946057e+08	7904	66986.41	5
2011	33	3	3302254	1.98305119e+09	29094	68160.14	5
2011	35	3	3502754	1.19747708e+09	17535	68290.68	5
2011	33	3	3302403	1.456589522e+10	212433	68567.01	5
2011	43	4	4314472	3.0580353e+08	4452	68689.02	5
2011	35	3	3509908	8.4120343e+08	12221	68832.62	5
2011	51	5	5104609	8.0710279e+08	11653	69261.37	5
2011	31	3	3127008	1.01347079e+09	14427	70248.2	5
2011	31	3	3145901	2.50661487e+09	35643	70325.59	5
2011	26	2	2607208	5.79187528e+09	82277	70394.83	5
2011	31	3	3130408	4.1721967e+08	5921	70464.39	5
2011	35	3	3525904	2.657186509e+10	373713	71102.33	5
2011	35	3	3534401	4.761455445e+10	667826	71297.84	5
2011	43	4	4312617	2.1411667e+08	2998	71419.84	5
2011	35	3	3545506	2.7135611e+08	3746	72438.9	5
2011	42	4	4219101	2.5759678e+08	3533	72911.63	5
2011	29	2	2929206	2.4909748e+09	33713	73887.66	5
2011	32	3	3205309	2.445422536e+10	330526	73985.78	5
2011	35	3	3527603	8.7805968e+08	11603	75675.23	5
2011	52	5	5216452	2.2565033e+08	2963	76156.03	5
2011	41	4	4125506	2.070946378e+10	268808	77041.84	5
2011	31	3	3146107	5.48515996e+09	70589	77705.59	5
2011	31	3	3168101	3.2807222e+08	4173	78617.83	5
2011	31	3	3115359	3.8795386e+08	4893	79287.53	5
2011	31	3	3130705	4.9606339e+08	6252	79344.75	5
2011	35	3	3556701	5.18933779e+09	64870	79995.96	5
2011	52	5	5220405	1.39704519e+09	17360	80474.95	5
2011	31	3	3126307	3.3570987e+08	4125	81384.21	5
2011	31	3	3125101	2.38709516e+09	29319	81418.03	5
2011	33	3	3301306	3.06881156e+09	36360	84400.76	5
2011	31	3	3144805	6.98981015e+09	82273	84958.74	5
2011	33	3	3300233	2.43988821e+09	28279	86279.15	5
2011	35	3	3548807	1.327974494e+10	149962	88554.07	5
2011	29	2	2905404	1.47404489e+09	15679	94013.96	5
2011	35	3	3524709	4.29006256e+09	45441	94409.51	5
2011	35	3	3509205	6.2019552e+09	65139	95211.09	5
2011	51	5	5107768	2.6033529e+08	2585	100709.98	5
2011	51	5	5102686	5.386363e+08	5327	101114.38	5
2011	35	3	3501152	1.72026941e+09	16961	101425	5
2011	52	5	5205471	7.5485146e+08	7249	104131.81	5
2011	31	3	3140001	5.72153718e+09	54796	104415.23	5
2011	15	1	1502152	2.94745689e+09	27929	105533.92	5
2011	43	4	4306957	3.2301009e+08	3049	105939.68	5
2011	31	3	3117876	6.3847941e+08	6008	106271.54	5
2011	33	3	3301009	5.102665942e+10	468087	109011.06	5
2011	52	5	5206909	2.2855319e+08	2058	111055.97	5
2011	33	3	3304524	1.251637985e+10	110992	112768.31	5
2011	31	3	3162948	7.7503706e+08	6834	113408.99	5
2011	35	3	3536505	9.80497348e+09	84512	116018.71	5
2011	42	4	4213104	6.0542884e+08	4708	128595.76	5
2011	15	1	1505536	2.101398408e+10	160229	131149.69	5
2011	35	3	3505708	3.446270423e+10	243242	141680.73	5
2011	32	3	3202801	4.65038227e+09	31209	149007.73	5
2011	31	3	3133709	1.52079562e+09	10037	151518.94	5
2011	43	4	4314464	3.4325002e+08	2110	162677.74	5
2011	43	4	4300901	1.13689785e+09	6523	174290.64	5
2011	52	5	5200555	8.3656915e+08	4654	179752.72	5
2011	31	3	3103751	1.12243446e+09	6209	180775.4	5
2011	35	3	3527306	7.03350298e+09	38140	184412.77	5
2011	41	4	4126272	9.8652121e+08	5061	194926.14	5
2011	43	4	4322004	5.23277573e+09	26072	200704.81	5
2011	50	5	5007802	1.34123927e+09	6303	212793.79	5
2011	33	3	3304151	4.52978963e+09	20747	218334.68	5
2011	32	3	3200409	5.39685576e+09	24265	222413.18	5
2011	33	3	3304110	4.5462577e+09	16938	268405.82	5
2011	33	3	3305000	9.08176275e+09	33136	274075.41	5
2011	31	3	3161908	2.95133022e+09	9878	298778.11	5
2011	32	3	3204302	6.46212944e+09	10373	622975.94	5
2012	24	2	2404507	-1.904643e+07	13047	1459.83	1
2012	21	2	2110906	3.428757e+07	11932	2873.58	1
2012	21	2	2110278	4.337154e+07	14456	3000.24	1
2012	21	2	2100873	4.463444e+07	14407	3098.11	1
2012	29	2	2923050	4.73281e+07	15067	3141.18	1
2012	21	2	2112100	8.924196e+07	28238	3160.35	1
2012	21	2	2111722	4.019066e+07	12600	3189.74	1
2012	21	2	2110237	3.911239e+07	12203	3205.15	1
2012	21	2	2106607	1.038108e+08	32216	3222.34	1
2012	21	2	2105104	8.294799e+07	25698	3227.8	1
2012	29	2	2905156	4.894596e+07	14926	3279.24	1
2012	21	2	2102408	3.527536e+07	10740	3284.48	1
2012	22	2	2206753	1.537181e+07	4661	3297.96	1
2012	21	2	2103125	2.677975e+07	8120	3298	1
2012	21	2	2107209	4.33969e+07	13095	3314.01	1
2012	21	2	2111789	3.520809e+07	10545	3338.84	1
2012	21	2	2101905	6.956812e+07	20773	3348.97	1
2012	21	2	2108405	4.66172e+07	13898	3354.24	1
2012	21	2	2106631	4.950254e+07	14755	3354.97	1
2012	22	2	2203750	1.731656e+07	5133	3373.57	1
2012	22	2	2203255	1.445767e+07	4265	3389.84	1
2012	21	2	2110401	6.1094e+07	18004	3393.36	1
2012	22	2	2203453	3.156425e+07	9296	3395.47	1
2012	15	1	1503754	1.410101e+08	41487	3398.9	1
2012	21	2	2108306	1.22661e+08	35996	3407.63	1
2012	23	2	2307908	3.56516e+07	10458	3409.03	1
2012	23	2	2306603	6.649547e+07	19401	3427.42	1
2012	21	2	2109403	4.931102e+07	14355	3435.11	1
2012	23	2	2303600	6.606815e+07	19228	3436.04	1
2012	21	2	2102358	5.150016e+07	14930	3449.44	1
2012	21	2	2104602	5.597145e+07	16197	3455.67	1
2012	21	2	2111078	6.108404e+07	17602	3470.29	1
2012	21	2	2100402	3.963041e+07	11381	3482.16	1
2012	22	2	2206050	2.198242e+07	6260	3511.57	1
2012	21	2	2101301	6.187825e+07	17437	3548.67	1
2012	15	1	1501956	1.006135e+08	28153	3573.81	1
2012	21	2	2103901	3.878252e+07	10836	3579.04	1
2012	13	1	1301803	8.461015e+07	23460	3606.57	1
2012	29	2	2919108	3.345663e+07	9271	3608.74	1
2012	21	2	2104628	2.696946e+07	7462	3614.24	1
2012	21	2	2109304	3.964345e+07	10964	3615.78	1
2012	21	2	2105005	9.767946e+07	26933	3626.76	1
2012	21	2	2111250	2.723464e+07	7506	3628.38	1
2012	22	2	2201960	2.924228e+07	8057	3629.42	1
2012	21	2	2106805	5.240187e+07	14402	3638.51	1
2012	22	2	2202059	3.691686e+07	10144	3639.28	1
2012	21	2	2100154	4.320255e+07	11865	3641.18	1
2012	22	2	2202851	1.66142e+07	4561	3642.67	1
2012	21	2	2100832	5.662783e+07	15542	3643.54	1
2012	22	2	2205854	2.908052e+07	7974	3646.92	1
2012	22	2	2209971	2.773694e+07	7578	3660.19	1
2012	21	2	2105922	4.030374e+07	10955	3679.03	1
2012	29	2	2920452	4.702775e+07	12759	3685.85	1
2012	22	2	2202174	2.570245e+07	6964	3690.76	1
2012	27	2	2708956	4.883373e+07	13209	3697	1
2012	21	2	2101772	4.570988e+07	12335	3705.71	1
2012	22	2	2209955	1.739467e+07	4693	3706.51	1
2012	22	2	2200103	1.876617e+07	5062	3707.26	1
2012	21	2	2105351	4.871959e+07	13103	3718.2	1
2012	22	2	2208874	1.608014e+07	4321	3721.39	1
2012	21	2	2104503	3.860905e+07	10372	3722.43	1
2012	22	2	2201945	2.343935e+07	6288	3727.63	1
2012	23	2	2303303	6.958335e+07	18586	3743.86	1
2012	23	2	2313351	6.612666e+07	17643	3748.04	1
2012	22	2	2201770	2.423927e+07	6467	3748.15	1
2012	22	2	2201051	2.850159e+07	7590	3755.15	1
2012	22	2	2200301	5.192167e+07	13820	3756.99	1
2012	21	2	2102309	8.717971e+07	23119	3770.91	1
2012	21	2	2112704	1.9475246e+08	51633	3771.86	1
2012	21	2	2102606	7.252963e+07	19222	3773.26	1
2012	22	2	2205409	5.260956e+07	13929	3776.98	1
2012	21	2	2108801	6.694564e+07	17722	3777.54	1
2012	21	2	2107456	5.154644e+07	13643	3778.23	1
2012	21	2	2111003	7.585106e+07	20072	3778.95	1
2012	21	2	2101103	4.387459e+07	11599	3782.62	1
2012	21	2	2108256	8.882644e+07	23454	3787.26	1
2012	29	2	2918753	5.376891e+07	14187	3790.01	1
2012	21	2	2102507	7.055672e+07	18603	3792.76	1
2012	23	2	2311009	4.573591e+07	12041	3798.35	1
2012	21	2	2108058	5.69217e+07	14971	3802.13	1
2012	29	2	2932457	6.631551e+07	17432	3804.24	1
2012	21	2	2102374	3.274794e+07	8607	3804.8	1
2012	29	2	2925907	1.041e+08	27357	3805.24	1
2012	22	2	2203271	1.900436e+07	4990	3808.49	1
2012	21	2	2112605	9.670834e+07	25356	3814.02	1
2012	21	2	2105807	4.146226e+07	10865	3816.13	1
2012	22	2	2202406	4.233518e+07	11092	3816.73	1
2012	23	2	2304707	2.0050844e+08	52528	3817.17	1
2012	23	2	2310951	3.959998e+07	10365	3820.55	1
2012	22	2	2201101	4.309118e+07	11258	3827.6	1
2012	21	2	2104081	3.671398e+07	9584	3830.76	1
2012	21	2	2100105	2.333016e+07	6090	3830.9	1
2012	15	1	1507961	4.053932e+07	10565	3837.13	1
2012	21	2	2105476	6.048556e+07	15733	3844.5	1
2012	29	2	2924702	4.702561e+07	12219	3848.56	1
2012	15	1	1503507	1.2128106e+08	31492	3851.17	1
2012	22	2	2208502	4.662736e+07	12097	3854.46	1
2012	23	2	2306504	7.332149e+07	19009	3857.2	1
2012	21	2	2106904	1.2235149e+08	31717	3857.6	1
2012	29	2	2901601	6.761468e+07	17526	3857.96	1
2012	22	2	2202026	3.119375e+07	8079	3861.09	1
2012	15	1	1501600	5.494145e+07	14207	3867.21	1
2012	22	2	2205458	2.018161e+07	5214	3870.66	1
2012	29	2	2925709	4.97542e+07	12854	3870.72	1
2012	21	2	2105450	3.513332e+07	9051	3881.71	1
2012	22	2	2206357	2.620917e+07	6750	3882.84	1
2012	23	2	2309458	9.473318e+07	24373	3886.81	1
2012	21	2	2101806	2.138048e+07	5497	3889.48	1
2012	21	2	2110500	1.6368703e+08	42083	3889.62	1
2012	29	2	2901809	4.367927e+07	11229	3889.86	1
2012	22	2	2209559	1.686614e+07	4332	3893.38	1
2012	22	2	2206100	4.124471e+07	10586	3896.16	1
2012	21	2	2102705	8.136997e+07	20879	3897.22	1
2012	23	2	2303006	8.067233e+07	20687	3899.66	1
2012	21	2	2106375	5.667212e+07	14524	3901.96	1
2012	29	2	2910008	4.770186e+07	12217	3904.55	1
2012	23	2	2302404	2.0631808e+08	52829	3905.39	1
2012	29	2	2900504	4.197758e+07	10746	3906.34	1
2012	21	2	2107803	1.3163653e+08	33669	3909.72	1
2012	21	2	2112506	2.1363225e+08	54629	3910.6	1
2012	21	2	2106300	7.159897e+07	18277	3917.44	1
2012	31	3	3162450	4.677538e+07	11940	3917.54	1
2012	21	2	2111953	2.142906e+07	5466	3920.43	1
2012	21	2	2104701	2.416324e+07	6150	3928.98	1
2012	22	2	2211357	1.917776e+07	4875	3933.9	1
2012	22	2	2205557	3.223839e+07	8184	3939.2	1
2012	29	2	2928307	3.48207e+07	8835	3941.22	1
2012	29	2	2913804	5.922373e+07	15025	3941.68	1
2012	29	2	2903953	3.989547e+07	10120	3942.24	1
2012	23	2	2305654	4.48158e+07	11358	3945.75	1
2012	29	2	2911303	4.219149e+07	10690	3946.82	1
2012	29	2	2915353	5.332154e+07	13487	3953.55	1
2012	21	2	2107100	7.225051e+07	18265	3955.68	1
2012	29	2	2921450	3.923382e+07	9902	3962.21	1
2012	23	2	2304657	5.99058e+07	15085	3971.22	1
2012	22	2	2201929	2.172736e+07	5471	3971.37	1
2012	27	2	2707206	5.500597e+07	13845	3972.98	1
2012	29	2	2903235	5.529268e+07	13914	3973.89	1
2012	27	2	2702553	6.918566e+07	17410	3973.9	1
2012	23	2	2308005	1.4329019e+08	36040	3975.87	1
2012	23	2	2300903	5.621963e+07	14135	3977.33	1
2012	29	2	2931806	7.067031e+07	17750	3981.43	1
2012	23	2	2300101	4.307863e+07	10815	3983.23	1
2012	29	2	2921054	4.522131e+07	11342	3987.07	1
2012	27	2	2706422	4.106768e+07	10282	3994.13	1
2012	22	2	2200251	2.961339e+07	7413	3994.79	1
2012	21	2	2102077	6.11822e+07	15314	3995.18	1
2012	21	2	2100907	1.7443651e+08	43653	3995.98	1
2012	21	2	2106201	2.649504e+07	6629	3996.84	1
2012	22	2	2203420	1.703686e+07	4261	3998.32	1
2012	23	2	2313559	5.937959e+07	14848	3999.16	1
2012	29	2	2919900	3.199267e+07	7992	4003.09	1
2012	21	2	2111748	4.211195e+07	10511	4006.46	1
2012	22	2	2204550	1.776321e+07	4432	4007.94	1
2012	22	2	2206670	2.634868e+07	6574	4008.01	1
2012	21	2	2100477	1.2513822e+08	31190	4012.13	1
2012	21	2	2111706	8.527059e+07	21235	4015.57	1
2012	22	2	2207793	1.549302e+07	3858	4015.82	1
2012	21	2	2104404	7.049511e+07	17545	4017.96	1
2012	15	1	1504505	1.0214894e+08	25374	4025.73	1
2012	21	2	2107605	7.657799e+07	19007	4028.94	1
2012	21	2	2103109	4.184111e+07	10374	4033.27	1
2012	15	1	1501105	1.0250575e+08	25398	4035.98	1
2012	29	2	2917409	5.852514e+07	14500	4036.22	1
2012	22	2	2207504	5.646258e+07	13986	4037.08	1
2012	23	2	2311900	6.35185e+07	15681	4050.67	1
2012	22	2	2206704	2.940847e+07	7248	4057.46	1
2012	22	2	2205250	1.768862e+07	4358	4058.88	1
2012	23	2	2305266	5.268687e+07	12977	4060.02	1
2012	15	1	1502806	1.2120578e+08	29838	4062.13	1
2012	29	2	2922052	4.778997e+07	11743	4069.66	1
2012	22	2	2204907	3.381308e+07	8307	4070.43	1
2012	23	2	2303931	5.284368e+07	12982	4070.53	1
2012	22	2	2210359	1.812169e+07	4451	4071.38	1
2012	22	2	2206902	2.630161e+07	6459	4072.09	1
2012	22	2	2201606	4.0516e+07	9943	4074.83	1
2012	29	2	2901502	4.249538e+07	10427	4075.51	1
2012	22	2	2208106	4.808729e+07	11798	4075.88	1
2012	21	2	2110104	1.1788702e+08	28914	4077.16	1
2012	22	2	2202505	4.261215e+07	10448	4078.5	1
2012	22	2	2210656	3.960808e+07	9706	4080.78	1
2012	22	2	2202703	1.1046607e+08	27067	4081.21	1
2012	29	2	2922854	3.286908e+07	8053	4081.59	1
2012	27	2	2703809	9.329841e+07	22853	4082.55	1
2012	23	2	2300408	6.726697e+07	16468	4084.71	1
2012	22	2	2203008	3.257026e+07	7973	4085.07	1
2012	22	2	2202117	1.966979e+07	4815	4085.11	1
2012	21	2	2112456	9.680764e+07	23694	4085.74	1
2012	22	2	2200707	3.836841e+07	9385	4088.27	1
2012	29	2	2904100	9.010858e+07	22025	4091.2	1
2012	29	2	2924504	6.421412e+07	15695	4091.37	1
2012	21	2	2104909	4.913454e+07	11997	4095.57	1
2012	22	2	2205573	2.670378e+07	6517	4097.56	1
2012	21	2	2111672	2.539161e+07	6193	4100.05	1
2012	22	2	2202075	1.399946e+07	3413	4101.8	1
2012	22	2	2206696	3.575664e+07	8714	4103.36	1
2012	29	2	2923035	4.515334e+07	11001	4104.48	1
2012	23	2	2313757	7.813202e+07	19023	4107.24	1
2012	29	2	2925931	3.908823e+07	9514	4108.5	1
2012	21	2	2103158	4.92477e+07	11979	4111.17	1
2012	31	3	3116100	6.250925e+07	15184	4116.78	1
2012	21	2	2105609	6.463506e+07	15688	4120.03	1
2012	29	2	2921500	2.143874e+08	52023	4121.01	1
2012	23	2	2301257	4.356584e+07	10564	4123.99	1
2012	22	2	2206209	1.3475886e+08	32658	4126.37	1
2012	23	2	2300507	4.521433e+07	10956	4126.9	1
2012	23	2	2310506	1.7365102e+08	42064	4128.26	1
2012	23	2	2308500	1.7715079e+08	42891	4130.26	1
2012	27	2	2702504	4.477395e+07	10838	4131.2	1
2012	29	2	2900207	7.306607e+07	17685	4131.53	1
2012	29	2	2922656	5.147612e+07	12458	4131.97	1
2012	21	2	2100303	1.021714e+08	24726	4132.14	1
2012	21	2	2106508	9.210974e+07	22286	4133.08	1
2012	29	2	2912509	5.904373e+07	14285	4133.27	1
2012	23	2	2304004	9.205132e+07	22252	4136.77	1
2012	22	2	2203354	2.799679e+07	6767	4137.25	1
2012	29	2	2930808	6.652787e+07	16069	4140.14	1
2012	21	2	2107704	8.47796e+07	20443	4147.12	1
2012	21	2	2111631	2.390378e+07	5757	4152.13	1
2012	26	2	2609154	7.825732e+07	18847	4152.24	1
2012	23	2	2308906	8.778749e+07	21119	4156.8	1
2012	21	2	2111904	4.351597e+07	10454	4162.61	1
2012	31	3	3126505	4.262545e+07	10239	4163.05	1
2012	22	2	2209351	1.870287e+07	4489	4166.38	1
2012	22	2	2202778	3.116188e+07	7461	4176.64	1
2012	21	2	2109809	1.6868982e+08	40356	4180.04	1
2012	23	2	2303204	1.1084092e+08	26471	4187.26	1
2012	21	2	2101731	2.926116e+07	6986	4188.54	1
2012	22	2	2201572	1.421715e+07	3388	4196.32	1
2012	23	2	2313708	3.17331e+07	7562	4196.39	1
2012	29	2	2906402	3.659507e+07	8720	4196.68	1
2012	29	2	2924801	9.616218e+07	22907	4197.94	1
2012	22	2	2209658	2.387385e+07	5686	4198.71	1
2012	29	2	2907558	3.702868e+07	8817	4199.69	1
2012	29	2	2904753	8.340065e+07	19853	4200.91	1
2012	23	2	2310308	1.3092373e+08	31160	4201.66	1
2012	27	2	2701605	7.248499e+07	17238	4204.95	1
2012	22	2	2207777	2.597888e+07	6178	4205.06	1
2012	23	2	2308203	5.919649e+07	14049	4213.57	1
2012	22	2	2205003	4.728227e+07	11219	4214.48	1
2012	21	2	2103703	1.3703734e+08	32487	4218.22	1
2012	22	2	2210375	1.085392e+07	2573	4218.39	1
2012	23	2	2309409	1.1671241e+08	27655	4220.3	1
2012	21	2	2106672	3.460132e+07	8195	4222.25	1
2012	22	2	2209807	2.043887e+07	4831	4230.77	1
2012	31	3	3143153	1.987188e+07	4693	4234.37	1
2012	26	2	2612471	5.03974e+07	11901	4234.72	1
2012	29	2	2924207	7.218363e+07	17045	4234.89	1
2012	22	2	2206506	3.170389e+07	7486	4235.09	1
2012	29	2	2901155	6.76368e+07	15962	4237.36	1
2012	23	2	2308807	3.486688e+07	8225	4239.13	1
2012	22	2	2200053	2.901169e+07	6840	4241.47	1
2012	21	2	2100709	1.1014852e+08	25955	4243.83	1
2012	22	2	2210953	1.191986e+07	2805	4249.51	1
2012	29	2	2903508	7.491773e+07	17625	4250.65	1
2012	23	2	2302305	1.3287859e+08	31259	4250.89	1
2012	15	1	1502608	4.88645e+07	11495	4250.94	1
2012	15	1	1506195	1.8042523e+08	42417	4253.61	1
2012	22	2	2201507	1.1081643e+08	26023	4258.4	1
2012	15	1	1506104	4.413511e+07	10352	4263.44	1
2012	21	2	2101970	3.576803e+07	8375	4270.81	1
2012	22	2	2211704	1.846681e+07	4323	4271.76	1
2012	23	2	2303105	7.856337e+07	18391	4271.84	1
2012	15	1	1501006	6.795282e+07	15899	4274.03	1
2012	23	2	2304905	4.467493e+07	10445	4277.16	1
2012	22	2	2202091	2.438416e+07	5700	4277.92	1
2012	21	2	2103604	2.6799835e+08	62639	4278.46	1
2012	26	2	2601052	7.970152e+07	18617	4281.11	1
2012	27	2	2704203	1.1589276e+08	27069	4281.38	1
2012	22	2	2210409	7.72572e+07	18033	4284.21	1
2012	22	2	2204204	3.79591e+07	8857	4285.77	1
2012	29	2	2922805	3.243102e+07	7563	4288.12	1
2012	21	2	2104651	4.365086e+07	10166	4293.81	1
2012	22	2	2210904	1.930856e+07	4495	4295.56	1
2012	26	2	2612109	4.144874e+07	9641	4299.22	1
2012	29	2	2924108	3.006765e+07	6993	4299.68	1
2012	29	2	2913101	7.642194e+07	17763	4302.31	1
2012	25	2	2515401	4.481254e+07	10400	4308.9	1
2012	23	2	2312007	1.3151752e+08	30512	4310.35	1
2012	22	2	2204154	1.278296e+07	2961	4317.11	1
2012	22	2	2204600	1.634009e+07	3782	4320.49	1
2012	26	2	2612554	5.860199e+07	13561	4321.36	1
2012	22	2	2205524	2.350541e+07	5439	4321.64	1
2012	21	2	2109056	2.583775e+07	5978	4322.14	1
2012	23	2	2304269	3.980192e+07	9203	4324.88	1
2012	29	2	2924603	8.656082e+07	20009	4326.09	1
2012	27	2	2701803	3.700622e+07	8548	4329.23	1
2012	23	2	2310902	6.849853e+07	15820	4329.87	1
2012	22	2	2209500	1.593174e+07	3679	4330.45	1
2012	13	1	1303700	1.0778724e+08	24890	4330.54	1
2012	31	3	3108255	4.307766e+07	9947	4330.72	1
2012	21	2	2107001	4.016348e+07	9272	4331.7	1
2012	21	2	2112308	1.7294431e+08	39924	4331.84	1
2012	21	2	2102200	1.1890813e+08	27449	4331.97	1
2012	22	2	2202729	2.442967e+07	5635	4335.34	1
2012	29	2	2927606	6.372759e+07	14698	4335.8	1
2012	22	2	2209377	2.231165e+07	5145	4336.57	1
2012	22	2	2209005	2.72576e+07	6282	4339	1
2012	27	2	2706208	2.258716e+07	5201	4342.85	1
2012	31	3	3130051	4.764063e+07	10963	4345.58	1
2012	29	2	2915007	6.549773e+07	15063	4348.25	1
2012	22	2	2205540	1.183792e+07	2721	4350.58	1
2012	29	2	2918506	6.530452e+07	15004	4352.47	1
2012	22	2	2209450	9.08374e+06	2087	4352.53	1
2012	22	2	2208601	1.344236e+07	3088	4353.1	1
2012	23	2	2301802	2.651717e+07	6072	4367.12	1
2012	23	2	2309003	6.177793e+07	14146	4367.17	1
2012	23	2	2314102	2.463112e+08	56394	4367.68	1
2012	23	2	2304236	7.548569e+07	17272	4370.41	1
2012	29	2	2902658	5.17484e+07	11840	4370.64	1
2012	23	2	2301505	3.353152e+07	7667	4373.49	1
2012	29	2	2924405	1.4514158e+08	33176	4374.9	1
2012	13	1	1303908	1.4297881e+08	32677	4375.52	1
2012	29	2	2900405	6.964094e+07	15884	4384.35	1
2012	21	2	2110203	1.4845788e+08	33843	4386.66	1
2012	21	2	2107902	7.886592e+07	17977	4387.05	1
2012	22	2	2207959	1.85737e+07	4233	4387.83	1
2012	21	2	2109759	3.181472e+07	7246	4390.66	1
2012	29	2	2909000	3.62028e+07	8245	4390.88	1
2012	21	2	2100600	1.7111129e+08	38953	4392.76	1
2012	22	2	2205599	2.178654e+07	4958	4394.22	1
2012	29	2	2906899	4.344588e+07	9879	4397.8	1
2012	27	2	2708402	1.3435332e+08	30549	4397.96	1
2012	23	2	2305902	1.6619331e+08	37758	4401.54	1
2012	26	2	2614808	1.0046202e+08	22819	4402.56	1
2012	22	2	2207850	1.597702e+07	3629	4402.6	1
2012	27	2	2709202	1.1613201e+08	26369	4404.11	1
2012	29	2	2900355	7.009501e+07	15914	4404.61	1
2012	21	2	2105203	4.973801e+07	11289	4405.88	1
2012	23	2	2307502	1.3697048e+08	31073	4408.02	1
2012	21	2	2100550	2.901825e+07	6583	4408.06	1
2012	29	2	2904001	6.139228e+07	13893	4418.94	1
2012	25	2	2509008	4.777207e+07	10803	4422.11	1
2012	21	2	2105963	5.530324e+07	12501	4423.9	1
2012	23	2	2312809	3.117291e+07	7041	4427.34	1
2012	15	1	1506112	5.596676e+07	12639	4428.1	1
2012	29	2	2901908	7.916529e+07	17877	4428.33	1
2012	22	2	2210391	1.317349e+07	2974	4429.55	1
2012	29	2	2905305	7.708621e+07	17398	4430.75	1
2012	24	2	2403509	4.627435e+07	10439	4432.83	1
2012	22	2	2200277	2.293471e+07	5173	4433.54	1
2012	29	2	2907707	4.786582e+07	10794	4434.48	1
2012	22	2	2210201	2.915345e+07	6574	4434.66	1
2012	22	2	2201002	2.064917e+07	4655	4435.91	1
2012	21	2	2104206	6.741189e+07	15174	4442.59	1
2012	21	2	2103752	5.609147e+07	12625	4442.89	1
2012	26	2	2607703	6.109008e+07	13748	4443.56	1
2012	27	2	2706604	3.293668e+07	7412	4443.7	1
2012	22	2	2204105	1.938908e+07	4363	4443.98	1
2012	22	2	2209609	1.300032e+07	2925	4444.55	1
2012	22	2	2207108	1.190304e+07	2678	4444.75	1
2012	22	2	2201739	2.686714e+07	6042	4446.73	1
2012	29	2	2929255	8.196949e+07	18430	4447.61	1
2012	23	2	2307205	3.401776e+07	7647	4448.51	1
2012	29	2	2919801	2.1321058e+08	47915	4449.77	1
2012	21	2	2101350	2.397783e+07	5387	4451.05	1
2012	29	2	2922102	1.1082996e+08	24867	4456.91	1
2012	22	2	2208650	3.869608e+07	8679	4458.59	1
2012	29	2	2907103	1.2724409e+08	28519	4461.73	1
2012	23	2	2305332	5.18568e+07	11622	4461.95	1
2012	29	2	2920304	3.745101e+07	8389	4464.3	1
2012	22	2	2209856	1.99899e+07	4476	4466.02	1
2012	29	2	2931509	9.643085e+07	21581	4468.32	1
2012	27	2	2701100	4.67881e+07	10471	4468.35	1
2012	15	1	1503101	1.3389785e+08	29963	4468.77	1
2012	22	2	2206720	3.678069e+07	8227	4470.73	1
2012	13	1	1303601	8.626462e+07	19292	4471.52	1
2012	29	2	2926806	6.71672e+07	15015	4473.34	1
2012	29	2	2913002	7.014477e+07	15669	4476.66	1
2012	23	2	2308377	5.82454e+07	13009	4477.32	1
2012	22	2	2209872	2.560621e+07	5718	4478.18	1
2012	26	2	2605608	9.930993e+07	22162	4481.09	1
2012	21	2	2105906	7.001538e+07	15624	4481.27	1
2012	22	2	2209906	2.724933e+07	6079	4482.53	1
2012	29	2	2912400	7.753285e+07	17277	4487.63	1
2012	23	2	2308609	7.524997e+07	16760	4489.85	1
2012	15	1	1507474	9.487813e+07	21125	4491.27	1
2012	29	2	2911857	5.885564e+07	13099	4493.14	1
2012	29	2	2926905	5.373026e+07	11948	4497.01	1
2012	29	2	2910859	7.497731e+07	16672	4497.2	1
2012	29	2	2933059	6.222769e+07	13834	4498.17	1
2012	22	2	2205953	3.626669e+07	8059	4500.15	1
2012	22	2	2205565	2.040882e+07	4535	4500.29	1
2012	23	2	2304277	3.118358e+07	6922	4505	1
2012	22	2	2202109	2.457014e+07	5449	4509.11	1
2012	31	3	3113008	1.0174718e+08	22549	4512.27	1
2012	22	2	2209708	2.841146e+07	6290	4516.93	1
2012	22	2	2211407	1.949648e+07	4316	4517.26	1
2012	22	2	2207553	1.758376e+07	3891	4519.08	1
2012	21	2	2107506	4.989212e+08	110321	4522.45	1
2012	22	2	2202133	2.582351e+07	5704	4527.26	1
2012	29	2	2911659	4.158085e+07	9182	4528.52	1
2012	31	3	3138658	3.853428e+07	8506	4530.25	1
2012	26	2	2603926	5.444248e+07	11991	4540.28	1
2012	26	2	2612802	5.043051e+07	11103	4542.06	1
2012	22	2	2210300	2.598809e+07	5719	4544.17	1
2012	23	2	2302909	7.819277e+07	17202	4545.56	1
2012	22	2	2206803	3.799588e+07	8356	4547.14	1
2012	23	2	2313203	1.1553352e+08	25397	4549.1	1
2012	23	2	2310407	5.168772e+07	11360	4549.98	1
2012	23	2	2313906	5.963581e+07	13096	4553.74	1
2012	29	2	2905503	5.767138e+07	12658	4556.12	1
2012	29	2	2906204	1.1133442e+08	24430	4557.28	1
2012	29	2	2907608	7.781863e+07	17057	4562.27	1
2012	29	2	2923407	9.534505e+07	20894	4563.27	1
2012	21	2	2109452	1.2657457e+08	27723	4565.69	1
2012	21	2	2109239	2.997406e+07	6564	4566.43	1
2012	31	3	3135456	3.293143e+07	7211	4566.83	1
2012	21	2	2108454	9.955481e+07	21785	4569.88	1
2012	21	2	2107308	2.101559e+07	4598	4570.59	1
2012	29	2	2909208	7.610668e+07	16650	4570.97	1
2012	21	2	2112852	5.46076e+07	11946	4571.2	1
2012	21	2	2111508	1.8165352e+08	39733	4571.86	1
2012	29	2	2902005	6.199698e+07	13542	4578.13	1
2012	22	2	2204808	4.334434e+07	9463	4580.4	1
2012	31	3	3135357	3.818496e+07	8331	4583.48	1
2012	22	2	2207355	1.574041e+07	3434	4583.7	1
2012	23	2	2304954	1.1336899e+08	24727	4584.83	1
2012	29	2	2906709	1.1796837e+08	25711	4588.25	1
2012	29	2	2913309	2.710848e+07	5908	4588.44	1
2012	29	2	2921401	7.624172e+07	16606	4591.22	1
2012	21	2	2103554	6.883683e+07	14989	4592.49	1
2012	27	2	2706109	5.034703e+07	10953	4596.64	1
2012	29	2	2930402	6.893058e+07	14993	4597.52	1
2012	23	2	2310803	7.284511e+07	15838	4599.39	1
2012	22	2	2204709	6.862585e+07	14909	4602.98	1
2012	29	2	2903003	6.411524e+07	13914	4607.97	1
2012	26	2	2606903	5.44868e+07	11824	4608.15	1
2012	29	2	2918605	3.473484e+07	7533	4611.02	1
2012	29	2	2921609	3.797682e+07	8233	4612.76	1
2012	31	3	3139250	2.92901e+07	6349	4613.34	1
2012	23	2	2303907	5.854347e+07	12684	4615.54	1
2012	31	3	3117836	3.321375e+07	7196	4615.58	1
2012	23	2	2307106	1.2344084e+08	26730	4618.06	1
2012	22	2	2202554	2.27081e+07	4915	4620.16	1
2012	22	2	2200954	1.128301e+07	2442	4620.4	1
2012	31	3	3155207	2.744396e+07	5939	4620.97	1
2012	29	2	2912608	2.252934e+07	4874	4622.35	1
2012	21	2	2102002	1.8372731e+08	39740	4623.23	1
2012	21	2	2108702	1.0036823e+08	21708	4623.56	1
2012	29	2	2909703	6.187397e+07	13374	4626.44	1
2012	21	2	2100956	1.4679372e+08	31729	4626.48	1
2012	22	2	2203800	2.022202e+07	4366	4631.7	1
2012	29	2	2929800	5.524559e+07	11921	4634.31	1
2012	22	2	2206001	2.063921e+07	4453	4634.9	1
2012	26	2	2601805	5.613589e+07	12109	4635.88	1
2012	31	3	3157658	2.829749e+07	6101	4638.17	1
2012	29	2	2917003	1.6795555e+08	36200	4639.66	1
2012	22	2	2202711	2.119053e+07	4567	4639.92	1
2012	21	2	2111532	5.659327e+07	12195	4640.69	1
2012	21	2	2111029	7.255582e+07	15631	4641.79	1
2012	22	2	2200608	3.090706e+07	6655	4644.19	1
2012	29	2	2906600	6.191609e+07	13329	4645.22	1
2012	23	2	2307635	8.630278e+07	18575	4646.18	1
2012	29	2	2922904	1.1278069e+08	24265	4647.88	1
2012	25	2	2508000	4.552038e+07	9793	4648.26	1
2012	26	2	2604155	6.429216e+07	13830	4648.75	1
2012	31	3	3127073	2.705512e+07	5814	4653.44	1
2012	22	2	2202455	1.836979e+07	3946	4655.3	1
2012	21	2	2101707	2.7042152e+08	58083	4655.78	1
2012	31	3	3164506	4.890212e+07	10503	4656.01	1
2012	29	2	2902708	2.3347186e+08	50134	4656.96	1
2012	29	2	2922201	3.435019e+07	7374	4658.28	1
2012	23	2	2301208	1.1921566e+08	25592	4658.32	1
2012	22	2	2205805	1.1565246e+08	24824	4658.9	1
2012	22	2	2201919	2.519869e+07	5407	4660.38	1
2012	22	2	2204006	2.439453e+07	5233	4661.67	1
2012	23	2	2311231	2.881524e+07	6181	4661.91	1
2012	29	2	2914307	5.198882e+07	11150	4662.67	1
2012	22	2	2202539	2.627166e+07	5634	4663.06	1
2012	25	2	2506707	5.337646e+07	11423	4672.72	1
2012	22	2	2202737	1.812248e+07	3872	4680.39	1
2012	22	2	2209153	1.80872e+07	3864	4680.95	1
2012	22	2	2203859	1.166924e+07	2492	4682.68	1
2012	15	1	1504307	1.3349282e+08	28498	4684.29	1
2012	22	2	2207900	1.7667329e+08	37692	4687.29	1
2012	22	2	2201309	1.525899e+07	3255	4687.86	1
2012	13	1	1300409	1.2165889e+08	25948	4688.57	1
2012	29	2	2905909	1.3205353e+08	28156	4690.07	1
2012	29	2	2901304	6.541842e+07	13942	4692.18	1
2012	31	3	3165552	5.221136e+07	11126	4692.73	1
2012	26	2	2605806	6.802872e+07	14492	4694.23	1
2012	22	2	2208205	8.380116e+07	17848	4695.27	1
2012	15	1	1502905	1.6679996e+08	35523	4695.55	1
2012	21	2	2104008	8.318413e+07	17715	4695.69	1
2012	29	2	2923704	1.4033964e+08	29853	4701.02	1
2012	25	2	2513000	1.698182e+07	3612	4701.5	1
2012	29	2	2932002	1.1293682e+08	24015	4702.76	1
2012	29	2	2927903	4.851735e+07	10312	4704.94	1
2012	26	2	2612901	6.742002e+07	14326	4706.13	1
2012	23	2	2311959	7.381998e+07	15684	4706.71	1
2012	22	2	2210706	6.71541e+07	14267	4706.95	1
2012	22	2	2210383	1.123283e+07	2386	4707.81	1
2012	25	2	2514453	2.636386e+07	5600	4707.83	1
2012	22	2	2204659	4.270403e+07	9069	4708.79	1
2012	23	2	2304350	1.0570799e+08	22435	4711.74	1
2012	21	2	2103174	9.407234e+07	19947	4716.11	1
2012	25	2	2514552	1.936695e+07	4106	4716.74	1
2012	22	2	2209104	2.862559e+07	6065	4719.8	1
2012	13	1	1304237	8.17825e+07	17316	4722.94	1
2012	25	2	2516409	4.914635e+07	10394	4728.34	1
2012	25	2	2506251	3.951503e+07	8355	4729.51	1
2012	21	2	2112274	2.673068e+07	5651	4730.26	1
2012	29	2	2919157	1.2210191e+08	25785	4735.39	1
2012	31	3	3170008	5.597818e+07	11818	4736.69	1
2012	26	2	2608701	7.45662e+07	15731	4740.08	1
2012	29	2	2931103	3.809903e+07	8035	4741.63	1
2012	15	1	1505601	3.734333e+07	7869	4745.63	1
2012	22	2	2206951	1.580207e+07	3329	4746.79	1
2012	27	2	2707107	1.1159288e+08	23504	4747.83	1
2012	29	2	2919603	5.318886e+07	11201	4748.58	1
2012	15	1	1508035	1.3383361e+08	28167	4751.43	1
2012	21	2	2110856	5.105479e+07	10745	4751.49	1
2012	25	2	2506608	2.840495e+07	5978	4751.58	1
2012	29	2	2932408	6.486453e+07	13642	4754.77	1
2012	23	2	2312106	8.192384e+07	17219	4757.76	1
2012	29	2	2923308	3.957706e+07	8316	4759.15	1
2012	29	2	2918209	6.709764e+07	14096	4760.05	1
2012	24	2	2413300	2.725266e+07	5724	4761.12	1
2012	29	2	2914109	4.475168e+07	9398	4761.83	1
2012	29	2	2910305	3.790905e+07	7961	4761.85	1
2012	22	2	2202251	1.853918e+07	3892	4763.41	1
2012	22	2	2205532	2.185479e+07	4588	4763.47	1
2012	22	2	2209302	2.678977e+07	5624	4763.47	1
2012	23	2	2303402	8.091778e+07	16975	4766.88	1
2012	29	2	2926400	1.4790627e+08	31027	4767.02	1
2012	21	2	2112803	2.395964e+08	50257	4767.42	1
2012	22	2	2200905	2.739119e+07	5742	4770.32	1
2012	26	2	2602001	1.7020353e+08	35676	4770.81	1
2012	21	2	2102903	1.0745397e+08	22517	4772.13	1
2012	31	3	3145356	4.964329e+07	10395	4775.69	1
2012	22	2	2201200	2.1743386e+08	45448	4784.23	1
2012	13	1	1303106	1.5200453e+08	31749	4787.7	1
2012	29	2	2906824	7.632148e+07	15941	4787.75	1
2012	25	2	2503555	3.292954e+07	6877	4788.36	1
2012	23	2	2310001	4.296268e+07	8972	4788.53	1
2012	27	2	2705002	1.1712313e+08	24449	4790.51	1
2012	15	1	1506302	1.0036919e+08	20948	4791.35	1
2012	29	2	2924678	4.713867e+07	9833	4793.93	1
2012	29	2	2913507	1.2497546e+08	26053	4796.97	1
2012	21	2	2106003	5.529688e+07	11525	4797.99	1
2012	13	1	1303809	1.8765213e+08	39097	4799.66	1
2012	23	2	2313252	4.257182e+07	8865	4802.24	1
2012	25	2	2512408	6.277407e+07	13066	4804.38	1
2012	27	2	2704609	4.796539e+07	9981	4805.67	1
2012	27	2	2705804	4.18481e+07	8708	4805.71	1
2012	29	2	2928505	4.709896e+07	9792	4809.94	1
2012	23	2	2313005	8.556751e+07	17768	4815.82	1
2012	25	2	2501575	3.948035e+07	8191	4819.97	1
2012	27	2	2706406	1.1399994e+08	23651	4820.09	1
2012	25	2	2508505	3.466814e+07	7189	4822.39	1
2012	25	2	2505204	3.296646e+07	6834	4823.89	1
2012	23	2	2301307	1.0058811e+08	20848	4824.83	1
2012	15	1	1506906	3.014839e+07	6248	4825.29	1
2012	23	2	2311108	7.226161e+07	14971	4826.77	1
2012	21	2	2106326	9.602016e+07	19887	4828.29	1
2012	29	2	2923100	1.2120973e+08	25100	4829.07	1
2012	21	2	2113009	1.5315379e+08	31709	4829.98	1
2012	29	2	2920106	9.257972e+07	19163	4831.17	1
2012	23	2	2300606	3.398186e+07	7033	4831.77	1
2012	29	2	2928950	4.479285e+07	9266	4834.11	1
2012	15	1	1506559	9.392134e+07	19428	4834.33	1
2012	29	2	2906808	1.5993705e+08	33054	4838.66	1
2012	23	2	2302008	1.0525041e+08	21742	4840.88	1
2012	29	2	2906105	4.548606e+07	9395	4841.52	1
2012	22	2	2206654	1.96242e+07	4053	4841.9	1
2012	31	3	3146750	3.214987e+07	6636	4844.77	1
2012	26	2	2602605	2.2406867e+08	46248	4844.94	1
2012	27	2	2705408	3.370711e+07	6952	4848.55	1
2012	26	2	2612455	6.764256e+07	13946	4850.32	1
2012	29	2	2903706	7.099018e+07	14620	4855.69	1
2012	31	3	3162401	1.2273729e+08	25257	4859.54	1
2012	29	2	2906857	5.584861e+07	11485	4862.74	1
2012	26	2	2610202	1.26485e+08	26005	4863.87	1
2012	29	2	2933158	6.279737e+07	12910	4864.24	1
2012	22	2	2210508	6.717579e+07	13810	4864.29	1
2012	29	2	2900108	4.214812e+07	8659	4867.55	1
2012	23	2	2305704	5.880225e+07	12080	4867.74	1
2012	13	1	1302801	8.575959e+07	17596	4873.81	1
2012	25	2	2502102	2.742697e+07	5625	4875.91	1
2012	23	2	2306108	1.109571e+08	22742	4878.95	1
2012	23	2	2301703	1.1956775e+08	24470	4886.3	1
2012	31	3	3129657	2.981572e+07	6098	4889.43	1
2012	22	2	2201176	1.88701e+07	3858	4891.16	1
2012	29	2	2924652	5.015261e+07	10250	4892.94	1
2012	27	2	2709004	3.020776e+07	6172	4894.32	1
2012	15	1	1500909	2.0375027e+08	41628	4894.55	1
2012	25	2	2514305	2.965823e+07	6052	4900.57	1
2012	23	2	2307403	1.1754157e+08	23985	4900.63	1
2012	31	3	3145307	1.5080153e+08	30767	4901.4	1
2012	21	2	2104099	8.7003e+07	17749	4901.85	1
2012	23	2	2304301	9.245841e+07	18859	4902.61	1
2012	29	2	2903607	7.288303e+07	14866	4902.67	1
2012	21	2	2105708	2.3189843e+08	47298	4902.92	1
2012	27	2	2703007	7.450391e+07	15180	4908.03	1
2012	26	2	2605905	1.3990968e+08	28503	4908.59	1
2012	26	2	2616100	4.509889e+07	9187	4908.99	1
2012	29	2	2907905	7.799999e+07	15884	4910.6	1
2012	22	2	2211506	1.473326e+07	2998	4914.36	1
2012	27	2	2705903	2.44388e+07	4967	4920.23	1
2012	29	2	2902104	2.574513e+08	52325	4920.24	1
2012	29	2	2921807	5.775217e+07	11729	4923.88	1
2012	23	2	2305209	9.625313e+07	19548	4923.94	1
2012	22	2	2200509	8.456357e+07	17173	4924.22	1
2012	31	3	3116308	3.240277e+07	6578	4925.93	1
2012	27	2	2706000	5.49392e+07	11150	4927.28	1
2012	25	2	2509206	6.447187e+07	13084	4927.54	1
2012	22	2	2201556	1.89909e+07	3854	4927.58	1
2012	23	2	2302057	7.177979e+07	14560	4929.93	1
2012	29	2	2924900	4.413476e+07	8944	4934.57	1
2012	23	2	2304251	1.129397e+08	22887	4934.67	1
2012	29	2	2928406	1.3159848e+08	26653	4937.47	1
2012	25	2	2507606	3.729484e+07	7550	4939.71	1
2012	25	2	2501302	9.396641e+07	19016	4941.44	1
2012	23	2	2308302	1.394123e+08	28204	4943	1
2012	24	2	2405405	2.672434e+07	5401	4948.04	1
2012	26	2	2600807	1.1069265e+08	22371	4948.04	1
2012	21	2	2106409	7.749383e+07	15657	4949.47	1
2012	21	2	2107407	9.315029e+07	18816	4950.59	1
2012	21	2	2108108	1.0128051e+08	20454	4951.62	1
2012	29	2	2908705	8.62746e+07	17421	4952.33	1
2012	25	2	2503506	8.365839e+07	16885	4954.6	1
2012	13	1	1303304	1.0959005e+08	22106	4957.48	1
2012	23	2	2303659	4.984061e+07	10053	4957.79	1
2012	29	2	2930758	6.02929e+07	12161	4957.89	1
2012	23	2	2314003	1.9315894e+08	38952	4958.9	1
2012	15	1	1502103	6.1731572e+08	124411	4961.91	1
2012	29	2	2919959	3.001049e+07	6048	4962.05	1
2012	29	2	2901205	9.870401e+07	19889	4962.74	1
2012	21	2	2102556	6.77451e+07	13649	4963.37	1
2012	25	2	2514107	2.17734e+07	4384	4966.56	1
2012	23	2	2303956	9.410885e+07	18947	4966.95	1
2012	21	2	2107357	9.767178e+07	19659	4968.3	1
2012	21	2	2112902	1.5708205e+08	31588	4972.84	1
2012	25	2	2500908	6.376757e+07	12820	4974.07	1
2012	31	3	3149150	5.240196e+07	10534	4974.56	1
2012	29	2	2902302	4.295488e+07	8632	4976.24	1
2012	31	3	3160454	3.484482e+07	7001	4977.12	1
2012	22	2	2201804	2.187736e+07	4394	4978.92	1
2012	23	2	2309904	3.006129e+07	6037	4979.51	1
2012	22	2	2210979	1.32629e+07	2663	4980.44	1
2012	25	2	2516607	7.064481e+07	14182	4981.3	1
2012	25	2	2515104	5.578506e+07	11195	4983.03	1
2012	13	1	1303205	7.720669e+07	15489	4984.61	1
2012	23	2	2310100	6.155936e+07	12330	4992.65	1
2012	23	2	2301604	1.131848e+08	22633	5000.87	1
2012	29	2	2925808	1.230557e+08	24602	5001.86	1
2012	22	2	2202000	9.611497e+07	19212	5002.86	1
2012	22	2	2200400	1.9631805e+08	39232	5004.03	1
2012	29	2	2930006	5.286134e+07	10563	5004.39	1
2012	29	2	2907806	1.6251292e+08	32470	5005.02	1
2012	21	2	2111805	8.657805e+07	17288	5007.99	1
2012	29	2	2929370	5.155365e+07	10293	5008.61	1
2012	21	2	2102101	1.715108e+08	34242	5008.78	1
2012	24	2	2403301	2.653869e+07	5297	5010.14	1
2012	23	2	2303808	1.2338032e+08	24622	5010.98	1
2012	26	2	2604403	6.316713e+07	12601	5012.87	1
2012	29	2	2902609	1.0042289e+08	20031	5013.37	1
2012	26	2	2601508	5.749112e+07	11463	5015.36	1
2012	24	2	2412302	6.231564e+07	12413	5020.19	1
2012	25	2	2505402	4.040269e+07	8035	5028.34	1
2012	25	2	2509503	2.587094e+07	5145	5028.37	1
2012	13	1	1300904	7.036061e+07	13986	5030.79	1
2012	29	2	2923506	4.299409e+07	8545	5031.49	1
2012	15	1	1505908	1.788478e+08	35529	5033.85	1
2012	22	2	2205151	2.855081e+07	5670	5035.42	1
2012	22	2	2208858	2.129937e+07	4229	5036.5	1
2012	29	2	2914208	3.549682e+07	7046	5037.87	1
2012	26	2	2611533	3.387511e+07	6722	5039.44	1
2012	24	2	2410108	7.1652e+07	14204	5044.49	1
2012	29	2	2930600	6.288328e+07	12464	5045.19	1
2012	22	2	2205201	9.267526e+07	18364	5046.57	1
2012	26	2	2609204	6.037528e+07	11961	5047.68	1
2012	31	3	3115409	1.761943e+07	3489	5050	1
2012	25	2	2514602	1.66877e+07	3303	5052.29	1
2012	29	2	2925600	6.982308e+07	13807	5057.08	1
2012	22	2	2203503	7.279362e+07	14394	5057.22	1
2012	13	1	1304062	2.7545619e+08	54440	5059.81	1
2012	25	2	2517209	2.583449e+07	5102	5063.6	1
2012	22	2	2207603	5.276097e+07	10417	5064.89	1
2012	15	1	1500701	1.3035739e+08	25731	5066.16	1
2012	29	2	2932309	1.2966227e+08	25575	5069.88	1
2012	23	2	2311264	1.022094e+08	20158	5070.41	1
2012	29	2	2930204	1.9367065e+08	38174	5073.37	1
2012	31	3	3166956	2.275042e+07	4484	5073.69	1
2012	26	2	2615102	3.453022e+07	6803	5075.73	1
2012	29	2	2922706	8.157066e+07	16070	5075.96	1
2012	23	2	2300309	2.6279278e+08	51768	5076.36	1
2012	26	2	2602704	6.408499e+07	12618	5078.85	1
2012	25	2	2505352	2.535962e+07	4990	5082.09	1
2012	26	2	2610509	1.4512098e+08	28552	5082.69	1
2012	22	2	2203305	6.810309e+07	13398	5083.08	1
2012	22	2	2202802	2.285501e+07	4496	5083.41	1
2012	25	2	2514800	1.886194e+07	3709	5085.45	1
2012	26	2	2605301	1.6036407e+08	31518	5088.02	1
2012	22	2	2208700	4.323367e+07	8494	5089.91	1
2012	26	2	2603702	1.2464827e+08	24461	5095.8	1
2012	25	2	2500106	4.902333e+07	9611	5100.75	1
2012	21	2	2106706	1.0475592e+08	20537	5100.84	1
2012	22	2	2207207	3.411408e+07	6687	5101.55	1
2012	23	2	2306207	3.792009e+07	7428	5105.02	1
2012	22	2	2201988	1.901255e+07	3724	5105.41	1
2012	22	2	2205516	2.447242e+07	4793	5105.87	1
2012	26	2	2606705	3.854694e+07	7549	5106.23	1
2012	26	2	2601300	6.678766e+07	13054	5116.26	1
2012	13	1	1301100	1.714847e+08	33517	5116.35	1
2012	29	2	2904852	9.002088e+07	17582	5120.06	1
2012	26	2	2615805	1.2790768e+08	24973	5121.84	1
2012	23	2	2300150	8.029153e+07	15673	5122.92	1
2012	21	2	2102325	3.4525809e+08	67378	5124.2	1
2012	29	2	2913408	7.809494e+07	15238	5125.01	1
2012	25	2	2508554	2.064711e+07	4026	5128.44	1
2012	25	2	2509909	5.271508e+07	10278	5128.92	1
2012	21	2	2108504	1.621268e+08	31609	5129.13	1
2012	31	3	3136520	2.325455e+07	4532	5131.19	1
2012	15	1	1505650	1.3099714e+08	25526	5131.91	1
2012	26	2	2608404	7.529335e+07	14662	5135.27	1
2012	26	2	2614402	2.967497e+07	5777	5136.74	1
2012	29	2	2933109	4.5005e+07	8759	5138.14	1
2012	26	2	2606507	9.487131e+07	18462	5138.73	1
2012	29	2	2904209	5.629291e+07	10950	5140.91	1
2012	15	1	1508209	2.5228476e+08	49054	5143	1
2012	25	2	2505709	5.371602e+07	10438	5146.2	1
2012	31	3	3100500	5.195784e+07	10093	5147.91	1
2012	26	2	2603207	1.3871881e+08	26946	5148.03	1
2012	21	2	2103406	2.4421507e+08	47435	5148.42	1
2012	24	2	2407708	5.835719e+07	11333	5149.31	1
2012	29	2	2921708	1.8154462e+08	35251	5150.06	1
2012	27	2	2703106	1.2946696e+08	25129	5152.09	1
2012	29	2	2904407	5.798741e+07	11247	5155.81	1
2012	31	3	3150570	3.739553e+07	7251	5157.29	1
2012	26	2	2602506	3.771539e+07	7312	5158.01	1
2012	31	3	3146552	3.069402e+07	5950	5158.66	1
2012	29	2	2930766	6.158751e+07	11930	5162.41	1
2012	22	2	2202653	2.671298e+07	5174	5162.93	1
2012	29	2	2902203	5.41508e+07	10483	5165.58	1
2012	27	2	2702801	6.395461e+07	12378	5166.8	1
2012	23	2	2300804	3.646288e+07	7056	5167.64	1
2012	31	3	3143450	3.926895e+07	7599	5167.65	1
2012	24	2	2402105	5.389614e+07	10427	5168.9	1
2012	25	2	2512804	4.317107e+07	8352	5168.95	1
2012	31	3	3160306	6.058847e+07	11720	5169.66	1
2012	22	2	2203107	5.215894e+07	10089	5169.88	1
2012	24	2	2405306	4.765757e+07	9211	5173.98	1
2012	21	2	2111409	1.0224873e+08	19758	5175.05	1
2012	15	1	1501204	2.031888e+08	39263	5175.07	1
2012	29	2	2919405	6.350325e+07	12268	5176.33	1
2012	15	1	1507102	8.845412e+07	17087	5176.69	1
2012	24	2	2408607	2.071224e+07	4001	5176.77	1
2012	31	3	3140555	4.140858e+07	7994	5179.96	1
2012	21	2	2101004	1.4932054e+08	28809	5183.12	1
2012	22	2	2205359	1.529723e+07	2951	5183.74	1
2012	25	2	2501203	3.391099e+07	6536	5188.34	1
2012	22	2	2203602	2.45856e+07	4738	5189.03	1
2012	25	2	2510204	3.120955e+07	6012	5191.21	1
2012	29	2	2933604	2.3706563e+08	45660	5191.98	1
2012	15	1	1503002	4.100968e+07	7897	5193.07	1
2012	31	3	3171600	7.077604e+07	13611	5199.91	1
2012	22	2	2207751	2.300584e+07	4424	5200.23	1
2012	31	3	3106507	6.344205e+07	12198	5201.02	1
2012	15	1	1507466	2.835081e+07	5451	5201.03	1
2012	29	2	2917102	1.0372267e+08	19942	5201.22	1
2012	15	1	1505700	1.4111567e+08	27103	5206.64	1
2012	29	2	2923605	1.1051667e+08	21226	5206.66	1
2012	29	2	2908804	2.403685e+07	4613	5210.68	1
2012	29	2	2920205	8.368446e+07	16058	5211.39	1
2012	26	2	2607950	5.983304e+07	11479	5212.39	1
2012	23	2	2300705	8.603646e+07	16505	5212.75	1
2012	26	2	2603900	9.751599e+07	18707	5212.81	1
2012	13	1	1300060	5.10612e+07	9794	5213.52	1
2012	25	2	2500536	2.754197e+07	5282	5214.31	1
2012	23	2	2304608	3.349466e+07	6423	5214.8	1
2012	21	2	2105948	4.039292e+07	7744	5216.03	1
2012	22	2	2208304	1.4593041e+08	27971	5217.2	1
2012	22	2	2202752	3.232268e+07	6191	5220.91	1
2012	26	2	2608602	6.425733e+07	12307	5221.2	1
2012	24	2	2405009	4.257382e+07	8150	5223.78	1
2012	29	2	2925253	8.112097e+07	15524	5225.52	1
2012	31	3	3122454	4.888186e+07	9351	5227.45	1
2012	13	1	1300607	1.8271753e+08	34950	5227.97	1
2012	25	2	2508109	2.435114e+07	4657	5228.93	1
2012	25	2	2509396	3.179273e+07	6076	5232.51	1
2012	22	2	2208809	9.193175e+07	17569	5232.61	1
2012	25	2	2513109	6.262252e+07	11966	5233.37	1
2012	17	1	1720200	5.648562e+07	10783	5238.4	1
2012	29	2	2904506	5.489512e+07	10479	5238.58	1
2012	27	2	2703700	2.893928e+07	5524	5238.83	1
2012	31	3	3136504	5.450632e+07	10394	5244.02	1
2012	29	2	2933406	4.714326e+07	8985	5246.88	1
2012	25	2	2513356	1.857171e+07	3538	5249.21	1
2012	26	2	2604908	9.173554e+07	17470	5251.03	1
2012	29	2	2924058	7.200781e+07	13707	5253.36	1
2012	25	2	2500502	7.22025e+07	13740	5254.91	1
2012	29	2	2916609	5.35205e+07	10181	5256.9	1
2012	25	2	2511509	5.956554e+07	11330	5257.33	1
2012	15	1	1504950	1.0702421e+08	20350	5259.17	1
2012	13	1	1300680	8.235694e+07	15659	5259.4	1
2012	25	2	2510402	3.575587e+07	6796	5261.31	1
2012	13	1	1301605	1.2212705e+08	23198	5264.55	1
2012	23	2	2311207	5.503344e+07	10448	5267.37	1
2012	24	2	2406304	3.730174e+07	7079	5269.35	1
2012	21	2	2101608	4.4374085e+08	84180	5271.33	1
2012	15	1	1505494	3.935332e+07	7465	5271.71	1
2012	25	2	2513505	2.776621e+07	5265	5273.73	1
2012	25	2	2509156	3.302452e+07	6257	5278.01	1
2012	31	3	3146206	3.159379e+07	5985	5278.83	1
2012	26	2	2614709	6.703636e+07	12695	5280.53	1
2012	29	2	2905107	5.291181e+07	10013	5284.31	1
2012	31	3	3147956	2.981455e+07	5642	5284.39	1
2012	21	2	2109270	9.346811e+07	17686	5284.86	1
2012	24	2	2402808	2.856505e+07	5405	5284.93	1
2012	23	2	2306702	9.427871e+07	17839	5284.98	1
2012	27	2	2705507	1.4291993e+08	27030	5287.46	1
2012	29	2	2920403	7.378681e+07	13948	5290.14	1
2012	21	2	2112233	1.0244514e+08	19339	5297.33	1
2012	25	2	2513604	3.802328e+07	7173	5300.89	1
2012	15	1	1502509	1.1428222e+08	21557	5301.4	1
2012	22	2	2205706	1.5400115e+08	29034	5304.17	1
2012	13	1	1304401	9.90875e+07	18679	5304.75	1
2012	21	2	2108900	1.0167266e+08	19165	5305.12	1
2012	22	2	2203701	2.033131e+08	38322	5305.39	1
2012	27	2	2707602	6.011602e+07	11330	5305.92	1
2012	31	3	3142254	2.443279e+07	4604	5306.86	1
2012	15	1	1501808	5.0302354e+08	94779	5307.33	1
2012	31	3	3109253	2.122672e+07	3999	5308.01	1
2012	26	2	2604700	9.22236e+07	17374	5308.14	1
2012	31	3	3170909	1.0148449e+08	19108	5311.1	1
2012	26	2	2604304	5.823925e+07	10964	5311.86	1
2012	22	2	2205904	2.77455e+07	5223	5312.18	1
2012	26	2	2615201	5.064906e+07	9534	5312.47	1
2012	27	2	2708204	3.584011e+07	6744	5314.37	1
2012	29	2	2926509	7.617678e+07	14333	5314.78	1
2012	29	2	2904803	5.622135e+07	10576	5315.94	1
2012	26	2	2614006	9.846312e+07	18519	5316.87	1
2012	24	2	2403202	3.69737e+07	6954	5316.9	1
2012	13	1	1300201	8.468342e+07	15924	5317.97	1
2012	13	1	1300300	1.7721496e+08	33312	5319.85	1
2012	25	2	2516805	4.919169e+07	9246	5320.32	1
2012	26	2	2604205	2.0649328e+08	38812	5320.35	1
2012	13	1	1303502	9.751964e+07	18329	5320.51	1
2012	26	2	2610103	4.349321e+07	8172	5322.22	1
2012	27	2	2701506	4.939052e+07	9273	5326.27	1
2012	25	2	2506103	6.037464e+07	11332	5327.8	1
2012	25	2	2508703	2.130732e+07	3999	5328.16	1
2012	25	2	2511806	5.512963e+07	10346	5328.59	1
2012	26	2	2612307	8.18943e+07	15355	5333.4	1
2012	24	2	2400901	3.698441e+07	6930	5336.86	1
2012	25	2	2502003	3.823887e+07	7163	5338.39	1
2012	31	3	3127057	2.486052e+07	4655	5340.61	1
2012	31	3	3166501	2.255994e+07	4224	5340.89	1
2012	22	2	2207306	2.162693e+07	4049	5341.3	1
2012	22	2	2202604	9.796703e+07	18336	5342.88	1
2012	29	2	2933000	1.3553574e+08	25342	5348.27	1
2012	22	2	2205508	2.0183241e+08	37724	5350.24	1
2012	29	2	2929701	1.0215696e+08	19054	5361.44	1
2012	29	2	2914505	1.4914792e+08	27814	5362.33	1
2012	15	1	1505007	7.515128e+07	14012	5363.35	1
2012	21	2	2109205	6.382251e+07	11897	5364.59	1
2012	29	2	2920809	5.608772e+07	10447	5368.79	1
2012	23	2	2304806	2.443514e+07	4551	5369.18	1
2012	31	3	3122207	3.820392e+07	7114	5370.25	1
2012	26	2	2605400	1.1187928e+08	20830	5371.06	1
2012	29	2	2926004	2.1147181e+08	39365	5372.08	1
2012	31	3	3138682	3.462478e+07	6443	5374.01	1
2012	24	2	2409704	3.78601e+07	7045	5374.04	1
2012	25	2	2509602	2.455137e+07	4568	5374.64	1
2012	25	2	2513158	3.511603e+07	6533	5375.18	1
2012	24	2	2407252	1.949116e+07	3625	5376.87	1
2012	25	2	2512036	2.011579e+07	3740	5378.55	1
2012	25	2	2505303	1.34346e+07	2497	5380.3	1
2012	22	2	2205276	2.533309e+07	4708	5380.86	1
2012	28	2	2802700	4.498165e+07	8359	5381.22	1
2012	13	1	1301654	7.746829e+07	14396	5381.24	1
2012	13	1	1303957	6.050763e+07	11241	5382.76	1
2012	31	3	3156502	3.986907e+07	7406	5383.35	1
2012	26	2	2616506	7.627875e+07	14168	5383.88	1
2012	25	2	2512721	3.13626e+07	5824	5385.06	1
2012	26	2	2612703	7.11736e+07	13215	5385.82	1
2012	24	2	2412906	5.835555e+07	10832	5387.33	1
2012	15	1	1504901	1.9139619e+08	35524	5387.8	1
2012	21	2	2102754	5.777705e+07	10722	5388.64	1
2012	26	2	2602209	2.0455927e+08	37949	5390.37	1
2012	23	2	2312601	6.719105e+07	12459	5392.97	1
2012	25	2	2501708	3.063118e+07	5679	5393.76	1
2012	29	2	2918357	1.2452402e+08	23066	5398.6	1
2012	31	3	3158102	2.840248e+07	5261	5398.68	1
2012	31	3	3105509	3.047925e+07	5643	5401.25	1
2012	23	2	2308351	7.0552e+07	13062	5401.32	1
2012	25	2	2510006	3.918082e+07	7252	5402.76	1
2012	25	2	2509404	7.120347e+07	13178	5403.21	1
2012	31	3	3144656	5.342308e+07	9885	5404.46	1
2012	22	2	2209401	3.316592e+07	6136	5405.14	1
2012	15	1	1501576	8.449322e+07	15629	5406.18	1
2012	24	2	2413706	2.76105e+07	5107	5406.4	1
2012	22	2	2210938	3.465285e+07	6409	5406.9	1
2012	21	2	2104073	4.442523e+07	8215	5407.82	1
2012	21	2	2101939	3.304844e+07	6111	5408.02	1
2012	29	2	2910909	2.931056e+07	5417	5410.85	1
2012	21	2	2100808	7.842091e+07	14492	5411.32	1
2012	29	2	2930154	1.7067648e+08	31525	5414	1
2012	25	2	2504157	3.866643e+07	7132	5421.54	1
2012	24	2	2413557	2.481771e+07	4577	5422.27	1
2012	24	2	2400307	5.87937e+07	10841	5423.27	1
2012	21	2	2108009	1.0017803e+08	18461	5426.47	1
2012	26	2	2611200	5.986905e+07	11029	5428.33	1
2012	27	2	2701209	5.595023e+07	10307	5428.37	1
2012	25	2	2514206	4.104515e+07	7560	5429.25	1
2012	24	2	2411007	2.39547e+07	4411	5430.67	1
2012	25	2	2502805	7.231136e+07	13313	5431.64	1
2012	29	2	2908903	1.2030805e+08	22149	5431.76	1
2012	13	1	1300029	7.812055e+07	14381	5432.21	1
2012	26	2	2600500	2.2153729e+08	40778	5432.76	1
2012	25	2	2510105	5.715552e+07	10514	5436.13	1
2012	23	2	2301851	9.508997e+07	17488	5437.44	1
2012	31	3	3141702	3.242723e+07	5963	5438.07	1
2012	23	2	2305803	2.2097929e+08	40579	5445.66	1
2012	22	2	2210102	2.005708e+07	3682	5447.33	1
2012	29	2	2911006	5.80694e+07	10657	5448.94	1
2012	25	2	2509370	1.496197e+07	2744	5452.61	1
2012	29	2	2918100	2.0809246e+08	38163	5452.73	1
2012	31	3	3133907	3.114656e+07	5711	5453.78	1
2012	15	1	1503309	3.2143169e+08	58904	5456.87	1
2012	25	2	2515203	1.793733e+07	3287	5457.05	1
2012	22	2	2210052	2.831892e+07	5189	5457.49	1
2012	23	2	2305308	1.3146915e+08	24058	5464.67	1
2012	21	2	2105989	3.883367e+07	7106	5464.91	1
2012	31	3	3142007	7.172268e+07	13116	5468.33	1
2012	21	2	2110005	4.099033e+08	74943	5469.53	1
2012	29	2	2923209	1.1931596e+08	21813	5469.95	1
2012	29	2	2928059	7.124778e+07	13025	5470.08	1
2012	25	2	2509800	5.220629e+07	9542	5471.21	1
2012	31	3	3155108	2.840307e+07	5191	5471.6	1
2012	25	2	2501005	1.0447897e+08	19076	5476.99	1
2012	31	3	3136009	8.215617e+07	15000	5477.08	1
2012	13	1	1300631	8.850166e+07	16158	5477.27	1
2012	31	3	3152170	6.282693e+07	11469	5477.98	1
2012	21	2	2103208	4.1176911e+08	75167	5478.06	1
2012	25	2	2505600	3.60084e+07	6571	5479.9	1
2012	25	2	2507309	7.670968e+07	13991	5482.79	1
2012	29	2	2911253	2.473605e+07	4510	5484.71	1
2012	29	2	2924306	9.467789e+07	17257	5486.35	1
2012	22	2	2204352	2.873646e+07	5237	5487.2	1
2012	29	2	2910206	2.136772e+07	3894	5487.35	1
2012	22	2	2207934	1.341728e+07	2445	5487.64	1
2012	24	2	2414704	2.894278e+07	5271	5490.95	1
2012	29	2	2908002	1.095078e+08	19937	5492.69	1
2012	31	3	3120870	3.875363e+07	7055	5493.07	1
2012	25	2	2513307	3.235254e+07	5886	5496.52	1
2012	31	3	3153103	3.018742e+07	5491	5497.62	1
2012	13	1	1302900	2.9731948e+08	54079	5497.87	1
2012	24	2	2413102	3.150138e+07	5729	5498.58	1
2012	24	2	2406007	3.224071e+07	5862	5499.95	1
2012	31	3	3128204	5.62454e+07	10218	5504.54	1
2012	24	2	2409803	7.822858e+07	14204	5507.5	1
2012	25	2	2504504	3.63392e+07	6598	5507.61	1
2012	29	2	2925758	1.3506535e+08	24517	5509.05	1
2012	21	2	2109601	2.2297287e+08	40469	5509.72	1
2012	15	1	1504406	1.4820048e+08	26890	5511.36	1
2012	26	2	2614303	6.075188e+07	11020	5512.88	1
2012	31	3	3170651	2.632725e+07	4775	5513.56	1
2012	27	2	2700706	9.60479e+07	17420	5513.66	1
2012	25	2	2517001	5.350192e+07	9698	5516.8	1
2012	23	2	2305605	1.4141442e+08	25620	5519.69	1
2012	29	2	2921203	1.4455903e+08	26188	5520.05	1
2012	29	2	2930907	6.315475e+07	11433	5523.9	1
2012	29	2	2909604	1.1159882e+08	20199	5524.97	1
2012	31	3	3121803	4.708081e+07	8520	5525.92	1
2012	15	1	1500107	7.9805328e+08	144415	5526.11	1
2012	27	2	2705606	6.813538e+07	12303	5538.11	1
2012	31	3	3119203	5.64842e+07	10190	5543.1	1
2012	29	2	2917334	6.078411e+07	10963	5544.48	1
2012	28	2	2805406	1.7544181e+08	31614	5549.5	1
2012	15	1	1507706	1.3152027e+08	23696	5550.32	1
2012	29	2	2923803	1.5525413e+08	27958	5553.12	1
2012	24	2	2407005	5.375614e+07	9679	5553.89	1
2012	24	2	2406155	2.020027e+07	3635	5557.16	1
2012	22	2	2205102	5.965113e+07	10728	5560.32	1
2012	23	2	2302701	1.4820763e+08	26648	5561.68	1
2012	23	2	2308104	2.4937434e+08	44836	5561.92	1
2012	25	2	2515005	3.775999e+07	6789	5561.94	1
2012	29	2	2909505	2.807737e+07	5048	5562.08	1
2012	25	2	2507705	9.493075e+07	17064	5563.22	1
2012	25	2	2508802	3.118448e+07	5602	5566.67	1
2012	21	2	2112407	1.9123884e+08	34333	5570.12	1
2012	31	3	3107802	8.495925e+07	15242	5574.02	1
2012	24	2	2405108	3.812248e+07	6838	5575.09	1
2012	25	2	2501534	2.441652e+07	4379	5575.82	1
2012	31	3	3129301	5.804829e+07	10406	5578.35	1
2012	26	2	2608008	9.048218e+07	16219	5578.78	1
2012	29	2	2926707	7.192573e+07	12891	5579.53	1
2012	25	2	2502409	6.162036e+07	11042	5580.54	1
2012	23	2	2309201	8.142226e+07	14586	5582.22	1
2012	31	3	3134004	8.088898e+07	14485	5584.33	1
2012	29	2	2916203	5.8294e+07	10436	5585.86	1
2012	31	3	3156007	7.516054e+07	13455	5586.07	1
2012	29	2	2932804	1.0259991e+08	18367	5586.1	1
2012	21	2	2110708	1.8823537e+08	33692	5586.95	1
2012	29	2	2903805	1.0004484e+08	17898	5589.72	1
2012	31	3	3157500	2.546922e+07	4552	5595.17	1
2012	25	2	2510303	2.507286e+07	4480	5596.62	1
2012	25	2	2513968	1.628118e+07	2909	5596.83	1
2012	29	2	2928000	1.9188634e+08	34274	5598.6	1
2012	26	2	2606309	3.901361e+07	6968	5598.97	1
2012	15	1	1508308	3.227654e+08	57566	5606.88	1
2012	31	3	3137007	9.627539e+07	17170	5607.19	1
2012	31	3	3135803	1.3635196e+08	24317	5607.27	1
2012	31	3	3132305	6.706095e+07	11957	5608.51	1
2012	24	2	2411700	2.246493e+07	4005	5609.22	1
2012	29	2	2912004	5.39108e+07	9607	5611.62	1
2012	25	2	2509107	1.1935645e+08	21254	5615.72	1
2012	24	2	2401701	5.376004e+07	9566	5619.91	1
2012	21	2	2106359	4.358305e+07	7751	5622.89	1
2012	27	2	2704401	1.0733029e+08	19087	5623.21	1
2012	26	2	2613305	1.1577091e+08	20586	5623.77	1
2012	25	2	2502300	2.812377e+07	4998	5627.01	1
2012	24	2	2407302	4.642302e+07	8249	5627.71	1
2012	23	2	2311702	1.0794089e+08	19179	5628.08	1
2012	29	2	2912103	1.3265332e+08	23560	5630.45	1
2012	24	2	2414753	2.186219e+07	3882	5631.68	1
2012	13	1	1300508	1.5817881e+08	28077	5633.75	1
2012	23	2	2309300	1.7588523e+08	31210	5635.54	1
2012	15	1	1503077	1.4178075e+08	25157	5635.84	1
2012	21	2	2110807	2.613031e+07	4636	5636.39	1
2012	15	1	1502855	7.166224e+07	12712	5637.37	1
2012	25	2	2504405	1.0394404e+08	18429	5640.24	1
2012	21	2	2105500	1.3290594e+08	23561	5640.93	1
2012	26	2	2608107	1.766038e+08	31305	5641.39	1
2012	23	2	2311355	8.42061e+07	14911	5647.25	1
2012	15	1	1501758	4.122254e+07	7295	5650.79	1
2012	29	2	2908309	1.0005541e+08	17705	5651.25	1
2012	25	2	2503407	2.029237e+07	3590	5652.47	1
2012	31	3	3170529	8.039922e+07	14207	5659.13	1
2012	31	3	3131158	9.642902e+07	17037	5659.98	1
2012	29	2	2931608	7.989815e+07	14113	5661.32	1
2012	23	2	2305407	3.7310936e+08	65900	5661.75	1
2012	31	3	3104452	2.746e+07	4848	5664.19	1
2012	29	2	2927804	3.672457e+07	6481	5666.5	1
2012	15	1	1502004	1.1990783e+08	21147	5670.21	1
2012	24	2	2410306	5.123941e+07	9035	5671.21	1
2012	26	2	2600708	2.1248852e+08	37450	5673.93	1
2012	26	2	2614600	1.5199066e+08	26784	5674.68	1
2012	24	2	2400604	2.736924e+07	4823	5674.73	1
2012	29	2	2923902	5.947432e+07	10479	5675.57	1
2012	21	2	2100436	1.4384841e+08	25326	5679.87	1
2012	24	2	2406205	3.58975e+07	6318	5681.78	1
2012	25	2	2511004	2.117449e+07	3726	5682.9	1
2012	26	2	2613503	1.8619561e+08	32763	5683.11	1
2012	25	2	2516508	8.434582e+07	14833	5686.36	1
2012	26	2	2611507	1.3930983e+08	24495	5687.28	1
2012	21	2	2103505	2.2542407e+08	39635	5687.5	1
2012	25	2	2500205	3.136241e+07	5514	5687.78	1
2012	25	2	2505501	2.033067e+07	3572	5691.68	1
2012	31	3	3125606	3.974408e+07	6974	5698.89	1
2012	13	1	1303007	1.0671137e+08	18720	5700.39	1
2012	27	2	2705309	2.996841e+07	5251	5707.18	1
2012	31	3	3170578	3.680822e+07	6449	5707.59	1
2012	26	2	2606101	1.6698093e+08	29241	5710.51	1
2012	31	3	3118106	2.827698e+07	4950	5712.52	1
2012	29	2	2908606	1.3777674e+08	24103	5716.17	1
2012	31	3	3112653	2.869036e+07	5019	5716.35	1
2012	24	2	2406601	4.3974e+07	7679	5726.53	1
2012	29	2	2926301	1.9053578e+08	33271	5726.78	1
2012	23	2	2308401	1.9775194e+08	34529	5727.13	1
2012	31	3	3169505	3.644468e+07	6363	5727.59	1
2012	29	2	2930303	1.0298341e+08	17963	5733.09	1
2012	29	2	2916708	4.44398e+07	7751	5733.43	1
2012	15	1	1503705	2.9510087e+08	51457	5734.9	1
2012	25	2	2502052	1.808425e+07	3153	5735.57	1
2012	29	2	2907202	3.8045025e+08	66331	5735.63	1
2012	25	2	2504900	9.365241e+07	16317	5739.56	1
2012	22	2	2209757	1.665081e+07	2901	5739.68	1
2012	25	2	2515807	4.026242e+07	7012	5741.93	1
2012	27	2	2702207	3.208083e+07	5586	5743.08	1
2012	26	2	2612406	1.315431e+08	22896	5745.24	1
2012	26	2	2608057	8.098057e+07	14087	5748.6	1
2012	24	2	2400505	7.749815e+07	13467	5754.67	1
2012	26	2	2603306	6.36151e+07	11051	5756.5	1
2012	35	3	3504701	2.339597e+07	4063	5758.3	1
2012	15	1	1502301	3.0082954e+08	52214	5761.47	1
2012	25	2	2501609	8.304317e+07	14413	5761.69	1
2012	29	2	2923357	9.554589e+07	16578	5763.41	1
2012	17	1	1703800	5.797676e+07	10059	5763.67	1
2012	31	3	3150802	9.953007e+07	17266	5764.51	1
2012	26	2	2607505	1.5111968e+08	26175	5773.44	1
2012	21	2	2111052	6.287062e+07	10882	5777.49	1
2012	31	3	3115474	2.928616e+07	5067	5779.78	1
2012	28	2	2805109	5.184794e+07	8970	5780.15	1
2012	29	2	2926657	6.030825e+07	10432	5781.08	1
2012	27	2	2705200	9.420849e+07	16292	5782.5	1
2012	31	3	3117009	4.634625e+07	8011	5785.33	1
2012	24	2	2405900	1.506426e+07	2602	5789.49	1
2012	29	2	2931905	3.0534476e+08	52734	5790.28	1
2012	31	3	3161106	3.1382979e+08	54180	5792.35	1
2012	21	2	2105401	3.7035617e+08	63907	5795.24	1
2012	31	3	3120151	3.573131e+07	6161	5799.6	1
2012	25	2	2504074	2.291441e+07	3951	5799.65	1
2012	24	2	2410504	2.761141e+07	4760	5800.72	1
2012	29	2	2911501	4.660001e+07	8031	5802.52	1
2012	26	2	2609907	3.8033544e+08	65510	5805.76	1
2012	25	2	2511707	2.969951e+07	5114	5807.49	1
2012	31	3	3166204	5.940223e+07	10222	5811.21	1
2012	25	2	2512747	1.940027e+07	3338	5811.94	1
2012	23	2	2306009	8.032792e+07	13808	5817.49	1
2012	31	3	3145877	4.313027e+07	7409	5821.33	1
2012	25	2	2506202	1.708687e+07	2935	5821.76	1
2012	15	1	1503200	2.1204323e+08	36414	5823.12	1
2012	31	3	3163003	2.389905e+07	4103	5824.78	1
2012	23	2	2304509	7.670841e+07	13167	5825.81	1
2012	29	2	2932101	1.2068753e+08	20714	5826.38	1
2012	31	3	3141801	1.7983731e+08	30852	5829.03	1
2012	29	2	2931301	9.584882e+07	16434	5832.35	1
2012	31	3	3106606	2.630508e+07	4508	5835.2	1
2012	26	2	2615706	8.75011e+07	14987	5838.47	1
2012	17	1	1712405	2.171102e+07	3716	5842.58	2
2012	29	2	2926103	7.17554e+07	12281	5842.8	2
2012	29	2	2902401	7.633133e+07	13059	5845.11	2
2012	17	1	1703008	6.102601e+07	10439	5845.96	2
2012	29	2	2910701	3.3306939e+08	56962	5847.22	2
2012	24	2	2401305	5.463331e+07	9330	5855.66	2
2012	15	1	1507805	7.402696e+07	12641	5856.1	2
2012	15	1	1507003	1.622923e+08	27707	5857.45	2
2012	23	2	2302800	4.4071181e+08	75209	5859.83	2
2012	29	2	2902807	1.2169473e+08	20767	5860.01	2
2012	21	2	2104677	1.4844151e+08	25323	5861.92	2
2012	22	2	2211100	2.5260909e+08	43085	5863.04	2
2012	28	2	2801603	3.327738e+07	5672	5866.96	2
2012	25	2	2512754	2.533078e+07	4312	5874.48	2
2012	29	2	2911907	1.4875759e+08	25319	5875.33	2
2012	15	1	1507904	1.3785833e+08	23461	5876.06	2
2012	31	3	3152204	2.2087372e+08	37588	5876.18	2
2012	29	2	2918704	2.251877e+07	3830	5879.57	2
2012	31	3	3127503	3.502209e+07	5953	5883.1	2
2012	26	2	2607000	1.1742539e+08	19957	5883.92	2
2012	15	1	1507508	7.822895e+07	13293	5884.97	2
2012	25	2	2507408	4.448173e+07	7557	5886.16	2
2012	29	2	2931053	9.610313e+07	16323	5887.59	2
2012	35	3	3540853	1.809899e+07	3074	5887.77	2
2012	25	2	2510501	2.175529e+07	3693	5890.95	2
2012	27	2	2701407	3.0831493e+08	52327	5892.08	2
2012	31	3	3156601	5.872565e+07	9958	5897.33	2
2012	27	2	2702009	6.349647e+07	10765	5898.42	2
2012	24	2	2410207	4.369735e+07	7407	5899.47	2
2012	31	3	3106655	2.616883e+07	4431	5905.85	2
2012	25	2	2513208	3.824905e+07	6471	5910.84	2
2012	21	2	2102036	1.7885971e+08	30259	5910.96	2
2012	29	2	2929354	3.31715e+07	5609	5913.98	2
2012	15	1	1504109	4.837067e+07	8179	5914.01	2
2012	13	1	1300805	2.1249598e+08	35919	5915.98	2
2012	25	2	2517407	1.249381e+07	2109	5924.05	2
2012	25	2	2504801	8.976401e+07	15152	5924.23	2
2012	27	2	2702603	1.264572e+08	21342	5925.27	2
2012	29	2	2916906	7.461319e+07	12589	5926.86	2
2012	26	2	2610301	6.579921e+07	11100	5927.86	2
2012	25	2	2505006	4.114366e+07	6939	5929.34	2
2012	25	2	2503902	3.435173e+07	5793	5929.87	2
2012	29	2	2922409	1.2819578e+08	21608	5932.79	2
2012	31	3	3134707	7.204317e+07	12142	5933.39	2
2012	27	2	2700508	8.70363e+07	14665	5934.97	2
2012	17	1	1718808	2.390967e+07	4025	5940.29	2
2012	24	2	2402907	2.842517e+07	4783	5942.96	2
2012	15	1	1507953	5.0856061e+08	85468	5950.3	2
2012	22	2	2202083	4.365668e+07	7321	5963.21	2
2012	25	2	2513927	2.518093e+07	4221	5965.63	2
2012	26	2	2608255	6.410942e+07	10742	5968.11	2
2012	24	2	2404606	7.441435e+07	12462	5971.3	2
2012	29	2	2927507	1.1530248e+08	19292	5976.7	2
2012	29	2	2920502	1.4970068e+08	25024	5982.28	2
2012	31	3	3145372	3.002238e+07	5017	5984.13	2
2012	26	2	2610806	1.2596964e+08	21050	5984.31	2
2012	25	2	2512309	1.3012569e+08	21744	5984.44	2
2012	21	2	2111102	1.4995054e+08	25056	5984.62	2
2012	25	2	2502607	3.671808e+07	6134	5985.99	2
2012	24	2	2411908	2.356143e+07	3934	5989.18	2
2012	25	2	2502201	1.456738e+07	2432	5989.88	2
2012	23	2	2313302	3.3728335e+08	56307	5990.08	2
2012	31	3	3116803	5.378246e+07	8972	5994.48	2
2012	25	2	2506806	1.0523793e+08	17555	5994.76	2
2012	25	2	2500809	1.0248286e+08	17093	5995.6	2
2012	26	2	2616209	1.1223883e+08	18716	5996.95	2
2012	29	2	2901403	8.392528e+07	13992	5998.09	2
2012	26	2	2613206	1.2938695e+08	21549	6004.31	2
2012	27	2	2702900	2.2733824e+08	37858	6005.03	2
2012	24	2	2414803	6.63898e+07	11051	6007.58	2
2012	25	2	2512705	1.0862705e+08	18075	6009.8	2
2012	29	2	2933174	5.401351e+07	8987	6010.18	2
2012	24	2	2401602	3.111267e+07	5175	6012.11	2
2012	31	3	3130655	4.403602e+07	7316	6019.14	2
2012	27	2	2702355	1.3800256e+08	22921	6020.79	2
2012	22	2	2202307	1.2271237e+08	20375	6022.69	2
2012	25	2	2504207	2.905389e+07	4822	6025.28	2
2012	26	2	2600203	1.0833133e+08	17975	6026.78	2
2012	31	3	3144201	1.904572e+07	3159	6029.04	2
2012	24	2	2410801	2.503482e+07	4150	6032.49	2
2012	25	2	2515500	7.909235e+07	13101	6037.12	2
2012	23	2	2304103	4.413454e+08	73102	6037.39	2
2012	27	2	2704906	2.166262e+07	3588	6037.52	2
2012	26	2	2603801	1.1842786e+08	19599	6042.55	2
2012	21	2	2114007	2.9824382e+08	49355	6042.83	2
2012	25	2	2513943	1.484354e+07	2455	6046.25	2
2012	27	2	2707503	1.1662695e+08	19288	6046.61	2
2012	25	2	2510907	7.17701e+07	11867	6047.87	2
2012	22	2	2211605	1.808342e+07	2990	6047.97	2
2012	22	2	2210805	7.410254e+07	12251	6048.69	2
2012	31	3	3126950	2.027617e+07	3350	6052.59	2
2012	24	2	2410702	1.961723e+07	3241	6052.83	2
2012	26	2	2601003	6.279218e+07	10372	6054.01	2
2012	26	2	2609303	8.773381e+07	14488	6055.62	2
2012	28	2	2802403	6.917897e+07	11412	6061.95	2
2012	25	2	2505907	2.034417e+07	3356	6062.03	2
2012	25	2	2512762	2.567273e+07	4235	6062.04	2
2012	17	1	1707405	5.914507e+07	9756	6062.43	2
2012	25	2	2508208	4.495705e+07	7413	6064.62	2
2012	25	2	2513802	2.765963e+07	4559	6067.04	2
2012	29	2	2908200	1.2642133e+08	20826	6070.36	2
2012	15	1	1506401	5.216518e+07	8593	6070.66	2
2012	29	2	2919702	1.0477278e+08	17253	6072.73	2
2012	25	2	2505105	1.2137021e+08	19983	6073.67	2
2012	31	3	3162708	1.3677561e+08	22517	6074.33	2
2012	24	2	2413508	3.937082e+07	6480	6075.74	2
2012	26	2	2602803	3.2391426e+08	53304	6076.73	2
2012	26	2	2613107	2.1612174e+08	35554	6078.69	2
2012	31	3	3142908	1.3202934e+08	21717	6079.54	2
2012	25	2	2502904	3.795849e+07	6236	6086.99	2
2012	25	2	2500304	1.7272444e+08	28375	6087.2	2
2012	52	5	5221080	1.876424e+07	3082	6088.33	2
2012	21	2	2108603	4.8470974e+08	79566	6091.92	2
2012	17	1	1718303	4.747874e+07	7792	6093.27	2
2012	26	2	2603405	3.439984e+07	5643	6096.02	2
2012	28	2	2804201	8.497232e+07	13936	6097.32	2
2012	31	3	3119500	5.558295e+07	9115	6097.96	2
2012	26	2	2604601	1.5045148e+08	24658	6101.53	2
2012	24	2	2414100	6.124098e+07	10036	6102.13	2
2012	25	2	2501104	1.427512e+08	23391	6102.83	2
2012	31	3	3148400	2.985537e+07	4889	6106.64	2
2012	15	1	1503408	6.346685e+07	10393	6106.69	2
2012	29	2	2906303	1.9493837e+08	31902	6110.54	2
2012	24	2	2406809	2.826619e+07	4625	6111.61	2
2012	24	2	2413003	3.720917e+07	6088	6111.89	2
2012	31	3	3136959	3.484621e+07	5697	6116.59	2
2012	31	3	3148509	5.224779e+07	8541	6117.29	2
2012	29	2	2901957	4.525674e+07	7397	6118.26	2
2012	23	2	2305001	2.3366e+08	38189	6118.52	2
2012	24	2	2407401	5.074552e+07	8293	6119.08	2
2012	29	2	2928208	1.5290166e+08	24987	6119.25	2
2012	15	1	1507151	1.4446958e+08	23602	6121.07	2
2012	52	5	5215231	6.009668e+08	98135	6123.88	2
2012	31	3	3146305	1.167062e+08	19057	6124.06	2
2012	21	2	2110609	1.6569685e+08	27044	6126.94	2
2012	22	2	2210003	1.2171662e+08	19852	6131.2	2
2012	51	5	5100508	6.313167e+07	10290	6135.25	2
2012	15	1	1507409	9.322243e+07	15184	6139.52	2
2012	27	2	2704104	1.1044668e+08	17988	6140.02	2
2012	29	2	2915700	4.811451e+07	7836	6140.19	2
2012	29	2	2922730	4.684974e+07	7630	6140.2	2
2012	31	3	3142700	9.598607e+07	15631	6140.75	2
2012	29	2	2909109	8.727179e+07	14210	6141.58	2
2012	29	2	2912707	1.3958092e+08	22683	6153.55	2
2012	26	2	2607307	1.7776093e+08	28887	6153.67	2
2012	13	1	1302108	4.584919e+07	7448	6155.91	2
2012	29	2	2909406	8.384171e+07	13614	6158.49	2
2012	28	2	2806404	4.419307e+07	7175	6159.31	2
2012	24	2	2413607	3.602707e+07	5848	6160.58	2
2012	26	2	2608305	8.564844e+07	13899	6162.2	2
2012	17	1	1720804	5.605997e+07	9097	6162.47	2
2012	24	2	2408409	2.63252e+07	4270	6165.15	2
2012	23	2	2312205	2.6412437e+08	42822	6167.96	2
2012	31	3	3122108	3.043291e+07	4933	6169.25	2
2012	29	2	2912301	9.66073e+07	15650	6172.99	2
2012	31	3	3152402	9.753976e+07	15801	6173.01	2
2012	26	2	2603504	1.0744309e+08	17405	6173.12	2
2012	29	2	2915106	7.907477e+07	12805	6175.3	2
2012	26	2	2600401	2.0880159e+08	33785	6180.3	2
2012	29	2	2910750	1.0850899e+08	17555	6181.09	2
2012	29	2	2929107	1.2565733e+08	20329	6181.19	2
2012	22	2	2201408	4.067625e+07	6580	6181.8	2
2012	24	2	2410405	5.345865e+07	8645	6183.76	2
2012	25	2	2513653	1.622093e+07	2623	6184.11	2
2012	26	2	2614105	2.1099971e+08	34109	6186.04	2
2012	13	1	1301001	1.6191411e+08	26130	6196.48	2
2012	24	2	2407807	1.2988841e+08	20959	6197.26	2
2012	24	2	2411106	2.21999e+07	3582	6197.63	2
2012	17	1	1711951	2.279079e+07	3676	6199.89	2
2012	24	2	2411502	1.3973067e+08	22535	6200.61	2
2012	27	2	2700201	1.0764489e+08	17360	6200.74	2
2012	29	2	2906006	4.1744858e+08	67305	6202.34	2
2012	25	2	2513984	2.0772e+07	3349	6202.45	2
2012	24	2	2407500	6.704998e+07	10810	6202.59	2
2012	31	3	3124302	1.9313638e+08	31134	6203.39	2
2012	31	3	3159100	2.360823e+07	3804	6206.16	2
2012	24	2	2412807	5.02719e+07	8098	6207.94	2
2012	23	2	2301406	7.084516e+07	11404	6212.31	2
2012	26	2	2600906	1.3695497e+08	22035	6215.34	2
2012	27	2	2703304	1.109022e+08	17839	6216.84	2
2012	21	2	2101509	1.1113006e+08	17862	6221.59	2
2012	31	3	3111150	2.304884e+07	3701	6227.73	2
2012	24	2	2410603	1.918495e+07	3080	6228.88	2
2012	26	2	2611705	1.2076118e+08	19387	6228.98	2
2012	17	1	1703891	2.341962e+07	3759	6230.28	2
2012	29	2	2925105	2.8647885e+08	45903	6240.96	2
2012	29	2	2919009	2.422942e+07	3881	6243.09	2
2012	23	2	2310852	1.2017728e+08	19247	6243.95	2
2012	15	1	1507201	1.8872506e+08	30215	6246.07	2
2012	25	2	2500775	4.892037e+07	7832	6246.22	2
2012	25	2	2501906	1.072318e+08	17167	6246.39	2
2012	31	3	3151909	5.531897e+07	8856	6246.5	2
2012	26	2	2607109	2.803133e+07	4486	6248.63	2
2012	31	3	3125408	3.158676e+07	5054	6249.85	2
2012	25	2	2507804	4.217238e+07	6745	6252.39	2
2012	27	2	2706802	1.0797608e+08	17268	6252.96	2
2012	25	2	2510600	1.841316e+07	2944	6254.47	2
2012	27	2	2700904	4.06533e+07	6499	6255.32	2
2012	25	2	2515609	1.984379e+07	3169	6261.84	2
2012	25	2	2516151	2.039194e+07	3256	6262.88	2
2012	21	2	2109551	4.663592e+07	7444	6264.9	2
2012	31	3	3100609	9.275796e+07	14803	6266.16	2
2012	26	2	2607604	1.428522e+08	22794	6267.1	2
2012	25	2	2503100	3.226739e+07	5148	6267.95	2
2012	29	2	2904050	9.482474e+07	15126	6268.99	2
2012	29	2	2910404	1.4095282e+08	22478	6270.7	2
2012	31	3	3162609	4.879949e+07	7781	6271.62	2
2012	25	2	2511400	1.1469436e+08	18272	6277.06	2
2012	17	1	1721109	4.32145e+07	6880	6281.18	2
2012	25	2	2503605	4.52679e+07	7205	6282.84	2
2012	31	3	3157377	2.725475e+07	4336	6285.69	2
2012	23	2	2309102	7.467129e+07	11876	6287.58	2
2012	31	3	3167707	3.623177e+07	5762	6288.05	2
2012	15	1	1504976	9.478227e+07	15065	6291.55	2
2012	29	2	2900900	3.856793e+07	6130	6291.67	2
2012	25	2	2506400	8.733249e+07	13877	6293.33	2
2012	13	1	1300086	6.776401e+07	10766	6294.26	2
2012	28	2	2804706	3.947355e+07	6271	6294.62	2
2012	29	2	2920908	8.977381e+07	14257	6296.82	2
2012	21	2	2105427	1.5823524e+08	25125	6297.92	2
2012	25	2	2501500	1.3702631e+08	21753	6299.19	2
2012	24	2	2400406	1.906306e+07	3026	6299.76	2
2012	28	2	2805505	1.4047946e+08	22287	6303.2	2
2012	22	2	2200202	1.0558484e+08	16744	6305.83	2
2012	26	2	2600609	8.665406e+07	13741	6306.24	2
2012	26	2	2615508	8.296676e+07	13155	6306.86	2
2012	29	2	2922607	8.031407e+07	12729	6309.53	2
2012	31	3	3127339	3.23144e+07	5121	6310.17	2
2012	31	3	3158201	9.088474e+07	14402	6310.56	2
2012	31	3	3153905	9.793635e+07	15502	6317.66	2
2012	24	2	2404002	2.641934e+07	4181	6318.9	2
2012	26	2	2616001	1.0632396e+08	16823	6320.15	2
2012	25	2	2501401	5.210892e+07	8243	6321.6	2
2012	31	3	3155603	1.8573978e+08	29381	6321.76	2
2012	23	2	2312700	1.6679075e+08	26382	6322.14	2
2012	29	2	2917805	1.0701854e+08	16927	6322.36	2
2012	31	3	3152303	6.677982e+07	10560	6323.85	2
2012	22	2	2211308	1.2898641e+08	20393	6325.03	2
2012	25	2	2514503	1.2202417e+08	19281	6328.73	2
2012	29	2	2925006	1.5588015e+08	24627	6329.64	2
2012	25	2	2508406	1.772333e+07	2800	6329.76	2
2012	25	2	2507200	6.536804e+07	10326	6330.43	2
2012	29	2	2915809	1.4347173e+08	22650	6334.29	2
2012	25	2	2504033	3.684649e+07	5816	6335.37	2
2012	22	2	2201705	3.390387e+07	5350	6337.17	2
2012	31	3	3121407	4.45665e+07	7032	6337.67	2
2012	29	2	2910776	3.919515e+07	6177	6345.34	2
2012	27	2	2705705	1.2984452e+08	20460	6346.26	2
2012	24	2	2410900	4.611811e+07	7265	6347.99	2
2012	29	2	2919058	5.298469e+07	8346	6348.51	2
2012	25	2	2514404	2.991148e+07	4708	6353.33	2
2012	52	5	5203962	2.104714e+07	3312	6354.81	2
2012	29	2	2916807	1.1854033e+08	18651	6355.71	2
2012	25	2	2506509	2.04345e+07	3215	6355.99	2
2012	15	1	1506351	1.1453117e+08	18012	6358.6	2
2012	22	2	2203404	4.236818e+07	6662	6359.68	2
2012	21	2	2103307	7.5733047e+08	119079	6359.9	2
2012	24	2	2414456	2.11613e+07	3327	6360.48	2
2012	22	2	2206407	6.575612e+07	10337	6361.24	2
2012	31	3	3160207	2.588838e+07	4067	6365.47	2
2012	25	2	2505279	3.305216e+07	5192	6365.98	2
2012	31	3	3141009	8.027511e+07	12609	6366.49	2
2012	31	3	3105202	3.144676e+07	4938	6368.32	2
2012	31	3	3171907	3.561432e+07	5590	6371.08	2
2012	31	3	3102506	3.129687e+07	4910	6374.11	2
2012	24	2	2412104	3.797435e+07	5956	6375.81	2
2012	52	5	5200258	1.06845019e+09	167477	6379.68	2
2012	22	2	2207801	1.272585e+08	19947	6379.83	2
2012	35	3	3522653	2.504844e+07	3926	6380.14	2
2012	31	3	3141504	4.04484e+07	6338	6381.89	2
2012	24	2	2403756	1.842071e+07	2885	6385	2
2012	24	2	2414159	3.550441e+07	5557	6389.13	2
2012	25	2	2514909	4.929394e+07	7708	6395.17	2
2012	24	2	2412500	1.4066649e+08	21994	6395.68	2
2012	25	2	2500700	1.1287e+08	17646	6396.35	2
2012	15	1	1500958	1.7641257e+08	27576	6397.32	2
2012	25	2	2511905	1.1190787e+08	17492	6397.66	2
2012	26	2	2604502	1.3050979e+08	20399	6397.85	2
2012	31	3	3126752	3.652769e+07	5706	6401.63	2
2012	21	2	2110039	1.4756257e+08	23035	6406.02	2
2012	31	3	3117405	2.863457e+07	4468	6408.81	2
2012	31	3	3165503	3.665103e+07	5718	6409.76	2
2012	26	2	2613602	2.063793e+08	32186	6412.08	2
2012	15	1	1503093	2.2640438e+08	35299	6413.9	2
2012	15	1	1500131	4.432765e+07	6905	6419.65	2
2012	22	2	2207009	2.3076215e+08	35931	6422.37	2
2012	31	3	3115458	4.247783e+07	6614	6422.41	2
2012	31	3	3170057	7.769116e+07	12095	6423.41	2
2012	17	1	1718758	4.034352e+07	6279	6425.15	2
2012	31	3	3140308	2.57524e+07	4008	6425.25	2
2012	25	2	2509339	2.803983e+07	4357	6435.58	2
2012	26	2	2603108	1.2284737e+08	19088	6435.84	2
2012	28	2	2805802	1.2501778e+08	19414	6439.57	2
2012	29	2	2919504	2.8057811e+08	43514	6448	2
2012	23	2	2306553	2.4866237e+08	38547	6450.89	2
2012	35	3	3505351	3.422666e+07	5305	6451.77	2
2012	35	3	3513603	1.3995711e+08	21682	6454.99	2
2012	28	2	2805604	1.7672577e+08	27370	6456.92	2
2012	25	2	2511608	4.425966e+07	6854	6457.49	2
2012	25	2	2500734	1.36862e+07	2119	6458.8	2
2012	31	3	3122504	3.341341e+07	5170	6462.94	2
2012	24	2	2403905	1.843886e+07	2852	6465.24	2
2012	23	2	2302107	2.1906307e+08	33863	6469.1	2
2012	26	2	2606606	1.7697517e+08	27349	6470.99	2
2012	31	3	3131802	7.006383e+07	10826	6471.81	2
2012	13	1	1302553	1.5743957e+08	24325	6472.34	2
2012	15	1	1500305	2.3223818e+08	35879	6472.82	2
2012	29	2	2927200	1.9438729e+08	30010	6477.42	2
2012	26	2	2600302	1.495729e+08	23079	6480.91	2
2012	25	2	2516003	1.7063067e+08	26323	6482.19	2
2012	21	2	2100204	1.4005078e+08	21605	6482.33	2
2012	25	2	2507903	6.695886e+07	10327	6483.86	2
2012	29	2	2918308	8.617694e+07	13280	6489.23	2
2012	29	2	2925402	6.075572e+07	9360	6491	2
2012	29	2	2932705	1.2750328e+08	19642	6491.36	2
2012	17	1	1712801	2.078588e+07	3200	6495.59	2
2012	17	1	1717800	2.949457e+07	4540	6496.6	2
2012	17	1	1720309	2.843172e+07	4376	6497.19	2
2012	27	2	2703502	4.516239e+07	6950	6498.19	2
2012	24	2	2408706	2.48511e+07	3824	6498.72	2
2012	31	3	3106804	2.407964e+07	3703	6502.74	2
2012	29	2	2911600	1.296484e+08	19926	6506.49	2
2012	29	2	2914406	1.5125794e+08	23246	6506.84	2
2012	27	2	2707404	5.307025e+07	8156	6506.9	2
2012	25	2	2512077	2.633656e+07	4046	6509.28	2
2012	15	1	1503804	3.4496223e+08	52993	6509.58	2
2012	23	2	2311603	1.7355809e+08	26660	6510.06	2
2012	15	1	1501709	7.564139e+08	116164	6511.6	2
2012	22	2	2208403	4.0440131e+08	62088	6513.36	2
2012	25	2	2516300	1.0563743e+08	16215	6514.8	2
2012	27	2	2701357	4.335817e+07	6655	6515.13	2
2012	22	2	2210623	2.264406e+07	3475	6516.28	2
2012	27	2	2701308	1.3444219e+08	20626	6518.09	2
2012	35	3	3543501	3.916511e+07	6008	6518.83	2
2012	31	3	3119906	2.422991e+07	3716	6520.43	2
2012	29	2	2918803	1.4793866e+08	22679	6523.16	2
2012	27	2	2702108	1.3310615e+08	20401	6524.49	2
2012	25	2	2516706	9.364233e+07	14352	6524.69	2
2012	25	2	2507101	1.1324402e+08	17354	6525.53	2
2012	24	2	2403806	5.852398e+07	8957	6533.88	2
2012	29	2	2909901	2.1326301e+08	32631	6535.6	2
2012	24	2	2401859	3.949569e+07	6043	6535.78	2
2012	17	1	1720002	1.619726e+07	2477	6539.06	2
2012	31	3	3152131	2.625757e+07	4014	6541.5	2
2012	23	2	2309508	1.3939304e+08	21294	6546.12	2
2012	31	3	3163409	3.654672e+07	5580	6549.59	2
2012	24	2	2405504	1.702705e+07	2598	6553.91	2
2012	24	2	2409100	7.554134e+07	11519	6557.98	2
2012	26	2	2608453	1.0763736e+08	16408	6560.05	2
2012	31	3	3163508	4.276849e+07	6518	6561.6	2
2012	23	2	2304459	1.0003847e+08	15233	6567.22	2
2012	31	3	3108602	2.0615427e+08	31356	6574.64	2
2012	31	3	3138351	3.166197e+07	4815	6575.7	2
2012	26	2	2615904	5.228441e+07	7950	6576.66	2
2012	29	2	2917607	3.3966989e+08	51635	6578.29	2
2012	28	2	2805208	4.003055e+07	6084	6579.64	2
2012	17	1	1720101	3.122438e+07	4740	6587.42	2
2012	29	2	2900306	9.710485e+07	14730	6592.32	2
2012	31	3	3126802	3.866545e+07	5865	6592.57	2
2012	31	3	3126901	5.957618e+07	9033	6595.39	2
2012	31	3	3138906	4.609493e+07	6985	6599.13	2
2012	21	2	2103257	9.221538e+07	13963	6604.27	2
2012	31	3	3139201	1.2371751e+08	18705	6614.14	2
2012	31	3	3139300	1.2892315e+08	19489	6615.18	2
2012	15	1	1502756	1.9419998e+08	29313	6625.05	2
2012	25	2	2514701	2.668428e+07	4027	6626.34	2
2012	31	3	3161601	2.846791e+07	4295	6628.15	2
2012	52	5	5219753	4.3073672e+08	64963	6630.49	2
2012	22	2	2205300	2.901701e+07	4372	6637.01	2
2012	27	2	2706448	7.867123e+07	11845	6641.72	2
2012	25	2	2501351	2.396026e+07	3607	6642.71	2
2012	23	2	2302503	3.0711078e+08	46207	6646.41	2
2012	29	2	2901007	2.3159719e+08	34845	6646.5	2
2012	26	2	2601607	1.3468299e+08	20260	6647.73	2
2012	24	2	2412559	5.877374e+07	8835	6652.38	2
2012	27	2	2700102	1.3148591e+08	19763	6653.14	2
2012	29	2	2911402	1.0057387e+08	15114	6654.35	2
2012	24	2	2407906	1.477835e+07	2219	6659.91	2
2012	24	2	2413409	5.19825e+07	7805	6660.15	2
2012	29	2	2922300	1.9280343e+08	28944	6661.26	2
2012	25	2	2501153	1.266639e+07	1901	6663.01	2
2012	31	3	3120839	3.15084e+07	4728	6664.21	2
2012	27	2	2704807	8.933045e+07	13389	6671.93	2
2012	25	2	2515971	4.968776e+07	7447	6672.18	2
2012	29	2	2918555	4.219527e+07	6322	6674.35	2
2012	29	2	2917201	1.2222766e+08	18302	6678.38	2
2012	29	2	2927101	5.377483e+07	8045	6684.25	2
2012	27	2	2706505	9.895055e+07	14802	6684.94	2
2012	23	2	2309805	7.810909e+07	11684	6685.13	2
2012	27	2	2700805	3.098662e+07	4635	6685.35	2
2012	15	1	1506500	4.1397885e+08	61919	6685.81	2
2012	23	2	2310605	5.672899e+07	8483	6687.37	2
2012	31	3	3103702	5.475955e+07	8188	6687.78	2
2012	25	2	2503753	2.047715e+07	3061	6689.69	2
2012	31	3	3102209	2.897079e+07	4329	6692.26	2
2012	29	2	2902500	8.982194e+07	13420	6693.14	2
2012	13	1	1301704	3.0758544e+08	45954	6693.33	2
2012	25	2	2514008	2.884981e+07	4309	6695.24	2
2012	28	2	2806206	1.3026321e+08	19439	6701.13	2
2012	31	3	3103405	2.4167584e+08	36059	6702.23	2
2012	13	1	1300706	2.090515e+08	31171	6706.6	2
2012	24	2	2401503	2.645592e+07	3944	6707.89	2
2012	21	2	2112209	1.06998029e+09	159471	6709.56	2
2012	24	2	2408508	3.156479e+07	4704	6710.2	2
2012	28	2	2806909	2.365052e+07	3524	6711.27	2
2012	31	3	3166006	3.819385e+07	5690	6712.45	2
2012	28	2	2807501	8.63349e+07	12858	6714.49	2
2012	31	3	3134301	4.097944e+07	6101	6716.84	2
2012	26	2	2610400	1.3722149e+08	20425	6718.31	2
2012	13	1	1301506	1.1371004e+08	16923	6719.26	2
2012	27	2	2708808	2.1802228e+08	32446	6719.54	2
2012	31	3	3154101	6.933363e+07	10316	6720.98	2
2012	15	1	1506005	1.9716105e+08	29325	6723.31	2
2012	25	2	2511103	5.118405e+07	7605	6730.32	2
2012	31	3	3113107	2.195606e+07	3260	6734.99	2
2012	25	2	2515930	3.059388e+07	4539	6740.22	2
2012	15	1	1504604	1.8653238e+08	27666	6742.3	2
2012	25	2	2505238	4.190295e+07	6214	6743.31	2
2012	31	3	3104700	9.514798e+07	14109	6743.78	2
2012	21	2	2104800	4.3505776e+08	64510	6744.04	2
2012	31	3	3112208	3.187114e+07	4724	6746.64	2
2012	31	3	3108701	3.083372e+07	4567	6751.42	2
2012	25	2	2511301	1.0502469e+08	15555	6751.83	2
2012	35	3	3521200	2.876327e+07	4260	6751.94	2
2012	24	2	2412708	4.155426e+07	6154	6752.4	2
2012	29	2	2929909	2.8475224e+08	42163	6753.6	2
2012	31	3	3150000	2.799076e+07	4142	6757.79	2
2012	24	2	2410009	2.380241e+07	3522	6758.21	2
2012	31	3	3137908	2.319492e+07	3432	6758.43	2
2012	25	2	2504108	1.650514e+07	2441	6761.63	2
2012	27	2	2703601	5.338497e+07	7888	6767.87	2
2012	17	1	1710706	4.044512e+07	5976	6767.92	2
2012	31	3	3135209	4.4524206e+08	65744	6772.36	2
2012	24	2	2406106	1.2022165e+08	17749	6773.43	2
2012	29	2	2919306	7.181772e+07	10589	6782.29	2
2012	24	2	2414001	9.82532e+07	14486	6782.63	2
2012	31	3	3112059	2.882158e+07	4249	6783.14	2
2012	31	3	3143807	4.205412e+07	6197	6786.21	2
2012	31	3	3167608	1.2568354e+08	18513	6788.93	2
2012	23	2	2313104	2.0045679e+08	29522	6790.08	2
2012	31	3	3144359	4.381886e+07	6453	6790.46	2
2012	24	2	2402709	7.432457e+07	10928	6801.3	2
2012	26	2	2611804	3.057275e+08	44950	6801.5	2
2012	29	2	2933455	8.403988e+07	12356	6801.54	2
2012	24	2	2409209	1.989475e+07	2925	6801.62	2
2012	31	3	3133204	8.095332e+07	11899	6803.37	2
2012	28	2	2803005	2.6884793e+08	39432	6818.01	2
2012	15	1	1505403	1.1321254e+08	16601	6819.62	2
2012	15	1	1500404	3.6444463e+08	53369	6828.77	2
2012	31	3	3123858	3.55202e+07	5194	6838.7	2
2012	31	3	3165909	3.064463e+07	4481	6838.79	2
2012	31	3	3130556	4.450167e+07	6502	6844.31	2
2012	31	3	3140100	2.867081e+07	4189	6844.31	2
2012	31	3	3157336	5.471948e+07	7990	6848.5	2
2012	51	5	5100102	3.747101e+07	5471	6849.02	2
2012	27	2	2708907	1.0289412e+08	15020	6850.47	2
2012	31	3	3121001	3.590878e+07	5237	6856.75	2
2012	29	2	2931707	8.776385e+07	12793	6860.3	2
2012	21	2	2103802	1.5638332e+08	22791	6861.63	2
2012	25	2	2513851	1.746295e+07	2545	6861.67	2
2012	35	3	3516309	1.08142469e+09	157603	6861.7	2
2012	13	1	1302207	7.858199e+07	11439	6869.66	2
2012	31	3	3122801	2.05279e+07	2988	6870.11	2
2012	24	2	2401909	2.320502e+07	3375	6875.56	2
2012	24	2	2409308	8.309013e+07	12084	6876.05	2
2012	31	3	3100401	2.699083e+07	3925	6876.64	2
2012	29	2	2901700	7.940617e+07	11545	6877.97	2
2012	26	2	2609006	1.661514e+08	24142	6882.25	2
2012	29	2	2932606	1.135549e+08	16493	6885.04	2
2012	26	2	2607653	2.4417898e+08	35461	6885.85	2
2012	24	2	2409605	1.758138e+07	2552	6889.25	2
2012	12	1	1200302	2.245213e+08	32560	6895.62	2
2012	31	3	3129608	5.473669e+07	7928	6904.22	2
2012	26	2	2602308	2.5922894e+08	37539	6905.59	2
2012	25	2	2510709	1.568985e+07	2272	6905.74	2
2012	31	3	3164100	3.793935e+07	5493	6906.85	2
2012	31	3	3120003	2.108713e+07	3050	6913.81	2
2012	21	2	2111201	1.15975375e+09	167714	6915.07	2
2012	24	2	2404705	9.783806e+07	14148	6915.33	2
2012	31	3	3107208	3.465713e+07	5011	6916.21	2
2012	31	3	3148301	6.438945e+07	9307	6918.39	2
2012	21	2	2111763	9.997817e+07	14447	6920.34	2
2012	25	2	2509057	5.413559e+07	7822	6920.94	2
2012	26	2	2605509	7.986599e+07	11537	6922.6	2
2012	31	3	3157609	2.725133e+07	3935	6925.37	2
2012	31	3	3124104	4.3126963e+08	62262	6926.69	2
2012	35	3	3540754	1.4042131e+08	20272	6926.86	2
2012	24	2	2404903	3.887393e+07	5609	6930.64	2
2012	25	2	2504850	1.249649e+07	1802	6934.79	2
2012	31	3	3157252	5.377359e+07	7754	6934.95	2
2012	28	2	2803708	4.502674e+07	6492	6935.73	2
2012	22	2	2202901	1.7855022e+08	25737	6937.49	2
2012	29	2	2914000	4.0938729e+08	59001	6938.65	2
2012	17	1	1702901	6.491299e+07	9343	6947.77	2
2012	15	1	1504059	1.9667576e+08	28290	6952.13	2
2012	43	4	4302055	1.563024e+07	2244	6965.35	2
2012	26	2	2603454	1.02328177e+09	146847	6968.35	2
2012	29	2	2914901	1.7604173e+08	25254	6970.85	2
2012	31	3	3125002	2.631537e+07	3775	6970.96	2
2012	25	2	2508307	1.8244653e+08	26164	6973.19	2
2012	17	1	1703826	1.511153e+07	2167	6973.48	2
2012	26	2	2615003	1.790956e+08	25681	6973.86	2
2012	15	1	1505809	3.7891149e+08	54306	6977.34	2
2012	31	3	3161056	2.353068e+07	3372	6978.26	2
2012	31	3	3153301	2.067265e+07	2961	6981.64	2
2012	12	1	1200393	6.780698e+07	9711	6982.49	2
2012	31	3	3168408	9.964328e+07	14264	6985.65	2
2012	17	1	1718006	1.996512e+07	2857	6988.14	2
2012	23	2	2307254	1.2412225e+08	17744	6995.17	2
2012	31	3	3166105	2.444275e+07	3494	6995.63	2
2012	28	2	2802502	2.105242e+07	3009	6996.48	2
2012	31	3	3169109	4.093021e+07	5846	7001.41	2
2012	23	2	2312502	5.45353e+07	7788	7002.48	2
2012	31	3	3122603	3.160495e+07	4511	7006.2	2
2012	28	2	2807402	3.4178826e+08	48776	7007.3	2
2012	17	1	1701051	2.255748e+07	3219	7007.6	2
2012	15	1	1502939	3.7222631e+08	53100	7009.91	2
2012	29	2	2902252	7.226276e+07	10307	7011.04	2
2012	29	2	2915403	4.991257e+07	7118	7012.16	2
2012	31	3	3148608	1.2117194e+08	17272	7015.51	2
2012	29	2	2905602	2.213387e+08	31535	7018.83	2
2012	31	3	3132800	1.57235e+07	2238	7025.69	2
2012	31	3	3154507	6.580393e+07	9361	7029.58	2
2012	23	2	2313955	1.248909e+08	17745	7038.09	2
2012	24	2	2414308	1.628607e+07	2312	7044.15	2
2012	25	2	2510659	1.279227e+07	1816	7044.2	2
2012	25	2	2506905	1.7171374e+08	24372	7045.53	2
2012	25	2	2504702	3.309089e+07	4692	7052.62	2
2012	29	2	2931400	5.466596e+07	7746	7057.31	2
2012	29	2	2913903	3.1448904e+08	44538	7061.14	2
2012	26	2	2602100	3.2477481e+08	45983	7062.93	2
2012	23	2	2300200	4.1581507e+08	58848	7065.92	2
2012	31	3	3135076	3.618505e+07	5121	7066.01	2
2012	31	3	3142304	3.337737e+07	4723	7066.98	2
2012	15	1	1506708	4.2359525e+08	59919	7069.46	2
2012	29	2	2911808	1.5442096e+08	21840	7070.56	2
2012	31	3	3164472	4.163873e+07	5884	7076.6	2
2012	43	4	4315404	7.383628e+07	10430	7079.22	2
2012	22	2	2210607	2.3475791e+08	33148	7082.11	2
2012	24	2	2414902	1.15658e+07	1633	7082.55	2
2012	31	3	3140605	3.235923e+07	4558	7099.44	2
2012	27	2	2704005	1.7167569e+08	24173	7101.96	2
2012	28	2	2807006	2.654369e+07	3736	7104.84	2
2012	17	1	1718501	2.74663e+07	3864	7108.25	2
2012	27	2	2707909	4.953704e+07	6967	7110.24	2
2012	29	2	2929404	7.456963e+07	10474	7119.5	2
2012	31	3	3135605	5.620397e+07	7893	7120.74	2
2012	29	2	2926608	3.410512e+08	47877	7123.49	2
2012	17	1	1714302	3.043098e+07	4271	7125.02	2
2012	31	3	3146701	4.662577e+07	6543	7126.05	2
2012	31	3	3112901	6.457907e+07	9060	7127.93	2
2012	24	2	2413805	1.683086e+07	2361	7128.7	2
2012	25	2	2503308	6.906011e+07	9685	7130.63	2
2012	15	1	1506187	3.4257645e+08	48036	7131.66	2
2012	23	2	2301950	1.423797e+08	19958	7133.97	2
2012	21	2	2105658	2.707104e+07	3792	7138.99	2
2012	17	1	1717909	5.235362e+07	7333	7139.45	2
2012	50	5	5004809	5.69259e+07	7972	7140.73	2
2012	17	1	1718659	1.281579e+07	1794	7143.7	2
2012	31	3	3163300	2.736427e+07	3830	7144.72	2
2012	28	2	2802205	3.831823e+07	5363	7144.92	2
2012	26	2	2609402	4.135269e+08	57828	7150.98	2
2012	31	3	3171030	6.09518e+07	8523	7151.45	2
2012	17	1	1718550	3.056303e+07	4270	7157.62	2
2012	29	2	2911204	2.2057908e+08	30816	7157.94	2
2012	25	2	2516904	1.0539508e+08	14721	7159.51	2
2012	25	2	2512606	1.260287e+07	1759	7164.79	2
2012	28	2	2803104	3.540922e+07	4942	7164.96	2
2012	23	2	2300754	2.8867643e+08	40274	7167.81	2
2012	26	2	2608800	2.6735477e+08	37296	7168.46	2
2012	25	2	2512200	2.809817e+07	3919	7169.73	2
2012	27	2	2709400	1.8205914e+08	25384	7172.2	2
2012	31	3	3123106	3.730549e+07	5200	7174.13	2
2012	12	1	1200427	1.0958084e+08	15260	7180.92	2
2012	17	1	1702208	2.3076399e+08	32133	7181.53	2
2012	13	1	1304104	1.2859935e+08	17903	7183.12	2
2012	17	1	1715002	2.775327e+07	3858	7193.69	2
2012	23	2	2313500	3.7744749e+08	52464	7194.41	2
2012	22	2	2202208	3.2730531e+08	45493	7194.63	2
2012	24	2	2405207	3.818594e+07	5307	7195.39	2
2012	27	2	2707008	2.055948e+07	2857	7196.18	2
2012	15	1	1501725	1.2929705e+08	17960	7199.17	2
2012	29	2	2903102	4.348976e+07	6038	7202.68	2
2012	13	1	1304260	8.749082e+07	12139	7207.42	2
2012	31	3	3167806	4.150148e+07	5755	7211.38	2
2012	31	3	3115201	2.84477e+07	3944	7212.91	2
2012	31	3	3156452	3.106587e+07	4305	7216.23	2
2012	29	2	2905800	2.5529812e+08	35366	7218.74	2
2012	13	1	1301951	5.765115e+07	7983	7221.74	2
2012	22	2	2203206	7.917939e+07	10948	7232.32	2
2012	29	2	2920700	1.3897342e+08	19212	7233.68	2
2012	31	3	3125507	2.222036e+07	3071	7235.55	2
2012	31	3	3150901	3.803626e+07	5254	7239.49	2
2012	35	3	3552007	4.241968e+07	5855	7245.03	2
2012	15	1	1505205	2.1306471e+08	29402	7246.61	2
2012	24	2	2406908	2.67953e+07	3696	7249.81	2
2012	26	2	2601409	2.9711347e+08	40973	7251.45	2
2012	21	2	2109106	3.3066244e+08	45564	7257.1	2
2012	23	2	2313609	2.3588938e+08	32496	7259.03	2
2012	29	2	2931202	1.3920831e+08	19174	7260.26	2
2012	22	2	2206308	8.97587e+06	1236	7262.03	2
2012	25	2	2513901	2.2952679e+08	31582	7267.65	2
2012	29	2	2910107	8.331358e+07	11454	7273.75	2
2012	28	2	2801702	1.2263401e+08	16859	7274.1	2
2012	26	2	2609105	1.0265064e+08	14109	7275.54	2
2012	29	2	2928109	2.9256559e+08	40165	7284.09	2
2012	31	3	3167103	1.5167533e+08	20809	7288.93	2
2012	25	2	2500577	1.742171e+07	2390	7289.42	2
2012	17	1	1713809	4.308543e+07	5909	7291.49	2
2012	29	2	2902906	2.5887692e+08	35501	7292.1	2
2012	13	1	1304005	6.237776e+07	8544	7300.77	2
2012	27	2	2703403	3.908619e+07	5352	7303.1	2
2012	31	3	3102852	5.905595e+07	8084	7305.29	2
2012	29	2	2921302	8.032883e+07	10994	7306.61	2
2012	35	3	3532306	4.849806e+07	6637	7307.23	2
2012	31	3	3141405	1.5301866e+08	20934	7309.58	2
2012	23	2	2310258	2.2477728e+08	30733	7313.87	2
2012	31	3	3157401	3.608753e+07	4934	7314.05	2
2012	27	2	2701902	5.228604e+07	7146	7316.83	2
2012	17	1	1701309	4.274841e+07	5838	7322.44	2
2012	25	2	2512507	3.0429069e+08	41538	7325.6	2
2012	13	1	1300144	1.3649818e+08	18633	7325.61	2
2012	31	3	3103306	1.504776e+07	2054	7326.07	2
2012	15	1	1507300	7.3239439e+08	99905	7330.91	2
2012	17	1	1705607	3.04484e+07	4153	7331.66	2
2012	25	2	2516755	2.101391e+07	2865	7334.7	2
2012	31	3	3134608	1.2968478e+08	17679	7335.53	2
2012	29	2	2908408	4.6261152e+08	63033	7339.2	2
2012	31	3	3121704	2.811101e+07	3830	7339.69	2
2012	28	2	2807303	2.207923e+07	3006	7345.05	2
2012	31	3	3113800	1.81972e+07	2477	7346.47	2
2012	27	2	2708006	3.3480415e+08	45453	7365.94	2
2012	25	2	2505808	2.662115e+07	3611	7372.24	2
2012	31	3	3123700	7.684467e+07	10421	7374.02	2
2012	31	3	3148806	2.478735e+07	3361	7374.99	2
2012	31	3	3125804	2.287244e+07	3101	7375.83	2
2012	15	1	1501782	4.0976132e+08	55521	7380.29	2
2012	29	2	2922508	2.0280587e+08	27454	7387.12	2
2012	15	1	1502954	2.3725699e+08	32115	7387.73	2
2012	21	2	2107258	3.719016e+07	5034	7387.79	2
2012	31	3	3102100	8.794046e+07	11903	7388.09	2
2012	31	3	3116001	4.169099e+07	5643	7388.09	2
2012	27	2	2709152	3.0919199e+08	41797	7397.47	2
2012	28	2	2801405	1.5060408e+08	20345	7402.51	2
2012	27	2	2703908	3.071608e+07	4142	7415.76	2
2012	31	3	3140159	1.0092362e+08	13594	7424.13	2
2012	29	2	2920007	6.855221e+07	9229	7427.91	2
2012	17	1	1720937	1.47198e+07	1981	7430.49	2
2012	15	1	1504802	4.148566e+08	55804	7434.17	2
2012	35	3	3554656	1.688615e+07	2271	7435.56	2
2012	24	2	2411403	1.0026859e+08	13481	7437.77	2
2012	12	1	1200435	3.765672e+07	5061	7440.57	2
2012	21	2	2101202	7.5354442e+08	101195	7446.46	2
2012	15	1	1507607	3.9557916e+08	53108	7448.58	2
2012	22	2	2208551	1.943557e+07	2606	7458.01	2
2012	31	3	3140407	2.177014e+07	2919	7458.08	2
2012	17	1	1715101	2.888806e+07	3869	7466.55	2
2012	25	2	2512903	1.750042e+08	23431	7468.92	2
2012	52	5	5205497	4.3516944e+08	58262	7469.18	2
2012	29	2	2912905	1.3417814e+08	17959	7471.36	2
2012	31	3	3150158	5.512052e+07	7377	7471.94	2
2012	15	1	1508159	3.343516e+08	44727	7475.39	2
2012	31	3	3136405	3.268772e+07	4371	7478.32	2
2012	24	2	2406502	1.0675208e+08	14274	7478.78	2
2012	29	2	2906873	2.025301e+08	27067	7482.55	2
2012	52	5	5213509	5.879808e+07	7857	7483.53	2
2012	17	1	1717008	3.352241e+07	4479	7484.35	2
2012	23	2	2311405	5.5244821e+08	73812	7484.53	2
2012	25	2	2512788	1.333173e+07	1781	7485.53	2
2012	31	3	3139904	1.0603504e+08	14157	7489.94	2
2012	31	3	3105707	4.4437e+07	5930	7493.59	2
2012	25	2	2512101	2.4083828e+08	32134	7494.81	2
2012	31	3	3132107	1.3326462e+08	17761	7503.22	2
2012	31	3	3148756	5.062235e+07	6739	7511.85	2
2012	52	5	5206701	2.472218e+07	3291	7512.06	2
2012	15	1	1508001	4.3506128e+08	57914	7512.2	2
2012	27	2	2701704	1.2567507e+08	16728	7512.86	2
2012	29	2	2903904	4.8653738e+08	64740	7515.25	2
2012	29	2	2905206	3.5916599e+08	47774	7518.02	2
2012	29	2	2922250	7.844274e+07	10433	7518.71	2
2012	31	3	3163805	5.097995e+07	6778	7521.39	2
2012	13	1	1302306	1.3765213e+08	18293	7524.85	2
2012	23	2	2312304	3.3738463e+08	44825	7526.71	2
2012	26	2	2605004	1.7400141e+08	23114	7527.97	2
2012	31	3	3156809	1.1760932e+08	15619	7529.89	2
2012	31	3	3110103	3.815643e+07	5059	7542.29	2
2012	25	2	2503803	4.307639e+07	5710	7544.03	2
2012	28	2	2801900	2.896887e+07	3839	7545.94	2
2012	28	2	2806800	7.866087e+07	10424	7546.13	2
2012	25	2	2502508	1.2870137e+08	17043	7551.57	2
2012	31	3	3150539	3.406536e+07	4511	7551.62	2
2012	29	2	2916500	2.4932048e+08	33008	7553.34	2
2012	27	2	2708709	5.560141e+07	7360	7554.54	2
2012	28	2	2801009	1.2835313e+08	16987	7555.96	2
2012	12	1	1200328	5.2136e+07	6898	7558.13	2
2012	24	2	2404804	1.590388e+07	2104	7558.88	2
2012	31	3	3141603	7.877806e+07	10415	7563.9	2
2012	29	2	2929057	1.0018283e+08	13243	7564.96	2
2012	31	3	3118908	6.580223e+07	8689	7573.05	2
2012	31	3	3125952	7.919258e+07	10452	7576.79	2
2012	28	2	2802809	1.2316283e+08	16236	7585.79	2
2012	31	3	3160959	4.128061e+07	5441	7586.95	2
2012	23	2	2306256	2.795556e+08	36814	7593.73	2
2012	31	3	3161403	3.875022e+07	5100	7598.08	2
2012	31	3	3165578	3.976263e+07	5233	7598.44	2
2012	25	2	2507002	1.7862782e+08	23505	7599.57	2
2012	25	2	2502706	3.929738e+07	5169	7602.51	2
2012	31	3	3155900	4.045453e+07	5315	7611.39	2
2012	29	2	2929602	1.2649609e+08	16619	7611.53	2
2012	31	3	3101805	5.483491e+07	7204	7611.73	2
2012	31	3	3171154	3.583305e+07	4707	7612.71	2
2012	29	2	2927309	1.0600544e+08	13921	7614.79	2
2012	31	3	3163201	3.07036e+07	4026	7626.33	2
2012	31	3	3131109	5.366905e+07	7034	7629.95	2
2012	27	2	2700409	3.4277502e+08	44892	7635.55	2
2012	31	3	3115706	5.199918e+07	6806	7640.2	2
2012	26	2	2601102	5.9809145e+08	78270	7641.39	2
2012	25	2	2513406	1.1332327e+08	14826	7643.55	2
2012	29	2	2929008	1.0828904e+08	14159	7648.07	2
2012	29	2	2903300	4.683146e+07	6122	7649.7	2
2012	31	3	3100906	1.4230307e+08	18575	7661	2
2012	31	3	3130903	1.8544423e+08	24204	7661.72	2
2012	12	1	1200336	1.2176592e+08	15890	7663.05	2
2012	26	2	2610905	4.8706568e+08	63519	7668.03	2
2012	52	5	5212709	5.504377e+07	7178	7668.4	2
2012	31	3	3165701	5.61944e+07	7326	7670.54	2
2012	31	3	3158409	2.808959e+07	3662	7670.56	2
2012	15	1	1506203	2.9186291e+08	38021	7676.36	2
2012	26	2	2609709	1.7654462e+08	22996	7677.19	2
2012	28	2	2805000	2.32405e+07	3026	7680.27	2
2012	31	3	3121100	6.117105e+07	7962	7682.88	2
2012	15	1	1505106	3.8237758e+08	49763	7683.97	2
2012	29	2	2916104	1.6140247e+08	20994	7688.03	2
2012	25	2	2509701	2.4097796e+08	31330	7691.6	2
2012	31	3	3168507	8.764327e+07	11387	7696.78	2
2012	23	2	2313401	5.428699e+08	70527	7697.33	2
2012	24	2	2408953	7.841845e+07	10187	7697.89	2
2012	29	2	2916005	1.5428437e+08	20015	7708.44	2
2012	21	2	2102150	3.825833e+07	4962	7710.26	2
2012	17	1	1719004	1.993471e+07	2585	7711.69	2
2012	31	3	3127305	5.32856e+07	6908	7713.61	2
2012	24	2	2406700	8.137208e+07	10530	7727.64	2
2012	24	2	2415008	2.260346e+07	2924	7730.32	2
2012	31	3	3147501	1.344328e+07	1739	7730.47	2
2012	26	2	2616183	6.019668e+07	7773	7744.33	2
2012	15	1	1504703	5.624772e+08	72597	7747.94	2
2012	13	1	1302702	3.7485461e+08	48373	7749.25	2
2012	24	2	2402402	5.86141e+07	7559	7754.21	2
2012	24	2	2406403	2.071776e+07	2671	7756.55	2
2012	31	3	3158706	1.763187e+07	2273	7757.09	2
2012	31	3	3167905	3.107267e+07	4005	7758.47	2
2012	27	2	2705101	1.8442352e+08	23750	7765.2	2
2012	23	2	2308708	4.7929087e+08	61713	7766.45	2
2012	17	1	1720259	2.280273e+07	2936	7766.6	2
2012	35	3	3542800	2.591029e+07	3336	7766.87	2
2012	23	2	2307809	1.9690396e+08	25349	7767.72	2
2012	15	1	1505064	5.0600097e+08	65106	7771.96	2
2012	35	3	3525805	3.474167e+07	4470	7772.19	2
2012	17	1	1702703	2.721241e+07	3499	7777.2	2
2012	23	2	2306405	9.2807319e+08	119320	7778.02	2
2012	23	2	2307700	9.1306974e+08	117306	7783.66	2
2012	24	2	2409332	3.825165e+07	4911	7788.97	2
2012	25	2	2504306	2.2658943e+08	29079	7792.2	2
2012	26	2	2605152	1.3483186e+08	17296	7795.55	2
2012	26	2	2602407	6.896906e+07	8834	7807.23	2
2012	17	1	1701002	7.629012e+07	9768	7810.21	2
2012	31	3	3154457	6.258569e+07	8013	7810.52	2
2012	23	2	2306306	3.8375904e+08	49130	7811.09	2
2012	31	3	3150406	3.668731e+07	4696	7812.46	2
2012	24	2	2404853	5.499272e+07	7036	7815.91	2
2012	13	1	1303403	8.1186713e+08	103828	7819.35	2
2012	52	5	5207907	9.97599e+07	12754	7821.85	2
2012	52	5	5209408	3.28204e+07	4195	7823.7	2
2012	17	1	1704105	2.055502e+07	2627	7824.52	2
2012	24	2	2400802	9.028388e+07	11538	7824.92	2
2012	29	2	2907301	1.9997775e+08	25555	7825.39	2
2012	24	2	2414506	8.298403e+07	10594	7833.12	2
2012	24	2	2403400	4.580937e+07	5846	7836.02	2
2012	31	3	3102704	7.072716e+07	9025	7836.8	2
2012	15	1	1505486	3.2651901e+08	41654	7838.84	2
2012	29	2	2904308	1.1071636e+08	14123	7839.44	2
2012	52	5	5201702	1.4558906e+08	18564	7842.55	2
2012	31	3	3145406	1.514849e+07	1927	7861.18	2
2012	31	3	3144904	2.943896e+07	3744	7862.97	2
2012	28	2	2800209	1.5985359e+08	20315	7868.75	2
2012	24	2	2412609	1.2708012e+08	16149	7869.23	2
2012	29	2	2932200	1.5907847e+08	20214	7869.72	2
2012	31	3	3172202	2.00615e+07	2547	7876.52	2
2012	26	2	2600104	2.7896998e+08	35416	7876.95	2
2012	24	2	2405603	1.0824711e+08	13735	7881.11	2
2012	29	2	2901106	1.9767771e+08	25080	7881.89	2
2012	29	2	2929750	8.964111e+07	11354	7895.11	2
2012	17	1	1715150	1.807597e+07	2288	7900.34	2
2012	31	3	3132701	1.8050129e+08	22831	7905.97	2
2012	28	2	2801108	3.12685e+07	3955	7906.07	2
2012	31	3	3162807	1.2300349e+08	15558	7906.13	2
2012	12	1	1200351	1.1970899e+08	15123	7915.69	2
2012	31	3	3158508	6.268357e+07	7918	7916.59	2
2012	43	4	4304713	5.9017e+07	7450	7921.75	2
2012	31	3	3170305	2.125673e+07	2680	7931.62	2
2012	25	2	2517100	2.040824e+07	2573	7931.69	2
2012	21	2	2108207	3.1257334e+08	39391	7935.15	2
2012	31	3	3112505	7.165756e+07	9030	7935.5	2
2012	35	3	3538501	1.1066484e+08	13942	7937.52	2
2012	29	2	2930501	6.131488e+08	77211	7941.21	2
2012	29	2	2914703	4.9280511e+08	62037	7943.73	2
2012	41	4	4109500	6.203287e+07	7809	7943.77	2
2012	31	3	3148707	1.8967889e+08	23874	7945	2
2012	35	3	3501400	3.763449e+07	4732	7953.19	2
2012	31	3	3109204	8.180415e+07	10281	7956.83	2
2012	12	1	1200609	2.9254766e+08	36763	7957.67	2
2012	52	5	5201801	6.894004e+07	8659	7961.66	2
2012	28	2	2802601	4.513012e+07	5665	7966.48	2
2012	21	2	2103000	1.25974955e+09	158059	7970.12	2
2012	35	3	3522158	2.57392e+07	3229	7971.26	2
2012	31	3	3114808	3.61199e+07	4530	7973.49	2
2012	14	1	1400704	6.988203e+07	8764	7973.76	2
2012	24	2	2400109	8.792612e+07	11012	7984.57	2
2012	17	1	1721208	1.805244e+08	22596	7989.22	2
2012	25	2	2516102	1.1182153e+08	13993	7991.25	2
2012	28	2	2800704	6.267435e+07	7839	7995.2	2
2012	35	3	3503505	2.968346e+07	3711	7998.78	2
2012	29	2	2927705	2.1296722e+08	26623	7999.37	2
2012	26	2	2615607	2.1398156e+08	26749	7999.61	2
2012	31	3	3165602	1.590168e+07	1987	8002.86	2
2012	31	3	3107703	4.478419e+07	5593	8007.19	2
2012	17	1	1711803	1.774433e+07	2216	8007.37	2
2012	52	5	5203559	6.299316e+07	7866	8008.28	2
2012	31	3	3159308	3.974739e+07	4960	8013.59	2
2012	23	2	2307007	2.6136894e+08	32614	8014.01	2
2012	31	3	3136108	4.207356e+07	5246	8020.12	2
2012	31	3	3156205	1.723153e+07	2148	8022.13	2
2012	35	3	3505401	6.157347e+07	7672	8025.74	2
2012	31	3	3136553	3.601979e+07	4487	8027.59	2
2012	31	3	3168051	2.50915e+07	3124	8031.85	2
2012	51	5	5107297	2.950531e+07	3673	8033.03	2
2012	35	3	3514007	6.49372e+07	8080	8036.78	2
2012	26	2	2605103	2.7695988e+08	34442	8041.34	2
2012	35	3	3515350	7.632624e+07	9491	8041.96	2
2012	50	5	5006358	1.0192208e+08	12673	8042.46	2
2012	12	1	1200344	6.617897e+07	8224	8047.05	2
2012	31	3	3135506	1.0244344e+08	12726	8049.93	2
2012	13	1	1300102	1.3749893e+08	17072	8054.06	2
2012	31	3	3101706	3.164211e+08	39287	8054.09	2
2012	31	3	3156106	3.906314e+07	4850	8054.25	2
2012	31	3	3151008	6.532441e+07	8110	8054.8	2
2012	15	1	1500859	1.7906748e+08	22225	8057.03	2
2012	17	1	1708304	4.008261e+07	4974	8058.43	2
2012	29	2	2922755	5.29621e+07	6570	8061.2	2
2012	31	3	3145851	3.639743e+07	4514	8063.23	2
2012	26	2	2613800	1.3831507e+08	17151	8064.55	2
2012	15	1	1505551	4.736457e+07	5869	8070.3	2
2012	24	2	2411205	2.9441287e+08	36477	8071.19	2
2012	32	3	3203304	1.1170661e+08	13826	8079.46	2
2012	31	3	3157302	3.662881e+07	4532	8082.26	2
2012	21	2	2102804	1.9384613e+08	23955	8092.09	2
2012	25	2	2515906	5.001711e+07	6175	8099.94	2
2012	29	2	2933505	1.7759047e+08	21910	8105.45	2
2012	17	1	1701903	5.234988e+07	6454	8111.23	2
2012	28	2	2803906	9.852146e+07	12127	8124.14	2
2012	17	1	1707702	6.946341e+07	8549	8125.33	2
2012	32	3	3204005	1.7668878e+08	21722	8134.09	2
2012	13	1	1301159	2.0295775e+08	24937	8138.82	2
2012	28	2	2800506	1.3969783e+08	17164	8139	2
2012	15	1	1504422	9.2333934e+08	113353	8145.7	2
2012	31	3	3171501	2.712005e+07	3329	8146.61	2
2012	24	2	2408300	2.9120436e+08	35741	8147.63	2
2012	31	3	3159407	2.888137e+07	3544	8149.37	2
2012	29	2	2913200	2.0892399e+08	25617	8155.68	2
2012	13	1	1302405	3.1828764e+08	39022	8156.62	2
2012	31	3	3120102	3.454253e+07	4234	8158.37	2
2012	31	3	3171808	8.605487e+07	10534	8169.25	2
2012	52	5	5214861	6.90037e+07	8443	8172.89	2
2012	29	2	2925956	1.8733631e+08	22916	8174.91	2
2012	31	3	3127370	2.538878e+07	3105	8176.74	2
2012	35	3	3535101	9.250393e+07	11312	8177.5	2
2012	29	2	2915908	6.207566e+07	7590	8178.61	2
2012	31	3	3104403	2.340487e+07	2860	8183.52	2
2012	51	5	5102793	8.838844e+07	10793	8189.42	2
2012	29	2	2923001	3.2381892e+08	39535	8190.69	2
2012	28	2	2800670	2.1076367e+08	25727	8192.31	2
2012	17	1	1718881	2.45383e+07	2995	8193.09	2
2012	25	2	2514651	1.398709e+07	1707	8193.96	2
2012	51	5	5101605	6.211424e+07	7578	8196.65	2
2012	31	3	3105301	4.432098e+07	5405	8200	2
2012	31	3	3136603	4.572064e+07	5575	8201.01	2
2012	31	3	3107901	8.570785e+07	10449	8202.49	2
2012	31	3	3116704	5.854541e+07	7135	8205.38	2
2012	31	3	3153202	3.160782e+07	3846	8218.36	2
2012	35	3	3553658	2.243005e+07	2727	8225.17	2
2012	17	1	1707207	5.878952e+07	7145	8228.06	2
2012	24	2	2414407	2.5981256e+08	31574	8228.69	2
2012	28	2	2807600	1.9113086e+08	23223	8230.24	2
2012	35	3	3523305	1.2982928e+08	15752	8242.08	2
2012	35	3	3517307	4.498931e+07	5458	8242.82	2
2012	31	3	3101300	2.224565e+07	2696	8251.35	2
2012	29	2	2900603	3.743333e+07	4536	8252.5	2
2012	28	2	2800100	1.889883e+07	2290	8252.76	2
2012	52	5	5209903	1.0438255e+08	12648	8252.89	2
2012	31	3	3162575	4.380037e+07	5307	8253.32	2
2012	35	3	3548302	2.350616e+07	2845	8262.27	2
2012	31	3	3125903	8.775827e+07	10612	8269.72	2
2012	28	2	2803401	1.0689698e+08	12926	8269.92	2
2012	17	1	1710508	5.91896e+07	7148	8280.58	2
2012	23	2	2311306	6.8176034e+08	82258	8288.07	2
2012	21	2	2111573	3.719123e+07	4486	8290.51	2
2012	31	3	3154606	2.51268716e+09	303029	8291.9	2
2012	41	4	4115457	4.048151e+07	4879	8297.09	2
2012	27	2	2709103	1.570541e+08	18907	8306.66	2
2012	43	4	4306353	2.310102e+07	2779	8312.71	2
2012	26	2	2610608	4.3513527e+08	52297	8320.46	2
2012	35	3	3526308	4.019928e+07	4824	8333.18	2
2012	26	2	2604809	1.0349684e+08	12418	8334.42	2
2012	41	4	4123857	9.318322e+07	11178	8336.3	2
2012	31	3	3153509	6.92259e+07	8297	8343.49	2
2012	35	3	3556354	7.577535e+07	9077	8348.06	2
2012	31	3	3124609	2.03756e+07	2440	8350.66	2
2012	27	2	2708303	1.9152212e+08	22906	8361.22	2
2012	12	1	1200054	5.280547e+07	6308	8371.19	2
2012	29	2	2929305	2.87108e+08	34232	8387.12	2
2012	13	1	1300839	9.480497e+07	11303	8387.59	2
2012	24	2	2402600	5.7896471e+08	69005	8390.18	2
2012	52	5	5212055	1.953194e+07	2327	8393.61	2
2012	17	1	1702554	1.3768825e+08	16401	8395.11	2
2012	24	2	2403608	2.1264295e+08	25324	8396.89	2
2012	31	3	3116209	2.317897e+07	2759	8401.22	2
2012	31	3	3122900	5.123407e+07	6098	8401.78	2
2012	31	3	3111705	3.868671e+07	4604	8402.85	2
2012	31	3	3138005	5.480544e+07	6517	8409.61	2
2012	31	3	3163607	2.208451e+07	2625	8413.15	2
2012	22	2	2207702	1.244845e+09	147732	8426.37	2
2012	51	5	5105309	1.841887e+07	2184	8433.55	2
2012	31	3	3154002	2.0034921e+08	23748	8436.47	2
2012	17	1	1716653	4.324405e+07	5124	8439.51	2
2012	31	3	3167301	1.859243e+07	2201	8447.27	2
2012	29	2	2914653	2.432059e+08	28790	8447.58	2
2012	25	2	2500403	1.6773595e+08	19849	8450.6	2
2012	24	2	2405702	1.0249649e+08	12124	8454.02	2
2012	31	3	3127206	3.332829e+07	3942	8454.67	2
2012	31	3	3149408	1.509933e+07	1785	8459.01	2
2012	52	5	5217609	7.0106669e+08	82847	8462.19	2
2012	26	2	2609808	1.1467848e+08	13536	8472.11	2
2012	31	3	3161650	3.033913e+07	3580	8474.62	2
2012	12	1	1200500	3.3367078e+08	39366	8476.12	2
2012	51	5	5107404	3.610584e+07	4259	8477.54	2
2012	17	1	1705557	3.979623e+07	4691	8483.53	2
2012	31	3	3138708	4.596752e+07	5413	8492.06	2
2012	27	2	2706703	5.1731794e+08	60890	8495.94	2
2012	31	3	3128501	3.309144e+07	3894	8498.06	2
2012	23	2	2302206	4.280089e+08	50364	8498.31	2
2012	28	2	2805307	7.256391e+07	8538	8498.94	2
2012	51	5	5103379	1.3523799e+08	15912	8499.12	2
2012	31	3	3154200	9.351526e+07	11001	8500.61	2
2012	31	3	3113503	7.807981e+07	9176	8509.13	2
2012	31	3	3158904	7.304501e+07	8579	8514.4	2
2012	25	2	2515302	4.3124866e+08	50565	8528.6	2
2012	35	3	3521606	6.696738e+07	7840	8541.76	2
2012	31	3	3131208	1.5767819e+08	18455	8543.93	2
2012	15	1	1503457	4.4066233e+08	51569	8545.1	2
2012	31	3	3155405	7.468692e+07	8737	8548.35	2
2012	31	3	3155009	2.129501e+07	2488	8559.09	2
2012	26	2	2601904	5.0386295e+08	58864	8559.78	2
2012	35	3	3551207	3.086257e+07	3605	8561.05	2
2012	17	1	1700251	2.074603e+07	2422	8565.66	2
2012	28	2	2801306	2.6925786e+08	31402	8574.54	2
2012	31	3	3123908	1.2362873e+08	14413	8577.58	2
2012	31	3	3169208	7.907837e+07	9218	8578.69	2
2012	33	3	3302270	8.3510005e+08	97337	8579.47	2
2012	43	4	4301859	2.665004e+07	3105	8582.94	2
2012	31	3	3108107	5.847177e+07	6811	8584.9	2
2012	28	2	2800407	8.154904e+07	9495	8588.63	2
2012	26	2	2611309	2.2413137e+08	26086	8592.02	2
2012	23	2	2303501	5.8000432e+08	67503	8592.27	2
2012	31	3	3164209	9.153698e+07	10653	8592.6	2
2012	26	2	2612604	3.4276834e+08	39816	8608.81	2
2012	26	2	2608909	4.7688866e+08	55343	8616.96	2
2012	29	2	2930105	6.5087339e+08	75437	8628.04	2
2012	31	3	3165560	2.415675e+07	2799	8630.49	2
2012	31	3	3142403	6.132958e+07	7106	8630.68	2
2012	31	3	3129400	4.337028e+07	5021	8637.78	2
2012	15	1	1506609	2.0187652e+08	23355	8643.82	2
2012	17	1	1720150	1.26474e+07	1463	8644.84	2
2012	28	2	2806503	3.264939e+07	3773	8653.43	2
2012	17	1	1703107	4.666904e+07	5390	8658.45	2
2012	43	4	4300646	6.348027e+07	7310	8684.03	2
2012	26	2	2613404	1.6346311e+08	18816	8687.45	2
2012	31	3	3120607	4.172203e+07	4800	8692.09	2
2012	29	2	2913705	3.244667e+08	37321	8693.94	2
2012	17	1	1702158	4.486102e+07	5157	8699.05	2
2012	41	4	4113254	5.457495e+07	6257	8722.22	2
2012	51	5	5106422	2.7497481e+08	31516	8724.93	2
2012	52	5	5204953	3.980345e+07	4562	8725	2
2012	31	3	3121506	2.605971e+07	2986	8727.3	2
2012	31	3	3159357	5.825947e+07	6661	8746.35	2
2012	41	4	4117206	4.843237e+07	5537	8747.04	2
2012	29	2	2917300	2.3559834e+08	26930	8748.55	2
2012	24	2	2404200	2.0307782e+08	23209	8749.96	2
2012	31	3	3109105	9.540181e+07	10886	8763.72	2
2012	52	5	5220686	5.750782e+07	6559	8767.77	2
2012	17	1	1709005	1.0714541e+08	12220	8768.04	2
2012	29	2	2905008	1.98009e+08	22577	8770.39	2
2012	27	2	2706307	6.2136189e+08	70738	8783.99	2
2012	15	1	1506583	1.5944428e+08	18150	8784.81	2
2012	31	3	3138302	2.813438e+07	3202	8786.5	2
2012	35	3	3549607	3.579205e+07	4068	8798.44	2
2012	31	3	3171402	3.255088e+07	3698	8802.29	2
2012	26	2	2607802	1.4287626e+08	16221	8808.1	2
2012	27	2	2709301	5.5467453e+08	62923	8815.13	2
2012	23	2	2304202	1.09283521e+09	123963	8815.82	2
2012	31	3	3145059	6.526652e+07	7400	8819.8	2
2012	31	3	3133303	1.8487272e+08	20961	8819.84	2
2012	15	1	1500347	2.2499193e+08	25506	8821.14	2
2012	31	3	3151305	9.554132e+07	10821	8829.25	2
2012	31	3	3119609	2.645995e+07	2996	8831.76	2
2012	51	5	5106109	1.0208047e+08	11550	8838.14	2
2012	50	5	5005202	1.7915668e+08	20267	8839.82	2
2012	26	2	2616308	2.7432428e+08	31021	8843.18	2
2012	43	4	4300604	1.74656636e+09	197441	8846.02	2
2012	17	1	1712454	2.40093e+07	2713	8849.72	2
2012	26	2	2605202	5.7055905e+08	64422	8856.59	2
2012	12	1	1200708	1.473902e+08	16639	8858.12	2
2012	42	4	4212254	6.171563e+07	6964	8862.09	2
2012	31	3	3164803	1.407674e+07	1588	8864.44	2
2012	28	2	2806701	7.1843293e+08	81011	8868.34	2
2012	28	2	2804102	9.789833e+07	11038	8869.21	2
2012	31	3	3160009	3.142025e+07	3542	8870.77	2
2012	41	4	4117057	1.0370415e+08	11690	8871.19	2
2012	26	2	2608750	2.069256e+08	23308	8877.88	2
2012	31	3	3143708	2.973695e+07	3349	8879.35	2
2012	31	3	3111309	1.0208511e+08	11483	8890.11	2
2012	25	2	2512002	1.5430671e+08	17357	8890.17	2
2012	35	3	3536802	5.163e+07	5806	8892.52	2
2012	22	2	2205607	4.650286e+07	5229	8893.26	2
2012	51	5	5106653	5.024629e+07	5646	8899.45	2
2012	41	4	4100400	9.3884954e+08	105458	8902.59	2
2012	31	3	3157278	2.539289e+07	2852	8903.54	2
2012	31	3	3169059	3.535442e+07	3970	8905.39	2
2012	31	3	3160801	4.192002e+07	4704	8911.57	2
2012	31	3	3123304	3.932515e+07	4412	8913.22	2
2012	31	3	3142502	2.074396e+07	2327	8914.47	2
2012	23	2	2302602	5.4298441e+08	60870	8920.39	2
2012	24	2	2401651	2.118295e+07	2373	8926.65	2
2012	29	2	2928604	5.1774101e+08	57978	8929.96	2
2012	43	4	4322152	3.936652e+07	4408	8930.7	2
2012	27	2	2707305	2.3205514e+08	25974	8934.13	2
2012	31	3	3104502	1.5797353e+08	17669	8940.72	2
2012	17	1	1722081	9.923348e+07	11088	8949.63	2
2012	28	2	2804607	2.2349678e+08	24941	8961.02	2
2012	15	1	1508050	1.5508761e+08	17303	8963.05	2
2012	31	3	3132503	2.9216451e+08	32595	8963.48	2
2012	17	1	1713957	2.893581e+07	3224	8975.13	2
2012	31	3	3134103	5.26313e+07	5859	8982.98	2
2012	35	3	3520004	2.1097179e+08	23475	8987.08	2
2012	21	2	2106102	1.0426457e+08	11597	8990.65	2
2012	43	4	4323754	3.067091e+07	3411	8991.76	2
2012	31	3	3149952	6.273154e+07	6975	8993.77	2
2012	24	2	2408201	2.2038238e+08	24501	8994.83	2
2012	51	5	5102603	1.3128521e+08	14590	8998.3	2
2012	31	3	3154150	5.999784e+07	6667	8999.23	2
2012	23	2	2306900	3.0900491e+08	34317	9004.43	2
2012	31	3	3144003	2.4006739e+08	26657	9005.79	2
2012	29	2	2928802	4.4037946e+08	48897	9006.27	2
2012	31	3	3101201	5.512358e+07	6116	9013.01	2
2012	26	2	2614501	5.3865916e+08	59751	9015.07	2
2012	52	5	5208103	4.307765e+07	4777	9017.72	2
2012	13	1	1301407	2.8297458e+08	31364	9022.27	2
2012	35	3	3533304	3.201176e+07	3546	9027.57	2
2012	31	3	3111903	5.035989e+07	5578	9028.3	2
2012	31	3	3147808	1.867198e+07	2067	9033.37	2
2012	17	1	1703909	4.286341e+07	4744	9035.29	2
2012	17	1	1714203	8.154382e+07	9021	9039.33	2
2012	31	3	3129004	7.797293e+07	8624	9041.39	2
2012	15	1	1504455	2.5535015e+08	28227	9046.31	2
2012	28	2	2806008	1.5773654e+08	17435	9047.12	2
2012	31	3	3135050	3.126407e+08	34539	9051.82	2
2012	29	2	2931004	1.812198e+08	20001	9060.54	2
2012	51	5	5107776	6.860037e+07	7568	9064.53	2
2012	31	3	3166303	6.482048e+07	7149	9067.07	2
2012	41	4	4110201	9.921651e+07	10940	9069.15	2
2012	29	2	2900801	1.9345319e+08	21328	9070.39	2
2012	31	3	3127602	1.0597739e+08	11680	9073.41	2
2012	32	3	3200508	6.80348e+07	7497	9074.94	2
2012	15	1	1501451	1.5048625e+08	16579	9076.92	2
2012	31	3	3100302	1.2083572e+08	13306	9081.3	2
2012	41	4	4115002	6.243728e+07	6874	9083.11	2
2012	29	2	2921104	1.9686029e+08	21642	9096.22	2
2012	29	2	2911709	7.2722497e+08	79936	9097.59	2
2012	15	1	1505635	1.1555325e+08	12701	9097.96	2
2012	52	5	5204557	3.091148e+07	3396	9102.32	2
2012	24	2	2401800	1.0714859e+08	11769	9104.31	2
2012	25	2	2501807	9.1698218e+08	100543	9120.3	2
2012	35	3	3520608	4.38694e+07	4809	9122.35	2
2012	13	1	1301852	3.8266859e+08	41947	9122.67	2
2012	31	3	3110400	2.826382e+07	3097	9126.19	2
2012	17	1	1715705	4.709075e+07	5157	9131.42	2
2012	41	4	4128807	5.432481e+07	5939	9147.13	2
2012	13	1	1304203	5.5829121e+08	61000	9152.31	2
2012	31	3	3110806	3.282421e+07	3586	9153.43	2
2012	17	1	1703073	3.854437e+07	4206	9164.14	2
2012	23	2	2309706	6.9300958e+08	75411	9189.77	2
2012	26	2	2607406	4.113656e+07	4475	9192.53	2
2012	31	3	3164902	1.959631e+07	2131	9195.83	2
2012	31	3	3126703	2.3114186e+08	25116	9202.97	2
2012	35	3	3542305	3.541319e+07	3847	9205.41	2
2012	31	3	3167004	1.827993e+07	1984	9213.67	2
2012	31	3	3116506	7.108462e+07	7712	9217.4	2
2012	35	3	3545001	1.4590016e+08	15828	9217.85	2
2012	43	4	4318507	2.3753527e+08	25761	9220.73	2
2012	25	2	2508604	1.1094361e+08	12029	9223.01	2
2012	52	5	5207808	1.091825e+08	11833	9226.95	2
2012	26	2	2611408	1.2654701e+08	13705	9233.64	2
2012	12	1	1200807	1.4346431e+08	15534	9235.5	2
2012	51	5	5106505	2.9491409e+08	31931	9235.98	2
2012	31	3	3168002	2.9071946e+08	31457	9241.81	3
2012	27	2	2704500	2.7538431e+08	29794	9242.95	3
2012	32	3	3204252	6.551605e+07	7088	9243.24	3
2012	14	1	1400407	8.665868e+07	9364	9254.45	3
2012	17	1	1706001	4.732973e+07	5111	9260.37	3
2012	31	3	3121308	4.449854e+07	4804	9262.81	3
2012	24	2	2413904	1.1014622e+08	11883	9269.23	3
2012	41	4	4122651	5.046604e+07	5438	9280.26	3
2012	31	3	3108909	1.353733e+08	14585	9281.68	3
2012	31	3	3149606	3.834353e+07	4131	9281.9	3
2012	29	2	2901353	1.3189407e+08	14209	9282.43	3
2012	31	3	3137403	1.1498182e+08	12373	9292.96	3
2012	17	1	1716307	4.302657e+07	4627	9299.02	3
2012	15	1	1502707	4.2673288e+08	45885	9300.05	3
2012	31	3	3146602	1.441687e+07	1549	9307.21	3
2012	31	3	3138674	5.794554e+07	6225	9308.52	3
2012	25	2	2506004	2.9357664e+08	31538	9308.66	3
2012	41	4	4126207	6.251984e+07	6716	9309.09	3
2012	31	3	3122355	5.630119e+07	6046	9312.14	3
2012	21	2	2104107	1.1462025e+08	12306	9314.18	3
2012	22	2	2206605	9.653166e+07	10363	9315.03	3
2012	41	4	4100509	1.9317795e+08	20711	9327.31	3
2012	31	3	3138609	1.5127565e+08	16216	9328.79	3
2012	51	5	5103254	2.6882734e+08	28810	9331.04	3
2012	31	3	3135902	4.443007e+07	4760	9334.05	3
2012	32	3	3203809	1.3549024e+08	14506	9340.29	3
2012	11	1	1100080	1.340908e+08	14355	9341.05	3
2012	31	3	3159001	3.798323e+07	4066	9341.67	3
2012	32	3	3203163	1.0114224e+08	10810	9356.36	3
2012	31	3	3122009	1.8002673e+08	19241	9356.41	3
2012	31	3	3123528	7.005609e+07	7487	9357.03	3
2012	43	4	4315107	9.799667e+07	10463	9366.02	3
2012	52	5	5205802	9.804054e+07	10464	9369.32	3
2012	31	3	3107505	6.072521e+07	6480	9371.17	3
2012	33	3	3302858	1.58875945e+09	169537	9371.17	3
2012	31	3	3144375	3.07294e+07	3279	9371.58	3
2012	17	1	1706100	6.772453e+07	7222	9377.53	3
2012	27	2	2701001	2.4398987e+08	26010	9380.62	3
2012	31	3	3103108	1.551411e+07	1653	9385.43	3
2012	31	3	3103009	8.913178e+07	9493	9389.21	3
2012	31	3	3158607	3.644314e+07	3873	9409.54	3
2012	35	3	3528908	3.698203e+07	3926	9419.77	3
2012	14	1	1400282	8.750213e+07	9288	9420.99	3
2012	15	1	1500206	5.0691614e+08	53787	9424.51	3
2012	31	3	3160603	3.017113e+07	3201	9425.53	3
2012	31	3	3161007	1.6328385e+08	17314	9430.74	3
2012	31	3	3140852	9.611708e+07	10188	9434.34	3
2012	28	2	2803807	3.297721e+07	3494	9438.24	3
2012	31	3	3150208	3.838556e+07	4067	9438.3	3
2012	29	2	2903409	2.0845097e+08	22067	9446.28	3
2012	31	3	3115904	2.697907e+07	2856	9446.45	3
2012	14	1	1400050	1.5334493e+08	16228	9449.4	3
2012	17	1	1700350	5.287885e+07	5595	9451.09	3
2012	27	2	2707701	6.5170622e+08	68952	9451.59	3
2012	52	5	5205521	3.306575e+07	3496	9458.17	3
2012	31	3	3121902	3.132548e+07	3309	9466.75	3
2012	31	3	3130606	6.602991e+07	6973	9469.37	3
2012	35	3	3519253	6.514901e+07	6878	9472.09	3
2012	52	5	5209291	2.191792e+07	2313	9475.97	3
2012	17	1	1713304	1.2079299e+08	12747	9476.19	3
2012	52	5	5216809	9.733834e+07	10269	9478.85	3
2012	35	3	3554201	4.483895e+07	4730	9479.69	3
2012	29	2	2915304	6.651505e+07	7013	9484.54	3
2012	17	1	1711506	3.384365e+07	3566	9490.65	3
2012	31	3	3124906	1.0117975e+08	10657	9494.21	3
2012	31	3	3129806	1.54641749e+09	162867	9494.97	3
2012	15	1	1503606	9.2967471e+08	97908	9495.39	3
2012	31	3	3149101	1.0817024e+08	11386	9500.28	3
2012	31	3	3157104	6.528652e+07	6872	9500.37	3
2012	52	5	5210604	5.131518e+07	5398	9506.33	3
2012	22	2	2200459	4.922862e+07	5177	9509.1	3
2012	23	2	2306801	1.0134609e+08	10652	9514.28	3
2012	31	3	3126406	2.612979e+07	2746	9515.58	3
2012	31	3	3153806	1.781692e+07	1872	9517.59	3
2012	52	5	5219704	9.56869e+07	10044	9526.77	3
2012	42	4	4202073	8.250557e+07	8655	9532.71	3
2012	24	2	2403004	7.575879e+07	7942	9539.01	3
2012	51	5	5107701	1.6720917e+08	17526	9540.64	3
2012	31	3	3127404	4.04139e+07	4235	9542.83	3
2012	51	5	5106315	2.032444e+07	2129	9546.47	3
2012	31	3	3120805	1.4064022e+08	14716	9556.96	3
2012	17	1	1720499	4.092649e+07	4282	9557.8	3
2012	31	3	3135100	6.4678919e+08	67581	9570.58	3
2012	51	5	5106273	3.624371e+07	3785	9575.62	3
2012	31	3	3160504	1.696165e+07	1771	9577.44	3
2012	31	3	3127388	3.555219e+07	3710	9582.8	3
2012	28	2	2804409	1.7733164e+08	18493	9589.12	3
2012	52	5	5214903	3.294404e+07	3434	9593.49	3
2012	35	3	3522802	1.3987368e+08	14579	9594.19	3
2012	31	3	3122470	3.624731e+07	3778	9594.31	3
2012	26	2	2608206	1.5120076e+08	15751	9599.44	3
2012	24	2	2405801	3.1381371e+08	32677	9603.5	3
2012	35	3	3533106	2.10432e+07	2191	9604.38	3
2012	31	3	3142106	9.92693e+07	10324	9615.39	3
2012	50	5	5003157	1.3706548e+08	14254	9615.93	3
2012	43	4	4305124	6.083453e+07	6324	9619.63	3
2012	28	2	2806305	1.3545685e+08	14081	9619.83	3
2012	31	3	3145703	2.04129e+07	2120	9628.73	3
2012	17	1	1716703	8.190645e+07	8500	9636.05	3
2012	43	4	4300638	6.211569e+07	6446	9636.32	3
2012	28	2	2804300	7.11688e+07	7381	9642.16	3
2012	29	2	2925501	2.670585e+08	27693	9643.54	3
2012	31	3	3109600	3.507981e+07	3635	9650.57	3
2012	43	4	4310702	3.868327e+07	4008	9651.51	3
2012	43	4	4316428	2.497056e+07	2587	9652.32	3
2012	35	3	3503158	2.390953e+07	2475	9660.42	3
2012	17	1	1718865	6.535529e+07	6764	9662.23	3
2012	17	1	1718709	2.528938e+07	2616	9667.19	3
2012	26	2	2606408	7.5271916e+08	77845	9669.46	3
2012	43	4	4302006	1.0735338e+08	11101	9670.6	3
2012	35	3	3510302	1.743761e+08	18029	9671.98	3
2012	29	2	2915601	6.1029688e+08	63037	9681.57	3
2012	35	3	3509304	9.544128e+07	9858	9681.61	3
2012	41	4	4128633	5.505309e+07	5686	9682.22	3
2012	31	3	3159902	1.6976616e+08	17532	9683.22	3
2012	26	2	2612000	1.0532534e+08	10877	9683.31	3
2012	17	1	1713700	2.053835e+07	2118	9697.05	3
2012	35	3	3537206	1.0044575e+08	10358	9697.41	3
2012	32	3	3200359	7.149215e+07	7371	9699.11	3
2012	43	4	4311734	2.898285e+07	2988	9699.75	3
2012	35	3	3556602	1.0404286e+08	10722	9703.68	3
2012	31	3	3104809	4.784507e+07	4930	9704.88	3
2012	52	5	5218300	3.1291411e+08	32234	9707.58	3
2012	43	4	4319737	2.574015e+07	2651	9709.6	3
2012	24	2	2411809	3.329617e+07	3427	9715.84	3
2012	41	4	4119509	9.3368997e+08	96023	9723.61	3
2012	51	5	5106208	4.285158e+07	4406	9725.73	3
2012	16	1	1600808	1.2678965e+08	13013	9743.31	3
2012	35	3	3551405	1.1529144e+08	11832	9744.04	3
2012	16	1	1600253	4.360858e+07	4473	9749.29	3
2012	28	2	2803500	9.4195766e+08	96602	9750.91	3
2012	31	3	3114907	2.185351e+07	2241	9751.68	3
2012	26	2	2603009	3.0725164e+08	31497	9754.95	3
2012	35	3	3503604	1.0364851e+08	10622	9757.91	3
2012	24	2	2408904	2.0018452e+08	20511	9759.86	3
2012	52	5	5204854	6.32082e+07	6476	9760.38	3
2012	26	2	2601201	6.8321224e+08	69880	9776.94	3
2012	25	2	2515708	2.932302e+07	2994	9793.93	3
2012	41	4	4107124	3.418518e+07	3488	9800.8	3
2012	52	5	5215801	2.293825e+07	2339	9806.86	3
2012	13	1	1302504	8.5316494e+08	86985	9808.18	3
2012	43	4	4309126	2.18694e+07	2228	9815.71	3
2012	51	5	5107263	2.95592e+07	3010	9820.33	3
2012	31	3	3153608	9.604183e+07	9776	9824.25	3
2012	51	5	5107206	4.978361e+07	5067	9825.07	3
2012	31	3	3139805	1.1722434e+08	11928	9827.66	3
2012	17	1	1715754	7.252959e+07	7380	9827.86	3
2012	17	1	1712504	4.431633e+07	4507	9832.78	3
2012	21	2	2106755	2.5251852e+08	25681	9832.89	3
2012	41	4	4120309	3.950375e+07	4016	9836.59	3
2012	52	5	5208301	4.851295e+07	4931	9838.36	3
2012	43	4	4311254	6.152431e+07	6247	9848.62	3
2012	17	1	1717206	2.890966e+07	2933	9856.69	3
2012	31	3	3104908	1.8169146e+08	18426	9860.6	3
2012	31	3	3102050	5.322204e+07	5392	9870.56	3
2012	31	3	3165008	1.0477833e+08	10609	9876.36	3
2012	28	2	2804458	8.44798e+07	8543	9888.77	3
2012	43	4	4304689	1.1722119e+08	11851	9891.25	3
2012	43	4	4300307	6.756821e+07	6828	9895.75	3
2012	52	5	5213772	4.13145e+07	4173	9900.43	3
2012	41	4	4114708	5.836005e+07	5892	9904.96	3
2012	31	3	3115607	1.188223e+07	1199	9910.11	3
2012	29	2	2932507	2.279763e+08	22992	9915.46	3
2012	31	3	3118403	2.2143135e+08	22319	9921.2	3
2012	17	1	1707553	3.769122e+07	3799	9921.35	3
2012	31	3	3160108	4.010394e+07	4041	9924.26	3
2012	32	3	3200169	1.1536077e+08	11624	9924.36	3
2012	35	3	3548203	6.463841e+07	6510	9929.1	3
2012	31	3	3150604	6.348765e+07	6391	9933.92	3
2012	43	4	4311429	2.475632e+07	2491	9938.31	3
2012	31	3	3100807	4.104304e+07	4129	9940.19	3
2012	26	2	2614204	4.1149608e+08	41391	9941.68	3
2012	31	3	3114105	1.3865405e+08	13932	9952.2	3
2012	16	1	1600402	1.7737788e+08	17794	9968.41	3
2012	52	5	5209200	1.3951772e+08	13994	9969.82	3
2012	21	2	2109908	7.8525889e+08	78733	9973.69	3
2012	41	4	4104253	2.5446633e+08	25513	9973.99	3
2012	31	3	3161205	6.466595e+07	6476	9985.48	3
2012	31	3	3157005	3.9501076e+08	39550	9987.63	3
2012	31	3	3138500	5.274158e+07	5279	9990.83	3
2012	17	1	1720903	1.5323636e+08	15336	9991.94	3
2012	26	2	2613701	1.04766589e+09	104782	9998.53	3
2012	35	3	3518909	4.827543e+07	4824	10007.34	3
2012	31	3	3116159	1.1353166e+08	11339	10012.49	3
2012	51	5	5103353	2.6263998e+08	26224	10015.25	3
2012	31	3	3146404	4.60291e+07	4592	10023.76	3
2012	17	1	1706506	5.438556e+07	5425	10024.99	3
2012	35	3	3529807	1.2166453e+08	12133	10027.57	3
2012	31	3	3109402	2.7161674e+08	27076	10031.64	3
2012	29	2	2913457	1.3070466e+08	13028	10032.6	3
2012	31	3	3172103	5.111759e+07	5093	10036.83	3
2012	27	2	2707800	6.632322e+07	6607	10038.33	3
2012	29	2	2904902	3.2394842e+08	32270	10038.69	3
2012	35	3	3544103	4.5199142e+08	45014	10041.13	3
2012	52	5	5221700	1.3875257e+08	13810	10047.25	3
2012	41	4	4103156	3.760922e+07	3742	10050.57	3
2012	41	4	4117503	3.6926173e+08	36717	10056.97	3
2012	25	2	2508901	4.2800552e+08	42537	10061.96	3
2012	31	3	3145505	2.594974e+07	2577	10069.75	3
2012	35	3	3553104	5.978974e+07	5936	10072.39	3
2012	52	5	5214101	3.865283e+07	3833	10084.22	3
2012	43	4	4301750	7.138886e+07	7072	10094.58	3
2012	31	3	3106101	3.433314e+07	3400	10097.98	3
2012	52	5	5206800	2.801383e+07	2774	10098.71	3
2012	41	4	4105201	1.7195866e+08	17027	10099.18	3
2012	35	3	3510609	3.7726595e+09	373358	10104.67	3
2012	31	3	3118502	1.750501e+07	1732	10106.82	3
2012	15	1	1507755	5.292506e+07	5236	10107.92	3
2012	31	3	3105004	7.968071e+07	7877	10115.62	3
2012	17	1	1704600	1.360913e+07	1345	10118.31	3
2012	28	2	2804904	1.3539922e+08	13379	10120.28	3
2012	41	4	4110078	1.1686031e+08	11546	10121.28	3
2012	52	5	5209606	3.635066e+07	3591	10122.71	3
2012	24	2	2402204	3.1897065e+08	31506	10124.12	3
2012	25	2	2504355	4.655147e+07	4598	10124.29	3
2012	31	3	3128402	8.817781e+07	8702	10133.05	3
2012	35	3	3550001	1.0533879e+08	10393	10135.55	3
2012	35	3	3542503	7.827718e+07	7713	10148.73	3
2012	31	3	3126000	6.846333e+07	6744	10151.74	3
2012	11	1	1101708	1.2881128e+08	12687	10153.01	3
2012	43	4	4307104	6.842362e+07	6739	10153.38	3
2012	35	3	3531704	4.262309e+07	4197	10155.61	3
2012	32	3	3202454	2.3207179e+08	22843	10159.43	3
2012	31	3	3158805	4.712153e+07	4638	10159.88	3
2012	31	3	3101631	6.323222e+07	6223	10161.05	3
2012	29	2	2933208	3.9378675e+08	38748	10162.76	3
2012	12	1	1200385	1.7879318e+08	17587	10166.21	3
2012	42	4	4215653	8.230588e+07	8091	10172.52	3
2012	16	1	1600709	1.3616969e+08	13385	10173.31	3
2012	29	2	2932903	9.1917173e+08	90319	10176.95	3
2012	42	4	4217253	4.962686e+07	4874	10181.96	3
2012	22	2	2205581	3.99402e+07	3920	10188.83	3
2012	24	2	2409506	3.513251e+07	3447	10192.2	3
2012	35	3	3534906	1.3593404e+08	13333	10195.31	3
2012	25	2	2510808	1.04076487e+09	102020	10201.58	3
2012	23	2	2311801	7.3209991e+08	71723	10207.32	3
2012	35	3	3554607	2.689004e+07	2634	10208.82	3
2012	52	5	5205208	4.839358e+07	4740	10209.62	3
2012	26	2	2611903	2.2832721e+08	22361	10210.96	3
2012	29	2	2912202	1.8197692e+08	17805	10220.55	3
2012	32	3	3201100	9.725034e+07	9514	10221.81	3
2012	31	3	3141900	3.927668e+07	3841	10225.64	3
2012	35	3	3553906	6.884265e+07	6731	10227.7	3
2012	21	2	2105153	1.335083e+08	13052	10228.95	3
2012	52	5	5209457	2.267952e+07	2217	10229.83	3
2012	43	4	4311775	7.002779e+07	6845	10230.5	3
2012	24	2	2412401	4.400831e+07	4300	10234.49	3
2012	23	2	2307601	5.7584899e+08	56255	10236.41	3
2012	31	3	3169703	1.8825581e+08	18383	10240.76	3
2012	15	1	1507458	2.5891319e+08	25277	10243.03	3
2012	23	2	2312403	4.6260275e+08	45141	10247.95	3
2012	52	5	5214879	2.90975e+07	2839	10249.21	3
2012	43	4	4301107	1.398921e+08	13647	10250.76	3
2012	51	5	5106703	1.764422e+07	1720	10258.27	3
2012	31	3	3165206	6.899377e+07	6724	10260.82	3
2012	31	3	3102001	1.4197341e+08	13829	10266.35	3
2012	43	4	4305173	1.0858637e+08	10570	10273.07	3
2012	43	4	4306072	2.897586e+07	2819	10278.77	3
2012	28	2	2804508	3.4271049e+08	33341	10278.95	3
2012	31	3	3148202	5.502228e+07	5352	10280.7	3
2012	41	4	4107009	1.4472383e+08	14077	10280.87	3
2012	31	3	3102803	1.2494361e+08	12153	10280.89	3
2012	31	3	3139607	2.7914154e+08	27148	10282.21	3
2012	23	2	2305100	4.067695e+07	3956	10282.34	3
2012	41	4	4103057	8.057958e+07	7834	10285.88	3
2012	41	4	4103503	8.365643e+07	8129	10291.11	3
2012	23	2	2305357	1.9315934e+08	18746	10304.03	3
2012	35	3	3543006	1.8364818e+08	17822	10304.58	3
2012	17	1	1707108	6.649743e+07	6452	10306.48	3
2012	35	3	3552700	1.5403761e+08	14943	10308.35	3
2012	26	2	2609501	3.2005955e+08	31029	10314.85	3
2012	24	2	2414605	1.3714519e+08	13295	10315.55	3
2012	41	4	4117271	7.309222e+07	7085	10316.47	3
2012	43	4	4305157	2.465977e+07	2390	10317.9	3
2012	17	1	1703883	2.439951e+07	2363	10325.65	3
2012	32	3	3201803	4.617462e+07	4471	10327.58	3
2012	26	2	2614857	2.1941312e+08	21234	10333.1	3
2012	31	3	3134806	7.772393e+07	7520	10335.63	3
2012	31	3	3171071	5.759477e+07	5569	10342.03	3
2012	43	4	4323002	2.49761804e+09	241190	10355.4	3
2012	31	3	3114006	1.1401024e+08	11007	10357.98	3
2012	31	3	3149507	3.302731e+07	3188	10359.89	3
2012	31	3	3149002	2.330841e+07	2247	10373.12	3
2012	31	3	3122405	6.024216e+07	5797	10391.95	3
2012	15	1	1502202	6.7158189e+08	64624	10392.14	3
2012	32	3	3204054	2.5040562e+08	24071	10402.79	3
2012	42	4	4215687	2.932653e+07	2818	10406.86	3
2012	24	2	2411601	3.034046e+07	2915	10408.39	3
2012	35	3	3527702	5.361698e+07	5145	10421.18	3
2012	41	4	4117800	1.5158452e+08	14538	10426.78	3
2012	51	5	5106174	3.323213e+07	3187	10427.4	3
2012	32	3	3200102	3.2241159e+08	30919	10427.62	3
2012	14	1	1400175	1.5346661e+08	14707	10434.94	3
2012	23	2	2301901	5.9090044e+08	56576	10444.37	3
2012	21	2	2110302	1.4934078e+08	14294	10447.79	3
2012	31	3	3128105	1.4537843e+08	13911	10450.61	3
2012	35	3	3523800	7.903809e+07	7559	10456.16	3
2012	52	5	5208400	1.1191927e+08	10699	10460.72	3
2012	17	1	1703206	4.646859e+07	4442	10461.19	3
2012	14	1	1400027	1.0408098e+08	9936	10475.14	3
2012	35	3	3549003	2.918398e+07	2783	10486.52	3
2012	31	3	3119708	3.482583e+07	3319	10492.87	3
2012	50	5	5000708	2.5246759e+08	24041	10501.54	3
2012	17	1	1713601	7.295399e+07	6946	10503.02	3
2012	51	5	5107750	3.968046e+07	3777	10505.82	3
2012	31	3	3108404	1.5646964e+08	14893	10506.25	3
2012	12	1	1200203	8.3865659e+08	79819	10506.98	3
2012	52	5	5211206	2.7387403e+08	26033	10520.26	3
2012	14	1	1400456	1.1538767e+08	10953	10534.8	3
2012	35	3	3529104	2.21674e+07	2101	10550.88	3
2012	16	1	1600212	5.180491e+07	4910	10550.9	3
2012	41	4	4121901	1.4147434e+08	13401	10557	3
2012	11	1	1100502	1.0487328e+08	9933	10558.07	3
2012	35	3	3505005	3.342203e+07	3165	10559.88	3
2012	31	3	3129905	3.585444e+07	3395	10560.95	3
2012	41	4	4124202	2.857822e+07	2705	10564.96	3
2012	28	2	2806602	1.2173862e+08	11522	10565.75	3
2012	15	1	1500800	5.11454887e+09	483821	10571.16	3
2012	29	2	2931350	1.51201444e+09	143001	10573.45	3
2012	33	3	3303955	2.454522e+08	23208	10576.19	3
2012	26	2	2608503	2.1927774e+08	20733	10576.27	3
2012	35	3	3523503	1.9514815e+08	18446	10579.43	3
2012	31	3	3121605	4.8828257e+08	46125	10586.07	3
2012	41	4	4102505	1.3171304e+08	12437	10590.42	3
2012	31	3	3158003	1.12094e+08	10584	10590.89	3
2012	31	3	3130002	3.05501e+07	2883	10596.63	3
2012	31	3	3119005	3.653799e+07	3447	10599.94	3
2012	52	5	5203104	4.17372e+07	3933	10612.05	3
2012	23	2	2310209	3.4230274e+08	32255	10612.39	3
2012	27	2	2702405	5.1906787e+08	48876	10620.1	3
2012	17	1	1710904	3.793618e+07	3571	10623.41	3
2012	31	3	3110202	4.277643e+07	4026	10625.05	3
2012	41	4	4111704	5.262465e+07	4950	10631.24	3
2012	51	5	5106851	3.714961e+07	3490	10644.59	3
2012	52	5	5204904	1.9818557e+08	18616	10645.98	3
2012	52	5	5221452	3.67852e+07	3455	10646.95	3
2012	13	1	1302009	8.890155e+07	8348	10649.44	3
2012	33	3	3301405	2.3019615e+08	21613	10650.82	3
2012	31	3	3155306	5.724279e+07	5372	10655.77	3
2012	31	3	3131505	1.0241887e+08	9607	10660.86	3
2012	29	2	2918407	2.1486735e+09	201499	10663.44	3
2012	35	3	3539400	1.3117115e+08	12297	10666.92	3
2012	42	4	4207858	2.205568e+07	2067	10670.38	3
2012	43	4	4304507	5.713387e+08	53533	10672.64	3
2012	42	4	4201000	8.938184e+07	8374	10673.73	3
2012	32	3	3204500	1.3032444e+08	12207	10676.21	3
2012	31	3	3112307	3.7768441e+08	35368	10678.7	3
2012	31	3	3149705	1.0038276e+08	9396	10683.56	3
2012	31	3	3152709	9.076076e+07	8495	10684.02	3
2012	31	3	3166709	9.026099e+07	8447	10685.57	3
2012	52	5	5204607	3.657207e+07	3421	10690.46	3
2012	35	3	3525508	1.2814628e+08	11974	10702.04	3
2012	14	1	1400605	7.457665e+07	6968	10702.73	3
2012	31	3	3154903	1.5054426e+08	14042	10721	3
2012	12	1	1200104	2.3870436e+08	22261	10722.98	3
2012	29	2	2915502	2.2403211e+08	20878	10730.54	3
2012	29	2	2918001	1.63589382e+09	152372	10736.18	3
2012	52	5	5201603	4.030867e+07	3753	10740.39	3
2012	43	4	4300505	8.260765e+07	7689	10743.61	3
2012	31	3	3124401	4.803099e+07	4470	10745.19	3
2012	31	3	3161502	1.1448279e+08	10648	10751.58	3
2012	31	3	3168309	4.129637e+07	3840	10754.26	3
2012	32	3	3202553	9.592844e+07	8919	10755.51	3
2012	52	5	5219605	4.182816e+07	3889	10755.51	3
2012	35	3	3546306	3.291168e+08	30593	10757.91	3
2012	52	5	5207535	7.446435e+07	6918	10763.85	3
2012	31	3	3140530	7.963931e+07	7398	10764.98	3
2012	43	4	4306908	2.6558679e+08	24671	10765.14	3
2012	21	2	2109502	2.16374e+08	20093	10768.63	3
2012	31	3	3162559	1.1282681e+08	10476	10770.03	3
2012	29	2	2914604	7.2740652e+08	67527	10772.08	3
2012	52	5	5210901	2.0622427e+08	19142	10773.39	3
2012	35	3	3555505	4.814844e+07	4468	10776.28	3
2012	52	5	5214705	2.447396e+07	2271	10776.73	3
2012	31	3	3137700	2.1150753e+08	19622	10779.1	3
2012	17	1	1717503	7.404776e+07	6869	10779.99	3
2012	52	5	5220157	5.064575e+07	4697	10782.57	3
2012	35	3	3505609	3.1452053e+08	29144	10791.95	3
2012	17	1	1702307	7.232529e+07	6700	10794.82	3
2012	33	3	3300159	1.1386236e+08	10545	10797.76	3
2012	32	3	3203700	1.9658486e+08	18202	10800.18	3
2012	31	3	3108552	1.5820959e+08	14642	10805.19	3
2012	41	4	4125456	4.096913e+07	3789	10812.65	3
2012	35	3	3503109	6.6454e+07	6132	10837.25	3
2012	52	5	5213855	2.533745e+07	2336	10846.51	3
2012	51	5	5100359	6.023127e+07	5553	10846.62	3
2012	41	4	4121000	1.2771584e+08	11773	10848.2	3
2012	52	5	5200159	2.690786e+07	2480	10849.95	3
2012	11	1	1100148	2.159817e+08	19891	10858.26	3
2012	43	4	4306502	1.575659e+08	14503	10864.37	3
2012	26	2	2610004	6.5320116e+08	60091	10870.2	3
2012	15	1	1506807	3.25504247e+09	299419	10871.2	3
2012	23	2	2310704	3.8949646e+08	35823	10872.8	3
2012	52	5	5219803	1.2526544e+08	11520	10873.74	3
2012	42	4	4207205	1.24114e+08	11411	10876.7	3
2012	43	4	4308300	1.1536796e+08	10606	10877.61	3
2012	16	1	1600055	4.945086e+07	4545	10880.28	3
2012	15	1	1501907	2.8763603e+08	26400	10895.3	3
2012	11	1	1100130	3.5307101e+08	32403	10896.24	3
2012	43	4	4314704	1.1340957e+08	10407	10897.43	3
2012	43	4	4302451	8.337787e+07	7651	10897.64	3
2012	35	3	3528601	9.91986e+07	9101	10899.75	3
2012	31	3	3117702	1.4233014e+08	13052	10904.85	3
2012	43	4	4321352	5.843216e+07	5353	10915.78	3
2012	31	3	3114600	4.320516e+07	3958	10915.91	3
2012	41	4	4125357	6.503017e+07	5956	10918.43	3
2012	35	3	3516804	4.679097e+07	4285	10919.71	3
2012	15	1	1502772	1.9776722e+08	18108	10921.54	3
2012	41	4	4119251	2.878221e+07	2635	10923.04	3
2012	41	4	4115507	5.027708e+07	4602	10925.05	3
2012	31	3	3130507	1.2709475e+08	11633	10925.36	3
2012	43	4	4308805	9.184934e+07	8404	10929.24	3
2012	35	3	3533254	5.247276e+07	4799	10934.1	3
2012	24	2	2413359	1.1595889e+08	10597	10942.62	3
2012	26	2	2613008	5.9575009e+08	54433	10944.65	3
2012	31	3	3125309	3.661517e+07	3342	10956.06	3
2012	31	3	3129202	6.787042e+07	6192	10960.99	3
2012	11	1	1101757	1.0560032e+08	9633	10962.35	3
2012	35	3	3508900	4.469102e+07	4072	10975.2	3
2012	14	1	1400233	9.312723e+07	8480	10981.98	3
2012	29	2	2909802	6.5309893e+08	59470	10981.99	3
2012	52	5	5210562	4.985479e+07	4533	10998.19	3
2012	25	2	2506301	6.1647226e+08	55977	11012.96	3
2012	31	3	3144672	3.985449e+07	3617	11018.66	3
2012	33	3	3300456	5.229925e+09	474596	11019.74	3
2012	35	3	3501806	6.307186e+07	5723	11020.77	3
2012	31	3	3112406	7.757939e+07	7039	11021.37	3
2012	52	5	5207501	3.648478e+07	3309	11025.92	3
2012	42	4	4206207	1.1862235e+08	10758	11026.43	3
2012	31	3	3120201	1.2747236e+08	11553	11033.7	3
2012	35	3	3521150	5.093799e+07	4613	11042.27	3
2012	31	3	3124005	1.9990628e+08	18087	11052.48	3
2012	41	4	4122156	1.4518673e+08	13125	11061.85	3
2012	51	5	5105176	1.3413963e+08	12125	11063.06	3
2012	35	3	3518503	1.6848898e+08	15225	11066.6	3
2012	23	2	2307304	2.82979563e+09	255648	11069.11	3
2012	43	4	4321832	3.171817e+07	2865	11070.91	3
2012	26	2	2612505	1.01765892e+09	91891	11074.63	3
2012	31	3	3171709	9.542164e+07	8612	11080.08	3
2012	15	1	1504000	2.8648208e+08	25846	11084.19	3
2012	23	2	2305506	1.08784687e+09	98138	11084.87	3
2012	26	2	2615300	5.9161891e+08	53360	11087.31	3
2012	31	3	3102902	1.2371628e+08	11151	11094.64	3
2012	35	3	3556958	1.938799e+07	1747	11097.88	3
2012	31	3	3124203	2.5758218e+08	23208	11098.85	3
2012	43	4	4307203	5.65077e+07	5090	11101.71	3
2012	31	3	3140209	3.128817e+07	2818	11102.97	3
2012	31	3	3155801	1.9135211e+08	17224	11109.62	3
2012	31	3	3162906	2.8051356e+08	25249	11109.89	3
2012	28	2	2807105	4.3321429e+08	38988	11111.48	3
2012	31	3	3170479	3.593499e+07	3231	11121.94	3
2012	43	4	4311981	4.197479e+07	3774	11122.1	3
2012	31	3	3117801	1.1804125e+08	10609	11126.52	3
2012	31	3	3117900	1.1945846e+08	10732	11131.05	3
2012	25	2	2516201	7.3993227e+08	66457	11134	3
2012	42	4	4201950	1.1270201e+08	10121	11135.46	3
2012	29	2	2904704	2.0632449e+08	18528	11135.82	3
2012	43	4	4317004	9.12453e+07	8185	11147.87	3
2012	51	5	5107883	1.581897e+07	1419	11147.97	3
2012	52	5	5221858	1.54717943e+09	138740	11151.65	3
2012	35	3	3527801	4.880283e+07	4372	11162.59	3
2012	31	3	3151701	1.7960992e+08	16082	11168.38	3
2012	26	2	2605707	3.3483001e+08	29973	11171.05	3
2012	32	3	3203106	1.2270602e+08	10984	11171.34	3
2012	24	2	2409407	3.1500124e+08	28197	11171.45	3
2012	43	4	4301636	1.2703514e+08	11371	11171.85	3
2012	11	1	1101302	1.3063185e+08	11686	11178.49	3
2012	23	2	2309607	7.2141005e+08	64521	11181.01	3
2012	35	3	3549201	2.854042e+07	2552	11183.55	3
2012	43	4	4314498	5.08424e+07	4545	11186.45	3
2012	52	5	5200803	9.136053e+07	8164	11190.66	3
2012	35	3	3546504	6.206864e+07	5542	11199.68	3
2012	52	5	5212006	3.336338e+07	2977	11207.05	3
2012	43	4	4300455	4.64406e+07	4141	11214.83	3
2012	35	3	3540507	9.621389e+07	8579	11215.05	3
2012	52	5	5220280	2.238559e+07	1996	11215.23	3
2012	41	4	4117214	4.433884e+07	3953	11216.5	3
2012	17	1	1703305	4.472611e+07	3987	11217.99	3
2012	43	4	4314209	8.713825e+07	7767	11219.03	3
2012	51	5	5101308	1.1357619e+08	10122	11220.73	3
2012	15	1	1508357	1.5459513e+08	13777	11221.25	3
2012	17	1	1700400	8.369941e+07	7452	11231.81	3
2012	52	5	5220702	3.200764e+07	2847	11242.58	3
2012	11	1	1100346	1.8442656e+08	16404	11242.78	3
2012	29	2	2917904	1.1670894e+08	10377	11246.89	3
2012	16	1	1600279	4.6885125e+08	41668	11252.07	3
2012	43	4	4312450	7.047308e+07	6262	11254.09	3
2012	31	3	3128808	8.068323e+07	7164	11262.32	3
2012	35	3	3517604	1.9984696e+08	17738	11266.6	3
2012	29	2	2908101	2.0554849e+08	18235	11272.2	3
2012	27	2	2708501	3.7028501e+08	32846	11273.37	3
2012	31	3	3123205	1.5432172e+08	13686	11275.88	3
2012	35	3	3553500	8.939858e+07	7928	11276.31	3
2012	31	3	3122702	5.855293e+07	5192	11277.53	3
2012	26	2	2610707	3.45429276e+09	306239	11279.73	3
2012	43	4	4315008	5.944728e+07	5265	11291.03	3
2012	31	3	3145802	3.464641e+07	3066	11300.2	3
2012	33	3	3303609	5.4400438e+08	48129	11303.05	3
2012	17	1	1711100	2.751628e+07	2434	11304.96	3
2012	31	3	3153707	3.782702e+07	3346	11305.15	3
2012	43	4	4311601	6.40377e+07	5661	11312.08	3
2012	42	4	4202081	3.244179e+07	2866	11319.54	3
2012	41	4	4114351	3.426011e+07	3026	11321.91	3
2012	31	3	3107000	2.946606e+07	2602	11324.39	3
2012	31	3	3144409	5.279829e+07	4661	11327.68	3
2012	35	3	3546900	9.414793e+07	8308	11332.2	3
2012	43	4	4303400	5.661726e+07	4995	11334.79	3
2012	35	3	3512605	5.569594e+07	4913	11336.44	3
2012	43	4	4310413	2.552011e+07	2251	11337.23	3
2012	16	1	1600501	2.4564987e+08	21661	11340.65	3
2012	31	3	3120409	5.696863e+07	5023	11341.56	3
2012	51	5	5102850	9.416485e+07	8298	11347.9	3
2012	17	1	1702406	1.2030263e+08	10594	11355.73	3
2012	29	2	2918456	1.1324131e+08	9972	11355.93	3
2012	31	3	3137809	2.2446754e+08	19752	11364.29	3
2012	52	5	5219506	3.198372e+07	2813	11369.97	3
2012	35	3	3532843	2.342521e+07	2059	11376.99	3
2012	43	4	4314605	2.2650325e+08	19906	11378.64	3
2012	31	3	3113305	3.6834154e+08	32353	11385.08	3
2012	31	3	3165800	2.041497e+07	1793	11385.93	3
2012	41	4	4113759	5.798689e+07	5084	11405.76	3
2012	51	5	5103437	5.612219e+07	4918	11411.59	3
2012	52	5	5202155	8.606717e+07	7541	11413.23	3
2012	41	4	4126256	9.6575848e+08	84573	11419.23	3
2012	41	4	4115101	1.1668493e+08	10214	11424.02	3
2012	52	5	5219357	4.228976e+07	3701	11426.58	3
2012	35	3	3501509	3.457075e+07	3025	11428.35	3
2012	41	4	4100301	9.633268e+07	8429	11428.72	3
2012	31	3	3162302	3.118482e+07	2728	11431.39	3
2012	24	2	2407609	4.874307e+07	4259	11444.72	3
2012	41	4	4100905	6.36826e+07	5562	11449.59	3
2012	41	4	4108551	3.736748e+07	3262	11455.39	3
2012	43	4	4313490	4.576582e+07	3995	11455.77	3
2012	41	4	4107652	9.6833041e+08	84514	11457.63	3
2012	51	5	5103007	2.0784052e+08	18133	11462	3
2012	23	2	2303709	3.85381696e+09	336091	11466.59	3
2012	31	3	3164431	3.249466e+07	2832	11474.1	3
2012	15	1	1503903	5.6801538e+08	49486	11478.3	3
2012	43	4	4310538	5.826526e+07	5076	11478.58	3
2012	29	2	2920601	4.949169e+08	43114	11479.26	3
2012	31	3	3119401	1.2015702e+09	104637	11483.22	3
2012	31	3	3106903	1.5828852e+08	13783	11484.33	3
2012	33	3	3302809	2.0720156e+08	18024	11495.87	3
2012	43	4	4309571	3.399056e+07	2954	11506.62	3
2012	29	2	2925303	1.51484088e+09	131642	11507.28	3
2012	43	4	4311122	4.697839e+07	4081	11511.49	3
2012	11	1	1101435	8.501359e+07	7382	11516.34	3
2012	43	4	4305132	5.160272e+07	4478	11523.61	3
2012	23	2	2313807	2.3384779e+08	20289	11525.84	3
2012	43	4	4320354	6.04876e+07	5245	11532.43	3
2012	31	3	3115508	2.4969701e+08	21641	11538.15	3
2012	31	3	3114709	3.900241e+07	3380	11539.17	3
2012	14	1	1400308	1.7693044e+08	15328	11542.96	3
2012	35	3	3510203	5.3218272e+08	46095	11545.35	3
2012	31	3	3128907	8.545412e+07	7399	11549.41	3
2012	31	3	3164001	9.501003e+07	8223	11554.18	3
2012	31	3	3104304	1.6129001e+08	13958	11555.38	3
2012	35	3	3508009	2.1618703e+08	18705	11557.71	3
2012	41	4	4115739	4.300824e+07	3716	11573.8	3
2012	31	3	3111002	2.3967965e+08	20707	11574.81	3
2012	24	2	2411429	2.951477e+07	2549	11578.96	3
2012	41	4	4123956	4.202149e+07	3629	11579.36	3
2012	41	4	4106803	2.0956247e+08	18097	11579.96	3
2012	11	1	1101484	6.792336e+07	5862	11587.06	3
2012	29	2	2917508	9.2232415e+08	79580	11589.9	3
2012	42	4	4216800	1.0551957e+08	9104	11590.46	3
2012	35	3	3507159	4.201991e+07	3623	11598.1	3
2012	52	5	5204656	4.232453e+07	3649	11598.94	3
2012	35	3	3523701	6.948748e+07	5990	11600.58	3
2012	11	1	1100403	2.0590635e+08	17742	11605.59	3
2012	50	5	5004007	1.1509833e+08	9911	11613.19	3
2012	26	2	2609600	4.40463243e+09	379271	11613.42	3
2012	35	3	3534104	7.132651e+07	6141	11614.8	3
2012	52	5	5200100	1.9066209e+08	16408	11620.07	3
2012	43	4	4309753	5.076877e+07	4368	11622.89	3
2012	41	4	4110300	3.488294e+07	3000	11627.65	3
2012	33	3	3303005	3.1179981e+08	26810	11629.98	3
2012	52	5	5203939	2.961002e+07	2546	11630.02	3
2012	41	4	4104451	1.5091164e+08	12974	11631.85	3
2012	35	3	3511904	8.509959e+07	7316	11631.98	3
2012	52	5	5215603	3.3299998e+08	28601	11642.95	3
2012	25	2	2503704	6.8850421e+08	59130	11643.91	3
2012	21	2	2111607	2.0810231e+08	17868	11646.65	3
2012	41	4	4102901	1.8535091e+08	15903	11655.09	3
2012	41	4	4121208	2.0262709e+08	17364	11669.38	3
2012	35	3	3532108	4.927105e+07	4219	11678.37	3
2012	43	4	4320651	2.821766e+07	2416	11679.49	3
2012	22	2	2207405	5.796234e+07	4962	11681.25	3
2012	26	2	2600054	1.11355683e+09	95243	11691.74	3
2012	14	1	1400209	2.2238896e+08	19019	11692.99	3
2012	31	3	3118809	3.0500437e+08	26079	11695.4	3
2012	41	4	4116109	1.4611346e+08	12487	11701.25	3
2012	52	5	5221908	4.30728e+07	3681	11701.39	3
2012	43	4	4323101	6.040348e+07	5158	11710.64	3
2012	11	1	1100338	2.7777502e+08	23719	11711.08	3
2012	35	3	3551009	3.94443219e+09	336809	11711.18	3
2012	52	5	5221007	4.144801e+07	3535	11725.04	3
2012	35	3	3554409	1.010794e+08	8619	11727.51	3
2012	43	4	4315305	2.6828093e+08	22873	11729.15	3
2012	35	3	3548401	5.098872e+07	4347	11729.63	3
2012	52	5	5202601	4.180033e+07	3562	11735.07	3
2012	28	2	2805703	3.3580014e+08	28612	11736.34	3
2012	43	4	4321436	1.18206e+08	10070	11738.43	3
2012	22	2	2208007	8.8608277e+08	75481	11739.15	3
2012	42	4	4217154	2.216492e+07	1887	11746.12	3
2012	31	3	3110004	4.8667199e+08	41423	11748.84	3
2012	52	5	5219902	7.20725e+07	6134	11749.67	3
2012	43	4	4316303	8.359252e+07	7114	11750.42	3
2012	52	5	5221403	1.26946811e+09	107966	11758.04	3
2012	41	4	4102752	4.53992e+07	3861	11758.4	3
2012	35	3	3540259	4.887915e+07	4155	11763.93	3
2012	42	4	4204459	2.904963e+07	2469	11765.75	3
2012	35	3	3517208	1.2814654e+08	10891	11766.28	3
2012	43	4	4319208	6.628457e+07	5625	11783.92	3
2012	31	3	3130200	1.1260224e+08	9553	11787.11	3
2012	43	4	4320263	8.359686e+07	7087	11795.8	3
2012	43	4	4318457	3.163029e+07	2678	11811.16	3
2012	13	1	1303569	3.1830007e+08	26948	11811.64	3
2012	31	3	3166402	2.124141e+07	1797	11820.48	3
2012	35	3	3534807	9.338634e+07	7899	11822.55	3
2012	11	1	1101005	1.187351e+08	10040	11826.21	3
2012	41	4	4106209	1.9267859e+08	16292	11826.58	3
2012	31	3	3151404	3.0480163e+08	25771	11827.31	3
2012	31	3	3107307	5.5914501e+08	47236	11837.26	3
2012	32	3	3203601	6.652165e+07	5619	11838.7	3
2012	31	3	3110301	1.629516e+08	13764	11838.97	3
2012	12	1	1200252	1.8576068e+08	15679	11847.74	3
2012	41	4	4124707	1.3360317e+08	11275	11849.51	3
2012	41	4	4104402	1.9360811e+08	16332	11854.53	3
2012	52	5	5218391	3.942479e+07	3325	11857.08	3
2012	52	5	5203609	3.916918e+07	3302	11862.26	3
2012	31	3	3161809	1.277417e+08	10765	11866.39	3
2012	42	4	4203204	7.774946e+08	65520	11866.52	3
2012	43	4	4318101	2.2576474e+08	19020	11869.86	3
2012	51	5	5106158	1.4676969e+08	12352	11882.26	3
2012	31	3	3150109	3.346277e+07	2816	11883.09	3
2012	11	1	1101609	1.257958e+08	10575	11895.58	3
2012	35	3	3530003	3.396735e+07	2854	11901.66	3
2012	31	3	3102308	1.8104974e+08	15212	11901.77	3
2012	21	2	2104552	1.9822196e+08	16651	11904.51	3
2012	41	4	4105102	1.3215807e+08	11096	11910.42	3
2012	51	5	5108352	3.635594e+07	3052	11912.17	3
2012	43	4	4310850	4.806891e+07	4032	11921.85	3
2012	43	4	4314555	3.181488e+07	2668	11924.62	3
2012	31	3	3167509	3.036841e+07	2546	11927.89	3
2012	31	3	3166907	9.003956e+07	7548	11928.93	3
2012	31	3	3139706	8.713739e+07	7304	11930.09	3
2012	35	3	3523206	5.7437424e+08	48143	11930.59	3
2012	35	3	3500758	6.050484e+07	5071	11931.54	3
2012	31	3	3100203	2.7135572e+08	22740	11932.97	3
2012	42	4	4215075	5.725492e+07	4789	11955.51	3
2012	25	2	2511202	3.2858147e+08	27479	11957.55	3
2012	52	5	5203401	1.0139974e+08	8477	11961.75	3
2012	43	4	4322376	2.896391e+07	2421	11963.61	3
2012	35	3	3551108	1.1031576e+08	9212	11975.22	3
2012	50	5	5003488	1.2599598e+08	10519	11977.94	3
2012	43	4	4314068	6.254279e+07	5220	11981.38	3
2012	35	3	3521507	8.832042e+07	7369	11985.4	3
2012	41	4	4103107	1.3523622e+08	11280	11989.03	3
2012	32	3	3203007	3.2988954e+08	27512	11990.75	3
2012	43	4	4317707	1.3175747e+08	10987	11992.12	3
2012	43	4	4312252	9.20899e+07	7678	11994	3
2012	35	3	3515103	7.6356917e+08	63653	11995.81	3
2012	41	4	4112702	1.4347859e+08	11958	11998.54	3
2012	31	3	3118700	1.1093903e+08	9241	12005.09	3
2012	52	5	5211800	5.1851052e+08	43167	12011.73	3
2012	43	4	4321477	7.576677e+07	6305	12016.93	3
2012	52	5	5210307	3.449168e+07	2870	12018.01	3
2012	17	1	1721307	2.653763e+07	2208	12018.86	3
2012	27	2	2703205	2.8328878e+08	23570	12019.04	3
2012	35	3	3531100	5.7683202e+08	47984	12021.34	3
2012	52	5	5207600	7.462752e+07	6206	12025.06	3
2012	41	4	4106555	4.643126e+07	3860	12028.82	3
2012	51	5	5106778	1.331608e+08	11069	12030.07	3
2012	17	1	1701101	5.198317e+07	4319	12035.93	3
2012	33	3	3301504	2.4928144e+08	20707	12038.51	3
2012	31	3	3154309	2.059469e+08	17107	12038.75	3
2012	42	4	4206009	1.5904818e+08	13211	12039.07	3
2012	52	5	5210158	3.430866e+07	2848	12046.58	3
2012	41	4	4100459	4.699156e+07	3900	12049.12	3
2012	11	1	1101807	9.592652e+07	7961	12049.56	3
2012	51	5	5103809	4.481888e+07	3718	12054.57	3
2012	26	2	2606002	1.58256371e+09	131169	12065.07	3
2012	51	5	5100805	1.0694273e+08	8855	12077.1	3
2012	51	5	5108808	5.82721e+07	4824	12079.62	3
2012	43	4	4321493	3.523593e+07	2916	12083.65	3
2012	35	3	3507704	6.186025e+07	5118	12086.8	3
2012	11	1	1100452	4.0380512e+08	33397	12091.06	3
2012	35	3	3547650	1.765208e+07	1458	12107.05	3
2012	35	3	3503950	2.181777e+07	1802	12107.53	3
2012	31	3	3144300	4.930031e+08	40716	12108.34	3
2012	41	4	4123709	1.0541716e+08	8701	12115.52	3
2012	22	2	2203909	7.0473937e+08	58158	12117.67	3
2012	31	3	3108305	2.125532e+08	17523	12129.95	3
2012	41	4	4116208	1.915425e+08	15785	12134.46	3
2012	52	5	5213905	5.938628e+07	4888	12149.4	3
2012	31	3	3112109	6.370589e+07	5241	12155.29	3
2012	33	3	3301850	6.5072057e+08	53527	12156.87	3
2012	41	4	4108007	1.3468481e+08	11076	12160.06	3
2012	11	1	1100700	1.5622829e+08	12847	12160.68	3
2012	33	3	3304904	1.23578115e+10	1016128	12161.67	3
2012	35	3	3526209	3.5369717e+08	29081	12162.48	3
2012	51	5	5106265	9.348534e+07	7685	12164.65	3
2012	41	4	4126900	7.01825e+07	5769	12165.45	3
2012	33	3	3301876	2.9307228e+08	24079	12171.28	3
2012	43	4	4312443	3.808462e+07	3129	12171.5	3
2012	14	1	1400472	3.0853371e+08	25319	12185.86	3
2012	31	3	3144607	3.1535332e+08	25871	12189.45	3
2012	41	4	4112504	1.4785616e+08	12121	12198.35	3
2012	35	3	3521002	3.6362455e+08	29798	12202.99	3
2012	35	3	3537701	6.575407e+07	5387	12206.06	3
2012	43	4	4314027	8.978581e+07	7355	12207.45	3
2012	21	2	2100055	1.2994899e+09	106422	12210.73	3
2012	35	3	3538204	1.6393556e+08	13425	12211.21	3
2012	31	3	3169000	1.9477268e+08	15947	12213.75	3
2012	35	3	3505104	8.193675e+07	6708	12214.78	3
2012	11	1	1101500	1.4192982e+08	11619	12215.32	3
2012	42	4	4201109	3.924025e+07	3211	12220.57	3
2012	11	1	1100106	5.161715e+08	42202	12230.97	3
2012	11	1	1101203	1.2480677e+08	10203	12232.36	3
2012	35	3	3549508	1.0346384e+08	8456	12235.55	3
2012	42	4	4204178	4.288232e+07	3503	12241.6	3
2012	33	3	3302502	2.82280867e+09	230568	12242.85	3
2012	52	5	5200829	4.272011e+07	3489	12244.23	3
2012	35	3	3554805	5.1350753e+08	41915	12251.16	3
2012	52	5	5217302	2.8523014e+08	23272	12256.37	3
2012	51	5	5101209	1.297539e+07	1058	12264.07	3
2012	51	5	5106828	1.3725655e+08	11188	12268.19	3
2012	24	2	2403103	5.2683531e+08	42934	12270.82	3
2012	31	3	3135308	4.920724e+07	4010	12271.13	3
2012	11	1	1100064	2.2207066e+08	18093	12273.84	3
2012	43	4	4315073	2.162399e+07	1760	12286.36	3
2012	12	1	1200138	1.0791395e+08	8782	12288.08	3
2012	52	5	5213004	1.4646129e+08	11907	12300.44	3
2012	35	3	3522109	1.09904501e+09	89332	12302.93	3
2012	41	4	4122107	4.064489e+07	3302	12309.17	3
2012	42	4	4204152	3.39854e+07	2760	12313.55	3
2012	24	2	2401404	1.0696964e+08	8687	12313.76	3
2012	11	1	1101450	6.150759e+07	4990	12326.17	3
2012	51	5	5102694	5.868827e+07	4756	12339.84	3
2012	52	5	5221577	3.600019e+07	2917	12341.51	3
2012	41	4	4127882	8.216204e+07	6656	12344.06	3
2012	31	3	3119104	2.9405794e+08	23819	12345.52	3
2012	43	4	4309159	4.958249e+07	4016	12346.24	3
2012	31	3	3142205	1.7299212e+08	14009	12348.64	3
2012	35	3	3526506	1.1526203e+08	9330	12353.92	3
2012	35	3	3538907	2.8538728e+08	23098	12355.5	3
2012	31	3	3117207	3.405063e+07	2755	12359.58	3
2012	31	3	3159209	1.111224e+08	8990	12360.67	3
2012	31	3	3112000	1.8078137e+08	14616	12368.73	3
2012	35	3	3523107	4.07138454e+09	329144	12369.61	3
2012	41	4	4113304	3.821967e+08	30891	12372.43	3
2012	17	1	1712009	3.51192e+07	2838	12374.63	3
2012	42	4	4202156	3.270965e+07	2643	12375.95	3
2012	41	4	4103479	5.243541e+07	4236	12378.52	3
2012	31	3	3137502	2.1418395e+08	17293	12385.59	3
2012	23	2	2301109	8.7192102e+08	70363	12391.75	3
2012	52	5	5208806	4.4169067e+08	35617	12401.12	3
2012	26	2	2604007	9.4932726e+08	76527	12405.13	3
2012	31	3	3113404	1.07168139e+09	86364	12408.89	3
2012	35	3	3544202	1.3508866e+08	10880	12416.24	3
2012	52	5	5209804	4.907754e+07	3951	12421.55	3
2012	31	3	3146909	1.7945704e+08	14433	12433.8	3
2012	50	5	5005608	3.2327666e+08	25986	12440.42	3
2012	41	4	4107751	1.0186173e+08	8181	12451.01	3
2012	35	3	3538600	3.1611845e+08	25384	12453.45	3
2012	12	1	1200450	2.5639548e+08	20588	12453.64	3
2012	43	4	4315552	4.301016e+07	3453	12455.88	3
2012	43	4	4313441	2.811761e+07	2257	12457.96	3
2012	17	1	1718451	3.023769e+07	2427	12458.88	3
2012	17	1	1718840	4.145437e+07	3326	12463.73	3
2012	31	3	3131000	7.287239e+07	5846	12465.34	3
2012	12	1	1200013	1.6219883e+08	13011	12466.28	3
2012	17	1	1705102	4.086471e+07	3278	12466.35	3
2012	43	4	4301073	3.435771e+07	2756	12466.51	3
2012	15	1	1506138	9.652076e+08	77415	12467.97	3
2012	43	4	4312104	6.288883e+07	5041	12475.47	3
2012	35	3	3527504	2.827208e+07	2264	12487.67	3
2012	50	5	5007950	1.3041913e+08	10442	12489.86	3
2012	16	1	1600550	5.022423e+07	4021	12490.48	3
2012	52	5	5212808	1.3064596e+08	10455	12496.03	3
2012	35	3	3537909	3.3466538e+08	26778	12497.77	3
2012	51	5	5104104	4.1028705e+08	32823	12499.99	3
2012	35	3	3538303	4.4327e+07	3546	12500.56	3
2012	35	3	3518008	2.456521e+07	1965	12501.38	3
2012	14	1	1400159	1.398772e+08	11188	12502.43	3
2012	35	3	3557204	1.5131191e+08	12102	12503.05	3
2012	41	4	4111308	4.317419e+07	3453	12503.39	3
2012	41	4	4108700	8.065029e+07	6438	12527.23	3
2012	33	3	3303203	1.98051943e+09	157986	12536.04	3
2012	42	4	4216404	8.82047e+07	7035	12537.98	3
2012	31	3	3114204	2.5649211e+08	20444	12546.08	3
2012	24	2	2402006	7.9777002e+08	63571	12549.28	3
2012	43	4	4320578	2.622147e+07	2089	12552.16	3
2012	41	4	4124004	6.516692e+07	5191	12553.83	3
2012	42	4	4214151	3.490673e+07	2780	12556.38	3
2012	51	5	5102504	1.11622963e+09	88897	12556.44	3
2012	31	3	3134509	4.871041e+07	3879	12557.47	3
2012	43	4	4310504	9.929842e+07	7902	12566.24	3
2012	35	3	3517000	1.3627086e+08	10825	12588.53	3
2012	31	3	3160702	5.818392e+08	46208	12591.74	3
2012	33	3	3303104	1.8999168e+08	15076	12602.26	3
2012	33	3	3306156	1.224961e+08	9720	12602.48	3
2012	35	3	3556800	2.2054076e+08	17499	12603.05	3
2012	50	5	5007307	6.273307e+07	4977	12604.6	3
2012	41	4	4119004	8.41506e+07	6672	12612.5	3
2012	52	5	5214804	2.628136e+07	2083	12617.07	3
2012	42	4	4205357	2.001782e+07	1585	12629.54	3
2012	31	3	3167400	7.648142e+07	6053	12635.29	3
2012	50	5	5003454	1.5499108e+08	12259	12643.04	3
2012	35	3	3535606	2.2057684e+08	17446	12643.41	3
2012	31	3	3111606	3.5124211e+08	27760	12652.81	3
2012	35	3	3516002	1.6594251e+08	13112	12655.77	3
2012	31	3	3168606	1.71778761e+09	135549	12672.82	3
2012	11	1	1101401	1.8138999e+08	14313	12673.09	3
2012	41	4	4118006	1.5309451e+08	12079	12674.44	3
2012	32	3	3201704	1.4957701e+08	11798	12678.17	3
2012	52	5	5210208	3.9655184e+08	31271	12681.14	3
2012	35	3	3545100	6.190466e+07	4881	12682.78	3
2012	29	2	2916401	8.8701496e+08	69903	12689.23	3
2012	31	3	3109501	1.7565922e+08	13838	12693.97	3
2012	35	3	3536257	2.597178e+07	2045	12700.14	3
2012	43	4	4323457	5.358795e+07	4215	12713.63	3
2012	31	3	3165305	9.079392e+07	7136	12723.36	3
2012	35	3	3526100	2.4268154e+08	19055	12735.85	3
2012	31	3	3141207	4.777929e+07	3750	12741.14	3
2012	17	1	1703602	2.658167e+07	2086	12742.89	3
2012	42	4	4203154	4.303809e+07	3375	12752.03	3
2012	33	3	3304409	2.2473016e+08	17606	12764.41	3
2012	31	3	3136900	1.2093114e+08	9474	12764.53	3
2012	50	5	5007703	1.3734225e+08	10757	12767.71	3
2012	26	2	2613909	1.02770767e+09	80489	12768.3	3
2012	52	5	5218904	2.4317018e+08	19041	12770.87	3
2012	31	3	3125200	3.002772e+07	2350	12777.75	3
2012	43	4	4320677	1.2841056e+08	10047	12780.98	3
2012	35	3	3509106	6.604387e+07	5167	12781.86	3
2012	27	2	2700300	2.78906105e+09	218140	12785.65	3
2012	43	4	4319406	2.0813397e+08	16275	12788.57	3
2012	35	3	3551504	5.0943815e+08	39826	12791.6	3
2012	41	4	4119806	1.7383645e+08	13584	12797.15	3
2012	52	5	5211404	1.1031277e+08	8620	12797.31	3
2012	31	3	3140902	2.2842935e+08	17843	12802.18	3
2012	11	1	1100940	2.2100312e+08	17262	12802.87	3
2012	28	2	2802908	1.1336773e+09	88501	12809.77	3
2012	14	1	1400506	8.99637e+07	7023	12809.87	3
2012	32	3	3201001	1.8297992e+08	14278	12815.51	3
2012	33	3	3303856	3.4063087e+08	26575	12817.72	3
2012	11	1	1100254	2.7826927e+08	21709	12818.15	3
2012	33	3	3305901	1.3238265e+08	10327	12819.08	3
2012	41	4	4103206	8.486804e+07	6620	12819.95	3
2012	31	3	3118304	1.52103798e+09	118578	12827.32	3
2012	35	3	3514502	1.5679858e+08	12218	12833.41	3
2012	31	3	3120508	1.3078555e+08	10191	12833.44	3
2012	17	1	1705508	4.0684478e+08	31675	12844.35	3
2012	43	4	4308433	3.157962e+07	2458	12847.69	3
2012	33	3	3304102	2.3183705e+08	18034	12855.55	3
2012	41	4	4110904	5.834169e+07	4538	12856.26	3
2012	11	1	1101476	4.378991e+07	3406	12856.7	3
2012	11	1	1100809	2.6739294e+08	20787	12863.47	3
2012	15	1	1506161	2.2829139e+08	17728	12877.45	3
2012	42	4	4210209	4.249918e+07	3300	12878.54	3
2012	41	4	4108452	6.796707e+07	5276	12882.31	3
2012	35	3	3549953	1.8350893e+08	14241	12885.96	3
2012	11	1	1100098	3.7617744e+08	29189	12887.64	3
2012	35	3	3541109	5.277758e+07	4094	12891.45	3
2012	33	3	3305604	2.7539891e+08	21362	12892	3
2012	50	5	5001102	5.9246136e+08	45943	12895.57	3
2012	41	4	4124905	7.587809e+07	5884	12895.66	3
2012	43	4	4323507	3.622999e+07	2808	12902.42	3
2012	29	2	2918902	4.88189e+07	3782	12908.22	3
2012	31	3	3157807	2.65516973e+09	205666	12910.11	3
2012	35	3	3535200	1.2229984e+08	9473	12910.36	3
2012	35	3	3508603	3.9419456e+08	30527	12912.98	3
2012	31	3	3103603	3.631758e+07	2811	12919.81	3
2012	42	4	4217956	2.247797e+07	1739	12925.8	3
2012	35	3	3541901	1.5063979e+08	11641	12940.45	3
2012	24	2	2400208	6.9935411e+08	54031	12943.57	3
2012	42	4	4215901	3.853905e+07	2977	12945.6	3
2012	42	4	4205159	4.767887e+07	3683	12945.66	3
2012	41	4	4107520	2.485916e+07	1919	12954.23	3
2012	29	2	2907509	6.7126248e+08	51734	12975.27	3
2012	52	5	5201207	1.349222e+07	1039	12985.77	3
2012	31	3	3170602	2.800033e+07	2156	12987.17	3
2012	51	5	5103957	4.028388e+07	3101	12990.61	3
2012	42	4	4207601	6.109908e+07	4699	13002.57	3
2012	35	3	3553005	1.4742303e+08	11336	13004.85	3
2012	52	5	5221304	3.665105e+07	2818	13006.05	3
2012	51	5	5106000	8.212774e+07	6314	13007.24	3
2012	17	1	1703701	6.807405e+07	5232	13011.09	3
2012	50	5	5004106	1.3343253e+08	10253	13014	3
2012	33	3	3305109	5.98748072e+09	460062	13014.51	3
2012	42	4	4210704	3.625726e+07	2784	13023.44	3
2012	35	3	3543238	2.842246e+07	2182	13025.87	3
2012	43	4	4315156	8.021855e+07	6153	13037.31	3
2012	42	4	4218400	8.998074e+07	6901	13038.8	3
2012	43	4	4313391	5.086608e+07	3899	13045.93	3
2012	17	1	1702000	1.1353516e+08	8702	13047.02	3
2012	35	3	3543808	1.2905981e+08	9887	13053.49	3
2012	31	3	3101904	2.4436721e+08	18709	13061.48	3
2012	31	3	3150505	1.0845556e+08	8299	13068.51	3
2012	43	4	4303707	7.817745e+07	5982	13068.78	3
2012	43	4	4306551	3.317663e+07	2538	13071.96	3
2012	31	3	3106408	9.879556e+07	7553	13080.31	3
2012	43	4	4318051	3.851056e+07	2941	13094.38	3
2012	52	5	5207105	3.243661e+07	2477	13095.12	3
2012	32	3	3204401	1.4846161e+08	11334	13098.78	3
2012	28	2	2804003	2.1584842e+08	16478	13099.19	3
2012	51	5	5108600	2.9168893e+08	22258	13104.9	3
2012	32	3	3200136	1.2463587e+08	9507	13109.91	3
2012	29	2	2906907	2.835019e+08	21612	13117.8	3
2012	43	4	4310751	2.7624e+07	2105	13123.04	3
2012	31	3	3101102	3.2730605e+08	24937	13125.32	3
2012	15	1	1502400	2.34975634e+09	178986	13128.16	3
2012	41	4	4109609	4.3107067e+08	32826	13131.99	3
2012	41	4	4120705	9.314593e+07	7091	13135.8	3
2012	41	4	4107157	6.634039e+07	5050	13136.71	3
2012	42	4	4209409	6.863122e+08	52166	13156.31	3
2012	41	4	4108650	9.756742e+07	7415	13158.11	3
2012	41	4	4118303	3.752959e+07	2852	13159.04	3
2012	17	1	1718899	2.855601e+07	2170	13159.45	3
2012	15	1	1505031	3.3114828e+08	25151	13166.41	3
2012	31	3	3133501	2.8181136e+08	21399	13169.37	3
2012	35	3	3553203	7.163497e+07	5439	13170.61	3
2012	16	1	1600105	1.0818618e+08	8213	13172.55	3
2012	41	4	4100103	1.0130122e+08	7690	13173.11	3
2012	24	2	2411056	4.958535e+07	3761	13184.09	3
2012	31	3	3108008	2.2770563e+08	17271	13184.28	3
2012	43	4	4319307	8.230589e+07	6240	13190.05	3
2012	43	4	4308052	3.316127e+07	2514	13190.64	3
2012	52	5	5214051	8.160509e+07	6186	13191.9	3
2012	52	5	5205513	2.3523784e+08	17827	13195.59	3
2012	35	3	3536570	2.34783e+07	1779	13197.47	3
2012	43	4	4321956	7.610989e+07	5767	13197.48	3
2012	35	3	3548609	1.3842272e+08	10486	13200.72	3
2012	43	4	4302378	2.977334e+07	2253	13214.97	3
2012	35	3	3500402	1.0116993e+08	7653	13219.64	3
2012	43	4	4304358	1.1738919e+08	8878	13222.48	3
2012	33	3	3304607	1.3620055e+08	10298	13225.92	3
2012	43	4	4321857	5.746711e+07	4345	13226.03	3
2012	11	1	1101559	6.327717e+07	4778	13243.44	3
2012	43	4	4302709	2.7068804e+08	20419	13256.67	3
2012	31	3	3158953	3.7978951e+08	28641	13260.34	3
2012	31	3	3120300	7.674109e+07	5787	13260.94	3
2012	22	2	2204402	1.3833869e+08	10429	13264.81	3
2012	42	4	4203709	1.4396079e+08	10845	13274.39	3
2012	43	4	4302659	6.274678e+07	4726	13276.93	3
2012	43	4	4315701	4.9890368e+08	37563	13281.78	3
2012	35	3	3501301	3.1414628e+08	23642	13287.64	3
2012	33	3	3301801	1.7838566e+08	13408	13304.42	3
2012	41	4	4120606	6.5391663e+08	49150	13304.51	3
2012	29	2	2933257	8.889389e+07	6681	13305.48	3
2012	29	2	2907400	4.28085e+07	3215	13315.24	3
2012	35	3	3541208	1.785583e+08	13406	13319.28	3
2012	43	4	4305447	6.675904e+07	5011	13322.5	3
2012	35	3	3550209	4.2046476e+08	31549	13327.36	3
2012	31	3	3113909	1.58245e+08	11872	13329.26	3
2012	31	3	3129103	8.033979e+07	6025	13334.4	3
2012	42	4	4202438	4.420104e+07	3314	13337.67	3
2012	41	4	4116950	6.76876e+07	5074	13340.09	3
2012	33	3	3301603	1.4701913e+08	11020	13341.12	3
2012	43	4	4322343	2.987469e+07	2239	13342.87	3
2012	32	3	3202652	1.5919442e+08	11930	13344.04	3
2012	43	4	4305454	1.7668254e+08	13240	13344.6	3
2012	32	3	3203403	3.4564164e+08	25858	13366.91	3
2012	43	4	4321667	1.3799586e+08	10322	13369.1	3
2012	52	5	5218607	1.4138267e+08	10571	13374.58	3
2012	17	1	1715507	1.404535e+07	1049	13389.28	3
2012	52	5	5204102	1.4522195e+08	10841	13395.62	3
2012	41	4	4108106	3.430561e+07	2560	13400.63	3
2012	41	4	4100202	8.421604e+07	6281	13408.06	3
2012	11	1	1101492	2.2306874e+08	16636	13408.8	3
2012	52	5	5208509	7.122722e+07	5310	13413.79	3
2012	35	3	3533007	2.6177138e+08	19507	13419.36	3
2012	35	3	3518107	8.614025e+07	6417	13423.76	3
2012	41	4	4124400	2.5579314e+08	19048	13428.87	3
2012	31	3	3157906	2.0453984e+08	15207	13450.37	3
2012	52	5	5200605	9.409877e+07	6992	13458.06	3
2012	11	1	1100908	4.686767e+07	3479	13471.59	3
2012	13	1	1304302	2.2771422e+08	16902	13472.62	3
2012	41	4	4102406	4.3067925e+08	31951	13479.37	3
2012	42	4	4219853	4.110253e+07	3046	13493.93	3
2012	35	3	3554904	7.381611e+07	5468	13499.66	3
2012	43	4	4313466	2.355742e+07	1744	13507.7	3
2012	51	5	5108956	1.1196448e+08	8285	13514.12	3
2012	50	5	5005004	3.3271759e+08	24619	13514.67	3
2012	28	2	2804805	2.23408372e+09	165194	13524	3
2012	35	3	3511201	9.75877e+07	7214	13527.54	3
2012	27	2	2700607	1.0491975e+08	7755	13529.3	3
2012	15	1	1508084	4.7313388e+08	34956	13535.13	3
2012	35	3	3506607	3.9494889e+08	29168	13540.49	3
2012	43	4	4310579	3.106051e+07	2292	13551.71	3
2012	41	4	4108320	8.588553e+07	6337	13553.03	3
2012	52	5	5213400	2.337563e+07	1724	13558.95	3
2012	41	4	4110805	1.426157e+08	10515	13563.07	3
2012	35	3	3532801	8.222311e+07	6061	13565.93	3
2012	43	4	4307450	4.341684e+07	3200	13567.76	3
2012	31	3	3117108	1.3418243e+08	9888	13570.23	3
2012	32	3	3200201	4.1574015e+08	30626	13574.75	3
2012	33	3	3305307	1.2186471e+08	8970	13585.81	3
2012	32	3	3202900	1.4672096e+08	10799	13586.53	3
2012	35	3	3500808	5.329271e+07	3921	13591.61	3
2012	35	3	3514205	2.839174e+07	2088	13597.58	3
2012	32	3	3202009	8.747131e+07	6429	13605.74	3
2012	33	3	3305208	1.24554653e+09	91542	13606.28	3
2012	35	3	3506904	1.3554799e+08	9960	13609.24	3
2012	51	5	5107107	2.5716984e+08	18894	13611.19	3
2012	41	4	4121257	5.686e+07	4175	13619.16	3
2012	31	3	3111200	7.0712069e+08	51900	13624.68	3
2012	35	3	3547205	2.184487e+07	1603	13627.49	3
2012	31	3	3127909	1.872087e+07	1373	13635.01	3
2012	43	4	4302600	4.946964e+07	3628	13635.51	3
2012	31	3	3132206	1.7090978e+08	12534	13635.69	3
2012	43	4	4310553	4.685307e+07	3432	13651.83	3
2012	32	3	3202256	1.5162067e+08	11106	13652.14	3
2012	35	3	3520202	1.2170594e+08	8913	13654.88	3
2012	31	3	3152907	1.1944123e+08	8746	13656.67	3
2012	43	4	4312377	4.250136e+07	3112	13657.25	3
2012	52	5	5208608	8.3500573e+08	61118	13662.19	3
2012	23	2	2311504	2.8442503e+08	20810	13667.71	3
2012	11	1	1100015	3.2902948e+08	24069	13670.26	3
2012	35	3	3527256	2.93593e+07	2147	13674.57	3
2012	43	4	4304853	2.134845e+07	1561	13676.14	3
2012	42	4	4211801	1.0052556e+08	7348	13680.67	3
2012	31	3	3156700	1.75050824e+09	127897	13686.86	3
2012	35	3	3526605	9.143754e+07	6678	13692.35	3
2012	41	4	4109757	8.346904e+07	6096	13692.43	3
2012	41	4	4113429	5.273099e+07	3851	13692.8	3
2012	41	4	4123808	1.8285727e+08	13347	13700.25	3
2012	52	5	5215207	4.686996e+07	3420	13704.67	3
2012	50	5	5002100	3.2066227e+08	23395	13706.44	3
2012	35	3	3533700	5.706176e+07	4163	13706.88	3
2012	50	5	5003801	2.6078609e+08	19024	13708.27	3
2012	43	4	4319364	2.604898e+07	1900	13709.99	3
2012	31	3	3113602	8.737015e+07	6372	13711.57	3
2012	35	3	3528205	5.006437e+07	3650	13716.27	3
2012	41	4	4128401	1.5664457e+08	11411	13727.51	3
2012	35	3	3515129	4.173174e+07	3040	13727.54	3
2012	33	3	3305158	2.8206266e+08	20540	13732.36	3
2012	35	3	3541505	5.2183216e+08	37996	13733.87	3
2012	43	4	4317103	1.11549313e+09	81198	13737.94	3
2012	31	3	3139508	2.9658119e+08	21587	13738.88	3
2012	43	4	4306932	1.2126091e+08	8823	13743.73	3
2012	41	4	4127809	1.1846199e+08	8619	13744.29	3
2012	25	2	2513703	1.67750423e+09	121994	13750.71	3
2012	32	3	3204351	2.4367587e+08	17713	13756.89	3
2012	52	5	5215256	5.555525e+07	4036	13764.93	3
2012	42	4	4202099	2.551614e+07	1853	13770.18	3
2012	15	1	1508407	5.6996579e+08	41382	13773.28	3
2012	35	3	3540101	4.751029e+07	3449	13775.09	3
2012	41	4	4109708	4.0085448e+08	29099	13775.54	3
2012	51	5	5108204	5.452058e+07	3957	13778.26	3
2012	35	3	3506300	1.4859479e+08	10784	13779.19	3
2012	29	2	2933307	4.35530186e+09	315884	13787.66	3
2012	52	5	5210000	6.7426642e+08	48903	13787.83	3
2012	43	4	4319356	4.670153e+07	3387	13788.47	3
2012	42	4	4201505	1.0878528e+08	7886	13794.74	3
2012	41	4	4117305	3.1889843e+08	23103	13803.33	3
2012	35	3	3544707	3.297931e+07	2389	13804.65	3
2012	31	3	3143005	1.8017248e+08	13049	13807.38	3
2012	35	3	3527009	9.543876e+07	6912	13807.69	3
2012	43	4	4311239	3.719984e+07	2694	13808.41	3
2012	24	2	2412203	5.5972568e+08	40511	13816.63	3
2012	31	3	3103207	3.119925e+07	2258	13817.2	3
2012	41	4	4106001	1.1534243e+08	8344	13823.4	3
2012	50	5	5003108	6.988023e+07	5054	13826.72	3
2012	31	3	3138401	7.0928228e+08	51286	13829.94	3
2012	12	1	1200179	1.2964856e+08	9368	13839.51	3
2012	35	3	3547700	2.8280451e+08	20434	13839.9	3
2012	15	1	1501253	4.679324e+07	3379	13848.25	3
2012	16	1	1600535	2.448731e+08	17680	13850.29	3
2012	35	3	3514957	3.34653e+07	2415	13857.27	3
2012	32	3	3201605	3.9839959e+08	28745	13859.79	3
2012	41	4	4110607	2.0462551e+08	14760	13863.52	3
2012	31	3	3130804	3.674625e+07	2650	13866.51	3
2012	43	4	4312005	3.011233e+07	2171	13870.26	3
2012	31	3	3145604	5.5217501e+08	39801	13873.4	3
2012	52	5	5206503	4.911311e+07	3540	13873.76	3
2012	43	4	4304101	4.788446e+07	3451	13875.53	3
2012	41	4	4112405	1.2031177e+08	8669	13878.39	3
2012	52	5	5200506	2.831657e+07	2040	13880.67	3
2012	32	3	3202306	3.9165977e+08	28208	13884.71	3
2012	41	4	4125555	2.918698e+07	2102	13885.34	3
2012	52	5	5200902	4.900152e+07	3529	13885.38	3
2012	15	1	1502764	1.547751e+08	11144	13888.65	3
2012	43	4	4321105	2.3177417e+08	16681	13894.5	3
2012	41	4	4128500	2.676268e+08	19259	13896.19	3
2012	41	4	4113809	6.439474e+07	4633	13899.15	3
2012	51	5	5108055	1.519104e+08	10929	13899.75	3
2012	35	3	3502606	6.086928e+07	4377	13906.62	3
2012	52	5	5214408	1.1215293e+08	8062	13911.3	3
2012	52	5	5203807	7.712624e+07	5544	13911.66	3
2012	29	2	2907004	1.2562766e+08	9030	13912.25	3
2012	35	3	3530409	6.094462e+07	4379	13917.47	3
2012	31	3	3168804	9.948515e+07	7143	13927.64	3
2012	15	1	1500503	4.6757088e+08	33563	13931.14	3
2012	43	4	4320453	3.088643e+07	2217	13931.63	3
2012	35	3	3537800	7.3096919e+08	52447	13937.29	3
2012	31	3	3115805	1.4316505e+08	10271	13938.76	3
2012	43	4	4317400	6.8218581e+08	48940	13939.23	3
2012	26	2	2612208	7.9999772e+08	57343	13951.1	3
2012	41	4	4117602	6.1555613e+08	44107	13955.97	3
2012	41	4	4127908	1.2069703e+08	8647	13958.25	3
2012	35	3	3516606	9.610463e+07	6884	13960.58	3
2012	31	3	3115102	2.4342327e+08	17433	13963.36	3
2012	43	4	4322541	7.311999e+07	5236	13964.86	3
2012	32	3	3204708	4.5629215e+08	32655	13973.12	3
2012	16	1	1600204	1.3056558e+08	9343	13974.7	3
2012	29	2	2916856	1.9347737e+08	13841	13978.57	3
2012	42	4	4211058	1.3122666e+08	9381	13988.56	3
2012	31	3	3132909	1.4404175e+08	10293	13994.15	3
2012	35	3	3502408	5.303259e+07	3788	14000.16	3
2012	42	4	4215059	3.419442e+07	2440	14014.11	3
2012	43	4	4301404	1.4332905e+08	10220	14024.37	3
2012	41	4	4109203	7.270976e+07	5181	14033.92	4
2012	26	2	2615409	5.2812733e+08	37631	14034.37	4
2012	31	3	3113701	2.7787543e+08	19779	14049.01	4
2012	41	4	4125407	9.049941e+07	6441	14050.52	4
2012	35	3	3519402	1.5618024e+08	11115	14051.3	4
2012	31	3	3162104	4.5616283e+08	32452	14056.54	4
2012	41	4	4121752	1.0406417e+08	7402	14058.93	4
2012	41	4	4118808	1.9184549e+08	13645	14059.76	4
2012	41	4	4115408	1.9597618e+08	13936	14062.58	4
2012	31	3	3143401	3.0482063e+08	21658	14074.27	4
2012	41	4	4127304	2.1731685e+08	15437	14077.66	4
2012	35	3	3504909	1.450736e+08	10301	14083.45	4
2012	11	1	1100155	5.2799017e+08	37482	14086.5	4
2012	43	4	4304663	3.4363625e+08	24386	14091.54	4
2012	31	3	3123403	2.05249e+07	1454	14116.16	4
2012	33	3	3300605	5.0372473e+08	35677	14119.03	4
2012	41	4	4119707	5.807199e+07	4111	14126	4
2012	31	3	3120904	1.05989765e+09	75014	14129.33	4
2012	31	3	3110905	2.2091589e+08	15635	14129.57	4
2012	43	4	4321402	1.9260243e+08	13625	14135.96	4
2012	43	4	4311106	1.6002357e+08	11320	14136.36	4
2012	17	1	1718907	6.513088e+07	4607	14137.37	4
2012	52	5	5202502	1.1112057e+08	7859	14139.28	4
2012	43	4	4303202	6.906193e+07	4883	14143.34	4
2012	16	1	1600600	1.47676921e+09	104407	14144.35	4
2012	52	5	5208004	1.46155033e+09	103322	14145.59	4
2012	35	3	3510708	1.6742757e+08	11836	14145.62	4
2012	52	5	5216304	1.3068848e+08	9238	14146.84	4
2012	43	4	4301602	1.65683901e+09	117090	14150.13	4
2012	17	1	1708205	2.5992946e+08	18369	14150.44	4
2012	42	4	4213609	4.7894685e+08	33740	14195.22	4
2012	41	4	4107546	6.488002e+07	4570	14196.94	4
2012	43	4	4310405	9.250448e+07	6514	14200.87	4
2012	43	4	4302584	3.094896e+07	2179	14203.29	4
2012	33	3	3302304	1.0547298e+08	7424	14207.03	4
2012	52	5	5204706	1.6107542e+08	11333	14212.95	4
2012	43	4	4308409	9.846368e+07	6926	14216.53	4
2012	35	3	3552106	5.3028798e+08	37288	14221.41	4
2012	42	4	4202057	1.2505016e+08	8791	14224.79	4
2012	52	5	5219001	1.0748132e+08	7554	14228.4	4
2012	43	4	4305116	4.184976e+07	2941	14229.77	4
2012	31	3	3160900	5.051754e+07	3548	14238.31	4
2012	43	4	4311908	7.102675e+07	4987	14242.38	4
2012	43	4	4322905	7.398883e+07	5194	14245.06	4
2012	42	4	4219150	3.916046e+07	2746	14260.91	4
2012	35	3	3519709	1.03038831e+09	72249	14261.63	4
2012	24	2	2401008	4.9709268e+08	34852	14262.96	4
2012	41	4	4117008	1.1594772e+08	8124	14272.25	4
2012	41	4	4115705	4.3179824e+08	30220	14288.49	4
2012	42	4	4204756	2.704563e+07	1892	14294.73	4
2012	41	4	4122800	6.086488e+07	4253	14311.05	4
2012	41	4	4117297	4.039209e+07	2822	14313.29	4
2012	43	4	4301925	2.778512e+07	1941	14314.85	4
2012	31	3	3128006	4.5500097e+08	31781	14316.76	4
2012	52	5	5204201	2.012878e+07	1405	14326.53	4
2012	31	3	3112703	2.0599451e+08	14372	14333.04	4
2012	43	4	4312203	6.88634e+07	4800	14346.54	4
2012	42	4	4209151	6.803679e+07	4741	14350.73	4
2012	42	4	4218905	1.5454049e+08	10767	14353.16	4
2012	31	3	3171303	1.05277407e+09	73333	14356.08	4
2012	35	3	3504404	1.6775351e+08	11685	14356.31	4
2012	42	4	4200705	1.3641457e+08	9494	14368.5	4
2012	42	4	4209706	1.704474e+08	11862	14369.2	4
2012	35	3	3515707	2.47471501e+09	172222	14369.33	4
2012	31	3	3123601	3.6953528e+08	25715	14370.42	4
2012	50	5	5005806	2.0538083e+08	14287	14375.36	4
2012	43	4	4319802	1.2166785e+08	8456	14388.35	4
2012	32	3	3205010	3.5534996e+08	24685	14395.38	4
2012	51	5	5103361	5.047164e+07	3506	14395.79	4
2012	31	3	3164407	7.265315e+07	5045	14401.02	4
2012	31	3	3137106	1.0922187e+08	7584	14401.62	4
2012	35	3	3516408	1.9468577e+09	135150	14405.16	4
2012	43	4	4322400	1.80399192e+09	125209	14407.85	4
2012	35	3	3532405	2.4096015e+08	16717	14414.08	4
2012	29	2	2912806	1.1661358e+08	8086	14421.66	4
2012	33	3	3305554	1.15623489e+09	80138	14428.05	4
2012	43	4	4321600	6.2306712e+08	43178	14430.2	4
2012	35	3	3555109	2.0806952e+08	14418	14431.23	4
2012	35	3	3535903	5.548482e+07	3843	14437.89	4
2012	33	3	3305752	4.5403268e+08	31438	14442.16	4
2012	31	3	3102407	5.126413e+07	3549	14444.67	4
2012	31	3	3160405	3.8070135e+08	26353	14446.22	4
2012	11	1	1100296	1.2244904e+08	8476	14446.56	4
2012	35	3	3532058	6.292133e+07	4354	14451.39	4
2012	31	3	3162658	5.954086e+07	4120	14451.67	4
2012	51	5	5105580	1.6837992e+08	11638	14468.11	4
2012	26	2	2601706	1.05649185e+09	72996	14473.28	4
2012	43	4	4314506	1.8298353e+08	12642	14474.25	4
2012	43	4	4310652	3.68959e+07	2546	14491.71	4
2012	11	1	1101104	1.2814146e+08	8830	14512.06	4
2012	43	4	4315057	3.633509e+07	2503	14516.62	4
2012	35	3	3546009	2.0150443e+08	13877	14520.75	4
2012	43	4	4311007	4.0087346e+08	27605	14521.77	4
2012	29	2	2914802	2.99060692e+09	205885	14525.62	4
2012	51	5	5107578	5.333318e+07	3671	14528.24	4
2012	31	3	3159704	4.710104e+07	3241	14532.87	4
2012	35	3	3514809	2.139278e+08	14718	14535.11	4
2012	43	4	4314159	1.1759974e+08	8090	14536.43	4
2012	31	3	3165404	9.245865e+07	6360	14537.52	4
2012	31	3	3116605	3.8194e+08	26262	14543.45	4
2012	26	2	2611101	4.44130209e+09	305352	14544.86	4
2012	32	3	3202108	3.3595712e+08	23097	14545.49	4
2012	41	4	4123105	5.400658e+07	3712	14549.19	4
2012	31	3	3152006	4.3031479e+08	29561	14556.84	4
2012	32	3	3204955	1.6604215e+08	11406	14557.44	4
2012	43	4	4316402	5.7513864e+08	39503	14559.37	4
2012	35	3	3544806	8.133707e+07	5586	14560.88	4
2012	43	4	4302808	4.887236e+08	33547	14568.32	4
2012	35	3	3502903	4.1417769e+08	28429	14568.84	4
2012	43	4	4306007	2.0279513e+08	13919	14569.66	4
2012	52	5	5220009	1.5719278e+08	10789	14569.73	4
2012	29	2	2928703	1.35708252e+09	93077	14580.21	4
2012	41	4	4116406	5.73121e+07	3930	14583.23	4
2012	17	1	1709807	2.495757e+07	1711	14586.54	4
2012	31	3	3135704	7.518616e+07	5154	14587.92	4
2012	41	4	4116000	2.696394e+07	1848	14590.88	4
2012	31	3	3138104	9.447903e+07	6474	14593.61	4
2012	43	4	4315206	5.966891e+07	4087	14599.69	4
2012	52	5	5218003	6.2468027e+08	42773	14604.55	4
2012	23	2	2301000	1.08757081e+09	74465	14605.13	4
2012	35	3	3508702	2.7126963e+08	18563	14613.46	4
2012	31	3	3114402	3.0014285e+08	20531	14619.01	4
2012	43	4	4322533	1.6313281e+08	11156	14622.88	4
2012	31	3	3110707	1.8447884e+08	12612	14627.25	4
2012	50	5	5002803	8.079648e+07	5520	14637.04	4
2012	29	2	2904605	9.5109949e+08	64972	14638.61	4
2012	42	4	4208807	2.5903065e+08	17695	14638.63	4
2012	35	3	3550407	4.7188978e+08	32231	14640.87	4
2012	31	3	3104601	1.938909e+08	13237	14647.65	4
2012	50	5	5003504	8.000265e+07	5460	14652.5	4
2012	51	5	5106257	2.9198635e+08	19917	14660.16	4
2012	35	3	3515400	2.2534784e+08	15367	14664.4	4
2012	33	3	3302106	3.3593727e+08	22884	14680.01	4
2012	41	4	4100608	2.0273421e+08	13806	14684.5	4
2012	35	3	3553856	7.717036e+07	5254	14687.93	4
2012	15	1	1501501	7.9437197e+08	54083	14688.02	4
2012	24	2	2413201	5.901849e+07	4018	14688.52	4
2012	41	4	4107850	6.896368e+07	4695	14688.75	4
2012	42	4	4212502	3.862634e+08	26268	14704.71	4
2012	32	3	3202702	2.0716777e+08	14080	14713.62	4
2012	13	1	1301902	1.31079243e+09	89064	14717.42	4
2012	51	5	5105101	4.8730719e+08	33100	14722.27	4
2012	31	3	3165107	1.0403512e+08	7062	14731.68	4
2012	50	5	5000609	5.2332626e+08	35523	14732.04	4
2012	35	3	3544608	7.7498e+07	5258	14739.06	4
2012	33	3	3303500	1.182253408e+10	801746	14745.98	4
2012	35	3	3536901	3.734186e+07	2532	14747.97	4
2012	28	2	2800605	3.8465885e+08	26059	14761.07	4
2012	17	1	1709302	3.4965481e+08	23681	14765.2	4
2012	41	4	4112306	7.24203e+07	4904	14767.6	4
2012	43	4	4321329	4.391116e+07	2973	14769.98	4
2012	51	5	5107800	2.7956111e+08	18921	14775.18	4
2012	42	4	4211892	3.474931e+07	2351	14780.65	4
2012	31	3	3105608	1.89414042e+09	128120	14784.11	4
2012	32	3	3204104	3.5905515e+08	24284	14785.67	4
2012	41	4	4120150	5.299537e+07	3582	14794.91	4
2012	43	4	4315453	3.161198e+07	2136	14799.61	4
2012	32	3	3204609	3.2583664e+08	22005	14807.39	4
2012	43	4	4309951	5.978067e+07	4037	14808.19	4
2012	31	3	3135001	4.45899e+07	3011	14809	4
2012	24	2	2412005	1.33845281e+09	90376	14809.83	4
2012	43	4	4305934	2.52079e+07	1702	14810.75	4
2012	17	1	1718402	5.435859e+07	3670	14811.6	4
2012	17	1	1700301	8.097826e+07	5467	14812.19	4
2012	41	4	4111506	4.7028829e+08	31748	14813.16	4
2012	35	3	3543600	5.117114e+07	3453	14819.33	4
2012	41	4	4120408	7.199754e+07	4857	14823.46	4
2012	42	4	4207759	6.228941e+07	4202	14823.75	4
2012	31	3	3166600	1.19667e+07	807	14828.63	4
2012	31	3	3109709	1.6473273e+08	11107	14831.43	4
2012	26	2	2604106	4.80962202e+09	324095	14840.16	4
2012	31	3	3120706	5.889786e+07	3967	14846.95	4
2012	42	4	4219358	7.663183e+07	5160	14851.13	4
2012	35	3	3538105	2.2770397e+08	15331	14852.52	4
2012	35	3	3555406	1.19811859e+09	80604	14864.26	4
2012	52	5	5215009	1.24811e+08	8388	14879.71	4
2012	43	4	4311700	8.152897e+07	5478	14882.98	4
2012	35	3	3520707	5.77742e+07	3880	14890.26	4
2012	31	3	3169802	7.037594e+07	4721	14907	4
2012	51	5	5103205	4.6488007e+08	31176	14911.47	4
2012	35	3	3533809	3.9171e+07	2625	14922.29	4
2012	43	4	4304200	4.5166723e+08	30260	14926.21	4
2012	31	3	3169406	8.1056576e+08	54289	14930.57	4
2012	43	4	4312054	6.044982e+07	4042	14955.42	4
2012	41	4	4128559	1.3268213e+08	8871	14956.84	4
2012	31	3	3147303	2.9438233e+08	19664	14970.62	4
2012	52	5	5219456	4.785659e+07	3196	14973.9	4
2012	43	4	4315172	2.971548e+07	1984	14977.56	4
2012	31	3	3114501	2.6147957e+08	17456	14979.35	4
2012	35	3	3535408	2.2061836e+08	14725	14982.57	4
2012	43	4	4302907	2.0121997e+08	13430	14982.87	4
2012	35	3	3544509	4.347183e+07	2900	14990.28	4
2012	51	5	5105150	5.9132518e+08	39442	14992.27	4
2012	42	4	4207809	1.4476902e+08	9656	14992.65	4
2012	41	4	4124103	6.4701261e+08	43125	15003.19	4
2012	43	4	4313805	1.0378379e+08	6917	15004.16	4
2012	41	4	4113106	6.643299e+07	4425	15013.11	4
2012	41	4	4105805	3.2651022e+09	217443	15015.9	4
2012	41	4	4120200	3.79852e+07	2527	15031.74	4
2012	52	5	5205703	3.880971e+07	2581	15036.69	4
2012	35	3	3500204	5.320027e+07	3538	15036.82	4
2012	52	5	5208905	3.6641911e+08	24366	15038.13	4
2012	33	3	3300902	2.2348749e+08	14851	15048.65	4
2012	26	2	2606804	1.58102516e+09	105003	15056.95	4
2012	50	5	5000807	1.2913183e+08	8575	15059.11	4
2012	31	3	3127354	4.506664e+07	2992	15062.38	4
2012	52	5	5220207	3.3452921e+08	22206	15064.81	4
2012	42	4	4209177	3.221486e+07	2138	15067.75	4
2012	35	3	3539004	1.6149098e+08	10712	15075.71	4
2012	31	3	3114303	4.4891901e+08	29777	15076.03	4
2012	31	3	3143906	1.53895274e+09	102074	15076.83	4
2012	43	4	4318432	3.882241e+07	2572	15094.25	4
2012	43	4	4305009	1.387576e+08	9191	15097.12	4
2012	35	3	3514700	9.430199e+07	6242	15107.66	4
2012	35	3	3527405	3.0405841e+08	20119	15113	4
2012	31	3	3143609	3.954067e+07	2615	15120.71	4
2012	42	4	4209607	2.1901305e+08	14483	15122.08	4
2012	43	4	4306700	5.031525e+07	3326	15127.86	4
2012	35	3	3523008	6.71502e+07	4436	15137.56	4
2012	41	4	4109302	2.1503775e+08	14187	15157.38	4
2012	43	4	4301552	5.505608e+07	3632	15158.61	4
2012	43	4	4311759	1.0738579e+08	7084	15158.92	4
2012	31	3	3131406	6.249059e+07	4120	15167.62	4
2012	43	4	4303608	9.860732e+07	6498	15175.03	4
2012	31	3	3144102	3.0966184e+08	20406	15175.04	4
2012	41	4	4123006	2.1017249e+08	13830	15196.85	4
2012	52	5	5212501	2.73000655e+09	179582	15202.01	4
2012	35	3	3501707	5.3886062e+08	35413	15216.46	4
2012	43	4	4312179	2.687244e+07	1766	15216.56	4
2012	11	1	1100320	3.3393257e+08	21927	15229.29	4
2012	35	3	3509452	8.565887e+07	5622	15236.37	4
2012	32	3	3202405	1.64326496e+09	107836	15238.56	4
2012	41	4	4126603	2.8687264e+08	18825	15238.92	4
2012	52	5	5211008	1.1245038e+08	7379	15239.24	4
2012	17	1	1707306	7.007812e+07	4597	15244.32	4
2012	31	3	3146008	4.8653051e+08	31893	15255.09	4
2012	52	5	5203575	5.554117e+07	3640	15258.56	4
2012	43	4	4300570	4.471871e+07	2930	15262.36	4
2012	42	4	4218103	8.099026e+07	5306	15263.9	4
2012	43	4	4302402	1.7672768e+08	11576	15266.73	4
2012	42	4	4218954	3.781165e+07	2476	15271.27	4
2012	42	4	4202206	1.6078192e+08	10528	15271.84	4
2012	32	3	3203908	7.0999961e+08	46487	15273.08	4
2012	43	4	4318804	6.5731234e+08	43024	15277.81	4
2012	35	3	3556404	6.0676354e+08	39714	15278.33	4
2012	31	3	3140704	4.3468201e+08	28417	15296.55	4
2012	43	4	4306320	4.761529e+07	3111	15305.46	4
2012	51	5	5106190	5.365172e+07	3505	15307.2	4
2012	52	5	5210802	7.613113e+07	4973	15308.89	4
2012	35	3	3551900	2.4203355e+08	15788	15330.22	4
2012	32	3	3204906	1.71496075e+09	111832	15335.15	4
2012	31	3	3127701	4.08341537e+09	266190	15340.23	4
2012	24	2	2414209	1.8313228e+08	11935	15344.14	4
2012	43	4	4321634	4.315558e+07	2812	15346.93	4
2012	32	3	3204658	1.2387371e+08	8070	15349.9	4
2012	41	4	4117107	2.003472e+08	13052	15349.92	4
2012	43	4	4306056	1.1327485e+08	7378	15353.06	4
2012	35	3	3519303	4.8190326e+08	31380	15357.02	4
2012	50	5	5006903	2.4113161e+08	15683	15375.35	4
2012	41	4	4106100	5.633661e+07	3663	15379.91	4
2012	35	3	3512308	2.5374699e+08	16497	15381.4	4
2012	43	4	4322327	5.374999e+07	3494	15383.51	4
2012	31	3	3111507	2.2197912e+08	14416	15398.11	4
2012	35	3	3529203	3.7779525e+08	24502	15418.96	4
2012	41	4	4123600	2.739524e+07	1776	15425.25	4
2012	35	3	3528502	1.29754699e+09	84104	15427.89	4
2012	29	2	2913606	2.89109485e+09	187315	15434.4	4
2012	43	4	4303301	7.588152e+07	4914	15441.9	4
2012	52	5	5221601	5.7845714e+08	37443	15449.01	4
2012	35	3	3511607	2.4629821e+08	15942	15449.64	4
2012	32	3	3203502	2.7714259e+08	17938	15450.03	4
2012	35	3	3543709	1.6124123e+08	10427	15463.82	4
2012	42	4	4215307	1.1448335e+08	7402	15466.54	4
2012	43	4	4318465	3.333486e+07	2155	15468.61	4
2012	41	4	4125753	9.859015e+07	6373	15469.97	4
2012	31	3	3147600	2.4276308e+08	15692	15470.5	4
2012	23	2	2312908	2.98797927e+09	193134	15471.02	4
2012	41	4	4100707	1.5615083e+08	10092	15472.73	4
2012	41	4	4116604	5.357463e+07	3462	15475.05	4
2012	35	3	3511706	2.3824559e+08	15395	15475.52	4
2012	41	4	4124053	3.2840952e+08	21215	15480.06	4
2012	31	3	3162500	1.32201519e+09	85353	15488.8	4
2012	43	4	4317251	2.671852e+07	1725	15489	4
2012	35	3	3504206	2.2160345e+08	14307	15489.16	4
2012	32	3	3200904	6.3686501e+08	41110	15491.73	4
2012	50	5	5008008	2.7849762e+08	17975	15493.61	4
2012	41	4	4121505	2.2097353e+08	14254	15502.56	4
2012	31	3	3162203	1.0822928e+08	6981	15503.41	4
2012	17	1	1706258	2.468812e+07	1592	15507.61	4
2012	32	3	3205036	3.0077355e+08	19395	15507.79	4
2012	52	5	5201306	3.173521e+08	20464	15507.82	4
2012	42	4	4206751	3.015827e+07	1944	15513.51	4
2012	43	4	4317954	3.767092e+07	2428	15515.2	4
2012	43	4	4304697	4.107972e+07	2647	15519.35	4
2012	51	5	5101001	4.90967e+07	3163	15522.19	4
2012	35	3	3529906	3.1561739e+08	20322	15530.82	4
2012	42	4	4205100	5.879318e+07	3784	15537.31	4
2012	41	4	4111001	1.0425893e+08	6710	15537.84	4
2012	35	3	3554706	1.4613858e+08	9405	15538.39	4
2012	41	4	4106456	1.1303833e+08	7274	15540.05	4
2012	43	4	4320321	4.349566e+07	2797	15550.83	4
2012	35	3	3503802	7.1365341e+08	45847	15565.98	4
2012	17	1	1707009	3.0619168e+08	19669	15567.22	4
2012	41	4	4122172	6.103265e+07	3920	15569.55	4
2012	52	5	5212956	6.854086e+07	4398	15584.55	4
2012	43	4	4320602	5.916942e+07	3796	15587.31	4
2012	17	1	1702109	2.4342811e+09	156123	15592.07	4
2012	41	4	4119608	5.0137331e+08	32152	15593.85	4
2012	33	3	3300209	1.81549948e+09	116418	15594.66	4
2012	51	5	5107180	1.4226142e+08	9118	15602.26	4
2012	50	5	5007406	2.9651635e+08	19004	15602.84	4
2012	31	3	3149903	3.166548e+08	20292	15604.91	4
2012	31	3	3163904	7.729138e+07	4953	15604.96	4
2012	52	5	5219407	1.1240109e+08	7202	15606.93	4
2012	42	4	4213302	7.578891e+07	4853	15616.92	4
2012	35	3	3516507	4.228061e+07	2706	15624.76	4
2012	31	3	3126208	1.3175108e+08	8427	15634.4	4
2012	43	4	4318309	9.456519e+08	60478	15636.3	4
2012	32	3	3203130	2.484384e+08	15886	15638.83	4
2012	35	3	3517505	2.8844216e+08	18441	15641.35	4
2012	42	4	4204905	1.3391383e+08	8560	15644.14	4
2012	42	4	4216057	7.962009e+07	5089	15645.53	4
2012	43	4	4305801	1.5242698e+08	9742	15646.37	4
2012	43	4	4305371	5.362684e+07	3424	15662.04	4
2012	27	2	2702702	7.022836e+07	4482	15668.98	4
2012	11	1	1100601	9.074159e+07	5791	15669.42	4
2012	43	4	4320800	4.716258e+08	30092	15672.8	4
2012	52	5	5216908	4.214585e+07	2688	15679.26	4
2012	43	4	4315958	3.917825e+07	2498	15683.85	4
2012	42	4	4215604	3.253857e+07	2074	15688.8	4
2012	35	3	3546256	3.105592e+07	1977	15708.61	4
2012	41	4	4125001	1.7724575e+08	11273	15723.03	4
2012	42	4	4218756	7.25702e+07	4612	15735.08	4
2012	43	4	4304614	2.81198e+07	1785	15753.39	4
2012	43	4	4301909	1.9991552e+08	12682	15763.72	4
2012	26	2	2606200	1.1971608e+09	75902	15772.45	4
2012	35	3	3547403	3.977737e+07	2521	15778.41	4
2012	35	3	3522000	5.271044e+07	3338	15791.03	4
2012	41	4	4126009	1.364043e+08	8638	15791.19	4
2012	52	5	5221502	7.574071e+07	4795	15795.77	4
2012	32	3	3201159	1.8879727e+08	11950	15798.93	4
2012	31	3	3112604	2.4373534e+08	15424	15802.34	4
2012	41	4	4116307	5.867448e+07	3713	15802.44	4
2012	42	4	4218251	1.1492519e+08	7268	15812.49	4
2012	43	4	4301701	1.0314732e+08	6521	15817.72	4
2012	35	3	3514924	5.065566e+07	3202	15820.01	4
2012	41	4	4113502	3.3952517e+08	21451	15827.94	4
2012	41	4	4106506	3.4052547e+08	21514	15828.09	4
2012	17	1	1720655	8.105459e+07	5120	15830.97	4
2012	43	4	4315909	9.090264e+07	5742	15831.18	4
2012	35	3	3541000	4.31252686e+09	272390	15832.18	4
2012	35	3	3555802	1.3993442e+08	8838	15833.27	4
2012	41	4	4106571	6.746699e+07	4261	15833.6	4
2012	31	3	3107109	6.1365295e+08	38734	15842.75	4
2012	41	4	4128658	6.262111e+07	3951	15849.43	4
2012	35	3	3521804	3.878081e+08	24457	15856.73	4
2012	42	4	4202503	7.04725e+07	4443	15861.47	4
2012	41	4	4105003	1.6129723e+08	10169	15861.66	4
2012	52	5	5219100	9.313605e+07	5870	15866.45	4
2012	41	4	4101309	1.1654914e+08	7343	15872.14	4
2012	51	5	5103106	8.747374e+07	5510	15875.45	4
2012	50	5	5004908	1.0299427e+08	6485	15881.92	4
2012	35	3	3515301	4.230115e+07	2663	15884.77	4
2012	43	4	4316204	8.631207e+07	5430	15895.41	4
2012	27	2	2706901	5.3464851e+08	33623	15901.27	4
2012	35	3	3545605	2.3016627e+08	14467	15909.74	4
2012	42	4	4214102	3.629999e+07	2281	15914.07	4
2012	51	5	5106455	4.302983e+07	2703	15919.29	4
2012	31	3	3147204	3.2543751e+08	20442	15920.04	4
2012	41	4	4114500	2.0993337e+08	13185	15922.14	4
2012	35	3	3554953	9.679278e+07	6078	15925.1	4
2012	31	3	3137536	1.3995404e+08	8786	15929.21	4
2012	41	4	4121703	4.0398388e+08	25353	15934.36	4
2012	31	3	3139102	7.860416e+07	4930	15944.05	4
2012	35	3	3555208	3.088059e+07	1936	15950.72	4
2012	25	2	2502151	1.0234092e+08	6415	15953.38	4
2012	31	3	3147402	3.6546452e+08	22893	15964.03	4
2012	43	4	4305835	2.424385e+07	1518	15970.92	4
2012	29	2	2910503	6.4229686e+08	40180	15985.49	4
2012	43	4	4323705	4.422614e+07	2765	15994.99	4
2012	35	3	3504602	2.4100646e+08	15065	15997.77	4
2012	42	4	4200903	8.274553e+07	5171	16001.84	4
2012	31	3	3145109	2.4965833e+08	15599	16004.76	4
2012	26	2	2607901	1.048447318e+10	654786	16012.06	4
2012	41	4	4110102	4.6529212e+08	29053	16015.29	4
2012	41	4	4104709	2.2061762e+08	13767	16025.1	4
2012	35	3	3500501	2.7945621e+08	17438	16025.7	4
2012	43	4	4310876	4.056206e+07	2530	16032.43	4
2012	35	3	3553807	3.5829849e+08	22338	16039.86	4
2012	42	4	4205704	3.0300703e+08	18890	16040.61	4
2012	41	4	4114104	3.2447275e+08	20227	16041.57	4
2012	41	4	4126702	7.582872e+07	4726	16045.01	4
2012	41	4	4128203	8.5646808e+08	53372	16047.14	4
2012	51	5	5100250	7.9439222e+08	49494	16050.27	4
2012	41	4	4128625	5.008484e+07	3119	16057.98	4
2012	43	4	4309654	9.871318e+07	6147	16058.76	4
2012	22	2	2211001	1.334753116e+10	830231	16076.89	4
2012	35	3	3541307	6.6918692e+08	41624	16076.95	4
2012	41	4	4111258	3.9510465e+08	24573	16078.81	4
2012	41	4	4123907	1.9747387e+08	12279	16082.24	4
2012	41	4	4112207	1.0128925e+08	6298	16082.76	4
2012	31	3	3148905	6.248491e+07	3885	16083.63	4
2012	41	4	4102109	4.0004983e+08	24859	16092.76	4
2012	35	3	3555901	1.976492e+07	1228	16095.21	4
2012	42	4	4210308	1.218129e+08	7566	16100.04	4
2012	29	2	2910800	9.14860239e+09	568099	16103.89	4
2012	31	3	3163706	6.8257525e+08	42372	16109.11	4
2012	41	4	4126652	5.344976e+07	3315	16123.61	4
2012	42	4	4205431	4.165492e+07	2583	16126.57	4
2012	41	4	4127858	1.907062e+08	11825	16127.37	4
2012	29	2	2927002	6.0910846e+08	37754	16133.61	4
2012	31	3	3124500	1.761871e+08	10918	16137.31	4
2012	43	4	4305587	3.89619e+07	2414	16139.98	4
2012	35	3	3542008	9.832022e+07	6089	16147.19	4
2012	31	3	3147709	1.317575e+08	8155	16156.65	4
2012	11	1	1100379	2.073654e+08	12833	16158.76	4
2012	50	5	5005681	2.787856e+08	17251	16160.55	4
2012	41	4	4109906	1.3991461e+08	8657	16162.02	4
2012	32	3	3205176	2.2347132e+08	13824	16165.46	4
2012	43	4	4315503	2.5603666e+08	15828	16176.18	4
2012	31	3	3108800	8.044636e+07	4973	16176.63	4
2012	31	3	3105103	3.7042363e+08	22891	16182.06	4
2012	35	3	3542909	1.9855551e+08	12270	16182.19	4
2012	35	3	3530201	2.7819386e+08	17187	16186.3	4
2012	35	3	3524204	1.0716823e+08	6618	16193.45	4
2012	25	2	2504009	6.31582911e+09	389995	16194.64	4
2012	35	3	3556008	2.0812346e+08	12848	16198.9	4
2012	27	2	2703759	1.925687e+08	11887	16199.94	4
2012	42	4	4210852	4.013256e+07	2477	16202.08	4
2012	42	4	4214409	9.962264e+07	6146	16209.35	4
2012	41	4	4118451	8.005956e+07	4939	16209.67	4
2012	41	4	4117255	1.6823199e+08	10374	16216.69	4
2012	35	3	3555307	3.113662e+07	1920	16216.99	4
2012	32	3	3200805	4.7485209e+08	29272	16222.06	4
2012	27	2	2704302	1.546717375e+10	953393	16223.29	4
2012	33	3	3304805	6.1093841e+08	37657	16223.77	4
2012	43	4	4320859	6.842435e+07	4217	16225.83	4
2012	52	5	5212303	1.2820494e+08	7900	16228.47	4
2012	31	3	3169604	3.9518261e+08	24350	16229.27	4
2012	35	3	3532504	1.4209876e+08	8752	16236.15	4
2012	11	1	1100031	9.958648e+07	6132	16240.46	4
2012	41	4	4102604	1.5921648e+08	9796	16253.21	4
2012	24	2	2404408	1.5548533e+08	9566	16253.96	4
2012	31	3	3123809	1.1590378e+08	7128	16260.35	4
2012	41	4	4104105	1.1782666e+08	7245	16263.17	4
2012	41	4	4101200	3.0736136e+08	18849	16306.51	4
2012	43	4	4316105	1.6715461e+08	10247	16312.54	4
2012	42	4	4215679	1.4289672e+08	8756	16319.86	4
2012	35	3	3537503	1.2468494e+08	7640	16320.02	4
2012	35	3	3515194	7.069822e+07	4330	16327.53	4
2012	41	4	4105706	2.7908568e+08	17075	16344.7	4
2012	43	4	4307302	1.2574823e+08	7682	16369.2	4
2012	35	3	3503406	1.2993208e+08	7932	16380.75	4
2012	35	3	3552601	1.8838863e+08	11495	16388.75	4
2012	22	2	2201903	3.8747432e+08	23642	16389.24	4
2012	42	4	4211454	6.998203e+07	4269	16393.07	4
2012	41	4	4116901	4.3874682e+08	26749	16402.36	4
2012	41	4	4117453	9.396094e+07	5726	16409.52	4
2012	42	4	4207403	9.482883e+07	5777	16414.89	4
2012	24	2	2403251	3.51613522e+09	214199	16415.27	4
2012	43	4	4318424	7.714159e+07	4696	16427.09	4
2012	50	5	5006259	7.752079e+07	4718	16430.86	4
2012	28	2	2802304	2.3269667e+08	14162	16431.06	4
2012	35	3	3543204	7.294907e+07	4439	16433.67	4
2012	35	3	3524600	2.8379612e+08	17234	16467.22	4
2012	29	2	2900702	2.36347063e+09	143460	16474.77	4
2012	41	4	4108502	2.2465833e+08	13635	16476.59	4
2012	17	1	1720978	4.291682e+07	2601	16500.12	4
2012	52	5	5212907	3.45738e+07	2095	16503	4
2012	35	3	3512209	4.2273838e+08	25615	16503.55	4
2012	41	4	4116802	1.1636556e+08	7050	16505.75	4
2012	43	4	4317301	5.0597433e+08	30641	16512.98	4
2012	31	3	3100104	1.1135999e+08	6743	16514.9	4
2012	31	3	3101508	5.6918418e+08	34461	16516.76	4
2012	43	4	4314035	5.867808e+07	3552	16519.73	4
2012	43	4	4320701	2.3712345e+08	14348	16526.59	4
2012	11	1	1100288	8.4550003e+08	51142	16532.4	4
2012	42	4	4215554	3.887112e+07	2351	16533.87	4
2012	31	3	3170800	6.0258633e+08	36439	16536.85	4
2012	35	3	3509403	3.9303309e+08	23763	16539.71	4
2012	35	3	3513900	1.8361387e+08	11086	16562.68	4
2012	43	4	4319703	5.89642e+07	3560	16562.98	4
2012	33	3	3303708	6.9021498e+08	41639	16576.17	4
2012	43	4	4314456	4.169538e+07	2515	16578.68	4
2012	29	2	2910727	1.70147785e+09	102628	16579.08	4
2012	31	3	3168903	1.1289391e+08	6806	16587.41	4
2012	41	4	4107736	9.733544e+07	5867	16590.32	4
2012	42	4	4216503	4.1698337e+08	25111	16605.61	4
2012	35	3	3550506	1.2034614e+08	7245	16610.92	4
2012	31	3	3115300	1.17337513e+09	70630	16612.98	4
2012	43	4	4310330	3.0729003e+08	18490	16619.26	4
2012	43	4	4302253	4.601089e+07	2767	16628.44	4
2012	11	1	1100262	5.610583e+07	3374	16628.88	4
2012	52	5	5218706	7.649273e+07	4597	16639.71	4
2012	43	4	4301206	2.1260026e+08	12774	16643.2	4
2012	35	3	3539707	5.395765e+07	3242	16643.32	4
2012	31	3	3143203	3.5350277e+08	21238	16644.82	4
2012	27	2	2702306	8.8660373e+08	53224	16657.97	4
2012	33	3	3306107	1.21115113e+09	72679	16664.39	4
2012	52	5	5212600	3.950163e+07	2370	16667.35	4
2012	41	4	4126306	3.0856315e+08	18511	16669.18	4
2012	31	3	3143302	6.17232991e+09	370216	16672.24	4
2012	32	3	3201407	5.8448934e+08	35048	16676.82	4
2012	43	4	4313425	6.347887e+07	3806	16678.63	4
2012	43	4	4314787	2.850826e+07	1709	16681.25	4
2012	31	3	3147907	1.79630004e+09	107661	16684.78	4
2012	35	3	3548104	9.868407e+07	5912	16692.16	4
2012	42	4	4212403	6.808757e+07	4078	16696.31	4
2012	43	4	4302204	1.0976757e+08	6573	16699.77	4
2012	41	4	4103800	1.2229698e+08	7319	16709.52	4
2012	35	3	3528106	1.2875719e+08	7705	16710.86	4
2012	31	3	3116407	7.6673e+07	4588	16711.64	4
2012	35	3	3512803	1.01971593e+09	61013	16713.09	4
2012	41	4	4103404	4.557674e+07	2727	16713.14	4
2012	41	4	4127205	2.6657334e+08	15948	16715.16	4
2012	41	4	4107603	2.7449486e+08	16421	16716.09	4
2012	35	3	3509700	8.0797058e+08	48324	16719.86	4
2012	31	3	3126109	1.09614264e+09	65464	16744.21	4
2012	17	1	1716109	7.6469282e+08	45669	16744.24	4
2012	35	3	3515657	2.650995e+07	1583	16746.65	4
2012	31	3	3164308	1.1294432e+08	6741	16754.83	4
2012	35	3	3506706	2.3138791e+08	13807	16758.74	4
2012	35	3	3530102	4.645313e+08	27717	16759.8	4
2012	32	3	3203346	2.4438157e+08	14576	16766.02	4
2012	41	4	4100806	1.751293e+08	10439	16776.44	4
2012	31	3	3159506	9.472879e+07	5643	16786.95	4
2012	31	3	3153004	5.579224e+07	3323	16789.72	4
2012	35	3	3521705	2.9721645e+08	17699	16792.84	4
2012	31	3	3162922	4.4790575e+08	26653	16805.08	4
2012	35	3	3532702	7.441027e+07	4427	16808.28	4
2012	15	1	1505437	4.7996376e+08	28551	16810.75	4
2012	41	4	4126678	2.1262258e+08	12647	16812.1	4
2012	52	5	5217708	2.8941577e+08	17207	16819.65	4
2012	35	3	3507100	3.477542e+08	20674	16820.85	4
2012	43	4	4320206	1.8226347e+08	10829	16831.05	4
2012	43	4	4321204	9.244787e+08	54918	16833.8	4
2012	31	3	3121209	1.1565078e+08	6869	16836.63	4
2012	35	3	3507803	3.6548659e+08	21707	16837.27	4
2012	43	4	4314050	8.8450891e+08	52518	16842.01	4
2012	42	4	4216354	5.85954e+07	3477	16852.29	4
2012	35	3	3530904	5.550045e+07	3291	16864.31	4
2012	43	4	4305439	1.0177321e+08	6031	16875.01	4
2012	32	3	3204807	1.7546312e+08	10397	16876.32	4
2012	42	4	4211108	1.4088477e+08	8346	16880.51	4
2012	31	3	3140506	2.1494385e+08	12731	16883.5	4
2012	35	3	3522208	2.63512743e+09	156077	16883.51	4
2012	35	3	3515806	2.850745e+07	1688	16888.3	4
2012	35	3	3500550	9.559261e+07	5658	16895.12	4
2012	43	4	4308003	1.1230195e+08	6647	16895.13	4
2012	35	3	3519808	1.2785104e+08	7567	16895.87	4
2012	41	4	4107306	9.860763e+07	5836	16896.44	4
2012	31	3	3112802	1.3951991e+08	8251	16909.45	4
2012	35	3	3538808	4.8307709e+08	28563	16912.69	4
2012	43	4	4300406	1.29633497e+09	76644	16913.72	4
2012	51	5	5101258	2.6375608e+08	15594	16913.95	4
2012	15	1	1505502	1.70939598e+09	101046	16917.01	4
2012	35	3	3552908	9.798698e+07	5789	16926.41	4
2012	35	3	3522406	1.49808278e+09	88491	16929.21	4
2012	43	4	4304408	6.7869322e+08	40076	16935.15	4
2012	31	3	3144706	2.9628628e+08	17494	16936.45	4
2012	35	3	3510807	4.8333846e+08	28535	16938.44	4
2012	52	5	5221197	1.1496143e+08	6785	16943.47	4
2012	43	4	4310306	6.913994e+07	4079	16950.22	4
2012	43	4	4318903	5.8041718e+08	34235	16953.91	4
2012	51	5	5106752	7.1314649e+08	42063	16954.25	4
2012	43	4	4312625	3.086972e+07	1820	16961.39	4
2012	35	3	3517109	7.779174e+07	4586	16962.87	4
2012	35	3	3531605	6.888359e+07	4060	16966.4	4
2012	24	2	2402303	3.3425388e+08	19692	16974.09	4
2012	25	2	2503001	3.505961e+08	20653	16975.55	4
2012	41	4	4107900	1.0288041e+08	6054	16993.79	4
2012	35	3	3506409	1.2230534e+08	7193	17003.38	4
2012	52	5	5200852	9.513482e+07	5595	17003.54	4
2012	35	3	3519204	1.0826845e+08	6365	17009.97	4
2012	21	2	2110658	1.205854e+08	7088	17012.61	4
2012	31	3	3163102	7.398739e+07	4345	17028.17	4
2012	43	4	4318622	5.652225e+07	3319	17029.9	4
2012	31	3	3143500	1.4229227e+08	8353	17034.87	4
2012	43	4	4319711	3.703337e+07	2173	17042.51	4
2012	33	3	3302056	2.4351489e+08	14281	17051.67	4
2012	43	4	4301057	1.3851468e+08	8113	17073.18	4
2012	42	4	4206702	3.6599212e+08	21420	17086.47	4
2012	31	3	3105905	3.3809491e+08	19787	17086.72	4
2012	26	2	2616407	2.21978642e+09	129907	17087.5	4
2012	43	4	4313607	7.103425e+07	4155	17096.09	4
2012	41	4	4123402	1.8240736e+08	10668	17098.55	4
2012	52	5	5220108	5.2305263e+08	30586	17101.05	4
2012	41	4	4128302	4.247488e+07	2482	17113.17	4
2012	29	2	2903276	2.4816617e+08	14495	17120.81	4
2012	15	1	1504208	4.17045061e+09	243583	17121.27	4
2012	35	3	3541653	5.697264e+07	3325	17134.63	4
2012	42	4	4216305	4.7960454e+08	27982	17139.75	4
2012	35	3	3531506	3.2291145e+08	18838	17141.49	4
2012	33	3	3301207	3.0469065e+08	17758	17157.94	4
2012	32	3	3201902	5.4982397e+08	32042	17159.48	4
2012	43	4	4311502	1.3073499e+08	7615	17168.09	4
2012	35	3	3515905	5.100019e+07	2970	17171.78	4
2012	43	4	4306304	8.028431e+07	4675	17173.11	4
2012	35	3	3540408	7.196744e+07	4189	17180.1	4
2012	52	5	5206305	5.042545e+07	2934	17186.59	4
2012	31	3	3153400	3.2137414e+08	18698	17187.62	4
2012	15	1	1503044	3.1464228e+08	18295	17198.27	4
2012	43	4	4319604	4.072416e+08	23674	17202.06	4
2012	29	2	2917706	5.2946899e+08	30769	17207.87	4
2012	51	5	5107743	3.495348e+07	2031	17209.99	4
2012	41	4	4121307	6.744745e+07	3919	17210.37	4
2012	42	4	4212601	5.081653e+07	2952	17214.27	4
2012	35	3	3514601	1.4504917e+08	8421	17224.7	4
2012	42	4	4213906	2.926062e+07	1697	17242.56	4
2012	31	3	3102605	6.5426184e+08	37920	17253.74	4
2012	42	4	4215505	2.744494e+08	15902	17258.8	4
2012	43	4	4311643	2.822406e+07	1634	17272.99	4
2012	52	5	5209705	3.1181252e+08	18050	17274.93	4
2012	32	3	3205150	1.507546e+08	8724	17280.44	4
2012	43	4	4305959	6.727883e+07	3891	17290.88	4
2012	41	4	4104501	3.2122469e+08	18570	17298.04	4
2012	11	1	1100049	1.37270509e+09	79330	17303.73	4
2012	33	3	3301157	2.1805743e+08	12601	17304.77	4
2012	43	4	4314753	3.50233e+07	2023	17312.56	4
2012	52	5	5205000	1.5761328e+08	9097	17325.85	4
2012	35	3	3553708	9.4070053e+08	54279	17330.84	4
2012	35	3	3545704	9.962486e+07	5744	17344.16	4
2012	35	3	3508801	2.9021619e+08	16730	17347.05	4
2012	41	4	4108809	5.3813457e+08	31013	17351.9	4
2012	35	3	3500303	5.6818997e+08	32745	17351.96	4
2012	22	2	2203230	8.295346e+07	4776	17368.81	4
2012	43	4	4318200	3.5909943e+08	20660	17381.39	4
2012	33	3	3300308	1.66511124e+09	95726	17394.56	4
2012	16	1	1600238	1.0682066e+08	6141	17394.67	4
2012	31	3	3152600	1.0693177e+08	6145	17401.43	4
2012	42	4	4203105	1.0788335e+08	6199	17403.35	4
2012	41	4	4101408	2.13924049e+09	122896	17406.92	4
2012	43	4	4322301	1.4637488e+08	8409	17406.93	4
2012	17	1	1718204	8.6650227e+08	49774	17408.73	4
2012	31	3	3101003	2.2375341e+08	12850	17412.72	4
2012	43	4	4314407	5.73642763e+09	329435	17412.93	4
2012	41	4	4109005	6.745779e+07	3865	17453.5	4
2012	35	3	3549250	3.137963e+07	1797	17462.23	4
2012	31	3	3107406	8.1180543e+08	46482	17464.94	4
2012	35	3	3520442	4.4060325e+08	25226	17466.24	4
2012	35	3	3535804	3.1710646e+08	18155	17466.62	4
2012	35	3	3523602	2.7833093e+08	15930	17472.12	4
2012	31	3	3117504	3.1125313e+08	17798	17488.1	4
2012	52	5	5213053	4.667583e+07	2668	17494.69	4
2012	35	3	3553609	2.2237497e+08	12707	17500.19	4
2012	41	4	4127965	2.3850133e+08	13628	17500.83	4
2012	41	4	4103909	2.6527179e+08	15149	17510.84	4
2012	43	4	4307864	4.546146e+07	2596	17512.12	4
2012	41	4	4103958	7.063246e+07	4033	17513.63	4
2012	31	3	3133600	1.5526528e+08	8861	17522.32	4
2012	43	4	4309704	8.546042e+07	4873	17537.54	4
2012	41	4	4112900	5.962515e+07	3399	17541.97	4
2012	52	5	5220454	1.56469964e+09	89176	17546.2	4
2012	43	4	4314076	1.0672536e+08	6079	17556.4	4
2012	28	2	2805901	1.6701096e+08	9509	17563.46	4
2012	41	4	4105409	3.4340062e+08	19549	17566.15	4
2012	21	2	2105302	4.39331203e+09	250063	17568.82	4
2012	35	3	3551603	4.7046909e+08	26770	17574.49	4
2012	43	4	4312302	8.498496e+07	4828	17602.52	4
2012	43	4	4305504	8.580235e+07	4873	17607.71	4
2012	41	4	4128609	1.3653051e+08	7751	17614.57	4
2012	43	4	4319372	5.066973e+07	2875	17624.25	4
2012	15	1	1508126	8.2808429e+08	46979	17626.69	4
2012	35	3	3507407	2.59663e+08	14731	17626.98	4
2012	52	5	5215652	5.959803e+07	3381	17627.34	4
2012	42	4	4214508	1.0834391e+08	6143	17636.97	4
2012	41	4	4111407	2.2847479e+08	12954	17637.39	4
2012	35	3	3502309	1.0281259e+08	5822	17659.32	4
2012	51	5	5105622	4.5361092e+08	25684	17661.23	4
2012	41	4	4110656	4.455421e+07	2522	17666.22	4
2012	52	5	5201405	8.37796398e+09	474219	17666.87	4
2012	29	2	2927408	4.794035011e+10	2710968	17683.85	4
2012	35	3	3551801	2.2823313e+08	12898	17695.23	4
2012	35	3	3525102	6.8556264e+08	38708	17711.14	4
2012	41	4	4112751	1.5732562e+08	8876	17724.83	4
2012	50	5	5003751	2.0901539e+08	11790	17728.19	4
2012	24	2	2401453	4.4293483e+08	24977	17733.71	4
2012	43	4	4318408	3.9758825e+08	22414	17738.39	4
2012	35	3	3541059	8.335642e+07	4697	17746.74	4
2012	31	3	3134905	4.1468879e+08	23341	17766.54	4
2012	17	1	1703057	5.689443e+07	3200	17779.51	4
2012	31	3	3138807	3.1275355e+08	17585	17785.25	4
2012	31	3	3115003	5.151208e+07	2893	17805.77	4
2012	52	5	5219738	8.806122e+07	4945	17808.13	4
2012	52	5	5212204	3.3880494e+08	19020	17813.09	4
2012	51	5	5105606	2.6026231e+08	14610	17813.98	4
2012	35	3	3543105	7.719474e+07	4333	17815.54	4
2012	41	4	4127007	1.888758e+08	10599	17820.15	4
2012	41	4	4101150	5.101039e+07	2862	17823.34	4
2012	52	5	5202809	4.352698e+07	2442	17824.32	4
2012	42	4	4205555	4.276406e+07	2399	17825.78	4
2012	42	4	4206801	5.956638e+07	3341	17828.91	4
2012	52	5	5222203	8.846494e+07	4954	17857.27	4
2012	41	4	4125209	1.6170575e+08	9052	17864.09	4
2012	31	3	3113206	4.2334968e+08	23692	17868.89	4
2012	41	4	4119202	1.1105882e+08	6215	17869.48	4
2012	42	4	4212809	3.220658e+08	18010	17882.61	4
2012	22	2	2204303	2.0191248e+08	11284	17893.7	4
2012	35	3	3539905	9.829765e+07	5489	17908.12	4
2012	16	1	1600303	7.45035092e+09	415554	17928.72	4
2012	43	4	4305405	7.140688e+07	3979	17945.94	4
2012	42	4	4205001	2.6743679e+08	14896	17953.6	4
2012	35	3	3501004	2.8064681e+08	15627	17959.1	4
2012	41	4	4118402	1.48140594e+09	82472	17962.53	4
2012	52	5	5207253	1.399819e+08	7792	17964.82	4
2012	41	4	4103305	1.3735127e+08	7641	17975.56	4
2012	42	4	4204400	1.8276702e+08	10165	17980.03	4
2012	41	4	4108957	1.4419137e+08	8016	17987.95	4
2012	41	4	4108601	5.200839e+08	28908	17991	4
2012	41	4	4109658	1.0460972e+08	5813	17995.82	4
2012	12	1	1200401	6.27061895e+09	348354	18000.71	4
2012	17	1	1714880	1.9596108e+08	10883	18006.16	4
2012	42	4	4200754	3.585564e+07	1991	18008.86	4
2012	43	4	4319158	1.339188e+08	7436	18009.52	4
2012	41	4	4103602	4.3344886e+08	24060	18015.33	4
2012	43	4	4317608	7.2252137e+08	40086	18024.28	4
2012	31	3	3128303	3.3795321e+08	18727	18046.31	4
2012	32	3	3202504	2.0465873e+08	11335	18055.47	4
2012	35	3	3542701	1.2174536e+08	6739	18065.79	4
2012	35	3	3549300	3.779395e+07	2092	18065.94	4
2012	43	4	4313086	4.445805e+07	2459	18079.73	4
2012	35	3	3518602	6.5383224e+08	36151	18086.15	4
2012	43	4	4306452	5.94563e+07	3287	18088.32	4
2012	52	5	5200209	3.591288e+07	1985	18092.13	4
2012	42	4	4202131	1.0942826e+08	6047	18096.29	4
2012	31	3	3136306	8.2991982e+08	45848	18101.55	4
2012	43	4	4322525	5.943573e+07	3283	18104.09	4
2012	35	3	3537602	1.10518765e+09	61030	18108.92	4
2012	41	4	4103040	1.1807462e+08	6520	18109.6	4
2012	35	3	3550803	2.1815832e+08	12046	18110.44	4
2012	43	4	4303004	1.50709879e+09	83217	18110.47	4
2012	35	3	3503000	9.437665e+07	5211	18111.04	4
2012	41	4	4108205	1.3328457e+08	7358	18114.24	4
2012	43	4	4320552	1.0759342e+08	5938	18119.47	4
2012	29	2	2929503	7.6991612e+08	42485	18122.07	4
2012	42	4	4207650	1.5392189e+08	8490	18129.79	4
2012	43	4	4300703	1.0950488e+08	6035	18144.97	4
2012	35	3	3536604	1.5626732e+08	8607	18155.84	4
2012	33	3	3304706	7.4266628e+08	40876	18168.76	4
2012	43	4	4304952	5.505441e+07	3030	18169.77	4
2012	29	2	2919926	3.3039546e+08	18183	18170.57	4
2012	41	4	4116505	2.627692e+07	1446	18172.15	4
2012	43	4	4306924	2.610461e+07	1436	18178.7	4
2012	43	4	4300109	3.0203093e+08	16612	18181.49	4
2012	43	4	4306759	3.665813e+07	2016	18183.59	4
2012	43	4	4302501	1.2280413e+08	6753	18185.12	4
2012	21	2	2101251	2.8360741e+08	15591	18190.46	4
2012	41	4	4125605	7.6407911e+08	41965	18207.53	4
2012	35	3	3557303	1.8617966e+08	10224	18210.06	4
2012	31	3	3123007	1.7198423e+08	9443	18212.88	4
2012	33	3	3305133	1.292006e+08	7093	18215.23	4
2012	43	4	4301305	3.3485771e+08	18368	18230.49	4
2012	41	4	4111803	7.1194996e+08	39045	18234.09	4
2012	52	5	5211602	4.768493e+07	2614	18242.13	4
2012	35	3	3547106	5.174381e+07	2836	18245.35	4
2012	35	3	3504800	1.5116955e+08	8284	18248.38	4
2012	43	4	4305900	1.3963088e+08	7645	18264.34	4
2012	43	4	4315131	3.338223e+07	1827	18271.61	4
2012	41	4	4112603	2.54531e+07	1392	18285.27	4
2012	43	4	4322186	2.834992e+07	1550	18290.27	4
2012	50	5	5008404	1.0831243e+08	5920	18296.02	4
2012	42	4	4213401	2.0320021e+08	11102	18303.03	4
2012	42	4	4210407	1.1964498e+08	6535	18308.34	4
2012	23	2	2304400	4.577542896e+10	2500194	18308.75	4
2012	51	5	5105507	2.7048417e+08	14770	18313.08	4
2012	51	5	5103304	3.4161002e+08	18651	18315.91	4
2012	31	3	3123502	3.389097e+07	1850	18319.44	4
2012	41	4	4105607	2.0690568e+08	11294	18319.96	4
2012	31	3	3125705	2.6243094e+08	14323	18322.34	4
2012	31	3	3170438	8.035953e+07	4385	18326	4
2012	41	4	4107702	8.763838e+07	4781	18330.55	4
2012	35	3	3519501	1.2617724e+08	6880	18339.72	4
2012	43	4	4322558	3.668385e+07	1999	18351.1	4
2012	35	3	3539509	6.5974258e+08	35934	18359.84	4
2012	11	1	1100023	1.70364194e+09	92747	18368.7	4
2012	41	4	4119954	4.0260344e+08	21917	18369.46	4
2012	52	5	5205406	3.8459841e+08	20924	18380.73	4
2012	31	3	3110509	3.8908932e+08	21162	18386.23	4
2012	42	4	4201273	7.722633e+07	4198	18395.98	4
2012	43	4	4312708	2.2018163e+08	11962	18406.76	4
2012	50	5	5006309	7.4577579e+08	40462	18431.51	4
2012	52	5	5206602	5.424393e+07	2943	18431.51	4
2012	31	3	3143104	8.4886915e+08	46055	18431.64	4
2012	43	4	4318440	5.08875e+07	2759	18444.18	4
2012	42	4	4212270	8.06989e+07	4374	18449.68	4
2012	31	3	3139003	7.2444089e+08	39264	18450.51	4
2012	52	5	5211305	1.1862204e+08	6429	18451.09	4
2012	43	4	4306205	2.2917368e+08	12420	18451.99	4
2012	35	3	3512506	9.89686e+07	5362	18457.4	4
2012	33	3	3300803	1.01818984e+09	55139	18465.87	4
2012	43	4	4316006	3.6444727e+08	19732	18469.86	4
2012	50	5	5004700	4.1493141e+08	22447	18484.94	4
2012	24	2	2407104	1.32490748e+09	71670	18486.22	4
2012	33	3	3302205	1.79810044e+09	97219	18495.36	4
2012	35	3	3547908	1.1811591e+08	6386	18496.07	4
2012	43	4	4312500	2.2563168e+08	12195	18501.98	4
2012	52	5	5217203	2.0562335e+08	11112	18504.62	4
2012	42	4	4214607	1.3231976e+08	7145	18519.21	4
2012	41	4	4109104	4.11764e+07	2223	18522.9	4
2012	43	4	4320230	5.524411e+07	2982	18525.86	4
2012	41	4	4125100	2.5757048e+08	13899	18531.58	4
2012	13	1	1301308	4.4641745e+08	24067	18548.94	4
2012	43	4	4304309	1.1970226e+08	6451	18555.61	4
2012	31	3	3109907	1.9427041e+08	10467	18560.28	4
2012	35	3	3554755	2.912593e+07	1569	18563.37	4
2012	43	4	4308250	3.651931e+07	1967	18565.99	4
2012	42	4	4217709	5.0467168e+08	27165	18578.01	4
2012	35	3	3519006	1.6359453e+08	8803	18583.95	4
2012	31	3	3152105	1.07263165e+09	57706	18587.87	4
2012	41	4	4125902	4.567082e+07	2454	18610.77	4
2012	43	4	4308656	5.89639e+07	3168	18612.34	4
2012	43	4	4317509	1.42238055e+09	76205	18665.19	4
2012	33	3	3303401	3.42356388e+09	183391	18668.11	4
2012	31	3	3136801	7.742743e+07	4146	18675.21	4
2012	51	5	5104203	2.6406705e+08	14137	18679.14	4
2012	35	3	3526001	3.5485736e+08	18986	18690.47	4
2012	15	1	1501402	2.636201518e+10	1410430	18690.76	4
2012	35	3	3509957	8.417243e+07	4502	18696.68	4
2012	17	1	1709500	1.46828329e+09	78525	18698.29	4
2012	50	5	5002209	3.7380714e+08	19985	18704.39	4
2012	43	4	4321501	6.5906321e+08	35227	18709.04	4
2012	43	4	4302303	2.1415205e+08	11445	18711.41	4
2012	35	3	3536208	3.4753723e+08	18567	18718.01	4
2012	35	3	3527207	1.55860097e+09	83224	18727.78	4
2012	43	4	4313334	4.483623e+07	2394	18728.58	4
2012	35	3	3509601	1.41679996e+09	75637	18731.57	4
2012	43	4	4306973	5.548853e+07	2962	18733.47	4
2012	43	4	4310439	1.142975e+08	6101	18734.22	4
2012	35	3	3545407	1.6563226e+08	8839	18738.8	4
2012	31	3	3139409	1.52657389e+09	81455	18741.32	4
2012	42	4	4201604	6.569551e+07	3504	18748.72	4
2012	42	4	4217105	6.001385e+07	3200	18754.33	4
2012	43	4	4318614	3.999942e+07	2132	18761.45	4
2012	33	3	3301900	4.17884559e+09	222618	18771.37	4
2012	42	4	4208955	3.252465e+07	1732	18778.67	4
2012	35	3	3503356	3.551705e+07	1890	18792.09	4
2012	32	3	3205069	3.9657157e+08	21094	18800.21	4
2012	31	3	3164704	1.24105144e+09	65984	18808.37	4
2012	41	4	4111555	1.4304635e+08	7603	18814.46	4
2012	31	3	3145208	1.48978314e+09	79174	18816.57	4
2012	52	5	5205059	6.777948e+07	3602	18817.18	4
2012	42	4	4203402	1.3921582e+08	7398	18818.03	4
2012	52	5	5210406	6.870568e+08	36503	18821.93	4
2012	41	4	4103024	5.106848e+07	2713	18823.62	4
2012	41	4	4120507	2.0423623e+08	10848	18827.09	4
2012	35	3	3535002	2.1374528e+08	11346	18838.82	4
2012	31	3	3148004	2.65551367e+09	140950	18840.11	4
2012	43	4	4306130	3.920152e+07	2080	18846.89	4
2012	35	3	3521309	2.7321363e+08	14492	18852.72	4
2012	31	3	3154705	7.27656e+07	3857	18865.85	4
2012	41	4	4118105	1.9668288e+08	10423	18870.08	4
2012	25	2	2507507	1.40121916e+10	742478	18872.2	4
2012	41	4	4128534	1.9347753e+08	10249	18877.7	4
2012	51	5	5104500	4.626654e+07	2449	18892.01	4
2012	42	4	4210050	3.429057e+07	1815	18892.87	4
2012	42	4	4205191	3.872124e+07	2049	18897.63	4
2012	52	5	5209952	2.6402544e+08	13970	18899.46	4
2012	43	4	4304002	9.963029e+07	5269	18908.77	4
2012	42	4	4201901	1.0518296e+08	5561	18914.4	4
2012	35	3	3519907	1.4552584e+08	7685	18936.35	4
2012	41	4	4119400	4.4951014e+08	23693	18972.28	4
2012	35	3	3525409	5.961288e+07	3142	18972.91	4
2012	35	3	3553302	4.2554748e+08	22429	18973.09	4
2012	50	5	5003306	6.1415465e+08	32355	18981.75	4
2012	51	5	5108402	4.90306095e+09	258208	18988.8	4
2012	41	4	4110706	1.07852052e+09	56790	18991.38	4
2012	50	5	5004304	2.8621917e+08	15065	18998.95	4
2012	41	4	4105904	4.2878298e+08	22555	19010.55	4
2012	50	5	5006606	1.5293161e+09	80433	19013.54	4
2012	35	3	3540200	7.9580767e+08	41840	19020.26	4
2012	42	4	4205209	8.304662e+07	4365	19025.57	4
2012	41	4	4127601	2.832456e+08	14881	19034.04	4
2012	15	1	1501303	2.00644948e+09	105385	19039.23	4
2012	35	3	3502507	6.6700069e+08	35023	19044.65	4
2012	33	3	3305703	2.8591819e+08	15010	19048.51	4
2012	50	5	5004601	3.628169e+08	19044	19051.51	4
2012	50	5	5002902	4.0225105e+08	21099	19064.93	4
2012	41	4	4114302	4.3730677e+08	22927	19073.88	4
2012	41	4	4111100	1.1413993e+08	5983	19077.37	4
2012	22	2	2210631	7.941894e+07	4159	19095.68	4
2012	35	3	3518859	1.3474189e+08	7056	19096.07	4
2012	41	4	4101002	3.3546283e+08	17563	19100.54	4
2012	42	4	4206900	3.3564461e+08	17561	19113.07	4
2012	43	4	4316907	5.04101916e+09	263662	19119.25	4
2012	43	4	4321303	4.9968768e+08	26123	19128.27	4
2012	42	4	4207908	2.0211311e+08	10556	19146.75	4
2012	43	4	4322707	4.6699091e+08	24389	19147.6	4
2012	43	4	4312955	3.686102e+07	1921	19188.45	4
2012	33	3	3304128	2.5148232e+08	13105	19189.8	4
2012	35	3	3520905	2.6544604e+08	13831	19192.11	4
2012	42	4	4213708	2.9183092e+08	15204	19194.35	4
2012	50	5	5003900	5.654615e+07	2945	19200.73	4
2012	41	4	4120101	8.753928e+07	4556	19214.07	4
2012	42	4	4216255	1.1673051e+08	6074	19218.06	4
2012	35	3	3546108	4.000413e+07	2079	19242.01	4
2012	35	3	3518701	5.67191082e+09	294669	19248.41	4
2012	41	4	4113403	7.895034e+07	4101	19251.48	4
2012	35	3	3554300	4.157496e+08	21595	19252.12	4
2012	43	4	4314175	4.169844e+07	2164	19269.15	4
2012	43	4	4306429	4.097019e+07	2126	19271.02	4
2012	43	4	4313003	6.162647e+07	3197	19276.34	4
2012	41	4	4126108	1.0401261e+08	5395	19279.45	4
2012	22	2	2209203	1.1775792e+08	6106	19285.61	4
2012	43	4	4306379	5.873086e+07	3044	19293.97	4
2012	32	3	3200706	1.9456167e+08	10080	19301.75	4
2012	51	5	5101803	1.10550506e+09	57235	19315.19	4
2012	33	3	3302452	1.0298998e+08	5327	19333.58	4
2012	35	3	3543303	2.21239419e+09	114361	19345.71	4
2012	43	4	4323606	3.026254e+07	1562	19374.23	4
2012	31	3	3138203	1.82581995e+09	94228	19376.62	4
2012	32	3	3202603	2.4594913e+08	12681	19395.09	4
2012	43	4	4311155	1.6175655e+08	8339	19397.6	4
2012	35	3	3533502	7.2220141e+08	37222	19402.54	4
2012	52	5	5217401	5.6554851e+08	29145	19404.65	4
2012	31	3	3104106	1.8888506e+08	9732	19408.66	4
2012	11	1	1100114	1.00496379e+09	51765	19413.96	4
2012	41	4	4102000	6.4065123e+08	32981	19424.86	4
2012	42	4	4209805	6.431021e+07	3309	19434.94	4
2012	42	4	4200309	9.696854e+07	4985	19452.06	4
2012	15	1	1505304	1.26424201e+09	64978	19456.46	4
2012	35	3	3524808	9.1721081e+08	47137	19458.4	4
2012	42	4	4206405	2.0279496e+08	10417	19467.69	4
2012	31	3	3162005	4.7011312e+08	24148	19467.99	4
2012	52	5	5200308	4.7472783e+08	24383	19469.62	4
2012	41	4	4102802	2.9375547e+08	15087	19470.77	4
2012	41	4	4123204	6.983616e+07	3583	19490.97	4
2012	35	3	3516853	8.702061e+07	4464	19493.86	4
2012	35	3	3528007	3.1856431e+08	16336	19500.75	4
2012	32	3	3201308	6.87801214e+09	352431	19515.91	4
2012	43	4	4313656	2.1447515e+08	10987	19520.81	4
2012	43	4	4318002	1.19503841e+09	61189	19530.28	4
2012	31	3	3137205	9.1942204e+08	47076	19530.59	4
2012	31	3	3142601	1.6102691e+08	8244	19532.62	4
2012	23	2	2305233	1.14181342e+09	58418	19545.58	4
2012	41	4	4121406	3.2062834e+08	16386	19567.21	4
2012	43	4	4312427	5.476611e+07	2797	19580.3	4
2012	41	4	4122503	2.1971814e+08	11221	19580.98	4
2012	21	2	2100501	2.1265171e+08	10856	19588.4	4
2012	17	1	1720853	3.49358e+07	1783	19593.83	4
2012	25	2	2504603	4.3409862e+08	22154	19594.59	4
2012	31	3	3107604	7.725055e+07	3942	19596.79	4
2012	41	4	4120358	1.0860339e+08	5533	19628.3	4
2012	35	3	3537305	1.16004767e+09	59096	19629.88	4
2012	35	3	3556503	2.14455304e+09	109247	19630.32	4
2012	11	1	1100122	2.31872851e+09	118092	19634.93	4
2012	35	3	3502705	4.8900435e+08	24894	19643.46	4
2012	42	4	4206603	9.709772e+07	4941	19651.43	4
2012	14	1	1400100	5.8357462e+09	296959	19651.69	4
2012	35	3	3501103	8.015299e+07	4078	19654.98	4
2012	43	4	4313102	1.248417e+08	6347	19669.4	4
2012	43	4	4317806	2.736672e+08	13899	19689.7	4
2012	41	4	4104428	2.9761051e+08	15104	19704.09	4
2012	41	4	4111209	2.1167938e+08	10738	19713.11	4
2012	43	4	4315800	2.0574997e+08	10436	19715.41	4
2012	32	3	3205101	1.3162974e+09	66745	19721.29	4
2012	32	3	3200300	2.7632764e+08	14007	19727.82	4
2012	31	3	3127107	1.0754685e+09	54511	19729.38	4
2012	43	4	4320008	2.60873153e+09	132197	19733.67	4
2012	43	4	4319109	1.1233253e+08	5691	19738.63	4
2012	42	4	4202602	1.7943191e+08	9090	19739.48	4
2012	52	5	5214838	2.3809274e+08	12058	19745.62	4
2012	21	2	2109007	4.3933908e+08	22239	19755.34	4
2012	43	4	4322103	1.1534447e+08	5837	19760.92	4
2012	43	4	4312476	1.1426377e+08	5781	19765.4	4
2012	52	5	5215405	7.878995e+07	3986	19766.67	4
2012	41	4	4115754	1.753528e+08	8870	19769.2	4
2012	42	4	4200200	1.8899746e+08	9552	19786.17	4
2012	50	5	5002605	2.6947564e+08	13609	19801.28	4
2012	43	4	4304630	8.671724e+08	43783	19806.14	4
2012	42	4	4215000	7.95632e+08	40169	19807.12	4
2012	35	3	3514403	8.6510539e+08	43675	19807.79	4
2012	35	3	3519600	1.0729602e+09	54146	19816.06	4
2012	35	3	3528304	6.280022e+07	3167	19829.56	4
2012	31	3	3161304	1.1625553e+08	5852	19865.95	4
2012	42	4	4208609	7.982347e+07	4018	19866.47	4
2012	41	4	4106605	4.0636865e+08	20446	19875.22	4
2012	43	4	4311130	7.058914e+07	3549	19889.87	4
2012	41	4	4107405	1.2061865e+08	6061	19900.78	4
2012	35	3	3553401	4.8348779e+08	24277	19915.47	4
2012	42	4	4217600	2.6164932e+08	13137	19916.98	4
2012	41	4	4113007	1.3264711e+08	6657	19925.96	4
2012	31	3	3154804	1.8545242e+08	9307	19926.12	4
2012	35	3	3516705	8.5899503e+08	43108	19926.58	4
2012	33	3	3306206	6.94817e+08	34858	19932.78	4
2012	35	3	3513405	1.54655499e+09	77575	19936.26	4
2012	24	2	2403707	1.1494119e+08	5765	19937.76	4
2012	31	3	3151503	6.4523488e+08	32352	19944.2	4
2012	50	5	5006408	1.5722122e+08	7882	19946.87	4
2012	51	5	5105200	2.2610438e+08	11335	19947.45	4
2012	31	3	3101409	5.834159e+07	2924	19952.66	4
2012	35	3	3507456	4.68686e+07	2348	19961.07	4
2012	29	2	2903201	2.81637024e+09	141081	19962.79	4
2012	42	4	4219408	7.293852e+07	3653	19966.75	4
2012	17	1	1707652	1.0607555e+08	5307	19987.86	4
2012	15	1	1507979	3.4602151e+08	17305	19995.46	4
2012	41	4	4107504	2.7791403e+08	13880	20022.62	4
2012	50	5	5007554	1.4737062e+08	7353	20042.24	4
2012	33	3	3302908	4.9647746e+08	24754	20056.45	4
2012	43	4	4306601	7.7588468e+08	38670	20064.25	4
2012	31	3	3172004	7.7818991e+08	38749	20082.84	4
2012	35	3	3510005	6.0202905e+08	29976	20083.7	4
2012	42	4	4200507	1.2372122e+08	6160	20084.61	4
2012	52	5	5222005	2.558726e+08	12737	20088.92	4
2012	31	3	3114550	1.9200943e+08	9556	20093.08	4
2012	35	3	3517901	2.038892e+08	10147	20093.54	4
2012	31	3	3110608	5.4385945e+08	27020	20128.03	4
2012	43	4	4322350	2.866646e+07	1424	20130.94	4
2012	35	3	3517703	4.0264944e+08	20001	20131.47	4
2012	42	4	4201406	1.25456257e+09	62308	20134.86	4
2012	29	2	2921906	2.0434622e+08	10145	20142.55	4
2012	43	4	4300877	1.0052049e+08	4990	20144.39	4
2012	11	1	1100189	6.8773244e+08	34135	20147.43	4
2012	42	4	4206108	1.2630719e+08	6268	20151.11	4
2012	31	3	3124708	7.065327e+07	3504	20163.6	4
2012	31	3	3162955	4.1401782e+08	20524	20172.37	4
2012	42	4	4207304	8.2412601e+08	40845	20176.91	4
2012	17	1	1721000	4.88672938e+09	242070	20187.26	4
2012	42	4	4213807	1.4674239e+08	7265	20198.54	4
2012	42	4	4215695	2.892193e+07	1431	20210.99	4
2012	35	3	3544301	1.971798e+08	9754	20215.28	4
2012	33	3	3300506	5.2042294e+08	25738	20220.02	4
2012	41	4	4123824	7.876129e+07	3895	20221.13	4
2012	24	2	2408102	1.654263554e+10	817590	20233.41	4
2012	31	3	3122306	4.3992373e+09	217404	20235.31	4
2012	41	4	4101903	3.2618542e+08	16099	20261.22	4
2012	42	4	4209904	2.1355244e+08	10526	20288.09	4
2012	31	3	3111101	3.9287944e+08	19358	20295.46	4
2012	51	5	5103056	2.2770969e+08	11213	20307.65	4
2012	42	4	4215208	1.1160529e+08	5494	20314.03	4
2012	42	4	4208708	2.1459108e+08	10562	20317.28	4
2012	41	4	4113452	1.0629446e+08	5231	20320.1	4
2012	41	4	4109401	3.43987466e+09	169252	20323.98	4
2012	35	3	3537404	5.0754004e+08	24953	20339.84	4
2012	35	3	3509809	9.345509e+07	4594	20342.86	4
2012	41	4	4123303	1.6317222e+08	8019	20348.2	4
2012	31	3	3119807	6.817552e+07	3349	20356.98	4
2012	43	4	4303509	1.28536848e+09	63124	20362.6	4
2012	43	4	4321907	4.8633695e+08	23861	20382.09	4
2012	42	4	4205456	4.725194e+08	23183	20382.15	4
2012	35	3	3504503	1.71067591e+09	83910	20387.03	4
2012	35	3	3513850	3.463928e+07	1699	20388.04	4
2012	42	4	4203303	2.3991127e+08	11766	20390.21	4
2012	43	4	4315750	8.92136e+07	4370	20415.01	4
2012	35	3	3535309	4.3405589e+08	21260	20416.55	4
2012	35	3	3515608	1.1332906e+08	5550	20419.65	4
2012	35	3	3521903	2.990944e+08	14606	20477.5	4
2012	33	3	3304508	1.7829808e+08	8703	20486.97	4
2012	52	5	5200050	1.4685521e+08	7164	20499.05	4
2012	41	4	4110953	1.9195996e+08	9357	20515.12	4
2012	51	5	5107958	1.78929721e+09	87145	20532.41	4
2012	42	4	4211652	5.537816e+07	2697	20533.24	4
2012	25	2	2500601	3.7627033e+08	18324	20534.29	4
2012	42	4	4217402	3.3370139e+08	16248	20538	4
2012	42	4	4214904	9.175527e+07	4466	20545.29	4
2012	35	3	3516200	6.65029699e+09	323307	20569.6	4
2012	52	5	5212105	1.4716111e+08	7151	20579.1	4
2012	31	3	3142809	4.0910386e+08	19863	20596.28	4
2012	17	1	1715259	5.158353e+07	2504	20600.45	4
2012	42	4	4210803	1.4396766e+08	6988	20602.13	4
2012	13	1	1303536	5.9057242e+08	28652	20611.91	4
2012	42	4	4202800	6.1167739e+08	29672	20614.63	4
2012	11	1	1100072	1.7587246e+08	8530	20618.11	4
2012	31	3	3170750	1.2908364e+08	6259	20623.68	4
2012	41	4	4102208	8.047998e+07	3898	20646.48	4
2012	52	5	5212253	2.695102e+07	1305	20652.12	4
2012	41	4	4118857	1.1790576e+08	5708	20656.23	4
2012	41	4	4106852	6.44839e+07	3118	20681.17	4
2012	27	2	2704708	9.8360391e+08	47504	20705.71	4
2012	42	4	4201802	6.802185e+07	3281	20732.05	4
2012	43	4	4309555	9.025087e+07	4344	20775.98	4
2012	41	4	4119657	5.973791e+07	2874	20785.63	4
2012	32	3	3204559	7.2751637e+08	34992	20790.93	4
2012	35	3	3506508	2.30773219e+09	110907	20807.81	4
2012	41	4	4125803	2.1373922e+08	10272	20807.95	4
2012	43	4	4313706	7.0843763e+08	34016	20826.6	4
2012	41	4	4110508	2.9736792e+08	14278	20827	4
2012	41	4	4116059	2.183576e+08	10481	20833.66	4
2012	35	3	3531209	1.5164787e+08	7278	20836.47	4
2012	50	5	5007505	1.04577e+08	5015	20852.84	4
2012	35	3	3516903	2.2224298e+08	10646	20875.73	4
2012	31	3	3148103	1.75153172e+09	83882	20880.9	4
2012	43	4	4313953	2.0326803e+08	9732	20886.56	4
2012	35	3	3545159	1.5146355e+08	7250	20891.52	4
2012	41	4	4101051	5.962897e+07	2854	20893.12	4
2012	31	3	3133402	2.9125969e+08	13932	20905.81	4
2012	43	4	4321626	4.837748e+07	2309	20951.7	4
2012	52	5	5220058	3.435486e+07	1639	20960.87	4
2012	35	3	3555000	1.33155957e+09	63498	20970.1	4
2012	32	3	3201209	4.0298484e+09	192156	20971.75	4
2012	41	4	4115853	1.0734482e+08	5113	20994.49	4
2012	35	3	3525854	6.065483e+07	2889	20995.1	4
2012	51	5	5104906	1.6337958e+08	7781	20997.25	4
2012	31	3	3149200	7.371047e+07	3510	21000.13	4
2012	41	4	4126801	3.1145098e+08	14822	21012.75	4
2012	41	4	4121109	1.0479833e+08	4987	21014.3	4
2012	35	3	3515509	1.36931429e+09	65157	21015.61	4
2012	31	3	3108503	1.3550575e+08	6447	21018.42	4
2012	41	4	4101655	7.2925e+07	3469	21021.91	4
2012	35	3	3513207	1.6280486e+08	7741	21031.5	4
2012	31	3	3161700	1.3450046e+08	6390	21048.59	4
2012	43	4	4318499	4.569792e+07	2170	21058.95	4
2012	31	3	3106002	2.1139004e+08	10028	21079.98	4
2012	35	3	3537107	8.964232e+08	42516	21084.37	4
2012	42	4	4216701	2.8864634e+08	13685	21092.17	4
2012	35	3	3536000	2.2798104e+08	10805	21099.59	4
2012	35	3	3510500	2.19999905e+09	104150	21123.37	4
2012	29	2	2921005	8.7762504e+08	41527	21133.84	4
2012	43	4	4315149	5.385762e+07	2547	21145.51	4
2012	35	3	3537156	6.244192e+07	2952	21152.41	4
2012	31	3	3134202	2.08144018e+09	98392	21154.57	4
2012	41	4	4111605	6.43737e+07	3043	21154.68	4
2012	31	3	3158300	1.5219206e+08	7188	21173.07	4
2012	43	4	4300554	3.822716e+07	1805	21178.48	4
2012	41	4	4128104	2.16536994e+09	102184	21190.89	5
2012	43	4	4319505	4.7197387e+08	22270	21193.26	5
2012	11	1	1100056	3.57333e+08	16852	21204.19	5
2012	35	3	3534500	5.376317e+07	2535	21208.35	5
2012	43	4	4322855	4.11404e+07	1939	21217.33	5
2012	35	3	3522307	3.12411996e+09	147219	21220.9	5
2012	41	4	4121604	1.4413793e+08	6790	21227.97	5
2012	27	2	2708600	1.19572214e+09	56319	21231.24	5
2012	50	5	5004403	1.6223668e+08	7639	21237.95	5
2012	43	4	4301503	1.4847878e+08	6990	21241.6	5
2012	35	3	3533205	6.843071e+07	3220	21251.77	5
2012	51	5	5107859	2.2965162e+08	10804	21256.17	5
2012	35	3	3510104	5.691893e+07	2677	21262.21	5
2012	52	5	5221809	6.534268e+07	3070	21284.26	5
2012	35	3	3530508	1.41414206e+09	66399	21297.64	5
2012	43	4	4305850	5.159181e+07	2422	21301.33	5
2012	31	3	3169901	2.2161835e+09	104004	21308.64	5
2012	41	4	4122008	3.0382732e+08	14255	21313.74	5
2012	31	3	3111804	2.4462089e+08	11476	21315.87	5
2012	41	4	4115309	1.3444403e+08	6306	21320.02	5
2012	51	5	5107008	3.6755356e+08	17232	21329.71	5
2012	43	4	4316436	6.016492e+07	2820	21335.08	5
2012	41	4	4122602	1.9335955e+08	9060	21342.11	5
2012	35	3	3547502	5.665805e+08	26530	21356.22	5
2012	41	4	4106407	1.00294693e+09	46939	21367.03	5
2012	28	2	2800308	1.257017857e+10	587701	21388.73	5
2012	35	3	3514106	5.3700401e+08	25100	21394.58	5
2012	17	1	1722107	2.4528693e+08	11458	21407.48	5
2012	35	3	3535507	9.1410442e+08	42680	21417.63	5
2012	41	4	4117404	7.238313e+07	3378	21427.81	5
2012	52	5	5217104	5.1419515e+08	23987	21436.41	5
2012	24	2	2408003	5.72130207e+09	266758	21447.54	5
2012	52	5	5209150	1.0934995e+08	5091	21479.07	5
2012	35	3	3547007	1.1872226e+08	5525	21488.19	5
2012	50	5	5004502	4.6077606e+08	21442	21489.42	5
2012	52	5	5215900	7.647325e+07	3557	21499.37	5
2012	35	3	3512704	8.359727e+07	3887	21506.89	5
2012	43	4	4307815	7.785145e+07	3619	21511.87	5
2012	50	5	5002159	1.7062177e+08	7928	21521.41	5
2012	35	3	3539202	5.3997973e+08	25086	21525.14	5
2012	41	4	4120333	7.48815e+07	3477	21536.24	5
2012	31	3	3171204	2.34277013e+09	108771	21538.55	5
2012	41	4	4108403	1.74033281e+09	80727	21558.25	5
2012	43	4	4309258	3.397594e+07	1576	21558.34	5
2012	15	1	1500602	2.2065758e+09	102343	21560.59	5
2012	43	4	4316758	1.2576146e+08	5832	21564.04	5
2012	35	3	3534708	2.25233035e+09	104420	21569.91	5
2012	52	5	5203302	5.4737122e+08	25361	21583.19	5
2012	41	4	4114203	7.0972423e+08	32849	21605.66	5
2012	22	2	2204501	2.2205696e+08	10268	21626.12	5
2012	35	3	3528700	1.0775684e+08	4981	21633.58	5
2012	42	4	4200606	1.2309407e+08	5685	21652.43	5
2012	43	4	4310603	8.2101761e+08	37916	21653.59	5
2012	43	4	4305306	2.0205774e+08	9322	21675.36	5
2012	52	5	5214507	5.4369714e+08	25061	21694.95	5
2012	43	4	4310900	7.829627e+07	3607	21706.76	5
2012	35	3	3510153	9.778549e+07	4504	21710.81	5
2012	43	4	4323804	2.8439253e+08	13074	21752.53	5
2012	41	4	4113205	9.8635405e+08	45334	21757.49	5
2012	35	3	3515152	3.6118794e+08	16580	21784.56	5
2012	35	3	3525003	2.41487686e+09	110842	21786.66	5
2012	43	4	4308904	3.5098633e+08	16101	21799.04	5
2012	33	3	3304144	3.06037967e+09	140374	21801.61	5
2012	33	3	3305505	1.69017903e+09	77522	21802.57	5
2012	35	3	3532603	2.3563271e+08	10806	21805.73	5
2012	31	3	3144508	1.7585501e+08	8062	21812.83	5
2012	21	2	2111300	2.267784107e+10	1039610	21813.8	5
2012	52	5	5200134	4.4901278e+08	20578	21820.04	5
2012	43	4	4321808	5.1664447e+08	23665	21831.59	5
2012	41	4	4108908	1.3647325e+08	6243	21860.2	5
2012	42	4	4214300	6.044518e+07	2765	21860.82	5
2012	35	3	3529401	9.29535985e+09	425169	21862.74	5
2012	52	5	5204409	3.7345276e+08	17072	21875.16	5
2012	41	4	4103354	1.2408041e+08	5667	21895.25	5
2012	31	3	3170503	2.2513032e+08	10279	21901.97	5
2012	43	4	4317905	3.1333229e+08	14301	21909.82	5
2012	31	3	3109808	5.559789e+07	2536	21923.46	5
2012	42	4	4216008	2.2882235e+08	10431	21936.76	5
2012	35	3	3524105	8.5708153e+08	39062	21941.57	5
2012	29	2	2926202	4.814994e+08	21941	21945.19	5
2012	52	5	5204508	1.61644211e+09	73616	21957.76	5
2012	42	4	4202453	3.3235274e+08	15136	21957.77	5
2012	50	5	5000906	1.8291627e+08	8329	21961.37	5
2012	41	4	4122909	1.1250384e+08	5122	21964.83	5
2012	35	3	3500105	7.4368394e+08	33843	21974.53	5
2012	41	4	4123501	5.2443642e+08	23855	21984.34	5
2012	35	3	3529658	4.136308e+07	1880	22001.64	5
2012	35	3	3513306	4.893177e+07	2224	22001.7	5
2012	43	4	4309407	5.1119299e+08	23230	22005.73	5
2012	41	4	4124301	5.176123e+07	2351	22016.69	5
2012	35	3	3527900	5.916715e+07	2687	22019.78	5
2012	35	3	3556107	2.5112678e+08	11404	22020.94	5
2012	43	4	4309506	1.7590448e+08	7983	22034.88	5
2012	42	4	4204194	6.154669e+07	2793	22036.05	5
2012	51	5	5107198	4.921436e+07	2233	22039.57	5
2012	31	3	3150307	1.0261929e+08	4656	22040.23	5
2012	42	4	4208302	1.0763102e+09	48807	22052.37	5
2012	52	5	5215306	3.2003343e+08	14487	22091.08	5
2012	43	4	4317558	4.703517e+07	2129	22092.61	5
2012	35	3	3550902	3.1931339e+08	14448	22100.87	5
2012	43	4	4318481	9.301544e+07	4201	22141.26	5
2012	51	5	5108303	8.18372e+07	3695	22148.09	5
2012	41	4	4127403	3.7307781e+08	16829	22168.74	5
2012	42	4	4204806	8.4249044e+08	38003	22169.05	5
2012	28	2	2802106	1.44652512e+09	65226	22177.12	5
2012	41	4	4114807	7.1972145e+08	32451	22178.71	5
2012	43	4	4308706	1.2826203e+08	5783	22179.15	5
2012	35	3	3542602	1.20747199e+09	54338	22221.5	5
2012	43	4	4306734	1.1472096e+08	5160	22232.74	5
2012	41	4	4102703	6.065503e+07	2728	22234.25	5
2012	52	5	5219308	8.1763708e+08	36760	22242.58	5
2012	51	5	5105002	2.2382509e+08	10062	22244.59	5
2012	35	3	3550100	8.5921763e+08	38614	22251.45	5
2012	43	4	4306767	7.8914429e+08	35412	22284.66	5
2012	41	4	4120853	8.540027e+07	3827	22315.2	5
2012	16	1	1600154	2.6337522e+08	11794	22331.29	5
2012	43	4	4316956	1.3579422e+08	6078	22341.92	5
2012	31	3	3137601	1.22359222e+09	54732	22356.07	5
2012	31	3	3171006	4.4367482e+08	19844	22358.13	5
2012	43	4	4300851	8.186416e+07	3660	22367.26	5
2012	42	4	4207007	1.35090578e+09	60374	22375.62	5
2012	42	4	4210100	1.19412572e+09	53361	22378.25	5
2012	43	4	4309001	3.7656486e+08	16823	22383.93	5
2012	42	4	4215455	2.4056518e+08	10744	22390.65	5
2012	43	4	4322509	1.3876752e+09	61947	22401.01	5
2012	35	3	3550605	1.80733805e+09	80661	22406.59	5
2012	42	4	4215109	2.465855e+08	11004	22408.72	5
2012	42	4	4202305	1.33868272e+09	59736	22409.98	5
2012	35	3	3557006	2.48229349e+09	110755	22412.47	5
2012	41	4	4104204	2.58993421e+09	115336	22455.56	5
2012	35	3	3518206	6.9323141e+08	30862	22462.3	5
2012	35	3	3526704	2.09879949e+09	93417	22467	5
2012	24	2	2401206	2.9586494e+08	13166	22471.89	5
2012	35	3	3508306	9.719089e+07	4322	22487.48	5
2012	43	4	4300208	1.6163615e+08	7187	22490.07	5
2012	35	3	3507902	4.9449078e+08	21987	22490.14	5
2012	32	3	3201506	2.54340561e+09	113054	22497.26	5
2012	42	4	4204004	2.192799e+08	9746	22499.48	5
2012	31	3	3147105	1.93355882e+09	85908	22507.32	5
2012	35	3	3517802	1.8843531e+08	8366	22523.94	5
2012	31	3	3109451	1.4719291e+08	6534	22527.23	5
2012	42	4	4219606	9.248674e+07	4103	22541.25	5
2012	41	4	4124020	2.315731e+08	10269	22550.7	5
2012	35	3	3555703	3.690167e+07	1636	22556.03	5
2012	29	2	2924009	2.485527e+09	110193	22556.12	5
2012	41	4	4104006	8.8960505e+08	39404	22576.52	5
2012	11	1	1100304	1.79797568e+09	79616	22583.09	5
2012	43	4	4301800	1.2025783e+08	5322	22596.36	5
2012	31	3	3130101	8.2175495e+08	36363	22598.66	5
2012	31	3	3101607	1.69425834e+09	74804	22649.3	5
2012	41	4	4117222	1.7445615e+08	7702	22650.76	5
2012	35	3	3557105	1.94965646e+09	86059	22654.88	5
2012	31	3	3132008	1.1463889e+08	5053	22687.29	5
2012	31	3	3136702	1.191616285e+10	525225	22687.73	5
2012	33	3	3300407	4.0606009e+09	178880	22700.14	5
2012	52	5	5216007	6.06229e+07	2668	22722.22	5
2012	28	2	2803203	7.0825802e+08	31165	22726.07	5
2012	21	2	2104305	2.4459082e+08	10762	22727.26	5
2012	41	4	4101853	5.430823e+07	2389	22732.62	5
2012	31	3	3157203	6.4690634e+08	28435	22750.35	5
2012	42	4	4219705	5.950034e+08	26145	22757.83	5
2012	52	5	5203500	4.8733854e+08	21402	22770.7	5
2012	35	3	3546801	1.17306204e+09	51467	22792.51	5
2012	52	5	5219712	1.0211677e+08	4480	22793.92	5
2012	32	3	3203353	2.5747296e+08	11286	22813.48	5
2012	25	2	2509305	1.7434128e+08	7641	22816.55	5
2012	35	3	3540606	1.12962253e+09	49404	22865	5
2012	42	4	4208500	5.184254e+08	22667	22871.37	5
2012	35	3	3544400	6.38983e+07	2789	22910.83	5
2012	35	3	3544905	2.4650323e+08	10756	22917.74	5
2012	41	4	4110052	5.114913e+07	2231	22926.55	5
2012	43	4	4308508	6.6850716e+08	29158	22927.06	5
2012	24	2	2404309	2.8585578e+08	12465	22932.67	5
2012	41	4	4107207	8.442369e+08	36813	22933.12	5
2012	43	4	4316600	3.547459e+08	15468	22934.18	5
2012	43	4	4307609	1.00238836e+09	43698	22939	5
2012	24	2	2402501	2.2949775e+08	10000	22949.78	5
2012	29	2	2930774	5.0754015e+08	22109	22956.27	5
2012	51	5	5103700	2.6542037e+08	11562	22956.27	5
2012	42	4	4215356	9.015351e+07	3926	22963.2	5
2012	31	3	3103900	1.8683377e+08	8135	22966.66	5
2012	43	4	4312351	3.493917e+07	1521	22971.19	5
2012	35	3	3530300	1.25467218e+09	54618	22971.77	5
2012	41	4	4105508	1.65088043e+09	71855	22975.16	5
2012	35	3	3511300	1.8765349e+08	8165	22982.67	5
2012	35	3	3511003	4.243755e+08	18465	22982.7	5
2012	42	4	4203808	1.2170874e+09	52937	22991.24	5
2012	42	4	4202875	6.392601e+07	2778	23011.52	5
2012	32	3	3205200	9.78408083e+09	424948	23024.18	5
2012	31	3	3137304	9.653434e+07	4191	23033.73	5
2012	42	4	4209508	1.4187524e+08	6147	23080.4	5
2012	50	5	5005707	1.10675481e+09	47899	23106.01	5
2012	52	5	5213806	9.7359404e+08	42135	23106.54	5
2012	33	3	3305802	3.87468457e+09	167622	23115.61	5
2012	51	5	5106182	1.3078885e+08	5648	23156.67	5
2012	41	4	4115606	3.7873558e+08	16340	23178.43	5
2012	21	2	2104057	8.7598871e+08	37784	23184.12	5
2012	43	4	4308102	2.9025838e+08	12517	23189.13	5
2012	41	4	4122305	7.342571e+08	31662	23190.48	5
2012	33	3	3304300	1.31026187e+09	56436	23216.77	5
2012	42	4	4214706	2.4354165e+08	10488	23220.98	5
2012	51	5	5106307	4.6185346e+08	19887	23223.89	5
2012	43	4	4313359	7.874777e+07	3390	23229.43	5
2012	43	4	4305603	8.072362e+07	3472	23249.89	5
2012	31	3	3171105	8.314884e+07	3575	23258.42	5
2012	35	3	3504008	2.24202745e+09	96336	23273	5
2012	41	4	4115903	5.357781e+07	2301	23284.58	5
2012	42	4	4212304	1.5865011e+08	6808	23303.48	5
2012	43	4	4303806	1.2764745e+08	5476	23310.35	5
2012	35	3	3520103	6.5889734e+08	28259	23316.37	5
2012	50	5	5003207	2.44651027e+09	104912	23319.64	5
2012	42	4	4201703	1.7462347e+08	7485	23329.79	5
2012	43	4	4316733	3.841845e+07	1646	23340.49	5
2012	50	5	5005152	1.4098077e+08	6039	23345.05	5
2012	35	3	3531407	5.1952186e+08	22250	23349.3	5
2012	52	5	5201454	5.678726e+07	2431	23359.63	5
2012	35	3	3511409	4.1816001e+08	17893	23370.03	5
2012	43	4	4313037	1.1163123e+08	4771	23397.87	5
2012	35	3	3548054	1.8118803e+08	7732	23433.53	5
2012	31	3	3132602	9.665946e+07	4123	23443.96	5
2012	42	4	4211256	6.766717e+07	2886	23446.7	5
2012	42	4	4214003	3.5820854e+08	15273	23453.71	5
2012	24	2	2404101	5.358023e+07	2284	23458.95	5
2012	43	4	4311718	1.1053798e+08	4694	23548.78	5
2012	31	3	3141306	8.257411e+07	3506	23552.23	5
2012	43	4	4305871	5.796715e+07	2460	23563.88	5
2012	31	3	3169307	1.74295831e+09	73894	23587.28	5
2012	35	3	3505906	1.35126117e+09	57286	23587.98	5
2012	35	3	3552304	1.7599813e+08	7446	23636.6	5
2012	35	3	3521408	4.8941353e+08	20705	23637.46	5
2012	52	5	5207352	8.801492e+07	3723	23640.86	5
2012	42	4	4208104	4.8472328e+08	20485	23662.35	5
2012	41	4	4101705	3.1887304e+08	13471	23671.07	5
2012	17	1	1700707	1.977748e+08	8354	23674.26	5
2012	31	3	3133105	3.4085651e+08	14366	23726.61	5
2012	43	4	4309902	1.7025057e+08	7173	23734.92	5
2012	43	4	4301651	1.3752743e+08	5793	23740.28	5
2012	42	4	4200051	6.260528e+07	2635	23759.12	5
2012	35	3	3555604	2.2661542e+08	9537	23761.71	5
2012	33	3	3300951	1.9536979e+08	8219	23770.51	5
2012	50	5	5002704	1.91581674e+10	805397	23787.23	5
2012	51	5	5104807	6.1684823e+08	25927	23791.73	5
2012	43	4	4321469	6.585385e+07	2767	23799.73	5
2012	42	4	4212205	4.3141325e+08	18096	23840.25	5
2012	41	4	4127957	1.9070477e+08	7994	23855.99	5
2012	51	5	5100201	5.1954185e+08	21778	23856.27	5
2012	42	4	4210035	1.3372633e+08	5605	23858.4	5
2012	42	4	4200804	1.4728181e+08	6172	23862.9	5
2012	24	2	2409902	3.2810956e+08	13739	23881.62	5
2012	43	4	4309803	1.1207088e+08	4692	23885.52	5
2012	21	2	2101400	2.08318401e+09	87057	23928.97	5
2012	41	4	4106308	3.9234364e+08	16389	23939.45	5
2012	31	3	3108206	1.3843658e+08	5778	23959.26	5
2012	35	3	3552551	8.324827e+07	3473	23970.13	5
2012	43	4	4315354	8.793303e+07	3664	23999.19	5
2012	42	4	4205506	8.3521682e+08	34796	24003.24	5
2012	35	3	3500907	9.263329e+07	3859	24004.48	5
2012	35	3	3545803	4.36315999e+09	181509	24038.26	5
2012	35	3	3525300	3.21907635e+09	133900	24040.9	5
2012	41	4	4117701	7.7726905e+08	32326	24044.7	5
2012	50	5	5002001	2.6420819e+08	10983	24056.1	5
2012	43	4	4300034	1.0745839e+08	4465	24066.83	5
2012	43	4	4319000	4.8806288e+08	20276	24070.96	5
2012	42	4	4210605	3.6098819e+08	14993	24077.12	5
2012	31	3	3154408	1.1401077e+08	4735	24078.3	5
2012	17	1	1711902	2.6099786e+08	10821	24119.57	5
2012	43	4	4300802	3.1011647e+08	12821	24188.17	5
2012	41	4	4118709	1.6861308e+08	6966	24205.15	5
2012	35	3	3549409	1.14444129e+09	47256	24217.9	5
2012	35	3	3515004	5.94047023e+09	245148	24232.18	5
2012	32	3	3202207	4.273247e+08	17632	24235.75	5
2012	35	3	3534609	7.5406536e+08	31109	24239.46	5
2012	31	3	3131604	1.5887868e+08	6553	24245.18	5
2012	41	4	4112801	2.6433686e+08	10899	24253.31	5
2012	52	5	5218508	1.07324068e+09	44233	24263.35	5
2012	50	5	5007901	1.09068364e+09	44949	24264.91	5
2012	41	4	4124608	1.5609183e+08	6422	24305.8	5
2012	17	1	1713205	4.8944681e+08	20117	24330.01	5
2012	43	4	4307054	7.518644e+07	3090	24332.18	5
2012	51	5	5107305	4.3317352e+08	17786	24354.75	5
2012	41	4	4116703	2.8250916e+08	11598	24358.44	5
2012	41	4	4115804	1.03431682e+09	42420	24382.76	5
2012	43	4	4303673	7.953291e+07	3259	24404.08	5
2012	41	4	4106704	1.1067428e+08	4534	24409.85	5
2012	35	3	3513108	7.8589834e+08	32187	24416.64	5
2012	31	3	3119302	6.7373645e+08	27562	24444.4	5
2012	42	4	4202537	6.353159e+07	2599	24444.63	5
2012	43	4	4318705	5.3235345e+09	217189	24511.07	5
2012	43	4	4314134	5.407337e+07	2206	24511.96	5
2012	31	3	3109303	5.6604793e+08	23091	24513.79	5
2012	42	4	4215703	4.9894719e+08	20332	2.454e+04	5
2012	31	3	3116902	7.342499e+07	2992	24540.44	5
2012	43	4	4323358	5.246236e+07	2134	24584.05	5
2012	35	3	3546603	7.2902751e+08	29651	24586.94	5
2012	52	5	5214606	1.05589108e+09	42933	24593.93	5
2012	42	4	4215406	1.0731788e+08	4361	24608.55	5
2012	35	3	3542107	2.1297295e+08	8651	24618.3	5
2012	50	5	5001904	5.0246653e+08	20389	24644	5
2012	41	4	4104808	7.21298857e+09	292372	24670.59	5
2012	31	3	3132404	2.26272073e+09	91643	24690.6	5
2012	52	5	5203906	2.2490119e+08	9105	24700.84	5
2012	31	3	3138625	1.7290133e+08	6999	24703.72	5
2012	43	4	4304705	1.47263747e+09	59569	24721.54	5
2012	51	5	5101704	8.027892e+08	32464	24728.6	5
2012	35	3	3556305	5.7378023e+08	23181	24752.18	5
2012	33	3	3304755	1.02444096e+09	41386	24753.32	5
2012	50	5	5007976	8.732128e+07	3522	24793.09	5
2012	50	5	5000252	1.1665213e+08	4704	24798.5	5
2012	35	3	3505203	7.961094e+08	32102	24799.37	5
2012	31	3	3149309	1.48029523e+09	59670	24808.03	5
2012	42	4	4204509	3.5149e+08	14155	24831.51	5
2012	52	5	5220603	4.7937253e+08	19293	24846.97	5
2012	33	3	3301702	2.154890479e+10	867067	24852.64	5
2012	35	3	3536406	1.6181865e+08	6496	24910.51	5
2012	43	4	4320107	5.4240403e+08	21757	24930.09	5
2012	35	3	3525607	1.0463662e+08	4197	24931.29	5
2012	23	2	2307650	5.32123603e+09	213404	24935.03	5
2012	41	4	4107801	1.2531289e+08	5015	24987.62	5
2012	43	4	4315321	6.782319e+07	2713	24999.33	5
2012	35	3	3532868	2.866346e+07	1146	25011.75	5
2012	42	4	4203907	5.268812e+08	21064	25013.35	5
2012	41	4	4107553	8.504573e+07	3398	25028.17	5
2012	31	3	3133808	2.17245721e+09	86762	25039.27	5
2012	42	4	4216107	2.3530523e+08	9389	25061.8	5
2012	31	3	3141108	8.6793147e+08	34624	25067.34	5
2012	35	3	3549102	2.12141352e+09	84584	25080.55	5
2012	31	3	3159803	4.6179393e+08	18406	25089.31	5
2012	41	4	4128005	5.3738499e+08	21402	25109.1	5
2012	31	3	3166808	2.6996966e+08	10725	25172	5
2012	35	3	3502002	1.1080312e+08	4401	25176.81	5
2012	41	4	4104907	1.70312283e+09	67613	25189.28	5
2012	52	5	5209937	1.4534997e+08	5769	25195	5
2012	41	4	4104055	1.0834429e+08	4299	25202.21	5
2012	51	5	5106232	4.5421361e+08	18018	25208.88	5
2012	35	3	3548005	5.3021084e+08	21032	25209.72	5
2012	42	4	4201653	5.683087e+07	2254	25213.34	5
2012	42	4	4207106	3.1845428e+08	12624	25226.1	5
2012	35	3	3541703	3.2726038e+08	12972	25228.21	5
2012	43	4	4305702	1.6563095e+08	6562	25240.92	5
2012	41	4	4121356	7.086738e+07	2807	25246.66	5
2012	35	3	3542404	4.7265616e+08	18720	25248.73	5
2012	43	4	4311304	6.9364584e+08	27466	25254.71	5
2012	42	4	4217808	4.3986325e+08	17412	25262.07	5
2012	51	5	5107909	3.00336842e+09	118833	25273.86	5
2012	43	4	4314308	9.968655e+07	3941	25294.73	5
2012	31	3	3103801	7.032756e+07	2780	25297.68	5
2012	43	4	4307559	1.5145738e+08	5979	25331.56	5
2012	41	4	4114005	3.4924724e+08	13781	25342.66	5
2012	26	2	2603603	2.0829831e+08	8204	25389.85	5
2012	31	3	3118205	1.6749307e+08	6591	25412.39	5
2012	42	4	4207700	1.8471273e+08	7268	25414.52	5
2012	43	4	4312757	8.255893e+07	3247	25426.22	5
2012	42	4	4218707	2.50255029e+09	98412	25429.32	5
2012	32	3	3204203	4.7309122e+08	18597	25439.11	5
2012	31	3	3103504	2.82545566e+09	110983	25458.45	5
2012	35	3	3540804	4.0037044e+08	15720	25468.86	5
2012	41	4	4101101	5.2087935e+08	20451	25469.63	5
2012	31	3	3165537	6.9080114e+08	27104	25487.05	5
2012	43	4	4311205	4.9612317e+08	19453	25503.68	5
2012	31	3	3151206	1.37307453e+09	53832	25506.66	5
2012	50	5	5007109	5.5069327e+08	21584	25513.96	5
2012	43	4	4320503	1.5611959e+08	6118	25518.08	5
2012	28	2	2807204	2.0879713e+08	8169	25559.69	5
2012	35	3	3552809	6.43486934e+09	251608	25574.98	5
2012	43	4	4322202	5.7551324e+08	22483	25597.71	5
2012	42	4	4204251	3.936894e+08	15376	25604.15	5
2012	42	4	4203501	2.362136e+08	9222	25614.14	5
2012	35	3	3532157	7.110974e+07	2774	25634.37	5
2012	42	4	4204608	5.01631145e+09	195614	25643.93	5
2012	52	5	5211701	1.574172e+08	6138	25646.33	5
2012	31	3	3170404	2.01984409e+09	78703	25664.13	5
2012	52	5	5213707	2.0513479e+08	7987	25683.58	5
2012	43	4	4308078	9.837215e+07	3828	25698.05	5
2012	43	4	4314001	1.7831482e+08	6932	25723.43	5
2012	31	3	3152808	6.7254597e+08	26139	25729.6	5
2012	42	4	4202701	1.1796306e+08	4584	25733.65	5
2012	50	5	5005103	1.0314656e+08	4005	25754.45	5
2012	43	4	4319901	1.95653196e+09	75861	25791.01	5
2012	41	4	4104303	2.27525096e+09	88209	25793.86	5
2012	35	3	3526407	6.638333e+08	25721	25809	5
2012	41	4	4113908	3.3656878e+08	13030	25830.3	5
2012	43	4	4316451	3.0840709e+08	11933	25844.89	5
2012	43	4	4317756	5.135445e+07	1985	25871.26	5
2012	43	4	4320305	1.2782892e+08	4940	25876.3	5
2012	43	4	4301875	1.0442339e+08	4032	25898.66	5
2012	29	2	2910602	8.7185963e+08	33618	25934.31	5
2012	42	4	4211504	3.2547788e+08	12544	25946.9	5
2012	43	4	4307500	3.9566831e+08	15241	25960.78	5
2012	43	4	4306809	5.4027993e+08	20810	25962.51	5
2012	42	4	4209300	4.08371988e+09	156604	26076.73	5
2012	35	3	3506102	1.95831389e+09	75069	26086.85	5
2012	41	4	4125704	6.7783209e+08	25971	26099.58	5
2012	35	3	3506359	1.31317879e+09	50304	26104.86	5
2012	35	3	3515186	1.09992332e+09	42123	26112.18	5
2012	35	3	3539103	4.2424868e+08	16238	26126.9	5
2012	35	3	3514304	2.2505286e+08	8610	26138.54	5
2012	41	4	4114609	1.24697036e+09	47697	26143.58	5
2012	43	4	4318606	1.8017166e+08	6882	26180.13	5
2012	42	4	4209854	1.2109189e+08	4622	26199.02	5
2012	35	3	3525706	8.7448523e+08	33375	26201.8	5
2012	42	4	4205605	9.049256e+07	3452	26214.53	5
2012	50	5	5006200	1.23616481e+09	47126	26231.06	5
2012	35	3	3557154	6.280691e+07	2394	26235.13	5
2012	35	3	3549706	1.37034449e+09	52176	26263.89	5
2012	35	3	3529005	5.77006697e+09	219664	26267.7	5
2012	31	3	3119955	1.5457656e+08	5883	26275.13	5
2012	52	5	5219209	8.133248e+07	3093	26295.66	5
2012	43	4	4314803	8.3953777e+08	31866	26345.88	5
2012	41	4	4103701	2.58316725e+09	98024	26352.4	5
2012	42	4	4213351	8.740541e+07	3316	26358.69	5
2012	26	2	2605459	7.167168e+07	2718	26369.27	5
2012	52	5	5206404	4.2031489e+08	15925	26393.4	5
2012	43	4	4316477	7.05165e+07	2670	26410.67	5
2012	41	4	4112009	8.6896946e+08	32882	26426.9	5
2012	41	4	4120655	1.2655583e+08	4784	26453.98	5
2012	42	4	4203006	1.90668884e+09	71886	26523.79	5
2012	35	3	3520806	9.755552e+07	3678	26524.07	5
2012	31	3	3168705	2.19424964e+09	82718	26526.87	5
2012	35	3	3514908	4.2668438e+08	16060	26568.14	5
2012	17	1	1703867	1.0287436e+08	3872	26568.79	5
2012	31	3	3129509	6.2562298e+08	23547	26569.12	5
2012	31	3	3104205	9.8900385e+08	37188	26594.7	5
2012	52	5	5220264	1.0107131e+08	3799	26604.71	5
2012	51	5	5106216	3.2516198e+08	12220	26609	5
2012	42	4	4217303	2.4275452e+08	9121	26614.9	5
2012	41	4	4112959	2.0147404e+08	7567	26625.35	5
2012	35	3	3541406	5.60542808e+09	210393	26642.65	5
2012	41	4	4114906	2.3546167e+08	8832	26660.06	5
2012	42	4	4219002	5.4299299e+08	20356	26674.84	5
2012	43	4	4321006	2.784164e+08	10431	26691.25	5
2012	41	4	4126355	1.213106e+08	4543	26702.75	5
2012	31	3	3136207	1.99355666e+09	74655	26703.59	5
2012	51	5	5101407	5.1667377e+08	19344	26709.77	5
2012	42	4	4212007	2.0583245e+08	7699	26734.96	5
2012	52	5	5222302	1.4034785e+08	5244	26763.51	5
2012	29	2	2919207	4.57816809e+09	171042	26766.34	5
2012	41	4	4127700	3.28042857e+09	122502	26778.57	5
2012	42	4	4207577	7.417693e+07	2768	26798.02	5
2012	35	3	3539301	1.90323725e+09	70869	26855.71	5
2012	35	3	3507506	3.49893959e+09	130201	26873.37	5
2012	42	4	4213005	8.576168e+07	3190	26884.54	5
2012	42	4	4218608	1.7929499e+08	6668	26888.87	5
2012	43	4	4302154	5.657394e+07	2103	26901.54	5
2012	42	4	4216909	5.9378244e+08	22062	26914.26	5
2012	43	4	4302352	3.273118e+08	12136	26970.32	5
2012	43	4	4313201	5.2266841e+08	19371	26982	5
2012	42	4	4211900	3.84697802e+09	142558	26985.35	5
2012	29	2	2909307	8.4851683e+08	31397	27025.41	5
2012	11	1	1100205	1.197087673e+10	442701	27040.55	5
2012	35	3	3540705	1.40629473e+09	51999	27044.65	5
2012	42	4	4204301	1.88317035e+09	69462	27110.8	5
2012	42	4	4212239	1.0772855e+08	3972	27121.99	5
2012	22	2	2208908	1.9029535e+08	7015	27126.92	5
2012	35	3	3545308	1.10947548e+09	40897	27128.53	5
2012	26	2	2607752	6.6057457e+08	24321	27160.67	5
2012	43	4	4315313	4.834234e+07	1779	27173.88	5
2012	41	4	4107538	1.0925744e+08	4017	27198.76	5
2012	35	3	3505500	3.08388997e+09	113338	27209.67	5
2012	50	5	5003702	5.46872301e+09	200729	27244.31	5
2012	43	4	4313409	6.5216437e+09	239355	27246.74	5
2012	35	3	3554003	2.98768093e+09	109425	27303.46	5
2012	43	4	4312153	1.0826203e+08	3964	27311.31	5
2012	51	5	5107602	5.52630108e+09	202309	27316.14	5
2012	35	3	3509007	2.42725545e+09	88841	27321.34	5
2012	51	5	5107354	1.4458924e+08	5291	27327.39	5
2012	35	3	3547601	6.6227121e+08	24229	27333.82	5
2012	52	5	5204003	2.0354043e+08	7444	27342.88	5
2012	35	3	3532900	2.6269717e+08	9601	27361.44	5
2012	11	1	1100924	2.3895541e+08	8721	2.74e+04	5
2012	41	4	4122404	1.62060278e+09	59139	27403.28	5
2012	51	5	5108105	9.466436e+07	3454	27407.17	5
2012	35	3	3516101	7.638857e+07	2785	27428.57	5
2012	51	5	5105234	1.5231839e+08	5550	27444.76	5
2012	35	3	3534757	2.4022352e+08	8725	27532.78	5
2012	42	4	4204558	3.9829061e+08	14447	27569.09	5
2012	35	3	3502200	6.2470651e+08	22650	27580.86	5
2012	43	4	4311791	7.022132e+07	2546	27581.04	5
2012	26	2	2611606	4.28906057e+10	1555039	27581.69	5
2012	42	4	4208005	1.7590521e+08	6375	27592.97	5
2012	35	3	3507605	4.14041361e+09	150023	27598.53	5
2012	42	4	4211207	4.5180922e+08	16364	27609.95	5
2012	35	3	3533908	1.39815518e+09	50630	27615.15	5
2012	35	3	3511102	3.14865889e+09	113873	27650.62	5
2012	41	4	4113734	2.013581e+08	7282	27651.48	5
2012	43	4	4305355	1.00072583e+09	36130	27697.92	5
2012	41	4	4126504	4.358655e+08	15713	27739.16	5
2012	51	5	5104542	1.5428213e+08	5558	27758.57	5
2012	35	3	3531308	1.3081737e+09	47100	27774.39	5
2012	43	4	4320909	5.5613506e+08	20017	27783.14	5
2012	35	3	3506003	9.69313305e+09	348146	27842.15	5
2012	35	3	3524303	2.01406782e+09	72305	27855.17	5
2012	35	3	3508108	4.371687e+08	15655	27925.18	5
2012	32	3	3203056	7.1135793e+08	25454	27946.8	5
2012	43	4	4311270	4.454771e+07	1594	27947.12	5
2012	52	5	5213103	1.53890502e+09	55036	27961.79	5
2012	31	3	3121258	2.3926542e+08	8546	27997.36	5
2012	42	4	4210902	1.1381038e+08	4063	28011.42	5
2012	52	5	5208707	3.746563313e+10	1333767	28090.09	5
2012	35	3	3546405	1.24670738e+09	44375	28094.81	5
2012	35	3	3530607	1.114672954e+10	396468	28115.08	5
2012	43	4	4312138	6.962603e+07	2473	28154.48	5
2012	41	4	4112108	5.7335616e+08	20359	28162.29	5
2012	42	4	4205902	1.68218484e+09	59728	28164.09	5
2012	35	3	3519105	2.8944986e+08	10275	28170.3	5
2012	41	4	4119905	8.94780007e+09	317339	28196.35	5
2012	31	3	3117306	6.7520779e+08	23932	28213.6	5
2012	43	4	4300471	5.760542e+07	2041	28224.11	5
2012	41	4	4110003	1.1405329e+08	4040	28231.01	5
2012	42	4	4218806	3.3885406e+08	12001	28235.49	5
2012	41	4	4127106	2.01424017e+09	71176	28299.43	5
2012	41	4	4113601	1.2616907e+08	4452	28339.86	5
2012	35	3	3504305	1.423919e+08	5014	28398.86	5
2012	52	5	5201504	1.0962092e+08	3860	28399.2	5
2012	51	5	5104559	1.2477522e+08	4393	28403.19	5
2012	35	3	3505807	5.8016405e+08	20424	28406	5
2012	35	3	3525201	7.0694844e+08	24875	28420.04	5
2012	51	5	5103403	1.595671471e+10	561329	28426.67	5
2012	35	3	3535705	1.6972276e+08	5969	28434.04	5
2012	41	4	4103008	1.2736617e+08	4479	28436.3	5
2012	51	5	5106372	4.5889414e+08	16079	28539.97	5
2012	42	4	4208401	4.4645993e+08	15623	28577.09	5
2012	27	2	2708105	3.0880873e+08	10792	28614.6	5
2012	41	4	4113700	1.476904972e+10	515707	28638.45	5
2012	52	5	5215702	6.9290654e+08	24171	28666.85	5
2012	35	3	3556453	1.27772093e+09	44555	28677.39	5
2012	29	2	2930709	3.48465206e+09	121416	28700.11	5
2012	50	5	5000203	4.2889446e+08	14939	28709.72	5
2012	35	3	3546207	1.1697193e+08	4074	28711.81	5
2012	41	4	4103370	8.921378e+07	3107	28713.8	5
2012	21	2	2109700	1.5881644e+08	5522	28760.67	5
2012	42	4	4217758	7.809758e+07	2714	28775.82	5
2012	35	3	3505302	1.01361689e+09	35210	28787.76	5
2012	35	3	3542206	8.3101839e+08	28809	28845.79	5
2012	31	3	3159605	1.1180015e+09	38734	28863.57	5
2012	35	3	3500600	8.188323e+07	2832	28913.57	5
2012	42	4	4211850	6.535596e+07	2259	28931.37	5
2012	35	3	3552502	7.74811663e+09	267583	28955.94	5
2012	31	3	3133006	4.1391052e+08	14276	28993.45	5
2012	17	1	1716505	3.4573303e+08	11919	29006.88	5
2012	35	3	3544004	8.8233003e+08	30409	29015.42	5
2012	15	1	1508100	2.92272464e+09	100651	29038.21	5
2012	42	4	4217907	2.5150164e+08	8653	29065.25	5
2012	35	3	3522703	1.17468554e+09	40399	29077.09	5
2012	35	3	3510401	1.44435359e+09	49650	29090.71	5
2012	51	5	5103601	2.3689407e+08	8134	29123.93	5
2012	35	3	3528809	3.9016194e+08	13382	29155.73	5
2012	35	3	3501202	1.1182975e+08	3834	29167.91	5
2012	52	5	5220504	2.2281309e+08	7638	29171.65	5
2012	42	4	4219507	1.31826789e+09	45140	29203.99	5
2012	17	1	1716208	3.0179885e+08	10327	29224.25	5
2012	50	5	5001003	6.7003719e+08	22912	29243.94	5
2012	28	2	2803609	8.0338638e+08	27442	29275.8	5
2012	43	4	4319125	9.353954e+07	3195	29276.85	5
2012	41	4	4118501	2.16544491e+09	73901	29301.97	5
2012	43	4	4320404	4.3259959e+08	14761	29306.93	5
2012	41	4	4105300	3.2635146e+08	11121	29345.51	5
2012	31	3	3128709	1.46124857e+09	49792	29347.06	5
2012	31	3	3170701	3.68586749e+09	125208	29437.96	5
2012	42	4	4208450	4.6113212e+08	15658	29450.26	5
2012	41	4	4124806	3.100797e+08	10508	29508.92	5
2012	51	5	5101852	1.6399319e+08	5555	29521.73	5
2012	42	4	4219200	1.8562077e+08	6284	29538.63	5
2012	42	4	4202008	3.34785262e+09	113319	29543.61	5
2012	43	4	4316501	2.0404741e+08	6903	29559.24	5
2012	35	3	3502804	5.42305463e+09	183441	29562.94	5
2012	52	5	5214002	4.0643608e+08	13739	29582.65	5
2012	43	4	4316972	7.042985e+07	2380	29592.37	5
2012	52	5	5222054	2.244122e+08	7576	29621.46	5
2012	43	4	4306106	1.84151425e+09	62138	29635.88	5
2012	43	4	4303558	7.736524e+07	2607	29675.96	5
2012	42	4	4217501	5.0465914e+08	17005	29677.1	5
2012	31	3	3156908	7.2102792e+08	24283	29692.7	5
2012	35	3	3512902	2.1379e+08	7191	29730.22	5
2012	43	4	4310207	2.36093823e+09	79396	29736.24	5
2012	42	4	4218004	9.5487485e+08	32087	29758.93	5
2012	43	4	4310462	5.736535e+07	1927	29769.25	5
2012	41	4	4128708	1.9495796e+08	6548	29773.66	5
2012	43	4	4307401	9.458174e+07	3176	29780.14	5
2012	42	4	4205803	4.5541909e+08	15272	29820.53	5
2012	42	4	4212700	1.8167446e+08	6090	29831.6	5
2012	13	1	1302603	5.555183761e+10	1861838	29837.1	5
2012	43	4	4304903	2.5938705e+08	8683	29872.98	5
2012	35	3	3513702	9.3741093e+08	31379	29873.83	5
2012	42	4	4200408	2.0850289e+08	6979	29875.75	5
2012	35	3	3540903	5.3966084e+08	18052	29894.8	5
2012	43	4	4312674	5.108103e+07	1708	29906.93	5
2012	52	5	5204300	4.1044865e+08	13692	29977.26	5
2012	35	3	3549805	1.246450365e+10	415769	29979.4	5
2012	50	5	5001508	1.9906727e+08	6637	29993.56	5
2012	43	4	4304606	9.79476704e+09	326505	29998.83	5
2012	35	3	3529708	6.2024749e+08	20668	30010.04	5
2012	43	4	4313011	8.202457e+07	2732	30023.63	5
2012	42	4	4205175	9.141022e+07	3043	30039.51	5
2012	33	3	3305406	5.2940227e+08	17581	30112.18	5
2012	50	5	5000856	2.8493001e+08	9462	30113.08	5
2012	42	4	4212106	4.8245341e+08	16018	30119.45	5
2012	43	4	4317202	2.08414724e+09	69127	30149.54	5
2012	42	4	4216602	6.49122819e+09	215278	30152.77	5
2012	41	4	4115358	1.7061686e+08	5654	30176.31	5
2012	31	3	3146503	2.4328771e+08	8047	30233.34	5
2012	43	4	4307708	2.44693159e+09	80862	30260.59	5
2012	35	3	3518404	3.42750541e+09	113258	30262.81	5
2012	41	4	4127502	5.8963128e+08	19482	30265.44	5
2012	41	4	4118600	1.6628457e+08	5491	30283.11	5
2012	43	4	4302220	7.3811e+07	2437	30287.65	5
2012	43	4	4313904	1.18102694e+09	38881	30375.43	5
2012	41	4	4119301	9.2623956e+08	30480	30388.44	5
2012	43	4	4323770	8.583833e+07	2821	30428.33	5
2012	41	4	4101606	7.9627799e+08	26153	30446.91	5
2012	35	3	3503901	2.35434651e+09	77279	30465.54	5
2012	52	5	5202353	9.653878e+07	3168	30473.1	5
2012	42	4	4204103	1.3061919e+08	4283	30497.12	5
2012	33	3	3300225	3.5631417e+08	11654	30574.41	5
2012	43	4	4303905	1.8654408e+09	60989	30586.51	5
2012	43	4	4322608	2.04266808e+09	66658	30644	5
2012	35	3	3506805	3.3952258e+08	11073	30662.2	5
2012	35	3	3513801	1.199828645e+10	390980	30687.72	5
2012	35	3	3510906	7.993083e+07	2599	30754.45	5
2012	50	5	5007935	4.8103315e+08	15632	30772.34	5
2012	43	4	4323200	9.226872e+07	2998	30776.76	5
2012	35	3	3536109	1.758576e+08	5711	30792.79	5
2012	41	4	4122206	9.4995478e+08	30848	30794.7	5
2012	17	1	1721257	5.032662e+07	1634	30799.64	5
2012	31	3	3151107	3.2083277e+08	10414	30807.83	5
2012	33	3	3306008	2.41156942e+09	78256	30816.42	5
2012	43	4	4302238	7.543983e+07	2447	30829.52	5
2012	35	3	3531902	9.1656705e+08	29673	30888.92	5
2012	52	5	5210109	7.7407986e+08	25054	30896.46	5
2012	35	3	3526803	1.93084162e+09	62393	30946.45	5
2012	43	4	4308458	1.3976685e+08	4513	30969.83	5
2012	42	4	4201307	8.3260171e+08	26875	30980.53	5
2012	43	4	4321451	8.7367411e+08	28198	30983.55	5
2012	41	4	4115200	1.139030655e+10	367410	31001.62	5
2012	43	4	4321709	7.6100179e+08	24516	31041.03	5
2012	31	3	3170107	9.39968046e+09	302623	31060.69	5
2012	42	4	4217204	1.14640109e+09	36908	31061.05	5
2012	35	3	3532009	3.7450991e+08	12050	31079.66	5
2012	31	3	3147006	2.67777172e+09	86153	31081.58	5
2012	42	4	4204202	5.87902196e+09	189052	31097.38	5
2012	42	4	4214805	1.94944336e+09	62658	31112.44	5
2012	31	3	3117603	1.62311e+08	5214	31129.84	5
2012	31	3	3106200	7.467032195e+10	2395785	31167.37	5
2012	29	2	2929206	1.06747024e+09	34226	31188.87	5
2012	31	3	3151800	4.83832505e+09	154974	31220.24	5
2012	31	3	3152501	4.19497051e+09	134215	31255.6	5
2012	43	4	4310801	6.4277236e+08	20562	31260.21	5
2012	52	5	5200175	1.6205795e+08	5184	31261.18	5
2012	51	5	5103908	1.6041241e+08	5130	31269.47	5
2012	41	4	4111902	3.8848202e+08	12421	31276.23	5
2012	31	3	3155504	3.7481009e+08	11939	31393.76	5
2012	31	3	3167202	6.86295893e+09	218574	31398.79	5
2012	35	3	3543253	2.3394979e+08	7427	31499.9	5
2012	42	4	4217550	1.0333988e+08	3279	31515.67	5
2012	29	2	2906501	2.65189469e+09	84121	31524.76	5
2012	41	4	4103222	1.0341893e+08	3279	31539.78	5
2012	51	5	5105903	4.7332543e+08	15004	31546.62	5
2012	42	4	4207502	1.80164791e+09	57068	31570.2	5
2012	43	4	4319752	6.275961e+07	1984	31632.87	5
2012	17	1	1712157	5.272678e+07	1665	31667.74	5
2012	42	4	4211751	5.2892361e+08	16691	31689.15	5
2012	50	5	5002407	8.4139081e+08	26532	31712.3	5
2012	43	4	4314100	5.95071326e+09	187298	31771.37	5
2012	41	4	4109807	1.56044214e+09	49111	31773.78	5
2012	35	3	3517406	1.20202113e+09	37826	31777.64	5
2012	35	3	3530706	4.43244369e+09	139211	31839.75	5
2012	42	4	4206504	1.1675853e+09	36640	31866.41	5
2012	43	4	4300661	3.926277e+07	1232	31869.13	5
2012	51	5	5102702	6.1469194e+08	19260	31915.47	5
2012	42	4	4203253	8.686093e+07	2713	32016.56	5
2012	42	4	4207684	2.2138077e+08	6901	32079.52	5
2012	26	2	2611002	1.06758445e+09	33273	32085.61	5
2012	25	2	2503209	1.93260495e+09	60226	32089.21	5
2012	31	3	3130309	2.5656015e+08	7993	32098.1	5
2012	31	3	3140803	4.3665865e+08	13603	32100.17	5
2012	29	2	2922003	1.19533248e+09	37229	32107.56	5
2012	29	2	2902054	3.7412029e+08	11642	32135.4	5
2012	42	4	4218301	5.8747252e+08	18281	32135.69	5
2012	41	4	4108304	8.21930061e+09	255718	32142.05	5
2012	52	5	5209101	1.05129068e+09	32698	32151.53	5
2012	42	4	4212056	7.756143e+07	2410	32183.17	5
2012	42	4	4205407	1.394662126e+10	433158	32197.54	5
2012	35	3	3529609	1.2365803e+08	3830	32286.69	5
2012	41	4	4121802	3.4373073e+08	10645	32290.35	5
2012	31	3	3151602	3.457356e+08	10700	32311.74	5
2012	52	5	5208152	1.0924608e+08	3378	32340.46	5
2012	35	3	3521101	2.027773e+08	6270	32340.88	5
2012	43	4	4304655	1.0307786e+08	3187	32343.23	5
2012	24	2	2407203	9.5250574e+08	29446	32347.54	5
2012	24	2	2400703	4.1197269e+08	12729	32364.89	5
2012	51	5	5108857	9.745911e+07	3007	32410.74	5
2012	42	4	4219309	1.55818784e+09	48064	32419.02	5
2012	35	3	3534302	1.30896495e+09	40352	32438.66	5
2012	17	1	1703842	2.7642212e+08	8517	32455.34	5
2012	17	1	1708254	7.939436e+07	2446	32458.85	5
2012	43	4	4309209	8.41224858e+09	259138	32462.43	5
2012	43	4	4315602	6.46075815e+09	198842	32491.92	5
2012	35	3	3508207	1.3378257e+08	4111	32542.59	5
2012	35	3	3503208	6.92852835e+09	212617	32586.9	5
2012	31	3	3169356	9.4873845e+08	29036	32674.56	5
2012	52	5	5206206	1.58544131e+09	48463	32714.47	5
2012	42	4	4210001	3.5386553e+08	10811	32731.99	5
2012	42	4	4215802	2.49692201e+09	76215	32761.56	5
2012	43	4	4307906	2.12824011e+09	64893	32796.14	5
2012	41	4	4125308	1.8068413e+08	5506	32815.86	5
2012	43	4	4313375	7.8049848e+08	23768	32838.21	5
2012	24	2	2401107	8.4583478e+08	25736	32865.82	5
2012	43	4	4307005	3.20305962e+09	97404	32884.27	5
2012	42	4	4218202	1.24723034e+09	37894	32913.66	5
2012	51	5	5101902	5.3360128e+08	16194	32950.55	5
2012	43	4	4313300	7.7656948e+08	23508	33034.26	5
2012	29	2	2916302	3.4387016e+08	10398	33070.8	5
2012	42	4	4211603	4.4924614e+08	13581	33079.02	5
2012	26	2	2602902	6.25939112e+09	189222	33079.62	5
2012	43	4	4314779	1.2749512e+08	3850	33115.61	5
2012	41	4	4101507	3.5451506e+09	106978	33139.06	5
2012	42	4	4218855	9.410466e+07	2838	33158.8	5
2012	31	3	3168200	6.200718e+07	1869	33176.66	5
2012	31	3	3157708	3.9369479e+08	11830	33279.36	5
2012	35	3	3503307	4.03714349e+09	121055	33349.66	5
2012	22	2	2201150	3.6479648e+08	10930	33375.71	5
2012	41	4	4122701	2.0693052e+08	6200	33375.89	5
2012	29	2	2908507	1.0253264e+09	30717	33379.77	5
2012	42	4	4206306	6.4287594e+08	19254	33389.21	5
2012	33	3	3303906	9.98167518e+09	297192	33586.62	5
2012	35	3	3526902	9.41935389e+09	280096	33629.02	5
2012	35	3	3502101	1.8619785e+09	55361	33633.4	5
2012	42	4	4211405	1.4769371e+08	4386	33673.9	5
2012	41	4	4124509	1.7789316e+08	5282	33679.13	5
2012	52	5	5201108	1.154699961e+10	342347	33728.93	5
2012	31	3	3150703	1.6690804e+08	4946	33746.06	5
2012	42	4	4201257	3.3016468e+08	9764	33814.49	5
2012	43	4	4301958	8.08372e+07	2388	33851.43	5
2012	35	3	3522901	4.2214304e+08	12446	33917.97	5
2012	51	5	5103452	2.9464069e+08	8684	33929.14	5
2012	42	4	4210506	7.6928492e+08	22642	33976.01	5
2012	35	3	3511508	1.39796003e+09	41144	33977.25	5
2012	35	3	3518800	4.242624083e+10	1244518	34090.5	5
2012	50	5	5001243	3.6086546e+08	10583	34098.6	5
2012	43	4	4323309	1.1009666e+08	3226	34127.92	5
2012	35	3	3509254	9.6763884e+08	28243	34261.19	5
2012	35	3	3538006	5.14526767e+09	150162	34264.78	5
2012	43	4	4311627	1.8341807e+08	5350	34283.75	5
2012	35	3	3522505	7.08816877e+09	206558	34315.63	5
2012	42	4	4211009	3.5910101e+08	10458	34337.45	5
2012	42	4	4211702	7.4214088e+08	21599	34359.96	5
2012	29	2	2917359	2.9990582e+08	8728	34361.35	5
2012	35	3	3504107	4.43442304e+09	128914	34398.3	5
2012	52	5	5211909	3.09486108e+09	89902	34424.83	5
2012	43	4	4323408	1.4567452e+08	4229	34446.56	5
2012	17	1	1712702	7.96807e+07	2311	34478.89	5
2012	42	4	4205308	3.6735597e+08	10645	34509.72	5
2012	23	2	2304285	1.65780986e+09	47993	34542.74	5
2012	41	4	4118907	3.5747686e+08	10348	34545.5	5
2012	41	4	4120002	4.8172637e+08	13934	34572.01	5
2012	35	3	3532827	3.008146e+08	8700	34576.39	5
2012	41	4	4126405	1.9769417e+08	5711	34616.38	5
2012	35	3	3522604	2.40181852e+09	69317	34649.78	5
2012	31	3	3105400	1.01554799e+09	29205	34773.09	5
2012	41	4	4117909	1.01383889e+09	29123	34812.31	5
2012	42	4	4203956	7.7138184e+08	22145	34833.23	5
2012	35	3	3529500	1.6647207e+08	4774	34870.56	5
2012	32	3	3203205	5.08122761e+09	145639	34889.2	5
2012	31	3	3149804	5.1411539e+08	14713	34942.93	5
2012	51	5	5108501	3.6402184e+08	10414	34955.05	5
2012	51	5	5107941	3.4283057e+08	9795	35000.57	5
2012	35	3	3547809	2.384298759e+10	680496	35037.66	5
2012	52	5	5207402	4.0119115e+08	11424	35118.27	5
2012	43	4	4312401	2.11414899e+09	60196	35121.09	5
2012	31	3	3136652	8.106622e+08	23080	35124.01	5
2012	35	3	3531001	7.560084e+07	2144	35261.58	5
2012	35	3	3543402	2.185435937e+10	619746	35263.41	5
2012	42	4	4213153	9.495681e+07	2685	35365.67	5
2012	11	1	1101468	8.077472e+07	2283	35380.95	5
2012	42	4	4202578	7.5412e+07	2130	35404.69	5
2012	42	4	4215752	9.476774e+07	2676	35413.95	5
2012	32	3	3205002	1.497267212e+10	422569	35432.49	5
2012	52	5	5218805	6.60260953e+09	185465	35600.3	5
2012	43	4	4308201	9.8543158e+08	27647	35643.35	5
2012	35	3	3528403	1.55983299e+09	43714	35682.69	5
2012	35	3	3524402	7.65204079e+09	214223	35719.98	5
2012	52	5	5211503	3.38309655e+09	94613	35757.21	5
2012	42	4	4202909	3.937395e+09	109950	35810.78	5
2012	31	3	3126604	1.7627484e+08	4920	35828.22	5
2012	29	2	2910057	2.50101454e+09	69628	35919.67	5
2012	43	4	4300059	1.3355324e+08	3712	35978.78	5
2012	33	3	3303302	1.76998289e+10	491807	35989.38	5
2012	43	4	4322806	8.4021221e+08	23315	36037.41	5
2012	43	4	4305207	4.8254046e+08	13384	36053.53	5
2012	31	3	3131307	8.78344958e+09	243541	36065.59	5
2012	35	3	3548906	8.16670483e+09	226322	36084.45	5
2012	35	3	3512100	2.165951e+08	6001	36093.17	5
2012	31	3	3136579	1.6658336e+08	4614	36103.89	5
2012	35	3	3539806	3.8906015e+09	107556	36172.8	5
2012	35	3	3527108	2.61927773e+09	72260	36247.96	5
2012	35	3	3509908	4.4317966e+08	12216	36278.62	5
2012	35	3	3532207	1.5857866e+08	4371	36279.72	5
2012	43	4	4311809	1.36393148e+09	37573	36300.84	5
2012	42	4	4211306	2.31477037e+09	63764	36302.15	5
2012	52	5	5219258	1.7686711e+08	4865	36355.01	5
2012	35	3	3512001	6.3747917e+08	17478	36473.23	5
2012	35	3	3556909	2.6406893e+08	7208	36635.53	5
2012	43	4	4310009	7.1175974e+08	19415	36660.3	5
2012	51	5	5106802	1.9887133e+08	5417	36712.45	5
2012	31	3	3118601	2.257650496e+10	613815	36780.63	5
2012	43	4	4309100	1.20933782e+09	32829	36837.49	5
2012	31	3	3170206	2.283727774e+10	619536	36861.91	5
2012	51	5	5100300	6.0131721e+08	16284	36926.87	5
2012	43	4	4307807	1.15191253e+09	31105	37033.03	5
2012	43	4	4301008	7.0705431e+08	19060	37096.24	5
2012	41	4	4120903	1.15616711e+09	31095	37181.77	5
2012	43	4	4307831	1.0146355e+08	2721	37289.07	5
2012	29	2	2915205	5.6282774e+08	15088	37303.01	5
2012	35	3	3551702	4.19446013e+09	112401	37316.93	5
2012	41	4	4118204	5.33904992e+09	142452	37479.64	5
2012	43	4	4304671	1.5037772e+08	4009	37510.03	5
2012	35	3	3523404	3.92129828e+09	104533	37512.54	5
2012	51	5	5103858	2.4660374e+08	6548	37660.93	5
2012	35	3	3554508	1.41780814e+09	37609	37698.64	5
2012	22	2	2211209	7.7764832e+08	20623	37707.82	5
2012	35	3	3533403	1.98503551e+09	52627	37718.96	5
2012	35	3	3528858	1.0158397e+08	2693	37721.49	5
2012	41	4	4119152	4.50433952e+09	119379	37731.42	5
2012	31	3	3155702	5.3456238e+08	14151	37775.59	5
2012	43	4	4309308	3.60192561e+09	95340	37779.79	5
2012	52	5	5205455	2.9119162e+08	7701	37812.18	5
2012	42	4	4217006	4.3040407e+08	11357	37897.69	5
2012	33	3	3300100	6.72219705e+09	177101	37956.86	5
2012	43	4	4312385	1.0029019e+08	2637	38031.93	5
2012	35	3	3529302	2.95397627e+09	77546	38093.21	5
2012	43	4	4314902	5.42048325e+10	1416714	38260.96	5
2012	42	4	4202404	1.210167124e+10	316139	38279.59	5
2012	43	4	4310108	1.24064017e+09	32399	38292.55	5
2012	35	3	3543907	7.24412296e+09	188977	38333.36	5
2012	35	3	3508504	3.30984344e+09	86054	38462.4	5
2012	31	3	3164605	2.3023472e+08	5980	38500.79	5
2012	43	4	4313060	7.2656062e+08	18841	38562.74	5
2012	31	3	3111408	2.7398652e+08	7103	38573.35	5
2012	35	3	3520301	1.12316942e+09	29055	38656.67	5
2012	35	3	3536703	1.63555247e+09	42235	38725.05	5
2012	43	4	4311403	2.83490764e+09	73201	38727.72	5
2012	31	3	3127800	5.8748116e+08	15145	38790.44	5
2012	42	4	4209102	2.047288078e+10	526338	38896.83	5
2012	35	3	3523909	6.11021038e+09	156983	38922.75	5
2012	29	2	2925204	1.32760351e+09	34106	38925.81	5
2012	41	4	4107108	2.1141456e+08	5428	38948.89	5
2012	50	5	5006002	6.8227364e+08	17410	39188.61	5
2012	51	5	5108907	2.7474113e+08	6989	39310.51	5
2012	43	4	4302105	4.31755468e+09	109653	39374.71	5
2012	42	4	4213500	6.6625817e+08	16896	39432.89	5
2012	51	5	5100409	4.2017196e+08	10655	39434.25	5
2012	35	3	3520400	1.15693447e+09	29308	39475.04	5
2012	33	3	3306305	1.028406935e+10	260180	39526.75	5
2012	33	3	3304557	2.5320078533e+11	6390290	39622.74	5
2012	43	4	4316709	3.4277497e+08	8650	39627.16	5
2012	42	4	4209003	1.091513e+09	27467	39739.07	5
2012	41	4	4106902	7.063770853e+10	1776761	39756.45	5
2012	42	4	4202107	9.333757e+08	23422	39850.38	5
2012	42	4	4202859	1.4011103e+08	3498	40054.61	5
2012	35	3	3548500	1.685021171e+10	419614	40156.46	5
2012	31	3	3156304	2.8545124e+08	7093	40244.08	5
2012	42	4	4200101	6.9274998e+08	17200	40276.16	5
2012	43	4	4313508	1.68051907e+09	41628	40369.92	5
2012	31	3	3106309	9.7280679e+08	23984	40560.66	5
2012	35	3	3534005	1.6051154e+08	3956	40574.2	5
2012	42	4	4204350	1.5744302e+08	3869	40693.47	5
2012	35	3	3501608	8.7580841e+09	214873	40759.35	5
2012	50	5	5007208	1.29942823e+09	31875	40766.38	5
2012	35	3	3539608	1.8703161e+08	4583	40809.87	5
2012	35	3	3545209	4.38552031e+09	107382	40840.37	5
2012	35	3	3556206	4.52098644e+09	110390	40954.67	5
2012	31	3	3133758	6.2129569e+08	15135	41050.26	5
2012	31	3	3104007	3.93886981e+09	95888	41077.82	5
2012	35	3	3549904	2.658474851e+10	643603	41306.13	5
2012	35	3	3513009	8.63995222e+09	209027	41334.14	5
2012	42	4	4211876	7.128433e+07	1720	41444.38	5
2012	22	2	2200806	1.2718436e+08	3068	41455.14	5
2012	42	4	4210555	8.863331e+07	2136	41495	5
2012	35	3	3519071	8.25960895e+09	198758	41556.11	5
2012	35	3	3536307	5.5047208e+08	13240	41576.44	5
2012	52	5	5213087	1.28128774e+09	30784	41621.87	5
2012	31	3	3128600	2.7337858e+08	6552	41724.45	5
2012	43	4	4312807	1.7190048e+08	4117	41753.82	5
2012	50	5	5007695	9.6341469e+08	23016	41858.48	5
2012	43	4	4308607	1.31182953e+09	31328	41874.03	5
2012	43	4	4310363	1.2688143e+08	3029	41888.88	5
2012	35	3	3506201	1.1381266e+08	2717	41889.09	5
2012	31	3	3146255	2.4969944e+08	5926	42136.25	5
2012	42	4	4212908	7.1380864e+08	16933	42154.88	5
2012	35	3	3519055	5.0239888e+08	11917	42158.17	5
2012	43	4	4305975	1.1859343e+08	2803	42309.46	5
2012	52	5	5218102	1.6379142e+08	3861	42422.02	5
2012	31	3	3129707	5.2948489e+08	12470	42460.7	5
2012	35	3	3507308	1.8468871e+08	4348	42476.7	5
2012	42	4	4201208	3.2402056e+08	7613	42561.48	5
2012	43	4	4306403	1.20809636e+09	28348	42616.63	5
2012	50	5	5005400	1.67350647e+09	39095	42806.15	5
2012	33	3	3301108	8.5272659e+08	19830	43001.84	5
2012	35	3	3552205	2.596968884e+10	600692	43232.95	5
2012	51	5	5105259	2.1413871e+09	49519	43243.75	5
2012	41	4	4120804	8.8327887e+08	20409	43278.89	5
2012	51	5	5107248	1.8039279e+08	4159	43374.08	5
2012	35	3	3538709	1.605265303e+10	369919	43395.05	5
2012	51	5	5107040	2.35016875e+09	53910	43594.3	5
2012	43	4	4312609	2.0933915e+08	4801	43603.24	5
2012	43	4	4303103	5.22938585e+09	119896	43616.02	5
2012	51	5	5102678	1.47400829e+09	33759	43662.68	5
2012	43	4	4308854	7.298219e+07	1663	43885.86	5
2012	41	4	4119103	5.0273386e+08	11454	43891.55	5
2012	35	3	3507001	2.21464249e+09	50420	43923.89	5
2012	35	3	3520509	9.22405742e+09	209859	43953.59	5
2012	35	3	3509502	4.843867748e+10	1098630	44090.07	5
2012	43	4	4304622	7.641467e+07	1730	44170.33	5
2012	50	5	5005251	2.9336305e+08	6636	44207.81	5
2012	41	4	4102307	5.1016513e+08	11539	44212.25	5
2012	31	3	3128253	2.1095307e+08	4756	44355.14	5
2012	42	4	4213203	1.26927424e+09	28610	44364.71	5
2012	35	3	3515202	3.6429629e+08	8201	44420.96	5
2012	42	4	4218350	1.5945126e+08	3585	44477.34	5
2012	42	4	4209201	9.842403e+07	2203	44677.27	5
2012	43	4	4314472	1.9915205e+08	4433	44924.89	5
2012	35	3	3541604	1.63935385e+09	36364	45081.78	5
2012	43	4	4305108	2.015048782e+10	446911	45088.37	5
2012	29	2	2905701	1.153428634e+10	255238	45190.32	5
2012	35	3	3518305	1.19535468e+09	26439	45211.8	5
2012	35	3	3501905	3.01410884e+09	66649	45223.62	5
2012	52	5	5205901	3.8095267e+08	8412	45286.81	5
2012	50	5	5003256	9.2315687e+08	20348	45368.43	5
2012	43	4	4316808	5.4459696e+09	119997	45384.21	5
2012	35	3	3552403	1.118073037e+10	246247	45404.53	5
2012	41	4	4107256	3.4730283e+08	7640	45458.48	5
2012	35	3	3540002	9.2084405e+08	20235	45507.49	5
2012	35	3	3524907	2.5275094e+08	5554	45507.91	5
2012	52	5	5216403	4.9871676e+08	10868	45888.55	5
2012	51	5	5106299	4.9410703e+08	10749	45967.72	5
2012	51	5	5106281	2.6786679e+08	5810	46104.44	5
2012	42	4	4208906	6.844962e+09	148353	46139.69	5
2012	35	3	3541802	1.3439767e+08	2905	46264.26	5
2012	51	5	5108006	5.1200142e+08	11042	46368.54	5
2012	42	4	4203600	1.5452299e+09	33313	46385.19	5
2012	41	4	4101804	5.72149275e+09	122878	46562.39	5
2012	51	5	5107925	3.3306624e+09	71190	46785.54	5
2012	28	2	2803302	8.0533768e+08	17213	46786.6	5
2012	42	4	4200556	1.127399e+08	2409	46799.46	5
2012	31	3	3162252	2.208485e+08	4695	47039.08	5
2012	35	3	3550308	5.3887712141e+11	11376685	47366.8	5
2012	31	3	3145000	6.3105552e+08	13314	47397.89	5
2012	41	4	4104659	9.4229544e+08	19813	47559.45	5
2012	52	5	5204805	2.9966792e+08	6292	47626.82	5
2012	17	1	1716604	5.0627332e+08	10629	47631.32	5
2012	50	5	5008305	5.0504969e+09	105224	47997.58	5
2012	33	3	3300258	1.35911445e+09	28295	48033.73	5
2012	50	5	5002308	5.7279547e+08	11807	48513.21	5
2012	35	3	3554102	1.381420985e+10	283899	48658.89	5
2012	29	2	2919553	3.26180943e+09	66371	49145.1	5
2012	42	4	4204707	5.2485078e+08	10671	49184.78	5
2012	31	3	3135407	2.611238e+08	5288	49380.45	5
2012	43	4	4312658	8.0062602e+08	16166	49525.3	5
2012	35	3	3507753	1.2993884e+08	2614	49708.81	5
2012	35	3	3513504	5.9945366e+09	120293	49832.8	5
2012	31	3	3131703	5.55908213e+09	111514	49850.98	5
2012	42	4	4218509	3.276643e+08	6568	49887.99	5
2012	24	2	2410256	2.7205964e+08	5392	50456.17	5
2012	31	3	3156403	1.8065645e+08	3575	50533.27	5
2012	43	4	4309050	3.5861663e+08	7074	50695.03	5
2012	52	5	5205307	4.797894e+08	9429	50884.44	5
2012	35	3	3524501	2.9993444e+08	5890	50922.66	5
2012	42	4	4219176	2.417631e+08	4738	51026.4	5
2012	43	4	4304804	1.33005858e+09	25898	51357.58	5
2012	33	3	3302700	6.97053105e+09	135121	51587.33	5
2012	35	3	3531803	2.62276576e+09	50702	51729.04	5
2012	42	4	4214201	5.3008027e+08	10175	52096.34	5
2012	52	5	5203203	4.7408077e+08	9089	52159.84	5
2012	35	3	3537008	8.2522996e+08	15807	52206.61	5
2012	31	3	3134400	1.84560796e+09	35308	52271.67	5
2012	52	5	5218052	1.7985914e+08	3427	52482.97	5
2012	35	3	3553955	6.971933e+08	13209	52781.69	5
2012	33	3	3304003	1.42486915e+09	26948	52874.76	5
2012	51	5	5106224	1.81911337e+09	34374	52921.2	5
2012	41	4	4110409	2.2878512e+08	4313	53045.47	5
2012	31	3	3100708	1.0743471e+08	2015	53317.47	5
2012	50	5	5002951	1.11601723e+09	20855	53513.17	5
2012	35	3	3555356	2.9371547e+08	5451	53882.86	5
2012	52	5	5213756	5.9410359e+08	11001	54004.51	5
2012	33	3	3302007	6.12620686e+09	113182	54127.04	5
2012	35	3	3546702	1.22004244e+09	22499	54226.52	5
2012	35	3	3544251	1.03433591e+09	19006	54421.55	5
2012	13	1	1301209	4.2079607e+09	77305	54433.23	5
2012	42	4	4209458	8.050895e+07	1478	54471.55	5
2012	35	3	3547304	6.21128907e+09	113945	54511.29	5
2012	51	5	5107065	7.6077596e+08	13903	54720.27	5
2012	43	4	4314423	2.888634e+08	5259	54927.44	5
2012	35	3	3533601	3.8112999e+08	6894	55284.3	5
2012	52	5	5218789	1.9336142e+08	3496	55309.33	5
2012	35	3	3500709	1.92853929e+09	34833	55365.29	5
2012	31	3	3106705	2.165200992e+10	388873	55678.87	5
2012	43	4	4309605	1.03174608e+09	18446	55933.32	5
2012	41	4	4103453	8.5650437e+08	15194	56371.22	5
2012	35	3	3508405	2.42614612e+09	42889	56568.03	5
2012	33	3	3304201	6.90583756e+09	122068	56573.69	5
2012	31	3	3127008	8.4057281e+08	14799	56799.3	5
2012	35	3	3534203	3.3910417e+08	5904	57436.34	5
2012	35	3	3524006	2.77256704e+09	47682	58147.04	5
2012	35	3	3548708	4.530059917e+10	774886	58460.99	5
2012	52	5	5221551	2.6757404e+08	4532	59041.05	5
2012	32	3	3200607	5.01953068e+09	84429	59452.68	5
2012	35	3	3550704	4.55042566e+09	76344	59604.23	5
2012	52	5	5215504	3.3776244e+08	5648	59802.13	5
2012	51	5	5102637	1.74635634e+09	29078	60057.65	5
2012	35	3	3503703	5.2913711e+08	8709	60757.51	5
2012	41	4	4114401	1.03197866e+09	16941	60916.04	5
2012	31	3	3131901	2.8386281e+09	46589	60929.15	5
2012	31	3	3130408	3.6693223e+08	5980	61359.9	5
2012	31	3	3145455	3.3340722e+08	5416	61559.68	5
2012	28	2	2806107	5.884244e+08	9541	61673.24	5
2012	41	4	4104600	9.3080994e+08	15060	61806.77	5
2012	53	5	5300108	1.6410133648e+11	2648532	61959.36	5
2012	51	5	5103502	1.28551999e+09	20605	62388.74	5
2012	31	3	3118007	3.11706425e+09	49616	62823.77	5
2012	28	2	2802007	2.8245331e+08	4487	62949.25	5
2012	35	3	3551306	1.9737152e+08	3105	63565.71	5
2012	51	5	5107156	1.6541975e+08	2595	63745.57	5
2012	28	2	2801504	9.0183027e+08	14130	63823.8	5
2012	33	3	3300936	8.9740439e+08	14024	63990.62	5
2012	29	2	2911105	1.50320402e+09	23169	64879.97	5
2012	51	5	5106240	6.354723e+08	9757	65129.89	5
2012	42	4	4216206	2.89236803e+09	44064	65640.16	5
2012	33	3	3302601	2.5139818e+09	38201	65809.32	5
2012	43	4	4322251	2.6797052e+08	4070	65840.42	5
2012	35	3	3540309	1.6678572e+08	2515	66316.39	5
2012	31	3	3109006	2.40198799e+09	35085	68461.96	5
2012	33	3	3303807	2.70102254e+09	38740	69721.8	5
2012	24	2	2408805	3.4613679e+08	4924	70295.86	5
2012	35	3	3512407	1.54002947e+09	21607	71274.56	5
2012	42	4	4208203	1.357709595e+10	188791	71916.01	5
2012	35	3	3502754	1.30823599e+09	17975	72780.86	5
2012	52	5	5205109	6.56409724e+09	90004	72931.17	5
2012	43	4	4312617	2.1935119e+08	3007	72946.85	5
2012	32	3	3205309	2.432212071e+10	333162	73003.89	5
2012	42	4	4213104	3.4403329e+08	4632	74273.16	5
2012	28	2	2801207	1.91879951e+09	25733	74565.71	5
2012	31	3	3115359	3.6897197e+08	4938	74720.93	5
2012	52	5	5216452	2.2239479e+08	2975	74754.55	5
2012	35	3	3534401	5.005946783e+10	668877	74841.07	5
2012	31	3	3126307	3.1098073e+08	4150	74935.12	5
2012	42	4	4206652	3.5293428e+08	4676	75477.82	5
2012	51	5	5100607	6.5053049e+08	8615	75511.37	5
2012	43	4	4312906	6.7993618e+08	8992	75615.68	5
2012	51	5	5107792	3.0866922e+08	4038	76441.12	5
2012	51	5	5104526	4.4240161e+08	5631	78565.37	5
2012	33	3	3302403	1.716591171e+10	217951	78760.42	5
2012	31	3	3145901	2.84577804e+09	36006	79036.22	5
2012	31	3	3146107	5.67823052e+09	70886	80103.69	5
2012	29	2	2928901	2.32144514e+09	28921	80268.49	5
2012	21	2	2112001	6.445812e+08	8008	80492.16	5
2012	35	3	3525904	3.068351605e+10	377183	81349.15	5
2012	31	3	3130705	5.1411012e+08	6312	81449.64	5
2012	41	4	4125506	2.22716237e+10	273255	81504.91	5
2012	35	3	3545506	3.0981328e+08	3792	81701.82	5
2012	33	3	3302254	2.41316469e+09	29394	82097.19	5
2012	52	5	5204250	6.8653566e+08	8214	83581.16	5
2012	32	3	3203320	2.93369447e+09	34675	84605.46	5
2012	33	3	3300704	1.676465724e+10	195197	85885.83	5
2012	51	5	5107875	1.68972717e+09	19639	86039.37	5
2012	35	3	3556701	5.7396242e+09	66087	86849.52	5
2012	26	2	2607208	7.28694037e+09	83862	86892.04	5
2012	35	3	3527603	1.03584308e+09	11910	86972.55	5
2012	52	5	5220405	1.53549669e+09	17622	87135.21	5
2012	35	3	3507209	7.219441e+07	807	89460.24	5
2012	35	3	3524709	4.16685404e+09	46533	89546.22	5
2012	42	4	4219101	3.1638283e+08	3533	89550.76	5
2012	51	5	5104609	1.05879298e+09	11822	89561.24	5
2012	43	4	4306957	2.7261667e+08	3018	90330.24	5
2012	52	5	5205471	6.863885e+08	7488	91665.13	5
2012	31	3	3168101	3.909795e+08	4231	92408.29	5
2012	31	3	3144805	7.92310102e+09	83507	94879.48	5
2012	35	3	3501152	1.65987317e+09	17079	97187.96	5
2012	31	3	3140001	5.39062214e+09	55353	97386.27	5
2012	35	3	3536505	8.46172932e+09	86800	97485.36	5
2012	35	3	3548807	1.509457163e+10	150638	100204.28	5
2012	31	3	3125101	3.10403707e+09	30016	103412.75	5
2012	31	3	3162948	7.1957546e+08	6888	104467.98	5
2012	35	3	3509205	7.05625408e+09	66131	106701.16	5
2012	31	3	3124807	8.2699178e+08	7532	109797.1	5
2012	33	3	3301306	4.11451378e+09	37340	110190.51	5
2012	15	1	1502152	3.20782692e+09	29101	110230.81	5
2012	33	3	3300233	3.2843231e+09	28973	113358.06	5
2012	15	1	1505536	1.908039543e+10	166342	114705.82	5
2012	52	5	5206909	2.4384834e+08	2060	118372.98	5
2012	31	3	3117876	7.2894234e+08	6077	119951.02	5
2012	33	3	3301009	5.953094145e+10	472300	126044.76	5
2012	33	3	3304524	1.491741e+10	116134	128449.98	5
2012	43	4	4300901	8.4314679e+08	6482	130075.1	5
2012	51	5	5107768	3.6007311e+08	2676	134556.47	5
2012	35	3	3530805	1.192770798e+10	87266	136682.19	5
2012	35	3	3520426	1.39907608e+09	9376	149218.86	5
2012	51	5	5102686	8.2942791e+08	5494	150969.77	5
2012	31	3	3133709	1.55040635e+09	10142	152869.88	5
2012	35	3	3505708	3.95664664e+10	245652	161067.15	5
2012	31	3	3103751	1.06307922e+09	6271	169523.08	5
2012	52	5	5200555	8.194737e+08	4799	170759.26	5
2012	29	2	2905404	2.7327485e+09	15973	171085.49	5
2012	43	4	4314464	3.6271656e+08	2089	173631.67	5
2012	32	3	3202801	6.163028e+09	31421	196143.6	5
2012	35	3	3527306	7.94616448e+09	39122	203112.43	5
2012	33	3	3305000	7.0169271e+09	33512	209385.51	5
2012	43	4	4322004	5.59338928e+09	26341	212345.37	5
2012	50	5	5007802	1.3602973e+09	6318	215305.05	5
2012	41	4	4126272	1.12437949e+09	5092	220812.94	5
2012	32	3	3200409	5.65292445e+09	24616	229644.31	5
2012	33	3	3304110	4.04876482e+09	17272	234412.04	5
2012	33	3	3304151	5.46788454e+09	21234	257506.1	5
2012	31	3	3161908	3.14486348e+09	9976	315242.93	5
2012	32	3	3204302	8.10437408e+09	10429	777099.83	5
2013	24	2	2404507	4.19894e+06	13922	301.6	1
2013	21	2	2107209	4.350003e+07	13465	3230.6	1
2013	21	2	2111722	4.540915e+07	12959	3504.06	1
2013	21	2	2106607	1.146347e+08	32545	3522.34	1
2013	21	2	2110278	5.28586e+07	14828	3564.78	1
2013	29	2	2923050	5.698667e+07	15943	3574.4	1
2013	21	2	2106631	5.484393e+07	15322	3579.42	1
2013	21	2	2112605	1.1263938e+08	31335	3594.68	1
2013	21	2	2110401	6.531348e+07	18118	3604.89	1
2013	21	2	2105104	9.425515e+07	26014	3623.25	1
2013	21	2	2102408	3.924604e+07	10822	3626.5	1
2013	21	2	2112100	1.0323447e+08	28368	3639.12	1
2013	21	2	2108306	1.3326798e+08	36520	3649.18	1
2013	21	2	2110237	4.581235e+07	12521	3658.84	1
2013	21	2	2101905	7.64471e+07	20821	3671.63	1
2013	29	2	2900504	4.244949e+07	11509	3688.37	1
2013	21	2	2111078	6.576628e+07	17809	3692.87	1
2013	21	2	2109403	5.433037e+07	14588	3724.32	1
2013	21	2	2103125	3.128727e+07	8255	3790.1	1
2013	22	2	2203255	1.628651e+07	4297	3790.21	1
2013	21	2	2105005	1.039357e+08	27364	3798.26	1
2013	29	2	2920452	5.185359e+07	13598	3813.32	1
2013	21	2	2111789	4.099437e+07	10693	3833.76	1
2013	21	2	2100873	5.631403e+07	14658	3841.86	1
2013	15	1	1503754	1.5948707e+08	41487	3844.27	1
2013	29	2	2903953	4.117627e+07	10644	3868.5	1
2013	23	2	2303006	8.265972e+07	21236	3892.43	1
2013	21	2	2104081	3.821725e+07	9783	3906.5	1
2013	21	2	2105450	3.658142e+07	9360	3908.27	1
2013	21	2	2108405	5.456154e+07	13956	3909.54	1
2013	21	2	2106805	5.691614e+07	14504	3924.17	1
2013	23	2	2303600	7.723751e+07	19676	3925.47	1
2013	29	2	2905156	6.251658e+07	15842	3946.26	1
2013	22	2	2203453	3.698601e+07	9364	3949.81	1
2013	29	2	2932457	7.370517e+07	18635	3955.2	1
2013	21	2	2100402	4.585938e+07	11564	3965.7	1
2013	21	2	2101731	2.821454e+07	7105	3971.08	1
2013	21	2	2102705	8.400932e+07	21125	3976.77	1
2013	21	2	2103901	4.384374e+07	10942	4006.92	1
2013	29	2	2919108	3.904819e+07	9673	4036.82	1
2013	21	2	2108801	7.23584e+07	17917	4038.53	1
2013	23	2	2310951	4.266287e+07	10556	4041.58	1
2013	22	2	2202059	4.130736e+07	10220	4041.82	1
2013	29	2	2901809	4.860006e+07	11973	4059.14	1
2013	21	2	2100204	8.786589e+07	21644	4059.6	1
2013	23	2	2313351	7.346364e+07	18083	4062.58	1
2013	21	2	2102507	7.624798e+07	18751	4066.34	1
2013	22	2	2206050	2.579639e+07	6305	4091.42	1
2013	29	2	2915353	5.893252e+07	14392	4094.81	1
2013	21	2	2107100	7.610617e+07	18544	4104.09	1
2013	21	2	2110906	4.90738e+07	11955	4104.88	1
2013	22	2	2200301	5.737998e+07	13923	4121.24	1
2013	22	2	2203750	2.132023e+07	5171	4123.04	1
2013	21	2	2101350	2.243799e+07	5440	4124.63	1
2013	22	2	2207793	1.605106e+07	3888	4128.36	1
2013	29	2	2918753	6.417714e+07	15542	4129.27	1
2013	29	2	2922854	3.524885e+07	8527	4133.79	1
2013	29	2	2911303	4.696609e+07	11338	4142.36	1
2013	29	2	2921054	5.024098e+07	12114	4147.35	1
2013	21	2	2109304	4.614103e+07	11105	4154.98	1
2013	22	2	2209955	1.966872e+07	4728	4160.05	1
2013	27	2	2708956	5.727859e+07	13765	4161.18	1
2013	21	2	2105922	4.574474e+07	10989	4162.78	1
2013	21	2	2108058	6.356971e+07	15234	4172.88	1
2013	21	2	2105476	6.639182e+07	15899	4175.85	1
2013	21	2	2110500	1.7909644e+08	42867	4177.96	1
2013	31	3	3162450	5.192655e+07	12421	4180.54	1
2013	29	2	2930808	7.145352e+07	17073	4185.18	1
2013	29	2	2907558	4.092102e+07	9760	4192.73	1
2013	21	2	2112704	2.220254e+08	52937	4194.14	1
2013	22	2	2202174	2.94354e+07	7016	4195.47	1
2013	23	2	2309458	1.0426128e+08	24829	4199.17	1
2013	22	2	2202026	3.418825e+07	8138	4201.06	1
2013	29	2	2913804	6.62398e+07	15753	4204.9	1
2013	13	1	1301803	1.067384e+08	25362	4208.6	1
2013	21	2	2102077	6.570099e+07	15604	4210.52	1
2013	21	2	2102309	9.785293e+07	23238	4210.9	1
2013	29	2	2910008	5.36404e+07	12721	4216.68	1
2013	27	2	2701605	7.541828e+07	17880	4218.02	1
2013	21	2	2108256	1.0108387e+08	23874	4234.06	1
2013	21	2	2100832	7.403172e+07	17474	4236.68	1
2013	23	2	2304657	6.475053e+07	15281	4237.32	1
2013	29	2	2925709	5.712985e+07	13442	4250.1	1
2013	22	2	2203354	2.904761e+07	6818	4260.43	1
2013	22	2	2202091	2.448088e+07	5742	4263.48	1
2013	21	2	2100907	1.8900309e+08	44317	4264.8	1
2013	29	2	2903235	6.344644e+07	14855	4271.05	1
2013	22	2	2200103	2.17783e+07	5097	4272.77	1
2013	23	2	2300507	4.774189e+07	11171	4273.73	1
2013	29	2	2924702	5.421046e+07	12678	4275.95	1
2013	21	2	2102358	6.421446e+07	15008	4278.68	1
2013	29	2	2917409	6.577799e+07	15350	4285.21	1
2013	29	2	2921450	4.404083e+07	10270	4288.3	1
2013	21	2	2104602	7.003154e+07	16312	4293.25	1
2013	21	2	2107803	1.4553996e+08	33883	4295.37	1
2013	21	2	2102374	3.738808e+07	8698	4298.47	1
2013	21	2	2100477	1.3443361e+08	31253	4301.46	1
2013	22	2	2206902	2.804429e+07	6505	4311.19	1
2013	29	2	2904753	9.104417e+07	21115	4311.82	1
2013	22	2	2205409	6.057022e+07	14032	4316.58	1
2013	29	2	2924504	7.235698e+07	16708	4330.68	1
2013	22	2	2205458	2.276652e+07	5253	4334	1
2013	21	2	2111748	4.622209e+07	10657	4337.25	1
2013	23	2	2308906	9.361012e+07	21561	4341.64	1
2013	22	2	2205557	3.580775e+07	8245	4342.97	1
2013	23	2	2303303	8.183187e+07	18815	4349.29	1
2013	22	2	2208874	1.894471e+07	4354	4351.1	1
2013	22	2	2201606	4.361492e+07	10014	4355.39	1
2013	22	2	2201960	3.540154e+07	8116	4361.94	1
2013	26	2	2612109	4.39788e+07	10076	4364.71	1
2013	22	2	2210656	4.274497e+07	9777	4371.99	1
2013	29	2	2922656	5.779295e+07	13216	4372.95	1
2013	23	2	2308377	5.815492e+07	13259	4386.07	1
2013	21	2	2107456	6.101528e+07	13911	4386.12	1
2013	23	2	2305266	5.773709e+07	13155	4388.98	1
2013	23	2	2305654	5.050509e+07	11500	4391.75	1
2013	27	2	2702553	7.961337e+07	18123	4392.95	1
2013	22	2	2201101	4.983528e+07	11341	4394.26	1
2013	22	2	2206357	2.99807e+07	6797	4410.87	1
2013	21	2	2101970	3.80607e+07	8626	4412.32	1
2013	21	2	2100154	5.309773e+07	12028	4414.51	1
2013	29	2	2912400	8.13438e+07	18398	4421.34	1
2013	21	2	2111003	8.915735e+07	20152	4424.24	1
2013	22	2	2201051	3.386279e+07	7645	4429.4	1
2013	23	2	2311009	5.41302e+07	12203	4435.81	1
2013	29	2	2924108	3.305288e+07	7450	4436.63	1
2013	26	2	2609154	8.779645e+07	19788	4436.85	1
2013	22	2	2205573	2.915546e+07	6566	4440.37	1
2013	22	2	2205854	3.568432e+07	8034	4441.66	1
2013	29	2	2922805	3.583979e+07	8058	4447.73	1
2013	29	2	2904001	6.562461e+07	14742	4451.54	1
2013	23	2	2303931	5.875667e+07	13195	4452.95	1
2013	22	2	2205250	1.954949e+07	4389	4454.2	1
2013	23	2	2301257	4.780796e+07	10723	4458.45	1
2013	23	2	2313559	6.790612e+07	15224	4460.46	1
2013	21	2	2106672	3.676351e+07	8237	4463.22	1
2013	22	2	2203271	2.243824e+07	5027	4463.54	1
2013	21	2	2103158	5.539125e+07	12395	4468.84	1
2013	21	2	2105807	4.418719e+07	9873	4475.56	1
2013	29	2	2901601	8.391824e+07	18744	4477.07	1
2013	21	2	2106508	1.0086819e+08	22515	4480.04	1
2013	27	2	2701100	4.852182e+07	10823	4483.21	1
2013	21	2	2100105	2.780535e+07	6197	4486.9	1
2013	22	2	2204154	1.339455e+07	2984	4488.79	1
2013	21	2	2101301	7.710654e+07	17164	4492.34	1
2013	22	2	2201929	2.477667e+07	5512	4495.04	1
2013	22	2	2202406	5.023515e+07	11173	4496.12	1
2013	29	2	2923035	5.300781e+07	11786	4497.52	1
2013	21	2	2102606	8.738258e+07	19426	4498.23	1
2013	23	2	2308005	1.6586664e+08	36854	4500.64	1
2013	22	2	2204907	3.769603e+07	8368	4504.78	1
2013	29	2	2919900	3.799793e+07	8417	4514.43	1
2013	21	2	2106375	6.77982e+07	15011	4516.57	1
2013	22	2	2205540	1.238853e+07	2741	4519.71	1
2013	21	2	2111672	2.861429e+07	6329	4521.14	1
2013	26	2	2612554	6.320409e+07	13977	4522.01	1
2013	29	2	2913101	8.480405e+07	18752	4522.4	1
2013	29	2	2924405	1.5937512e+08	35237	4522.95	1
2013	21	2	2107902	8.239777e+07	18216	4523.37	1
2013	21	2	2103109	4.717844e+07	10414	4530.29	1
2013	23	2	2304707	2.4213954e+08	53435	4531.48	1
2013	22	2	2206670	3.000817e+07	6622	4531.59	1
2013	22	2	2211357	2.227911e+07	4910	4537.5	1
2013	22	2	2206753	2.131412e+07	4696	4538.78	1
2013	21	2	2107704	9.367739e+07	20636	4539.51	1
2013	29	2	2913002	7.559226e+07	16647	4540.89	1
2013	22	2	2209351	2.054915e+07	4522	4544.26	1
2013	23	2	2311900	7.19964e+07	15835	4546.66	1
2013	23	2	2301505	3.531903e+07	7766	4547.9	1
2013	21	2	2112456	1.100745e+08	24190	4550.41	1
2013	22	2	2210375	1.179132e+07	2591	4550.88	1
2013	23	2	2300101	5.046773e+07	11089	4551.15	1
2013	29	2	2901155	7.684224e+07	16884	4551.19	1
2013	22	2	2206704	3.322806e+07	7300	4551.79	1
2013	21	2	2106904	1.4666219e+08	32180	4557.56	1
2013	21	2	2109056	2.709465e+07	5943	4559.09	1
2013	21	2	2100303	1.148846e+08	25177	4563.08	1
2013	23	2	2313757	8.829735e+07	19349	4563.41	1
2013	29	2	2901502	5.075396e+07	11113	4567.08	1
2013	21	2	2112506	2.5458968e+08	55705	4570.32	1
2013	29	2	2912509	6.93028e+07	15162	4570.82	1
2013	22	2	2207504	6.441154e+07	14090	4571.44	1
2013	29	2	2929255	8.91274e+07	19495	4571.81	1
2013	21	2	2101103	5.356557e+07	11706	4575.91	1
2013	29	2	2931806	8.494369e+07	18560	4576.71	1
2013	22	2	2200053	3.153706e+07	6890	4577.22	1
2013	21	2	2111953	2.521546e+07	5498	4586.3	1
2013	29	2	2909000	4.015184e+07	8752	4587.73	1
2013	22	2	2200251	3.426076e+07	7467	4588.29	1
2013	29	2	2922052	5.594172e+07	12191	4588.77	1
2013	27	2	2706422	4.90219e+07	10674	4592.65	1
2013	21	2	2104651	4.650466e+07	10113	4598.5	1
2013	23	2	2300903	6.622782e+07	14397	4600.11	1
2013	29	2	2922102	1.2198711e+08	26518	4600.16	1
2013	21	2	2103604	2.9077611e+08	63154	4604.24	1
2013	22	2	2206209	1.5167334e+08	32900	4610.13	1
2013	29	2	2923308	4.05911e+07	8804	4610.53	1
2013	29	2	2924603	9.749736e+07	21113	4617.88	1
2013	22	2	2209559	2.016743e+07	4363	4622.38	1
2013	23	2	2312809	3.335647e+07	7210	4626.42	1
2013	22	2	2210904	2.094397e+07	4527	4626.46	1
2013	29	2	2924801	1.1317524e+08	24462	4626.57	1
2013	31	3	3165552	5.369325e+07	11592	4631.92	1
2013	26	2	2612901	6.903258e+07	14900	4633.06	1
2013	31	3	3126505	4.885145e+07	10542	4633.98	1
2013	22	2	2201945	2.937331e+07	6335	4636.67	1
2013	22	2	2204006	2.444322e+07	5270	4638.18	1
2013	23	2	2308203	6.66882e+07	14377	4638.53	1
2013	23	2	2310100	5.85788e+07	12624	4640.27	1
2013	29	2	2915007	7.426195e+07	15996	4642.53	1
2013	23	2	2304004	1.0518812e+08	22653	4643.45	1
2013	42	4	4212650	4.499318e+07	9687	4644.7	1
2013	21	2	2104503	4.862496e+07	10466	4645.99	1
2013	23	2	2303105	8.658077e+07	18629	4647.63	1
2013	29	2	2933059	6.811184e+07	14654	4648	1
2013	21	2	2110203	1.6143505e+08	34710	4650.97	1
2013	29	2	2900108	4.248546e+07	9132	4652.37	1
2013	29	2	2907103	1.3854352e+08	29768	4654.11	1
2013	23	2	2306504	9.033235e+07	19409	4654.15	1
2013	29	2	2921401	8.253883e+07	17714	4659.53	1
2013	21	2	2101806	2.567722e+07	5510	4660.11	1
2013	22	2	2209807	2.267862e+07	4866	4660.63	1
2013	22	2	2210409	8.464863e+07	18162	4660.76	1
2013	31	3	3143153	2.263482e+07	4855	4662.17	1
2013	22	2	2206506	3.516003e+07	7541	4662.52	1
2013	22	2	2208106	5.544676e+07	11884	4665.66	1
2013	13	1	1303106	1.5788274e+08	33829	4667.08	1
2013	21	2	2105609	7.354045e+07	15755	4667.75	1
2013	23	2	2306603	9.272012e+07	19861	4668.45	1
2013	23	2	2307908	4.995962e+07	10693	4672.18	1
2013	21	2	2109809	1.9208605e+08	41081	4675.79	1
2013	23	2	2300408	7.855735e+07	16784	4680.49	1
2013	21	2	2104404	8.228548e+07	17572	4682.76	1
2013	22	2	2202729	2.659245e+07	5677	4684.24	1
2013	29	2	2918506	7.432115e+07	15848	4689.62	1
2013	25	2	2509008	5.167024e+07	11007	4694.31	1
2013	29	2	2905909	1.3995329e+08	29812	4694.53	1
2013	22	2	2209856	2.117977e+07	4509	4697.22	1
2013	29	2	2903508	8.71285e+07	18539	4699.74	1
2013	29	2	2925931	4.721865e+07	10045	4700.71	1
2013	21	2	2106300	8.781861e+07	18680	4701.21	1
2013	21	2	2111250	3.52922e+07	7507	4701.24	1
2013	21	2	2102200	1.3028016e+08	27697	4703.76	1
2013	31	3	3116100	7.370421e+07	15638	4713.15	1
2013	22	2	2204204	4.206345e+07	8924	4713.52	1
2013	22	2	2208502	5.74642e+07	12188	4714.82	1
2013	23	2	2308500	2.05153e+08	43493	4716.92	1
2013	15	1	1501956	1.3936035e+08	29533	4718.8	1
2013	22	2	2201739	2.872505e+07	6086	4719.86	1
2013	22	2	2203420	2.026286e+07	4292	4721.08	1
2013	21	2	2104909	5.640162e+07	11939	4724.15	1
2013	29	2	2900207	8.973795e+07	18989	4725.79	1
2013	26	2	2612471	5.786883e+07	12240	4727.85	1
2013	23	2	2313708	3.623574e+07	7660	4730.51	1
2013	21	2	2100550	3.155647e+07	6669	4731.81	1
2013	22	2	2200277	2.465778e+07	5211	4731.87	1
2013	23	2	2310308	1.4903033e+08	31462	4736.84	1
2013	21	2	2106201	3.172932e+07	6697	4737.84	1
2013	23	2	2302305	1.5092692e+08	31804	4745.53	1
2013	23	2	2307635	9.02555e+07	19017	4746.04	1
2013	29	2	2901908	9.009297e+07	18976	4747.73	1
2013	29	2	2926806	7.326041e+07	15427	4748.84	1
2013	21	2	2107605	9.095848e+07	19133	4754.01	1
2013	29	2	2912608	2.452302e+07	5158	4754.37	1
2013	29	2	2900405	8.02144e+07	16871	4754.57	1
2013	21	2	2110104	1.1752485e+08	24706	4756.94	1
2013	29	2	2929800	6.017013e+07	12644	4758.79	1
2013	26	2	2612802	5.430872e+07	11411	4759.33	1
2013	27	2	2701803	4.171591e+07	8758	4763.18	1
2013	29	2	2922201	3.735784e+07	7825	4774.17	1
2013	23	2	2308807	4.007939e+07	8393	4775.34	1
2013	26	2	2601805	5.939275e+07	12433	4777.03	1
2013	26	2	2605608	1.0808664e+08	22610	4780.48	1
2013	29	2	2902658	5.995128e+07	12534	4783.09	1
2013	23	2	2310506	2.0401142e+08	42643	4784.17	1
2013	22	2	2202117	2.322373e+07	4851	4787.41	1
2013	29	2	2904100	1.0727763e+08	22389	4791.53	1
2013	29	2	2918605	3.710356e+07	7741	4793.12	1
2013	22	2	2209658	2.748357e+07	5728	4798.11	1
2013	23	2	2309003	6.881289e+07	14335	4800.34	1
2013	22	2	2205599	2.398904e+07	4995	4802.61	1
2013	29	2	2901304	7.078228e+07	14738	4802.71	1
2013	26	2	2607703	6.695418e+07	13932	4805.78	1
2013	29	2	2913309	3.01361e+07	6265	4810.23	1
2013	21	2	2111631	2.672356e+07	5554	4811.59	1
2013	29	2	2926905	5.790307e+07	12033	4812.02	1
2013	26	2	2603926	5.961431e+07	12387	4812.65	1
2013	29	2	2906402	4.401644e+07	9143	4814.22	1
2013	27	2	2703304	8.915155e+07	18516	4814.84	1
2013	22	2	2206100	5.135321e+07	10664	4815.57	1
2013	29	2	2924306	8.873846e+07	18421	4817.24	1
2013	31	3	3137007	8.566813e+07	17782	4817.69	1
2013	22	2	2207108	1.299822e+07	2698	4817.72	1
2013	15	1	1504505	1.2460248e+08	25860	4818.35	1
2013	22	2	2207777	2.999865e+07	6223	4820.61	1
2013	25	2	2515401	5.158976e+07	10701	4821.02	1
2013	22	2	2202703	1.3149068e+08	27274	4821.1	1
2013	22	2	2209971	3.686843e+07	7636	4828.24	1
2013	23	2	2312007	1.5033388e+08	31133	4828.76	1
2013	22	2	2202554	2.393829e+07	4951	4835.04	1
2013	22	2	2202778	3.634581e+07	7515	4836.43	1
2013	22	2	2209377	2.506272e+07	5182	4836.5	1
2013	29	2	2903003	7.104476e+07	14684	4838.24	1
2013	29	2	2921500	2.657111e+08	54884	4841.32	1
2013	24	2	2403509	5.216246e+07	10753	4850.97	1
2013	22	2	2206696	4.260213e+07	8781	4851.63	1
2013	22	2	2201002	2.274493e+07	4688	4851.73	1
2013	22	2	2201507	1.2721245e+08	26215	4852.66	1
2013	21	2	2105906	7.641972e+07	15742	4854.51	1
2013	21	2	2107001	4.458565e+07	9183	4855.24	1
2013	26	2	2604155	6.874808e+07	14159	4855.43	1
2013	21	2	2103174	9.897101e+07	20382	4855.8	1
2013	21	2	2100709	1.2790333e+08	26339	4856.04	1
2013	22	2	2207850	1.775152e+07	3655	4856.78	1
2013	22	2	2206803	4.090384e+07	8419	4858.52	1
2013	21	2	2101772	5.207761e+07	10717	4859.35	1
2013	29	2	2928505	5.069362e+07	10423	4863.63	1
2013	23	2	2309409	1.3654911e+08	28075	4863.73	1
2013	22	2	2204550	2.17266e+07	4464	4867.07	1
2013	26	2	2606903	5.889251e+07	12097	4868.36	1
2013	31	3	3135456	3.644096e+07	7479	4872.44	1
2013	22	2	2205003	5.510247e+07	11302	4875.46	1
2013	22	2	2203008	3.917587e+07	8033	4876.87	1
2013	23	2	2303204	1.308626e+08	26821	4879.11	1
2013	29	2	2907707	5.58854e+07	11444	4883.38	1
2013	22	2	2209872	2.812993e+07	5760	4883.67	1
2013	22	2	2202075	1.679557e+07	3438	4885.27	1
2013	22	2	2200707	4.623941e+07	9456	4889.95	1
2013	29	2	2906204	1.2720817e+08	26006	4891.49	1
2013	21	2	2111706	1.0499688e+08	21445	4896.1	1
2013	22	2	2209450	1.030331e+07	2102	4901.67	1
2013	22	2	2205524	2.686611e+07	5479	4903.47	1
2013	29	2	2906899	5.046787e+07	10292	4903.6	1
2013	29	2	2920304	4.38501e+07	8942	4903.84	1
2013	22	2	2210706	7.048492e+07	14372	4904.32	1
2013	29	2	2919157	1.3407984e+08	27338	4904.52	1
2013	27	2	2707206	7.065861e+07	14401	4906.51	1
2013	22	2	2201572	1.675576e+07	3413	4909.39	1
2013	29	2	2933406	4.666781e+07	9504	4910.33	1
2013	22	2	2210359	2.202653e+07	4483	4913.35	1
2013	21	2	2105963	6.238708e+07	12687	4917.4	1
2013	22	2	2211407	2.137625e+07	4346	4918.6	1
2013	23	2	2305902	1.8783952e+08	38159	4922.55	1
2013	29	2	2917003	1.8880107e+08	38330	4925.67	1
2013	23	2	2308609	8.366053e+07	16984	4925.84	1
2013	21	2	2111904	5.149835e+07	10454	4926.19	1
2013	29	2	2919801	2.4359744e+08	49436	4927.53	1
2013	27	2	2703809	1.1741827e+08	23813	4930.85	1
2013	26	2	2614808	1.1754318e+08	23833	4931.95	1
2013	21	2	2100600	1.9508269e+08	39544	4933.31	1
2013	21	2	2111029	7.696784e+07	15599	4934.15	1
2013	21	2	2104628	3.717515e+07	7532	4935.63	1
2013	22	2	2205953	4.011892e+07	8121	4940.15	1
2013	22	2	2209906	3.025454e+07	6122	4941.94	1
2013	23	2	2304905	5.272281e+07	10668	4942.15	1
2013	13	1	1303908	1.7280995e+08	34963	4942.65	1
2013	23	2	2313203	1.269125e+08	25675	4943.04	1
2013	29	2	2911659	4.640679e+07	9388	4943.2	1
2013	23	2	2313906	6.60123e+07	13348	4945.48	1
2013	22	2	2206951	1.659383e+07	3354	4947.47	1
2013	27	2	2706109	5.646161e+07	11409	4948.87	1
2013	22	2	2211704	2.155265e+07	4355	4948.94	1
2013	26	2	2605806	7.392368e+07	14932	4950.69	1
2013	29	2	2926400	1.7621087e+08	35586	4951.69	1
2013	23	2	2311264	1.0160122e+08	20505	4954.95	1
2013	22	2	2207900	1.8817939e+08	37968	4956.26	1
2013	13	1	1300409	1.3436437e+08	27110	4956.27	1
2013	26	2	2608701	7.980331e+07	16100	4956.73	1
2013	27	2	2702504	5.568796e+07	11234	4957.09	1
2013	31	3	3113008	1.1578096e+08	23340	4960.62	1
2013	22	2	2207553	1.944818e+07	3919	4962.54	1
2013	23	2	2310902	8.028376e+07	16169	4965.29	1
2013	29	2	2928307	4.654613e+07	9370	4967.57	1
2013	29	2	2923704	1.6040839e+08	32258	4972.67	1
2013	22	2	2200954	1.22297e+07	2459	4973.44	1
2013	22	2	2201770	3.243135e+07	6516	4977.19	1
2013	26	2	2601052	9.628052e+07	19333	4980.11	1
2013	27	2	2702355	1.1896931e+08	23885	4980.92	1
2013	13	1	1303601	1.047477e+08	20986	4991.31	1
2013	29	2	2904803	5.405636e+07	10828	4992.28	1
2013	29	2	2910859	8.793935e+07	17603	4995.7	1
2013	29	2	2925600	7.31122e+07	14629	4997.76	1
2013	22	2	2205359	1.486022e+07	2971	5001.76	1
2013	22	2	2210953	1.414379e+07	2826	5004.88	1
2013	22	2	2202851	2.299677e+07	4594	5005.83	1
2013	21	2	2108702	1.0771405e+08	21512	5007.16	1
2013	22	2	2204808	4.774328e+07	9534	5007.69	1
2013	29	2	2906105	5.073897e+07	10130	5008.78	1
2013	29	2	2921609	4.504013e+07	8987	5011.7	1
2013	23	2	2307502	1.5766815e+08	31435	5015.69	1
2013	29	2	2931103	4.26906e+07	8510	5016.52	1
2013	21	2	2109759	3.728259e+07	7426	5020.55	1
2013	29	2	2930204	2.0450393e+08	40720	5022.2	1
2013	21	2	2105351	7.073597e+07	14084	5022.43	1
2013	21	2	2107308	2.310982e+07	4599	5024.97	1
2013	22	2	2209500	1.863174e+07	3706	5027.45	1
2013	29	2	2929701	1.0153081e+08	20195	5027.52	1
2013	22	2	2210300	2.896922e+07	5761	5028.51	1
2013	23	2	2302909	8.79224e+07	17470	5032.76	1
2013	29	2	2924900	4.789202e+07	9516	5032.79	1
2013	22	2	2205532	2.328332e+07	4623	5036.41	1
2013	25	2	2514107	2.237243e+07	4442	5036.57	1
2013	22	2	2210391	1.508745e+07	2995	5037.55	1
2013	22	2	2202505	5.30314e+07	10527	5037.66	1
2013	22	2	2207355	1.744124e+07	3460	5040.82	1
2013	23	2	2304350	1.1594406e+08	22998	5041.48	1
2013	21	2	2100956	1.6067763e+08	31867	5042.13	1
2013	23	2	2314102	2.9107928e+08	57719	5043.04	1
2013	25	2	2506707	5.880748e+07	11659	5043.96	1
2013	21	2	2103703	1.5722639e+08	31149	5047.56	1
2013	22	2	2209005	3.197021e+07	6327	5052.98	1
2013	29	2	2931509	1.1587225e+08	22873	5065.9	1
2013	23	2	2301802	3.124033e+07	6165	5067.37	1
2013	22	2	2208650	4.430437e+07	8743	5067.41	1
2013	23	2	2304269	4.744345e+07	9360	5068.74	1
2013	21	2	2105203	5.797923e+07	11431	5072.1	1
2013	15	1	1502806	1.5692589e+08	30915	5076.04	1
2013	29	2	2930907	6.593817e+07	12990	5076.07	1
2013	31	3	3139250	3.326922e+07	6554	5076.17	1
2013	26	2	2602605	2.4372204e+08	47972	5080.51	1
2013	22	2	2202109	2.788936e+07	5489	5080.95	1
2013	31	3	3145356	5.45701e+07	10738	5081.96	1
2013	23	2	2304277	3.578459e+07	7041	5082.32	1
2013	22	2	2208601	1.580202e+07	3109	5082.67	1
2013	29	2	2921807	6.314009e+07	12421	5083.33	1
2013	21	2	2107506	5.7755407e+08	113378	5094.06	1
2013	23	2	2305332	6.058324e+07	11890	5095.31	1
2013	25	2	2500502	7.185398e+07	14088	5100.37	1
2013	23	2	2303907	6.56528e+07	12865	5103.21	1
2013	29	2	2902708	2.7237627e+08	53361	5104.41	1
2013	21	2	2104701	3.141727e+07	6151	5107.67	1
2013	22	2	2204600	1.945574e+07	3809	5107.83	1
2013	29	2	2914109	5.106064e+07	9992	5110.15	1
2013	23	2	2311231	3.210048e+07	6278	5113.17	1
2013	25	2	2514602	1.744417e+07	3411	5114.09	1
2013	21	2	2103752	6.472041e+07	12646	5117.86	1
2013	31	3	3130051	5.840216e+07	11411	5118.06	1
2013	22	2	2203800	2.251118e+07	4396	5120.83	1
2013	26	2	2603207	1.422079e+08	27766	5121.66	1
2013	21	2	2109239	3.420821e+07	6674	5125.59	1
2013	29	2	2930402	8.033227e+07	15672	5125.85	1
2013	15	1	1503507	1.6219144e+08	31634	5127.12	1
2013	23	2	2305209	1.0194396e+08	19882	5127.45	1
2013	21	2	2106326	1.0402306e+08	20268	5132.38	1
2013	29	2	2906808	1.7990755e+08	35029	5135.96	1
2013	29	2	2930600	6.798998e+07	13238	5135.97	1
2013	31	3	3138658	4.534155e+07	8821	5140.18	1
2013	26	2	2602001	1.891193e+08	36783	5141.49	1
2013	29	2	2920106	1.0383715e+08	20194	5141.98	1
2013	31	3	3157658	3.244369e+07	6309	5142.45	1
2013	26	2	2601300	6.962617e+07	13523	5148.72	1
2013	22	2	2206720	4.270334e+07	8289	5151.81	1
2013	26	2	2600807	1.1796772e+08	22853	5162.02	1
2013	21	2	2111508	2.07011e+08	40095	5163.01	1
2013	29	2	2914307	5.89366e+07	11412	5164.44	1
2013	25	2	2503555	3.634912e+07	7035	5166.9	1
2013	29	2	2932408	7.461135e+07	14436	5168.42	1
2013	27	2	2700102	1.0627279e+08	20545	5172.68	1
2013	26	2	2600401	1.8103873e+08	34978	5175.79	1
2013	27	2	2709202	1.4234865e+08	27488	5178.57	1
2013	26	2	2610202	1.3734638e+08	26515	5179.95	1
2013	23	2	2303402	8.952627e+07	17282	5180.32	1
2013	29	2	2904506	5.856771e+07	11301	5182.52	1
2013	29	2	2919603	6.13516e+07	11835	5183.91	1
2013	15	1	1506195	2.2997362e+08	44349	5185.54	1
2013	21	2	2106409	8.272436e+07	15951	5186.15	1
2013	22	2	2204105	2.279888e+07	4392	5191	1
2013	13	1	1303700	1.2628647e+08	24327	5191.21	1
2013	23	2	2310803	8.344707e+07	16063	5194.99	1
2013	29	2	2905305	9.613707e+07	18489	5199.69	1
2013	29	2	2906600	7.554123e+07	14527	5200.06	1
2013	22	2	2205565	2.375889e+07	4568	5201.16	1
2013	29	2	2923407	1.1577845e+08	22260	5201.19	1
2013	29	2	2903607	8.185148e+07	15737	5201.21	1
2013	31	3	3129657	3.253368e+07	6250	5205.39	1
2013	22	2	2208205	9.360042e+07	17979	5206.1	1
2013	13	1	1303809	2.1645726e+08	41575	5206.43	1
2013	24	2	2412302	6.699338e+07	12856	5211.06	1
2013	31	3	3145307	1.6535803e+08	31715	5213.87	1
2013	26	2	2615805	1.3498836e+08	25882	5215.53	1
2013	21	2	2111805	9.102205e+07	17449	5216.46	1
2013	29	2	2903706	7.905006e+07	15141	5220.93	1
2013	23	2	2300606	3.758483e+07	7196	5223.02	1
2013	25	2	2514552	2.130467e+07	4077	5225.57	1
2013	21	2	2108454	1.1569756e+08	22123	5229.74	1
2013	21	2	2112274	2.972772e+07	5681	5232.83	1
2013	29	2	2910305	4.409492e+07	8426	5233.2	1
2013	29	2	2907608	9.452418e+07	18061	5233.61	1
2013	29	2	2905503	7.050648e+07	13465	5236.28	1
2013	15	1	1506302	1.1311119e+08	21592	5238.57	1
2013	15	1	1502608	6.081287e+07	11600	5242.49	1
2013	29	2	2907905	8.839954e+07	16860	5243.15	1
2013	22	2	2201919	2.856138e+07	5447	5243.51	1
2013	29	2	2932309	1.4344728e+08	27312	5252.17	1
2013	29	2	2927903	5.719605e+07	10884	5255.06	1
2013	29	2	2913507	1.4513609e+08	27615	5255.7	1
2013	21	2	2112852	6.497272e+07	12352	5260.1	1
2013	24	2	2405306	5.078772e+07	9651	5262.43	1
2013	22	2	2201309	1.725276e+07	3278	5263.2	1
2013	27	2	2706604	4.044911e+07	7685	5263.39	1
2013	26	2	2607000	1.1057805e+08	21003	5264.87	1
2013	22	2	2206001	2.362317e+07	4484	5268.33	1
2013	24	2	2413300	3.108042e+07	5896	5271.44	1
2013	26	2	2612703	7.18416e+07	13626	5272.39	1
2013	31	3	3144656	5.39445e+07	10219	5278.84	1
2013	23	2	2302057	7.800643e+07	14771	5281.05	1
2013	23	2	2307205	4.104073e+07	7764	5286.03	1
2013	25	2	2516409	5.638039e+07	10665	5286.49	1
2013	29	2	2924207	9.545606e+07	18051	5288.13	1
2013	21	2	2112308	2.1305176e+08	40273	5290.19	1
2013	13	1	1302801	9.688019e+07	18310	5291.11	1
2013	21	2	2105708	2.5407659e+08	48002	5293.04	1
2013	21	2	2103554	8.113061e+07	15313	5298.15	1
2013	25	2	2514305	3.27373e+07	6179	5298.15	1
2013	15	1	1501105	1.4132875e+08	26666	5299.96	1
2013	22	2	2211506	1.601759e+07	3020	5303.84	1
2013	22	2	2202737	2.069742e+07	3901	5305.67	1
2013	24	2	2402105	5.775927e+07	10879	5309.24	1
2013	25	2	2508505	3.887805e+07	7320	5311.21	1
2013	29	2	2925907	1.5417162e+08	28996	5317	1
2013	22	2	2200509	9.199403e+07	17298	5318.19	1
2013	26	2	2606705	4.102799e+07	7714	5318.64	1
2013	26	2	2601508	6.266568e+07	11777	5321.02	1
2013	21	2	2103406	2.5451485e+08	47821	5322.24	1
2013	22	2	2210201	3.523995e+07	6621	5322.45	1
2013	26	2	2616506	7.724616e+07	14513	5322.55	1
2013	25	2	2503506	9.123638e+07	17141	5322.7	1
2013	21	2	2109601	2.1814134e+08	40983	5322.73	1
2013	26	2	2616100	5.010863e+07	9408	5326.17	1
2013	29	2	2906857	6.461785e+07	12128	5327.99	1
2013	23	2	2302404	2.8569297e+08	53608	5329.3	1
2013	22	2	2209302	3.019618e+07	5666	5329.36	1
2013	23	2	2301208	1.3852076e+08	25988	5330.18	1
2013	23	2	2304236	9.368379e+07	17569	5332.33	1
2013	15	1	1507466	2.990613e+07	5608	5332.76	1
2013	29	2	2908705	9.790964e+07	18359	5333.06	1
2013	15	1	1503101	1.6391303e+08	30727	5334.5	1
2013	23	2	2309904	3.271153e+07	6131	5335.43	1
2013	29	2	2928950	5.240731e+07	9820	5336.79	1
2013	26	2	2615201	5.294759e+07	9916	5339.61	1
2013	29	2	2933109	4.972077e+07	9309	5341.15	1
2013	26	2	2608404	8.040946e+07	15050	5342.82	1
2013	29	2	2902104	2.9750779e+08	55655	5345.57	1
2013	23	2	2304251	1.2480617e+08	23344	5346.39	1
2013	27	2	2706406	1.3361912e+08	24975	5350.11	1
2013	31	3	3170529	8.006237e+07	14963	5350.69	1
2013	23	2	2303808	1.3356314e+08	24958	5351.52	1
2013	22	2	2201804	2.368253e+07	4425	5351.98	1
2013	27	2	2705408	3.866575e+07	7219	5356.11	1
2013	22	2	2205151	3.058663e+07	5710	5356.68	1
2013	29	2	2929370	5.865816e+07	10938	5362.79	1
2013	29	2	2902609	1.1355391e+08	21174	5362.89	1
2013	29	2	2925253	8.756039e+07	16321	5364.89	1
2013	29	2	2906709	1.4516827e+08	27057	5365.28	1
2013	29	2	2930006	6.083112e+07	11336	5366.19	1
2013	27	2	2705002	1.3608958e+08	25349	5368.64	1
2013	23	2	2304954	1.3590293e+08	25310	5369.53	1
2013	23	2	2312106	9.36776e+07	17445	5369.88	1
2013	22	2	2202133	3.086093e+07	5746	5370.85	1
2013	27	2	2706000	6.232281e+07	11594	5375.44	1
2013	22	2	2206654	2.194567e+07	4082	5376.21	1
2013	23	2	2306108	1.2474816e+08	23202	5376.61	1
2013	25	2	2514800	2.016027e+07	3749	5377.51	1
2013	22	2	2202455	2.138196e+07	3975	5379.11	1
2013	26	2	2602704	6.959188e+07	12934	5380.54	1
2013	29	2	2909208	9.381234e+07	17422	5384.71	1
2013	23	2	2313252	4.819267e+07	8949	5385.26	1
2013	23	2	2304806	2.461989e+07	4569	5388.46	1
2013	29	2	2926509	8.184141e+07	15186	5389.27	1
2013	22	2	2210508	7.498946e+07	13913	5389.88	1
2013	31	3	3108255	5.60615e+07	10395	5393.12	1
2013	25	2	2513000	2.023753e+07	3752	5393.8	1
2013	31	3	3146552	3.310256e+07	6137	5393.93	1
2013	31	3	3122454	5.308251e+07	9838	5395.66	1
2013	31	3	3164506	5.799728e+07	10740	5400.12	1
2013	29	2	2927606	8.31207e+07	15381	5404.12	1
2013	25	2	2502102	3.031226e+07	5608	5405.18	1
2013	31	3	3117836	4.03661e+07	7464	5408.11	1
2013	21	2	2101707	3.1700221e+08	58599	5409.69	1
2013	26	2	2608206	8.691999e+07	16056	5413.55	1
2013	15	1	1501600	7.952676e+07	14689	5414.03	1
2013	26	2	2602803	2.9932258e+08	55268	5415.84	1
2013	29	2	2928406	1.5354154e+08	28349	5416.12	1
2013	27	2	2707503	1.0879399e+08	20066	5421.81	1
2013	23	2	2307106	1.4676694e+08	27067	5422.36	1
2013	26	2	2615102	3.792094e+07	6991	5424.25	1
2013	22	2	2204709	8.147787e+07	15017	5425.71	1
2013	22	2	2209153	2.11225e+07	3893	5425.76	1
2013	23	2	2311108	8.19737e+07	15108	5425.85	1
2013	29	2	2924678	5.654545e+07	10415	5429.23	1
2013	26	2	2609204	6.521592e+07	12009	5430.59	1
2013	26	2	2612455	7.87692e+07	14487	5437.23	1
2013	15	1	1505700	1.5243594e+08	28025	5439.28	1
2013	23	2	2304301	1.0344553e+08	19015	5440.21	1
2013	29	2	2923357	9.578135e+07	17603	5441.19	1
2013	22	2	2205516	2.627401e+07	4828	5442.01	1
2013	25	2	2505402	4.465044e+07	8196	5447.83	1
2013	26	2	2611533	3.730203e+07	6846	5448.73	1
2013	22	2	2200905	3.153569e+07	5784	5452.23	1
2013	23	2	2301950	1.1113595e+08	20371	5455.6	1
2013	25	2	2508000	5.412916e+07	9919	5457.12	1
2013	26	2	2603702	1.3609767e+08	24918	5461.82	1
2013	22	2	2205805	1.3667175e+08	25005	5465.78	1
2013	29	2	2922706	9.299173e+07	17013	5465.92	1
2013	29	2	2922904	1.4063377e+08	25725	5466.81	1
2013	23	2	2300309	2.8793678e+08	52661	5467.74	1
2013	13	1	1301100	1.9380161e+08	35431	5469.83	1
2013	31	3	3127073	3.238136e+07	5919	5470.75	1
2013	25	2	2509156	3.514478e+07	6423	5471.71	1
2013	15	1	1501006	8.733182e+07	15959	5472.26	1
2013	21	2	2102002	2.1967199e+08	40134	5473.46	1
2013	31	3	3160454	3.961759e+07	7236	5475.07	1
2013	25	2	2500908	7.203609e+07	13157	5475.12	1
2013	15	1	1506351	1.0260473e+08	18736	5476.34	1
2013	31	3	3156502	4.068424e+07	7428	5477.15	1
2013	29	2	2902005	7.799042e+07	14232	5479.93	1
2013	26	2	2608602	6.955544e+07	12685	5483.28	1
2013	13	1	1304401	1.1016621e+08	20091	5483.36	1
2013	13	1	1304237	9.962725e+07	18162	5485.48	1
2013	27	2	2701407	3.0264215e+08	55161	5486.52	1
2013	22	2	2210383	1.318757e+07	2403	5487.96	1
2013	22	2	2202539	3.11672e+07	5676	5491.05	1
2013	26	2	2606507	1.0385354e+08	18913	5491.12	1
2013	25	2	2506251	4.649249e+07	8466	5491.67	1
2013	31	3	3140555	4.558389e+07	8299	5492.7	1
2013	22	2	2201176	2.135063e+07	3886	5494.24	1
2013	23	2	2305704	6.734553e+07	12256	5494.9	1
2013	22	2	2201556	2.134418e+07	3882	5498.24	1
2013	23	2	2302008	1.2156653e+08	22104	5499.75	1
2013	29	2	2932002	1.3906052e+08	25274	5502.12	1
2013	23	2	2308104	2.5136275e+08	45640	5507.51	1
2013	31	3	3143450	4.351539e+07	7901	5507.58	1
2013	22	2	2207207	3.711469e+07	6735	5510.72	1
2013	31	3	3146750	3.681867e+07	6674	5516.73	1
2013	13	1	1300904	8.142667e+07	14754	5518.96	1
2013	22	2	2202752	3.443137e+07	6238	5519.62	1
2013	27	2	2702900	2.1908573e+08	39657	5524.52	1
2013	29	2	2901205	1.1437345e+08	20698	5525.82	1
2013	29	2	2924652	5.968289e+07	10798	5527.22	1
2013	26	2	2602506	4.125784e+07	7464	5527.58	1
2013	29	2	2920403	8.073141e+07	14600	5529.55	1
2013	21	2	2112902	1.7592823e+08	31793	5533.55	1
2013	15	1	1506112	7.111646e+07	12838	5539.53	1
2013	22	2	2202802	2.508377e+07	4528	5539.7	1
2013	26	2	2610301	6.315119e+07	11399	5540.06	1
2013	29	2	2919405	7.181101e+07	12962	5540.12	1
2013	13	1	1303205	9.262607e+07	16719	5540.17	1
2013	31	3	3160306	6.676869e+07	12042	5544.65	1
2013	25	2	2516607	8.02287e+07	14467	5545.64	1
2013	31	3	3141702	3.377023e+07	6084	5550.66	1
2013	25	2	2500106	5.492617e+07	9893	5552.02	1
2013	22	2	2204659	5.072399e+07	9136	5552.1	1
2013	27	2	2706208	2.739878e+07	4934	5553.06	1
2013	21	2	2112803	2.8149092e+08	50687	5553.51	1
2013	22	2	2201200	2.5431051e+08	45786	5554.33	1
2013	25	2	2501302	1.0698046e+08	19259	5554.83	1
2013	21	2	2107407	1.0518138e+08	18934	5555.16	1
2013	26	2	2608008	9.267025e+07	16679	5556.1	1
2013	22	2	2207603	5.833117e+07	10494	5558.53	1
2013	27	2	2709004	3.543037e+07	6374	5558.58	1
2013	27	2	2701902	4.121461e+07	7413	5559.77	1
2013	29	2	2923100	1.4802165e+08	26620	5560.54	1
2013	26	2	2602209	2.158909e+08	38816	5561.9	1
2013	29	2	2917102	1.1744806e+08	21106	5564.68	1
2013	13	1	1300300	1.9796118e+08	35554	5567.9	1
2013	24	2	2413102	3.330969e+07	5980	5570.18	1
2013	29	2	2924058	8.066144e+07	14478	5571.31	1
2013	23	2	2301703	1.3770965e+08	24716	5571.68	1
2013	22	2	2209104	3.405369e+07	6110	5573.44	1
2013	24	2	2410108	8.275727e+07	14845	5574.76	1
2013	13	1	1300201	9.574267e+07	17174	5574.86	1
2013	29	2	2906824	9.462787e+07	16956	5580.79	1
2013	21	2	2106706	1.1483207e+08	20576	5580.87	1
2013	29	2	2914208	4.169818e+07	7471	5581.34	1
2013	31	3	3116308	3.791524e+07	6793	5581.52	1
2013	15	1	1508209	2.7943541e+08	50055	5582.57	1
2013	26	2	2614006	1.0581335e+08	18951	5583.52	1
2013	25	2	2508109	2.630465e+07	4710	5584.85	1
2013	27	2	2704203	1.5775771e+08	28244	5585.53	1
2013	25	2	2510204	3.387627e+07	6058	5591.99	1
2013	21	2	2107357	1.1164299e+08	19963	5592.5	1
2013	21	2	2108108	1.1472455e+08	20514	5592.5	1
2013	29	2	2904852	1.0466355e+08	18713	5593.09	1
2013	23	2	2314003	2.2187735e+08	39651	5595.76	1
2013	21	2	2108504	1.7834122e+08	31866	5596.6	1
2013	22	2	2208700	4.788776e+07	8556	5596.98	1
2013	25	2	2501575	4.651317e+07	8305	5600.62	1
2013	29	2	2913408	9.050176e+07	16159	5600.7	1
2013	21	2	2105948	4.917949e+07	8775	5604.5	1
2013	31	3	3146305	1.1069102e+08	19744	5606.31	1
2013	27	2	2704609	5.701275e+07	10168	5607.08	1
2013	13	1	1304062	3.2717703e+08	58314	5610.61	1
2013	29	2	2904209	6.266961e+07	11162	5614.55	1
2013	25	2	2510402	3.818107e+07	6790	5623.13	1
2013	25	2	2505709	5.925829e+07	10535	5624.9	1
2013	27	2	2708204	3.941669e+07	7006	5626.13	1
2013	29	2	2918209	8.404054e+07	14936	5626.71	1
2013	21	2	2102325	3.8628055e+08	68626	5628.78	1
2013	29	2	2911907	1.4973957e+08	26591	5631.21	1
2013	24	2	2400901	4.038959e+07	7172	5631.57	1
2013	22	2	2209609	1.659623e+07	2945	5635.39	1
2013	23	2	2308302	1.605519e+08	28487	5635.97	1
2013	31	3	3142254	2.689702e+07	4772	5636.42	1
2013	21	2	2102903	1.2870218e+08	22811	5642.11	1
2013	13	1	1303502	1.080439e+08	19149	5642.27	1
2013	22	2	2208809	9.985947e+07	17696	5643.05	1
2013	27	2	2705903	2.912512e+07	5159	5645.5	1
2013	25	2	2517209	2.952937e+07	5228	5648.31	1
2013	22	2	2209708	3.579369e+07	6335	5650.15	1
2013	25	2	2514206	4.33836e+07	7674	5653.32	1
2013	26	2	2610509	1.6444116e+08	29082	5654.4	1
2013	21	2	2106003	6.54791e+07	11580	5654.5	1
2013	27	2	2705804	5.153909e+07	9114	5654.94	1
2013	15	1	1507474	1.2185705e+08	21536	5658.3	1
2013	29	2	2925808	1.4725332e+08	26023	5658.58	1
2013	26	2	2613305	1.192877e+08	21079	5659.08	1
2013	21	2	2102556	7.819637e+07	13808	5663.12	1
2013	31	3	3166956	2.633487e+07	4650	5663.41	1
2013	31	3	3132305	7.026071e+07	12403	5664.82	1
2013	29	2	2909604	1.2144394e+08	21435	5665.68	1
2013	22	2	2208858	2.413561e+07	4259	5666.97	1
2013	21	2	2105989	4.0869e+07	7211	5667.59	1
2013	21	2	2104099	1.0254291e+08	18087	5669.43	1
2013	29	2	2909703	8.046303e+07	14189	5670.8	1
2013	24	2	2407005	5.697807e+07	10042	5673.98	1
2013	15	1	1506401	5.08387e+07	8957	5675.86	1
2013	15	1	1507904	1.3544599e+08	23861	5676.46	1
2013	25	2	2515104	6.528165e+07	11495	5679.13	1
2013	23	2	2301406	6.521901e+07	11482	5680.11	1
2013	23	2	2313005	1.0240522e+08	18025	5681.29	1
2013	29	2	2926707	7.722246e+07	13592	5681.46	1
2013	22	2	2203503	8.237869e+07	14496	5682.86	1
2013	26	2	2605905	1.677541e+08	29515	5683.69	1
2013	26	2	2611507	1.4341055e+08	25220	5686.38	1
2013	24	2	2403301	3.137418e+07	5515	5688.88	1
2013	22	2	2202711	2.617684e+07	4601	5689.38	1
2013	29	2	2923209	1.2937101e+08	22738	5689.64	1
2013	29	2	2930758	7.505616e+07	13188	5691.25	1
2013	21	2	2108900	1.0607239e+08	18633	5692.72	1
2013	25	2	2509503	3.050057e+07	5351	5699.98	1
2013	29	2	2923605	1.244845e+08	21838	5700.36	1
2013	25	2	2505204	3.930727e+07	6895	5700.84	1
2013	31	3	3162401	1.4805632e+08	25961	5703.03	1
2013	29	2	2902203	6.362942e+07	11157	5703.09	1
2013	23	2	2308351	7.532184e+07	13207	5703.18	1
2013	21	2	2113009	1.7657172e+08	30959	5703.41	1
2013	29	2	2916609	6.159186e+07	10799	5703.48	1
2013	26	2	2614402	3.376793e+07	5918	5705.97	1
2013	25	2	2512408	7.642694e+07	13386	5709.47	1
2013	22	2	2210102	2.117894e+07	3707	5713.23	1
2013	22	2	2202251	2.239934e+07	3920	5714.12	1
2013	27	2	2707107	1.4044669e+08	24556	5719.45	1
2013	29	2	2931301	9.921548e+07	17345	5720.12	1
2013	31	3	3147956	3.346765e+07	5846	5724.88	1
2013	24	2	2407708	6.671546e+07	11644	5729.6	1
2013	31	3	3170008	7.020408e+07	12248	5731.88	1
2013	31	3	3149150	6.288791e+07	10970	5732.72	1
2013	23	2	2304608	3.779312e+07	6591	5734.05	1
2013	23	2	2301307	1.2140274e+08	21170	5734.66	1
2013	25	2	2509602	2.6885e+07	4688	5734.86	1
2013	13	1	1300060	5.986148e+07	10436	5736.06	1
2013	21	2	2104206	8.726887e+07	15212	5736.84	1
2013	26	2	2604403	7.462849e+07	13002	5739.77	1
2013	15	1	1504406	1.5619425e+08	27153	5752.38	1
2013	25	2	2512804	4.898732e+07	8513	5754.41	1
2013	25	2	2511806	6.057002e+07	10523	5755.96	1
2013	23	2	2307403	1.4020524e+08	24351	5757.68	1
2013	25	2	2500536	3.108552e+07	5398	5758.71	1
2013	15	1	1501808	5.5539675e+08	96444	5758.75	1
2013	22	2	2205276	2.731478e+07	4743	5758.97	1
2013	22	2	2203859	1.446415e+07	2511	5760.31	1
2013	31	3	3138682	3.838601e+07	6660	5763.67	1
2013	25	2	2507606	4.464617e+07	7742	5766.75	1
2013	25	2	2516805	5.427749e+07	9410	5768.06	1
2013	27	2	2704104	1.0709149e+08	18566	5768.15	1
2013	31	3	3166501	2.511045e+07	4353	5768.54	1
2013	15	1	1506559	1.1223254e+08	19455	5768.83	1
2013	25	2	2506608	3.477666e+07	6027	5770.14	1
2013	23	2	2306207	4.3681e+07	7567	5772.56	1
2013	26	2	2607950	6.753349e+07	11696	5774.07	1
2013	29	2	2928059	7.91781e+07	13710	5775.21	1
2013	21	2	2104073	4.772596e+07	8263	5775.86	1
2013	29	2	2911857	7.978312e+07	13812	5776.36	1
2013	29	2	2907202	4.0943465e+08	70796	5783.3	1
2013	26	2	2600500	2.4296325e+08	42008	5783.74	1
2013	29	2	2933604	2.7819823e+08	48100	5783.75	1
2013	22	2	2207306	2.358366e+07	4077	5784.56	1
2013	29	2	2905107	6.03278e+07	10429	5784.62	1
2013	27	2	2701506	5.572901e+07	9631	5786.42	1
2013	21	2	2110856	6.383681e+07	11027	5789.14	1
2013	23	2	2309102	7.061256e+07	12196	5789.81	1
2013	23	2	2310001	5.28394e+07	9126	5789.99	1
2013	22	2	2202000	1.1215556e+08	19352	5795.55	1
2013	22	2	2211100	2.5162104e+08	43403	5797.32	1
2013	15	1	1502103	7.3875524e+08	127401	5798.66	1
2013	24	2	2405405	3.183639e+07	5490	5798.98	1
2013	25	2	2509396	3.646984e+07	6283	5804.53	1
2013	23	2	2311959	9.276658e+07	15976	5806.62	1
2013	15	1	1500701	1.5423716e+08	26547	5809.97	1
2013	25	2	2511509	6.75765e+07	11620	5815.53	1
2013	22	2	2205904	3.060283e+07	5260	5818.03	1
2013	26	2	2604700	1.0376332e+08	17830	5819.59	1
2013	29	2	2926004	2.434922e+08	41824	5821.83	1
2013	26	2	2604908	8.625151e+07	14815	5821.9	1
2013	31	3	3127057	2.781293e+07	4777	5822.26	1
2013	25	2	2508703	2.355948e+07	4044	5825.79	1
2013	24	2	2413706	3.107471e+07	5333	5826.87	1
2013	27	2	2707602	6.820783e+07	11700	5829.73	1
2013	22	2	2202653	3.039124e+07	5213	5829.89	1
2013	23	2	2303956	1.1190922e+08	19187	5832.55	1
2013	21	2	2101608	4.9595696e+08	85022	5833.28	1
2013	26	2	2604304	6.609688e+07	11323	5837.4	1
2013	31	3	3146206	3.589865e+07	6148	5839.08	1
2013	21	2	2105500	1.3692734e+08	23450	5839.12	1
2013	21	2	2111532	7.177097e+07	12287	5841.21	1
2013	21	2	2101004	1.6937876e+08	28986	5843.47	1
2013	23	2	2308401	2.0497157e+08	35056	5846.98	1
2013	25	2	2513208	3.844865e+07	6573	5849.48	1
2013	23	2	2300804	4.19679e+07	7172	5851.63	1
2013	15	1	1507961	6.333462e+07	10822	5852.4	1
2013	29	2	2902302	5.35286e+07	9146	5852.68	1
2013	29	2	2903805	1.1058478e+08	18888	5854.76	1
2013	26	2	2605301	1.8786789e+08	32076	5856.96	1
2013	22	2	2210938	3.781887e+07	6457	5857.03	1
2013	24	2	2400307	6.556903e+07	11191	5859.09	1
2013	31	3	3150570	4.389367e+07	7491	5859.52	1
2013	29	2	2909109	8.805564e+07	15024	5861	1
2013	24	2	2409704	4.211822e+07	7186	5861.15	1
2013	25	2	2509370	1.653691e+07	2821	5862.07	1
2013	21	2	2102754	6.300522e+07	10729	5872.42	1
2013	29	2	2912004	6.383972e+07	10866	5875.18	1
2013	21	2	2104008	1.0260044e+08	17460	5876.31	1
2013	24	2	2407252	2.236111e+07	3805	5876.77	1
2013	31	3	3162658	2.513039e+07	4276	5877.08	1
2013	25	2	2501203	4.009384e+07	6819	5879.72	1
2013	25	2	2510006	4.317034e+07	7342	5879.92	1
2013	25	2	2514453	3.388192e+07	5762	5880.24	1
2013	25	2	2517001	5.799525e+07	9862	5880.68	1
2013	22	2	2207934	1.449086e+07	2463	5883.42	1
2013	24	2	2410306	5.598429e+07	9515	5883.79	1
2013	29	2	2929354	3.649366e+07	6202	5884.18	1
2013	31	3	3155108	3.138805e+07	5333	5885.63	1
2013	29	2	2909505	3.144185e+07	5341	5886.88	1
2013	29	2	2907806	2.0270724e+08	34424	5888.54	1
2013	25	2	2505352	3.028232e+07	5142	5889.21	1
2013	29	2	2930154	1.9477226e+08	33034	5896.11	1
2013	26	2	2611200	6.642329e+07	11261	5898.53	1
2013	29	2	2932804	1.1514478e+08	19516	5900.02	1
2013	23	2	2312601	7.482014e+07	12663	5908.56	1
2013	25	2	2502300	2.980342e+07	5044	5908.69	1
2013	24	2	2413557	2.809487e+07	4752	5912.22	1
2013	26	2	2612307	9.2905e+07	15702	5916.76	1
2013	27	2	2702801	7.612913e+07	12862	5918.92	1
2013	31	3	3131158	1.0494993e+08	17729	5919.68	1
2013	15	1	1504307	1.6950893e+08	28631	5920.47	1
2013	25	2	2501005	1.1635846e+08	19653	5920.65	1
2013	24	2	2403202	4.251087e+07	7178	5922.38	1
2013	31	3	3136009	9.171253e+07	15483	5923.43	1
2013	29	2	2911501	4.934038e+07	8325	5926.77	1
2013	24	2	2407302	5.047134e+07	8506	5933.62	1
2013	22	2	2201988	2.224593e+07	3749	5933.83	1
2013	25	2	2513109	7.209115e+07	12144	5936.36	1
2013	24	2	2406205	3.91065e+07	6587	5936.92	1
2013	22	2	2203701	2.2921378e+08	38607	5937.1	1
2013	31	3	3128204	6.247706e+07	10521	5938.32	1
2013	25	2	2513604	4.28421e+07	7209	5942.86	1
2013	13	1	1300680	1.0000098e+08	16820	5945.36	1
2013	29	2	2933000	1.6149349e+08	27162	5945.57	1
2013	22	2	2207801	1.1954162e+08	20093	5949.42	1
2013	31	3	3153103	3.349532e+07	5630	5949.43	1
2013	25	2	2510105	6.343272e+07	10661	5949.98	1
2013	22	2	2207959	2.537948e+07	4264	5952.03	1
2013	15	1	1500909	2.5355411e+08	42591	5953.23	1
2013	29	2	2914406	1.4825166e+08	24882	5958.19	1
2013	27	2	2703106	1.5522322e+08	26051	5958.44	1
2013	25	2	2502409	6.799021e+07	11409	5959.35	1
2013	26	2	2607109	2.723568e+07	4570	5959.67	1
2013	25	2	2502003	4.346594e+07	7291	5961.59	1
2013	29	2	2912103	1.4665976e+08	24595	5962.99	1
2013	25	2	2504157	4.357923e+07	7304	5966.49	1
2013	29	2	2904407	6.292801e+07	10545	5967.57	1
2013	29	2	2911253	2.832941e+07	4747	5967.85	1
2013	29	2	2920809	6.5807e+07	11026	5968.35	1
2013	13	1	1303304	1.4018467e+08	23486	5968.86	1
2013	26	2	2604205	2.4080264e+08	40328	5971.1	1
2013	24	2	2406304	4.401907e+07	7372	5971.12	1
2013	26	2	2605400	1.2806824e+08	21444	5972.22	1
2013	27	2	2701308	1.282903e+08	21480	5972.55	1
2013	31	3	3136504	6.417889e+07	10744	5973.46	1
2013	21	2	2109205	7.230944e+07	12103	5974.51	1
2013	31	3	3104452	3.009372e+07	5036	5975.72	1
2013	24	2	2410207	4.608743e+07	7708	5979.17	1
2013	27	2	2702603	1.3383795e+08	22377	5981.05	1
2013	27	2	2701209	6.417115e+07	10729	5981.09	1
2013	29	2	2923506	5.458289e+07	9122	5983.65	1
2013	29	2	2931608	8.985252e+07	15016	5983.78	1
2013	25	2	2513307	3.560215e+07	5949	5984.56	1
2013	31	3	3127503	3.67937e+07	6148	5984.66	1
2013	23	2	2306702	1.0796453e+08	18040	5984.73	1
2013	29	2	2916906	7.944425e+07	13267	5988.11	1
2013	22	2	2200400	2.3671963e+08	39522	5989.57	1
2013	13	1	1300029	9.087505e+07	15166	5992.02	1
2013	22	2	2202604	1.1067089e+08	18469	5992.25	1
2013	15	1	1505650	1.6084954e+08	26842	5992.46	1
2013	31	3	3118106	3.060131e+07	5103	5996.73	1
2013	23	2	2311355	9.024875e+07	15046	5998.19	1
2013	31	3	3135357	5.158354e+07	8599	5998.78	1
2013	29	2	2930303	1.1079491e+08	18467	5999.62	1
2013	23	2	2302800	4.5861339e+08	76439	5999.73	1
2013	25	2	2501708	3.501155e+07	5824	6011.6	1
2013	25	2	2513356	2.161328e+07	3592	6017.06	1
2013	22	2	2200608	4.03429e+07	6703	6018.63	1
2013	24	2	2406007	3.640837e+07	6049	6018.91	1
2013	29	2	2919959	3.594791e+07	5972	6019.41	1
2013	25	2	2513158	3.979441e+07	6610	6020.33	1
2013	26	2	2603900	1.1551479e+08	19187	6020.47	1
2013	31	3	3155207	3.640319e+07	6045	6022.03	1
2013	25	2	2509909	6.287323e+07	10439	6022.92	1
2013	27	2	2702009	6.692545e+07	11110	6023.89	1
2013	26	2	2606309	4.331913e+07	7191	6024.08	1
2013	26	2	2603405	3.468644e+07	5754	6028.23	1
2013	29	2	2918357	1.4849521e+08	24633	6028.3	1
2013	15	1	1502905	2.2040072e+08	36557	6028.96	1
2013	29	2	2933158	8.190981e+07	13581	6031.21	1
2013	24	2	2402808	3.365526e+07	5580	6031.41	1
2013	22	2	2204352	3.183804e+07	5276	6034.5	1
2013	25	2	2507705	1.0604274e+08	17565	6037.16	1
2013	31	3	3109253	2.488693e+07	4122	6037.59	1
2013	25	2	2509206	8.113425e+07	13438	6037.67	1
2013	24	2	2414753	2.445506e+07	4050	6038.29	1
2013	15	1	1502855	7.909143e+07	13097	6038.9	1
2013	25	2	2501534	2.764416e+07	4577	6039.8	1
2013	26	2	2614303	6.802638e+07	11246	6048.94	1
2013	15	1	1500107	8.9142835e+08	147267	6053.14	1
2013	29	2	2921203	1.6690982e+08	27569	6054.26	1
2013	26	2	2613503	2.0323081e+08	33541	6059.18	1
2013	22	2	2203602	2.892434e+07	4773	6059.99	1
2013	27	2	2703007	9.555184e+07	15762	6062.16	1
2013	24	2	2400604	2.997857e+07	4945	6062.4	1
2013	21	2	2112233	1.185767e+08	19559	6062.51	1
2013	13	1	1301654	9.270931e+07	15291	6063	1
2013	25	2	2513505	3.209549e+07	5292	6064.91	1
2013	13	1	1301605	1.3263734e+08	21859	6067.86	1
2013	29	2	2916708	4.994567e+07	8231	6067.99	1
2013	21	2	2103208	4.6280622e+08	76217	6072.22	1
2013	29	2	2910909	3.488021e+07	5744	6072.46	1
2013	24	2	2406155	2.301799e+07	3790	6073.35	1
2013	25	2	2504405	1.1405699e+08	18769	6076.88	1
2013	26	2	2610103	4.978384e+07	8191	6077.87	1
2013	21	2	2105401	3.9483608e+08	64951	6078.98	1
2013	27	2	2703700	3.476549e+07	5718	6080.01	1
2013	31	3	3171600	8.527024e+07	14016	6083.78	1
2013	25	2	2507408	4.679829e+07	7689	6086.39	1
2013	29	2	2930766	7.49716e+07	12317	6086.84	1
2013	29	2	2910206	2.512133e+07	4127	6087.07	1
2013	25	2	2502052	1.989034e+07	3266	6090.12	1
2013	31	3	3158102	3.29426e+07	5406	6093.71	1
2013	31	3	3115474	3.169423e+07	5200	6095.04	1
2013	13	1	1303957	7.386618e+07	12115	6097.08	1
2013	21	2	2108009	1.1405776e+08	18687	6103.59	1
2013	29	2	2908606	1.5697294e+08	25714	6104.57	1
2013	26	2	2600708	2.3352563e+08	38242	6106.52	1
2013	26	2	2607505	1.6274862e+08	26651	6106.66	1
2013	29	2	2921302	7.064861e+07	11569	6106.72	1
2013	23	2	2303659	6.242827e+07	10218	6109.64	1
2013	25	2	2517407	1.325807e+07	2169	6112.53	1
2013	29	2	2908002	1.26114e+08	20620	6116.1	1
2013	29	2	2931905	3.4204562e+08	55923	6116.37	1
2013	22	2	2207751	2.726443e+07	4457	6117.21	1
2013	26	2	2612406	1.4715681e+08	24049	6119.04	1
2013	21	2	2104677	1.5463921e+08	25262	6121.42	1
2013	24	2	2409803	9.016378e+07	14729	6121.51	1
2013	31	3	3170909	1.2049842e+08	19678	6123.51	1
2013	23	2	2301851	1.0887416e+08	17775	6125.13	1
2013	29	2	2923902	6.839525e+07	11166	6125.31	1
2013	22	2	2210979	1.643885e+07	2683	6127.04	1
2013	22	2	2205102	6.623285e+07	10806	6129.27	1
2013	25	2	2515203	2.072036e+07	3380	6130.28	1
2013	29	2	2926301	2.1622618e+08	35237	6136.34	1
2013	25	2	2504504	4.120293e+07	6711	6139.61	1
2013	25	2	2512036	2.326416e+07	3788	6141.54	1
2013	15	1	1505908	2.2630422e+08	36841	6142.73	1
2013	24	2	2401701	6.121367e+07	9965	6142.87	1
2013	25	2	2502805	8.40408e+07	13676	6145.13	1
2013	22	2	2210052	3.212959e+07	5227	6146.85	1
2013	22	2	2205201	1.1380115e+08	18501	6151.08	1
2013	29	2	2911006	7.007519e+07	11392	6151.26	1
2013	23	2	2305605	1.5965507e+08	25946	6153.36	1
2013	15	1	1507102	1.0626231e+08	17266	6154.43	1
2013	17	1	1720200	6.937824e+07	11271	6155.46	1
2013	31	3	3142700	9.837394e+07	15974	6158.38	1
2013	29	2	2926103	8.066143e+07	13092	6161.12	1
2013	25	2	2512721	3.674249e+07	5963	6161.75	1
2013	15	1	1506906	3.908965e+07	6341	6164.59	1
2013	25	2	2516508	9.372199e+07	15190	6169.98	1
2013	23	2	2301604	1.4188089e+08	22988	6171.95	1
2013	29	2	2908309	1.1508914e+08	18644	6172.99	1
2013	15	1	1505494	4.608935e+07	7465	6174.06	1
2013	25	2	2510501	2.349036e+07	3804	6175.17	1
2013	25	2	2509107	1.3371872e+08	21648	6176.95	1
2013	31	3	3126604	3.149404e+07	5098	6177.72	1
2013	31	3	3162708	1.4403617e+08	23303	6181.01	1
2013	29	2	2927804	4.20979e+07	6808	6183.59	1
2013	22	2	2205508	2.3502771e+08	38005	6184.13	1
2013	21	2	2110005	4.6694169e+08	75444	6189.25	1
2013	24	2	2412906	6.926177e+07	11187	6191.27	1
2013	25	2	2505600	4.11009e+07	6636	6193.63	1
2013	23	2	2311207	6.603573e+07	10651	6199.96	1
2013	25	2	2504074	2.514271e+07	4054	6201.95	1
2013	21	2	2103505	2.4756601e+08	39915	6202.33	1
2013	22	2	2209401	3.834701e+07	6182	6203.01	1
2013	13	1	1300805	2.3623907e+08	38073	6204.9	1
2013	31	3	3117009	5.022627e+07	8094	6205.37	1
2013	31	3	3106507	7.764466e+07	12508	6207.6	1
2013	31	3	3100500	6.39699e+07	10297	6212.48	1
2013	24	2	2411700	2.613454e+07	4205	6215.11	1
2013	24	2	2405009	5.330047e+07	8573	6217.25	1
2013	23	2	2305407	4.1617909e+08	66885	6222.31	1
2013	21	2	2111409	1.2143436e+08	19510	6224.21	1
2013	23	2	2311702	1.2005522e+08	19281	6226.61	1
2013	29	2	2908903	1.4516835e+08	23314	6226.66	1
2013	31	3	3170578	4.13279e+07	6635	6228.77	1
2013	13	1	1300631	1.0796838e+08	17332	6229.42	1
2013	27	2	2704401	1.2380451e+08	19874	6229.47	1
2013	26	2	2608107	2.0156531e+08	32355	6229.8	1
2013	31	3	3134707	7.796789e+07	12511	6231.95	1
2013	31	3	3157500	2.908239e+07	4661	6239.52	1
2013	29	2	2918100	2.5327431e+08	40587	6240.28	1
2013	31	3	3167608	1.1980133e+08	19188	6243.55	1
2013	26	2	2603306	7.008078e+07	11223	6244.39	1
2013	23	2	2309300	1.9793535e+08	31692	6245.59	1
2013	29	2	2920205	1.0851717e+08	17375	6245.59	1
2013	29	2	2902401	8.447242e+07	13525	6245.65	1
2013	22	2	2208304	1.7603741e+08	28179	6247.11	1
2013	22	2	2203305	8.431314e+07	13496	6247.27	1
2013	29	2	2914505	1.8478952e+08	29579	6247.32	1
2013	24	2	2414704	3.416708e+07	5467	6249.7	1
2013	24	2	2408607	2.603346e+07	4165	6250.53	1
2013	29	2	2908804	2.722289e+07	4354	6252.39	1
2013	15	1	1502509	1.3776898e+08	22029	6253.98	1
2013	24	2	2402907	3.093516e+07	4946	6254.58	1
2013	24	2	2405900	1.68127e+07	2687	6257.05	1
2013	31	3	3134004	9.363096e+07	14963	6257.5	1
2013	29	2	2902252	7.3988e+07	11822	6258.5	1
2013	31	3	3136520	2.91456e+07	4656	6259.79	1
2013	13	1	1302900	3.6098344e+08	57663	6260.23	1
2013	22	2	2203404	4.203351e+07	6712	6262.44	1
2013	23	2	2300705	1.0506017e+08	16767	6265.89	1
2013	21	2	2109452	1.7903664e+08	28543	6272.52	1
2013	25	2	2508802	3.562578e+07	5679	6273.25	1
2013	15	1	1501204	2.5869112e+08	41232	6274.04	1
2013	31	3	3135803	1.5784766e+08	25150	6276.25	1
2013	25	2	2505501	2.307095e+07	3675	6277.81	1
2013	29	2	2920908	9.557545e+07	15221	6279.18	1
2013	15	1	1503309	3.7454274e+08	59644	6279.64	1
2013	25	2	2510303	2.921339e+07	4647	6286.5	1
2013	26	2	2603504	1.1303733e+08	17980	6286.84	1
2013	26	2	2615508	8.486342e+07	13497	6287.58	1
2013	31	3	3130556	4.238186e+07	6739	6289.04	1
2013	26	2	2616001	1.0980636e+08	17455	6290.83	1
2013	24	2	2410801	2.693327e+07	4280	6292.82	1
2013	25	2	2500205	3.515345e+07	5586	6293.13	1
2013	25	2	2513968	1.887529e+07	2999	6293.86	1
2013	15	1	1508035	1.8117875e+08	28775	6296.39	1
2013	26	2	2603801	1.2595517e+08	20004	6296.5	1
2013	27	2	2702108	1.3426995e+08	21307	6301.68	1
2013	31	3	3105509	3.63618e+07	5770	6301.87	1
2013	23	2	2310407	7.25807e+07	11517	6302.05	1
2013	25	2	2512747	2.173841e+07	3448	6304.64	1
2013	28	2	2802700	5.410977e+07	8582	6305.03	1
2013	15	1	1505007	9.021044e+07	14305	6306.22	1
2013	13	1	1300607	2.3693057e+08	37564	6307.38	1
2013	26	2	2614709	8.163701e+07	12932	6312.79	1
2013	24	2	2405108	4.473988e+07	7086	6313.84	1
2013	25	2	2504900	1.0631332e+08	16836	6314.64	1
2013	29	2	2912707	1.5198919e+08	24059	6317.35	1
2013	24	2	2410504	3.134083e+07	4961	6317.44	1
2013	24	2	2400406	1.994248e+07	3156	6318.91	1
2013	15	1	1507706	1.5398077e+08	24363	6320.27	1
2013	31	3	3107802	9.88502e+07	15633	6323.18	1
2013	29	2	2931053	1.107148e+08	17493	6329.09	1
2013	21	2	2102101	2.1998193e+08	34754	6329.69	1
2013	21	2	2101939	3.909903e+07	6176	6330.8	1
2013	21	2	2110708	2.1350975e+08	33725	6330.9	1
2013	26	2	2608255	7.003223e+07	11061	6331.46	1
2013	31	3	3156007	8.708932e+07	13755	6331.47	1
2013	27	2	2700706	1.1525518e+08	18201	6332.35	1
2013	29	2	2918704	2.543732e+07	4017	6332.42	1
2013	25	2	2502904	4.030534e+07	6364	6333.33	1
2013	25	2	2508554	2.634434e+07	4157	6337.34	1
2013	17	1	1703800	6.668781e+07	10522	6337.94	1
2013	23	2	2305803	2.6107297e+08	41190	6338.26	1
2013	23	2	2302701	1.7134449e+08	27030	6339.05	1
2013	25	2	2511004	2.403619e+07	3787	6347.03	1
2013	27	2	2708402	2.0241392e+08	31867	6351.83	1
2013	24	2	2404606	8.30752e+07	13070	6356.17	1
2013	22	2	2203206	7.011287e+07	11030	6356.56	1
2013	29	2	2904050	1.0256312e+08	16132	6357.74	1
2013	22	2	2201705	3.430259e+07	5389	6365.3	1
2013	31	3	3156601	6.546711e+07	10278	6369.64	1
2013	29	2	2932101	1.3955178e+08	21897	6373.1	1
2013	25	2	2515005	4.443474e+07	6970	6375.14	1
2013	25	2	2509800	6.21931e+07	9750	6378.78	1
2013	23	2	2300150	1.0216429e+08	16011	6380.88	1
2013	22	2	2205706	1.8681798e+08	29252	6386.5	1
2013	25	2	2505006	4.538257e+07	7106	6386.51	1
2013	24	2	2411007	2.907077e+07	4549	6390.58	1
2013	25	2	2515807	4.531688e+07	7089	6392.56	1
2013	31	3	3121704	2.516164e+07	3935	6394.32	1
2013	31	3	3125606	4.629538e+07	7236	6397.92	1
2013	21	2	2100436	1.6480366e+08	25748	6400.64	1
2013	27	2	2705309	3.48193e+07	5439	6401.78	1
2013	31	3	3106606	2.980348e+07	4648	6412.11	1
2013	29	2	2919702	1.1815989e+08	18419	6415.11	1
2013	25	2	2506806	1.150338e+08	17912	6422.16	2
2013	31	3	3145877	4.947096e+07	7701	6423.97	2
2013	15	1	1504901	2.3534801e+08	36632	6424.66	2
2013	22	2	2203107	6.532987e+07	10164	6427.57	2
2013	31	3	3141801	2.0447812e+08	31811	6427.91	2
2013	26	2	2614105	2.25298e+08	35042	6429.37	2
2013	31	3	3127339	3.38454e+07	5264	6429.6	2
2013	26	2	2609907	4.3527327e+08	67689	6430.49	2
2013	24	2	2401602	3.467035e+07	5385	6438.32	2
2013	22	2	2206407	6.704796e+07	10411	6440.11	2
2013	31	3	3126950	2.229975e+07	3462	6441.29	2
2013	27	2	2705606	8.039074e+07	12479	6442.08	2
2013	29	2	2916203	6.883888e+07	10682	6444.38	2
2013	31	3	3152204	2.496108e+08	38697	6450.39	2
2013	25	2	2510907	7.82159e+07	12117	6455.06	2
2013	17	1	1718808	2.739942e+07	4241	6460.6	2
2013	28	2	2805406	2.128966e+08	32949	6461.4	2
2013	31	3	3161106	3.6188035e+08	56003	6461.8	2
2013	31	3	3145372	3.36122e+07	5196	6468.86	2
2013	29	2	2902500	8.987378e+07	13892	6469.46	2
2013	25	2	2502607	4.018856e+07	6210	6471.59	2
2013	23	2	2304103	4.7966096e+08	74103	6472.9	2
2013	13	1	1301506	1.1685737e+08	18051	6473.73	2
2013	25	2	2503407	2.381121e+07	3673	6482.77	2
2013	21	2	2111052	7.079028e+07	10917	6484.41	2
2013	31	3	3170651	3.206351e+07	4942	6487.96	2
2013	25	2	2515500	8.701292e+07	13409	6489.14	2
2013	24	2	2406809	3.10739e+07	4784	6495.38	2
2013	21	2	2103307	7.7722656e+08	119641	6496.32	2
2013	29	2	2909901	2.2558683e+08	34725	6496.38	2
2013	23	2	2309201	9.690607e+07	14908	6500.27	2
2013	26	2	2616209	1.2649831e+08	19457	6501.43	2
2013	27	2	2700201	1.1696012e+08	17989	6501.76	2
2013	24	2	2411106	2.398506e+07	3689	6501.78	2
2013	25	2	2501609	9.656244e+07	14847	6503.84	2
2013	29	2	2918308	8.889492e+07	13667	6504.35	2
2013	26	2	2608057	9.408885e+07	14464	6505.04	2
2013	31	3	3166204	6.863149e+07	10544	6509.06	2
2013	25	2	2513943	1.642138e+07	2522	6511.25	2
2013	31	3	3119500	6.11454e+07	9387	6513.84	2
2013	31	3	3119203	6.808993e+07	10453	6513.91	2
2013	31	3	3121803	5.63913e+07	8657	6513.95	2
2013	13	1	1303007	1.289497e+08	19792	6515.24	2
2013	25	2	2516151	2.199794e+07	3376	6515.98	2
2013	24	2	2410702	2.215393e+07	3399	6517.78	2
2013	31	3	3169505	4.298132e+07	6593	6519.24	2
2013	31	3	3116803	6.007297e+07	9213	6520.46	2
2013	29	2	2901957	5.083065e+07	7795	6520.93	2
2013	29	2	2925758	1.7132658e+08	26238	6529.71	2
2013	23	2	2306009	9.152597e+07	14011	6532.44	2
2013	31	3	3120151	4.189323e+07	6408	6537.65	2
2013	26	2	2604601	1.6632726e+08	25435	6539.31	2
2013	31	3	3129301	7.043651e+07	10768	6541.28	2
2013	24	2	2410900	4.997669e+07	7640	6541.45	2
2013	25	2	2506103	7.489454e+07	11449	6541.58	2
2013	29	2	2900900	4.140582e+07	6327	6544.31	2
2013	24	2	2414100	6.856154e+07	10468	6549.63	2
2013	26	2	2601003	7.015989e+07	10706	6553.32	2
2013	24	2	2409100	7.98758e+07	12188	6553.64	2
2013	17	1	1718303	5.299498e+07	8085	6554.73	2
2013	29	2	2922409	1.5033799e+08	22928	6556.96	2
2013	31	3	3122207	4.836544e+07	7376	6557.14	2
2013	17	1	1712405	2.496456e+07	3806	6559.26	2
2013	22	2	2211605	1.974647e+07	3010	6560.29	2
2013	25	2	2503902	3.881757e+07	5917	6560.35	2
2013	31	3	3142908	1.4582304e+08	22218	6563.28	2
2013	21	2	2109270	1.1808899e+08	17988	6564.88	2
2013	29	2	2931707	8.885752e+07	13526	6569.39	2
2013	15	1	1504976	1.0132084e+08	15422	6569.89	2
2013	25	2	2506202	1.962348e+07	2981	6582.85	2
2013	15	1	1502004	1.4311834e+08	21740	6583.18	2
2013	29	2	2915106	8.851825e+07	13433	6589.61	2
2013	24	2	2407401	5.677112e+07	8615	6589.8	2
2013	27	2	2709400	1.7325058e+08	26289	6590.23	2
2013	25	2	2503100	3.506889e+07	5319	6593.14	2
2013	25	2	2508406	1.852495e+07	2809	6594.85	2
2013	25	2	2506509	2.183717e+07	3311	6595.34	2
2013	24	2	2414159	3.853995e+07	5843	6595.92	2
2013	24	2	2414803	7.68415e+07	11644	6599.24	2
2013	29	2	2933174	6.236179e+07	9449	6599.83	2
2013	26	2	2606606	1.8612008e+08	28197	6600.71	2
2013	31	3	3136959	3.870031e+07	5863	6600.77	2
2013	21	2	2102036	2.0677698e+08	31320	6602.07	2
2013	35	3	3540853	2.190964e+07	3315	6609.24	2
2013	31	3	3130655	4.975761e+07	7528	6609.67	2
2013	31	3	3131802	7.425974e+07	11224	6616.16	2
2013	27	2	2705507	1.8630442e+08	28158	6616.39	2
2013	15	1	1507003	1.890692e+08	28575	6616.59	2
2013	28	2	2801603	3.870341e+07	5846	6620.49	2
2013	13	1	1300508	1.9699921e+08	29737	6624.72	2
2013	25	2	2504801	1.0197465e+08	15391	6625.6	2
2013	25	2	2505303	1.675774e+07	2529	6626.23	2
2013	22	2	2202307	1.360432e+08	20528	6627.2	2
2013	29	2	2929107	1.4258179e+08	21513	6627.7	2
2013	27	2	2704906	2.452128e+07	3698	6630.96	2
2013	22	2	2205300	2.920211e+07	4403	6632.32	2
2013	21	2	2106359	5.120837e+07	7721	6632.35	2
2013	28	2	2806404	4.945257e+07	7456	6632.59	2
2013	29	2	2917334	7.464121e+07	11253	6633.01	2
2013	31	3	3112901	6.201948e+07	9349	6633.81	2
2013	31	3	3112653	3.463839e+07	5221	6634.44	2
2013	22	2	2201408	4.398596e+07	6627	6637.39	2
2013	26	2	2611705	1.3241304e+08	19947	6638.24	2
2013	25	2	2513653	1.771792e+07	2669	6638.41	2
2013	31	3	3150802	1.1823316e+08	17804	6640.82	2
2013	25	2	2512754	2.934934e+07	4419	6641.62	2
2013	26	2	2600203	1.2372274e+08	18625	6642.83	2
2013	31	3	3138351	3.298395e+07	4965	6643.29	2
2013	52	5	5215231	6.8537567e+08	103085	6648.65	2
2013	31	3	3153301	2.028415e+07	3050	6650.54	2
2013	29	2	2901403	9.81836e+07	14762	6651.1	2
2013	29	2	2922730	5.376317e+07	8083	6651.39	2
2013	31	3	3152402	1.0895382e+08	16350	6663.84	2
2013	17	1	1707405	6.800836e+07	10203	6665.53	2
2013	25	2	2500775	5.387294e+07	8081	6666.62	2
2013	26	2	2615706	1.0188235e+08	15280	6667.69	2
2013	31	3	3142007	9.036841e+07	13552	6668.27	2
2013	24	2	2400505	9.257378e+07	13878	6670.54	2
2013	15	1	1501576	1.0616862e+08	15916	6670.56	2
2013	31	3	3164472	4.09585e+07	6140	6670.76	2
2013	15	1	1507508	8.968637e+07	13419	6683.54	2
2013	25	2	2511707	3.449314e+07	5159	6686.01	2
2013	31	3	3152303	7.329315e+07	10955	6690.38	2
2013	25	2	2508208	5.062757e+07	7564	6693.23	2
2013	17	1	1721109	4.792739e+07	7158	6695.64	2
2013	15	1	1507151	1.6095822e+08	24012	6703.24	2
2013	23	2	2309508	1.4414227e+08	21503	6703.36	2
2013	27	2	2703403	3.697261e+07	5511	6708.87	2
2013	25	2	2507309	9.573048e+07	14248	6718.87	2
2013	29	2	2909406	9.672222e+07	14390	6721.49	2
2013	24	2	2410603	2.146584e+07	3191	6727	2
2013	25	2	2507804	4.664614e+07	6934	6727.16	2
2013	25	2	2513984	2.28144e+07	3389	6731.9	2
2013	31	3	3152170	8.003957e+07	11881	6736.77	2
2013	35	3	3522653	2.750759e+07	4081	6740.4	2
2013	25	2	2500809	1.1630308e+08	17252	6741.43	2
2013	31	3	3115409	2.433878e+07	3608	6745.78	2
2013	25	2	2509404	9.009782e+07	13349	6749.41	2
2013	29	2	2906006	4.8301803e+08	71507	6754.84	2
2013	24	2	2413508	4.474927e+07	6620	6759.71	2
2013	24	2	2404002	2.893468e+07	4280	6760.44	2
2013	31	3	3150539	3.175503e+07	4696	6762.14	2
2013	29	2	2927507	1.38799e+08	20509	6767.71	2
2013	22	2	2209757	1.978467e+07	2923	6768.62	2
2013	52	5	5203962	2.300724e+07	3398	6770.82	2
2013	15	1	1506104	7.067951e+07	10432	6775.26	2
2013	25	2	2512077	2.821988e+07	4165	6775.48	2
2013	31	3	3106655	3.116037e+07	4597	6778.41	2
2013	32	3	3204005	1.5679318e+08	23125	6780.25	2
2013	25	2	2512309	1.5235521e+08	22461	6783.1	2
2013	31	3	3108503	4.485252e+07	6612	6783.5	2
2013	26	2	2613206	1.5042031e+08	22162	6787.31	2
2013	25	2	2505105	1.3778995e+08	20299	6788.02	2
2013	24	2	2413003	4.295554e+07	6328	6788.17	2
2013	25	2	2514404	3.219353e+07	4738	6794.75	2
2013	15	1	1503077	1.7182955e+08	25287	6795.17	2
2013	25	2	2500304	1.954125e+08	28733	6800.98	2
2013	25	2	2512705	1.2708474e+08	18686	6801.07	2
2013	28	2	2802403	7.968069e+07	11712	6803.34	2
2013	24	2	2401503	2.769194e+07	4067	6808.93	2
2013	13	1	1302207	8.45131e+07	12408	6811.18	2
2013	15	1	1501758	4.962783e+07	7285	6812.33	2
2013	25	2	2514503	1.344265e+08	19732	6812.61	2
2013	26	2	2601607	1.4090236e+08	20680	6813.46	2
2013	23	2	2313302	3.9025014e+08	57246	6817.07	2
2013	31	3	3110103	3.587284e+07	5260	6819.93	2
2013	26	2	2610400	1.4315261e+08	20990	6820.04	2
2013	29	2	2912301	1.132276e+08	16582	6828.34	2
2013	26	2	2614600	1.8841359e+08	27591	6828.81	2
2013	29	2	2906303	2.2926752e+08	33570	6829.54	2
2013	31	3	3148400	3.429301e+07	5020	6831.28	2
2013	26	2	2610806	1.4730893e+08	21558	6833.14	2
2013	25	2	2504033	4.159606e+07	6082	6839.21	2
2013	26	2	2613107	2.4965806e+08	36485	6842.76	2
2013	31	3	3127354	2.119558e+07	3097	6843.91	2
2013	31	3	3105202	3.463092e+07	5059	6845.41	2
2013	31	3	3116506	5.416175e+07	7909	6848.12	2
2013	25	2	2504207	3.359153e+07	4905	6848.43	2
2013	24	2	2403806	6.331442e+07	9245	6848.5	2
2013	29	2	2918803	1.6581486e+08	24207	6849.87	2
2013	24	2	2410009	2.524583e+07	3683	6854.69	2
2013	15	1	1507953	6.2071023e+08	90552	6854.74	2
2013	23	2	2310852	1.3530331e+08	19733	6856.7	2
2013	21	2	2109551	5.152665e+07	7514	6857.42	2
2013	25	2	2511400	1.2753473e+08	18597	6857.81	2
2013	25	2	2507101	1.22916e+08	17918	6859.92	2
2013	29	2	2917805	1.2430162e+08	18114	6862.18	2
2013	21	2	2114007	3.4214507e+08	49848	6863.77	2
2013	25	2	2501351	2.562612e+07	3732	6866.59	2
2013	25	2	2501153	1.310271e+07	1908	6867.25	2
2013	31	3	3122504	3.642461e+07	5303	6868.68	2
2013	13	1	1302553	1.8225686e+08	26530	6869.84	2
2013	26	2	2607307	2.0638131e+08	30037	6870.9	2
2013	31	3	3148756	4.796529e+07	6978	6873.79	2
2013	24	2	2407807	1.5023202e+08	21833	6880.96	2
2013	23	2	2302107	2.3770742e+08	34512	6887.67	2
2013	23	2	2312205	2.986408e+08	43358	6887.79	2
2013	31	3	3171154	3.346818e+07	4859	6887.87	2
2013	28	2	2807501	9.100481e+07	13192	6898.48	2
2013	31	3	3124302	2.2135479e+08	32081	6899.87	2
2013	31	3	3102209	3.032877e+07	4395	6900.74	2
2013	29	2	2925402	6.609509e+07	9574	6903.6	2
2013	25	2	2501401	5.911333e+07	8561	6904.96	2
2013	25	2	2503605	5.049922e+07	7304	6913.91	2
2013	31	3	3165503	4.119689e+07	5957	6915.71	2
2013	25	2	2504850	1.283945e+07	1856	6917.81	2
2013	31	3	3108701	3.226804e+07	4664	6918.53	2
2013	24	2	2411502	1.6264339e+08	23492	6923.35	2
2013	31	3	3151909	6.265934e+07	9050	6923.68	2
2013	51	5	5100508	7.255747e+07	10476	6926.07	2
2013	23	2	2300754	2.8577853e+08	41227	6931.83	2
2013	25	2	2513927	3.019793e+07	4355	6934.08	2
2013	15	1	1503804	3.770701e+08	54376	6934.49	2
2013	31	3	3103702	5.863936e+07	8454	6936.29	2
2013	29	2	2928000	2.5301769e+08	36452	6941.12	2
2013	52	5	5200258	1.23551239e+09	177890	6945.37	2
2013	24	2	2411908	2.850617e+07	4103	6947.64	2
2013	21	2	2103257	9.814131e+07	14125	6948.06	2
2013	29	2	2931400	5.647069e+07	8125	6950.24	2
2013	26	2	2600906	1.5682966e+08	22555	6953.21	2
2013	52	5	5221080	2.234763e+07	3213	6955.38	2
2013	31	3	3141009	9.00825e+07	12947	6957.79	2
2013	25	2	2510600	2.089682e+07	3003	6958.65	2
2013	25	2	2512762	3.035033e+07	4359	6962.68	2
2013	24	2	2401859	4.358124e+07	6257	6965.2	2
2013	26	2	2609105	1.0293105e+08	14770	6968.93	2
2013	31	3	3154101	7.417012e+07	10635	6974.15	2
2013	21	2	2108603	5.6051757e+08	80365	6974.65	2
2013	26	2	2609303	1.040433e+08	14915	6975.75	2
2013	24	2	2412500	1.5993043e+08	22921	6977.46	2
2013	21	2	2110807	3.205785e+07	4593	6979.72	2
2013	26	2	2600609	9.8855e+07	14155	6983.75	2
2013	25	2	2501906	1.2220874e+08	17495	6985.35	2
2013	31	3	3157377	3.097488e+07	4434	6985.76	2
2013	29	2	2919058	6.180538e+07	8847	6986.03	2
2013	31	3	3168408	1.0255522e+08	14677	6987.48	2
2013	29	2	2916807	1.3865264e+08	19837	6989.6	2
2013	31	3	3111150	2.671742e+07	3821	6992.26	2
2013	17	1	1720804	6.503802e+07	9297	6995.59	2
2013	31	3	3123858	3.749933e+07	5360	6996.14	2
2013	25	2	2501104	1.6422414e+08	23472	6996.6	2
2013	24	2	2408409	3.072798e+07	4391	6997.95	2
2013	17	1	1720101	3.466879e+07	4954	6998.14	2
2013	31	3	3119906	2.673045e+07	3819	6999.33	2
2013	26	2	2615904	5.690039e+07	8129	6999.68	2
2013	25	2	2513802	3.230079e+07	4612	7003.64	2
2013	17	1	1703891	2.736811e+07	3906	7006.68	2
2013	29	2	2900306	1.0942537e+08	15615	7007.71	2
2013	28	2	2805604	1.9800307e+08	28237	7012.19	2
2013	26	2	2607802	1.1669298e+08	16638	7013.64	2
2013	21	2	2103802	1.6022864e+08	22844	7014.04	2
2013	27	2	2705200	1.200514e+08	17110	7016.45	2
2013	21	2	2111102	1.7690468e+08	25199	7020.31	2
2013	25	2	2505907	2.417054e+07	3439	7028.36	2
2013	24	2	2412807	5.873744e+07	8351	7033.58	2
2013	23	2	2305308	1.7203665e+08	24458	7033.96	2
2013	17	1	1710706	4.285297e+07	6092	7034.3	2
2013	28	2	2804201	1.021058e+08	14513	7035.47	2
2013	31	3	3136579	3.362922e+07	4778	7038.35	2
2013	15	1	1502301	3.6983761e+08	52537	7039.56	2
2013	31	3	3129608	5.783767e+07	8215	7040.49	2
2013	25	2	2516706	1.0379462e+08	14739	7042.18	2
2013	31	3	3158201	1.0450312e+08	14839	7042.46	2
2013	22	2	2211308	1.4480402e+08	20541	7049.51	2
2013	25	2	2505279	3.708982e+07	5259	7052.64	2
2013	31	3	3171907	4.035264e+07	5720	7054.66	2
2013	26	2	2600302	1.6824444e+08	23842	7056.64	2
2013	25	2	2511905	1.2812176e+08	18148	7059.83	2
2013	27	2	2705705	1.518496e+08	21499	7063.1	2
2013	31	3	3120870	5.188474e+07	7345	7063.95	2
2013	26	2	2604502	1.483897e+08	21006	7064.16	2
2013	24	2	2412708	4.448215e+07	6296	7065.14	2
2013	29	2	2928208	1.907493e+08	26998	7065.31	2
2013	21	2	2112407	2.4413647e+08	34554	7065.36	2
2013	15	1	1503002	5.428833e+07	7680	7068.79	2
2013	31	3	3141504	4.619206e+07	6533	7070.57	2
2013	22	2	2207009	2.5595204e+08	36195	7071.47	2
2013	29	2	2919306	7.996971e+07	11300	7076.97	2
2013	29	2	2911600	1.4950813e+08	21125	7077.31	2
2013	31	3	3125408	3.650417e+07	5157	7078.57	2
2013	31	3	3155603	2.1531665e+08	30418	7078.59	2
2013	29	2	2910776	4.182381e+07	5908	7079.18	2
2013	23	2	2302503	3.3437763e+08	47218	7081.57	2
2013	27	2	2700805	3.354568e+07	4737	7081.63	2
2013	31	3	3140605	3.310731e+07	4673	7084.81	2
2013	35	3	3540754	1.5234873e+08	21501	7085.66	2
2013	35	3	3553658	1.994111e+07	2814	7086.39	2
2013	29	2	2919504	3.2061687e+08	45236	7087.65	2
2013	24	2	2414902	1.202095e+07	1696	7087.82	2
2013	24	2	2414001	1.0764988e+08	15175	7093.9	2
2013	31	3	3100609	1.0668447e+08	15034	7096.21	2
2013	26	2	2602308	2.7177738e+08	38287	7098.42	2
2013	25	2	2511103	5.561709e+07	7830	7103.08	2
2013	27	2	2708907	1.1180128e+08	15737	7104.36	2
2013	25	2	2500700	1.2729073e+08	17917	7104.47	2
2013	31	3	3160207	2.951989e+07	4151	7111.51	2
2013	26	2	2602100	3.3622165e+08	47273	7112.34	2
2013	29	2	2929057	1.0985881e+08	15443	7113.83	2
2013	31	3	3170057	8.886249e+07	12487	7116.4	2
2013	24	2	2407500	8.1277e+07	11419	7117.7	2
2013	29	2	2922607	9.648275e+07	13555	7117.87	2
2013	25	2	2516300	1.1826672e+08	16595	7126.65	2
2013	29	2	2918555	4.629731e+07	6493	7130.34	2
2013	29	2	2931202	1.4601877e+08	20474	7131.91	2
2013	31	3	3118809	1.9179749e+08	26889	7132.94	2
2013	25	2	2505238	4.509615e+07	6321	7134.34	2
2013	31	3	3133204	8.76509e+07	12280	7137.7	2
2013	31	3	3134301	4.470487e+07	6263	7137.93	2
2013	31	3	3102506	3.587103e+07	5023	7141.36	2
2013	26	2	2611804	3.2998327e+08	46200	7142.49	2
2013	29	2	2915809	1.6948956e+08	23723	7144.52	2
2013	31	3	3144201	2.327591e+07	3256	7148.62	2
2013	25	2	2516003	1.8896033e+08	26431	7149.19	2
2013	29	2	2925105	3.4733204e+08	48576	7150.28	2
2013	22	2	2208403	4.4781776e+08	62542	7160.27	2
2013	25	2	2507200	7.584372e+07	10590	7161.82	2
2013	15	1	1500305	2.6221412e+08	36598	7164.71	2
2013	29	2	2932705	1.5766425e+08	22004	7165.25	2
2013	28	2	2805109	6.662641e+07	9298	7165.67	2
2013	25	2	2515609	2.287644e+07	3190	7171.3	2
2013	17	1	1718758	4.633216e+07	6459	7173.27	2
2013	25	2	2511608	4.922642e+07	6860	7175.86	2
2013	26	2	2603108	1.4117792e+08	19674	7175.86	2
2013	29	2	2922300	2.1988324e+08	30635	7177.52	2
2013	31	3	3163003	3.0446e+07	4241	7178.97	2
2013	29	2	2920502	1.7584566e+08	24491	7180.01	2
2013	31	3	3167707	4.239473e+07	5897	7189.2	2
2013	31	3	3158904	6.351319e+07	8834	7189.63	2
2013	24	2	2412104	4.44036e+07	6174	7192.03	2
2013	29	2	2911402	1.1512302e+08	16003	7193.84	2
2013	15	1	1506203	2.7742941e+08	38552	7196.24	2
2013	23	2	2305001	2.7972147e+08	38832	7203.38	2
2013	26	2	2615003	1.9304072e+08	26772	7210.55	2
2013	15	1	1504109	5.944925e+07	8240	7214.72	2
2013	13	1	1300706	2.3662876e+08	32792	7216.05	2
2013	26	2	2608305	1.0340469e+08	14325	7218.48	2
2013	22	2	2210003	1.44378e+08	20000	7218.9	2
2013	24	2	2410405	6.556789e+07	9081	7220.34	2
2013	25	2	2515930	3.414187e+07	4728	7221.21	2
2013	24	2	2412559	6.670611e+07	9237	7221.62	2
2013	25	2	2507903	7.628727e+07	10560	7224.17	2
2013	24	2	2408508	3.511569e+07	4860	7225.45	2
2013	21	2	2101509	1.3059742e+08	18074	7225.71	2
2013	21	2	2100808	1.0705732e+08	14815	7226.28	2
2013	24	2	2409308	9.079297e+07	12561	7228.16	2
2013	29	2	2901007	2.6810037e+08	37081	7230.13	2
2013	31	3	3108602	2.3411702e+08	32378	7230.74	2
2013	31	3	3163409	4.134863e+07	5717	7232.57	2
2013	31	3	3157252	5.806965e+07	8027	7234.29	2
2013	31	3	3152131	3.010665e+07	4161	7235.44	2
2013	24	2	2406106	1.3298024e+08	18366	7240.57	2
2013	31	3	3148509	6.353636e+07	8771	7243.91	2
2013	24	2	2411403	9.917454e+07	13688	7245.36	2
2013	29	2	2917201	1.3919989e+08	19211	7245.84	2
2013	29	2	2908200	1.6109778e+08	22226	7248.17	2
2013	52	5	5219753	4.9306657e+08	67993	7251.73	2
2013	13	1	1300086	8.438719e+07	11636	7252.25	2
2013	31	3	3126802	4.375886e+07	6033	7253.25	2
2013	29	2	2917607	3.9828088e+08	54902	7254.4	2
2013	31	3	3133907	4.232384e+07	5833	7255.93	2
2013	22	2	2200202	1.2242522e+08	16869	7257.41	2
2013	29	2	2903300	4.916424e+07	6767	7265.29	2
2013	31	3	3161650	2.720063e+07	3740	7272.9	2
2013	35	3	3543501	4.434401e+07	6096	7274.28	2
2013	24	2	2402709	8.216282e+07	11292	7276.2	2
2013	22	2	2202083	5.366271e+07	7375	7276.3	2
2013	23	2	2302602	4.5070042e+08	61918	7278.99	2
2013	27	2	2701357	5.04143e+07	6925	7280.04	2
2013	24	2	2406601	5.830687e+07	8009	7280.17	2
2013	29	2	2910404	1.5619328e+08	21418	7292.62	2
2013	25	2	2506400	1.0294848e+08	14098	7302.35	2
2013	25	2	2502201	1.821964e+07	2495	7302.46	2
2013	27	2	2708808	2.4711279e+08	33826	7305.41	2
2013	31	3	3159100	2.855833e+07	3908	7307.66	2
2013	31	3	3124104	4.768031e+08	65224	7310.24	2
2013	31	3	3112208	3.545081e+07	4848	7312.46	2
2013	26	2	2604809	9.252715e+07	12647	7316.13	2
2013	15	1	1503200	2.6998383e+08	36883	7320.01	2
2013	24	2	2413409	5.926108e+07	8083	7331.57	2
2013	24	2	2409605	1.911609e+07	2607	7332.6	2
2013	31	3	3115458	4.958164e+07	6761	7333.48	2
2013	15	1	1503093	2.6774061e+08	36500	7335.36	2
2013	31	3	3139300	1.4597593e+08	19898	7336.21	2
2013	17	1	1704105	2.008128e+07	2737	7336.97	2
2013	31	3	3150158	5.683998e+07	7744	7339.87	2
2013	26	2	2613602	2.4301559e+08	33105	7340.75	2
2013	26	2	2608453	1.2527998e+08	17034	7354.7	2
2013	31	3	3162609	5.857837e+07	7964	7355.4	2
2013	17	1	1711951	2.851297e+07	3875	7358.18	2
2013	26	2	2603454	1.11545085e+09	151587	7358.49	2
2013	31	3	3153509	6.282203e+07	8535	7360.52	2
2013	22	2	2210623	2.575647e+07	3499	7361.09	2
2013	31	3	3104700	1.0564026e+08	14344	7364.77	2
2013	29	2	2903102	4.614717e+07	6261	7370.57	2
2013	31	3	3121407	5.350835e+07	7259	7371.31	2
2013	23	2	2313955	1.329416e+08	18024	7375.81	2
2013	15	1	1508308	4.3025978e+08	58323	7377.19	2
2013	35	3	3501400	3.645586e+07	4937	7384.21	2
2013	15	1	1503705	3.8196538e+08	51711	7386.54	2
2013	21	2	2104800	4.8088348e+08	65078	7389.34	2
2013	27	2	2704807	1.0204717e+08	13807	7390.97	2
2013	31	3	3157609	2.985899e+07	4034	7401.83	2
2013	25	2	2514008	3.222044e+07	4352	7403.59	2
2013	21	2	2110609	2.0266975e+08	27369	7405.08	2
2013	29	2	2927200	2.3582303e+08	31799	7416.05	2
2013	29	2	2932606	1.2791448e+08	17239	7420.06	2
2013	25	2	2500734	1.615006e+07	2176	7421.9	2
2013	31	3	3120839	3.634016e+07	4895	7423.93	2
2013	17	1	1720309	3.380207e+07	4553	7424.13	2
2013	22	2	2200459	3.873694e+07	5216	7426.56	2
2013	29	2	2915403	5.575901e+07	7507	7427.6	2
2013	31	3	3138674	4.762005e+07	6407	7432.5	2
2013	25	2	2508307	1.9918083e+08	26788	7435.45	2
2013	29	2	2926657	6.840812e+07	9195	7439.71	2
2013	28	2	2804706	4.806437e+07	6456	7444.91	2
2013	29	2	2920007	7.344999e+07	9864	7446.27	2
2013	31	3	3139201	1.4324099e+08	19228	7449.6	2
2013	17	1	1717800	3.467153e+07	4654	7449.83	2
2013	26	2	2607653	2.7018418e+08	36233	7456.85	2
2013	29	2	2905800	2.7748288e+08	37207	7457.81	2
2013	23	2	2311603	2.0215337e+08	27088	7462.84	2
2013	22	2	2210805	9.210502e+07	12341	7463.33	2
2013	17	1	1712801	2.474156e+07	3313	7468.02	2
2013	13	1	1301704	3.6718065e+08	49137	7472.59	2
2013	25	2	2514909	5.826458e+07	7794	7475.57	2
2013	26	2	2607604	1.7902088e+08	23923	7483.21	2
2013	27	2	2703502	5.384857e+07	7193	7486.25	2
2013	22	2	2206605	7.814925e+07	10438	7486.99	2
2013	28	2	2806206	1.4969873e+08	19994	7487.18	2
2013	25	2	2509057	6.078473e+07	8117	7488.57	2
2013	31	3	3107208	3.868261e+07	5163	7492.27	2
2013	29	2	2905602	2.4787457e+08	33068	7495.9	2
2013	26	2	2609006	1.8592307e+08	24793	7499.01	2
2013	31	3	3122108	3.808378e+07	5078	7499.76	2
2013	25	2	2514701	3.076687e+07	4102	7500.46	2
2013	25	2	2501500	1.6521379e+08	22012	7505.62	2
2013	31	3	3135209	5.0946472e+08	67875	7505.93	2
2013	31	3	3100401	3.039899e+07	4045	7515.2	2
2013	35	3	3516309	1.23900235e+09	164718	7521.96	2
2013	29	2	2915700	6.215112e+07	8259	7525.26	2
2013	23	2	2304459	1.1744708e+08	15603	7527.21	2
2013	28	2	2806909	2.788847e+07	3705	7527.25	2
2013	24	2	2412609	1.2717282e+08	16888	7530.37	2
2013	31	3	3169109	4.568577e+07	6066	7531.45	2
2013	29	2	2910107	9.328309e+07	12379	7535.59	2
2013	29	2	2929909	3.3758085e+08	44765	7541.18	2
2013	17	1	1715002	3.03012e+07	4018	7541.36	2
2013	27	2	2707305	2.042733e+08	27047	7552.53	2
2013	24	2	2403756	2.265779e+07	3000	7552.6	2
2013	31	3	3122801	2.321844e+07	3074	7553.17	2
2013	35	3	3513603	1.6814735e+08	22251	7556.84	2
2013	52	5	5206701	2.555602e+07	3381	7558.72	2
2013	28	2	2803708	5.083673e+07	6723	7561.61	2
2013	25	2	2500577	1.85003e+07	2446	7563.49	2
2013	31	3	3144359	5.073649e+07	6708	7563.58	2
2013	26	2	2613701	8.1944817e+08	108301	7566.4	2
2013	25	2	2516755	2.233086e+07	2951	7567.22	2
2013	31	3	3160959	4.255965e+07	5622	7570.2	2
2013	25	2	2510709	1.770443e+07	2338	7572.47	2
2013	31	3	3156452	3.380468e+07	4464	7572.73	2
2013	25	2	2510659	1.381346e+07	1823	7577.32	2
2013	29	2	2914901	2.0272393e+08	26753	7577.61	2
2013	17	1	1718006	2.253562e+07	2973	7580.09	2
2013	24	2	2405504	2.029226e+07	2676	7583.05	2
2013	25	2	2516904	1.1423195e+08	15062	7584.12	2
2013	23	2	2307254	1.3875283e+08	18292	7585.44	2
2013	31	3	3140308	3.129653e+07	4125	7587.04	2
2013	31	3	3163201	3.15963e+07	4163	7589.79	2
2013	31	3	3106804	2.858618e+07	3765	7592.61	2
2013	24	2	2404705	1.1253508e+08	14814	7596.54	2
2013	31	3	3113107	2.540746e+07	3341	7604.75	2
2013	27	2	2700508	1.169824e+08	15377	7607.62	2
2013	35	3	3504701	3.372473e+07	4433	7607.65	2
2013	24	2	2403400	4.606265e+07	6054	7608.63	2
2013	31	3	3116001	4.423848e+07	5811	7612.89	2
2013	17	1	1718501	3.067722e+07	4029	7614.1	2
2013	29	2	2911204	2.4987615e+08	32814	7614.93	2
2013	23	2	2310605	6.599727e+07	8666	7615.66	2
2013	23	2	2312304	3.4790212e+08	45653	7620.58	2
2013	31	3	3103405	2.8358802e+08	37169	7629.69	2
2013	31	3	3120003	2.366122e+07	3100	7632.65	2
2013	31	3	3167806	4.557968e+07	5971	7633.51	2
2013	29	2	2920700	1.6048125e+08	21016	7636.15	2
2013	31	3	3163805	5.338879e+07	6991	7636.79	2
2013	28	2	2803104	3.856533e+07	5048	7639.73	2
2013	25	2	2513851	1.962427e+07	2565	7650.79	2
2013	31	3	3158607	3.058281e+07	3997	7651.44	2
2013	31	3	3150000	3.271034e+07	4274	7653.33	2
2013	25	2	2504108	1.936536e+07	2529	7657.32	2
2013	21	2	2105427	1.9358745e+08	25269	7661.06	2
2013	31	3	3117405	3.531297e+07	4609	7661.74	2
2013	29	2	2911808	1.7318404e+08	22583	7668.78	2
2013	25	2	2503753	2.403772e+07	3131	7677.33	2
2013	15	1	1502954	2.4946972e+08	32420	7694.93	2
2013	25	2	2515971	5.866705e+07	7623	7696.06	2
2013	31	3	3125507	2.442749e+07	3170	7705.83	2
2013	29	2	2933455	1.0095944e+08	13089	7713.3	2
2013	29	2	2928109	3.2263762e+08	41824	7714.17	2
2013	15	1	1502939	4.2127237e+08	54602	7715.33	2
2013	15	1	1507805	9.515256e+07	12331	7716.53	2
2013	25	2	2512606	1.41621e+07	1834	7721.97	2
2013	27	2	2708006	3.6568602e+08	47352	7722.72	2
2013	22	2	2207405	3.860194e+07	4997	7725.02	2
2013	21	2	2112209	1.24994054e+09	161721	7728.99	2
2013	23	2	2313104	2.3201699e+08	30018	7729.26	2
2013	31	3	3148301	7.433486e+07	9605	7739.18	2
2013	22	2	2206308	9.63309e+06	1244	7743.64	2
2013	31	3	3161403	4.035395e+07	5211	7743.99	2
2013	27	2	2706448	9.666081e+07	12474	7748.98	2
2013	28	2	2805802	1.5455799e+08	19937	7752.32	2
2013	17	1	1717909	5.915066e+07	7628	7754.41	2
2013	23	2	2309805	9.198173e+07	11857	7757.59	2
2013	27	2	2700409	3.6329749e+08	46787	7764.92	2
2013	25	2	2515302	4.0168585e+08	51700	7769.55	2
2013	25	2	2514651	1.362368e+07	1753	7771.63	2
2013	31	3	3166105	2.796617e+07	3597	7774.86	2
2013	29	2	2923803	2.3062255e+08	29654	7777.11	2
2013	23	2	2300200	4.67824e+08	60137	7779.3	2
2013	24	2	2404853	5.707918e+07	7336	7780.7	2
2013	31	3	3143807	4.943976e+07	6351	7784.56	2
2013	29	2	2908408	5.2278262e+08	67126	7788.08	2
2013	51	5	5100102	4.230949e+07	5431	7790.37	2
2013	23	2	2304509	1.0441748e+08	13402	7791.19	2
2013	29	2	2922250	8.934253e+07	11465	7792.63	2
2013	29	2	2910701	4.7237696e+08	60558	7800.41	2
2013	15	1	1506005	2.2909989e+08	29342	7807.92	2
2013	22	2	2208551	2.050076e+07	2625	7809.81	2
2013	13	1	1302702	4.0095007e+08	51331	7811.07	2
2013	29	2	2922508	2.2747459e+08	29122	7811.09	2
2013	13	1	1301001	2.1448574e+08	27405	7826.52	2
2013	22	2	2202901	2.0293647e+08	25927	7827.23	2
2013	24	2	2413805	1.93184e+07	2468	7827.55	2
2013	31	3	3154507	7.552553e+07	9643	7832.16	2
2013	31	3	3140100	3.366705e+07	4297	7835.01	2
2013	31	3	3166006	4.596249e+07	5864	7838.08	2
2013	27	2	2709152	3.4183592e+08	43605	7839.37	2
2013	31	3	3137908	2.763613e+07	3524	7842.26	2
2013	23	2	2307700	9.4451431e+08	120405	7844.48	2
2013	28	2	2807006	3.027468e+07	3859	7845.21	2
2013	29	2	2900355	1.3282688e+08	16929	7846.11	2
2013	13	1	1302009	6.887229e+07	8774	7849.59	2
2013	29	2	2926608	3.9918202e+08	50805	7857.14	2
2013	24	2	2404903	4.578204e+07	5822	7863.63	2
2013	15	1	1502756	2.3789167e+08	30233	7868.61	2
2013	25	2	2502508	1.3718647e+08	17434	7868.9	2
2013	27	2	2703908	3.365961e+07	4275	7873.59	2
2013	15	1	1504604	2.2410226e+08	28454	7875.95	2
2013	24	2	2401909	2.783164e+07	3531	7882.08	2
2013	24	2	2405207	4.298511e+07	5453	7882.84	2
2013	24	2	2409209	2.398274e+07	3040	7889.06	2
2013	52	5	5213509	6.442321e+07	8166	7889.2	2
2013	25	2	2513901	2.5763953e+08	32651	7890.71	2
2013	25	2	2503308	7.853238e+07	9950	7892.7	2
2013	24	2	2407906	1.785641e+07	2261	7897.57	2
2013	17	1	1703008	8.46758e+07	10720	7898.86	2
2013	29	2	2919009	3.225387e+07	4079	7907.3	2
2013	31	3	3150901	4.295313e+07	5432	7907.43	2
2013	25	2	2503803	4.635863e+07	5859	7912.38	2
2013	15	1	1506500	5.0648761e+08	63973	7917.21	2
2013	27	2	2707909	5.750334e+07	7257	7923.84	2
2013	15	1	1505486	3.4126883e+08	43057	7925.98	2
2013	35	3	3532306	5.408544e+07	6821	7929.25	2
2013	29	2	2905008	1.8430127e+08	23232	7933.08	2
2013	15	1	1508001	4.6905373e+08	59112	7935	2
2013	31	3	3123809	5.829001e+07	7345	7936.01	2
2013	29	2	2912905	1.4724652e+08	18546	7939.53	2
2013	28	2	2807402	4.0167305e+08	50557	7944.95	2
2013	13	1	1300144	1.5785815e+08	19860	7948.55	2
2013	29	2	2925006	2.0847047e+08	26225	7949.3	2
2013	21	2	2111763	1.1383422e+08	14315	7952.09	2
2013	26	2	2605509	9.424099e+07	11850	7952.83	2
2013	28	2	2802502	2.500681e+07	3143	7956.35	2
2013	31	3	3139904	1.1586481e+08	14551	7962.67	2
2013	28	2	2803005	3.2517051e+08	40821	7965.77	2
2013	31	3	3153905	1.2792538e+08	16055	7967.95	2
2013	25	2	2512200	3.214872e+07	4033	7971.42	2
2013	31	3	3165701	6.057721e+07	7598	7972.78	2
2013	29	2	2913200	2.1753942e+08	27285	7972.86	2
2013	27	2	2706802	1.4304938e+08	17941	7973.32	2
2013	31	3	3104403	2.331987e+07	2924	7975.33	2
2013	31	3	3163300	3.144677e+07	3942	7977.36	2
2013	23	2	2311405	6.034482e+08	75565	7985.82	2
2013	26	2	2605103	2.8408977e+08	35574	7985.88	2
2013	31	3	3157401	4.036587e+07	5050	7993.24	2
2013	27	2	2708303	1.9064691e+08	23847	7994.59	2
2013	29	2	2929602	1.4068265e+08	17594	7996.06	2
2013	26	2	2605004	1.8958317e+08	23695	8000.98	2
2013	23	2	2307809	2.0767967e+08	25944	8004.92	2
2013	21	2	2111201	1.364988e+09	170423	8009.41	2
2013	29	2	2913903	3.7797145e+08	47178	8011.6	2
2013	31	3	3135506	1.0448356e+08	13041	8011.93	2
2013	28	2	2805505	1.8495179e+08	23078	8014.2	2
2013	17	1	1703826	1.792933e+07	2236	8018.49	2
2013	52	5	5203559	6.671205e+07	8319	8019.24	2
2013	31	3	3135076	4.254048e+07	5303	8021.97	2
2013	31	3	3105707	4.807216e+07	5991	8024.06	2
2013	31	3	3168507	9.424402e+07	11745	8024.18	2
2013	27	2	2709301	5.2571326e+08	65495	8026.77	2
2013	22	2	2202208	3.6788891e+08	45827	8027.78	2
2013	31	3	3165602	1.642919e+07	2046	8029.91	2
2013	31	3	3121100	6.584696e+07	8197	8033.06	2
2013	31	3	3163508	5.377575e+07	6694	8033.43	2
2013	25	2	2512903	1.9186536e+08	23883	8033.55	2
2013	32	3	3203304	1.1903067e+08	14808	8038.27	2
2013	23	2	2312700	2.1436516e+08	26656	8041.91	2
2013	25	2	2506905	1.9834478e+08	24663	8042.2	2
2013	31	3	3171030	7.137569e+07	8875	8042.33	2
2013	22	2	2210607	2.6877829e+08	33400	8047.25	2
2013	29	2	2902906	2.8632942e+08	35567	8050.42	2
2013	29	2	2901353	1.2027341e+08	14936	8052.59	2
2013	17	1	1718659	1.526677e+07	1895	8056.34	2
2013	29	2	2904308	1.197663e+08	14866	8056.39	2
2013	15	1	1506187	3.9462643e+08	48959	8060.34	2
2013	25	2	2507002	1.9458332e+08	24128	8064.63	2
2013	29	2	2903904	5.5084817e+08	68282	8067.25	2
2013	29	2	2902807	1.8091944e+08	22409	8073.52	2
2013	31	3	3125952	8.73788e+07	10822	8074.18	2
2013	15	1	1508159	3.6131908e+08	44731	8077.6	2
2013	31	3	3112059	3.560427e+07	4406	8080.86	2
2013	25	2	2504702	3.85614e+07	4770	8084.15	2
2013	12	1	1200393	8.206036e+07	10143	8090.34	2
2013	15	1	1500958	2.3060093e+08	28441	8108.05	2
2013	29	2	2901700	9.90341e+07	12206	8113.56	2
2013	25	2	2511301	1.2881298e+08	15870	8116.76	2
2013	17	1	1715101	3.281944e+07	4043	8117.59	2
2013	28	2	2801306	2.6519148e+08	32666	8118.27	2
2013	27	2	2704005	2.0358766e+08	25073	8119.8	2
2013	52	5	5212709	6.167798e+07	7596	8119.8	2
2013	21	2	2105658	2.966329e+07	3653	8120.25	2
2013	31	3	3134608	1.505777e+08	18508	8135.82	2
2013	15	1	1504950	1.6705301e+08	20528	8137.81	2
2013	15	1	1505809	4.5673614e+08	56094	8142.34	2
2013	27	2	2707008	2.412188e+07	2961	8146.53	2
2013	12	1	1200328	5.827089e+07	7147	8153.2	2
2013	26	2	2601409	3.4239829e+08	41987	8154.86	2
2013	31	3	3146255	5.0209e+07	6154	8158.76	2
2013	15	1	1501782	4.7370207e+08	58033	8162.63	2
2013	26	2	2609402	4.8862632e+08	59836	8166.09	2
2013	15	1	1506708	5.1523069e+08	63031	8174.24	2
2013	24	2	2402402	6.456635e+07	7896	8177.1	2
2013	31	3	3126752	4.763943e+07	5825	8178.44	2
2013	31	3	3113503	7.753682e+07	9467	8190.22	2
2013	27	2	2705101	2.0486132e+08	25005	8192.81	2
2013	25	2	2512101	2.6753202e+08	32654	8192.93	2
2013	31	3	3146701	5.52126e+07	6738	8194.21	2
2013	31	3	3161601	3.582648e+07	4372	8194.53	2
2013	29	2	2929404	9.100094e+07	11105	8194.59	2
2013	23	2	2306405	1.00256311e+09	122220	8202.94	2
2013	17	1	1718550	3.638846e+07	4435	8204.84	2
2013	27	2	2702207	4.774044e+07	5817	8207.05	2
2013	35	3	3525805	3.80814e+07	4639	8208.97	2
2013	28	2	2801009	1.4443447e+08	17594	8209.3	2
2013	15	1	1500131	5.75732e+07	7013	8209.5	2
2013	15	1	1505601	6.477493e+07	7889	8210.79	2
2013	24	2	2408706	3.222401e+07	3924	8212.03	2
2013	24	2	2404804	1.799628e+07	2190	8217.48	2
2013	29	2	2916104	1.8355867e+08	22329	8220.64	2
2013	28	2	2802205	4.548771e+07	5529	8227.11	2
2013	15	1	1507300	8.7986971e+08	106940	8227.7	2
2013	31	3	3148806	2.809321e+07	3414	8228.83	2
2013	31	3	3137304	3.537342e+07	4298	8230.2	2
2013	31	3	3122900	5.215721e+07	6334	8234.48	2
2013	31	3	3125804	2.661524e+07	3232	8234.91	2
2013	15	1	1504059	2.359961e+08	28636	8241.24	2
2013	15	1	1501709	9.7837186e+08	118678	8243.92	2
2013	12	1	1200302	2.6720296e+08	32411	8244.21	2
2013	29	2	2927101	7.122762e+07	8632	8251.58	2
2013	52	5	5207907	1.1224602e+08	13596	8255.81	2
2013	25	2	2505808	3.013838e+07	3645	8268.42	2
2013	17	1	1702901	7.971764e+07	9632	8276.33	2
2013	13	1	1304260	1.0610244e+08	12801	8288.61	2
2013	28	2	2801900	3.280557e+07	3955	8294.71	2
2013	31	3	3103306	1.753809e+07	2113	8300.09	2
2013	13	1	1304104	1.5259411e+08	18383	8300.83	2
2013	28	2	2800704	6.739627e+07	8110	8310.27	2
2013	21	2	2103000	1.32480986e+09	159396	8311.44	2
2013	17	1	1719004	2.241499e+07	2695	8317.25	2
2013	31	3	3171501	2.834704e+07	3406	8322.68	2
2013	31	3	3156809	1.3365873e+08	16042	8331.8	2
2013	31	3	3141603	8.959432e+07	10753	8332.03	2
2013	26	2	2605152	1.4935845e+08	17925	8332.41	2
2013	31	3	3168051	2.677882e+07	3210	8342.31	2
2013	21	2	2109106	3.8418161e+08	46039	8344.7	2
2013	17	1	1701309	4.974064e+07	5958	8348.55	2
2013	22	2	2205607	4.397636e+07	5266	8351	2
2013	31	3	3123700	9.029736e+07	10812	8351.59	2
2013	23	2	2313609	2.7748505e+08	33205	8356.72	2
2013	28	2	2803906	1.0448949e+08	12501	8358.49	2
2013	31	3	3102852	6.998421e+07	8371	8360.32	2
2013	29	2	2932200	1.771308e+08	21183	8361.93	2
2013	31	3	3140407	2.491854e+07	2979	8364.73	2
2013	29	2	2916005	1.7347615e+08	20735	8366.34	2
2013	31	3	3121001	4.526054e+07	5409	8367.63	2
2013	31	3	3138906	6.024831e+07	7200	8367.82	2
2013	31	3	3127370	2.700197e+07	3226	8370.11	2
2013	13	1	1302108	5.095943e+07	6083	8377.35	2
2013	13	1	1300102	1.5386691e+08	18351	8384.66	2
2013	51	5	5107297	3.14009e+07	3741	8393.72	2
2013	31	3	3130903	2.0896837e+08	24882	8398.38	2
2013	12	1	1200435	4.513594e+07	5374	8398.95	2
2013	31	3	3157336	6.972307e+07	8298	8402.39	2
2013	24	2	2401305	8.117367e+07	9660	8403.07	2
2013	29	2	2930501	6.9042821e+08	82157	8403.77	2
2013	25	2	2512788	1.560877e+07	1856	8409.9	2
2013	52	5	5205497	5.1769903e+08	61552	8410.76	2
2013	31	3	3132107	1.5416126e+08	18316	8416.75	2
2013	17	1	1717008	3.852014e+07	4576	8417.86	2
2013	31	3	3164100	4.727661e+07	5616	8418.2	2
2013	31	3	3115201	3.416411e+07	4057	8421.03	2
2013	26	2	2608800	3.2463594e+08	38545	8422.26	2
2013	17	1	1714302	3.624606e+07	4301	8427.36	2
2013	17	1	1705607	3.57323e+07	4240	8427.43	2
2013	29	2	2914000	5.2478744e+08	62253	8429.91	2
2013	31	3	3148707	2.0757176e+08	24612	8433.76	2
2013	29	2	2922755	5.837162e+07	6913	8443.75	2
2013	24	2	2400802	1.0052382e+08	11905	8443.83	2
2013	17	1	1720937	1.736575e+07	2056	8446.37	2
2013	28	2	2805208	5.33758e+07	6318	8448.21	2
2013	31	3	3167103	1.8099376e+08	21419	8450.15	2
2013	23	2	2310258	2.654607e+08	31413	8450.66	2
2013	35	3	3505351	4.661131e+07	5514	8453.27	2
2013	31	3	3123528	6.550151e+07	7747	8455.08	2
2013	26	2	2601102	6.8129612e+08	80577	8455.22	2
2013	24	2	2406908	3.265024e+07	3860	8458.61	2
2013	26	2	2610608	4.5788096e+08	54051	8471.28	2
2013	29	2	2905206	4.4202492e+08	52166	8473.43	2
2013	25	2	2504306	2.5250329e+08	29794	8474.97	2
2013	31	3	3163607	2.306328e+07	2721	8476.03	2
2013	31	3	3145406	1.659196e+07	1957	8478.26	2
2013	31	3	3172202	2.220544e+07	2619	8478.6	2
2013	27	2	2706505	1.3044689e+08	15372	8486.01	2
2013	26	2	2609709	1.9994034e+08	23552	8489.31	2
2013	26	2	2610905	5.5517016e+08	65374	8492.22	2
2013	15	1	1503408	9.08109e+07	10693	8492.56	2
2013	24	2	2406700	9.329819e+07	10977	8499.43	2
2013	27	2	2701704	1.4677123e+08	17266	8500.59	2
2013	25	2	2513406	1.2886636e+08	15145	8508.84	2
2013	31	3	3101805	6.329944e+07	7437	8511.42	2
2013	31	3	3132800	1.94189e+07	2281	8513.33	2
2013	31	3	3118908	7.63196e+07	8963	8514.96	2
2013	17	1	1720259	2.581017e+07	3030	8518.21	2
2013	25	2	2517100	2.273083e+07	2668	8519.8	2
2013	35	3	3521200	3.724042e+07	4369	8523.79	2
2013	29	2	2900603	4.064242e+07	4767	8525.79	2
2013	35	3	3542800	2.921991e+07	3427	8526.38	2
2013	29	2	2916500	3.0060795e+08	35255	8526.68	2
2013	25	2	2512507	3.6312296e+08	42586	8526.82	2
2013	29	2	2921708	3.1833393e+08	37326	8528.48	2
2013	17	1	1702208	2.8623758e+08	33524	8538.29	2
2013	17	1	1701002	8.511312e+07	9952	8552.36	2
2013	29	2	2929750	1.0333044e+08	12078	8555.26	2
2013	51	5	5101605	6.479435e+07	7565	8565.02	2
2013	27	2	2707404	7.16679e+07	8362	8570.67	2
2013	28	2	2802809	1.4531287e+08	16940	8578.09	2
2013	29	2	2900801	1.9882308e+08	23176	8578.83	2
2013	31	3	3100906	1.6466357e+08	19186	8582.49	2
2013	31	3	3165578	4.633568e+07	5398	8583.86	2
2013	31	3	3123304	3.87703e+07	4516	8585.1	2
2013	13	1	1304203	5.4006926e+08	62885	8588.2	2
2013	24	2	2415008	2.624833e+07	3056	8589.11	2
2013	24	2	2403905	2.516124e+07	2929	8590.39	2
2013	31	3	3111309	1.0165113e+08	11831	8591.93	2
2013	31	3	3129004	7.598651e+07	8838	8597.7	2
2013	29	2	2933505	1.9823429e+08	23046	8601.68	2
2013	31	3	3167905	3.514301e+07	4085	8602.94	2
2013	28	2	2806800	9.294936e+07	10801	8605.63	2
2013	21	2	2107258	4.407792e+07	5120	8608.97	2
2013	35	3	3552007	5.237247e+07	6083	8609.64	2
2013	31	3	3131109	6.282804e+07	7297	8610.12	2
2013	26	2	2616183	6.768458e+07	7859	8612.37	2
2013	17	1	1701051	2.869676e+07	3332	8612.47	2
2013	29	2	2907301	2.3343194e+08	27097	8614.68	2
2013	29	2	2927705	2.4001077e+08	27854	8616.74	2
2013	31	3	3132503	2.9154609e+08	33804	8624.6	2
2013	15	1	1503457	4.7120152e+08	54609	8628.64	2
2013	41	4	4109500	6.917583e+07	8012	8634.03	2
2013	31	3	3122009	1.7169597e+08	19879	8637.05	2
2013	24	2	2408953	9.165555e+07	10607	8641.04	2
2013	24	2	2400109	9.815632e+07	11355	8644.33	2
2013	21	2	2101202	8.8068231e+08	101851	8646.77	2
2013	51	5	5103379	1.4431113e+08	16689	8647.08	2
2013	24	2	2413607	4.044855e+07	4674	8653.95	2
2013	31	3	3141405	1.8618581e+08	21513	8654.57	2
2013	28	2	2802601	5.042755e+07	5824	8658.58	2
2013	31	3	3102100	1.0515916e+08	12120	8676.5	2
2013	35	3	3505401	6.836174e+07	7878	8677.55	2
2013	31	3	3159357	6.010949e+07	6924	8681.32	2
2013	31	3	3105301	4.864537e+07	5603	8682.02	2
2013	29	2	2901106	2.3001675e+08	26477	8687.42	2
2013	31	3	3122603	4.024556e+07	4632	8688.59	2
2013	31	3	3171402	3.300477e+07	3790	8708.38	2
2013	31	3	3115706	6.134168e+07	7029	8726.94	2
2013	52	5	5201801	7.94885e+07	9108	8727.33	2
2013	23	2	2311306	7.3305978e+08	83990	8727.94	2
2013	35	3	3535101	1.0413731e+08	11922	8734.89	2
2013	28	2	2807303	2.722947e+07	3117	8735.79	2
2013	17	1	1701903	5.867151e+07	6716	8736.08	2
2013	35	3	3521606	7.098308e+07	8123	8738.53	2
2013	21	2	2108207	3.4386898e+08	39337	8741.62	2
2013	15	1	1507201	2.6710089e+08	30550	8743.07	2
2013	22	2	2205581	3.452261e+07	3948	8744.33	2
2013	17	1	1702703	3.169938e+07	3625	8744.66	2
2013	31	3	3140159	1.2438004e+08	14222	8745.61	2
2013	31	3	3135605	7.057921e+07	8069	8746.96	2
2013	31	3	3125002	3.412577e+07	3901	8747.96	2
2013	31	3	3113800	2.246482e+07	2567	8751.39	2
2013	31	3	3127305	6.207071e+07	7092	8752.21	2
2013	31	3	3154002	2.13818e+08	24423	8754.78	2
2013	15	1	1505064	5.9258013e+08	67652	8759.24	2
2013	24	2	2414308	2.101055e+07	2398	8761.7	2
2013	31	3	3154150	6.068371e+07	6920	8769.32	2
2013	24	2	2408300	3.2521323e+08	37079	8770.82	2
2013	24	2	2414506	9.554129e+07	10893	8770.89	2
2013	13	1	1301159	2.3440129e+08	26722	8771.85	2
2013	31	3	3136603	5.04606e+07	5752	8772.71	2
2013	26	2	2601904	5.2840891e+08	60213	8775.66	2
2013	31	3	3144904	3.361132e+07	3830	8775.8	2
2013	29	2	2929305	3.2171537e+08	36641	8780.2	2
2013	31	3	3150406	4.274746e+07	4867	8783.12	2
2013	17	1	1709005	1.1108142e+08	12644	8785.31	2
2013	32	3	3200359	6.888922e+07	7841	8785.77	2
2013	35	3	3538501	1.2544791e+08	14278	8786.1	2
2013	29	2	2906873	2.5354463e+08	28853	8787.46	2
2013	31	3	3147501	1.560763e+07	1776	8788.08	2
2013	15	1	1504703	6.5736713e+08	74768	8792.09	2
2013	29	2	2915908	7.057989e+07	8023	8797.19	2
2013	32	3	3200508	6.964168e+07	7916	8797.58	2
2013	29	2	2914703	5.7935281e+08	65806	8803.95	2
2013	31	3	3162252	4.276991e+07	4858	8804.02	2
2013	23	2	2307007	2.9220202e+08	33174	8808.16	2
2013	29	2	2923001	3.7247967e+08	42265	8812.96	2
2013	31	3	3156106	4.367028e+07	4955	8813.38	2
2013	31	3	3167301	2.001721e+07	2271	8814.27	2
2013	31	3	3109204	9.328942e+07	10583	8815.03	2
2013	31	3	3162575	4.874844e+07	5530	8815.27	2
2013	24	2	2406403	2.432621e+07	2759	8817.04	2
2013	31	3	3126901	8.258574e+07	9366	8817.61	2
2013	15	1	1502707	4.0747254e+08	46206	8818.61	2
2013	25	2	2502706	4.671866e+07	5297	8819.83	2
2013	24	2	2405702	1.1055506e+08	12526	8826.05	2
2013	31	3	3151008	7.421486e+07	8404	8830.9	2
2013	31	3	3125903	9.550808e+07	10807	8837.61	2
2013	21	2	2111573	3.994792e+07	4520	8838.03	2
2013	27	2	2707701	6.3494438e+08	71834	8839.05	2
2013	31	3	3116209	2.499543e+07	2827	8841.68	2
2013	28	2	2801702	1.5507073e+08	17536	8842.99	2
2013	31	3	3162807	1.4174122e+08	16028	8843.35	2
2013	31	3	3149101	1.0340372e+08	11683	8850.78	2
2013	25	2	2516102	1.2761692e+08	14418	8851.22	2
2013	24	2	2409332	4.581897e+07	5174	8855.62	2
2013	31	3	3111705	4.189564e+07	4729	8859.3	2
2013	17	1	1711803	2.005457e+07	2262	8865.86	2
2013	26	2	2606101	2.6606916e+08	30000	8868.97	2
2013	52	5	5209408	3.786569e+07	4267	8874.08	2
2013	25	2	2509701	2.8599466e+08	32211	8878.79	2
2013	28	2	2800209	1.867786e+08	21023	8884.49	2
2013	35	3	3503158	2.258113e+07	2541	8886.71	2
2013	15	1	1500859	2.0986433e+08	23609	8889.17	2
2013	52	5	5209903	1.1706074e+08	13159	8895.87	2
2013	25	2	2509339	3.961532e+07	4453	8896.32	2
2013	52	5	5201702	1.717466e+08	19267	8914.03	2
2013	13	1	1301951	7.33835e+07	8232	8914.42	2
2013	17	1	1720002	2.26761e+07	2543	8917.07	2
2013	31	3	3123908	1.3327761e+08	14940	8920.86	2
2013	31	3	3169208	8.315527e+07	9321	8921.28	2
2013	29	2	2925956	2.1641393e+08	24258	8921.34	2
2013	17	1	1715150	2.095775e+07	2349	8921.99	2
2013	17	1	1707702	7.851601e+07	8800	8922.27	2
2013	12	1	1200609	3.355199e+08	37571	8930.29	2
2013	14	1	1400704	8.15081e+07	9127	8930.44	2
2013	31	3	3165560	2.551636e+07	2856	8934.3	2
2013	27	2	2706703	5.6849508e+08	63595	8939.3	2
2013	26	2	2602407	8.051573e+07	9006	8940.23	2
2013	23	2	2306553	3.5314482e+08	39494	8941.73	2
2013	27	2	2706307	6.5838923e+08	73532	8953.78	2
2013	31	3	3105004	7.255165e+07	8093	8964.74	2
2013	23	2	2306306	4.5043093e+08	50211	8970.76	2
2013	28	2	2801108	3.639922e+07	4057	8971.95	2
2013	31	3	3155900	4.924903e+07	5487	8975.58	2
2013	24	2	2411205	3.4249556e+08	38142	8979.49	2
2013	32	3	3203809	1.3893195e+08	15438	8999.35	2
2013	31	3	3144672	3.297696e+07	3662	9005.18	2
2013	31	3	3158508	7.304959e+07	8106	9011.79	2
2013	31	3	3107703	5.242428e+07	5817	9012.25	2
2013	31	3	3102050	5.05201e+07	5605	9013.4	2
2013	31	3	3159308	4.591751e+07	5090	9021.12	2
2013	31	3	3136553	4.223481e+07	4681	9022.6	2
2013	31	3	3124609	2.253315e+07	2496	9027.71	2
2013	31	3	3161056	3.130714e+07	3467	9030.04	2
2013	24	2	2403004	7.388626e+07	8182	9030.34	2
2013	29	2	2931004	1.9189885e+08	21246	9032.23	2
2013	28	2	2800100	2.131072e+07	2358	9037.63	2
2013	25	2	2515906	5.622725e+07	6218	9042.66	2
2013	31	3	3138708	5.041809e+07	5571	9050.1	2
2013	31	3	3135902	4.433811e+07	4899	9050.44	2
2013	52	5	5217609	7.7867189e+08	86014	9052.85	2
2013	24	2	2413904	1.1143824e+08	12301	9059.28	2
2013	26	2	2616308	2.8868603e+08	31866	9059.37	2
2013	50	5	5006358	1.1890444e+08	13123	9060.77	2
2013	26	2	2600104	3.2976437e+08	36379	9064.69	2
2013	29	2	2914653	2.7802782e+08	30636	9075.2	2
2013	31	3	3159407	3.293515e+07	3628	9078.05	2
2013	31	3	3138005	6.123661e+07	6740	9085.55	2
2013	31	3	3128501	3.62688e+07	3991	9087.65	2
2013	31	3	3110400	2.870074e+07	3158	9088.27	2
2013	35	3	3503505	3.489876e+07	3839	9090.59	2
2013	17	1	1721208	2.1066969e+08	23165	9094.31	2
2013	31	3	3101706	3.7074848e+08	40749	9098.35	2
2013	17	1	1708304	4.653841e+07	5115	9098.42	2
2013	31	3	3154606	2.87495613e+09	315819	9103.18	2
2013	31	3	3145851	4.244334e+07	4660	9108.01	2
2013	28	2	2800407	9.835613e+07	10796	9110.42	2
2013	35	3	3522158	3.039063e+07	3332	9120.84	2
2013	29	2	2929008	1.3691358e+08	15004	9125.14	2
2013	31	3	3164902	2.013076e+07	2206	9125.46	2
2013	31	3	3108107	6.400152e+07	7012	9127.43	2
2013	27	2	2700904	6.163325e+07	6751	9129.5	2
2013	28	2	2800506	1.6288166e+08	17825	9137.82	2
2013	22	2	2204402	9.598992e+07	10504	9138.42	2
2013	28	2	2805000	2.870754e+07	3141	9139.62	2
2013	12	1	1200336	1.5013608e+08	16410	9149.06	2
2013	17	1	1713809	5.654619e+07	6180	9149.87	2
2013	31	3	3132701	2.1528805e+08	23528	9150.29	2
2013	13	1	1302405	3.8068666e+08	41600	9151.12	2
2013	31	3	3142106	9.778229e+07	10674	9160.79	2
2013	29	2	2913705	3.6608118e+08	39938	9166.24	2
2013	31	3	3116704	6.776628e+07	7392	9167.52	2
2013	31	3	3112505	8.610708e+07	9382	9177.9	2
2013	29	2	2921104	2.1490026e+08	23358	9200.28	2
2013	26	2	2613800	1.6208366e+08	17612	9203.02	2
2013	26	2	2611408	1.3079534e+08	14200	9210.94	2
2013	31	3	3166303	6.797964e+07	7375	9217.58	2
2013	12	1	1200351	1.4633884e+08	15857	9228.66	2
2013	26	2	2607406	4.285764e+07	4643	9230.59	2
2013	41	4	4128633	5.391045e+07	5837	9235.99	2
2013	31	3	3107901	9.9375e+07	10759	9236.45	2
2013	26	2	2613404	1.816623e+08	19663	9238.79	2
2013	28	2	2806701	7.8192663e+08	84620	9240.45	2
2013	17	1	1716653	4.902067e+07	5305	9240.47	2
2013	24	2	2402600	6.6398948e+08	71856	9240.56	2
2013	31	3	3154200	1.051809e+08	11378	9244.23	2
2013	13	1	1303403	1.01062026e+09	109225	9252.65	2
2013	31	3	3136108	4.910799e+07	5305	9256.92	2
2013	24	2	2414456	3.153288e+07	3406	9258.04	2
2013	17	1	1720150	1.405518e+07	1518	9259.01	2
2013	28	2	2803401	1.227115e+08	13253	9259.15	2
2013	24	2	2403608	2.4701277e+08	26677	9259.39	2
2013	31	3	3148608	1.6484432e+08	17797	9262.48	2
2013	13	1	1300839	1.1129091e+08	12004	9271.15	2
2013	23	2	2312502	7.270126e+07	7829	9286.15	2
2013	31	3	3134103	5.619571e+07	6051	9287.01	2
2013	51	5	5105309	1.995088e+07	2148	9288.12	2
2013	35	3	3548302	2.753441e+07	2963	9292.75	2
2013	23	2	2303501	6.4055397e+08	68926	9293.36	2
2013	26	2	2608503	1.9724715e+08	21210	9299.72	2
2013	31	3	3144003	2.5534451e+08	27456	9300.14	2
2013	31	3	3133303	2.0076614e+08	21569	9308.09	2
2013	35	3	3526308	4.626631e+07	4966	9316.62	2
2013	28	2	2800670	2.4732859e+08	26529	9322.95	2
2013	23	2	2304202	1.18060524e+09	126591	9326.14	2
2013	15	1	1505551	5.356182e+07	5743	9326.45	2
2013	23	2	2306256	3.5210478e+08	37705	9338.41	2
2013	29	2	2927309	1.3961398e+08	14937	9346.86	2
2013	17	1	1721307	2.189075e+07	2342	9347.03	2
2013	31	3	3129400	4.826539e+07	5163	9348.32	2
2013	26	2	2611903	2.1478036e+08	22970	9350.47	2
2013	31	3	3155405	8.434727e+07	9013	9358.4	2
2013	17	1	1702158	5.034729e+07	5379	9359.97	2
2013	51	5	5106653	5.483644e+07	5855	9365.74	2
2013	31	3	3114105	1.3539767e+08	14451	9369.43	2
2013	29	2	2930105	7.5231396e+08	80258	9373.69	2
2013	27	2	2702405	4.7809799e+08	50999	9374.65	2
2013	52	5	5220686	6.352594e+07	6773	9379.29	2
2013	13	1	1304005	8.392928e+07	8946	9381.77	2
2013	26	2	2611309	2.5098476e+08	26716	9394.55	2
2013	32	3	3203163	1.0732098e+08	11418	9399.28	2
2013	17	1	1713957	3.159608e+07	3356	9414.8	2
2013	24	2	2414407	3.1022658e+08	32942	9417.36	2
2013	29	2	2917300	2.7013683e+08	28639	9432.48	2
2013	26	2	2615607	2.6182422e+08	27756	9433.07	2
2013	31	3	3112109	5.114646e+07	5416	9443.59	2
2013	11	1	1100080	1.4973883e+08	15853	9445.46	2
2013	26	2	2612000	1.023503e+08	10835	9446.27	2
2013	23	2	2313401	6.8131414e+08	72110	9448.26	2
2013	32	3	3202553	8.892094e+07	9400	9459.67	2
2013	15	1	1504422	1.11265073e+09	117614	9460.19	2
2013	26	2	2614857	2.0865627e+08	22046	9464.59	2
2013	24	2	2401800	1.1628883e+08	12286	9465.15	2
2013	31	3	3114808	4.402706e+07	4651	9466.15	2
2013	17	1	1707207	6.938589e+07	7319	9480.24	2
2013	11	1	1101757	9.975106e+07	10518	9483.84	2
2013	15	1	1505403	1.5988239e+08	16854	9486.32	2
2013	31	3	3108909	1.4220484e+08	14982	9491.71	2
2013	52	5	5214903	3.326739e+07	3504	9494.12	2
2013	21	2	2106755	2.5100942e+08	26419	9501.09	2
2013	27	2	2709103	1.8760101e+08	19725	9510.82	2
2013	12	1	1200427	1.5205265e+08	15968	9522.34	2
2013	15	1	1505205	2.8654575e+08	30088	9523.59	2
2013	52	5	5212055	2.296383e+07	2411	9524.61	2
2013	29	2	2928604	5.8501387e+08	61407	9526.83	2
2013	24	2	2405603	1.3679132e+08	14342	9537.81	2
2013	31	3	3111903	5.475689e+07	5739	9541.19	2
2013	12	1	1200344	8.001827e+07	8386	9541.89	2
2013	23	2	2313500	5.1121169e+08	53561	9544.48	2
2013	52	5	5221452	3.392699e+07	3553	9548.83	2
2013	31	3	3104502	1.7379673e+08	18198	9550.32	2
2013	24	2	2404200	2.3376226e+08	24476	9550.67	2
2013	31	3	3130606	6.896349e+07	7217	9555.7	2
2013	31	3	3121506	2.925425e+07	3060	9560.21	2
2013	28	2	2804607	2.4718991e+08	25839	9566.54	2
2013	26	2	2608909	5.3983501e+08	56407	9570.35	2
2013	27	2	2704500	2.996347e+08	31299	9573.3	2
2013	31	3	3158706	2.260849e+07	2361	9575.81	2
2013	31	3	3127206	3.934327e+07	4108	9577.23	2
2013	25	2	2508901	4.1841144e+08	43678	9579.46	2
2013	31	3	3116159	1.1469186e+08	11972	9580.01	2
2013	27	2	2708709	7.401828e+07	7709	9601.54	2
2013	43	4	4300646	7.264027e+07	7560	9608.5	2
2013	22	2	2207702	1.43020772e+09	148832	9609.54	2
2013	31	3	3120607	4.772331e+07	4966	9610.01	2
2013	21	2	2102150	4.415957e+07	4591	9618.73	2
2013	31	3	3150208	4.032716e+07	4192	9620.03	2
2013	21	2	2102804	2.3034996e+08	23939	9622.37	2
2013	23	2	2310704	3.507357e+08	36442	9624.49	2
2013	31	3	3161205	6.417213e+07	6666	9626.78	2
2013	31	3	3102704	8.984968e+07	9333	9627.1	2
2013	51	5	5103254	2.9741079e+08	30848	9641.17	2
2013	26	2	2614501	5.9660407e+08	61875	9642.09	2
2013	29	2	2903409	2.2642411e+08	23471	9646.97	2
2013	25	2	2506004	3.1140149e+08	32264	9651.67	2
2013	31	3	3142403	7.109329e+07	7363	9655.48	2
2013	29	2	2910750	1.7895989e+08	18524	9660.97	2
2013	31	3	3131208	1.8515997e+08	19165	9661.36	2
2013	31	3	3168002	3.1625804e+08	32698	9672.09	2
2013	31	3	3165909	4.414415e+07	4564	9672.25	2
2013	17	1	1702554	1.6582856e+08	17140	9674.94	2
2013	35	3	3556602	1.0682197e+08	11032	9682.92	2
2013	31	3	3160009	3.536808e+07	3650	9689.89	2
2013	35	3	3556354	9.257574e+07	9550	9693.79	2
2013	17	1	1703107	5.391996e+07	5557	9703.07	2
2013	23	2	2302206	4.9922811e+08	51442	9704.68	2
2013	32	3	3203106	1.1368912e+08	11707	9711.21	2
2013	35	3	3527801	4.393533e+07	4523	9713.76	2
2013	31	3	3164209	1.0859904e+08	11179	9714.56	2
2013	51	5	5107776	7.496089e+07	7709	9723.82	2
2013	31	3	3120300	5.816685e+07	5976	9733.41	2
2013	31	3	3101300	2.69484e+07	2768	9735.69	2
2013	52	5	5207808	1.2017355e+08	12342	9736.96	2
2013	31	3	3169059	3.991867e+07	4099	9738.64	2
2013	41	4	4113254	6.221476e+07	6384	9745.42	2
2013	31	3	3109105	1.0926572e+08	11211	9746.3	2
2013	32	3	3202454	2.3962942e+08	24575	9750.94	2
2013	17	1	1710508	7.181158e+07	7363	9753.03	2
2013	43	4	4300604	1.99957042e+09	204750	9765.91	2
2013	32	3	3204252	7.425571e+07	7590	9783.36	2
2013	35	3	3514007	8.262121e+07	8432	9798.53	2
2013	17	1	1705557	4.73698e+07	4827	9813.51	2
2013	26	2	2609808	1.3809919e+08	14071	9814.45	2
2013	31	3	3129806	1.66761961e+09	169908	9814.84	2
2013	26	2	2614204	4.2250846e+08	43036	9817.56	2
2013	31	3	3159902	1.7833556e+08	18162	9819.16	2
2013	31	3	3154457	8.114934e+07	8257	9827.95	2
2013	25	2	2501807	9.3597001e+08	95196	9832.03	2
2013	35	3	3533254	5.005014e+07	5089	9834.97	2
2013	15	1	1507458	2.4652059e+08	25056	9838.78	2
2013	35	3	3533304	3.668676e+07	3728	9840.87	2
2013	28	2	2804102	1.1181998e+08	11350	9851.98	2
2013	29	2	2928802	5.1443796e+08	52186	9857.78	2
2013	31	3	3127388	3.794654e+07	3849	9858.8	2
2013	31	3	3159001	4.152395e+07	4211	9860.83	2
2013	24	2	2406502	1.4738572e+08	14942	9863.86	2
2013	31	3	3128253	4.854131e+07	4919	9868.13	2
2013	35	3	3545001	1.6254744e+08	16462	9874.1	2
2013	32	3	3200169	1.2024868e+08	12164	9885.62	2
2013	31	3	3160801	4.8635e+07	4915	9895.22	2
2013	31	3	3110806	3.667649e+07	3706	9896.52	2
2013	15	1	1504802	5.5574442e+08	56147	9898.03	2
2013	51	5	5107701	1.7227306e+08	17393	9904.73	2
2013	31	3	3100807	4.254355e+07	4293	9909.98	2
2013	12	1	1200708	1.6870832e+08	17021	9911.78	2
2013	15	1	1500800	4.90029695e+09	493976	9920.11	2
2013	28	2	2807600	2.3759252e+08	23950	9920.36	2
2013	31	3	3145505	2.657564e+07	2677	9927.4	2
2013	35	3	3515350	9.666304e+07	9729	9935.56	2
2013	31	3	3100302	1.3619359e+08	13703	9938.96	2
2013	31	3	3155009	2.559732e+07	2575	9940.71	2
2013	21	2	2104107	1.2280853e+08	12343	9949.65	2
2013	26	2	2603009	3.2435959e+08	32596	9950.9	2
2013	51	5	5102793	1.0592723e+08	10626	9968.68	2
2013	12	1	1200054	6.460158e+07	6480	9969.38	2
2013	51	5	5106422	3.2013974e+08	32100	9973.2	2
2013	26	2	2605202	6.6315902e+08	66419	9984.48	2
2013	31	3	3139805	1.236812e+08	12384	9987.18	2
2013	41	4	4100400	1.10137707e+09	110256	9989.27	2
2013	41	4	4117206	5.731245e+07	5733	9996.94	2
2013	31	3	3146602	1.590378e+07	1590	10002.37	2
2013	52	5	5208301	5.047338e+07	5046	10002.65	2
2013	17	1	1718709	2.716458e+07	2715	10005.37	2
2013	23	2	2301901	5.786943e+08	57818	10008.9	2
2013	31	3	3118403	2.3053074e+08	23032	10009.15	2
2013	17	1	1715259	2.60381e+07	2600	10014.65	2
2013	35	3	3554656	2.35787e+07	2354	10016.44	2
2013	50	5	5004809	8.303073e+07	8288	10018.19	2
2013	31	3	3157302	4.655535e+07	4646	10020.52	2
2013	23	2	2306900	3.4761452e+08	34683	10022.62	2
2013	31	3	3103108	1.69647e+07	1692	10026.42	2
2013	31	3	3164803	1.626569e+07	1622	10028.17	2
2013	27	2	2701001	2.715606e+08	27074	10030.31	2
2013	35	3	3549607	4.20402e+07	4190	10033.46	2
2013	29	2	2908101	1.9346104e+08	19281	10033.77	2
2013	31	3	3156205	2.237424e+07	2229	10037.79	2
2013	43	4	4318507	2.6827717e+08	26721	10039.94	2
2013	52	5	5204953	4.382856e+07	4365	10040.91	2
2013	33	3	3302270	9.8869412e+08	98393	10048.42	2
2013	25	2	2512002	1.8013916e+08	17894	10067.01	3
2013	31	3	3119609	3.113881e+07	3093	10067.51	3
2013	31	3	3158409	3.819038e+07	3793	10068.65	3
2013	52	5	5208103	4.876717e+07	4835	10086.28	3
2013	42	4	4201950	1.0975704e+08	10876	10091.67	3
2013	31	3	3119104	2.4738368e+08	24484	10103.89	3
2013	25	2	2504355	4.763465e+07	4714	10104.93	3
2013	43	4	4304713	7.823588e+07	7742	10105.38	3
2013	51	5	5106273	3.855971e+07	3815	10107.39	3
2013	23	2	2308708	6.2972334e+08	62287	10110.03	3
2013	42	4	4212254	7.529248e+07	7447	10110.44	3
2013	31	3	3122470	3.915173e+07	3872	10111.5	3
2013	31	3	3153806	1.956925e+07	1934	10118.54	3
2013	31	3	3142304	4.942436e+07	4883	10121.72	3
2013	31	3	3124906	1.1190705e+08	11042	10134.67	3
2013	17	1	1716307	4.836794e+07	4772	10135.78	3
2013	35	3	3527702	5.458076e+07	5384	10137.58	3
2013	31	3	3149507	3.344513e+07	3296	10147.19	3
2013	31	3	3114709	3.554612e+07	3502	10150.23	3
2013	17	1	1703073	4.437277e+07	4371	10151.63	3
2013	16	1	1600253	4.798864e+07	4722	10162.78	3
2013	29	2	2911709	8.6146743e+08	84645	10177.42	3
2013	31	3	3136405	4.62099e+07	4538	10182.88	3
2013	32	3	3201803	4.774868e+07	4688	10185.3	3
2013	31	3	3151305	1.1333494e+08	11123	10189.24	3
2013	31	3	3122405	6.103384e+07	5990	10189.29	3
2013	52	5	5219803	1.2249946e+08	12016	10194.7	3
2013	31	3	3137403	1.3080032e+08	12808	10212.39	3
2013	31	3	3130507	1.2320786e+08	12061	10215.39	3
2013	42	4	4217253	5.25315e+07	5139	10222.13	3
2013	41	4	4114708	6.168953e+07	6034	10223.65	3
2013	31	3	3149408	1.879166e+07	1838	10223.97	3
2013	35	3	3518909	5.13596e+07	5023	10224.89	3
2013	31	3	3122355	6.462933e+07	6315	10234.26	3
2013	52	5	5216809	1.0796506e+08	10545	10238.51	3
2013	31	3	3143708	3.503952e+07	3421	10242.48	3
2013	31	3	3149952	7.323744e+07	7150	10243	3
2013	31	3	3120102	4.483455e+07	4377	10243.22	3
2013	35	3	3503604	1.1266994e+08	10989	10252.98	3
2013	51	5	5106109	1.1794011e+08	11497	10258.34	3
2013	35	3	3522802	1.5456601e+08	15064	10260.62	3
2013	26	2	2612604	4.1996321e+08	40908	10266.04	3
2013	35	3	3520004	2.4946015e+08	24299	10266.27	3
2013	13	1	1301407	3.403317e+08	33127	10273.54	3
2013	31	3	3109501	1.4656531e+08	14262	10276.63	3
2013	43	4	4302055	2.369054e+07	2305	10277.89	3
2013	35	3	3520608	5.092922e+07	4951	10286.65	3
2013	50	5	5005202	2.172388e+08	21106	10292.75	3
2013	29	2	2917508	8.6828235e+08	84328	10296.49	3
2013	51	5	5106315	2.299132e+07	2232	10300.77	3
2013	52	5	5209200	1.4838536e+08	14397	10306.69	3
2013	15	1	1506583	1.9521529e+08	18934	10310.3	3
2013	23	2	2309706	8.0251317e+08	77723	10325.3	3
2013	52	5	5209291	2.40905e+07	2333	10325.97	3
2013	52	5	5205521	3.693922e+07	3575	10332.65	3
2013	35	3	3523503	1.9957592e+08	19297	10342.33	3
2013	31	3	3149002	2.425401e+07	2345	10342.86	3
2013	31	3	3108404	1.5851608e+08	15326	10342.95	3
2013	31	3	3151701	1.7204183e+08	16633	10343.4	3
2013	28	2	2806602	1.2312763e+08	11899	10347.73	3
2013	17	1	1718881	3.25388e+07	3143	10352.78	3
2013	43	4	4306353	2.955405e+07	2853	10358.94	3
2013	15	1	1501725	1.5851322e+08	15300	10360.34	3
2013	31	3	3135100	7.2568754e+08	70041	10360.9	3
2013	52	5	5204557	3.668374e+07	3540	10362.64	3
2013	31	3	3127404	4.528828e+07	4370	10363.45	3
2013	15	1	1500404	5.6015408e+08	54035	10366.5	3
2013	35	3	3549201	2.720483e+07	2624	10367.7	3
2013	13	1	1302306	1.8023414e+08	17376	10372.59	3
2013	42	4	4210209	3.501905e+07	3375	10376.02	3
2013	31	3	3142502	2.469454e+07	2379	10380.22	3
2013	41	4	4104253	2.777737e+08	26755	10382.12	3
2013	31	3	3120201	1.2512463e+08	12046	10387.24	3
2013	24	2	2408201	2.6803353e+08	25800	10388.9	3
2013	29	2	2925501	3.0254334e+08	29095	10398.47	3
2013	31	3	3160108	4.304771e+07	4138	10403.02	3
2013	29	2	2933208	4.3206863e+08	41524	10405.27	3
2013	35	3	3542503	8.555159e+07	8218	10410.27	3
2013	15	1	1505106	5.2229971e+08	50171	10410.39	3
2013	32	3	3201100	1.0509315e+08	10095	10410.42	3
2013	31	3	3138302	3.432573e+07	3296	10414.36	3
2013	31	3	3104908	1.9845855e+08	19045	10420.51	3
2013	31	3	3121308	5.177865e+07	4968	10422.43	3
2013	31	3	3145703	2.274116e+07	2181	10426.94	3
2013	31	3	3168309	4.150118e+07	3980	10427.43	3
2013	31	3	3104809	5.279743e+07	5062	10430.15	3
2013	21	2	2110039	2.4274912e+08	23256	10438.13	3
2013	35	3	3523701	6.506032e+07	6232	10439.72	3
2013	17	1	1706001	5.549995e+07	5314	10444.1	3
2013	51	5	5100359	6.069169e+07	5809	10447.87	3
2013	41	4	4110078	1.2633637e+08	12087	10452.25	3
2013	31	3	3160603	3.424769e+07	3276	10454.12	3
2013	17	1	1711506	3.872203e+07	3698	10471.07	3
2013	31	3	3165008	1.1477467e+08	10955	10476.92	3
2013	42	4	4202073	9.709183e+07	9259	10486.21	3
2013	31	3	3169703	2.0048341e+08	19114	10488.83	3
2013	31	3	3140530	8.123656e+07	7744	10490.26	3
2013	31	3	3166709	9.148907e+07	8720	10491.87	3
2013	31	3	3134806	8.136455e+07	7755	10491.88	3
2013	31	3	3161007	1.8706002e+08	17811	10502.5	3
2013	31	3	3127602	1.2653308e+08	12030	10518.13	3
2013	31	3	3139607	2.9452577e+08	27983	10525.17	3
2013	28	2	2806008	1.902607e+08	18071	10528.51	3
2013	14	1	1400407	1.0287778e+08	9754	10547.24	3
2013	52	5	5214861	9.110492e+07	8633	10553.1	3
2013	51	5	5105176	1.3616671e+08	12900	10555.56	3
2013	31	3	3102001	1.5106187e+08	14306	10559.34	3
2013	29	2	2932507	2.4286904e+08	22989	10564.58	3
2013	31	3	3118502	1.888387e+07	1785	10579.2	3
2013	31	3	3101003	1.4077987e+08	13306	10580.18	3
2013	31	3	3130002	3.153643e+07	2979	10586.25	3
2013	41	4	4123857	1.1978664e+08	11315	10586.53	3
2013	23	2	2311801	7.7748103e+08	73436	10587.19	3
2013	12	1	1200500	4.2688135e+08	40311	10589.7	3
2013	41	4	4128807	6.436451e+07	6077	10591.49	3
2013	31	3	3126000	7.446834e+07	7026	10598.97	3
2013	31	3	3144375	3.579692e+07	3376	10603.35	3
2013	31	3	3129905	3.716051e+07	3503	10608.2	3
2013	32	3	3200102	3.4557093e+08	32551	10616.29	3
2013	17	1	1700251	2.661278e+07	2506	10619.63	3
2013	17	1	1703305	4.505233e+07	4241	10623.05	3
2013	26	2	2606408	8.5468066e+08	80450	10623.75	3
2013	31	3	3162559	1.1606905e+08	10917	10631.95	3
2013	31	3	3129202	6.822138e+07	6416	10633.01	3
2013	41	4	4115002	7.549477e+07	7100	10633.07	3
2013	31	3	3120805	1.6194651e+08	15227	10635.48	3
2013	35	3	3536802	6.392609e+07	6009	10638.39	3
2013	50	5	5003157	1.5549869e+08	14607	10645.49	3
2013	31	3	3158805	5.102884e+07	4793	10646.53	3
2013	31	3	3171808	1.1553202e+08	10830	10667.78	3
2013	32	3	3204054	2.7423033e+08	25700	10670.44	3
2013	24	2	2408904	2.2721043e+08	21288	10673.17	3
2013	52	5	5218300	3.5995381e+08	33712	10677.32	3
2013	52	5	5214879	3.125017e+07	2926	10680.17	3
2013	29	2	2913457	1.4564163e+08	13636	10680.67	3
2013	31	3	3157906	1.6845643e+08	15772	10680.73	3
2013	29	2	2915502	2.3389833e+08	21884	10688.1	3
2013	52	5	5209606	3.961809e+07	3704	10696.03	3
2013	52	5	5221700	1.5175842e+08	14184	10699.27	3
2013	35	3	3555505	4.966071e+07	4637	10709.66	3
2013	43	4	4301859	3.446124e+07	3216	10715.56	3
2013	41	4	4119509	1.08380419e+09	101053	10725.11	3
2013	28	2	2806305	1.4619225e+08	13628	10727.34	3
2013	24	2	2413359	1.1973346e+08	11159	10729.77	3
2013	31	3	3165206	7.47434e+07	6962	10735.91	3
2013	35	3	3551405	1.3525123e+08	12592	10741.04	3
2013	43	4	4323002	2.68608677e+09	250028	10743.14	3
2013	25	2	2508604	1.3391045e+08	12460	10747.23	3
2013	35	3	3517307	6.083509e+07	5654	10759.65	3
2013	52	5	5213772	4.653904e+07	4325	10760.47	3
2013	12	1	1200807	1.7251946e+08	16029	10762.96	3
2013	31	3	3121902	3.677829e+07	3417	10763.33	3
2013	35	3	3523305	1.7697347e+08	16441	10764.16	3
2013	11	1	1100148	2.3067644e+08	21427	10765.69	3
2013	31	3	3101201	6.757981e+07	6274	10771.41	3
2013	28	2	2804409	2.0428654e+08	18964	10772.33	3
2013	28	2	2806503	4.187275e+07	3886	10775.28	3
2013	35	3	3553104	6.63215e+07	6153	10778.73	3
2013	32	3	3204807	1.1848941e+08	10987	10784.51	3
2013	52	5	5210562	5.039975e+07	4673	10785.31	3
2013	52	5	5219704	1.093972e+08	10142	10786.55	3
2013	11	1	1101302	1.3451724e+08	12469	10788.13	3
2013	52	5	5204854	7.358866e+07	6821	10788.54	3
2013	15	1	1505635	1.3723365e+08	12720	10788.81	3
2013	31	3	3125309	3.693831e+07	3423	10791.21	3
2013	15	1	1507607	5.8728994e+08	54417	10792.4	3
2013	51	5	5107206	5.464474e+07	5063	10792.96	3
2013	31	3	3157104	7.646167e+07	7084	10793.57	3
2013	52	5	5205802	1.1695653e+08	10829	10800.31	3
2013	21	2	2109908	8.8712173e+08	82106	10804.59	3
2013	26	2	2601201	7.7939466e+08	72102	10809.61	3
2013	11	1	1100502	1.1369991e+08	10515	10813.12	3
2013	13	1	1301852	4.8144576e+08	44503	10818.28	3
2013	31	3	3109402	3.0309167e+08	27974	10834.76	3
2013	52	5	5215801	2.608278e+07	2407	10836.22	3
2013	32	3	3203700	2.068222e+08	19081	10839.17	3
2013	31	3	3157005	4.4431805e+08	40942	10852.38	3
2013	52	5	5210604	5.993028e+07	5521	10854.97	3
2013	35	3	3529807	1.3661485e+08	12583	10857.1	3
2013	24	2	2402204	3.581606e+08	32945	10871.47	3
2013	26	2	2608750	2.6325942e+08	24183	10886.14	3
2013	35	3	3553906	7.657255e+07	7028	10895.35	3
2013	24	2	2412401	4.895993e+07	4488	10909.07	3
2013	31	3	3115904	3.249911e+07	2977	10916.73	3
2013	31	3	3155306	6.10246e+07	5585	10926.52	3
2013	24	2	2411809	3.885987e+07	3556	10927.97	3
2013	17	1	1718865	7.711718e+07	7054	10932.4	3
2013	31	3	3132909	1.1557921e+08	10572	10932.58	3
2013	52	5	5200159	2.788172e+07	2550	10934.01	3
2013	31	3	3111606	3.1365563e+08	28683	10935.24	3
2013	35	3	3552700	1.7048929e+08	15590	10935.81	3
2013	35	3	3508702	2.0700673e+08	18926	10937.69	3
2013	28	2	2805307	9.712875e+07	8877	10941.62	3
2013	32	3	3203007	3.2014645e+08	29258	10942.19	3
2013	26	2	2615300	5.9247554e+08	54115	10948.45	3
2013	41	4	4126207	7.568558e+07	6912	10949.88	3
2013	15	1	1504455	3.1802585e+08	28987	10971.33	3
2013	17	1	1707108	7.331114e+07	6681	10973.08	3
2013	52	5	5205208	5.39001e+07	4910	10977.62	3
2013	26	2	2609501	3.4961901e+08	31834	10982.57	3
2013	17	1	1722081	1.2577221e+08	11450	10984.47	3
2013	11	1	1100346	1.911376e+08	17399	10985.55	3
2013	31	3	3144409	5.279771e+07	4802	10994.94	3
2013	11	1	1100403	2.1406392e+08	19459	11000.77	3
2013	29	2	2915601	7.385896e+08	67128	11002.71	3
2013	16	1	1600808	1.5106436e+08	13724	11007.31	3
2013	51	5	5102603	1.6322359e+08	14827	11008.54	3
2013	11	1	1101435	8.679193e+07	7883	11010.01	3
2013	31	3	3154903	1.5830381e+08	14376	11011.67	3
2013	41	4	4107009	1.6105788e+08	14620	11016.27	3
2013	35	3	3503950	2.04304e+07	1854	11019.63	3
2013	41	4	4115457	5.477539e+07	4965	11032.3	3
2013	52	5	5214101	4.333495e+07	3928	11032.32	3
2013	25	2	2510808	1.15546215e+09	104716	11034.25	3
2013	28	2	2803807	3.984394e+07	3610	11037.1	3
2013	25	2	2506301	6.3340169e+08	57383	11038.14	3
2013	35	3	3509304	1.1294269e+08	10232	11038.18	3
2013	14	1	1400050	1.8142915e+08	16428	11043.9	3
2013	35	3	3534906	1.5277897e+08	13829	11047.72	3
2013	23	2	2313807	2.2944451e+08	20768	11047.98	3
2013	52	5	5212006	3.3636e+07	3044	11049.93	3
2013	33	3	3302858	1.88167572e+09	170185	11056.65	3
2013	31	3	3109600	4.13316e+07	3734	11068.99	3
2013	31	3	3112406	7.996594e+07	7222	11072.55	3
2013	31	3	3160504	2.015458e+07	1820	11073.94	3
2013	28	2	2801405	2.3397547e+08	21109	11084.16	3
2013	31	3	3101631	7.194443e+07	6490	11085.43	3
2013	35	3	3545100	5.633823e+07	5079	11092.39	3
2013	51	5	5106174	3.682266e+07	3318	11097.85	3
2013	31	3	3117801	1.2261348e+08	11048	11098.25	3
2013	42	4	4220000	1.2906127e+08	11628	11099.18	3
2013	41	4	4100509	2.3855361e+08	21489	11101.2	3
2013	31	3	3138500	5.996279e+07	5401	11102.17	3
2013	15	1	1500347	2.8753957e+08	25899	11102.34	3
2013	21	2	2106102	1.3009404e+08	11714	11105.86	3
2013	35	3	3542305	4.390732e+07	3952	11110.15	3
2013	17	1	1715705	6.037049e+07	5432	11113.86	3
2013	17	1	1704600	1.541054e+07	1386	11118.72	3
2013	17	1	1703206	5.055843e+07	4547	11119.07	3
2013	41	4	4107124	3.985017e+07	3583	11122.01	3
2013	23	2	2306801	1.2120408e+08	10892	11127.81	3
2013	17	1	1700350	6.329381e+07	5686	11131.52	3
2013	11	1	1100130	3.9665841e+08	35633	11131.77	3
2013	17	1	1713304	1.4653874e+08	13164	11131.78	3
2013	31	3	3166907	8.659472e+07	7778	11133.29	3
2013	51	5	5106505	3.5688859e+08	32053	11134.33	3
2013	31	3	3117702	1.5043526e+08	13499	11144.18	3
2013	35	3	3529104	2.409599e+07	2160	11155.55	3
2013	35	3	3526100	2.1792422e+08	19535	11155.58	3
2013	26	2	2612208	6.58744e+08	59037	11158.16	3
2013	11	1	1101708	1.5056254e+08	13491	11160.22	3
2013	31	3	3135050	4.0299442e+08	36098	11163.9	3
2013	52	5	5221858	1.63790714e+09	146694	11165.47	3
2013	32	3	3203601	6.599738e+07	5909	11168.96	3
2013	31	3	3113305	3.7264942e+08	33358	11171.22	3
2013	31	3	3128105	1.6037126e+08	14349	11176.48	3
2013	17	1	1706100	8.27121e+07	7399	11178.82	3
2013	17	1	1716703	9.669839e+07	8642	11189.35	3
2013	52	5	5201603	4.277894e+07	3823	11189.89	3
2013	35	3	3537206	1.2078536e+08	10791	11193.16	3
2013	35	3	3512605	5.607102e+07	5009	11194.05	3
2013	12	1	1200385	1.9965696e+08	17795	11219.83	3
2013	17	1	1717503	8.049607e+07	7168	11229.92	3
2013	17	1	1713700	2.466741e+07	2196	11232.88	3
2013	17	1	1715754	8.537397e+07	7600	11233.42	3
2013	35	3	3544103	5.2973436e+08	47142	11236.99	3
2013	17	1	1713601	8.191774e+07	7286	11243.17	3
2013	41	4	4117057	1.350413e+08	12010	11244.07	3
2013	16	1	1600212	5.81814e+07	5173	11247.13	3
2013	13	1	1303569	3.2620348e+08	28999	11248.78	3
2013	35	3	3519253	8.363373e+07	7431	11254.71	3
2013	23	2	2310209	3.7056965e+08	32919	11257.01	3
2013	29	2	2907004	1.0830058e+08	9611	11268.4	3
2013	35	3	3503109	7.137805e+07	6334	11269.03	3
2013	42	4	4201000	9.283208e+07	8230	11279.72	3
2013	11	1	1101609	1.2804229e+08	11343	11288.22	3
2013	31	3	3112307	4.1489075e+08	36740	11292.62	3
2013	17	1	1707553	4.396135e+07	3892	11295.31	3
2013	51	5	5106208	4.803185e+07	4252	11296.3	3
2013	31	3	3111002	2.4119348e+08	21340	11302.41	3
2013	31	3	3119005	4.019139e+07	3556	11302.41	3
2013	35	3	3523800	8.828889e+07	7807	11308.94	3
2013	31	3	3165800	2.04015e+07	1804	11309.03	3
2013	52	5	5200803	9.555722e+07	8448	11311.22	3
2013	29	2	2916401	8.4459457e+08	74652	11313.76	3
2013	31	3	3108552	1.7331822e+08	15310	11320.59	3
2013	35	3	3551207	4.197089e+07	3707	11322.06	3
2013	29	2	2904902	3.8781182e+08	34244	11324.96	3
2013	35	3	3516804	5.077201e+07	4482	11327.98	3
2013	35	3	3549003	3.244991e+07	2864	11330.28	3
2013	35	3	3505005	3.736982e+07	3297	11334.49	3
2013	52	5	5204904	2.1856502e+08	19282	11335.18	3
2013	17	1	1717206	3.420453e+07	3017	11337.26	3
2013	29	2	2903276	1.754204e+08	15470	11339.39	3
2013	41	4	4108551	3.759377e+07	3315	11340.5	3
2013	31	3	3140852	1.2038192e+08	10608	11348.22	3
2013	35	3	3510609	4.40171196e+09	387788	11350.82	3
2013	16	1	1600055	5.404196e+07	4761	11350.97	3
2013	17	1	1703909	5.638041e+07	4965	11355.57	3
2013	24	2	2414605	1.5840504e+08	13939	11364.16	3
2013	24	2	2409506	3.984676e+07	3505	11368.55	3
2013	31	3	3162906	2.9691722e+08	26114	11370.04	3
2013	31	3	3162302	3.193392e+07	2808	11372.48	3
2013	35	3	3514809	1.7350942e+08	15238	11386.63	3
2013	11	1	1101484	7.08265e+07	6219	11388.73	3
2013	15	1	1508050	2.0123955e+08	17670	11388.77	3
2013	31	3	3161502	1.2732808e+08	11178	11390.95	3
2013	41	4	4117503	4.372966e+08	38385	11392.38	3
2013	43	4	4311734	3.518257e+07	3087	11397.01	3
2013	25	2	2515708	3.48334e+07	3055	11402.09	3
2013	28	2	2807105	4.5837523e+08	40199	11402.65	3
2013	35	3	3546900	9.830583e+07	8613	11413.66	3
2013	35	3	3548203	7.685312e+07	6733	11414.39	3
2013	35	3	3533106	2.594923e+07	2270	11431.38	3
2013	31	3	3102902	1.3163391e+08	11507	11439.46	3
2013	31	3	3145109	1.8541751e+08	16191	11451.89	3
2013	31	3	3124401	5.296632e+07	4625	11452.18	3
2013	23	2	2305100	4.477361e+07	3909	11453.98	3
2013	31	3	3119708	3.927891e+07	3429	11454.92	3
2013	17	1	1702307	7.841191e+07	6844	11457.03	3
2013	31	3	3110202	4.738512e+07	4135	11459.52	3
2013	31	3	3164431	3.365263e+07	2936	11462.07	3
2013	16	1	1600402	2.1491326e+08	18739	11468.77	3
2013	14	1	1400456	1.3107158e+08	11423	11474.36	3
2013	43	4	4305124	7.487864e+07	6523	11479.17	3
2013	26	2	2612505	1.11294803e+09	96908	11484.58	3
2013	26	2	2605707	3.5706218e+08	31088	11485.53	3
2013	29	2	2932903	1.10611868e+09	96287	11487.73	3
2013	31	3	3115607	1.409662e+07	1227	11488.69	3
2013	31	3	3171709	1.0188258e+08	8864	11493.97	3
2013	52	5	5219605	4.512891e+07	3923	11503.67	3
2013	31	3	3136900	1.1380949e+08	9887	11511.02	3
2013	31	3	3146404	5.41955e+07	4708	11511.36	3
2013	24	2	2409407	3.3878182e+08	29430	11511.44	3
2013	26	2	2613008	6.495969e+08	56413	11515.02	3
2013	35	3	3508900	4.838502e+07	4201	11517.5	3
2013	23	2	2305357	2.2035706e+08	19129	11519.53	3
2013	51	5	5106778	1.3068677e+08	11336	11528.47	3
2013	29	2	2912202	2.2006552e+08	19071	11539.28	3
2013	35	3	3531704	5.056066e+07	4381	11540.89	3
2013	14	1	1400027	1.2039814e+08	10432	11541.23	3
2013	31	3	3137809	2.3616068e+08	20453	11546.51	3
2013	15	1	1502772	2.0766915e+08	17983	11548.08	3
2013	31	3	3124203	2.7833664e+08	24098	11550.2	3
2013	42	4	4210704	3.195941e+07	2767	11550.2	3
2013	31	3	3145455	6.538223e+07	5659	11553.67	3
2013	29	2	2931350	1.77684844e+09	153385	11584.24	3
2013	31	3	3104304	1.6826087e+08	14503	11601.8	3
2013	24	2	2411429	3.071499e+07	2647	11603.7	3
2013	31	3	3118700	1.1018483e+08	9492	11608.18	3
2013	31	3	3170479	3.862183e+07	3326	11612.09	3
2013	29	2	2904704	2.2425462e+08	19311	11612.79	3
2013	32	3	3202652	1.4870024e+08	12798	11619.02	3
2013	31	3	3145059	8.858645e+07	7623	11620.94	3
2013	41	4	4105201	2.0480801e+08	17619	11624.27	3
2013	35	3	3546306	3.7229201e+08	32009	11630.85	3
2013	31	3	3153707	4.037158e+07	3470	11634.46	3
2013	31	3	3171071	6.693097e+07	5746	11648.27	3
2013	41	4	4120309	4.820637e+07	4138	11649.68	3
2013	31	3	3159704	3.900663e+07	3347	11654.21	3
2013	31	3	3163904	5.890903e+07	5054	11655.92	3
2013	31	3	3157278	3.466944e+07	2972	11665.36	3
2013	51	5	5106851	3.912837e+07	3354	11666.18	3
2013	41	4	4110201	1.3170798e+08	11282	11674.17	3
2013	14	1	1400282	1.140947e+08	9762	11687.64	3
2013	17	1	1706506	6.630176e+07	5670	11693.43	3
2013	11	1	1100452	4.2748849e+08	36555	11694.39	3
2013	29	2	2914604	8.4276829e+08	72041	11698.45	3
2013	52	5	5209457	2.600704e+07	2221	11709.61	3
2013	23	2	2309607	7.7896966e+08	66510	11712.07	3
2013	35	3	3550001	1.2556602e+08	10721	11712.16	3
2013	25	2	2500403	2.3775443e+08	20294	11715.5	3
2013	31	3	3126406	3.340347e+07	2850	11720.51	3
2013	31	3	3122702	6.26479e+07	5344	11723.04	3
2013	52	5	5202155	9.11239e+07	7772	11724.64	3
2013	50	5	5000708	2.87909e+08	24534	11735.1	3
2013	31	3	3128808	8.636906e+07	7356	11741.31	3
2013	52	5	5204607	4.159424e+07	3539	11753.11	3
2013	11	1	1100338	3.0832228e+08	26227	11755.91	3
2013	51	5	5100805	1.0696035e+08	9094	11761.64	3
2013	35	3	3505609	3.5893748e+08	30506	11766.13	3
2013	31	3	3126703	3.0578937e+08	25983	11768.82	3
2013	41	4	4121901	1.6170376e+08	13740	11768.83	3
2013	35	3	3501806	6.96384e+07	5916	11771.2	3
2013	35	3	3534807	9.675808e+07	8216	11776.79	3
2013	31	3	3120508	1.23601e+08	10486	11787.24	3
2013	35	3	3551108	1.1356322e+08	9628	11795.1	3
2013	31	3	3149606	5.053537e+07	4284	11796.31	3
2013	23	2	2305506	1.18031357e+09	100053	11796.88	3
2013	31	3	3128402	1.0597909e+08	8977	11805.62	3
2013	52	5	5206800	3.390093e+07	2869	11816.29	3
2013	31	3	3121605	5.6326879e+08	47647	11821.71	3
2013	33	3	3303955	2.7774237e+08	23488	11824.86	3
2013	29	2	2918001	1.90846612e+09	161391	11825.11	3
2013	52	5	5213855	2.824726e+07	2387	11833.79	3
2013	41	4	4103503	9.9721e+07	8423	11839.13	3
2013	28	2	2803500	1.18859651e+09	100330	11846.87	3
2013	52	5	5214705	2.774762e+07	2342	11847.83	3
2013	15	1	1503606	1.16592703e+09	98363	11853.31	3
2013	31	3	3165107	8.603119e+07	7257	11854.93	3
2013	31	3	3135308	4.941564e+07	4168	11855.96	3
2013	27	2	2708501	4.0594098e+08	34239	11856.1	3
2013	35	3	3539400	1.5223106e+08	12839	11856.93	3
2013	32	3	3204500	1.5279179e+08	12881	11861.8	3
2013	15	1	1507409	1.8168408e+08	15301	11874	3
2013	41	4	4113759	6.173402e+07	5193	11887.93	3
2013	51	5	5107404	5.163e+07	4341	11893.57	3
2013	25	2	2516201	8.0928225e+08	68030	11895.96	3
2013	14	1	1400175	1.8316692e+08	15393	11899.36	3
2013	15	1	1506807	3.43360737e+09	288462	11903.15	3
2013	52	5	5207535	8.409082e+07	7064	11904.14	3
2013	43	4	4310702	4.890133e+07	4106	11909.72	3
2013	26	2	2610707	3.77215412e+09	316714	11910.29	3
2013	31	3	3106101	4.167621e+07	3499	11910.89	3
2013	52	5	5210307	3.504359e+07	2938	11927.7	3
2013	51	5	5107750	4.37384e+07	3666	11930.82	3
2013	31	3	3149705	1.1867156e+08	9943	11935.19	3
2013	31	3	3153202	4.688237e+07	3928	11935.43	3
2013	28	2	2804458	1.049808e+08	8788	11945.93	3
2013	29	2	2915304	8.870026e+07	7420	11954.21	3
2013	43	4	4315107	1.2913924e+08	10802	11955.12	3
2013	35	3	3551801	1.5836678e+08	13239	11962.14	3
2013	15	1	1506609	2.8360802e+08	23649	11992.39	3
2013	35	3	3532108	5.250992e+07	4375	12002.27	3
2013	31	3	3103009	1.1692177e+08	9738	12006.75	3
2013	31	3	3165404	7.943882e+07	6616	12007.08	3
2013	33	3	3301405	2.6246845e+08	21844	12015.59	3
2013	21	2	2104305	1.3273929e+08	11046	12016.96	3
2013	35	3	3536570	2.207101e+07	1836	12021.25	3
2013	41	4	4103057	9.651883e+07	8028	12022.77	3
2013	31	3	3137700	2.4309842e+08	20219	12023.27	3
2013	31	3	3125200	2.910154e+07	2419	12030.4	3
2013	51	5	5106158	1.5605173e+08	12946	12054.05	3
2013	43	4	4315404	1.3073132e+08	10845	12054.52	3
2013	31	3	3144607	3.2217131e+08	26725	12055.05	3
2013	35	3	3556958	2.181577e+07	1809	12059.58	3
2013	28	2	2804904	1.6761399e+08	13896	12062.03	3
2013	51	5	5102850	1.0076358e+08	8353	12063.16	3
2013	12	1	1200203	9.697842e+08	80377	12065.44	3
2013	41	4	4122651	6.64736e+07	5509	12066.36	3
2013	35	3	3554607	3.269469e+07	2709	12068.91	3
2013	41	4	4107751	1.0095213e+08	8364	12069.84	3
2013	52	5	5211206	3.2223931e+08	26695	12071.15	3
2013	52	5	5200852	7.017652e+07	5813	12072.34	3
2013	31	3	3117207	3.431545e+07	2840	12082.91	3
2013	43	4	4311775	8.542711e+07	7068	12086.46	3
2013	31	3	3123205	1.6989144e+08	14048	12093.64	3
2013	31	3	3115508	2.6918693e+08	22257	12094.48	3
2013	27	2	2703205	2.9440044e+08	24328	12101.3	3
2013	43	4	4305173	1.332761e+08	11012	12102.81	3
2013	43	4	4311981	4.7321e+07	3906	12114.95	3
2013	42	4	4203204	8.4990714e+08	70068	12129.75	3
2013	35	3	3509106	6.573512e+07	5418	12132.73	3
2013	17	1	1720903	1.9330648e+08	15931	12133.98	3
2013	31	3	3167509	3.189549e+07	2628	12136.79	3
2013	35	3	3554201	5.860954e+07	4828	12139.51	3
2013	27	2	2703601	1.0005098e+08	8234	12150.96	3
2013	41	4	4117800	1.7967661e+08	14780	12156.74	3
2013	43	4	4300307	8.523224e+07	7010	12158.66	3
2013	31	3	3117108	1.2436177e+08	10222	12166.09	3
2013	17	1	1714203	1.1295204e+08	9268	12187.32	3
2013	17	1	1711100	3.03585e+07	2488	12201.97	3
2013	43	4	4307104	8.503611e+07	6969	12202.05	3
2013	11	1	1100809	2.8036011e+08	22973	12203.9	3
2013	43	4	4306502	1.8358557e+08	15038	12208.11	3
2013	51	5	5103353	3.3151854e+08	27144	12213.33	3
2013	29	2	2918407	2.62333791e+09	214748	12215.89	3
2013	31	3	3102803	1.5301249e+08	12507	12234.15	3
2013	41	4	4111704	6.290524e+07	5135	12250.29	3
2013	43	4	4314548	3.284449e+07	2681	12250.83	3
2013	35	3	3538907	2.9533696e+08	24098	12255.66	3
2013	29	2	2909802	7.7642256e+08	63299	12265.95	3
2013	29	2	2924009	1.43981363e+09	117377	12266.57	3
2013	35	3	3554805	5.3816582e+08	43871	12267.01	3
2013	33	3	3303609	5.9754295e+08	48705	12268.62	3
2013	31	3	3155801	2.1844762e+08	17804	12269.58	3
2013	35	3	3554409	1.1005835e+08	8969	12270.97	3
2013	29	2	2917904	1.3497149e+08	10997	12273.48	3
2013	28	2	2804508	4.2750847e+08	34799	12285.08	3
2013	35	3	3518503	1.9845569e+08	16149	12289.04	3
2013	32	3	3202256	1.4694621e+08	11953	12293.67	3
2013	43	4	4300638	8.232108e+07	6693	12299.58	3
2013	31	3	3138609	2.0592448e+08	16740	12301.34	3
2013	31	3	3154309	2.1696164e+08	17631	12305.69	3
2013	17	1	1703883	3.024401e+07	2457	12309.32	3
2013	43	4	4301107	1.7398054e+08	14132	12311.11	3
2013	31	3	3110004	5.3017544e+08	43036	12319.35	3
2013	26	2	2610004	7.6050324e+08	61731	12319.63	3
2013	43	4	4312450	8.003763e+07	6488	12336.26	3
2013	31	3	3113909	1.5116097e+08	12249	12340.68	3
2013	35	3	3548401	5.592838e+07	4532	12340.77	3
2013	31	3	3124005	2.3094817e+08	18707	12345.55	3
2013	35	3	3525508	1.5425192e+08	12492	12348.06	3
2013	21	2	2105153	1.6483066e+08	13347	12349.64	3
2013	16	1	1600279	5.4183824e+08	43832	12361.7	3
2013	41	4	4127882	8.811623e+07	7127	12363.72	3
2013	31	3	3108305	2.2590738e+08	18271	12364.26	3
2013	29	2	2917706	4.0482721e+08	32740	12364.91	3
2013	43	4	4304689	1.524425e+08	12323	12370.57	3
2013	23	2	2307304	3.23244604e+09	261289	12371.15	3
2013	31	3	3123106	6.61076e+07	5343	12372.75	3
2013	27	2	2707800	8.459518e+07	6836	12374.95	3
2013	31	3	3117900	1.3865122e+08	11198	12381.78	3
2013	35	3	3510708	1.5161561e+08	12233	12393.98	3
2013	35	3	3510302	2.3480356e+08	18933	12401.81	3
2013	42	4	4206207	1.3724297e+08	11064	12404.46	3
2013	29	2	2906907	2.7708377e+08	22328	12409.7	3
2013	31	3	3159506	7.177524e+07	5782	12413.57	3
2013	31	3	3114006	1.4129217e+08	11382	12413.65	3
2013	31	3	3114907	2.864405e+07	2307	12416.15	3
2013	51	5	5107883	1.816522e+07	1463	12416.42	3
2013	31	3	3153608	1.2642439e+08	10181	12417.68	3
2013	31	3	3145802	3.929956e+07	3164	12420.85	3
2013	17	1	1700400	9.38255e+07	7553	12422.28	3
2013	43	4	4314209	9.969056e+07	8024	12424.05	3
2013	35	3	3532843	2.595393e+07	2087	12436	3
2013	31	3	3107000	3.312994e+07	2664	12436.16	3
2013	51	5	5106265	9.926142e+07	7979	12440.33	3
2013	35	3	3526506	1.244188e+08	9995	12448.1	3
2013	31	3	3164001	1.0455679e+08	8397	12451.68	3
2013	31	3	3158003	1.359508e+08	10918	12451.99	3
2013	43	4	4302006	1.4308495e+08	11478	12466.02	3
2013	31	3	3167400	7.796477e+07	6249	12476.36	3
2013	26	2	2600054	1.22014893e+09	97786	12477.75	3
2013	35	3	3521150	6.061785e+07	4858	12477.94	3
2013	41	4	4115507	5.922122e+07	4745	12480.76	3
2013	31	3	3123601	3.3416113e+08	26759	12487.8	3
2013	43	4	4321352	6.917908e+07	5539	12489.45	3
2013	35	3	3501509	3.91815e+07	3137	12490.12	3
2013	29	2	2918902	4.960271e+07	3971	12491.24	3
2013	35	3	3547650	1.887653e+07	1511	12492.74	3
2013	32	3	3202306	3.7676855e+08	30144	12498.96	3
2013	52	5	5210901	2.5234184e+08	20161	12516.34	3
2013	31	3	3128907	9.634239e+07	7693	12523.38	3
2013	17	1	1720499	5.416735e+07	4322	12532.94	3
2013	16	1	1600501	2.8811247e+08	22986	12534.26	3
2013	52	5	5221908	4.761056e+07	3798	12535.69	3
2013	35	3	3549508	1.0999513e+08	8759	12557.95	3
2013	31	3	3150604	8.258575e+07	6575	12560.57	3
2013	21	2	2109502	2.5142926e+08	20011	12564.55	3
2013	33	3	3300159	1.3490654e+08	10736	12565.81	3
2013	31	3	3112000	1.8999402e+08	15066	12610.78	3
2013	43	4	4301750	9.252985e+07	7331	12621.72	3
2013	26	2	2609600	4.89999457e+09	388127	12624.72	3
2013	52	5	5211800	5.7187826e+08	45291	12626.75	3
2013	11	1	1101500	1.5793906e+08	12505	12630.07	3
2013	15	1	1502202	8.2851522e+08	65498	12649.47	3
2013	11	1	1100064	2.4276724e+08	19190	12650.72	3
2013	22	2	2203230	6.087403e+07	4811	12653.09	3
2013	52	5	5221403	1.43580491e+09	113447	12656.17	3
2013	52	5	5207501	4.295297e+07	3393	12659.29	3
2013	52	5	5200100	2.1935457e+08	17326	12660.43	3
2013	43	4	4307203	6.645496e+07	5248	12662.91	3
2013	43	4	4304358	1.1669554e+08	9214	12665.03	3
2013	51	5	5108352	3.863364e+07	3050	12666.77	3
2013	32	3	3202702	1.8840739e+08	14844	12692.49	3
2013	35	3	3521507	9.738604e+07	7666	12703.63	3
2013	25	2	2503704	7.7033946e+08	60612	12709.36	3
2013	11	1	1100254	2.9263624e+08	23017	12713.92	3
2013	35	3	3507159	4.798142e+07	3772	12720.42	3
2013	35	3	3554904	7.212574e+07	5669	12722.83	3
2013	41	4	4124202	3.530545e+07	2774	12727.27	3
2013	32	3	3201001	1.9316893e+08	15169	12734.45	3
2013	41	4	4102505	1.6157681e+08	12683	12739.64	3
2013	41	4	4112702	1.5784524e+08	12387	12742.81	3
2013	33	3	3302809	2.3029456e+08	18072	12743.17	3
2013	50	5	5004007	1.2780532e+08	10025	12748.66	3
2013	31	3	3147808	2.704954e+07	2121	12753.2	3
2013	24	2	2407609	5.673384e+07	4448	12754.91	3
2013	52	5	5203939	3.32574e+07	2606	12761.86	3
2013	31	3	3114600	5.210326e+07	4081	12767.28	3
2013	43	4	4301636	1.518722e+08	11895	12767.73	3
2013	51	5	5106828	1.4457796e+08	11317	12775.29	3
2013	31	3	3137502	2.28559e+08	17885	12779.37	3
2013	35	3	3518008	2.58828e+07	2023	12794.27	3
2013	52	5	5204656	4.792679e+07	3745	12797.54	3
2013	17	1	1712454	3.643597e+07	2847	12798.02	3
2013	43	4	4314704	1.3746967e+08	10739	12800.97	3
2013	33	3	3301876	3.1732649e+08	24788	12801.62	3
2013	31	3	3148905	5.1284e+07	4006	12801.8	3
2013	31	3	3141900	5.070902e+07	3957	12815.02	3
2013	52	5	5219506	3.620057e+07	2823	12823.44	3
2013	41	4	4110300	3.975788e+07	3100	12825.12	3
2013	31	3	3119401	1.38977944e+09	108302	12832.44	3
2013	11	1	1101807	1.0813391e+08	8425	12834.89	3
2013	17	1	1712504	6.071623e+07	4730	12836.41	3
2013	11	1	1100940	2.4922269e+08	19410	12839.91	3
2013	26	2	2611002	4.4340736e+08	34523	12843.82	3
2013	42	4	4215653	1.0611396e+08	8261	12845.17	3
2013	33	3	3306156	1.2669437e+08	9861	12848.02	3
2013	24	2	2401404	1.1625553e+08	9048	12848.75	3
2013	26	2	2604007	1.01910103e+09	79308	12849.91	3
2013	43	4	4306908	3.2849719e+08	25563	12850.49	3
2013	43	4	4302451	1.0167104e+08	7910	12853.48	3
2013	24	2	2411601	3.8139e+07	2967	12854.4	3
2013	31	3	3160702	6.1148856e+08	47557	12858.01	3
2013	15	1	1508084	4.6340518e+08	36021	12864.86	3
2013	35	3	3537701	7.243321e+07	5626	12874.73	3
2013	12	1	1200104	2.9487425e+08	22899	12877.17	3
2013	35	3	3551009	4.5148322e+09	350465	12882.41	3
2013	31	3	3108008	2.2940701e+08	17805	12884.41	3
2013	31	3	3170305	3.543426e+07	2746	12903.95	3
2013	32	3	3201704	1.6236657e+08	12579	12907.75	3
2013	14	1	1400605	9.316006e+07	7210	12920.95	3
2013	50	5	5005806	1.858365e+08	14379	12924.16	3
2013	21	2	2104552	2.21052e+08	17094	12931.56	3
2013	52	5	5221577	3.864922e+07	2986	12943.48	3
2013	31	3	3110301	1.8460207e+08	14250	12954.53	3
2013	28	2	2805703	3.8205117e+08	29467	12965.39	3
2013	52	5	5219902	8.188152e+07	6315	12966.2	3
2013	31	3	3106903	1.8509025e+08	14268	12972.4	3
2013	41	4	4105102	1.47745e+08	11382	12980.58	3
2013	11	1	1101450	7.109693e+07	5477	12981	3
2013	31	3	3144300	5.4370899e+08	41876	12983.79	3
2013	29	2	2925303	1.83180935e+09	141006	12991	3
2013	51	5	5106703	2.181291e+07	1679	12991.61	3
2013	35	3	3528908	5.27077e+07	4057	12991.79	3
2013	35	3	3544202	1.4851757e+08	11429	12994.8	3
2013	29	2	2930774	3.0458971e+08	23435	12997.21	3
2013	31	3	3169000	2.1437688e+08	16494	12997.26	3
2013	41	4	4103107	1.5372615e+08	11826	12999	3
2013	35	3	3510203	6.1808282e+08	47510	13009.53	3
2013	11	1	1100700	1.8140793e+08	13939	13014.42	3
2013	52	5	5201207	1.408459e+07	1082	13017.18	3
2013	41	4	4117271	9.24581e+07	7100	13022.27	3
2013	17	1	1705102	4.380198e+07	3362	13028.55	3
2013	17	1	1710904	4.807989e+07	3690	13029.78	3
2013	51	5	5103007	2.3969318e+08	18393	13031.76	3
2013	31	3	3100203	3.0577259e+08	23451	13038.79	3
2013	33	3	3302502	3.0314571e+09	232419	13043.07	3
2013	43	4	4311122	5.477674e+07	4199	13045.19	3
2013	43	4	4321436	1.3658172e+08	10467	13048.79	3
2013	52	5	5220157	6.37441e+07	4884	13051.62	3
2013	32	3	3204401	1.5657208e+08	11993	13055.29	3
2013	52	5	5218391	4.441697e+07	3401	13059.97	3
2013	27	2	2700300	2.97362093e+09	227640	13062.82	3
2013	35	3	3507704	6.983342e+07	5345	13065.19	3
2013	31	3	3107307	6.3994794e+08	48974	13067.1	3
2013	31	3	3170602	2.895969e+07	2216	13068.45	3
2013	35	3	3534104	8.325007e+07	6366	13077.3	3
2013	52	5	5205513	2.4385407e+08	18623	13094.24	3
2013	51	5	5101308	1.3038029e+08	9955	13096.97	3
2013	31	3	3146909	1.9679727e+08	15007	13113.7	3
2013	35	3	3540259	5.695084e+07	4341	13119.29	3
2013	43	4	4311254	8.485578e+07	6467	13121.35	3
2013	14	1	1400209	2.5859178e+08	19696	13129.15	3
2013	26	2	2613909	1.09072619e+09	83051	13133.21	3
2013	43	4	4308300	1.4375194e+08	10945	13134.03	3
2013	35	3	3521002	4.1702361e+08	31745	13136.67	3
2013	35	3	3500758	7.036296e+07	5356	13137.22	3
2013	52	5	5208400	1.4473116e+08	11001	13156.18	3
2013	28	2	2804003	2.237588e+08	16998	13163.83	3
2013	33	3	3300456	6.2886035e+09	477583	13167.56	3
2013	35	3	3515103	8.7278723e+08	66273	13169.57	3
2013	33	3	3303005	3.5278295e+08	26786	13170.42	3
2013	17	1	1701101	5.932003e+07	4504	13170.52	3
2013	24	2	2403103	5.8649865e+08	44528	13171.46	3
2013	52	5	5207600	8.298436e+07	6298	13176.3	3
2013	14	1	1400308	2.0943941e+08	15890	13180.58	3
2013	35	3	3538303	4.832275e+07	3665	13184.93	3
2013	31	3	3113602	8.708133e+07	6604	13186.15	3
2013	41	4	4126256	1.16715757e+09	88365	13208.37	3
2013	33	3	3301850	7.2273781e+08	54706	13211.31	3
2013	31	3	3113404	1.18431093e+09	89578	13221	3
2013	11	1	1100106	6.0513083e+08	45761	13223.72	3
2013	31	3	3131000	8.026289e+07	6068	13227.24	3
2013	11	1	1101401	2.0560021e+08	15541	13229.54	3
2013	35	3	3530003	3.926878e+07	2968	13230.72	3
2013	31	3	3152907	1.1883945e+08	8975	13241.16	3
2013	31	3	3161809	1.4949024e+08	11289	13242.12	3
2013	11	1	1100379	1.832102e+08	13827	13250.18	3
2013	51	5	5108808	6.269122e+07	4731	13251.16	3
2013	15	1	1502400	2.43732651e+09	183917	13252.32	3
2013	35	3	3536257	2.807478e+07	2118	13255.32	3
2013	11	1	1100015	3.4132469e+08	25728	13266.66	3
2013	11	1	1101476	4.772707e+07	3597	13268.58	3
2013	35	3	3546504	7.574278e+07	5701	13285.88	3
2013	41	4	4119251	3.623322e+07	2724	13301.48	3
2013	11	1	1101005	1.401403e+08	10534	13303.62	3
2013	35	3	3505104	9.313374e+07	6998	13308.62	3
2013	26	2	2606002	1.79879502e+09	135138	13310.8	3
2013	52	5	5200829	4.829533e+07	3625	13322.85	3
2013	11	1	1101559	6.768081e+07	5080	13322.99	3
2013	32	3	3200201	4.3033181e+08	32267	13336.59	3
2013	43	4	4312377	4.296931e+07	3221	13340.36	3
2013	24	2	2402006	8.837978e+08	66246	13341.15	3
2013	41	4	4103156	5.102162e+07	3824	13342.47	3
2013	51	5	5102504	1.19678056e+09	89683	13344.56	3
2013	31	3	3101904	2.5879191e+08	19391	13345.98	3
2013	33	3	3301801	1.802524e+08	13505	13347.09	3
2013	35	3	3516002	1.8296823e+08	13704	13351.45	3
2013	12	1	1200138	1.202101e+08	9003	13352.23	3
2013	42	4	4206009	1.8234464e+08	13655	13353.69	3
2013	52	5	5220702	3.936187e+07	2941	13383.84	3
2013	43	4	4320354	7.278789e+07	5438	13385.05	3
2013	52	5	5203401	1.171727e+08	8752	13388.11	3
2013	25	2	2511202	3.7567881e+08	28056	13390.32	3
2013	13	1	1302504	1.22992935e+09	91795	13398.65	3
2013	41	4	4104451	1.7970904e+08	13396	13415.13	3
2013	22	2	2203909	7.8611956e+08	58586	13418.22	3
2013	41	4	4121000	1.6336031e+08	12171	13422.09	3
2013	52	5	5208806	5.0638803e+08	37713	13427.41	3
2013	35	3	3517208	1.5292526e+08	11385	13432.17	3
2013	43	4	4315305	3.1749763e+08	23631	13435.64	3
2013	42	4	4207205	1.5188559e+08	11301	13440.01	3
2013	32	3	3203403	3.6714553e+08	27309	13444.12	3
2013	42	4	4200507	8.490509e+07	6313	13449.25	3
2013	43	4	4305132	6.239254e+07	4639	13449.57	3
2013	35	3	3523206	6.700515e+08	49818	13449.99	3
2013	11	1	1101203	1.4664054e+08	10899	13454.49	3
2013	35	3	3535200	1.3051443e+08	9700	13455.1	3
2013	11	1	1100098	4.2654622e+08	31699	13456.14	3
2013	52	5	5213004	1.6844978e+08	12513	13461.98	3
2013	35	3	3556800	2.4494857e+08	18191	13465.37	3
2013	11	1	1101492	2.4594827e+08	18265	13465.55	3
2013	41	4	4108700	8.773396e+07	6515	13466.46	3
2013	41	4	4106555	5.234426e+07	3887	13466.49	3
2013	51	5	5103809	4.916817e+07	3651	13467.04	3
2013	31	3	3143401	3.0400438e+08	22557	13477.16	3
2013	41	4	4102901	2.2148647e+08	16416	13492.11	3
2013	42	4	4215687	3.749178e+07	2776	13505.69	3
2013	16	1	1600550	5.777635e+07	4277	13508.62	3
2013	35	3	3548609	1.4634684e+08	10831	13511.85	3
2013	51	5	5103437	6.707568e+07	4961	13520.6	3
2013	35	3	3515129	4.261079e+07	3149	13531.53	3
2013	32	3	3200136	1.3612014e+08	10045	13551.03	3
2013	15	1	1500503	4.5491807e+08	33562	13554.56	3
2013	50	5	5005608	3.6184884e+08	26670	13567.64	3
2013	31	3	3151404	3.6380171e+08	26797	13576.21	3
2013	31	3	3132008	7.115956e+07	5241	13577.48	3
2013	52	5	5218904	2.6695344e+08	19661	13577.82	3
2013	33	3	3304904	1.394316811e+10	1025507	13596.37	3
2013	35	3	3526209	4.1120001e+08	30239	13598.33	3
2013	52	5	5210208	4.3709732e+08	32143	13598.52	3
2013	29	2	2907509	7.4921433e+08	55021	13616.88	3
2013	51	5	5101209	1.394968e+07	1024	13622.73	3
2013	43	4	4314605	2.8087063e+08	20614	13625.24	3
2013	43	4	4317004	1.1520505e+08	8455	13625.67	3
2013	52	5	5218607	1.4850697e+08	10899	13625.74	3
2013	35	3	3544707	3.353146e+07	2460	13630.68	3
2013	51	5	5108956	1.1510726e+08	8444	13631.84	3
2013	16	1	1600709	1.9491218e+08	14292	13637.85	3
2013	35	3	3541109	5.735313e+07	4205	13639.27	3
2013	23	2	2307601	7.8269388e+08	57372	13642.44	3
2013	41	4	4100301	1.2002872e+08	8797	13644.28	3
2013	31	3	3168804	1.0175647e+08	7457	13645.76	3
2013	31	3	3139508	3.0530458e+08	22348	13661.38	3
2013	52	5	5202601	4.917485e+07	3599	13663.47	3
2013	22	2	2208007	1.03969804e+09	76042	13672.68	3
2013	31	3	3130200	1.3690357e+08	9997	13694.47	3
2013	52	5	5204201	1.967607e+07	1436	13702	3
2013	52	5	5212808	1.454079e+08	10610	13704.8	3
2013	35	3	3535606	2.4727883e+08	18040	13707.25	3
2013	17	1	1702000	1.2156218e+08	8868	13707.96	3
2013	31	3	3132206	1.7827872e+08	12999	13714.8	3
2013	41	4	4100905	7.980572e+07	5815	13724.11	3
2013	50	5	5007950	1.4797435e+08	10777	13730.57	3
2013	31	3	3143005	1.8449598e+08	13435	13732.49	3
2013	31	3	3168606	1.92370982e+09	140067	13734.21	3
2013	31	3	3106408	1.0707851e+08	7789	13747.4	3
2013	52	5	5203104	5.770321e+07	4197	13748.68	3
2013	51	5	5106000	8.539939e+07	6209	13754.13	3
2013	23	2	2303709	4.75060156e+09	344936	13772.41	3
2013	41	4	4110904	6.423212e+07	4659	13786.67	3
2013	35	3	3531100	6.9853389e+08	50641	13793.84	3
2013	32	3	3204955	1.6804808e+08	12179	13798.18	3
2013	23	2	2301109	9.9030487e+08	71749	13802.35	3
2013	31	3	3107505	9.199488e+07	6663	13806.83	3
2013	31	3	3110905	2.2397497e+08	16215	13812.83	3
2013	52	5	5213905	6.833494e+07	4940	13832.98	3
2013	31	3	3115102	2.4860626e+08	17967	13836.83	3
2013	32	3	3202108	3.3663501e+08	24327	13837.92	3
2013	41	4	4117214	5.682877e+07	4106	13840.42	3
2013	35	3	3504909	1.4782505e+08	10680	13841.3	3
2013	28	2	2802908	1.27212774e+09	91873	13846.59	3
2013	15	1	1507755	7.471059e+07	5395	13848.12	3
2013	52	5	5211404	1.2333547e+08	8893	13868.83	3
2013	32	3	3202009	9.473041e+07	6827	13875.85	3
2013	15	1	1506138	1.09638408e+09	79010	13876.52	3
2013	11	1	1100155	5.5644337e+08	40099	13876.74	3
2013	32	3	3204104	3.6116866e+08	26023	13878.83	3
2013	32	3	3201605	4.2560824e+08	30659	13882	3
2013	43	4	4314498	6.545488e+07	4715	13882.27	3
2013	35	3	3543238	3.121611e+07	2248	13886.17	3
2013	35	3	3540101	4.914372e+07	3537	13894.18	3
2013	31	3	3102308	2.1761114e+08	15642	13911.98	3
2013	31	3	3150109	4.016789e+07	2887	13913.36	3
2013	31	3	3118304	1.71666885e+09	123275	13925.52	3
2013	17	1	1718840	4.750401e+07	3411	13926.71	3
2013	31	3	3165305	1.0341577e+08	7420	13937.43	3
2013	33	3	3301504	2.9083224e+08	20863	13940.1	3
2013	35	3	3538600	3.6764115e+08	26371	13941.12	3
2013	43	4	4322152	6.364255e+07	4565	13941.41	3
2013	42	4	4207601	6.581898e+07	4713	13965.41	3
2013	52	5	5209804	5.596147e+07	4006	13969.41	3
2013	35	3	3553005	1.6816269e+08	12034	13973.96	3
2013	52	5	5215256	5.876336e+07	4204	13977.96	3
2013	41	4	4113429	5.439708e+07	3891	13980.23	3
2013	42	4	4202057	1.3043669e+08	9330	13980.35	3
2013	35	3	3532801	8.902634e+07	6367	13982.46	3
2013	12	1	1200450	2.9083802e+08	20799	13983.27	3
2013	15	1	1504752	2.1304508e+08	15232	13986.68	3
2013	50	5	5007307	6.979587e+07	4989	13989.95	3
2013	41	4	4116208	2.2853698e+08	16325	13999.2	3
2013	35	3	3541208	1.9212545e+08	13724	13999.23	3
2013	41	4	4125555	3.037907e+07	2170	13999.57	3
2013	35	3	3527504	3.282945e+07	2345	13999.77	3
2013	35	3	3527256	3.118791e+07	2227	14004.45	3
2013	22	2	2201903	3.3370216e+08	23826	14005.8	3
2013	43	4	4302659	6.86868e+07	4902	14011.99	3
2013	35	3	3557204	1.7491877e+08	12480	14015.93	3
2013	35	3	3508009	2.7207534e+08	19395	14028.12	3
2013	35	3	3500402	1.1141262e+08	7942	14028.28	3
2013	35	3	3516606	9.854388e+07	7019	14039.59	3
2013	43	4	4300505	1.1052639e+08	7871	14042.23	3
2013	14	1	1400233	1.2394484e+08	8826	14043.15	3
2013	35	3	3522109	1.31812391e+09	93696	14068.09	3
2013	24	2	2405801	4.7938904e+08	34057	14076.08	3
2013	43	4	4301073	4.024713e+07	2857	14087.2	3
2013	28	2	2804805	2.4311841e+09	172547	14089.98	3
2013	31	3	3131406	5.989615e+07	4250	14093.21	3
2013	15	1	1505031	3.5542642e+08	25203	14102.54	3
2013	52	5	5215603	4.2391501e+08	30059	14102.76	3
2013	41	4	4122909	7.398579e+07	5246	14103.28	3
2013	43	4	4304507	7.8277459e+08	55462	14113.71	3
2013	32	3	3204708	4.9727759e+08	35232	14114.37	3
2013	52	5	5219456	4.661326e+07	3301	14120.95	3
2013	31	3	3114204	3.0084183e+08	21294	14128.01	3
2013	11	1	1100296	1.2566167e+08	8887	14139.94	3
2013	27	2	2700607	1.1471004e+08	8112	14140.78	3
2013	35	3	3523107	4.87890621e+09	344558	14159.9	3
2013	31	3	3114402	3.0033398e+08	21206	14162.69	3
2013	41	4	4119954	3.2997802e+08	23261	14185.89	3
2013	41	4	4116109	1.8171629e+08	12800	14196.59	3
2013	28	2	2804300	1.0791818e+08	7598	14203.5	3
2013	33	3	3305109	6.54553164e+09	460799	14204.74	3
2013	35	3	3526605	9.887065e+07	6950	14225.99	3
2013	35	3	3553203	7.975244e+07	5606	14226.27	3
2013	35	3	3528205	5.344235e+07	3756	14228.53	3
2013	41	4	4118303	4.241995e+07	2980	14234.88	3
2013	52	5	5221007	5.16541e+07	3628	14237.62	3
2013	35	3	3530409	6.51239e+07	4574	14237.84	3
2013	52	5	5214051	8.800158e+07	6180	14239.74	3
2013	24	2	2411056	5.610319e+07	3935	14257.48	3
2013	31	3	3148202	7.911328e+07	5548	14259.78	3
2013	35	3	3515707	2.57217167e+09	180326	14264.01	3
2013	31	3	3116407	6.777839e+07	4751	14266.13	3
2013	41	4	4124707	1.6537349e+08	11588	14271.1	3
2013	21	2	2111607	2.5821363e+08	18093	14271.47	3
2013	17	1	1705508	4.721281e+08	33078	14273.18	3
2013	43	4	4321832	4.215447e+07	2953	14275.13	3
2013	41	4	4106209	2.4371576e+08	17067	14279.94	3
2013	42	4	4203709	1.6117056e+08	11286	14280.57	3
2013	50	5	5001102	6.6890562e+08	46830	14283.7	3
2013	33	3	3305752	4.5503138e+08	31844	14289.39	3
2013	16	1	1600535	2.6755818e+08	18708	14301.81	3
2013	31	3	3152709	1.2601542e+08	8807	14308.55	3
2013	51	5	5107578	5.333924e+07	3726	14315.41	3
2013	35	3	3533007	2.9143003e+08	20346	14323.7	3
2013	24	2	2412203	6.0661742e+08	42345	14325.6	3
2013	28	2	2800605	3.9388227e+08	27495	14325.6	3
2013	43	4	4310538	7.551801e+07	5268	14335.23	3
2013	25	2	2513703	1.905403e+09	132871	14340.25	3
2013	35	3	3547700	3.021082e+08	21059	14345.8	3
2013	52	5	5208004	1.55810339e+09	108503	1.436e+04	3
2013	42	4	4217154	2.724271e+07	1897	14360.95	3
2013	32	3	3204351	2.7145395e+08	18892	14368.73	3
2013	43	4	4305454	1.9896821e+08	13844	14372.16	3
2013	32	3	3205176	2.1006242e+08	14614	14374.05	3
2013	52	5	5215900	5.255208e+07	3656	14374.2	3
2013	41	4	4121208	2.6020242e+08	18089	14384.57	3
2013	31	3	3170503	1.52209e+08	10581	14385.12	3
2013	42	4	4215075	6.919655e+07	4810	14385.98	3
2013	52	5	5221304	4.166852e+07	2895	14393.27	3
2013	32	3	3201159	1.8236709e+08	12669	14394.75	3
2013	35	3	3502606	6.431972e+07	4468	14395.64	3
2013	35	3	3538204	2.0264452e+08	14067	14405.67	3
2013	17	1	1703701	7.779856e+07	5400	14407.14	3
2013	35	3	3508603	4.5837936e+08	31791	14418.53	3
2013	51	5	5104104	4.8113834e+08	33326	14437.33	3
2013	11	1	1100908	5.326305e+07	3689	14438.34	3
2013	41	4	4115101	1.5199728e+08	10526	14440.18	3
2013	41	4	4116950	7.535784e+07	5218	14441.9	3
2013	26	2	2615409	5.7642206e+08	39913	14441.96	3
2013	52	5	5200605	1.049152e+08	7262	14447.15	3
2013	11	1	1101104	1.3958926e+08	9661	14448.74	3
2013	35	3	3547205	2.354582e+07	1629	14454.16	3
2013	17	1	1718899	3.259605e+07	2255	14455.01	3
2013	41	4	4123709	1.2926581e+08	8935	14467.35	3
2013	33	3	3304102	2.6313963e+08	18188	14467.76	3
2013	31	3	3110707	1.8815282e+08	12997	14476.63	3
2013	35	3	3511201	1.0867629e+08	7502	14486.31	3
2013	35	3	3551504	6.0534115e+08	41728	14506.83	3
2013	31	3	3115805	1.536893e+08	10583	14522.28	3
2013	24	2	2400208	8.1841643e+08	56354	14522.77	3
2013	35	3	3522000	5.093704e+07	3505	14532.68	3
2013	33	3	3304607	1.4943137e+08	10282	14533.3	3
2013	35	3	3537909	4.0518947e+08	27880	14533.34	3
2013	52	5	5219001	1.1288744e+08	7766	14536.11	3
2013	41	4	4103206	9.980909e+07	6866	14536.72	3
2013	32	3	3204609	3.4062768e+08	23432	14536.86	3
2013	17	1	1702406	1.5747844e+08	10833	14536.92	3
2013	50	5	5004106	1.4954679e+08	10287	14537.45	3
2013	43	4	4309159	6.059407e+07	4168	14537.92	3
2013	21	2	2100055	1.56727045e+09	107790	14540.04	3
2013	52	5	5202502	1.2125017e+08	8335	14547.11	3
2013	41	4	4106803	2.7210966e+08	18702	14549.76	3
2013	16	1	1600204	1.4250162e+08	9793	14551.38	3
2013	43	4	4312443	4.693111e+07	3225	14552.28	3
2013	41	4	4116406	5.899831e+07	4053	14556.7	3
2013	35	3	3550209	4.7487116e+08	32621	14557.22	3
2013	31	3	3113701	2.9452384e+08	20214	14570.29	3
2013	31	3	3111507	2.1815048e+08	14964	14578.35	3
2013	42	4	4202081	4.17681e+07	2865	14578.74	3
2013	43	4	4308433	3.700504e+07	2537	14586.14	3
2013	31	3	3111200	7.8282368e+08	53656	14589.68	3
2013	15	1	1505437	4.3108955e+08	29547	14589.96	3
2013	43	4	4315008	7.895047e+07	5410	14593.43	3
2013	31	3	3143203	3.1937814e+08	21878	14598.14	3
2013	31	3	3103207	3.40933e+07	2335	14600.98	3
2013	51	5	5103361	5.268555e+07	3607	14606.47	3
2013	31	3	3131505	1.4524581e+08	9942	14609.31	3
2013	35	3	3514502	1.8387826e+08	12585	14610.91	3
2013	43	4	4320263	1.0741666e+08	7343	14628.44	3
2013	31	3	3140209	4.267768e+07	2917	14630.68	3
2013	50	5	5007703	1.5913861e+08	10876	14632.09	3
2013	43	4	4308805	1.2708845e+08	8685	14633.1	3
2013	32	3	3203502	2.7899176e+08	19049	14646.01	3
2013	50	5	5002100	3.4989069e+08	23888	14647.13	3
2013	33	3	3303856	3.9109193e+08	26696	14649.83	3
2013	41	4	4115739	5.516581e+07	3765	14652.27	3
2013	17	1	1712009	4.332121e+07	2956	14655.35	3
2013	17	1	1703602	3.156996e+07	2154	14656.44	3
2013	31	3	3129103	9.006164e+07	6144	14658.47	3
2013	51	5	5104500	3.651507e+07	2491	14658.8	3
2013	31	3	3120409	7.600197e+07	5182	14666.53	3
2013	35	3	3553500	1.1920774e+08	8125	14671.72	3
2013	43	4	4323101	7.785121e+07	5305	14675.06	3
2013	41	4	4123956	5.548779e+07	3780	14679.31	3
2013	42	4	4213609	5.0722513e+08	34551	14680.48	3
2013	32	3	3205036	3.045449e+08	20744	14681.11	3
2013	41	4	4124905	8.885814e+07	6051	14684.87	3
2013	35	3	3532058	6.661598e+07	4534	14692.54	3
2013	35	3	3501301	3.5982082e+08	24482	14697.36	3
2013	32	3	3202900	1.6698735e+08	11349	14713.84	3
2013	33	3	3303104	2.2211746e+08	15069	14740.03	3
2013	43	4	4303202	7.453501e+07	5056	14741.89	3
2013	41	4	4100459	5.534343e+07	3754	14742.52	3
2013	31	3	3159209	1.3620874e+08	9239	14742.8	3
2013	50	5	5003108	7.803357e+07	5289	14753.94	3
2013	41	4	4122156	1.9956986e+08	13524	14756.72	3
2013	32	3	3204906	1.78174103e+09	120725	14758.67	3
2013	43	4	4304663	3.728414e+08	25256	14762.49	3
2013	41	4	4114351	4.509271e+07	3053	14769.97	3
2013	33	3	3305901	1.528373e+08	10347	14771.17	3
2013	41	4	4123105	5.567711e+07	3769	14772.38	3
2013	50	5	5000906	1.2625411e+08	8545	14775.2	3
2013	13	1	1304302	2.5660727e+08	17367	14775.57	3
2013	52	5	5203807	8.462319e+07	5724	14783.92	3
2013	41	4	4102752	5.804505e+07	3926	14784.78	3
2013	17	1	1720655	7.821718e+07	5289	14788.65	3
2013	15	1	1504000	3.9254381e+08	26542	14789.53	3
2013	27	2	2708105	1.6466797e+08	11134	14789.65	3
2013	52	5	5220009	1.6963266e+08	11467	14793.12	3
2013	31	3	3144102	3.1090503e+08	21007	14800.07	3
2013	50	5	5008008	2.8040113e+08	18942	14803.14	3
2013	35	3	3506706	2.126586e+08	14356	14813.22	3
2013	35	3	3514205	3.181981e+07	2148	14813.69	3
2013	31	3	3157807	3.16057317e+09	213345	14814.38	3
2013	29	2	2933307	4.99337252e+09	336987	14817.7	3
2013	52	5	5210000	7.519302e+08	50736	14820.45	3
2013	52	5	5206503	5.375563e+07	3627	14820.96	3
2013	52	5	5214804	3.196766e+07	2155	14834.18	3
2013	41	4	4126900	8.7619e+07	5906	14835.59	3
2013	11	1	1100031	9.636454e+07	6495	14836.73	3
2013	52	5	5207105	3.776818e+07	2544	14845.98	3
2013	29	2	2907400	5.078475e+07	3420	14849.34	3
2013	52	5	5217302	3.5819625e+08	24111	14856.13	3
2013	31	3	3114303	4.5663818e+08	30695	14876.63	3
2013	35	3	3540507	1.3421404e+08	9021	14877.96	3
2013	41	4	4107652	1.32551145e+09	89037	14887.2	3
2013	50	5	5003504	8.361766e+07	5616	14889.18	3
2013	29	2	2904605	1.02409528e+09	68776	14890.3	3
2013	52	5	5208509	8.176774e+07	5491	14891.23	3
2013	41	4	4109609	5.119621e+08	34338	14909.49	3
2013	32	3	3205150	1.3826869e+08	9272	14912.5	3
2013	41	4	4102406	4.895513e+08	32800	14925.34	3
2013	52	5	5220280	3.065969e+07	2054	14926.82	3
2013	35	3	3517000	1.6749913e+08	11209	14943.27	3
2013	31	3	3139706	1.1358885e+08	7600	14945.9	3
2013	41	4	4116000	2.834587e+07	1896	14950.35	3
2013	35	3	3549953	2.2247222e+08	14874	14957.12	3
2013	31	3	3160405	4.0911708e+08	27352	14957.48	3
2013	41	4	4112504	1.8522547e+08	12371	14972.55	3
2013	41	4	4103479	6.490957e+07	4334	14976.83	3
2013	15	1	1506161	2.6621413e+08	17774	14977.73	3
2013	42	4	4205159	5.736551e+07	3828	14985.77	3
2013	31	3	3101102	3.8476208e+08	25675	14985.86	3
2013	43	4	4311429	3.86635e+07	2579	14991.66	3
2013	43	4	4316303	1.1011677e+08	7338	15006.37	3
2013	24	2	2401008	5.4118782e+08	36049	15012.56	3
2013	43	4	4314159	1.25955e+08	8382	15026.84	3
2013	42	4	4216404	1.0797698e+08	7183	15032.3	3
2013	41	4	4108007	1.705282e+08	11328	15053.69	3
2013	35	3	3552106	5.8529738e+08	38878	15054.72	3
2013	41	4	4113809	7.234117e+07	4805	15055.39	3
2013	50	5	5005004	3.7923318e+08	25180	15060.89	3
2013	35	3	3554706	1.4693138e+08	9754	15063.7	3
2013	32	3	3203908	7.467644e+08	49564	15066.67	3
2013	42	4	4209706	1.8196326e+08	12077	15066.93	3
2013	50	5	5003454	1.8876101e+08	12524	15071.94	3
2013	43	4	4321477	9.781003e+07	6484	15084.83	3
2013	35	3	3535903	6.011631e+07	3983	15093.22	3
2013	29	2	2918456	1.5702935e+08	10403	15094.62	3
2013	14	1	1400506	1.0995142e+08	7284	15094.92	3
2013	52	5	5208608	9.6539545e+08	63938	15098.93	3
2013	52	5	5204706	1.7832956e+08	11807	15103.71	3
2013	35	3	3511706	2.4323893e+08	16092	15115.52	3
2013	31	3	3120706	6.205205e+07	4103	15123.58	3
2013	41	4	4107520	2.94443e+07	1946	15130.68	3
2013	41	4	4118006	1.9168098e+08	12661	15139.48	3
2013	31	3	3140902	2.8020312e+08	18491	15153.49	3
2013	17	1	1718451	3.83441e+07	2529	15161.77	3
2013	52	5	5200506	3.168793e+07	2089	15168.95	3
2013	35	3	3506300	1.6892495e+08	11133	15173.35	3
2013	17	1	1706258	2.506106e+07	1651	15179.32	3
2013	31	3	3156700	2.01347477e+09	132636	15180.45	3
2013	31	3	3146008	5.0174911e+08	33031	15190.25	3
2013	42	4	4209409	6.6818034e+08	43979	15193.17	3
2013	35	3	3544400	4.435382e+07	2917	15205.29	3
2013	43	4	4314555	4.163221e+07	2738	15205.33	3
2013	17	1	1707009	3.1285083e+08	20566	15212.04	3
2013	51	5	5108600	3.4978757e+08	22990	15214.77	3
2013	24	2	2401206	2.0970936e+08	13764	15236.08	3
2013	31	3	3151503	5.1164246e+08	33580	15236.52	3
2013	41	4	4122107	5.162003e+07	3385	15249.64	3
2013	31	3	3128006	5.0361796e+08	33020	15251.91	3
2013	35	3	3541901	1.8669727e+08	12234	15260.53	3
2013	35	3	3523008	7.06521e+07	4629	15262.93	3
2013	17	1	1709807	2.753577e+07	1804	15263.73	3
2013	26	2	2611101	4.88278457e+09	319893	15263.81	3
2013	35	3	3543709	1.6436093e+08	10768	15263.83	3
2013	42	4	4215356	6.030352e+07	3948	15274.45	3
2013	31	3	3138401	8.0825484e+08	52915	15274.59	3
2013	13	1	1301902	1.44063915e+09	94278	15280.76	3
2013	52	5	5216304	1.4666628e+08	9593	15288.89	3
2013	31	3	3107109	6.1217548e+08	40018	15297.5	3
2013	35	3	3541505	6.0099674e+08	39265	15306.17	3
2013	52	5	5210158	4.48613e+07	2930	15311.02	3
2013	41	4	4111308	5.324687e+07	3476	15318.43	3
2013	31	3	3169406	8.6033834e+08	56156	15320.51	3
2013	43	4	4309753	6.918798e+07	4516	15320.63	3
2013	43	4	4310504	1.2462328e+08	8132	15325.05	3
2013	43	4	4320859	6.720664e+07	4385	15326.49	3
2013	31	3	3164407	8.045075e+07	5249	15326.87	3
2013	41	4	4109203	8.235286e+07	5373	15327.16	3
2013	41	4	4127809	1.345173e+08	8776	15327.86	3
2013	52	5	5215207	5.282881e+07	3445	15334.92	3
2013	35	3	3529203	3.9076952e+08	25473	15340.54	3
2013	14	1	1400472	4.039292e+08	26326	15343.36	3
2013	31	3	3172103	8.076809e+07	5258	15360.99	3
2013	35	3	3504206	2.2790838e+08	14831	15367.03	3
2013	41	4	4104402	2.5567667e+08	16633	15371.65	3
2013	41	4	4112306	7.778326e+07	5058	15378.26	3
2013	35	3	3543808	1.5643272e+08	10170	15381.78	3
2013	15	1	1501253	5.13816e+07	3340	15383.71	3
2013	41	4	4109708	4.6536186e+08	30242	15387.93	3
2013	35	3	3528601	1.4569223e+08	9464	15394.36	3
2013	52	5	5219100	9.421241e+07	6118	15399.22	3
2013	35	3	3506904	1.6180503e+08	10504	15404.13	3
2013	52	5	5214408	1.2976046e+08	8421	15409.15	3
2013	31	3	3142205	2.2406241e+08	14540	15410.07	3
2013	32	3	3203353	1.8641051e+08	12092	15416.02	3
2013	42	4	4215901	4.608093e+07	2989	15416.84	3
2013	31	3	3133501	3.4005205e+08	22054	15419.06	3
2013	31	3	3158953	4.668475e+08	30255	15430.42	3
2013	43	4	4312252	1.2288248e+08	7956	15445.26	3
2013	32	3	3205010	4.1460849e+08	26843	15445.68	3
2013	35	3	3504404	1.9016767e+08	12307	15451.99	3
2013	35	3	3524600	2.7512308e+08	17801	15455.48	3
2013	35	3	3551900	2.5485875e+08	16482	15462.85	3
2013	35	3	3555208	3.09492e+07	2000	15474.6	3
2013	41	4	4113304	4.9434769e+08	31936	15479.32	3
2013	31	3	3138104	1.0316805e+08	6663	15483.72	3
2013	41	4	4108106	4.107507e+07	2650	15500.03	3
2013	33	3	3305208	1.4522965e+09	93659	15506.21	3
2013	41	4	4124004	8.247456e+07	5315	15517.32	3
2013	24	2	2404408	1.5517172e+08	9998	15520.28	3
2013	32	3	3202405	1.80513138e+09	116278	15524.27	3
2013	43	4	4314068	8.422654e+07	5421	15537.09	3
2013	42	4	4213807	1.1463516e+08	7377	15539.54	3
2013	31	3	3140506	2.0482522e+08	13180	15540.61	3
2013	43	4	4321667	1.6640117e+08	10707	15541.34	3
2013	35	3	3527009	1.1291347e+08	7265	15542.12	3
2013	43	4	4320453	3.541357e+07	2277	15552.73	3
2013	35	3	3502903	4.6802605e+08	30088	15555.24	3
2013	42	4	4202206	1.6974512e+08	10906	15564.38	3
2013	43	4	4311601	9.073132e+07	5827	15570.85	3
2013	31	3	3171303	1.18597158e+09	76147	15574.76	3
2013	43	4	4302709	3.2925264e+08	21131	15581.5	3
2013	35	3	3543600	5.571575e+07	3574	15589.18	3
2013	41	4	4120705	1.1453681e+08	7344	15595.97	3
2013	31	3	3127909	2.207603e+07	1414	15612.47	3
2013	35	3	3537503	1.2509305e+08	8006	15624.91	3
2013	43	4	4306072	4.557619e+07	2915	15635.06	3
2013	29	2	2933257	1.060336e+08	6781	15636.87	3
2013	43	4	4320677	1.6252326e+08	10390	15642.28	3
2013	33	3	3305307	1.4105855e+08	9012	15652.3	3
2013	50	5	5003488	1.6905715e+08	10793	15663.59	3
2013	50	5	5002803	8.927433e+07	5699	15664.91	3
2013	31	3	3120904	1.22026787e+09	77824	15679.84	3
2013	52	5	5221601	6.0997055e+08	38854	15699.04	3
2013	29	2	2910503	6.6951197e+08	42640	15701.5	3
2013	41	4	4117602	7.2689091e+08	46294	15701.62	3
2013	43	4	4303400	8.08723e+07	5148	15709.46	4
2013	26	2	2604106	5.30077395e+09	337416	15709.91	4
2013	31	3	3169802	7.69503e+07	4897	15713.76	4
2013	31	3	3135704	8.342167e+07	5307	15719.18	4
2013	35	3	3520202	1.4551723e+08	9251	15729.89	4
2013	35	3	3547403	4.066386e+07	2585	15730.7	4
2013	41	4	4125456	6.103894e+07	3880	15731.69	4
2013	31	3	3145604	6.479575e+08	41181	15734.38	4
2013	35	3	3550803	1.9507272e+08	12394	15739.29	4
2013	32	3	3204658	1.3529835e+08	8595	15741.52	4
2013	35	3	3543105	7.101485e+07	4510	15746.09	4
2013	33	3	3305604	3.3656113e+08	21366	15752.18	4
2013	41	4	4100103	1.2417098e+08	7881	15755.74	4
2013	35	3	3555109	2.3606341e+08	14976	15762.78	4
2013	43	4	4318051	4.801732e+07	3046	15764.06	4
2013	31	3	3105608	2.09636127e+09	132980	15764.49	4
2013	43	4	4317103	1.31980305e+09	83702	15767.88	4
2013	43	4	4321105	2.7236182e+08	17273	15768.07	4
2013	42	4	4205357	2.533111e+07	1605	15782.62	4
2013	22	2	2209203	9.706865e+07	6150	15783.52	4
2013	43	4	4315156	1.0044961e+08	6364	15784.04	4
2013	42	4	4204152	4.40707e+07	2792	15784.63	4
2013	35	3	3544806	9.243008e+07	5853	15791.91	4
2013	11	1	1100601	9.901056e+07	6268	15796.2	4
2013	41	4	4110805	1.7026392e+08	10773	15804.69	4
2013	52	5	5212956	7.12794e+07	4510	15804.74	4
2013	43	4	4314027	1.2038552e+08	7615	15809	4
2013	42	4	4218400	1.1123512e+08	7036	15809.43	4
2013	29	2	2914802	3.45013833e+09	218124	15817.33	4
2013	41	4	4128401	1.8555519e+08	11729	15820.21	4
2013	42	4	4218103	8.523157e+07	5387	15821.71	4
2013	51	5	5107263	4.787223e+07	3025	15825.53	4
2013	35	3	3535408	2.4218494e+08	15288	15841.51	4
2013	16	1	1600105	1.3447896e+08	8483	15852.76	4
2013	35	3	3520707	6.324594e+07	3988	15859.06	4
2013	52	5	5218003	7.02348e+08	44265	15866.89	4
2013	41	4	4104709	2.2596791e+08	14239	15869.65	4
2013	43	4	4312203	7.837587e+07	4938	15871.99	4
2013	32	3	3200904	6.9657682e+08	43882	15873.86	4
2013	42	4	4215059	3.943193e+07	2482	15887.16	4
2013	41	4	4120606	8.1000044e+08	50983	15887.66	4
2013	35	3	3521705	2.8857592e+08	18158	15892.49	4
2013	33	3	3303203	2.5180157e+09	158288	15907.81	4
2013	15	1	1502764	1.8628998e+08	11704	15916.78	4
2013	35	3	3550407	5.3554612e+08	33638	15920.87	4
2013	43	4	4312054	6.649887e+07	4176	15924.06	4
2013	17	1	1715507	1.728271e+07	1085	15928.76	4
2013	43	4	4315057	4.112944e+07	2579	15947.82	4
2013	35	3	3519402	1.8523878e+08	11615	15948.24	4
2013	33	3	3304805	6.0187499e+08	37717	15957.66	4
2013	31	3	3150505	1.370177e+08	8582	15965.71	4
2013	42	4	4213302	7.799357e+07	4885	15965.93	4
2013	41	4	4111258	4.1473857e+08	25974	15967.45	4
2013	35	3	3516507	4.456225e+07	2790	15972.13	4
2013	15	1	1501451	2.6853162e+08	16808	15976.42	4
2013	52	5	5213400	2.787242e+07	1744	15981.89	4
2013	42	4	4209607	2.3724457e+08	14841	15985.75	4
2013	43	4	4322541	8.712306e+07	5447	15994.69	4
2013	43	4	4312104	8.31479e+07	5198	15996.13	4
2013	43	4	4319406	2.6910679e+08	16817	16002.07	4
2013	17	1	1718907	7.607532e+07	4752	16009.12	4
2013	43	4	4321600	7.2209192e+08	45079	16018.37	4
2013	32	3	3200805	4.9866036e+08	31126	16020.7	4
2013	51	5	5107107	3.014118e+08	18801	16031.69	4
2013	42	4	4202156	4.316963e+07	2692	16036.27	4
2013	32	3	3202504	1.9444668e+08	12124	16038.16	4
2013	52	5	5219357	6.122483e+07	3814	16052.66	4
2013	42	4	4211801	1.1938229e+08	7436	16054.64	4
2013	50	5	5003801	3.0942117e+08	19260	16065.48	4
2013	43	4	4320651	4.010556e+07	2495	16074.37	4
2013	12	1	1200013	2.1465203e+08	13353	16075.19	4
2013	43	4	4314506	2.0977523e+08	13047	16078.43	4
2013	29	2	2912806	1.3845762e+08	8603	16094.11	4
2013	41	4	4127304	2.5858222e+08	16063	16098	4
2013	35	3	3536901	4.180158e+07	2595	16108.51	4
2013	42	4	4219358	8.363466e+07	5190	16114.58	4
2013	41	4	4108452	8.615939e+07	5346	16116.61	4
2013	43	4	4319208	9.3417e+07	5794	16123.06	4
2013	15	1	1500206	8.7161882e+08	54030	16132.13	4
2013	31	3	3162104	5.4485824e+08	33774	16132.48	4
2013	12	1	1200179	1.5879977e+08	9836	16144.75	4
2013	33	3	3300605	5.7888903e+08	35825	16158.8	4
2013	43	4	4322400	2.094172e+09	129504	16170.71	4
2013	35	3	3500808	6.572748e+07	4064	16173.1	4
2013	35	3	3527405	3.3834874e+08	20918	16175	4
2013	31	3	3136801	6.945943e+07	4288	16198.56	4
2013	42	4	4212502	4.5257357e+08	27936	16200.37	4
2013	31	3	3116605	4.4276528e+08	27321	16206.04	4
2013	52	5	5200902	5.789663e+07	3570	16217.54	4
2013	22	2	2204303	1.8441565e+08	11368	16222.35	4
2013	35	3	3528106	1.2954801e+08	7978	16238.16	4
2013	42	4	4202438	5.512385e+07	3393	16246.35	4
2013	35	3	3554953	1.035143e+08	6369	16252.83	4
2013	35	3	3504602	2.5767945e+08	15851	16256.35	4
2013	43	4	4319356	5.727694e+07	3522	16262.62	4
2013	35	3	3515400	2.5850107e+08	15889	16269.18	4
2013	41	4	4121257	7.047863e+07	4332	16269.3	4
2013	41	4	4107157	8.500332e+07	5223	16274.81	4
2013	31	3	3147204	3.4475966e+08	21164	16289.91	4
2013	35	3	3546256	3.351385e+07	2056	16300.51	4
2013	35	3	3528502	1.44923663e+09	88883	16304.99	4
2013	42	4	4211058	1.5663239e+08	9604	16309.08	4
2013	43	4	4303608	1.0948165e+08	6712	16311.33	4
2013	42	4	4204459	4.112388e+07	2520	16319	4
2013	33	3	3304409	2.8902494e+08	17709	16320.79	4
2013	31	3	3141207	6.294996e+07	3856	16325.2	4
2013	31	3	3158300	1.2052888e+08	7379	16334.04	4
2013	31	3	3104601	2.2442092e+08	13738	16335.78	4
2013	35	3	3511607	2.7322015e+08	16717	16343.85	4
2013	33	3	3305158	3.3847946e+08	20704	16348.51	4
2013	35	3	3555307	3.175692e+07	1942	16352.69	4
2013	41	4	4125357	9.956992e+07	6088	16355.11	4
2013	31	3	3149903	3.437889e+08	21013	16360.77	4
2013	35	3	3512308	2.8101856e+08	17162	16374.46	4
2013	43	4	4318101	3.215039e+08	19621	16385.7	4
2013	24	2	2412005	1.56056835e+09	95218	16389.43	4
2013	35	3	3516408	2.32581327e+09	141824	16399.29	4
2013	31	3	3153004	5.666504e+07	3455	16400.88	4
2013	35	3	3532702	7.659427e+07	4669	16404.86	4
2013	35	3	3544608	8.948234e+07	5452	16412.76	4
2013	52	5	5208905	4.0693617e+08	24793	16413.35	4
2013	43	4	4315073	2.950329e+07	1797	16418.08	4
2013	33	3	3303500	1.321490808e+10	804815	16419.81	4
2013	42	4	4204178	5.701211e+07	3472	16420.54	4
2013	15	1	1501501	9.2174894e+08	56112	16426.95	4
2013	25	2	2504009	6.57410502e+09	400002	16435.18	4
2013	35	3	3514924	5.520865e+07	3359	16436.04	4
2013	31	3	3152006	5.0474552e+08	30699	16441.76	4
2013	51	5	5108204	6.346392e+07	3859	16445.69	4
2013	31	3	3143906	1.74103978e+09	105861	16446.47	4
2013	51	5	5105101	5.4885711e+08	33353	16456	4
2013	52	5	5205703	4.30871e+07	2616	16470.6	4
2013	51	5	5101001	5.160583e+07	3133	16471.7	4
2013	28	2	2802304	2.4279993e+08	14730	16483.36	4
2013	29	2	2920601	7.5416459e+08	45740	16488.08	4
2013	33	3	3302304	1.2180873e+08	7385	16494.07	4
2013	52	5	5212501	3.10488005e+09	188181	16499.43	4
2013	43	4	4305116	5.010694e+07	3036	16504.26	4
2013	41	4	4100202	1.0591854e+08	6416	16508.5	4
2013	27	2	2704302	1.64567255e+10	996733	16510.67	4
2013	51	5	5106190	5.836315e+07	3534	16514.76	4
2013	35	3	3503802	7.9965751e+08	48420	16515.03	4
2013	42	4	4202099	3.042754e+07	1842	16518.75	4
2013	31	3	3109709	1.8967129e+08	11481	16520.45	4
2013	43	4	4318457	4.564462e+07	2761	16531.92	4
2013	15	1	1501907	4.4636257e+08	27000	16531.95	4
2013	29	2	2928703	1.64350237e+09	99407	16533.06	4
2013	52	5	5203575	6.348004e+07	3838	16539.87	4
2013	41	4	4115705	5.2437711e+08	31690	16547.08	4
2013	35	3	3519709	1.2450722e+09	75241	16547.79	4
2013	42	4	4208807	3.0492663e+08	18425	16549.61	4
2013	21	2	2101251	2.6481698e+08	15982	16569.7	4
2013	35	3	3532405	2.89208e+08	17451	16572.57	4
2013	17	1	1707306	7.81986e+07	4718	16574.52	4
2013	35	3	3513207	1.3417065e+08	8089	16586.8	4
2013	41	4	4117297	4.823359e+07	2906	16597.93	4
2013	42	4	4219853	5.234488e+07	3153	16601.61	4
2013	42	4	4209151	8.030457e+07	4837	16602.14	4
2013	52	5	5211008	1.2060062e+08	7264	16602.51	4
2013	51	5	5105580	1.882517e+08	11324	16624.13	4
2013	43	4	4302402	1.9956276e+08	12004	16624.69	4
2013	31	3	3127701	4.58540008e+09	275568	16639.81	4
2013	14	1	1400159	1.9178538e+08	11525	16640.81	4
2013	52	5	5220207	3.7912322e+08	22773	16647.93	4
2013	12	1	1200252	2.6808679e+08	16099	16652.39	4
2013	41	4	4126702	8.184702e+07	4915	16652.5	4
2013	35	3	3532504	1.5021299e+08	9017	16658.87	4
2013	27	2	2703759	1.9953007e+08	11969	16670.57	4
2013	51	5	5108055	1.7712025e+08	10621	16676.42	4
2013	42	4	4217956	2.912549e+07	1746	16681.27	4
2013	41	4	4105805	3.79205381e+09	227220	16688.91	4
2013	11	1	1100049	1.43325351e+09	85863	16692.33	4
2013	11	1	1100320	3.954084e+08	23668	16706.46	4
2013	16	1	1600600	1.81941066e+09	108897	16707.63	4
2013	33	3	3301603	1.8496493e+08	11070	16708.67	4
2013	52	5	5219407	1.2696965e+08	7599	16708.73	4
2013	41	4	4119806	2.3333545e+08	13964	16709.79	4
2013	35	3	3530201	2.9804201e+08	17820	16725.14	4
2013	11	1	1100288	9.2608942e+08	55357	16729.4	4
2013	31	3	3137106	1.3056417e+08	7802	16734.7	4
2013	41	4	4128500	3.3201092e+08	19838	16736.11	4
2013	43	4	4301909	2.2010876e+08	13150	16738.31	4
2013	35	3	3544509	5.05313e+07	3017	16748.86	4
2013	43	4	4303707	1.0314722e+08	6156	16755.56	4
2013	35	3	3517505	3.2529495e+08	19409	16760.01	4
2013	35	3	3546009	2.4127477e+08	14395	16761.01	4
2013	50	5	5006903	2.7113918e+08	16162	16776.34	4
2013	35	3	3539004	1.8647822e+08	11112	16781.7	4
2013	42	4	4201505	1.3696688e+08	8159	16787.21	4
2013	43	4	4311106	1.9624317e+08	11675	16808.84	4
2013	51	5	5105150	6.6564421e+08	39592	16812.59	4
2013	41	4	4122172	6.820883e+07	4056	16816.77	4
2013	42	4	4200705	1.6389234e+08	9737	16831.91	4
2013	24	2	2402303	3.4364218e+08	20414	16833.65	4
2013	17	1	1709302	4.145985e+08	24629	16833.75	4
2013	33	3	3300902	2.502012e+08	14862	16834.96	4
2013	41	4	4121752	1.2962065e+08	7697	16840.41	4
2013	22	2	2210631	7.057302e+07	4189	16847.22	4
2013	31	3	3147600	2.7335519e+08	16224	16848.82	4
2013	43	4	4317400	8.5281297e+08	50608	16851.35	4
2013	35	3	3541059	8.277394e+07	4912	16851.37	4
2013	15	1	1505502	1.74901981e+09	103775	16853.96	4
2013	43	4	4313490	6.975134e+07	4138	16856.29	4
2013	52	5	5201306	3.575086e+08	21195	16867.59	4
2013	31	3	3135001	5.249997e+07	3112	16870.17	4
2013	15	1	1503903	8.6872213e+08	51483	16873.96	4
2013	35	3	3555802	1.5391227e+08	9121	16874.5	4
2013	43	4	4313391	6.82679e+07	4045	16877.11	4
2013	43	4	4311908	8.64675e+07	5123	16878.29	4
2013	35	3	3555901	2.113978e+07	1252	16884.8	4
2013	15	1	1508407	7.1078838e+08	42085	16889.35	4
2013	26	2	2601706	1.26545062e+09	74902	16894.75	4
2013	35	3	3514957	4.205292e+07	2486	16915.9	4
2013	32	3	3201407	6.3155023e+08	37331	16917.58	4
2013	35	3	3503406	1.3948584e+08	8245	16917.63	4
2013	31	3	3134905	4.1214773e+08	24354	16923.2	4
2013	41	4	4117008	1.4155285e+08	8363	16926.08	4
2013	31	3	3166808	1.8861855e+08	11142	16928.61	4
2013	52	5	5212907	3.672695e+07	2169	16932.67	4
2013	42	4	4211892	4.040336e+07	2385	16940.61	4
2013	31	3	3163706	7.4615435e+08	44037	16943.81	4
2013	41	4	4111001	1.1674406e+08	6887	16951.37	4
2013	31	3	3162500	1.49868991e+09	88405	16952.55	4
2013	52	5	5215009	1.4937673e+08	8806	16963.06	4
2013	43	4	4309571	5.184112e+07	3056	16963.72	4
2013	42	4	4201109	5.528842e+07	3259	16964.84	4
2013	35	3	3522208	2.77234981e+09	163363	16970.49	4
2013	35	3	3542701	1.1972996e+08	7054	16973.34	4
2013	43	4	4322533	1.9637338e+08	11563	16982.91	4
2013	31	3	3112703	2.5303735e+08	14894	16989.21	4
2013	42	4	4218954	4.260737e+07	2507	16995.36	4
2013	41	4	4120200	4.429023e+07	2605	17002.01	4
2013	31	3	3114501	3.0982086e+08	18205	17018.45	4
2013	35	3	3519303	5.5907244e+08	32810	17039.7	4
2013	43	4	4301602	2.06595554e+09	121235	17040.92	4
2013	42	4	4202503	7.781044e+07	4566	17041.27	4
2013	35	3	3543006	3.0851631e+08	18093	17051.69	4
2013	27	2	2706901	5.9765015e+08	35003	17074.26	4
2013	31	3	3167004	3.482085e+07	2037	17094.18	4
2013	52	5	5210802	8.632982e+07	5050	17095.01	4
2013	31	3	3162203	1.2382847e+08	7241	17101.02	4
2013	35	3	3521804	4.3671565e+08	25535	17102.63	4
2013	35	3	3556404	7.0605838e+08	41279	17104.54	4
2013	35	3	3509452	9.982987e+07	5836	17105.87	4
2013	42	4	4205431	4.455903e+07	2603	17118.34	4
2013	35	3	3545605	2.5714221e+08	15017	17123.41	4
2013	35	3	3503356	3.29722e+07	1925	17128.42	4
2013	35	3	3538105	2.743599e+08	16013	17133.57	4
2013	35	3	3553807	3.955416e+08	23083	17135.62	4
2013	41	4	4106001	1.4833871e+08	8648	17152.95	4
2013	52	5	5221502	8.40017e+07	4897	17153.71	4
2013	35	3	3518107	1.1372943e+08	6629	17156.35	4
2013	41	4	4123808	2.3873306e+08	13908	17165.16	4
2013	31	3	3130804	4.703887e+07	2740	17167.47	4
2013	43	4	4310330	3.323089e+08	19338	17184.24	4
2013	43	4	4301404	1.8174167e+08	10573	17189.22	4
2013	31	3	3147402	4.0847063e+08	23762	17190.08	4
2013	31	3	3166600	1.419342e+07	825	17204.15	4
2013	35	3	3510807	5.0927603e+08	29597	17207.02	4
2013	31	3	3169604	4.3325235e+08	25171	17212.36	4
2013	31	3	3126208	1.5189363e+08	8817	17227.36	4
2013	31	3	3115300	1.2626519e+09	73232	17241.81	4
2013	35	3	3541000	4.96641782e+09	287967	17246.48	4
2013	42	4	4206702	3.7880256e+08	21961	17248.88	4
2013	33	3	3302106	3.9449829e+08	22870	17249.6	4
2013	41	4	4127908	1.5334748e+08	8887	17255.26	4
2013	31	3	3126109	1.16713828e+09	67617	17261.02	4
2013	43	4	4319737	4.737702e+07	2743	17271.97	4
2013	41	4	4100608	2.4759877e+08	14334	17273.53	4
2013	29	2	2926202	4.0090703e+08	23209	17273.77	4
2013	15	1	1507979	3.0429026e+08	17614	17275.48	4
2013	31	3	3121209	1.2259933e+08	7096	17277.25	4
2013	31	3	3103603	4.992609e+07	2888	17287.43	4
2013	23	2	2312908	3.41914322e+09	197663	17297.84	4
2013	24	2	2413201	7.292546e+07	4215	17301.41	4
2013	50	5	5000609	6.3472889e+08	36686	17301.67	4
2013	42	4	4205704	3.4658419e+08	20024	17308.44	4
2013	41	4	4113502	3.8586634e+08	22288	17312.74	4
2013	43	4	4304408	7.2165114e+08	41682	17313.26	4
2013	17	1	1708205	3.2563785e+08	18804	17317.48	4
2013	43	4	4316402	7.0714967e+08	40825	17321.49	4
2013	41	4	4108502	2.4343108e+08	14039	17339.63	4
2013	35	3	3555406	1.46323583e+09	84377	17341.64	4
2013	41	4	4106100	6.580754e+07	3794	17345.16	4
2013	42	4	4219150	4.718818e+07	2718	17361.36	4
2013	33	3	3300209	2.06577931e+09	118964	17364.74	4
2013	41	4	4111506	5.6786319e+08	32699	17366.38	4
2013	41	4	4118808	2.4474718e+08	14087	17373.97	4
2013	11	1	1100262	6.373195e+07	3666	17384.6	4
2013	31	3	3102605	6.8563133e+08	39416	17394.75	4
2013	43	4	4306007	2.4982275e+08	14360	17397.13	4
2013	35	3	3502309	1.0648567e+08	6120	17399.62	4
2013	43	4	4319307	1.1186107e+08	6425	17410.28	4
2013	41	4	4128625	5.502092e+07	3159	17417.19	4
2013	31	3	3101409	5.256882e+07	3018	17418.43	4
2013	24	2	2401651	4.202272e+07	2412	17422.36	4
2013	42	4	4215307	1.3162227e+08	7553	17426.49	4
2013	29	2	2900702	2.65913103e+09	152570	17428.92	4
2013	35	3	3501103	7.309144e+07	4193	17431.78	4
2013	41	4	4122800	7.473601e+07	4287	17433.17	4
2013	43	4	4310850	7.245694e+07	4156	17434.3	4
2013	29	2	2913606	3.21940502e+09	184616	17438.39	4
2013	43	4	4305157	4.299341e+07	2465	17441.55	4
2013	31	3	3160900	6.410688e+07	3673	17453.55	4
2013	52	5	5205000	1.653559e+08	9470	17461.02	4
2013	31	3	3124500	1.9705497e+08	11285	17461.67	4
2013	41	4	4116604	6.21751e+07	3560	17464.91	4
2013	35	3	3548104	1.06207e+08	6078	17474.01	4
2013	35	3	3533700	7.509803e+07	4296	17480.92	4
2013	43	4	4307450	5.753307e+07	3291	17481.94	4
2013	31	3	3147303	3.5683658e+08	20410	17483.42	4
2013	43	4	4314407	5.96701078e+09	341180	17489.33	4
2013	31	3	3147907	1.95370338e+09	111651	17498.31	4
2013	51	5	5102694	8.274832e+07	4728	17501.76	4
2013	35	3	3553609	2.2914499e+08	13091	17504.01	4
2013	51	5	5106257	3.5267571e+08	20143	17508.6	4
2013	41	4	4119202	1.1223209e+08	6409	17511.64	4
2013	35	3	3524204	1.1992286e+08	6846	17517.22	4
2013	35	3	3501707	6.5111469e+08	37165	17519.57	4
2013	41	4	4117305	4.1438768e+08	23646	17524.64	4
2013	35	3	3543204	8.025069e+07	4575	17541.13	4
2013	52	5	5221197	1.2514597e+08	7132	17547.11	4
2013	31	3	3164308	1.2238062e+08	6973	17550.64	4
2013	43	4	4306551	4.607056e+07	2623	17564.07	4
2013	43	4	4314050	9.590599e+08	54599	17565.52	4
2013	43	4	4318804	7.8183428e+08	44498	17570.1	4
2013	43	4	4317251	3.131494e+07	1782	17572.92	4
2013	51	5	5107800	3.3922666e+08	19302	17574.69	4
2013	35	3	3513900	2.0396235e+08	11604	17576.9	4
2013	35	3	3509403	4.3562246e+08	24783	17577.47	4
2013	17	1	1702109	2.88713878e+09	164093	17594.53	4
2013	24	2	2414209	2.2362771e+08	12708	17597.4	4
2013	43	4	4311239	4.919533e+07	2795	17601.19	4
2013	33	3	3305133	1.2585307e+08	7143	17619.08	4
2013	43	4	4321204	1.00304106e+09	56896	17629.38	4
2013	43	4	4316428	4.717219e+07	2675	17634.46	4
2013	17	1	1716109	8.4161997e+08	47724	17635.15	4
2013	32	3	3201902	6.0064147e+08	34059	17635.32	4
2013	22	2	2211001	1.475398956e+10	836475	17638.29	4
2013	31	3	3112604	2.815907e+08	15961	17642.42	4
2013	43	4	4309126	4.049919e+07	2295	17646.7	4
2013	43	4	4300455	7.48942e+07	4244	17647.08	4
2013	31	3	3123403	2.655016e+07	1504	17653.03	4
2013	35	3	3530904	6.023347e+07	3411	17658.6	4
2013	35	3	3537800	9.6043183e+08	54323	17680.02	4
2013	25	2	2502151	1.1790968e+08	6669	17680.26	4
2013	41	4	4100806	1.9220465e+08	10869	17683.75	4
2013	35	3	3539509	6.6340032e+08	37499	17691.15	4
2013	35	3	3540408	7.613281e+07	4299	17709.42	4
2013	31	3	3153400	3.422602e+08	19325	17710.75	4
2013	35	3	3514700	1.1320274e+08	6389	17718.38	4
2013	51	5	5103106	9.799254e+07	5525	17736.21	4
2013	51	5	5103957	5.449735e+07	3072	17740.02	4
2013	41	4	4124103	7.9420157e+08	44754	17745.93	4
2013	41	4	4117107	2.3877125e+08	13452	17749.87	4
2013	29	2	2916856	2.610215e+08	14700	17756.56	4
2013	31	3	3139102	9.040318e+07	5091	17757.45	4
2013	33	3	3302056	2.558491e+08	14405	17761.13	4
2013	52	5	5220108	5.6552269e+08	31832	17765.85	4
2013	35	3	3502408	7.003631e+07	3941	17771.2	4
2013	11	1	1100023	1.79985251e+09	101269	17772.99	4
2013	33	3	3300308	1.71102268e+09	96261	17774.83	4
2013	31	3	3123007	1.7429522e+08	9805	17776.16	4
2013	33	3	3300803	9.8894825e+08	55632	17776.61	4
2013	23	2	2312403	8.2259495e+08	46247	17786.99	4
2013	43	4	4306700	6.085733e+07	3421	17789.34	4
2013	35	3	3520442	4.6513353e+08	26138	17795.3	4
2013	43	4	4315206	7.506409e+07	4215	17808.8	4
2013	35	3	3523602	2.9767012e+08	16709	17814.96	4
2013	31	3	3105103	4.2164398e+08	23665	17817.2	4
2013	41	4	4109906	1.5697382e+08	8809	17819.71	4
2013	31	3	3143609	4.757748e+07	2669	17825.96	4
2013	35	3	3514601	1.582763e+08	8874	17835.96	4
2013	43	4	4323457	7.7787e+07	4359	17845.15	4
2013	41	4	4126603	3.5094927e+08	19661	17850.02	4
2013	31	3	3163102	8.138051e+07	4556	17862.27	4
2013	52	5	5212600	4.34902e+07	2433	17875.13	4
2013	35	3	3531605	7.485847e+07	4187	17878.78	4
2013	17	1	1720978	4.819159e+07	2695	17881.85	4
2013	42	4	4204756	3.454559e+07	1931	1.789e+04	4
2013	26	2	2607901	1.20897706e+10	675599	17894.89	4
2013	41	4	4109757	1.1288415e+08	6306	17901.07	4
2013	41	4	4127205	2.9693233e+08	16562	17928.53	4
2013	31	3	3132602	7.655696e+07	4270	17929.03	4
2013	17	1	1718204	9.2342068e+08	51501	17930.15	4
2013	26	2	2606804	1.96041218e+09	109322	17932.46	4
2013	41	4	4124400	3.5416659e+08	19748	17934.3	4
2013	43	4	4313607	7.670817e+07	4276	17939.24	4
2013	35	3	3504800	1.5498752e+08	8631	17957.08	4
2013	43	4	4321493	5.39984e+07	3007	17957.57	4
2013	41	4	4106456	1.3513746e+08	7525	17958.47	4
2013	43	4	4322376	4.484496e+07	2497	17959.54	4
2013	35	3	3512803	1.156949e+09	64415	17960.86	4
2013	29	2	2927002	7.2211987e+08	40203	17961.84	4
2013	43	4	4306056	1.3758622e+08	7659	17963.99	4
2013	43	4	4301057	1.5251998e+08	8488	17968.89	4
2013	31	3	3147709	1.5055755e+08	8377	17972.73	4
2013	43	4	4318408	4.1830959e+08	23263	17981.76	4
2013	50	5	5007406	3.4813949e+08	19351	17990.78	4
2013	31	3	3115003	5.398217e+07	2999	18000.06	4
2013	35	3	3519907	1.4342715e+08	7966	18004.92	4
2013	52	5	5203609	6.201044e+07	3444	18005.35	4
2013	35	3	3538808	5.3174756e+08	29532	18005.81	4
2013	51	5	5104203	2.5764433e+08	14304	18012.05	4
2013	33	3	3303708	7.5580082e+08	41955	18014.56	4
2013	42	4	4205100	7.048431e+07	3912	18017.46	4
2013	42	4	4211108	1.5281855e+08	8478	18025.31	4
2013	32	3	3203130	3.0408928e+08	16869	18026.51	4
2013	43	4	4315701	7.0070971e+08	38861	18031.18	4
2013	24	2	2403251	4.13692085e+09	229414	18032.56	4
2013	41	4	4126678	2.3994198e+08	13298	18043.46	4
2013	41	4	4125407	1.1906153e+08	6596	18050.56	4
2013	35	3	3539905	1.0342617e+08	5726	18062.55	4
2013	41	4	4107850	8.710284e+07	4822	18063.63	4
2013	29	2	2910800	1.094990718e+10	606139	18065.01	4
2013	43	4	4304200	5.6612731e+08	31334	18067.51	4
2013	41	4	4126306	3.4612432e+08	19154	18070.6	4
2013	41	4	4114104	3.8238446e+08	21156	18074.52	4
2013	43	4	4302808	6.2678882e+08	34676	18075.58	4
2013	41	4	4103800	1.3747281e+08	7603	18081.39	4
2013	35	3	3515905	5.502485e+07	3042	18088.38	4
2013	29	2	2910727	2.0044189e+09	110803	18089.93	4
2013	41	4	4119004	1.2342109e+08	6822	18091.63	4
2013	31	3	3127800	2.8346496e+08	15667	18093.12	4
2013	41	4	4109302	2.6011374e+08	14372	18098.65	4
2013	35	3	3517109	8.591473e+07	4745	18106.37	4
2013	35	3	3506409	1.3617809e+08	7519	18111.2	4
2013	31	3	3170800	6.8660628e+08	37879	18126.3	4
2013	51	5	5100250	9.0260591e+08	49761	18138.82	4
2013	42	4	4207809	1.8051164e+08	9948	18145.52	4
2013	42	4	4216305	5.5095039e+08	30337	18161	4
2013	43	4	4311700	1.0281795e+08	5660	18165.71	4
2013	35	3	3551603	5.0650103e+08	27879	18167.83	4
2013	41	4	4120408	9.187818e+07	5056	18172.11	4
2013	35	3	3531506	3.5237541e+08	19376	18186.18	4
2013	35	3	3540200	8.0509938e+08	44236	18200.09	4
2013	35	3	3521309	2.7635855e+08	15184	18200.64	4
2013	41	4	4108650	1.3818655e+08	7590	18206.4	4
2013	35	3	3552601	2.1764479e+08	11949	18214.48	4
2013	41	4	4119707	7.742256e+07	4250	18217.07	4
2013	41	4	4103404	5.164883e+07	2833	18231.14	4
2013	41	4	4102109	4.6946342e+08	25745	18235.13	4
2013	31	3	3143302	7.04271635e+09	385898	18250.2	4
2013	41	4	4111407	2.4549542e+08	13451	18251.09	4
2013	43	4	4310579	4.307465e+07	2358	18267.45	4
2013	43	4	4314035	6.734813e+07	3686	18271.33	4
2013	31	3	3144706	3.2905489e+08	18002	18278.8	4
2013	35	3	3556008	2.4393449e+08	13345	18279.09	4
2013	41	4	4110102	5.5503389e+08	30359	18282.35	4
2013	41	4	4107546	8.492393e+07	4642	18294.69	4
2013	35	3	3552908	1.1019332e+08	6023	18295.42	4
2013	43	4	4311007	5.2132993e+08	28482	18303.84	4
2013	24	2	2402501	1.9209767e+08	10491	18310.71	4
2013	43	4	4302907	2.5337148e+08	13834	18315.13	4
2013	43	4	4313805	1.3108256e+08	7156	18317.85	4
2013	35	3	3549250	3.416296e+07	1865	18317.94	4
2013	43	4	4301552	6.867005e+07	3748	18321.79	4
2013	35	3	3509700	9.2071833e+08	50221	18333.33	4
2013	35	3	3517604	3.3248482e+08	18129	18339.94	4
2013	43	4	4323507	5.317126e+07	2899	18341.24	4
2013	32	3	3201308	6.9022139e+09	375974	18358.22	4
2013	31	3	3102407	6.71483e+07	3657	18361.58	4
2013	35	3	3515301	5.054286e+07	2752	18365.86	4
2013	31	3	3137536	1.6780231e+08	9134	18371.17	4
2013	35	3	3507456	4.515851e+07	2458	18372.06	4
2013	43	4	4323754	6.448859e+07	3510	18372.82	4
2013	35	3	3512209	4.9073266e+08	26689	18387.08	4
2013	24	2	2407104	1.38912892e+09	75548	18387.37	4
2013	41	4	4124053	4.0686369e+08	22127	18387.66	4
2013	35	3	3547106	5.38599e+07	2929	18388.49	4
2013	25	2	2503001	3.9022496e+08	21212	18396.42	4
2013	43	4	4305835	2.884479e+07	1567	18407.65	4
2013	43	4	4304853	2.953086e+07	1604	18410.76	4
2013	42	4	4214102	4.262101e+07	2314	18418.76	4
2013	29	2	2929503	8.3062355e+08	45090	18421.46	4
2013	41	4	4128203	1.02264313e+09	55467	18436.96	4
2013	31	3	3128303	3.5599987e+08	19298	18447.5	4
2013	52	5	5212204	3.5896196e+08	19458	18448.04	4
2013	35	3	3506607	5.627111e+08	30492	18454.38	4
2013	41	4	4116307	7.118082e+07	3857	18454.97	4
2013	42	4	4215604	3.906795e+07	2116	18463.11	4
2013	52	5	5205406	3.999113e+08	21652	18469.95	4
2013	42	4	4209904	2.0332351e+08	11005	18475.56	4
2013	42	4	4215679	1.6415688e+08	8883	18479.89	4
2013	35	3	3515194	8.367072e+07	4525	18490.77	4
2013	41	4	4101309	1.400097e+08	7567	18502.67	4
2013	17	1	1700301	1.0777092e+08	5820	18517.34	4
2013	31	3	3134509	7.362973e+07	3976	18518.54	4
2013	35	3	3550506	1.3904242e+08	7508	18519.23	4
2013	43	4	4320800	5.7702468e+08	31150	18524.07	4
2013	41	4	4125001	2.1231768e+08	11461	18525.23	4
2013	35	3	3518602	6.998513e+08	37747	18540.58	4
2013	35	3	3539707	6.263115e+07	3378	18540.9	4
2013	29	2	2927408	5.347165913e+10	2883682	18542.84	4
2013	11	1	1100122	2.37480065e+09	128026	18549.36	4
2013	43	4	4305959	7.460437e+07	4019	18562.92	4
2013	43	4	4313441	4.327116e+07	2330	18571.31	4
2013	31	3	3108800	9.458337e+07	5091	18578.54	4
2013	32	3	3203346	2.914982e+08	15689	18579.78	4
2013	35	3	3508306	8.244639e+07	4430	18610.92	4
2013	42	4	4214151	5.300542e+07	2848	18611.45	4
2013	27	2	2702306	1.03598752e+09	55648	18616.8	4
2013	43	4	4308409	1.3316593e+08	7144	18640.25	4
2013	35	3	3507407	2.8585469e+08	15335	18640.67	4
2013	43	4	4305934	3.271317e+07	1754	18650.61	4
2013	11	1	1100072	1.6868059e+08	9036	18667.62	4
2013	41	4	4116901	5.16695e+08	27678	18668.08	4
2013	43	4	4305447	9.709307e+07	5201	18668.15	4
2013	42	4	4217709	5.2686585e+08	28209	18677.23	4
2013	42	4	4202875	5.125873e+07	2741	18700.74	4
2013	41	4	4101200	3.6320176e+08	19412	18710.17	4
2013	43	4	4318465	4.151501e+07	2217	18725.76	4
2013	31	3	3139003	7.6328692e+08	40760	18726.37	4
2013	31	3	3112802	1.5991258e+08	8535	18736.1	4
2013	52	5	5211602	4.968298e+07	2651	18741.22	4
2013	41	4	4121703	4.9283834e+08	26268	18761.93	4
2013	41	4	4123402	2.0939515e+08	11158	18766.37	4
2013	43	4	4321402	2.6424184e+08	14075	18773.84	4
2013	41	4	4126009	1.6744573e+08	8917	18778.26	4
2013	41	4	4119608	6.1845202e+08	32841	18831.7	4
2013	42	4	4215505	3.0726855e+08	16315	18833.5	4
2013	32	3	3202603	2.5524456e+08	13548	18840.02	4
2013	51	5	5106455	5.056638e+07	2683	18846.95	4
2013	43	4	4322525	6.415814e+07	3404	18847.87	4
2013	43	4	4302600	7.048336e+07	3735	18871.05	4
2013	43	4	4318309	1.18174812e+09	62594	18879.58	4
2013	32	3	3205069	4.3185961e+08	22873	18880.76	4
2013	43	4	4301925	3.763097e+07	1993	18881.57	4
2013	41	4	4112405	1.703816e+08	9020	18889.31	4
2013	35	3	3519204	1.2341671e+08	6530	18899.95	4
2013	52	5	5202809	4.733252e+07	2504	18902.76	4
2013	31	3	3152600	1.1908253e+08	6291	18929.03	4
2013	43	4	4323705	5.418881e+07	2862	18933.89	4
2013	35	3	3507803	4.3164311e+08	22797	18934.21	4
2013	16	1	1600303	8.27931011e+09	437256	18934.7	4
2013	50	5	5005681	3.3444362e+08	17658	18940.06	4
2013	52	5	5217708	3.3621883e+08	17749	18942.97	4
2013	35	3	3530102	5.4482054e+08	28758	18945.01	4
2013	35	3	3535804	3.596402e+08	18965	18963.36	4
2013	43	4	4319711	4.265781e+07	2249	18967.46	4
2013	42	4	4218251	1.4216445e+08	7495	18967.91	4
2013	42	4	4218905	2.0906359e+08	11012	18985.07	4
2013	50	5	5006408	1.5013787e+08	7908	18985.57	4
2013	41	4	4120150	6.915517e+07	3640	18998.67	4
2013	41	4	4102604	1.9280271e+08	10143	19008.45	4
2013	31	3	3152105	1.13358695e+09	59614	19015.45	4
2013	41	4	4110607	2.8681095e+08	15078	19021.82	4
2013	35	3	3525102	7.7310144e+08	40640	19023.17	4
2013	31	3	3164704	1.3039368e+09	68518	19030.57	4
2013	31	3	3140704	5.6291001e+08	29578	19031.37	4
2013	15	1	1501402	2.713928617e+10	1425922	19032.8	4
2013	35	3	3509601	1.50536572e+09	79091	19033.34	4
2013	42	4	4206900	3.445817e+08	18097	19040.82	4
2013	41	4	4115408	2.7430095e+08	14397	19052.65	4
2013	35	3	3549300	4.097559e+07	2150	19058.41	4
2013	12	1	1200401	6.80758145e+09	357194	19058.5	4
2013	15	1	1503044	3.5737869e+08	18741	19069.35	4
2013	31	3	3168200	3.66865e+07	1923	19077.74	4
2013	43	4	4312005	4.265396e+07	2235	19084.54	4
2013	35	3	3512506	1.0719477e+08	5615	19090.79	4
2013	41	4	4121505	2.8186602e+08	14752	19106.97	4
2013	33	3	3306107	1.39806482e+09	73154	19111.26	4
2013	31	3	3162922	5.3654152e+08	28064	19118.5	4
2013	41	4	4107306	1.151928e+08	6024	19122.31	4
2013	42	4	4207403	1.1376723e+08	5946	19133.41	4
2013	32	3	3200706	2.0784595e+08	10862	19135.15	4
2013	29	2	2903201	2.8886771e+09	150896	19143.5	4
2013	43	4	4320552	1.1804706e+08	6166	19144.84	4
2013	43	4	4320008	2.62502018e+09	137104	19146.2	4
2013	13	1	1301308	4.9232237e+08	25696	19159.49	4
2013	17	1	1714880	2.1654445e+08	11301	19161.53	4
2013	41	4	4123006	2.7511612e+08	14357	19162.51	4
2013	31	3	3107406	9.2683944e+08	48350	19169.38	4
2013	31	3	3110509	4.1874848e+08	21844	19169.95	4
2013	43	4	4300406	1.51594743e+09	79054	19176.1	4
2013	51	5	5101258	3.03229e+08	15803	19188.07	4
2013	35	3	3542008	1.2170254e+08	6339	19199.01	4
2013	17	1	1718402	7.212175e+07	3756	19201.74	4
2013	31	3	3143500	1.6630905e+08	8657	19210.93	4
2013	31	3	3168903	1.3372897e+08	6955	19227.75	4
2013	43	4	4310553	6.828383e+07	3549	19240.3	4
2013	43	4	4300570	5.840387e+07	3035	19243.45	4
2013	11	1	1100114	1.0704294e+09	55597	19253.37	4
2013	52	5	5215652	6.704159e+07	3482	19253.76	4
2013	35	3	3522406	1.76810001e+09	91807	19258.88	4
2013	43	4	4316451	2.380686e+08	12360	19261.21	4
2013	35	3	3519808	1.5176354e+08	7877	19266.67	4
2013	32	3	3200300	2.8636361e+08	14859	19272.06	4
2013	51	5	5103205	6.0738576e+08	31515	19272.91	4
2013	35	3	3536208	3.711143e+08	19239	19289.69	4
2013	31	3	3139409	1.63860299e+09	84934	19292.66	4
2013	26	2	2616407	2.58394426e+09	133907	19296.56	4
2013	50	5	5004908	1.2922659e+08	6696	19299.07	4
2013	43	4	4318200	4.132716e+08	21408	19304.54	4
2013	35	3	3542909	2.4619695e+08	12750	19309.56	4
2013	41	4	4128302	4.96433e+07	2570	19316.46	4
2013	43	4	4309654	1.2336985e+08	6386	19318.8	4
2013	35	3	3508801	3.3520132e+08	17346	19324.42	4
2013	43	4	4320602	7.567121e+07	3915	19328.53	4
2013	35	3	3500303	6.6086978e+08	34188	19330.46	4
2013	51	5	5105622	5.0277078e+08	26002	19335.85	4
2013	42	4	4216503	5.002447e+08	25841	19358.57	4
2013	43	4	4315453	4.26907e+07	2205	19360.86	4
2013	51	5	5105002	1.8841406e+08	9728	19368.22	4
2013	42	4	4218756	9.027174e+07	4660	19371.62	4
2013	41	4	4111555	1.5313095e+08	7901	19381.21	4
2013	33	3	3304508	1.702628e+08	8783	19385.49	4
2013	41	4	4108957	1.6173856e+08	8343	19386.14	4
2013	35	3	3527207	1.67396596e+09	86337	19388.74	4
2013	42	4	4207759	8.168619e+07	4212	19393.68	4
2013	52	5	5201405	9.70922755e+09	500619	19394.44	4
2013	35	3	3537305	1.19063881e+09	61371	19400.67	4
2013	43	4	4313086	4.939314e+07	2545	19407.91	4
2013	35	3	3500550	1.141271e+08	5876	19422.58	4
2013	35	3	3500501	3.5179891e+08	18108	19427.82	4
2013	31	3	3145208	1.64436118e+09	84550	19448.39	4
2013	33	3	3302205	1.90744347e+09	98004	19462.91	4
2013	25	2	2507507	1.500260925e+10	769607	19493.86	4
2013	33	3	3301207	3.4982572e+08	17944	19495.41	4
2013	23	2	2304400	4.975876285e+10	2551806	19499.43	4
2013	43	4	4322343	4.488939e+07	2302	19500.17	4
2013	43	4	4315909	1.1591141e+08	5942	19507.14	4
2013	26	2	2606200	1.52359272e+09	77945	19547.02	4
2013	41	4	4112900	6.812593e+07	3483	19559.56	4
2013	50	5	5002902	4.2044735e+08	21491	19563.88	4
2013	31	3	3142601	1.6705142e+08	8537	19567.93	4
2013	11	1	1100056	3.5326968e+08	18041	19581.49	4
2013	41	4	4101408	2.51113827e+09	128058	19609.38	4
2013	35	3	3517703	4.065974e+08	20733	19611.12	4
2013	52	5	5220058	3.237906e+07	1649	19635.57	4
2013	33	3	3304128	2.610528e+08	13283	19653.15	4
2013	35	3	3536604	1.7479837e+08	8893	19655.73	4
2013	42	4	4217105	6.367607e+07	3239	19659.18	4
2013	52	5	5222203	1.0323339e+08	5246	19678.5	4
2013	41	4	4101051	5.766997e+07	2929	19689.3	4
2013	43	4	4302378	4.554505e+07	2311	19707.94	4
2013	29	2	2915205	3.120304e+08	15829	19712.58	4
2013	41	4	4103958	8.141352e+07	4130	19712.72	4
2013	43	4	4319802	1.7256818e+08	8754	19713.07	4
2013	23	2	2305233	1.19545369e+09	60584	19732.17	4
2013	35	3	3519006	1.8069472e+08	9154	19739.43	4
2013	35	3	3547502	5.4108109e+08	27411	19739.56	4
2013	35	3	3557303	2.1061348e+08	10669	19740.7	4
2013	43	4	4318432	5.246549e+07	2657	19746.14	4
2013	52	5	5206305	5.960574e+07	3016	19763.17	4
2013	17	1	1709500	1.61666626e+09	81792	19765.58	4
2013	42	4	4215455	2.2324609e+08	11294	19766.79	4
2013	31	3	3101508	7.0305358e+08	35559	19771.47	4
2013	43	4	4315503	3.2349744e+08	16357	19777.31	4
2013	35	3	3515152	3.4990701e+08	17681	1.979e+04	4
2013	41	4	4100707	2.0489434e+08	10350	19796.55	4
2013	35	3	3507100	4.3524179e+08	21976	19805.32	4
2013	43	4	4304614	3.647313e+07	1841	19811.59	4
2013	35	3	3537602	1.26551852e+09	63815	19831.05	4
2013	42	4	4214409	1.2384996e+08	6245	19831.86	4
2013	41	4	4106571	8.694486e+07	4383	19836.84	4
2013	41	4	4123600	3.581064e+07	1804	19850.69	4
2013	41	4	4112603	2.82707e+07	1424	19853.02	4
2013	42	4	4200903	1.0256392e+08	5166	19853.64	4
2013	43	4	4319703	7.27735e+07	3665	19856.34	4
2013	43	4	4304697	5.447613e+07	2741	19874.54	4
2013	31	3	3113206	4.8882372e+08	24594	19875.73	4
2013	43	4	4308052	5.142277e+07	2587	19877.38	4
2013	42	4	4200754	3.989802e+07	2007	19879.43	4
2013	41	4	4108320	1.2890507e+08	6483	19883.55	4
2013	31	3	3109907	2.1710255e+08	10918	19884.83	4
2013	31	3	3100104	1.3869394e+08	6967	19907.27	4
2013	43	4	4322327	7.194446e+07	3608	19940.26	4
2013	50	5	5004601	3.9319383e+08	19672	19987.49	4
2013	35	3	3531209	1.519121e+08	7593	20006.86	4
2013	17	1	1720853	3.713852e+07	1856	20009.98	4
2013	35	3	3553302	4.6350829e+08	23159	20014.18	4
2013	42	4	4210308	1.5585952e+08	7782	20028.21	4
2013	42	4	4203402	1.4861749e+08	7419	20032.01	4
2013	31	3	3107604	8.197141e+07	4091	20037.01	4
2013	51	5	5106752	8.5404351e+08	42605	20045.62	4
2013	43	4	4310751	4.345777e+07	2166	20063.61	4
2013	41	4	4127965	2.7998585e+08	13937	20089.39	4
2013	43	4	4317707	2.2727121e+08	11312	20091.16	4
2013	51	5	5108402	5.2856538e+09	262880	20106.72	4
2013	43	4	4302253	5.753712e+07	2860	20117.88	4
2013	31	3	3136306	9.578198e+08	47549	20143.85	4
2013	41	4	4123907	2.5315126e+08	12562	20152.15	4
2013	35	3	3528007	3.4086662e+08	16909	20158.89	4
2013	35	3	3514106	5.2672573e+08	26126	20160.98	4
2013	52	5	5207253	1.6003923e+08	7938	20161.15	4
2013	43	4	4321501	7.3799564e+08	36595	20166.57	4
2013	21	2	2105302	5.07153246e+09	251468	20167.71	4
2013	42	4	4215752	5.326601e+07	2641	20168.88	4
2013	41	4	4125100	2.9171636e+08	14462	20171.23	4
2013	42	4	4203154	6.896923e+07	3416	20190.06	4
2013	35	3	3500204	7.352929e+07	3639	20205.91	4
2013	42	4	4214706	2.1996313e+08	10879	20219.06	4
2013	42	4	4203105	1.2688886e+08	6274	20224.56	4
2013	27	2	2708600	1.19483983e+09	59077	20225.13	4
2013	43	4	4305371	7.144801e+07	3532	20228.77	4
2013	35	3	3541307	8.7318821e+08	43155	20233.77	4
2013	43	4	4317301	6.3980279e+08	31618	20235.4	4
2013	41	4	4103602	5.0457098e+08	24928	20241.13	4
2013	41	4	4116505	3.036713e+07	1500	20244.75	4
2013	35	3	3528700	1.0630638e+08	5251	20244.98	4
2013	24	2	2403707	1.2093513e+08	5973	20246.97	4
2013	43	4	4315552	7.151986e+07	3531	20254.85	4
2013	35	3	3547908	1.3472965e+08	6644	20278.39	4
2013	33	3	3300225	2.389897e+08	11785	20279.14	4
2013	35	3	3533502	7.874417e+08	38828	20280.25	4
2013	35	3	3519600	1.14720261e+09	56531	20293.34	4
2013	33	3	3303401	3.73892286e+09	184122	20306.77	4
2013	52	5	5200209	4.104597e+07	2021	20309.73	4
2013	23	2	2301000	1.5488846e+09	76186	20330.3	4
2013	51	5	5107743	4.348673e+07	2139	20330.4	4
2013	42	4	4215554	4.786787e+07	2354	20334.69	4
2013	35	3	3516705	9.0580279e+08	44479	20364.73	4
2013	41	4	4109104	4.663621e+07	2289	20374.06	4
2013	41	4	4120101	9.63121e+07	4727	20374.89	4
2013	41	4	4114500	2.7737689e+08	13610	20380.37	4
2013	50	5	5003306	6.7170319e+08	32948	20386.77	4
2013	41	4	4104105	1.5411341e+08	7550	20412.37	4
2013	35	3	3520905	2.9365165e+08	14383	20416.58	4
2013	42	4	4207650	1.779182e+08	8714	20417.51	4
2013	41	4	4111803	8.2133943e+08	40221	20420.66	4
2013	35	3	3556503	2.3327266e+09	114170	20432.05	4
2013	41	4	4107736	1.2277916e+08	6008	20435.95	4
2013	42	4	4209177	4.411016e+07	2158	20440.29	4
2013	41	4	4118402	1.75058519e+09	85643	20440.49	4
2013	11	1	1100189	7.5554177e+08	36939	20453.77	4
2013	41	4	4107603	3.4806542e+08	17006	20467.21	4
2013	43	4	4306205	2.6355508e+08	12876	20468.71	4
2013	43	4	4320701	3.0420733e+08	14861	20470.18	4
2013	42	4	4212601	6.057694e+07	2958	20479.02	4
2013	41	4	4105003	2.1439024e+08	10467	20482.49	4
2013	43	4	4318614	4.546216e+07	2218	20496.92	4
2013	42	4	4216057	1.077669e+08	5255	20507.5	4
2013	28	2	2805901	2.0237876e+08	9863	20518.99	4
2013	50	5	5003900	6.151747e+07	2997	20526.35	4
2013	51	5	5103304	3.9157649e+08	19045	20560.59	4
2013	31	3	3162005	5.1416143e+08	25007	20560.7	4
2013	43	4	4319364	4.048751e+07	1969	20562.47	4
2013	31	3	3171204	2.35215469e+09	114365	20567.09	4
2013	31	3	3148103	1.79324764e+09	87178	20569.96	4
2013	41	4	4120507	2.3044389e+08	11199	20577.18	4
2013	35	3	3545407	1.8841313e+08	9156	20578.11	4
2013	35	3	3553856	1.1296692e+08	5489	20580.6	4
2013	33	3	3306206	7.2272009e+08	35112	20583.28	4
2013	43	4	4316006	4.2170325e+08	20479	20591.98	4
2013	43	4	4312500	2.6024722e+08	12637	20594.07	4
2013	17	1	1713205	4.1703578e+08	20243	20601.48	4
2013	41	4	4107900	1.304131e+08	6324	20621.93	4
2013	24	2	2404309	2.6677644e+08	12934	20625.98	4
2013	42	4	4215109	2.3264665e+08	11270	20643	4
2013	43	4	4321303	5.5824178e+08	27039	20645.8	4
2013	52	5	5219738	1.0845392e+08	5253	20646.09	4
2013	52	5	5217401	6.2449535e+08	30232	20656.77	4
2013	33	3	3305703	3.1132098e+08	15070	20658.33	4
2013	32	3	3201209	4.23961014e+09	205213	20659.56	4
2013	31	3	3142809	4.2577549e+08	20594	20674.73	4
2013	50	5	5007554	1.5577921e+08	7530	20687.81	4
2013	35	3	3515806	3.515304e+07	1699	20690.43	4
2013	35	3	3537404	5.3281747e+08	25742	20698.37	4
2013	43	4	4300109	3.5528966e+08	17161	20703.32	4
2013	42	4	4212403	8.509302e+07	4110	20703.9	4
2013	42	4	4210803	1.467009e+08	7085	20705.84	4
2013	29	2	2919926	4.0635689e+08	19600	20732.49	4
2013	52	5	5214838	2.5916079e+08	12488	20752.79	4
2013	41	4	4127858	2.5331537e+08	12196	20770.36	4
2013	42	4	4201406	1.33943472e+09	64405	20797.06	4
2013	41	4	4128658	8.475073e+07	4075	20797.72	4
2013	43	4	4318424	1.0090935e+08	4851	20801.76	4
2013	50	5	5000807	1.8222609e+08	8758	20806.82	4
2013	35	3	3552304	1.6018803e+08	7691	20827.98	4
2013	35	3	3501004	3.3615714e+08	16137	20831.45	4
2013	43	4	4304630	9.5313286e+08	45744	20836.24	4
2013	31	3	3170750	1.367015e+08	6558	20845	4
2013	35	3	3511904	1.6099441e+08	7717	20862.3	4
2013	41	4	4125209	1.9449615e+08	9313	20884.37	4
2013	41	4	4103909	3.2299627e+08	15463	20888.33	4
2013	31	3	3138807	3.7951001e+08	18168	20888.93	4
2013	31	3	3110608	5.8765523e+08	28123	20895.89	4
2013	35	3	3535507	9.2619128e+08	44310	20902.53	4
2013	35	3	3517802	1.7948858e+08	8586	20904.8	4
2013	52	5	5209952	3.0454771e+08	14560	20916.74	4
2013	51	5	5106182	1.218339e+08	5824	20919.28	4
2013	35	3	3532157	6.078047e+07	2905	20922.71	4
2013	35	3	3554755	3.422287e+07	1635	20931.42	4
2013	31	3	3117504	3.8254573e+08	18273	20935.03	4
2013	52	5	5204102	2.3762264e+08	11348	20939.6	4
2013	32	3	3201506	2.52705499e+09	120677	20940.65	4
2013	42	4	4210852	5.186465e+07	2476	20946.95	4
2013	31	3	3162955	4.5128077e+08	21538	20952.77	4
2013	41	4	4114302	5.0560659e+08	24112	20969.09	4
2013	31	3	3138203	2.05919579e+09	98172	20975.39	4
2013	50	5	5002209	4.3215118e+08	20597	20981.27	4
2013	35	3	3529658	4.061062e+07	1935	20987.4	4
2013	31	3	3154804	2.0367971e+08	9704	20989.25	4
2013	42	4	4214508	1.2997754e+08	6185	21014.96	4
2013	35	3	3529906	4.3724448e+08	20790	21031.48	4
2013	43	4	4312476	1.2640765e+08	6008	21039.89	4
2013	52	5	5209705	4.0009932e+08	19015	21041.25	4
2013	35	3	3502507	7.6068865e+08	36151	21041.98	4
2013	41	4	4116802	1.4777887e+08	7023	21042.13	4
2013	43	4	4316907	5.75513801e+09	273489	21043.4	4
2013	43	4	4305439	1.3199808e+08	6269	21055.68	4
2013	52	5	5200050	1.5933268e+08	7567	21056.25	4
2013	29	2	2921906	2.2270844e+08	10568	21073.85	4
2013	33	3	3302452	1.1297724e+08	5360	21077.84	4
2013	42	4	4204905	1.8156401e+08	8612	21082.68	4
2013	41	4	4105904	4.9366036e+08	23402	21094.79	4
2013	51	5	5105507	3.1659516e+08	14999	21107.75	4
2013	42	4	4215000	8.6902247e+08	41167	21109.69	4
2013	43	4	4315131	3.96589e+07	1878	21117.63	4
2013	51	5	5101803	1.22200501e+09	57791	21145.25	4
2013	33	3	3304706	8.6790275e+08	41035	21150.3	4
2013	41	4	4108601	6.2933921e+08	29743	21159.24	4
2013	31	3	3124708	7.623754e+07	3602	21165.34	4
2013	28	2	2801207	5.7446886e+08	27136	21169.99	4
2013	35	3	3526001	4.1848849e+08	19765	21173.21	4
2013	50	5	5006309	8.729419e+08	41227	21174.03	4
2013	35	3	3509957	1.0002037e+08	4722	21181.78	4
2013	35	3	3517901	2.2432924e+08	10584	21195.13	4
2013	31	3	3169901	2.30054174e+09	108493	21204.52	4
2013	26	2	2603603	1.783224e+08	8405	21216.23	4
2013	31	3	3170438	9.544325e+07	4498	21219.04	4
2013	42	4	4201273	9.065498e+07	4270	21230.67	4
2013	41	4	4113007	1.464798e+08	6897	21238.19	4
2013	35	3	3553708	1.19376976e+09	56204	21239.94	4
2013	41	4	4127007	2.3663176e+08	11140	21241.63	4
2013	43	4	4303004	1.82807366e+09	85955	21267.8	4
2013	43	4	4306452	7.238219e+07	3403	21270.11	4
2013	43	4	4302303	2.5149009e+08	11823	21271.26	4
2013	52	5	5205059	7.830434e+07	3676	21301.51	4
2013	51	5	5103700	2.5769688e+08	12088	21318.41	4
2013	35	3	3503000	1.1546832e+08	5416	21319.85	4
2013	41	4	4125803	2.2737871e+08	10664	21322.08	4
2013	50	5	5006606	1.78568413e+09	83747	21322.37	4
2013	43	4	4310413	4.959565e+07	2324	21340.64	4
2013	43	4	4317954	5.346106e+07	2504	21350.26	4
2013	50	5	5007505	1.1009858e+08	5156	21353.49	4
2013	42	4	4214607	1.5643451e+08	7319	21373.75	4
2013	41	4	4118857	1.2663527e+08	5923	21380.26	4
2013	31	3	3148004	3.13092578e+09	146416	21383.77	4
2013	43	4	4308250	4.324193e+07	2021	21396.31	4
2013	35	3	3515657	3.52296e+07	1646	21403.16	4
2013	41	4	4121307	8.603957e+07	4018	21413.53	4
2013	43	4	4321857	9.614824e+07	4487	21428.18	4
2013	31	3	3154705	8.55567e+07	3990	21442.78	4
2013	42	4	4206801	7.202973e+07	3359	21443.8	4
2013	50	5	5004304	3.3113973e+08	15429	21462.16	4
2013	25	2	2509305	1.7088243e+08	7952	21489.24	4
2013	32	3	3205101	1.54970788e+09	72115	21489.4	4
2013	52	5	5212105	1.5846877e+08	7374	21490.21	4
2013	31	3	3123502	4.105158e+07	1909	21504.23	4
2013	52	5	5220454	2.0442353e+09	95018	21514.19	4
2013	50	5	5004502	4.7829571e+08	22231	21514.81	4
2013	35	3	3537107	9.5792897e+08	44509	21522.14	4
2013	50	5	5002605	2.9645511e+08	13770	21529.06	4
2013	43	4	4301701	1.4521478e+08	6744	21532.44	4
2013	42	4	4206603	1.0895387e+08	5054	21557.95	4
2013	31	3	3111101	4.3049829e+08	19959	21569.13	4
2013	42	4	4213401	2.450463e+08	11358	21574.78	4
2013	42	4	4213906	3.648463e+07	1691	21575.77	4
2013	43	4	4316105	2.2901905e+08	10610	21585.21	4
2013	31	3	3166402	4.006855e+07	1855	21600.3	4
2013	43	4	4308003	1.4845991e+08	6871	21606.74	4
2013	41	4	4118451	1.1171314e+08	5170	21607.96	4
2013	35	3	3543303	2.56959538e+09	118871	21616.67	4
2013	51	5	5105200	2.432621e+08	11252	21619.45	4
2013	24	2	2408102	1.846510076e+10	853928	21623.72	4
2013	41	4	4128534	2.3273882e+08	10763	21623.97	4
2013	35	3	3535002	2.5762614e+08	11904	21641.98	4
2013	42	4	4207858	4.476827e+07	2067	21658.57	4
2013	31	3	3127107	1.22895366e+09	56720	21667.03	4
2013	41	4	4119400	5.3337038e+08	24613	21670.27	4
2013	43	4	4321956	1.2921907e+08	5962	21673.78	4
2013	43	4	4310652	5.68945e+07	2625	21674.1	4
2013	35	3	3525409	7.001549e+07	3230	21676.62	4
2013	41	4	4108809	6.9781771e+08	32190	21678.09	4
2013	35	3	3519501	1.5617487e+08	7203	21681.92	4
2013	14	1	1400100	6.70537682e+09	308996	21700.53	4
2013	51	5	5103056	2.4666125e+08	11366	21701.68	4
2013	41	4	4106506	4.7838517e+08	22035	21710.24	4
2013	43	4	4304101	7.738466e+07	3559	21743.37	4
2013	35	3	3524808	1.05994544e+09	48724	21754.07	4
2013	42	4	4205456	5.2771314e+08	24256	21755.98	4
2013	35	3	3546108	4.660242e+07	2141	21766.66	4
2013	17	1	1707652	1.1802926e+08	5421	21772.6	4
2013	35	3	3554300	4.8824517e+08	22424	21773.33	4
2013	41	4	4117255	2.3296578e+08	10698	21776.57	4
2013	42	4	4200200	2.1697764e+08	9957	21791.47	4
2013	41	4	4103305	1.6854078e+08	7724	21820.4	4
2013	41	4	4112207	1.3840208e+08	6341	21826.54	4
2013	35	3	3532603	2.4452565e+08	11203	21826.8	4
2013	42	4	4208302	1.15521802e+09	52923	21828.28	4
2013	41	4	4128559	1.9830656e+08	9081	21837.52	4
2013	33	3	3305554	1.77522915e+09	81260	21846.29	4
2013	31	3	3161304	1.3262066e+08	6069	21852.14	4
2013	41	4	4119657	6.566363e+07	3004	21858.73	4
2013	41	4	4102802	3.4039711e+08	15565	21869.39	4
2013	21	2	2109007	4.9583822e+08	22651	21890.35	4
2013	41	4	4103040	1.4671552e+08	6702	21891.3	4
2013	43	4	4313003	7.248723e+07	3311	21892.85	4
2013	31	3	3122306	4.95809122e+09	226345	21905.02	4
2013	43	4	4302204	1.4904692e+08	6800	21918.67	4
2013	43	4	4309555	9.904224e+07	4517	21926.55	4
2013	32	3	3205200	1.005921015e+10	458489	21939.92	4
2013	21	2	2104057	8.5434414e+08	38932	21944.52	4
2013	24	2	2408003	6.15175158e+09	280314	21945.93	4
2013	35	3	3525854	6.676453e+07	3042	21947.58	4
2013	21	2	2111300	2.313444033e+10	1053922	21950.81	4
2013	52	5	5210406	8.4174581e+08	38324	21963.93	4
2013	50	5	5003751	2.6423782e+08	12029	21966.73	4
2013	24	2	2401453	5.7902031e+08	26347	21976.71	4
2013	35	3	3516200	7.40074092e+09	336734	21978	4
2013	41	4	4118105	2.3877303e+08	10863	21980.39	4
2013	41	4	4125753	1.4277661e+08	6495	21982.54	4
2013	27	2	2702702	1.0287352e+08	4678	21990.92	4
2013	35	3	3518206	7.0433135e+08	32023	21994.55	4
2013	42	4	4209805	7.256367e+07	3298	22002.33	4
2013	33	3	3305505	1.74829454e+09	79421	22013	4
2013	35	3	3536000	2.450393e+08	11124	22027.98	4
2013	50	5	5007901	1.05894387e+09	48027	22048.93	4
2013	41	4	4105409	4.4297421e+08	20077	22063.77	4
2013	52	5	5222005	2.9191874e+08	13227	22069.91	4
2013	35	3	3518701	6.76862708e+09	306683	22070.43	4
2013	51	5	5107180	2.0561182e+08	9316	22070.83	4
2013	43	4	4312625	4.162156e+07	1885	22080.4	4
2013	43	4	4314456	5.74748e+07	2602	22088.7	4
2013	35	3	3528304	7.176144e+07	3246	22107.65	4
2013	42	4	4215208	1.1990718e+08	5421	22119.01	4
2013	43	4	4315172	4.530679e+07	2048	22122.46	4
2013	43	4	4321907	5.459568e+08	24665	22134.88	4
2013	43	4	4305801	2.2311078e+08	10077	22140.6	4
2013	42	4	4202305	1.38173762e+09	62383	22149.27	4
2013	52	5	5206602	6.666994e+07	3010	22149.48	4
2013	43	4	4306304	1.0720913e+08	4834	22178.14	4
2013	35	3	3510153	1.050775e+08	4737	22182.29	4
2013	29	2	2921005	9.880109e+08	44538	22183.55	4
2013	42	4	4216354	7.939449e+07	3578	22189.63	4
2013	43	4	4318622	7.637677e+07	3441	22196.1	4
2013	42	4	4205001	3.3816795e+08	15227	22208.44	4
2013	35	3	3509809	1.0609396e+08	4776	22213.98	4
2013	43	4	4301206	2.9414941e+08	13235	22225.12	4
2013	41	4	4123303	1.8277962e+08	8222	22230.55	4
2013	31	3	3149200	8.061965e+07	3626	22233.77	4
2013	35	3	3555000	1.45728993e+09	65540	22235.12	4
2013	35	3	3533205	7.615806e+07	3423	22248.92	4
2013	35	3	3510005	6.896024e+08	30993	22250.26	4
2013	42	4	4217402	3.9032165e+08	17538	22255.77	4
2013	31	3	3109303	5.3399352e+08	23979	22269.22	4
2013	32	3	3204203	4.4728349e+08	20082	22272.86	4
2013	41	4	4115754	2.0842128e+08	9355	22279.13	4
2013	43	4	4318440	6.349675e+07	2850	22279.56	4
2013	33	3	3301900	5.01966697e+09	225263	22283.58	4
2013	31	3	3105905	4.5648486e+08	20484	22284.95	4
2013	32	3	3204559	8.4153199e+08	37720	22309.97	4
2013	43	4	4317509	1.75887955e+09	78836	22310.61	4
2013	22	2	2204501	2.3076751e+08	10342	22313.62	4
2013	35	3	3541653	7.788148e+07	3489	22322.01	4
2013	35	3	3511003	4.3223385e+08	19360	22326.13	4
2013	43	4	4306759	4.648828e+07	2082	22328.67	4
2013	43	4	4322905	1.1937301e+08	5344	22337.76	4
2013	35	3	3545159	1.6996783e+08	7607	22343.61	4
2013	52	5	5201454	5.58944e+07	2501	22348.82	4
2013	41	4	4110706	1.31902354e+09	58957	22372.64	4
2013	41	4	4109005	8.879646e+07	3968	22378.14	4
2013	42	4	4208955	3.852625e+07	1721	22385.97	4
2013	41	4	4101002	4.0937334e+08	18281	22393.38	4
2013	43	4	4310306	9.442217e+07	4215	22401.46	4
2013	52	5	5212303	1.8221164e+08	8133	22403.99	4
2013	35	3	3504503	1.95572228e+09	87238	22418.24	4
2013	41	4	4125902	5.619712e+07	2506	22425.03	4
2013	35	3	3539202	5.864049e+08	26146	22428.09	4
2013	52	5	5204508	1.74725542e+09	77899	22429.75	4
2013	43	4	4322707	5.6860904e+08	25338	22440.96	4
2013	42	4	4214003	3.5777838e+08	15943	22441.09	4
2013	35	3	3506508	2.60097289e+09	115898	22441.91	4
2013	43	4	4319372	6.676653e+07	2975	22442.53	4
2013	31	3	3172004	9.062042e+08	40356	22455.25	4
2013	35	3	3516853	1.0412038e+08	4635	22463.94	4
2013	42	4	4219408	8.468044e+07	3769	22467.61	4
2013	17	1	1721000	5.79478922e+09	257904	22468.78	4
2013	41	4	4123824	8.988027e+07	3997	22486.93	4
2013	43	4	4314076	1.4194044e+08	6307	22505.22	4
2013	42	4	4212270	9.877854e+07	4387	22516.19	4
2013	43	4	4309951	9.39236e+07	4170	22523.65	4
2013	52	5	5217203	2.5492152e+08	11314	22531.51	4
2013	33	3	3300506	5.8521965e+08	25969	22535.32	4
2013	41	4	412665