--
--Copyright (C) 2019 Centro de Computacao Cientifica e Software Livre
--Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR
--
--This file is part of SMPPIR-Tables.
--
--SMPPIR-Tables is free software: you can redistribute it and/or modify
--it under the terms of the GNU General Public License as published by
--the Free Software Foundation, either version 3 of the License, or
--(at your option) any later version.
--
--SMPPIR-Tables is distributed in the hope that it will be useful,
--but WITHOUT ANY WARRANTY; without even the implied warranty of
--MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--GNU General Public License for more details.
--
--You should have received a copy of the GNU General Public License
--along with SMPPIR-Tables.  If not, see <https://www.gnu.org/licenses/>.
--

CREATE TABLE indigenas_infrastructure_ag 
AS 
SELECT
    familias_cadunico_2.ano_censo,
    familias_cadunico_2.cod_especie_domicilio,
    familias_cadunico_2.ind_tipo_familia,
    familias_cadunico_2.cod_local_domicilio,
    familias_cadunico_2.cod_iluminacao_domicilio,
    familias_cadunico_2.cod_destino_lixo_domicilio,
    familias_cadunico_2.cod_abastecimento_agua_domicilio,
    familias_cadunico_2.cod_familia_indigena,    
    familias_cadunico_2.cod_escoa_sanitario_domicilio,
    familias_cadunico_2.id_familia,
    geographic.nome_regiao,
    geographic.sigla_estado,
    COUNT(*) AS Total 
    
FROM

    -- Data from CadUnico
    familias_cadunico_2 
        INNER JOIN 
        
    -- Geogrphic (State/Region) data    
    (
        SELECT 
            municipio.id AS municipio_id,
            regiao.nome AS nome_regiao,
            estado.sigla AS sigla_estado
        FROM
            estado INNER JOIN municipio ON (estado.id = municipio.estado_id)
                INNER JOIN regiao ON (regiao.id = estado.regiao_id)
    ) AS geographic ON (geographic.municipio_id = familias_cadunico_2.codigo_ibge)
    
WHERE 
    cod_familia_indigena = '1'

GROUP BY 
    familias_cadunico_2.ano_censo, 
    familias_cadunico_2.cod_especie_domicilio,
    familias_cadunico_2.ind_tipo_familia, 
    familias_cadunico_2.cod_local_domicilio,
    familias_cadunico_2.cod_iluminacao_domicilio,
    familias_cadunico_2.cod_destino_lixo_domicilio,
    familias_cadunico_2.cod_abastecimento_agua_domicilio,
    familias_cadunico_2.cod_familia_indigena,  
    familias_cadunico_2.cod_escoa_sanitario_domicilio, 
    familias_cadunico_2.id_familia,
    geographic.nome_regiao,
    geographic.sigla_estado

ORDER BY 
    familias_cadunico_2.ano_censo ASC, 
    familias_cadunico_2.cod_especie_domicilio ASC, 
    familias_cadunico_2.ind_tipo_familia,
    familias_cadunico_2.cod_local_domicilio,
    familias_cadunico_2.cod_iluminacao_domicilio,
    familias_cadunico_2.cod_destino_lixo_domicilio,
    familias_cadunico_2.cod_abastecimento_agua_domicilio,
    familias_cadunico_2.cod_familia_indigena,    
    geographic.nome_regiao ASC,
    geographic.sigla_estado ASC
    ;