--
--Copyright (C) 2019 Centro de Computacao Cientifica e Software Livre
--Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR
--
--This file is part of SMPPIR-Tables.
--
--SMPPIR-Tables is free software: you can redistribute it and/or modify
--it under the terms of the GNU General Public License as published by
--the Free Software Foundation, either version 3 of the License, or
--(at your option) any later version.
--
--SMPPIR-Tables is distributed in the hope that it will be useful,
--but WITHOUT ANY WARRANTY; without even the implied warranty of
--MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--GNU General Public License for more details.
--
--You should have received a copy of the GNU General Public License
--along with SMPPIR-Tables.  If not, see <https://www.gnu.org/licenses/>.
--

CREATE TABLE jvt_trabalho_ag
AS
SELECT 
    ano_censo,
    cod_uf,
    sgl_uf,
    cor_raca,
    CASE 
        WHEN ((trabalhou_referencia_dinheiro = 1) OR (trabalhou_referencia_bens = 1) OR (trabalhou_referencia_bico = 1) OR (trabalhou_referencia_nao_remunerado = 1) OR (afastado_referencia = 1)) THEN 1
        WHEN ((trabalhou_referencia_dinheiro = 2) AND (trabalhou_referencia_bens = 2) AND (trabalhou_referencia_bico = 2) AND (trabalhou_referencia_nao_remunerado = 2) AND (afastado_referencia = 2)) THEN 2
        ELSE null    
    END AS trabalhou_referencia,
    tipo_vinculo,
    rendimento_faixa,
    rendimento_bruto,
    COUNT(*) AS total 

FROM 
    pnad_cont 

WHERE
    (idade >=15) AND
    (idade <=29)
    
GROUP BY 
    ano_censo,
    sgl_uf,
    cod_uf,
    cor_raca,
    tipo_vinculo,
    trabalhou_referencia,
    rendimento_faixa,
    rendimento_bruto

ORDER BY 
    ano_censo ASC,
    sgl_uf ASC,
    cod_uf ASC,
    cor_raca ASC,
    tipo_vinculo ASC,
    trabalhou_referencia ASC,
    rendimento_faixa ASC,
    rendimento_bruto  ASC 
;