CREATE TABLE localoferta_ens_superior_matricula AS (

WITH
    COD_CURSO AS
        (SELECT aluno_ens_superior.cod_aluno, aluno_ens_superior.ano_censo, aluno_ens_superior.cod_uf_ies AS "aluno_cod_uf",
            aluno_ens_superior.cod_municipio_ies AS "aluno_cod_municipio", aluno_ens_superior.cod_regiao_ies AS "aluno_regiao_ies",
            aluno_ens_superior.idade_aluno_codigo, aluno_ens_superior.par_categoria_administrativa, aluno_ens_superior.cod_organizacao_academica,
            aluno_ens_superior.par_cod_ocde_area_especifica, aluno_ens_superior.par_cod_ocde_area_geral, aluno_ens_superior.par_cod_ocde_area_detalhada,
            aluno_ens_superior.nome_ocde_area_especifica, aluno_ens_superior.nome_ocde_area_geral, aluno_ens_superior.nome_ocde_area_detalhada,
            aluno_ens_superior.cod_grau_academico, aluno_ens_superior.cod_modalidade_ensino, aluno_ens_superior.cod_turno_aluno,
            aluno_ens_superior.par_cod_cor_raca_aluno, aluno_ens_superior.par_aluno_deficiencia_transtorno_superdotacao,
            aluno_ens_superior.nome_ies AS "nome_ies", aluno_ens_superior.cod_ies AS "cod_ies", aluno_ens_superior.par_genero_aluno,
            localoferta_ens_superior.cod_local_oferta, localoferta_ens_superior.cod_uf AS "localoferta_cod_uf", aluno_ens_superior.par_tipo_escola_ensino_medio,
            localoferta_ens_superior.cod_municipio AS "localoferta_cod_municipio", localoferta_ens_superior.cod_regiao AS "localoferta_cod_regiao",
            localoferta_ens_superior.nome AS "localoferta_nome", aluno_ens_superior.concluinte AS "concluinte", aluno_ens_superior.cod_aluno_situacao AS "cod_aluno_situacao", aluno_ens_superior.ingressante AS "ingressante",
            aluno_ens_superior.cod_curso AS "cod_curso", aluno_ens_superior.cod_nivel_academico AS "cod_nivel_academico", aluno_ens_superior.matriculado AS "matriculado" -- adicionado para poder ser consultado na api.
        FROM
            aluno_ens_superior INNER JOIN localoferta_ens_superior ON (aluno_ens_superior.ano_censo=localoferta_ens_superior.ano_censo AND aluno_ens_superior.cod_curso=localoferta_ens_superior.cod_curso)
        WHERE
        	(localoferta_ens_superior.cod_curso_polo IS NULL)
    	),
    COD_CURSO_POLO AS
        (SELECT aluno_ens_superior.cod_aluno, aluno_ens_superior.ano_censo, aluno_ens_superior.cod_uf_ies AS "aluno_cod_uf",
            aluno_ens_superior.cod_municipio_ies AS "aluno_cod_municipio", aluno_ens_superior.cod_regiao_ies AS "aluno_regiao_ies",
            aluno_ens_superior.idade_aluno_codigo, aluno_ens_superior.par_categoria_administrativa, aluno_ens_superior.cod_organizacao_academica,
            aluno_ens_superior.par_cod_ocde_area_especifica, aluno_ens_superior.par_cod_ocde_area_geral, aluno_ens_superior.par_cod_ocde_area_detalhada,
            aluno_ens_superior.nome_ocde_area_especifica, aluno_ens_superior.nome_ocde_area_geral, aluno_ens_superior.nome_ocde_area_detalhada,
            aluno_ens_superior.cod_grau_academico, aluno_ens_superior.cod_modalidade_ensino, aluno_ens_superior.cod_turno_aluno,
            aluno_ens_superior.par_cod_cor_raca_aluno, aluno_ens_superior.par_aluno_deficiencia_transtorno_superdotacao,
            aluno_ens_superior.nome_ies AS "nome_ies", aluno_ens_superior.cod_ies AS "cod_ies", aluno_ens_superior.par_genero_aluno,
            localoferta_ens_superior.cod_local_oferta, localoferta_ens_superior.cod_uf AS "localoferta_cod_uf", aluno_ens_superior.par_tipo_escola_ensino_medio,
            localoferta_ens_superior.cod_municipio AS "localoferta_cod_municipio", localoferta_ens_superior.cod_regiao AS "localoferta_cod_regiao",
            localoferta_ens_superior.nome AS "localoferta_nome", aluno_ens_superior.concluinte AS "concluinte", aluno_ens_superior.cod_aluno_situacao AS "cod_aluno_situacao", aluno_ens_superior.ingressante AS "ingressante",
            aluno_ens_superior.cod_curso AS "cod_curso", aluno_ens_superior.cod_nivel_academico AS "cod_nivel_academico", aluno_ens_superior.matriculado AS "matriculado"
        FROM
        	aluno_ens_superior INNER JOIN localoferta_ens_superior ON (aluno_ens_superior.ano_censo=localoferta_ens_superior.ano_censo AND aluno_ens_superior.cod_curso_polo=localoferta_ens_superior.cod_curso_polo)
        WHERE
        	(localoferta_ens_superior.cod_curso_polo > 0)
        )

SELECT * FROM COD_CURSO
UNION ALL (SELECT * FROM COD_CURSO_POLO)
);