/*
Copyright (C) 2016 Centro de Computacao Cientifica e Software Livre
Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR

This file is part of HOTMapper.

HOTMapper is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

HOTMapper is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with HOTMapper.  If not, see <https://www.gnu.org/licenses/>.
*/

-- depends: estado
-- SimCAQ: tabela de municípios --
CREATE TABLE municipio
(
    id                  INT NOT NULL,
    nome                TEXT NOT NULL,
    estado_id           INT NOT NULL,
    longitude           DOUBLE NOT NULL,
    latitude            DOUBLE NOT NULL,
    mesorregiao_id      INT NOT NULL,
    nome_mesorregiao    VARCHAR(128) NOT NULL,
    microrregiao_id     INT NOT NULL,
    nome_microrregiao   VARCHAR(128) NOT NULL,
    CONSTRAINT municipio_pk_codigo_ibge PRIMARY KEY(id),
    CONSTRAINT municipio_fk_estado_id FOREIGN KEY(estado_id) REFERENCES estado(id)
);

COPY 5570 RECORDS INTO "sys"."municipio" FROM stdin USING DELIMITERS '\t','\n','"';
1200013	"ACRELANDIA"	12	-67.0523165800206	-10.0737938924635	1202	'Vale do Acre'	12004	'Rio Branco'
1200054	"ASSIS BRASIL"	12	-69.5634591746677	-10.9428656809172	1202	'Vale do Acre'	12005	'Brasiléia'
1200104	"BRASILEIA"	12	-68.7479434259584	-11.0164110190858	1202	'Vale do Acre'	12005	'Brasiléia'
1200138	"BUJARI"	12	-67.9518592792015	-9.82001962670938	1202	'Vale do Acre'	12004	'Rio Branco'
1200179	"CAPIXABA"	12	-67.6735079719432	-10.5697677087928	1202	'Vale do Acre'	12004	'Rio Branco'
1200203	"CRUZEIRO DO SUL"	12	-72.6725313174358	-7.63069000500981	1201	'Vale do Juruá'	12001	'Cruzeiro do Sul'
1200252	"EPITACIOLANDIA"	12	-68.7448680666749	-11.0282398279564	1202	'Vale do Acre'	12005	'Brasiléia'
1200302	"FEIJO"	12	-70.3539836082165	-8.16024753	1201	'Vale do Juruá'	12002	'Tarauacá'
1200328	"JORDAO"	12	-71.9508751248365	-9.19335785982848	1201	'Vale do Juruá'	12002	'Tarauacá'
1200336	"MANCIO LIMA"	12	-72.9165010261308	-7.59322259385836	1201	'Vale do Juruá'	12001	'Cruzeiro do Sul'
1200344	"MANOEL URBANO"	12	-69.2599445775075	-8.83631773689166	1202	'Vale do Acre'	12003	'Sena Madureira'
1200351	"MARECHAL THAUMATURGO"	12	-72.7902659086983	-8.95359112315366	1201	'Vale do Juruá'	12001	'Cruzeiro do Sul'
1200385	"PLACIDO DE CASTRO"	12	-67.1882600861516	-10.3351332827427	1202	'Vale do Acre'	12004	'Rio Branco'
1200807	"PORTO ACRE"	12	-67.5405900835194	-9.60085823118788	1202	'Vale do Acre'	12004	'Rio Branco'
1200393	"PORTO WALTER"	12	-72.7423339648033	-8.26666636282753	1201	'Vale do Juruá'	12001	'Cruzeiro do Sul'
1200401	"RIO BRANCO"	12	-67.8105287004235	-9.97829875272498	1202	'Vale do Acre'	12004	'Rio Branco'
1200427	"RODRIGUES ALVES"	12	-72.6478549141997	-7.73360203372322	1201	'Vale do Juruá'	12001	'Cruzeiro do Sul'
1200435	"SANTA ROSA DO PURUS"	12	-70.4864968937616	-9.44340653741185	1202	'Vale do Acre'	12003	'Sena Madureira'
1200500	"SENA MADUREIRA"	12	-68.655684061692	-9.065339505	1202	'Vale do Acre'	12003	'Sena Madureira'
1200450	"SENADOR GUIOMARD"	12	-67.7431723600051	-10.1481735861989	1202	'Vale do Acre'	12004	'Rio Branco'
1200609	"TARAUACA"	12	-70.7555010628937	-8.15566859176562	1201	'Vale do Juruá'	12002	'Tarauacá'
1200708	"XAPURI"	12	-68.5062948050463	-10.6520719403355	1202	'Vale do Acre'	12005	'Brasiléia'
2700102	"AGUA BRANCA"	27	-37.940715175965	-9.26702549705051	2701	'Sertão Alagoano'	27001	'Serrana do Sertão Alagoano'
2700201	"ANADIA"	27	-36.3008135714461	-9.68408378505047	2703	'Leste Alagoano'	27012	'São Miguel dos Campos'
2700300	"ARAPIRACA"	27	-36.6572965062872	-9.7559070107047	2702	'Agreste Alagoano'	27006	'Arapiraca'
2700409	"ATALAIA"	27	-36.0214273162625	-9.50138674650017	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2700508	"BARRA DE SANTO ANTONIO"	27	-35.5002980957816	-9.40927810936494	2703	'Leste Alagoano'	27011	'Maceió'
2700607	"BARRA DE SAO MIGUEL"	27	-35.9074498726289	-9.83899825174925	2703	'Leste Alagoano'	27011	'Maceió'
2700706	"BATALHA"	27	-37.1270918944836	-9.67459302797037	2701	'Sertão Alagoano'	27004	'Batalha'
2700805	"BELEM"	27	-36.4944979894058	-9.56864823133606	2702	'Agreste Alagoano'	27005	'Palmeira dos Índios'
2700904	"BELO MONTE"	27	-37.2784386581653	-9.82698885476657	2701	'Sertão Alagoano'	27004	'Batalha'
2701001	"BOCA DA MATA"	27	-36.2117249001431	-9.64514456727259	2703	'Leste Alagoano'	27012	'São Miguel dos Campos'
2701100	"BRANQUINHA"	27	-36.0200335331731	-9.24658310830329	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2701209	"CACIMBINHAS"	27	-36.9968696260236	-9.40516275105815	2702	'Agreste Alagoano'	27005	'Palmeira dos Índios'
2701308	"CAJUEIRO"	27	-36.1563785914086	-9.38966057508941	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2701357	"CAMPESTRE"	27	-35.5667177264544	-8.84837535315291	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2701407	"CAMPO ALEGRE"	27	-36.352434752197	-9.78341603898408	2703	'Leste Alagoano'	27012	'São Miguel dos Campos'
2701506	"CAMPO GRANDE"	27	-36.7908400521347	-9.95692260332019	2702	'Agreste Alagoano'	27006	'Arapiraca'
2701605	"CANAPI"	27	-37.6056471506351	-9.11738029758643	2701	'Sertão Alagoano'	27001	'Serrana do Sertão Alagoano'
2701704	"CAPELA"	27	-36.0750084923936	-9.4129315555221	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2701803	"CARNEIROS"	27	-37.3747504206165	-9.48067972087814	2701	'Sertão Alagoano'	27003	'Santana do Ipanema'
2701902	"CHA PRETA"	27	-36.2993814518778	-9.26142245940566	2703	'Leste Alagoano'	27008	'Serrana dos Quilombos'
2702009	"COITE DO NOIA"	27	-36.5796842002285	-9.63848727077993	2702	'Agreste Alagoano'	27006	'Arapiraca'
2702108	"COLONIA LEOPOLDINA"	27	-35.7197808593936	-8.91268826995015	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2702207	"COQUEIRO SECO"	27	-35.795363001733	-9.63755427096993	2703	'Leste Alagoano'	27011	'Maceió'
2702306	"CORURIPE"	27	-36.1760783105118	-10.1265472503749	2703	'Leste Alagoano'	27012	'São Miguel dos Campos'
2702355	"CRAIBAS"	27	-36.7723914019128	-9.61993379738632	2702	'Agreste Alagoano'	27006	'Arapiraca'
2702405	"DELMIRO GOUVEIA"	27	-37.9992334861769	-9.38457444694075	2701	'Sertão Alagoano'	27002	'Alagoana do Sertão do São Francisco'
2702504	"DOIS RIACHOS"	27	-37.0898496479493	-9.38567081154627	2701	'Sertão Alagoano'	27003	'Santana do Ipanema'
2702553	"ESTRELA DE ALAGOAS"	27	-36.7583331109668	-9.38740530657934	2702	'Agreste Alagoano'	27005	'Palmeira dos Índios'
2702603	"FEIRA GRANDE"	27	-36.6776855005338	-9.90043719889157	2702	'Agreste Alagoano'	27006	'Arapiraca'
2702702	"FELIZ DESERTO"	27	-36.3071875176995	-10.2923806198663	2703	'Leste Alagoano'	27013	'Penedo'
2702801	"FLEXEIRAS"	27	-35.7243716385672	-9.27323546004541	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2702900	"GIRAU DO PONCIANO"	27	-36.8303139029901	-9.8873641521582	2702	'Agreste Alagoano'	27006	'Arapiraca'
2703007	"IBATEGUARA"	27	-35.9311844564205	-8.97698521760536	2703	'Leste Alagoano'	27008	'Serrana dos Quilombos'
2703106	"IGACI"	27	-36.62815971645	-9.53368865946465	2702	'Agreste Alagoano'	27005	'Palmeira dos Índios'
2703205	"IGREJA NOVA"	27	-36.653345012518	-10.1292988371728	2703	'Leste Alagoano'	27013	'Penedo'
2703304	"INHAPI"	27	-37.7526365210459	-9.22389877333184	2701	'Sertão Alagoano'	27001	'Serrana do Sertão Alagoano'
2703403	"JACARE DOS HOMENS"	27	-37.2078334090177	-9.63665882831559	2701	'Sertão Alagoano'	27004	'Batalha'
2703502	"JACUIPE"	27	-35.4609975081236	-8.84030050756405	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2703601	"JAPARATINGA"	27	-35.2586583540313	-9.08897435434458	2703	'Leste Alagoano'	27010	'Litoral Norte Alagoano'
2703700	"JARAMATAIA"	27	-37.0035959132308	-9.65835193876392	2701	'Sertão Alagoano'	27004	'Batalha'
2703759	"JEQUIA DA PRAIA"	27	-36.0273340429838	-10.0095918935695	2703	'Leste Alagoano'	27012	'São Miguel dos Campos'
2703809	"JOAQUIM GOMES"	27	-35.749030258912	-9.13597914629409	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2703908	"JUNDIA"	27	-35.5555972975355	-8.93887675416228	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2704005	"JUNQUEIRO"	27	-36.4715218222232	-9.93161038974245	2703	'Leste Alagoano'	27012	'São Miguel dos Campos'
2704104	"LAGOA DA CANOA"	27	-36.7357892600018	-9.83087565650446	2702	'Agreste Alagoano'	27006	'Arapiraca'
2704203	"LIMOEIRO DE ANADIA"	27	-36.5038970865	-9.73861316781449	2702	'Agreste Alagoano'	27006	'Arapiraca'
2704302	"MACEIO"	27	-35.7016299134895	-9.66082215163114	2703	'Leste Alagoano'	27011	'Maceió'
2704401	"MAJOR ISIDORO"	27	-36.9847996142241	-9.52664406793994	2701	'Sertão Alagoano'	27004	'Batalha'
2704906	"MAR VERMELHO"	27	-36.3850400240272	-9.44777264348944	2702	'Agreste Alagoano'	27005	'Palmeira dos Índios'
2704500	"MARAGOGI"	27	-35.2230154091319	-9.0154564858241	2703	'Leste Alagoano'	27010	'Litoral Norte Alagoano'
2704609	"MARAVILHA"	27	-37.3566354220481	-9.23399706335314	2701	'Sertão Alagoano'	27003	'Santana do Ipanema'
2704708	"MARECHAL DEODORO"	27	-35.8930686988453	-9.73915570244381	2703	'Leste Alagoano'	27011	'Maceió'
2704807	"MARIBONDO"	27	-36.3066028985381	-9.57724995600836	2702	'Agreste Alagoano'	27005	'Palmeira dos Índios'
2705002	"MATA GRANDE"	27	-37.7252240648916	-9.11480625764182	2701	'Sertão Alagoano'	27001	'Serrana do Sertão Alagoano'
2705101	"MATRIZ DE CAMARAGIBE"	27	-35.533554829803	-9.15852582474625	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2705200	"MESSIAS"	27	-35.840378300501	-9.39181222510958	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2705309	"MINADOR DO NEGRAO"	27	-36.864915772472	-9.30368326063751	2702	'Agreste Alagoano'	27005	'Palmeira dos Índios'
2705408	"MONTEIROPOLIS"	27	-37.2452720989471	-9.60232753886744	2701	'Sertão Alagoano'	27004	'Batalha'
2705507	"MURICI"	27	-35.947555585677	-9.31630114434686	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2705606	"NOVO LINO"	27	-35.6609637180966	-8.94315880807644	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2705705	"OLHO D'AGUA DAS FLORES"	27	-37.2978907897967	-9.53360127527465	2701	'Sertão Alagoano'	27004	'Batalha'
2705804	"OLHO D'AGUA DO CASADO"	27	-37.8362428164813	-9.50144626528801	2701	'Sertão Alagoano'	27002	'Alagoana do Sertão do São Francisco'
2705903	"OLHO D'AGUA GRANDE"	27	-36.8067459676714	-10.0584949600009	2702	'Agreste Alagoano'	27007	'Traipu'
2706000	"OLIVENCA"	27	-37.1908187180627	-9.51945648335504	2701	'Sertão Alagoano'	27004	'Batalha'
2706109	"OURO BRANCO"	27	-37.3544437290231	-9.163415364026	2701	'Sertão Alagoano'	27003	'Santana do Ipanema'
2706208	"PALESTINA"	27	-37.3311364505041	-9.67309718564914	2701	'Sertão Alagoano'	27003	'Santana do Ipanema'
2706307	"PALMEIRA DOS INDIOS"	27	-36.6309840973114	-9.4061587984201	2702	'Agreste Alagoano'	27005	'Palmeira dos Índios'
2706406	"PAO DE ACUCAR"	27	-37.435138856573	-9.74704185025694	2701	'Sertão Alagoano'	27003	'Santana do Ipanema'
2706422	"PARICONHA"	27	-38.0098260716315	-9.25788438518493	2701	'Sertão Alagoano'	27001	'Serrana do Sertão Alagoano'
2706448	"PARIPUEIRA"	27	-35.5591051843043	-9.46631347833536	2703	'Leste Alagoano'	27011	'Maceió'
2706505	"PASSO DE CAMARAGIBE"	27	-35.4912752632186	-9.24484665799731	2703	'Leste Alagoano'	27010	'Litoral Norte Alagoano'
2706604	"PAULO JACINTO"	27	-36.3727420945597	-9.3733643824119	2702	'Agreste Alagoano'	27005	'Palmeira dos Índios'
2706703	"PENEDO"	27	-36.5804602140903	-10.2961102979024	2703	'Leste Alagoano'	27013	'Penedo'
2706802	"PIACABUCU"	27	-36.4343520081112	-10.4073624263407	2703	'Leste Alagoano'	27013	'Penedo'
2706901	"PILAR"	27	-35.9485175199678	-9.60689429266684	2703	'Leste Alagoano'	27011	'Maceió'
2707008	"PINDOBA"	27	-36.2865406443458	-9.47621079980144	2703	'Leste Alagoano'	27008	'Serrana dos Quilombos'
2707107	"PIRANHAS"	27	-37.7503929130592	-9.62355920030328	2701	'Sertão Alagoano'	27002	'Alagoana do Sertão do São Francisco'
2707206	"POCO DAS TRINCHEIRAS"	27	-37.2792980528473	-9.30291365540457	2701	'Sertão Alagoano'	27003	'Santana do Ipanema'
2707305	"PORTO CALVO"	27	-35.3983344556037	-9.05244831413658	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2707404	"PORTO DE PEDRAS"	27	-35.2970152177328	-9.15608616311578	2703	'Leste Alagoano'	27010	'Litoral Norte Alagoano'
2707503	"PORTO REAL DO COLEGIO"	27	-36.8246292915239	-10.1737325641911	2703	'Leste Alagoano'	27013	'Penedo'
2707602	"QUEBRANGULO"	27	-36.4772220766618	-9.32354705536581	2702	'Agreste Alagoano'	27005	'Palmeira dos Índios'
2707701	"RIO LARGO"	27	-35.8524223085924	-9.48615760833584	2703	'Leste Alagoano'	27011	'Maceió'
2707800	"ROTEIRO"	27	-35.9812102213933	-9.83218949018835	2703	'Leste Alagoano'	27012	'São Miguel dos Campos'
2707909	"SANTA LUZIA DO NORTE"	27	-35.8234877698639	-9.59676774166949	2703	'Leste Alagoano'	27011	'Maceió'
2708006	"SANTANA DO IPANEMA"	27	-37.2454070203705	-9.3722843627404	2701	'Sertão Alagoano'	27003	'Santana do Ipanema'
2708105	"SANTANA DO MUNDAU"	27	-36.2252341170425	-9.16503322076224	2703	'Leste Alagoano'	27008	'Serrana dos Quilombos'
2708204	"SAO BRAS"	27	-36.8989486552451	-10.1203099965729	2702	'Agreste Alagoano'	27007	'Traipu'
2708303	"SAO JOSE DA LAJE"	27	-36.0573877321467	-9.01106588188022	2703	'Leste Alagoano'	27008	'Serrana dos Quilombos'
2708402	"SAO JOSE DA TAPERA"	27	-37.3837077656992	-9.54939574043675	2701	'Sertão Alagoano'	27003	'Santana do Ipanema'
2708501	"SAO LUIS DO QUITUNDE"	27	-35.5654908365835	-9.31411736924134	2703	'Leste Alagoano'	27009	'Mata Alagoana'
2708600	"SAO MIGUEL DOS CAMPOS"	27	-36.0942642743776	-9.77993457613103	2703	'Leste Alagoano'	27012	'São Miguel dos Campos'
2708709	"SAO MIGUEL DOS MILAGRES"	27	-35.3691193336324	-9.26718629500207	2703	'Leste Alagoano'	27010	'Litoral Norte Alagoano'
2708808	"SAO SEBASTIAO"	27	-36.5510919020052	-9.93165738892367	2702	'Agreste Alagoano'	27006	'Arapiraca'
2708907	"SATUBA"	27	-35.8285402270771	-9.56942786775773	2703	'Leste Alagoano'	27011	'Maceió'
2708956	"SENADOR RUI PALMEIRA"	27	-37.4536462478126	-9.46339144898312	2701	'Sertão Alagoano'	27003	'Santana do Ipanema'
2709004	"TANQUE D'ARCA"	27	-36.4367415959431	-9.53196244231297	2702	'Agreste Alagoano'	27005	'Palmeira dos Índios'
2709103	"TAQUARANA"	27	-36.4967676919618	-9.64232010538379	2702	'Agreste Alagoano'	27006	'Arapiraca'
2709152	"TEOTONIO VILELA"	27	-36.3555631422205	-9.90749788301098	2703	'Leste Alagoano'	27012	'São Miguel dos Campos'
2709202	"TRAIPU"	27	-37.0060056722452	-9.97105938200651	2702	'Agreste Alagoano'	27007	'Traipu'
2709301	"UNIAO DOS PALMARES"	27	-36.0331428428074	-9.159524116522	2703	'Leste Alagoano'	27008	'Serrana dos Quilombos'
2709400	"VICOSA"	27	-36.2483932029197	-9.37705435448976	2703	'Leste Alagoano'	27008	'Serrana dos Quilombos'
1300029	"ALVARAES"	13	-64.8135346775686	-3.21658376906639	1303	'Centro Amazonense'	13005	'Tefé'
1300060	"AMATURA"	13	-68.2096146409404	-3.36680518750561	1302	'Sudoeste Amazonense'	13003	'Alto Solimões'
1300086	"ANAMA"	13	-61.4059034797501	-3.57637042689027	1303	'Centro Amazonense'	13006	'Coari'
1300102	"ANORI"	13	-61.6589553828779	-3.74538558611889	1303	'Centro Amazonense'	13006	'Coari'
1300144	"APUI"	13	-59.8856661047188	-7.1978701516076	1304	'Sul Amazonense'	13013	'Madeira'
1300201	"ATALAIA DO NORTE"	13	-70.1879892845226	-4.36615748971603	1302	'Sudoeste Amazonense'	13003	'Alto Solimões'
1300300	"AUTAZES"	13	-59.1335670918168	-3.57866364177127	1303	'Centro Amazonense'	13007	'Manaus'
1300409	"BARCELOS"	13	-62.9256696581026	-0.972801052532191	1301	'Norte Amazonense'	13001	'Rio Negro'
1300508	"BARREIRINHA"	13	-57.0677504898938	-2.7981498369298	1303	'Centro Amazonense'	13010	'Parintins'
1300607	"BENJAMIN CONSTANT"	13	-70.0273484332765	-4.37498901860391	1302	'Sudoeste Amazonense'	13003	'Alto Solimões'
1300631	"BERURI"	13	-61.3715708916659	-3.89451340981806	1303	'Centro Amazonense'	13006	'Coari'
1300680	"BOA VISTA DO RAMOS"	13	-57.5877073464737	-2.97172653158936	1303	'Centro Amazonense'	13010	'Parintins'
1300706	"BOCA DO ACRE"	13	-67.3995777566805	-8.75124319609379	1304	'Sul Amazonense'	13011	'Boca do Acre'
1300805	"BORBA"	13	-59.5945590194969	-4.39061989147273	1304	'Sul Amazonense'	13013	'Madeira'
1300839	"CAAPIRANGA"	13	-61.2113341331817	-3.3300933919416	1303	'Centro Amazonense'	13006	'Coari'
1300904	"CANUTAMA"	13	-64.3942308189288	-6.52910607582614	1304	'Sul Amazonense'	13012	'Purus'
1301001	"CARAUARI"	13	-66.8966352816837	-4.88166590420413	1302	'Sudoeste Amazonense'	13004	'Juruá'
1301100	"CAREIRO"	13	-60.3638098437089	-3.82244727004599	1303	'Centro Amazonense'	13007	'Manaus'
1301159	"CAREIRO DA VARZEA"	13	-59.8263140608339	-3.1973965948696	1303	'Centro Amazonense'	13007	'Manaus'
1301209	"COARI"	13	-63.1421839840562	-4.08421915877588	1303	'Centro Amazonense'	13006	'Coari'
1301308	"CODAJAS"	13	-62.0634296604883	-3.84304593273892	1303	'Centro Amazonense'	13006	'Coari'
1301407	"EIRUNEPE"	13	-69.8662902624416	-6.66735256685182	1302	'Sudoeste Amazonense'	13004	'Juruá'
1301506	"ENVIRA"	13	-70.0304125429825	-7.43981754396838	1302	'Sudoeste Amazonense'	13004	'Juruá'
1301605	"FONTE BOA"	13	-66.0965029898347	-2.51227068454779	1302	'Sudoeste Amazonense'	13003	'Alto Solimões'
1301654	"GUAJARA"	13	-72.5824305383396	-7.5477744148336	1302	'Sudoeste Amazonense'	13004	'Juruá'
1301704	"HUMAITA"	13	-63.0266980219283	-7.51222495061139	1304	'Sul Amazonense'	13013	'Madeira'
1301803	"IPIXUNA"	13	-71.6944180603084	-7.05098011443721	1302	'Sudoeste Amazonense'	13004	'Juruá'
1301852	"IRANDUBA"	13	-60.1933881661307	-3.2810538776069	1303	'Centro Amazonense'	13007	'Manaus'
1301902	"ITACOATIARA"	13	-58.4401754367571	-3.14037880391635	1303	'Centro Amazonense'	13009	'Itacoatiara'
1301951	"ITAMARATI"	13	-68.2479174359782	-6.43779934861918	1302	'Sudoeste Amazonense'	13004	'Juruá'
1302009	"ITAPIRANGA"	13	-58.0345458839662	-2.74184275232884	1303	'Centro Amazonense'	13009	'Itacoatiara'
1302108	"JAPURA"	13	-66.9969034946413	-1.880844858703	1301	'Norte Amazonense'	13002	'Japurá'
1302207	"JURUA"	13	-66.0630419255434	-3.47488959889068	1302	'Sudoeste Amazonense'	13004	'Juruá'
1302306	"JUTAI"	13	-66.7713275466878	-2.74464644685786	1302	'Sudoeste Amazonense'	13003	'Alto Solimões'
1302405	"LABREA"	13	-64.79477302752	-7.26194655332705	1304	'Sul Amazonense'	13012	'Purus'
1302504	"MANACAPURU"	13	-60.6205894458706	-3.29827803546755	1303	'Centro Amazonense'	13007	'Manaus'
1302553	"MANAQUIRI"	13	-60.4588813063745	-3.42907966935262	1303	'Centro Amazonense'	13007	'Manaus'
1302603	"MANAUS"	13	-60.023335181061	-3.13469149120195	1303	'Centro Amazonense'	13007	'Manaus'
1302702	"MANICORE"	13	-61.2992484088508	-5.81320526118813	1304	'Sul Amazonense'	13013	'Madeira'
1302801	"MARAA"	13	-65.5742837031641	-1.86643687730125	1301	'Norte Amazonense'	13002	'Japurá'
1302900	"MAUES"	13	-57.7150343867525	-3.38642792621106	1303	'Centro Amazonense'	13010	'Parintins'
1303007	"NHAMUNDA"	13	-56.7167699133376	-2.1889837668969	1303	'Centro Amazonense'	13010	'Parintins'
1303106	"NOVA OLINDA DO NORTE"	13	-59.0930740260433	-3.88759283191138	1303	'Centro Amazonense'	13009	'Itacoatiara'
1303205	"NOVO AIRAO"	13	-60.948810707829	-2.62343245902763	1301	'Norte Amazonense'	13001	'Rio Negro'
1303304	"NOVO ARIPUANA"	13	-60.3770456690009	-5.12266931419617	1304	'Sul Amazonense'	13013	'Madeira'
1303403	"PARINTINS"	13	-56.7362921451951	-2.62705258583723	1303	'Centro Amazonense'	13010	'Parintins'
1303502	"PAUINI"	13	-67.0020974885282	-7.71404364432219	1304	'Sul Amazonense'	13011	'Boca do Acre'
1303536	"PRESIDENTE FIGUEIREDO"	13	-60.0256468344675	-2.058429085233	1303	'Centro Amazonense'	13008	'Rio Preto da Eva'
1303569	"RIO PRETO DA EVA"	13	-59.704738094199	-2.6933015416451	1303	'Centro Amazonense'	13008	'Rio Preto da Eva'
1303601	"SANTA ISABEL DO RIO NEGRO"	13	-65.020022639512	-0.416694831881864	1301	'Norte Amazonense'	13001	'Rio Negro'
1303700	"SANTO ANTONIO DO ICA"	13	-67.9464851438841	-3.10748630918151	1302	'Sudoeste Amazonense'	13003	'Alto Solimões'
1303809	"SAO GABRIEL DA CACHOEIRA"	13	-67.0836428963463	-0.136462788116522	1301	'Norte Amazonense'	13001	'Rio Negro'
1303908	"SAO PAULO DE OLIVENCA"	13	-68.9448534881358	-3.46650962349132	1302	'Sudoeste Amazonense'	13003	'Alto Solimões'
1303957	"SAO SEBASTIAO DO UATUMA"	13	-57.8703463558346	-2.57015257967785	1303	'Centro Amazonense'	13010	'Parintins'
1304005	"SILVES"	13	-58.2148008608269	-2.83642742966584	1303	'Centro Amazonense'	13009	'Itacoatiara'
1304062	"TABATINGA"	13	-69.9462443752272	-4.23188367564665	1302	'Sudoeste Amazonense'	13003	'Alto Solimões'
1304104	"TAPAUA"	13	-63.1870948671802	-5.62422351778794	1304	'Sul Amazonense'	13012	'Purus'
1304203	"TEFE"	13	-64.7084196633027	-3.34837249394151	1303	'Centro Amazonense'	13005	'Tefé'
1304237	"TONANTINS"	13	-67.7764822806952	-2.86109124983543	1302	'Sudoeste Amazonense'	13003	'Alto Solimões'
1304260	"UARINI"	13	-65.1553456401554	-2.9836092426921	1303	'Centro Amazonense'	13005	'Tefé'
1304302	"URUCARA"	13	-57.7598281745956	-2.53661167184038	1303	'Centro Amazonense'	13010	'Parintins'
1304401	"URUCURITUBA"	13	-58.1596410413098	-3.1346331156473	1303	'Centro Amazonense'	13009	'Itacoatiara'
1600105	"AMAPA"	16	-50.7932144702699	2.05392124468205	1601	'Norte do Amapá'	16002	'Amapá'
1600204	"CALCOENE"	16	-50.9447727342665	2.49655904456698	1601	'Norte do Amapá'	16001	'Oiapoque'
1600212	"CUTIAS"	16	-50.8016260298776	0.97107805541715	1602	'Sul do Amapá'	16003	'Macapá'
1600238	"FERREIRA GOMES"	16	-51.1874290460046	0.853977393142956	1602	'Sul do Amapá'	16003	'Macapá'
1600253	"ITAUBAL"	16	-50.7001794374183	0.600653288304609	1602	'Sul do Amapá'	16003	'Macapá'
1600279	"LARANJAL DO JARI"	16	-52.5390207369393	-0.8556645	1602	'Sul do Amapá'	16004	'Mazagão'
1600303	"MACAPA"	16	-51.057405457036	0.03895101	1602	'Sul do Amapá'	16003	'Macapá'
1600402	"MAZAGAO"	16	-51.2860768561013	-0.124396328821101	1602	'Sul do Amapá'	16004	'Mazagão'
1600501	"OIAPOQUE"	16	-51.8305525552731	3.85113073255929	1601	'Norte do Amapá'	16001	'Oiapoque'
1600154	"PEDRA BRANCA DO AMAPARI"	16	-51.9465942732743	0.776882860563944	1602	'Sul do Amapá'	16003	'Macapá'
1600535	"PORTO GRANDE"	16	-51.4144488229915	0.712554701824323	1602	'Sul do Amapá'	16003	'Macapá'
1600550	"PRACUUBA"	16	-50.7842537212883	1.74250848707834	1601	'Norte do Amapá'	16002	'Amapá'
1600600	"SANTANA"	16	-51.1728464650687	-0.0383734790956602	1602	'Sul do Amapá'	16003	'Macapá'
1600055	"SERRA DO NAVIO"	16	-52.0035384352918	0.897841040971924	1602	'Sul do Amapá'	16003	'Macapá'
1600709	"TARTARUGALZINHO"	16	-50.9127861523142	1.50984824031107	1601	'Norte do Amapá'	16002	'Amapá'
1600808	"VITORIA DO JARI"	16	-52.4196147795719	-0.918977088542798	1602	'Sul do Amapá'	16004	'Mazagão'
2900108	"ABAIRA"	29	-41.661608480236	-13.2535318932762	2906	'Centro Sul Baiano'	29023	'Seabra'
2900207	"ABARE"	29	-39.1165879396428	-8.72341824568634	2902	'Vale São-Franciscano da Bahia'	29005	'Paulo Afonso'
2900306	"ACAJUTIBA"	29	-38.0182863705796	-11.6626128300483	2904	'Nordeste Baiano'	29017	'Alagoinhas'
2900355	"ADUSTINA"	29	-38.1155058347825	-10.5295715700202	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2900405	"AGUA FRIA"	29	-38.7680777950043	-11.8729309975791	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2900603	"AIQUARA"	29	-39.8857780091229	-14.1272774885543	2906	'Centro Sul Baiano'	29024	'Jequié'
2900702	"ALAGOINHAS"	29	-38.4226157693395	-12.1341825924055	2904	'Nordeste Baiano'	29017	'Alagoinhas'
2900801	"ALCOBACA"	29	-39.1942143206578	-17.5189333438062	2907	'Sul Baiano'	29032	'Porto Seguro'
2900900	"ALMADINA"	29	-39.6359031752447	-14.7060477475217	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2901007	"AMARGOSA"	29	-39.5981225034895	-13.0344513621971	2906	'Centro Sul Baiano'	29024	'Jequié'
2901106	"AMELIA RODRIGUES"	29	-38.7555569164417	-12.4001884013071	2905	'Metropolitana de Salvador'	29019	'Catu'
2901155	"AMERICA DOURADA"	29	-41.4371632791237	-11.4496458647759	2903	'Centro Norte Baiano'	29009	'Irecê'
2901205	"ANAGE"	29	-41.1271131685047	-14.6113255924937	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2901304	"ANDARAI"	29	-41.3246418039988	-12.8013506460241	2906	'Centro Sul Baiano'	29023	'Seabra'
2901353	"ANDORINHA"	29	-39.8323357010101	-10.3442400415346	2903	'Centro Norte Baiano'	29008	'Senhor do Bonfim'
2901403	"ANGICAL"	29	-44.6958234827073	-12.0066827725325	2901	'Extremo Oeste Baiano'	29002	'Cotegipe'
2901502	"ANGUERA"	29	-39.2484989182822	-12.1495870700754	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2901601	"ANTAS"	29	-38.3310416783347	-10.4127021692653	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2901700	"ANTONIO CARDOSO"	29	-39.1186615354614	-12.4348389094768	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2901809	"ANTONIO GONCALVES"	29	-40.2756586985804	-10.5757977912944	2903	'Centro Norte Baiano'	29008	'Senhor do Bonfim'
2901908	"APORA"	29	-38.0799953494517	-11.6553942918973	2904	'Nordeste Baiano'	29017	'Alagoinhas'
2901957	"APUAREMA"	29	-39.7421321165047	-13.853228848819	2906	'Centro Sul Baiano'	29024	'Jequié'
2902054	"ARACAS"	29	-38.1982880171949	-12.2151996675491	2904	'Nordeste Baiano'	29017	'Alagoinhas'
2902005	"ARACATU"	29	-41.4616853206574	-14.4266302419957	2906	'Centro Sul Baiano'	29027	'Brumado'
2902104	"ARACI"	29	-38.9609581594029	-11.3357278753123	2904	'Nordeste Baiano'	29016	'Serrinha'
2902203	"ARAMARI"	29	-38.5030663542087	-12.0881829783087	2904	'Nordeste Baiano'	29017	'Alagoinhas'
2902252	"ARATACA"	29	-39.4132815657126	-15.260872997351	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2902302	"ARATUIPE"	29	-39.0029108659812	-13.0805965410127	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2902401	"AURELINO LEAL"	29	-39.3219966377058	-14.3169494479569	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2902500	"BAIANOPOLIS"	29	-44.5360980467187	-12.3041247007939	2901	'Extremo Oeste Baiano'	29001	'Barreiras'
2902609	"BAIXA GRANDE"	29	-40.1668609095132	-11.9593574889724	2903	'Centro Norte Baiano'	29011	'Itaberaba'
2902658	"BANZAE"	29	-38.6118696305729	-10.5740919358198	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2902708	"BARRA"	29	-43.1436385524586	-11.0889548205462	2902	'Vale São-Franciscano da Bahia'	29006	'Barra'
2902807	"BARRA DA ESTIVA"	29	-41.3316958704896	-13.6202045630406	2906	'Centro Sul Baiano'	29023	'Seabra'
2902906	"BARRA DO CHOCA"	29	-40.5763729895987	-14.864273042783	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2903003	"BARRA DO MENDES"	29	-42.0591284156826	-11.8088282812611	2903	'Centro Norte Baiano'	29009	'Irecê'
2903102	"BARRA DO ROCHA"	29	-39.601386089866	-14.210029248501	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2903201	"BARREIRAS"	29	-45.0041684370285	-12.1449248883906	2901	'Extremo Oeste Baiano'	29001	'Barreiras'
2903235	"BARRO ALTO"	29	-41.9120960647526	-11.7610639229593	2903	'Centro Norte Baiano'	29009	'Irecê'
2903300	"BARRO PRETO"	29	-39.4733346713801	-14.8097543871027	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2903276	"BARROCAS"	29	-39.0786688809182	-11.5291128520783	2904	'Nordeste Baiano'	29016	'Serrinha'
2903409	"BELMONTE"	29	-38.8803032385601	-15.8613964917869	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2903508	"BELO CAMPO"	29	-41.2600334790203	-15.0334961972012	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2903607	"BIRITINGA"	29	-38.8121589228975	-11.6201102629816	2904	'Nordeste Baiano'	29016	'Serrinha'
2903706	"BOA NOVA"	29	-40.2005218938254	-14.3626079430408	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2903805	"BOA VISTA DO TUPIM"	29	-40.6057428240473	-12.6613221925482	2903	'Centro Norte Baiano'	29011	'Itaberaba'
2903904	"BOM JESUS DA LAPA"	29	-43.417141642139	-13.2541143730901	2902	'Vale São-Franciscano da Bahia'	29007	'Bom Jesus da Lapa'
2903953	"BOM JESUS DA SERRA"	29	-40.501176329753	-14.3729222943841	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2904001	"BONINAL"	29	-41.8243284848072	-12.7151207923139	2906	'Centro Sul Baiano'	29023	'Seabra'
2904050	"BONITO"	29	-41.2684027881505	-11.9695725020911	2906	'Centro Sul Baiano'	29023	'Seabra'
2904100	"BOQUIRA"	29	-42.7301154012176	-12.8208228300175	2906	'Centro Sul Baiano'	29022	'Boquira'
2904209	"BOTUPORA"	29	-42.5292775589668	-13.3808662136783	2906	'Centro Sul Baiano'	29022	'Boquira'
2904308	"BREJOES"	29	-39.7934915926573	-13.105536483186	2906	'Centro Sul Baiano'	29024	'Jequié'
2904407	"BREJOLANDIA"	29	-43.9656645942921	-12.486693342119	2901	'Extremo Oeste Baiano'	29002	'Cotegipe'
2904506	"BROTAS DE MACAUBAS"	29	-42.6246912893431	-12.0026355373041	2906	'Centro Sul Baiano'	29022	'Boquira'
2904605	"BRUMADO"	29	-41.6670695036664	-14.2054382406597	2906	'Centro Sul Baiano'	29027	'Brumado'
2904704	"BUERAREMA"	29	-39.3025196057871	-14.9564408366046	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2904753	"BURITIRAMA"	29	-43.6313808982398	-10.7117914663194	2902	'Vale São-Franciscano da Bahia'	29006	'Barra'
2904803	"CAATIBA"	29	-40.4102724753438	-14.9785506351839	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2904852	"CABACEIRAS DO PARAGUACU"	29	-39.1867130922404	-12.5371357853541	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2904902	"CACHOEIRA"	29	-38.9693980689823	-12.5962107984627	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2905008	"CACULE"	29	-42.2214140996087	-14.5042061971359	2906	'Centro Sul Baiano'	29026	'Guanambi'
2905107	"CAEM"	29	-40.4373119407154	-11.0930915174846	2903	'Centro Norte Baiano'	29010	'Jacobina'
2905156	"CAETANOS"	29	-40.9092896392257	-14.3385629673677	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2905206	"CAETITE"	29	-42.4857114474597	-14.0667543191246	2906	'Centro Sul Baiano'	29026	'Guanambi'
2905305	"CAFARNAUM"	29	-41.4722215133285	-11.6913562190577	2903	'Centro Norte Baiano'	29009	'Irecê'
2905404	"CAIRU"	29	-39.0432543550852	-13.4876034013497	2907	'Sul Baiano'	29030	'Valença'
2905503	"CALDEIRAO GRANDE"	29	-40.307370359496	-11.0221557768896	2903	'Centro Norte Baiano'	29010	'Jacobina'
2905602	"CAMACAN"	29	-39.4963673314917	-15.417626851831	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2905701	"CAMACARI"	29	-38.3257400620652	-12.69881676	2905	'Metropolitana de Salvador'	29021	'Salvador'
2905800	"CAMAMU"	29	-39.1005697174881	-13.9470763405896	2907	'Sul Baiano'	29030	'Valença'
2905909	"CAMPO ALEGRE DE LOURDES"	29	-43.0122984390904	-9.51715411399994	2902	'Vale São-Franciscano da Bahia'	29004	'Juazeiro'
2906006	"CAMPO FORMOSO"	29	-40.3188209870999	-10.5056615545438	2903	'Centro Norte Baiano'	29008	'Senhor do Bonfim'
2906105	"CANAPOLIS"	29	-44.2050289853753	-13.0759114976724	2901	'Extremo Oeste Baiano'	29003	'Santa Maria da Vitória'
2906204	"CANARANA"	29	-41.7654922319867	-11.6875833139667	2903	'Centro Norte Baiano'	29009	'Irecê'
2906303	"CANAVIEIRAS"	29	-38.9473758746396	-15.6797774765314	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2906402	"CANDEAL"	29	-39.1237184954764	-11.8049702300289	2904	'Nordeste Baiano'	29016	'Serrinha'
2906501	"CANDEIAS"	29	-38.5435962675254	-12.6719227052682	2905	'Metropolitana de Salvador'	29021	'Salvador'
2906600	"CANDIBA"	29	-42.8644023352399	-14.4131865031095	2906	'Centro Sul Baiano'	29026	'Guanambi'
2906709	"CANDIDO SALES"	29	-41.2411175945831	-15.5060663507903	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2906808	"CANSANCAO"	29	-39.4966050064607	-10.6667499148657	2904	'Nordeste Baiano'	29014	'Euclides da Cunha'
2906824	"CANUDOS"	29	-39.024071242689	-9.89067296094181	2904	'Nordeste Baiano'	29014	'Euclides da Cunha'
2906857	"CAPELA DO ALTO ALEGRE"	29	-39.8353553091028	-11.6700816433262	2904	'Nordeste Baiano'	29016	'Serrinha'
2906873	"CAPIM GROSSO"	29	-40.0110006117175	-11.3815744576449	2903	'Centro Norte Baiano'	29010	'Jacobina'
2906899	"CARAIBAS"	29	-41.2654313236692	-14.72206949374	2906	'Centro Sul Baiano'	29027	'Brumado'
2906907	"CARAVELAS"	29	-39.2533822213722	-17.7333705274895	2907	'Sul Baiano'	29032	'Porto Seguro'
2907004	"CARDEAL DA SILVA"	29	-37.9454765829698	-11.9407674063607	2904	'Nordeste Baiano'	29018	'Entre Rios'
2907103	"CARINHANHA"	29	-43.7617772009392	-14.3020069035503	2902	'Vale São-Franciscano da Bahia'	29007	'Bom Jesus da Lapa'
2907202	"CASA NOVA"	29	-40.9757969268709	-9.17859457408863	2902	'Vale São-Franciscano da Bahia'	29004	'Juazeiro'
2907301	"CASTRO ALVES"	29	-39.426519430322	-12.7658326369124	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2907400	"CATOLANDIA"	29	-44.8597702833594	-12.3160059384947	2901	'Extremo Oeste Baiano'	29001	'Barreiras'
2907509	"CATU"	29	-38.3762943035541	-12.3551865588507	2905	'Metropolitana de Salvador'	29019	'Catu'
2907558	"CATURAMA"	29	-42.2964066437467	-13.3282013504011	2906	'Centro Sul Baiano'	29022	'Boquira'
2907608	"CENTRAL"	29	-42.1123489751401	-11.137988582854	2903	'Centro Norte Baiano'	29009	'Irecê'
2907707	"CHORROCHO"	29	-39.1023700774151	-8.97547780401288	2902	'Vale São-Franciscano da Bahia'	29005	'Paulo Afonso'
2907806	"CICERO DANTAS"	29	-38.3834191278696	-10.5921715319251	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2907905	"CIPO"	29	-38.5171293979405	-11.1011435641446	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2908002	"COARACI"	29	-39.5523042559244	-14.6368142028023	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2908101	"COCOS"	29	-44.5456688581223	-14.1710775452171	2901	'Extremo Oeste Baiano'	29003	'Santa Maria da Vitória'
2908200	"CONCEICAO DA FEIRA"	29	-38.9997807982437	-12.503991911881	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2908309	"CONCEICAO DO ALMEIDA"	29	-39.1709464493763	-12.7780203224236	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2908408	"CONCEICAO DO COITE"	29	-39.2816841782278	-11.5618258458634	2904	'Nordeste Baiano'	29016	'Serrinha'
2908507	"CONCEICAO DO JACUIPE"	29	-38.7636737165227	-12.322946459029	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2908606	"CONDE"	29	-37.6069779820631	-11.8134317610463	2904	'Nordeste Baiano'	29018	'Entre Rios'
2908705	"CONDEUBA"	29	-41.9708095383447	-14.8904103648485	2906	'Centro Sul Baiano'	29027	'Brumado'
2908804	"CONTENDAS DO SINCORA"	29	-41.0463180639509	-13.7554968278956	2906	'Centro Sul Baiano'	29023	'Seabra'
2908903	"CORACAO DE MARIA"	29	-38.7505165473666	-12.2479210100615	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2909000	"CORDEIROS"	29	-41.9357339067348	-15.0372341089128	2906	'Centro Sul Baiano'	29027	'Brumado'
2909109	"CORIBE"	29	-44.4530364349169	-13.8278416058215	2901	'Extremo Oeste Baiano'	29003	'Santa Maria da Vitória'
2909208	"CORONEL JOAO SA"	29	-37.9329643376141	-10.279395400226	2904	'Nordeste Baiano'	29013	'Jeremoabo'
2909307	"CORRENTINA"	29	-44.641086701211	-13.3417718212105	2901	'Extremo Oeste Baiano'	29003	'Santa Maria da Vitória'
2909406	"COTEGIPE"	29	-44.2524761376623	-12.0285973836155	2901	'Extremo Oeste Baiano'	29002	'Cotegipe'
2909505	"CRAVOLANDIA"	29	-39.8127117486746	-13.3626230640403	2906	'Centro Sul Baiano'	29024	'Jequié'
2909604	"CRISOPOLIS"	29	-38.1517158173066	-11.5177899236101	2904	'Nordeste Baiano'	29017	'Alagoinhas'
2909703	"CRISTOPOLIS"	29	-44.4118418963	-12.2314508089662	2901	'Extremo Oeste Baiano'	29002	'Cotegipe'
2909802	"CRUZ DAS ALMAS"	29	-39.1007361428306	-12.6637862127757	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2909901	"CURACA"	29	-39.908081018943	-8.98903211797355	2902	'Vale São-Franciscano da Bahia'	29004	'Juazeiro'
2910008	"DARIO MEIRA"	29	-39.9024656528413	-14.4350474388235	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2910057	"DIAS D'AVILA"	29	-38.2979935898508	-12.6043684168205	2905	'Metropolitana de Salvador'	29021	'Salvador'
2910107	"DOM BASILIO"	29	-41.7708775806957	-13.7633265545771	2906	'Centro Sul Baiano'	29025	'Livramento do Brumado'
2910206	"DOM MACEDO COSTA"	29	-39.188094169582	-12.911489262313	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2910305	"ELISIO MEDRADO"	29	-39.5204855551496	-12.9433258382093	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2910404	"ENCRUZILHADA"	29	-40.9091207501114	-15.5345801802607	2906	'Centro Sul Baiano'	29029	'Itapetinga'
2910503	"ENTRE RIOS"	29	-38.078777019756	-11.9372613704434	2904	'Nordeste Baiano'	29018	'Entre Rios'
2900504	"ERICO CARDOSO"	29	-42.1361637333109	-13.4223477953016	2906	'Centro Sul Baiano'	29025	'Livramento do Brumado'
2910602	"ESPLANADA"	29	-37.9449814740986	-11.799409496062	2904	'Nordeste Baiano'	29018	'Entre Rios'
2910701	"EUCLIDES DA CUNHA"	29	-39.0142487251363	-10.5058180636519	2904	'Nordeste Baiano'	29014	'Euclides da Cunha'
2910727	"EUNAPOLIS"	29	-39.5841719409864	-16.3751672322564	2907	'Sul Baiano'	29032	'Porto Seguro'
2910750	"FATIMA"	29	-38.2086747828629	-10.6001702140173	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2910776	"FEIRA DA MATA"	29	-44.283463938437	-14.2105645058372	2902	'Vale São-Franciscano da Bahia'	29007	'Bom Jesus da Lapa'
2910800	"FEIRA DE SANTANA"	29	-38.9600330963214	-12.2292842524801	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2910859	"FILADELFIA"	29	-40.1378268767837	-10.7384641099353	2903	'Centro Norte Baiano'	29008	'Senhor do Bonfim'
2910909	"FIRMINO ALVES"	29	-39.9214417636272	-14.9849353752521	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2911006	"FLORESTA AZUL"	29	-39.6565235874089	-14.8627983966227	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2911105	"FORMOSA DO RIO PRETO"	29	-45.190990909729	-11.0470324906679	2901	'Extremo Oeste Baiano'	29001	'Barreiras'
2911204	"GANDU"	29	-39.4863240792918	-13.7437807885113	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2911253	"GAVIAO"	29	-39.786112929979	-11.4708954591253	2904	'Nordeste Baiano'	29016	'Serrinha'
2911303	"GENTIO DO OURO"	29	-42.5047423861031	-11.4275313127499	2903	'Centro Norte Baiano'	29009	'Irecê'
2911402	"GLORIA"	29	-38.2592732301041	-9.34017318364545	2902	'Vale São-Franciscano da Bahia'	29005	'Paulo Afonso'
2911501	"GONGOGI"	29	-39.4672396549531	-14.3237132993301	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2911600	"GOVERNADOR MANGABEIRA"	29	-39.0340236148013	-12.601553838445	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2911659	"GUAJERU"	29	-41.9371481668575	-14.5469622716723	2906	'Centro Sul Baiano'	29027	'Brumado'
2911709	"GUANAMBI"	29	-42.7785619667054	-14.2253150270076	2906	'Centro Sul Baiano'	29026	'Guanambi'
2911808	"GUARATINGA"	29	-39.7812844707838	-16.5812160355631	2907	'Sul Baiano'	29032	'Porto Seguro'
2911857	"HELIOPOLIS"	29	-38.2802330422697	-10.6752987880285	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2911907	"IACU"	29	-40.2133652349888	-12.7691377865306	2903	'Centro Norte Baiano'	29011	'Itaberaba'
2912004	"IBIASSUCE"	29	-42.2557743546652	-14.2767025345281	2906	'Centro Sul Baiano'	29026	'Guanambi'
2912103	"IBICARAI"	29	-39.5915412034881	-14.8657631413793	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2912202	"IBICOARA"	29	-41.2720658080785	-13.4263272087783	2906	'Centro Sul Baiano'	29023	'Seabra'
2912301	"IBICUI"	29	-39.9898321056847	-14.8430903650876	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2912400	"IBIPEBA"	29	-42.011248439896	-11.6375264431558	2903	'Centro Norte Baiano'	29009	'Irecê'
2912509	"IBIPITANGA"	29	-42.4912287412418	-12.8791061453242	2906	'Centro Sul Baiano'	29022	'Boquira'
2912608	"IBIQUERA"	29	-40.9354210018921	-12.6499286126214	2903	'Centro Norte Baiano'	29011	'Itaberaba'
2912707	"IBIRAPITANGA"	29	-39.3744665327401	-14.1650324961225	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2912806	"IBIRAPUA"	29	-40.1063094115419	-17.6841971442165	2907	'Sul Baiano'	29032	'Porto Seguro'
2912905	"IBIRATAIA"	29	-39.6409188889228	-14.0672690808107	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2913002	"IBITIARA"	29	-42.213294323499	-12.6455137042392	2906	'Centro Sul Baiano'	29022	'Boquira'
2913101	"IBITITA"	29	-41.9751521500745	-11.5527707224075	2903	'Centro Norte Baiano'	29009	'Irecê'
2913200	"IBOTIRAMA"	29	-43.2186962649655	-12.1840135690449	2902	'Vale São-Franciscano da Bahia'	29006	'Barra'
2913309	"ICHU"	29	-39.1887163054619	-11.7552498736675	2904	'Nordeste Baiano'	29016	'Serrinha'
2913408	"IGAPORA"	29	-42.7178798074989	-13.7679764775293	2906	'Centro Sul Baiano'	29026	'Guanambi'
2913457	"IGRAPIUNA"	29	-39.1400807978716	-13.8204024423397	2907	'Sul Baiano'	29030	'Valença'
2913507	"IGUAI"	29	-40.0975134505707	-14.7579625255698	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2913606	"ILHEUS"	29	-39.0431842869426	-14.7933202697252	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2913705	"INHAMBUPE"	29	-38.3540192706032	-11.7891274640932	2904	'Nordeste Baiano'	29017	'Alagoinhas'
2913804	"IPECAETA"	29	-39.3060256383634	-12.3141993063471	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2913903	"IPIAU"	29	-39.7356541802101	-14.1374736712629	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2914000	"IPIRA"	29	-39.7407084849396	-12.1602868808957	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2914109	"IPUPIARA"	29	-42.6106888538981	-11.8288274008654	2906	'Centro Sul Baiano'	29022	'Boquira'
2914208	"IRAJUBA"	29	-40.0838518009128	-13.2566101533511	2906	'Centro Sul Baiano'	29024	'Jequié'
2914307	"IRAMAIA"	29	-40.9695824783476	-13.2936511934142	2906	'Centro Sul Baiano'	29024	'Jequié'
2914406	"IRAQUARA"	29	-41.6179588573912	-12.2435010164176	2903	'Centro Norte Baiano'	29009	'Irecê'
2914505	"IRARA"	29	-38.7716507783794	-12.0337039631626	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2914604	"IRECE"	29	-41.8588604758612	-11.3033796242944	2903	'Centro Norte Baiano'	29009	'Irecê'
2914653	"ITABELA"	29	-39.5532377750796	-16.5758360567514	2907	'Sul Baiano'	29032	'Porto Seguro'
2914703	"ITABERABA"	29	-40.30699491974	-12.5322540889787	2903	'Centro Norte Baiano'	29011	'Itaberaba'
2914802	"ITABUNA"	29	-39.2731089520081	-14.789039548603	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2914901	"ITACARE"	29	-38.9948415531018	-14.278249285587	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2915007	"ITAETE"	29	-40.9634187749058	-12.9820339945038	2906	'Centro Sul Baiano'	29023	'Seabra'
2915106	"ITAGI"	29	-40.0136249931013	-14.1617937177936	2906	'Centro Sul Baiano'	29024	'Jequié'
2915205	"ITAGIBA"	29	-39.8485155565573	-14.286514167771	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2915304	"ITAGIMIRIM"	29	-39.61519181091	-16.08814327593	2907	'Sul Baiano'	29032	'Porto Seguro'
2915353	"ITAGUACU DA BAHIA"	29	-42.4011571242596	-11.0087222103694	2902	'Vale São-Franciscano da Bahia'	29006	'Barra'
2915403	"ITAJU DO COLONIA"	29	-39.7247246149297	-15.1401935524042	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2915502	"ITAJUIPE"	29	-39.3817881541009	-14.6780189897835	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2915601	"ITAMARAJU"	29	-39.5330398845548	-17.0423375996661	2907	'Sul Baiano'	29032	'Porto Seguro'
2915700	"ITAMARI"	29	-39.6763483469467	-13.774836755857	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2915809	"ITAMBE"	29	-40.6240417223752	-15.2480191939772	2906	'Centro Sul Baiano'	29029	'Itapetinga'
2915908	"ITANAGRA"	29	-38.0381809411938	-12.268163143855	2905	'Metropolitana de Salvador'	29019	'Catu'
2916005	"ITANHEM"	29	-40.3270486489758	-17.1663329036881	2907	'Sul Baiano'	29032	'Porto Seguro'
2916104	"ITAPARICA"	29	-38.6840303112952	-12.8814890528205	2905	'Metropolitana de Salvador'	29021	'Salvador'
2916203	"ITAPE"	29	-39.429962728368	-14.894807960836	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2916302	"ITAPEBI"	29	-39.5285413926178	-15.9721666550673	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2916401	"ITAPETINGA"	29	-40.2473809072369	-15.246167188692	2906	'Centro Sul Baiano'	29029	'Itapetinga'
2916500	"ITAPICURU"	29	-38.218612375549	-11.3109527005757	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2916609	"ITAPITANGA"	29	-39.5663618837119	-14.4211947386928	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2916708	"ITAQUARA"	29	-39.9382435936366	-13.4464090027676	2906	'Centro Sul Baiano'	29024	'Jequié'
2916807	"ITARANTIM"	29	-40.0615452743889	-15.6578300416217	2906	'Centro Sul Baiano'	29029	'Itapetinga'
2916856	"ITATIM"	29	-39.7037746062264	-12.7092465330848	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2916906	"ITIRUCU"	29	-40.1461722976579	-13.5323986079019	2906	'Centro Sul Baiano'	29024	'Jequié'
2917003	"ITIUBA"	29	-39.8532769742179	-10.6919012256505	2903	'Centro Norte Baiano'	29008	'Senhor do Bonfim'
2917102	"ITORORO"	29	-40.0717033442152	-15.1190373140262	2906	'Centro Sul Baiano'	29029	'Itapetinga'
2917201	"ITUACU"	29	-41.3109815271264	-13.807407146168	2906	'Centro Sul Baiano'	29027	'Brumado'
2917300	"ITUBERA"	29	-39.149042491857	-13.7361569056683	2907	'Sul Baiano'	29030	'Valença'
2917334	"IUIU"	29	-43.556402615529	-14.4121460364229	2906	'Centro Sul Baiano'	29026	'Guanambi'
2917359	"JABORANDI"	29	-44.4659699896562	-13.6259340019621	2901	'Extremo Oeste Baiano'	29003	'Santa Maria da Vitória'
2917409	"JACARACI"	29	-42.4306087705946	-14.8491905702097	2906	'Centro Sul Baiano'	29026	'Guanambi'
2917508	"JACOBINA"	29	-40.5130176278701	-11.1850621601419	2903	'Centro Norte Baiano'	29010	'Jacobina'
2917607	"JAGUAQUARA"	29	-39.9702551831643	-13.530698630843	2906	'Centro Sul Baiano'	29024	'Jequié'
2917706	"JAGUARARI"	29	-40.1936114661932	-10.2628542593016	2903	'Centro Norte Baiano'	29008	'Senhor do Bonfim'
2917805	"JAGUARIPE"	29	-38.8914186277088	-13.1150638883823	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2917904	"JANDAIRA"	29	-37.7868684912297	-11.5657484739409	2904	'Nordeste Baiano'	29018	'Entre Rios'
2918001	"JEQUIE"	29	-40.0886073274763	-13.8556640076641	2906	'Centro Sul Baiano'	29024	'Jequié'
2918100	"JEREMOABO"	29	-38.3518191467426	-10.0622424076243	2904	'Nordeste Baiano'	29013	'Jeremoabo'
2918209	"JIQUIRICA"	29	-39.5765017781122	-13.2523063492574	2906	'Centro Sul Baiano'	29024	'Jequié'
2918308	"JITAUNA"	29	-39.8896321766671	-14.0174286979097	2906	'Centro Sul Baiano'	29024	'Jequié'
2918357	"JOAO DOURADO"	29	-41.6599891797839	-11.3464052247312	2903	'Centro Norte Baiano'	29009	'Irecê'
2918407	"JUAZEIRO"	29	-40.5035521594434	-9.41071709622787	2902	'Vale São-Franciscano da Bahia'	29004	'Juazeiro'
2918456	"JUCURUCU"	29	-40.158812629938	-16.8445161458114	2907	'Sul Baiano'	29032	'Porto Seguro'
2918506	"JUSSARA"	29	-41.9797319275478	-11.0545549483525	2903	'Centro Norte Baiano'	29009	'Irecê'
2918555	"JUSSARI"	29	-39.4949398662896	-15.1904562989287	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2918605	"JUSSIAPE"	29	-41.5901420145899	-13.5129503420972	2906	'Centro Sul Baiano'	29023	'Seabra'
2918704	"LAFAIETE COUTINHO"	29	-40.2106058828047	-13.6529994248073	2906	'Centro Sul Baiano'	29024	'Jequié'
2918753	"LAGOA REAL"	29	-42.1457118363755	-14.030028985633	2906	'Centro Sul Baiano'	29026	'Guanambi'
2918803	"LAJE"	29	-39.427552152912	-13.1796486824668	2906	'Centro Sul Baiano'	29024	'Jequié'
2918902	"LAJEDAO"	29	-40.3458465320806	-17.6121309379681	2907	'Sul Baiano'	29032	'Porto Seguro'
2919009	"LAJEDINHO"	29	-40.903709970347	-12.3603741929439	2903	'Centro Norte Baiano'	29011	'Itaberaba'
2919058	"LAJEDO DO TABOCAL"	29	-40.2252295031908	-13.4725200035757	2906	'Centro Sul Baiano'	29024	'Jequié'
2919108	"LAMARAO"	29	-38.8929803339265	-11.7915777403757	2904	'Nordeste Baiano'	29016	'Serrinha'
2919157	"LAPAO"	29	-41.8319086533875	-11.3801390539198	2903	'Centro Norte Baiano'	29009	'Irecê'
2919207	"LAURO DE FREITAS"	29	-38.3234616102514	-12.8967176089245	2905	'Metropolitana de Salvador'	29021	'Salvador'
2919306	"LENCOIS"	29	-41.3940311361177	-12.5640631156412	2906	'Centro Sul Baiano'	29023	'Seabra'
2919405	"LICINIO DE ALMEIDA"	29	-42.5026836358801	-14.6758660767898	2906	'Centro Sul Baiano'	29026	'Guanambi'
2919504	"LIVRAMENTO DE NOSSA SENHORA"	29	-41.8403872818085	-13.6495009052305	2906	'Centro Sul Baiano'	29025	'Livramento do Brumado'
2919553	"LUIS EDUARDO MAGALHAES"	29	-45.8004644064563	-12.0783722561969	2901	'Extremo Oeste Baiano'	29001	'Barreiras'
2919603	"MACAJUBA"	29	-40.3651796434378	-12.1413926805595	2903	'Centro Norte Baiano'	29011	'Itaberaba'
2919702	"MACARANI"	29	-40.4220441103433	-15.5673161525245	2906	'Centro Sul Baiano'	29029	'Itapetinga'
2919801	"MACAUBAS"	29	-42.6946657468879	-13.0236716698562	2906	'Centro Sul Baiano'	29022	'Boquira'
2919900	"MACURURE"	29	-39.0595150265112	-9.1747059108515	2902	'Vale São-Franciscano da Bahia'	29005	'Paulo Afonso'
2919926	"MADRE DE DEUS"	29	-38.6027685669092	-12.7403126545334	2905	'Metropolitana de Salvador'	29021	'Salvador'
2919959	"MAETINGA"	29	-41.4836566953217	-14.6612663590579	2906	'Centro Sul Baiano'	29027	'Brumado'
2920007	"MAIQUINIQUE"	29	-40.2605151185559	-15.6197717025776	2906	'Centro Sul Baiano'	29029	'Itapetinga'
2920106	"MAIRI"	29	-40.1497825191557	-11.7111106230506	2903	'Centro Norte Baiano'	29011	'Itaberaba'
2920205	"MALHADA"	29	-43.7716203176702	-14.3403832840842	2906	'Centro Sul Baiano'	29026	'Guanambi'
2920304	"MALHADA DE PEDRAS"	29	-41.8786983400613	-14.3779454038321	2906	'Centro Sul Baiano'	29027	'Brumado'
2920403	"MANOEL VITORINO"	29	-40.2420162476621	-14.1459322060189	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2920452	"MANSIDAO"	29	-44.0364854095632	-10.715828960029	2901	'Extremo Oeste Baiano'	29002	'Cotegipe'
2920502	"MARACAS"	29	-40.4312875473779	-13.4376744923124	2906	'Centro Sul Baiano'	29024	'Jequié'
2920601	"MARAGOGIPE"	29	-38.9188814371553	-12.7751199192363	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2920700	"MARAU"	29	-39.0249517556685	-14.105530671656	2907	'Sul Baiano'	29030	'Valença'
2920809	"MARCIONILIO SOUZA"	29	-40.5345299893203	-13.0035103723106	2906	'Centro Sul Baiano'	29024	'Jequié'
2920908	"MASCOTE"	29	-39.3024004527217	-15.5659880327486	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2921005	"MATA DE SAO JOAO"	29	-38.2972993248088	-12.5299707907046	2905	'Metropolitana de Salvador'	29019	'Catu'
2921054	"MATINA"	29	-42.8429324443126	-13.9126360110704	2906	'Centro Sul Baiano'	29026	'Guanambi'
2921104	"MEDEIROS NETO"	29	-40.220174208006	-17.370409482092	2907	'Sul Baiano'	29032	'Porto Seguro'
2921203	"MIGUEL CALMON"	29	-40.596069612737	-11.4283442062266	2903	'Centro Norte Baiano'	29010	'Jacobina'
2921302	"MILAGRES"	29	-39.8591271004733	-12.8705749151395	2906	'Centro Sul Baiano'	29024	'Jequié'
2921401	"MIRANGABA"	29	-40.5747927022127	-10.9561172849444	2903	'Centro Norte Baiano'	29010	'Jacobina'
2921450	"MIRANTE"	29	-40.7735665979009	-14.2398179211321	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2921500	"MONTE SANTO"	29	-39.3327059520687	-10.440157740658	2904	'Nordeste Baiano'	29014	'Euclides da Cunha'
2921609	"MORPARA"	29	-43.2779134070032	-11.5580425446035	2902	'Vale São-Franciscano da Bahia'	29006	'Barra'
2921708	"MORRO DO CHAPEU"	29	-41.1590965077636	-11.5501261105049	2903	'Centro Norte Baiano'	29010	'Jacobina'
2921807	"MORTUGABA"	29	-42.3804489223231	-15.0164072903659	2906	'Centro Sul Baiano'	29026	'Guanambi'
2921906	"MUCUGE"	29	-41.3732130118668	-13.0038942044712	2906	'Centro Sul Baiano'	29023	'Seabra'
2922003	"MUCURI"	29	-39.5475458898298	-18.0885397388763	2907	'Sul Baiano'	29032	'Porto Seguro'
2922052	"MULUNGU DO MORRO"	29	-41.6438000095819	-11.967220021102	2903	'Centro Norte Baiano'	29009	'Irecê'
2922102	"MUNDO NOVO"	29	-40.4714981500981	-11.8647227486239	2903	'Centro Norte Baiano'	29011	'Itaberaba'
2922201	"MUNIZ FERREIRA"	29	-39.1129817012099	-12.9973037019252	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2922250	"MUQUEM DE SAO FRANCISCO"	29	-43.551859915059	-12.06826126493	2902	'Vale São-Franciscano da Bahia'	29006	'Barra'
2922300	"MURITIBA"	29	-38.9886888174458	-12.6233724415369	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2922409	"MUTUIPE"	29	-39.5041638520156	-13.2293733236817	2906	'Centro Sul Baiano'	29024	'Jequié'
2922508	"NAZARE"	29	-39.0106225828794	-13.0351482201812	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2922607	"NILO PECANHA"	29	-39.1129855090732	-13.6044944204415	2907	'Sul Baiano'	29030	'Valença'
2922656	"NORDESTINA"	29	-39.4291308507325	-10.8320535248462	2904	'Nordeste Baiano'	29014	'Euclides da Cunha'
2922706	"NOVA CANAA"	29	-40.145174652014	-14.7935980876719	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2922730	"NOVA FATIMA"	29	-39.6322170918942	-11.6083983892313	2904	'Nordeste Baiano'	29016	'Serrinha'
2922755	"NOVA IBIA"	29	-39.6256860494916	-13.8099073660338	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2922805	"NOVA ITARANA"	29	-40.0692497332534	-13.0330498856442	2906	'Centro Sul Baiano'	29024	'Jequié'
2922854	"NOVA REDENCAO"	29	-41.0688595103445	-12.8188675675112	2906	'Centro Sul Baiano'	29023	'Seabra'
2922904	"NOVA SOURE"	29	-38.4846139269682	-11.2380081972295	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2923001	"NOVA VICOSA"	29	-39.3720115380737	-17.8933917821788	2907	'Sul Baiano'	29032	'Porto Seguro'
2923035	"NOVO HORIZONTE"	29	-42.167788448517	-12.8019973640359	2906	'Centro Sul Baiano'	29022	'Boquira'
2923050	"NOVO TRIUNFO"	29	-38.4155813480126	-10.342018230888	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2923100	"OLINDINA"	29	-38.3310801960897	-11.3583061402444	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2923209	"OLIVEIRA DOS BREJINHOS"	29	-42.897019768671	-12.3205889500424	2906	'Centro Sul Baiano'	29022	'Boquira'
2923308	"OURICANGAS"	29	-38.6284167702128	-12.0068519179474	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2923357	"OUROLANDIA"	29	-41.0818117290063	-10.9646176504278	2903	'Centro Norte Baiano'	29010	'Jacobina'
2923407	"PALMAS DE MONTE ALTO"	29	-43.1705121315164	-14.257350994356	2906	'Centro Sul Baiano'	29026	'Guanambi'
2923506	"PALMEIRAS"	29	-41.5773369327133	-12.5100711046145	2906	'Centro Sul Baiano'	29023	'Seabra'
2923605	"PARAMIRIM"	29	-42.240648777677	-13.4424266571553	2906	'Centro Sul Baiano'	29025	'Livramento do Brumado'
2923704	"PARATINGA"	29	-43.1820250755777	-12.6906971249291	2902	'Vale São-Franciscano da Bahia'	29007	'Bom Jesus da Lapa'
2923803	"PARIPIRANGA"	29	-37.870447700721	-10.6759923133197	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2923902	"PAU BRASIL"	29	-39.6487820361139	-15.4636188168583	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2924009	"PAULO AFONSO"	29	-38.2183289682262	-9.40333169737823	2902	'Vale São-Franciscano da Bahia'	29005	'Paulo Afonso'
2924058	"PE DE SERRA"	29	-39.6094253290429	-11.8311793085998	2904	'Nordeste Baiano'	29016	'Serrinha'
2924108	"PEDRAO"	29	-38.6490014216411	-12.1435872038139	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2924207	"PEDRO ALEXANDRE"	29	-37.8992615844143	-10.010071580454	2904	'Nordeste Baiano'	29013	'Jeremoabo'
2924306	"PIATA"	29	-41.7706230393181	-13.1644568682516	2906	'Centro Sul Baiano'	29023	'Seabra'
2924405	"PILAO ARCADO"	29	-42.4847567624654	-9.99777105599991	2902	'Vale São-Franciscano da Bahia'	29004	'Juazeiro'
2924504	"PINDAI"	29	-42.6870333191128	-14.4899875404939	2906	'Centro Sul Baiano'	29026	'Guanambi'
2924603	"PINDOBACU"	29	-40.357159193636	-10.7342066123577	2903	'Centro Norte Baiano'	29008	'Senhor do Bonfim'
2924652	"PINTADAS"	29	-39.9082386319335	-11.8080365090652	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2924678	"PIRAI DO NORTE"	29	-39.3745221879491	-13.7612250392524	2907	'Sul Baiano'	29030	'Valença'
2924702	"PIRIPA"	29	-41.7248658272753	-14.9468709101065	2906	'Centro Sul Baiano'	29027	'Brumado'
2924801	"PIRITIBA"	29	-40.5513277059088	-11.7372340017775	2903	'Centro Norte Baiano'	29010	'Jacobina'
2924900	"PLANALTINO"	29	-40.3683973567155	-13.2566087533798	2906	'Centro Sul Baiano'	29024	'Jequié'
2925006	"PLANALTO"	29	-40.4846403764104	-14.6701699702495	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2925105	"POCOES"	29	-40.3651272938438	-14.5223245425648	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2925204	"POJUCA"	29	-38.3271668771048	-12.4292631348677	2905	'Metropolitana de Salvador'	29019	'Catu'
2925253	"PONTO NOVO"	29	-40.1353928450651	-10.8671478313026	2903	'Centro Norte Baiano'	29010	'Jacobina'
2925303	"PORTO SEGURO"	29	-39.0621135238902	-16.4490561793643	2907	'Sul Baiano'	29032	'Porto Seguro'
2925402	"POTIRAGUA"	29	-39.8756600705601	-15.5924563116907	2906	'Centro Sul Baiano'	29029	'Itapetinga'
2925501	"PRADO"	29	-39.229238421169	-17.3295639893846	2907	'Sul Baiano'	29032	'Porto Seguro'
2925600	"PRESIDENTE DUTRA"	29	-41.990930902445	-11.296504066349	2903	'Centro Norte Baiano'	29009	'Irecê'
2925709	"PRESIDENTE JANIO QUADROS"	29	-41.6824426344039	-14.685395366954	2906	'Centro Sul Baiano'	29027	'Brumado'
2925758	"PRESIDENTE TANCREDO NEVES"	29	-39.4240598299107	-13.4708417736022	2907	'Sul Baiano'	29030	'Valença'
2925808	"QUEIMADAS"	29	-39.6264068266007	-10.9763905291559	2904	'Nordeste Baiano'	29014	'Euclides da Cunha'
2925907	"QUIJINGUE"	29	-39.2066092540489	-10.7516723300366	2904	'Nordeste Baiano'	29014	'Euclides da Cunha'
2925931	"QUIXABEIRA"	29	-40.1214965949346	-11.4086852033198	2903	'Centro Norte Baiano'	29010	'Jacobina'
2925956	"RAFAEL JAMBEIRO"	29	-39.5006356828925	-12.4074173544739	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2926004	"REMANSO"	29	-42.0796675416606	-9.62390678921074	2902	'Vale São-Franciscano da Bahia'	29004	'Juazeiro'
2926103	"RETIROLANDIA"	29	-39.4241777923454	-11.4896669831527	2904	'Nordeste Baiano'	29016	'Serrinha'
2926202	"RIACHAO DAS NEVES"	29	-44.9164697719097	-11.7462475299556	2901	'Extremo Oeste Baiano'	29001	'Barreiras'
2926301	"RIACHAO DO JACUIPE"	29	-39.3830354938567	-11.8059790259237	2904	'Nordeste Baiano'	29016	'Serrinha'
2926400	"RIACHO DE SANTANA"	29	-42.9383471199804	-13.6065881421409	2906	'Centro Sul Baiano'	29026	'Guanambi'
2926509	"RIBEIRA DO AMPARO"	29	-38.4305538667121	-11.0391582800742	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2926608	"RIBEIRA DO POMBAL"	29	-38.5360987874333	-10.8362780747687	2904	'Nordeste Baiano'	29015	'Ribeira do Pombal'
2926657	"RIBEIRAO DO LARGO"	29	-40.7438597619248	-15.4640596335135	2906	'Centro Sul Baiano'	29029	'Itapetinga'
2926707	"RIO DE CONTAS"	29	-41.8187905563617	-13.5886077869907	2906	'Centro Sul Baiano'	29023	'Seabra'
2926806	"RIO DO ANTONIO"	29	-42.0750553350102	-14.4085096465099	2906	'Centro Sul Baiano'	29027	'Brumado'
2926905	"RIO DO PIRES"	29	-42.2878777528385	-13.1186631386997	2906	'Centro Sul Baiano'	29025	'Livramento do Brumado'
2927002	"RIO REAL"	29	-37.9335777751436	-11.4849354254303	2904	'Nordeste Baiano'	29017	'Alagoinhas'
2927101	"RODELAS"	29	-38.7723090006586	-8.84499653356944	2902	'Vale São-Franciscano da Bahia'	29005	'Paulo Afonso'
2927200	"RUY BARBOSA"	29	-40.5003712305803	-12.2893169587982	2903	'Centro Norte Baiano'	29011	'Itaberaba'
2927309	"SALINAS DA MARGARIDA"	29	-38.757943950869	-12.877997054567	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2927408	"SALVADOR"	29	-38.4880614840079	-13.0147719115328	2905	'Metropolitana de Salvador'	29021	'Salvador'
2927507	"SANTA BARBARA"	29	-38.9661390064385	-11.9569028341389	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2927606	"SANTA BRIGIDA"	29	-38.1278183662894	-9.73189095954201	2904	'Nordeste Baiano'	29013	'Jeremoabo'
2927705	"SANTA CRUZ CABRALIA"	29	-39.0131825840709	-16.3380965838173	2907	'Sul Baiano'	29032	'Porto Seguro'
2927804	"SANTA CRUZ DA VITORIA"	29	-39.8118359700429	-14.9600783107079	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2927903	"SANTA INES"	29	-39.8276053254776	-13.298687223335	2906	'Centro Sul Baiano'	29024	'Jequié'
2928059	"SANTA LUZIA"	29	-39.3324934250425	-15.4327879846348	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2928109	"SANTA MARIA DA VITORIA"	29	-44.1983088657849	-13.3935452501399	2901	'Extremo Oeste Baiano'	29003	'Santa Maria da Vitória'
2928406	"SANTA RITA DE CASSIA"	29	-44.5190497202788	-11.0080450698517	2901	'Extremo Oeste Baiano'	29002	'Cotegipe'
2928505	"SANTA TERESINHA"	29	-39.5211400561744	-12.7728517712321	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2928000	"SANTALUZ"	29	-39.3773777962667	-11.2533600344586	2904	'Nordeste Baiano'	29016	'Serrinha'
2928208	"SANTANA"	29	-44.0532579029164	-12.98075117473	2901	'Extremo Oeste Baiano'	29003	'Santa Maria da Vitória'
2928307	"SANTANOPOLIS"	29	-38.8671618077053	-12.0284068880334	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2928604	"SANTO AMARO"	29	-38.7090314624696	-12.5491401086618	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2928703	"SANTO ANTONIO DE JESUS"	29	-39.2611312580459	-12.9680077697186	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2928802	"SANTO ESTEVAO"	29	-39.2531902035138	-12.4288932288611	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2928901	"SAO DESIDERIO"	29	-44.9740962396215	-12.3608954905377	2901	'Extremo Oeste Baiano'	29001	'Barreiras'
2928950	"SAO DOMINGOS"	29	-39.5262647672412	-11.4634661341857	2904	'Nordeste Baiano'	29016	'Serrinha'
2929107	"SAO FELIPE"	29	-39.0840148984065	-12.8450782150251	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2929008	"SAO FELIX"	29	-38.9687185313515	-12.6057132519818	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2929057	"SAO FELIX DO CORIBE"	29	-44.1968725574679	-13.4042182497929	2901	'Extremo Oeste Baiano'	29003	'Santa Maria da Vitória'
2929206	"SAO FRANCISCO DO CONDE"	29	-38.6757980532931	-12.6299828044039	2905	'Metropolitana de Salvador'	29021	'Salvador'
2929255	"SAO GABRIEL"	29	-41.8742692011285	-11.2267073342793	2903	'Centro Norte Baiano'	29009	'Irecê'
2929305	"SAO GONCALO DOS CAMPOS"	29	-38.949772430601	-12.4303098042388	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2929354	"SAO JOSE DA VITORIA"	29	-39.338920502937	-15.078178211378	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2929370	"SAO JOSE DO JACUIPE"	29	-40.0236558829144	-11.505326093792	2903	'Centro Norte Baiano'	29010	'Jacobina'
2929404	"SAO MIGUEL DAS MATAS"	29	-39.4557804260308	-13.0517330820998	2906	'Centro Sul Baiano'	29024	'Jequié'
2929503	"SAO SEBASTIAO DO PASSE"	29	-38.495309845374	-12.512724642985	2905	'Metropolitana de Salvador'	29019	'Catu'
2929602	"SAPEACU"	29	-39.1948084366246	-12.7351614750528	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2929701	"SATIRO DIAS"	29	-38.5913537821245	-11.6008090454152	2904	'Nordeste Baiano'	29017	'Alagoinhas'
2929750	"SAUBARA"	29	-38.7706068300048	-12.7369036248191	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2929800	"SAUDE"	29	-40.4185507431154	-10.9411051662096	2903	'Centro Norte Baiano'	29010	'Jacobina'
2929909	"SEABRA"	29	-41.7682012410905	-12.4187631865162	2906	'Centro Sul Baiano'	29023	'Seabra'
2930006	"SEBASTIAO LARANJEIRAS"	29	-42.9441131530547	-14.5748223923479	2906	'Centro Sul Baiano'	29026	'Guanambi'
2930105	"SENHOR DO BONFIM"	29	-40.1899845399956	-10.4567714931968	2903	'Centro Norte Baiano'	29008	'Senhor do Bonfim'
2930204	"SENTO SE"	29	-41.8909969156275	-9.74037980462474	2902	'Vale São-Franciscano da Bahia'	29004	'Juazeiro'
2930154	"SERRA DO RAMALHO"	29	-43.5807307421456	-13.5644659880715	2902	'Vale São-Franciscano da Bahia'	29007	'Bom Jesus da Lapa'
2930303	"SERRA DOURADA"	29	-43.9523372558921	-12.7625947392978	2901	'Extremo Oeste Baiano'	29003	'Santa Maria da Vitória'
2930402	"SERRA PRETA"	29	-39.3325039202553	-12.1597268274139	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2930501	"SERRINHA"	29	-39.008132628756	-11.6595317243643	2904	'Nordeste Baiano'	29016	'Serrinha'
2930600	"SERROLANDIA"	29	-40.299905217028	-11.4160318981088	2903	'Centro Norte Baiano'	29010	'Jacobina'
2930709	"SIMOES FILHO"	29	-38.4115191932451	-12.7839414833678	2905	'Metropolitana de Salvador'	29021	'Salvador'
2930758	"SITIO DO MATO"	29	-43.4664411672544	-13.0857927061126	2902	'Vale São-Franciscano da Bahia'	29007	'Bom Jesus da Lapa'
2930766	"SITIO DO QUINTO"	29	-38.2003708811346	-10.3641586477739	2904	'Nordeste Baiano'	29013	'Jeremoabo'
2930774	"SOBRADINHO"	29	-40.7915948463624	-9.47080663849994	2902	'Vale São-Franciscano da Bahia'	29004	'Juazeiro'
2930808	"SOUTO SOARES"	29	-41.6442483898691	-12.0925960034189	2903	'Centro Norte Baiano'	29009	'Irecê'
2930907	"TABOCAS DO BREJO VELHO"	29	-44.0111890670864	-12.7073009223161	2901	'Extremo Oeste Baiano'	29002	'Cotegipe'
2931004	"TANHACU"	29	-41.2543335107241	-14.0255080592255	2906	'Centro Sul Baiano'	29027	'Brumado'
2931053	"TANQUE NOVO"	29	-42.4906125114981	-13.5465603206792	2906	'Centro Sul Baiano'	29022	'Boquira'
2931103	"TANQUINHO"	29	-39.100547165361	-11.9716930934711	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2931202	"TAPEROA"	29	-39.1006222478813	-13.5309926331682	2907	'Sul Baiano'	29030	'Valença'
2931301	"TAPIRAMUTA"	29	-40.7887003322581	-11.8523411104563	2903	'Centro Norte Baiano'	29011	'Itaberaba'
2931350	"TEIXEIRA DE FREITAS"	29	-39.7445176868085	-17.5377498816811	2907	'Sul Baiano'	29032	'Porto Seguro'
2931400	"TEODORO SAMPAIO"	29	-38.6419275419473	-12.3014071565363	2903	'Centro Norte Baiano'	29012	'Feira de Santana'
2931509	"TEOFILANDIA"	29	-39.0058128587129	-11.4829246317549	2904	'Nordeste Baiano'	29016	'Serrinha'
2931608	"TEOLANDIA"	29	-39.4893857886023	-13.6011060070107	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2931707	"TERRA NOVA"	29	-38.6231018591955	-12.4030919013749	2905	'Metropolitana de Salvador'	29019	'Catu'
2931806	"TREMEDAL"	29	-41.4095763195932	-14.9724717722726	2906	'Centro Sul Baiano'	29027	'Brumado'
2931905	"TUCANO"	29	-38.7859480015492	-10.9643001695673	2904	'Nordeste Baiano'	29014	'Euclides da Cunha'
2932002	"UAUA"	29	-39.4880641705295	-9.83265416561483	2904	'Nordeste Baiano'	29014	'Euclides da Cunha'
2932101	"UBAIRA"	29	-39.662032567228	-13.2680894848911	2906	'Centro Sul Baiano'	29024	'Jequié'
2932200	"UBAITABA"	29	-39.3225474057589	-14.3104363678067	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2932309	"UBATA"	29	-39.5226677883931	-14.211466553942	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2932408	"UIBAI"	29	-42.1337955487965	-11.3381145644914	2903	'Centro Norte Baiano'	29009	'Irecê'
2932457	"UMBURANAS"	29	-41.3329141302901	-10.7292712187978	2903	'Centro Norte Baiano'	29008	'Senhor do Bonfim'
2932507	"UNA"	29	-39.0747128879619	-15.294208064906	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2932606	"URANDI"	29	-42.6589988097565	-14.7632421837899	2906	'Centro Sul Baiano'	29026	'Guanambi'
2932705	"URUCUCA"	29	-39.2838018788493	-14.5920354535153	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2932804	"UTINGA"	29	-41.0958288508152	-12.0833176629994	2906	'Centro Sul Baiano'	29023	'Seabra'
2932903	"VALENCA"	29	-39.0723502471979	-13.370341506502	2907	'Sul Baiano'	29030	'Valença'
2933000	"VALENTE"	29	-39.4642460663082	-11.412489535751	2904	'Nordeste Baiano'	29016	'Serrinha'
2933059	"VARZEA DA ROCA"	29	-40.1406370838535	-11.5989862634569	2903	'Centro Norte Baiano'	29011	'Itaberaba'
2933109	"VARZEA DO POCO"	29	-40.3189181998398	-11.5239795325989	2903	'Centro Norte Baiano'	29010	'Jacobina'
2933158	"VARZEA NOVA"	29	-40.9458459310635	-11.2572312022726	2903	'Centro Norte Baiano'	29010	'Jacobina'
2933174	"VARZEDO"	29	-39.3934758347381	-12.9753125649567	2905	'Metropolitana de Salvador'	29020	'Santo Antônio de Jesus'
2933208	"VERA CRUZ"	29	-38.6191597463471	-12.9357333313259	2905	'Metropolitana de Salvador'	29021	'Salvador'
2933257	"VEREDA"	29	-40.0844849278142	-17.2239340593797	2907	'Sul Baiano'	29032	'Porto Seguro'
2933307	"VITORIA DA CONQUISTA"	29	-40.8398095371781	-14.8480048115856	2906	'Centro Sul Baiano'	29028	'Vitória da Conquista'
2933406	"WAGNER"	29	-41.169626985929	-12.2842507899379	2906	'Centro Sul Baiano'	29023	'Seabra'
2933455	"WANDERLEY"	29	-43.8889295198526	-12.1201503140061	2901	'Extremo Oeste Baiano'	29002	'Cotegipe'
2933505	"WENCESLAU GUIMARAES"	29	-39.4796708031912	-13.688587752525	2907	'Sul Baiano'	29031	'Ilhéus-Itabuna'
2933604	"XIQUE-XIQUE"	29	-42.7255080011618	-10.8249744181433	2902	'Vale São-Franciscano da Bahia'	29006	'Barra'
2300101	"ABAIARA"	23	-39.0475466361851	-7.35697659589831	2307	'Sul Cearense'	23033	'Brejo Santo'
2300150	"ACARAPE"	23	-38.7056237709826	-4.22313840937245	2302	'Norte Cearense'	23013	'Baturité'
2300200	"ACARAU"	23	-40.1182414711655	-2.885310540095	2301	'Noroeste Cearense'	23001	'Litoral de Camocim e Acaraú'
2300309	"ACOPIARA"	23	-39.4557052761772	-6.092761995	2304	'Sertões Cearenses'	23021	'Sertão de Senador Pompeu'
2300408	"AIUABA"	23	-40.1231600775541	-6.56329844005168	2304	'Sertões Cearenses'	23020	'Sertão de Inhamuns'
2300507	"ALCANTARAS"	23	-40.5446381225739	-3.58698376924817	2301	'Noroeste Cearense'	23004	'Meruoca'
2300606	"ALTANEIRA"	23	-39.7458206389421	-6.9974983508052	2307	'Sul Cearense'	23030	'Caririaçu'
2300705	"ALTO SANTO"	23	-38.2727781487196	-5.52208173974523	2305	'Jaguaribe'	23023	'Baixo Jaguaribe'
2300754	"AMONTADA"	23	-39.8288227917225	-3.36487780347731	2302	'Norte Cearense'	23008	'Itapipoca'
2300804	"ANTONINA DO NORTE"	23	-39.9823868418819	-6.77968784711829	2306	'Centro-Sul Cearense'	23027	'Várzea Alegre'
2300903	"APUIARES"	23	-39.4304227833004	-3.94801851861481	2302	'Norte Cearense'	23011	'Médio Curu'
2301000	"AQUIRAZ"	23	-38.3898029588509	-3.9061945	2303	'Metropolitana de Fortaleza'	23016	'Fortaleza'
2301109	"ARACATI"	23	-37.7727525989113	-4.56706647	2305	'Jaguaribe'	23022	'Litoral de Aracati'
2301208	"ARACOIABA"	23	-38.8094409691659	-4.37039380697671	2302	'Norte Cearense'	23013	'Baturité'
2301257	"ARARENDA"	23	-40.8310967349814	-4.75193827199216	2304	'Sertões Cearenses'	23018	'Sertão de Cratéus'
2301307	"ARARIPE"	23	-40.1374458093569	-7.20618378918069	2307	'Sul Cearense'	23029	'Chapada do Araripe'
2301406	"ARATUBA"	23	-39.047554561796	-4.41693064499256	2302	'Norte Cearense'	23013	'Baturité'
2301505	"ARNEIROZ"	23	-40.161443712374	-6.31942580302218	2304	'Sertões Cearenses'	23020	'Sertão de Inhamuns'
2301604	"ASSARE"	23	-39.8712747474926	-6.87260711221149	2307	'Sul Cearense'	23029	'Chapada do Araripe'
2301703	"AURORA"	23	-38.9769908769444	-6.94039183200645	2307	'Sul Cearense'	23031	'Barro'
2301802	"BAIXIO"	23	-38.7201259159638	-6.7271620493217	2306	'Centro-Sul Cearense'	23028	'Lavras da Mangabeira'
2301851	"BANABUIU"	23	-38.9257848049298	-5.3150473039948	2304	'Sertões Cearenses'	23019	'Sertão de Quixeramobim'
2301901	"BARBALHA"	23	-39.3023163692257	-7.30717212691268	2307	'Sul Cearense'	23032	'Cariri'
2301950	"BARREIRA"	23	-38.6385018295574	-4.28876226676818	2302	'Norte Cearense'	23014	'Chorozinho'
2302008	"BARRO"	23	-38.7798806460522	-7.16820872668523	2307	'Sul Cearense'	23031	'Barro'
2302057	"BARROQUINHA"	23	-41.1394815381655	-3.00911674619191	2301	'Noroeste Cearense'	23001	'Litoral de Camocim e Acaraú'
2302107	"BATURITE"	23	-38.8800213756291	-4.33120515640856	2302	'Norte Cearense'	23013	'Baturité'
2302206	"BEBERIBE"	23	-38.1232730421463	-4.17476322117715	2302	'Norte Cearense'	23015	'Cascavel'
2302305	"BELA CRUZ"	23	-40.1668429070243	-3.05510672431327	2301	'Noroeste Cearense'	23001	'Litoral de Camocim e Acaraú'
2302404	"BOA VIAGEM"	23	-39.7332823425095	-5.12574387005676	2304	'Sertões Cearenses'	23019	'Sertão de Quixeramobim'
2302503	"BREJO SANTO"	23	-38.9855138673635	-7.49163800866139	2307	'Sul Cearense'	23033	'Brejo Santo'
2302602	"CAMOCIM"	23	-40.847527740938	-2.9009665745879	2301	'Noroeste Cearense'	23001	'Litoral de Camocim e Acaraú'
2302701	"CAMPOS SALES"	23	-40.3790031301681	-7.0733835	2307	'Sul Cearense'	23029	'Chapada do Araripe'
2302800	"CANINDE"	23	-39.3103429528638	-4.35534428969186	2302	'Norte Cearense'	23012	'Canindé'
2302909	"CAPISTRANO"	23	-38.9018287595054	-4.45989661214017	2302	'Norte Cearense'	23013	'Baturité'
2303006	"CARIDADE"	23	-39.1930329149954	-4.22496000078457	2302	'Norte Cearense'	23012	'Canindé'
2303105	"CARIRE"	23	-40.4738448077338	-3.95161188001281	2301	'Noroeste Cearense'	23005	'Sobral'
2303204	"CARIRIACU"	23	-39.2843720295557	-7.041528	2307	'Sul Cearense'	23030	'Caririaçu'
2303303	"CARIUS"	23	-39.4976886800605	-6.53112793786476	2306	'Centro-Sul Cearense'	23027	'Várzea Alegre'
2303402	"CARNAUBAL"	23	-40.935631577279	-4.16398856236529	2301	'Noroeste Cearense'	23002	'Ibiapaba'
2303501	"CASCAVEL"	23	-38.2396859406771	-4.13143367820745	2302	'Norte Cearense'	23015	'Cascavel'
2303600	"CATARINA"	23	-39.879466228339	-6.12755629081684	2304	'Sertões Cearenses'	23020	'Sertão de Inhamuns'
2303659	"CATUNDA"	23	-40.2058037894278	-4.65154938565972	2301	'Noroeste Cearense'	23007	'Santa Quitéria'
2303709	"CAUCAIA"	23	-38.6640175358384	-3.736487	2303	'Metropolitana de Fortaleza'	23016	'Fortaleza'
2303808	"CEDRO"	23	-39.0597431480294	-6.6049605	2306	'Centro-Sul Cearense'	23026	'Iguatu'
2303907	"CHAVAL"	23	-41.2445958219436	-3.03890118909178	2301	'Noroeste Cearense'	23001	'Litoral de Camocim e Acaraú'
2303931	"CHORO"	23	-39.1374675315576	-4.84251565928672	2304	'Sertões Cearenses'	23019	'Sertão de Quixeramobim'
2303956	"CHOROZINHO"	23	-38.5012856666586	-4.30217091397851	2302	'Norte Cearense'	23014	'Chorozinho'
2304004	"COREAU"	23	-40.6569510757545	-3.54948786111024	2301	'Noroeste Cearense'	23003	'Coreaú'
2304103	"CRATEUS"	23	-40.6684001308448	-5.17695055079545	2304	'Sertões Cearenses'	23018	'Sertão de Cratéus'
2304202	"CRATO"	23	-39.4083902977886	-7.23175278993045	2307	'Sul Cearense'	23032	'Cariri'
2304236	"CROATA"	23	-40.9090450981578	-4.41405726551229	2301	'Noroeste Cearense'	23002	'Ibiapaba'
2304251	"CRUZ"	23	-40.171278706542	-2.91670805035548	2301	'Noroeste Cearense'	23001	'Litoral de Camocim e Acaraú'
2304269	"DEPUTADO IRAPUAN PINHEIRO"	23	-39.2615417650871	-5.90896237382936	2304	'Sertões Cearenses'	23021	'Sertão de Senador Pompeu'
2304277	"ERERE"	23	-38.3472589620963	-6.03133272993446	2305	'Jaguaribe'	23025	'Serra do Pereiro'
2304285	"EUSEBIO"	23	-38.4451218386123	-3.88697288667811	2303	'Metropolitana de Fortaleza'	23016	'Fortaleza'
2304301	"FARIAS BRITO"	23	-39.5708350212066	-6.92710998064911	2307	'Sul Cearense'	23030	'Caririaçu'
2304350	"FORQUILHA"	23	-40.2587689981082	-3.79895774308495	2301	'Noroeste Cearense'	23005	'Sobral'
2304400	"FORTALEZA"	23	-38.5899275550432	-3.723805035	2303	'Metropolitana de Fortaleza'	23016	'Fortaleza'
2304459	"FORTIM"	23	-37.7989754860384	-4.44980491741282	2305	'Jaguaribe'	23022	'Litoral de Aracati'
2304509	"FRECHEIRINHA"	23	-40.8214052011868	-3.76061193145276	2301	'Noroeste Cearense'	23003	'Coreaú'
2304608	"GENERAL SAMPAIO"	23	-39.4535299504286	-4.05104127465347	2302	'Norte Cearense'	23011	'Médio Curu'
2304657	"GRACA"	23	-40.755524899564	-4.04693879398909	2301	'Noroeste Cearense'	23005	'Sobral'
2304707	"GRANJA"	23	-40.8299389910215	-3.11895215616977	2301	'Noroeste Cearense'	23001	'Litoral de Camocim e Acaraú'
2304806	"GRANJEIRO"	23	-39.2203088858466	-6.88888437288031	2307	'Sul Cearense'	23030	'Caririaçu'
2304905	"GROAIRAS"	23	-40.382146023886	-3.91195412920395	2301	'Noroeste Cearense'	23005	'Sobral'
2304954	"GUAIUBA"	23	-38.6344347805213	-4.04024350050078	2303	'Metropolitana de Fortaleza'	23016	'Fortaleza'
2305001	"GUARACIABA DO NORTE"	23	-40.7526331779113	-4.1624510671404	2301	'Noroeste Cearense'	23002	'Ibiapaba'
2305100	"GUARAMIRANGA"	23	-38.94063328506	-4.26205091860387	2302	'Norte Cearense'	23013	'Baturité'
2305209	"HIDROLANDIA"	23	-40.4018171243637	-4.40799944425957	2301	'Noroeste Cearense'	23007	'Santa Quitéria'
2305233	"HORIZONTE"	23	-38.4942395585521	-4.093278	2303	'Metropolitana de Fortaleza'	23017	'Pacajus'
2305266	"IBARETAMA"	23	-38.8216783127295	-4.81865157790641	2304	'Sertões Cearenses'	23019	'Sertão de Quixeramobim'
2305308	"IBIAPINA"	23	-40.8939290197956	-3.93613126224114	2301	'Noroeste Cearense'	23002	'Ibiapaba'
2305332	"IBICUITINGA"	23	-38.6408630485786	-4.96916642282456	2305	'Jaguaribe'	23023	'Baixo Jaguaribe'
2305357	"ICAPUI"	23	-37.3535630985971	-4.71554948783128	2305	'Jaguaribe'	23022	'Litoral de Aracati'
2305407	"ICO"	23	-38.8630851788798	-6.40303125193041	2306	'Centro-Sul Cearense'	23026	'Iguatu'
2305506	"IGUATU"	23	-39.2999056781645	-6.36055472004592	2306	'Centro-Sul Cearense'	23026	'Iguatu'
2305605	"INDEPENDENCIA"	23	-40.3093482605607	-5.39802810026086	2304	'Sertões Cearenses'	23018	'Sertão de Cratéus'
2305654	"IPAPORANGA"	23	-40.7579663399773	-4.90062978571446	2304	'Sertões Cearenses'	23018	'Sertão de Cratéus'
2305704	"IPAUMIRIM"	23	-38.7159037441224	-6.78836126021327	2306	'Centro-Sul Cearense'	23028	'Lavras da Mangabeira'
2305803	"IPU"	23	-40.7187261447301	-4.31343168517722	2301	'Noroeste Cearense'	23006	'Ipu'
2305902	"IPUEIRAS"	23	-40.7156965105938	-4.543785495	2301	'Noroeste Cearense'	23006	'Ipu'
2306009	"IRACEMA"	23	-38.3046616556988	-5.80984255286376	2305	'Jaguaribe'	23025	'Serra do Pereiro'
2306108	"IRAUCUBA"	23	-39.7922381150857	-3.74541880170377	2301	'Noroeste Cearense'	23005	'Sobral'
2306207	"ITAICABA"	23	-37.821629513686	-4.68340471185561	2305	'Jaguaribe'	23022	'Litoral de Aracati'
2306256	"ITAITINGA"	23	-38.5264051494908	-3.97045901630545	2303	'Metropolitana de Fortaleza'	23016	'Fortaleza'
2306306	"ITAPAGE"	23	-39.5835332386222	-3.68567310984199	2302	'Norte Cearense'	23010	'Uruburetama'
2306405	"ITAPIPOCA"	23	-39.583481575771	-3.4994355	2302	'Norte Cearense'	23008	'Itapipoca'
2306504	"ITAPIUNA"	23	-38.9206739559252	-4.55474017465125	2302	'Norte Cearense'	23013	'Baturité'
2306553	"ITAREMA"	23	-39.915677748929	-2.923348	2301	'Noroeste Cearense'	23001	'Litoral de Camocim e Acaraú'
2306603	"ITATIRA"	23	-39.6179040158845	-4.52892256233297	2302	'Norte Cearense'	23012	'Canindé'
2306702	"JAGUARETAMA"	23	-38.7625262979074	-5.61088956322615	2305	'Jaguaribe'	23024	'Médio Jaguaribe'
2306801	"JAGUARIBARA"	23	-38.4630972955508	-5.45750203396349	2305	'Jaguaribe'	23024	'Médio Jaguaribe'
2306900	"JAGUARIBE"	23	-38.6230050492668	-5.886459045	2305	'Jaguaribe'	23024	'Médio Jaguaribe'
2307007	"JAGUARUANA"	23	-37.7823914809586	-4.83955516829761	2305	'Jaguaribe'	23023	'Baixo Jaguaribe'
2307106	"JARDIM"	23	-39.2841644573661	-7.58553646567843	2307	'Sul Cearense'	23032	'Cariri'
2307205	"JATI"	23	-39.0051387612294	-7.69274159478333	2307	'Sul Cearense'	23033	'Brejo Santo'
2307254	"JIJOCA DE JERICOACOARA"	23	-40.4387354018727	-2.89968270887056	2301	'Noroeste Cearense'	23001	'Litoral de Camocim e Acaraú'
2307304	"JUAZEIRO DO NORTE"	23	-39.3169933556143	-7.210766	2307	'Sul Cearense'	23032	'Cariri'
2307403	"JUCAS"	23	-39.5267762434303	-6.52254927305863	2306	'Centro-Sul Cearense'	23027	'Várzea Alegre'
2307502	"LAVRAS DA MANGABEIRA"	23	-38.9672750539277	-6.75474797684014	2306	'Centro-Sul Cearense'	23028	'Lavras da Mangabeira'
2307601	"LIMOEIRO DO NORTE"	23	-38.0990948704529	-5.15023902	2305	'Jaguaribe'	23023	'Baixo Jaguaribe'
2307635	"MADALENA"	23	-39.5757886826003	-4.85243417660198	2304	'Sertões Cearenses'	23019	'Sertão de Quixeramobim'
2307650	"MARACANAU"	23	-38.6244186465865	-3.87696445102036	2303	'Metropolitana de Fortaleza'	23016	'Fortaleza'
2307700	"MARANGUAPE"	23	-38.6858512476873	-3.89186946	2303	'Metropolitana de Fortaleza'	23016	'Fortaleza'
2307809	"MARCO"	23	-40.1516436427496	-3.120707025	2301	'Noroeste Cearense'	23001	'Litoral de Camocim e Acaraú'
2307908	"MARTINOPOLE"	23	-40.6993551750691	-3.22501222744216	2301	'Noroeste Cearense'	23001	'Litoral de Camocim e Acaraú'
2308005	"MASSAPE"	23	-40.3421348648013	-3.52387058428249	2301	'Noroeste Cearense'	23005	'Sobral'
2308104	"MAURITI"	23	-38.772795438031	-7.387398	2307	'Sul Cearense'	23031	'Barro'
2308203	"MERUOCA"	23	-40.4508809567861	-3.53900666231988	2301	'Noroeste Cearense'	23004	'Meruoca'
2308302	"MILAGRES"	23	-38.9431567662076	-7.31042779678189	2307	'Sul Cearense'	23033	'Brejo Santo'
2308351	"MILHA"	23	-39.2035741816436	-5.67956410088697	2304	'Sertões Cearenses'	23021	'Sertão de Senador Pompeu'
2308377	"MIRAIMA"	23	-39.9700648820021	-3.56859990655738	2301	'Noroeste Cearense'	23005	'Sobral'
2308401	"MISSAO VELHA"	23	-39.1451977078653	-7.24323151378516	2307	'Sul Cearense'	23032	'Cariri'
2308500	"MOMBACA"	23	-39.6244052478572	-5.74700454	2304	'Sertões Cearenses'	23021	'Sertão de Senador Pompeu'
2308609	"MONSENHOR TABOSA"	23	-40.0700674615929	-4.78309129145873	2304	'Sertões Cearenses'	23018	'Sertão de Cratéus'
2308708	"MORADA NOVA"	23	-38.3649073450731	-5.09695200016721	2305	'Jaguaribe'	23023	'Baixo Jaguaribe'
2308807	"MORAUJO"	23	-40.6835989271198	-3.46636327439925	2301	'Noroeste Cearense'	23003	'Coreaú'
2308906	"MORRINHOS"	23	-40.1241788929331	-3.22883053425389	2301	'Noroeste Cearense'	23001	'Litoral de Camocim e Acaraú'
2309003	"MUCAMBO"	23	-40.7452804651593	-3.90602997959821	2301	'Noroeste Cearense'	23005	'Sobral'
2309102	"MULUNGU"	23	-38.9930659239268	-4.29952832007765	2302	'Norte Cearense'	23013	'Baturité'
2309201	"NOVA OLINDA"	23	-39.6794854726644	-7.08410281138904	2307	'Sul Cearense'	23032	'Cariri'
2309300	"NOVA RUSSAS"	23	-40.5653033548825	-4.7068083499366	2304	'Sertões Cearenses'	23018	'Sertão de Cratéus'
2309409	"NOVO ORIENTE"	23	-40.7747672682117	-5.53386483554612	2304	'Sertões Cearenses'	23018	'Sertão de Cratéus'
2309458	"OCARA"	23	-38.5985379827902	-4.48506654454779	2302	'Norte Cearense'	23014	'Chorozinho'
2309508	"OROS"	23	-38.9135959845487	-6.24279878368762	2306	'Centro-Sul Cearense'	23026	'Iguatu'
2309607	"PACAJUS"	23	-38.4670222648935	-4.17054051	2303	'Metropolitana de Fortaleza'	23017	'Pacajus'
2309706	"PACATUBA"	23	-38.6182993120325	-3.98612002229387	2303	'Metropolitana de Fortaleza'	23016	'Fortaleza'
2309805	"PACOTI"	23	-38.9258889386659	-4.22476543307066	2302	'Norte Cearense'	23013	'Baturité'
2309904	"PACUJA"	23	-40.6967361072542	-3.97839438605716	2301	'Noroeste Cearense'	23005	'Sobral'
2310001	"PALHANO"	23	-37.9662351610974	-4.74394507677329	2305	'Jaguaribe'	23023	'Baixo Jaguaribe'
2310100	"PALMACIA"	23	-38.8450290663103	-4.14898177452437	2302	'Norte Cearense'	23013	'Baturité'
2310209	"PARACURU"	23	-39.0295453441225	-3.41163500915711	2302	'Norte Cearense'	23009	'Baixo Curu'
2310258	"PARAIPABA"	23	-39.1481155272123	-3.43619672787107	2302	'Norte Cearense'	23009	'Baixo Curu'
2310308	"PARAMBU"	23	-40.6942072413457	-6.21033600172244	2304	'Sertões Cearenses'	23020	'Sertão de Inhamuns'
2310407	"PARAMOTI"	23	-39.2394664950313	-4.09743233197343	2302	'Norte Cearense'	23012	'Canindé'
2310506	"PEDRA BRANCA"	23	-39.7139376447036	-5.4546855	2304	'Sertões Cearenses'	23021	'Sertão de Senador Pompeu'
2310605	"PENAFORTE"	23	-39.0741275240802	-7.82991461205567	2307	'Sul Cearense'	23033	'Brejo Santo'
2310704	"PENTECOSTE"	23	-39.267008731469	-3.79626673615443	2302	'Norte Cearense'	23011	'Médio Curu'
2310803	"PEREIRO"	23	-38.4591360389541	-6.04507690203015	2305	'Jaguaribe'	23025	'Serra do Pereiro'
2310852	"PINDORETAMA"	23	-38.3000879762561	-4.02780399274119	2302	'Norte Cearense'	23015	'Cascavel'
2310902	"PIQUET CARNEIRO"	23	-39.419406255538	-5.80856955977343	2304	'Sertões Cearenses'	23021	'Sertão de Senador Pompeu'
2310951	"PIRES FERREIRA"	23	-40.6465412477527	-4.24215414323442	2301	'Noroeste Cearense'	23006	'Ipu'
2311009	"PORANGA"	23	-40.9263795102653	-4.74395073194117	2301	'Noroeste Cearense'	23006	'Ipu'
2311108	"PORTEIRAS"	23	-39.1153314614829	-7.53574644160671	2307	'Sul Cearense'	23032	'Cariri'
2311207	"POTENGI"	23	-40.0321325356878	-7.09017946960707	2307	'Sul Cearense'	23029	'Chapada do Araripe'
2311231	"POTIRETAMA"	23	-38.1579178531648	-5.72166790374219	2305	'Jaguaribe'	23025	'Serra do Pereiro'
2311264	"QUITERIANOPOLIS"	23	-40.7044888468331	-5.8470092293282	2304	'Sertões Cearenses'	23018	'Sertão de Cratéus'
2311306	"QUIXADA"	23	-39.0117446758304	-4.9637	2304	'Sertões Cearenses'	23019	'Sertão de Quixeramobim'
2311355	"QUIXELO"	23	-39.202294366455	-6.25121190037953	2306	'Centro-Sul Cearense'	23026	'Iguatu'
2311405	"QUIXERAMOBIM"	23	-39.2943542269635	-5.19840483742558	2304	'Sertões Cearenses'	23019	'Sertão de Quixeramobim'
2311504	"QUIXERE"	23	-37.9905222250863	-5.06872895444067	2305	'Jaguaribe'	23023	'Baixo Jaguaribe'
2311603	"REDENCAO"	23	-38.7295707505904	-4.22295815020099	2302	'Norte Cearense'	23013	'Baturité'
2311702	"RERIUTABA"	23	-40.5846120036545	-4.14156760083061	2301	'Noroeste Cearense'	23006	'Ipu'
2311801	"RUSSAS"	23	-37.975431296901	-4.93973781536402	2305	'Jaguaribe'	23023	'Baixo Jaguaribe'
2311900	"SABOEIRO"	23	-39.9045806984177	-6.53643335248083	2304	'Sertões Cearenses'	23020	'Sertão de Inhamuns'
2311959	"SALITRE"	23	-40.46475206463	-7.28452868497372	2307	'Sul Cearense'	23029	'Chapada do Araripe'
2312205	"SANTA QUITERIA"	23	-40.153507813582	-4.3332705	2301	'Noroeste Cearense'	23007	'Santa Quitéria'
2312007	"SANTANA DO ACARAU"	23	-40.2094628598127	-3.45977534173113	2301	'Noroeste Cearense'	23005	'Sobral'
2312106	"SANTANA DO CARIRI"	23	-39.7379797815466	-7.18089778328218	2307	'Sul Cearense'	23032	'Cariri'
2312304	"SAO BENEDITO"	23	-40.8644898757611	-4.04472699	2301	'Noroeste Cearense'	23002	'Ibiapaba'
2312403	"SAO GONCALO DO AMARANTE"	23	-38.9720758652803	-3.6056325	2302	'Norte Cearense'	23009	'Baixo Curu'
2312502	"SAO JOAO DO JAGUARIBE"	23	-38.2719407043798	-5.26863055048591	2305	'Jaguaribe'	23023	'Baixo Jaguaribe'
2312601	"SAO LUIS DO CURU"	23	-39.2416061849713	-3.67300925322864	2302	'Norte Cearense'	23011	'Médio Curu'
2312700	"SENADOR POMPEU"	23	-39.3753253308417	-5.58934375213112	2304	'Sertões Cearenses'	23021	'Sertão de Senador Pompeu'
2312809	"SENADOR SA"	23	-40.4637920044145	-3.35178962803698	2301	'Noroeste Cearense'	23005	'Sobral'
2312908	"SOBRAL"	23	-40.3486680336582	-3.68803768376442	2301	'Noroeste Cearense'	23005	'Sobral'
2313005	"SOLONOPOLE"	23	-39.0082249132446	-5.72635129100783	2304	'Sertões Cearenses'	23021	'Sertão de Senador Pompeu'
2313104	"TABULEIRO DO NORTE"	23	-38.129737128172	-5.24380386987735	2305	'Jaguaribe'	23023	'Baixo Jaguaribe'
2313203	"TAMBORIL"	23	-40.319068513296	-4.83392858315588	2304	'Sertões Cearenses'	23018	'Sertão de Cratéus'
2313252	"TARRAFAS"	23	-39.7584941948653	-6.68259031473737	2306	'Centro-Sul Cearense'	23027	'Várzea Alegre'
2313302	"TAUA"	23	-40.2926246551049	-6.00299893985789	2304	'Sertões Cearenses'	23020	'Sertão de Inhamuns'
2313351	"TEJUCUOCA"	23	-39.5768263617106	-3.98971180859371	2302	'Norte Cearense'	23011	'Médio Curu'
2313401	"TIANGUA"	23	-40.9917056226916	-3.722674	2301	'Noroeste Cearense'	23002	'Ibiapaba'
2313500	"TRAIRI"	23	-39.272231872633	-3.26442016913387	2302	'Norte Cearense'	23008	'Itapipoca'
2313559	"TURURU"	23	-39.4343635369541	-3.59559523549983	2302	'Norte Cearense'	23010	'Uruburetama'
2313609	"UBAJARA"	23	-40.9071439279714	-3.84849143521655	2301	'Noroeste Cearense'	23002	'Ibiapaba'
2313708	"UMARI"	23	-38.7013257158543	-6.64724437520981	2306	'Centro-Sul Cearense'	23028	'Lavras da Mangabeira'
2313757	"UMIRIM"	23	-39.3423844042955	-3.67556189809805	2302	'Norte Cearense'	23010	'Uruburetama'
2313807	"URUBURETAMA"	23	-39.5081780697542	-3.62301683368172	2302	'Norte Cearense'	23010	'Uruburetama'
2313906	"URUOCA"	23	-40.5611630276796	-3.31323066042929	2301	'Noroeste Cearense'	23003	'Coreaú'
2313955	"VARJOTA"	23	-40.4789932740701	-4.18282228275994	2301	'Noroeste Cearense'	23006	'Ipu'
2314003	"VARZEA ALEGRE"	23	-39.2989329971137	-6.79184585564321	2306	'Centro-Sul Cearense'	23027	'Várzea Alegre'
2314102	"VICOSA DO CEARA"	23	-41.0916290750336	-3.56601275320063	2301	'Noroeste Cearense'	23002	'Ibiapaba'
5300108	"BRASILIA"	53	-47.8879054780313	-15.794087361891	5301	'Distrito Federal'	53001	'Brasília'
3200102	"AFONSO CLAUDIO"	32	-41.1254597171689	-20.0770400098969	3203	'Central Espírito-santense'	32007	'Afonso Cláudio'
3200169	"AGUA DOCE DO NORTE"	32	-40.976455911882	-18.5455464912766	3201	'Noroeste Espírito-santense'	32001	'Barra de São Francisco'
3200136	"AGUIA BRANCA"	32	-40.736638167375	-18.9873613695253	3201	'Noroeste Espírito-santense'	32002	'Nova Venécia'
3200201	"ALEGRE"	32	-41.5364883187663	-20.7632651351226	3204	'Sul Espírito-santense'	32011	'Alegre'
3200300	"ALFREDO CHAVES"	32	-40.7600496463911	-20.630347537232	3203	'Central Espírito-santense'	32010	'Guarapari'
3200359	"ALTO RIO NOVO"	32	-41.0186843433418	-19.0574996056204	3201	'Noroeste Espírito-santense'	32003	'Colatina'
3200409	"ANCHIETA"	32	-40.6476589422027	-20.8056132241888	3203	'Central Espírito-santense'	32010	'Guarapari'
3200508	"APIACA"	32	-41.5633797608618	-21.1564478852618	3204	'Sul Espírito-santense'	32012	'Cachoeiro de Itapemirim'
3200607	"ARACRUZ"	32	-40.2762233763624	-19.8232777404467	3202	'Litoral Norte Espírito-santense'	32006	'Linhares'
3200706	"ATILIO VIVACQUA"	32	-41.1912419094544	-20.9158966202099	3204	'Sul Espírito-santense'	32012	'Cachoeiro de Itapemirim'
3200805	"BAIXO GUANDU"	32	-41.0120677359012	-19.5142461286191	3201	'Noroeste Espírito-santense'	32003	'Colatina'
3200904	"BARRA DE SAO FRANCISCO"	32	-40.89039862396	-18.7590890533313	3201	'Noroeste Espírito-santense'	32001	'Barra de São Francisco'
3201001	"BOA ESPERANCA"	32	-40.3029556431013	-18.5387151622041	3201	'Noroeste Espírito-santense'	32002	'Nova Venécia'
3201100	"BOM JESUS DO NORTE"	32	-41.6758105077654	-21.129341788413	3204	'Sul Espírito-santense'	32012	'Cachoeiro de Itapemirim'
3201159	"BREJETUBA"	32	-41.2896765285112	-20.157034186191	3203	'Central Espírito-santense'	32007	'Afonso Cláudio'
3201209	"CACHOEIRO DE ITAPEMIRIM"	32	-41.1119188104426	-20.8501123496921	3204	'Sul Espírito-santense'	32012	'Cachoeiro de Itapemirim'
3201308	"CARIACICA"	32	-40.3905591046775	-20.2946777965171	3203	'Central Espírito-santense'	32009	'Vitória'
3201407	"CASTELO"	32	-41.2022127039763	-20.602065086052	3204	'Sul Espírito-santense'	32012	'Cachoeiro de Itapemirim'
3201506	"COLATINA"	32	-40.6303175540319	-19.5362700836217	3201	'Noroeste Espírito-santense'	32003	'Colatina'
3201605	"CONCEICAO DA BARRA"	32	-39.7274744194389	-18.5984623008997	3202	'Litoral Norte Espírito-santense'	32005	'São Mateus'
3201704	"CONCEICAO DO CASTELO"	32	-41.2453480411941	-20.3655811138099	3203	'Central Espírito-santense'	32007	'Afonso Cláudio'
3201803	"DIVINO DE SAO LOURENCO"	32	-41.6799763283207	-20.6204706518503	3204	'Sul Espírito-santense'	32011	'Alegre'
3201902	"DOMINGOS MARTINS"	32	-40.6593963545811	-20.3642385223786	3203	'Central Espírito-santense'	32007	'Afonso Cláudio'
3202009	"DORES DO RIO PRETO"	32	-41.8495773624823	-20.692893905303	3204	'Sul Espírito-santense'	32011	'Alegre'
3202108	"ECOPORANGA"	32	-40.8300811593362	-18.3752523795108	3201	'Noroeste Espírito-santense'	32001	'Barra de São Francisco'
3202207	"FUNDAO"	32	-40.4037654440298	-19.9334471176936	3202	'Litoral Norte Espírito-santense'	32006	'Linhares'
3202256	"GOVERNADOR LINDENBERG"	32	-40.4577660614079	-19.2528074444097	3201	'Noroeste Espírito-santense'	32003	'Colatina'
3202306	"GUACUI"	32	-41.6794962927473	-20.7753378052849	3204	'Sul Espírito-santense'	32011	'Alegre'
3202405	"GUARAPARI"	32	-40.4950210194579	-20.6659745796442	3203	'Central Espírito-santense'	32010	'Guarapari'
3202454	"IBATIBA"	32	-41.507207999498	-20.2340203462858	3204	'Sul Espírito-santense'	32011	'Alegre'
3202504	"IBIRACU"	32	-40.3716661788635	-19.8318799980722	3202	'Litoral Norte Espírito-santense'	32006	'Linhares'
3202553	"IBITIRAMA"	32	-41.6594124008597	-20.5387309665894	3204	'Sul Espírito-santense'	32011	'Alegre'
3202603	"ICONHA"	32	-40.8112210453371	-20.7971447538605	3203	'Central Espírito-santense'	32010	'Guarapari'
3202652	"IRUPI"	32	-41.6475278614673	-20.3485970392932	3204	'Sul Espírito-santense'	32011	'Alegre'
3202702	"ITAGUACU"	32	-40.8565984866284	-19.8025077112127	3203	'Central Espírito-santense'	32008	'Santa Teresa'
3202801	"ITAPEMIRIM"	32	-40.836145116845	-21.0110996272507	3204	'Sul Espírito-santense'	32013	'Itapemirim'
3202900	"ITARANA"	32	-40.8797910822261	-19.872348006049	3203	'Central Espírito-santense'	32008	'Santa Teresa'
3203007	"IUNA"	32	-41.5328886935213	-20.3485995137779	3204	'Sul Espírito-santense'	32011	'Alegre'
3203056	"JAGUARE"	32	-40.0861409923639	-18.9004359095214	3202	'Litoral Norte Espírito-santense'	32005	'São Mateus'
3203106	"JERONIMO MONTEIRO"	32	-41.4029345744706	-20.7976978982677	3204	'Sul Espírito-santense'	32012	'Cachoeiro de Itapemirim'
3203130	"JOAO NEIVA"	32	-40.3808804853377	-19.7529585988572	3202	'Litoral Norte Espírito-santense'	32006	'Linhares'
3203163	"LARANJA DA TERRA"	32	-41.0552443545224	-19.898693450439	3203	'Central Espírito-santense'	32007	'Afonso Cláudio'
3203205	"LINHARES"	32	-40.0653057986955	-19.3981059344649	3202	'Litoral Norte Espírito-santense'	32006	'Linhares'
3203304	"MANTENOPOLIS"	32	-41.117737478806	-18.8611789662472	3201	'Noroeste Espírito-santense'	32001	'Barra de São Francisco'
3203320	"MARATAIZES"	32	-40.8301872856744	-21.0429962752913	3204	'Sul Espírito-santense'	32013	'Itapemirim'
3203346	"MARECHAL FLORIANO"	32	-40.6803834328881	-20.4267085919717	3203	'Central Espírito-santense'	32007	'Afonso Cláudio'
3203353	"MARILANDIA"	32	-40.5509510036323	-19.4128127577518	3201	'Noroeste Espírito-santense'	32003	'Colatina'
3203403	"MIMOSO DO SUL"	32	-41.3644252658845	-21.0653735081717	3204	'Sul Espírito-santense'	32012	'Cachoeiro de Itapemirim'
3203502	"MONTANHA"	32	-40.3634208795715	-18.1268566471782	3202	'Litoral Norte Espírito-santense'	32004	'Montanha'
3203601	"MUCURICI"	32	-40.5179268365101	-18.097236379572	3202	'Litoral Norte Espírito-santense'	32004	'Montanha'
3203700	"MUNIZ FREIRE"	32	-41.417513780413	-20.4565455935268	3204	'Sul Espírito-santense'	32011	'Alegre'
3203809	"MUQUI"	32	-41.3462139983691	-20.9536923095423	3204	'Sul Espírito-santense'	32012	'Cachoeiro de Itapemirim'
3203908	"NOVA VENECIA"	32	-40.401547877017	-18.7129060016259	3201	'Noroeste Espírito-santense'	32002	'Nova Venécia'
3204005	"PANCAS"	32	-40.8560031007125	-19.2244197861321	3201	'Noroeste Espírito-santense'	32003	'Colatina'
3204054	"PEDRO CANARIO"	32	-39.9549369518726	-18.2971915038956	3202	'Litoral Norte Espírito-santense'	32005	'São Mateus'
3204104	"PINHEIROS"	32	-40.2177280801912	-18.413323343618	3202	'Litoral Norte Espírito-santense'	32004	'Montanha'
3204203	"PIUMA"	32	-40.7279809404286	-20.8376088996899	3203	'Central Espírito-santense'	32010	'Guarapari'
3204252	"PONTO BELO"	32	-40.538133777058	-18.1291260855312	3202	'Litoral Norte Espírito-santense'	32004	'Montanha'
3204302	"PRESIDENTE KENNEDY"	32	-41.0518956305895	-21.1001484084681	3204	'Sul Espírito-santense'	32013	'Itapemirim'
3204351	"RIO BANANAL"	32	-40.3224784282699	-19.2770864859237	3202	'Litoral Norte Espírito-santense'	32006	'Linhares'
3204401	"RIO NOVO DO SUL"	32	-40.9362283554512	-20.8645861496867	3203	'Central Espírito-santense'	32010	'Guarapari'
3204500	"SANTA LEOPOLDINA"	32	-40.5332096123378	-20.0988906924926	3203	'Central Espírito-santense'	32008	'Santa Teresa'
3204559	"SANTA MARIA DE JETIBA"	32	-40.7416178006497	-20.0288140581884	3203	'Central Espírito-santense'	32008	'Santa Teresa'
3204609	"SANTA TERESA"	32	-40.5989977217142	-19.9377143168607	3203	'Central Espírito-santense'	32008	'Santa Teresa'
3204658	"SAO DOMINGOS DO NORTE"	32	-40.621877732717	-19.1481685100059	3201	'Noroeste Espírito-santense'	32003	'Colatina'
3204708	"SAO GABRIEL DA PALHA"	32	-40.52959950756	-19.021964753249	3201	'Noroeste Espírito-santense'	32002	'Nova Venécia'
3204807	"SAO JOSE DO CALCADO"	32	-41.6560878498074	-21.0261302467275	3204	'Sul Espírito-santense'	32012	'Cachoeiro de Itapemirim'
3204906	"SAO MATEUS"	32	-39.8582005956105	-18.7184469678596	3202	'Litoral Norte Espírito-santense'	32005	'São Mateus'
3204955	"SAO ROQUE DO CANAA"	32	-40.6431387555474	-19.7253072048101	3203	'Central Espírito-santense'	32008	'Santa Teresa'
3205002	"SERRA"	32	-40.2752170367085	-20.1567698424317	3203	'Central Espírito-santense'	32009	'Vitória'
3205010	"SOORETAMA"	32	-40.0964908071322	-19.1919496278562	3202	'Litoral Norte Espírito-santense'	32006	'Linhares'
3205036	"VARGEM ALTA"	32	-41.0071483601644	-20.6716781987879	3204	'Sul Espírito-santense'	32012	'Cachoeiro de Itapemirim'
3205069	"VENDA NOVA DO IMIGRANTE"	32	-41.1290532110882	-20.3315181774343	3203	'Central Espírito-santense'	32007	'Afonso Cláudio'
3205101	"VIANA"	32	-40.4956243354911	-20.3908625111662	3203	'Central Espírito-santense'	32009	'Vitória'
3205150	"VILA PAVAO"	32	-40.6024114108213	-18.620803452346	3201	'Noroeste Espírito-santense'	32002	'Nova Venécia'
3205176	"VILA VALERIO"	32	-40.3905897774138	-18.9936174389143	3201	'Noroeste Espírito-santense'	32002	'Nova Venécia'
3205200	"VILA VELHA"	32	-40.2939566369471	-20.3383741042138	3203	'Central Espírito-santense'	32009	'Vitória'
3205309	"VITORIA"	32	-40.3222087267266	-20.3201537928533	3203	'Central Espírito-santense'	32009	'Vitória'
5200050	"ABADIA DE GOIAS"	52	-49.4405478326574	-16.7588118948196	5203	'Centro Goiano'	52010	'Goiânia'
5200100	"ABADIANIA"	52	-48.7188121416752	-16.1826718580048	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5200134	"ACREUNA"	52	-50.3749733666553	-17.3981562192276	5205	'Sul Goiano'	52014	'Vale do Rio dos Bois'
5200159	"ADELANDIA"	52	-50.1631466761094	-16.4150015120189	5203	'Centro Goiano'	52009	'Anicuns'
5200175	"AGUA FRIA DE GOIAS"	52	-47.7822121623989	-14.9855352682152	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5200209	"AGUA LIMPA"	52	-48.7612409591412	-18.0714060588379	5205	'Sul Goiano'	52015	'Meia Ponte'
5200258	"AGUAS LINDAS DE GOIAS"	52	-48.2834444362152	-15.7379388562832	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5200308	"ALEXANIA"	52	-48.5096363918634	-16.0861676205662	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5200506	"ALOANDIA"	52	-49.4823211066406	-17.7249088541556	5205	'Sul Goiano'	52015	'Meia Ponte'
5200555	"ALTO HORIZONTE"	52	-49.3327491561607	-14.1992268099335	5202	'Norte Goiano'	52004	'Porangatu'
5200605	"ALTO PARAISO DE GOIAS"	52	-47.5190934382788	-14.1362446377625	5202	'Norte Goiano'	52005	'Chapada dos Veadeiros'
5200803	"ALVORADA DO NORTE"	52	-46.51563769131	-14.4828391105338	5204	'Leste Goiano'	52011	'Vão do Paranã'
5200829	"AMARALINA"	52	-49.2953772219036	-13.9254818594186	5202	'Norte Goiano'	52004	'Porangatu'
5200852	"AMERICANO DO BRASIL"	52	-49.9836415337481	-16.2551002852464	5203	'Centro Goiano'	52009	'Anicuns'
5200902	"AMORINOPOLIS"	52	-51.097167066995	-16.6179121241589	5203	'Centro Goiano'	52008	'Iporá'
5201108	"ANAPOLIS"	52	-48.9572179026313	-16.3288257446492	5203	'Centro Goiano'	52007	'Anápolis'
5201207	"ANHANGUERA"	52	-48.2174036920944	-18.334366032323	5205	'Sul Goiano'	52017	'Catalão'
5201306	"ANICUNS"	52	-49.9590680177593	-16.4607406192493	5203	'Centro Goiano'	52009	'Anicuns'
5201405	"APARECIDA DE GOIANIA"	52	-49.2433259277011	-16.8221465	5203	'Centro Goiano'	52010	'Goiânia'
5201454	"APARECIDA DO RIO DOCE"	52	-51.1514916271733	-18.2969842878477	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5201504	"APORE"	52	-51.928072999929	-18.9588774471471	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5201603	"ARACU"	52	-49.6816820506526	-16.3543348065301	5203	'Centro Goiano'	52007	'Anápolis'
5201702	"ARAGARCAS"	52	-52.2468547307811	-15.8977681654152	5201	'Noroeste Goiano'	52003	'Aragarças'
5201801	"ARAGOIANIA"	52	-49.4509030547984	-16.9156395993745	5203	'Centro Goiano'	52010	'Goiânia'
5202155	"ARAGUAPAZ"	52	-50.6347424117136	-15.0885303703699	5201	'Noroeste Goiano'	52002	'Rio Vermelho'
5202353	"ARENOPOLIS"	52	-51.5600294917897	-16.3875456188786	5201	'Noroeste Goiano'	52003	'Aragarças'
5202502	"ARUANA"	52	-51.0808851466972	-14.90333238046	5201	'Noroeste Goiano'	52002	'Rio Vermelho'
5202601	"AURILANDIA"	52	-50.4647657585302	-16.6767252917239	5203	'Centro Goiano'	52009	'Anicuns'
5202809	"AVELINOPOLIS"	52	-49.7542258382107	-16.4619386944645	5203	'Centro Goiano'	52009	'Anicuns'
5203104	"BALIZA"	52	-52.5427449421297	-16.2016366664348	5201	'Noroeste Goiano'	52003	'Aragarças'
5203203	"BARRO ALTO"	52	-48.9157070788234	-14.9737085965343	5203	'Centro Goiano'	52006	'Ceres'
5203302	"BELA VISTA DE GOIAS"	52	-48.9524115974734	-16.9731214373005	5203	'Centro Goiano'	52010	'Goiânia'
5203401	"BOM JARDIM DE GOIAS"	52	-52.1753675713712	-16.2006850337108	5201	'Noroeste Goiano'	52003	'Aragarças'
5203500	"BOM JESUS DE GOIAS"	52	-49.7394106514873	-18.2147665091834	5205	'Sul Goiano'	52015	'Meia Ponte'
5203559	"BONFINOPOLIS"	52	-48.9705799425652	-16.6175284340698	5203	'Centro Goiano'	52010	'Goiânia'
5203575	"BONOPOLIS"	52	-49.8371838013902	-13.6497465485671	5202	'Norte Goiano'	52004	'Porangatu'
5203609	"BRAZABRANTES"	52	-49.3886672746655	-16.4257149363233	5203	'Centro Goiano'	52007	'Anápolis'
5203807	"BRITANIA"	52	-51.1672851018916	-15.2385862943788	5201	'Noroeste Goiano'	52002	'Rio Vermelho'
5203906	"BURITI ALEGRE"	52	-49.0400651408771	-18.1330550495739	5205	'Sul Goiano'	52015	'Meia Ponte'
5203939	"BURITI DE GOIAS"	52	-50.4344347563621	-16.1813969764783	5203	'Centro Goiano'	52009	'Anicuns'
5203962	"BURITINOPOLIS"	52	-46.4310771148915	-14.4560230273582	5204	'Leste Goiano'	52011	'Vão do Paranã'
5204003	"CABECEIRAS"	52	-46.9294761862946	-15.8011558822358	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5204102	"CACHOEIRA ALTA"	52	-50.9447078424788	-18.7510044618506	5205	'Sul Goiano'	52018	'Quirinópolis'
5204201	"CACHOEIRA DE GOIAS"	52	-50.6431478383131	-16.6667328024555	5203	'Centro Goiano'	52008	'Iporá'
5204250	"CACHOEIRA DOURADA"	52	-49.4709176635814	-18.4890356139803	5205	'Sul Goiano'	52015	'Meia Ponte'
5204300	"CACU"	52	-51.13352861362	-18.5630506239039	5205	'Sul Goiano'	52018	'Quirinópolis'
5204409	"CAIAPONIA"	52	-51.8094797771314	-16.9534576703657	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5204508	"CALDAS NOVAS"	52	-48.621197474689	-17.7435388676728	5205	'Sul Goiano'	52015	'Meia Ponte'
5204557	"CALDAZINHA"	52	-49.0033734590288	-16.7147769438059	5203	'Centro Goiano'	52010	'Goiânia'
5204607	"CAMPESTRE DE GOIAS"	52	-49.6955342614038	-16.7623092239645	5205	'Sul Goiano'	52014	'Vale do Rio dos Bois'
5204656	"CAMPINACU"	52	-48.5698343277658	-13.7863485878978	5202	'Norte Goiano'	52004	'Porangatu'
5204706	"CAMPINORTE"	52	-49.1563472947914	-14.3105979559882	5202	'Norte Goiano'	52004	'Porangatu'
5204805	"CAMPO ALEGRE DE GOIAS"	52	-47.7782251013376	-17.6405551366126	5205	'Sul Goiano'	52017	'Catalão'
5204854	"CAMPO LIMPO DE GOIAS"	52	-49.0899365208448	-16.2986230067008	5203	'Centro Goiano'	52007	'Anápolis'
5204904	"CAMPOS BELOS"	52	-46.7707832966078	-13.0367239866584	5202	'Norte Goiano'	52005	'Chapada dos Veadeiros'
5204953	"CAMPOS VERDES"	52	-49.6632651125087	-14.2732669562185	5202	'Norte Goiano'	52004	'Porangatu'
5205000	"CARMO DO RIO VERDE"	52	-49.7028649780144	-15.3577136637698	5203	'Centro Goiano'	52006	'Ceres'
5205059	"CASTELANDIA"	52	-50.2292504517447	-18.0898452373216	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5205109	"CATALAO"	52	-47.9477032172158	-18.1695733634179	5205	'Sul Goiano'	52017	'Catalão'
5205208	"CATURAI"	52	-49.5028529990414	-16.4467615884306	5203	'Centro Goiano'	52007	'Anápolis'
5205307	"CAVALCANTE"	52	-47.463436194172	-13.7992785141945	5202	'Norte Goiano'	52005	'Chapada dos Veadeiros'
5205406	"CERES"	52	-49.6033462318309	-15.3070283354002	5203	'Centro Goiano'	52006	'Ceres'
5205455	"CEZARINA"	52	-49.7731689820683	-16.9677922829026	5205	'Sul Goiano'	52014	'Vale do Rio dos Bois'
5205471	"CHAPADAO DO CEU"	52	-52.6708005984179	-18.3940322027156	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5205497	"CIDADE OCIDENTAL"	52	-47.9371306539447	-16.1109591976501	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5205513	"COCALZINHO DE GOIAS"	52	-48.768967447569	-15.7817370135149	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5205521	"COLINAS DO SUL"	52	-48.0768431325587	-14.1501851952808	5202	'Norte Goiano'	52005	'Chapada dos Veadeiros'
5205703	"CORREGO DO OURO"	52	-50.5558190730691	-16.2953575521383	5203	'Centro Goiano'	52008	'Iporá'
5205802	"CORUMBA DE GOIAS"	52	-48.8103450571615	-15.9279051540032	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5205901	"CORUMBAIBA"	52	-48.5561020698988	-18.1369060848451	5205	'Sul Goiano'	52017	'Catalão'
5206206	"CRISTALINA"	52	-47.6068175922326	-16.7694336631642	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5206305	"CRISTIANOPOLIS"	52	-48.7122976533102	-17.1955889543854	5205	'Sul Goiano'	52016	'Pires do Rio'
5206404	"CRIXAS"	52	-49.9672039392423	-14.5375902550292	5201	'Noroeste Goiano'	52001	'São Miguel do Araguaia'
5206503	"CROMINIA"	52	-49.3805054797548	-17.2818549268211	5205	'Sul Goiano'	52015	'Meia Ponte'
5206602	"CUMARI"	52	-48.1566767810345	-18.2613822982099	5205	'Sul Goiano'	52017	'Catalão'
5206701	"DAMIANOPOLIS"	52	-46.1735358095694	-14.5574350508893	5204	'Leste Goiano'	52011	'Vão do Paranã'
5206800	"DAMOLANDIA"	52	-49.3611056454839	-16.254801619746	5203	'Centro Goiano'	52007	'Anápolis'
5206909	"DAVINOPOLIS"	52	-47.5593683925586	-18.1585643378909	5205	'Sul Goiano'	52017	'Catalão'
5207105	"DIORAMA"	52	-51.258893073177	-16.2317085200356	5201	'Noroeste Goiano'	52003	'Aragarças'
5208301	"DIVINOPOLIS DE GOIAS"	52	-46.3938887513768	-13.2968133668957	5204	'Leste Goiano'	52011	'Vão do Paranã'
5207253	"DOVERLANDIA"	52	-52.3139804233096	-16.7210370624643	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5207352	"EDEALINA"	52	-49.6646951088956	-17.4228916982466	5205	'Sul Goiano'	52014	'Vale do Rio dos Bois'
5207402	"EDEIA"	52	-49.9344239559036	-17.3380800331194	5205	'Sul Goiano'	52014	'Vale do Rio dos Bois'
5207501	"ESTRELA DO NORTE"	52	-49.0734010835998	-13.8670273952048	5202	'Norte Goiano'	52004	'Porangatu'
5207535	"FAINA"	52	-50.3687036599486	-15.4428687832321	5201	'Noroeste Goiano'	52002	'Rio Vermelho'
5207600	"FAZENDA NOVA"	52	-50.7873644001456	-16.1775143289682	5203	'Centro Goiano'	52008	'Iporá'
5207808	"FIRMINOPOLIS"	52	-50.3036343394174	-16.5764612335216	5203	'Centro Goiano'	52009	'Anicuns'
5207907	"FLORES DE GOIAS"	52	-47.0450829249731	-14.4501741366926	5204	'Leste Goiano'	52011	'Vão do Paranã'
5208004	"FORMOSA"	52	-47.3358155764676	-15.540944627683	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5208103	"FORMOSO"	52	-48.8880896723124	-13.6557801485826	5202	'Norte Goiano'	52004	'Porangatu'
5208152	"GAMELEIRA DE GOIAS"	52	-48.6457054930611	-16.4827366321438	5205	'Sul Goiano'	52016	'Pires do Rio'
5208400	"GOIANAPOLIS"	52	-49.0173421790322	-16.5006821667021	5203	'Centro Goiano'	52010	'Goiânia'
5208509	"GOIANDIRA"	52	-48.0884713741385	-18.1326246743773	5205	'Sul Goiano'	52017	'Catalão'
5208608	"GOIANESIA"	52	-49.1158101507745	-15.3222887524883	5203	'Centro Goiano'	52006	'Ceres'
5208707	"GOIANIA"	52	-49.2558142758158	-16.6733097738389	5203	'Centro Goiano'	52010	'Goiânia'
5208806	"GOIANIRA"	52	-49.4287772736105	-16.5031915591775	5203	'Centro Goiano'	52010	'Goiânia'
5208905	"GOIAS"	52	-50.1413841443018	-15.9357427010732	5201	'Noroeste Goiano'	52002	'Rio Vermelho'
5209101	"GOIATUBA"	52	-49.3666434695635	-18.0106332403567	5205	'Sul Goiano'	52015	'Meia Ponte'
5209150	"GOUVELANDIA"	52	-50.1379987972883	-18.4382785343916	5205	'Sul Goiano'	52018	'Quirinópolis'
5209200	"GUAPO"	52	-49.5367333643017	-16.8313227580374	5203	'Centro Goiano'	52010	'Goiânia'
5209291	"GUARAITA"	52	-50.0317779844947	-15.6294278846087	5203	'Centro Goiano'	52006	'Ceres'
5209408	"GUARANI DE GOIAS"	52	-46.4803757074661	-13.9389114968643	5204	'Leste Goiano'	52011	'Vão do Paranã'
5209457	"GUARINOS"	52	-49.701188130376	-14.7337403887433	5203	'Centro Goiano'	52006	'Ceres'
5209606	"HEITORAI"	52	-49.8293395924293	-15.7202164219726	5203	'Centro Goiano'	52007	'Anápolis'
5209705	"HIDROLANDIA"	52	-49.2297840436263	-16.9609447714124	5203	'Centro Goiano'	52010	'Goiânia'
5209804	"HIDROLINA"	52	-49.4598974466229	-14.7276582892576	5203	'Centro Goiano'	52006	'Ceres'
5209903	"IACIARA"	52	-46.631967793967	-14.1008175253214	5204	'Leste Goiano'	52011	'Vão do Paranã'
5209937	"INACIOLANDIA"	52	-49.9875784505859	-18.4863548297405	5205	'Sul Goiano'	52015	'Meia Ponte'
5209952	"INDIARA"	52	-49.9890531950284	-17.1372613100831	5205	'Sul Goiano'	52014	'Vale do Rio dos Bois'
5210000	"INHUMAS"	52	-49.5002245065799	-16.3599604740426	5203	'Centro Goiano'	52007	'Anápolis'
5210109	"IPAMERI"	52	-48.1586676782561	-17.7221768121534	5205	'Sul Goiano'	52017	'Catalão'
5210158	"IPIRANGA DE GOIAS"	52	-49.66740512088	-15.1720118940704	5203	'Centro Goiano'	52006	'Ceres'
5210208	"IPORA"	52	-51.1195950892158	-16.4400026707082	5203	'Centro Goiano'	52008	'Iporá'
5210307	"ISRAELANDIA"	52	-50.9034397149487	-16.3128012448907	5203	'Centro Goiano'	52008	'Iporá'
5210406	"ITABERAI"	52	-49.8034793740214	-16.0211302070027	5203	'Centro Goiano'	52007	'Anápolis'
5210562	"ITAGUARI"	52	-49.6097600443052	-15.909093570601	5203	'Centro Goiano'	52007	'Anápolis'
5210604	"ITAGUARU"	52	-49.6320512064225	-15.7637943882195	5203	'Centro Goiano'	52007	'Anápolis'
5210802	"ITAJA"	52	-51.5446839593993	-19.0622350464855	5205	'Sul Goiano'	52018	'Quirinópolis'
5210901	"ITAPACI"	52	-49.5541561136132	-14.9504032179387	5203	'Centro Goiano'	52006	'Ceres'
5211008	"ITAPIRAPUA"	52	-50.6091628273289	-15.818862494157	5201	'Noroeste Goiano'	52002	'Rio Vermelho'
5211206	"ITAPURANGA"	52	-49.9444934167904	-15.5623312456785	5203	'Centro Goiano'	52006	'Ceres'
5211305	"ITARUMA"	52	-51.348889900608	-18.7616602284422	5205	'Sul Goiano'	52018	'Quirinópolis'
5211404	"ITAUCU"	52	-49.6011340852738	-16.2033472311635	5203	'Centro Goiano'	52007	'Anápolis'
5211503	"ITUMBIARA"	52	-49.220870075038	-18.4176824715349	5205	'Sul Goiano'	52015	'Meia Ponte'
5211602	"IVOLANDIA"	52	-50.7947013663514	-16.6034027617672	5203	'Centro Goiano'	52008	'Iporá'
5211701	"JANDAIA"	52	-50.1480076360605	-17.0494211395482	5205	'Sul Goiano'	52014	'Vale do Rio dos Bois'
5211800	"JARAGUA"	52	-49.3301439342367	-15.7531137828783	5203	'Centro Goiano'	52007	'Anápolis'
5211909	"JATAI"	52	-51.7208180375605	-17.8862323338404	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5212006	"JAUPACI"	52	-50.9517191424873	-16.1780359315247	5203	'Centro Goiano'	52008	'Iporá'
5212055	"JESUPOLIS"	52	-49.3762189275273	-15.9515976078315	5203	'Centro Goiano'	52007	'Anápolis'
5212105	"JOVIANIA"	52	-49.629939809589	-17.8071094520717	5205	'Sul Goiano'	52015	'Meia Ponte'
5212204	"JUSSARA"	52	-50.8661265899967	-15.8663489233335	5201	'Noroeste Goiano'	52002	'Rio Vermelho'
5212253	"LAGOA SANTA"	52	-51.4046158469187	-19.1836069808173	5205	'Sul Goiano'	52018	'Quirinópolis'
5212303	"LEOPOLDO DE BULHOES"	52	-48.7464523369563	-16.6189649329137	5203	'Centro Goiano'	52010	'Goiânia'
5212501	"LUZIANIA"	52	-47.9557200567595	-16.258541	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5212600	"MAIRIPOTABA"	52	-49.5008802854382	-17.2973954688586	5205	'Sul Goiano'	52015	'Meia Ponte'
5212709	"MAMBAI"	52	-46.1139474126744	-14.4875342642037	5204	'Leste Goiano'	52011	'Vão do Paranã'
5212808	"MARA ROSA"	52	-49.1798231432443	-14.00856889567	5202	'Norte Goiano'	52004	'Porangatu'
5212907	"MARZAGAO"	52	-48.6371735788677	-17.9816102558339	5205	'Sul Goiano'	52015	'Meia Ponte'
5212956	"MATRINCHA"	52	-50.7464743435777	-15.437188316997	5201	'Noroeste Goiano'	52002	'Rio Vermelho'
5213004	"MAURILANDIA"	52	-50.3389113971531	-17.9720829886462	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5213053	"MIMOSO DE GOIAS"	52	-48.1632731159377	-15.0592934915695	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5213087	"MINACU"	52	-48.2239076238009	-13.5350936496024	5202	'Norte Goiano'	52004	'Porangatu'
5213103	"MINEIROS"	52	-52.5546671879349	-17.5661675714878	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5213400	"MOIPORA"	52	-50.7360975398747	-16.546899884094	5203	'Centro Goiano'	52008	'Iporá'
5213509	"MONTE ALEGRE DE GOIAS"	52	-46.8857991383548	-13.2573260767063	5202	'Norte Goiano'	52005	'Chapada dos Veadeiros'
5213707	"MONTES CLAROS DE GOIAS"	52	-51.4004988846889	-16.0047599101006	5201	'Noroeste Goiano'	52003	'Aragarças'
5213756	"MONTIVIDIU"	52	-51.1751445984875	-17.4444620017218	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5213772	"MONTIVIDIU DO NORTE"	52	-48.688822123885	-13.353094256586	5202	'Norte Goiano'	52004	'Porangatu'
5213806	"MORRINHOS"	52	-49.1101770718855	-17.7352710999441	5205	'Sul Goiano'	52015	'Meia Ponte'
5213855	"MORRO AGUDO DE GOIAS"	52	-50.0574471319424	-15.3121981483209	5203	'Centro Goiano'	52006	'Ceres'
5213905	"MOSSAMEDES"	52	-50.2180496713251	-16.1196542993227	5203	'Centro Goiano'	52009	'Anicuns'
5214002	"MOZARLANDIA"	52	-50.5702136123584	-14.7475894763559	5201	'Noroeste Goiano'	52001	'São Miguel do Araguaia'
5214051	"MUNDO NOVO"	52	-50.2856877224896	-13.765576924048	5201	'Noroeste Goiano'	52001	'São Miguel do Araguaia'
5214101	"MUTUNOPOLIS"	52	-49.2744452473581	-13.7236105818189	5202	'Norte Goiano'	52004	'Porangatu'
5214408	"NAZARIO"	52	-49.8819882317251	-16.5805280796717	5203	'Centro Goiano'	52009	'Anicuns'
5214507	"NEROPOLIS"	52	-49.224462526185	-16.4040436842355	5203	'Centro Goiano'	52010	'Goiânia'
5214606	"NIQUELANDIA"	52	-48.4585851494733	-14.4691101441778	5202	'Norte Goiano'	52004	'Porangatu'
5214705	"NOVA AMERICA"	52	-49.8993153993298	-15.0183858596303	5203	'Centro Goiano'	52006	'Ceres'
5214804	"NOVA AURORA"	52	-48.2604579069233	-18.0651021012103	5205	'Sul Goiano'	52017	'Catalão'
5214838	"NOVA CRIXAS"	52	-50.3420003319155	-14.0956114307068	5201	'Noroeste Goiano'	52001	'São Miguel do Araguaia'
5214861	"NOVA GLORIA"	52	-49.5787847002581	-15.1492765853624	5203	'Centro Goiano'	52006	'Ceres'
5214879	"NOVA IGUACU DE GOIAS"	52	-49.3907701087405	-14.2834774149336	5202	'Norte Goiano'	52004	'Porangatu'
5214903	"NOVA ROMA"	52	-46.8903259703719	-13.7429057520921	5202	'Norte Goiano'	52005	'Chapada dos Veadeiros'
5215009	"NOVA VENEZA"	52	-49.3108981042099	-16.3652331930827	5203	'Centro Goiano'	52007	'Anápolis'
5215207	"NOVO BRASIL"	52	-50.7163144530646	-16.032670860267	5203	'Centro Goiano'	52008	'Iporá'
5215231	"NOVO GAMA"	52	-48.0372112741246	-16.0560782141982	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5215256	"NOVO PLANALTO"	52	-49.512050299192	-13.2409519765795	5201	'Noroeste Goiano'	52001	'São Miguel do Araguaia'
5215306	"ORIZONA"	52	-48.3021478029846	-17.0347660176056	5205	'Sul Goiano'	52016	'Pires do Rio'
5215405	"OURO VERDE DE GOIAS"	52	-49.2038676027847	-16.210827654498	5203	'Centro Goiano'	52007	'Anápolis'
5215504	"OUVIDOR"	52	-47.8326044040217	-18.2255687121879	5205	'Sul Goiano'	52017	'Catalão'
5215603	"PADRE BERNARDO"	52	-48.2859656163306	-15.16435542	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5215652	"PALESTINA DE GOIAS"	52	-51.5300322006929	-16.7414317725853	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5215702	"PALMEIRAS DE GOIAS"	52	-49.9227871292957	-16.8069880059216	5205	'Sul Goiano'	52014	'Vale do Rio dos Bois'
5215801	"PALMELO"	52	-48.4230955764225	-17.3230168517086	5205	'Sul Goiano'	52016	'Pires do Rio'
5215900	"PALMINOPOLIS"	52	-50.1654937516465	-16.7991350225567	5205	'Sul Goiano'	52014	'Vale do Rio dos Bois'
5216007	"PANAMA"	52	-49.3534819159218	-18.1824552757032	5205	'Sul Goiano'	52015	'Meia Ponte'
5216304	"PARANAIGUARA"	52	-50.6522043595986	-18.905159859907	5205	'Sul Goiano'	52018	'Quirinópolis'
5216403	"PARAUNA"	52	-50.4576405930576	-16.9466970092766	5205	'Sul Goiano'	52014	'Vale do Rio dos Bois'
5216452	"PEROLANDIA"	52	-52.06657724961	-17.5264535228648	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5216809	"PETROLINA DE GOIAS"	52	-49.338797936091	-16.0974175745694	5203	'Centro Goiano'	52007	'Anápolis'
5216908	"PILAR DE GOIAS"	52	-49.575114312765	-14.7660904485041	5203	'Centro Goiano'	52006	'Ceres'
5217104	"PIRACANJUBA"	52	-49.0245603471275	-17.3018097158009	5205	'Sul Goiano'	52015	'Meia Ponte'
5217203	"PIRANHAS"	52	-51.8218013359508	-16.420706440486	5201	'Noroeste Goiano'	52003	'Aragarças'
5217302	"PIRENOPOLIS"	52	-48.9625271926179	-15.8533422975454	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5217401	"PIRES DO RIO"	52	-48.2802925533446	-17.3005811055154	5205	'Sul Goiano'	52016	'Pires do Rio'
5217609	"PLANALTINA"	52	-47.6148467661508	-15.4531095649744	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5217708	"PONTALINA"	52	-49.448181016169	-17.5149844214861	5205	'Sul Goiano'	52015	'Meia Ponte'
5218003	"PORANGATU"	52	-49.1462260518879	-13.4421859466224	5202	'Norte Goiano'	52004	'Porangatu'
5218052	"PORTEIRAO"	52	-50.1642504168683	-17.8154006298882	5205	'Sul Goiano'	52015	'Meia Ponte'
5218102	"PORTELANDIA"	52	-52.680683543854	-17.3529241047143	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5218300	"POSSE"	52	-46.3620104423077	-14.0877335642249	5204	'Leste Goiano'	52011	'Vão do Paranã'
5218391	"PROFESSOR JAMIL"	52	-49.2366973073337	-17.2475666832404	5205	'Sul Goiano'	52015	'Meia Ponte'
5218508	"QUIRINOPOLIS"	52	-50.4522625218091	-18.4515073558847	5205	'Sul Goiano'	52018	'Quirinópolis'
5218607	"RIALMA"	52	-49.5843695086837	-15.3154039732359	5203	'Centro Goiano'	52006	'Ceres'
5218706	"RIANAPOLIS"	52	-49.5101169941166	-15.4424666682603	5203	'Centro Goiano'	52006	'Ceres'
5218789	"RIO QUENTE"	52	-48.7726682958329	-17.7677458121661	5205	'Sul Goiano'	52015	'Meia Ponte'
5218805	"RIO VERDE"	52	-50.9296809301732	-17.7945434019057	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5218904	"RUBIATABA"	52	-49.8034096971441	-15.1643127537172	5203	'Centro Goiano'	52006	'Ceres'
5219001	"SANCLERLANDIA"	52	-50.3158669330706	-16.2006630828726	5203	'Centro Goiano'	52009	'Anicuns'
5219100	"SANTA BARBARA DE GOIAS"	52	-49.6897833771126	-16.5774759289558	5203	'Centro Goiano'	52009	'Anicuns'
5219209	"SANTA CRUZ DE GOIAS"	52	-48.476689757667	-17.3215530231462	5205	'Sul Goiano'	52016	'Pires do Rio'
5219258	"SANTA FE DE GOIAS"	52	-51.1094159480253	-15.7707845628319	5201	'Noroeste Goiano'	52002	'Rio Vermelho'
5219308	"SANTA HELENA DE GOIAS"	52	-50.5984432624214	-17.8123551401385	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5219357	"SANTA ISABEL"	52	-49.4281779495791	-15.3023982428053	5203	'Centro Goiano'	52006	'Ceres'
5219407	"SANTA RITA DO ARAGUAIA"	52	-53.2051465107986	-17.3263507863191	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5219456	"SANTA RITA DO NOVO DESTINO"	52	-49.1201255263389	-15.1353910970642	5203	'Centro Goiano'	52006	'Ceres'
5219506	"SANTA ROSA DE GOIAS"	52	-49.491579173178	-16.0798908614537	5203	'Centro Goiano'	52007	'Anápolis'
5219605	"SANTA TEREZA DE GOIAS"	52	-49.0149969464435	-13.7125508671121	5202	'Norte Goiano'	52004	'Porangatu'
5219704	"SANTA TEREZINHA DE GOIAS"	52	-49.7062022411161	-14.4334764202998	5202	'Norte Goiano'	52004	'Porangatu'
5219712	"SANTO ANTONIO DA BARRA"	52	-50.6340535808077	-17.5561082964935	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5219738	"SANTO ANTONIO DE GOIAS"	52	-49.3102428569283	-16.483121215036	5203	'Centro Goiano'	52010	'Goiânia'
5219753	"SANTO ANTONIO DO DESCOBERTO"	52	-48.2560064258403	-15.94422351	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5219803	"SAO DOMINGOS"	52	-46.3151052424492	-13.402013257213	5204	'Leste Goiano'	52011	'Vão do Paranã'
5219902	"SAO FRANCISCO DE GOIAS"	52	-49.2620087204189	-15.9227064368289	5203	'Centro Goiano'	52007	'Anápolis'
5220058	"SAO JOAO DA PARAUNA"	52	-50.40506299254	-16.8145235535214	5205	'Sul Goiano'	52014	'Vale do Rio dos Bois'
5220009	"SAO JOAO D'ALIANCA"	52	-47.5188017123423	-14.7082161796638	5202	'Norte Goiano'	52005	'Chapada dos Veadeiros'
5220108	"SAO LUIS DE MONTES BELOS"	52	-50.3742880027313	-16.51981015978	5203	'Centro Goiano'	52009	'Anicuns'
5220157	"SAO LUIZ DO NORTE"	52	-49.3319358805783	-14.8620789113103	5203	'Centro Goiano'	52006	'Ceres'
5220207	"SAO MIGUEL DO ARAGUAIA"	52	-50.1638382701425	-13.2760243429645	5201	'Noroeste Goiano'	52001	'São Miguel do Araguaia'
5220264	"SAO MIGUEL DO PASSA QUATRO"	52	-48.6647175593758	-17.0509343499312	5205	'Sul Goiano'	52016	'Pires do Rio'
5220280	"SAO PATRICIO"	52	-49.8163460404831	-15.3524896722037	5203	'Centro Goiano'	52006	'Ceres'
5220405	"SAO SIMAO"	52	-50.5496997576566	-18.9897385995163	5205	'Sul Goiano'	52018	'Quirinópolis'
5220454	"SENADOR CANEDO"	52	-49.0879668327789	-16.71857532	5203	'Centro Goiano'	52010	'Goiânia'
5220504	"SERRANOPOLIS"	52	-51.957777940175	-18.307724397145	5205	'Sul Goiano'	52013	'Sudoeste de Goiás'
5220603	"SILVANIA"	52	-48.6105699100182	-16.6646168096505	5205	'Sul Goiano'	52016	'Pires do Rio'
5220686	"SIMOLANDIA"	52	-46.4842842225005	-14.4703229883122	5204	'Leste Goiano'	52011	'Vão do Paranã'
5220702	"SITIO D'ABADIA"	52	-46.2524898428401	-14.8039939161548	5204	'Leste Goiano'	52011	'Vão do Paranã'
5221007	"TAQUARAL DE GOIAS"	52	-49.6022193143577	-16.0500187966169	5203	'Centro Goiano'	52007	'Anápolis'
5221080	"TERESINA DE GOIAS"	52	-47.2635203210208	-13.776863099648	5202	'Norte Goiano'	52005	'Chapada dos Veadeiros'
5221197	"TEREZOPOLIS DE GOIAS"	52	-49.0917849230921	-16.4789604613737	5203	'Centro Goiano'	52010	'Goiânia'
5221304	"TRES RANCHOS"	52	-47.7793385108656	-18.3607986884177	5205	'Sul Goiano'	52017	'Catalão'
5221403	"TRINDADE"	52	-49.4890992025778	-16.6553504288294	5203	'Centro Goiano'	52010	'Goiânia'
5221452	"TROMBAS"	52	-48.7447086103352	-13.5084677212691	5202	'Norte Goiano'	52004	'Porangatu'
5221502	"TURVANIA"	52	-50.1319530546499	-16.6098037804966	5203	'Centro Goiano'	52009	'Anicuns'
5221551	"TURVELANDIA"	52	-50.3074793439396	-17.8509523354152	5205	'Sul Goiano'	52014	'Vale do Rio dos Bois'
5221577	"UIRAPURU"	52	-49.9210751817802	-14.288653538562	5201	'Noroeste Goiano'	52001	'São Miguel do Araguaia'
5221601	"URUACU"	52	-49.1474856222181	-14.5202197628247	5202	'Norte Goiano'	52004	'Porangatu'
5221700	"URUANA"	52	-49.6794807087689	-15.5011652333766	5203	'Centro Goiano'	52006	'Ceres'
5221809	"URUTAI"	52	-48.204653131644	-17.4597534245575	5205	'Sul Goiano'	52016	'Pires do Rio'
5221858	"VALPARAISO DE GOIAS"	52	-47.9841113505533	-16.0695752570385	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5221908	"VARJAO"	52	-49.6281674870259	-17.0412247517589	5205	'Sul Goiano'	52014	'Vale do Rio dos Bois'
5222005	"VIANOPOLIS"	52	-48.5134708970577	-16.7420814386658	5205	'Sul Goiano'	52016	'Pires do Rio'
5222054	"VICENTINOPOLIS"	52	-49.807239013854	-17.732662380299	5205	'Sul Goiano'	52015	'Meia Ponte'
5222203	"VILA BOA"	52	-47.0573608536835	-15.0348887907102	5204	'Leste Goiano'	52012	'Entorno de Brasília'
5222302	"VILA PROPICIO"	52	-48.8824220764979	-15.4546348167753	5204	'Leste Goiano'	52012	'Entorno de Brasília'
2100055	"ACAILANDIA"	21	-47.5066645931119	-4.95137700016248	2102	'Oeste Maranhense'	21009	'Imperatriz'
2100105	"AFONSO CUNHA"	21	-43.3208690039685	-4.13501547687008	2104	'Leste Maranhense'	21016	'Coelho Neto'
2100154	"AGUA DOCE DO MARANHAO"	21	-42.1155512017213	-2.84027827913681	2104	'Leste Maranhense'	21013	'Baixo Parnaíba Maranhense'
2100204	"ALCANTARA"	21	-44.4170125372846	-2.40327652507917	2101	'Norte Maranhense'	21001	'Litoral Ocidental Maranhense'
2100303	"ALDEIAS ALTAS"	21	-43.4687348529398	-4.63077949515206	2104	'Leste Maranhense'	21016	'Coelho Neto'
2100402	"ALTAMIRA DO MARANHAO"	21	-45.4646758311604	-4.16226926685315	2102	'Oeste Maranhense'	21008	'Pindaré'
2100436	"ALTO ALEGRE DO MARANHAO"	21	-44.4482474945232	-4.207227	2104	'Leste Maranhense'	21015	'Codó'
2100477	"ALTO ALEGRE DO PINDARE"	21	-45.8420796161705	-3.66517037445328	2102	'Oeste Maranhense'	21008	'Pindaré'
2100501	"ALTO PARNAIBA"	21	-45.9273440133384	-9.10836593219112	2105	'Sul Maranhense'	21020	'Gerais de Balsas'
2100550	"AMAPA DO MARANHAO"	21	-46.0091799003875	-1.68092149512179	2102	'Oeste Maranhense'	21007	'Gurupi'
2100600	"AMARANTE DO MARANHAO"	21	-46.7506375454972	-5.55766200018214	2102	'Oeste Maranhense'	21009	'Imperatriz'
2100709	"ANAJATUBA"	21	-44.6206700277629	-3.25755484212724	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2100808	"ANAPURUS"	21	-43.1057925096893	-3.66703466234686	2104	'Leste Maranhense'	21014	'Chapadinha'
2100832	"APICUM-ACU"	21	-45.0766520734486	-1.53059157775486	2101	'Norte Maranhense'	21001	'Litoral Ocidental Maranhense'
2100873	"ARAGUANA"	21	-45.6687944761006	-2.94912562327705	2102	'Oeste Maranhense'	21008	'Pindaré'
2100907	"ARAIOSES"	21	-41.8991394498654	-2.88925584643306	2104	'Leste Maranhense'	21013	'Baixo Parnaíba Maranhense'
2100956	"ARAME"	21	-46.0136362778351	-4.886081505	2103	'Centro Maranhense'	21011	'Alto Mearim e Grajaú'
2101004	"ARARI"	21	-44.7788346547106	-3.45917097011381	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2101103	"AXIXA"	21	-44.0545858090773	-2.83779683713212	2101	'Norte Maranhense'	21003	'Rosário'
2101202	"BACABAL"	21	-44.7815559640891	-4.23152462978051	2103	'Centro Maranhense'	21010	'Médio Mearim'
2101251	"BACABEIRA"	21	-44.3154229865671	-2.98582477877569	2101	'Norte Maranhense'	21003	'Rosário'
2101301	"BACURI"	21	-45.1373489396265	-1.72404631847323	2101	'Norte Maranhense'	21001	'Litoral Ocidental Maranhense'
2101350	"BACURITUBA"	21	-44.7357420061579	-2.71087197652061	2101	'Norte Maranhense'	21001	'Litoral Ocidental Maranhense'
2101400	"BALSAS"	21	-46.0389926733405	-7.53116999024552	2105	'Sul Maranhense'	21020	'Gerais de Balsas'
2101509	"BARAO DE GRAJAU"	21	-43.0264526994269	-6.75895520558046	2104	'Leste Maranhense'	21018	'Chapadas do Alto Itapecuru'
2101608	"BARRA DO CORDA"	21	-45.239011016111	-5.5083395	2103	'Centro Maranhense'	21011	'Alto Mearim e Grajaú'
2101707	"BARREIRINHAS"	21	-42.8278025132041	-2.75008594875811	2101	'Norte Maranhense'	21004	'Lençóis Maranhenses'
2101772	"BELA VISTA DO MARANHAO"	21	-45.2482458781849	-3.73773324990828	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2101731	"BELAGUA"	21	-43.510061642741	-3.15677222752965	2104	'Leste Maranhense'	21014	'Chapadinha'
2101806	"BENEDITO LEITE"	21	-44.5598567990095	-7.2187997953852	2105	'Sul Maranhense'	21021	'Chapadas das Mangabeiras'
2101905	"BEQUIMAO"	21	-44.7857301568673	-2.4620629950811	2101	'Norte Maranhense'	21001	'Litoral Ocidental Maranhense'
2101939	"BERNARDO DO MEARIM"	21	-44.7643231034878	-4.63028749079229	2103	'Centro Maranhense'	21010	'Médio Mearim'
2101970	"BOA VISTA DO GURUPI"	21	-46.2987100525274	-1.79329613579879	2102	'Oeste Maranhense'	21007	'Gurupi'
2102002	"BOM JARDIM"	21	-45.6018893890511	-3.54416097785572	2102	'Oeste Maranhense'	21008	'Pindaré'
2102036	"BOM JESUS DAS SELVAS"	21	-46.8532412231489	-4.48996835310692	2102	'Oeste Maranhense'	21008	'Pindaré'
2102077	"BOM LUGAR"	21	-45.0311078563238	-4.37550960146424	2103	'Centro Maranhense'	21010	'Médio Mearim'
2102101	"BREJO"	21	-42.7508478268196	-3.679178	2104	'Leste Maranhense'	21014	'Chapadinha'
2102150	"BREJO DE AREIA"	21	-45.5820952717813	-4.33062989749501	2102	'Oeste Maranhense'	21008	'Pindaré'
2102200	"BURITI"	21	-42.9251061777803	-3.9455715	2104	'Leste Maranhense'	21014	'Chapadinha'
2102309	"BURITI BRAVO"	21	-43.8356215415106	-5.83528813214674	2104	'Leste Maranhense'	21017	'Caxias'
2102325	"BURITICUPU"	21	-46.451495319051	-4.32594772630155	2102	'Oeste Maranhense'	21008	'Pindaré'
2102358	"BURITIRANA"	21	-47.0172250932177	-5.58891514171156	2102	'Oeste Maranhense'	21009	'Imperatriz'
2102374	"CACHOEIRA GRANDE"	21	-44.0596850157832	-2.93192103905761	2101	'Norte Maranhense'	21003	'Rosário'
2102408	"CAJAPIO"	21	-44.6733771645862	-2.88288220315752	2101	'Norte Maranhense'	21001	'Litoral Ocidental Maranhense'
2102507	"CAJARI"	21	-45.0079653349663	-3.32386883091692	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2102556	"CAMPESTRE DO MARANHAO"	21	-47.3676328633342	-6.16471664583519	2105	'Sul Maranhense'	21019	'Porto Franco'
2102606	"CANDIDO MENDES"	21	-45.7372683655917	-1.453889108528	2102	'Oeste Maranhense'	21007	'Gurupi'
2102705	"CANTANHEDE"	21	-44.381816135839	-3.62836431187274	2101	'Norte Maranhense'	21006	'Itapecuru Mirim'
2102754	"CAPINZAL DO NORTE"	21	-44.3304362519955	-4.7212453887722	2104	'Leste Maranhense'	21015	'Codó'
2102804	"CAROLINA"	21	-47.4700918028279	-7.33078300523913	2105	'Sul Maranhense'	21019	'Porto Franco'
2102903	"CARUTAPERA"	21	-46.023150834605	-1.200602	2102	'Oeste Maranhense'	21007	'Gurupi'
2103000	"CAXIAS"	21	-43.3585394285192	-4.86167499015957	2104	'Leste Maranhense'	21017	'Caxias'
2103109	"CEDRAL"	21	-44.5307895278055	-1.99791592557159	2101	'Norte Maranhense'	21001	'Litoral Ocidental Maranhense'
2103125	"CENTRAL DO MARANHAO"	21	-44.8318437024986	-2.19131390761778	2101	'Norte Maranhense'	21001	'Litoral Ocidental Maranhense'
2103158	"CENTRO DO GUILHERME"	21	-46.0399601131872	-2.4569850818082	2102	'Oeste Maranhense'	21007	'Gurupi'
2103174	"CENTRO NOVO DO MARANHAO"	21	-46.1284089549781	-2.14429169855839	2102	'Oeste Maranhense'	21007	'Gurupi'
2103208	"CHAPADINHA"	21	-43.361120781752	-3.74002452	2104	'Leste Maranhense'	21014	'Chapadinha'
2103257	"CIDELANDIA"	21	-47.7842327756716	-5.17742104721159	2102	'Oeste Maranhense'	21009	'Imperatriz'
2103307	"CODO"	21	-43.8860802350324	-4.45133750014621	2104	'Leste Maranhense'	21015	'Codó'
2103406	"COELHO NETO"	21	-43.0140136155495	-4.25473750013981	2104	'Leste Maranhense'	21016	'Coelho Neto'
2103505	"COLINAS"	21	-44.2497802305352	-6.02736552019732	2104	'Leste Maranhense'	21018	'Chapadas do Alto Itapecuru'
2103554	"CONCEICAO DO LAGO-ACU"	21	-44.9030159051796	-3.84111845785575	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2103604	"COROATA"	21	-44.1255992014644	-4.128976	2104	'Leste Maranhense'	21015	'Codó'
2103703	"CURURUPU"	21	-44.8677616169761	-1.8255207812193	2101	'Norte Maranhense'	21001	'Litoral Ocidental Maranhense'
2103752	"DAVINOPOLIS"	21	-47.4049963875281	-5.53445621610635	2102	'Oeste Maranhense'	21009	'Imperatriz'
2103802	"DOM PEDRO"	21	-44.4400099109689	-5.03844763516531	2103	'Centro Maranhense'	21012	'Presidente Dutra'
2103901	"DUQUE BACELAR"	21	-42.9441802036073	-4.14781909711357	2104	'Leste Maranhense'	21016	'Coelho Neto'
2104008	"ESPERANTINOPOLIS"	21	-44.8860686990188	-4.87030089747643	2103	'Centro Maranhense'	21010	'Médio Mearim'
2104057	"ESTREITO"	21	-47.4478829861377	-6.56808498021472	2105	'Sul Maranhense'	21019	'Porto Franco'
2104073	"FEIRA NOVA DO MARANHAO"	21	-46.6873552159638	-6.96313554062729	2105	'Sul Maranhense'	21020	'Gerais de Balsas'
2104081	"FERNANDO FALCAO"	21	-44.9107074022131	-6.154978462916	2103	'Centro Maranhense'	21011	'Alto Mearim e Grajaú'
2104099	"FORMOSA DA SERRA NEGRA"	21	-46.1863570068861	-6.43530410561392	2103	'Centro Maranhense'	21011	'Alto Mearim e Grajaú'
2104107	"FORTALEZA DOS NOGUEIRAS"	21	-46.1855575419836	-6.9659260874923	2105	'Sul Maranhense'	21021	'Chapadas das Mangabeiras'
2104206	"FORTUNA"	21	-44.1606284272259	-5.73622413247702	2103	'Centro Maranhense'	21012	'Presidente Dutra'
2104305	"GODOFREDO VIANA"	21	-45.7717548080523	-1.40980018673278	2102	'Oeste Maranhense'	21007	'Gurupi'
2104404	"GONCALVES DIAS"	21	-44.3059065359375	-5.14395556946104	2103	'Centro Maranhense'	21012	'Presidente Dutra'
2104503	"GOVERNADOR ARCHER"	21	-44.2757565261253	-5.02538782392684	2103	'Centro Maranhense'	21012	'Presidente Dutra'
2104552	"GOVERNADOR EDISON LOBAO"	21	-47.3689358390373	-5.74741173851254	2102	'Oeste Maranhense'	21009	'Imperatriz'
2104602	"GOVERNADOR EUGENIO BARROS"	21	-44.2469626460204	-5.32249100152954	2103	'Centro Maranhense'	21012	'Presidente Dutra'
2104628	"GOVERNADOR LUIZ ROCHA"	21	-44.0708873355169	-5.47286468491781	2103	'Centro Maranhense'	21012	'Presidente Dutra'
2104651	"GOVERNADOR NEWTON BELLO"	21	-45.6745017970093	-3.42970471990357	2102	'Oeste Maranhense'	21008	'Pindaré'
2104677	"GOVERNADOR NUNES FREIRE"	21	-45.8814811327942	-2.13496236	2102	'Oeste Maranhense'	21007	'Gurupi'
2104701	"GRACA ARANHA"	21	-44.33579125992	-5.40482121305463	2103	'Centro Maranhense'	21012	'Presidente Dutra'
2104800	"GRAJAU"	21	-46.1423956359934	-5.81854843133104	2103	'Centro Maranhense'	21011	'Alto Mearim e Grajaú'
2104909	"GUIMARAES"	21	-44.5977464563371	-2.13507715838452	2101	'Norte Maranhense'	21001	'Litoral Ocidental Maranhense'
2105005	"HUMBERTO DE CAMPOS"	21	-43.4650921443146	-2.59122397226084	2101	'Norte Maranhense'	21004	'Lençóis Maranhenses'
2105104	"ICATU"	21	-44.06584846864	-2.77482786309925	2101	'Norte Maranhense'	21003	'Rosário'
2105153	"IGARAPE DO MEIO"	21	-45.1833277021706	-3.63670852186543	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2105203	"IGARAPE GRANDE"	21	-44.8674033458603	-4.66085380623745	2103	'Centro Maranhense'	21010	'Médio Mearim'
2105302	"IMPERATRIZ"	21	-47.4798108057682	-5.52652402518114	2102	'Oeste Maranhense'	21009	'Imperatriz'
2105351	"ITAIPAVA DO GRAJAU"	21	-45.792682503469	-5.1445822617698	2103	'Centro Maranhense'	21011	'Alto Mearim e Grajaú'
2105401	"ITAPECURU MIRIM"	21	-44.354263390434	-3.39904548011184	2101	'Norte Maranhense'	21006	'Itapecuru Mirim'
2105427	"ITINGA DO MARANHAO"	21	-47.5279099637574	-4.45500399844588	2102	'Oeste Maranhense'	21009	'Imperatriz'
2105450	"JATOBA"	21	-44.2199147698158	-5.81966693677504	2104	'Leste Maranhense'	21018	'Chapadas do Alto Itapecuru'
2105476	"JENIPAPO DOS VIEIRAS"	21	-45.6333791074203	-5.36942492643339	2103	'Centro Maranhense'	21011	'Alto Mearim e Grajaú'
2105500	"JOAO LISBOA"	21	-47.4050361497684	-5.45366294155917	2102	'Oeste Maranhense'	21009	'Imperatriz'
2105609	"JOSELANDIA"	21	-44.6991525645005	-4.97269332894745	2103	'Centro Maranhense'	21011	'Alto Mearim e Grajaú'
2105658	"JUNCO DO MARANHAO"	21	-46.0707260732137	-1.87460959750276	2102	'Oeste Maranhense'	21007	'Gurupi'
2105708	"LAGO DA PEDRA"	21	-45.1258913559145	-4.564744515	2102	'Oeste Maranhense'	21008	'Pindaré'
2105807	"LAGO DO JUNCO"	21	-45.0513443921165	-4.60764321768366	2103	'Centro Maranhense'	21010	'Médio Mearim'
2105948	"LAGO DOS RODRIGUES"	21	-44.9764423255877	-4.61237577693148	2103	'Centro Maranhense'	21010	'Médio Mearim'
2105906	"LAGO VERDE"	21	-44.9376352319942	-4.03871129527666	2103	'Centro Maranhense'	21010	'Médio Mearim'
2105922	"LAGOA DO MATO"	21	-43.5275591165627	-6.04527729657082	2104	'Leste Maranhense'	21018	'Chapadas do Alto Itapecuru'
2105963	"LAGOA GRANDE DO MARANHAO"	21	-45.3906142793613	-4.99312373713713	2102	'Oeste Maranhense'	21008	'Pindaré'
2105989	"LAJEADO NOVO"	21	-47.0324475171004	-6.19160922666686	2102	'Oeste Maranhense'	21009	'Imperatriz'
2106003	"LIMA CAMPOS"	21	-44.4693403292236	-4.51704598721753	2103	'Centro Maranhense'	21010	'Médio Mearim'
2106102	"LORETO"	21	-45.1392416375273	-7.09445416538222	2105	'Sul Maranhense'	21021	'Chapadas das Mangabeiras'
2106201	"LUIS DOMINGUES"	21	-45.8953319920784	-1.32546024435309	2102	'Oeste Maranhense'	21007	'Gurupi'
2106300	"MAGALHAES DE ALMEIDA"	21	-42.2015066913751	-3.3966676742208	2104	'Leste Maranhense'	21013	'Baixo Parnaíba Maranhense'
2106326	"MARACACUME"	21	-45.9586390371679	-2.05616454951514	2102	'Oeste Maranhense'	21007	'Gurupi'
2106359	"MARAJA DO SENA"	21	-45.4572376525781	-4.62031332412411	2102	'Oeste Maranhense'	21008	'Pindaré'
2106375	"MARANHAOZINHO"	21	-45.8556114548668	-2.235616992076	2102	'Oeste Maranhense'	21007	'Gurupi'
2106409	"MATA ROMA"	21	-43.1203894235718	-3.61904550989372	2104	'Leste Maranhense'	21014	'Chapadinha'
2106508	"MATINHA"	21	-45.0364289401062	-3.09840003	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2106607	"MATOES"	21	-43.201208282913	-5.52246501943405	2104	'Leste Maranhense'	21017	'Caxias'
2106631	"MATOES DO NORTE"	21	-44.5502445069402	-3.62751878021672	2101	'Norte Maranhense'	21006	'Itapecuru Mirim'
2106672	"MILAGRES DO MARANHAO"	21	-42.6107528325103	-3.58220664139805	2104	'Leste Maranhense'	21014	'Chapadinha'
2106706	"MIRADOR"	21	-44.3626097938789	-6.37756569538775	2104	'Leste Maranhense'	21018	'Chapadas do Alto Itapecuru'
2106755	"MIRANDA DO NORTE"	21	-44.5842756917321	-3.56264477442983	2101	'Norte Maranhense'	21006	'Itapecuru Mirim'
2106805	"MIRINZAL"	21	-44.7857559864783	-2.06422419159107	2101	'Norte Maranhense'	21001	'Litoral Ocidental Maranhense'
2106904	"MONCAO"	21	-45.2475846706441	-3.49393248	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2107001	"MONTES ALTOS"	21	-47.0704395080146	-5.82856250416417	2102	'Oeste Maranhense'	21009	'Imperatriz'
2107100	"MORROS"	21	-44.0445445431756	-2.86147895308791	2101	'Norte Maranhense'	21003	'Rosário'
2107209	"NINA RODRIGUES"	21	-43.9044847603497	-3.46246428944702	2101	'Norte Maranhense'	21006	'Itapecuru Mirim'
2107258	"NOVA COLINAS"	21	-46.2593252229153	-7.12056600356251	2105	'Sul Maranhense'	21021	'Chapadas das Mangabeiras'
2107308	"NOVA IORQUE"	21	-44.0486267271013	-6.73320330579158	2104	'Leste Maranhense'	21018	'Chapadas do Alto Itapecuru'
2107357	"NOVA OLINDA DO MARANHAO"	21	-45.7045360408348	-2.79988654406012	2102	'Oeste Maranhense'	21008	'Pindaré'
2107407	"OLHO D'AGUA DAS CUNHAS"	21	-45.1195796205	-4.13727592980541	2103	'Centro Maranhense'	21010	'Médio Mearim'
2107456	"OLINDA NOVA DO MARANHAO"	21	-45.0032353744727	-2.99747761540954	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2107506	"PACO DO LUMIAR"	21	-44.0986923548404	-2.528063	2101	'Norte Maranhense'	21002	'Aglomeração Urbana de São Luís'
2107605	"PALMEIRANDIA"	21	-44.9044638923101	-2.64777427826389	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2107704	"PARAIBANO"	21	-43.9857620488226	-6.43182541413892	2104	'Leste Maranhense'	21018	'Chapadas do Alto Itapecuru'
2107803	"PARNARAMA"	21	-43.0904013534702	-5.6844671764059	2104	'Leste Maranhense'	21017	'Caxias'
2107902	"PASSAGEM FRANCA"	21	-43.781745225862	-6.17399442555871	2104	'Leste Maranhense'	21018	'Chapadas do Alto Itapecuru'
2108009	"PASTOS BONS"	21	-44.0886025133719	-6.60402773206398	2104	'Leste Maranhense'	21018	'Chapadas do Alto Itapecuru'
2108058	"PAULINO NEVES"	21	-42.5454239809374	-2.71820598982708	2101	'Norte Maranhense'	21004	'Lençóis Maranhenses'
2108108	"PAULO RAMOS"	21	-45.2399800047299	-4.44795676593636	2102	'Oeste Maranhense'	21008	'Pindaré'
2108207	"PEDREIRAS"	21	-44.6037348763271	-4.56935068809905	2103	'Centro Maranhense'	21010	'Médio Mearim'
2108256	"PEDRO DO ROSARIO"	21	-45.3464537341416	-2.96811467267822	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2108306	"PENALVA"	21	-45.1764616887688	-3.29323331776922	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2108405	"PERI MIRIM"	21	-44.8502907000589	-2.57305464850608	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2108454	"PERITORO"	21	-44.3258535239149	-4.37022511765711	2104	'Leste Maranhense'	21015	'Codó'
2108504	"PINDARE-MIRIM"	21	-45.3468679178433	-3.60550057491389	2102	'Oeste Maranhense'	21008	'Pindaré'
2108603	"PINHEIRO"	21	-45.0839266012938	-2.5227405	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2108702	"PIO XII"	21	-45.169960388665	-3.88758753012782	2103	'Centro Maranhense'	21010	'Médio Mearim'
2108801	"PIRAPEMAS"	21	-44.2282808838415	-3.72532906611683	2101	'Norte Maranhense'	21006	'Itapecuru Mirim'
2108900	"POCAO DE PEDRAS"	21	-44.9515514003151	-4.75002521124495	2103	'Centro Maranhense'	21010	'Médio Mearim'
2109007	"PORTO FRANCO"	21	-47.3821649019193	-6.35418186391414	2105	'Sul Maranhense'	21019	'Porto Franco'
2109056	"PORTO RICO DO MARANHAO"	21	-44.5837478895568	-1.85722321484413	2101	'Norte Maranhense'	21001	'Litoral Ocidental Maranhense'
2109106	"PRESIDENTE DUTRA"	21	-44.4929188624246	-5.28237425775883	2103	'Centro Maranhense'	21012	'Presidente Dutra'
2109205	"PRESIDENTE JUSCELINO"	21	-44.0767794214185	-2.92822924614922	2101	'Norte Maranhense'	21003	'Rosário'
2109239	"PRESIDENTE MEDICI"	21	-45.8207086475539	-2.38366404653914	2102	'Oeste Maranhense'	21008	'Pindaré'
2109270	"PRESIDENTE SARNEY"	21	-45.3713022606449	-2.59553055990599	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2109304	"PRESIDENTE VARGAS"	21	-44.0334018673342	-3.40201152220656	2101	'Norte Maranhense'	21006	'Itapecuru Mirim'
2109403	"PRIMEIRA CRUZ"	21	-43.4424433046987	-2.51058317196358	2101	'Norte Maranhense'	21004	'Lençóis Maranhenses'
2109452	"RAPOSA"	21	-44.1025161642031	-2.41507490262868	2101	'Norte Maranhense'	21002	'Aglomeração Urbana de São Luís'
2109502	"RIACHAO"	21	-46.6233501429074	-7.36456500024021	2105	'Sul Maranhense'	21020	'Gerais de Balsas'
2109551	"RIBAMAR FIQUENE"	21	-47.3834777870799	-5.93382285881857	2102	'Oeste Maranhense'	21009	'Imperatriz'
2109601	"ROSARIO"	21	-44.2475185952615	-2.941543035	2101	'Norte Maranhense'	21003	'Rosário'
2109700	"SAMBAIBA"	21	-45.3442031980139	-7.13835089749796	2105	'Sul Maranhense'	21021	'Chapadas das Mangabeiras'
2109759	"SANTA FILOMENA DO MARANHAO"	21	-44.5637140401312	-5.4997668067221	2103	'Centro Maranhense'	21011	'Alto Mearim e Grajaú'
2109809	"SANTA HELENA"	21	-45.3051611932379	-2.23453250892676	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2109908	"SANTA INES"	21	-45.3782724523024	-3.65857452	2102	'Oeste Maranhense'	21008	'Pindaré'
2110005	"SANTA LUZIA"	21	-45.6650117249372	-3.968391465	2102	'Oeste Maranhense'	21008	'Pindaré'
2110039	"SANTA LUZIA DO PARUA"	21	-45.7764615615901	-2.54616147481491	2102	'Oeste Maranhense'	21008	'Pindaré'
2110104	"SANTA QUITERIA DO MARANHAO"	21	-42.5628730097352	-3.49848499511509	2104	'Leste Maranhense'	21013	'Baixo Parnaíba Maranhense'
2110203	"SANTA RITA"	21	-44.3199480818757	-3.13411676567102	2101	'Norte Maranhense'	21003	'Rosário'
2110237	"SANTANA DO MARANHAO"	21	-42.4007677571893	-3.11306834278169	2104	'Leste Maranhense'	21013	'Baixo Parnaíba Maranhense'
2110278	"SANTO AMARO DO MARANHAO"	21	-43.2552849422448	-2.5027211989687	2101	'Norte Maranhense'	21004	'Lençóis Maranhenses'
2110302	"SANTO ANTONIO DOS LOPES"	21	-44.3614474338019	-4.87381957559703	2103	'Centro Maranhense'	21010	'Médio Mearim'
2110401	"SAO BENEDITO DO RIO PRETO"	21	-43.5299918701629	-3.33276600373026	2104	'Leste Maranhense'	21014	'Chapadinha'
2110500	"SAO BENTO"	21	-44.8283451799242	-2.6970075	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2110609	"SAO BERNARDO"	21	-42.4230096609141	-3.36543651011074	2104	'Leste Maranhense'	21013	'Baixo Parnaíba Maranhense'
2110658	"SAO DOMINGOS DO AZEITAO"	21	-44.6504239102536	-6.80442500975138	2105	'Sul Maranhense'	21021	'Chapadas das Mangabeiras'
2110708	"SAO DOMINGOS DO MARANHAO"	21	-44.3928792568666	-5.5656420001824	2103	'Centro Maranhense'	21012	'Presidente Dutra'
2110807	"SAO FELIX DE BALSAS"	21	-44.8114476614751	-7.08468515424976	2105	'Sul Maranhense'	21021	'Chapadas das Mangabeiras'
2110856	"SAO FRANCISCO DO BREJAO"	21	-47.3911373985947	-5.13020078716627	2102	'Oeste Maranhense'	21009	'Imperatriz'
2110906	"SAO FRANCISCO DO MARANHAO"	21	-42.8653217275577	-6.2527979166509	2104	'Leste Maranhense'	21018	'Chapadas do Alto Itapecuru'
2111003	"SAO JOAO BATISTA"	21	-44.8117618530648	-2.95333291245805	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2111029	"SAO JOAO DO CARU"	21	-46.2549254827263	-3.56080340686086	2102	'Oeste Maranhense'	21008	'Pindaré'
2111052	"SAO JOAO DO PARAISO"	21	-47.0506104204952	-6.46622228636398	2105	'Sul Maranhense'	21019	'Porto Franco'
2111078	"SAO JOAO DO SOTER"	21	-43.8181817951061	-5.11573926436997	2104	'Leste Maranhense'	21017	'Caxias'
2111102	"SAO JOAO DOS PATOS"	21	-43.7029101657958	-6.4982081521098	2104	'Leste Maranhense'	21018	'Chapadas do Alto Itapecuru'
2111201	"SAO JOSE DE RIBAMAR"	21	-44.0575481150532	-2.55585852	2101	'Norte Maranhense'	21002	'Aglomeração Urbana de São Luís'
2111250	"SAO JOSE DOS BASILIOS"	21	-44.5824465175581	-5.04868724515117	2103	'Centro Maranhense'	21012	'Presidente Dutra'
2111300	"SAO LUIS"	21	-44.2979185642444	-2.53188598508339	2101	'Norte Maranhense'	21002	'Aglomeração Urbana de São Luís'
2111409	"SAO LUIS GONZAGA DO MARANHAO"	21	-44.6627084964498	-4.37391849056593	2103	'Centro Maranhense'	21010	'Médio Mearim'
2111508	"SAO MATEUS DO MARANHAO"	21	-44.4685628110946	-4.03455051013262	2103	'Centro Maranhense'	21010	'Médio Mearim'
2111532	"SAO PEDRO DA AGUA BRANCA"	21	-48.4236235936456	-5.08891099740741	2102	'Oeste Maranhense'	21009	'Imperatriz'
2111573	"SAO PEDRO DOS CRENTES"	21	-46.5325803473698	-6.82855564083835	2105	'Sul Maranhense'	21019	'Porto Franco'
2111607	"SAO RAIMUNDO DAS MANGABEIRAS"	21	-45.4848314302202	-7.02696265716848	2105	'Sul Maranhense'	21021	'Chapadas das Mangabeiras'
2111631	"SAO RAIMUNDO DO DOCA BEZERRA"	21	-45.0841627902783	-5.10318184489716	2103	'Centro Maranhense'	21010	'Médio Mearim'
2111672	"SAO ROBERTO"	21	-44.9919011592934	-5.01736688238089	2103	'Centro Maranhense'	21010	'Médio Mearim'
2111706	"SAO VICENTE FERRER"	21	-44.8869045766146	-2.89073106437795	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2111722	"SATUBINHA"	21	-45.2336295762481	-4.03573549481028	2103	'Centro Maranhense'	21010	'Médio Mearim'
2111748	"SENADOR ALEXANDRE COSTA"	21	-44.056301506417	-5.26107654438389	2103	'Centro Maranhense'	21012	'Presidente Dutra'
2111763	"SENADOR LA ROCQUE"	21	-47.2891914239822	-5.44183249517839	2102	'Oeste Maranhense'	21009	'Imperatriz'
2111789	"SERRANO DO MARANHAO"	21	-45.1146408497435	-1.85264554172752	2101	'Norte Maranhense'	21001	'Litoral Ocidental Maranhense'
2111805	"SITIO NOVO"	21	-46.6949833406808	-5.87062989131234	2103	'Centro Maranhense'	21011	'Alto Mearim e Grajaú'
2111904	"SUCUPIRA DO NORTE"	21	-44.1886027051903	-6.47828444762036	2104	'Leste Maranhense'	21018	'Chapadas do Alto Itapecuru'
2111953	"SUCUPIRA DO RIACHAO"	21	-43.5458533208452	-6.42010840512647	2104	'Leste Maranhense'	21018	'Chapadas do Alto Itapecuru'
2112001	"TASSO FRAGOSO"	21	-45.7441235175102	-8.47983101786688	2105	'Sul Maranhense'	21020	'Gerais de Balsas'
2112100	"TIMBIRAS"	21	-43.9384339738391	-4.253840505	2104	'Leste Maranhense'	21015	'Codó'
2112209	"TIMON"	21	-42.8337278988597	-5.10068111012935	2104	'Leste Maranhense'	21017	'Caxias'
2112233	"TRIZIDELA DO VALE"	21	-44.6106851966461	-4.57012685660997	2103	'Centro Maranhense'	21010	'Médio Mearim'
2112274	"TUFILANDIA"	21	-45.6339164756818	-3.6764041183838	2102	'Oeste Maranhense'	21008	'Pindaré'
2112308	"TUNTUM"	21	-44.6490121516647	-5.24965554	2103	'Centro Maranhense'	21011	'Alto Mearim e Grajaú'
2112407	"TURIACU"	21	-45.3691524172241	-1.66902204768173	2102	'Oeste Maranhense'	21007	'Gurupi'
2112456	"TURILANDIA"	21	-45.30676531197	-2.22883352495052	2102	'Oeste Maranhense'	21007	'Gurupi'
2112506	"TUTOIA"	21	-42.2768472076943	-2.76355019688869	2101	'Norte Maranhense'	21004	'Lençóis Maranhenses'
2112605	"URBANO SANTOS"	21	-43.4042484723562	-3.20840949958587	2104	'Leste Maranhense'	21014	'Chapadinha'
2112704	"VARGEM GRANDE"	21	-43.9166644901652	-3.54189600011652	2101	'Norte Maranhense'	21006	'Itapecuru Mirim'
2112803	"VIANA"	21	-45.0013066952616	-3.21456251306625	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
2112852	"VILA NOVA DOS MARTIRIOS"	21	-48.138926482601	-5.18351151920427	2102	'Oeste Maranhense'	21009	'Imperatriz'
2112902	"VITORIA DO MEARIM"	21	-44.8695722405589	-3.48204736454661	2101	'Norte Maranhense'	21005	'Baixada Maranhense'
3100104	"ABADIA DOS DOURADOS"	31	-47.3968324406222	-18.487564958939	3105	'Triângulo Mineiro/Alto Paranaíba'	31019	'Patrocínio'
3100203	"ABAETE"	31	-45.4461914172049	-19.1558476941445	3106	'Central Mineira'	31024	'Três Marias'
3100302	"ABRE CAMPO"	31	-42.4809899866789	-20.3014452838404	3112	'Zona da Mata'	31061	'Manhuaçu'
3100401	"ACAIACA"	31	-43.1482389018347	-20.3604089312558	3112	'Zona da Mata'	31060	'Ponte Nova'
3100500	"ACUCENA"	31	-42.5462108797345	-19.0767128936334	3108	'Vale do Rio Doce'	31039	'Ipatinga'
3100609	"AGUA BOA"	31	-42.3896432300847	-17.9910530496416	3108	'Vale do Rio Doce'	31036	'Peçanha'
3100708	"AGUA COMPRIDA"	31	-48.1080767741672	-20.0593124134427	3105	'Triângulo Mineiro/Alto Paranaíba'	31022	'Uberaba'
3100807	"AGUANIL"	31	-45.3894653434948	-20.9374322025454	3109	'Oeste de Minas'	31045	'Campo Belo'
3100906	"AGUAS FORMOSAS"	31	-40.9352279398691	-17.0823043195567	3104	'Vale do Mucuri'	31016	'Nanuque'
3101003	"AGUAS VERMELHAS"	31	-41.45878830412	-15.7453199451695	3102	'Norte de Minas'	31005	'Salinas'
3101102	"AIMORES"	31	-41.0733274627961	-19.4919501492683	3108	'Vale do Rio Doce'	31041	'Aimorés'
3101201	"AIURUOCA"	31	-44.6028244646276	-21.9758966559157	3110	'Sul/Sudoeste de Minas'	31055	'Andrelândia'
3101300	"ALAGOA"	31	-44.6380988671778	-22.1711356644334	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3101409	"ALBERTINA"	31	-46.6116025733674	-22.1997644819049	3110	'Sul/Sudoeste de Minas'	31051	'Poços de Caldas'
3101508	"ALEM PARAIBA"	31	-42.6959466024573	-21.8768037118642	3112	'Zona da Mata'	31066	'Cataguases'
3101607	"ALFENAS"	31	-45.9489181992359	-21.4281781229191	3110	'Sul/Sudoeste de Minas'	31049	'Alfenas'
3101631	"ALFREDO VASCONCELOS"	31	-43.7738899527392	-21.1394234648344	3111	'Campo das Vertentes'	31059	'Barbacena'
3101706	"ALMENARA"	31	-40.6976511832513	-16.1806161743577	3103	'Jequitinhonha'	31014	'Almenara'
3101805	"ALPERCATA"	31	-41.9891291115954	-18.986831256466	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3101904	"ALPINOPOLIS"	31	-46.3894825347688	-20.8618546557469	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3102001	"ALTEROSA"	31	-46.1453205614697	-21.2558699519209	3110	'Sul/Sudoeste de Minas'	31049	'Alfenas'
3102050	"ALTO CAPARAO"	31	-41.873083740031	-20.4443611209763	3112	'Zona da Mata'	31061	'Manhuaçu'
3153509	"ALTO JEQUITIBA"	31	-41.967175112677	-20.4229271109286	3112	'Zona da Mata'	31061	'Manhuaçu'
3102100	"ALTO RIO DOCE"	31	-43.41887066418	-21.0221461475547	3112	'Zona da Mata'	31062	'Viçosa'
3102209	"ALVARENGA"	31	-41.7264422739295	-19.4144696868442	3108	'Vale do Rio Doce'	31041	'Aimorés'
3102308	"ALVINOPOLIS"	31	-43.0660832381092	-20.1147634823643	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3102407	"ALVORADA DE MINAS"	31	-43.3660843434322	-18.733593024363	3107	'Metropolitana de Belo Horizonte'	31028	'Conceição do Mato Dentro'
3102506	"AMPARO DO SERRA"	31	-42.8072021533658	-20.5100666871252	3112	'Zona da Mata'	31062	'Viçosa'
3102605	"ANDRADAS"	31	-46.575583000941	-22.0728073441089	3110	'Sul/Sudoeste de Minas'	31051	'Poços de Caldas'
3102803	"ANDRELANDIA"	31	-44.3176990379283	-21.7369681986895	3110	'Sul/Sudoeste de Minas'	31055	'Andrelândia'
3102852	"ANGELANDIA"	31	-42.2664504899208	-17.7277898321354	3103	'Jequitinhonha'	31011	'Capelinha'
3102902	"ANTONIO CARLOS"	31	-43.7556410098457	-21.3185803699484	3111	'Campo das Vertentes'	31059	'Barbacena'
3103009	"ANTONIO DIAS"	31	-42.8695452089701	-19.651466672642	3108	'Vale do Rio Doce'	31039	'Ipatinga'
3103108	"ANTONIO PRADO DE MINAS"	31	-42.1093426501154	-21.0182320587864	3112	'Zona da Mata'	31063	'Muriaé'
3103207	"ARACAI"	31	-44.2469237128616	-19.2003638594211	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3103306	"ARACITABA"	31	-43.3815562385328	-21.3392687360042	3112	'Zona da Mata'	31065	'Juiz de Fora'
3103405	"ARACUAI"	31	-42.0642065495411	-16.8517813953624	3103	'Jequitinhonha'	31012	'Araçuaí'
3103504	"ARAGUARI"	31	-48.1916053790292	-18.6482695268138	3105	'Triângulo Mineiro/Alto Paranaíba'	31018	'Uberlândia'
3103603	"ARANTINA"	31	-44.2469542481005	-21.9161042282331	3110	'Sul/Sudoeste de Minas'	31055	'Andrelândia'
3103702	"ARAPONGA"	31	-42.5262730999891	-20.6656617312945	3112	'Zona da Mata'	31062	'Viçosa'
3103751	"ARAPORA"	31	-49.1900866447003	-18.441909376646	3105	'Triângulo Mineiro/Alto Paranaíba'	31018	'Uberlândia'
3103801	"ARAPUA"	31	-46.1545977684885	-19.0338552875261	3105	'Triângulo Mineiro/Alto Paranaíba'	31020	'Patos de Minas'
3103900	"ARAUJOS"	31	-45.1667022785262	-19.9467853401902	3106	'Central Mineira'	31026	'Bom Despacho'
3104007	"ARAXA"	31	-46.9400098900213	-19.5913298027837	3105	'Triângulo Mineiro/Alto Paranaíba'	31023	'Araxá'
3104106	"ARCEBURGO"	31	-46.944354131699	-21.3601814752415	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3104205	"ARCOS"	31	-45.5436318712363	-20.2825631199368	3109	'Oeste de Minas'	31044	'Formiga'
3104304	"AREADO"	31	-46.1465594661257	-21.3583823575394	3110	'Sul/Sudoeste de Minas'	31049	'Alfenas'
3104403	"ARGIRITA"	31	-42.8364467678468	-21.6075545062608	3112	'Zona da Mata'	31066	'Cataguases'
3104452	"ARICANDUVA"	31	-42.5592310545725	-17.8677629385128	3103	'Jequitinhonha'	31011	'Capelinha'
3104502	"ARINOS"	31	-46.1077521361039	-15.9217716943489	3101	'Noroeste de Minas'	31001	'Unaí'
3104601	"ASTOLFO DUTRA"	31	-42.8596443142027	-21.3112038507544	3112	'Zona da Mata'	31064	'Ubá'
3104700	"ATALEIA"	31	-41.1105583899414	-18.0459198091504	3104	'Vale do Mucuri'	31015	'Teófilo Otoni'
3104809	"AUGUSTO DE LIMA"	31	-44.2752188423279	-18.1125481037423	3106	'Central Mineira'	31025	'Curvelo'
3104908	"BAEPENDI"	31	-44.8903706627583	-21.9576108079318	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3105004	"BALDIM"	31	-43.9570406413178	-19.2864373041598	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3105103	"BAMBUI"	31	-45.9790448126104	-20.0118916914226	3109	'Oeste de Minas'	31042	'Piuí'
3105202	"BANDEIRA"	31	-40.5588864205795	-15.8849769791563	3103	'Jequitinhonha'	31014	'Almenara'
3105301	"BANDEIRA DO SUL"	31	-46.3852629849298	-21.7248685443114	3110	'Sul/Sudoeste de Minas'	31051	'Poços de Caldas'
3105400	"BARAO DE COCAIS"	31	-43.4848824690371	-19.9358474342692	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3105509	"BARAO DE MONTE ALTO"	31	-42.2391465797033	-21.2478823447256	3112	'Zona da Mata'	31063	'Muriaé'
3105608	"BARBACENA"	31	-43.7761933160596	-21.2249153847091	3111	'Campo das Vertentes'	31059	'Barbacena'
3105707	"BARRA LONGA"	31	-43.0371967110936	-20.2836358984768	3112	'Zona da Mata'	31060	'Ponte Nova'
3105905	"BARROSO"	31	-43.9753811243157	-21.176286999031	3111	'Campo das Vertentes'	31059	'Barbacena'
3106002	"BELA VISTA DE MINAS"	31	-43.0969322664076	-19.8258467639902	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3106101	"BELMIRO BRAGA"	31	-43.4157207678682	-21.9501313020299	3112	'Zona da Mata'	31065	'Juiz de Fora'
3106200	"BELO HORIZONTE"	31	-43.9264531735305	-19.9375242937751	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3106309	"BELO ORIENTE"	31	-42.4872826001983	-19.224644999373	3108	'Vale do Rio Doce'	31039	'Ipatinga'
3106408	"BELO VALE"	31	-44.0285276542129	-20.4066578717857	3107	'Metropolitana de Belo Horizonte'	31032	'Itaguara'
3106507	"BERILO"	31	-42.4613537743061	-16.9503017552809	3103	'Jequitinhonha'	31011	'Capelinha'
3106655	"BERIZAL"	31	-41.7467850898706	-15.6107836516615	3102	'Norte de Minas'	31005	'Salinas'
3106606	"BERTOPOLIS"	31	-40.5722458500666	-17.0609628122125	3104	'Vale do Mucuri'	31016	'Nanuque'
3106705	"BETIM"	31	-44.1975511032666	-19.9653792400851	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3106804	"BIAS FORTES"	31	-43.7565748274501	-21.6087474847644	3112	'Zona da Mata'	31065	'Juiz de Fora'
3106903	"BICAS"	31	-43.0620472620857	-21.7221051209875	3112	'Zona da Mata'	31065	'Juiz de Fora'
3107000	"BIQUINHAS"	31	-45.5046517160236	-18.7847516602239	3106	'Central Mineira'	31024	'Três Marias'
3107109	"BOA ESPERANCA"	31	-45.5644089307913	-21.0905310792112	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3107208	"BOCAINA DE MINAS"	31	-44.3973057604562	-22.1696084676486	3110	'Sul/Sudoeste de Minas'	31055	'Andrelândia'
3107307	"BOCAIUVA"	31	-43.8144435712164	-17.1121047332277	3102	'Norte de Minas'	31009	'Bocaiúva'
3107406	"BOM DESPACHO"	31	-45.2541151985748	-19.737596333881	3106	'Central Mineira'	31026	'Bom Despacho'
3107505	"BOM JARDIM DE MINAS"	31	-44.189374455961	-21.9458997849154	3110	'Sul/Sudoeste de Minas'	31055	'Andrelândia'
3107604	"BOM JESUS DA PENHA"	31	-46.523543613945	-21.017269311163	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3107703	"BOM JESUS DO AMPARO"	31	-43.4735149244831	-19.7041372739146	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3107802	"BOM JESUS DO GALHO"	31	-42.3157265526063	-19.8244720395432	3108	'Vale do Rio Doce'	31040	'Caratinga'
3107901	"BOM REPOUSO"	31	-46.147882202098	-22.4768368285268	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3108008	"BOM SUCESSO"	31	-44.7555027232646	-21.0304160944461	3109	'Oeste de Minas'	31046	'Oliveira'
3108107	"BONFIM"	31	-44.232911084905	-20.3254910996075	3107	'Metropolitana de Belo Horizonte'	31032	'Itaguara'
3108206	"BONFINOPOLIS DE MINAS"	31	-45.988340657155	-16.5707647860757	3101	'Noroeste de Minas'	31001	'Unaí'
3108255	"BONITO DE MINAS"	31	-44.7580284448542	-15.3238044714657	3102	'Norte de Minas'	31003	'Januária'
3108305	"BORDA DA MATA"	31	-46.1671682395358	-22.2724082578295	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3108404	"BOTELHOS"	31	-46.3954931502591	-21.6516638757349	3110	'Sul/Sudoeste de Minas'	31051	'Poços de Caldas'
3108503	"BOTUMIRIM"	31	-43.0104324369177	-16.8629245518797	3102	'Norte de Minas'	31008	'Grão Mogol'
3108701	"BRAS PIRES"	31	-43.239122599312	-20.8484564359993	3112	'Zona da Mata'	31062	'Viçosa'
3108552	"BRASILANDIA DE MINAS"	31	-46.0154017589955	-16.9986005535911	3101	'Noroeste de Minas'	31002	'Paracatu'
3108602	"BRASILIA DE MINAS"	31	-44.4275330930915	-16.205872688841	3102	'Norte de Minas'	31007	'Montes Claros'
3108800	"BRAUNAS"	31	-42.7153526369813	-19.0535966189467	3108	'Vale do Rio Doce'	31035	'Guanhães'
3108909	"BRASOPOLIS"	31	-45.6153258182512	-22.4731102415169	3110	'Sul/Sudoeste de Minas'	31056	'Itajubá'
3109006	"BRUMADINHO"	31	-44.2001876090636	-20.1441744103499	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3109105	"BUENO BRANDAO"	31	-46.353388087214	-22.4361670055923	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3109204	"BUENOPOLIS"	31	-44.1807884588015	-17.8742562843054	3106	'Central Mineira'	31025	'Curvelo'
3109253	"BUGRE"	31	-42.2594570122598	-19.4222126750432	3108	'Vale do Rio Doce'	31040	'Caratinga'
3109303	"BURITIS"	31	-46.424040801173	-15.626505489997	3101	'Noroeste de Minas'	31001	'Unaí'
3109402	"BURITIZEIRO"	31	-44.9551936818752	-17.3594207725782	3102	'Norte de Minas'	31006	'Pirapora'
3109451	"CABECEIRA GRANDE"	31	-47.0849893051072	-16.028274803193	3101	'Noroeste de Minas'	31001	'Unaí'
3109501	"CABO VERDE"	31	-46.3999705002413	-21.4692919515993	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3109600	"CACHOEIRA DA PRATA"	31	-44.4410509536478	-19.5264353262956	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3109709	"CACHOEIRA DE MINAS"	31	-45.7821375141066	-22.3539840611907	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3102704	"CACHOEIRA DE PAJEU"	31	-41.4964103683588	-15.9651758417422	3103	'Jequitinhonha'	31013	'Pedra Azul'
3109808	"CACHOEIRA DOURADA"	31	-49.5017341333274	-18.512689815808	3105	'Triângulo Mineiro/Alto Paranaíba'	31017	'Ituiutaba'
3109907	"CAETANOPOLIS"	31	-44.4130373375318	-19.2937130281333	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3110004	"CAETE"	31	-43.6647873511184	-19.8871411326048	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3110103	"CAIANA"	31	-41.9229821868914	-20.6968289779179	3112	'Zona da Mata'	31063	'Muriaé'
3110202	"CAJURI"	31	-42.7939202734051	-20.7889426719043	3112	'Zona da Mata'	31062	'Viçosa'
3110301	"CALDAS"	31	-46.3877891098818	-21.9233359583344	3110	'Sul/Sudoeste de Minas'	31051	'Poços de Caldas'
3110400	"CAMACHO"	31	-45.1587926720343	-20.6269158527807	3109	'Oeste de Minas'	31044	'Formiga'
3110509	"CAMANDUCAIA"	31	-46.146863289284	-22.7567463577539	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3110608	"CAMBUI"	31	-46.0580193633379	-22.6110971633733	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3110707	"CAMBUQUIRA"	31	-45.2925205085194	-21.8554097676123	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3110806	"CAMPANARIO"	31	-41.7301317866171	-18.2411235319382	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3110905	"CAMPANHA"	31	-45.3984486738569	-21.8353567040277	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3111002	"CAMPESTRE"	31	-46.2481585071337	-21.7114548340365	3110	'Sul/Sudoeste de Minas'	31051	'Poços de Caldas'
3111101	"CAMPINA VERDE"	31	-49.4811690506139	-19.5354556028876	3105	'Triângulo Mineiro/Alto Paranaíba'	31021	'Frutal'
3111150	"CAMPO AZUL"	31	-44.8118582138383	-16.5040634892558	3102	'Norte de Minas'	31007	'Montes Claros'
3111200	"CAMPO BELO"	31	-45.2758613611232	-20.8953162458046	3109	'Oeste de Minas'	31045	'Campo Belo'
3111309	"CAMPO DO MEIO"	31	-45.8307571404523	-21.109325717622	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3111408	"CAMPO FLORIDO"	31	-48.5730034681848	-19.7654453932829	3105	'Triângulo Mineiro/Alto Paranaíba'	31022	'Uberaba'
3111507	"CAMPOS ALTOS"	31	-46.1737099168343	-19.6988958417622	3105	'Triângulo Mineiro/Alto Paranaíba'	31023	'Araxá'
3111606	"CAMPOS GERAIS"	31	-45.7569073652198	-21.238697907437	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3111903	"CANA VERDE"	31	-45.185925314678	-21.0234516663837	3109	'Oeste de Minas'	31045	'Campo Belo'
3111705	"CANAA"	31	-42.6130114531104	-20.6873760386752	3112	'Zona da Mata'	31062	'Viçosa'
3111804	"CANAPOLIS"	31	-49.2040544543899	-18.7216637220479	3105	'Triângulo Mineiro/Alto Paranaíba'	31018	'Uberlândia'
3112000	"CANDEIAS"	31	-45.2768566964552	-20.7703500411538	3109	'Oeste de Minas'	31045	'Campo Belo'
3112059	"CANTAGALO"	31	-42.6257272921885	-18.5317179062502	3108	'Vale do Rio Doce'	31036	'Peçanha'
3112109	"CAPARAO"	31	-41.9071902950208	-20.5255883673675	3112	'Zona da Mata'	31061	'Manhuaçu'
3112208	"CAPELA NOVA"	31	-43.6124218663921	-20.9166679077144	3111	'Campo das Vertentes'	31059	'Barbacena'
3112307	"CAPELINHA"	31	-42.5160753734565	-17.6953852202015	3103	'Jequitinhonha'	31011	'Capelinha'
3112406	"CAPETINGA"	31	-47.0574368006836	-20.6204991278604	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3112505	"CAPIM BRANCO"	31	-44.1331662414131	-19.5455422093287	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3112604	"CAPINOPOLIS"	31	-49.5744822393992	-18.6822937337555	3105	'Triângulo Mineiro/Alto Paranaíba'	31017	'Ituiutaba'
3112653	"CAPITAO ANDRADE"	31	-41.8650973290854	-19.0790244575707	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3112703	"CAPITAO ENEAS"	31	-43.7054128998982	-16.3209151363553	3102	'Norte de Minas'	31007	'Montes Claros'
3112802	"CAPITOLIO"	31	-46.0545138880805	-20.6146635994975	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3112901	"CAPUTIRA"	31	-42.2719878999316	-20.1708899894667	3112	'Zona da Mata'	31061	'Manhuaçu'
3113008	"CARAI"	31	-41.6983072511944	-17.1929041661081	3103	'Jequitinhonha'	31012	'Araçuaí'
3113107	"CARANAIBA"	31	-43.7394664788539	-20.8702194155652	3111	'Campo das Vertentes'	31059	'Barbacena'
3113206	"CARANDAI"	31	-43.8054753702247	-20.9543694555464	3111	'Campo das Vertentes'	31059	'Barbacena'
3113305	"CARANGOLA"	31	-42.0322245231296	-20.732550508322	3112	'Zona da Mata'	31063	'Muriaé'
3113404	"CARATINGA"	31	-42.1437070451993	-19.7896349230665	3108	'Vale do Rio Doce'	31040	'Caratinga'
3113503	"CARBONITA"	31	-43.0144602004652	-17.5302458345986	3103	'Jequitinhonha'	31011	'Capelinha'
3113602	"CAREACU"	31	-45.6876774051204	-22.0380848512152	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3113701	"CARLOS CHAGAS"	31	-40.7673997960806	-17.7033310440365	3104	'Vale do Mucuri'	31016	'Nanuque'
3113800	"CARMESIA"	31	-43.1458403032499	-19.0870863874439	3108	'Vale do Rio Doce'	31035	'Guanhães'
3113909	"CARMO DA CACHOEIRA"	31	-45.2246230941763	-21.4610604282587	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3114006	"CARMO DA MATA"	31	-44.8683827332713	-20.5592100019754	3109	'Oeste de Minas'	31046	'Oliveira'
3114105	"CARMO DE MINAS"	31	-45.1327634855743	-22.1181266345725	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3114204	"CARMO DO CAJURU"	31	-44.771478137316	-20.186093830724	3109	'Oeste de Minas'	31043	'Divinópolis'
3114303	"CARMO DO PARANAIBA"	31	-46.3142888776277	-18.9972890251417	3105	'Triângulo Mineiro/Alto Paranaíba'	31020	'Patos de Minas'
3114402	"CARMO DO RIO CLARO"	31	-46.1219647340897	-20.9729965301287	3110	'Sul/Sudoeste de Minas'	31049	'Alfenas'
3114501	"CARMOPOLIS DE MINAS"	31	-44.6325277075291	-20.5396421743262	3109	'Oeste de Minas'	31046	'Oliveira'
3114550	"CARNEIRINHO"	31	-50.6914274936605	-19.6973263172808	3105	'Triângulo Mineiro/Alto Paranaíba'	31021	'Frutal'
3114600	"CARRANCAS"	31	-44.6436090229114	-21.4916256213918	3111	'Campo das Vertentes'	31057	'Lavras'
3114709	"CARVALHOPOLIS"	31	-45.8456391849518	-21.7760729207397	3110	'Sul/Sudoeste de Minas'	31049	'Alfenas'
3114808	"CARVALHOS"	31	-44.466015072793	-21.9967053815743	3110	'Sul/Sudoeste de Minas'	31055	'Andrelândia'
3114907	"CASA GRANDE"	31	-43.9314665941035	-20.7934512867946	3107	'Metropolitana de Belo Horizonte'	31034	'Conselheiro Lafaiete'
3115003	"CASCALHO RICO"	31	-47.8759987830325	-18.5785902482689	3105	'Triângulo Mineiro/Alto Paranaíba'	31018	'Uberlândia'
3115102	"CASSIA"	31	-46.924035860642	-20.5828560244396	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3115300	"CATAGUASES"	31	-42.6920846108201	-21.3892484232128	3112	'Zona da Mata'	31066	'Cataguases'
3115359	"CATAS ALTAS"	31	-43.4148057349597	-20.0748929431654	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3115409	"CATAS ALTAS DA NORUEGA"	31	-43.5050592004737	-20.6870876210355	3107	'Metropolitana de Belo Horizonte'	31034	'Conselheiro Lafaiete'
3115458	"CATUJI"	31	-41.523126865366	-17.3010807061062	3104	'Vale do Mucuri'	31015	'Teófilo Otoni'
3115474	"CATUTI"	31	-42.9635229642327	-15.3573788763445	3102	'Norte de Minas'	31004	'Janaúba'
3115508	"CAXAMBU"	31	-44.9314985913756	-21.9793115398299	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3115607	"CEDRO DO ABAETE"	31	-45.7121949359924	-19.1471676520828	3106	'Central Mineira'	31024	'Três Marias'
3115706	"CENTRAL DE MINAS"	31	-41.3104050536671	-18.7574605376829	3108	'Vale do Rio Doce'	31038	'Mantena'
3115805	"CENTRALINA"	31	-49.1962825701454	-18.5853855112475	3105	'Triângulo Mineiro/Alto Paranaíba'	31018	'Uberlândia'
3115904	"CHACARA"	31	-43.2187700295011	-21.6729132233441	3112	'Zona da Mata'	31065	'Juiz de Fora'
3116001	"CHALE"	31	-41.6922070079875	-20.0442533445944	3112	'Zona da Mata'	31061	'Manhuaçu'
3116100	"CHAPADA DO NORTE"	31	-42.5407487605038	-17.0866959813483	3103	'Jequitinhonha'	31011	'Capelinha'
3116159	"CHAPADA GAUCHA"	31	-45.6255844399663	-15.2998087151246	3102	'Norte de Minas'	31003	'Januária'
3116209	"CHIADOR"	31	-43.0590388470773	-22.0037126009454	3112	'Zona da Mata'	31065	'Juiz de Fora'
3116308	"CIPOTANEA"	31	-43.367977207819	-20.9055357479024	3112	'Zona da Mata'	31062	'Viçosa'
3116407	"CLARAVAL"	31	-47.2877612861721	-20.3983760809959	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3116506	"CLARO DOS POCOES"	31	-44.2087100149448	-17.077685022881	3102	'Norte de Minas'	31007	'Montes Claros'
3116605	"CLAUDIO"	31	-44.7684225278902	-20.4445746550274	3109	'Oeste de Minas'	31043	'Divinópolis'
3116704	"COIMBRA"	31	-42.805939102564	-20.8586595280142	3112	'Zona da Mata'	31062	'Viçosa'
3116803	"COLUNA"	31	-42.8436545122746	-18.2204050351578	3108	'Vale do Rio Doce'	31035	'Guanhães'
3116902	"COMENDADOR GOMES"	31	-49.0814302053372	-19.7002146271412	3105	'Triângulo Mineiro/Alto Paranaíba'	31021	'Frutal'
3117009	"COMERCINHO"	31	-41.7911317349164	-16.2965954747835	3103	'Jequitinhonha'	31013	'Pedra Azul'
3117108	"CONCEICAO DA APARECIDA"	31	-46.203127249623	-21.0966200708181	3110	'Sul/Sudoeste de Minas'	31049	'Alfenas'
3115201	"CONCEICAO DA BARRA DE MINAS"	31	-44.4778082132301	-21.1317693674981	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3117306	"CONCEICAO DAS ALAGOAS"	31	-48.381874129465	-19.9231135061827	3105	'Triângulo Mineiro/Alto Paranaíba'	31022	'Uberaba'
3117207	"CONCEICAO DAS PEDRAS"	31	-45.4536794627182	-22.1611757087795	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3117405	"CONCEICAO DE IPANEMA"	31	-41.6924492631517	-19.9307803586776	3108	'Vale do Rio Doce'	31041	'Aimorés'
3117504	"CONCEICAO DO MATO DENTRO"	31	-43.423435767518	-19.0451899945408	3107	'Metropolitana de Belo Horizonte'	31028	'Conceição do Mato Dentro'
3117603	"CONCEICAO DO PARA"	31	-44.8958756116422	-19.7490562324375	3109	'Oeste de Minas'	31043	'Divinópolis'
3117702	"CONCEICAO DO RIO VERDE"	31	-45.0837688660577	-21.8776655592195	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3117801	"CONCEICAO DOS OUROS"	31	-45.7963266584857	-22.4174754897215	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3117836	"CONEGO MARINHO"	31	-44.4151547108268	-15.2962703181641	3102	'Norte de Minas'	31003	'Januária'
3117876	"CONFINS"	31	-43.9955960875638	-19.6299482494053	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3117900	"CONGONHAL"	31	-46.0536623723338	-22.152560758106	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3118007	"CONGONHAS"	31	-43.8568926496971	-20.5046427885581	3107	'Metropolitana de Belo Horizonte'	31034	'Conselheiro Lafaiete'
3118106	"CONGONHAS DO NORTE"	31	-43.6876316327273	-18.8164519608161	3107	'Metropolitana de Belo Horizonte'	31028	'Conceição do Mato Dentro'
3118205	"CONQUISTA"	31	-47.5432832203071	-19.9369306256422	3105	'Triângulo Mineiro/Alto Paranaíba'	31022	'Uberaba'
3118304	"CONSELHEIRO LAFAIETE"	31	-43.7884446647199	-20.660851799444	3107	'Metropolitana de Belo Horizonte'	31034	'Conselheiro Lafaiete'
3118403	"CONSELHEIRO PENA"	31	-41.4719740204006	-19.1756232014514	3108	'Vale do Rio Doce'	31041	'Aimorés'
3118502	"CONSOLACAO"	31	-45.9222507202093	-22.5504650358103	3110	'Sul/Sudoeste de Minas'	31056	'Itajubá'
3118601	"CONTAGEM"	31	-44.0663446487239	-19.9434459056633	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3118700	"COQUEIRAL"	31	-45.440805566821	-21.1865745236631	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3118809	"CORACAO DE JESUS"	31	-44.3584952946502	-16.6893234476866	3102	'Norte de Minas'	31007	'Montes Claros'
3118908	"CORDISBURGO"	31	-44.3220674519339	-19.1285333206637	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3119005	"CORDISLANDIA"	31	-45.7005297277009	-21.7912077552474	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3119104	"CORINTO"	31	-44.4562256497032	-18.3635162871045	3106	'Central Mineira'	31025	'Curvelo'
3119203	"COROACI"	31	-42.283027891501	-18.6180835058572	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3119302	"COROMANDEL"	31	-47.2015477282097	-18.4738505975887	3105	'Triângulo Mineiro/Alto Paranaíba'	31019	'Patrocínio'
3119401	"CORONEL FABRICIANO"	31	-42.624346577298	-19.5250528393467	3108	'Vale do Rio Doce'	31039	'Ipatinga'
3119500	"CORONEL MURTA"	31	-42.1848038231002	-16.6102682357247	3103	'Jequitinhonha'	31012	'Araçuaí'
3119609	"CORONEL PACHECO"	31	-43.2688579711124	-21.5764151525441	3112	'Zona da Mata'	31065	'Juiz de Fora'
3119708	"CORONEL XAVIER CHAVES"	31	-44.2286242458218	-21.0245950067461	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3119807	"CORREGO DANTA"	31	-45.8984710283885	-19.8264100219361	3109	'Oeste de Minas'	31042	'Piuí'
3119906	"CORREGO DO BOM JESUS"	31	-46.017909207626	-22.6299218873908	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3119955	"CORREGO FUNDO"	31	-45.5533954460448	-20.4555253223239	3109	'Oeste de Minas'	31044	'Formiga'
3120003	"CORREGO NOVO"	31	-42.4001378803437	-19.8347854823175	3108	'Vale do Rio Doce'	31040	'Caratinga'
3120102	"COUTO DE MAGALHAES DE MINAS"	31	-43.4753487750125	-18.0720593059942	3103	'Jequitinhonha'	31010	'Diamantina'
3120151	"CRISOLITA"	31	-40.914895278108	-17.2375343951009	3104	'Vale do Mucuri'	31016	'Nanuque'
3120201	"CRISTAIS"	31	-45.5185038489986	-20.8752331535244	3109	'Oeste de Minas'	31045	'Campo Belo'
3120300	"CRISTALIA"	31	-42.8595509120255	-16.7126340057198	3102	'Norte de Minas'	31008	'Grão Mogol'
3120409	"CRISTIANO OTONI"	31	-43.7978363805106	-20.8408523330587	3107	'Metropolitana de Belo Horizonte'	31034	'Conselheiro Lafaiete'
3120508	"CRISTINA"	31	-45.2628086074469	-22.2083205226708	3110	'Sul/Sudoeste de Minas'	31056	'Itajubá'
3120607	"CRUCILANDIA"	31	-44.3378369394148	-20.3932917693507	3107	'Metropolitana de Belo Horizonte'	31032	'Itaguara'
3120706	"CRUZEIRO DA FORTALEZA"	31	-46.6733926485072	-18.9386473163882	3105	'Triângulo Mineiro/Alto Paranaíba'	31019	'Patrocínio'
3120805	"CRUZILIA"	31	-44.8110234836963	-21.8389511788947	3110	'Sul/Sudoeste de Minas'	31055	'Andrelândia'
3120839	"CUPARAQUE"	31	-41.1031257418177	-18.9666415321382	3108	'Vale do Rio Doce'	31041	'Aimorés'
3120870	"CURRAL DE DENTRO"	31	-41.8559797796326	-15.9393267809759	3102	'Norte de Minas'	31005	'Salinas'
3120904	"CURVELO"	31	-44.4283989683234	-18.7554807216307	3106	'Central Mineira'	31025	'Curvelo'
3121001	"DATAS"	31	-43.656714638014	-18.4533026488235	3103	'Jequitinhonha'	31010	'Diamantina'
3121100	"DELFIM MOREIRA"	31	-45.2725963577217	-22.5020087460167	3110	'Sul/Sudoeste de Minas'	31056	'Itajubá'
3121209	"DELFINOPOLIS"	31	-46.8581796122359	-20.3458462167345	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3121258	"DELTA"	31	-47.7729714324773	-19.9774726891388	3105	'Triângulo Mineiro/Alto Paranaíba'	31022	'Uberaba'
3121308	"DESCOBERTO"	31	-42.9720691787786	-21.4602039706987	3112	'Zona da Mata'	31065	'Juiz de Fora'
3121407	"DESTERRO DE ENTRE RIOS"	31	-44.3436660058815	-20.6546306803958	3107	'Metropolitana de Belo Horizonte'	31034	'Conselheiro Lafaiete'
3121506	"DESTERRO DO MELO"	31	-43.5196002211704	-21.1471785182012	3111	'Campo das Vertentes'	31059	'Barbacena'
3121605	"DIAMANTINA"	31	-43.5944568221762	-18.2420927241641	3103	'Jequitinhonha'	31010	'Diamantina'
3121704	"DIOGO DE VASCONCELOS"	31	-43.1965768271676	-20.4875057994595	3107	'Metropolitana de Belo Horizonte'	31033	'Ouro Preto'
3121803	"DIONISIO"	31	-42.7823684408398	-19.8439966742821	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3121902	"DIVINESIA"	31	-43.0110812037762	-20.9900103366548	3112	'Zona da Mata'	31064	'Ubá'
3122009	"DIVINO"	31	-42.1477393353315	-20.6129771965043	3112	'Zona da Mata'	31063	'Muriaé'
3122108	"DIVINO DAS LARANJEIRAS"	31	-41.4832539383023	-18.7731284728487	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3122207	"DIVINOLANDIA DE MINAS"	31	-42.6218202062038	-18.8052604137557	3108	'Vale do Rio Doce'	31035	'Guanhães'
3122306	"DIVINOPOLIS"	31	-44.8938855338723	-20.1420739745819	3109	'Oeste de Minas'	31043	'Divinópolis'
3122355	"DIVISA ALEGRE"	31	-41.3400243277945	-15.7239399549396	3102	'Norte de Minas'	31005	'Salinas'
3122405	"DIVISA NOVA"	31	-46.2029411062337	-21.5172644643355	3110	'Sul/Sudoeste de Minas'	31049	'Alfenas'
3122454	"DIVISOPOLIS"	31	-41.0025823969773	-15.7246353600352	3103	'Jequitinhonha'	31014	'Almenara'
3122470	"DOM BOSCO"	31	-46.2714498987887	-16.6507498918987	3101	'Noroeste de Minas'	31001	'Unaí'
3122504	"DOM CAVATI"	31	-42.1103240464578	-19.3791630318591	3108	'Vale do Rio Doce'	31040	'Caratinga'
3122603	"DOM JOAQUIM"	31	-43.2613480039741	-18.9645501866295	3107	'Metropolitana de Belo Horizonte'	31028	'Conceição do Mato Dentro'
3122702	"DOM SILVERIO"	31	-42.9708729670396	-20.1622049297376	3112	'Zona da Mata'	31060	'Ponte Nova'
3122801	"DOM VICOSO"	31	-45.159168673856	-22.2536741086805	3110	'Sul/Sudoeste de Minas'	31056	'Itajubá'
3122900	"DONA EUSEBIA"	31	-42.8069340637792	-21.3238746965497	3112	'Zona da Mata'	31066	'Cataguases'
3123007	"DORES DE CAMPOS"	31	-44.0230465708887	-21.1040875600453	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3123106	"DORES DE GUANHAES"	31	-42.9267218922717	-19.054261783513	3108	'Vale do Rio Doce'	31035	'Guanhães'
3123205	"DORES DO INDAIA"	31	-45.6026558325089	-19.4616294368129	3106	'Central Mineira'	31026	'Bom Despacho'
3123304	"DORES DO TURVO"	31	-43.1951945185031	-20.9812733744049	3112	'Zona da Mata'	31064	'Ubá'
3123403	"DORESOPOLIS"	31	-45.9051968861518	-20.2884509606147	3109	'Oeste de Minas'	31042	'Piuí'
3123502	"DOURADOQUARA"	31	-47.6119749498521	-18.4338340922598	3105	'Triângulo Mineiro/Alto Paranaíba'	31019	'Patrocínio'
3123528	"DURANDE"	31	-41.794261647372	-20.2072388771967	3112	'Zona da Mata'	31061	'Manhuaçu'
3123601	"ELOI MENDES"	31	-45.5664342007897	-21.6093127849259	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3123700	"ENGENHEIRO CALDAS"	31	-42.0498416857745	-19.1981028702941	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3123809	"ENGENHEIRO NAVARRO"	31	-43.9494147387385	-17.2877532077503	3102	'Norte de Minas'	31009	'Bocaiúva'
3123858	"ENTRE FOLHAS"	31	-42.2323599753122	-19.6277833509071	3108	'Vale do Rio Doce'	31040	'Caratinga'
3123908	"ENTRE RIOS DE MINAS"	31	-44.0670816812587	-20.6713572038258	3107	'Metropolitana de Belo Horizonte'	31034	'Conselheiro Lafaiete'
3124005	"ERVALIA"	31	-42.6593674650091	-20.8335065579592	3112	'Zona da Mata'	31062	'Viçosa'
3124104	"ESMERALDAS"	31	-44.3148069192277	-19.7592007437738	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3124203	"ESPERA FELIZ"	31	-41.9139350169683	-20.6437078083015	3112	'Zona da Mata'	31063	'Muriaé'
3124302	"ESPINOSA"	31	-42.8129818449157	-14.9252718111525	3102	'Norte de Minas'	31004	'Janaúba'
3124401	"ESPIRITO SANTO DO DOURADO"	31	-45.9540125198564	-22.0475136418497	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3124500	"ESTIVA"	31	-46.0163518065517	-22.4630450603543	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3124609	"ESTRELA DALVA"	31	-42.4583710299194	-21.7422852764394	3112	'Zona da Mata'	31066	'Cataguases'
3124708	"ESTRELA DO INDAIA"	31	-45.7924325620025	-19.52023782207	3106	'Central Mineira'	31026	'Bom Despacho'
3124807	"ESTRELA DO SUL"	31	-47.6889748021455	-18.7412931756593	3105	'Triângulo Mineiro/Alto Paranaíba'	31019	'Patrocínio'
3124906	"EUGENOPOLIS"	31	-42.1922770818769	-21.0972225306709	3112	'Zona da Mata'	31063	'Muriaé'
3125002	"EWBANK DA CAMARA"	31	-43.5075913951105	-21.5416361511493	3112	'Zona da Mata'	31065	'Juiz de Fora'
3125101	"EXTREMA"	31	-46.3221617403776	-22.858190072021	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3125200	"FAMA"	31	-45.8323121024444	-21.4057615290226	3110	'Sul/Sudoeste de Minas'	31049	'Alfenas'
3125309	"FARIA LEMOS"	31	-42.0138461766787	-20.8017449434969	3112	'Zona da Mata'	31063	'Muriaé'
3125408	"FELICIO DOS SANTOS"	31	-43.2451709347937	-18.077563117073	3103	'Jequitinhonha'	31010	'Diamantina'
3125606	"FELISBURGO"	31	-40.7585704995432	-16.6383331500748	3103	'Jequitinhonha'	31014	'Almenara'
3125705	"FELIXLANDIA"	31	-44.8965866173716	-18.7543565615242	3106	'Central Mineira'	31025	'Curvelo'
3125804	"FERNANDES TOURINHO"	31	-42.0809784803541	-19.1510006449856	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3125903	"FERROS"	31	-43.0197136171061	-19.2364195947071	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3125952	"FERVEDOURO"	31	-42.2781805292377	-20.7327756857738	3112	'Zona da Mata'	31063	'Muriaé'
3126000	"FLORESTAL"	31	-44.4301155625427	-19.8945182324972	3107	'Metropolitana de Belo Horizonte'	31029	'Pará de Minas'
3126109	"FORMIGA"	31	-45.4264281831415	-20.4648835524537	3109	'Oeste de Minas'	31044	'Formiga'
3126208	"FORMOSO"	31	-46.239979536778	-14.9517425978891	3101	'Noroeste de Minas'	31001	'Unaí'
3126307	"FORTALEZA DE MINAS"	31	-46.7126434064402	-20.8484925119899	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3126406	"FORTUNA DE MINAS"	31	-44.4433970450287	-19.5639009597139	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3126505	"FRANCISCO BADARO"	31	-42.3497731636506	-16.9906912878231	3103	'Jequitinhonha'	31011	'Capelinha'
3126604	"FRANCISCO DUMONT"	31	-44.2342065277647	-17.3199488056432	3102	'Norte de Minas'	31009	'Bocaiúva'
3126703	"FRANCISCO SA"	31	-43.488735281491	-16.4756808656879	3102	'Norte de Minas'	31007	'Montes Claros'
3126752	"FRANCISCOPOLIS"	31	-42.0073128118949	-17.9590435726149	3104	'Vale do Mucuri'	31015	'Teófilo Otoni'
3126802	"FREI GASPAR"	31	-41.4294207855596	-18.0711850280915	3104	'Vale do Mucuri'	31015	'Teófilo Otoni'
3126901	"FREI INOCENCIO"	31	-41.9012165865176	-18.5617897297728	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3126950	"FREI LAGONEGRO"	31	-42.7652952385537	-18.1650807120668	3108	'Vale do Rio Doce'	31036	'Peçanha'
3127008	"FRONTEIRA"	31	-49.2042820251303	-20.2883005578685	3105	'Triângulo Mineiro/Alto Paranaíba'	31021	'Frutal'
3127057	"FRONTEIRA DOS VALES"	31	-40.9250786594486	-16.8920152174495	3104	'Vale do Mucuri'	31016	'Nanuque'
3127073	"FRUTA DE LEITE"	31	-42.5322219360174	-16.1164184229985	3102	'Norte de Minas'	31005	'Salinas'
3127107	"FRUTAL"	31	-48.9391537102571	-20.0258978750723	3105	'Triângulo Mineiro/Alto Paranaíba'	31021	'Frutal'
3127206	"FUNILANDIA"	31	-44.0630858803589	-19.3699873329839	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3127305	"GALILEIA"	31	-41.5361971686177	-19.0054736424555	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3127339	"GAMELEIRAS"	31	-43.1194808391551	-15.0768220675066	3102	'Norte de Minas'	31004	'Janaúba'
3127354	"GLAUCILANDIA"	31	-43.696405897757	-16.8502186918182	3102	'Norte de Minas'	31007	'Montes Claros'
3127370	"GOIABEIRA"	31	-41.2228216102869	-18.9817133371255	3108	'Vale do Rio Doce'	31041	'Aimorés'
3127388	"GOIANA"	31	-43.1914823969779	-21.5324178276547	3112	'Zona da Mata'	31065	'Juiz de Fora'
3127404	"GONCALVES"	31	-45.8565920384671	-22.6576191871187	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3127503	"GONZAGA"	31	-42.4772238728792	-18.824825001353	3108	'Vale do Rio Doce'	31035	'Guanhães'
3127602	"GOUVEIA"	31	-43.7339867457722	-18.4429725027128	3103	'Jequitinhonha'	31010	'Diamantina'
3127701	"GOVERNADOR VALADARES"	31	-41.9470813340288	-18.8528824033103	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3127800	"GRAO MOGOL"	31	-42.888012880146	-16.5664951547914	3102	'Norte de Minas'	31008	'Grão Mogol'
3127909	"GRUPIARA"	31	-47.7247984350216	-18.4930238023097	3105	'Triângulo Mineiro/Alto Paranaíba'	31019	'Patrocínio'
3128006	"GUANHAES"	31	-42.9370490952478	-18.777150790233	3108	'Vale do Rio Doce'	31035	'Guanhães'
3128105	"GUAPE"	31	-45.9183838607042	-20.7567245119627	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3128204	"GUARACIABA"	31	-43.0112816471752	-20.5717035009858	3112	'Zona da Mata'	31060	'Ponte Nova'
3128253	"GUARACIAMA"	31	-43.6687777057549	-17.0115274631445	3102	'Norte de Minas'	31009	'Bocaiúva'
3128303	"GUARANESIA"	31	-46.7954912202959	-21.3055603706599	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3128402	"GUARANI"	31	-43.0464566840078	-21.3626691859301	3112	'Zona da Mata'	31064	'Ubá'
3128501	"GUARARA"	31	-43.0389524781122	-21.7327203008453	3112	'Zona da Mata'	31065	'Juiz de Fora'
3128600	"GUARDA-MOR"	31	-47.1010758534976	-17.7712998977844	3101	'Noroeste de Minas'	31002	'Paracatu'
3128709	"GUAXUPE"	31	-46.7135372309766	-21.3037814647476	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3128808	"GUIDOVAL"	31	-42.800817312061	-21.1442385033	3112	'Zona da Mata'	31064	'Ubá'
3128907	"GUIMARANIA"	31	-46.7972650323216	-18.8380192150624	3105	'Triângulo Mineiro/Alto Paranaíba'	31020	'Patos de Minas'
3129004	"GUIRICEMA"	31	-42.7188124697545	-21.0106733747952	3112	'Zona da Mata'	31064	'Ubá'
3129103	"GURINHATA"	31	-49.786273293982	-19.2137484368274	3105	'Triângulo Mineiro/Alto Paranaíba'	31017	'Ituiutaba'
3129202	"HELIODORA"	31	-45.5445766340527	-22.0647444405161	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3129301	"IAPU"	31	-42.2146925147824	-19.4402724492355	3108	'Vale do Rio Doce'	31040	'Caratinga'
3129400	"IBERTIOGA"	31	-43.9681238350753	-21.4294724820412	3111	'Campo das Vertentes'	31059	'Barbacena'
3129509	"IBIA"	31	-46.5386114189874	-19.4751117153569	3105	'Triângulo Mineiro/Alto Paranaíba'	31023	'Araxá'
3129608	"IBIAI"	31	-44.9141068387179	-16.8598724483642	3102	'Norte de Minas'	31006	'Pirapora'
3129657	"IBIRACATU"	31	-44.1677094358321	-15.6654666513271	3102	'Norte de Minas'	31007	'Montes Claros'
3129707	"IBIRACI"	31	-47.1308034906801	-20.470154879298	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3129806	"IBIRITE"	31	-44.0566646387867	-20.0280377506555	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3129905	"IBITIURA DE MINAS"	31	-46.4376032820573	-22.0570551561833	3110	'Sul/Sudoeste de Minas'	31051	'Poços de Caldas'
3130002	"IBITURUNA"	31	-44.7384635851603	-21.1464850111516	3109	'Oeste de Minas'	31046	'Oliveira'
3130051	"ICARAI DE MINAS"	31	-44.9027768020848	-16.2140127770631	3102	'Norte de Minas'	31003	'Januária'
3130101	"IGARAPE"	31	-44.3011578802931	-20.0699086840598	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3130200	"IGARATINGA"	31	-44.7004951348527	-19.9538862483495	3109	'Oeste de Minas'	31043	'Divinópolis'
3130309	"IGUATAMA"	31	-45.7091401060063	-20.1760739663705	3109	'Oeste de Minas'	31042	'Piuí'
3130408	"IJACI"	31	-44.9287829737225	-21.1720656158926	3111	'Campo das Vertentes'	31057	'Lavras'
3130507	"ILICINEA"	31	-45.8284636231176	-20.9403890167576	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3130556	"IMBE DE MINAS"	31	-41.9624807644967	-19.5958756424763	3108	'Vale do Rio Doce'	31040	'Caratinga'
3130606	"INCONFIDENTES"	31	-46.3338013987836	-22.3214871299648	3110	'Sul/Sudoeste de Minas'	31051	'Poços de Caldas'
3130655	"INDAIABIRA"	31	-42.2035848204661	-15.4923847142697	3102	'Norte de Minas'	31005	'Salinas'
3130705	"INDIANOPOLIS"	31	-47.9179923167254	-19.0424949328092	3105	'Triângulo Mineiro/Alto Paranaíba'	31018	'Uberlândia'
3130804	"INGAI"	31	-44.9224226367292	-21.4037168147376	3111	'Campo das Vertentes'	31057	'Lavras'
3130903	"INHAPIM"	31	-42.1219309349806	-19.5501147218179	3108	'Vale do Rio Doce'	31040	'Caratinga'
3131000	"INHAUMA"	31	-44.390945526609	-19.4923673884806	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3131109	"INIMUTABA"	31	-44.3662617661161	-18.7314405298966	3106	'Central Mineira'	31025	'Curvelo'
3131158	"IPABA"	31	-42.4181656693639	-19.4132508261961	3108	'Vale do Rio Doce'	31040	'Caratinga'
3131208	"IPANEMA"	31	-41.7173533200378	-19.8003359539072	3108	'Vale do Rio Doce'	31041	'Aimorés'
3131307	"IPATINGA"	31	-42.5203511114107	-19.481032097265	3108	'Vale do Rio Doce'	31039	'Ipatinga'
3131406	"IPIACU"	31	-49.9457732111112	-18.6948803087203	3105	'Triângulo Mineiro/Alto Paranaíba'	31017	'Ituiutaba'
3131505	"IPUIUNA"	31	-46.1908292322435	-22.0995205122112	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3131604	"IRAI DE MINAS"	31	-47.4629914178309	-18.981858345519	3105	'Triângulo Mineiro/Alto Paranaíba'	31019	'Patrocínio'
3131703	"ITABIRA"	31	-43.2239516190304	-19.6381694925835	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3131802	"ITABIRINHA"	31	-41.2331827152783	-18.5567992809294	3108	'Vale do Rio Doce'	31038	'Mantena'
3131901	"ITABIRITO"	31	-43.8021429838628	-20.2541765124384	3107	'Metropolitana de Belo Horizonte'	31033	'Ouro Preto'
3132008	"ITACAMBIRA"	31	-43.3104021870614	-17.0644351817249	3102	'Norte de Minas'	31008	'Grão Mogol'
3132107	"ITACARAMBI"	31	-44.0931858020531	-15.102641864892	3102	'Norte de Minas'	31003	'Januária'
3132206	"ITAGUARA"	31	-44.4867779577883	-20.3906782170492	3107	'Metropolitana de Belo Horizonte'	31032	'Itaguara'
3132305	"ITAIPE"	31	-41.6732295731568	-17.4042316437631	3104	'Vale do Mucuri'	31015	'Teófilo Otoni'
3132404	"ITAJUBA"	31	-45.4645825045045	-22.4306005744942	3110	'Sul/Sudoeste de Minas'	31056	'Itajubá'
3132503	"ITAMARANDIBA"	31	-42.8491577569261	-17.8585173258274	3103	'Jequitinhonha'	31011	'Capelinha'
3132602	"ITAMARATI DE MINAS"	31	-42.8185933585145	-21.4194556178374	3112	'Zona da Mata'	31066	'Cataguases'
3132701	"ITAMBACURI"	31	-41.6822673820424	-18.0343299628962	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3132800	"ITAMBE DO MATO DENTRO"	31	-43.3228953038647	-19.4209634657341	3107	'Metropolitana de Belo Horizonte'	31028	'Conceição do Mato Dentro'
3132909	"ITAMOGI"	31	-47.0474677838902	-21.0784433613415	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3133006	"ITAMONTE"	31	-44.8682875036049	-22.285126973446	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3133105	"ITANHANDU"	31	-44.9359219046627	-22.2950796548768	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3133204	"ITANHOMI"	31	-41.864931837144	-19.1716889295635	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3133303	"ITAOBIM"	31	-41.4989769803723	-16.5595259169948	3103	'Jequitinhonha'	31013	'Pedra Azul'
3133402	"ITAPAGIPE"	31	-49.3698210446178	-19.9032958273788	3105	'Triângulo Mineiro/Alto Paranaíba'	31021	'Frutal'
3133501	"ITAPECERICA"	31	-45.1246798888931	-20.4728898996102	3109	'Oeste de Minas'	31044	'Formiga'
3133600	"ITAPEVA"	31	-46.2195568578145	-22.7697403889152	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3133709	"ITATIAIUCU"	31	-44.4291636129271	-20.1986423603592	3107	'Metropolitana de Belo Horizonte'	31032	'Itaguara'
3133758	"ITAU DE MINAS"	31	-46.7529537830538	-20.7381893867748	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3133808	"ITAUNA"	31	-44.5782765780477	-20.0744355868074	3109	'Oeste de Minas'	31043	'Divinópolis'
3133907	"ITAVERAVA"	31	-43.6043223481191	-20.6747274709917	3107	'Metropolitana de Belo Horizonte'	31034	'Conselheiro Lafaiete'
3134004	"ITINGA"	31	-41.7781780721963	-16.60142939198	3103	'Jequitinhonha'	31012	'Araçuaí'
3134103	"ITUETA"	31	-41.225631912755	-19.3923977847252	3108	'Vale do Rio Doce'	31041	'Aimorés'
3134202	"ITUIUTABA"	31	-49.4622351892104	-18.973067680916	3105	'Triângulo Mineiro/Alto Paranaíba'	31017	'Ituiutaba'
3134301	"ITUMIRIM"	31	-44.8757878460442	-21.313796338098	3111	'Campo das Vertentes'	31057	'Lavras'
3134400	"ITURAMA"	31	-50.2019735753731	-19.7319475242371	3105	'Triângulo Mineiro/Alto Paranaíba'	31021	'Frutal'
3134509	"ITUTINGA"	31	-44.6588381542144	-21.2960563593091	3111	'Campo das Vertentes'	31057	'Lavras'
3134608	"JABOTICATUBAS"	31	-43.7473336329577	-19.5222886181808	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3134707	"JACINTO"	31	-40.2914288341066	-16.1411618529223	3103	'Jequitinhonha'	31014	'Almenara'
3134806	"JACUI"	31	-46.7420103807098	-21.0176021589274	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3134905	"JACUTINGA"	31	-46.6123411663105	-22.286638029799	3110	'Sul/Sudoeste de Minas'	31051	'Poços de Caldas'
3135001	"JAGUARACU"	31	-42.7529990591999	-19.6470726974423	3108	'Vale do Rio Doce'	31039	'Ipatinga'
3135050	"JAIBA"	31	-43.6703288759639	-15.3429340536125	3102	'Norte de Minas'	31004	'Janaúba'
3135076	"JAMPRUCA"	31	-41.8101692473884	-18.4615985742441	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3135100	"JANAUBA"	31	-43.3076829437623	-15.7990284583669	3102	'Norte de Minas'	31004	'Janaúba'
3135209	"JANUARIA"	31	-44.3598053349032	-15.4878728139879	3102	'Norte de Minas'	31003	'Januária'
3135308	"JAPARAIBA"	31	-45.5041178058938	-20.1416175950709	3106	'Central Mineira'	31026	'Bom Despacho'
3135357	"JAPONVAR"	31	-44.2761272371548	-16.0009569335553	3102	'Norte de Minas'	31007	'Montes Claros'
3135407	"JECEABA"	31	-43.9852319173302	-20.5330334382926	3107	'Metropolitana de Belo Horizonte'	31032	'Itaguara'
3135456	"JENIPAPO DE MINAS"	31	-42.2560474559329	-17.0804230780923	3103	'Jequitinhonha'	31011	'Capelinha'
3135506	"JEQUERI"	31	-42.6822636838868	-20.4463030375066	3112	'Zona da Mata'	31060	'Ponte Nova'
3135605	"JEQUITAI"	31	-44.4416872765915	-17.2163725570715	3102	'Norte de Minas'	31006	'Pirapora'
3135704	"JEQUITIBA"	31	-44.0280763937239	-19.2376735101776	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3135803	"JEQUITINHONHA"	31	-41.0071154423797	-16.4417689423789	3103	'Jequitinhonha'	31014	'Almenara'
3135902	"JESUANIA"	31	-45.2908769703791	-21.9984256960601	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3136009	"JOAIMA"	31	-41.0230530136668	-16.6547296379851	3103	'Jequitinhonha'	31014	'Almenara'
3136108	"JOANESIA"	31	-42.6747016823061	-19.1686956741327	3108	'Vale do Rio Doce'	31039	'Ipatinga'
3136207	"JOAO MONLEVADE"	31	-43.1745712712595	-19.8056386938267	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3136306	"JOAO PINHEIRO"	31	-46.1754635512704	-17.7418529395634	3101	'Noroeste de Minas'	31002	'Paracatu'
3136405	"JOAQUIM FELICIO"	31	-44.1736047177658	-17.7552943065804	3106	'Central Mineira'	31025	'Curvelo'
3136504	"JORDANIA"	31	-40.1800141591305	-15.9010651064361	3103	'Jequitinhonha'	31014	'Almenara'
3136520	"JOSE GONCALVES DE MINAS"	31	-42.6071746086131	-16.9071819765672	3103	'Jequitinhonha'	31011	'Capelinha'
3136553	"JOSE RAYDAN"	31	-42.5005902687836	-18.2174949411939	3108	'Vale do Rio Doce'	31036	'Peçanha'
3136579	"JOSENOPOLIS"	31	-42.513137018713	-16.5445254003468	3102	'Norte de Minas'	31008	'Grão Mogol'
3136652	"JUATUBA"	31	-44.3413314409208	-19.9557908623338	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3136702	"JUIZ DE FORA"	31	-43.3488172724747	-21.7609243086743	3112	'Zona da Mata'	31065	'Juiz de Fora'
3136801	"JURAMENTO"	31	-43.5901936206433	-16.8512704550027	3102	'Norte de Minas'	31007	'Montes Claros'
3136900	"JURUAIA"	31	-46.580596484704	-21.2493559380963	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3136959	"JUVENILIA"	31	-44.1595897099682	-14.2635945628851	3102	'Norte de Minas'	31003	'Januária'
3137007	"LADAINHA"	31	-41.7404499396581	-17.6244796696875	3104	'Vale do Mucuri'	31015	'Teófilo Otoni'
3137106	"LAGAMAR"	31	-46.8125356350839	-18.1769616222933	3101	'Noroeste de Minas'	31002	'Paracatu'
3137205	"LAGOA DA PRATA"	31	-45.5416920320703	-20.0237653293211	3106	'Central Mineira'	31026	'Bom Despacho'
3137304	"LAGOA DOS PATOS"	31	-44.5783346323487	-16.9784492004609	3102	'Norte de Minas'	31006	'Pirapora'
3137403	"LAGOA DOURADA"	31	-44.0711164400161	-20.918598617034	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3137502	"LAGOA FORMOSA"	31	-46.4065287919616	-18.7755725803991	3105	'Triângulo Mineiro/Alto Paranaíba'	31020	'Patos de Minas'
3137536	"LAGOA GRANDE"	31	-46.5179054003776	-17.8380469908804	3101	'Noroeste de Minas'	31002	'Paracatu'
3137601	"LAGOA SANTA"	31	-43.8952876969413	-19.6258505201125	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3137700	"LAJINHA"	31	-41.645293037911	-20.1641701467971	3112	'Zona da Mata'	31061	'Manhuaçu'
3137809	"LAMBARI"	31	-45.3524788134755	-21.9743155557077	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3137908	"LAMIM"	31	-43.4744670605853	-20.7920574262943	3112	'Zona da Mata'	31062	'Viçosa'
3138005	"LARANJAL"	31	-42.4806742915843	-21.3636296128678	3112	'Zona da Mata'	31066	'Cataguases'
3138104	"LASSANCE"	31	-44.5793585587481	-17.8951151805206	3102	'Norte de Minas'	31006	'Pirapora'
3138203	"LAVRAS"	31	-44.9999311091152	-21.2428702373008	3111	'Campo das Vertentes'	31057	'Lavras'
3138302	"LEANDRO FERREIRA"	31	-45.0262837852859	-19.7192234719511	3106	'Central Mineira'	31026	'Bom Despacho'
3138351	"LEME DO PRADO"	31	-42.6956826242014	-17.0838668461657	3103	'Jequitinhonha'	31011	'Capelinha'
3138401	"LEOPOLDINA"	31	-42.6418441295043	-21.530729364529	3112	'Zona da Mata'	31066	'Cataguases'
3138500	"LIBERDADE"	31	-44.3151409364083	-22.0243587047764	3110	'Sul/Sudoeste de Minas'	31055	'Andrelândia'
3138609	"LIMA DUARTE"	31	-43.796383224017	-21.8410955180842	3112	'Zona da Mata'	31065	'Juiz de Fora'
3138625	"LIMEIRA DO OESTE"	31	-50.5752903741881	-19.5477771592959	3105	'Triângulo Mineiro/Alto Paranaíba'	31021	'Frutal'
3138658	"LONTRA"	31	-44.3061148191293	-15.9020583529967	3102	'Norte de Minas'	31007	'Montes Claros'
3138674	"LUISBURGO"	31	-42.1064719035898	-20.4383761082781	3112	'Zona da Mata'	31061	'Manhuaçu'
3138682	"LUISLANDIA"	31	-44.5860484270339	-16.1153114861604	3102	'Norte de Minas'	31007	'Montes Claros'
3138708	"LUMINARIAS"	31	-44.9061064796858	-21.5123199001778	3111	'Campo das Vertentes'	31057	'Lavras'
3138807	"LUZ"	31	-45.6838812680545	-19.7962466218588	3106	'Central Mineira'	31026	'Bom Despacho'
3138906	"MACHACALIS"	31	-40.7204221322494	-17.0773703528882	3104	'Vale do Mucuri'	31016	'Nanuque'
3139003	"MACHADO"	31	-45.9217640832215	-21.6783538964701	3110	'Sul/Sudoeste de Minas'	31049	'Alfenas'
3139102	"MADRE DE DEUS DE MINAS"	31	-44.3408859114965	-21.477322068925	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3139201	"MALACACHETA"	31	-42.0760767010133	-17.8416225399766	3104	'Vale do Mucuri'	31015	'Teófilo Otoni'
3139250	"MAMONAS"	31	-42.955964349258	-15.0516469177915	3102	'Norte de Minas'	31004	'Janaúba'
3139300	"MANGA"	31	-43.9367615223531	-14.7559221144299	3102	'Norte de Minas'	31003	'Januária'
3139409	"MANHUACU"	31	-42.0338482904372	-20.2586800832824	3112	'Zona da Mata'	31061	'Manhuaçu'
3139508	"MANHUMIRIM"	31	-41.9626798073714	-20.3639991114518	3112	'Zona da Mata'	31061	'Manhuaçu'
3139607	"MANTENA"	31	-40.9785257407467	-18.7806998749734	3108	'Vale do Rio Doce'	31038	'Mantena'
3139805	"MAR DE ESPANHA"	31	-43.008406754404	-21.8668933765816	3112	'Zona da Mata'	31065	'Juiz de Fora'
3139706	"MARAVILHAS"	31	-44.6760761301857	-19.5146797200647	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3139904	"MARIA DA FE"	31	-45.371053690755	-22.3072187775991	3110	'Sul/Sudoeste de Minas'	31056	'Itajubá'
3140001	"MARIANA"	31	-43.4161404121375	-20.3744932308933	3107	'Metropolitana de Belo Horizonte'	31033	'Ouro Preto'
3140100	"MARILAC"	31	-42.0816889525875	-18.5049724110901	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3140159	"MARIO CAMPOS"	31	-44.1858252961843	-20.0536364124057	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3140209	"MARIPA DE MINAS"	31	-42.9683499274736	-21.6922627509639	3112	'Zona da Mata'	31065	'Juiz de Fora'
3140308	"MARLIERIA"	31	-42.737379035917	-19.7064561098251	3108	'Vale do Rio Doce'	31039	'Ipatinga'
3140407	"MARMELOPOLIS"	31	-45.1600478024722	-22.4465170977661	3110	'Sul/Sudoeste de Minas'	31056	'Itajubá'
3140506	"MARTINHO CAMPOS"	31	-45.2386503971405	-19.3297423483367	3106	'Central Mineira'	31026	'Bom Despacho'
3140530	"MARTINS SOARES"	31	-41.8757909081753	-20.2582291959846	3112	'Zona da Mata'	31061	'Manhuaçu'
3140555	"MATA VERDE"	31	-40.7385334084693	-15.6876678048477	3103	'Jequitinhonha'	31014	'Almenara'
3140605	"MATERLANDIA"	31	-43.0573759058743	-18.4727736734063	3108	'Vale do Rio Doce'	31035	'Guanhães'
3140704	"MATEUS LEME"	31	-44.4289912352272	-19.9908681368469	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3171501	"MATHIAS LOBATO"	31	-41.9233604609168	-18.5795889082626	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3140803	"MATIAS BARBOSA"	31	-43.3191619887632	-21.8694792710752	3112	'Zona da Mata'	31065	'Juiz de Fora'
3140852	"MATIAS CARDOSO"	31	-43.9178264365666	-14.8502838776958	3102	'Norte de Minas'	31003	'Januária'
3140902	"MATIPO"	31	-42.3414864060946	-20.2871482524922	3112	'Zona da Mata'	31061	'Manhuaçu'
3141009	"MATO VERDE"	31	-42.8665147238001	-15.3973215529759	3102	'Norte de Minas'	31004	'Janaúba'
3141108	"MATOZINHOS"	31	-44.0839745678654	-19.5619102810389	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3141207	"MATUTINA"	31	-45.9835170334863	-19.2266120633451	3105	'Triângulo Mineiro/Alto Paranaíba'	31020	'Patos de Minas'
3141306	"MEDEIROS"	31	-46.2266888203747	-19.9933078776241	3109	'Oeste de Minas'	31042	'Piuí'
3141405	"MEDINA"	31	-41.47630906692	-16.2247956209704	3103	'Jequitinhonha'	31013	'Pedra Azul'
3141504	"MENDES PIMENTEL"	31	-41.4056151686685	-18.661777740612	3108	'Vale do Rio Doce'	31038	'Mantena'
3141603	"MERCES"	31	-43.3410701613993	-21.1920649246761	3112	'Zona da Mata'	31064	'Ubá'
3141702	"MESQUITA"	31	-42.6056610568179	-19.2243458124531	3108	'Vale do Rio Doce'	31039	'Ipatinga'
3141801	"MINAS NOVAS"	31	-42.5967587107471	-17.2154581636337	3103	'Jequitinhonha'	31011	'Capelinha'
3141900	"MINDURI"	31	-44.6092928194542	-21.6775434808097	3110	'Sul/Sudoeste de Minas'	31055	'Andrelândia'
3142007	"MIRABELA"	31	-44.1606437772011	-16.2584529385286	3102	'Norte de Minas'	31007	'Montes Claros'
3142106	"MIRADOURO"	31	-42.3461498563434	-20.8944190662135	3112	'Zona da Mata'	31063	'Muriaé'
3142205	"MIRAI"	31	-42.6160395902808	-21.1939817415147	3112	'Zona da Mata'	31063	'Muriaé'
3142254	"MIRAVANIA"	31	-44.4120754278479	-14.7478394007116	3102	'Norte de Minas'	31003	'Januária'
3142304	"MOEDA"	31	-44.047568670537	-20.3302688429873	3107	'Metropolitana de Belo Horizonte'	31032	'Itaguara'
3142403	"MOEMA"	31	-45.425310133709	-19.8386998978716	3106	'Central Mineira'	31026	'Bom Despacho'
3142502	"MONJOLOS"	31	-44.1193167724144	-18.3236856182628	3106	'Central Mineira'	31025	'Curvelo'
3142601	"MONSENHOR PAULO"	31	-45.5450741387173	-21.7617721380658	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3142700	"MONTALVANIA"	31	-44.3636205825571	-14.4203647785697	3102	'Norte de Minas'	31003	'Januária'
3142809	"MONTE ALEGRE DE MINAS"	31	-48.8771169089609	-18.8691667166174	3105	'Triângulo Mineiro/Alto Paranaíba'	31018	'Uberlândia'
3142908	"MONTE AZUL"	31	-42.8731654940395	-15.1553385887242	3102	'Norte de Minas'	31004	'Janaúba'
3143005	"MONTE BELO"	31	-46.3682455768311	-21.3271458474544	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3143104	"MONTE CARMELO"	31	-47.4959724312194	-18.7290384400921	3105	'Triângulo Mineiro/Alto Paranaíba'	31019	'Patrocínio'
3143153	"MONTE FORMOSO"	31	-41.2545787417996	-16.8664938299771	3103	'Jequitinhonha'	31014	'Almenara'
3143203	"MONTE SANTO DE MINAS"	31	-46.9771185470619	-21.1904748350993	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3143401	"MONTE SIAO"	31	-46.5737026933609	-22.4335488211534	3110	'Sul/Sudoeste de Minas'	31051	'Poços de Caldas'
3143302	"MONTES CLAROS"	31	-43.8654224343832	-16.7227066399838	3102	'Norte de Minas'	31007	'Montes Claros'
3143450	"MONTEZUMA"	31	-42.50747369917	-15.1711441584771	3102	'Norte de Minas'	31005	'Salinas'
3143500	"MORADA NOVA DE MINAS"	31	-45.3555023480963	-18.6074447216394	3106	'Central Mineira'	31024	'Três Marias'
3143609	"MORRO DA GARCA"	31	-44.6035310348425	-18.5472184629381	3106	'Central Mineira'	31025	'Curvelo'
3143708	"MORRO DO PILAR"	31	-43.3748041822981	-19.2183422251452	3107	'Metropolitana de Belo Horizonte'	31028	'Conceição do Mato Dentro'
3143807	"MUNHOZ"	31	-46.3603709348441	-22.6127826889517	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3143906	"MURIAE"	31	-42.3610748978923	-21.1320467915102	3112	'Zona da Mata'	31063	'Muriaé'
3144003	"MUTUM"	31	-41.4391385240539	-19.8071892243168	3108	'Vale do Rio Doce'	31041	'Aimorés'
3144102	"MUZAMBINHO"	31	-46.5268046885479	-21.3730127526952	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3144201	"NACIP RAYDAN"	31	-42.2517915937101	-18.4579241926549	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3144300	"NANUQUE"	31	-40.3517388336104	-17.8389933519387	3104	'Vale do Mucuri'	31016	'Nanuque'
3144359	"NAQUE"	31	-42.3347084488518	-19.2235434748675	3108	'Vale do Rio Doce'	31039	'Ipatinga'
3144375	"NATALANDIA"	31	-46.4975343552908	-16.5038364836175	3101	'Noroeste de Minas'	31001	'Unaí'
3144409	"NATERCIA"	31	-45.5182345056536	-22.1184737389404	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3144508	"NAZARENO"	31	-44.6172346644262	-21.2176969671605	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3144607	"NEPOMUCENO"	31	-45.237429119816	-21.2345769350247	3111	'Campo das Vertentes'	31057	'Lavras'
3144656	"NINHEIRA"	31	-41.7487889593795	-15.3238019191961	3102	'Norte de Minas'	31005	'Salinas'
3144672	"NOVA BELEM"	31	-41.103687832357	-18.4940908207838	3108	'Vale do Rio Doce'	31038	'Mantena'
3144706	"NOVA ERA"	31	-43.0354568497189	-19.7644230686327	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3144805	"NOVA LIMA"	31	-43.8497833626163	-19.9838929938666	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3144904	"NOVA MODICA"	31	-41.5013362739996	-18.4416056135454	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3145000	"NOVA PONTE"	31	-47.670570749698	-19.1688916492638	3105	'Triângulo Mineiro/Alto Paranaíba'	31023	'Araxá'
3145059	"NOVA PORTEIRINHA"	31	-43.3025512295159	-15.8022101967311	3102	'Norte de Minas'	31004	'Janaúba'
3145109	"NOVA RESENDE"	31	-46.4170291046065	-21.1266519125721	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3145208	"NOVA SERRANA"	31	-44.9855787363319	-19.875867380562	3109	'Oeste de Minas'	31043	'Divinópolis'
3136603	"NOVA UNIAO"	31	-43.5799944146644	-19.6881033680241	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3145307	"NOVO CRUZEIRO"	31	-41.8753915421219	-17.4748888552055	3103	'Jequitinhonha'	31012	'Araçuaí'
3145356	"NOVO ORIENTE DE MINAS"	31	-41.2220966101202	-17.4091656808734	3104	'Vale do Mucuri'	31015	'Teófilo Otoni'
3145372	"NOVORIZONTE"	31	-42.4167808370082	-16.0195385667832	3102	'Norte de Minas'	31005	'Salinas'
3145406	"OLARIA"	31	-43.9309268801853	-21.8647729424271	3112	'Zona da Mata'	31065	'Juiz de Fora'
3145455	"OLHOS-D'AGUA"	31	-43.5714109825145	-17.4018999265273	3102	'Norte de Minas'	31009	'Bocaiúva'
3145505	"OLIMPIO NORONHA"	31	-45.2641356959281	-22.066959814499	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3145604	"OLIVEIRA"	31	-44.826410866482	-20.6975157761844	3109	'Oeste de Minas'	31046	'Oliveira'
3145703	"OLIVEIRA FORTES"	31	-43.462543869181	-21.3394932742632	3112	'Zona da Mata'	31065	'Juiz de Fora'
3145802	"ONCA DE PITANGUI"	31	-44.8083821799508	-19.745524484591	3107	'Metropolitana de Belo Horizonte'	31029	'Pará de Minas'
3145851	"ORATORIOS"	31	-42.8063392207749	-20.4309959520838	3112	'Zona da Mata'	31060	'Ponte Nova'
3145877	"ORIZANIA"	31	-42.2029460820898	-20.5041213742453	3112	'Zona da Mata'	31063	'Muriaé'
3145901	"OURO BRANCO"	31	-43.6947707969396	-20.5235831235093	3107	'Metropolitana de Belo Horizonte'	31034	'Conselheiro Lafaiete'
3146008	"OURO FINO"	31	-46.3800808287623	-22.2835244238733	3110	'Sul/Sudoeste de Minas'	31051	'Poços de Caldas'
3146107	"OURO PRETO"	31	-43.5064475197137	-20.3867763678658	3107	'Metropolitana de Belo Horizonte'	31033	'Ouro Preto'
3146206	"OURO VERDE DE MINAS"	31	-41.268709492315	-18.0693390949826	3104	'Vale do Mucuri'	31015	'Teófilo Otoni'
3146255	"PADRE CARVALHO"	31	-42.5207448266403	-16.3651032683092	3102	'Norte de Minas'	31008	'Grão Mogol'
3146305	"PADRE PARAISO"	31	-41.4849648092247	-17.076318651422	3103	'Jequitinhonha'	31012	'Araçuaí'
3146552	"PAI PEDRO"	31	-43.0705559756113	-15.537065987525	3102	'Norte de Minas'	31004	'Janaúba'
3146404	"PAINEIRAS"	31	-45.5387576862268	-18.9022172143692	3106	'Central Mineira'	31024	'Três Marias'
3146503	"PAINS"	31	-45.660813183335	-20.3709172455363	3109	'Oeste de Minas'	31044	'Formiga'
3146602	"PAIVA"	31	-43.4188333732522	-21.2878522493125	3112	'Zona da Mata'	31065	'Juiz de Fora'
3146701	"PALMA"	31	-42.3158258828457	-21.3725611558571	3112	'Zona da Mata'	31066	'Cataguases'
3146750	"PALMOPOLIS"	31	-40.4203975983825	-16.7344674967349	3103	'Jequitinhonha'	31014	'Almenara'
3146909	"PAPAGAIOS"	31	-44.7447017250618	-19.4555367596145	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3147105	"PARA DE MINAS"	31	-44.6053801878937	-19.8647379639463	3107	'Metropolitana de Belo Horizonte'	31029	'Pará de Minas'
3147006	"PARACATU"	31	-46.8754188909564	-17.219741910187	3101	'Noroeste de Minas'	31002	'Paracatu'
3147204	"PARAGUACU"	31	-45.7326954707608	-21.5473160267618	3110	'Sul/Sudoeste de Minas'	31049	'Alfenas'
3147303	"PARAISOPOLIS"	31	-45.7817035280062	-22.5551927714903	3110	'Sul/Sudoeste de Minas'	31056	'Itajubá'
3147402	"PARAOPEBA"	31	-44.403116870288	-19.2814289520739	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3147600	"PASSA QUATRO"	31	-44.9696386730973	-22.3897981316188	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3147709	"PASSA TEMPO"	31	-44.4934171989932	-20.652387747284	3109	'Oeste de Minas'	31046	'Oliveira'
3147808	"PASSA-VINTE"	31	-44.2310487920843	-22.208976878402	3110	'Sul/Sudoeste de Minas'	31055	'Andrelândia'
3147501	"PASSABEM"	31	-43.1438137394836	-19.3509824791921	3107	'Metropolitana de Belo Horizonte'	31028	'Conceição do Mato Dentro'
3147907	"PASSOS"	31	-46.6114125680355	-20.7192119018634	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3147956	"PATIS"	31	-44.0827053066768	-16.0792763596562	3102	'Norte de Minas'	31007	'Montes Claros'
3148004	"PATOS DE MINAS"	31	-46.5159156766059	-18.5925708199234	3105	'Triângulo Mineiro/Alto Paranaíba'	31020	'Patos de Minas'
3148103	"PATROCINIO"	31	-46.9974382401645	-18.9408129613497	3105	'Triângulo Mineiro/Alto Paranaíba'	31019	'Patrocínio'
3148202	"PATROCINIO DO MURIAE"	31	-42.2126532982876	-21.1517112745085	3112	'Zona da Mata'	31063	'Muriaé'
3148301	"PAULA CANDIDO"	31	-42.9831550986696	-20.8701615330242	3112	'Zona da Mata'	31062	'Viçosa'
3148400	"PAULISTAS"	31	-42.8726250989216	-18.4317377127072	3108	'Vale do Rio Doce'	31035	'Guanhães'
3148509	"PAVAO"	31	-41.0001132091318	-17.4326895767166	3104	'Vale do Mucuri'	31015	'Teófilo Otoni'
3148608	"PECANHA"	31	-42.563186267502	-18.5468889887705	3108	'Vale do Rio Doce'	31036	'Peçanha'
3148707	"PEDRA AZUL"	31	-41.2817519782488	-16.0059227890656	3103	'Jequitinhonha'	31013	'Pedra Azul'
3148756	"PEDRA BONITA"	31	-42.3321344916825	-20.5200184905724	3112	'Zona da Mata'	31061	'Manhuaçu'
3148806	"PEDRA DO ANTA"	31	-42.7159333247726	-20.5960112647687	3112	'Zona da Mata'	31062	'Viçosa'
3148905	"PEDRA DO INDAIA"	31	-45.2098100905663	-20.2535964014334	3109	'Oeste de Minas'	31044	'Formiga'
3149002	"PEDRA DOURADA"	31	-42.1545386689724	-20.8299461552485	3112	'Zona da Mata'	31063	'Muriaé'
3149101	"PEDRALVA"	31	-45.4659715175691	-22.254226003118	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3149150	"PEDRAS DE MARIA DA CRUZ"	31	-44.3924439591511	-15.5990124531728	3102	'Norte de Minas'	31003	'Januária'
3149200	"PEDRINOPOLIS"	31	-47.4606173926482	-19.2277204066822	3105	'Triângulo Mineiro/Alto Paranaíba'	31023	'Araxá'
3149309	"PEDRO LEOPOLDO"	31	-44.045883960309	-19.6183958909548	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3149408	"PEDRO TEIXEIRA"	31	-43.7454590571945	-21.7068071496686	3112	'Zona da Mata'	31065	'Juiz de Fora'
3149507	"PEQUERI"	31	-43.126286174621	-21.8369041285086	3112	'Zona da Mata'	31065	'Juiz de Fora'
3149606	"PEQUI"	31	-44.653441896498	-19.6279870911321	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3149705	"PERDIGAO"	31	-45.0793625822689	-19.9551229354497	3109	'Oeste de Minas'	31043	'Divinópolis'
3149804	"PERDIZES"	31	-47.2920084470812	-19.3386575248866	3105	'Triângulo Mineiro/Alto Paranaíba'	31023	'Araxá'
3149903	"PERDOES"	31	-45.0930878294041	-21.0945188675979	3109	'Oeste de Minas'	31045	'Campo Belo'
3149952	"PERIQUITO"	31	-42.2347246280497	-19.1544849011065	3108	'Vale do Rio Doce'	31039	'Ipatinga'
3150000	"PESCADOR"	31	-41.6016228175806	-18.3536287289768	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3150109	"PIAU"	31	-43.329125174333	-21.5046175293695	3112	'Zona da Mata'	31065	'Juiz de Fora'
3150158	"PIEDADE DE CARATINGA"	31	-42.0742639715865	-19.7592126249565	3108	'Vale do Rio Doce'	31040	'Caratinga'
3150208	"PIEDADE DE PONTE NOVA"	31	-42.7352388987405	-20.2476646154438	3112	'Zona da Mata'	31060	'Ponte Nova'
3150307	"PIEDADE DO RIO GRANDE"	31	-44.2025017471596	-21.4697328736348	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3150406	"PIEDADE DOS GERAIS"	31	-44.2279160102123	-20.4610103538288	3107	'Metropolitana de Belo Horizonte'	31032	'Itaguara'
3150505	"PIMENTA"	31	-45.7990870292463	-20.4831953924347	3109	'Oeste de Minas'	31044	'Formiga'
3150539	"PINGO-D'AGUA"	31	-42.4086657783621	-19.7286082528472	3108	'Vale do Rio Doce'	31040	'Caratinga'
3150570	"PINTOPOLIS"	31	-45.1495068805966	-16.0549897298845	3102	'Norte de Minas'	31003	'Januária'
3150604	"PIRACEMA"	31	-44.4784717749718	-20.508995862821	3109	'Oeste de Minas'	31046	'Oliveira'
3150703	"PIRAJUBA"	31	-48.6966380638012	-19.9085049086271	3105	'Triângulo Mineiro/Alto Paranaíba'	31021	'Frutal'
3150802	"PIRANGA"	31	-43.2873455533564	-20.6851438161544	3112	'Zona da Mata'	31062	'Viçosa'
3150901	"PIRANGUCU"	31	-45.4932717049665	-22.5264938453732	3110	'Sul/Sudoeste de Minas'	31056	'Itajubá'
3151008	"PIRANGUINHO"	31	-45.5347391785866	-22.4118730678437	3110	'Sul/Sudoeste de Minas'	31056	'Itajubá'
3151107	"PIRAPETINGA"	31	-42.3484310466426	-21.6559720071799	3112	'Zona da Mata'	31066	'Cataguases'
3151206	"PIRAPORA"	31	-44.9510653804875	-17.3495820956098	3102	'Norte de Minas'	31006	'Pirapora'
3151305	"PIRAUBA"	31	-43.0181308108699	-21.2765501292586	3112	'Zona da Mata'	31064	'Ubá'
3151404	"PITANGUI"	31	-44.8901188906692	-19.6805972412923	3107	'Metropolitana de Belo Horizonte'	31029	'Pará de Minas'
3151503	"PIUMHI"	31	-45.9605686667875	-20.4708828676222	3109	'Oeste de Minas'	31042	'Piuí'
3151602	"PLANURA"	31	-48.699918855179	-20.1386632020283	3105	'Triângulo Mineiro/Alto Paranaíba'	31021	'Frutal'
3151701	"POCO FUNDO"	31	-45.9649695631605	-21.7846925499932	3110	'Sul/Sudoeste de Minas'	31049	'Alfenas'
3151800	"POCOS DE CALDAS"	31	-46.5664100449604	-21.7873635785949	3110	'Sul/Sudoeste de Minas'	31051	'Poços de Caldas'
3151909	"POCRANE"	31	-41.6290012532568	-19.6201444044024	3108	'Vale do Rio Doce'	31041	'Aimorés'
3152006	"POMPEU"	31	-45.0018708585068	-19.2209571770945	3106	'Central Mineira'	31024	'Três Marias'
3152105	"PONTE NOVA"	31	-42.9096842699379	-20.4166434224879	3112	'Zona da Mata'	31060	'Ponte Nova'
3152131	"PONTO CHIQUE"	31	-45.0631345096394	-16.6330397392495	3102	'Norte de Minas'	31007	'Montes Claros'
3152170	"PONTO DOS VOLANTES"	31	-41.5078082034317	-16.754519633283	3103	'Jequitinhonha'	31012	'Araçuaí'
3152204	"PORTEIRINHA"	31	-43.0285226494433	-15.746837727003	3102	'Norte de Minas'	31004	'Janaúba'
3152303	"PORTO FIRME"	31	-43.0914109084357	-20.6682669693677	3112	'Zona da Mata'	31062	'Viçosa'
3152402	"POTE"	31	-41.7883855248752	-17.8013694472947	3104	'Vale do Mucuri'	31015	'Teófilo Otoni'
3152501	"POUSO ALEGRE"	31	-45.9371442758265	-22.2303029951548	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3152600	"POUSO ALTO"	31	-44.9753435743211	-22.190942292589	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3152709	"PRADOS"	31	-44.0732802771838	-21.0560144581482	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3152808	"PRATA"	31	-48.9238460694599	-19.3082112062986	3105	'Triângulo Mineiro/Alto Paranaíba'	31018	'Uberlândia'
3152907	"PRATAPOLIS"	31	-46.8609173417016	-20.7441844539654	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3153004	"PRATINHA"	31	-46.3784486441064	-19.7569452522589	3105	'Triângulo Mineiro/Alto Paranaíba'	31023	'Araxá'
3153103	"PRESIDENTE BERNARDES"	31	-43.1900555792424	-20.7656775010213	3112	'Zona da Mata'	31062	'Viçosa'
3153202	"PRESIDENTE JUSCELINO"	31	-44.0541822751655	-18.6407817383921	3106	'Central Mineira'	31025	'Curvelo'
3153301	"PRESIDENTE KUBITSCHEK"	31	-43.5574479486812	-18.6154898025756	3103	'Jequitinhonha'	31010	'Diamantina'
3153400	"PRESIDENTE OLEGARIO"	31	-46.4177886879906	-18.414741973875	3101	'Noroeste de Minas'	31002	'Paracatu'
3153608	"PRUDENTE DE MORAIS"	31	-44.1583906670618	-19.4835603824475	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3153707	"QUARTEL GERAL"	31	-45.5588633859592	-19.2676900955159	3106	'Central Mineira'	31026	'Bom Despacho'
3153806	"QUELUZITO"	31	-43.8800273028343	-20.7423844777111	3107	'Metropolitana de Belo Horizonte'	31034	'Conselheiro Lafaiete'
3153905	"RAPOSOS"	31	-43.8047741981268	-19.9655987691945	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3154002	"RAUL SOARES"	31	-42.4541675367435	-20.1019588519943	3112	'Zona da Mata'	31060	'Ponte Nova'
3154101	"RECREIO"	31	-42.4713945672859	-21.5337846187598	3112	'Zona da Mata'	31066	'Cataguases'
3154150	"REDUTO"	31	-41.9851988576302	-20.2426797034932	3112	'Zona da Mata'	31061	'Manhuaçu'
3154200	"RESENDE COSTA"	31	-44.2394035043136	-20.9173692442954	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3154309	"RESPLENDOR"	31	-41.2539671081682	-19.3254839308532	3108	'Vale do Rio Doce'	31041	'Aimorés'
3154408	"RESSAQUINHA"	31	-43.7587060938834	-21.0553009170043	3111	'Campo das Vertentes'	31059	'Barbacena'
3154457	"RIACHINHO"	31	-46.0027468183087	-16.2168261724193	3102	'Norte de Minas'	31006	'Pirapora'
3154507	"RIACHO DOS MACHADOS"	31	-43.0445637317792	-15.9980341607319	3102	'Norte de Minas'	31004	'Janaúba'
3154606	"RIBEIRAO DAS NEVES"	31	-44.085823649141	-19.766022015498	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3154705	"RIBEIRAO VERMELHO"	31	-45.064782108458	-21.1904143250473	3111	'Campo das Vertentes'	31057	'Lavras'
3154804	"RIO ACIMA"	31	-43.7908543768367	-20.0951301629183	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3154903	"RIO CASCA"	31	-42.6522301991544	-20.2265128664941	3112	'Zona da Mata'	31060	'Ponte Nova'
3155108	"RIO DO PRADO"	31	-40.5718939337966	-16.6094078454736	3103	'Jequitinhonha'	31014	'Almenara'
3155009	"RIO DOCE"	31	-42.8956813088344	-20.2446457034063	3112	'Zona da Mata'	31060	'Ponte Nova'
3155207	"RIO ESPERA"	31	-43.4653334003173	-20.8580800986411	3112	'Zona da Mata'	31062	'Viçosa'
3155306	"RIO MANSO"	31	-44.3102050445654	-20.2616823651625	3107	'Metropolitana de Belo Horizonte'	31032	'Itaguara'
3155405	"RIO NOVO"	31	-43.1286689152867	-21.4832491498789	3112	'Zona da Mata'	31065	'Juiz de Fora'
3155504	"RIO PARANAIBA"	31	-46.2427530916275	-19.191238301813	3105	'Triângulo Mineiro/Alto Paranaíba'	31020	'Patos de Minas'
3155603	"RIO PARDO DE MINAS"	31	-42.5412319786549	-15.6130780188597	3102	'Norte de Minas'	31005	'Salinas'
3155702	"RIO PIRACICABA"	31	-43.1798237456689	-19.9549411680991	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3155801	"RIO POMBA"	31	-43.1778056454032	-21.2721906098132	3112	'Zona da Mata'	31064	'Ubá'
3155900	"RIO PRETO"	31	-43.8294656655803	-22.086922252455	3112	'Zona da Mata'	31065	'Juiz de Fora'
3156007	"RIO VERMELHO"	31	-43.0224390980622	-18.3011105692073	3107	'Metropolitana de Belo Horizonte'	31028	'Conceição do Mato Dentro'
3156106	"RITAPOLIS"	31	-44.3234775238384	-21.0232532704209	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3156205	"ROCHEDO DE MINAS"	31	-43.0220685053826	-21.6314596314615	3112	'Zona da Mata'	31065	'Juiz de Fora'
3156304	"RODEIRO"	31	-42.8686762586127	-21.200705079223	3112	'Zona da Mata'	31064	'Ubá'
3156403	"ROMARIA"	31	-47.581754900456	-18.883480034872	3105	'Triângulo Mineiro/Alto Paranaíba'	31019	'Patrocínio'
3156452	"ROSARIO DA LIMEIRA"	31	-42.5060599702183	-20.981298201362	3112	'Zona da Mata'	31063	'Muriaé'
3156502	"RUBELITA"	31	-42.2647623323815	-16.4029664156926	3102	'Norte de Minas'	31005	'Salinas'
3156601	"RUBIM"	31	-40.5369414738532	-16.3729735166896	3103	'Jequitinhonha'	31014	'Almenara'
3156700	"SABARA"	31	-43.8255570903302	-19.8924945120897	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3156809	"SABINOPOLIS"	31	-43.088203642905	-18.6718146531902	3108	'Vale do Rio Doce'	31035	'Guanhães'
3156908	"SACRAMENTO"	31	-47.4365553163875	-19.8635763393531	3105	'Triângulo Mineiro/Alto Paranaíba'	31023	'Araxá'
3157005	"SALINAS"	31	-42.2935064722757	-16.1698557321158	3102	'Norte de Minas'	31005	'Salinas'
3157104	"SALTO DA DIVISA"	31	-39.9507560235873	-15.9975707021522	3103	'Jequitinhonha'	31014	'Almenara'
3157203	"SANTA BARBARA"	31	-43.4052209879755	-19.9655911927172	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3157252	"SANTA BARBARA DO LESTE"	31	-42.1408405819159	-19.9757926674141	3108	'Vale do Rio Doce'	31040	'Caratinga'
3157278	"SANTA BARBARA DO MONTE VERDE"	31	-43.7017741663928	-21.9572670150904	3112	'Zona da Mata'	31065	'Juiz de Fora'
3157302	"SANTA BARBARA DO TUGURIO"	31	-43.5589487842784	-21.2462083894654	3111	'Campo das Vertentes'	31059	'Barbacena'
3157336	"SANTA CRUZ DE MINAS"	31	-44.2232578483842	-21.1194710322007	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3157377	"SANTA CRUZ DE SALINAS"	31	-41.7503545267497	-16.0943556352834	3102	'Norte de Minas'	31005	'Salinas'
3157401	"SANTA CRUZ DO ESCALVADO"	31	-42.8184528533261	-20.2382772552792	3112	'Zona da Mata'	31060	'Ponte Nova'
3157500	"SANTA EFIGENIA DE MINAS"	31	-42.4393126685705	-18.8198378232138	3108	'Vale do Rio Doce'	31035	'Guanhães'
3157609	"SANTA FE DE MINAS"	31	-45.4136331221547	-16.6873734528009	3102	'Norte de Minas'	31006	'Pirapora'
3157658	"SANTA HELENA DE MINAS"	31	-40.6862886421122	-16.9363075336244	3104	'Vale do Mucuri'	31016	'Nanuque'
3157708	"SANTA JULIANA"	31	-47.5271443343503	-19.3112989337	3105	'Triângulo Mineiro/Alto Paranaíba'	31023	'Araxá'
3157807	"SANTA LUZIA"	31	-43.8500072606321	-19.7676168525221	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3157906	"SANTA MARGARIDA"	31	-42.2525357802654	-20.3779254268061	3112	'Zona da Mata'	31061	'Manhuaçu'
3158003	"SANTA MARIA DE ITABIRA"	31	-43.1101498441238	-19.4590107742798	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3158102	"SANTA MARIA DO SALTO"	31	-40.1469330149968	-16.2475726793913	3103	'Jequitinhonha'	31014	'Almenara'
3158201	"SANTA MARIA DO SUACUI"	31	-42.4178024504598	-18.1922522024908	3108	'Vale do Rio Doce'	31036	'Peçanha'
3159209	"SANTA RITA DE CALDAS"	31	-46.3386257813582	-22.026435486111	3110	'Sul/Sudoeste de Minas'	31051	'Poços de Caldas'
3159407	"SANTA RITA DE IBITIPOCA"	31	-43.9167605187734	-21.561230079445	3112	'Zona da Mata'	31065	'Juiz de Fora'
3159308	"SANTA RITA DE JACUTINGA"	31	-44.1004418543942	-22.1484611222255	3112	'Zona da Mata'	31065	'Juiz de Fora'
3159357	"SANTA RITA DE MINAS"	31	-42.1317808369165	-19.8752101701675	3108	'Vale do Rio Doce'	31040	'Caratinga'
3159506	"SANTA RITA DO ITUETO"	31	-41.379278217516	-19.3598130146739	3108	'Vale do Rio Doce'	31041	'Aimorés'
3159605	"SANTA RITA DO SAPUCAI"	31	-45.7039881925124	-22.2533298263696	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3159704	"SANTA ROSA DA SERRA"	31	-45.9706644273527	-19.532621138026	3105	'Triângulo Mineiro/Alto Paranaíba'	31020	'Patos de Minas'
3159803	"SANTA VITORIA"	31	-50.1234651115175	-18.8439479825626	3105	'Triângulo Mineiro/Alto Paranaíba'	31017	'Ituiutaba'
3158300	"SANTANA DA VARGEM"	31	-45.5071210487386	-21.2489621801898	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3158409	"SANTANA DE CATAGUASES"	31	-42.5546049490811	-21.2840280786181	3112	'Zona da Mata'	31066	'Cataguases'
3158508	"SANTANA DE PIRAPAMA"	31	-44.0381025080678	-19.0068859968553	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3158607	"SANTANA DO DESERTO"	31	-43.172317833716	-21.9496920444449	3112	'Zona da Mata'	31065	'Juiz de Fora'
3158706	"SANTANA DO GARAMBEU"	31	-44.110873430004	-21.6018318573641	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3158805	"SANTANA DO JACARE"	31	-45.1280485695678	-20.901677492437	3109	'Oeste de Minas'	31045	'Campo Belo'
3158904	"SANTANA DO MANHUACU"	31	-41.9234974642324	-20.1085461650507	3112	'Zona da Mata'	31061	'Manhuaçu'
3158953	"SANTANA DO PARAISO"	31	-42.552582949045	-19.3690985235546	3108	'Vale do Rio Doce'	31039	'Ipatinga'
3159001	"SANTANA DO RIACHO"	31	-43.7114593033951	-19.1700918689263	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3159100	"SANTANA DOS MONTES"	31	-43.7059982789998	-20.7897348514805	3107	'Metropolitana de Belo Horizonte'	31034	'Conselheiro Lafaiete'
3159902	"SANTO ANTONIO DO AMPARO"	31	-44.9186749352284	-20.9462485658306	3109	'Oeste de Minas'	31046	'Oliveira'
3160009	"SANTO ANTONIO DO AVENTUREIRO"	31	-42.8116372461193	-21.755828175855	3112	'Zona da Mata'	31066	'Cataguases'
3160108	"SANTO ANTONIO DO GRAMA"	31	-42.6138987970154	-20.3125002779396	3112	'Zona da Mata'	31060	'Ponte Nova'
3160207	"SANTO ANTONIO DO ITAMBE"	31	-43.3037794094908	-18.4689716455164	3107	'Metropolitana de Belo Horizonte'	31028	'Conceição do Mato Dentro'
3160306	"SANTO ANTONIO DO JACINTO"	31	-40.1753373252436	-16.537683409686	3103	'Jequitinhonha'	31014	'Almenara'
3160405	"SANTO ANTONIO DO MONTE"	31	-45.2939359191445	-20.0872192488794	3109	'Oeste de Minas'	31043	'Divinópolis'
3160454	"SANTO ANTONIO DO RETIRO"	31	-42.6243765156755	-15.3426335372695	3102	'Norte de Minas'	31005	'Salinas'
3160504	"SANTO ANTONIO DO RIO ABAIXO"	31	-43.2530571823808	-19.2256798037912	3107	'Metropolitana de Belo Horizonte'	31028	'Conceição do Mato Dentro'
3160603	"SANTO HIPOLITO"	31	-44.2216982205234	-18.2878101900473	3106	'Central Mineira'	31025	'Curvelo'
3160702	"SANTOS DUMONT"	31	-43.5537521652921	-21.4575319947014	3112	'Zona da Mata'	31065	'Juiz de Fora'
3160801	"SAO BENTO ABADE"	31	-45.0753606266928	-21.5790480164946	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3160900	"SAO BRAS DO SUACUI"	31	-43.9526746478891	-20.6265040684823	3107	'Metropolitana de Belo Horizonte'	31034	'Conselheiro Lafaiete'
3160959	"SAO DOMINGOS DAS DORES"	31	-42.0095079969034	-19.5294460672771	3108	'Vale do Rio Doce'	31040	'Caratinga'
3161007	"SAO DOMINGOS DO PRATA"	31	-42.960363400399	-19.8710279004362	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3161056	"SAO FELIX DE MINAS"	31	-41.490352828828	-18.5861055944553	3108	'Vale do Rio Doce'	31038	'Mantena'
3161106	"SAO FRANCISCO"	31	-44.8613127423766	-15.9525638055612	3102	'Norte de Minas'	31003	'Januária'
3161205	"SAO FRANCISCO DE PAULA"	31	-44.9826306199264	-20.7135317999445	3109	'Oeste de Minas'	31046	'Oliveira'
3161304	"SAO FRANCISCO DE SALES"	31	-49.7655663178882	-19.865114358282	3105	'Triângulo Mineiro/Alto Paranaíba'	31021	'Frutal'
3161403	"SAO FRANCISCO DO GLORIA"	31	-42.2682205326675	-20.7923014187189	3112	'Zona da Mata'	31063	'Muriaé'
3161502	"SAO GERALDO"	31	-42.8376641332472	-20.9208475279285	3112	'Zona da Mata'	31064	'Ubá'
3161601	"SAO GERALDO DA PIEDADE"	31	-42.28913506793	-18.8440313418778	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3161650	"SAO GERALDO DO BAIXIO"	31	-41.3636282368696	-18.9188085164172	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3161700	"SAO GONCALO DO ABAETE"	31	-45.8342461504009	-18.3411129280494	3101	'Noroeste de Minas'	31002	'Paracatu'
3161809	"SAO GONCALO DO PARA"	31	-44.857188983823	-19.9856847319035	3109	'Oeste de Minas'	31043	'Divinópolis'
3161908	"SAO GONCALO DO RIO ABAIXO"	31	-43.3480400193056	-19.8318007017906	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3125507	"SAO GONCALO DO RIO PRETO"	31	-43.3845437324083	-18.0063941614788	3103	'Jequitinhonha'	31010	'Diamantina'
3162005	"SAO GONCALO DO SAPUCAI"	31	-45.5946377949369	-21.8919051420956	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3162104	"SAO GOTARDO"	31	-46.0531440401029	-19.3127001913322	3105	'Triângulo Mineiro/Alto Paranaíba'	31020	'Patos de Minas'
3162203	"SAO JOAO BATISTA DO GLORIA"	31	-46.5034614693394	-20.6390368456458	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3162252	"SAO JOAO DA LAGOA"	31	-44.3490885621947	-16.8520551567279	3102	'Norte de Minas'	31007	'Montes Claros'
3162302	"SAO JOAO DA MATA"	31	-45.9265298075988	-21.9348528245237	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3162401	"SAO JOAO DA PONTE"	31	-44.0089551084967	-15.9245130654992	3102	'Norte de Minas'	31007	'Montes Claros'
3162450	"SAO JOAO DAS MISSOES"	31	-44.0812622895275	-14.8825334839124	3102	'Norte de Minas'	31003	'Januária'
3162500	"SAO JOAO DEL REI"	31	-44.2609727347292	-21.1355089743172	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3162559	"SAO JOAO DO MANHUACU"	31	-42.1521577505494	-20.3954998659809	3112	'Zona da Mata'	31061	'Manhuaçu'
3162575	"SAO JOAO DO MANTENINHA"	31	-41.158748442561	-18.7278374865803	3108	'Vale do Rio Doce'	31038	'Mantena'
3162609	"SAO JOAO DO ORIENTE"	31	-42.156459894962	-19.337666134262	3108	'Vale do Rio Doce'	31040	'Caratinga'
3162658	"SAO JOAO DO PACUI"	31	-44.5295709891001	-16.5383751445545	3102	'Norte de Minas'	31007	'Montes Claros'
3162708	"SAO JOAO DO PARAISO"	31	-42.0114224428155	-15.3184380950909	3102	'Norte de Minas'	31005	'Salinas'
3162807	"SAO JOAO EVANGELISTA"	31	-42.7760481433917	-18.5451868295064	3108	'Vale do Rio Doce'	31035	'Guanhães'
3162906	"SAO JOAO NEPOMUCENO"	31	-43.011285768504	-21.5356970635886	3112	'Zona da Mata'	31065	'Juiz de Fora'
3162922	"SAO JOAQUIM DE BICAS"	31	-44.2662730160972	-20.0634684606132	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3162948	"SAO JOSE DA BARRA"	31	-46.3193295708755	-20.7220909662412	3110	'Sul/Sudoeste de Minas'	31047	'Passos'
3162955	"SAO JOSE DA LAPA"	31	-43.9599562982337	-19.6986268215191	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3163003	"SAO JOSE DA SAFIRA"	31	-42.1464105249464	-18.3251174567601	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3163102	"SAO JOSE DA VARGINHA"	31	-44.5610597329864	-19.7048059868236	3107	'Metropolitana de Belo Horizonte'	31029	'Pará de Minas'
3163201	"SAO JOSE DO ALEGRE"	31	-45.5301876074668	-22.3290552486338	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3163300	"SAO JOSE DO DIVINO"	31	-41.3912087843896	-18.4832633219871	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3163409	"SAO JOSE DO GOIABAL"	31	-42.7098601268982	-19.9279832169656	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3163508	"SAO JOSE DO JACURI"	31	-42.6666267691673	-18.2758107503416	3108	'Vale do Rio Doce'	31036	'Peçanha'
3163607	"SAO JOSE DO MANTIMENTO"	31	-41.749072816426	-20.0059989819425	3112	'Zona da Mata'	31061	'Manhuaçu'
3163706	"SAO LOURENCO"	31	-45.0533731031446	-22.1177686713602	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3163805	"SAO MIGUEL DO ANTA"	31	-42.7208990463332	-20.7059175904583	3112	'Zona da Mata'	31062	'Viçosa'
3163904	"SAO PEDRO DA UNIAO"	31	-46.6213268893432	-21.1334584955414	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3164100	"SAO PEDRO DO SUACUI"	31	-42.6002319396511	-18.3655057595136	3108	'Vale do Rio Doce'	31036	'Peçanha'
3164001	"SAO PEDRO DOS FERROS"	31	-42.523900934801	-20.1719098245167	3112	'Zona da Mata'	31060	'Ponte Nova'
3164209	"SAO ROMAO"	31	-45.0691351971252	-16.3686392158312	3102	'Norte de Minas'	31006	'Pirapora'
3164308	"SAO ROQUE DE MINAS"	31	-46.3689949346399	-20.2506708115156	3109	'Oeste de Minas'	31042	'Piuí'
3164407	"SAO SEBASTIAO DA BELA VISTA"	31	-45.7547892088755	-22.1550057867841	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3164431	"SAO SEBASTIAO DA VARGEM ALEGRE"	31	-42.6386658919301	-21.0738303380808	3112	'Zona da Mata'	31063	'Muriaé'
3164472	"SAO SEBASTIAO DO ANTA"	31	-41.979598898526	-19.5001070899358	3108	'Vale do Rio Doce'	31040	'Caratinga'
3164506	"SAO SEBASTIAO DO MARANHAO"	31	-42.5657456966687	-18.0913715113299	3108	'Vale do Rio Doce'	31036	'Peçanha'
3164605	"SAO SEBASTIAO DO OESTE"	31	-45.0031339870159	-20.2740951951869	3109	'Oeste de Minas'	31043	'Divinópolis'
3164704	"SAO SEBASTIAO DO PARAISO"	31	-46.986471825605	-20.9180654486469	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3164803	"SAO SEBASTIAO DO RIO PRETO"	31	-43.1747344223136	-19.2857666703185	3107	'Metropolitana de Belo Horizonte'	31028	'Conceição do Mato Dentro'
3164902	"SAO SEBASTIAO DO RIO VERDE"	31	-44.9777360533972	-22.2150562279056	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3165206	"SAO THOME DAS LETRAS"	31	-44.9870084546217	-21.7207227802252	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3165008	"SAO TIAGO"	31	-44.5039924427307	-20.9009463498959	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3165107	"SAO TOMAS DE AQUINO"	31	-47.0967829718718	-20.7849943870432	3110	'Sul/Sudoeste de Minas'	31048	'São Sebastião do Paraíso'
3165305	"SAO VICENTE DE MINAS"	31	-44.4546835035525	-21.6974718375073	3110	'Sul/Sudoeste de Minas'	31055	'Andrelândia'
3165404	"SAPUCAI-MIRIM"	31	-45.7409257375558	-22.7515963809342	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3165503	"SARDOA"	31	-42.3661292228935	-18.7832653468761	3108	'Vale do Rio Doce'	31035	'Guanhães'
3165537	"SARZEDO"	31	-44.1458673612766	-20.0345349207995	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3165560	"SEM-PEIXE"	31	-42.8419017302093	-20.1025363692222	3112	'Zona da Mata'	31060	'Ponte Nova'
3165578	"SENADOR AMARAL"	31	-46.1802335937979	-22.5887215665658	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3165602	"SENADOR CORTES"	31	-42.9443320993964	-21.8025169575441	3112	'Zona da Mata'	31065	'Juiz de Fora'
3165701	"SENADOR FIRMINO"	31	-43.1041303932776	-20.9180596003151	3112	'Zona da Mata'	31064	'Ubá'
3165800	"SENADOR JOSE BENTO"	31	-46.1794726958333	-22.1666066776878	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3165909	"SENADOR MODESTINO GONCALVES"	31	-43.2229754714858	-17.9460246708404	3103	'Jequitinhonha'	31010	'Diamantina'
3166006	"SENHORA DE OLIVEIRA"	31	-43.3377319940151	-20.7938997631814	3112	'Zona da Mata'	31062	'Viçosa'
3166105	"SENHORA DO PORTO"	31	-43.0817557207791	-18.8980080199684	3108	'Vale do Rio Doce'	31035	'Guanhães'
3166204	"SENHORA DOS REMEDIOS"	31	-43.5863819522035	-21.0330829642424	3111	'Campo das Vertentes'	31059	'Barbacena'
3166303	"SERICITA"	31	-42.4820072656267	-20.4715553544651	3112	'Zona da Mata'	31060	'Ponte Nova'
3166402	"SERITINGA"	31	-44.5214453517545	-21.9113492777473	3110	'Sul/Sudoeste de Minas'	31055	'Andrelândia'
3166501	"SERRA AZUL DE MINAS"	31	-43.1744593090578	-18.3622797249824	3107	'Metropolitana de Belo Horizonte'	31028	'Conceição do Mato Dentro'
3166600	"SERRA DA SAUDADE"	31	-45.7965895746721	-19.4405622457509	3106	'Central Mineira'	31026	'Bom Despacho'
3166808	"SERRA DO SALITRE"	31	-46.692108726184	-19.1117957634513	3105	'Triângulo Mineiro/Alto Paranaíba'	31019	'Patrocínio'
3166709	"SERRA DOS AIMORES"	31	-40.2431685749409	-17.7857470182657	3104	'Vale do Mucuri'	31016	'Nanuque'
3166907	"SERRANIA"	31	-46.0431449357807	-21.5466806519747	3110	'Sul/Sudoeste de Minas'	31049	'Alfenas'
3166956	"SERRANOPOLIS DE MINAS"	31	-42.8743863930717	-15.8087837820719	3102	'Norte de Minas'	31004	'Janaúba'
3167004	"SERRANOS"	31	-44.5067541647369	-21.8887817979059	3110	'Sul/Sudoeste de Minas'	31055	'Andrelândia'
3167103	"SERRO"	31	-43.3886312680834	-18.6044422453401	3107	'Metropolitana de Belo Horizonte'	31028	'Conceição do Mato Dentro'
3167202	"SETE LAGOAS"	31	-44.239594615621	-19.4582874187508	3107	'Metropolitana de Belo Horizonte'	31027	'Sete Lagoas'
3165552	"SETUBINHA"	31	-42.166438310787	-17.5970190167039	3104	'Vale do Mucuri'	31015	'Teófilo Otoni'
3167301	"SILVEIRANIA"	31	-43.217878469846	-21.1646375385202	3112	'Zona da Mata'	31064	'Ubá'
3167400	"SILVIANOPOLIS"	31	-45.8324471455678	-22.0279972638563	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3167509	"SIMAO PEREIRA"	31	-43.3149558126212	-21.9648567892045	3112	'Zona da Mata'	31065	'Juiz de Fora'
3167608	"SIMONESIA"	31	-42.0038567486968	-20.1220295973937	3112	'Zona da Mata'	31061	'Manhuaçu'
3167707	"SOBRALIA"	31	-42.0986538397189	-19.2355492879039	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3167806	"SOLEDADE DE MINAS"	31	-45.0410226419628	-22.0592064057821	3110	'Sul/Sudoeste de Minas'	31054	'São Lourenço'
3167905	"TABULEIRO"	31	-43.2456052646167	-21.3575776594416	3112	'Zona da Mata'	31064	'Ubá'
3168002	"TAIOBEIRAS"	31	-42.2279155455793	-15.8115214376568	3102	'Norte de Minas'	31005	'Salinas'
3168051	"TAPARUBA"	31	-41.6158581306474	-19.7614695843439	3108	'Vale do Rio Doce'	31041	'Aimorés'
3168101	"TAPIRA"	31	-46.8219153621833	-19.9255792183172	3105	'Triângulo Mineiro/Alto Paranaíba'	31023	'Araxá'
3168200	"TAPIRAI"	31	-46.0185702098121	-19.8858056068801	3109	'Oeste de Minas'	31042	'Piuí'
3168309	"TAQUARACU DE MINAS"	31	-43.6871427896688	-19.6738480484131	3107	'Metropolitana de Belo Horizonte'	31031	'Itabira'
3168408	"TARUMIRIM"	31	-42.0077345774412	-19.2814948727844	3108	'Vale do Rio Doce'	31040	'Caratinga'
3168507	"TEIXEIRAS"	31	-42.8626438044107	-20.6490665250922	3112	'Zona da Mata'	31062	'Viçosa'
3168606	"TEOFILO OTONI"	31	-41.5096351657897	-17.862539808014	3104	'Vale do Mucuri'	31015	'Teófilo Otoni'
3168705	"TIMOTEO"	31	-42.6439423108068	-19.5840503585078	3108	'Vale do Rio Doce'	31039	'Ipatinga'
3168804	"TIRADENTES"	31	-44.1726923811067	-21.107043436755	3111	'Campo das Vertentes'	31058	'São João Del Rei'
3168903	"TIROS"	31	-45.9635510991526	-19.0039173800698	3105	'Triângulo Mineiro/Alto Paranaíba'	31020	'Patos de Minas'
3169000	"TOCANTINS"	31	-43.0186995083911	-21.175549526019	3112	'Zona da Mata'	31064	'Ubá'
3169059	"TOCOS DO MOJI"	31	-46.0964468007417	-22.3716455947385	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3169109	"TOLEDO"	31	-46.3789726564943	-22.7433948080707	3110	'Sul/Sudoeste de Minas'	31052	'Pouso Alegre'
3169208	"TOMBOS"	31	-42.0146816210783	-20.9025892250881	3112	'Zona da Mata'	31063	'Muriaé'
3169307	"TRES CORACOES"	31	-45.2549368731671	-21.6959657769093	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3169356	"TRES MARIAS"	31	-45.2257352467415	-18.2059212240174	3106	'Central Mineira'	31024	'Três Marias'
3169406	"TRES PONTAS"	31	-45.515474797041	-21.3687699216518	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3169505	"TUMIRITINGA"	31	-41.6379804793586	-18.9766076611695	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3169604	"TUPACIGUARA"	31	-48.6937358802059	-18.599352564443	3105	'Triângulo Mineiro/Alto Paranaíba'	31018	'Uberlândia'
3169703	"TURMALINA"	31	-42.7304145447903	-17.2864120942752	3103	'Jequitinhonha'	31011	'Capelinha'
3169802	"TURVOLANDIA"	31	-45.796735792709	-21.8793890056639	3110	'Sul/Sudoeste de Minas'	31053	'Santa Rita do Sapucaí'
3169901	"UBA"	31	-42.936786464392	-21.1185969514978	3112	'Zona da Mata'	31064	'Ubá'
3170008	"UBAI"	31	-44.7870862054941	-16.2974045209459	3102	'Norte de Minas'	31007	'Montes Claros'
3170057	"UBAPORANGA"	31	-42.1092163270909	-19.6413620049211	3108	'Vale do Rio Doce'	31040	'Caratinga'
3170107	"UBERABA"	31	-47.9836248955743	-19.7135346071021	3105	'Triângulo Mineiro/Alto Paranaíba'	31022	'Uberaba'
3170206	"UBERLANDIA"	31	-48.2779501847345	-18.9189986093056	3105	'Triângulo Mineiro/Alto Paranaíba'	31018	'Uberlândia'
3170305	"UMBURATIBA"	31	-40.5726450205228	-17.2536072102915	3104	'Vale do Mucuri'	31016	'Nanuque'
3170404	"UNAI"	31	-46.899956595285	-16.3590084924977	3101	'Noroeste de Minas'	31001	'Unaí'
3170438	"UNIAO DE MINAS"	31	-50.3308029413544	-19.5297366441285	3105	'Triângulo Mineiro/Alto Paranaíba'	31021	'Frutal'
3170479	"URUANA DE MINAS"	31	-46.2562288734466	-16.0600251971288	3101	'Noroeste de Minas'	31001	'Unaí'
3170503	"URUCANIA"	31	-42.7412284517106	-20.3508704157197	3112	'Zona da Mata'	31060	'Ponte Nova'
3170529	"URUCUIA"	31	-45.7370281843675	-16.1320910169931	3102	'Norte de Minas'	31003	'Januária'
3170578	"VARGEM ALEGRE"	31	-42.2998154822517	-19.6007202041095	3108	'Vale do Rio Doce'	31040	'Caratinga'
3170602	"VARGEM BONITA"	31	-46.3724569794485	-20.3267766484088	3109	'Oeste de Minas'	31042	'Piuí'
3170651	"VARGEM GRANDE DO RIO PARDO"	31	-42.3092908662842	-15.4024006159174	3102	'Norte de Minas'	31005	'Salinas'
3170701	"VARGINHA"	31	-45.4318861442786	-21.5570800390634	3110	'Sul/Sudoeste de Minas'	31050	'Varginha'
3170750	"VARJAO DE MINAS"	31	-46.033501545731	-18.3837044637811	3101	'Noroeste de Minas'	31002	'Paracatu'
3170800	"VARZEA DA PALMA"	31	-44.7303465827323	-17.5975701770905	3102	'Norte de Minas'	31006	'Pirapora'
3170909	"VARZELANDIA"	31	-44.027948143227	-15.7088710522808	3102	'Norte de Minas'	31007	'Montes Claros'
3171006	"VAZANTE"	31	-46.901966885848	-17.9910384302439	3101	'Noroeste de Minas'	31002	'Paracatu'
3171030	"VERDELANDIA"	31	-43.6060222623997	-15.5945423473444	3102	'Norte de Minas'	31007	'Montes Claros'
3171071	"VEREDINHA"	31	-42.7359302400247	-17.3939690803405	3103	'Jequitinhonha'	31011	'Capelinha'
3171105	"VERISSIMO"	31	-48.303710580261	-19.669357832615	3105	'Triângulo Mineiro/Alto Paranaíba'	31022	'Uberaba'
3171154	"VERMELHO NOVO"	31	-42.2683458173973	-20.0347660882541	3112	'Zona da Mata'	31060	'Ponte Nova'
3171204	"VESPASIANO"	31	-43.9199151867379	-19.6930304397713	3107	'Metropolitana de Belo Horizonte'	31030	'Belo Horizonte'
3171303	"VICOSA"	31	-42.8794773756709	-20.7520720070293	3112	'Zona da Mata'	31062	'Viçosa'
3171402	"VIEIRAS"	31	-42.2458035423232	-20.8653406932197	3112	'Zona da Mata'	31063	'Muriaé'
3171600	"VIRGEM DA LAPA"	31	-42.3432810665662	-16.8021488570313	3103	'Jequitinhonha'	31012	'Araçuaí'
3171709	"VIRGINIA"	31	-45.0954251629558	-22.3369720668069	3110	'Sul/Sudoeste de Minas'	31056	'Itajubá'
3171808	"VIRGINOPOLIS"	31	-42.7148044703271	-18.8251403925481	3108	'Vale do Rio Doce'	31035	'Guanhães'
3171907	"VIRGOLANDIA"	31	-42.3108100373185	-18.4760617047881	3108	'Vale do Rio Doce'	31037	'Governador Valadares'
3172004	"VISCONDE DO RIO BRANCO"	31	-42.8393893910016	-21.0119895771312	3112	'Zona da Mata'	31064	'Ubá'
3172103	"VOLTA GRANDE"	31	-42.5412849473875	-21.7707111492068	3112	'Zona da Mata'	31066	'Cataguases'
3172202	"WENCESLAU BRAZ"	31	-45.3567739530528	-22.5290130396557	3110	'Sul/Sudoeste de Minas'	31056	'Itajubá'
5000203	"AGUA CLARA"	50	-52.8751175514539	-20.4488507623245	5003	'Leste de Mato Grosso do Sul'	50007	'Três Lagoas'
5000252	"ALCINOPOLIS"	50	-53.7080896262813	-18.3250339793628	5002	'Centro Norte de Mato Grosso do Sul'	50003	'Alto Taquari'
5000609	"AMAMBAI"	50	-55.2438276926237	-23.1005822383764	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5000708	"ANASTACIO"	50	-55.8045705990792	-20.4823601995756	5001	'Pantanais Sul Mato-grossense'	50002	'Aquidauana'
5000807	"ANAURILANDIA"	50	-52.7181693586844	-22.1826502679487	5003	'Leste de Mato Grosso do Sul'	50008	'Nova Andradina'
5000856	"ANGELICA"	50	-53.7697304804627	-22.1560625224337	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5000906	"ANTONIO JOAO"	50	-55.9480815053866	-22.1946853905287	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5001003	"APARECIDA DO TABOADO"	50	-51.0976376237368	-20.0850215149956	5003	'Leste de Mato Grosso do Sul'	50006	'Paranaíba'
5001102	"AQUIDAUANA"	50	-55.7906160902268	-20.4746543469162	5001	'Pantanais Sul Mato-grossense'	50002	'Aquidauana'
5001243	"ARAL MOREIRA"	50	-55.6307614468625	-22.9478813290856	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5001508	"BANDEIRANTES"	50	-54.3631938942841	-19.9209203030945	5002	'Centro Norte de Mato Grosso do Sul'	50004	'Campo Grande'
5001904	"BATAGUASSU"	50	-52.4254366020331	-21.715288435775	5003	'Leste de Mato Grosso do Sul'	50008	'Nova Andradina'
5002001	"BATAYPORA"	50	-53.2748069911071	-22.2958799665907	5003	'Leste de Mato Grosso do Sul'	50008	'Nova Andradina'
5002100	"BELA VISTA"	50	-56.5313145677842	-22.1159761784366	5004	'Sudoeste de Mato Grosso do Sul'	50009	'Bodoquena'
5002159	"BODOQUENA"	50	-56.6735673000081	-20.5548426981466	5004	'Sudoeste de Mato Grosso do Sul'	50009	'Bodoquena'
5002209	"BONITO"	50	-56.4928586185731	-21.1243412844496	5004	'Sudoeste de Mato Grosso do Sul'	50009	'Bodoquena'
5002308	"BRASILANDIA"	50	-52.0362967948522	-21.2471181439629	5003	'Leste de Mato Grosso do Sul'	50007	'Três Lagoas'
5002407	"CAARAPO"	50	-54.8269701013583	-22.6365822193983	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5002605	"CAMAPUA"	50	-54.043309486428	-19.5352597987482	5002	'Centro Norte de Mato Grosso do Sul'	50003	'Alto Taquari'
5002704	"CAMPO GRANDE"	50	-54.6157435664588	-20.4580299878639	5002	'Centro Norte de Mato Grosso do Sul'	50004	'Campo Grande'
5002803	"CARACOL"	50	-57.0259387643523	-22.0127382891948	5004	'Sudoeste de Mato Grosso do Sul'	50009	'Bodoquena'
5002902	"CASSILANDIA"	50	-51.7315768884039	-19.1094073707569	5003	'Leste de Mato Grosso do Sul'	50005	'Cassilândia'
5002951	"CHAPADAO DO SUL"	50	-52.6263557069987	-18.7977731220362	5003	'Leste de Mato Grosso do Sul'	50005	'Cassilândia'
5003108	"CORGUINHO"	50	-54.8300060009779	-19.8312180172352	5002	'Centro Norte de Mato Grosso do Sul'	50004	'Campo Grande'
5003157	"CORONEL SAPUCAIA"	50	-55.5413276902645	-23.2764445607858	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5003207	"CORUMBA"	50	-57.6489854573401	-19.0063746546458	5001	'Pantanais Sul Mato-grossense'	50001	'Baixo Pantanal'
5003256	"COSTA RICA"	50	-53.1330469048741	-18.5435483884105	5003	'Leste de Mato Grosso do Sul'	50005	'Cassilândia'
5003306	"COXIM"	50	-54.7580559501933	-18.5084105386467	5002	'Centro Norte de Mato Grosso do Sul'	50003	'Alto Taquari'
5003454	"DEODAPOLIS"	50	-54.1611832428627	-22.2729491422667	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5003488	"DOIS IRMAOS DO BURITI"	50	-55.281914486329	-20.6923120582393	5001	'Pantanais Sul Mato-grossense'	50002	'Aquidauana'
5003504	"DOURADINA"	50	-54.6079306686315	-22.0455302820426	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5003702	"DOURADOS"	50	-54.8112891228926	-22.2272355368988	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5003751	"ELDORADO"	50	-54.2800282489385	-23.7740539200753	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5003801	"FATIMA DO SUL"	50	-54.5163759902411	-22.3754232110589	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5003900	"FIGUEIRAO"	50	-53.6425733238918	-18.6754480707676	5002	'Centro Norte de Mato Grosso do Sul'	50003	'Alto Taquari'
5004007	"GLORIA DE DOURADOS"	50	-54.2346287898579	-22.4144245309986	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5004106	"GUIA LOPES DA LAGUNA"	50	-56.1081525022452	-21.4524591422453	5004	'Sudoeste de Mato Grosso do Sul'	50009	'Bodoquena'
5004304	"IGUATEMI"	50	-54.5586010866498	-23.6619015645077	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5004403	"INOCENCIA"	50	-51.9276790223466	-19.725457973959	5003	'Leste de Mato Grosso do Sul'	50006	'Paranaíba'
5004502	"ITAPORA"	50	-54.7956587372653	-22.0824475601645	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5004601	"ITAQUIRAI"	50	-54.1881983027434	-23.4906632623464	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5004700	"IVINHEMA"	50	-53.8269701470603	-22.3016035627085	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5004809	"JAPORA"	50	-54.4034847428654	-23.8940669514617	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5004908	"JARAGUARI"	50	-54.4406839539385	-20.103740391705	5002	'Centro Norte de Mato Grosso do Sul'	50004	'Campo Grande'
5005004	"JARDIM"	50	-56.1458445844119	-21.4796031457566	5004	'Sudoeste de Mato Grosso do Sul'	50009	'Bodoquena'
5005103	"JATEI"	50	-54.3080543756429	-22.4816870305277	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5005152	"JUTI"	50	-54.6013228312571	-22.8624718343924	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5005202	"LADARIO"	50	-57.6024001955275	-19.0017756680233	5001	'Pantanais Sul Mato-grossense'	50001	'Baixo Pantanal'
5005251	"LAGUNA CARAPA"	50	-55.1501077344737	-22.5505815145125	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5005400	"MARACAJU"	50	-55.1571395689956	-21.6236103838164	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5005608	"MIRANDA"	50	-56.3901982861341	-20.2393334990435	5001	'Pantanais Sul Mato-grossense'	50002	'Aquidauana'
5005681	"MUNDO NOVO"	50	-54.2816614237766	-23.9352736181859	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5005707	"NAVIRAI"	50	-54.1988361701181	-23.0599994824999	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5005806	"NIOAQUE"	50	-55.8338899214135	-21.158152313499	5004	'Sudoeste de Mato Grosso do Sul'	50009	'Bodoquena'
5006002	"NOVA ALVORADA DO SUL"	50	-54.3828036000825	-21.4666342525148	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5006200	"NOVA ANDRADINA"	50	-53.3515738148688	-22.2487593127534	5003	'Leste de Mato Grosso do Sul'	50008	'Nova Andradina'
5006259	"NOVO HORIZONTE DO SUL"	50	-53.8608865570425	-22.6549531055812	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5006275	"PARAISO DAS AGUAS"	50	-53.01306849	-19.01739138	5003	'Leste de Mato Grosso do Sul'	50005	'Cassilândia'
5006309	"PARANAIBA"	50	-51.1887077083698	-19.6773717332006	5003	'Leste de Mato Grosso do Sul'	50006	'Paranaíba'
5006358	"PARANHOS"	50	-55.4330304573901	-23.8968696614801	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5006408	"PEDRO GOMES"	50	-54.5524458291661	-18.1018562342507	5002	'Centro Norte de Mato Grosso do Sul'	50003	'Alto Taquari'
5006606	"PONTA PORA"	50	-55.7108501778638	-22.4861870787603	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5006903	"PORTO MURTINHO"	50	-57.8884823022607	-21.707324558832	5001	'Pantanais Sul Mato-grossense'	50001	'Baixo Pantanal'
5007109	"RIBAS DO RIO PARDO"	50	-53.761677624322	-20.4436755255861	5003	'Leste de Mato Grosso do Sul'	50007	'Três Lagoas'
5007208	"RIO BRILHANTE"	50	-54.5422422224689	-21.8011952575732	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5007307	"RIO NEGRO"	50	-54.9875023242982	-19.4474291073405	5002	'Centro Norte de Mato Grosso do Sul'	50004	'Campo Grande'
5007406	"RIO VERDE DE MATO GROSSO"	50	-54.8422536901125	-18.9165864402561	5002	'Centro Norte de Mato Grosso do Sul'	50003	'Alto Taquari'
5007505	"ROCHEDO"	50	-54.8927719306444	-19.9618596065419	5002	'Centro Norte de Mato Grosso do Sul'	50004	'Campo Grande'
5007554	"SANTA RITA DO PARDO"	50	-52.828071432574	-21.3053769424865	5003	'Leste de Mato Grosso do Sul'	50007	'Três Lagoas'
5007695	"SAO GABRIEL DO OESTE"	50	-54.5645690937601	-19.3955213701578	5002	'Centro Norte de Mato Grosso do Sul'	50003	'Alto Taquari'
5007802	"SELVIRIA"	50	-51.4189369057614	-20.3667425853307	5003	'Leste de Mato Grosso do Sul'	50006	'Paranaíba'
5007703	"SETE QUEDAS"	50	-55.0533150890634	-23.9835132549713	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5007901	"SIDROLANDIA"	50	-54.9660301365064	-20.9310544595365	5002	'Centro Norte de Mato Grosso do Sul'	50004	'Campo Grande'
5007935	"SONORA"	50	-54.7549062179542	-17.5813552344532	5002	'Centro Norte de Mato Grosso do Sul'	50003	'Alto Taquari'
5007950	"TACURU"	50	-55.0203205182963	-23.6347420220157	5004	'Sudoeste de Mato Grosso do Sul'	50011	'Iguatemi'
5007976	"TAQUARUSSU"	50	-53.3519187419396	-22.4899870565256	5003	'Leste de Mato Grosso do Sul'	50008	'Nova Andradina'
5008008	"TERENOS"	50	-54.8655566306489	-20.4423076800354	5002	'Centro Norte de Mato Grosso do Sul'	50004	'Campo Grande'
5008305	"TRES LAGOAS"	50	-51.7100006287942	-20.7886791613914	5003	'Leste de Mato Grosso do Sul'	50007	'Três Lagoas'
5008404	"VICENTINA"	50	-54.4421247768421	-22.4017875573449	5004	'Sudoeste de Mato Grosso do Sul'	50010	'Dourados'
5100102	"ACORIZAL"	51	-56.3715525667098	-15.1978899803339	5104	'Centro-Sul Mato-grossense'	51016	'Rosário Oeste'
5100201	"AGUA BOA"	51	-52.1589152986038	-14.0490868003435	5102	'Nordeste Mato-grossense'	51010	'Canarana'
5100250	"ALTA FLORESTA"	51	-56.0916104404738	-9.87172259661951	5101	'Norte Mato-grossense'	51002	'Alta Floresta'
5100300	"ALTO ARAGUAIA"	51	-53.2202603299843	-17.3155899403964	5105	'Sudeste Mato-grossense'	51022	'Alto Araguaia'
5100359	"ALTO BOA VISTA"	51	-51.3793220737552	-11.6767451578561	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
5100409	"ALTO GARCAS"	51	-53.5284541196243	-16.9467221760397	5105	'Sudeste Mato-grossense'	51022	'Alto Araguaia'
5100508	"ALTO PARAGUAI"	51	-56.4944416625755	-14.5147118103311	5104	'Centro-Sul Mato-grossense'	51015	'Alto Paraguai'
5100607	"ALTO TAQUARI"	51	-53.2819931222741	-17.8347436507218	5105	'Sudeste Mato-grossense'	51022	'Alto Araguaia'
5100805	"APIACAS"	51	-57.3954022412255	-9.56549516872457	5101	'Norte Mato-grossense'	51002	'Alta Floresta'
5101001	"ARAGUAIANA"	51	-51.8336216513347	-15.7312434957136	5102	'Nordeste Mato-grossense'	51011	'Médio Araguaia'
5101209	"ARAGUAINHA"	51	-53.03561988386	-16.8575455378911	5105	'Sudeste Mato-grossense'	51020	'Tesouro'
5101258	"ARAPUTANGA"	51	-58.3483671518683	-15.4681442696685	5103	'Sudoeste Mato-grossense'	51014	'Jauru'
5101308	"ARENAPOLIS"	51	-56.8444892395472	-14.4555216659758	5104	'Centro-Sul Mato-grossense'	51015	'Alto Paraguai'
5101407	"ARIPUANA"	51	-59.4486163791619	-10.1725236954827	5101	'Norte Mato-grossense'	51001	'Aripuanã'
5101605	"BARAO DE MELGACO"	51	-55.9671211336846	-16.1950994476433	5104	'Centro-Sul Mato-grossense'	51018	'Alto Pantanal'
5101704	"BARRA DO BUGRES"	51	-57.1864086868428	-15.0662579403434	5103	'Sudoeste Mato-grossense'	51013	'Tangará da Serra'
5101803	"BARRA DO GARCAS"	51	-52.2603297567721	-15.8887114516953	5102	'Nordeste Mato-grossense'	51011	'Médio Araguaia'
5101852	"BOM JESUS DO ARAGUAIA"	51	-51.5036392318627	-12.1735983436532	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
5101902	"BRASNORTE"	51	-58.0026736277872	-12.1249381398803	5101	'Norte Mato-grossense'	51001	'Aripuanã'
5102504	"CACERES"	51	-57.6747623072181	-16.0740956303637	5104	'Centro-Sul Mato-grossense'	51018	'Alto Pantanal'
5102603	"CAMPINAPOLIS"	51	-52.7974947505792	-14.5396174299416	5102	'Nordeste Mato-grossense'	51010	'Canarana'
5102637	"CAMPO NOVO DO PARECIS"	51	-57.8885464788372	-13.6547331732023	5101	'Norte Mato-grossense'	51004	'Parecis'
5102678	"CAMPO VERDE"	51	-55.1716554148957	-15.5537042703149	5105	'Sudeste Mato-grossense'	51019	'Primavera do Leste'
5102686	"CAMPOS DE JULIO"	51	-59.2634085205862	-13.7199230456405	5101	'Norte Mato-grossense'	51004	'Parecis'
5102694	"CANABRAVA DO NORTE"	51	-51.8377580067528	-11.0461869218311	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
5102702	"CANARANA"	51	-52.2734568634775	-13.559229509583	5102	'Nordeste Mato-grossense'	51010	'Canarana'
5102793	"CARLINDA"	51	-55.8216147779941	-9.96666579255585	5101	'Norte Mato-grossense'	51002	'Alta Floresta'
5102850	"CASTANHEIRA"	51	-58.6134092636961	-11.1341078575921	5101	'Norte Mato-grossense'	51001	'Aripuanã'
5103007	"CHAPADA DOS GUIMARAES"	51	-55.7450045178921	-15.4605696789085	5104	'Centro-Sul Mato-grossense'	51017	'Cuiabá'
5103056	"CLAUDIA"	51	-54.8741824477688	-11.5053107376487	5101	'Norte Mato-grossense'	51007	'Sinop'
5103106	"COCALINHO"	51	-51.0112436410084	-14.3903655391808	5102	'Nordeste Mato-grossense'	51011	'Médio Araguaia'
5103205	"COLIDER"	51	-55.4642305419601	-10.8040897790092	5101	'Norte Mato-grossense'	51003	'Colíder'
5103254	"COLNIZA"	51	-59.2189486740791	-9.45790384671208	5101	'Norte Mato-grossense'	51001	'Aripuanã'
5103304	"COMODORO"	51	-59.7904309944221	-13.6605599169829	5101	'Norte Mato-grossense'	51004	'Parecis'
5103353	"CONFRESA"	51	-51.5710336178615	-10.6407305770377	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
5103361	"CONQUISTA D'OESTE"	51	-59.5450742072991	-14.5362728149759	5103	'Sudoeste Mato-grossense'	51012	'Alto Guaporé'
5103379	"COTRIGUACU"	51	-58.6068949710817	-9.88625387152961	5101	'Norte Mato-grossense'	51001	'Aripuanã'
5103403	"CUIABA"	51	-56.0732520381911	-15.5699890131206	5104	'Centro-Sul Mato-grossense'	51017	'Cuiabá'
5103437	"CURVELANDIA"	51	-57.9171149786644	-15.6093061708567	5104	'Centro-Sul Mato-grossense'	51018	'Alto Pantanal'
5103452	"DENISE"	51	-57.0537772728324	-14.7338159183318	5103	'Sudoeste Mato-grossense'	51013	'Tangará da Serra'
5103502	"DIAMANTINO"	51	-56.433566081512	-14.4013229621649	5101	'Norte Mato-grossense'	51004	'Parecis'
5103601	"DOM AQUINO"	51	-54.9174807825692	-15.8074551507897	5105	'Sudeste Mato-grossense'	51021	'Rondonópolis'
5103700	"FELIZ NATAL"	51	-54.9339040664255	-12.383247028174	5101	'Norte Mato-grossense'	51007	'Sinop'
5103809	"FIGUEIROPOLIS D'OESTE"	51	-58.7378245488632	-15.4461351146319	5103	'Sudoeste Mato-grossense'	51014	'Jauru'
5103858	"GAUCHA DO NORTE"	51	-53.2615186719475	-13.1880431895097	5101	'Norte Mato-grossense'	51008	'Paranatinga'
5103908	"GENERAL CARNEIRO"	51	-52.7593098339669	-15.7070417946133	5105	'Sudeste Mato-grossense'	51020	'Tesouro'
5103957	"GLORIA D'OESTE"	51	-58.314485588724	-15.7679623095483	5103	'Sudoeste Mato-grossense'	51014	'Jauru'
5104104	"GUARANTA DO NORTE"	51	-54.9160573112722	-9.95407323364261	5101	'Norte Mato-grossense'	51003	'Colíder'
5104203	"GUIRATINGA"	51	-53.7609640294195	-16.3483892680666	5105	'Sudeste Mato-grossense'	51020	'Tesouro'
5104500	"INDIAVAI"	51	-58.5739923860232	-15.4975142295561	5103	'Sudoeste Mato-grossense'	51014	'Jauru'
5104526	"IPIRANGA DO NORTE"	51	-56.1597931355503	-12.2368420001759	5101	'Norte Mato-grossense'	51006	'Alto Teles Pires'
5104542	"ITANHANGA"	51	-56.6493436130839	-12.2347687158666	5101	'Norte Mato-grossense'	51006	'Alto Teles Pires'
5104559	"ITAUBA"	51	-55.2466893348601	-11.0077118987319	5101	'Norte Mato-grossense'	51007	'Sinop'
5104609	"ITIQUIRA"	51	-54.1443008960004	-17.2068250553657	5105	'Sudeste Mato-grossense'	51021	'Rondonópolis'
5104807	"JACIARA"	51	-54.9641881751901	-15.9648381841494	5105	'Sudeste Mato-grossense'	51021	'Rondonópolis'
5104906	"JANGADA"	51	-56.490194562614	-15.2396872255932	5104	'Centro-Sul Mato-grossense'	51016	'Rosário Oeste'
5105002	"JAURU"	51	-58.8798383973631	-15.3418963815145	5103	'Sudoeste Mato-grossense'	51014	'Jauru'
5105101	"JUARA"	51	-57.5131232183312	-11.2503599784852	5101	'Norte Mato-grossense'	51005	'Arinos'
5105150	"JUINA"	51	-58.7622171517696	-11.4220180322681	5101	'Norte Mato-grossense'	51001	'Aripuanã'
5105176	"JURUENA"	51	-58.4963091740334	-10.3291127798668	5101	'Norte Mato-grossense'	51001	'Aripuanã'
5105200	"JUSCIMEIRA"	51	-54.8887609429504	-16.0446851891088	5105	'Sudeste Mato-grossense'	51021	'Rondonópolis'
5105234	"LAMBARI D'OESTE"	51	-58.0058251786064	-15.3155012400441	5103	'Sudoeste Mato-grossense'	51014	'Jauru'
5105259	"LUCAS DO RIO VERDE"	51	-55.9217707091117	-13.0704649508999	5101	'Norte Mato-grossense'	51006	'Alto Teles Pires'
5105309	"LUCIARA"	51	-50.6632015831694	-11.2280970998312	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
5105580	"MARCELANDIA"	51	-54.5193062321905	-11.0805914112817	5101	'Norte Mato-grossense'	51007	'Sinop'
5105606	"MATUPA"	51	-54.9318057201458	-10.1721074662032	5101	'Norte Mato-grossense'	51003	'Colíder'
5105622	"MIRASSOL D'OESTE"	51	-58.0979035689912	-15.6740707810881	5103	'Sudoeste Mato-grossense'	51014	'Jauru'
5105903	"NOBRES"	51	-56.3340848305989	-14.7245002733703	5101	'Norte Mato-grossense'	51006	'Alto Teles Pires'
5106000	"NORTELANDIA"	51	-56.8020689751516	-14.4537245567653	5104	'Centro-Sul Mato-grossense'	51015	'Alto Paraguai'
5106109	"NOSSA SENHORA DO LIVRAMENTO"	51	-56.3452585551782	-15.7896762066682	5104	'Centro-Sul Mato-grossense'	51017	'Cuiabá'
5106158	"NOVA BANDEIRANTES"	51	-57.8184757985331	-9.84295282030582	5101	'Norte Mato-grossense'	51002	'Alta Floresta'
5106208	"NOVA BRASILANDIA"	51	-54.9719088691261	-14.925464456005	5101	'Norte Mato-grossense'	51008	'Paranatinga'
5106216	"NOVA CANAA DO NORTE"	51	-55.7148773060438	-10.6311042290192	5101	'Norte Mato-grossense'	51003	'Colíder'
5108808	"NOVA GUARITA"	51	-55.4030701389659	-10.3088464293765	5101	'Norte Mato-grossense'	51003	'Colíder'
5106182	"NOVA LACERDA"	51	-59.5903305027945	-14.4697889940042	5103	'Sudoeste Mato-grossense'	51012	'Alto Guaporé'
5108857	"NOVA MARILANDIA"	51	-56.9731767858961	-14.3624512717366	5104	'Centro-Sul Mato-grossense'	51015	'Alto Paraguai'
5108907	"NOVA MARINGA"	51	-57.0985516651799	-13.0114269541347	5101	'Norte Mato-grossense'	51005	'Arinos'
5108956	"NOVA MONTE VERDE"	51	-57.4723693069132	-9.97261692693499	5101	'Norte Mato-grossense'	51002	'Alta Floresta'
5106224	"NOVA MUTUM"	51	-56.1100052480978	-13.832725692724	5101	'Norte Mato-grossense'	51006	'Alto Teles Pires'
5106174	"NOVA NAZARE"	51	-51.7974342175117	-13.9878672734426	5102	'Nordeste Mato-grossense'	51010	'Canarana'
5106232	"NOVA OLIMPIA"	51	-57.2829239619584	-14.7794142418653	5103	'Sudoeste Mato-grossense'	51013	'Tangará da Serra'
5106190	"NOVA SANTA HELENA"	51	-55.1836857411212	-10.8509999759112	5101	'Norte Mato-grossense'	51007	'Sinop'
5106240	"NOVA UBIRATA"	51	-55.273213318984	-13.0338277159556	5101	'Norte Mato-grossense'	51006	'Alto Teles Pires'
5106257	"NOVA XAVANTINA"	51	-52.3611926726195	-14.669179516314	5102	'Nordeste Mato-grossense'	51010	'Canarana'
5106273	"NOVO HORIZONTE DO NORTE"	51	-57.3174751138237	-11.3876347793611	5101	'Norte Mato-grossense'	51005	'Arinos'
5106265	"NOVO MUNDO"	51	-55.1720189315524	-9.97710919449313	5101	'Norte Mato-grossense'	51003	'Colíder'
5106315	"NOVO SANTO ANTONIO"	51	-50.9691726452052	-12.2946934832423	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
5106281	"NOVO SAO JOAQUIM"	51	-53.0161155129018	-14.8865652627151	5102	'Nordeste Mato-grossense'	51010	'Canarana'
5106299	"PARANAITA"	51	-56.4788997201888	-9.66965549852606	5101	'Norte Mato-grossense'	51002	'Alta Floresta'
5106307	"PARANATINGA"	51	-54.0540919919066	-14.4276984800989	5101	'Norte Mato-grossense'	51008	'Paranatinga'
5106372	"PEDRA PRETA"	51	-54.4713956382102	-16.6222104158826	5105	'Sudeste Mato-grossense'	51021	'Rondonópolis'
5106422	"PEIXOTO DE AZEVEDO"	51	-54.9922974013688	-10.2448420827714	5101	'Norte Mato-grossense'	51003	'Colíder'
5106455	"PLANALTO DA SERRA"	51	-54.7834957522787	-14.6607059394903	5101	'Norte Mato-grossense'	51008	'Paranatinga'
5106505	"POCONE"	51	-56.626509352735	-16.2595094669667	5104	'Centro-Sul Mato-grossense'	51018	'Alto Pantanal'
5106653	"PONTAL DO ARAGUAIA"	51	-52.2585111119354	-15.9024713438393	5105	'Sudeste Mato-grossense'	51020	'Tesouro'
5106703	"PONTE BRANCA"	51	-52.8357757281924	-16.767648010989	5105	'Sudeste Mato-grossense'	51020	'Tesouro'
5106752	"PONTES E LACERDA"	51	-59.3380018443657	-15.22972757111	5103	'Sudoeste Mato-grossense'	51012	'Alto Guaporé'
5106778	"PORTO ALEGRE DO NORTE"	51	-51.6308798239408	-10.8775484769153	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
5106802	"PORTO DOS GAUCHOS"	51	-57.4083538380051	-11.5338400294576	5101	'Norte Mato-grossense'	51005	'Arinos'
5106828	"PORTO ESPERIDIAO"	51	-58.4692987422521	-15.8576348619178	5103	'Sudoeste Mato-grossense'	51014	'Jauru'
5106851	"PORTO ESTRELA"	51	-57.2013572999111	-15.3313363060043	5103	'Sudoeste Mato-grossense'	51013	'Tangará da Serra'
5107008	"POXOREO"	51	-54.4007326559538	-15.818135556981	5105	'Sudeste Mato-grossense'	51020	'Tesouro'
5107040	"PRIMAVERA DO LESTE"	51	-54.3000532591227	-15.5522935931141	5105	'Sudeste Mato-grossense'	51019	'Primavera do Leste'
5107065	"QUERENCIA"	51	-52.2098919155942	-12.5922996263044	5102	'Nordeste Mato-grossense'	51010	'Canarana'
5107156	"RESERVA DO CABACAL"	51	-58.3853645299516	-15.1224095311857	5103	'Sudoeste Mato-grossense'	51014	'Jauru'
5107180	"RIBEIRAO CASCALHEIRA"	51	-51.8333633451013	-12.9320485634907	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
5107198	"RIBEIRAOZINHO"	51	-52.6954417282626	-16.48652591368	5105	'Sudeste Mato-grossense'	51020	'Tesouro'
5107206	"RIO BRANCO"	51	-58.1179393479916	-15.2356828101436	5103	'Sudoeste Mato-grossense'	51014	'Jauru'
5107578	"RONDOLANDIA"	51	-61.4596781719947	-10.8443019740102	5101	'Norte Mato-grossense'	51001	'Aripuanã'
5107602	"RONDONOPOLIS"	51	-54.6335870401784	-16.4701628734999	5105	'Sudeste Mato-grossense'	51021	'Rondonópolis'
5107701	"ROSARIO OESTE"	51	-56.4282932054054	-14.8264275714772	5104	'Centro-Sul Mato-grossense'	51016	'Rosário Oeste'
5107750	"SALTO DO CEU"	51	-58.1267518070165	-15.1358245747688	5103	'Sudoeste Mato-grossense'	51014	'Jauru'
5107248	"SANTA CARMEM"	51	-55.2822227065053	-11.9696855569233	5101	'Norte Mato-grossense'	51007	'Sinop'
5107743	"SANTA CRUZ DO XINGU"	51	-52.3986159655702	-10.1524495036333	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
5107768	"SANTA RITA DO TRIVELATO"	51	-55.2776928814179	-13.8161897319564	5101	'Norte Mato-grossense'	51006	'Alto Teles Pires'
5107776	"SANTA TEREZINHA"	51	-50.5062664379029	-10.4661116195783	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
5107263	"SANTO AFONSO"	51	-57.0005036374709	-14.4907768196978	5104	'Centro-Sul Mato-grossense'	51015	'Alto Paraguai'
5107792	"SANTO ANTONIO DO LESTE"	51	-53.6117238521722	-14.8008133965517	5102	'Nordeste Mato-grossense'	51010	'Canarana'
5107800	"SANTO ANTONIO DO LEVERGER"	51	-56.0941622007565	-15.8691790439575	5104	'Centro-Sul Mato-grossense'	51017	'Cuiabá'
5107859	"SAO FELIX DO ARAGUAIA"	51	-50.6619863699344	-11.6160823259387	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
5107297	"SAO JOSE DO POVO"	51	-54.2562463683382	-16.4663303087874	5105	'Sudeste Mato-grossense'	51021	'Rondonópolis'
5107305	"SAO JOSE DO RIO CLARO"	51	-56.7215837606849	-13.4520683374106	5101	'Norte Mato-grossense'	51005	'Arinos'
5107354	"SAO JOSE DO XINGU"	51	-52.7397936398726	-10.8002641630326	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
5107107	"SAO JOSE DOS QUATRO MARCOS"	51	-58.176505937373	-15.6271057366723	5103	'Sudoeste Mato-grossense'	51014	'Jauru'
5107404	"SAO PEDRO DA CIPA"	51	-54.9189931830667	-16.002708520526	5105	'Sudeste Mato-grossense'	51021	'Rondonópolis'
5107875	"SAPEZAL"	51	-58.8121380141755	-13.5381953534711	5101	'Norte Mato-grossense'	51004	'Parecis'
5107883	"SERRA NOVA DOURADA"	51	-51.3995934077539	-12.089271838886	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
5107909	"SINOP"	51	-55.5009220023868	-11.8580053080776	5101	'Norte Mato-grossense'	51007	'Sinop'
5107925	"SORRISO"	51	-55.7259136750913	-12.5517767078455	5101	'Norte Mato-grossense'	51006	'Alto Teles Pires'
5107941	"TABAPORA"	51	-56.8248337962705	-11.3075079570383	5101	'Norte Mato-grossense'	51005	'Arinos'
5107958	"TANGARA DA SERRA"	51	-57.4912991530603	-14.623784750468	5103	'Sudoeste Mato-grossense'	51013	'Tangará da Serra'
5108006	"TAPURAH"	51	-56.5194858964735	-12.7320686313157	5101	'Norte Mato-grossense'	51006	'Alto Teles Pires'
5108055	"TERRA NOVA DO NORTE"	51	-55.1159514886165	-10.5971280931496	5101	'Norte Mato-grossense'	51003	'Colíder'
5108105	"TESOURO"	51	-53.5558439620298	-16.0752374012224	5105	'Sudeste Mato-grossense'	51020	'Tesouro'
5108204	"TORIXOREU"	51	-52.5588386353409	-16.1975263639358	5105	'Sudeste Mato-grossense'	51020	'Tesouro'
5108303	"UNIAO DO SUL"	51	-54.3748444105852	-11.5355107507237	5101	'Norte Mato-grossense'	51007	'Sinop'
5108352	"VALE DE SAO DOMINGOS"	51	-59.064571157227	-15.2958978418302	5103	'Sudoeste Mato-grossense'	51012	'Alto Guaporé'
5108402	"VARZEA GRANDE"	51	-56.1446637401866	-15.6580648240885	5104	'Centro-Sul Mato-grossense'	51017	'Cuiabá'
5108501	"VERA"	51	-55.30091857486	-12.2840488631767	5101	'Norte Mato-grossense'	51007	'Sinop'
5105507	"VILA BELA DA SANTISSIMA TRINDADE"	51	-59.9525581994781	-15.0093244787806	5103	'Sudoeste Mato-grossense'	51012	'Alto Guaporé'
5108600	"VILA RICA"	51	-51.1168225790044	-10.0133521818689	5102	'Nordeste Mato-grossense'	51009	'Norte Araguaia'
1500107	"ABAETETUBA"	15	-48.8844038207231	-1.72346986284591	1504	'Nordeste Paraense'	15011	'Cametá'
1500131	"ABEL FIGUEIREDO"	15	-48.3967621257945	-4.9513908955313	1506	'Sudeste Paraense'	15017	'Paragominas'
1500206	"ACARA"	15	-48.2004564317501	-1.9634365	1504	'Nordeste Paraense'	15012	'Tomé-Açu'
1500305	"AFUA"	15	-50.3914275892332	-0.159171693779797	1502	'Marajó'	15005	'Furos de Breves'
1500347	"AGUA AZUL DO NORTE"	15	-50.4852745072531	-6.80494886740538	1506	'Sudeste Paraense'	15019	'Parauapebas'
1500404	"ALENQUER"	15	-54.7408623501896	-1.951397505	1501	'Baixo Amazonas'	15002	'Santarém'
1500503	"ALMEIRIM"	15	-52.5768350868127	-1.52733880276478	1501	'Baixo Amazonas'	15003	'Almeirim'
1500602	"ALTAMIRA"	15	-52.2143763052078	-3.20565951	1505	'Sudoeste Paraense'	15015	'Altamira'
1500701	"ANAJAS"	15	-49.945001040544	-0.984451394008702	1502	'Marajó'	15005	'Furos de Breves'
1500800	"ANANINDEUA"	15	-48.372066654168	-1.36871356826946	1503	'Metropolitana de Belém'	15007	'Belém'
1500859	"ANAPU"	15	-51.2016217984581	-3.47610463506868	1505	'Sudoeste Paraense'	15015	'Altamira'
1500909	"AUGUSTO CORREA"	15	-46.6416457856711	-1.02292101	1504	'Nordeste Paraense'	15010	'Bragantina'
1500958	"AURORA DO PARA"	15	-47.5561746036128	-2.12937601319444	1504	'Nordeste Paraense'	15013	'Guamá'
1501006	"AVEIRO"	15	-55.3307343898178	-3.60559525928393	1505	'Sudoeste Paraense'	15014	'Itaituba'
1501105	"BAGRE"	15	-50.2219869206135	-1.88980806036172	1502	'Marajó'	15004	'Portel'
1501204	"BAIAO"	15	-49.6727533733253	-2.79196186136136	1504	'Nordeste Paraense'	15011	'Cametá'
1501253	"BANNACH"	15	-50.4060471215196	-7.3510721924244	1506	'Sudeste Paraense'	15018	'São Félix do Xingu'
1501303	"BARCARENA"	15	-48.6270728925156	-1.505767005	1503	'Metropolitana de Belém'	15007	'Belém'
1501402	"BELEM"	15	-48.4878256874876	-1.459845	1503	'Metropolitana de Belém'	15007	'Belém'
1501451	"BELTERRA"	15	-54.9426747393262	-2.64902016946856	1501	'Baixo Amazonas'	15002	'Santarém'
1501501	"BENEVIDES"	15	-48.2418364505703	-1.361437515	1503	'Metropolitana de Belém'	15007	'Belém'
1501576	"BOM JESUS DO TOCANTINS"	15	-48.5990399590615	-5.04736270432029	1506	'Sudeste Paraense'	15017	'Paragominas'
1501600	"BONITO"	15	-47.3058918168639	-1.36747435687254	1504	'Nordeste Paraense'	15010	'Bragantina'
1501709	"BRAGANCA"	15	-46.765754213664	-1.05352395620564	1504	'Nordeste Paraense'	15010	'Bragantina'
1501725	"BRASIL NOVO"	15	-52.5434411922788	-3.29780370400837	1505	'Sudoeste Paraense'	15015	'Altamira'
1501758	"BREJO GRANDE DO ARAGUAIA"	15	-48.4057604223874	-5.70729615383609	1506	'Sudeste Paraense'	15020	'Marabá'
1501782	"BREU BRANCO"	15	-49.5698796832857	-3.77813541287867	1506	'Sudeste Paraense'	15016	'Tucuruí'
1501808	"BREVES"	15	-50.4808947990195	-1.6907365	1502	'Marajó'	15005	'Furos de Breves'
1501907	"BUJARU"	15	-48.035875014396	-1.51399146230061	1503	'Metropolitana de Belém'	15008	'Castanhal'
1502004	"CACHOEIRA DO ARARI"	15	-48.9606675773871	-1.00878626563928	1502	'Marajó'	15006	'Arari'
1501956	"CACHOEIRA DO PIRIA"	15	-46.5473914166255	-1.75289700493124	1504	'Nordeste Paraense'	15013	'Guamá'
1502103	"CAMETA"	15	-49.497830168997	-2.24683848	1504	'Nordeste Paraense'	15011	'Cametá'
1502152	"CANAA DOS CARAJAS"	15	-49.8489584319153	-6.5321966156294	1506	'Sudeste Paraense'	15019	'Parauapebas'
1502202	"CAPANEMA"	15	-47.1751261231344	-1.192441995	1504	'Nordeste Paraense'	15010	'Bragantina'
1502301	"CAPITAO POCO"	15	-47.0628253774009	-1.74618729323752	1504	'Nordeste Paraense'	15013	'Guamá'
1502400	"CASTANHAL"	15	-47.9266431419442	-1.29575680504525	1503	'Metropolitana de Belém'	15008	'Castanhal'
1502509	"CHAVES"	15	-49.9893186050714	-0.162437290121912	1502	'Marajó'	15006	'Arari'
1502608	"COLARES"	15	-48.2887284319494	-0.932091243957739	1504	'Nordeste Paraense'	15009	'Salgado'
1502707	"CONCEICAO DO ARAGUAIA"	15	-49.2645008124957	-8.26486353	1506	'Sudeste Paraense'	15022	'Conceição do Araguaia'
1502756	"CONCORDIA DO PARA"	15	-47.9498869390047	-1.98452146277276	1504	'Nordeste Paraense'	15012	'Tomé-Açu'
1502764	"CUMARU DO NORTE"	15	-50.7715783775131	-7.81110653689927	1506	'Sudeste Paraense'	15018	'São Félix do Xingu'
1502772	"CURIONOPOLIS"	15	-49.6022142249504	-6.09681995220666	1506	'Sudeste Paraense'	15019	'Parauapebas'
1502806	"CURRALINHO"	15	-49.7915228470854	-1.80942341966693	1502	'Marajó'	15005	'Furos de Breves'
1502855	"CURUA"	15	-55.1196786087308	-1.88992870430549	1501	'Baixo Amazonas'	15002	'Santarém'
1502905	"CURUCA"	15	-47.8512650859352	-0.73249551	1504	'Nordeste Paraense'	15009	'Salgado'
1502939	"DOM ELISEU"	15	-47.5559148859934	-4.29077772	1506	'Sudeste Paraense'	15017	'Paragominas'
1502954	"ELDORADO DOS CARAJAS"	15	-49.3739519421522	-6.10352516107139	1506	'Sudeste Paraense'	15019	'Parauapebas'
1503002	"FARO"	15	-56.745753017307	-2.17297524194977	1501	'Baixo Amazonas'	15001	'Óbidos'
1503044	"FLORESTA DO ARAGUAIA"	15	-49.6975784122373	-7.55870087237008	1506	'Sudeste Paraense'	15022	'Conceição do Araguaia'
1503077	"GARRAFAO DO NORTE"	15	-47.0450460172973	-1.93169704310669	1504	'Nordeste Paraense'	15013	'Guamá'
1503093	"GOIANESIA DO PARA"	15	-49.1010449237426	-3.842468	1506	'Sudeste Paraense'	15017	'Paragominas'
1503101	"GURUPA"	15	-51.6436957233941	-1.404918	1502	'Marajó'	15004	'Portel'
1503200	"IGARAPE-ACU"	15	-47.6223754920271	-1.124322	1504	'Nordeste Paraense'	15010	'Bragantina'
1503309	"IGARAPE-MIRI"	15	-48.9622994689466	-1.983116	1504	'Nordeste Paraense'	15011	'Cametá'
1503408	"INHANGAPI"	15	-47.9133927465885	-1.42658198091031	1503	'Metropolitana de Belém'	15008	'Castanhal'
1503457	"IPIXUNA DO PARA"	15	-47.4997175887983	-2.5575285	1504	'Nordeste Paraense'	15013	'Guamá'
1503507	"IRITUIA"	15	-47.4407556128483	-1.771474995	1504	'Nordeste Paraense'	15013	'Guamá'
1503606	"ITAITUBA"	15	-55.9900488572777	-4.26372948	1505	'Sudoeste Paraense'	15014	'Itaituba'
1503705	"ITUPIRANGA"	15	-49.3244258612861	-5.12883702636091	1506	'Sudeste Paraense'	15016	'Tucuruí'
1503754	"JACAREACANGA"	15	-57.7663398583794	-6.22355173138645	1505	'Sudoeste Paraense'	15014	'Itaituba'
1503804	"JACUNDA"	15	-49.1127815625675	-4.448405475	1506	'Sudeste Paraense'	15016	'Tucuruí'
1503903	"JURUTI"	15	-56.0949976884001	-2.155252995	1501	'Baixo Amazonas'	15001	'Óbidos'
1504000	"LIMOEIRO DO AJURU"	15	-49.3815339012019	-1.8919485	1504	'Nordeste Paraense'	15011	'Cametá'
1504059	"MAE DO RIO"	15	-47.5522901794774	-2.04770744079076	1504	'Nordeste Paraense'	15013	'Guamá'
1504109	"MAGALHAES BARATA"	15	-47.5991818964912	-0.795850156021161	1504	'Nordeste Paraense'	15009	'Salgado'
1504208	"MARABA"	15	-49.1420253334067	-5.35260576313025	1506	'Sudeste Paraense'	15020	'Marabá'
1504307	"MARACANA"	15	-47.4552679594076	-0.762419459981231	1504	'Nordeste Paraense'	15009	'Salgado'
1504406	"MARAPANIM"	15	-47.7025487537677	-0.712150996347819	1504	'Nordeste Paraense'	15009	'Salgado'
1504422	"MARITUBA"	15	-48.340535877783	-1.3464172655758	1503	'Metropolitana de Belém'	15007	'Belém'
1504455	"MEDICILANDIA"	15	-52.8883453507243	-3.44541741218688	1505	'Sudoeste Paraense'	15015	'Altamira'
1504505	"MELGACO"	15	-50.7174646976964	-1.803446698641	1502	'Marajó'	15004	'Portel'
1504604	"MOCAJUBA"	15	-49.5090234612729	-2.58287297327153	1504	'Nordeste Paraense'	15011	'Cametá'
1504703	"MOJU"	15	-48.7671991273719	-1.885889	1504	'Nordeste Paraense'	15012	'Tomé-Açu'
1504752	"MOJUI DOS CAMPOS"	15	-54.65061704	-26.82213186	1501	'Baixo Amazonas'	15002	'Santarém'
1504802	"MONTE ALEGRE"	15	-54.073374725636	-2.003328	1501	'Baixo Amazonas'	15002	'Santarém'
1504901	"MUANA"	15	-49.2168324424737	-1.53002620835491	1502	'Marajó'	15006	'Arari'
1504950	"NOVA ESPERANCA DO PIRIA"	15	-46.9620928836736	-2.2676259890313	1504	'Nordeste Paraense'	15013	'Guamá'
1504976	"NOVA IPIXUNA"	15	-49.0798869380164	-4.92308630702649	1506	'Sudeste Paraense'	15016	'Tucuruí'
1505007	"NOVA TIMBOTEUA"	15	-47.3932022764599	-1.20414364746687	1504	'Nordeste Paraense'	15010	'Bragantina'
1505031	"NOVO PROGRESSO"	15	-55.4198701179784	-7.03483591328812	1505	'Sudoeste Paraense'	15014	'Itaituba'
1505064	"NOVO REPARTIMENTO"	15	-49.9486382443426	-4.2481485	1506	'Sudeste Paraense'	15016	'Tucuruí'
1505106	"OBIDOS"	15	-55.5163235097126	-1.90923549588121	1501	'Baixo Amazonas'	15001	'Óbidos'
1505205	"OEIRAS DO PARA"	15	-49.8551061087735	-2.004734	1504	'Nordeste Paraense'	15011	'Cametá'
1505304	"ORIXIMINA"	15	-55.8627995152359	-1.7637535	1501	'Baixo Amazonas'	15001	'Óbidos'
1505403	"OUREM"	15	-47.1176193628502	-1.54894714230244	1504	'Nordeste Paraense'	15013	'Guamá'
1505437	"OURILANDIA DO NORTE"	15	-51.0908327746816	-6.74061708637736	1506	'Sudeste Paraense'	15018	'São Félix do Xingu'
1505486	"PACAJA"	15	-50.6348408304298	-3.8303057037573	1505	'Sudoeste Paraense'	15015	'Altamira'
1505494	"PALESTINA DO PARA"	15	-48.3217937261637	-5.74993410622605	1506	'Sudeste Paraense'	15020	'Marabá'
1505502	"PARAGOMINAS"	15	-47.3569615610519	-2.9941905	1506	'Sudeste Paraense'	15017	'Paragominas'
1505536	"PARAUAPEBAS"	15	-49.900780634297	-6.07272988763184	1506	'Sudeste Paraense'	15019	'Parauapebas'
1505551	"PAU D'ARCO"	15	-50.0482755318998	-7.83679440397357	1506	'Sudeste Paraense'	15021	'Redenção'
1505601	"PEIXE-BOI"	15	-47.3179270215591	-1.18956924075654	1504	'Nordeste Paraense'	15010	'Bragantina'
1505635	"PICARRA"	15	-48.8684006672187	-6.45367623455792	1506	'Sudeste Paraense'	15021	'Redenção'
1505650	"PLACAS"	15	-54.2169681312654	-3.86731556213536	1501	'Baixo Amazonas'	15002	'Santarém'
1505700	"PONTA DE PEDRAS"	15	-48.8717855600433	-1.3965999975235	1502	'Marajó'	15006	'Arari'
1505809	"PORTEL"	15	-50.822490442211	-1.936451	1502	'Marajó'	15004	'Portel'
1505908	"PORTO DE MOZ"	15	-52.2424769190201	-1.74609008880885	1501	'Baixo Amazonas'	15003	'Almeirim'
1506005	"PRAINHA"	15	-53.4818139407895	-1.8056945	1501	'Baixo Amazonas'	15002	'Santarém'
1506104	"PRIMAVERA"	15	-47.1172512589126	-0.940111515930574	1504	'Nordeste Paraense'	15010	'Bragantina'
1506112	"QUATIPURU"	15	-47.006786993576	-0.900115853739325	1504	'Nordeste Paraense'	15010	'Bragantina'
1506138	"REDENCAO"	15	-50.0296418255093	-8.0276045	1506	'Sudeste Paraense'	15021	'Redenção'
1506161	"RIO MARIA"	15	-50.0464108775224	-7.31111524468815	1506	'Sudeste Paraense'	15021	'Redenção'
1506187	"RONDON DO PARA"	15	-48.0699737493982	-4.77782172703555	1506	'Sudeste Paraense'	15017	'Paragominas'
1506195	"RUROPOLIS"	15	-54.9058622598691	-4.09906539	1505	'Sudoeste Paraense'	15014	'Itaituba'
1506203	"SALINOPOLIS"	15	-47.3531202631536	-0.623638	1504	'Nordeste Paraense'	15009	'Salgado'
1506302	"SALVATERRA"	15	-48.5131865994469	-0.754525974353047	1502	'Marajó'	15006	'Arari'
1506351	"SANTA BARBARA DO PARA"	15	-48.2977406497887	-1.22943946699244	1503	'Metropolitana de Belém'	15007	'Belém'
1506401	"SANTA CRUZ DO ARARI"	15	-49.1716155661252	-0.659974125599254	1502	'Marajó'	15006	'Arari'
1506500	"SANTA ISABEL DO PARA"	15	-48.1630599409531	-1.29739590129143	1503	'Metropolitana de Belém'	15008	'Castanhal'
1506559	"SANTA LUZIA DO PARA"	15	-46.9061692026983	-1.51882789138752	1504	'Nordeste Paraense'	15013	'Guamá'
1506583	"SANTA MARIA DAS BARREIRAS"	15	-49.7193518572257	-8.87055053969294	1506	'Sudeste Paraense'	15022	'Conceição do Araguaia'
1506609	"SANTA MARIA DO PARA"	15	-47.5746954138091	-1.3478664592967	1504	'Nordeste Paraense'	15010	'Bragantina'
1506708	"SANTANA DO ARAGUAIA"	15	-50.344804321129	-9.329424525	1506	'Sudeste Paraense'	15022	'Conceição do Araguaia'
1506807	"SANTAREM"	15	-54.7185701672711	-2.43621332999996	1501	'Baixo Amazonas'	15002	'Santarém'
1506906	"SANTAREM NOVO"	15	-47.400924744868	-0.928719535783208	1504	'Nordeste Paraense'	15010	'Bragantina'
1507003	"SANTO ANTONIO DO TAUA"	15	-48.1324330748457	-1.1516925	1503	'Metropolitana de Belém'	15008	'Castanhal'
1507102	"SAO CAETANO DE ODIVELAS"	15	-48.0258054980831	-0.746617759994861	1504	'Nordeste Paraense'	15009	'Salgado'
1507151	"SAO DOMINGOS DO ARAGUAIA"	15	-48.7203734107844	-5.549841	1506	'Sudeste Paraense'	15020	'Marabá'
1507201	"SAO DOMINGOS DO CAPIM"	15	-47.7747845692257	-1.6758145	1504	'Nordeste Paraense'	15013	'Guamá'
1507300	"SAO FELIX DO XINGU"	15	-51.9937825239644	-6.64248327834078	1506	'Sudeste Paraense'	15018	'São Félix do Xingu'
1507409	"SAO FRANCISCO DO PARA"	15	-47.7905146107051	-1.17018878467698	1504	'Nordeste Paraense'	15010	'Bragantina'
1507458	"SAO GERALDO DO ARAGUAIA"	15	-48.5557124861926	-6.39895797	1506	'Sudeste Paraense'	15021	'Redenção'
1507466	"SAO JOAO DA PONTA"	15	-47.9207241656462	-0.851002145269607	1504	'Nordeste Paraense'	15009	'Salgado'
1507474	"SAO JOAO DE PIRABAS"	15	-47.1726742979205	-0.766442531515371	1504	'Nordeste Paraense'	15009	'Salgado'
1507508	"SAO JOAO DO ARAGUAIA"	15	-48.7886334020461	-5.35900272441641	1506	'Sudeste Paraense'	15020	'Marabá'
1507607	"SAO MIGUEL DO GUAMA"	15	-47.4824089444892	-1.61713591449048	1504	'Nordeste Paraense'	15013	'Guamá'
1507706	"SAO SEBASTIAO DA BOA VISTA"	15	-49.5323121746161	-1.7188505	1502	'Marajó'	15005	'Furos de Breves'
1507755	"SAPUCAIA"	15	-49.7035807118844	-6.94285711257384	1506	'Sudeste Paraense'	15021	'Redenção'
1507805	"SENADOR JOSE PORFIRIO"	15	-51.9530564180171	-2.59485041832352	1505	'Sudoeste Paraense'	15015	'Altamira'
1507904	"SOURE"	15	-48.5160126622773	-0.7259255	1502	'Marajó'	15006	'Arari'
1507953	"TAILANDIA"	15	-48.9512816295758	-2.9370795	1504	'Nordeste Paraense'	15012	'Tomé-Açu'
1507961	"TERRA ALTA"	15	-47.9078083483744	-1.03482666361629	1504	'Nordeste Paraense'	15009	'Salgado'
1507979	"TERRA SANTA"	15	-56.4909047722432	-2.10811447373903	1501	'Baixo Amazonas'	15001	'Óbidos'
1508001	"TOME-ACU"	15	-48.146896586572	-2.41936685526733	1504	'Nordeste Paraense'	15012	'Tomé-Açu'
1508035	"TRACUATEUA"	15	-46.8994783371171	-1.06878405856835	1504	'Nordeste Paraense'	15010	'Bragantina'
1508050	"TRAIRAO"	15	-55.9961700349273	-4.69981914969727	1505	'Sudoeste Paraense'	15014	'Itaituba'
1508084	"TUCUMA"	15	-51.1395392466358	-6.74997200738229	1506	'Sudeste Paraense'	15018	'São Félix do Xingu'
1508100	"TUCURUI"	15	-49.6671843672248	-3.76688908431164	1506	'Sudeste Paraense'	15016	'Tucuruí'
1508126	"ULIANOPOLIS"	15	-47.5031447549992	-3.75719301	1506	'Sudeste Paraense'	15017	'Paragominas'
1508159	"URUARA"	15	-53.7370310504594	-3.7065285	1505	'Sudoeste Paraense'	15015	'Altamira'
1508209	"VIGIA"	15	-48.1414985852069	-0.855532573667763	1504	'Nordeste Paraense'	15009	'Salgado'
1508308	"VISEU"	15	-46.1387652161496	-1.20327852667727	1504	'Nordeste Paraense'	15013	'Guamá'
1508357	"VITORIA DO XINGU"	15	-52.0112603538154	-2.8837657102288	1505	'Sudoeste Paraense'	15015	'Altamira'
1508407	"XINGUARA"	15	-49.9427005843752	-7.10151282714604	1506	'Sudeste Paraense'	15021	'Redenção'
2500106	"AGUA BRANCA"	25	-37.6422090442572	-7.51107015055765	2501	'Sertão Paraibano'	25007	'Serra do Teixeira'
2500205	"AGUIAR"	25	-38.1775818446374	-7.09480576245307	2501	'Sertão Paraibano'	25005	'Piancó'
2500304	"ALAGOA GRANDE"	25	-35.6338919827495	-7.036775	2503	'Agreste Paraibano'	25015	'Brejo Paraibano'
2500403	"ALAGOA NOVA"	25	-35.75945653982	-7.05779882533355	2503	'Agreste Paraibano'	25015	'Brejo Paraibano'
2500502	"ALAGOINHA"	25	-35.5454913506159	-6.94814040463241	2503	'Agreste Paraibano'	25016	'Guarabira'
2500536	"ALCANTIL"	25	-36.0606043308864	-7.74147703829654	2502	'Borborema'	25011	'Cariri Oriental'
2500577	"ALGODAO DE JANDAIRA"	25	-36.0060933987894	-6.90469403776756	2503	'Agreste Paraibano'	25012	'Curimataú Ocidental'
2500601	"ALHANDRA"	25	-34.9119851554492	-7.43299530218586	2504	'Mata Paraibana'	25023	'Litoral Sul'
2500734	"AMPARO"	25	-37.0647752481212	-7.5672115216128	2502	'Borborema'	25010	'Cariri Ocidental'
2500775	"APARECIDA"	25	-38.0833382545418	-6.78369514151856	2501	'Sertão Paraibano'	25003	'Sousa'
2500809	"ARACAGI"	25	-35.3832990883057	-6.85169661748309	2503	'Agreste Paraibano'	25016	'Guarabira'
2500908	"ARARA"	25	-35.7595417215504	-6.82619172120958	2503	'Agreste Paraibano'	25012	'Curimataú Ocidental'
2501005	"ARARUNA"	25	-35.7359805119437	-6.53144702131672	2503	'Agreste Paraibano'	25013	'Curimataú Oriental'
2501104	"AREIA"	25	-35.7033914011072	-6.965515	2503	'Agreste Paraibano'	25015	'Brejo Paraibano'
2501153	"AREIA DE BARAUNAS"	25	-36.9435079583787	-7.12369501302357	2501	'Sertão Paraibano'	25004	'Patos'
2501203	"AREIAL"	25	-35.9228094312866	-7.04996108869381	2503	'Agreste Paraibano'	25014	'Esperança'
2501302	"AROEIRAS"	25	-35.7155929489148	-7.54846202270723	2503	'Agreste Paraibano'	25019	'Umbuzeiro'
2501351	"ASSUNCAO"	25	-36.7331874760572	-7.0763269436714	2502	'Borborema'	25010	'Cariri Ocidental'
2501401	"BAIA DA TRAICAO"	25	-34.9499310949655	-6.67952912303058	2504	'Mata Paraibana'	25020	'Litoral Norte'
2501500	"BANANEIRAS"	25	-35.6315999027685	-6.74963727499996	2503	'Agreste Paraibano'	25015	'Brejo Paraibano'
2501534	"BARAUNA"	25	-36.2530413530428	-6.64240503523788	2502	'Borborema'	25009	'Seridó Oriental Paraibano'
2501609	"BARRA DE SANTA ROSA"	25	-36.0597726422183	-6.72025267755581	2503	'Agreste Paraibano'	25012	'Curimataú Ocidental'
2501575	"BARRA DE SANTANA"	25	-35.9963140811176	-7.52283378063902	2502	'Borborema'	25011	'Cariri Oriental'
2501708	"BARRA DE SAO MIGUEL"	25	-36.3215359677565	-7.75267062619654	2502	'Borborema'	25011	'Cariri Oriental'
2501807	"BAYEUX"	25	-34.9291858200857	-7.132276485	2504	'Mata Paraibana'	25022	'João Pessoa'
2501906	"BELEM"	25	-35.5362740820625	-6.69404260977741	2503	'Agreste Paraibano'	25016	'Guarabira'
2502003	"BELEM DO BREJO DO CRUZ"	25	-37.5395024822564	-6.18857499767009	2501	'Sertão Paraibano'	25001	'Catolé do Rocha'
2502052	"BERNARDINO BATISTA"	25	-38.5488692212462	-6.45354779321651	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2502102	"BOA VENTURA"	25	-38.2189508765067	-7.42228214528533	2501	'Sertão Paraibano'	25006	'Itaporanga'
2502151	"BOA VISTA"	25	-36.2353736587535	-7.25791308057967	2503	'Agreste Paraibano'	25017	'Campina Grande'
2502201	"BOM JESUS"	25	-38.6551428070451	-6.8179576511972	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2502300	"BOM SUCESSO"	25	-37.9300236973884	-6.44504672298809	2501	'Sertão Paraibano'	25001	'Catolé do Rocha'
2502409	"BONITO DE SANTA FE"	25	-38.5164953050679	-7.31076308185791	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2502508	"BOQUEIRAO"	25	-36.133404750711	-7.48264791987131	2502	'Borborema'	25011	'Cariri Oriental'
2502706	"BORBOREMA"	25	-35.5993759656005	-6.80430588310093	2503	'Agreste Paraibano'	25015	'Brejo Paraibano'
2502805	"BREJO DO CRUZ"	25	-37.5001626416753	-6.3477076067963	2501	'Sertão Paraibano'	25001	'Catolé do Rocha'
2502904	"BREJO DOS SANTOS"	25	-37.8237101751213	-6.37618330821286	2501	'Sertão Paraibano'	25001	'Catolé do Rocha'
2503001	"CAAPORA"	25	-34.9178501439554	-7.51428764137233	2504	'Mata Paraibana'	25023	'Litoral Sul'
2503100	"CABACEIRAS"	25	-36.2843418898015	-7.49066987370998	2502	'Borborema'	25011	'Cariri Oriental'
2503209	"CABEDELO"	25	-34.8394300208048	-6.96698306327964	2504	'Mata Paraibana'	25022	'João Pessoa'
2503308	"CACHOEIRA DOS INDIOS"	25	-38.6783031916558	-6.92393585280371	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2503407	"CACIMBA DE AREIA"	25	-37.1582169542224	-7.12847337694278	2501	'Sertão Paraibano'	25004	'Patos'
2503506	"CACIMBA DE DENTRO"	25	-35.7928209013797	-6.64001674704108	2503	'Agreste Paraibano'	25013	'Curimataú Oriental'
2503555	"CACIMBAS"	25	-37.0604021093534	-7.21235930264992	2501	'Sertão Paraibano'	25007	'Serra do Teixeira'
2503605	"CAICARA"	25	-35.4691142820996	-6.61746979091996	2503	'Agreste Paraibano'	25016	'Guarabira'
2503704	"CAJAZEIRAS"	25	-38.5605303718409	-6.8904645	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2503753	"CAJAZEIRINHAS"	25	-37.7991843341113	-6.96269281318218	2501	'Sertão Paraibano'	25003	'Sousa'
2503803	"CALDAS BRANDAO"	25	-35.3423820919597	-7.17175143704308	2503	'Agreste Paraibano'	25018	'Itabaiana'
2503902	"CAMALAU"	25	-36.8316105814858	-7.89124209512659	2502	'Borborema'	25010	'Cariri Ocidental'
2504009	"CAMPINA GRANDE"	25	-35.8838591147815	-7.22149704	2503	'Agreste Paraibano'	25017	'Campina Grande'
2504033	"CAPIM"	25	-35.1677387140512	-6.91084437486816	2504	'Mata Paraibana'	25020	'Litoral Norte'
2504074	"CARAUBAS"	25	-36.4954780726943	-7.73109937240817	2502	'Borborema'	25011	'Cariri Oriental'
2504108	"CARRAPATEIRA"	25	-38.3442167253342	-7.03965424145217	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2504157	"CASSERENGUE"	25	-35.8163048294656	-6.78376032573468	2503	'Agreste Paraibano'	25013	'Curimataú Oriental'
2504207	"CATINGUEIRA"	25	-37.6107199033242	-7.12520978356176	2501	'Sertão Paraibano'	25005	'Piancó'
2504306	"CATOLE DO ROCHA"	25	-37.7485000905939	-6.346752995	2501	'Sertão Paraibano'	25001	'Catolé do Rocha'
2504355	"CATURITE"	25	-36.0206588240689	-7.41961832073032	2502	'Borborema'	25011	'Cariri Oriental'
2504405	"CONCEICAO"	25	-38.5091579595304	-7.56022508662484	2501	'Sertão Paraibano'	25006	'Itaporanga'
2504504	"CONDADO"	25	-37.6039713346287	-6.91230677729076	2501	'Sertão Paraibano'	25003	'Sousa'
2504603	"CONDE"	25	-34.9071513370733	-7.26357182671599	2504	'Mata Paraibana'	25022	'João Pessoa'
2504702	"CONGO"	25	-36.6615328551699	-7.79257077750369	2502	'Borborema'	25010	'Cariri Ocidental'
2504801	"COREMAS"	25	-37.945537275175	-7.01691828418342	2501	'Sertão Paraibano'	25005	'Piancó'
2504850	"COXIXOLA"	25	-36.6048295218776	-7.62879696062795	2502	'Borborema'	25010	'Cariri Ocidental'
2504900	"CRUZ DO ESPIRITO SANTO"	25	-35.0914891261586	-7.14133696188833	2504	'Mata Paraibana'	25021	'Sapé'
2505006	"CUBATI"	25	-36.3479297161771	-6.86236060920264	2502	'Borborema'	25009	'Seridó Oriental Paraibano'
2505105	"CUITE"	25	-36.1532081655002	-6.48555530115429	2503	'Agreste Paraibano'	25012	'Curimataú Ocidental'
2505238	"CUITE DE MAMANGUAPE"	25	-35.2528248925397	-6.91415747337448	2504	'Mata Paraibana'	25020	'Litoral Norte'
2505204	"CUITEGI"	25	-35.5257412326659	-6.89581374261491	2503	'Agreste Paraibano'	25016	'Guarabira'
2505279	"CURRAL DE CIMA"	25	-35.2670572687864	-6.71743002924733	2504	'Mata Paraibana'	25020	'Litoral Norte'
2505303	"CURRAL VELHO"	25	-38.2003914462447	-7.53808510765584	2501	'Sertão Paraibano'	25006	'Itaporanga'
2505352	"DAMIAO"	25	-35.9099425357662	-6.63189740734812	2503	'Agreste Paraibano'	25012	'Curimataú Ocidental'
2505402	"DESTERRO"	25	-37.0921693225256	-7.29144753043202	2501	'Sertão Paraibano'	25007	'Serra do Teixeira'
2505600	"DIAMANTE"	25	-38.2650442086435	-7.42358342115025	2501	'Sertão Paraibano'	25006	'Itaporanga'
2505709	"DONA INES"	25	-35.6225406506041	-6.60212273515188	2503	'Agreste Paraibano'	25013	'Curimataú Oriental'
2505808	"DUAS ESTRADAS"	25	-35.4181768047992	-6.68813295468359	2503	'Agreste Paraibano'	25016	'Guarabira'
2505907	"EMAS"	25	-37.7145859750777	-7.10799223236892	2501	'Sertão Paraibano'	25005	'Piancó'
2506004	"ESPERANCA"	25	-35.8585932869695	-7.020685	2503	'Agreste Paraibano'	25014	'Esperança'
2506103	"FAGUNDES"	25	-35.7846088757702	-7.36306160444852	2503	'Agreste Paraibano'	25017	'Campina Grande'
2506202	"FREI MARTINHO"	25	-36.4520440619056	-6.40451585235458	2502	'Borborema'	25009	'Seridó Oriental Paraibano'
2506251	"GADO BRAVO"	25	-35.7906509034521	-7.5829411773177	2503	'Agreste Paraibano'	25019	'Umbuzeiro'
2506301	"GUARABIRA"	25	-35.4899649848849	-6.852715	2503	'Agreste Paraibano'	25016	'Guarabira'
2506400	"GURINHEM"	25	-35.4281860624289	-7.12321566843337	2503	'Agreste Paraibano'	25018	'Itabaiana'
2506509	"GURJAO"	25	-36.4862761217649	-7.24622166093218	2502	'Borborema'	25011	'Cariri Oriental'
2506608	"IBIARA"	25	-38.4055678575028	-7.49785122454589	2501	'Sertão Paraibano'	25006	'Itaporanga'
2502607	"IGARACY"	25	-38.1466946448252	-7.17931929137953	2501	'Sertão Paraibano'	25005	'Piancó'
2506707	"IMACULADA"	25	-37.5100748563998	-7.38853726132228	2501	'Sertão Paraibano'	25007	'Serra do Teixeira'
2506806	"INGA"	25	-35.6176892168187	-7.29502691351019	2503	'Agreste Paraibano'	25018	'Itabaiana'
2506905	"ITABAIANA"	25	-35.3375333858727	-7.3309315	2503	'Agreste Paraibano'	25018	'Itabaiana'
2507002	"ITAPORANGA"	25	-38.1525731066856	-7.30398046311692	2501	'Sertão Paraibano'	25006	'Itaporanga'
2507101	"ITAPOROROCA"	25	-35.246295714605	-6.8299201630414	2504	'Mata Paraibana'	25020	'Litoral Norte'
2507200	"ITATUBA"	25	-35.6281612500039	-7.37495775502352	2503	'Agreste Paraibano'	25018	'Itabaiana'
2507309	"JACARAU"	25	-35.2942824484025	-6.6129685867326	2504	'Mata Paraibana'	25020	'Litoral Norte'
2507408	"JERICO"	25	-37.808641377421	-6.55619499094078	2501	'Sertão Paraibano'	25001	'Catolé do Rocha'
2507507	"JOAO PESSOA"	25	-34.8733848135386	-7.14938202	2504	'Mata Paraibana'	25022	'João Pessoa'
2513653	"SANTAREM"	25	-38.4791522142449	-6.48405529669128	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2507606	"JUAREZ TAVORA"	25	-35.5911781067138	-7.1663446273336	2503	'Agreste Paraibano'	25018	'Itabaiana'
2507705	"JUAZEIRINHO"	25	-36.5707010055171	-7.06536831063555	2502	'Borborema'	25009	'Seridó Oriental Paraibano'
2507804	"JUNCO DO SERIDO"	25	-36.716441226086	-6.9933376488561	2502	'Borborema'	25008	'Seridó Ocidental Paraibano'
2507903	"JURIPIRANGA"	25	-35.2394540486469	-7.37029077318249	2504	'Mata Paraibana'	25021	'Sapé'
2508000	"JURU"	25	-37.819264489008	-7.53430713843463	2501	'Sertão Paraibano'	25007	'Serra do Teixeira'
2508109	"LAGOA"	25	-37.9150900701029	-6.59420861333486	2501	'Sertão Paraibano'	25001	'Catolé do Rocha'
2508208	"LAGOA DE DENTRO"	25	-35.3770436482357	-6.67059904965351	2503	'Agreste Paraibano'	25016	'Guarabira'
2508307	"LAGOA SECA"	25	-35.8514401351463	-7.15841248855856	2503	'Agreste Paraibano'	25017	'Campina Grande'
2508406	"LASTRO"	25	-38.1792184928311	-6.51653062578422	2501	'Sertão Paraibano'	25003	'Sousa'
2508505	"LIVRAMENTO"	25	-36.94862930397	-7.3790028227583	2502	'Borborema'	25010	'Cariri Ocidental'
2508554	"LOGRADOURO"	25	-35.4432993555945	-6.61537142228734	2503	'Agreste Paraibano'	25016	'Guarabira'
2508604	"LUCENA"	25	-34.8746090973937	-6.89884933841366	2504	'Mata Paraibana'	25022	'João Pessoa'
2508703	"MAE D'AGUA"	25	-37.428160994959	-7.25704909269706	2501	'Sertão Paraibano'	25004	'Patos'
2508802	"MALTA"	25	-37.5177757103802	-6.90718512349047	2501	'Sertão Paraibano'	25003	'Sousa'
2508901	"MAMANGUAPE"	25	-35.1238932020901	-6.83371514693319	2504	'Mata Paraibana'	25020	'Litoral Norte'
2509008	"MANAIRA"	25	-38.1530716660802	-7.70461414156368	2501	'Sertão Paraibano'	25007	'Serra do Teixeira'
2509057	"MARCACAO"	25	-35.0139243934696	-6.77005417404741	2504	'Mata Paraibana'	25020	'Litoral Norte'
2509107	"MARI"	25	-35.3185424166403	-7.056384	2504	'Mata Paraibana'	25021	'Sapé'
2509156	"MARIZOPOLIS"	25	-38.3553961303769	-6.84467427702503	2501	'Sertão Paraibano'	25003	'Sousa'
2509206	"MASSARANDUBA"	25	-35.7375152076896	-7.18019947108161	2503	'Agreste Paraibano'	25017	'Campina Grande'
2509305	"MATARACA"	25	-35.0485576738377	-6.60051865435005	2504	'Mata Paraibana'	25020	'Litoral Norte'
2509339	"MATINHAS"	25	-35.7709374162111	-7.12116834374255	2503	'Agreste Paraibano'	25015	'Brejo Paraibano'
2509370	"MATO GROSSO"	25	-37.7115726982213	-6.5426334911734	2501	'Sertão Paraibano'	25001	'Catolé do Rocha'
2509396	"MATUREIA"	25	-37.3504338850628	-7.26593000193745	2501	'Sertão Paraibano'	25007	'Serra do Teixeira'
2509404	"MOGEIRO"	25	-35.4824246020059	-7.30948053230429	2503	'Agreste Paraibano'	25018	'Itabaiana'
2509503	"MONTADAS"	25	-35.9582754292669	-7.08909633845498	2503	'Agreste Paraibano'	25014	'Esperança'
2509602	"MONTE HOREBE"	25	-38.5836574944156	-7.20952640226047	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2509701	"MONTEIRO"	25	-37.1226806805604	-7.892217	2502	'Borborema'	25010	'Cariri Ocidental'
2509800	"MULUNGU"	25	-35.4651434243147	-7.02788603160562	2503	'Agreste Paraibano'	25016	'Guarabira'
2509909	"NATUBA"	25	-35.5561446826129	-7.64097882478663	2503	'Agreste Paraibano'	25019	'Umbuzeiro'
2510006	"NAZAREZINHO"	25	-38.3189125786079	-6.9127009191105	2501	'Sertão Paraibano'	25003	'Sousa'
2510105	"NOVA FLORESTA"	25	-36.2024954255349	-6.45613994183283	2503	'Agreste Paraibano'	25012	'Curimataú Ocidental'
2510204	"NOVA OLINDA"	25	-38.0410502007873	-7.47684278075379	2501	'Sertão Paraibano'	25005	'Piancó'
2510303	"NOVA PALMEIRA"	25	-36.4187129743523	-6.67660584264479	2502	'Borborema'	25009	'Seridó Oriental Paraibano'
2510402	"OLHO D'AGUA"	25	-37.7526855285604	-7.22497264854926	2501	'Sertão Paraibano'	25005	'Piancó'
2510501	"OLIVEDOS"	25	-36.2436652193579	-6.98822562229028	2503	'Agreste Paraibano'	25012	'Curimataú Ocidental'
2510600	"OURO VELHO"	25	-37.1543789425132	-7.61865212451032	2502	'Borborema'	25010	'Cariri Ocidental'
2510659	"PARARI"	25	-36.6583244439251	-7.31670010077819	2502	'Borborema'	25010	'Cariri Ocidental'
2510709	"PASSAGEM"	25	-37.0543919436503	-7.13281959666244	2501	'Sertão Paraibano'	25004	'Patos'
2510808	"PATOS"	25	-37.2769133372926	-7.02449166821925	2501	'Sertão Paraibano'	25004	'Patos'
2510907	"PAULISTA"	25	-37.6210556739872	-6.59406157976211	2501	'Sertão Paraibano'	25003	'Sousa'
2511004	"PEDRA BRANCA"	25	-38.0722463078192	-7.42656442613012	2501	'Sertão Paraibano'	25006	'Itaporanga'
2511103	"PEDRA LAVRADA"	25	-36.4720503638462	-6.75788146064519	2502	'Borborema'	25009	'Seridó Oriental Paraibano'
2511202	"PEDRAS DE FOGO"	25	-35.1131779827065	-7.4015385	2504	'Mata Paraibana'	25023	'Litoral Sul'
2512721	"PEDRO REGIS"	25	-35.2930058538096	-6.64447149726608	2504	'Mata Paraibana'	25020	'Litoral Norte'
2511301	"PIANCO"	25	-37.926519001178	-7.1925698759973	2501	'Sertão Paraibano'	25005	'Piancó'
2511400	"PICUI"	25	-36.3470460251457	-6.51013565740654	2502	'Borborema'	25009	'Seridó Oriental Paraibano'
2511509	"PILAR"	25	-35.2598804076248	-7.25988798491644	2504	'Mata Paraibana'	25021	'Sapé'
2511608	"PILOES"	25	-35.6155405946994	-6.86922052824915	2503	'Agreste Paraibano'	25015	'Brejo Paraibano'
2511707	"PILOEZINHOS"	25	-35.530585704033	-6.84056878304328	2503	'Agreste Paraibano'	25016	'Guarabira'
2511806	"PIRPIRITUBA"	25	-35.4977157927507	-6.78080009845509	2503	'Agreste Paraibano'	25016	'Guarabira'
2511905	"PITIMBU"	25	-34.8139304142683	-7.48241339603127	2504	'Mata Paraibana'	25023	'Litoral Sul'
2512002	"POCINHOS"	25	-36.0564422810101	-7.07861726936986	2503	'Agreste Paraibano'	25012	'Curimataú Ocidental'
2512036	"POCO DANTAS"	25	-38.4971655332399	-6.4071756420217	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2512077	"POCO DE JOSE DE MOURA"	25	-38.5099999913196	-6.57691881585499	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2512101	"POMBAL"	25	-37.7982672713629	-6.769855485	2501	'Sertão Paraibano'	25003	'Sousa'
2512200	"PRATA"	25	-37.0823339751871	-7.69698308434496	2502	'Borborema'	25010	'Cariri Ocidental'
2512309	"PRINCESA ISABEL"	25	-37.9936640096162	-7.73386645898496	2501	'Sertão Paraibano'	25007	'Serra do Teixeira'
2512408	"PUXINANA"	25	-35.9584940731246	-7.1489066440629	2503	'Agreste Paraibano'	25017	'Campina Grande'
2512507	"QUEIMADAS"	25	-35.8994339112229	-7.3607915	2503	'Agreste Paraibano'	25017	'Campina Grande'
2512606	"QUIXABA"	25	-37.1470987043486	-7.03081760657396	2501	'Sertão Paraibano'	25004	'Patos'
2512705	"REMIGIO"	25	-35.7958331901249	-6.96629295198897	2503	'Agreste Paraibano'	25012	'Curimataú Ocidental'
2512747	"RIACHAO"	25	-35.6627216943535	-6.54267652788993	2503	'Agreste Paraibano'	25013	'Curimataú Oriental'
2512754	"RIACHAO DO BACAMARTE"	25	-35.6553876583291	-7.25059477327924	2503	'Agreste Paraibano'	25018	'Itabaiana'
2512762	"RIACHAO DO POCO"	25	-35.2612426920122	-7.15150361574026	2504	'Mata Paraibana'	25021	'Sapé'
2512788	"RIACHO DE SANTO ANTONIO"	25	-36.1567097727418	-7.69029534454018	2502	'Borborema'	25011	'Cariri Oriental'
2512804	"RIACHO DOS CAVALOS"	25	-37.6538353910347	-6.43649424914114	2501	'Sertão Paraibano'	25001	'Catolé do Rocha'
2512903	"RIO TINTO"	25	-35.0788522259515	-6.8084485	2504	'Mata Paraibana'	25020	'Litoral Norte'
2513000	"SALGADINHO"	25	-36.8455028942862	-7.10303473308871	2502	'Borborema'	25008	'Seridó Ocidental Paraibano'
2513109	"SALGADO DE SAO FELIX"	25	-35.4433017394971	-7.35535731371706	2503	'Agreste Paraibano'	25018	'Itabaiana'
2513158	"SANTA CECILIA"	25	-35.877474466628	-7.74290596221598	2503	'Agreste Paraibano'	25019	'Umbuzeiro'
2513208	"SANTA CRUZ"	25	-38.0605555920097	-6.53501416751783	2501	'Sertão Paraibano'	25003	'Sousa'
2513307	"SANTA HELENA"	25	-38.6427896706556	-6.71869419964293	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2513356	"SANTA INES"	25	-38.5595999296318	-7.62777971854305	2501	'Sertão Paraibano'	25006	'Itaporanga'
2513406	"SANTA LUZIA"	25	-36.9216783300447	-6.87186326188252	2502	'Borborema'	25008	'Seridó Ocidental Paraibano'
2513703	"SANTA RITA"	25	-34.9658392782709	-7.1380845	2504	'Mata Paraibana'	25022	'João Pessoa'
2513802	"SANTA TERESINHA"	25	-37.4417177954698	-7.08419170526247	2501	'Sertão Paraibano'	25004	'Patos'
2513505	"SANTANA DE MANGUEIRA"	25	-38.3325811539416	-7.55121340952874	2501	'Sertão Paraibano'	25006	'Itaporanga'
2513604	"SANTANA DOS GARROTES"	25	-37.9850430999296	-7.38764445972837	2501	'Sertão Paraibano'	25005	'Piancó'
2513851	"SANTO ANDRE"	25	-36.6309754330546	-7.22048912283316	2502	'Borborema'	25011	'Cariri Oriental'
2513927	"SAO BENTINHO"	25	-37.7227213005654	-6.89030850899754	2501	'Sertão Paraibano'	25003	'Sousa'
2513901	"SAO BENTO"	25	-37.449349664422	-6.48930754079141	2501	'Sertão Paraibano'	25001	'Catolé do Rocha'
2513968	"SAO DOMINGOS"	25	-37.9426027474446	-6.81592498091653	2501	'Sertão Paraibano'	25003	'Sousa'
2513943	"SAO DOMINGOS DO CARIRI"	25	-36.4359294005056	-7.63299070250314	2502	'Borborema'	25011	'Cariri Oriental'
2513984	"SAO FRANCISCO"	25	-38.0971412339127	-6.61927998240531	2501	'Sertão Paraibano'	25003	'Sousa'
2514008	"SAO JOAO DO CARIRI"	25	-36.5315209358872	-7.39020133575512	2502	'Borborema'	25011	'Cariri Oriental'
2500700	"SAO JOAO DO RIO DO PEIXE"	25	-38.445453570848	-6.73443082832052	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2514107	"SAO JOAO DO TIGRE"	25	-36.8457433215685	-8.08104288936475	2502	'Borborema'	25010	'Cariri Ocidental'
2514206	"SAO JOSE DA LAGOA TAPADA"	25	-38.1577701892674	-6.94423148941398	2501	'Sertão Paraibano'	25003	'Sousa'
2514305	"SAO JOSE DE CAIANA"	25	-38.2978233702354	-7.24915963108365	2501	'Sertão Paraibano'	25006	'Itaporanga'
2514404	"SAO JOSE DE ESPINHARAS"	25	-37.3251148399789	-6.84417960846357	2501	'Sertão Paraibano'	25004	'Patos'
2514503	"SAO JOSE DE PIRANHAS"	25	-38.5010748206497	-7.12086995744378	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2514552	"SAO JOSE DE PRINCESA"	25	-38.0988027202559	-7.7429694507639	2501	'Sertão Paraibano'	25007	'Serra do Teixeira'
2514602	"SAO JOSE DO BONFIM"	25	-37.3092447284815	-7.16091497735897	2501	'Sertão Paraibano'	25004	'Patos'
2514651	"SAO JOSE DO BREJO DO CRUZ"	25	-37.3538296761784	-6.21291534073982	2501	'Sertão Paraibano'	25001	'Catolé do Rocha'
2514701	"SAO JOSE DO SABUGI"	25	-36.7974932181972	-6.77553140683712	2502	'Borborema'	25008	'Seridó Ocidental Paraibano'
2514800	"SAO JOSE DOS CORDEIROS"	25	-36.8027778195065	-7.39264269695839	2502	'Borborema'	25010	'Cariri Ocidental'
2514453	"SAO JOSE DOS RAMOS"	25	-35.3779610544874	-7.24712735721632	2504	'Mata Paraibana'	25021	'Sapé'
2514909	"SAO MAMEDE"	25	-37.0948573852401	-6.93022837139016	2502	'Borborema'	25008	'Seridó Ocidental Paraibano'
2515005	"SAO MIGUEL DE TAIPU"	25	-35.2104513918797	-7.24923353038705	2504	'Mata Paraibana'	25021	'Sapé'
2515104	"SAO SEBASTIAO DE LAGOA DE ROCA"	25	-35.8664139115223	-7.10094595524404	2503	'Agreste Paraibano'	25014	'Esperança'
2515203	"SAO SEBASTIAO DO UMBUZEIRO"	25	-37.0084169780022	-8.15711875468474	2502	'Borborema'	25010	'Cariri Ocidental'
2515401	"SERIDO"	25	-36.4107641095568	-6.85690856317292	2502	'Borborema'	25009	'Seridó Oriental Paraibano'
2515302	"SAPE"	25	-35.2304326165497	-7.087111	2504	'Mata Paraibana'	25021	'Sapé'
2515500	"SERRA BRANCA"	25	-36.6556668629229	-7.4805025244756	2502	'Borborema'	25010	'Cariri Ocidental'
2515609	"SERRA DA RAIZ"	25	-35.4427388368849	-6.68551765005369	2503	'Agreste Paraibano'	25016	'Guarabira'
2515708	"SERRA GRANDE"	25	-38.3748947870419	-7.21414775784029	2501	'Sertão Paraibano'	25006	'Itaporanga'
2515807	"SERRA REDONDA"	25	-35.6742704972443	-7.18254942468272	2503	'Agreste Paraibano'	25017	'Campina Grande'
2515906	"SERRARIA"	25	-35.6441425707571	-6.81708894284731	2503	'Agreste Paraibano'	25015	'Brejo Paraibano'
2515930	"SERTAOZINHO"	25	-35.4417507457045	-6.75079754596171	2503	'Agreste Paraibano'	25016	'Guarabira'
2515971	"SOBRADO"	25	-35.2381954790313	-7.14457561363735	2504	'Mata Paraibana'	25021	'Sapé'
2516003	"SOLANEA"	25	-35.6561584077255	-6.7598975	2503	'Agreste Paraibano'	25013	'Curimataú Oriental'
2516102	"SOLEDADE"	25	-36.362664860377	-7.05874137777625	2503	'Agreste Paraibano'	25012	'Curimataú Ocidental'
2516151	"SOSSEGO"	25	-36.2482238788383	-6.76752752888267	2503	'Agreste Paraibano'	25012	'Curimataú Ocidental'
2516201	"SOUSA"	25	-38.2296050806011	-6.763378005	2501	'Sertão Paraibano'	25003	'Sousa'
2516300	"SUME"	25	-36.8802761457321	-7.67105361514705	2502	'Borborema'	25010	'Cariri Ocidental'
2516409	"CAMPO DE SANTANA"	25	-35.6388366564942	-6.48891694245472	2503	'Agreste Paraibano'	25013	'Curimataú Oriental'
2516508	"TAPEROA"	25	-36.8289985342818	-7.20953935099688	2502	'Borborema'	25010	'Cariri Ocidental'
2516607	"TAVARES"	25	-37.8785919324605	-7.63570844619416	2501	'Sertão Paraibano'	25007	'Serra do Teixeira'
2516706	"TEIXEIRA"	25	-37.2515615776267	-7.22370290861476	2501	'Sertão Paraibano'	25007	'Serra do Teixeira'
2516755	"TENORIO"	25	-36.6279998744085	-6.93826040293171	2502	'Borborema'	25009	'Seridó Oriental Paraibano'
2516805	"TRIUNFO"	25	-38.598098331275	-6.5768355073857	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2516904	"UIRAUNA"	25	-38.4070270101528	-6.52492709513081	2501	'Sertão Paraibano'	25002	'Cajazeiras'
2517001	"UMBUZEIRO"	25	-35.6714708228878	-7.69820632935525	2503	'Agreste Paraibano'	25019	'Umbuzeiro'
2517100	"VARZEA"	25	-36.9927210043315	-6.77080724678283	2502	'Borborema'	25008	'Seridó Ocidental Paraibano'
2517209	"VIEIROPOLIS"	25	-38.2778434980653	-6.54571355168578	2501	'Sertão Paraibano'	25003	'Sousa'
2505501	"VISTA SERRANA"	25	-37.5679145327463	-6.74068727242421	2501	'Sertão Paraibano'	25003	'Sousa'
2517407	"ZABELE"	25	-37.0935519728886	-8.0768741972494	2502	'Borborema'	25010	'Cariri Ocidental'
2600054	"ABREU E LIMA"	26	-34.8991305847304	-7.90444899	2605	'Metropolitana de Recife'	26017	'Recife'
2600104	"AFOGADOS DA INGAZEIRA"	26	-37.6376860181022	-7.74832758583151	2601	'Sertão Pernambucano'	26003	'Pajeú'
2600203	"AFRANIO"	26	-41.0057973410949	-8.51109128375517	2602	'São Francisco Pernambucano'	26005	'Petrolina'
2600302	"AGRESTINA"	26	-35.94677683746	-8.455973	2603	'Agreste Pernambucano'	26012	'Brejo Pernambucano'
2600401	"AGUA PRETA"	26	-35.5185573511919	-8.70912255231174	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2600500	"AGUAS BELAS"	26	-37.1219571685606	-9.1145895	2603	'Agreste Pernambucano'	26007	'Vale do Ipanema'
2600609	"ALAGOINHA"	26	-36.7754560083166	-8.46627052298468	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2600708	"ALIANCA"	26	-35.228501497065	-7.60472980846341	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2600807	"ALTINHO"	26	-36.0596997585832	-8.4895925	2603	'Agreste Pernambucano'	26012	'Brejo Pernambucano'
2600906	"AMARAJI"	26	-35.4507729209957	-8.378487	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2601003	"ANGELIM"	26	-36.2848143554983	-8.89037420790995	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2601052	"ARACOIABA"	26	-35.0939665275382	-7.78564187251451	2605	'Metropolitana de Recife'	26016	'Itamaracá'
2601102	"ARARIPINA"	26	-40.5024605749941	-7.5781415	2601	'Sertão Pernambucano'	26001	'Araripina'
2601201	"ARCOVERDE"	26	-37.0565055646245	-8.4239405	2601	'Sertão Pernambucano'	26004	'Sertão do Moxotó'
2601300	"BARRA DE GUABIRABA"	26	-35.6628188858245	-8.42093503757972	2603	'Agreste Pernambucano'	26012	'Brejo Pernambucano'
2601409	"BARREIROS"	26	-35.1990859873173	-8.81413799010685	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2601508	"BELEM DE MARIA"	26	-35.8399240901317	-8.6212019106173	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2601607	"BELEM DE SAO FRANCISCO"	26	-38.9615995649726	-8.75146278008585	2602	'São Francisco Pernambucano'	26006	'Itaparica'
2601706	"BELO JARDIM"	26	-36.420035083018	-8.3352954393583	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2601805	"BETANIA"	26	-38.0387381366471	-8.26984078962668	2601	'Sertão Pernambucano'	26004	'Sertão do Moxotó'
2601904	"BEZERROS"	26	-35.754487945878	-8.2353595	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2602001	"BODOCO"	26	-39.9361631850394	-7.77934262699137	2601	'Sertão Pernambucano'	26001	'Araripina'
2602100	"BOM CONSELHO"	26	-36.679314385707	-9.16338298488547	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2602209	"BOM JARDIM"	26	-35.5871395022878	-7.79951218074003	2603	'Agreste Pernambucano'	26010	'Médio Capibaribe'
2602308	"BONITO"	26	-35.7285279259275	-8.4722605	2603	'Agreste Pernambucano'	26012	'Brejo Pernambucano'
2602407	"BREJAO"	26	-36.5646966592673	-9.02724915072048	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2602506	"BREJINHO"	26	-37.2873345539798	-7.3456712759663	2601	'Sertão Pernambucano'	26003	'Pajeú'
2602605	"BREJO DA MADRE DE DEUS"	26	-36.3703914413319	-8.1489565	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2602704	"BUENOS AIRES"	26	-35.3295704142006	-7.72437221003539	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2602803	"BUIQUE"	26	-37.156988114845	-8.62205904068232	2603	'Agreste Pernambucano'	26007	'Vale do Ipanema'
2602902	"CABO DE SANTO AGOSTINHO"	26	-35.0384889718131	-8.28986423029788	2605	'Metropolitana de Recife'	26018	'Suape'
2603009	"CABROBO"	26	-39.3098413379707	-8.51510548326908	2602	'São Francisco Pernambucano'	26005	'Petrolina'
2603108	"CACHOEIRINHA"	26	-36.2359914117891	-8.48683107303865	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2603207	"CAETES"	26	-36.6248040076124	-8.77559484478882	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2603306	"CALCADO"	26	-36.3332880795364	-8.73837794373232	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2603405	"CALUMBI"	26	-38.1537459242791	-7.93842732667504	2601	'Sertão Pernambucano'	26003	'Pajeú'
2603454	"CAMARAGIBE"	26	-34.9957213563856	-8.0205217674976	2605	'Metropolitana de Recife'	26017	'Recife'
2603504	"CAMOCIM DE SAO FELIX"	26	-35.7651947265538	-8.36213804006225	2603	'Agreste Pernambucano'	26012	'Brejo Pernambucano'
2603603	"CAMUTANGA"	26	-35.2827906438477	-7.40708241993907	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2603702	"CANHOTINHO"	26	-36.193574878074	-8.88387056215619	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2603801	"CAPOEIRAS"	26	-36.6237980172928	-8.73614267974256	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2603900	"CARNAIBA"	26	-37.793398902551	-7.80305821890566	2601	'Sertão Pernambucano'	26003	'Pajeú'
2603926	"CARNAUBEIRA DA PENHA"	26	-38.7434219469465	-8.32060796467651	2602	'São Francisco Pernambucano'	26006	'Itaparica'
2604007	"CARPINA"	26	-35.2580606059131	-7.84688671641732	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2604106	"CARUARU"	26	-35.9670733600535	-8.285898	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2604155	"CASINHAS"	26	-35.7253231033555	-7.74320656791998	2603	'Agreste Pernambucano'	26009	'Alto Capibaribe'
2604205	"CATENDE"	26	-35.7216666573487	-8.6703075	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2604304	"CEDRO"	26	-39.2371382153378	-7.71746923330341	2601	'Sertão Pernambucano'	26002	'Salgueiro'
2604403	"CHA DE ALEGRIA"	26	-35.213726736211	-7.99790078017443	2604	'Mata Pernambucana'	26014	'Vitória de Santo Antão'
2604502	"CHA GRANDE"	26	-35.464740812514	-8.24011277651399	2604	'Mata Pernambucana'	26014	'Vitória de Santo Antão'
2604601	"CONDADO"	26	-35.1041184906515	-7.589382255	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2604700	"CORRENTES"	26	-36.3297018953137	-9.12866550151905	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2604809	"CORTES"	26	-35.5415869000023	-8.4751512172918	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2604908	"CUMARU"	26	-35.6946989631154	-8.01503244286428	2603	'Agreste Pernambucano'	26010	'Médio Capibaribe'
2605004	"CUPIRA"	26	-35.9502573664167	-8.61128266016395	2603	'Agreste Pernambucano'	26012	'Brejo Pernambucano'
2605103	"CUSTODIA"	26	-37.6410965906668	-8.089002	2601	'Sertão Pernambucano'	26004	'Sertão do Moxotó'
2605152	"DORMENTES"	26	-40.7707358130966	-8.44865698651541	2602	'São Francisco Pernambucano'	26005	'Petrolina'
2605202	"ESCADA"	26	-35.2361574244476	-8.36252199	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2605301	"EXU"	26	-39.7227283392676	-7.516307	2601	'Sertão Pernambucano'	26001	'Araripina'
2605400	"FEIRA NOVA"	26	-35.390597986464	-7.94872774216478	2603	'Agreste Pernambucano'	26010	'Médio Capibaribe'
2605459	"FERNANDO DE NORONHA"	26	-32.4351863280529	-3.85202140078181	2605	'Metropolitana de Recife'	26019	'Fernando de Noronha'
2605509	"FERREIROS"	26	-35.2440702124351	-7.44549420525894	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2605608	"FLORES"	26	-37.9714561137782	-7.86171447493079	2601	'Sertão Pernambucano'	26003	'Pajeú'
2605707	"FLORESTA"	26	-38.5712393419872	-8.6008265	2602	'São Francisco Pernambucano'	26006	'Itaparica'
2605806	"FREI MIGUELINHO"	26	-35.9231276419375	-7.94445824740133	2603	'Agreste Pernambucano'	26009	'Alto Capibaribe'
2605905	"GAMELEIRA"	26	-35.3866107834559	-8.58383577054338	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2606002	"GARANHUNS"	26	-36.4930502821005	-8.88890553	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2606101	"GLORIA DO GOITA"	26	-35.2923223922623	-7.99960847212724	2604	'Mata Pernambucana'	26014	'Vitória de Santo Antão'
2606200	"GOIANA"	26	-34.9983762971528	-7.55923185486717	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2606309	"GRANITO"	26	-39.6192863432021	-7.70925328234973	2601	'Sertão Pernambucano'	26001	'Araripina'
2606408	"GRAVATA"	26	-35.5714923938373	-8.2059995	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2606507	"IATI"	26	-36.8472759684337	-9.04570925087953	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2606606	"IBIMIRIM"	26	-37.6900466896833	-8.53876220824973	2601	'Sertão Pernambucano'	26004	'Sertão do Moxotó'
2606705	"IBIRAJUBA"	26	-36.1804630923865	-8.58053493560591	2603	'Agreste Pernambucano'	26012	'Brejo Pernambucano'
2606804	"IGARASSU"	26	-34.9105833875875	-7.82837199	2605	'Metropolitana de Recife'	26016	'Itamaracá'
2606903	"IGUARACI"	26	-37.5188211184962	-7.84477430130535	2601	'Sertão Pernambucano'	26003	'Pajeú'
2607604	"ILHA DE ITAMARACA"	26	-34.823950567034	-7.74657331766388	2605	'Metropolitana de Recife'	26016	'Itamaracá'
2607000	"INAJA"	26	-37.8244851112304	-8.90204607887599	2601	'Sertão Pernambucano'	26004	'Sertão do Moxotó'
2607109	"INGAZEIRA"	26	-37.4576704743563	-7.6777971945153	2601	'Sertão Pernambucano'	26003	'Pajeú'
2607208	"IPOJUCA"	26	-35.0634719379371	-8.3969865	2605	'Metropolitana de Recife'	26018	'Suape'
2607307	"IPUBI"	26	-40.1502087501672	-7.6497045	2601	'Sertão Pernambucano'	26001	'Araripina'
2607406	"ITACURUBA"	26	-38.6863416893124	-8.72451506478971	2602	'São Francisco Pernambucano'	26006	'Itaparica'
2607505	"ITAIBA"	26	-37.4189484589274	-8.9400544003599	2603	'Agreste Pernambucano'	26007	'Vale do Ipanema'
2607653	"ITAMBE"	26	-35.1106273574317	-7.40926386	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2607703	"ITAPETIM"	26	-37.1884393109605	-7.37842852842199	2601	'Sertão Pernambucano'	26003	'Pajeú'
2607752	"ITAPISSUMA"	26	-34.8892710487235	-7.77403476474654	2605	'Metropolitana de Recife'	26016	'Itamaracá'
2607802	"ITAQUITINGA"	26	-35.1026145695038	-7.6663936085023	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2607901	"JABOATAO DOS GUARARAPES"	26	-34.9211734672603	-8.16539146735745	2605	'Metropolitana de Recife'	26017	'Recife'
2607950	"JAQUEIRA"	26	-35.7973952137599	-8.72796987804595	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2608008	"JATAUBA"	26	-36.4988285484163	-7.98725777724561	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2608057	"JATOBA"	26	-38.2750376623843	-9.18506999252143	2602	'São Francisco Pernambucano'	26006	'Itaparica'
2608107	"JOAO ALFREDO"	26	-35.5915023689903	-7.86018872703986	2603	'Agreste Pernambucano'	26010	'Médio Capibaribe'
2608206	"JOAQUIM NABUCO"	26	-35.5292418261614	-8.62689829945635	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2608255	"JUCATI"	26	-36.4903865236772	-8.70702896437458	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2608305	"JUPI"	26	-36.4117337384655	-8.70609685279339	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2608404	"JUREMA"	26	-36.1359544906229	-8.7196671740285	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2608453	"LAGOA DO CARRO"	26	-35.3126019234256	-7.84423249520262	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2608503	"LAGOA DO ITAENGA"	26	-35.2928036525271	-7.93237817854015	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2608602	"LAGOA DO OURO"	26	-36.4643169318296	-9.12417183792505	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2608701	"LAGOA DOS GATOS"	26	-35.9071210443245	-8.64925486457646	2603	'Agreste Pernambucano'	26012	'Brejo Pernambucano'
2608750	"LAGOA GRANDE"	26	-40.2707251264837	-8.995051485	2602	'São Francisco Pernambucano'	26005	'Petrolina'
2608800	"LAJEDO"	26	-36.3214966175308	-8.66285686583942	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2608909	"LIMOEIRO"	26	-35.4552610509597	-7.880198	2603	'Agreste Pernambucano'	26010	'Médio Capibaribe'
2609006	"MACAPARANA"	26	-35.4498749786749	-7.55568069874715	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2609105	"MACHADOS"	26	-35.5141405623355	-7.68857248562588	2603	'Agreste Pernambucano'	26010	'Médio Capibaribe'
2609154	"MANARI"	26	-37.626822945483	-8.96010814463401	2601	'Sertão Pernambucano'	26004	'Sertão do Moxotó'
2609204	"MARAIAL"	26	-35.8141175724592	-8.78307760133499	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2609303	"MIRANDIBA"	26	-38.7345645822767	-8.12024380215452	2601	'Sertão Pernambucano'	26002	'Salgueiro'
2614303	"MOREILANDIA"	26	-39.5537537310788	-7.62998268812021	2601	'Sertão Pernambucano'	26001	'Araripina'
2609402	"MORENO"	26	-35.0948690998839	-8.11869453	2605	'Metropolitana de Recife'	26017	'Recife'
2609501	"NAZARE DA MATA"	26	-35.2213386961744	-7.737688	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2609600	"OLINDA"	26	-34.8613103898235	-7.99266007532292	2605	'Metropolitana de Recife'	26017	'Recife'
2609709	"OROBO"	26	-35.6029820966855	-7.73789513366546	2603	'Agreste Pernambucano'	26010	'Médio Capibaribe'
2609808	"OROCO"	26	-39.5952457761053	-8.61794564613774	2602	'São Francisco Pernambucano'	26005	'Petrolina'
2609907	"OURICURI"	26	-40.0814625767368	-7.883151975	2601	'Sertão Pernambucano'	26001	'Araripina'
2610004	"PALMARES"	26	-35.5883359937581	-8.6790825	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2610103	"PALMEIRINA"	26	-36.3273109987233	-9.00168328514325	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2610202	"PANELAS"	26	-36.0015757987346	-8.66724228497482	2603	'Agreste Pernambucano'	26012	'Brejo Pernambucano'
2610301	"PARANATAMA"	26	-36.6584292680601	-8.92014533800006	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2610400	"PARNAMIRIM"	26	-39.5757868229726	-8.09013832716909	2601	'Sertão Pernambucano'	26002	'Salgueiro'
2610509	"PASSIRA"	26	-35.5816849952226	-7.97888394183413	2603	'Agreste Pernambucano'	26010	'Médio Capibaribe'
2610608	"PAUDALHO"	26	-35.1791510623855	-7.897135005	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2610707	"PAULISTA"	26	-34.8847916197368	-7.943188	2605	'Metropolitana de Recife'	26017	'Recife'
2610806	"PEDRA"	26	-36.9427981488871	-8.4984765	2603	'Agreste Pernambucano'	26007	'Vale do Ipanema'
2610905	"PESQUEIRA"	26	-36.6955147218979	-8.35545610783497	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2611002	"PETROLANDIA"	26	-38.2207335453001	-8.97734346438332	2602	'São Francisco Pernambucano'	26006	'Itaparica'
2611101	"PETROLINA"	26	-40.4999993346523	-9.397375515	2602	'São Francisco Pernambucano'	26005	'Petrolina'
2611200	"POCAO"	26	-36.7058798977192	-8.18622700894123	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2611309	"POMBOS"	26	-35.3961953582275	-8.14435986002866	2604	'Mata Pernambucana'	26014	'Vitória de Santo Antão'
2611408	"PRIMAVERA"	26	-35.3539433948819	-8.33137608611828	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2611507	"QUIPAPA"	26	-36.0119895299569	-8.82788502205398	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2611533	"QUIXABA"	26	-37.8464456195457	-7.71812641014089	2601	'Sertão Pernambucano'	26003	'Pajeú'
2611606	"RECIFE"	26	-34.8889419445777	-8.06276248305241	2605	'Metropolitana de Recife'	26017	'Recife'
2611705	"RIACHO DAS ALMAS"	26	-35.8608749474581	-8.12703278058798	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2611804	"RIBEIRAO"	26	-35.3761308237039	-8.51111604	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2611903	"RIO FORMOSO"	26	-35.155432817216	-8.66217108532585	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2612000	"SAIRE"	26	-35.7102477662867	-8.32761353933924	2603	'Agreste Pernambucano'	26012	'Brejo Pernambucano'
2612109	"SALGADINHO"	26	-35.6380612404985	-7.93948374141724	2603	'Agreste Pernambucano'	26010	'Médio Capibaribe'
2612208	"SALGUEIRO"	26	-39.120850981104	-8.07067752213416	2601	'Sertão Pernambucano'	26002	'Salgueiro'
2612307	"SALOA"	26	-36.6927291741698	-8.97599548086788	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2612406	"SANHARO"	26	-36.5625071953832	-8.36296196892339	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2612455	"SANTA CRUZ"	26	-40.3376876555693	-8.23796111841333	2601	'Sertão Pernambucano'	26001	'Araripina'
2612471	"SANTA CRUZ DA BAIXA VERDE"	26	-38.1531381817594	-7.82146968232143	2601	'Sertão Pernambucano'	26003	'Pajeú'
2612505	"SANTA CRUZ DO CAPIBARIBE"	26	-36.2039500171457	-7.9551895	2603	'Agreste Pernambucano'	26009	'Alto Capibaribe'
2612554	"SANTA FILOMENA"	26	-40.615775185024	-8.16051116726482	2601	'Sertão Pernambucano'	26001	'Araripina'
2612604	"SANTA MARIA DA BOA VISTA"	26	-39.8242357254967	-8.8041265	2602	'São Francisco Pernambucano'	26005	'Petrolina'
2612703	"SANTA MARIA DO CAMBUCA"	26	-35.8852433390024	-7.83181342623099	2603	'Agreste Pernambucano'	26009	'Alto Capibaribe'
2612802	"SANTA TEREZINHA"	26	-37.4800327232567	-7.37035573926697	2601	'Sertão Pernambucano'	26003	'Pajeú'
2612901	"SAO BENEDITO DO SUL"	26	-35.9311226193514	-8.81043823419499	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2613008	"SAO BENTO DO UNA"	26	-36.4462983615963	-8.51986752058347	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2613107	"SAO CAITANO"	26	-36.1373597958186	-8.3273605	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2613206	"SAO JOAO"	26	-36.3682530765329	-8.87755937542735	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2613305	"SAO JOAQUIM DO MONTE"	26	-35.8094911721096	-8.4321515	2603	'Agreste Pernambucano'	26012	'Brejo Pernambucano'
2613404	"SAO JOSE DA COROA GRANDE"	26	-35.1457070847085	-8.89419513072977	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2613503	"SAO JOSE DO BELMONTE"	26	-38.7594537800097	-7.86174005472195	2601	'Sertão Pernambucano'	26002	'Salgueiro'
2613602	"SAO JOSE DO EGITO"	26	-37.2750721852438	-7.47402518326653	2601	'Sertão Pernambucano'	26003	'Pajeú'
2613701	"SAO LOURENCO DA MATA"	26	-35.041277539321	-7.995938	2605	'Metropolitana de Recife'	26017	'Recife'
2613800	"SAO VICENTE FERRER"	26	-35.4901218808857	-7.59221273256537	2603	'Agreste Pernambucano'	26010	'Médio Capibaribe'
2613909	"SERRA TALHADA"	26	-38.2963149474727	-7.98799752	2601	'Sertão Pernambucano'	26003	'Pajeú'
2614006	"SERRITA"	26	-39.2926231743621	-7.95434039807981	2601	'Sertão Pernambucano'	26002	'Salgueiro'
2614105	"SERTANIA"	26	-37.2673901012878	-8.07245	2601	'Sertão Pernambucano'	26004	'Sertão do Moxotó'
2614204	"SIRINHAEM"	26	-35.1164053546685	-8.5933695	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2614402	"SOLIDAO"	26	-37.6474702370335	-7.602125684249	2601	'Sertão Pernambucano'	26003	'Pajeú'
2614501	"SURUBIM"	26	-35.7567841034417	-7.83515705731727	2603	'Agreste Pernambucano'	26009	'Alto Capibaribe'
2614600	"TABIRA"	26	-37.5402657741875	-7.59113651302262	2601	'Sertão Pernambucano'	26003	'Pajeú'
2614709	"TACAIMBO"	26	-36.2904043048255	-8.31561072482585	2603	'Agreste Pernambucano'	26008	'Vale do Ipojuca'
2614808	"TACARATU"	26	-38.1534611596796	-9.10569964429411	2602	'São Francisco Pernambucano'	26006	'Itaparica'
2614857	"TAMANDARE"	26	-35.0906465455374	-8.70468927853919	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2615003	"TAQUARITINGA DO NORTE"	26	-36.0433376713092	-7.90215982578207	2603	'Agreste Pernambucano'	26009	'Alto Capibaribe'
2615102	"TEREZINHA"	26	-36.6214759481747	-9.0577780594961	2603	'Agreste Pernambucano'	26011	'Garanhuns'
2615201	"TERRA NOVA"	26	-39.37442183786	-8.2303579786437	2602	'São Francisco Pernambucano'	26005	'Petrolina'
2615300	"TIMBAUBA"	26	-35.3187721210384	-7.51174567401952	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2615409	"TORITAMA"	26	-36.0568434929956	-8.00665027093915	2603	'Agreste Pernambucano'	26009	'Alto Capibaribe'
2615508	"TRACUNHAEM"	26	-35.2379228139922	-7.80268861266727	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2615607	"TRINDADE"	26	-40.2655906092822	-7.76179462574901	2601	'Sertão Pernambucano'	26001	'Araripina'
2615706	"TRIUNFO"	26	-38.1070603447143	-7.83087635877055	2601	'Sertão Pernambucano'	26003	'Pajeú'
2615805	"TUPANATINGA"	26	-37.3402334718006	-8.7515816593182	2603	'Agreste Pernambucano'	26007	'Vale do Ipanema'
2615904	"TUPARETAMA"	26	-37.3111818112638	-7.59875946480799	2601	'Sertão Pernambucano'	26003	'Pajeú'
2616001	"VENTUROSA"	26	-36.8783720838699	-8.57652690116664	2603	'Agreste Pernambucano'	26007	'Vale do Ipanema'
2616100	"VERDEJANTE"	26	-38.9742826042683	-7.93288370462191	2601	'Sertão Pernambucano'	26002	'Salgueiro'
2616183	"VERTENTE DO LERIO"	26	-35.8530027396954	-7.77481945530466	2603	'Agreste Pernambucano'	26009	'Alto Capibaribe'
2616209	"VERTENTES"	26	-35.989305931	-7.90574260349678	2603	'Agreste Pernambucano'	26009	'Alto Capibaribe'
2616308	"VICENCIA"	26	-35.320300689316	-7.6529595	2604	'Mata Pernambucana'	26013	'Mata Setentrional Pernambucana'
2616407	"VITORIA DE SANTO ANTAO"	26	-35.2938642410814	-8.118748	2604	'Mata Pernambucana'	26014	'Vitória de Santo Antão'
2616506	"XEXEU"	26	-35.6242353157547	-8.80331340552882	2604	'Mata Pernambucana'	26015	'Mata Meridional Pernambucana'
2200053	"ACAUA"	22	-41.0836378172387	-8.22078666287762	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2200103	"AGRICOLANDIA"	22	-42.6591831974356	-5.79550193543481	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2200202	"AGUA BRANCA"	22	-42.6351308599585	-5.89326633794508	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2200251	"ALAGOINHA DO PIAUI"	22	-40.9346348169192	-7.00817528014998	2204	'Sudeste Piauiense'	22014	'Pio IX'
2200277	"ALEGRETE DO PIAUI"	22	-40.8578629896146	-7.2453494663005	2204	'Sudeste Piauiense'	22014	'Pio IX'
2200301	"ALTO LONGA"	22	-42.210321962161	-5.25099301135127	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2200400	"ALTOS"	22	-42.4609480355568	-5.03654643434055	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2200459	"ALVORADA DO GURGUEIA"	22	-43.8630715789216	-8.44395907228392	2203	'Sudoeste Piauiense'	22010	'Alto Médio Gurguéia'
2200509	"AMARANTE"	22	-42.8536928230327	-6.24661077217367	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2200608	"ANGICAL DO PIAUI"	22	-42.7438657484282	-6.08724169212959	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2200707	"ANISIO DE ABREU"	22	-43.0348533320546	-9.17491853090693	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2200806	"ANTONIO ALMEIDA"	22	-44.1965353200183	-7.21935583400696	2203	'Sudoeste Piauiense'	22008	'Bertolínia'
2200905	"AROAZES"	22	-41.797453338794	-6.11285025626382	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2200954	"AROEIRAS DO ITAIM"	22	-41.5632044182612	-7.27874546497215	2204	'Sudeste Piauiense'	22013	'Picos'
2201002	"ARRAIAL"	22	-42.5365666246569	-6.65082702747813	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2201051	"ASSUNCAO DO PIAUI"	22	-41.0508299964828	-5.8649144945276	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2201101	"AVELINO LOPES"	22	-43.9415101417959	-10.1347450128483	2203	'Sudoeste Piauiense'	22012	'Chapadas do Extremo Sul Piauiense'
2201150	"BAIXA GRANDE DO RIBEIRO"	22	-45.212815292567	-7.85335195918549	2203	'Sudoeste Piauiense'	22007	'Alto Parnaíba Piauiense'
2201176	"BARRA D'ALCANTARA"	22	-42.1050020825819	-6.5188730722939	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2201200	"BARRAS"	22	-42.2953398573464	-4.24309335434368	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2201309	"BARREIRAS DO PIAUI"	22	-45.4777877054503	-9.92124682674306	2203	'Sudoeste Piauiense'	22010	'Alto Médio Gurguéia'
2201408	"BARRO DURO"	22	-42.5133778221163	-5.81235970781592	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2201507	"BATALHA"	22	-42.075218732031	-4.0204123357539	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2201556	"BELA VISTA DO PIAUI"	22	-41.8713796439709	-7.97218531957187	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2201572	"BELEM DO PIAUI"	22	-40.9703021906942	-7.37013961551867	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2201606	"BENEDITINOS"	22	-42.3706167024747	-5.44760286024037	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2201705	"BERTOLINIA"	22	-43.9543877391026	-7.62862476310433	2203	'Sudoeste Piauiense'	22008	'Bertolínia'
2201739	"BETANIA DO PIAUI"	22	-40.7966219288235	-8.14566557729576	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2201770	"BOA HORA"	22	-42.1252957358755	-4.40900960580236	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2201804	"BOCAINA"	22	-41.3223406826513	-6.95484233259558	2204	'Sudeste Piauiense'	22013	'Picos'
2201903	"BOM JESUS"	22	-44.3605250848239	-9.07094898367372	2203	'Sudoeste Piauiense'	22010	'Alto Médio Gurguéia'
2201919	"BOM PRINCIPIO DO PIAUI"	22	-41.6452095701255	-3.18985868760539	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2201929	"BONFIM DO PIAUI"	22	-42.8796630650943	-9.16656053927466	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2201945	"BOQUEIRAO DO PIAUI"	22	-42.1036271347473	-4.48581963164374	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2201960	"BRASILEIRA"	22	-41.7892596435709	-4.13782910774516	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2201988	"BREJO DO PIAUI"	22	-42.8303018098246	-8.20706476637205	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2202000	"BURITI DOS LOPES"	22	-41.8699088471231	-3.17272133505459	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2202026	"BURITI DOS MONTES"	22	-41.1018513936703	-5.31206678256848	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2202059	"CABECEIRAS DO PIAUI"	22	-42.3083160653123	-4.4713312938014	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2202075	"CAJAZEIRAS DO PIAUI"	22	-42.3967272946014	-6.79418411754213	2204	'Sudeste Piauiense'	22013	'Picos'
2202083	"CAJUEIRO DA PRAIA"	22	-41.3471503621608	-2.9292271717718	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2202091	"CALDEIRAO GRANDE DO PIAUI"	22	-40.6374189126801	-7.33155965178439	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2202109	"CAMPINAS DO PIAUI"	22	-41.8807452929818	-7.65477812796145	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2202117	"CAMPO ALEGRE DO FIDALGO"	22	-41.832013324158	-8.37448038066491	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2202133	"CAMPO GRANDE DO PIAUI"	22	-41.031200960402	-7.13599312024874	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2202174	"CAMPO LARGO DO PIAUI"	22	-42.6260410416609	-3.8078689391976	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2202208	"CAMPO MAIOR"	22	-42.16674460469	-4.8291139265717	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2202251	"CANAVIEIRA"	22	-43.7194280333653	-7.69462155953116	2203	'Sudoeste Piauiense'	22009	'Floriano'
2202307	"CANTO DO BURITI"	22	-42.9440210219612	-8.10823191972276	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2202406	"CAPITAO DE CAMPOS"	22	-41.9435219724325	-4.45855926839762	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2202455	"CAPITAO GERVASIO OLIVEIRA"	22	-41.8161163123905	-8.49683786838726	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2202505	"CARACOL"	22	-43.3342004507516	-9.27676526720519	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2202539	"CARAUBAS DO PIAUI"	22	-41.8412081259918	-3.47859053753496	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2202554	"CARIDADE DO PIAUI"	22	-40.9903345467585	-7.7286523875636	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2202604	"CASTELO DO PIAUI"	22	-41.5473162426661	-5.32154387089345	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2202653	"CAXINGO"	22	-41.8826837610641	-3.42693840284847	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2202703	"COCAL"	22	-41.5568448345735	-3.47045348969133	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2202711	"COCAL DE TELHA"	22	-41.9790478739642	-4.55381572391613	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2202729	"COCAL DOS ALVES"	22	-41.4554189108305	-3.60607259075426	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2202737	"COIVARAS"	22	-42.207315906284	-5.09130835135404	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2202752	"COLONIA DO GURGUEIA"	22	-43.7960171560657	-8.18757421634094	2203	'Sudoeste Piauiense'	22008	'Bertolínia'
2202778	"COLONIA DO PIAUI"	22	-42.1771185063946	-7.22365756395221	2204	'Sudeste Piauiense'	22013	'Picos'
2202802	"CONCEICAO DO CANINDE"	22	-41.5966339439158	-7.88270415387533	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2202851	"CORONEL JOSE DIAS"	22	-42.4703571012192	-8.81636941148989	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2202901	"CORRENTE"	22	-45.1633125235767	-10.4409360381237	2203	'Sudoeste Piauiense'	22012	'Chapadas do Extremo Sul Piauiense'
2203008	"CRISTALANDIA DO PIAUI"	22	-45.1860307001326	-10.6478037517985	2203	'Sudoeste Piauiense'	22012	'Chapadas do Extremo Sul Piauiense'
2203107	"CRISTINO CASTRO"	22	-44.2244147473452	-8.82018628851015	2203	'Sudoeste Piauiense'	22010	'Alto Médio Gurguéia'
2203206	"CURIMATA"	22	-44.3007222328749	-10.0312924303294	2203	'Sudoeste Piauiense'	22012	'Chapadas do Extremo Sul Piauiense'
2203230	"CURRAIS"	22	-44.4030021530455	-9.01243383893679	2203	'Sudoeste Piauiense'	22010	'Alto Médio Gurguéia'
2203271	"CURRAL NOVO DO PIAUI"	22	-40.9010694707015	-7.83079718839096	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2203255	"CURRALINHOS"	22	-42.8322105193044	-5.62045322935698	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2203305	"DEMERVAL LOBAO"	22	-42.6742286110912	-5.35846546591049	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2203354	"DIRCEU ARCOVERDE"	22	-42.4395699620089	-9.33520004406841	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2203404	"DOM EXPEDITO LOPES"	22	-41.6523852113084	-6.95790184268742	2204	'Sudeste Piauiense'	22013	'Picos'
2203453	"DOM INOCENCIO"	22	-41.9768511187551	-9.00807494342793	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2203420	"DOMINGOS MOURAO"	22	-41.2718814488667	-4.2534336344923	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2203503	"ELESBAO VELOSO"	22	-42.1381444495036	-6.20171946131167	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2203602	"ELISEU MARTINS"	22	-43.6648111316973	-8.09646228958409	2203	'Sudoeste Piauiense'	22008	'Bertolínia'
2203701	"ESPERANTINA"	22	-42.2353645251038	-3.89560453063831	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2203750	"FARTURA DO PIAUI"	22	-42.7944014031782	-9.47860628628754	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2203800	"FLORES DO PIAUI"	22	-42.9243058019859	-7.79177560177302	2203	'Sudoeste Piauiense'	22009	'Floriano'
2203859	"FLORESTA DO PIAUI"	22	-41.800314291439	-7.46679537490687	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2203909	"FLORIANO"	22	-43.0206447383255	-6.76967243378636	2203	'Sudoeste Piauiense'	22009	'Floriano'
2204006	"FRANCINOPOLIS"	22	-42.2633660989624	-6.39529262258713	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2204105	"FRANCISCO AYRES"	22	-42.6911278448088	-6.62334353190539	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2204154	"FRANCISCO MACEDO"	22	-40.7955673541325	-7.32787104055435	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2204204	"FRANCISCO SANTOS"	22	-41.1361573365002	-6.99417113754419	2204	'Sudeste Piauiense'	22014	'Pio IX'
2204303	"FRONTEIRAS"	22	-40.6172329306571	-7.08841253289163	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2204352	"GEMINIANO"	22	-41.3575797604714	-7.15841762588982	2204	'Sudeste Piauiense'	22013	'Picos'
2204402	"GILBUES"	22	-45.3469199782092	-9.83456990551612	2203	'Sudoeste Piauiense'	22010	'Alto Médio Gurguéia'
2204501	"GUADALUPE"	22	-43.5669236545324	-6.78524690867309	2203	'Sudoeste Piauiense'	22009	'Floriano'
2204550	"GUARIBAS"	22	-43.6877210274291	-9.39511130371931	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2204600	"HUGO NAPOLEAO"	22	-42.5625630466248	-5.98778789069953	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2204659	"ILHA GRANDE"	22	-41.8197731840424	-2.85400860719721	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2204709	"INHUMA"	22	-41.7101940564928	-6.66712034067942	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2204808	"IPIRANGA DO PIAUI"	22	-41.7399141279438	-6.82693267828703	2204	'Sudeste Piauiense'	22013	'Picos'
2204907	"ISAIAS COELHO"	22	-41.6794480824978	-7.73431069665783	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2205003	"ITAINOPOLIS"	22	-41.4800253104968	-7.45128081314228	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2205102	"ITAUEIRA"	22	-43.0254965077817	-7.60811663252844	2203	'Sudoeste Piauiense'	22009	'Floriano'
2205151	"JACOBINA DO PIAUI"	22	-41.2107620506702	-7.93626448750448	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2205201	"JAICOS"	22	-41.1464748134968	-7.35315232722134	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2205250	"JARDIM DO MULATO"	22	-42.6339595632103	-6.0965775947567	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2205276	"JATOBA DO PIAUI"	22	-41.8198222185671	-4.77315894428875	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2205300	"JERUMENHA"	22	-43.5027430064021	-7.08463219387257	2203	'Sudoeste Piauiense'	22009	'Floriano'
2205359	"JOAO COSTA"	22	-42.4178485806471	-8.48912572192957	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2205409	"JOAQUIM PIRES"	22	-42.1876898035533	-3.51310354787667	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2205458	"JOCA MARQUES"	22	-42.4277370789814	-3.48803382556586	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2205508	"JOSE DE FREITAS"	22	-42.5783745315457	-4.76305063948266	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2205516	"JUAZEIRO DO PIAUI"	22	-41.7026007596661	-5.16137275429351	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2205524	"JULIO BORGES"	22	-44.2437006323999	-10.326786813699	2203	'Sudoeste Piauiense'	22012	'Chapadas do Extremo Sul Piauiense'
2205532	"JUREMA"	22	-43.1331097430468	-9.22202472045584	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2205557	"LAGOA ALEGRE"	22	-42.6167425390488	-4.50872974922941	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2205573	"LAGOA DE SAO FRANCISCO"	22	-41.6054686902431	-4.39274638665332	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2205565	"LAGOA DO BARRO DO PIAUI"	22	-41.5302754057351	-8.48243711515927	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2205581	"LAGOA DO PIAUI"	22	-42.6490132063022	-5.41214416962348	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2205599	"LAGOA DO SITIO"	22	-41.5823863012861	-6.51534762977601	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2205540	"LAGOINHA DO PIAUI"	22	-42.6273837298549	-5.83658344062351	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2205607	"LANDRI SALES"	22	-43.9310455151444	-7.26659997541352	2203	'Sudoeste Piauiense'	22008	'Bertolínia'
2205706	"LUIS CORREIA"	22	-41.6645672322748	-2.88156653584822	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2205805	"LUZILANDIA"	22	-42.3716375238246	-3.46081763518067	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2205854	"MADEIRO"	22	-42.505141246491	-3.48421200519069	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2205904	"MANOEL EMIDIO"	22	-43.8754746716661	-8.01135867397569	2203	'Sudoeste Piauiense'	22008	'Bertolínia'
2205953	"MARCOLANDIA"	22	-40.6628542913824	-7.44355666136108	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2206001	"MARCOS PARENTE"	22	-43.8883140086213	-7.11929537745121	2203	'Sudoeste Piauiense'	22008	'Bertolínia'
2206050	"MASSAPE DO PIAUI"	22	-41.1238546846189	-7.46548268448323	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2206100	"MATIAS OLIMPIO"	22	-42.5586289027608	-3.71102728343893	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2206209	"MIGUEL ALVES"	22	-42.8931666492627	-4.16821558232068	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2206308	"MIGUEL LEAO"	22	-42.7358295252403	-5.68224178043601	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2206357	"MILTON BRANDAO"	22	-41.4479595412321	-4.69995347755744	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2206407	"MONSENHOR GIL"	22	-42.6173989159071	-5.55148563139472	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2206506	"MONSENHOR HIPOLITO"	22	-41.0328934036477	-7.00350247264632	2204	'Sudeste Piauiense'	22014	'Pio IX'
2206605	"MONTE ALEGRE DO PIAUI"	22	-45.2957402208575	-9.75583366808834	2203	'Sudoeste Piauiense'	22010	'Alto Médio Gurguéia'
2206654	"MORRO CABECA NO TEMPO"	22	-43.9018743653614	-9.71931949215443	2203	'Sudoeste Piauiense'	22012	'Chapadas do Extremo Sul Piauiense'
2206670	"MORRO DO CHAPEU DO PIAUI"	22	-42.3090633949589	-3.74225509621994	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2206696	"MURICI DOS PORTELAS"	22	-42.096769081771	-3.32385978507354	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2206704	"NAZARE DO PIAUI"	22	-42.6682272300917	-6.96712849109696	2203	'Sudoeste Piauiense'	22009	'Floriano'
2206720	"NAZARIA"	22	-42.8140484695768	-5.346925	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2206753	"NOSSA SENHORA DE NAZARE"	22	-42.1793030784653	-4.62693209174171	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2206803	"NOSSA SENHORA DOS REMEDIOS"	22	-42.6239510484895	-3.99122535178459	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2207959	"NOVA SANTA RITA"	22	-42.0482620010711	-8.07496471811903	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2206902	"NOVO ORIENTE DO PIAUI"	22	-41.928722314402	-6.44940513691504	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2206951	"NOVO SANTO ANTONIO"	22	-41.9345074978553	-5.28605764396126	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2207009	"OEIRAS"	22	-42.1314056604251	-7.01641800596289	2204	'Sudeste Piauiense'	22013	'Picos'
2207108	"OLHO D'AGUA DO PIAUI"	22	-42.5785516089696	-5.84715857344544	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2207207	"PADRE MARCOS"	22	-40.9058620823742	-7.35471211551845	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2207306	"PAES LANDIM"	22	-42.2569576294243	-7.77556291450923	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2207355	"PAJEU DO PIAUI"	22	-42.8169360897963	-7.85252009217664	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2207405	"PALMEIRA DO PIAUI"	22	-44.2325685791726	-8.72950111876504	2203	'Sudoeste Piauiense'	22010	'Alto Médio Gurguéia'
2207504	"PALMEIRAIS"	22	-43.0618435228749	-5.97979683607055	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2207553	"PAQUETA"	22	-41.7013852455649	-7.1014662443006	2204	'Sudeste Piauiense'	22013	'Picos'
2207603	"PARNAGUA"	22	-44.6343146131202	-10.217180970543	2203	'Sudoeste Piauiense'	22012	'Chapadas do Extremo Sul Piauiense'
2207702	"PARNAIBA"	22	-41.7781705920245	-2.90336014450892	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2207751	"PASSAGEM FRANCA DO PIAUI"	22	-42.44052674629	-5.85624732031881	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2207777	"PATOS DO PIAUI"	22	-41.2522813962752	-7.68076393508747	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2207793	"PAU D'ARCO DO PIAUI"	22	-42.3888654971449	-5.25109342941114	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2207801	"PAULISTANA"	22	-41.1470964851424	-8.1414361348951	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2207850	"PAVUSSU"	22	-43.2217523026137	-7.96428695477047	2203	'Sudoeste Piauiense'	22009	'Floriano'
2207900	"PEDRO II"	22	-41.4585599330709	-4.42705526541623	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2207934	"PEDRO LAURENTINO"	22	-42.2860736700138	-8.06688259438779	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2208007	"PICOS"	22	-41.468826714668	-7.08137391219936	2204	'Sudeste Piauiense'	22013	'Picos'
2208106	"PIMENTEIRAS"	22	-41.4151586072493	-6.24168840966687	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2208205	"PIO IX"	22	-40.6182727863014	-6.83268730124508	2204	'Sudeste Piauiense'	22014	'Pio IX'
2208304	"PIRACURUCA"	22	-41.7090415496498	-3.9292874935799	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2208403	"PIRIPIRI"	22	-41.7785048523536	-4.27606869325536	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2208502	"PORTO"	22	-42.7109259993477	-3.89142299503453	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2208551	"PORTO ALEGRE DO PIAUI"	22	-44.1948371018939	-6.97172468664628	2203	'Sudoeste Piauiense'	22008	'Bertolínia'
2208601	"PRATA DO PIAUI"	22	-42.2042236753317	-5.6647976938028	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2208650	"QUEIMADA NOVA"	22	-41.4170249221793	-8.5854253469422	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2208700	"REDENCAO DO GURGUEIA"	22	-44.5812141605608	-9.49344824144475	2203	'Sudoeste Piauiense'	22010	'Alto Médio Gurguéia'
2208809	"REGENERACAO"	22	-42.6850242313083	-6.24018302114034	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2208858	"RIACHO FRIO"	22	-44.952530048253	-10.1287276881395	2203	'Sudoeste Piauiense'	22012	'Chapadas do Extremo Sul Piauiense'
2208874	"RIBEIRA DO PIAUI"	22	-42.7140434913463	-7.69057550115737	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2208908	"RIBEIRO GONCALVES"	22	-45.2456386842602	-7.55803424497219	2203	'Sudoeste Piauiense'	22007	'Alto Parnaíba Piauiense'
2209005	"RIO GRANDE DO PIAUI"	22	-43.1401827860102	-7.77085711980515	2203	'Sudoeste Piauiense'	22009	'Floriano'
2209104	"SANTA CRUZ DO PIAUI"	22	-41.7619256890988	-7.17762649610062	2204	'Sudeste Piauiense'	22013	'Picos'
2209153	"SANTA CRUZ DOS MILAGRES"	22	-41.9584459530597	-5.80812099835306	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2209203	"SANTA FILOMENA"	22	-45.9205564410726	-9.10679570533628	2203	'Sudoeste Piauiense'	22007	'Alto Parnaíba Piauiense'
2209302	"SANTA LUZ"	22	-44.1295859062574	-8.94462421689483	2203	'Sudoeste Piauiense'	22010	'Alto Médio Gurguéia'
2209377	"SANTA ROSA DO PIAUI"	22	-42.2808138760659	-6.80145505828923	2204	'Sudeste Piauiense'	22013	'Picos'
2209351	"SANTANA DO PIAUI"	22	-41.5184805579744	-6.94907176392449	2204	'Sudeste Piauiense'	22013	'Picos'
2209401	"SANTO ANTONIO DE LISBOA"	22	-41.2337647421245	-6.98184847697697	2204	'Sudeste Piauiense'	22014	'Pio IX'
2209450	"SANTO ANTONIO DOS MILAGRES"	22	-42.7111968050238	-6.04671759629306	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2209500	"SANTO INACIO DO PIAUI"	22	-41.9182128600204	-7.42233683737326	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2209559	"SAO BRAZ DO PIAUI"	22	-42.9990725170726	-9.06256053587373	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2209609	"SAO FELIX DO PIAUI"	22	-42.1135025901892	-5.93286766298678	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2209658	"SAO FRANCISCO DE ASSIS DO PIAUI"	22	-41.6895971516657	-8.23775474973057	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2209708	"SAO FRANCISCO DO PIAUI"	22	-42.5385319870053	-7.24397610386385	2203	'Sudoeste Piauiense'	22009	'Floriano'
2209757	"SAO GONCALO DO GURGUEIA"	22	-45.301405510563	-10.0299401062335	2203	'Sudoeste Piauiense'	22010	'Alto Médio Gurguéia'
2209807	"SAO GONCALO DO PIAUI"	22	-42.6988309840949	-5.98966743952697	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2209856	"SAO JOAO DA CANABRAVA"	22	-41.3460536519366	-6.81893098950292	2204	'Sudeste Piauiense'	22013	'Picos'
2209872	"SAO JOAO DA FRONTEIRA"	22	-41.256286959289	-3.93859743411526	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2209906	"SAO JOAO DA SERRA"	22	-41.8992637510964	-5.50879753777524	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2209955	"SAO JOAO DA VARJOTA"	22	-41.8637422049467	-6.91901783852341	2204	'Sudeste Piauiense'	22013	'Picos'
2209971	"SAO JOAO DO ARRAIAL"	22	-42.4531261733045	-3.81316887361888	2201	'Norte Piauiense'	22001	'Baixo Parnaíba Piauiense'
2210003	"SAO JOAO DO PIAUI"	22	-42.2564375329406	-8.34884968799341	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2210052	"SAO JOSE DO DIVINO"	22	-41.8301087692171	-3.80571635649951	2201	'Norte Piauiense'	22002	'Litoral Piauiense'
2210102	"SAO JOSE DO PEIXE"	22	-42.5701794157863	-7.49300878090782	2203	'Sudoeste Piauiense'	22009	'Floriano'
2210201	"SAO JOSE DO PIAUI"	22	-41.4794072341782	-6.87062624465213	2204	'Sudeste Piauiense'	22013	'Picos'
2210300	"SAO JULIAO"	22	-40.8369132447998	-7.08531500457718	2204	'Sudeste Piauiense'	22014	'Pio IX'
2210359	"SAO LOURENCO DO PIAUI"	22	-42.5443519903866	-9.17200187707728	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2210375	"SAO LUIS DO PIAUI"	22	-41.3228378191747	-6.82814382976455	2204	'Sudeste Piauiense'	22013	'Picos'
2210383	"SAO MIGUEL DA BAIXA GRANDE"	22	-42.1853773737545	-5.86229863428784	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2210391	"SAO MIGUEL DO FIDALGO"	22	-42.3705290411912	-7.58496911892799	2203	'Sudoeste Piauiense'	22009	'Floriano'
2210409	"SAO MIGUEL DO TAPUIO"	22	-41.319798489524	-5.50066369912748	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2210508	"SAO PEDRO DO PIAUI"	22	-42.7236601720603	-5.91395164656097	2202	'Centro-Norte Piauiense'	22005	'Médio Parnaíba Piauiense'
2210607	"SAO RAIMUNDO NONATO"	22	-42.6922851641908	-9.0153604823547	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2210623	"SEBASTIAO BARROS"	22	-44.8332841775162	-10.8166752206016	2203	'Sudoeste Piauiense'	22012	'Chapadas do Extremo Sul Piauiense'
2210631	"SEBASTIAO LEAL"	22	-44.0676917696104	-7.57738563015195	2203	'Sudoeste Piauiense'	22008	'Bertolínia'
2210656	"SIGEFREDO PACHECO"	22	-41.727559224799	-4.91168916423737	2202	'Centro-Norte Piauiense'	22004	'Campo Maior'
2210706	"SIMOES"	22	-40.8175090683555	-7.59913716568336	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2210805	"SIMPLICIO MENDES"	22	-41.9109103616519	-7.85795729388299	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2210904	"SOCORRO DO PIAUI"	22	-42.5046917237203	-7.86493805710391	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2210938	"SUSSUAPARA"	22	-41.392267730941	-7.01701058882809	2204	'Sudeste Piauiense'	22013	'Picos'
2210953	"TAMBORIL DO PIAUI"	22	-42.909688830207	-8.40043178009231	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2210979	"TANQUE DO PIAUI"	22	-42.2839013404883	-6.59635346741982	2204	'Sudeste Piauiense'	22013	'Picos'
2211001	"TERESINA"	22	-42.8052704582233	-5.0863419523217	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2211100	"UNIAO"	22	-42.8629297159505	-4.58601815914006	2202	'Centro-Norte Piauiense'	22003	'Teresina'
2211209	"URUCUI"	22	-44.5602559238525	-7.22950334456247	2203	'Sudoeste Piauiense'	22007	'Alto Parnaíba Piauiense'
2211308	"VALENCA DO PIAUI"	22	-41.7405359913299	-6.39819602271571	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2211357	"VARZEA BRANCA"	22	-42.9694445350297	-9.23654108934563	2203	'Sudoeste Piauiense'	22011	'São Raimundo Nonato'
2211407	"VARZEA GRANDE"	22	-42.2531016233438	-6.5429475544247	2202	'Centro-Norte Piauiense'	22006	'Valença do Piauí'
2211506	"VERA MENDES"	22	-41.4797367500354	-7.60284928289199	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2211605	"VILA NOVA DO PIAUI"	22	-40.937801396493	-7.14104643395254	2204	'Sudeste Piauiense'	22015	'Alto Médio Canindé'
2211704	"WALL FERRAZ"	22	-41.9089536203039	-7.23577900641265	2204	'Sudeste Piauiense'	22013	'Picos'
4100103	"ABATIA"	41	-50.312526582882	-23.3004940371229	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4100202	"ADRIANOPOLIS"	41	-48.9917545384254	-24.6616897054529	4110	'Metropolitana de Curitiba'	41035	'Cerro Azul'
4100301	"AGUDOS DO SUL"	41	-49.3387018845931	-25.9906180905956	4110	'Metropolitana de Curitiba'	41039	'Rio Negro'
4100400	"ALMIRANTE TAMANDARE"	41	-49.3003198184039	-25.3133776022763	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4100459	"ALTAMIRA DO PARANA"	41	-52.7098074466916	-24.8010001634957	4102	'Centro Ocidental Paranaense'	41004	'Goioerê'
4128625	"ALTO PARAISO"	41	-53.7328931507692	-23.5081307379288	4101	'Noroeste Paranaense'	41002	'Umuarama'
4100608	"ALTO PARANA"	41	-52.3216824440546	-23.1271208306481	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4100707	"ALTO PIQUIRI"	41	-53.4412490788684	-24.0190125564173	4101	'Noroeste Paranaense'	41002	'Umuarama'
4100509	"ALTONIA"	41	-53.8919738559114	-23.8708814057507	4101	'Noroeste Paranaense'	41002	'Umuarama'
4100806	"ALVORADA DO SUL"	41	-51.2292163306355	-22.7803787673948	4103	'Norte Central Paranaense'	41007	'Porecatu'
4100905	"AMAPORA"	41	-52.7867873506458	-23.097370288159	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4101002	"AMPERE"	41	-53.4732567447246	-25.9170684652825	4107	'Sudoeste Paranaense'	41025	'Capanema'
4101051	"ANAHY"	41	-53.1333198286711	-24.6475824586186	4106	'Oeste Paranaense'	41023	'Cascavel'
4101101	"ANDIRA"	41	-50.2264075987152	-23.0517516546542	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4101150	"ANGULO"	41	-51.9173646798432	-23.1929038650252	4103	'Norte Central Paranaense'	41006	'Astorga'
4101200	"ANTONINA"	41	-48.7129000617478	-25.4301661323239	4110	'Metropolitana de Curitiba'	41038	'Paranaguá'
4101309	"ANTONIO OLINTO"	41	-50.1979472440033	-25.9867057800286	4109	'Sudeste Paranaense'	41034	'São Mateus do Sul'
4101408	"APUCARANA"	41	-51.4599851423592	-23.551592985	4103	'Norte Central Paranaense'	41010	'Apucarana'
4101507	"ARAPONGAS"	41	-51.4382797346677	-23.4135165319918	4103	'Norte Central Paranaense'	41010	'Apucarana'
4101606	"ARAPOTI"	41	-49.8248285017272	-24.1465691652057	4105	'Centro Oriental Paranaense'	41020	'Jaguariaíva'
4101655	"ARAPUA"	41	-51.7913175642778	-24.3087023864114	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4101705	"ARARUNA"	41	-52.4996181031374	-23.9282009505813	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4101804	"ARAUCARIA"	41	-49.4019396967087	-25.591645	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4101853	"ARIRANHA DO IVAI"	41	-51.5879178388767	-24.3832887447902	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4101903	"ASSAI"	41	-50.8416234863142	-23.37271790506	4104	'Norte Pioneiro Paranaense'	41014	'Assaí'
4102000	"ASSIS CHATEAUBRIAND"	41	-53.5212369274392	-24.4085300849158	4106	'Oeste Paranaense'	41022	'Toledo'
4102109	"ASTORGA"	41	-51.6696792625367	-23.236711965	4103	'Norte Central Paranaense'	41006	'Astorga'
4102208	"ATALAIA"	41	-52.0557011364669	-23.1515870955391	4103	'Norte Central Paranaense'	41006	'Astorga'
4102307	"BALSA NOVA"	41	-49.6317559904068	-25.5784978074535	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4102406	"BANDEIRANTES"	41	-50.3718730229324	-23.0924805	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4102505	"BARBOSA FERRAZ"	41	-52.0071166854286	-24.0277154652953	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4102703	"BARRA DO JACARE"	41	-50.1877367616339	-23.1205927280976	4104	'Norte Pioneiro Paranaense'	41016	'Jacarezinho'
4102604	"BARRACAO"	41	-53.6350002652568	-26.2526028442091	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4102752	"BELA VISTA DA CAROBA"	41	-53.6660426284896	-25.8794933222508	4107	'Sudoeste Paranaense'	41025	'Capanema'
4102802	"BELA VISTA DO PARAISO"	41	-51.1941450328947	-22.9920875312333	4103	'Norte Central Paranaense'	41007	'Porecatu'
4102901	"BITURUNA"	41	-51.5565252574649	-26.1607944758407	4109	'Sudeste Paranaense'	41033	'União da Vitória'
4103008	"BOA ESPERANCA"	41	-52.7927774592961	-24.2394931592462	4102	'Centro Ocidental Paranaense'	41004	'Goioerê'
4103024	"BOA ESPERANCA DO IGUACU"	41	-53.2171600749416	-25.6358731593967	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4103040	"BOA VENTURA DE SAO ROQUE"	41	-51.5393738370315	-24.8785175861527	4108	'Centro-Sul Paranaense'	41028	'Pitanga'
4103057	"BOA VISTA DA APARECIDA"	41	-53.411736489037	-25.4304049443238	4106	'Oeste Paranaense'	41023	'Cascavel'
4103107	"BOCAIUVA DO SUL"	41	-49.1057874827993	-25.2149015836903	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4103156	"BOM JESUS DO SUL"	41	-53.5995999694702	-26.1928749692651	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4103206	"BOM SUCESSO"	41	-51.7644654446774	-23.70743701803	4103	'Norte Central Paranaense'	41012	'Faxinal'
4103222	"BOM SUCESSO DO SUL"	41	-52.8319762720658	-26.0745371402892	4107	'Sudoeste Paranaense'	41027	'Pato Branco'
4103305	"BORRAZOPOLIS"	41	-51.5844090969291	-23.9378541947059	4103	'Norte Central Paranaense'	41012	'Faxinal'
4103354	"BRAGANEY"	41	-53.1210736649672	-24.8148946326325	4106	'Oeste Paranaense'	41023	'Cascavel'
4103370	"BRASILANDIA DO SUL"	41	-53.5240418135566	-24.1938462811774	4101	'Noroeste Paranaense'	41002	'Umuarama'
4103404	"CAFEARA"	41	-51.7150055085076	-22.788235240971	4103	'Norte Central Paranaense'	41006	'Astorga'
4103453	"CAFELANDIA"	41	-53.3249164784302	-24.6156669761343	4106	'Oeste Paranaense'	41023	'Cascavel'
4103479	"CAFEZAL DO SUL"	41	-53.5110648541672	-23.9047044712396	4101	'Noroeste Paranaense'	41002	'Umuarama'
4103503	"CALIFORNIA"	41	-51.3580855530853	-23.6661438837704	4103	'Norte Central Paranaense'	41010	'Apucarana'
4103602	"CAMBARA"	41	-50.0775707225535	-23.04126648	4104	'Norte Pioneiro Paranaense'	41016	'Jacarezinho'
4103701	"CAMBE"	41	-51.2777284423314	-23.281632	4103	'Norte Central Paranaense'	41011	'Londrina'
4103800	"CAMBIRA"	41	-51.5816306133721	-23.6006118802114	4103	'Norte Central Paranaense'	41010	'Apucarana'
4103909	"CAMPINA DA LAGOA"	41	-52.8135641546009	-24.5949565820335	4102	'Centro Ocidental Paranaense'	41004	'Goioerê'
4103958	"CAMPINA DO SIMAO"	41	-51.8147865320916	-25.1025784698031	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4104006	"CAMPINA GRANDE DO SUL"	41	-49.0534658723572	-25.303247505	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4104055	"CAMPO BONITO"	41	-52.9968696036502	-25.0396344827897	4106	'Oeste Paranaense'	41023	'Cascavel'
4104105	"CAMPO DO TENENTE"	41	-49.6903769402356	-25.9810056577243	4110	'Metropolitana de Curitiba'	41039	'Rio Negro'
4104204	"CAMPO LARGO"	41	-49.5288414503356	-25.4594905	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4104253	"CAMPO MAGRO"	41	-49.4276649679895	-25.3679565	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4104303	"CAMPO MOURAO"	41	-52.3811150855647	-24.0412231967198	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4104402	"CANDIDO DE ABREU"	41	-51.3325805083905	-24.5646691198961	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4104428	"CANDOI"	41	-52.0554464047832	-25.5679318458436	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4104451	"CANTAGALO"	41	-52.1266876349423	-25.3743173860408	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4104501	"CAPANEMA"	41	-53.8001786950115	-25.682977417434	4107	'Sudoeste Paranaense'	41025	'Capanema'
4104600	"CAPITAO LEONIDAS MARQUES"	41	-53.617211010762	-25.4794684845174	4106	'Oeste Paranaense'	41023	'Cascavel'
4104659	"CARAMBEI"	41	-50.1130915115041	-24.950872979957	4105	'Centro Oriental Paranaense'	41021	'Ponta Grossa'
4104709	"CARLOPOLIS"	41	-49.7187235298862	-23.4277239250352	4104	'Norte Pioneiro Paranaense'	41018	'Wenceslau Braz'
4104808	"CASCAVEL"	41	-53.4597221819857	-24.9537975	4106	'Oeste Paranaense'	41023	'Cascavel'
4104907	"CASTRO"	41	-50.0028111277611	-24.7954175	4105	'Centro Oriental Paranaense'	41021	'Ponta Grossa'
4105003	"CATANDUVAS"	41	-53.1537063668496	-25.1964932494608	4106	'Oeste Paranaense'	41023	'Cascavel'
4105102	"CENTENARIO DO SUL"	41	-51.5935295600151	-22.8149823509494	4103	'Norte Central Paranaense'	41006	'Astorga'
4105201	"CERRO AZUL"	41	-49.2603168259064	-24.8189473027859	4110	'Metropolitana de Curitiba'	41035	'Cerro Azul'
4105300	"CEU AZUL"	41	-53.8572693830674	-25.1497612093124	4106	'Oeste Paranaense'	41024	'Foz do Iguaçu'
4105409	"CHOPINZINHO"	41	-52.5339602074992	-25.8546838487659	4107	'Sudoeste Paranaense'	41027	'Pato Branco'
4105508	"CIANORTE"	41	-52.6091508905561	-23.6538131528275	4101	'Noroeste Paranaense'	41003	'Cianorte'
4105607	"CIDADE GAUCHA"	41	-52.940525149061	-23.3741973865545	4101	'Noroeste Paranaense'	41003	'Cianorte'
4105706	"CLEVELANDIA"	41	-52.352986201218	-26.4052052933615	4108	'Centro-Sul Paranaense'	41030	'Palmas'
4105805	"COLOMBO"	41	-49.2274379772727	-25.294340294536	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4105904	"COLORADO"	41	-51.9744162121383	-22.83789753	4103	'Norte Central Paranaense'	41006	'Astorga'
4106001	"CONGONHINHAS"	41	-50.5544280470447	-23.5469021022166	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4106100	"CONSELHEIRO MAIRINCK"	41	-50.1717730024103	-23.6215617142487	4104	'Norte Pioneiro Paranaense'	41017	'Ibaiti'
4106209	"CONTENDA"	41	-49.5316118696956	-25.68076630959	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4106308	"CORBELIA"	41	-53.2965277769968	-24.7996495159732	4106	'Oeste Paranaense'	41023	'Cascavel'
4106407	"CORNELIO PROCOPIO"	41	-50.6514844783365	-23.1832575	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4106456	"CORONEL DOMINGOS SOARES"	41	-52.0345386761735	-26.2265477684456	4108	'Centro-Sul Paranaense'	41030	'Palmas'
4106506	"CORONEL VIVIDA"	41	-52.567086635376	-25.9781534980571	4107	'Sudoeste Paranaense'	41027	'Pato Branco'
4106555	"CORUMBATAI DO SUL"	41	-52.1241853003798	-24.097412385249	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4106803	"CRUZ MACHADO"	41	-51.3477095246118	-26.0172688782083	4109	'Sudeste Paranaense'	41033	'União da Vitória'
4106571	"CRUZEIRO DO IGUACU"	41	-53.1268226637842	-25.6165692702865	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4106605	"CRUZEIRO DO OESTE"	41	-53.0818216076221	-23.7769048606571	4101	'Noroeste Paranaense'	41002	'Umuarama'
4106704	"CRUZEIRO DO SUL"	41	-52.163977669531	-22.9651754195403	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4106852	"CRUZMALTINA"	41	-51.4442466489686	-23.9933276018928	4103	'Norte Central Paranaense'	41012	'Faxinal'
4106902	"CURITIBA"	41	-49.2718478850774	-25.432956	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4107009	"CURIUVA"	41	-50.4594055244877	-24.0358255892877	4104	'Norte Pioneiro Paranaense'	41017	'Ibaiti'
4107108	"DIAMANTE DO NORTE"	41	-52.8641112387079	-22.6572061502022	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4107124	"DIAMANTE DO SUL"	41	-52.6881907613318	-25.0351919283102	4106	'Oeste Paranaense'	41023	'Cascavel'
4107157	"DIAMANTE D'OESTE"	41	-54.1036264276883	-24.9421618556159	4106	'Oeste Paranaense'	41022	'Toledo'
4107207	"DOIS VIZINHOS"	41	-53.0548359924349	-25.74601002	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4107256	"DOURADINA"	41	-53.2964486552294	-23.3819072161657	4101	'Noroeste Paranaense'	41002	'Umuarama'
4107306	"DOUTOR CAMARGO"	41	-52.2227214970694	-23.5559013269844	4103	'Norte Central Paranaense'	41008	'Floraí'
4128633	"DOUTOR ULYSSES"	41	-49.4197717989297	-24.5678364522416	4110	'Metropolitana de Curitiba'	41035	'Cerro Azul'
4107405	"ENEAS MARQUES"	41	-53.166185268213	-25.9407559827093	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4107504	"ENGENHEIRO BELTRAO"	41	-52.2600351547591	-23.80114407037	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4107538	"ENTRE RIOS DO OESTE"	41	-54.2448936714884	-24.7081421701975	4106	'Oeste Paranaense'	41022	'Toledo'
4107520	"ESPERANCA NOVA"	41	-53.8104950389931	-23.7246547648773	4101	'Noroeste Paranaense'	41002	'Umuarama'
4107546	"ESPIGAO ALTO DO IGUACU"	41	-52.8382134986902	-25.4266700616993	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4107553	"FAROL"	41	-52.6262151802103	-24.0990946186794	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4107603	"FAXINAL"	41	-51.3201059317839	-24.0039270722271	4103	'Norte Central Paranaense'	41012	'Faxinal'
4107652	"FAZENDA RIO GRANDE"	41	-49.3232931947119	-25.6414002186938	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4107702	"FENIX"	41	-51.9844644869602	-23.9206947065803	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4107736	"FERNANDES PINHEIRO"	41	-50.547414254411	-25.4122422979542	4109	'Sudeste Paranaense'	41031	'Prudentópolis'
4107751	"FIGUEIRA"	41	-50.4092010911711	-23.8434107619382	4104	'Norte Pioneiro Paranaense'	41017	'Ibaiti'
4107850	"FLOR DA SERRA DO SUL"	41	-53.3085976818885	-26.2552988459276	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4107801	"FLORAI"	41	-52.3029843729815	-23.3198456635855	4103	'Norte Central Paranaense'	41008	'Floraí'
4107900	"FLORESTA"	41	-52.0830848515253	-23.6102671394592	4103	'Norte Central Paranaense'	41008	'Floraí'
4108007	"FLORESTOPOLIS"	41	-51.3838226518282	-22.8591043044292	4103	'Norte Central Paranaense'	41007	'Porecatu'
4108106	"FLORIDA"	41	-51.9558280909722	-23.0878019097437	4103	'Norte Central Paranaense'	41006	'Astorga'
4108205	"FORMOSA DO OESTE"	41	-53.3161610107395	-24.2941972137273	4106	'Oeste Paranaense'	41022	'Toledo'
4108304	"FOZ DO IGUACU"	41	-54.5871024886046	-25.5424932795293	4106	'Oeste Paranaense'	41024	'Foz do Iguaçu'
4108452	"FOZ DO JORDAO"	41	-52.1256275318311	-25.7334396202596	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4108320	"FRANCISCO ALVES"	41	-53.8440159671513	-24.0675754043871	4101	'Noroeste Paranaense'	41002	'Umuarama'
4108403	"FRANCISCO BELTRAO"	41	-53.0561357214894	-26.07845	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4108502	"GENERAL CARNEIRO"	41	-51.3168589232395	-26.4258025265901	4109	'Sudeste Paranaense'	41033	'União da Vitória'
4108551	"GODOY MOREIRA"	41	-51.9243682163217	-24.1928594485963	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4108601	"GOIOERE"	41	-53.0273189133007	-24.1891883938618	4102	'Centro Ocidental Paranaense'	41004	'Goioerê'
4108650	"GOIOXIM"	41	-52.0055879661652	-25.2015403111031	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4108700	"GRANDES RIOS"	41	-51.5087423991262	-24.1461940122141	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4108809	"GUAIRA"	41	-54.2467577203893	-24.08527548	4106	'Oeste Paranaense'	41022	'Toledo'
4108908	"GUAIRACA"	41	-52.6910396163512	-22.9382439477033	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4108957	"GUAMIRANGA"	41	-50.8098759006677	-25.1899094536303	4109	'Sudeste Paranaense'	41031	'Prudentópolis'
4109005	"GUAPIRAMA"	41	-50.0426137439964	-23.5166402424419	4104	'Norte Pioneiro Paranaense'	41018	'Wenceslau Braz'
4109104	"GUAPOREMA"	41	-52.778243782884	-23.3429843451037	4101	'Noroeste Paranaense'	41003	'Cianorte'
4109203	"GUARACI"	41	-51.6503853708561	-22.9744292672903	4103	'Norte Central Paranaense'	41006	'Astorga'
4109302	"GUARANIACU"	41	-52.8696324396125	-25.0986499165701	4106	'Oeste Paranaense'	41023	'Cascavel'
4109401	"GUARAPUAVA"	41	-51.4634310776746	-25.39359198	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4109500	"GUARAQUECABA"	41	-48.3260489326164	-25.3004374743932	4110	'Metropolitana de Curitiba'	41038	'Paranaguá'
4109609	"GUARATUBA"	41	-48.5757259604424	-25.874241975	4110	'Metropolitana de Curitiba'	41038	'Paranaguá'
4109658	"HONORIO SERPA"	41	-52.3830290561902	-26.1429662070044	4108	'Centro-Sul Paranaense'	41030	'Palmas'
4109708	"IBAITI"	41	-50.1906662735549	-23.849821485	4104	'Norte Pioneiro Paranaense'	41017	'Ibaiti'
4109757	"IBEMA"	41	-53.0231216933671	-25.1128670711596	4106	'Oeste Paranaense'	41023	'Cascavel'
4109807	"IBIPORA"	41	-51.0580336739701	-23.269331475	4103	'Norte Central Paranaense'	41011	'Londrina'
4109906	"ICARAIMA"	41	-53.6255701622959	-23.3967114280053	4101	'Noroeste Paranaense'	41002	'Umuarama'
4110003	"IGUARACU"	41	-51.8247742046263	-23.1947806086686	4103	'Norte Central Paranaense'	41006	'Astorga'
4110052	"IGUATU"	41	-53.0860050753783	-24.7112618444418	4106	'Oeste Paranaense'	41023	'Cascavel'
4110078	"IMBAU"	41	-50.7493089935498	-24.4427970837244	4105	'Centro Oriental Paranaense'	41019	'Telêmaco Borba'
4110102	"IMBITUVA"	41	-50.5974729665313	-25.2306130382221	4109	'Sudeste Paranaense'	41031	'Prudentópolis'
4110201	"INACIO MARTINS"	41	-51.0749452987122	-25.5721626869871	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4110300	"INAJA"	41	-52.2023437503346	-22.7491161251096	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4110409	"INDIANOPOLIS"	41	-52.7010569081576	-23.4797105011699	4101	'Noroeste Paranaense'	41003	'Cianorte'
4110508	"IPIRANGA"	41	-50.5812401343906	-25.0130228282322	4109	'Sudeste Paranaense'	41031	'Prudentópolis'
4110607	"IPORA"	41	-53.7180991714403	-24.002580498538	4101	'Noroeste Paranaense'	41002	'Umuarama'
4110656	"IRACEMA DO OESTE"	41	-53.358110555243	-24.4290304152957	4106	'Oeste Paranaense'	41022	'Toledo'
4110706	"IRATI"	41	-50.6580481227738	-25.4737362989273	4109	'Sudeste Paranaense'	41032	'Irati'
4110805	"IRETAMA"	41	-52.101576622284	-24.4211415593772	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4110904	"ITAGUAJE"	41	-51.9693404488617	-22.614782675702	4103	'Norte Central Paranaense'	41006	'Astorga'
4110953	"ITAIPULANDIA"	41	-54.3050007423361	-25.1384806509619	4106	'Oeste Paranaense'	41024	'Foz do Iguaçu'
4111001	"ITAMBARACA"	41	-50.4090904668323	-23.0147685088751	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4111100	"ITAMBE"	41	-51.9900043142568	-23.6600985811132	4103	'Norte Central Paranaense'	41008	'Floraí'
4111209	"ITAPEJARA D'OESTE"	41	-52.8139296045112	-25.970878051643	4107	'Sudoeste Paranaense'	41027	'Pato Branco'
4111258	"ITAPERUCU"	41	-49.3428643436738	-25.214469525	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4111308	"ITAUNA DO SUL"	41	-52.8850248105017	-22.7268769277415	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4111407	"IVAI"	41	-50.8614257041266	-25.008262582518	4109	'Sudeste Paranaense'	41031	'Prudentópolis'
4111506	"IVAIPORA"	41	-51.6745520468117	-24.24194802	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4111555	"IVATE"	41	-53.3738794057888	-23.4095888739513	4101	'Noroeste Paranaense'	41002	'Umuarama'
4111605	"IVATUBA"	41	-52.2176692790419	-23.6182744112522	4103	'Norte Central Paranaense'	41008	'Floraí'
4111704	"JABOTI"	41	-50.0734525498615	-23.7357406011678	4104	'Norte Pioneiro Paranaense'	41017	'Ibaiti'
4111803	"JACAREZINHO"	41	-49.9785725343256	-23.160116475	4104	'Norte Pioneiro Paranaense'	41016	'Jacarezinho'
4111902	"JAGUAPITA"	41	-51.5406168453571	-23.1177827565859	4103	'Norte Central Paranaense'	41006	'Astorga'
4112009	"JAGUARIAIVA"	41	-49.7121863019608	-24.2530565	4105	'Centro Oriental Paranaense'	41020	'Jaguariaíva'
4112108	"JANDAIA DO SUL"	41	-51.6433953621984	-23.6011789160911	4103	'Norte Central Paranaense'	41010	'Apucarana'
4112207	"JANIOPOLIS"	41	-52.782551780046	-24.1414499417911	4102	'Centro Ocidental Paranaense'	41004	'Goioerê'
4112306	"JAPIRA"	41	-50.1385951194178	-23.8074805268044	4104	'Norte Pioneiro Paranaense'	41017	'Ibaiti'
4112405	"JAPURA"	41	-52.5566276715464	-23.4685877725578	4101	'Noroeste Paranaense'	41003	'Cianorte'
4112504	"JARDIM ALEGRE"	41	-51.6943350083947	-24.1811374455632	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4112603	"JARDIM OLINDA"	41	-52.0381409640908	-22.5526316001824	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4112702	"JATAIZINHO"	41	-50.9740548451338	-23.2572651215149	4104	'Norte Pioneiro Paranaense'	41014	'Assaí'
4112751	"JESUITAS"	41	-53.3881148800191	-24.3772489097272	4106	'Oeste Paranaense'	41022	'Toledo'
4112801	"JOAQUIM TAVORA"	41	-49.9244568128405	-23.5004885244257	4104	'Norte Pioneiro Paranaense'	41018	'Wenceslau Braz'
4112900	"JUNDIAI DO SUL"	41	-50.2493535652284	-23.437909451052	4104	'Norte Pioneiro Paranaense'	41016	'Jacarezinho'
4112959	"JURANDA"	41	-52.8444864982627	-24.4163906494412	4102	'Centro Ocidental Paranaense'	41004	'Goioerê'
4113007	"JUSSARA"	41	-52.4730408047112	-23.6163267087865	4101	'Noroeste Paranaense'	41003	'Cianorte'
4113106	"KALORE"	41	-51.6651419267049	-23.8234388793882	4103	'Norte Central Paranaense'	41012	'Faxinal'
4113205	"LAPA"	41	-49.7185958084251	-25.765102485	4110	'Metropolitana de Curitiba'	41036	'Lapa'
4113254	"LARANJAL"	41	-52.4716661790835	-24.8883015839692	4108	'Centro-Sul Paranaense'	41028	'Pitanga'
4113304	"LARANJEIRAS DO SUL"	41	-52.4088474232637	-25.4016815101669	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4113403	"LEOPOLIS"	41	-50.755124972908	-23.0799224936918	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4113429	"LIDIANOPOLIS"	41	-51.6541506163069	-24.1067664133174	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4113452	"LINDOESTE"	41	-53.5771259362793	-25.2559851259617	4106	'Oeste Paranaense'	41023	'Cascavel'
4113502	"LOANDA"	41	-53.1344689597801	-22.9302286218534	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4113601	"LOBATO"	41	-51.9537492142271	-23.0041580768891	4103	'Norte Central Paranaense'	41006	'Astorga'
4113700	"LONDRINA"	41	-51.1627734238781	-23.312156	4103	'Norte Central Paranaense'	41011	'Londrina'
4113734	"LUIZIANA"	41	-52.2819056183387	-24.2800814126702	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4113759	"LUNARDELLI"	41	-51.7445483867649	-24.078046360677	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4113809	"LUPIONOPOLIS"	41	-51.65687284024	-22.7519945229726	4103	'Norte Central Paranaense'	41006	'Astorga'
4113908	"MALLET"	41	-50.8275686221384	-25.8737880845276	4109	'Sudeste Paranaense'	41032	'Irati'
4114005	"MAMBORE"	41	-52.5290941575477	-24.3218130807396	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4114104	"MANDAGUACU"	41	-52.0942530606026	-23.3427891418224	4103	'Norte Central Paranaense'	41006	'Astorga'
4114203	"MANDAGUARI"	41	-51.6812520884286	-23.517452	4103	'Norte Central Paranaense'	41009	'Maringá'
4114302	"MANDIRITUBA"	41	-49.3227825970264	-25.7596206130936	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4114351	"MANFRINOPOLIS"	41	-53.3125829630542	-26.1437768725464	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4114401	"MANGUEIRINHA"	41	-52.1763258293897	-25.942981341552	4108	'Centro-Sul Paranaense'	41030	'Palmas'
4114500	"MANOEL RIBAS"	41	-51.6690785950707	-24.5217308774068	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4114609	"MARECHAL CANDIDO RONDON"	41	-54.0600078164531	-24.559254495	4106	'Oeste Paranaense'	41022	'Toledo'
4114708	"MARIA HELENA"	41	-53.2048192711896	-23.6176096561206	4101	'Noroeste Paranaense'	41002	'Umuarama'
4114807	"MARIALVA"	41	-51.7980569139104	-23.484758535	4103	'Norte Central Paranaense'	41009	'Maringá'
4114906	"MARILANDIA DO SUL"	41	-51.3092905257137	-23.7457790925403	4103	'Norte Central Paranaense'	41010	'Apucarana'
4115002	"MARILENA"	41	-53.0371858842334	-22.7318252451306	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4115101	"MARILUZ"	41	-53.1515258188949	-24.0037326297737	4101	'Noroeste Paranaense'	41002	'Umuarama'
4115200	"MARINGA"	41	-51.9398818702521	-23.42228	4103	'Norte Central Paranaense'	41009	'Maringá'
4115309	"MARIOPOLIS"	41	-52.5577480020641	-26.3558427427168	4107	'Sudoeste Paranaense'	41027	'Pato Branco'
4115358	"MARIPA"	41	-53.8334777829878	-24.4172088392526	4106	'Oeste Paranaense'	41022	'Toledo'
4115408	"MARMELEIRO"	41	-53.0261839782571	-26.1486971929932	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4115457	"MARQUINHO"	41	-52.2569829527735	-25.1122123613302	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4115507	"MARUMBI"	41	-51.6410803664656	-23.7063690370968	4103	'Norte Central Paranaense'	41012	'Faxinal'
4115606	"MATELANDIA"	41	-53.9743873416592	-25.2379210128539	4106	'Oeste Paranaense'	41024	'Foz do Iguaçu'
4115705	"MATINHOS"	41	-48.5337711877653	-25.8164097029052	4110	'Metropolitana de Curitiba'	41038	'Paranaguá'
4115739	"MATO RICO"	41	-52.146258579849	-24.7073171878821	4108	'Centro-Sul Paranaense'	41028	'Pitanga'
4115754	"MAUA DA SERRA"	41	-51.2264634713856	-23.9012964431155	4103	'Norte Central Paranaense'	41010	'Apucarana'
4115804	"MEDIANEIRA"	41	-54.0917821269222	-25.2924975	4106	'Oeste Paranaense'	41024	'Foz do Iguaçu'
4115853	"MERCEDES"	41	-54.1644357171677	-24.4488897646012	4106	'Oeste Paranaense'	41022	'Toledo'
4115903	"MIRADOR"	41	-52.7769349283224	-23.2574075418387	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4116000	"MIRASELVA"	41	-51.4857072490769	-22.9660925761244	4103	'Norte Central Paranaense'	41007	'Porecatu'
4116059	"MISSAL"	41	-54.2431753258264	-25.0911596680568	4106	'Oeste Paranaense'	41024	'Foz do Iguaçu'
4116109	"MOREIRA SALES"	41	-53.0134465696634	-24.0447582369354	4102	'Centro Ocidental Paranaense'	41004	'Goioerê'
4116208	"MORRETES"	41	-48.8315391962639	-25.4784816833829	4110	'Metropolitana de Curitiba'	41038	'Paranaguá'
4116307	"MUNHOZ DE MELO"	41	-51.775757907573	-23.145692803078	4103	'Norte Central Paranaense'	41006	'Astorga'
4116406	"NOSSA SENHORA DAS GRACAS"	41	-51.7951475240122	-22.9105625092978	4103	'Norte Central Paranaense'	41006	'Astorga'
4116505	"NOVA ALIANCA DO IVAI"	41	-52.6019227273391	-23.1774555298389	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4116604	"NOVA AMERICA DA COLINA"	41	-50.7144428465776	-23.3326866674542	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4116703	"NOVA AURORA"	41	-53.2575255396178	-24.5284853289959	4106	'Oeste Paranaense'	41023	'Cascavel'
4116802	"NOVA CANTU"	41	-52.570992160533	-24.6707788449965	4102	'Centro Ocidental Paranaense'	41004	'Goioerê'
4116901	"NOVA ESPERANCA"	41	-52.2048663633507	-23.1842513921502	4103	'Norte Central Paranaense'	41006	'Astorga'
4116950	"NOVA ESPERANCA DO SUDOESTE"	41	-53.2642073185992	-25.8987792083354	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4117008	"NOVA FATIMA"	41	-50.5623142175567	-23.4323585708965	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4117057	"NOVA LARANJEIRAS"	41	-52.5393704514689	-25.3067459165584	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4117107	"NOVA LONDRINA"	41	-52.9863126298766	-22.7638686048357	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4117206	"NOVA OLIMPIA"	41	-53.0912329510219	-23.4711009791015	4101	'Noroeste Paranaense'	41002	'Umuarama'
4117255	"NOVA PRATA DO IGUACU"	41	-53.3479572462114	-25.631877090964	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4117214	"NOVA SANTA BARBARA"	41	-50.7641471219669	-23.5854238548731	4104	'Norte Pioneiro Paranaense'	41014	'Assaí'
4117222	"NOVA SANTA ROSA"	41	-53.955116084308	-24.4647645333136	4106	'Oeste Paranaense'	41022	'Toledo'
4117271	"NOVA TEBAS"	41	-51.9503961103527	-24.4383252111535	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4117297	"NOVO ITACOLOMI"	41	-51.5069594279647	-23.7653137692885	4103	'Norte Central Paranaense'	41010	'Apucarana'
4117305	"ORTIGUEIRA"	41	-50.9269295381431	-24.2120106688963	4105	'Centro Oriental Paranaense'	41019	'Telêmaco Borba'
4117404	"OURIZONA"	41	-52.1950387276658	-23.4045682216049	4103	'Norte Central Paranaense'	41008	'Floraí'
4117453	"OURO VERDE DO OESTE"	41	-53.8995380841541	-24.7707942898476	4106	'Oeste Paranaense'	41022	'Toledo'
4117503	"PAICANDU"	41	-52.0524118315665	-23.4576987574943	4103	'Norte Central Paranaense'	41009	'Maringá'
4117602	"PALMAS"	41	-51.9887738877128	-26.481472515	4108	'Centro-Sul Paranaense'	41030	'Palmas'
4117701	"PALMEIRA"	41	-50.0032468209789	-25.4185679014664	4105	'Centro Oriental Paranaense'	41021	'Ponta Grossa'
4117800	"PALMITAL"	41	-52.2129972267238	-24.8822436773402	4108	'Centro-Sul Paranaense'	41028	'Pitanga'
4117909	"PALOTINA"	41	-53.838771723893	-24.279409485	4106	'Oeste Paranaense'	41022	'Toledo'
4118006	"PARAISO DO NORTE"	41	-52.6035431383628	-23.2871611665114	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4118105	"PARANACITY"	41	-52.155988728928	-22.9268100520746	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4118204	"PARANAGUA"	41	-48.5247328366567	-25.5068415	4110	'Metropolitana de Curitiba'	41038	'Paranaguá'
4118303	"PARANAPOEMA"	41	-52.0807237217792	-22.6556215750358	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4118402	"PARANAVAI"	41	-52.462401669956	-23.081879475	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4118451	"PATO BRAGADO"	41	-54.231395741042	-24.6256440144925	4106	'Oeste Paranaense'	41022	'Toledo'
4118501	"PATO BRANCO"	41	-52.6773619976723	-26.229958515	4107	'Sudoeste Paranaense'	41027	'Pato Branco'
4118600	"PAULA FREITAS"	41	-50.9347363362549	-26.2201021596604	4109	'Sudeste Paranaense'	41033	'União da Vitória'
4118709	"PAULO FRONTIN"	41	-50.8331964537166	-26.0456075777101	4109	'Sudeste Paranaense'	41033	'União da Vitória'
4118808	"PEABIRU"	41	-52.3478961545674	-23.9141264298477	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4118857	"PEROBAL"	41	-53.4115002037974	-23.8945617452713	4101	'Noroeste Paranaense'	41002	'Umuarama'
4118907	"PEROLA"	41	-53.6732521304902	-23.7974787686894	4101	'Noroeste Paranaense'	41002	'Umuarama'
4119004	"PEROLA D'OESTE"	41	-53.740108472608	-25.828265676702	4107	'Sudoeste Paranaense'	41025	'Capanema'
4119103	"PIEN"	41	-49.4282437421995	-26.0969563765535	4110	'Metropolitana de Curitiba'	41039	'Rio Negro'
4119152	"PINHAIS"	41	-49.1991974196099	-25.4421978879055	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4119251	"PINHAL DE SAO BENTO"	41	-53.483090442217	-26.0327285546862	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4119202	"PINHALAO"	41	-50.0626030635253	-23.7873547288699	4104	'Norte Pioneiro Paranaense'	41017	'Ibaiti'
4119301	"PINHAO"	41	-51.6482701915018	-25.69629501	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4119400	"PIRAI DO SUL"	41	-49.9413309935834	-24.5323575	4105	'Centro Oriental Paranaense'	41020	'Jaguariaíva'
4119509	"PIRAQUARA"	41	-49.0653056139231	-25.4465503564542	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4119608	"PITANGA"	41	-51.7631540083928	-24.7527477534144	4108	'Centro-Sul Paranaense'	41028	'Pitanga'
4119657	"PITANGUEIRAS"	41	-51.5857680569437	-23.2303038463547	4103	'Norte Central Paranaense'	41011	'Londrina'
4119707	"PLANALTINA DO PARANA"	41	-52.9178407026414	-23.0188101882836	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4119806	"PLANALTO"	41	-53.770857430338	-25.7121014977616	4107	'Sudoeste Paranaense'	41025	'Capanema'
4119905	"PONTA GROSSA"	41	-50.1614420592942	-25.092547	4105	'Centro Oriental Paranaense'	41021	'Ponta Grossa'
4119954	"PONTAL DO PARANA"	41	-48.4483270301901	-25.5941510148777	4110	'Metropolitana de Curitiba'	41038	'Paranaguá'
4120002	"PORECATU"	41	-51.3775989927537	-22.7562094968322	4103	'Norte Central Paranaense'	41007	'Porecatu'
4120101	"PORTO AMAZONAS"	41	-49.8897208650407	-25.5415727120726	4110	'Metropolitana de Curitiba'	41036	'Lapa'
4120150	"PORTO BARREIRO"	41	-52.4047867627126	-25.545185638387	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4120200	"PORTO RICO"	41	-53.2679681115051	-22.7783515586479	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4120309	"PORTO VITORIA"	41	-51.2366947363773	-26.1634752041939	4109	'Sudeste Paranaense'	41033	'União da Vitória'
4120333	"PRADO FERREIRA"	41	-51.4432261434374	-23.0339140302723	4103	'Norte Central Paranaense'	41007	'Porecatu'
4120358	"PRANCHITA"	41	-53.742622639593	-26.0156642887295	4107	'Sudoeste Paranaense'	41025	'Capanema'
4120408	"PRESIDENTE CASTELO BRANCO"	41	-52.157726252669	-23.2815496047308	4103	'Norte Central Paranaense'	41006	'Astorga'
4120507	"PRIMEIRO DE MAIO"	41	-51.0277519969787	-22.8525332550873	4103	'Norte Central Paranaense'	41007	'Porecatu'
4120606	"PRUDENTOPOLIS"	41	-50.983575090629	-25.2160205	4109	'Sudeste Paranaense'	41031	'Prudentópolis'
4120655	"QUARTO CENTENARIO"	41	-53.0752885848612	-24.2790209177585	4102	'Centro Ocidental Paranaense'	41004	'Goioerê'
4120705	"QUATIGUA"	41	-49.9152641614705	-23.5641609208327	4104	'Norte Pioneiro Paranaense'	41018	'Wenceslau Braz'
4120804	"QUATRO BARRAS"	41	-49.0851888348275	-25.3737448472333	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4120853	"QUATRO PONTES"	41	-53.9726991274637	-24.5732085847918	4106	'Oeste Paranaense'	41022	'Toledo'
4120903	"QUEDAS DO IGUACU"	41	-52.9098324023128	-25.4567808508294	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4121000	"QUERENCIA DO NORTE"	41	-53.4870407060353	-23.0865285793462	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4121109	"QUINTA DO SOL"	41	-52.1351287636401	-23.8438884262315	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4121208	"QUITANDINHA"	41	-49.4966829869198	-25.8683083492793	4110	'Metropolitana de Curitiba'	41039	'Rio Negro'
4121257	"RAMILANDIA"	41	-54.0272370317877	-25.1189865236099	4106	'Oeste Paranaense'	41024	'Foz do Iguaçu'
4121307	"RANCHO ALEGRE"	41	-50.9163921629724	-23.0757149210335	4104	'Norte Pioneiro Paranaense'	41014	'Assaí'
4121356	"RANCHO ALEGRE D'OESTE"	41	-52.9511258398345	-24.3090100123643	4102	'Centro Ocidental Paranaense'	41004	'Goioerê'
4121406	"REALEZA"	41	-53.532574359025	-25.762579950614	4107	'Sudoeste Paranaense'	41025	'Capanema'
4121505	"REBOUCAS"	41	-50.6812544333183	-25.6263927557656	4109	'Sudeste Paranaense'	41032	'Irati'
4121604	"RENASCENCA"	41	-52.9721620116988	-26.1562209295429	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4121703	"RESERVA"	41	-50.8505958054306	-24.651648	4105	'Centro Oriental Paranaense'	41019	'Telêmaco Borba'
4121752	"RESERVA DO IGUACU"	41	-52.0287624631417	-25.8309580360474	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4121802	"RIBEIRAO CLARO"	41	-49.7563505190838	-23.1962854621858	4104	'Norte Pioneiro Paranaense'	41016	'Jacarezinho'
4121901	"RIBEIRAO DO PINHAL"	41	-50.3580609524608	-23.4082575022835	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4122008	"RIO AZUL"	41	-50.7871729819706	-25.7161131774978	4109	'Sudeste Paranaense'	41032	'Irati'
4122107	"RIO BOM"	41	-51.4153647878351	-23.7620982802826	4103	'Norte Central Paranaense'	41012	'Faxinal'
4122156	"RIO BONITO DO IGUACU"	41	-52.5268897829594	-25.4869088092077	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4122172	"RIO BRANCO DO IVAI"	41	-51.3120655882648	-24.3202776012942	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4122206	"RIO BRANCO DO SUL"	41	-49.3167138827683	-25.1901653515541	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4122305	"RIO NEGRO"	41	-49.7976853768382	-26.10040797	4110	'Metropolitana de Curitiba'	41039	'Rio Negro'
4122404	"ROLANDIA"	41	-51.3627803563626	-23.313592485	4103	'Norte Central Paranaense'	41011	'Londrina'
4122503	"RONCADOR"	41	-52.2760525503737	-24.5951071879967	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4122602	"RONDON"	41	-52.7624923118905	-23.4126599793783	4101	'Noroeste Paranaense'	41003	'Cianorte'
4122651	"ROSARIO DO IVAI"	41	-51.2499448251477	-24.2535525559056	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4122701	"SABAUDIA"	41	-51.5567020218746	-23.3183956216474	4103	'Norte Central Paranaense'	41010	'Apucarana'
4122800	"SALGADO FILHO"	41	-53.3621154225924	-26.170460518652	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4122909	"SALTO DO ITARARE"	41	-49.630750093362	-23.6057567382241	4104	'Norte Pioneiro Paranaense'	41018	'Wenceslau Braz'
4123006	"SALTO DO LONTRA"	41	-53.314935101821	-25.7767652429306	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4123105	"SANTA AMELIA"	41	-50.4234587703804	-23.2681573189206	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4123204	"SANTA CECILIA DO PAVAO"	41	-50.7828651430903	-23.5128957120937	4104	'Norte Pioneiro Paranaense'	41014	'Assaí'
4123303	"SANTA CRUZ DE MONTE CASTELO"	41	-53.2973064204957	-22.9585816078019	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4123402	"SANTA FE"	41	-51.8063020531831	-23.0361147581787	4103	'Norte Central Paranaense'	41006	'Astorga'
4123501	"SANTA HELENA"	41	-54.3364531522835	-24.8570958306367	4106	'Oeste Paranaense'	41022	'Toledo'
4123600	"SANTA INES"	41	-51.902768382784	-22.6387065306372	4103	'Norte Central Paranaense'	41006	'Astorga'
4123709	"SANTA ISABEL DO IVAI"	41	-53.1959475093714	-23.001088809404	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4123808	"SANTA IZABEL DO OESTE"	41	-53.4836175358081	-25.8143812184215	4107	'Sudoeste Paranaense'	41025	'Capanema'
4123824	"SANTA LUCIA"	41	-53.5711436726035	-25.4113199197696	4106	'Oeste Paranaense'	41023	'Cascavel'
4123857	"SANTA MARIA DO OESTE"	41	-51.8677097950836	-24.9341839968829	4108	'Centro-Sul Paranaense'	41028	'Pitanga'
4123907	"SANTA MARIANA"	41	-50.5210713512026	-23.1464274393077	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4123956	"SANTA MONICA"	41	-53.1112728730423	-23.1054239387676	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4124020	"SANTA TEREZA DO OESTE"	41	-53.6272357310511	-25.058721900954	4106	'Oeste Paranaense'	41023	'Cascavel'
4124053	"SANTA TEREZINHA DE ITAIPU"	41	-54.3995187311272	-25.4421605134166	4106	'Oeste Paranaense'	41024	'Foz do Iguaçu'
4124004	"SANTANA DO ITARARE"	41	-49.6331966315173	-23.7531325857099	4104	'Norte Pioneiro Paranaense'	41018	'Wenceslau Braz'
4124103	"SANTO ANTONIO DA PLATINA"	41	-50.0773459027438	-23.2970488330377	4104	'Norte Pioneiro Paranaense'	41016	'Jacarezinho'
4124202	"SANTO ANTONIO DO CAIUA"	41	-52.3446578437543	-22.7339747691581	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4124301	"SANTO ANTONIO DO PARAISO"	41	-50.6468281629708	-23.4947194367769	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4124400	"SANTO ANTONIO DO SUDOESTE"	41	-53.7230834338629	-26.0749754785585	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4124509	"SANTO INACIO"	41	-51.7952999014099	-22.7000685756213	4103	'Norte Central Paranaense'	41006	'Astorga'
4124608	"SAO CARLOS DO IVAI"	41	-52.4771145893703	-23.3088474513599	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4124707	"SAO JERONIMO DA SERRA"	41	-50.7384804270196	-23.723403403633	4104	'Norte Pioneiro Paranaense'	41014	'Assaí'
4124806	"SAO JOAO"	41	-52.7294732188134	-25.8246629361444	4107	'Sudoeste Paranaense'	41027	'Pato Branco'
4124905	"SAO JOAO DO CAIUA"	41	-52.3397510425866	-22.8544043257963	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4125001	"SAO JOAO DO IVAI"	41	-51.8202792051938	-23.9930894814884	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4125100	"SAO JOAO DO TRIUNFO"	41	-50.3080640619123	-25.6918750639247	4109	'Sudeste Paranaense'	41034	'São Mateus do Sul'
4125308	"SAO JORGE DO IVAI"	41	-52.2943419624336	-23.4354578614104	4103	'Norte Central Paranaense'	41008	'Floraí'
4125357	"SAO JORGE DO PATROCINIO"	41	-53.8833305620973	-23.7582479652566	4101	'Noroeste Paranaense'	41002	'Umuarama'
4125209	"SAO JORGE D'OESTE"	41	-52.9201031661411	-25.714948099592	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4125407	"SAO JOSE DA BOA VISTA"	41	-49.6511522910825	-23.915465975535	4104	'Norte Pioneiro Paranaense'	41018	'Wenceslau Braz'
4125456	"SAO JOSE DAS PALMEIRAS"	41	-54.0599182790456	-24.8340818673691	4106	'Oeste Paranaense'	41022	'Toledo'
4125506	"SAO JOSE DOS PINHAIS"	41	-49.2000824656673	-25.537702	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4125555	"SAO MANOEL DO PARANA"	41	-52.6470195624171	-23.3961302642141	4101	'Noroeste Paranaense'	41003	'Cianorte'
4125605	"SAO MATEUS DO SUL"	41	-50.3906242547046	-25.869599505	4109	'Sudeste Paranaense'	41034	'São Mateus do Sul'
4125704	"SAO MIGUEL DO IGUACU"	41	-54.242120554007	-25.3488942672582	4106	'Oeste Paranaense'	41024	'Foz do Iguaçu'
4125753	"SAO PEDRO DO IGUACU"	41	-53.8598616786826	-24.9309309248552	4106	'Oeste Paranaense'	41022	'Toledo'
4125803	"SAO PEDRO DO IVAI"	41	-51.8569627582888	-23.8678134422696	4103	'Norte Central Paranaense'	41013	'Ivaiporã'
4125902	"SAO PEDRO DO PARANA"	41	-53.2229371404628	-22.8251294492252	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4126009	"SAO SEBASTIAO DA AMOREIRA"	41	-50.7624009771172	-23.4606458610134	4104	'Norte Pioneiro Paranaense'	41014	'Assaí'
4126108	"SAO TOME"	41	-52.5924836675634	-23.5355113617934	4101	'Noroeste Paranaense'	41003	'Cianorte'
4126207	"SAPOPEMA"	41	-50.579646631054	-23.9072874610035	4104	'Norte Pioneiro Paranaense'	41017	'Ibaiti'
4126256	"SARANDI"	41	-51.8736820362471	-23.44317201	4103	'Norte Central Paranaense'	41009	'Maringá'
4126272	"SAUDADE DO IGUACU"	41	-52.6143393739758	-25.6936611646413	4107	'Sudoeste Paranaense'	41027	'Pato Branco'
4126306	"SENGES"	41	-49.4730192945961	-24.1168102194297	4105	'Centro Oriental Paranaense'	41020	'Jaguariaíva'
4126355	"SERRANOPOLIS DO IGUACU"	41	-54.0583765839748	-25.3798841827825	4106	'Oeste Paranaense'	41024	'Foz do Iguaçu'
4126405	"SERTANEJA"	41	-50.8171022996451	-23.0369370349393	4104	'Norte Pioneiro Paranaense'	41015	'Cornélio Procópio'
4126504	"SERTANOPOLIS"	41	-51.0422435334555	-23.058481975559	4103	'Norte Central Paranaense'	41007	'Porecatu'
4126603	"SIQUEIRA CAMPOS"	41	-49.8314969707685	-23.6877083827751	4104	'Norte Pioneiro Paranaense'	41018	'Wenceslau Braz'
4126652	"SULINA"	41	-52.7165965203627	-25.6996322445225	4107	'Sudoeste Paranaense'	41027	'Pato Branco'
4126678	"TAMARANA"	41	-51.0985602004511	-23.7151771915553	4103	'Norte Central Paranaense'	41011	'Londrina'
4126702	"TAMBOARA"	41	-52.5006292917574	-23.2018206530944	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4126801	"TAPEJARA"	41	-52.8641131839901	-23.7324791909303	4101	'Noroeste Paranaense'	41003	'Cianorte'
4126900	"TAPIRA"	41	-53.0753253067345	-23.3171088650565	4101	'Noroeste Paranaense'	41002	'Umuarama'
4127007	"TEIXEIRA SOARES"	41	-50.4656469824186	-25.3800492077089	4109	'Sudeste Paranaense'	41031	'Prudentópolis'
4127106	"TELEMACO BORBA"	41	-50.6231227231312	-24.32868597	4105	'Centro Oriental Paranaense'	41019	'Telêmaco Borba'
4127205	"TERRA BOA"	41	-52.4621421588906	-23.7668332665984	4102	'Centro Ocidental Paranaense'	41005	'Campo Mourão'
4127304	"TERRA RICA"	41	-52.6246705735779	-22.7243649693344	4101	'Noroeste Paranaense'	41001	'Paranavaí'
4127403	"TERRA ROXA"	41	-54.0985136359671	-24.16748352606	4106	'Oeste Paranaense'	41022	'Toledo'
4127502	"TIBAGI"	41	-50.4114701228325	-24.5132880678495	4105	'Centro Oriental Paranaense'	41019	'Telêmaco Borba'
4127601	"TIJUCAS DO SUL"	41	-49.1822439412764	-25.9201804801753	4110	'Metropolitana de Curitiba'	41039	'Rio Negro'
4127700	"TOLEDO"	41	-53.7414114911568	-24.732077	4106	'Oeste Paranaense'	41022	'Toledo'
4127809	"TOMAZINA"	41	-49.9551515410795	-23.7790448563942	4104	'Norte Pioneiro Paranaense'	41018	'Wenceslau Braz'
4127858	"TRES BARRAS DO PARANA"	41	-53.187498800546	-25.4194083194783	4106	'Oeste Paranaense'	41023	'Cascavel'
4127882	"TUNAS DO PARANA"	41	-49.0860587993652	-24.9723811901187	4110	'Metropolitana de Curitiba'	41037	'Curitiba'
4127908	"TUNEIRAS DO OESTE"	41	-52.8745678467236	-23.8640306292838	4101	'Noroeste Paranaense'	41003	'Cianorte'
4127957	"TUPASSI"	41	-53.5144953148303	-24.5798134088754	4106	'Oeste Paranaense'	41022	'Toledo'
4127965	"TURVO"	41	-51.5327643273371	-25.0401268031015	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4128005	"UBIRATA"	41	-52.9945060158456	-24.5410348849922	4102	'Centro Ocidental Paranaense'	41004	'Goioerê'
4128104	"UMUARAMA"	41	-53.3084598047956	-23.76395	4101	'Noroeste Paranaense'	41002	'Umuarama'
4128203	"UNIAO DA VITORIA"	41	-51.0906095229867	-26.2284345	4109	'Sudeste Paranaense'	41033	'União da Vitória'
4128302	"UNIFLOR"	41	-52.1600108240348	-23.0860486572457	4103	'Norte Central Paranaense'	41006	'Astorga'
4128401	"URAI"	41	-50.7973651802287	-23.2001591025263	4104	'Norte Pioneiro Paranaense'	41014	'Assaí'
4128534	"VENTANIA"	41	-50.2476172237288	-24.2441658559639	4105	'Centro Oriental Paranaense'	41019	'Telêmaco Borba'
4128559	"VERA CRUZ DO OESTE"	41	-53.8800300706254	-25.0631701890109	4106	'Oeste Paranaense'	41024	'Foz do Iguaçu'
4128609	"VERE"	41	-52.9085930798312	-25.8806316035548	4107	'Sudoeste Paranaense'	41026	'Francisco Beltrão'
4128658	"VIRMOND"	41	-52.2025433047369	-25.3787659851252	4108	'Centro-Sul Paranaense'	41029	'Guarapuava'
4128708	"VITORINO"	41	-52.7770814458028	-26.2643442873669	4107	'Sudoeste Paranaense'	41027	'Pato Branco'
4128500	"WENCESLAU BRAZ"	41	-49.80298478237	-23.8704228528497	4104	'Norte Pioneiro Paranaense'	41018	'Wenceslau Braz'
4128807	"XAMBRE"	41	-53.4869406945526	-23.7383943961389	4101	'Noroeste Paranaense'	41002	'Umuarama'
3300100	"ANGRA DOS REIS"	33	-44.3196272622666	-23.0091159352755	3305	'Sul Fluminense'	33013	'Baía da Ilha Grande'
3300159	"APERIBE"	33	-42.1049166541126	-21.6194217697861	3301	'Noroeste Fluminense'	33002	'Santo Antônio de Pádua'
3300209	"ARARUAMA"	33	-42.3410960231634	-22.8774383873544	3304	'Baixadas'	33010	'Lagos'
3300225	"AREAL"	33	-43.1010698051683	-22.2369120035668	3303	'Centro Fluminense'	33005	'Três Rios'
3300233	"ARMACAO DOS BUZIOS"	33	-41.8877494680881	-22.7577637929237	3304	'Baixadas'	33010	'Lagos'
3300258	"ARRAIAL DO CABO"	33	-42.0283359676368	-22.967638277584	3304	'Baixadas'	33010	'Lagos'
3300308	"BARRA DO PIRAI"	33	-43.8284524538255	-22.469596292124	3305	'Sul Fluminense'	33012	'Barra do Piraí'
3300407	"BARRA MANSA"	33	-44.1724313736866	-22.5453011339304	3305	'Sul Fluminense'	33011	'Vale do Paraíba Fluminense'
3300456	"BELFORD ROXO"	33	-43.3996249708152	-22.7645559675461	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3300506	"BOM JARDIM"	33	-42.4172114822868	-22.1533052283079	3303	'Centro Fluminense'	33007	'Nova Friburgo'
3300605	"BOM JESUS DO ITABAPOANA"	33	-41.6776797949817	-21.1344974418774	3301	'Noroeste Fluminense'	33001	'Itaperuna'
3300704	"CABO FRIO"	33	-42.0200748019026	-22.880764667133	3304	'Baixadas'	33010	'Lagos'
3300803	"CACHOEIRAS DE MACACU"	33	-42.6631643572627	-22.4675708722497	3306	'Metropolitana do Rio de Janeiro'	33016	'Macacu-Caceribu'
3300902	"CAMBUCI"	33	-41.9086360046562	-21.5772767096589	3301	'Noroeste Fluminense'	33002	'Santo Antônio de Pádua'
3301009	"CAMPOS DOS GOYTACAZES"	33	-41.3304764918626	-21.751898632064	3302	'Norte Fluminense'	33003	'Campos dos Goytacazes'
3301108	"CANTAGALO"	33	-42.365977599021	-21.9818398587921	3303	'Centro Fluminense'	33006	'Cantagalo-Cordeiro'
3300936	"CARAPEBUS"	33	-41.6640105958579	-22.1825947273674	3302	'Norte Fluminense'	33004	'Macaé'
3301157	"CARDOSO MOREIRA"	33	-41.6132963462101	-21.4961573566676	3302	'Norte Fluminense'	33003	'Campos dos Goytacazes'
3301207	"CARMO"	33	-42.6097176406817	-21.9293117801393	3303	'Centro Fluminense'	33006	'Cantagalo-Cordeiro'
3301306	"CASIMIRO DE ABREU"	33	-42.204210544431	-22.4795365025548	3304	'Baixadas'	33009	'Bacia de São João'
3300951	"COMENDADOR LEVY GASPARIAN"	33	-43.2172237155871	-22.0333589383827	3303	'Centro Fluminense'	33005	'Três Rios'
3301405	"CONCEICAO DE MACABU"	33	-41.8677585057148	-22.0878715265253	3302	'Norte Fluminense'	33004	'Macaé'
3301504	"CORDEIRO"	33	-42.3630305379077	-22.0277765631233	3303	'Centro Fluminense'	33006	'Cantagalo-Cordeiro'
3301603	"DUAS BARRAS"	33	-42.515097631467	-22.0589060899401	3303	'Centro Fluminense'	33007	'Nova Friburgo'
3301702	"DUQUE DE CAXIAS"	33	-43.3098880717226	-22.7852532496542	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3301801	"ENGENHEIRO PAULO DE FRONTIN"	33	-43.6794768289526	-22.5436846647273	3306	'Metropolitana do Rio de Janeiro'	33014	'Vassouras'
3301850	"GUAPIMIRIM"	33	-42.9783297043207	-22.5195957941239	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3301876	"IGUABA GRANDE"	33	-42.2221245423239	-22.8390569836941	3304	'Baixadas'	33010	'Lagos'
3301900	"ITABORAI"	33	-42.8603434261964	-22.7458630174263	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3302007	"ITAGUAI"	33	-43.7750406349418	-22.871250768422	3306	'Metropolitana do Rio de Janeiro'	33017	'Itaguaí'
3302056	"ITALVA"	33	-41.690964760493	-21.4251032779829	3301	'Noroeste Fluminense'	33001	'Itaperuna'
3302106	"ITAOCARA"	33	-42.0777295245708	-21.6705026732971	3301	'Noroeste Fluminense'	33002	'Santo Antônio de Pádua'
3302205	"ITAPERUNA"	33	-41.8862031766506	-21.2105910847538	3301	'Noroeste Fluminense'	33001	'Itaperuna'
3302254	"ITATIAIA"	33	-44.562771994177	-22.4970145997172	3305	'Sul Fluminense'	33011	'Vale do Paraíba Fluminense'
3302270	"JAPERI"	33	-43.6537858009828	-22.6448185711114	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3302304	"LAJE DO MURIAE"	33	-42.1311744192347	-21.2057208352488	3301	'Noroeste Fluminense'	33001	'Itaperuna'
3302403	"MACAE"	33	-41.775064285476	-22.368704974385	3302	'Norte Fluminense'	33004	'Macaé'
3302452	"MACUCO"	33	-42.2570738797263	-21.9902295051433	3303	'Centro Fluminense'	33006	'Cantagalo-Cordeiro'
3302502	"MAGE"	33	-43.0402461327151	-22.6543487574334	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3302601	"MANGARATIBA"	33	-44.0411265453576	-22.9617119412403	3306	'Metropolitana do Rio de Janeiro'	33017	'Itaguaí'
3302700	"MARICA"	33	-42.819824114827	-22.916955337401	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3302809	"MENDES"	33	-43.7214868876952	-22.5174226018979	3306	'Metropolitana do Rio de Janeiro'	33014	'Vassouras'
3302858	"MESQUITA"	33	-43.4292237631069	-22.768087922635	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3302908	"MIGUEL PEREIRA"	33	-43.4746761214594	-22.4554266084252	3306	'Metropolitana do Rio de Janeiro'	33014	'Vassouras'
3303005	"MIRACEMA"	33	-42.1984114071903	-21.4111632991602	3301	'Noroeste Fluminense'	33002	'Santo Antônio de Pádua'
3303104	"NATIVIDADE"	33	-41.9764403133446	-21.0437569889655	3301	'Noroeste Fluminense'	33001	'Itaperuna'
3303203	"NILOPOLIS"	33	-43.4166099808637	-22.8075142239115	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3303302	"NITEROI"	33	-43.0758231672735	-22.8964523851273	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3303401	"NOVA FRIBURGO"	33	-42.5327712629633	-22.2864614591961	3303	'Centro Fluminense'	33007	'Nova Friburgo'
3303500	"NOVA IGUACU"	33	-43.4503453299191	-22.7598348262647	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3303609	"PARACAMBI"	33	-43.7093845630292	-22.6097271620662	3306	'Metropolitana do Rio de Janeiro'	33014	'Vassouras'
3303708	"PARAIBA DO SUL"	33	-43.2895444648457	-22.1619815421833	3303	'Centro Fluminense'	33005	'Três Rios'
3303807	"PARATY"	33	-44.7108585020174	-23.2194136073409	3305	'Sul Fluminense'	33013	'Baía da Ilha Grande'
3303856	"PATY DO ALFERES"	33	-43.4248709167338	-22.4274146332335	3306	'Metropolitana do Rio de Janeiro'	33014	'Vassouras'
3303906	"PETROPOLIS"	33	-43.177336576675	-22.5105986119618	3306	'Metropolitana do Rio de Janeiro'	33015	'Serrana'
3303955	"PINHEIRAL"	33	-44.0003545569539	-22.5156739857917	3305	'Sul Fluminense'	33011	'Vale do Paraíba Fluminense'
3304003	"PIRAI"	33	-43.8993511857657	-22.6287569098054	3305	'Sul Fluminense'	33011	'Vale do Paraíba Fluminense'
3304102	"PORCIUNCULA"	33	-42.0401563585052	-20.9626076269766	3301	'Noroeste Fluminense'	33001	'Itaperuna'
3304110	"PORTO REAL"	33	-44.2969007349911	-22.432948423821	3305	'Sul Fluminense'	33011	'Vale do Paraíba Fluminense'
3304128	"QUATIS"	33	-44.2627113015842	-22.409918661677	3305	'Sul Fluminense'	33011	'Vale do Paraíba Fluminense'
3304144	"QUEIMADOS"	33	-43.5556695470827	-22.7174304900919	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3304151	"QUISSAMA"	33	-41.4725094000999	-22.1066401655146	3302	'Norte Fluminense'	33004	'Macaé'
3304201	"RESENDE"	33	-44.4436134229207	-22.4711835861228	3305	'Sul Fluminense'	33011	'Vale do Paraíba Fluminense'
3304300	"RIO BONITO"	33	-42.6259978411627	-22.7112715025702	3306	'Metropolitana do Rio de Janeiro'	33016	'Macacu-Caceribu'
3304409	"RIO CLARO"	33	-44.1394056377073	-22.7317268340485	3305	'Sul Fluminense'	33011	'Vale do Paraíba Fluminense'
3304508	"RIO DAS FLORES"	33	-43.5764329481335	-22.171862243836	3305	'Sul Fluminense'	33012	'Barra do Piraí'
3304524	"RIO DAS OSTRAS"	33	-41.9369671271608	-22.523941185805	3304	'Baixadas'	33009	'Bacia de São João'
3304557	"RIO DE JANEIRO"	33	-43.2278751249952	-22.8766521181865	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3304607	"SANTA MARIA MADALENA"	33	-42.0144449928315	-21.9660944706772	3303	'Centro Fluminense'	33008	'Santa Maria Madalena'
3304706	"SANTO ANTONIO DE PADUA"	33	-42.1779115574882	-21.5359771209445	3301	'Noroeste Fluminense'	33002	'Santo Antônio de Pádua'
3304805	"SAO FIDELIS"	33	-41.7555923123358	-21.6436265466279	3302	'Norte Fluminense'	33003	'Campos dos Goytacazes'
3304755	"SAO FRANCISCO DE ITABAPOANA"	33	-41.1177197285798	-21.4801381322882	3302	'Norte Fluminense'	33003	'Campos dos Goytacazes'
3304904	"SAO GONCALO"	33	-43.0323350619648	-22.8295473130261	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3305000	"SAO JOAO DA BARRA"	33	-41.050348145484	-21.6404577523792	3302	'Norte Fluminense'	33003	'Campos dos Goytacazes'
3305109	"SAO JOAO DE MERITI"	33	-43.3718846030395	-22.8023308086339	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3305133	"SAO JOSE DE UBA"	33	-41.9412319414458	-21.3602211097573	3301	'Noroeste Fluminense'	33002	'Santo Antônio de Pádua'
3305158	"SAO JOSE DO VALE DO RIO PRETO"	33	-42.9233683013341	-22.1497395104903	3306	'Metropolitana do Rio de Janeiro'	33015	'Serrana'
3305208	"SAO PEDRO DA ALDEIA"	33	-42.1035286701542	-22.8372031947556	3304	'Baixadas'	33010	'Lagos'
3305307	"SAO SEBASTIAO DO ALTO"	33	-42.1302196784864	-21.9544634108549	3303	'Centro Fluminense'	33008	'Santa Maria Madalena'
3305406	"SAPUCAIA"	33	-42.9141753604676	-21.9939558651925	3303	'Centro Fluminense'	33005	'Três Rios'
3305505	"SAQUAREMA"	33	-42.4966940500338	-22.9311274159959	3304	'Baixadas'	33010	'Lagos'
3305554	"SEROPEDICA"	33	-43.7019252211618	-22.743011068024	3306	'Metropolitana do Rio de Janeiro'	33017	'Itaguaí'
3305604	"SILVA JARDIM"	33	-42.3898259273538	-22.6543301984185	3304	'Baixadas'	33009	'Bacia de São João'
3305703	"SUMIDOURO"	33	-42.6786255811119	-22.0506694108347	3303	'Centro Fluminense'	33007	'Nova Friburgo'
3305752	"TANGUA"	33	-42.7211719484129	-22.7339374343164	3306	'Metropolitana do Rio de Janeiro'	33018	'Rio de Janeiro'
3305802	"TERESOPOLIS"	33	-42.9629567139024	-22.4090049455631	3306	'Metropolitana do Rio de Janeiro'	33015	'Serrana'
3305901	"TRAJANO DE MORAES"	33	-42.0548152486202	-22.0613797048486	3303	'Centro Fluminense'	33008	'Santa Maria Madalena'
3306008	"TRES RIOS"	33	-43.2116094443354	-22.1174480009517	3303	'Centro Fluminense'	33005	'Três Rios'
3306107	"VALENCA"	33	-43.7048436783271	-22.2447194311794	3305	'Sul Fluminense'	33012	'Barra do Piraí'
3306156	"VARRE-SAI"	33	-41.8632953882988	-20.9292976638709	3301	'Noroeste Fluminense'	33001	'Itaperuna'
3306206	"VASSOURAS"	33	-43.6638740245132	-22.4090075730264	3306	'Metropolitana do Rio de Janeiro'	33014	'Vassouras'
3306305	"VOLTA REDONDA"	33	-44.0935218846871	-22.5099676007977	3305	'Sul Fluminense'	33011	'Vale do Paraíba Fluminense'
2400109	"ACARI"	24	-36.6437388699983	-6.44208508893385	2402	'Central Potiguar'	24012	'Seridó Oriental'
2400208	"ACU"	24	-36.9179232199589	-5.57194599924666	2401	'Oeste Potiguar'	24004	'Vale do Açu'
2400307	"AFONSO BEZERRA"	24	-36.5091482339596	-5.49873426813082	2402	'Central Potiguar'	24009	'Angicos'
2400406	"AGUA NOVA"	24	-38.290824954228	-6.20471671883501	2401	'Oeste Potiguar'	24005	'Serra de São Miguel'
2400505	"ALEXANDRIA"	24	-38.0192888913064	-6.41713633794429	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2400604	"ALMINO AFONSO"	24	-37.7631253023649	-6.15742069252536	2401	'Oeste Potiguar'	24007	'Umarizal'
2400703	"ALTO DO RODRIGUES"	24	-36.7594926142107	-5.293807787638	2401	'Oeste Potiguar'	24004	'Vale do Açu'
2400802	"ANGICOS"	24	-36.6054328737792	-5.66036532908629	2402	'Central Potiguar'	24009	'Angicos'
2400901	"ANTONIO MARTINS"	24	-37.8857345656395	-6.21600445470736	2401	'Oeste Potiguar'	24007	'Umarizal'
2401008	"APODI"	24	-37.797784476271	-5.66376981922722	2401	'Oeste Potiguar'	24002	'Chapada do Apodi'
2401107	"AREIA BRANCA"	24	-37.1312717156955	-4.9528976305617	2401	'Oeste Potiguar'	24001	'Mossoró'
2401206	"ARES"	24	-35.1606360959418	-6.19371227448261	2404	'Leste Potiguar'	24019	'Litoral Sul'
2401305	"AUGUSTO SEVERO"	24	-37.3088725642243	-5.85811442404707	2401	'Oeste Potiguar'	24003	'Médio Oeste'
2401404	"BAIA FORMOSA"	24	-35.0090361817886	-6.36999230418874	2404	'Leste Potiguar'	24019	'Litoral Sul'
2401453	"BARAUNA"	24	-37.6181801950628	-5.07661810480469	2401	'Oeste Potiguar'	24001	'Mossoró'
2401503	"BARCELONA"	24	-35.9267945279531	-5.9481318482859	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2401602	"BENTO FERNANDES"	24	-35.8216988907063	-5.69238331769413	2403	'Agreste Potiguar'	24013	'Baixa Verde'
2401651	"BODO"	24	-36.413837702334	-5.98804524994105	2402	'Central Potiguar'	24010	'Serra de Santana'
2401701	"BOM JESUS"	24	-35.5888032897951	-5.98631885234114	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2401800	"BREJINHO"	24	-35.3573540540418	-6.19257905870004	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2401859	"CAICARA DO NORTE"	24	-36.0558571538451	-5.06299440936317	2402	'Central Potiguar'	24008	'Macau'
2401909	"CAICARA DO RIO DO VENTO"	24	-35.9997904110862	-5.75908714277655	2402	'Central Potiguar'	24009	'Angicos'
2402006	"CAICO"	24	-37.0964887711922	-6.45913883139328	2402	'Central Potiguar'	24011	'Seridó Ocidental'
2402105	"CAMPO REDONDO"	24	-36.1825045694096	-6.24338305317339	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2402204	"CANGUARETAMA"	24	-35.1285396639931	-6.37492521572032	2404	'Leste Potiguar'	24019	'Litoral Sul'
2402303	"CARAUBAS"	24	-37.5537021978471	-5.79117610285868	2401	'Oeste Potiguar'	24002	'Chapada do Apodi'
2402402	"CARNAUBA DOS DANTAS"	24	-36.5952519214664	-6.56073251736681	2402	'Central Potiguar'	24012	'Seridó Oriental'
2402501	"CARNAUBAIS"	24	-36.8346423564497	-5.33978539431904	2401	'Oeste Potiguar'	24004	'Vale do Açu'
2402600	"CEARA-MIRIM"	24	-35.42448692853	-5.64098359191175	2404	'Leste Potiguar'	24017	'Macaíba'
2402709	"CERRO CORA"	24	-36.3457414414503	-6.0348271931366	2402	'Central Potiguar'	24010	'Serra de Santana'
2402808	"CORONEL EZEQUIEL"	24	-36.2147710444246	-6.38340239029441	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2402907	"CORONEL JOAO PESSOA"	24	-38.4402581627126	-6.26011221139078	2401	'Oeste Potiguar'	24005	'Serra de São Miguel'
2403004	"CRUZETA"	24	-36.7917053203155	-6.41317640695567	2402	'Central Potiguar'	24012	'Seridó Oriental'
2403103	"CURRAIS NOVOS"	24	-36.5162192209593	-6.26467221895558	2402	'Central Potiguar'	24012	'Seridó Oriental'
2403202	"DOUTOR SEVERIANO"	24	-38.3736830788222	-6.09368737055909	2401	'Oeste Potiguar'	24005	'Serra de São Miguel'
2403301	"ENCANTO"	24	-38.3048789906516	-6.1111342006329	2401	'Oeste Potiguar'	24005	'Serra de São Miguel'
2403400	"EQUADOR"	24	-36.7164124288599	-6.94584274907483	2402	'Central Potiguar'	24012	'Seridó Oriental'
2403509	"ESPIRITO SANTO"	24	-35.3170907892286	-6.33557170320116	2404	'Leste Potiguar'	24019	'Litoral Sul'
2403608	"EXTREMOZ"	24	-35.3140254320232	-5.70270993620874	2404	'Leste Potiguar'	24018	'Natal'
2403707	"FELIPE GUERRA"	24	-37.6913850557146	-5.60196176980821	2401	'Oeste Potiguar'	24002	'Chapada do Apodi'
2403756	"FERNANDO PEDROZA"	24	-36.5324535353652	-5.69601578146739	2402	'Central Potiguar'	24009	'Angicos'
2403806	"FLORANIA"	24	-36.8140762988106	-6.12695195501155	2402	'Central Potiguar'	24010	'Serra de Santana'
2403905	"FRANCISCO DANTAS"	24	-38.1256497554185	-6.08809671674326	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2404002	"FRUTUOSO GOMES"	24	-37.8409607540419	-6.15623279929201	2401	'Oeste Potiguar'	24007	'Umarizal'
2404101	"GALINHOS"	24	-36.2746400699779	-5.09168977841149	2402	'Central Potiguar'	24008	'Macau'
2404200	"GOIANINHA"	24	-35.2177861245435	-6.25059038995067	2404	'Leste Potiguar'	24019	'Litoral Sul'
2404309	"GOVERNADOR DIX-SEPT ROSADO"	24	-37.5219118430218	-5.45891384210597	2401	'Oeste Potiguar'	24002	'Chapada do Apodi'
2404408	"GROSSOS"	24	-37.1574841600262	-4.97551480707414	2401	'Oeste Potiguar'	24001	'Mossoró'
2404507	"GUAMARE"	24	-36.3181443773969	-5.10736295459178	2402	'Central Potiguar'	24008	'Macau'
2404606	"IELMO MARINHO"	24	-35.5528293750625	-5.81531503827622	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2404705	"IPANGUACU"	24	-36.8528746046542	-5.49714835330496	2401	'Oeste Potiguar'	24004	'Vale do Açu'
2404804	"IPUEIRA"	24	-37.1978561298861	-6.81555076188514	2402	'Central Potiguar'	24011	'Seridó Ocidental'
2404853	"ITAJA"	24	-36.8698181053353	-5.64354760896816	2401	'Oeste Potiguar'	24004	'Vale do Açu'
2404903	"ITAU"	24	-37.9882686256902	-5.83793607342512	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2405009	"JACANA"	24	-36.2055929077335	-6.42497334736577	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2405108	"JANDAIRA"	24	-36.1305852719426	-5.35528	2403	'Agreste Potiguar'	24013	'Baixa Verde'
2405207	"JANDUIS"	24	-37.4092111089131	-6.01609270285832	2401	'Oeste Potiguar'	24003	'Médio Oeste'
2405306	"JANUARIO CICCO"	24	-35.600891962575	-6.15609802255279	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2405405	"JAPI"	24	-35.9459348280456	-6.46056601331605	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2405504	"JARDIM DE ANGICOS"	24	-35.969954329802	-5.6526312123534	2402	'Central Potiguar'	24009	'Angicos'
2405603	"JARDIM DE PIRANHAS"	24	-37.3492178522692	-6.38009754919079	2402	'Central Potiguar'	24011	'Seridó Ocidental'
2405702	"JARDIM DO SERIDO"	24	-36.77458152338	-6.58633625168301	2402	'Central Potiguar'	24012	'Seridó Oriental'
2405801	"JOAO CAMARA"	24	-35.8167878738553	-5.53842338336333	2403	'Agreste Potiguar'	24013	'Baixa Verde'
2405900	"JOAO DIAS"	24	-37.7969607820048	-6.27611409784306	2401	'Oeste Potiguar'	24007	'Umarizal'
2406007	"JOSE DA PENHA"	24	-38.2844030704544	-6.31268844277092	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2406106	"JUCURUTU"	24	-37.020225829413	-6.03341878412747	2401	'Oeste Potiguar'	24004	'Vale do Açu'
2406155	"JUNDIA"	24	-35.3277885218596	-6.26916933108908	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2406304	"LAGOA DE PEDRAS"	24	-35.4334827321932	-6.14973910199057	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2406403	"LAGOA DE VELHOS"	24	-35.8706988331384	-5.99991551930281	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2406205	"LAGOA D'ANTA"	24	-35.5997951777328	-6.39150232349883	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2406502	"LAGOA NOVA"	24	-36.4589606695817	-6.09766929639383	2402	'Central Potiguar'	24010	'Serra de Santana'
2406601	"LAGOA SALGADA"	24	-35.4724975676103	-6.12581826185821	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2406700	"LAJES"	24	-36.242735126413	-5.69883035878165	2402	'Central Potiguar'	24009	'Angicos'
2406809	"LAJES PINTADAS"	24	-36.1184417929034	-6.15143207205811	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2406908	"LUCRECIA"	24	-37.8156328477028	-6.11692363522479	2401	'Oeste Potiguar'	24007	'Umarizal'
2407005	"LUIS GOMES"	24	-38.386420375103	-6.41402814243274	2401	'Oeste Potiguar'	24005	'Serra de São Miguel'
2407104	"MACAIBA"	24	-35.3552371335816	-5.85723661962623	2404	'Leste Potiguar'	24017	'Macaíba'
2407203	"MACAU"	24	-36.634973181901	-5.11336765030868	2402	'Central Potiguar'	24008	'Macau'
2407252	"MAJOR SALES"	24	-38.3234550212287	-6.40375656574908	2401	'Oeste Potiguar'	24005	'Serra de São Miguel'
2407302	"MARCELINO VIEIRA"	24	-38.1666126187356	-6.29354978779003	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2407401	"MARTINS"	24	-37.9113273956681	-6.09634749287148	2401	'Oeste Potiguar'	24007	'Umarizal'
2407500	"MAXARANGUAPE"	24	-35.262074868072	-5.50545626577382	2404	'Leste Potiguar'	24016	'Litoral Nordeste'
2407609	"MESSIAS TARGINO"	24	-37.5120589301593	-6.07649750532978	2401	'Oeste Potiguar'	24003	'Médio Oeste'
2407708	"MONTANHAS"	24	-35.2876919575565	-6.4822429389357	2404	'Leste Potiguar'	24019	'Litoral Sul'
2407807	"MONTE ALEGRE"	24	-35.3320992692543	-6.06787662410822	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2407906	"MONTE DAS GAMELEIRAS"	24	-35.7866071234666	-6.43946601652215	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2408003	"MOSSORO"	24	-37.3568741367043	-5.19380123470868	2401	'Oeste Potiguar'	24001	'Mossoró'
2408102	"NATAL"	24	-35.2522547280543	-5.75089853761206	2404	'Leste Potiguar'	24018	'Natal'
2408201	"NISIA FLORESTA"	24	-35.211309564485	-6.09071414590346	2404	'Leste Potiguar'	24017	'Macaíba'
2408300	"NOVA CRUZ"	24	-35.4323003945869	-6.48006479201477	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2408409	"OLHO-D'AGUA DO BORGES"	24	-37.7118209785559	-5.95925838753112	2401	'Oeste Potiguar'	24007	'Umarizal'
2408508	"OURO BRANCO"	24	-36.9462950766901	-6.69965894742555	2402	'Central Potiguar'	24012	'Seridó Oriental'
2408607	"PARANA"	24	-38.3111288501105	-6.48533050134249	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2408706	"PARAU"	24	-37.1016501352676	-5.77705551761264	2401	'Oeste Potiguar'	24003	'Médio Oeste'
2408805	"PARAZINHO"	24	-35.8449895223578	-5.23078073449039	2403	'Agreste Potiguar'	24013	'Baixa Verde'
2408904	"PARELHAS"	24	-36.6578048562049	-6.68875519717457	2402	'Central Potiguar'	24012	'Seridó Oriental'
2403251	"PARNAMIRIM"	24	-35.2592090738617	-5.91036975825394	2404	'Leste Potiguar'	24018	'Natal'
2409100	"PASSA E FICA"	24	-35.6473522143433	-6.42911549365363	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2409209	"PASSAGEM"	24	-35.3755657140696	-6.27444221295608	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2409308	"PATU"	24	-37.6401023994731	-6.1015320672853	2401	'Oeste Potiguar'	24007	'Umarizal'
2409407	"PAU DOS FERROS"	24	-38.2032615200836	-6.11473183865013	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2409506	"PEDRA GRANDE"	24	-35.8759906400618	-5.14938743349801	2404	'Leste Potiguar'	24016	'Litoral Nordeste'
2409605	"PEDRA PRETA"	24	-36.1031358189646	-5.58190915620307	2402	'Central Potiguar'	24009	'Angicos'
2409704	"PEDRO AVELINO"	24	-36.3852292558735	-5.52400218205231	2402	'Central Potiguar'	24009	'Angicos'
2409803	"PEDRO VELHO"	24	-35.2229392416707	-6.43318948820377	2404	'Leste Potiguar'	24019	'Litoral Sul'
2409902	"PENDENCIAS"	24	-36.7191460402508	-5.25678817094245	2401	'Oeste Potiguar'	24004	'Vale do Açu'
2410009	"PILOES"	24	-38.0444431555028	-6.26572244024087	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2410108	"POCO BRANCO"	24	-35.6550117699579	-5.61885150409171	2403	'Agreste Potiguar'	24013	'Baixa Verde'
2410207	"PORTALEGRE"	24	-37.9851948257179	-6.02432801349187	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2410256	"PORTO DO MANGUE"	24	-36.7805380667257	-5.06967015221064	2401	'Oeste Potiguar'	24004	'Vale do Açu'
2410405	"PUREZA"	24	-35.5622682321378	-5.46591858591341	2404	'Leste Potiguar'	24016	'Litoral Nordeste'
2410504	"RAFAEL FERNANDES"	24	-38.2225028856897	-6.18649519808459	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2410603	"RAFAEL GODEIRO"	24	-37.7159740682361	-6.07829664776498	2401	'Oeste Potiguar'	24007	'Umarizal'
2410702	"RIACHO DA CRUZ"	24	-37.9502747099434	-5.93580252202388	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2410801	"RIACHO DE SANTANA"	24	-38.3148330293793	-6.26473054680818	2401	'Oeste Potiguar'	24005	'Serra de São Miguel'
2410900	"RIACHUELO"	24	-35.8262747639025	-5.81394696471209	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2408953	"RIO DO FOGO"	24	-35.3848720422209	-5.27155865959121	2404	'Leste Potiguar'	24016	'Litoral Nordeste'
2411007	"RODOLFO FERNANDES"	24	-38.0628743291341	-5.78799361171139	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2411106	"RUY BARBOSA"	24	-35.9354841632411	-5.87942894095812	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2411205	"SANTA CRUZ"	24	-36.0205165703447	-6.23007562338656	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2409332	"SANTA MARIA"	24	-35.6903638553156	-5.83851870108946	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2411403	"SANTANA DO MATOS"	24	-36.6541049650822	-5.95772715540178	2402	'Central Potiguar'	24010	'Serra de Santana'
2411429	"SANTANA DO SERIDO"	24	-36.7368516418736	-6.77015175289955	2402	'Central Potiguar'	24012	'Seridó Oriental'
2411502	"SANTO ANTONIO"	24	-35.4751369839982	-6.30517392129752	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2411601	"SAO BENTO DO NORTE"	24	-36.0354313533959	-5.05950106008262	2402	'Central Potiguar'	24008	'Macau'
2411700	"SAO BENTO DO TRAIRI"	24	-36.0868875014205	-6.34448121674061	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2411809	"SAO FERNANDO"	24	-37.1854030398375	-6.38386107302845	2402	'Central Potiguar'	24011	'Seridó Ocidental'
2411908	"SAO FRANCISCO DO OESTE"	24	-38.1692961807558	-6.00063657053982	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2412005	"SAO GONCALO DO AMARANTE"	24	-35.3311560930852	-5.78955554020528	2404	'Leste Potiguar'	24017	'Macaíba'
2412104	"SAO JOAO DO SABUGI"	24	-37.2041396579503	-6.71122435001558	2402	'Central Potiguar'	24011	'Seridó Ocidental'
2412203	"SAO JOSE DE MIPIBU"	24	-35.2402746487129	-6.0704657116057	2404	'Leste Potiguar'	24017	'Macaíba'
2412302	"SAO JOSE DO CAMPESTRE"	24	-35.7121150331211	-6.31556398064831	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2412401	"SAO JOSE DO SERIDO"	24	-36.883258892934	-6.44879853464511	2402	'Central Potiguar'	24012	'Seridó Oriental'
2412500	"SAO MIGUEL"	24	-38.4963439736539	-6.2123429186061	2401	'Oeste Potiguar'	24005	'Serra de São Miguel'
2412559	"SAO MIGUEL DO GOSTOSO"	24	-35.6412835112052	-5.1228571163116	2404	'Leste Potiguar'	24016	'Litoral Nordeste'
2412609	"SAO PAULO DO POTENGI"	24	-35.7643696369494	-5.89982033377984	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2412708	"SAO PEDRO"	24	-35.6403110302273	-5.89798028251298	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2412807	"SAO RAFAEL"	24	-36.8903975641003	-5.80093422659101	2401	'Oeste Potiguar'	24004	'Vale do Açu'
2412906	"SAO TOME"	24	-36.0736631485719	-5.97302234709679	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2413003	"SAO VICENTE"	24	-36.6886618516821	-6.2149638781654	2402	'Central Potiguar'	24010	'Serra de Santana'
2413102	"SENADOR ELOI DE SOUZA"	24	-35.6956637751617	-6.03622642877325	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2413201	"SENADOR GEORGINO AVELINO"	24	-35.1241762279568	-6.15869433436923	2404	'Leste Potiguar'	24019	'Litoral Sul'
2410306	"PRESIDENTE JUSCELINO"	24	-35.7056053223905	-6.10491278564986	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2413300	"SERRA DE SAO BENTO"	24	-35.7034898198867	-6.41536699233032	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2413359	"SERRA DO MEL"	24	-37.0413013452291	-5.16524134820184	2401	'Oeste Potiguar'	24001	'Mossoró'
2413409	"SERRA NEGRA DO NORTE"	24	-37.3949730105827	-6.66398433637305	2402	'Central Potiguar'	24011	'Seridó Ocidental'
2413508	"SERRINHA"	24	-35.5013432340406	-6.27709152574771	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2413557	"SERRINHA DOS PINTOS"	24	-37.9615790488698	-6.1141293698225	2401	'Oeste Potiguar'	24007	'Umarizal'
2413607	"SEVERIANO MELO"	24	-37.9565807059839	-5.77818776528756	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2413706	"SITIO NOVO"	24	-35.9104491798599	-6.10409158278198	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2413805	"TABOLEIRO GRANDE"	24	-38.0435675405776	-5.92675229224912	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2413904	"TAIPU"	24	-35.5988465612551	-5.61966667527279	2404	'Leste Potiguar'	24016	'Litoral Nordeste'
2414001	"TANGARA"	24	-35.8001895983091	-6.19735736831057	2403	'Agreste Potiguar'	24014	'Borborema Potiguar'
2414100	"TENENTE ANANIAS"	24	-38.1792978897052	-6.47754371218665	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2414159	"TENENTE LAURENTINO CRUZ"	24	-36.7206601448861	-6.14723015948954	2402	'Central Potiguar'	24010	'Serra de Santana'
2411056	"TIBAU"	24	-37.2513026681358	-4.84143741044144	2401	'Oeste Potiguar'	24001	'Mossoró'
2414209	"TIBAU DO SUL"	24	-35.0926003671736	-6.18807175929036	2404	'Leste Potiguar'	24019	'Litoral Sul'
2414308	"TIMBAUBA DOS BATISTAS"	24	-37.2713399064401	-6.46328926305819	2402	'Central Potiguar'	24011	'Seridó Ocidental'
2414407	"TOUROS"	24	-35.4552931657206	-5.20260680139676	2404	'Leste Potiguar'	24016	'Litoral Nordeste'
2414456	"TRIUNFO POTIGUAR"	24	-37.1837968505575	-5.86695901863489	2401	'Oeste Potiguar'	24003	'Médio Oeste'
2414506	"UMARIZAL"	24	-37.8132584900854	-5.98990197956187	2401	'Oeste Potiguar'	24007	'Umarizal'
2414605	"UPANEMA"	24	-37.2601469419864	-5.64179765927023	2401	'Oeste Potiguar'	24003	'Médio Oeste'
2414704	"VARZEA"	24	-35.374790664391	-6.34879989073068	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2414753	"VENHA-VER"	24	-38.4912301676647	-6.31942283689552	2401	'Oeste Potiguar'	24005	'Serra de São Miguel'
2414803	"VERA CRUZ"	24	-35.428109527209	-6.04560848179296	2403	'Agreste Potiguar'	24015	'Agreste Potiguar'
2414902	"VICOSA"	24	-37.9474090159691	-5.99185717473435	2401	'Oeste Potiguar'	24006	'Pau dos Ferros'
2415008	"VILA FLOR"	24	-35.0761274954455	-6.31279187093585	2404	'Leste Potiguar'	24019	'Litoral Sul'
1100015	"ALTA FLORESTA DOESTE"	11	-61.9998238962936	-11.9355403047646	1102	'Leste Rondoniense'	11006	'Cacoal'
1100379	"ALTO ALEGRE DOS PARECIS"	11	-61.853077168603	-12.1317772245709	1102	'Leste Rondoniense'	11006	'Cacoal'
1100403	"ALTO PARAISO"	11	-63.3176294334976	-9.71666673807728	1102	'Leste Rondoniense'	11003	'Ariquemes'
1100346	"ALVORADA D'OESTE"	11	-62.2772748656972	-11.3441300234334	1102	'Leste Rondoniense'	11005	'Alvorada D''Oeste'
1100023	"ARIQUEMES"	11	-63.0332692780484	-9.9084628665672	1102	'Leste Rondoniense'	11003	'Ariquemes'
1100452	"BURITIS"	11	-63.8296787917565	-10.2098054072356	1101	'Madeira-Guaporé'	11001	'Porto Velho'
1100031	"CABIXI"	11	-60.5443135812009	-13.4997634596963	1102	'Leste Rondoniense'	11008	'Colorado do Oeste'
1100601	"CACAULANDIA"	11	-62.9031899345687	-10.3388728393928	1102	'Leste Rondoniense'	11003	'Ariquemes'
1100049	"CACOAL"	11	-61.4429442118224	-11.4338650286852	1102	'Leste Rondoniense'	11006	'Cacoal'
1100700	"CAMPO NOVO DE RONDONIA"	11	-63.6249914265426	-10.5684164693485	1101	'Madeira-Guaporé'	11001	'Porto Velho'
1100809	"CANDEIAS DO JAMARI"	11	-63.7000200718298	-8.78502070347748	1101	'Madeira-Guaporé'	11001	'Porto Velho'
1100908	"CASTANHEIRAS"	11	-61.9491611964662	-11.4268422254625	1102	'Leste Rondoniense'	11006	'Cacoal'
1100056	"CEREJEIRAS"	11	-60.8184261646815	-13.1950330320399	1102	'Leste Rondoniense'	11008	'Colorado do Oeste'
1100924	"CHUPINGUAIA"	11	-60.9018477499554	-12.5568407610938	1102	'Leste Rondoniense'	11007	'Vilhena'
1100064	"COLORADO DO OESTE"	11	-60.5550674630789	-13.1305638414553	1102	'Leste Rondoniense'	11008	'Colorado do Oeste'
1100072	"CORUMBIARA"	11	-60.9487011706614	-12.9975202364834	1102	'Leste Rondoniense'	11008	'Colorado do Oeste'
1100080	"COSTA MARQUES"	11	-64.2316539391172	-12.4360138777142	1101	'Madeira-Guaporé'	11002	'Guajará-Mirim'
1100940	"CUJUBIM"	11	-62.5871745319209	-9.37819339905712	1101	'Madeira-Guaporé'	11001	'Porto Velho'
1100098	"ESPIGAO D'OESTE"	11	-61.0201731132847	-11.5285546333473	1102	'Leste Rondoniense'	11006	'Cacoal'
1101005	"GOVERNADOR JORGE TEIXEIRA"	11	-62.7404576394632	-10.6120717726075	1102	'Leste Rondoniense'	11004	'Ji-Paraná'
1100106	"GUAJARA-MIRIM"	11	-65.3239518196923	-10.7738837406705	1101	'Madeira-Guaporé'	11002	'Guajará-Mirim'
1101104	"ITAPUA DO OESTE"	11	-63.1823370165183	-9.19187167532786	1101	'Madeira-Guaporé'	11001	'Porto Velho'
1100114	"JARU"	11	-62.4762307081317	-10.4359487678844	1102	'Leste Rondoniense'	11004	'Ji-Paraná'
1100122	"JI-PARANA"	11	-61.9450945826841	-10.882051318349	1102	'Leste Rondoniense'	11004	'Ji-Paraná'
1100130	"MACHADINHO D'OESTE"	11	-61.9995925724466	-9.42556248	1102	'Leste Rondoniense'	11003	'Ariquemes'
1101203	"MINISTRO ANDREAZZA"	11	-61.5189219301054	-11.1962379841591	1102	'Leste Rondoniense'	11006	'Cacoal'
1101302	"MIRANTE DA SERRA"	11	-62.6694270952566	-11.045609289937	1102	'Leste Rondoniense'	11004	'Ji-Paraná'
1101401	"MONTE NEGRO"	11	-63.2955591672175	-10.263097755883	1102	'Leste Rondoniense'	11003	'Ariquemes'
1100148	"NOVA BRASILANDIA D'OESTE"	11	-62.308230163019	-11.7213254138559	1102	'Leste Rondoniense'	11005	'Alvorada D''Oeste'
1100338	"NOVA MAMORE"	11	-65.3291490231467	-10.4117712947002	1101	'Madeira-Guaporé'	11001	'Porto Velho'
1101435	"NOVA UNIAO"	11	-62.55508939888	-10.9155320416628	1102	'Leste Rondoniense'	11004	'Ji-Paraná'
1100502	"NOVO HORIZONTE DO OESTE"	11	-61.9943876627606	-11.7097429200152	1102	'Leste Rondoniense'	11006	'Cacoal'
1100155	"OURO PRETO DO OESTE"	11	-62.2610551904363	-10.7235739008135	1102	'Leste Rondoniense'	11004	'Ji-Paraná'
1101450	"PARECIS"	11	-61.5979979726776	-12.1798270507077	1102	'Leste Rondoniense'	11007	'Vilhena'
1100189	"PIMENTA BUENO"	11	-61.183665673642	-11.67753699	1102	'Leste Rondoniense'	11007	'Vilhena'
1101468	"PIMENTEIRAS DO OESTE"	11	-61.0443790025384	-13.4765620024615	1102	'Leste Rondoniense'	11008	'Colorado do Oeste'
1100205	"PORTO VELHO"	11	-63.8314456543611	-8.76889179	1101	'Madeira-Guaporé'	11001	'Porto Velho'
1100254	"PRESIDENTE MEDICI"	11	-61.9094386835298	-11.1732050162268	1102	'Leste Rondoniense'	11004	'Ji-Paraná'
1101476	"PRIMAVERA DE RONDONIA"	11	-61.3165462429165	-11.8257069542468	1102	'Leste Rondoniense'	11007	'Vilhena'
1100262	"RIO CRESPO"	11	-62.9000103659589	-9.70553670973949	1102	'Leste Rondoniense'	11003	'Ariquemes'
1100288	"ROLIM DE MOURA"	11	-61.7857809351854	-11.7222589133808	1102	'Leste Rondoniense'	11006	'Cacoal'
1100296	"SANTA LUZIA D'OESTE"	11	-61.7733054630545	-11.908423332469	1102	'Leste Rondoniense'	11006	'Cacoal'
1101484	"SAO FELIPE D'OESTE"	11	-61.5125081133327	-11.9143893546886	1102	'Leste Rondoniense'	11007	'Vilhena'
1101492	"SAO FRANCISCO DO GUAPORE"	11	-63.5708647107649	-12.0637984122334	1101	'Madeira-Guaporé'	11002	'Guajará-Mirim'
1100320	"SAO MIGUEL DO GUAPORE"	11	-62.7200634814364	-11.699489743806	1102	'Leste Rondoniense'	11005	'Alvorada D''Oeste'
1101500	"SERINGUEIRAS"	11	-63.0387609977072	-11.767116635607	1102	'Leste Rondoniense'	11005	'Alvorada D''Oeste'
1101559	"TEIXEIROPOLIS"	11	-62.2559222539546	-10.9321692860399	1102	'Leste Rondoniense'	11004	'Ji-Paraná'
1101609	"THEOBROMA"	11	-62.3451455299349	-10.2487305520261	1102	'Leste Rondoniense'	11004	'Ji-Paraná'
1101708	"URUPA"	11	-62.3706324537667	-11.1285452756794	1102	'Leste Rondoniense'	11004	'Ji-Paraná'
1101757	"VALE DO ANARI"	11	-62.1768234421278	-9.85139270806179	1102	'Leste Rondoniense'	11003	'Ariquemes'
1101807	"VALE DO PARAISO"	11	-62.1343903568099	-10.4310526845565	1102	'Leste Rondoniense'	11004	'Ji-Paraná'
1100304	"VILHENA"	11	-60.1385838660987	-12.7413734718029	1102	'Leste Rondoniense'	11007	'Vilhena'
1400050	"ALTO ALEGRE"	14	-61.3140223901178	2.99382294765484	1401	'Norte de Roraima'	14001	'Boa Vista'
1400027	"AMAJARI"	14	-61.4205901726631	3.6521184454459	1401	'Norte de Roraima'	14001	'Boa Vista'
1400100	"BOA VISTA"	14	-60.6705326729651	2.81668191910439	1401	'Norte de Roraima'	14001	'Boa Vista'
1400159	"BONFIM"	14	-59.8780066289099	3.35028861911032	1401	'Norte de Roraima'	14002	'Nordeste de Roraima'
1400175	"CANTA"	14	-60.6020628476112	2.60766639841651	1401	'Norte de Roraima'	14002	'Nordeste de Roraima'
1400209	"CARACARAI"	14	-61.14917687013	1.80387124729759	1402	'Sul de Roraima'	14003	'Caracaraí'
1400233	"CAROEBE"	14	-59.6948100736757	0.872674507186562	1402	'Sul de Roraima'	14004	'Sudeste de Roraima'
1400282	"IRACEMA"	14	-61.0522585850197	2.16821476520387	1402	'Sul de Roraima'	14003	'Caracaraí'
1400308	"MUCAJAI"	14	-60.9115185306216	2.47977223505342	1402	'Sul de Roraima'	14003	'Caracaraí'
1400407	"NORMANDIA"	14	-59.6352062835683	3.88297828530181	1401	'Norte de Roraima'	14002	'Nordeste de Roraima'
1400456	"PACARAIMA"	14	-61.1473063471493	4.47525934021226	1401	'Norte de Roraima'	14001	'Boa Vista'
1400472	"RORAINOPOLIS"	14	-60.4250604939819	0.937195393597556	1402	'Sul de Roraima'	14004	'Sudeste de Roraima'
1400506	"SAO JOAO DA BALIZA"	14	-59.9060443451545	0.947157427466681	1402	'Sul de Roraima'	14004	'Sudeste de Roraima'
1400605	"SAO LUIZ"	14	-60.0282667741903	1.01811162739126	1402	'Sul de Roraima'	14004	'Sudeste de Roraima'
1400704	"UIRAMUTA"	14	-60.195716148042	4.58544038754255	1401	'Norte de Roraima'	14002	'Nordeste de Roraima'
4300034	"ACEGUA"	43	-54.1647315363634	-31.8640153042621	4306	'Sudoeste Rio-grandense'	43031	'Campanha Meridional'
4300059	"AGUA SANTA"	43	-52.0346327891623	-28.1750547485119	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4300109	"AGUDO"	43	-53.2586916877151	-29.6456633632496	4303	'Centro Ocidental Rio-grandense'	43019	'Restinga Seca'
4300208	"AJURICABA"	43	-53.7728188899873	-28.2377290066892	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4300307	"ALECRIM"	43	-54.7670962217407	-27.6610744578017	4301	'Noroeste Rio-grandense'	43001	'Santa Rosa'
4300406	"ALEGRETE"	43	-55.7958701453331	-29.7820432091245	4306	'Sudoeste Rio-grandense'	43029	'Campanha Ocidental'
4300455	"ALEGRIA"	43	-54.0573664131385	-27.8372999563703	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4300471	"ALMIRANTE TAMANDARE DO SUL"	43	-52.9137145496944	-28.1137262870376	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4300505	"ALPESTRE"	43	-53.0373660485512	-27.2487687566901	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4300554	"ALTO ALEGRE"	43	-52.9907552806891	-28.7747455370691	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4300570	"ALTO FELIZ"	43	-51.3158156678408	-29.3901391668448	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4300604	"ALVORADA"	43	-51.0777294542001	-29.9974930647423	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4300638	"AMARAL FERRADOR"	43	-52.2512703969698	-30.8751476011694	4307	'Sudeste Rio-grandense'	43032	'Serras de Sudeste'
4300646	"AMETISTA DO SUL"	43	-53.1921772619969	-27.3564254737848	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4300661	"ANDRE DA ROCHA"	43	-51.5737379712009	-28.6319772028818	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4300703	"ANTA GORDA"	43	-52.0158234394073	-28.9708843631015	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4300802	"ANTONIO PRADO"	43	-51.2835769243409	-28.8554376246298	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4300851	"ARAMBARE"	43	-51.5013182505968	-30.9093455500119	4305	'Metropolitana de Porto Alegre'	43028	'Camaquã'
4300877	"ARARICA"	43	-50.9256766146808	-29.6172435929301	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4300901	"ARATIBA"	43	-52.3038319547884	-27.3944441288949	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4301008	"ARROIO DO MEIO"	43	-51.9474494916139	-29.3988907191368	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4301073	"ARROIO DO PADRE"	43	-52.4333015044096	-31.4406439930693	4307	'Sudeste Rio-grandense'	43033	'Pelotas'
4301057	"ARROIO DO SAL"	43	-49.932957517978	-29.5929607439655	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4301206	"ARROIO DO TIGRE"	43	-53.0863955671765	-29.3358596133036	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4301107	"ARROIO DOS RATOS"	43	-51.733806866458	-30.0900131146766	4305	'Metropolitana de Porto Alegre'	43025	'São Jerônimo'
4301305	"ARROIO GRANDE"	43	-53.0822483482181	-32.2363441256672	4307	'Sudeste Rio-grandense'	43034	'Jaguarão'
4301404	"ARVOREZINHA"	43	-52.1795119395293	-28.8730493916397	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4301503	"AUGUSTO PESTANA"	43	-53.9894700807226	-28.5133519891142	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4301552	"AUREA"	43	-52.0541756691329	-27.693786650391	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4301602	"BAGE"	43	-54.10708328517	-31.3305018415475	4306	'Sudoeste Rio-grandense'	43031	'Campanha Meridional'
4301636	"BALNEARIO PINHAL"	43	-50.2367010760971	-30.2397509270339	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4301651	"BARAO"	43	-51.4975376808973	-29.3808640678083	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4301701	"BARAO DE COTEGIPE"	43	-52.3777503250275	-27.6170925671432	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4301750	"BARAO DO TRIUNFO"	43	-51.7376694748388	-30.3904838547345	4305	'Metropolitana de Porto Alegre'	43025	'São Jerônimo'
4301859	"BARRA DO GUARITA"	43	-53.7144126933058	-27.1880699614942	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4301875	"BARRA DO QUARAI"	43	-57.5570603248123	-30.2110754079216	4306	'Sudoeste Rio-grandense'	43029	'Campanha Ocidental'
4301909	"BARRA DO RIBEIRO"	43	-51.3008736006115	-30.2926754998868	4305	'Metropolitana de Porto Alegre'	43028	'Camaquã'
4301925	"BARRA DO RIO AZUL"	43	-52.4141049464501	-27.4087577154522	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4301958	"BARRA FUNDA"	43	-53.0362966696036	-27.9238258451753	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4301800	"BARRACAO"	43	-51.4601514583785	-27.6802298713897	4301	'Noroeste Rio-grandense'	43005	'Sananduva'
4302006	"BARROS CASSAL"	43	-52.5877521245	-29.0877043607385	4301	'Noroeste Rio-grandense'	43013	'Soledade'
4302055	"BENJAMIN CONSTANT DO SUL"	43	-52.6022250047219	-27.5085835626576	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4302105	"BENTO GONCALVES"	43	-51.5155603063239	-29.1674019331912	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4302154	"BOA VISTA DAS MISSOES"	43	-53.312756393758	-27.6661110350384	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4302204	"BOA VISTA DO BURICA"	43	-54.1094812552698	-27.6715669967826	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4302220	"BOA VISTA DO CADEADO"	43	-53.8137346351149	-28.5774344754805	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4302238	"BOA VISTA DO INCRA"	43	-53.3887049606029	-28.8184880340187	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4302253	"BOA VISTA DO SUL"	43	-51.6772718371373	-29.3501193714924	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4302303	"BOM JESUS"	43	-50.4333492699802	-28.6705776756427	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4302352	"BOM PRINCIPIO"	43	-51.355519097396	-29.4944851149457	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4302378	"BOM PROGRESSO"	43	-53.8667908856402	-27.5467742041554	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4302402	"BOM RETIRO DO SUL"	43	-51.9438467659586	-29.6074226198573	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4302451	"BOQUEIRAO DO LEAO"	43	-52.4280502644718	-29.3051579179085	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4302501	"BOSSOROCA"	43	-54.9098109252545	-28.7307243302239	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4302584	"BOZANO"	43	-53.7724021387641	-28.3662899401941	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4302600	"BRAGA"	43	-53.7443293820752	-27.6191925075347	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4302659	"BROCHIER"	43	-51.5889159716534	-29.5555279555572	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4302709	"BUTIA"	43	-51.9614829532158	-30.1161440126473	4305	'Metropolitana de Porto Alegre'	43025	'São Jerônimo'
4302808	"CACAPAVA DO SUL"	43	-53.4875689200414	-30.5147432340801	4307	'Sudeste Rio-grandense'	43032	'Serras de Sudeste'
4302907	"CACEQUI"	43	-54.8277276903362	-29.8802876604795	4303	'Centro Ocidental Rio-grandense'	43018	'Santa Maria'
4303004	"CACHOEIRA DO SUL"	43	-52.893412558482	-30.0458199797274	4304	'Centro Oriental Rio-grandense'	43022	'Cachoeira do Sul'
4303103	"CACHOEIRINHA"	43	-51.0936769542628	-29.9506294443447	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4303202	"CACIQUE DOBLE"	43	-51.6641134498382	-27.7682324660163	4301	'Noroeste Rio-grandense'	43005	'Sananduva'
4303301	"CAIBATE"	43	-54.6378867042087	-28.2910748191668	4301	'Noroeste Rio-grandense'	43006	'Cerro Largo'
4303400	"CAICARA"	43	-53.431895485104	-27.280940664627	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4303509	"CAMAQUA"	43	-51.8146009062211	-30.8507043892559	4305	'Metropolitana de Porto Alegre'	43028	'Camaquã'
4303558	"CAMARGO"	43	-52.2037989732514	-28.589237531547	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4303608	"CAMBARA DO SUL"	43	-50.1437653842536	-29.0481752734456	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4303673	"CAMPESTRE DA SERRA"	43	-51.0956640048374	-28.7965122468981	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4303707	"CAMPINA DAS MISSOES"	43	-54.8453289508288	-27.9916900284003	4301	'Noroeste Rio-grandense'	43006	'Cerro Largo'
4303806	"CAMPINAS DO SUL"	43	-52.6331044777763	-27.7116014161015	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4303905	"CAMPO BOM"	43	-51.0588699242785	-29.6756850971228	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4304002	"CAMPO NOVO"	43	-53.8028138686738	-27.6744926102172	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4304101	"CAMPOS BORGES"	43	-52.998914733228	-28.8921317673265	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4304200	"CANDELARIA"	43	-52.7896684388192	-29.6712854159647	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4304309	"CANDIDO GODOI"	43	-54.7528340428941	-27.951318068101	4301	'Noroeste Rio-grandense'	43001	'Santa Rosa'
4304358	"CANDIOTA"	43	-53.6778046425127	-31.5610097235535	4307	'Sudeste Rio-grandense'	43032	'Serras de Sudeste'
4304408	"CANELA"	43	-50.8148673493636	-29.3579718504151	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4304507	"CANGUCU"	43	-52.6762858320724	-31.3938595243163	4307	'Sudeste Rio-grandense'	43033	'Pelotas'
4304606	"CANOAS"	43	-51.1810297806876	-29.9186967064906	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4304614	"CANUDOS DO VALE"	43	-52.2323826172485	-29.3235252962996	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4304622	"CAPAO BONITO DO SUL"	43	-51.3951584627035	-28.1259752949248	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4304630	"CAPAO DA CANOA"	43	-50.0200224442732	-29.7614666401197	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4304655	"CAPAO DO CIPO"	43	-54.5546989999907	-28.9316275195542	4303	'Centro Ocidental Rio-grandense'	43017	'Santiago'
4304663	"CAPAO DO LEAO"	43	-52.4870075720627	-31.7668386566486	4307	'Sudeste Rio-grandense'	43033	'Pelotas'
4304689	"CAPELA DE SANTANA"	43	-51.3217693454114	-29.7019448519831	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4304697	"CAPITAO"	43	-51.9859688456389	-29.2694996085818	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4304671	"CAPIVARI DO SUL"	43	-50.5088079340934	-30.1496596629382	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4304713	"CARAA"	43	-50.4357564295696	-29.7786374562404	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4304705	"CARAZINHO"	43	-52.7918973881038	-28.2865105908949	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4304804	"CARLOS BARBOSA"	43	-51.5038176299836	-29.2982968058739	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4304853	"CARLOS GOMES"	43	-51.9175762298652	-27.7148920750864	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4304903	"CASCA"	43	-51.9832326574164	-28.5598740168421	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4304952	"CASEIROS"	43	-51.6926828223303	-28.2735654702811	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4305009	"CATUIPE"	43	-54.0123868476744	-28.2542344724617	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4305108	"CAXIAS DO SUL"	43	-51.178860205883	-29.1668990110621	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4305116	"CENTENARIO"	43	-52.0020538458457	-27.7628471303939	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4305124	"CERRITO"	43	-52.8148023322809	-31.852639126784	4307	'Sudeste Rio-grandense'	43033	'Pelotas'
4305132	"CERRO BRANCO"	43	-52.9419778017439	-29.6562871949216	4304	'Centro Oriental Rio-grandense'	43022	'Cachoeira do Sul'
4305157	"CERRO GRANDE"	43	-53.1659130764764	-27.6079801347369	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4305173	"CERRO GRANDE DO SUL"	43	-51.7531032652187	-30.6020289289506	4305	'Metropolitana de Porto Alegre'	43028	'Camaquã'
4305207	"CERRO LARGO"	43	-54.7399972398551	-28.1478408769518	4301	'Noroeste Rio-grandense'	43006	'Cerro Largo'
4305306	"CHAPADA"	43	-53.0672769044206	-28.0584504612393	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4305355	"CHARQUEADAS"	43	-51.6250060521847	-29.9568003630446	4305	'Metropolitana de Porto Alegre'	43025	'São Jerônimo'
4305371	"CHARRUA"	43	-52.0294119535135	-27.9528311010695	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4305405	"CHIAPETTA"	43	-53.9457497023822	-27.9173647540078	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4305439	"CHUI"	43	-53.4626751416843	-33.6875668687297	4307	'Sudeste Rio-grandense'	43035	'Litoral Lagunar'
4305447	"CHUVISCA"	43	-51.9785422226284	-30.7574267111909	4305	'Metropolitana de Porto Alegre'	43028	'Camaquã'
4305454	"CIDREIRA"	43	-50.2090923338719	-30.1811699861621	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4305504	"CIRIACO"	43	-51.8830312919558	-28.3443025435146	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4305587	"COLINAS"	43	-51.8685755464998	-29.3925368716088	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4305603	"COLORADO"	43	-52.9931763194633	-28.5229477598944	4301	'Noroeste Rio-grandense'	43012	'Não-Me-Toque'
4305702	"CONDOR"	43	-53.4889433308529	-28.2052957752937	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4305801	"CONSTANTINA"	43	-52.9877388321137	-27.730411086445	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4305835	"COQUEIRO BAIXO"	43	-52.0946025596403	-29.1792568012569	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4305850	"COQUEIROS DO SUL"	43	-52.7788008455504	-28.117428320628	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4305871	"CORONEL BARROS"	43	-54.0736624302888	-28.3845408586763	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4305900	"CORONEL BICACO"	43	-53.7091281065014	-27.7178730196391	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4305934	"CORONEL PILAR"	43	-51.6849345965552	-29.2727100754174	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4305959	"COTIPORA"	43	-51.6964336774026	-28.9985764275982	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4305975	"COXILHA"	43	-52.3002778295103	-28.1213417107792	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4306007	"CRISSIUMAL"	43	-54.1000349061653	-27.4980122693927	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4306056	"CRISTAL"	43	-52.0494104017764	-30.999345191822	4307	'Sudeste Rio-grandense'	43033	'Pelotas'
4306072	"CRISTAL DO SUL"	43	-53.2491844952575	-27.4536295671694	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4306106	"CRUZ ALTA"	43	-53.6052407621196	-28.6424466084891	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4306130	"CRUZALTENSE"	43	-52.6481429882271	-27.6648881085743	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4306205	"CRUZEIRO DO SUL"	43	-51.9915758851734	-29.5082909687012	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4306304	"DAVID CANABARRO"	43	-51.852249056523	-28.3846115340599	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4306320	"DERRUBADAS"	43	-53.8651194603325	-27.2653909362973	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4306353	"DEZESSEIS DE NOVEMBRO"	43	-55.0482085020399	-28.2268764434985	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4306379	"DILERMANDO DE AGUIAR"	43	-54.2135603845021	-29.7019639097539	4303	'Centro Ocidental Rio-grandense'	43018	'Santa Maria'
4306403	"DOIS IRMAOS"	43	-51.0876193130209	-29.5841587789047	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4306429	"DOIS IRMAOS DAS MISSOES"	43	-53.5308646235229	-27.6575367314489	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4306452	"DOIS LAJEADOS"	43	-51.8351029868648	-28.9752053862425	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4306502	"DOM FELICIANO"	43	-52.103933579678	-30.708598426315	4305	'Metropolitana de Porto Alegre'	43028	'Camaquã'
4306601	"DOM PEDRITO"	43	-54.6741301838236	-30.9812670567511	4306	'Sudoeste Rio-grandense'	43031	'Campanha Meridional'
4306551	"DOM PEDRO DE ALCANTARA"	43	-49.8495499617296	-29.3701870791044	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4306700	"DONA FRANCISCA"	43	-53.362333180785	-29.6248524913473	4303	'Centro Ocidental Rio-grandense'	43019	'Restinga Seca'
4306734	"DOUTOR MAURICIO CARDOSO"	43	-54.3582679905268	-27.5092126137125	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4306759	"DOUTOR RICARDO"	43	-51.9849043921162	-29.0990310609603	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4306767	"ELDORADO DO SUL"	43	-51.310418926013	-29.9992925945868	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4306809	"ENCANTADO"	43	-51.8730231343648	-29.2399172072227	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4306908	"ENCRUZILHADA DO SUL"	43	-52.5220453898558	-30.5436573247692	4307	'Sudeste Rio-grandense'	43032	'Serras de Sudeste'
4306924	"ENGENHO VELHO"	43	-52.9119205030241	-27.7085865196651	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4306957	"ENTRE RIOS DO SUL"	43	-52.7350679521256	-27.5288579316363	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4306932	"ENTRE-IJUIS"	43	-54.2714318511947	-28.3627942778995	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4306973	"EREBANGO"	43	-52.2997114029771	-27.8491959408603	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4307005	"ERECHIM"	43	-52.2758768978871	-27.633405810801	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4307054	"ERNESTINA"	43	-52.5721762088587	-28.4971546905367	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4307203	"ERVAL GRANDE"	43	-52.5701120523532	-27.3933366745076	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4307302	"ERVAL SECO"	43	-53.5095730836612	-27.5494171265095	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4307401	"ESMERALDA"	43	-51.1887936624614	-28.0572763479842	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4307450	"ESPERANCA DO SUL"	43	-53.9927678151195	-27.3599436088412	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4307500	"ESPUMOSO"	43	-52.841926970944	-28.7314451425443	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4307559	"ESTACAO"	43	-52.2704857966567	-27.9090063415288	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4307609	"ESTANCIA VELHA"	43	-51.1742939249861	-29.6501479676013	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4307708	"ESTEIO"	43	-51.143837339432	-29.852186295458	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4307807	"ESTRELA"	43	-51.9702602941755	-29.5034718768222	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4307815	"ESTRELA VELHA"	43	-53.1602937786865	-29.1796613617013	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4307831	"EUGENIO DE CASTRO"	43	-54.1481126184862	-28.5250597626107	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4307864	"FAGUNDES VARELA"	43	-51.691448747733	-28.8821343126181	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4307906	"FARROUPILHA"	43	-51.3483495737698	-29.2236791868351	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4308003	"FAXINAL DO SOTURNO"	43	-53.4390648197058	-29.5743295397707	4303	'Centro Ocidental Rio-grandense'	43019	'Restinga Seca'
4308052	"FAXINALZINHO"	43	-52.6705912421647	-27.4254155069082	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4308078	"FAZENDA VILANOVA"	43	-51.8211830446408	-29.5885745296736	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4308102	"FELIZ"	43	-51.3101021353557	-29.453970926152	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4308201	"FLORES DA CUNHA"	43	-51.1822205769359	-29.0311421436903	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4308250	"FLORIANO PEIXOTO"	43	-52.0856070999391	-27.8625092778995	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4308300	"FONTOURA XAVIER"	43	-52.3449531837753	-28.9821677891754	4301	'Noroeste Rio-grandense'	43013	'Soledade'
4308409	"FORMIGUEIRO"	43	-53.5002944149445	-29.9976338154204	4303	'Centro Ocidental Rio-grandense'	43019	'Restinga Seca'
4308433	"FORQUETINHA"	43	-52.0969170585272	-29.3806337847287	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4308458	"FORTALEZA DOS VALOS"	43	-53.2355232639118	-28.7878829709941	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4308508	"FREDERICO WESTPHALEN"	43	-53.4007767388514	-27.358882412381	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4308607	"GARIBALDI"	43	-51.5295484587997	-29.2545491128245	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4308656	"GARRUCHOS"	43	-55.6340719501045	-28.1894767900687	4306	'Sudoeste Rio-grandense'	43029	'Campanha Ocidental'
4308706	"GAURAMA"	43	-52.1001384605265	-27.5838577562615	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4308805	"GENERAL CAMARA"	43	-51.7634306851003	-29.902983741364	4305	'Metropolitana de Porto Alegre'	43025	'São Jerônimo'
4308854	"GENTIL"	43	-52.0345235699367	-28.4338484670158	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4308904	"GETULIO VARGAS"	43	-52.249574123331	-27.8759119305256	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4309001	"GIRUA"	43	-54.3508400776839	-28.0297443728968	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4309050	"GLORINHA"	43	-50.7862074318938	-29.8771339612804	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4309100	"GRAMADO"	43	-50.8719457002814	-29.3797375183577	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4309126	"GRAMADO DOS LOUREIROS"	43	-52.9182179830321	-27.444385021407	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4309159	"GRAMADO XAVIER"	43	-52.5778377569665	-29.2699362175355	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4309209	"GRAVATAI"	43	-50.9907929747741	-29.9455189133363	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4309258	"GUABIJU"	43	-51.6910473580747	-28.5406715310391	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4309308	"GUAIBA"	43	-51.3146836637248	-30.1086019223736	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4309407	"GUAPORE"	43	-51.8906506874927	-28.8491336404505	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4309506	"GUARANI DAS MISSOES"	43	-54.5605559296609	-28.1417792573454	4301	'Noroeste Rio-grandense'	43006	'Cerro Largo'
4309555	"HARMONIA"	43	-51.414039704658	-29.5490490867874	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4307104	"HERVAL"	43	-53.3943378608911	-32.0267435511585	4307	'Sudeste Rio-grandense'	43034	'Jaguarão'
4309571	"HERVEIRAS"	43	-52.6501705958055	-29.4570438109034	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4309605	"HORIZONTINA"	43	-54.3087915108958	-27.6300969136806	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4309654	"HULHA NEGRA"	43	-53.8678247940087	-31.4050982483871	4306	'Sudoeste Rio-grandense'	43031	'Campanha Meridional'
4309704	"HUMAITA"	43	-53.9765055737001	-27.5614898161207	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4309753	"IBARAMA"	43	-53.1332000129437	-29.4207443610837	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4309803	"IBIACA"	43	-51.8572520902201	-28.0488495214905	4301	'Noroeste Rio-grandense'	43005	'Sananduva'
4309902	"IBIRAIARAS"	43	-51.6353239891883	-28.3692267294479	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4309951	"IBIRAPUITA"	43	-52.5193855878489	-28.6150204151633	4301	'Noroeste Rio-grandense'	43013	'Soledade'
4310009	"IBIRUBA"	43	-53.0883540195233	-28.627607782438	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4310108	"IGREJINHA"	43	-50.7987107333217	-29.5722204557553	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4310207	"IJUI"	43	-53.918066835708	-28.3885365409849	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4310306	"ILOPOLIS"	43	-52.1221574946372	-28.9291527317996	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4310330	"IMBE"	43	-50.1305799407181	-29.97477782067	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4310363	"IMIGRANTE"	43	-51.7701905100744	-29.3521581197828	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4310405	"INDEPENDENCIA"	43	-54.1881083345896	-27.8473315580669	4301	'Noroeste Rio-grandense'	43001	'Santa Rosa'
4310413	"INHACORA"	43	-54.012545591408	-27.8804544583429	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4310439	"IPE"	43	-51.2799101922001	-28.8183280318304	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4310462	"IPIRANGA DO SUL"	43	-52.4250606441447	-27.9359842848544	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4310504	"IRAI"	43	-53.2642960185149	-27.1922819750184	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4310538	"ITAARA"	43	-53.7578492490045	-29.6028879547439	4303	'Centro Ocidental Rio-grandense'	43018	'Santa Maria'
4310553	"ITACURUBI"	43	-55.2327232640516	-28.802205033087	4303	'Centro Ocidental Rio-grandense'	43017	'Santiago'
4310579	"ITAPUCA"	43	-52.1723668452035	-28.7802957029811	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4310603	"ITAQUI"	43	-56.5571334970304	-29.1286368990609	4306	'Sudoeste Rio-grandense'	43029	'Campanha Ocidental'
4310652	"ITATI"	43	-50.1017822613948	-29.5002484954756	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4310702	"ITATIBA DO SUL"	43	-52.4524432547055	-27.3832919400558	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4310751	"IVORA"	43	-53.5808856194398	-29.5195344843337	4303	'Centro Ocidental Rio-grandense'	43019	'Restinga Seca'
4310801	"IVOTI"	43	-51.1595741943299	-29.5941565228625	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4310850	"JABOTICABA"	43	-53.2843894020471	-27.631222386294	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4310876	"JACUIZINHO"	43	-53.0565506587969	-29.0338163561117	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4310900	"JACUTINGA"	43	-52.5431728064303	-27.7284936335667	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4311007	"JAGUARAO"	43	-53.3775229153129	-32.563568668515	4307	'Sudeste Rio-grandense'	43034	'Jaguarão'
4311106	"JAGUARI"	43	-54.6938466713292	-29.4973467312154	4303	'Centro Ocidental Rio-grandense'	43018	'Santa Maria'
4311122	"JAQUIRANA"	43	-50.3580367222002	-28.8805675913494	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4311130	"JARI"	43	-54.2199358202821	-29.2900810968405	4303	'Centro Ocidental Rio-grandense'	43017	'Santiago'
4311155	"JOIA"	43	-54.1159648970211	-28.645623534628	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4311205	"JULIO DE CASTILHOS"	43	-53.683099614611	-29.2264491192748	4303	'Centro Ocidental Rio-grandense'	43017	'Santiago'
4311239	"LAGOA BONITA DO SUL"	43	-53.0169831807835	-29.4941314004424	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4311270	"LAGOA DOS TRES CANTOS"	43	-52.8578352424045	-28.569468132747	4301	'Noroeste Rio-grandense'	43012	'Não-Me-Toque'
4311304	"LAGOA VERMELHA"	43	-51.5272285291447	-28.2088702462124	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4311254	"LAGOAO"	43	-52.7750289082597	-29.2243164011489	4301	'Noroeste Rio-grandense'	43013	'Soledade'
4311403	"LAJEADO"	43	-51.9678277005001	-29.465454402471	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4311429	"LAJEADO DO BUGRE"	43	-53.1813871337597	-27.6907694083803	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4311502	"LAVRAS DO SUL"	43	-53.8984766554676	-30.8120099930395	4306	'Sudoeste Rio-grandense'	43031	'Campanha Meridional'
4311601	"LIBERATO SALZANO"	43	-53.0748607372178	-27.5964701638556	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4311627	"LINDOLFO COLLOR"	43	-51.2081553215577	-29.6008035857933	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4311643	"LINHA NOVA"	43	-51.2019020947684	-29.4626386025506	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4311718	"MACAMBARA"	43	-56.0636134817356	-29.1461441991842	4306	'Sudoeste Rio-grandense'	43029	'Campanha Ocidental'
4311700	"MACHADINHO"	43	-51.6675073604692	-27.5681399699086	4301	'Noroeste Rio-grandense'	43005	'Sananduva'
4311734	"MAMPITUBA"	43	-49.9365135523956	-29.2106494197245	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4311759	"MANOEL VIANA"	43	-55.491662539453	-29.5805371826454	4306	'Sudoeste Rio-grandense'	43029	'Campanha Ocidental'
4311775	"MAQUINE"	43	-50.2033948126293	-29.6791370128964	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4311791	"MARATA"	43	-51.5555668832642	-29.555322967598	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4311809	"MARAU"	43	-52.1967769340001	-28.4484539272764	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4311908	"MARCELINO RAMOS"	43	-51.9133189437274	-27.4613912128695	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4311981	"MARIANA PIMENTEL"	43	-51.5873429914433	-30.3536222023384	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4312005	"MARIANO MORO"	43	-52.148891817328	-27.3526127883475	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4312054	"MARQUES DE SOUZA"	43	-52.0978044284152	-29.3291373440536	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4312104	"MATA"	43	-54.4524354819352	-29.5693917755536	4303	'Centro Ocidental Rio-grandense'	43018	'Santa Maria'
4312138	"MATO CASTELHANO"	43	-52.1972608812043	-28.275761741248	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4312153	"MATO LEITAO"	43	-52.1330293263325	-29.5248303377978	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4312179	"MATO QUEIMADO"	43	-54.6168368777268	-28.2558159870126	4301	'Noroeste Rio-grandense'	43006	'Cerro Largo'
4312203	"MAXIMILIANO DE ALMEIDA"	43	-51.8017181970059	-27.6349406517609	4301	'Noroeste Rio-grandense'	43005	'Sananduva'
4312252	"MINAS DO LEAO"	43	-52.0512801985772	-30.1224395107247	4305	'Metropolitana de Porto Alegre'	43025	'São Jerônimo'
4312302	"MIRAGUAI"	43	-53.6859940447681	-27.4960764230659	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4312351	"MONTAURI"	43	-52.0761081911119	-28.6532071850553	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4312377	"MONTE ALEGRE DOS CAMPOS"	43	-50.7828337051116	-28.6850717757186	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4312385	"MONTE BELO DO SUL"	43	-51.6315592453903	-29.1599412231295	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4312401	"MONTENEGRO"	43	-51.4612993756819	-29.6881186098638	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4312427	"MORMACO"	43	-52.6928263150565	-28.6933512202192	4301	'Noroeste Rio-grandense'	43013	'Soledade'
4312443	"MORRINHOS DO SUL"	43	-49.932762974333	-29.3629636300424	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4312450	"MORRO REDONDO"	43	-52.6577802013945	-31.5822032274461	4307	'Sudeste Rio-grandense'	43033	'Pelotas'
4312476	"MORRO REUTER"	43	-51.0800883478072	-29.5393416585882	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4312500	"MOSTARDAS"	43	-50.9191588510717	-31.1082251074075	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4312609	"MUCUM"	43	-51.8660555260518	-29.1656148145796	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4312617	"MUITOS CAPOES"	43	-51.1846023448957	-28.3189128014806	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4312625	"MULITERNO"	43	-51.7687012353332	-28.3302653562743	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4312658	"NAO-ME-TOQUE"	43	-52.8192794924234	-28.4599067658751	4301	'Noroeste Rio-grandense'	43012	'Não-Me-Toque'
4312674	"NICOLAU VERGUEIRO"	43	-52.4624006731904	-28.5362148138665	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4312708	"NONOAI"	43	-52.7761885672359	-27.3546645324847	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4312757	"NOVA ALVORADA"	43	-52.1671339172913	-28.6765644327978	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4312807	"NOVA ARACA"	43	-51.7421646339673	-28.6581760370725	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4312906	"NOVA BASSANO"	43	-51.7032314173958	-28.7234686416168	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4312955	"NOVA BOA VISTA"	43	-52.9814768438008	-27.9879676591236	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4313003	"NOVA BRESCIA"	43	-52.0179835406116	-29.2165114325477	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4313011	"NOVA CANDELARIA"	43	-54.1041142397608	-27.6120981609471	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4313037	"NOVA ESPERANCA DO SUL"	43	-54.8358729018542	-29.4045957086276	4303	'Centro Ocidental Rio-grandense'	43018	'Santa Maria'
4313060	"NOVA HARTZ"	43	-50.9037934307384	-29.5857475329704	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4313086	"NOVA PADUA"	43	-51.306824642212	-29.0300464452855	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4313102	"NOVA PALMA"	43	-53.4706351108828	-29.4730257379506	4303	'Centro Ocidental Rio-grandense'	43019	'Restinga Seca'
4313201	"NOVA PETROPOLIS"	43	-51.1069539239561	-29.3762088694351	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4313300	"NOVA PRATA"	43	-51.6089956920177	-28.7839447131901	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4313334	"NOVA RAMADA"	43	-53.7069373378916	-28.0826448724052	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4313359	"NOVA ROMA DO SUL"	43	-51.4051574749651	-28.9847489120484	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4313375	"NOVA SANTA RITA"	43	-51.2752106890133	-29.8486155356247	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4313490	"NOVO BARREIRO"	43	-53.1134988510144	-27.9067884670258	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4313391	"NOVO CABRAIS"	43	-52.9550860641314	-29.7362546057332	4304	'Centro Oriental Rio-grandense'	43022	'Cachoeira do Sul'
4313409	"NOVO HAMBURGO"	43	-51.1286052776319	-29.6863260251772	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4313425	"NOVO MACHADO"	43	-54.5033844145301	-27.5784006505782	4301	'Noroeste Rio-grandense'	43001	'Santa Rosa'
4313441	"NOVO TIRADENTES"	43	-53.1857025890656	-27.5635584344757	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4313466	"NOVO XINGU"	43	-53.0641092994744	-27.7481146921356	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4313508	"OSORIO"	43	-50.2667978126156	-29.8926970775174	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4313607	"PAIM FILHO"	43	-51.7615966409461	-27.7033080739322	4301	'Noroeste Rio-grandense'	43005	'Sananduva'
4313656	"PALMARES DO SUL"	43	-50.5060519722618	-30.2600666451319	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4313706	"PALMEIRA DAS MISSOES"	43	-53.3149539105514	-27.9006208754318	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4313805	"PALMITINHO"	43	-53.5555460129883	-27.3560199139378	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4313904	"PANAMBI"	43	-53.5002651674453	-28.2927305369249	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4313953	"PANTANO GRANDE"	43	-52.373900235302	-30.194551527175	4304	'Centro Oriental Rio-grandense'	43022	'Cachoeira do Sul'
4314001	"PARAI"	43	-51.7820960450567	-28.5996205337326	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4314027	"PARAISO DO SUL"	43	-53.1791002389546	-29.7313142401478	4304	'Centro Oriental Rio-grandense'	43022	'Cachoeira do Sul'
4314035	"PARECI NOVO"	43	-51.3988696583788	-29.6393892914087	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4314050	"PAROBE"	43	-50.8348659023274	-29.6317492776321	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4314068	"PASSA SETE"	43	-52.9639832352128	-29.4516655688988	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4314076	"PASSO DO SOBRADO"	43	-52.2787581943227	-29.745793549977	4304	'Centro Oriental Rio-grandense'	43022	'Cachoeira do Sul'
4314100	"PASSO FUNDO"	43	-52.4070950926172	-28.2617671279049	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4314134	"PAULO BENTO"	43	-52.4224356311043	-27.704100282708	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4314159	"PAVERAMA"	43	-51.7302929671505	-29.5548561399363	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4314175	"PEDRAS ALTAS"	43	-53.5871703196396	-31.733636939471	4307	'Sudeste Rio-grandense'	43032	'Serras de Sudeste'
4314209	"PEDRO OSORIO"	43	-52.8263117339326	-31.8638282218118	4307	'Sudeste Rio-grandense'	43033	'Pelotas'
4314308	"PEJUCARA"	43	-53.6565423317737	-28.4215860641583	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4314407	"PELOTAS"	43	-52.3443200629915	-31.7195978808292	4307	'Sudeste Rio-grandense'	43033	'Pelotas'
4314423	"PICADA CAFE"	43	-51.064049820262	-29.4543844430519	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4314456	"PINHAL"	43	-53.2147061788915	-27.5116742434576	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4314464	"PINHAL DA SERRA"	43	-51.170102723734	-27.8766645867712	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4314472	"PINHAL GRANDE"	43	-53.3386383371448	-29.3353601289161	4303	'Centro Ocidental Rio-grandense'	43017	'Santiago'
4314498	"PINHEIRINHO DO VALE"	43	-53.6195609569296	-27.2097627892597	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4314506	"PINHEIRO MACHADO"	43	-53.3846199682774	-31.5805926686944	4307	'Sudeste Rio-grandense'	43032	'Serras de Sudeste'
4314548	"PINTO BANDEIRA"	43	-51.45221544	-29.09692337	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4314555	"PIRAPO"	43	-55.2003099472118	-28.0453158376278	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4314605	"PIRATINI"	43	-53.1047344539722	-31.4441124733536	4307	'Sudeste Rio-grandense'	43032	'Serras de Sudeste'
4314704	"PLANALTO"	43	-53.058880813139	-27.3314638754662	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4314753	"POCO DAS ANTAS"	43	-51.670890273323	-29.4545464778304	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4314779	"PONTAO"	43	-52.6753994466165	-28.0618408393643	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4314787	"PONTE PRETA"	43	-52.4902319212427	-27.6570399700736	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4314803	"PORTAO"	43	-51.2301496442457	-29.6962586011397	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4314902	"PORTO ALEGRE"	43	-51.2286604637023	-30.0300367747664	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4315008	"PORTO LUCENA"	43	-55.0115620452524	-27.8513751159726	4301	'Noroeste Rio-grandense'	43001	'Santa Rosa'
4315057	"PORTO MAUA"	43	-54.671951891498	-27.5786353600571	4301	'Noroeste Rio-grandense'	43001	'Santa Rosa'
4315073	"PORTO VERA CRUZ"	43	-54.8990318240447	-27.7343739194085	4301	'Noroeste Rio-grandense'	43001	'Santa Rosa'
4315107	"PORTO XAVIER"	43	-55.139560262016	-27.9056898469343	4301	'Noroeste Rio-grandense'	43006	'Cerro Largo'
4315131	"POUSO NOVO"	43	-52.2108697395067	-29.1697612523235	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4315149	"PRESIDENTE LUCENA"	43	-51.1815996950517	-29.5261270681801	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4315156	"PROGRESSO"	43	-52.3017166029489	-29.2403086781211	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4315172	"PROTASIO ALVES"	43	-51.4736316972583	-28.7567128311852	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4315206	"PUTINGA"	43	-52.1599106947089	-28.9987556541311	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4315305	"QUARAI"	43	-56.4536470403836	-30.3828679608813	4306	'Sudoeste Rio-grandense'	43029	'Campanha Ocidental'
4315313	"QUATRO IRMAOS"	43	-52.4427686045062	-27.8211966886801	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4315321	"QUEVEDOS"	43	-54.0712547223508	-29.3519213499725	4303	'Centro Ocidental Rio-grandense'	43017	'Santiago'
4315354	"QUINZE DE NOVEMBRO"	43	-53.0967220567818	-28.7423613499233	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4315404	"REDENTORA"	43	-53.6419336939954	-27.6615398826699	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4315453	"RELVADO"	43	-52.0729485542966	-29.1122786661256	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4315503	"RESTINGA SECA"	43	-53.3705685765474	-29.8139485366989	4303	'Centro Ocidental Rio-grandense'	43019	'Restinga Seca'
4315552	"RIO DOS INDIOS"	43	-52.8400578928292	-27.2983975952198	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4315602	"RIO GRANDE"	43	-52.0867696991135	-32.0504457926525	4307	'Sudeste Rio-grandense'	43035	'Litoral Lagunar'
4315701	"RIO PARDO"	43	-52.3790182512363	-29.9856258786533	4304	'Centro Oriental Rio-grandense'	43022	'Cachoeira do Sul'
4315750	"RIOZINHO"	43	-50.4738181137863	-29.6422860137917	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4315800	"ROCA SALES"	43	-51.863891759922	-29.2850700737134	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4315909	"RODEIO BONITO"	43	-53.1685306043438	-27.4704034354621	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4315958	"ROLADOR"	43	-54.8194269754104	-28.256344217328	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4316006	"ROLANTE"	43	-50.5734423345883	-29.6407628899966	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4316105	"RONDA ALTA"	43	-52.8065335255691	-27.7819313528667	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4316204	"RONDINHA"	43	-52.9061601564804	-27.8318159703692	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4316303	"ROQUE GONZALES"	43	-55.0291861243459	-28.135366986895	4301	'Noroeste Rio-grandense'	43006	'Cerro Largo'
4316402	"ROSARIO DO SUL"	43	-54.9457608552519	-30.2440332378098	4306	'Sudoeste Rio-grandense'	43030	'Campanha Central'
4316428	"SAGRADA FAMILIA"	43	-53.1356517180311	-27.7067309905016	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4316436	"SALDANHA MARINHO"	43	-53.0941072015607	-28.4032861706865	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4316451	"SALTO DO JACUI"	43	-53.2133096524064	-29.0886812478169	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4316477	"SALVADOR DAS MISSOES"	43	-54.8377420188123	-28.121697445134	4301	'Noroeste Rio-grandense'	43006	'Cerro Largo'
4316501	"SALVADOR DO SUL"	43	-51.5094214594765	-29.4397322208801	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4316600	"SANANDUVA"	43	-51.8135019139456	-27.9440065101962	4301	'Noroeste Rio-grandense'	43005	'Sananduva'
4317103	"SANT' ANA DO LIVRAMENTO"	43	-55.5348142679597	-30.8893840112129	4306	'Sudoeste Rio-grandense'	43030	'Campanha Central'
4316709	"SANTA BARBARA DO SUL"	43	-53.2505267075504	-28.3651668167465	4301	'Noroeste Rio-grandense'	43011	'Cruz Alta'
4316733	"SANTA CECILIA DO SUL"	43	-51.9266712610956	-28.1644511049731	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4316758	"SANTA CLARA DO SUL"	43	-52.0809258239316	-29.4635962109187	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4316808	"SANTA CRUZ DO SUL"	43	-52.4299285873704	-29.7197684337466	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4316972	"SANTA MARGARIDA DO SUL"	43	-54.0909546703586	-30.3451034509105	4306	'Sudoeste Rio-grandense'	43030	'Campanha Central'
4316907	"SANTA MARIA"	43	-53.8086753946629	-29.6855818035457	4303	'Centro Ocidental Rio-grandense'	43018	'Santa Maria'
4316956	"SANTA MARIA DO HERVAL"	43	-50.9872554093643	-29.5035155387999	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4317202	"SANTA ROSA"	43	-54.4782240987609	-27.866749798923	4301	'Noroeste Rio-grandense'	43001	'Santa Rosa'
4317251	"SANTA TEREZA"	43	-51.7343442423989	-29.1716344398725	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4317301	"SANTA VITORIA DO PALMAR"	43	-53.3670063807333	-33.5198600306947	4307	'Sudeste Rio-grandense'	43035	'Litoral Lagunar'
4317004	"SANTANA DA BOA VISTA"	43	-53.1158749986991	-30.8747025739616	4307	'Sudeste Rio-grandense'	43032	'Serras de Sudeste'
4317400	"SANTIAGO"	43	-54.8690758537886	-29.1914601708944	4303	'Centro Ocidental Rio-grandense'	43017	'Santiago'
4317509	"SANTO ANGELO"	43	-54.2641427984269	-28.3019378733474	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4317608	"SANTO ANTONIO DA PATRULHA"	43	-50.5209859366778	-29.8320340169251	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4317707	"SANTO ANTONIO DAS MISSOES"	43	-55.2245566426344	-28.5080969775918	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4317558	"SANTO ANTONIO DO PALMA"	43	-52.0246330595594	-28.4974451045296	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4317756	"SANTO ANTONIO DO PLANALTO"	43	-52.6837258444323	-28.3959289066311	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4317806	"SANTO AUGUSTO"	43	-53.7788495982932	-27.8534907764033	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4317905	"SANTO CRISTO"	43	-54.6687478952904	-27.8199297346011	4301	'Noroeste Rio-grandense'	43001	'Santa Rosa'
4317954	"SANTO EXPEDITO DO SUL"	43	-51.6435721743256	-27.9093694246144	4301	'Noroeste Rio-grandense'	43005	'Sananduva'
4318002	"SAO BORJA"	43	-56.0010291536185	-28.6628375266947	4306	'Sudoeste Rio-grandense'	43029	'Campanha Ocidental'
4318051	"SAO DOMINGOS DO SUL"	43	-51.8931867141812	-28.5317631267992	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4318101	"SAO FRANCISCO DE ASSIS"	43	-55.1323857402451	-29.5527159067382	4306	'Sudoeste Rio-grandense'	43029	'Campanha Ocidental'
4318200	"SAO FRANCISCO DE PAULA"	43	-50.5821081078304	-29.4440980747993	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4318309	"SAO GABRIEL"	43	-54.3204778581076	-30.3367600548515	4306	'Sudoeste Rio-grandense'	43030	'Campanha Central'
4318408	"SAO JERONIMO"	43	-51.7281775032404	-29.959438664805	4305	'Metropolitana de Porto Alegre'	43025	'São Jerônimo'
4318424	"SAO JOAO DA URTIGA"	43	-51.8258385475929	-27.8266899655136	4301	'Noroeste Rio-grandense'	43005	'Sananduva'
4318432	"SAO JOAO DO POLESINE"	43	-53.4463504348062	-29.6146764163643	4303	'Centro Ocidental Rio-grandense'	43019	'Restinga Seca'
4318440	"SAO JORGE"	43	-51.7029685893393	-28.4980809710014	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4318457	"SAO JOSE DAS MISSOES"	43	-53.1187752690111	-27.7781833180516	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4318465	"SAO JOSE DO HERVAL"	43	-52.2930164741218	-29.0414470213399	4301	'Noroeste Rio-grandense'	43013	'Soledade'
4318481	"SAO JOSE DO HORTENCIO"	43	-51.2495975571438	-29.5400486073189	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4318499	"SAO JOSE DO INHACORA"	43	-54.133550202739	-27.722584567332	4301	'Noroeste Rio-grandense'	43001	'Santa Rosa'
4318507	"SAO JOSE DO NORTE"	43	-52.0342022719838	-32.0206091127381	4307	'Sudeste Rio-grandense'	43035	'Litoral Lagunar'
4318606	"SAO JOSE DO OURO"	43	-51.5947676779911	-27.771255406485	4301	'Noroeste Rio-grandense'	43005	'Sananduva'
4318614	"SAO JOSE DO SUL"	43	-51.4863838306853	-29.5434695178158	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4318622	"SAO JOSE DOS AUSENTES"	43	-50.0636129376329	-28.7499064320338	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4318705	"SAO LEOPOLDO"	43	-51.1462345615722	-29.7658665423851	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4318804	"SAO LOURENCO DO SUL"	43	-51.9769152357623	-31.3640237211512	4307	'Sudeste Rio-grandense'	43033	'Pelotas'
4318903	"SAO LUIZ GONZAGA"	43	-54.9596595493639	-28.4066469530094	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4319000	"SAO MARCOS"	43	-51.0667069382632	-28.9698486394212	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4319109	"SAO MARTINHO"	43	-53.9669227230418	-27.7089288021284	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4319125	"SAO MARTINHO DA SERRA"	43	-53.8542256318643	-29.5348505683156	4303	'Centro Ocidental Rio-grandense'	43018	'Santa Maria'
4319158	"SAO MIGUEL DAS MISSOES"	43	-54.5615630937001	-28.5495371215131	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4319208	"SAO NICOLAU"	43	-55.260100232028	-28.1821546933056	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4319307	"SAO PAULO DAS MISSOES"	43	-54.9347083422524	-28.0204849099622	4301	'Noroeste Rio-grandense'	43006	'Cerro Largo'
4319356	"SAO PEDRO DA SERRA"	43	-51.514326527241	-29.4214298420035	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4319364	"SAO PEDRO DAS MISSOES"	43	-53.2473689788526	-27.771308460749	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4319372	"SAO PEDRO DO BUTIA"	43	-54.8882559534463	-28.1243539018421	4301	'Noroeste Rio-grandense'	43006	'Cerro Largo'
4319406	"SAO PEDRO DO SUL"	43	-54.1799912875495	-29.6175307561941	4303	'Centro Ocidental Rio-grandense'	43018	'Santa Maria'
4319505	"SAO SEBASTIAO DO CAI"	43	-51.3766648242451	-29.5920803307578	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4319604	"SAO SEPE"	43	-53.5696441253718	-30.1674113897135	4303	'Centro Ocidental Rio-grandense'	43018	'Santa Maria'
4319703	"SAO VALENTIM"	43	-52.5284789422219	-27.5543183312228	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4319711	"SAO VALENTIM DO SUL"	43	-51.769670539141	-29.0512275281257	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4319737	"SAO VALERIO DO SUL"	43	-53.9355261513435	-27.7877181698841	4301	'Noroeste Rio-grandense'	43008	'Ijuí'
4319752	"SAO VENDELINO"	43	-51.3686527562625	-29.3758099571721	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4319802	"SAO VICENTE DO SUL"	43	-54.6760020162093	-29.6920608344659	4303	'Centro Ocidental Rio-grandense'	43018	'Santa Maria'
4319901	"SAPIRANGA"	43	-51.0036229878238	-29.6385541176145	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4320008	"SAPUCAIA DO SUL"	43	-51.1518747155206	-29.8248680325854	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4320107	"SARANDI"	43	-52.9254610594471	-27.9435951779041	4301	'Noroeste Rio-grandense'	43009	'Carazinho'
4320206	"SEBERI"	43	-53.4054673035279	-27.4804138165262	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4320230	"SEDE NOVA"	43	-53.9558847238338	-27.6311628724795	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4320263	"SEGREDO"	43	-52.9820736412151	-29.3426184273269	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4320305	"SELBACH"	43	-52.9565252738362	-28.6274338066309	4301	'Noroeste Rio-grandense'	43012	'Não-Me-Toque'
4320321	"SENADOR SALGADO FILHO"	43	-54.5454030325181	-28.0274895013966	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4320354	"SENTINELA DO SUL"	43	-51.5779817748104	-30.6133025970454	4305	'Metropolitana de Porto Alegre'	43028	'Camaquã'
4320404	"SERAFINA CORREA"	43	-51.9357086099403	-28.7107970714072	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4320453	"SERIO"	43	-52.267455830945	-29.3867600898773	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4320503	"SERTAO"	43	-52.2597378611455	-27.9807735548475	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4320552	"SERTAO SANTANA"	43	-51.6042499160429	-30.4654278903326	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4320578	"SETE DE SETEMBRO"	43	-54.4636861823155	-28.130416323371	4301	'Noroeste Rio-grandense'	43006	'Cerro Largo'
4320602	"SEVERIANO DE ALMEIDA"	43	-52.120656296054	-27.4327929836269	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4320651	"SILVEIRA MARTINS"	43	-53.5852374736119	-29.6452500585474	4303	'Centro Ocidental Rio-grandense'	43019	'Restinga Seca'
4320677	"SINIMBU"	43	-52.5216363086253	-29.5290681570186	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4320701	"SOBRADINHO"	43	-53.0251679436161	-29.4147731341294	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4320800	"SOLEDADE"	43	-52.5098661711662	-28.8277379536692	4301	'Noroeste Rio-grandense'	43013	'Soledade'
4320859	"TABAI"	43	-51.7274751185081	-29.6877706241648	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4320909	"TAPEJARA"	43	-52.0221325276641	-28.084171059706	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4321006	"TAPERA"	43	-52.8714671740768	-28.6249501911655	4301	'Noroeste Rio-grandense'	43012	'Não-Me-Toque'
4321105	"TAPES"	43	-51.3944987057586	-30.673172903847	4305	'Metropolitana de Porto Alegre'	43028	'Camaquã'
4321204	"TAQUARA"	43	-50.7811686192558	-29.6505131042758	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4321303	"TAQUARI"	43	-51.8627764842002	-29.8028008516735	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4321329	"TAQUARUCU DO SUL"	43	-53.4669519596144	-27.3980360509079	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4321352	"TAVARES"	43	-51.0888429815162	-31.2887026583166	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4321402	"TENENTE PORTELA"	43	-53.7572696148981	-27.3721669191145	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4321436	"TERRA DE AREIA"	43	-50.0672491456318	-29.5775485680459	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4321451	"TEUTONIA"	43	-51.8128168705993	-29.4889144363945	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4321469	"TIO HUGO"	43	-52.593046116066	-28.5804960165544	4301	'Noroeste Rio-grandense'	43012	'Não-Me-Toque'
4321477	"TIRADENTES DO SUL"	43	-54.0853922050406	-27.396898884195	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4321493	"TOROPI"	43	-54.2280109967382	-29.4721417007548	4303	'Centro Ocidental Rio-grandense'	43018	'Santa Maria'
4321501	"TORRES"	43	-49.7304044945034	-29.3359306143356	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4321600	"TRAMANDAI"	43	-50.1303765006803	-29.9873019471826	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4321626	"TRAVESSEIRO"	43	-52.05777726813	-29.2990858097554	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4321634	"TRES ARROIOS"	43	-52.14985207427	-27.4995162183877	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4321667	"TRES CACHOEIRAS"	43	-49.9156392761957	-29.445886590417	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4321709	"TRES COROAS"	43	-50.7831258357971	-29.5166609789895	4305	'Metropolitana de Porto Alegre'	43024	'Gramado-Canela'
4321808	"TRES DE MAIO"	43	-54.2353022075467	-27.7796602188975	4301	'Noroeste Rio-grandense'	43001	'Santa Rosa'
4321832	"TRES FORQUILHAS"	43	-50.0643164805228	-29.5381105462902	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4321857	"TRES PALMEIRAS"	43	-52.8437143501482	-27.6175274499814	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4321907	"TRES PASSOS"	43	-53.9296989580111	-27.4561598838426	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4321956	"TRINDADE DO SUL"	43	-52.8922310209657	-27.5175759348321	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4322004	"TRIUNFO"	43	-51.7153128356961	-29.9452042660447	4305	'Metropolitana de Porto Alegre'	43025	'São Jerônimo'
4322103	"TUCUNDUVA"	43	-54.4331286688342	-27.6500599333578	4301	'Noroeste Rio-grandense'	43001	'Santa Rosa'
4322152	"TUNAS"	43	-52.9570131055336	-29.1064397188461	4301	'Noroeste Rio-grandense'	43013	'Soledade'
4322186	"TUPANCI DO SUL"	43	-51.5405390116847	-27.9257114659323	4301	'Noroeste Rio-grandense'	43005	'Sananduva'
4322202	"TUPANCIRETA"	43	-53.8406300553464	-29.077479730048	4303	'Centro Ocidental Rio-grandense'	43017	'Santiago'
4322251	"TUPANDI"	43	-51.4198254297357	-29.4879128148686	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4322301	"TUPARENDI"	43	-54.4785080753273	-27.7540889272986	4301	'Noroeste Rio-grandense'	43001	'Santa Rosa'
4322327	"TURUCU"	43	-52.1714156210008	-31.4123658570916	4307	'Sudeste Rio-grandense'	43033	'Pelotas'
4322343	"UBIRETAMA"	43	-54.6845107762281	-28.0435647657327	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4322350	"UNIAO DA SERRA"	43	-52.0004166642532	-28.7798985678317	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4322376	"UNISTALDA"	43	-55.1507805181379	-29.0474850255841	4303	'Centro Ocidental Rio-grandense'	43017	'Santiago'
4322400	"URUGUAIANA"	43	-57.0818249090229	-29.7598231720144	4306	'Sudoeste Rio-grandense'	43029	'Campanha Ocidental'
4322509	"VACARIA"	43	-50.9365991641211	-28.5023543951864	4302	'Nordeste Rio-grandense'	43015	'Vacaria'
4322533	"VALE DO SOL"	43	-52.6813545006574	-29.608827986549	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4322541	"VALE REAL"	43	-51.251196564827	-29.3922806174208	4305	'Metropolitana de Porto Alegre'	43023	'Montenegro'
4322525	"VALE VERDE"	43	-52.1797223009284	-29.782574939641	4305	'Metropolitana de Porto Alegre'	43025	'São Jerônimo'
4322558	"VANINI"	43	-51.8446581973908	-28.4762225149757	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4322608	"VENANCIO AIRES"	43	-52.1918802404895	-29.6116528926556	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4322707	"VERA CRUZ"	43	-52.5011034071041	-29.7198575940345	4304	'Centro Oriental Rio-grandense'	43020	'Santa Cruz do Sul'
4322806	"VERANOPOLIS"	43	-51.5522869044647	-28.9339573362745	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4322855	"VESPASIANO CORREA"	43	-51.8594699501021	-29.069894355791	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4322905	"VIADUTOS"	43	-52.0237987496513	-27.5709530600841	4301	'Noroeste Rio-grandense'	43004	'Erechim'
4323002	"VIAMAO"	43	-51.024820489573	-30.0818968409399	4305	'Metropolitana de Porto Alegre'	43026	'Porto Alegre'
4323101	"VICENTE DUTRA"	43	-53.4021290554094	-27.1684450441447	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4323200	"VICTOR GRAEFF"	43	-52.7477917888999	-28.5601846251484	4301	'Noroeste Rio-grandense'	43012	'Não-Me-Toque'
4323309	"VILA FLORES"	43	-51.5495890891784	-28.8630001302505	4302	'Nordeste Rio-grandense'	43016	'Caxias do Sul'
4323358	"VILA LANGARO"	43	-52.1469033571178	-28.1074051987607	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4323408	"VILA MARIA"	43	-52.1635378990709	-28.5333142349985	4301	'Noroeste Rio-grandense'	43010	'Passo Fundo'
4323457	"VILA NOVA DO SUL"	43	-53.879196483097	-30.333958689168	4303	'Centro Ocidental Rio-grandense'	43018	'Santa Maria'
4323507	"VISTA ALEGRE"	43	-53.4924104661248	-27.3700841700745	4301	'Noroeste Rio-grandense'	43003	'Frederico Westphalen'
4323606	"VISTA ALEGRE DO PRATA"	43	-51.7862084024789	-28.8094722969115	4302	'Nordeste Rio-grandense'	43014	'Guaporé'
4323705	"VISTA GAUCHA"	43	-53.7013197816331	-27.2899783753413	4301	'Noroeste Rio-grandense'	43002	'Três Passos'
4323754	"VITORIA DAS MISSOES"	43	-54.4990548870704	-28.3523872492512	4301	'Noroeste Rio-grandense'	43007	'Santo Ângelo'
4323770	"WESTFALIA"	43	-51.7661555137498	-29.423449549901	4304	'Centro Oriental Rio-grandense'	43021	'Lajeado-Estrela'
4323804	"XANGRI-LA"	43	-50.0390814237967	-29.8053781854105	4305	'Metropolitana de Porto Alegre'	43027	'Osório'
4200051	"ABDON BATISTA"	42	-51.0252722110367	-27.6089871233363	4203	'Serrana'	42009	'Curitibanos'
4200101	"ABELARDO LUZ"	42	-52.3364823833237	-26.5630310224445	4201	'Oeste Catarinense'	42003	'Xanxerê'
4200200	"AGROLANDIA"	42	-49.8256533877284	-27.4005165879985	4204	'Vale do Itajaí'	42014	'Ituporanga'
4200309	"AGRONOMICA"	42	-49.7183688907554	-27.2697161071454	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4200408	"AGUA DOCE"	42	-51.5590965552946	-27.0040916588601	4201	'Oeste Catarinense'	42004	'Joaçaba'
4200507	"AGUAS DE CHAPECO"	42	-52.9872510056855	-27.0762129124757	4201	'Oeste Catarinense'	42002	'Chapecó'
4200556	"AGUAS FRIAS"	42	-52.8594194493505	-26.8802275430245	4201	'Oeste Catarinense'	42002	'Chapecó'
4200606	"AGUAS MORNAS"	42	-48.8405384028278	-27.7065971917498	4205	'Grande Florianópolis'	42017	'Tabuleiro'
4200705	"ALFREDO WAGNER"	42	-49.3438123011528	-27.7053963320374	4205	'Grande Florianópolis'	42017	'Tabuleiro'
4200754	"ALTO BELA VISTA"	42	-51.9110368540592	-27.4311378753286	4201	'Oeste Catarinense'	42005	'Concórdia'
4200804	"ANCHIETA"	42	-53.333270177229	-26.5356808606572	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4200903	"ANGELINA"	42	-48.9834760642254	-27.582257352064	4205	'Grande Florianópolis'	42015	'Tijucas'
4201000	"ANITA GARIBALDI"	42	-51.1311938712633	-27.6837772900554	4203	'Serrana'	42010	'Campos de Lages'
4201109	"ANITAPOLIS"	42	-49.1315993662195	-27.9098868973331	4205	'Grande Florianópolis'	42017	'Tabuleiro'
4201208	"ANTONIO CARLOS"	42	-48.7649600267553	-27.5133710516314	4205	'Grande Florianópolis'	42016	'Florianópolis'
4201257	"APIUNA"	42	-49.3916376287528	-27.041812598125	4204	'Vale do Itajaí'	42012	'Blumenau'
4201273	"ARABUTA"	42	-52.1485992606982	-27.1574036959429	4201	'Oeste Catarinense'	42005	'Concórdia'
4201307	"ARAQUARI"	42	-48.6927074119294	-26.3759515540741	4202	'Norte Catarinense'	42008	'Joinville'
4201406	"ARARANGUA"	42	-49.480966523633	-28.9357520142005	4206	'Sul Catarinense'	42020	'Araranguá'
4201505	"ARMAZEM"	42	-49.012911084774	-28.2587054679168	4206	'Sul Catarinense'	42018	'Tubarão'
4201604	"ARROIO TRINTA"	42	-51.3341239238805	-26.932564856681	4201	'Oeste Catarinense'	42004	'Joaçaba'
4201653	"ARVOREDO"	42	-52.4577888411626	-27.0735335581574	4201	'Oeste Catarinense'	42005	'Concórdia'
4201703	"ASCURRA"	42	-49.3863634278063	-26.9547758424939	4204	'Vale do Itajaí'	42012	'Blumenau'
4201802	"ATALANTA"	42	-49.7794566741424	-27.4205360018406	4204	'Vale do Itajaí'	42014	'Ituporanga'
4201901	"AURORA"	42	-49.6436279074818	-27.2990294946104	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4201950	"BALNEARIO ARROIO DO SILVA"	42	-49.405702799137	-28.9804024547593	4206	'Sul Catarinense'	42020	'Araranguá'
4202057	"BALNEARIO BARRA DO SUL"	42	-48.6066458760074	-26.4564295671177	4202	'Norte Catarinense'	42008	'Joinville'
4202008	"BALNEARIO CAMBORIU"	42	-48.6346174770265	-26.9918186052546	4204	'Vale do Itajaí'	42013	'Itajaí'
4202073	"BALNEARIO GAIVOTA"	42	-49.5908937823551	-29.1645212685343	4206	'Sul Catarinense'	42020	'Araranguá'
4212809	"BALNEARIO PICARRAS"	42	-48.6750513539987	-26.7691705385029	4204	'Vale do Itajaí'	42013	'Itajaí'
4220000	"BALNEARIO RINCAO"	42	-49.2406727	-28.80428548	4206	'Sul Catarinense'	42019	'Criciúma'
4202081	"BANDEIRANTE"	42	-53.64104958659	-26.7689379013244	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4202099	"BARRA BONITA"	42	-53.4413025406045	-26.6522935998562	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4202107	"BARRA VELHA"	42	-48.683864274324	-26.6343614082893	4204	'Vale do Itajaí'	42013	'Itajaí'
4202131	"BELA VISTA DO TOLDO"	42	-50.4647882384698	-26.276228278338	4202	'Norte Catarinense'	42006	'Canoinhas'
4202156	"BELMONTE"	42	-53.5809772314809	-26.8445863474828	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4202206	"BENEDITO NOVO"	42	-49.3644027494089	-26.7775075690012	4204	'Vale do Itajaí'	42012	'Blumenau'
4202305	"BIGUACU"	42	-48.6544889289506	-27.49432274347	4205	'Grande Florianópolis'	42016	'Florianópolis'
4202404	"BLUMENAU"	42	-49.0576308843612	-26.9161077053067	4204	'Vale do Itajaí'	42012	'Blumenau'
4202438	"BOCAINA DO SUL"	42	-49.9458979108069	-27.7431983069377	4203	'Serrana'	42010	'Campos de Lages'
4202503	"BOM JARDIM DA SERRA"	42	-49.6249777453381	-28.3379471909765	4203	'Serrana'	42010	'Campos de Lages'
4202537	"BOM JESUS"	42	-52.3930159598262	-26.735923435578	4201	'Oeste Catarinense'	42003	'Xanxerê'
4202578	"BOM JESUS DO OESTE"	42	-53.0953502802337	-26.6918115545937	4201	'Oeste Catarinense'	42002	'Chapecó'
4202602	"BOM RETIRO"	42	-49.4898337660812	-27.7986710014261	4203	'Serrana'	42010	'Campos de Lages'
4202453	"BOMBINHAS"	42	-48.5213451348448	-27.1442546993321	4204	'Vale do Itajaí'	42013	'Itajaí'
4202701	"BOTUVERA"	42	-49.0784843619278	-27.2021068611648	4204	'Vale do Itajaí'	42012	'Blumenau'
4202800	"BRACO DO NORTE"	42	-49.1645477089486	-28.2800388673436	4206	'Sul Catarinense'	42018	'Tubarão'
4202859	"BRACO DO TROMBUDO"	42	-49.8909079359514	-27.3642513451248	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4202875	"BRUNOPOLIS"	42	-50.8359207719507	-27.318362150824	4203	'Serrana'	42009	'Curitibanos'
4202909	"BRUSQUE"	42	-48.9151630055154	-27.0983102262107	4204	'Vale do Itajaí'	42012	'Blumenau'
4203006	"CACADOR"	42	-51.0190347589981	-26.7753476727181	4201	'Oeste Catarinense'	42004	'Joaçaba'
4203105	"CAIBI"	42	-53.2505271955837	-27.073053932558	4201	'Oeste Catarinense'	42002	'Chapecó'
4203154	"CALMON"	42	-51.0966349045981	-26.6046771770733	4201	'Oeste Catarinense'	42004	'Joaçaba'
4203204	"CAMBORIU"	42	-48.6499958521006	-27.0264564992357	4204	'Vale do Itajaí'	42013	'Itajaí'
4203303	"CAMPO ALEGRE"	42	-49.2633444820536	-26.1906592824645	4202	'Norte Catarinense'	42007	'São Bento do Sul'
4203402	"CAMPO BELO DO SUL"	42	-50.7619937519385	-27.8966573872665	4203	'Serrana'	42010	'Campos de Lages'
4203501	"CAMPO ERE"	42	-53.0901551703376	-26.3945511410056	4201	'Oeste Catarinense'	42002	'Chapecó'
4203600	"CAMPOS NOVOS"	42	-51.2236729932379	-27.3990529792286	4203	'Serrana'	42009	'Curitibanos'
4203709	"CANELINHA"	42	-48.7892731276779	-27.2724147946086	4205	'Grande Florianópolis'	42015	'Tijucas'
4203808	"CANOINHAS"	42	-50.3978487118933	-26.1788070142524	4202	'Norte Catarinense'	42006	'Canoinhas'
4203253	"CAPAO ALTO"	42	-50.5114792925864	-27.9416852818149	4203	'Serrana'	42010	'Campos de Lages'
4203907	"CAPINZAL"	42	-51.6113627551759	-27.3442784642161	4201	'Oeste Catarinense'	42004	'Joaçaba'
4203956	"CAPIVARI DE BAIXO"	42	-48.9605750680941	-28.4490455118251	4206	'Sul Catarinense'	42018	'Tubarão'
4204004	"CATANDUVAS"	42	-51.6589480985776	-27.0720352215709	4201	'Oeste Catarinense'	42004	'Joaçaba'
4204103	"CAXAMBU DO SUL"	42	-52.8804748928922	-27.1612817848638	4201	'Oeste Catarinense'	42002	'Chapecó'
4204152	"CELSO RAMOS"	42	-51.3359938247645	-27.6347386053699	4203	'Serrana'	42010	'Campos de Lages'
4204178	"CERRO NEGRO"	42	-50.8700622646788	-27.7958280677384	4203	'Serrana'	42010	'Campos de Lages'
4204194	"CHAPADAO DO LAGEADO"	42	-49.5443259548905	-27.5852982512011	4204	'Vale do Itajaí'	42014	'Ituporanga'
4204202	"CHAPECO"	42	-52.6170311134138	-27.1068370215332	4201	'Oeste Catarinense'	42002	'Chapecó'
4204251	"COCAL DO SUL"	42	-49.3271287199039	-28.6030228652774	4206	'Sul Catarinense'	42019	'Criciúma'
4204301	"CONCORDIA"	42	-52.0239710697483	-27.2336587800538	4201	'Oeste Catarinense'	42005	'Concórdia'
4204350	"CORDILHEIRA ALTA"	42	-52.6032512708199	-26.9850812923252	4201	'Oeste Catarinense'	42002	'Chapecó'
4204400	"CORONEL FREITAS"	42	-52.7091514565173	-26.903251411811	4201	'Oeste Catarinense'	42002	'Chapecó'
4204459	"CORONEL MARTINS"	42	-52.6696992888121	-26.5116375952923	4201	'Oeste Catarinense'	42003	'Xanxerê'
4204558	"CORREIA PINTO"	42	-50.363760554615	-27.5848083449709	4203	'Serrana'	42010	'Campos de Lages'
4204509	"CORUPA"	42	-49.2267370000437	-26.4319663158101	4202	'Norte Catarinense'	42008	'Joinville'
4204608	"CRICIUMA"	42	-49.3659395588222	-28.6735722526747	4206	'Sul Catarinense'	42019	'Criciúma'
4204707	"CUNHA PORA"	42	-53.1738455719665	-26.8917270824506	4201	'Oeste Catarinense'	42002	'Chapecó'
4204756	"CUNHATAI"	42	-53.0932904925904	-26.9731396983276	4201	'Oeste Catarinense'	42002	'Chapecó'
4204806	"CURITIBANOS"	42	-50.5826010352621	-27.2829825064662	4203	'Serrana'	42009	'Curitibanos'
4204905	"DESCANSO"	42	-53.5046288706139	-26.8178702209916	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4205001	"DIONISIO CERQUEIRA"	42	-53.6313951228273	-26.2664885336603	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4205100	"DONA EMMA"	42	-49.7168977450524	-26.9863006137375	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4205159	"DOUTOR PEDRINHO"	42	-49.4792933619334	-26.7204609555414	4204	'Vale do Itajaí'	42012	'Blumenau'
4205175	"ENTRE RIOS"	42	-52.562533967831	-26.7236210952911	4201	'Oeste Catarinense'	42003	'Xanxerê'
4205191	"ERMO"	42	-49.6434049775486	-28.9850817922511	4206	'Sul Catarinense'	42020	'Araranguá'
4205209	"ERVAL VELHO"	42	-51.4434329044499	-27.2738954846384	4201	'Oeste Catarinense'	42004	'Joaçaba'
4205308	"FAXINAL DOS GUEDES"	42	-52.2714153987085	-26.8597867213521	4201	'Oeste Catarinense'	42003	'Xanxerê'
4205357	"FLOR DO SERTAO"	42	-53.3448914354815	-26.7794323287604	4201	'Oeste Catarinense'	42002	'Chapecó'
4205407	"FLORIANOPOLIS"	42	-48.5476373781933	-27.58779554855	4205	'Grande Florianópolis'	42016	'Florianópolis'
4205431	"FORMOSA DO SUL"	42	-52.7934500252739	-26.6485233782537	4201	'Oeste Catarinense'	42002	'Chapecó'
4205456	"FORQUILHINHA"	42	-49.4688610533615	-28.7424153508779	4206	'Sul Catarinense'	42019	'Criciúma'
4205506	"FRAIBURGO"	42	-50.9250792352346	-27.0234469627061	4201	'Oeste Catarinense'	42004	'Joaçaba'
4205555	"FREI ROGERIO"	42	-50.8064082491164	-27.1747514992324	4203	'Serrana'	42009	'Curitibanos'
4205605	"GALVAO"	42	-52.682002075558	-26.4554762383808	4201	'Oeste Catarinense'	42003	'Xanxerê'
4205704	"GAROPABA"	42	-48.6125566828538	-28.020895934826	4206	'Sul Catarinense'	42018	'Tubarão'
4205803	"GARUVA"	42	-48.8498418594081	-26.0220755061165	4202	'Norte Catarinense'	42008	'Joinville'
4205902	"GASPAR"	42	-48.9677065681263	-26.9183685142378	4204	'Vale do Itajaí'	42012	'Blumenau'
4206009	"GOVERNADOR CELSO RAMOS"	42	-48.5781665645095	-27.3186459075051	4205	'Grande Florianópolis'	42016	'Florianópolis'
4206108	"GRAO PARA"	42	-49.2199960405178	-28.1839865262373	4206	'Sul Catarinense'	42018	'Tubarão'
4206207	"GRAVATAL"	42	-49.0394702581619	-28.3291307178425	4206	'Sul Catarinense'	42018	'Tubarão'
4206306	"GUABIRUBA"	42	-48.9835604480228	-27.0603252392512	4204	'Vale do Itajaí'	42012	'Blumenau'
4206405	"GUARACIABA"	42	-53.5220897181838	-26.6003475707552	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4206504	"GUARAMIRIM"	42	-48.9921042659495	-26.4744451283201	4202	'Norte Catarinense'	42008	'Joinville'
4206603	"GUARUJA DO SUL"	42	-53.5254451083141	-26.384920604032	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4206652	"GUATAMBU"	42	-52.7838401342671	-27.1369108659036	4201	'Oeste Catarinense'	42002	'Chapecó'
4206702	"HERVAL D'OESTE"	42	-51.4962153102599	-27.1703031847073	4201	'Oeste Catarinense'	42004	'Joaçaba'
4206751	"IBIAM"	42	-51.2394276982807	-27.1805834764113	4201	'Oeste Catarinense'	42004	'Joaçaba'
4206801	"IBICARE"	42	-51.3684502619661	-27.0915490160551	4201	'Oeste Catarinense'	42004	'Joaçaba'
4206900	"IBIRAMA"	42	-49.5220277592255	-27.0535408849138	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4207007	"ICARA"	42	-49.3008225783231	-28.7070840092046	4206	'Sul Catarinense'	42019	'Criciúma'
4207106	"ILHOTA"	42	-48.8250140063896	-26.9046251832167	4204	'Vale do Itajaí'	42013	'Itajaí'
4207205	"IMARUI"	42	-48.8146717195152	-28.3438499095259	4206	'Sul Catarinense'	42018	'Tubarão'
4207304	"IMBITUBA"	42	-48.6692841969228	-28.2399511140131	4206	'Sul Catarinense'	42018	'Tubarão'
4207403	"IMBUIA"	42	-49.4277293449918	-27.4946042536369	4204	'Vale do Itajaí'	42014	'Ituporanga'
4207502	"INDAIAL"	42	-49.2401404600146	-26.906255999238	4204	'Vale do Itajaí'	42012	'Blumenau'
4207577	"IOMERE"	42	-51.2406190978758	-27.0010780507868	4201	'Oeste Catarinense'	42004	'Joaçaba'
4207601	"IPIRA"	42	-51.7708536189115	-27.4097088482285	4201	'Oeste Catarinense'	42005	'Concórdia'
4207650	"IPORA DO OESTE"	42	-53.5395118843069	-26.9960166793445	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4207684	"IPUACU"	42	-52.454296911798	-26.6325600976818	4201	'Oeste Catarinense'	42003	'Xanxerê'
4207700	"IPUMIRIM"	42	-52.1405408667672	-27.0683263637725	4201	'Oeste Catarinense'	42005	'Concórdia'
4207759	"IRACEMINHA"	42	-53.2760577940404	-26.8240650315757	4201	'Oeste Catarinense'	42002	'Chapecó'
4207809	"IRANI"	42	-51.9041079240294	-27.016186689116	4201	'Oeste Catarinense'	42005	'Concórdia'
4207858	"IRATI"	42	-52.8950113563078	-26.6572269448	4201	'Oeste Catarinense'	42002	'Chapecó'
4207908	"IRINEOPOLIS"	42	-50.8039000498131	-26.2366129371023	4202	'Norte Catarinense'	42006	'Canoinhas'
4208005	"ITA"	42	-52.3291825163272	-27.2817787174759	4201	'Oeste Catarinense'	42005	'Concórdia'
4208104	"ITAIOPOLIS"	42	-49.9087562022231	-26.3371264112188	4202	'Norte Catarinense'	42006	'Canoinhas'
4208203	"ITAJAI"	42	-48.6570232083488	-26.9074262397995	4204	'Vale do Itajaí'	42013	'Itajaí'
4208302	"ITAPEMA"	42	-48.6173993861423	-27.0959378836856	4204	'Vale do Itajaí'	42013	'Itajaí'
4208401	"ITAPIRANGA"	42	-53.7148020649025	-27.1753750894904	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4208450	"ITAPOA"	42	-48.6041676070776	-26.0060478870145	4202	'Norte Catarinense'	42008	'Joinville'
4208500	"ITUPORANGA"	42	-49.603414701133	-27.4148584906675	4204	'Vale do Itajaí'	42014	'Ituporanga'
4208609	"JABORA"	42	-51.7433538390133	-27.1728530868747	4201	'Oeste Catarinense'	42004	'Joaçaba'
4208708	"JACINTO MACHADO"	42	-49.761768656406	-29.0014186138235	4206	'Sul Catarinense'	42020	'Araranguá'
4208807	"JAGUARUNA"	42	-49.0491289860852	-28.6249636892195	4206	'Sul Catarinense'	42018	'Tubarão'
4208906	"JARAGUA DO SUL"	42	-49.0762988228022	-26.4904843494135	4202	'Norte Catarinense'	42008	'Joinville'
4208955	"JARDINOPOLIS"	42	-52.8588992560494	-26.7205694035031	4201	'Oeste Catarinense'	42002	'Chapecó'
4209003	"JOACABA"	42	-51.5066897333377	-27.1739445292328	4201	'Oeste Catarinense'	42004	'Joaçaba'
4209102	"JOINVILLE"	42	-48.849409143238	-26.3045176486541	4202	'Norte Catarinense'	42008	'Joinville'
4209151	"JOSE BOITEUX"	42	-49.6238066864875	-26.9546826165688	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4209177	"JUPIA"	42	-52.7343805407579	-26.393702818029	4201	'Oeste Catarinense'	42003	'Xanxerê'
4209201	"LACERDOPOLIS"	42	-51.5628663690798	-27.2646000912218	4201	'Oeste Catarinense'	42004	'Joaçaba'
4209300	"LAGES"	42	-50.3302224241895	-27.8172594631137	4203	'Serrana'	42010	'Campos de Lages'
4209409	"LAGUNA"	42	-48.7813886217994	-28.483585953912	4206	'Sul Catarinense'	42018	'Tubarão'
4209458	"LAJEADO GRANDE"	42	-52.5660348495432	-26.8609423456111	4201	'Oeste Catarinense'	42003	'Xanxerê'
4209508	"LAURENTINO"	42	-49.7552636609799	-27.2123881016018	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4209607	"LAURO MULLER"	42	-49.3943072672474	-28.3935851652629	4206	'Sul Catarinense'	42019	'Criciúma'
4209706	"LEBON REGIS"	42	-50.6918278644481	-26.92911401117	4201	'Oeste Catarinense'	42004	'Joaçaba'
4209805	"LEOBERTO LEAL"	42	-49.2894014989799	-27.5063895156567	4205	'Grande Florianópolis'	42015	'Tijucas'
4209854	"LINDOIA DO SUL"	42	-52.0809226441985	-27.0474644814817	4201	'Oeste Catarinense'	42005	'Concórdia'
4209904	"LONTRAS"	42	-49.5448293546842	-27.1574865637255	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4210001	"LUIZ ALVES"	42	-48.9260467722994	-26.7211107866955	4204	'Vale do Itajaí'	42012	'Blumenau'
4210035	"LUZERNA"	42	-51.4679460432033	-27.1298960692111	4201	'Oeste Catarinense'	42004	'Joaçaba'
4210050	"MACIEIRA"	42	-51.3761219769561	-26.8552123885479	4201	'Oeste Catarinense'	42004	'Joaçaba'
4210100	"MAFRA"	42	-49.8010375282692	-26.1152284942537	4202	'Norte Catarinense'	42006	'Canoinhas'
4210209	"MAJOR GERCINO"	42	-48.9533539588878	-27.4186604134206	4205	'Grande Florianópolis'	42015	'Tijucas'
4210308	"MAJOR VIEIRA"	42	-50.3329868433168	-26.357526536006	4202	'Norte Catarinense'	42006	'Canoinhas'
4210407	"MARACAJA"	42	-49.4543763245932	-28.8503146069746	4206	'Sul Catarinense'	42020	'Araranguá'
4210506	"MARAVILHA"	42	-53.174818815895	-26.7616239472618	4201	'Oeste Catarinense'	42002	'Chapecó'
4210555	"MAREMA"	42	-52.6271354100559	-26.8004219087544	4201	'Oeste Catarinense'	42003	'Xanxerê'
4210605	"MASSARANDUBA"	42	-48.9887446627143	-26.5954580146677	4202	'Norte Catarinense'	42008	'Joinville'
4210704	"MATOS COSTA"	42	-51.1574514436102	-26.4741154352025	4201	'Oeste Catarinense'	42004	'Joaçaba'
4210803	"MELEIRO"	42	-49.6298493602249	-28.8324458208608	4206	'Sul Catarinense'	42020	'Araranguá'
4210852	"MIRIM DOCE"	42	-50.0685637123754	-27.2012050831375	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4210902	"MODELO"	42	-53.0535007992379	-26.7780420756962	4201	'Oeste Catarinense'	42002	'Chapecó'
4211009	"MONDAI"	42	-53.3986840279187	-27.1036116941033	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4211058	"MONTE CARLO"	42	-50.9741046780325	-27.217678802079	4203	'Serrana'	42009	'Curitibanos'
4211108	"MONTE CASTELO"	42	-50.2262714328843	-26.4563624721632	4202	'Norte Catarinense'	42006	'Canoinhas'
4211207	"MORRO DA FUMACA"	42	-49.2132565084377	-28.6547878430396	4206	'Sul Catarinense'	42019	'Criciúma'
4211256	"MORRO GRANDE"	42	-49.7187999838418	-28.7997195366586	4206	'Sul Catarinense'	42020	'Araranguá'
4211306	"NAVEGANTES"	42	-48.6491829025091	-26.8974391192712	4204	'Vale do Itajaí'	42013	'Itajaí'
4211405	"NOVA ERECHIM"	42	-52.9112866654386	-26.9012733980819	4201	'Oeste Catarinense'	42002	'Chapecó'
4211454	"NOVA ITABERABA"	42	-52.81124405489	-26.9428898836363	4201	'Oeste Catarinense'	42002	'Chapecó'
4211504	"NOVA TRENTO"	42	-48.9257954329345	-27.2877711667856	4205	'Grande Florianópolis'	42015	'Tijucas'
4211603	"NOVA VENEZA"	42	-49.5031235817322	-28.638232602301	4206	'Sul Catarinense'	42019	'Criciúma'
4211652	"NOVO HORIZONTE"	42	-52.8340333904853	-26.4461719902068	4201	'Oeste Catarinense'	42002	'Chapecó'
4211702	"ORLEANS"	42	-49.2914262911017	-28.3604689662855	4206	'Sul Catarinense'	42018	'Tubarão'
4211751	"OTACILIO COSTA"	42	-50.1123146891291	-27.5038461750082	4203	'Serrana'	42010	'Campos de Lages'
4211801	"OURO"	42	-51.620562178214	-27.3424881724357	4201	'Oeste Catarinense'	42004	'Joaçaba'
4211850	"OURO VERDE"	42	-52.3100192014426	-26.6959944195779	4201	'Oeste Catarinense'	42003	'Xanxerê'
4211876	"PAIAL"	42	-52.5010887492735	-27.2551577941135	4201	'Oeste Catarinense'	42005	'Concórdia'
4211892	"PAINEL"	42	-50.1130097409793	-27.9145181854278	4203	'Serrana'	42010	'Campos de Lages'
4211900	"PALHOCA"	42	-48.6702879187122	-27.6470436836907	4205	'Grande Florianópolis'	42016	'Florianópolis'
4212007	"PALMA SOLA"	42	-53.2799772512092	-26.3465081338035	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4212056	"PALMEIRA"	42	-50.1590014055927	-27.5822620704524	4203	'Serrana'	42010	'Campos de Lages'
4212106	"PALMITOS"	42	-53.1622672928949	-27.0702505491681	4201	'Oeste Catarinense'	42002	'Chapecó'
4212205	"PAPANDUVA"	42	-50.1632041973224	-26.3939830707766	4202	'Norte Catarinense'	42006	'Canoinhas'
4212239	"PARAISO"	42	-53.6753141316767	-26.6152629707928	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4212254	"PASSO DE TORRES"	42	-49.725145272462	-29.3234599051044	4206	'Sul Catarinense'	42020	'Araranguá'
4212270	"PASSOS MAIA"	42	-52.061723800427	-26.7808891471921	4201	'Oeste Catarinense'	42003	'Xanxerê'
4212304	"PAULO LOPES"	42	-48.6814954135887	-27.949816232587	4205	'Grande Florianópolis'	42016	'Florianópolis'
4212403	"PEDRAS GRANDES"	42	-49.186487547356	-28.4372176497457	4206	'Sul Catarinense'	42018	'Tubarão'
4212502	"PENHA"	42	-48.6475729112698	-26.7688610927433	4204	'Vale do Itajaí'	42013	'Itajaí'
4212601	"PERITIBA"	42	-51.9098146670515	-27.3773092814998	4201	'Oeste Catarinense'	42005	'Concórdia'
4212650	"PESCARIA BRAVA"	42	-48.86600135	-28.38671014	4206	'Sul Catarinense'	42018	'Tubarão'
4212700	"PETROLANDIA"	42	-49.6948686231008	-27.5281268330003	4204	'Vale do Itajaí'	42014	'Ituporanga'
4212908	"PINHALZINHO"	42	-52.9822532451308	-26.8488143342201	4201	'Oeste Catarinense'	42002	'Chapecó'
4213005	"PINHEIRO PRETO"	42	-51.2305364835274	-27.0451346160511	4201	'Oeste Catarinense'	42004	'Joaçaba'
4213104	"PIRATUBA"	42	-51.7586498276128	-27.4159535517176	4201	'Oeste Catarinense'	42005	'Concórdia'
4213153	"PLANALTO ALEGRE"	42	-52.8673520307871	-27.0694597760793	4201	'Oeste Catarinense'	42002	'Chapecó'
4213203	"POMERODE"	42	-49.1741975274002	-26.7448263965019	4204	'Vale do Itajaí'	42012	'Blumenau'
4213302	"PONTE ALTA"	42	-50.3771006508207	-27.4677840727923	4203	'Serrana'	42009	'Curitibanos'
4213351	"PONTE ALTA DO NORTE"	42	-50.4654042677657	-27.1690291828981	4203	'Serrana'	42009	'Curitibanos'
4213401	"PONTE SERRADA"	42	-52.014537512533	-26.8749128276431	4201	'Oeste Catarinense'	42003	'Xanxerê'
4213500	"PORTO BELO"	42	-48.6027567395843	-27.1494662097186	4204	'Vale do Itajaí'	42013	'Itajaí'
4213609	"PORTO UNIAO"	42	-51.0816046335966	-26.2300048980861	4202	'Norte Catarinense'	42006	'Canoinhas'
4213708	"POUSO REDONDO"	42	-49.9556521355194	-27.2510862782106	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4213807	"PRAIA GRANDE"	42	-49.960591976336	-29.1957763636175	4206	'Sul Catarinense'	42020	'Araranguá'
4213906	"PRESIDENTE CASTELLO BRANCO"	42	-51.8113755382464	-27.2199421946146	4201	'Oeste Catarinense'	42005	'Concórdia'
4214003	"PRESIDENTE GETULIO"	42	-49.6220861691379	-27.0414082411233	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4214102	"PRESIDENTE NEREU"	42	-49.4032927710887	-27.2873292141085	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4214151	"PRINCESA"	42	-53.5981058756425	-26.4443352068206	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4214201	"QUILOMBO"	42	-52.7276095700875	-26.7400555498141	4201	'Oeste Catarinense'	42002	'Chapecó'
4214300	"RANCHO QUEIMADO"	42	-49.0084323799639	-27.6772088641101	4205	'Grande Florianópolis'	42017	'Tabuleiro'
4214409	"RIO DAS ANTAS"	42	-51.0760199431708	-26.8970674359054	4201	'Oeste Catarinense'	42004	'Joaçaba'
4214508	"RIO DO CAMPO"	42	-50.1395889130392	-26.9423084311286	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4214607	"RIO DO OESTE"	42	-49.8028622167011	-27.1911665180101	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4214805	"RIO DO SUL"	42	-49.6432375290983	-27.2179032254389	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4214706	"RIO DOS CEDROS"	42	-49.2723794435685	-26.7491298161626	4204	'Vale do Itajaí'	42012	'Blumenau'
4214904	"RIO FORTUNA"	42	-49.105093802571	-28.1325913886379	4206	'Sul Catarinense'	42018	'Tubarão'
4215000	"RIO NEGRINHO"	42	-49.5172950755857	-26.255325027927	4202	'Norte Catarinense'	42007	'São Bento do Sul'
4215059	"RIO RUFINO"	42	-49.7775918042695	-27.863235479243	4203	'Serrana'	42010	'Campos de Lages'
4215075	"RIQUEZA"	42	-53.3252862115099	-27.0675941645796	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4215109	"RODEIO"	42	-49.3047072334636	-26.9435016683708	4204	'Vale do Itajaí'	42012	'Blumenau'
4215208	"ROMELANDIA"	42	-53.320158400046	-26.679463563118	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4215307	"SALETE"	42	-50.0017307310962	-26.9752443334315	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4215356	"SALTINHO"	42	-53.058631248926	-26.6085589195734	4201	'Oeste Catarinense'	42002	'Chapecó'
4215406	"SALTO VELOSO"	42	-51.4052080779569	-26.9031646076917	4201	'Oeste Catarinense'	42004	'Joaçaba'
4215455	"SANGAO"	42	-49.1340298641987	-28.6332229229122	4206	'Sul Catarinense'	42018	'Tubarão'
4215505	"SANTA CECILIA"	42	-50.4229016203405	-26.9569007446141	4203	'Serrana'	42009	'Curitibanos'
4215554	"SANTA HELENA"	42	-53.6199878739379	-26.9398439236403	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4215604	"SANTA ROSA DE LIMA"	42	-49.1250913029394	-28.0356055728432	4206	'Sul Catarinense'	42018	'Tubarão'
4215653	"SANTA ROSA DO SUL"	42	-49.7176263735924	-29.1352882185643	4206	'Sul Catarinense'	42020	'Araranguá'
4215679	"SANTA TEREZINHA"	42	-50.0055291871441	-26.7809823539531	4202	'Norte Catarinense'	42006	'Canoinhas'
4215687	"SANTA TEREZINHA DO PROGRESSO"	42	-53.1998469616569	-26.6197755738664	4201	'Oeste Catarinense'	42002	'Chapecó'
4215695	"SANTIAGO DO SUL"	42	-52.675949479347	-26.6348090908966	4201	'Oeste Catarinense'	42002	'Chapecó'
4215703	"SANTO AMARO DA IMPERATRIZ"	42	-48.7802399213721	-27.6897477584618	4205	'Grande Florianópolis'	42016	'Florianópolis'
4215802	"SAO BENTO DO SUL"	42	-49.3869788951345	-26.2494854185392	4202	'Norte Catarinense'	42007	'São Bento do Sul'
4215752	"SAO BERNARDINO"	42	-52.9655387397374	-26.4732782462558	4201	'Oeste Catarinense'	42002	'Chapecó'
4215901	"SAO BONIFACIO"	42	-48.9293119585962	-27.8964966985261	4205	'Grande Florianópolis'	42017	'Tabuleiro'
4216008	"SAO CARLOS"	42	-53.017394273321	-27.0786350778961	4201	'Oeste Catarinense'	42002	'Chapecó'
4216057	"SAO CRISTOVAO DO SUL"	42	-50.434628933086	-27.2829466733989	4203	'Serrana'	42009	'Curitibanos'
4216107	"SAO DOMINGOS"	42	-52.5372274685343	-26.5578303695187	4201	'Oeste Catarinense'	42003	'Xanxerê'
4216206	"SAO FRANCISCO DO SUL"	42	-48.6375707581745	-26.244017884154	4202	'Norte Catarinense'	42008	'Joinville'
4216305	"SAO JOAO BATISTA"	42	-48.8570042802462	-27.2958805567379	4205	'Grande Florianópolis'	42015	'Tijucas'
4216354	"SAO JOAO DO ITAPERIU"	42	-48.7677653867626	-26.6174540463118	4204	'Vale do Itajaí'	42013	'Itajaí'
4216255	"SAO JOAO DO OESTE"	42	-53.5959666797443	-27.0974826254415	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4216404	"SAO JOAO DO SUL"	42	-49.806571385692	-29.2234797912484	4206	'Sul Catarinense'	42020	'Araranguá'
4216503	"SAO JOAQUIM"	42	-49.9367417605442	-28.294712499212	4203	'Serrana'	42010	'Campos de Lages'
4216602	"SAO JOSE"	42	-48.6160227158664	-27.5903120772487	4205	'Grande Florianópolis'	42016	'Florianópolis'
4216701	"SAO JOSE DO CEDRO"	42	-53.5001241069131	-26.4560602968492	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4216800	"SAO JOSE DO CERRITO"	42	-50.5813861763305	-27.6685865187534	4203	'Serrana'	42010	'Campos de Lages'
4216909	"SAO LOURENCO DO OESTE"	42	-52.8513336669502	-26.3551901645503	4201	'Oeste Catarinense'	42002	'Chapecó'
4217006	"SAO LUDGERO"	42	-49.1756843247193	-28.3268955250758	4206	'Sul Catarinense'	42018	'Tubarão'
4217105	"SAO MARTINHO"	42	-48.9777862480357	-28.16449528961	4206	'Sul Catarinense'	42018	'Tubarão'
4217154	"SAO MIGUEL DA BOA VISTA"	42	-53.2545563766802	-26.694475145317	4201	'Oeste Catarinense'	42002	'Chapecó'
4217204	"SAO MIGUEL DO OESTE"	42	-53.5188394061561	-26.7264271766606	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4217253	"SAO PEDRO DE ALCANTARA"	42	-48.7876695873071	-27.5671700933901	4205	'Grande Florianópolis'	42016	'Florianópolis'
4217303	"SAUDADES"	42	-52.9955697272511	-26.9197569510449	4201	'Oeste Catarinense'	42002	'Chapecó'
4217402	"SCHROEDER"	42	-49.0732596915149	-26.4209759126271	4202	'Norte Catarinense'	42008	'Joinville'
4217501	"SEARA"	42	-52.3028548279905	-27.1456976228746	4201	'Oeste Catarinense'	42005	'Concórdia'
4217550	"SERRA ALTA"	42	-53.0462763415455	-26.7247733740512	4201	'Oeste Catarinense'	42002	'Chapecó'
4217600	"SIDEROPOLIS"	42	-49.420540933003	-28.5951024182345	4206	'Sul Catarinense'	42019	'Criciúma'
4217709	"SOMBRIO"	42	-49.6342103641341	-29.109132756826	4206	'Sul Catarinense'	42020	'Araranguá'
4217758	"SUL BRASIL"	42	-52.9642047957299	-26.736936209706	4201	'Oeste Catarinense'	42002	'Chapecó'
4217808	"TAIO"	42	-50.0050964642724	-27.1179373002204	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4217907	"TANGARA"	42	-51.245914375254	-27.1010111042277	4201	'Oeste Catarinense'	42004	'Joaçaba'
4217956	"TIGRINHOS"	42	-53.1575419839148	-26.6894748377594	4201	'Oeste Catarinense'	42002	'Chapecó'
4218004	"TIJUCAS"	42	-48.6320705638696	-27.2394536072106	4205	'Grande Florianópolis'	42015	'Tijucas'
4218103	"TIMBE DO SUL"	42	-49.8441177627944	-28.8325174934795	4206	'Sul Catarinense'	42020	'Araranguá'
4218202	"TIMBO"	42	-49.2777122897972	-26.8229025749878	4204	'Vale do Itajaí'	42012	'Blumenau'
4218251	"TIMBO GRANDE"	42	-50.6746741364894	-26.6178284910438	4202	'Norte Catarinense'	42006	'Canoinhas'
4218301	"TRES BARRAS"	42	-50.3054193679948	-26.11409633676	4202	'Norte Catarinense'	42006	'Canoinhas'
4218350	"TREVISO"	42	-49.455933378851	-28.5184848579408	4206	'Sul Catarinense'	42019	'Criciúma'
4218400	"TREZE DE MAIO"	42	-49.1448153071747	-28.558140037514	4206	'Sul Catarinense'	42018	'Tubarão'
4218509	"TREZE TILIAS"	42	-51.4146746650895	-26.9985363058706	4201	'Oeste Catarinense'	42004	'Joaçaba'
4218608	"TROMBUDO CENTRAL"	42	-49.792478234056	-27.3030195290903	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4218707	"TUBARAO"	42	-49.0052680770245	-28.4800339478501	4206	'Sul Catarinense'	42018	'Tubarão'
4218756	"TUNAPOLIS"	42	-53.641459736047	-26.9722235914893	4201	'Oeste Catarinense'	42001	'São Miguel do Oeste'
4218806	"TURVO"	42	-49.6808657451159	-28.9247492173882	4206	'Sul Catarinense'	42020	'Araranguá'
4218855	"UNIAO DO OESTE"	42	-52.8514964564325	-26.7617370137475	4201	'Oeste Catarinense'	42002	'Chapecó'
4218905	"URUBICI"	42	-49.5882056111042	-28.0045549120329	4203	'Serrana'	42010	'Campos de Lages'
4218954	"URUPEMA"	42	-49.8732112423988	-27.9526858098159	4203	'Serrana'	42010	'Campos de Lages'
4219002	"URUSSANGA"	42	-49.3191079185647	-28.5199662039211	4206	'Sul Catarinense'	42019	'Criciúma'
4219101	"VARGEAO"	42	-52.154105650118	-26.8639833173705	4201	'Oeste Catarinense'	42003	'Xanxerê'
4219150	"VARGEM"	42	-50.9781506256549	-27.4899701004296	4203	'Serrana'	42009	'Curitibanos'
4219176	"VARGEM BONITA"	42	-51.7447401814046	-27.0032416045091	4201	'Oeste Catarinense'	42004	'Joaçaba'
4219200	"VIDAL RAMOS"	42	-49.3682191726114	-27.3957786986881	4204	'Vale do Itajaí'	42014	'Ituporanga'
4219309	"VIDEIRA"	42	-51.1517052828326	-27.0061290679698	4201	'Oeste Catarinense'	42004	'Joaçaba'
4219358	"VITOR MEIRELES"	42	-49.8307519609684	-26.8815776185781	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4219408	"WITMARSUM"	42	-49.8042033754401	-26.926742723396	4204	'Vale do Itajaí'	42011	'Rio do Sul'
4219507	"XANXERE"	42	-52.4046671389754	-26.8745844992386	4201	'Oeste Catarinense'	42003	'Xanxerê'
4219606	"XAVANTINA"	42	-52.3428505099137	-27.0702501470745	4201	'Oeste Catarinense'	42005	'Concórdia'
4219705	"XAXIM"	42	-52.5349325183039	-26.9637194992369	4201	'Oeste Catarinense'	42003	'Xanxerê'
4219853	"ZORTEA"	42	-51.5495663068408	-27.4502514116819	4203	'Serrana'	42009	'Curitibanos'
2800100	"AMPARO DE SAO FRANCISCO"	28	-36.927483689181	-10.1339710339015	2803	'Leste Sergipano'	28007	'Propriá'
2800209	"AQUIDABA"	28	-37.0221808560785	-10.2925180922232	2802	'Agreste Sergipano'	28003	'Nossa Senhora das Dores'
2800308	"ARACAJU"	28	-37.0482126395123	-10.9072157978835	2803	'Leste Sergipano'	28011	'Aracaju'
2800407	"ARAUA"	28	-37.6123374340696	-11.2645047798951	2803	'Leste Sergipano'	28012	'Boquim'
2800506	"AREIA BRANCA"	28	-37.3133626004441	-10.758192250822	2802	'Agreste Sergipano'	28004	'Agreste de Itabaiana'
2800605	"BARRA DOS COQUEIROS"	28	-37.0412415492828	-10.9067992470843	2803	'Leste Sergipano'	28011	'Aracaju'
2800670	"BOQUIM"	28	-37.6235734779508	-11.1463916303607	2803	'Leste Sergipano'	28012	'Boquim'
2800704	"BREJO GRANDE"	28	-36.4718202439579	-10.4189433106341	2803	'Leste Sergipano'	28007	'Propriá'
2801009	"CAMPO DO BRITO"	28	-37.4963563345164	-10.7433351538524	2802	'Agreste Sergipano'	28004	'Agreste de Itabaiana'
2801108	"CANHOBA"	28	-36.9738449754071	-10.138743655691	2803	'Leste Sergipano'	28007	'Propriá'
2801207	"CANINDE DE SAO FRANCISCO"	28	-37.7879637221177	-9.65410406729849	2801	'Sertão Sergipano'	28001	'Sergipana do Sertão do São Francisco'
2801306	"CAPELA"	28	-37.0548329945789	-10.5060996319004	2803	'Leste Sergipano'	28008	'Cotinguiba'
2801405	"CARIRA"	28	-37.7019192069376	-10.3580170968976	2801	'Sertão Sergipano'	28002	'Carira'
2801504	"CARMOPOLIS"	28	-36.9908161851827	-10.6468185839524	2803	'Leste Sergipano'	28010	'Baixo Cotinguiba'
2801603	"CEDRO DE SAO JOAO"	28	-36.8840359528515	-10.2477649415005	2803	'Leste Sergipano'	28007	'Propriá'
2801702	"CRISTINAPOLIS"	28	-37.754659635068	-11.4735577970762	2803	'Leste Sergipano'	28012	'Boquim'
2801900	"CUMBE"	28	-37.1878992756552	-10.3570250323237	2802	'Agreste Sergipano'	28003	'Nossa Senhora das Dores'
2802007	"DIVINA PASTORA"	28	-37.1493449602392	-10.6773757001803	2803	'Leste Sergipano'	28008	'Cotinguiba'
2802106	"ESTANCIA"	28	-37.4400108537292	-11.2679486493031	2803	'Leste Sergipano'	28013	'Estância'
2802205	"FEIRA NOVA"	28	-37.3161177206926	-10.2705325209233	2801	'Sertão Sergipano'	28001	'Sergipana do Sertão do São Francisco'
2802304	"FREI PAULO"	28	-37.5418762486803	-10.5400847468847	2801	'Sertão Sergipano'	28002	'Carira'
2802403	"GARARU"	28	-37.0843724853204	-9.96735146791995	2801	'Sertão Sergipano'	28001	'Sergipana do Sertão do São Francisco'
2802502	"GENERAL MAYNARD"	28	-36.9879844294671	-10.6865298123962	2803	'Leste Sergipano'	28010	'Baixo Cotinguiba'
2802601	"GRACHO CARDOSO"	28	-37.196054632255	-10.2261996604123	2801	'Sertão Sergipano'	28001	'Sergipana do Sertão do São Francisco'
2802700	"ILHA DAS FLORES"	28	-36.538635240922	-10.434275829882	2803	'Leste Sergipano'	28007	'Propriá'
2802809	"INDIAROBA"	28	-37.5150947928792	-11.5185072682496	2803	'Leste Sergipano'	28013	'Estância'
2802908	"ITABAIANA"	28	-37.4268609403324	-10.6857160383187	2802	'Agreste Sergipano'	28004	'Agreste de Itabaiana'
2803005	"ITABAIANINHA"	28	-37.7874111399082	-11.2767854368944	2803	'Leste Sergipano'	28012	'Boquim'
2803104	"ITABI"	28	-37.0996499528057	-10.1234895922391	2801	'Sertão Sergipano'	28001	'Sergipana do Sertão do São Francisco'
2803203	"ITAPORANGA D'AJUDA"	28	-37.3078269330688	-10.9967327673047	2803	'Leste Sergipano'	28013	'Estância'
2803302	"JAPARATUBA"	28	-36.9417863037613	-10.5894668148048	2803	'Leste Sergipano'	28009	'Japaratuba'
2803401	"JAPOATA"	28	-36.8007564643613	-10.3465099141958	2803	'Leste Sergipano'	28009	'Japaratuba'
2803500	"LAGARTO"	28	-37.666353409722	-10.9153009698622	2802	'Agreste Sergipano'	28006	'Agreste de Lagarto'
2803609	"LARANJEIRAS"	28	-37.1605681986739	-10.7970295089519	2803	'Leste Sergipano'	28010	'Baixo Cotinguiba'
2803708	"MACAMBIRA"	28	-37.543445391339	-10.6641499737985	2802	'Agreste Sergipano'	28004	'Agreste de Itabaiana'
2803807	"MALHADA DOS BOIS"	28	-36.9189022040157	-10.3464515201382	2802	'Agreste Sergipano'	28003	'Nossa Senhora das Dores'
2803906	"MALHADOR"	28	-37.3114599440126	-10.6600442408644	2802	'Agreste Sergipano'	28004	'Agreste de Itabaiana'
2804003	"MARUIM"	28	-37.0833143406492	-10.7369324035675	2803	'Leste Sergipano'	28010	'Baixo Cotinguiba'
2804102	"MOITA BONITA"	28	-37.3457494006631	-10.5790438595404	2802	'Agreste Sergipano'	28004	'Agreste de Itabaiana'
2804201	"MONTE ALEGRE DE SERGIPE"	28	-37.5614258472908	-10.025861627368	2801	'Sertão Sergipano'	28001	'Sergipana do Sertão do São Francisco'
2804300	"MURIBECA"	28	-36.9570014375569	-10.4274274735498	2802	'Agreste Sergipano'	28003	'Nossa Senhora das Dores'
2804409	"NEOPOLIS"	28	-36.5767181793652	-10.3158782272668	2803	'Leste Sergipano'	28007	'Propriá'
2804458	"NOSSA SENHORA APARECIDA"	28	-37.4544385459973	-10.3946514574101	2801	'Sertão Sergipano'	28002	'Carira'
2804508	"NOSSA SENHORA DA GLORIA"	28	-37.4199214592677	-10.215686849106	2801	'Sertão Sergipano'	28001	'Sergipana do Sertão do São Francisco'
2804607	"NOSSA SENHORA DAS DORES"	28	-37.1937112099255	-10.4920543730734	2802	'Agreste Sergipano'	28003	'Nossa Senhora das Dores'
2804706	"NOSSA SENHORA DE LOURDES"	28	-37.0504728834465	-10.0786160367075	2803	'Leste Sergipano'	28007	'Propriá'
2804805	"NOSSA SENHORA DO SOCORRO"	28	-37.1284961300464	-10.8487541757333	2803	'Leste Sergipano'	28011	'Aracaju'
2804904	"PACATUBA"	28	-36.6479863948283	-10.4498997629294	2803	'Leste Sergipano'	28009	'Japaratuba'
2805000	"PEDRA MOLE"	28	-37.6860272130241	-10.6181191604186	2801	'Sertão Sergipano'	28002	'Carira'
2805109	"PEDRINHAS"	28	-37.6811281603891	-11.1935033961179	2803	'Leste Sergipano'	28012	'Boquim'
2805208	"PINHAO"	28	-37.7221107205356	-10.5666899531531	2801	'Sertão Sergipano'	28002	'Carira'
2805307	"PIRAMBU"	28	-36.8597462116876	-10.7410561554895	2803	'Leste Sergipano'	28009	'Japaratuba'
2805406	"POCO REDONDO"	28	-37.6842137118049	-9.80579020827372	2801	'Sertão Sergipano'	28001	'Sergipana do Sertão do São Francisco'
2805505	"POCO VERDE"	28	-38.1766582213158	-10.7075986488522	2802	'Agreste Sergipano'	28005	'Tobias Barreto'
2805604	"PORTO DA FOLHA"	28	-37.2766348494805	-9.91925887236146	2801	'Sertão Sergipano'	28001	'Sergipana do Sertão do São Francisco'
2805703	"PROPRIA"	28	-36.8420993590988	-10.2082073153137	2803	'Leste Sergipano'	28007	'Propriá'
2805802	"RIACHAO DO DANTAS"	28	-37.7293412249827	-11.0664022904367	2802	'Agreste Sergipano'	28006	'Agreste de Lagarto'
2805901	"RIACHUELO"	28	-37.1934568325855	-10.7316512984525	2803	'Leste Sergipano'	28010	'Baixo Cotinguiba'
2806008	"RIBEIROPOLIS"	28	-37.4329390298824	-10.5451904693215	2801	'Sertão Sergipano'	28002	'Carira'
2806107	"ROSARIO DO CATETE"	28	-37.0313228648729	-10.6945899789946	2803	'Leste Sergipano'	28010	'Baixo Cotinguiba'
2806206	"SALGADO"	28	-37.477755358888	-11.0221187749041	2803	'Leste Sergipano'	28012	'Boquim'
2806305	"SANTA LUZIA DO ITANHY"	28	-37.4498421802076	-11.3533173973413	2803	'Leste Sergipano'	28013	'Estância'
2806503	"SANTA ROSA DE LIMA"	28	-37.1977318456227	-10.6462336647079	2803	'Leste Sergipano'	28008	'Cotinguiba'
2806404	"SANTANA DO SAO FRANCISCO"	28	-36.5995793479956	-10.2876719724288	2803	'Leste Sergipano'	28007	'Propriá'
2806602	"SANTO AMARO DAS BROTAS"	28	-37.0563110976557	-10.7820113826258	2803	'Leste Sergipano'	28010	'Baixo Cotinguiba'
2806701	"SAO CRISTOVAO"	28	-37.2094987839423	-11.0136768571472	2803	'Leste Sergipano'	28011	'Aracaju'
2806800	"SAO DOMINGOS"	28	-37.5684292045339	-10.7923257834115	2802	'Agreste Sergipano'	28004	'Agreste de Itabaiana'
2806909	"SAO FRANCISCO"	28	-36.8862396608894	-10.3464864526782	2803	'Leste Sergipano'	28009	'Japaratuba'
2807006	"SAO MIGUEL DO ALEIXO"	28	-37.3839764494164	-10.3877721948223	2802	'Agreste Sergipano'	28003	'Nossa Senhora das Dores'
2807105	"SIMAO DIAS"	28	-37.8094305822503	-10.7380617976536	2802	'Agreste Sergipano'	28005	'Tobias Barreto'
2807204	"SIRIRI"	28	-37.1122253407609	-10.6050355731006	2803	'Leste Sergipano'	28008	'Cotinguiba'
2807303	"TELHA"	28	-36.8838500415646	-10.2091732236821	2803	'Leste Sergipano'	28007	'Propriá'
2807402	"TOBIAS BARRETO"	28	-37.9990006951017	-11.1843298680994	2802	'Agreste Sergipano'	28005	'Tobias Barreto'
2807501	"TOMAR DO GERU"	28	-37.8453707752723	-11.3680522747437	2803	'Leste Sergipano'	28012	'Boquim'
2807600	"UMBAUBA"	28	-37.6611466730617	-11.3798724696847	2803	'Leste Sergipano'	28012	'Boquim'
3500105	"ADAMANTINA"	35	-51.0733647495818	-21.68831148	3508	'Presidente Prudente'	35035	'Adamantina'
3500204	"ADOLFO"	35	-49.6497214255596	-21.232729777348	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3500303	"AGUAI"	35	-46.9796931092697	-22.059684	3507	'Campinas'	35029	'Pirassununga'
3500402	"AGUAS DA PRATA"	35	-46.7167667096261	-21.934829	3507	'Campinas'	35030	'São João da Boa Vista'
3500501	"AGUAS DE LINDOIA"	35	-46.6317788359222	-22.4738220361707	3507	'Campinas'	35033	'Amparo'
3500550	"AGUAS DE SANTA BARBARA"	35	-49.2386077671316	-22.869149409425	3504	'Bauru'	35022	'Avaré'
3500600	"AGUAS DE SAO PEDRO"	35	-47.8839747409776	-22.5973395538539	3506	'Piracicaba'	35028	'Piracicaba'
3500709	"AGUDOS"	35	-48.9901562879424	-22.474037	3504	'Bauru'	35020	'Bauru'
3500758	"ALAMBARI"	35	-47.8935883872336	-23.5538988926706	3511	'Itapetininga'	35042	'Itapetininga'
3500808	"ALFREDO MARCONDES"	35	-51.4129380665063	-21.9527411236001	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3500907	"ALTAIR"	35	-49.060110754241	-20.523304881604	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3501004	"ALTINOPOLIS"	35	-47.3732802928901	-21.0245826445728	3502	'Ribeirão Preto'	35015	'Batatais'
3501103	"ALTO ALEGRE"	35	-50.1635967960874	-21.5816894572053	3503	'Araçatuba'	35018	'Birigui'
3501152	"ALUMINIO"	35	-47.2590569184704	-23.5333730478469	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3501202	"ALVARES FLORENCE"	35	-49.91118481249	-20.3198762474474	3501	'São José do Rio Preto'	35003	'Votuporanga'
3501301	"ALVARES MACHADO"	35	-51.4687972730125	-22.077778995	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3501400	"ALVARO DE CARVALHO"	35	-49.720609020316	-22.0763746340433	3509	'Marília'	35038	'Marília'
3501509	"ALVINLANDIA"	35	-49.7630330293599	-22.4450101515788	3509	'Marília'	35038	'Marília'
3501608	"AMERICANA"	35	-47.3303629263814	-22.7408835	3507	'Campinas'	35032	'Campinas'
3501707	"AMERICO BRASILIENSE"	35	-48.1066045618439	-21.7300365	3505	'Araraquara'	35024	'Araraquara'
3501806	"AMERICO DE CAMPOS"	35	-49.7270268374496	-20.2964019435983	3501	'São José do Rio Preto'	35003	'Votuporanga'
3501905	"AMPARO"	35	-46.7650856904637	-22.6993886263407	3507	'Campinas'	35033	'Amparo'
3502002	"ANALANDIA"	35	-47.6607664159226	-22.1287854993409	3505	'Araraquara'	35025	'São Carlos'
3502101	"ANDRADINA"	35	-51.3788477947637	-20.901463515	3503	'Araçatuba'	35016	'Andradina'
3502200	"ANGATUBA"	35	-48.406759616493	-23.483987	3511	'Itapetininga'	35042	'Itapetininga'
3502309	"ANHEMBI"	35	-48.126926830643	-22.786320939625	3504	'Bauru'	35023	'Botucatu'
3502408	"ANHUMAS"	35	-51.386074423278	-22.2932371758311	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3502507	"APARECIDA"	35	-45.2294293380918	-22.848154	3513	'Vale do Paraíba Paulista'	35051	'Guaratinguetá'
3502606	"APARECIDA D'OESTE"	35	-50.8856157061664	-20.4508453725492	3501	'São José do Rio Preto'	35001	'Jales'
3502705	"APIAI"	35	-48.8486599046398	-24.513316	3511	'Itapetininga'	35044	'Capão Bonito'
3502754	"ARACARIGUAMA"	35	-47.0715476361902	-23.4300408481693	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3502804	"ARACATUBA"	35	-50.4392260727526	-21.205476	3503	'Araçatuba'	35017	'Araçatuba'
3502903	"ARACOIABA DA SERRA"	35	-47.5872429386271	-23.5073197972187	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3503000	"ARAMINA"	35	-47.7860130410377	-20.0899442071251	3502	'Ribeirão Preto'	35011	'Ituverava'
3503109	"ARANDU"	35	-49.0509758715375	-23.1334071156444	3504	'Bauru'	35022	'Avaré'
3503158	"ARAPEI"	35	-44.4481065567943	-22.6747987232725	3513	'Vale do Paraíba Paulista'	35052	'Bananal'
3503208	"ARARAQUARA"	35	-48.1744399375438	-21.7903595	3505	'Araraquara'	35024	'Araraquara'
3503307	"ARARAS"	35	-47.3858295274694	-22.3570865196587	3506	'Piracicaba'	35027	'Limeira'
3503356	"ARCO-IRIS"	35	-50.4649108682641	-21.7739140250212	3509	'Marília'	35037	'Tupã'
3503406	"AREALVA"	35	-48.9204148013707	-22.0247674993088	3504	'Bauru'	35020	'Bauru'
3503505	"AREIAS"	35	-44.6994320050905	-22.5821938858719	3513	'Vale do Paraíba Paulista'	35052	'Bananal'
3503604	"AREIOPOLIS"	35	-48.6655945584847	-22.6739404491646	3504	'Bauru'	35020	'Bauru'
3503703	"ARIRANHA"	35	-48.7883365641079	-21.1861274429158	3501	'São José do Rio Preto'	35005	'Catanduva'
3503802	"ARTUR NOGUEIRA"	35	-47.1643011502678	-22.5713430104766	3507	'Campinas'	35031	'Mogi Mirim'
3503901	"ARUJA"	35	-46.3204896001138	-23.3958267409999	3515	'Metropolitana de São Paulo'	35059	'Guarulhos'
3503950	"ASPASIA"	35	-50.7269626714191	-20.158189985895	3501	'São José do Rio Preto'	35001	'Jales'
3504008	"ASSIS"	35	-50.41751004	-22.66283502	3510	'Assis'	35039	'Assis'
3504107	"ATIBAIA"	35	-46.5550625006743	-23.116308	3512	'Macro Metropolitana Paulista'	35048	'Bragança Paulista'
3504206	"AURIFLAMA"	35	-50.5539593332149	-20.6873348994576	3501	'São José do Rio Preto'	35006	'Auriflama'
3504305	"AVAI"	35	-49.3368150411834	-22.1567721162872	3504	'Bauru'	35020	'Bauru'
3504404	"AVANHANDAVA"	35	-49.9426973011876	-21.4608705607152	3503	'Araçatuba'	35018	'Birigui'
3504503	"AVARE"	35	-48.9232631943567	-23.1031935	3504	'Bauru'	35022	'Avaré'
3504602	"BADY BASSITT"	35	-49.4485737092931	-20.9185637795998	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3504701	"BALBINOS"	35	-49.3564734994135	-21.9015237820312	3504	'Bauru'	35020	'Bauru'
3504800	"BALSAMO"	35	-49.5793276900247	-20.7382637781816	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3504909	"BANANAL"	35	-44.3233301289908	-22.6826159993241	3513	'Vale do Paraíba Paulista'	35052	'Bananal'
3505005	"BARAO DE ANTONINA"	35	-49.5660638969023	-23.6271105197246	3511	'Itapetininga'	35041	'Itapeva'
3505104	"BARBOSA"	35	-49.9539885165489	-21.2590259219708	3503	'Araçatuba'	35018	'Birigui'
3505203	"BARIRI"	35	-48.7415247712398	-22.071978	3504	'Bauru'	35021	'Jaú'
3505302	"BARRA BONITA"	35	-48.5632292275695	-22.4911455	3504	'Bauru'	35021	'Jaú'
3505351	"BARRA DO CHAPEU"	35	-49.0271391368039	-24.4714259992879	3511	'Itapetininga'	35044	'Capão Bonito'
3505401	"BARRA DO TURVO"	35	-48.5023434527708	-24.7593866560173	3514	'Litoral Sul Paulista'	35055	'Registro'
3505500	"BARRETOS"	35	-48.5673778394551	-20.558455515	3502	'Ribeirão Preto'	35009	'Barretos'
3505609	"BARRINHA"	35	-48.1628135185261	-21.1917435	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3505708	"BARUERI"	35	-46.8746528865305	-23.508902	3515	'Metropolitana de São Paulo'	35057	'Osasco'
3505807	"BASTOS"	35	-50.7348708618954	-21.92103747	3509	'Marília'	35037	'Tupã'
3505906	"BATATAIS"	35	-47.5861067268683	-20.8919295	3502	'Ribeirão Preto'	35015	'Batatais'
3506003	"BAURU"	35	-49.0830008670904	-22.3251225	3504	'Bauru'	35020	'Bauru'
3506102	"BEBEDOURO"	35	-48.4773621747017	-20.94981552	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3506201	"BENTO DE ABREU"	35	-50.8118522148056	-21.2691080212024	3503	'Araçatuba'	35017	'Araçatuba'
3506300	"BERNARDINO DE CAMPOS"	35	-49.4740434846817	-23.0135530040032	3510	'Assis'	35040	'Ourinhos'
3506359	"BERTIOGA"	35	-46.1365383351346	-23.8540145	3515	'Metropolitana de São Paulo'	35063	'Santos'
3506409	"BILAC"	35	-50.4811104805002	-21.4025711351917	3503	'Araçatuba'	35018	'Birigui'
3506508	"BIRIGUI"	35	-50.339328516987	-21.2923922882494	3503	'Araçatuba'	35018	'Birigui'
3506607	"BIRITIBA-MIRIM"	35	-46.0412122248146	-23.5710333875	3515	'Metropolitana de São Paulo'	35062	'Mogi das Cruzes'
3506706	"BOA ESPERANCA DO SUL"	35	-48.3905969069851	-21.9924841634404	3505	'Araraquara'	35024	'Araraquara'
3506805	"BOCAINA"	35	-48.5204936243826	-22.1339225456857	3504	'Bauru'	35021	'Jaú'
3506904	"BOFETE"	35	-48.2600330588198	-23.1025199999814	3504	'Bauru'	35023	'Botucatu'
3507001	"BOITUVA"	35	-47.6714734979741	-23.2819440034999	3511	'Itapetininga'	35043	'Tatuí'
3507100	"BOM JESUS DOS PERDOES"	35	-46.4664928426292	-23.1308374287388	3512	'Macro Metropolitana Paulista'	35048	'Bragança Paulista'
3507159	"BOM SUCESSO DE ITARARE"	35	-49.1437619226039	-24.3182628407156	3511	'Itapetininga'	35041	'Itapeva'
3507209	"BORA"	35	-50.544880999221	-22.2701171066813	3510	'Assis'	35039	'Assis'
3507308	"BORACEIA"	35	-48.7792182831576	-22.1932056543657	3504	'Bauru'	35021	'Jaú'
3507407	"BORBOREMA"	35	-49.072640247934	-21.6215379942474	3505	'Araraquara'	35024	'Araraquara'
3507456	"BOREBI"	35	-48.9715958405052	-22.5678331168654	3504	'Bauru'	35020	'Bauru'
3507506	"BOTUCATU"	35	-48.4412893843504	-22.8883815	3504	'Bauru'	35023	'Botucatu'
3507605	"BRAGANCA PAULISTA"	35	-46.5423333739798	-22.9568955	3512	'Macro Metropolitana Paulista'	35048	'Bragança Paulista'
3507704	"BRAUNA"	35	-50.3181656103264	-21.5010212084554	3503	'Araçatuba'	35018	'Birigui'
3507753	"BREJO ALEGRE"	35	-50.187258508288	-21.166128499364	3503	'Araçatuba'	35018	'Birigui'
3507803	"BRODOWSKI"	35	-47.6563979568538	-20.9901403801924	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3507902	"BROTAS"	35	-48.1268333241157	-22.286516985	3506	'Piracicaba'	35026	'Rio Claro'
3508009	"BURI"	35	-48.5974149737978	-23.7993814189726	3511	'Itapetininga'	35041	'Itapeva'
3508108	"BURITAMA"	35	-50.1492812527853	-21.0670395669022	3503	'Araçatuba'	35018	'Birigui'
3508207	"BURITIZAL"	35	-47.7088600395175	-20.1931482216386	3502	'Ribeirão Preto'	35011	'Ituverava'
3508306	"CABRALIA PAULISTA"	35	-49.3324468331431	-22.4550869581335	3504	'Bauru'	35020	'Bauru'
3508405	"CABREUVA"	35	-47.1336583734349	-23.3126743947758	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3508504	"CACAPAVA"	35	-45.7077303650875	-23.100663752709	3513	'Vale do Paraíba Paulista'	35050	'São José dos Campos'
3508603	"CACHOEIRA PAULISTA"	35	-45.0106304149283	-22.6647543761424	3513	'Vale do Paraíba Paulista'	35051	'Guaratinguetá'
3508702	"CACONDE"	35	-46.6468348789643	-21.5287380374974	3507	'Campinas'	35030	'São João da Boa Vista'
3508801	"CAFELANDIA"	35	-49.6003544059215	-21.8097052866096	3504	'Bauru'	35019	'Lins'
3508900	"CAIABU"	35	-51.2359531354811	-22.0123252565933	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3509007	"CAIEIRAS"	35	-46.7441014176654	-23.3621160547412	3515	'Metropolitana de São Paulo'	35058	'Franco da Rocha'
3509106	"CAIUA"	35	-51.9868926967256	-21.8299102733969	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3509205	"CAJAMAR"	35	-46.8829201465695	-23.360971384728	3515	'Metropolitana de São Paulo'	35057	'Osasco'
3509254	"CAJATI"	35	-48.1049998090052	-24.726360972223	3514	'Litoral Sul Paulista'	35055	'Registro'
3509304	"CAJOBI"	35	-48.8101223647094	-20.8790925178628	3501	'São José do Rio Preto'	35005	'Catanduva'
3509403	"CAJURU"	35	-47.304266116797	-21.2747175	3502	'Ribeirão Preto'	35015	'Batatais'
3509452	"CAMPINA DO MONTE ALEGRE"	35	-48.4803990199383	-23.5840768383134	3511	'Itapetininga'	35042	'Itapetininga'
3509502	"CAMPINAS"	35	-47.0601562729732	-22.9073425	3507	'Campinas'	35032	'Campinas'
3509601	"CAMPO LIMPO PAULISTA"	35	-46.7638192327891	-23.2093964295223	3512	'Macro Metropolitana Paulista'	35047	'Jundiaí'
3509700	"CAMPOS DO JORDAO"	35	-45.5892017004491	-22.7400919138812	3513	'Vale do Paraíba Paulista'	35049	'Campos do Jordão'
3509809	"CAMPOS NOVOS PAULISTA"	35	-50.0017947248853	-22.5997489993283	3510	'Assis'	35039	'Assis'
3509908	"CANANEIA"	35	-47.9284828144297	-25.0169080699809	3514	'Litoral Sul Paulista'	35055	'Registro'
3509957	"CANAS"	35	-45.056975740535	-22.69066906604	3513	'Vale do Paraíba Paulista'	35051	'Guaratinguetá'
3510005	"CANDIDO MOTA"	35	-50.3883931717685	-22.7469255	3510	'Assis'	35039	'Assis'
3510104	"CANDIDO RODRIGUES"	35	-48.634039310838	-21.3226135828498	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3510153	"CANITAR"	35	-49.7854319545023	-23.0098372187953	3510	'Assis'	35040	'Ourinhos'
3510203	"CAPAO BONITO"	35	-48.3514345179275	-24.00680097	3511	'Itapetininga'	35044	'Capão Bonito'
3510302	"CAPELA DO ALTO"	35	-47.7361184436443	-23.4699029552539	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3510401	"CAPIVARI"	35	-47.5022061546687	-22.9995489145883	3506	'Piracicaba'	35028	'Piracicaba'
3510500	"CARAGUATATUBA"	35	-45.4108183822498	-23.6220065	3513	'Vale do Paraíba Paulista'	35054	'Caraguatatuba'
3510609	"CARAPICUIBA"	35	-46.8414454319096	-23.5352495	3515	'Metropolitana de São Paulo'	35057	'Osasco'
3510708	"CARDOSO"	35	-49.9149423028903	-20.0809915099979	3501	'São José do Rio Preto'	35003	'Votuporanga'
3510807	"CASA BRANCA"	35	-47.0797582048272	-21.77798699	3507	'Campinas'	35030	'São João da Boa Vista'
3510906	"CASSIA DOS COQUEIROS"	35	-47.1671058770489	-21.2850004285294	3502	'Ribeirão Preto'	35015	'Batatais'
3511003	"CASTILHO"	35	-51.4894070558423	-20.8720265541211	3503	'Araçatuba'	35016	'Andradina'
3511102	"CATANDUVA"	35	-48.9758709390428	-21.1395385	3501	'São José do Rio Preto'	35005	'Catanduva'
3511201	"CATIGUA"	35	-49.0577421525082	-21.0485799993669	3501	'São José do Rio Preto'	35005	'Catanduva'
3511300	"CEDRAL"	35	-49.272841545891	-20.9042319222866	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3511409	"CERQUEIRA CESAR"	35	-49.1653301708879	-23.0347974993199	3504	'Bauru'	35022	'Avaré'
3511508	"CERQUILHO"	35	-47.7375313251079	-23.1686725	3511	'Itapetininga'	35043	'Tatuí'
3511607	"CESARIO LANGE"	35	-47.9521106553903	-23.2247318358775	3511	'Itapetininga'	35043	'Tatuí'
3511706	"CHARQUEADA"	35	-47.7757002034567	-22.5088824120687	3506	'Piracicaba'	35028	'Piracicaba'
3557204	"CHAVANTES"	35	-49.7139361486766	-23.0320056319212	3510	'Assis'	35040	'Ourinhos'
3511904	"CLEMENTINA"	35	-50.4503486921567	-21.5603100367994	3503	'Araçatuba'	35018	'Birigui'
3512001	"COLINA"	35	-48.5397383290134	-20.7187344993776	3502	'Ribeirão Preto'	35009	'Barretos'
3512100	"COLOMBIA"	35	-48.6874841798297	-20.1715588433353	3502	'Ribeirão Preto'	35009	'Barretos'
3512209	"CONCHAL"	35	-47.1743757425524	-22.3300764479999	3506	'Piracicaba'	35027	'Limeira'
3512308	"CONCHAS"	35	-48.0098921336448	-23.012958080649	3504	'Bauru'	35023	'Botucatu'
3512407	"CORDEIROPOLIS"	35	-47.4582829254002	-22.481707032329	3506	'Piracicaba'	35027	'Limeira'
3512506	"COROADOS"	35	-50.2872958479117	-21.3540528502724	3503	'Araçatuba'	35018	'Birigui'
3512605	"CORONEL MACEDO"	35	-49.3189123964155	-23.6322349818014	3511	'Itapetininga'	35041	'Itapeva'
3512704	"CORUMBATAI"	35	-47.6266101304082	-22.2189967501708	3506	'Piracicaba'	35026	'Rio Claro'
3512803	"COSMOPOLIS"	35	-47.1967707767946	-22.6457848858527	3507	'Campinas'	35032	'Campinas'
3512902	"COSMORAMA"	35	-49.7788596931171	-20.477034658871	3501	'São José do Rio Preto'	35003	'Votuporanga'
3513009	"COTIA"	35	-46.9318463278886	-23.603514	3515	'Metropolitana de São Paulo'	35060	'Itapecerica da Serra'
3513108	"CRAVINHOS"	35	-47.730042348128	-21.3404305	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3513207	"CRISTAIS PAULISTA"	35	-47.4238064520508	-20.4024919993924	3502	'Ribeirão Preto'	35012	'Franca'
3513306	"CRUZALIA"	35	-50.7936661595576	-22.7454989289789	3510	'Assis'	35039	'Assis'
3513405	"CRUZEIRO"	35	-44.9617319605967	-22.577749880422	3513	'Vale do Paraíba Paulista'	35051	'Guaratinguetá'
3513504	"CUBATAO"	35	-46.4200317682745	-23.883839	3515	'Metropolitana de São Paulo'	35063	'Santos'
3513603	"CUNHA"	35	-44.9580269034981	-23.0747501474065	3513	'Vale do Paraíba Paulista'	35053	'Paraibuna/Paraitinga'
3513702	"DESCALVADO"	35	-47.6206639718592	-21.909083	3505	'Araraquara'	35025	'São Carlos'
3513801	"DIADEMA"	35	-46.623381393203	-23.689295	3515	'Metropolitana de São Paulo'	35061	'São Paulo'
3513850	"DIRCE REIS"	35	-50.6060559888332	-20.4644127943002	3501	'São José do Rio Preto'	35001	'Jales'
3513900	"DIVINOLANDIA"	35	-46.7368697867924	-21.6616215060366	3507	'Campinas'	35030	'São João da Boa Vista'
3514007	"DOBRADA"	35	-48.4002427192517	-21.5148043304059	3505	'Araraquara'	35024	'Araraquara'
3514106	"DOIS CORREGOS"	35	-48.3826759875355	-22.367316	3504	'Bauru'	35021	'Jaú'
3514205	"DOLCINOPOLIS"	35	-50.5153630840246	-20.1228706610567	3501	'São José do Rio Preto'	35001	'Jales'
3514304	"DOURADO"	35	-48.3162358063433	-22.1131671963671	3505	'Araraquara'	35025	'São Carlos'
3514403	"DRACENA"	35	-51.5340496600627	-21.486137535	3508	'Presidente Prudente'	35034	'Dracena'
3514502	"DUARTINA"	35	-49.405045410633	-22.4148813758078	3504	'Bauru'	35020	'Bauru'
3514601	"DUMONT"	35	-47.9708434494443	-21.2333259993624	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3514700	"ECHAPORA"	35	-50.2070061462144	-22.424996999334	3509	'Marília'	35038	'Marília'
3514809	"ELDORADO"	35	-48.103228422535	-24.525386611147	3514	'Litoral Sul Paulista'	35055	'Registro'
3514908	"ELIAS FAUSTO"	35	-47.3767742396416	-23.0425367211808	3507	'Campinas'	35032	'Campinas'
3514924	"ELISIARIO"	35	-49.1108358902026	-21.1644290184892	3501	'São José do Rio Preto'	35005	'Catanduva'
3514957	"EMBAUBA"	35	-48.8326202921458	-20.9826680548747	3501	'São José do Rio Preto'	35005	'Catanduva'
3515004	"EMBU"	35	-46.8508599936736	-23.6473125	3515	'Metropolitana de São Paulo'	35060	'Itapecerica da Serra'
3515103	"EMBU-GUACU"	35	-46.8171088725496	-23.8318291037713	3515	'Metropolitana de São Paulo'	35060	'Itapecerica da Serra'
3515129	"EMILIANOPOLIS"	35	-51.4804314280506	-21.8313089781001	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3515152	"ENGENHEIRO COELHO"	35	-47.2130797305393	-22.4911899524775	3507	'Campinas'	35031	'Mogi Mirim'
3515186	"ESPIRITO SANTO DO PINHAL"	35	-46.7455142898696	-22.1970535	3507	'Campinas'	35030	'São João da Boa Vista'
3515194	"ESPIRITO SANTO DO TURVO"	35	-49.4298252858159	-22.6949734920695	3510	'Assis'	35040	'Ourinhos'
3557303	"ESTIVA GERBI"	35	-46.9536026904179	-22.2745889131265	3507	'Campinas'	35031	'Mogi Mirim'
3515301	"ESTRELA DO NORTE"	35	-51.6641761909517	-22.4905989019911	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3515202	"ESTRELA D'OESTE"	35	-50.4054668479512	-20.2860822039747	3501	'São José do Rio Preto'	35002	'Fernandópolis'
3515350	"EUCLIDES DA CUNHA PAULISTA"	35	-52.5908983802766	-22.5549969202085	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3515400	"FARTURA"	35	-49.5120533766983	-23.3889609139385	3510	'Assis'	35040	'Ourinhos'
3515608	"FERNANDO PRESTES"	35	-48.6922730531942	-21.2671219899524	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3515509	"FERNANDOPOLIS"	35	-50.2487484305834	-20.28238299	3501	'São José do Rio Preto'	35002	'Fernandópolis'
3515657	"FERNAO"	35	-49.5198412111563	-22.3591383191477	3509	'Marília'	35038	'Marília'
3515707	"FERRAZ DE VASCONCELOS"	35	-46.3665526715742	-23.5415445	3515	'Metropolitana de São Paulo'	35062	'Mogi das Cruzes'
3515806	"FLORA RICA"	35	-51.3823008410719	-21.6767339356144	3508	'Presidente Prudente'	35035	'Adamantina'
3515905	"FLOREAL"	35	-50.1456890086828	-20.6740312279254	3501	'São José do Rio Preto'	35006	'Auriflama'
3516002	"FLORIDA PAULISTA"	35	-51.1688764668277	-21.6134276151642	3508	'Presidente Prudente'	35035	'Adamantina'
3516101	"FLORINIA"	35	-50.72482247338	-22.903568778762	3510	'Assis'	35039	'Assis'
3516200	"FRANCA"	35	-47.4023316256775	-20.536097	3502	'Ribeirão Preto'	35012	'Franca'
3516309	"FRANCISCO MORATO"	35	-46.7325267047053	-23.2758255	3515	'Metropolitana de São Paulo'	35058	'Franco da Rocha'
3516408	"FRANCO DA ROCHA"	35	-46.7278746685526	-23.3203025	3515	'Metropolitana de São Paulo'	35058	'Franco da Rocha'
3516507	"GABRIEL MONTEIRO"	35	-50.5554608419398	-21.5289801353128	3503	'Araçatuba'	35018	'Birigui'
3516606	"GALIA"	35	-49.55211132983	-22.294019248259	3509	'Marília'	35038	'Marília'
3516705	"GARCA"	35	-49.656529935058	-22.21070949	3509	'Marília'	35038	'Marília'
3516804	"GASTAO VIDIGAL"	35	-50.1902197322049	-20.7952394993746	3501	'São José do Rio Preto'	35006	'Auriflama'
3516853	"GAVIAO PEIXOTO"	35	-48.4954592027481	-21.8403669022702	3505	'Araraquara'	35024	'Araraquara'
3516903	"GENERAL SALGADO"	35	-50.3618137021237	-20.648369316722	3501	'São José do Rio Preto'	35006	'Auriflama'
3517000	"GETULINA"	35	-49.929283572294	-21.7998305974601	3504	'Bauru'	35019	'Lins'
3517109	"GLICERIO"	35	-50.2084167281141	-21.3797778057066	3503	'Araçatuba'	35018	'Birigui'
3517208	"GUAICARA"	35	-49.7987616909618	-21.622142999353	3504	'Bauru'	35019	'Lins'
3517307	"GUAIMBE"	35	-49.8971777502379	-21.91092065892	3504	'Bauru'	35019	'Lins'
3517406	"GUAIRA"	35	-48.314470490026	-20.320144335	3502	'Ribeirão Preto'	35010	'São Joaquim da Barra'
3517505	"GUAPIACU"	35	-49.2191458577245	-20.7964486248653	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3517604	"GUAPIARA"	35	-48.5276813218495	-24.1825265	3511	'Itapetininga'	35044	'Capão Bonito'
3517703	"GUARA"	35	-47.8245929501746	-20.4275570617021	3502	'Ribeirão Preto'	35011	'Ituverava'
3517802	"GUARACAI"	35	-51.2091063449954	-21.0328813875825	3503	'Araçatuba'	35016	'Andradina'
3517901	"GUARACI"	35	-48.9445025950499	-20.4988092128935	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3518008	"GUARANI D'OESTE"	35	-50.3415338816928	-20.0757055718498	3501	'São José do Rio Preto'	35002	'Fernandópolis'
3518107	"GUARANTA"	35	-49.5948218473783	-21.8951462014728	3504	'Bauru'	35020	'Bauru'
3518206	"GUARARAPES"	35	-50.6426390482505	-21.253446495	3503	'Araçatuba'	35017	'Araçatuba'
3518305	"GUARAREMA"	35	-46.0410534647582	-23.415233019833	3515	'Metropolitana de São Paulo'	35062	'Mogi das Cruzes'
3518404	"GUARATINGUETA"	35	-45.1916001284202	-22.8174250893317	3513	'Vale do Paraíba Paulista'	35051	'Guaratinguetá'
3518503	"GUAREI"	35	-48.1845381753097	-23.3731401917664	3511	'Itapetininga'	35042	'Itapetininga'
3518602	"GUARIBA"	35	-48.2340567272232	-21.357996	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3518701	"GUARUJA"	35	-46.2490342794416	-23.995149	3515	'Metropolitana de São Paulo'	35063	'Santos'
3518800	"GUARULHOS"	35	-46.5310840856611	-23.468506	3515	'Metropolitana de São Paulo'	35059	'Guarulhos'
3518859	"GUATAPARA"	35	-48.037729357499	-21.4918946535898	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3518909	"GUZOLANDIA"	35	-50.6614595041436	-20.6501686872551	3501	'São José do Rio Preto'	35006	'Auriflama'
3519006	"HERCULANDIA"	35	-50.3855215980828	-22.0037471806678	3509	'Marília'	35037	'Tupã'
3519055	"HOLAMBRA"	35	-47.0592869062413	-22.6417496242127	3507	'Campinas'	35032	'Campinas'
3519071	"HORTOLANDIA"	35	-47.2210966097575	-22.858395	3507	'Campinas'	35032	'Campinas'
3519105	"IACANGA"	35	-49.0169299189126	-21.8919776026997	3504	'Bauru'	35020	'Bauru'
3519204	"IACRI"	35	-50.6891999323707	-21.8550610868608	3509	'Marília'	35037	'Tupã'
3519253	"IARAS"	35	-49.1561791517071	-22.8718922795928	3504	'Bauru'	35022	'Avaré'
3519303	"IBATE"	35	-48.0023882086525	-21.955602	3505	'Araraquara'	35025	'São Carlos'
3519402	"IBIRA"	35	-49.238861531251	-21.0805374993661	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3519501	"IBIRAREMA"	35	-50.07912539457	-22.8145429597086	3510	'Assis'	35039	'Assis'
3519600	"IBITINGA"	35	-48.8276946930001	-21.7570829843498	3505	'Araraquara'	35024	'Araraquara'
3519709	"IBIUNA"	35	-47.2204911874899	-23.6526325	3512	'Macro Metropolitana Paulista'	35045	'Piedade'
3519808	"ICEM"	35	-49.1961201914742	-20.3435051210596	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3519907	"IEPE"	35	-51.0774138909334	-22.6631014713253	3510	'Assis'	35039	'Assis'
3520004	"IGARACU DO TIETE"	35	-48.5570661013871	-22.511149	3504	'Bauru'	35021	'Jaú'
3520103	"IGARAPAVA"	35	-47.751066571313	-20.039612535	3502	'Ribeirão Preto'	35011	'Ituverava'
3520202	"IGARATA"	35	-46.1563144239377	-23.204843	3513	'Vale do Paraíba Paulista'	35050	'São José dos Campos'
3520301	"IGUAPE"	35	-47.5531374088176	-24.7069541964258	3514	'Litoral Sul Paulista'	35055	'Registro'
3520426	"ILHA COMPRIDA"	35	-47.5543169659299	-24.7392399403978	3514	'Litoral Sul Paulista'	35055	'Registro'
3520442	"ILHA SOLTEIRA"	35	-51.344890657635	-20.4293725	3503	'Araçatuba'	35016	'Andradina'
3520400	"ILHABELA"	35	-45.3540566669409	-23.7886525	3513	'Vale do Paraíba Paulista'	35054	'Caraguatatuba'
3520509	"INDAIATUBA"	35	-47.2123089402514	-23.081646	3507	'Campinas'	35032	'Campinas'
3520608	"INDIANA"	35	-51.2517585134202	-22.1720934486803	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3520707	"INDIAPORA"	35	-50.288981041994	-19.9775429993935	3501	'São José do Rio Preto'	35002	'Fernandópolis'
3520806	"INUBIA PAULISTA"	35	-50.9643748939952	-21.7699119903207	3508	'Presidente Prudente'	35035	'Adamantina'
3520905	"IPAUSSU"	35	-49.6268069783117	-23.0529129993195	3510	'Assis'	35040	'Ourinhos'
3521002	"IPERO"	35	-47.6898938935446	-23.350277390298	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3521101	"IPEUNA"	35	-47.7190959711091	-22.4372995021949	3506	'Piracicaba'	35026	'Rio Claro'
3521150	"IPIGUA"	35	-49.3881423816844	-20.661645528879	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3521200	"IPORANGA"	35	-48.5896007140876	-24.584460178277	3511	'Itapetininga'	35044	'Capão Bonito'
3521309	"IPUA"	35	-48.0173850385104	-20.4414826010419	3502	'Ribeirão Preto'	35010	'São Joaquim da Barra'
3521408	"IRACEMAPOLIS"	35	-47.5222466341717	-22.5830369342824	3506	'Piracicaba'	35027	'Limeira'
3521507	"IRAPUA"	35	-49.4081517822264	-21.276437176419	3501	'São José do Rio Preto'	35008	'Novo Horizonte'
3521606	"IRAPURU"	35	-51.3501727308157	-21.5674762352993	3508	'Presidente Prudente'	35035	'Adamantina'
3521705	"ITABERA"	35	-49.1371332858525	-23.8598114700688	3511	'Itapetininga'	35041	'Itapeva'
3521804	"ITAI"	35	-49.0810322484854	-23.419055385	3504	'Bauru'	35022	'Avaré'
3521903	"ITAJOBI"	35	-49.0543110797985	-21.3157070587079	3501	'São José do Rio Preto'	35008	'Novo Horizonte'
3522000	"ITAJU"	35	-48.8050217362657	-21.9846724207758	3504	'Bauru'	35021	'Jaú'
3522109	"ITANHAEM"	35	-46.7909914828787	-24.1861206668328	3514	'Litoral Sul Paulista'	35056	'Itanhaém'
3522158	"ITAOCA"	35	-48.8428556815305	-24.642594234804	3511	'Itapetininga'	35044	'Capão Bonito'
3522208	"ITAPECERICA DA SERRA"	35	-46.8505519668521	-23.715357	3515	'Metropolitana de São Paulo'	35060	'Itapecerica da Serra'
3522307	"ITAPETININGA"	35	-48.0461428954547	-23.5878725	3511	'Itapetininga'	35042	'Itapetininga'
3522406	"ITAPEVA"	35	-48.8773891590654	-23.9834379992987	3511	'Itapetininga'	35041	'Itapeva'
3522505	"ITAPEVI"	35	-46.9333728634881	-23.546934	3515	'Metropolitana de São Paulo'	35057	'Osasco'
3522604	"ITAPIRA"	35	-46.8212480111337	-22.4360054993337	3507	'Campinas'	35031	'Mogi Mirim'
3522653	"ITAPIRAPUA PAULISTA"	35	-49.1721656552808	-24.5715534992858	3511	'Itapetininga'	35044	'Capão Bonito'
3522703	"ITAPOLIS"	35	-48.8133919855384	-21.5947039943537	3505	'Araraquara'	35024	'Araraquara'
3522802	"ITAPORANGA"	35	-49.4843963120809	-23.7034999431633	3511	'Itapetininga'	35041	'Itapeva'
3522901	"ITAPUI"	35	-48.7188741595351	-22.2321276250437	3504	'Bauru'	35021	'Jaú'
3523008	"ITAPURA"	35	-51.5099693695097	-20.6398257755739	3503	'Araçatuba'	35016	'Andradina'
3523107	"ITAQUAQUECETUBA"	35	-46.3516031409654	-23.4768975	3515	'Metropolitana de São Paulo'	35062	'Mogi das Cruzes'
3523206	"ITARARE"	35	-49.3361197139295	-24.11213796	3511	'Itapetininga'	35041	'Itapeva'
3523305	"ITARIRI"	35	-47.1757260565555	-24.292005633897	3514	'Litoral Sul Paulista'	35056	'Itanhaém'
3523404	"ITATIBA"	35	-46.8375578529412	-23.0048529993206	3512	'Macro Metropolitana Paulista'	35048	'Bragança Paulista'
3523503	"ITATINGA"	35	-48.6133802692841	-23.1042734016774	3504	'Bauru'	35022	'Avaré'
3523602	"ITIRAPINA"	35	-47.8198848666073	-22.2539679738051	3506	'Piracicaba'	35026	'Rio Claro'
3523701	"ITIRAPUA"	35	-47.2199528848551	-20.6424265297474	3502	'Ribeirão Preto'	35012	'Franca'
3523800	"ITOBI"	35	-46.9734186541802	-21.7349018191477	3507	'Campinas'	35030	'São João da Boa Vista'
3523909	"ITU"	35	-47.299749835961	-23.2654425	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3524006	"ITUPEVA"	35	-47.0557011520917	-23.1534096261863	3512	'Macro Metropolitana Paulista'	35047	'Jundiaí'
3524105	"ITUVERAVA"	35	-47.780415655389	-20.3362879658708	3502	'Ribeirão Preto'	35011	'Ituverava'
3524204	"JABORANDI"	35	-48.4134449206286	-20.6872244993758	3502	'Ribeirão Preto'	35010	'São Joaquim da Barra'
3524303	"JABOTICABAL"	35	-48.3203497512575	-21.2544714993619	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3524402	"JACAREI"	35	-45.9695932044094	-23.3048804993138	3513	'Vale do Paraíba Paulista'	35050	'São José dos Campos'
3524501	"JACI"	35	-49.5733446115317	-20.8840851331179	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3524600	"JACUPIRANGA"	35	-48.0047045115401	-24.6981502809578	3514	'Litoral Sul Paulista'	35055	'Registro'
3524709	"JAGUARIUNA"	35	-46.9823434662879	-22.7067819581976	3507	'Campinas'	35032	'Campinas'
3524808	"JALES"	35	-50.5503561990428	-20.2678530475	3501	'São José do Rio Preto'	35001	'Jales'
3524907	"JAMBEIRO"	35	-45.6936551245799	-23.2565768668366	3513	'Vale do Paraíba Paulista'	35053	'Paraibuna/Paraitinga'
3525003	"JANDIRA"	35	-46.9052211417411	-23.529939	3515	'Metropolitana de São Paulo'	35057	'Osasco'
3525102	"JARDINOPOLIS"	35	-47.7653529285234	-21.022457	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3525201	"JARINU"	35	-46.7382709354058	-23.1030625	3512	'Macro Metropolitana Paulista'	35048	'Bragança Paulista'
3525300	"JAU"	35	-48.5581413878331	-22.29579099	3504	'Bauru'	35021	'Jaú'
3525409	"JERIQUARA"	35	-47.58874391657	-20.3120415892929	3502	'Ribeirão Preto'	35012	'Franca'
3525508	"JOANOPOLIS"	35	-46.2734166101367	-22.9306782182056	3512	'Macro Metropolitana Paulista'	35048	'Bragança Paulista'
3525607	"JOAO RAMALHO"	35	-50.768535308414	-22.2510460550787	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3525706	"JOSE BONIFACIO"	35	-49.6862827160333	-21.053719035	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3525805	"JULIO MESQUITA"	35	-49.7907942837747	-22.0131689993437	3504	'Bauru'	35019	'Lins'
3525854	"JUMIRIM"	35	-47.7981735119048	-23.0825599993188	3506	'Piracicaba'	35028	'Piracicaba'
3525904	"JUNDIAI"	35	-46.8852739679967	-23.187668	3512	'Macro Metropolitana Paulista'	35047	'Jundiaí'
3526001	"JUNQUEIROPOLIS"	35	-51.434011950549	-21.511275749681	3508	'Presidente Prudente'	35034	'Dracena'
3526100	"JUQUIA"	35	-47.6353419676622	-24.3207030789727	3514	'Litoral Sul Paulista'	35055	'Registro'
3526209	"JUQUITIBA"	35	-47.0815940722918	-23.9356892015078	3515	'Metropolitana de São Paulo'	35060	'Itapecerica da Serra'
3526308	"LAGOINHA"	35	-45.190810820433	-23.0869213514864	3513	'Vale do Paraíba Paulista'	35053	'Paraibuna/Paraitinga'
3526407	"LARANJAL PAULISTA"	35	-47.8337807102663	-23.0540116065372	3511	'Itapetininga'	35043	'Tatuí'
3526506	"LAVINIA"	35	-51.0405016570685	-21.1648565654735	3503	'Araçatuba'	35017	'Araçatuba'
3526605	"LAVRINHAS"	35	-44.8931102793871	-22.570096474153	3513	'Vale do Paraíba Paulista'	35051	'Guaratinguetá'
3526704	"LEME"	35	-47.3887079696148	-22.185436005	3506	'Piracicaba'	35027	'Limeira'
3526803	"LENCOIS PAULISTA"	35	-48.7986819724573	-22.597507	3504	'Bauru'	35020	'Bauru'
3526902	"LIMEIRA"	35	-47.4019395233102	-22.562194	3506	'Piracicaba'	35027	'Limeira'
3527009	"LINDOIA"	35	-46.6614836163087	-22.5204881921692	3507	'Campinas'	35033	'Amparo'
3527108	"LINS"	35	-49.7514233866855	-21.6723465	3504	'Bauru'	35019	'Lins'
3527207	"LORENA"	35	-45.1242481441632	-22.7316930326296	3513	'Vale do Paraíba Paulista'	35051	'Guaratinguetá'
3527256	"LOURDES"	35	-50.226660095996	-20.9653905383037	3503	'Araçatuba'	35018	'Birigui'
3527306	"LOUVEIRA"	35	-46.9464402180487	-23.0867785	3512	'Macro Metropolitana Paulista'	35047	'Jundiaí'
3527405	"LUCELIA"	35	-51.0183491422409	-21.7234156460379	3508	'Presidente Prudente'	35035	'Adamantina'
3527504	"LUCIANOPOLIS"	35	-49.5231791244614	-22.4316399993339	3504	'Bauru'	35020	'Bauru'
3527603	"LUIS ANTONIO"	35	-47.7002799448476	-21.5517065252372	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3527702	"LUIZIANIA"	35	-50.3276394896385	-21.673602964563	3503	'Araçatuba'	35018	'Birigui'
3527801	"LUPERCIO"	35	-49.8203246999438	-22.4138153922327	3509	'Marília'	35038	'Marília'
3527900	"LUTECIA"	35	-50.3893271158818	-22.3434442872082	3510	'Assis'	35039	'Assis'
3528007	"MACATUBA"	35	-48.7114053869681	-22.5055496288439	3504	'Bauru'	35021	'Jaú'
3528106	"MACAUBAL"	35	-49.9634978203421	-20.8013135395633	3501	'São José do Rio Preto'	35007	'Nhandeara'
3528205	"MACEDONIA"	35	-50.197628484224	-20.1499979846925	3501	'São José do Rio Preto'	35002	'Fernandópolis'
3528304	"MAGDA"	35	-50.2275370471089	-20.6434813110551	3501	'São José do Rio Preto'	35006	'Auriflama'
3528403	"MAIRINQUE"	35	-47.1844826262497	-23.5474579999999	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3528502	"MAIRIPORA"	35	-46.5901958731419	-23.3224593829704	3515	'Metropolitana de São Paulo'	35058	'Franco da Rocha'
3528601	"MANDURI"	35	-49.3181131205831	-23.0033460898635	3510	'Assis'	35040	'Ourinhos'
3528700	"MARABA PAULISTA"	35	-51.9684674847115	-22.1103314993414	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3528809	"MARACAI"	35	-50.6689682495018	-22.6104153367619	3510	'Assis'	35039	'Assis'
3528858	"MARAPOAMA"	35	-49.1400008102662	-21.2587619255663	3501	'São José do Rio Preto'	35008	'Novo Horizonte'
3528908	"MARIAPOLIS"	35	-51.1828975550503	-21.7944933664673	3508	'Presidente Prudente'	35035	'Adamantina'
3529005	"MARILIA"	35	-49.9516456431033	-22.214933	3509	'Marília'	35038	'Marília'
3529104	"MARINOPOLIS"	35	-50.8256772948301	-20.4393989125252	3501	'São José do Rio Preto'	35001	'Jales'
3529203	"MARTINOPOLIS"	35	-51.1707680574885	-22.147832475	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3529302	"MATAO"	35	-48.3677476993662	-21.6029945062726	3505	'Araraquara'	35024	'Araraquara'
3529401	"MAUA"	35	-46.4582620121647	-23.6693345	3515	'Metropolitana de São Paulo'	35061	'São Paulo'
3529500	"MENDONCA"	35	-49.5820189988673	-21.1801561723046	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3529609	"MERIDIANO"	35	-50.1818318399051	-20.3541099031675	3501	'São José do Rio Preto'	35002	'Fernandópolis'
3529658	"MESOPOLIS"	35	-50.6220802653681	-19.9670371030093	3501	'São José do Rio Preto'	35001	'Jales'
3529708	"MIGUELOPOLIS"	35	-48.0293341827145	-20.1771292325793	3502	'Ribeirão Preto'	35010	'São Joaquim da Barra'
3529807	"MINEIROS DO TIETE"	35	-48.4518023092831	-22.4116968007708	3504	'Bauru'	35021	'Jaú'
3530003	"MIRA ESTRELA"	35	-50.138427196428	-19.9805160524126	3501	'São José do Rio Preto'	35002	'Fernandópolis'
3529906	"MIRACATU"	35	-47.4571039991089	-24.2839294653761	3514	'Litoral Sul Paulista'	35055	'Registro'
3530102	"MIRANDOPOLIS"	35	-51.1056403917537	-21.132086985	3503	'Araçatuba'	35016	'Andradina'
3530201	"MIRANTE DO PARANAPANEMA"	35	-51.905794305935	-22.2905585944723	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3530300	"MIRASSOL"	35	-49.5121392179273	-20.8170045	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3530409	"MIRASSOLANDIA"	35	-49.4655198425085	-20.616857219804	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3530508	"MOCOCA"	35	-47.0071709787367	-21.46899051	3507	'Campinas'	35030	'São João da Boa Vista'
3530607	"MOGI DAS CRUZES"	35	-46.1967600843266	-23.5227065	3515	'Metropolitana de São Paulo'	35062	'Mogi das Cruzes'
3530706	"MOGI GUACU"	35	-46.9444740881491	-22.3657201895116	3507	'Campinas'	35031	'Mogi Mirim'
3530805	"MOJI MIRIM"	35	-46.956367126579	-22.4326955	3507	'Campinas'	35031	'Mogi Mirim'
3530904	"MOMBUCA"	35	-47.5675240048384	-22.9268278834078	3506	'Piracicaba'	35028	'Piracicaba'
3531001	"MONCOES"	35	-50.0963061315458	-20.8503257037729	3501	'São José do Rio Preto'	35007	'Nhandeara'
3531100	"MONGAGUA"	35	-46.619992725371	-24.0941161449999	3514	'Litoral Sul Paulista'	35056	'Itanhaém'
3531209	"MONTE ALEGRE DO SUL"	35	-46.6811943005087	-22.6811286598593	3507	'Campinas'	35033	'Amparo'
3531308	"MONTE ALTO"	35	-48.496651259966	-21.263863995	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3531407	"MONTE APRAZIVEL"	35	-49.7141161614286	-20.7721401375947	3501	'São José do Rio Preto'	35007	'Nhandeara'
3531506	"MONTE AZUL PAULISTA"	35	-48.642971283281	-20.9038412258907	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3531605	"MONTE CASTELO"	35	-51.5654932487094	-21.2989594492626	3508	'Presidente Prudente'	35034	'Dracena'
3531803	"MONTE MOR"	35	-47.3132692483363	-22.945521999322	3507	'Campinas'	35032	'Campinas'
3531704	"MONTEIRO LOBATO"	35	-45.8481519849651	-22.9550105791512	3513	'Vale do Paraíba Paulista'	35049	'Campos do Jordão'
3531902	"MORRO AGUDO"	35	-48.0575938253217	-20.7326629993746	3502	'Ribeirão Preto'	35010	'São Joaquim da Barra'
3532009	"MORUNGABA"	35	-46.7913443945838	-22.8810309326945	3512	'Macro Metropolitana Paulista'	35048	'Bragança Paulista'
3532058	"MOTUCA"	35	-48.1506612543949	-21.5076094411899	3505	'Araraquara'	35024	'Araraquara'
3532108	"MURUTINGA DO SUL"	35	-51.2771381855099	-20.99429808926	3503	'Araçatuba'	35016	'Andradina'
3532157	"NANTES"	35	-51.2385874975948	-22.6201175825202	3510	'Assis'	35039	'Assis'
3532207	"NARANDIBA"	35	-51.5242398508102	-22.4042831999049	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3532306	"NATIVIDADE DA SERRA"	35	-45.4464004707244	-23.3757869833588	3513	'Vale do Paraíba Paulista'	35053	'Paraibuna/Paraitinga'
3532405	"NAZARE PAULISTA"	35	-46.4025902149896	-23.1786958110045	3512	'Macro Metropolitana Paulista'	35048	'Bragança Paulista'
3532504	"NEVES PAULISTA"	35	-49.6304748513402	-20.8439161558274	3501	'São José do Rio Preto'	35007	'Nhandeara'
3532603	"NHANDEARA"	35	-50.0402744955429	-20.6948234993756	3501	'São José do Rio Preto'	35007	'Nhandeara'
3532702	"NIPOA"	35	-49.7808986510894	-20.9139024276169	3501	'São José do Rio Preto'	35007	'Nhandeara'
3532801	"NOVA ALIANCA"	35	-49.5071383479433	-21.0137347171998	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3532827	"NOVA CAMPINA"	35	-48.9057384790491	-24.1232104179112	3511	'Itapetininga'	35041	'Itapeva'
3532843	"NOVA CANAA PAULISTA"	35	-50.9480524385274	-20.3868950260488	3501	'São José do Rio Preto'	35001	'Jales'
3532868	"NOVA CASTILHO"	35	-50.3439061761777	-20.7656546201048	3501	'São José do Rio Preto'	35006	'Auriflama'
3532900	"NOVA EUROPA"	35	-48.5621404276762	-21.7789228838555	3505	'Araraquara'	35024	'Araraquara'
3533007	"NOVA GRANADA"	35	-49.3200928761116	-20.5331539993796	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3533106	"NOVA GUATAPORANGA"	35	-51.6498328903569	-21.3299371411701	3508	'Presidente Prudente'	35034	'Dracena'
3533205	"NOVA INDEPENDENCIA"	35	-51.4904465280516	-21.1045420014556	3503	'Araçatuba'	35016	'Andradina'
3533304	"NOVA LUZITANIA"	35	-50.2658273722874	-20.8566109993715	3501	'São José do Rio Preto'	35006	'Auriflama'
3533403	"NOVA ODESSA"	35	-47.2936346144048	-22.7827946609131	3507	'Campinas'	35032	'Campinas'
3533254	"NOVAIS"	35	-48.9170637096957	-20.9903581964183	3501	'São José do Rio Preto'	35005	'Catanduva'
3533502	"NOVO HORIZONTE"	35	-49.221749533677	-21.4684749893567	3501	'São José do Rio Preto'	35008	'Novo Horizonte'
3533601	"NUPORANGA"	35	-47.7491054639032	-20.7339997347712	3502	'Ribeirão Preto'	35010	'São Joaquim da Barra'
3533700	"OCAUCU"	35	-49.9273728303605	-22.438860447949	3509	'Marília'	35038	'Marília'
3533809	"OLEO"	35	-49.3409507526023	-22.9445847774897	3510	'Assis'	35040	'Ourinhos'
3533908	"OLIMPIA"	35	-48.9134917257694	-20.737283985	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3534005	"ONDA VERDE"	35	-49.2992147942624	-20.6127221201493	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3534104	"ORIENTE"	35	-50.0935854636602	-22.1485994118271	3509	'Marília'	35038	'Marília'
3534203	"ORINDIUVA"	35	-49.3518184809986	-20.1801967430368	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3534302	"ORLANDIA"	35	-47.8863838221278	-20.720421495	3502	'Ribeirão Preto'	35010	'São Joaquim da Barra'
3534401	"OSASCO"	35	-46.7888101442714	-23.533612	3515	'Metropolitana de São Paulo'	35057	'Osasco'
3534500	"OSCAR BRESSANE"	35	-50.2841261658479	-22.3178820548999	3509	'Marília'	35038	'Marília'
3534609	"OSVALDO CRUZ"	35	-50.8731391102634	-21.7970835	3508	'Presidente Prudente'	35035	'Adamantina'
3534708	"OURINHOS"	35	-49.868579835937	-22.9772675	3510	'Assis'	35040	'Ourinhos'
3534807	"OURO VERDE"	35	-51.6993207216788	-21.4911659171055	3508	'Presidente Prudente'	35034	'Dracena'
3534757	"OUROESTE"	35	-50.3775846521981	-19.9955921069967	3501	'São José do Rio Preto'	35002	'Fernandópolis'
3534906	"PACAEMBU"	35	-51.2652015199324	-21.5600784993545	3508	'Presidente Prudente'	35035	'Adamantina'
3535002	"PALESTINA"	35	-49.4337823999184	-20.3905874702698	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3535101	"PALMARES PAULISTA"	35	-48.8012846265372	-21.0824706914012	3501	'São José do Rio Preto'	35005	'Catanduva'
3535200	"PALMEIRA D'OESTE"	35	-50.7659878049468	-20.4162173246964	3501	'São José do Rio Preto'	35001	'Jales'
3535309	"PALMITAL"	35	-50.2187909877223	-22.785592	3510	'Assis'	35039	'Assis'
3535408	"PANORAMA"	35	-51.8565741615377	-21.360183557941	3508	'Presidente Prudente'	35034	'Dracena'
3535507	"PARAGUACU PAULISTA"	35	-50.5750285304783	-22.41771102	3510	'Assis'	35039	'Assis'
3535606	"PARAIBUNA"	35	-45.6628640605501	-23.3862615659286	3513	'Vale do Paraíba Paulista'	35053	'Paraibuna/Paraitinga'
3535705	"PARAISO"	35	-48.7725289127498	-21.0157929993515	3501	'São José do Rio Preto'	35005	'Catanduva'
3535804	"PARANAPANEMA"	35	-48.7236769841271	-23.386927999312	3504	'Bauru'	35022	'Avaré'
3535903	"PARANAPUA"	35	-50.5867189179955	-20.0998059524588	3501	'São José do Rio Preto'	35001	'Jales'
3536000	"PARAPUA"	35	-50.7938438430625	-21.7798391437891	3508	'Presidente Prudente'	35035	'Adamantina'
3536109	"PARDINHO"	35	-48.3728766836555	-23.0803183239365	3504	'Bauru'	35023	'Botucatu'
3536208	"PARIQUERA-ACU"	35	-47.8799976028944	-24.7125466309581	3514	'Litoral Sul Paulista'	35055	'Registro'
3536257	"PARISI"	35	-50.012617830837	-20.3021911754183	3501	'São José do Rio Preto'	35003	'Votuporanga'
3536307	"PATROCINIO PAULISTA"	35	-47.2830600903002	-20.6411534023077	3502	'Ribeirão Preto'	35012	'Franca'
3536406	"PAULICEIA"	35	-51.8471399509412	-21.3092755579826	3508	'Presidente Prudente'	35034	'Dracena'
3536505	"PAULINIA"	35	-47.1543858009695	-22.7599217	3507	'Campinas'	35032	'Campinas'
3536570	"PAULISTANIA"	35	-49.3990383461375	-22.57430074801	3504	'Bauru'	35020	'Bauru'
3536604	"PAULO DE FARIA"	35	-49.3995518863825	-20.0293000277993	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3536703	"PEDERNEIRAS"	35	-48.7796809636213	-22.3554915	3504	'Bauru'	35021	'Jaú'
3536802	"PEDRA BELA"	35	-46.4420309473291	-22.7913843518599	3507	'Campinas'	35033	'Amparo'
3536901	"PEDRANOPOLIS"	35	-50.1123902828971	-20.2476466672454	3501	'São José do Rio Preto'	35002	'Fernandópolis'
3537008	"PEDREGULHO"	35	-47.4817949691207	-20.2568709993865	3502	'Ribeirão Preto'	35012	'Franca'
3537107	"PEDREIRA"	35	-46.8978020902908	-22.743771	3507	'Campinas'	35032	'Campinas'
3537156	"PEDRINHAS PAULISTA"	35	-50.792165655457	-22.811215213632	3510	'Assis'	35039	'Assis'
3537206	"PEDRO DE TOLEDO"	35	-47.2290763497417	-24.2728006735454	3514	'Litoral Sul Paulista'	35056	'Itanhaém'
3537305	"PENAPOLIS"	35	-50.0730362750292	-21.418383015	3503	'Araçatuba'	35018	'Birigui'
3537404	"PEREIRA BARRETO"	35	-51.1066610199469	-20.636668999377	3503	'Araçatuba'	35016	'Andradina'
3537503	"PEREIRAS"	35	-47.9678667729849	-23.0728523359407	3511	'Itapetininga'	35043	'Tatuí'
3537602	"PERUIBE"	35	-46.9973018645123	-24.3195088839999	3514	'Litoral Sul Paulista'	35056	'Itanhaém'
3537701	"PIACATU"	35	-50.5994257172224	-21.5953916792139	3503	'Araçatuba'	35018	'Birigui'
3537800	"PIEDADE"	35	-47.418015150931	-23.7142022229999	3512	'Macro Metropolitana Paulista'	35045	'Piedade'
3537909	"PILAR DO SUL"	35	-47.7155077158385	-23.814612	3512	'Macro Metropolitana Paulista'	35045	'Piedade'
3538006	"PINDAMONHANGABA"	35	-45.4620488462304	-22.9266687258989	3513	'Vale do Paraíba Paulista'	35050	'São José dos Campos'
3538105	"PINDORAMA"	35	-48.9056375352937	-21.1859884885525	3501	'São José do Rio Preto'	35005	'Catanduva'
3538204	"PINHALZINHO"	35	-46.5905773189317	-22.7807960685162	3507	'Campinas'	35033	'Amparo'
3538303	"PIQUEROBI"	35	-51.7316269037642	-21.8849896988148	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3538501	"PIQUETE"	35	-45.1835694244977	-22.6111668851801	3513	'Vale do Paraíba Paulista'	35051	'Guaratinguetá'
3538600	"PIRACAIA"	35	-46.3587552004696	-23.050499	3512	'Macro Metropolitana Paulista'	35048	'Bragança Paulista'
3538709	"PIRACICABA"	35	-47.6468462361582	-22.723722	3506	'Piracicaba'	35028	'Piracicaba'
3538808	"PIRAJU"	35	-49.3839744896606	-23.192991495	3510	'Assis'	35040	'Ourinhos'
3538907	"PIRAJUI"	35	-49.4566424333696	-21.993447	3504	'Bauru'	35020	'Bauru'
3539004	"PIRANGI"	35	-48.6698419325618	-21.0996316625998	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3539103	"PIRAPORA DO BOM JESUS"	35	-47.0009675687449	-23.3975233079019	3515	'Metropolitana de São Paulo'	35057	'Osasco'
3539202	"PIRAPOZINHO"	35	-51.4995842900895	-22.276675485	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3539301	"PIRASSUNUNGA"	35	-47.4251728816539	-21.994049295	3507	'Campinas'	35029	'Pirassununga'
3539400	"PIRATININGA"	35	-49.1372522167908	-22.4120659448211	3504	'Bauru'	35020	'Bauru'
3539509	"PITANGUEIRAS"	35	-48.222265751502	-21.0109994993678	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3539608	"PLANALTO"	35	-49.925719799209	-21.0323282024965	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3539707	"PLATINA"	35	-50.208934535832	-22.6334572583338	3510	'Assis'	35039	'Assis'
3539806	"POA"	35	-46.3462203886587	-23.5286265676615	3515	'Metropolitana de São Paulo'	35062	'Mogi das Cruzes'
3539905	"POLONI"	35	-49.8138949066775	-20.7858577505803	3501	'São José do Rio Preto'	35007	'Nhandeara'
3540002	"POMPEIA"	35	-50.176028054853	-22.1061456540783	3509	'Marília'	35038	'Marília'
3540101	"PONGAI"	35	-49.3608700748926	-21.7361764725485	3504	'Bauru'	35020	'Bauru'
3540200	"PONTAL"	35	-48.0378373025419	-21.02571	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3540259	"PONTALINDA"	35	-50.524602015676	-20.4408338429439	3501	'São José do Rio Preto'	35001	'Jales'
3540309	"PONTES GESTAL"	35	-49.703552355834	-20.1823631062097	3501	'São José do Rio Preto'	35003	'Votuporanga'
3540408	"POPULINA"	35	-50.5368531154367	-19.9443331306978	3501	'São José do Rio Preto'	35001	'Jales'
3540507	"PORANGABA"	35	-48.1267674358002	-23.1753874993167	3511	'Itapetininga'	35043	'Tatuí'
3540606	"PORTO FELIZ"	35	-47.5245965730656	-23.2144122679999	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3540705	"PORTO FERREIRA"	35	-47.481409643358	-21.858362505	3507	'Campinas'	35029	'Pirassununga'
3540754	"POTIM"	35	-45.255974312882	-22.8406202063186	3513	'Vale do Paraíba Paulista'	35051	'Guaratinguetá'
3540804	"POTIRENDABA"	35	-49.3781831999027	-21.0450947210928	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3540853	"PRACINHA"	35	-51.0870772105069	-21.8519276207301	3508	'Presidente Prudente'	35035	'Adamantina'
3540903	"PRADOPOLIS"	35	-48.0655830220454	-21.358049011278	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3541000	"PRAIA GRANDE"	35	-46.4120495836124	-24.0030215	3515	'Metropolitana de São Paulo'	35063	'Santos'
3541059	"PRATANIA"	35	-48.6646855775175	-22.8114679844676	3504	'Bauru'	35023	'Botucatu'
3541109	"PRESIDENTE ALVES"	35	-49.4391492872367	-22.1036743192374	3504	'Bauru'	35020	'Bauru'
3541208	"PRESIDENTE BERNARDES"	35	-51.557570191824	-22.0089907787559	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3541307	"PRESIDENTE EPITACIO"	35	-52.1152758269966	-21.768781995	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3541406	"PRESIDENTE PRUDENTE"	35	-51.3867655819125	-22.1227435	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3541505	"PRESIDENTE VENCESLAU"	35	-51.8402588050568	-21.875939505	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3541604	"PROMISSAO"	35	-49.8577352347911	-21.538867499355	3504	'Bauru'	35019	'Lins'
3541653	"QUADRA"	35	-48.0526853360855	-23.3015749993139	3511	'Itapetininga'	35043	'Tatuí'
3541703	"QUATA"	35	-50.6979473893502	-22.2494047983717	3510	'Assis'	35039	'Assis'
3541802	"QUEIROZ"	35	-50.2409284561053	-21.7990944339574	3509	'Marília'	35037	'Tupã'
3541901	"QUELUZ"	35	-44.7784773100595	-22.5418444993313	3513	'Vale do Paraíba Paulista'	35051	'Guaratinguetá'
3542008	"QUINTANA"	35	-50.3115952429299	-22.071919826417	3509	'Marília'	35037	'Tupã'
3542107	"RAFARD"	35	-47.5311606809031	-23.0115563538873	3506	'Piracicaba'	35028	'Piracicaba'
3542206	"RANCHARIA"	35	-50.890211685938	-22.22845101	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3542305	"REDENCAO DA SERRA"	35	-45.5364956107389	-23.2726554993106	3513	'Vale do Paraíba Paulista'	35053	'Paraibuna/Paraitinga'
3542404	"REGENTE FEIJO"	35	-51.3031489766821	-22.220234092902	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3542503	"REGINOPOLIS"	35	-49.2297976710518	-21.8867609385595	3504	'Bauru'	35020	'Bauru'
3542602	"REGISTRO"	35	-47.841054751675	-24.4942514279999	3514	'Litoral Sul Paulista'	35055	'Registro'
3542701	"RESTINGA"	35	-47.4830902374517	-20.6038028262709	3502	'Ribeirão Preto'	35012	'Franca'
3542800	"RIBEIRA"	35	-49.0083019947608	-24.6574894992839	3511	'Itapetininga'	35044	'Capão Bonito'
3542909	"RIBEIRAO BONITO"	35	-48.1777057541408	-22.06493466402	3505	'Araraquara'	35025	'São Carlos'
3543006	"RIBEIRAO BRANCO"	35	-48.7654774814823	-24.2202684575569	3511	'Itapetininga'	35044	'Capão Bonito'
3543105	"RIBEIRAO CORRENTE"	35	-47.5907050925335	-20.460660174376	3502	'Ribeirão Preto'	35012	'Franca'
3543204	"RIBEIRAO DO SUL"	35	-49.9341678147122	-22.7857347996783	3510	'Assis'	35040	'Ourinhos'
3543238	"RIBEIRAO DOS INDIOS"	35	-51.6006345171707	-21.8385000397493	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3543253	"RIBEIRAO GRANDE"	35	-48.3670711559505	-24.101200310693	3511	'Itapetininga'	35044	'Capão Bonito'
3543303	"RIBEIRAO PIRES"	35	-46.4153443749185	-23.707423	3515	'Metropolitana de São Paulo'	35061	'São Paulo'
3543402	"RIBEIRAO PRETO"	35	-47.8054759155415	-21.1848345	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3543600	"RIFAINA"	35	-47.4291988991085	-20.0829324993908	3502	'Ribeirão Preto'	35012	'Franca'
3543709	"RINCAO"	35	-48.0723300667108	-21.5891894993576	3505	'Araraquara'	35024	'Araraquara'
3543808	"RINOPOLIS"	35	-50.7248383216513	-21.7278909993505	3508	'Presidente Prudente'	35035	'Adamantina'
3543907	"RIO CLARO"	35	-47.5635332384344	-22.4125115	3506	'Piracicaba'	35026	'Rio Claro'
3544004	"RIO DAS PEDRAS"	35	-47.6044848861606	-22.8428607224999	3506	'Piracicaba'	35028	'Piracicaba'
3544103	"RIO GRANDE DA SERRA"	35	-46.3936926739737	-23.744515	3515	'Metropolitana de São Paulo'	35061	'São Paulo'
3544202	"RIOLANDIA"	35	-49.681159102897	-19.9777343379654	3501	'São José do Rio Preto'	35003	'Votuporanga'
3543501	"RIVERSUL"	35	-49.4366967189135	-23.8313350065799	3511	'Itapetininga'	35041	'Itapeva'
3544251	"ROSANA"	35	-53.0586544794081	-22.5811754993051	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3544301	"ROSEIRA"	35	-45.3093777870655	-22.8968185474924	3513	'Vale do Paraíba Paulista'	35051	'Guaratinguetá'
3544400	"RUBIACEA"	35	-50.7269079994794	-21.3005239894596	3503	'Araçatuba'	35017	'Araçatuba'
3544509	"RUBINEIA"	35	-50.9974845550347	-20.1717745	3501	'São José do Rio Preto'	35001	'Jales'
3544608	"SABINO"	35	-49.5808185602086	-21.460213833726	3504	'Bauru'	35019	'Lins'
3544707	"SAGRES"	35	-50.9571547111781	-21.8811386706383	3508	'Presidente Prudente'	35035	'Adamantina'
3544806	"SALES"	35	-49.4987686686201	-21.3444533768433	3501	'São José do Rio Preto'	35008	'Novo Horizonte'
3544905	"SALES OLIVEIRA"	35	-47.8423493399249	-20.7778821519735	3502	'Ribeirão Preto'	35010	'São Joaquim da Barra'
3545001	"SALESOPOLIS"	35	-45.847176929618	-23.5317929883978	3515	'Metropolitana de São Paulo'	35062	'Mogi das Cruzes'
3545100	"SALMOURAO"	35	-50.8606720042896	-21.6253627328396	3508	'Presidente Prudente'	35035	'Adamantina'
3545159	"SALTINHO"	35	-47.6782883887976	-22.8433674978233	3506	'Piracicaba'	35028	'Piracicaba'
3545209	"SALTO"	35	-47.2924156290787	-23.2040738057971	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3545308	"SALTO DE PIRAPORA"	35	-47.5746801202081	-23.6491322249999	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3545407	"SALTO GRANDE"	35	-49.9810777589953	-22.8905072541939	3510	'Assis'	35040	'Ourinhos'
3545506	"SANDOVALINA"	35	-51.7599517360995	-22.4585417399964	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3545605	"SANTA ADELIA"	35	-48.8059484186125	-21.24327	3501	'São José do Rio Preto'	35005	'Catanduva'
3545704	"SANTA ALBERTINA"	35	-50.7305643708393	-20.0307026219517	3501	'São José do Rio Preto'	35001	'Jales'
3545803	"SANTA BARBARA D'OESTE"	35	-47.4139547662303	-22.7553935	3507	'Campinas'	35032	'Campinas'
3546009	"SANTA BRANCA"	35	-45.8876482871122	-23.3957580348717	3513	'Vale do Paraíba Paulista'	35050	'São José dos Campos'
3546108	"SANTA CLARA D'OESTE"	35	-50.9302211544636	-20.0913919359022	3501	'São José do Rio Preto'	35001	'Jales'
3546207	"SANTA CRUZ DA CONCEICAO"	35	-47.4571636949973	-22.1276819650707	3506	'Piracicaba'	35027	'Limeira'
3546256	"SANTA CRUZ DA ESPERANCA"	35	-47.4337805615268	-21.2911683770477	3502	'Ribeirão Preto'	35015	'Batatais'
3546306	"SANTA CRUZ DAS PALMEIRAS"	35	-47.249414421875	-21.827568	3507	'Campinas'	35029	'Pirassununga'
3546405	"SANTA CRUZ DO RIO PARDO"	35	-49.6246088693009	-22.9057225	3510	'Assis'	35040	'Ourinhos'
3546504	"SANTA ERNESTINA"	35	-48.3936499288618	-21.462921503003	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3546603	"SANTA FE DO SUL"	35	-50.9267774238433	-20.211693165	3501	'São José do Rio Preto'	35001	'Jales'
3546702	"SANTA GERTRUDES"	35	-47.5307087162038	-22.4553269562963	3506	'Piracicaba'	35027	'Limeira'
3546801	"SANTA ISABEL"	35	-46.2270128418218	-23.3180885	3515	'Metropolitana de São Paulo'	35059	'Guarulhos'
3546900	"SANTA LUCIA"	35	-48.0853360131002	-21.6865678510772	3505	'Araraquara'	35024	'Araraquara'
3547007	"SANTA MARIA DA SERRA"	35	-48.1590141415467	-22.5694102578227	3506	'Piracicaba'	35028	'Piracicaba'
3547106	"SANTA MERCEDES"	35	-51.7589742421449	-21.3469107455922	3508	'Presidente Prudente'	35034	'Dracena'
3547502	"SANTA RITA DO PASSA QUATRO"	35	-47.4789808517864	-21.70714401	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3547403	"SANTA RITA D'OESTE"	35	-50.8309473881775	-20.1418014734409	3501	'São José do Rio Preto'	35001	'Jales'
3547601	"SANTA ROSA DE VITERBO"	35	-47.3672689282942	-21.4852725	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3547650	"SANTA SALETE"	35	-50.6884618811611	-20.2438451880186	3501	'São José do Rio Preto'	35001	'Jales'
3547205	"SANTANA DA PONTE PENSA"	35	-50.7984038446256	-20.2526022556705	3501	'São José do Rio Preto'	35001	'Jales'
3547304	"SANTANA DE PARNAIBA"	35	-46.9220925056497	-23.449453	3515	'Metropolitana de São Paulo'	35057	'Osasco'
3547700	"SANTO ANASTACIO"	35	-51.6498922117679	-21.97302102	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3547809	"SANTO ANDRE"	35	-46.5308742576295	-23.65751	3515	'Metropolitana de São Paulo'	35061	'São Paulo'
3547908	"SANTO ANTONIO DA ALEGRIA"	35	-47.1559309699915	-21.0899640290791	3502	'Ribeirão Preto'	35015	'Batatais'
3548005	"SANTO ANTONIO DE POSSE"	35	-46.9159099001221	-22.6047968522941	3507	'Campinas'	35031	'Mogi Mirim'
3548054	"SANTO ANTONIO DO ARACANGUA"	35	-50.4967350523279	-20.9324968425443	3503	'Araçatuba'	35017	'Araçatuba'
3548104	"SANTO ANTONIO DO JARDIM"	35	-46.6823066318305	-22.1185234999319	3507	'Campinas'	35030	'São João da Boa Vista'
3548203	"SANTO ANTONIO DO PINHAL"	35	-45.6792788632616	-22.8311934022588	3513	'Vale do Paraíba Paulista'	35049	'Campos do Jordão'
3548302	"SANTO EXPEDITO"	35	-51.3909209814133	-21.8468050512061	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3548401	"SANTOPOLIS DO AGUAPEI"	35	-50.5046924735538	-21.6393116638351	3503	'Araçatuba'	35018	'Birigui'
3548500	"SANTOS"	35	-46.3313708491907	-23.9337375	3515	'Metropolitana de São Paulo'	35063	'Santos'
3548609	"SAO BENTO DO SAPUCAI"	35	-45.7371389868924	-22.6852869533192	3513	'Vale do Paraíba Paulista'	35049	'Campos do Jordão'
3548708	"SAO BERNARDO DO CAMPO"	35	-46.5502572476783	-23.7103045	3515	'Metropolitana de São Paulo'	35061	'São Paulo'
3548807	"SAO CAETANO DO SUL"	35	-46.5715146086306	-23.614705	3515	'Metropolitana de São Paulo'	35061	'São Paulo'
3548906	"SAO CARLOS"	35	-47.8892376846916	-22.0159985	3505	'Araraquara'	35025	'São Carlos'
3549003	"SAO FRANCISCO"	35	-50.7000971572879	-20.3584138176091	3501	'São José do Rio Preto'	35001	'Jales'
3549102	"SAO JOAO DA BOA VISTA"	35	-46.7963507817956	-21.972011	3507	'Campinas'	35030	'São João da Boa Vista'
3549201	"SAO JOAO DAS DUAS PONTES"	35	-50.3807219077481	-20.3887717266302	3501	'São José do Rio Preto'	35002	'Fernandópolis'
3549250	"SAO JOAO DE IRACEMA"	35	-50.3515975169017	-20.512615492076	3501	'São José do Rio Preto'	35006	'Auriflama'
3549300	"SAO JOAO DO PAU D'ALHO"	35	-51.6666651611736	-21.2683639993616	3508	'Presidente Prudente'	35034	'Dracena'
3549409	"SAO JOAQUIM DA BARRA"	35	-47.8632680707133	-20.583165555	3502	'Ribeirão Preto'	35010	'São Joaquim da Barra'
3549508	"SAO JOSE DA BELA VISTA"	35	-47.6409895014997	-20.5944195310987	3502	'Ribeirão Preto'	35012	'Franca'
3549607	"SAO JOSE DO BARREIRO"	35	-44.5783409613193	-22.6464898966297	3513	'Vale do Paraíba Paulista'	35052	'Bananal'
3549706	"SAO JOSE DO RIO PARDO"	35	-46.8882658895285	-21.5961025	3507	'Campinas'	35030	'São João da Boa Vista'
3549805	"SAO JOSE DO RIO PRETO"	35	-49.3813476850258	-20.8126365	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3549904	"SAO JOSE DOS CAMPOS"	35	-45.8841754014597	-23.1840615	3513	'Vale do Paraíba Paulista'	35050	'São José dos Campos'
3549953	"SAO LOURENCO DA SERRA"	35	-46.941749717394	-23.8490857160501	3515	'Metropolitana de São Paulo'	35060	'Itapecerica da Serra'
3550001	"SAO LUIS DO PARAITINGA"	35	-45.3095445048095	-23.221871510221	3513	'Vale do Paraíba Paulista'	35053	'Paraibuna/Paraitinga'
3550100	"SAO MANUEL"	35	-48.5687632812679	-22.736459985	3504	'Bauru'	35023	'Botucatu'
3550209	"SAO MIGUEL ARCANJO"	35	-47.9955891463509	-23.87949	3512	'Macro Metropolitana Paulista'	35045	'Piedade'
3550308	"SAO PAULO"	35	-46.5703831821128	-23.5673865	3515	'Metropolitana de São Paulo'	35061	'São Paulo'
3550407	"SAO PEDRO"	35	-47.9140329971131	-22.548888	3506	'Piracicaba'	35028	'Piracicaba'
3550506	"SAO PEDRO DO TURVO"	35	-49.7414761629027	-22.7512564292451	3510	'Assis'	35040	'Ourinhos'
3550605	"SAO ROQUE"	35	-47.1354230127479	-23.530359	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3550704	"SAO SEBASTIAO"	35	-45.402680140544	-23.8066876521488	3513	'Vale do Paraíba Paulista'	35054	'Caraguatatuba'
3550803	"SAO SEBASTIAO DA GRAMA"	35	-46.8241276257914	-21.7084207919196	3507	'Campinas'	35030	'São João da Boa Vista'
3550902	"SAO SIMAO"	35	-47.5533525399834	-21.479723372164	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3551009	"SAO VICENTE"	35	-46.3844908173177	-23.967373	3515	'Metropolitana de São Paulo'	35063	'Santos'
3551108	"SARAPUI"	35	-47.8271959850447	-23.6415065707683	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3551207	"SARUTAIA"	35	-49.4831286342664	-23.2744959258442	3510	'Assis'	35040	'Ourinhos'
3551306	"SEBASTIANOPOLIS DO SUL"	35	-49.9209224971393	-20.6568804993765	3501	'São José do Rio Preto'	35007	'Nhandeara'
3551405	"SERRA AZUL"	35	-47.563249920264	-21.3102876656624	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3551603	"SERRA NEGRA"	35	-46.7017913807122	-22.6126935218595	3507	'Campinas'	35033	'Amparo'
3551504	"SERRANA"	35	-47.5977620963446	-21.209477985	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3551702	"SERTAOZINHO"	35	-47.991148431	-21.137021505	3502	'Ribeirão Preto'	35014	'Ribeirão Preto'
3551801	"SETE BARRAS"	35	-47.9272169634722	-24.3886037821879	3514	'Litoral Sul Paulista'	35055	'Registro'
3551900	"SEVERINIA"	35	-48.8015339794314	-20.8093857877632	3501	'São José do Rio Preto'	35005	'Catanduva'
3552007	"SILVEIRAS"	35	-44.8489961031593	-22.6614243463512	3513	'Vale do Paraíba Paulista'	35052	'Bananal'
3552106	"SOCORRO"	35	-46.5292115917609	-22.5920299518995	3507	'Campinas'	35033	'Amparo'
3552205	"SOROCABA"	35	-47.457853253204	-23.499323	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3552304	"SUD MENNUCCI"	35	-50.9205265590321	-20.6929434993756	3503	'Araçatuba'	35016	'Andradina'
3552403	"SUMARE"	35	-47.2658027320901	-22.822145	3507	'Campinas'	35032	'Campinas'
3552551	"SUZANAPOLIS"	35	-51.0282225865129	-20.5033442669623	3503	'Araçatuba'	35016	'Andradina'
3552502	"SUZANO"	35	-46.3078104672882	-23.5368275	3515	'Metropolitana de São Paulo'	35062	'Mogi das Cruzes'
3552601	"TABAPUA"	35	-49.0326214091866	-20.9576006760593	3501	'São José do Rio Preto'	35005	'Catanduva'
3552700	"TABATINGA"	35	-48.6867876140157	-21.7325145	3505	'Araraquara'	35024	'Araraquara'
3552809	"TABOAO DA SERRA"	35	-46.7857800342102	-23.6233285	3515	'Metropolitana de São Paulo'	35060	'Itapecerica da Serra'
3552908	"TACIBA"	35	-51.284773424105	-22.388266261606	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3553005	"TAGUAI"	35	-49.4057711155675	-23.449814118588	3510	'Assis'	35040	'Ourinhos'
3553104	"TAIACU"	35	-48.5119552220808	-21.1467362736079	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3553203	"TAIUVA"	35	-48.4539353422828	-21.1295562882791	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3553302	"TAMBAU"	35	-47.2716155130664	-21.703033	3507	'Campinas'	35030	'São João da Boa Vista'
3553401	"TANABI"	35	-49.6488201993718	-20.6251121361351	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3553500	"TAPIRAI"	35	-47.5052882352036	-23.9731482667906	3512	'Macro Metropolitana Paulista'	35045	'Piedade'
3553609	"TAPIRATIBA"	35	-46.7455152106836	-21.4718854023053	3507	'Campinas'	35030	'São João da Boa Vista'
3553658	"TAQUARAL"	35	-48.4086549184105	-21.0726085	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3553708	"TAQUARITINGA"	35	-48.5067421828536	-21.410008	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3553807	"TAQUARITUBA"	35	-49.2440885383899	-23.5320605077168	3511	'Itapetininga'	35041	'Itapeva'
3553856	"TAQUARIVAI"	35	-48.697328636962	-23.9192571496529	3511	'Itapetininga'	35041	'Itapeva'
3553906	"TARABAI"	35	-51.5595725755548	-22.3016682954719	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3553955	"TARUMA"	35	-50.5765651350867	-22.7447711942842	3510	'Assis'	35039	'Assis'
3554003	"TATUI"	35	-47.8494640336609	-23.3485765	3511	'Itapetininga'	35043	'Tatuí'
3554102	"TAUBATE"	35	-45.5566086966874	-23.0265555	3513	'Vale do Paraíba Paulista'	35050	'São José dos Campos'
3554201	"TEJUPA"	35	-49.3774419611386	-23.3405917462502	3510	'Assis'	35040	'Ourinhos'
3554300	"TEODORO SAMPAIO"	35	-52.1711948221637	-22.531007	3508	'Presidente Prudente'	35036	'Presidente Prudente'
3554409	"TERRA ROXA"	35	-48.3415361372325	-20.7878416566548	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3554508	"TIETE"	35	-47.7114725279963	-23.097889485	3506	'Piracicaba'	35028	'Piracicaba'
3554607	"TIMBURI"	35	-49.6035428949314	-23.2023633829603	3510	'Assis'	35040	'Ourinhos'
3554656	"TORRE DE PEDRA"	35	-48.1982388398873	-23.2437695272621	3511	'Itapetininga'	35043	'Tatuí'
3554706	"TORRINHA"	35	-48.1721575851456	-22.4274936146981	3506	'Piracicaba'	35026	'Rio Claro'
3554755	"TRABIJU"	35	-48.3401833937535	-22.0380736470599	3505	'Araraquara'	35024	'Araraquara'
3554805	"TREMEMBE"	35	-45.5507468823468	-22.9604152053933	3513	'Vale do Paraíba Paulista'	35050	'São José dos Campos'
3554904	"TRES FRONTEIRAS"	35	-50.8848827854553	-20.228012803364	3501	'São José do Rio Preto'	35001	'Jales'
3554953	"TUIUTI"	35	-46.6970238595325	-22.8147561551633	3512	'Macro Metropolitana Paulista'	35048	'Bragança Paulista'
3555000	"TUPA"	35	-50.514006421723	-21.93482151	3509	'Marília'	35037	'Tupã'
3555109	"TUPI PAULISTA"	35	-51.5767205759711	-21.3863953176887	3508	'Presidente Prudente'	35034	'Dracena'
3555208	"TURIUBA"	35	-50.1094417505193	-20.9502350891825	3503	'Araçatuba'	35018	'Birigui'
3555307	"TURMALINA"	35	-50.4777294314793	-20.0512686173184	3501	'São José do Rio Preto'	35002	'Fernandópolis'
3555356	"UBARANA"	35	-49.719672394224	-21.1624709998002	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3555406	"UBATUBA"	35	-45.0720914754799	-23.4359649805169	3513	'Vale do Paraíba Paulista'	35054	'Caraguatatuba'
3555505	"UBIRAJARA"	35	-49.6632716655535	-22.5238354502071	3504	'Bauru'	35020	'Bauru'
3555604	"UCHOA"	35	-49.1776695349784	-20.9533463992657	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
3555703	"UNIAO PAULISTA"	35	-49.8973935791086	-20.8877689993708	3501	'São José do Rio Preto'	35007	'Nhandeara'
3555802	"URANIA"	35	-50.6418001540779	-20.2462640966701	3501	'São José do Rio Preto'	35001	'Jales'
3555901	"URU"	35	-49.2832016013571	-21.7863136524377	3504	'Bauru'	35020	'Bauru'
3556008	"URUPES"	35	-49.2907298494467	-21.2004188127348	3501	'São José do Rio Preto'	35008	'Novo Horizonte'
3556107	"VALENTIM GENTIL"	35	-50.0858682817053	-20.4233702918777	3501	'São José do Rio Preto'	35003	'Votuporanga'
3556206	"VALINHOS"	35	-46.9966300275552	-22.971244	3507	'Campinas'	35032	'Campinas'
3556305	"VALPARAISO"	35	-50.8693081190398	-21.2255752828595	3503	'Araçatuba'	35017	'Araçatuba'
3556354	"VARGEM"	35	-46.4116002331355	-22.8848804238204	3512	'Macro Metropolitana Paulista'	35048	'Bragança Paulista'
3556404	"VARGEM GRANDE DO SUL"	35	-46.8956089147522	-21.835866	3507	'Campinas'	35030	'São João da Boa Vista'
3556453	"VARGEM GRANDE PAULISTA"	35	-47.019647784074	-23.6153025	3515	'Metropolitana de São Paulo'	35060	'Itapecerica da Serra'
3556503	"VARZEA PAULISTA"	35	-46.8298902239178	-23.2144665	3512	'Macro Metropolitana Paulista'	35047	'Jundiaí'
3556602	"VERA CRUZ"	35	-49.8217816545761	-22.2247483148416	3509	'Marília'	35038	'Marília'
3556701	"VINHEDO"	35	-46.9764763090797	-23.0305383241408	3507	'Campinas'	35032	'Campinas'
3556800	"VIRADOURO"	35	-48.2966628795998	-20.872314	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3556909	"VISTA ALEGRE DO ALTO"	35	-48.630171357211	-21.1671540847205	3502	'Ribeirão Preto'	35013	'Jaboticabal'
3556958	"VITORIA BRASIL"	35	-50.4808069702363	-20.1987385744561	3501	'São José do Rio Preto'	35001	'Jales'
3557006	"VOTORANTIM"	35	-47.4497380579827	-23.5418712059999	3512	'Macro Metropolitana Paulista'	35046	'Sorocaba'
3557105	"VOTUPORANGA"	35	-49.9746720152067	-20.41947	3501	'São José do Rio Preto'	35003	'Votuporanga'
3557154	"ZACARIAS"	35	-50.0557395184794	-21.0501104349718	3501	'São José do Rio Preto'	35004	'São José do Rio Preto'
1700251	"ABREULANDIA"	17	-49.1624375554797	-9.62179071199836	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1700301	"AGUIARNOPOLIS"	17	-47.470456587945	-6.5471708206181	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1700350	"ALIANCA DO TOCANTINS"	17	-48.9412400221409	-11.3037430465089	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1700400	"ALMAS"	17	-47.1741716842358	-11.5745234694478	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1700707	"ALVORADA"	17	-49.12681140673	-12.4788153208227	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1701002	"ANANAS"	17	-48.0797646061948	-6.36281815410008	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1701051	"ANGICO"	17	-47.8620778391735	-6.3877527497248	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1701101	"APARECIDA DO RIO NEGRO"	17	-47.9766700113511	-9.9558777145605	1702	'Oriental do Tocantins'	17006	'Porto Nacional'
1701309	"ARAGOMINAS"	17	-48.5234301922917	-7.1643492714437	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1701903	"ARAGUACEMA"	17	-49.5618126396074	-8.80180254411115	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1702000	"ARAGUACU"	17	-49.8286124432782	-12.9255837118616	1701	'Ocidental do Tocantins'	17004	'Rio Formoso'
1702109	"ARAGUAINA"	17	-48.2087052518558	-7.19132893965496	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1702158	"ARAGUANA"	17	-48.6437495469431	-6.58224942002919	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1702208	"ARAGUATINS"	17	-48.1235073430294	-5.65058647299995	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1702307	"ARAPOEMA"	17	-49.0756373852721	-7.65256973541903	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1702406	"ARRAIAS"	17	-46.9461070585534	-12.9344198592593	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1702554	"AUGUSTINOPOLIS"	17	-47.8809567910047	-5.46541429589652	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1702703	"AURORA DO TOCANTINS"	17	-46.4070829808607	-12.7084898610615	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1702901	"AXIXA DO TOCANTINS"	17	-47.7741560325221	-5.62430906592745	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1703008	"BABACULANDIA"	17	-47.7588161270324	-7.20186453206148	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1703057	"BANDEIRANTES DO TOCANTINS"	17	-48.5783806048644	-7.76485914125333	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1703073	"BARRA DO OURO"	17	-47.6871349692244	-7.69176659865687	1702	'Oriental do Tocantins'	17007	'Jalapão'
1703107	"BARROLANDIA"	17	-48.7314605907218	-9.83165336453343	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1703206	"BERNARDO SAYAO"	17	-48.8990543467276	-7.86851248331281	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1703305	"BOM JESUS DO TOCANTINS"	17	-48.1663804935405	-8.96334801285521	1702	'Oriental do Tocantins'	17006	'Porto Nacional'
1703602	"BRASILANDIA DO TOCANTINS"	17	-48.485374419124	-8.38488935107799	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1703701	"BREJINHO DE NAZARE"	17	-48.5586602281507	-11.0108050561865	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1703800	"BURITI DO TOCANTINS"	17	-48.223250128075	-5.31353885638917	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1703826	"CACHOEIRINHA"	17	-47.914197778559	-6.11324164650466	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1703842	"CAMPOS LINDOS"	17	-46.8019743467067	-7.97168139413731	1702	'Oriental do Tocantins'	17007	'Jalapão'
1703867	"CARIRI DO TOCANTINS"	17	-49.1710407289889	-11.8889974638744	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1703883	"CARMOLANDIA"	17	-48.3959599306274	-7.03147877786106	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1703891	"CARRASCO BONITO"	17	-48.0306334265692	-5.32266135485805	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1703909	"CASEARA"	17	-49.9486922677787	-9.26740621890348	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1704105	"CENTENARIO"	17	-47.3383985145873	-8.9584636390938	1702	'Oriental do Tocantins'	17007	'Jalapão'
1705102	"CHAPADA DA NATIVIDADE"	17	-47.7539048918565	-11.6242678313621	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1704600	"CHAPADA DE AREIA"	17	-49.1831078580315	-10.1419885833334	1701	'Ocidental do Tocantins'	17004	'Rio Formoso'
1705508	"COLINAS DO TOCANTINS"	17	-48.4815945437489	-8.05462467549995	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1716703	"COLMEIA"	17	-48.7570665856948	-8.72937180681859	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1705557	"COMBINADO"	17	-46.5520723402661	-12.8186076720311	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1705607	"CONCEICAO DO TOCANTINS"	17	-47.292868810807	-12.2172777669654	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1706001	"COUTO MAGALHAES"	17	-49.176571570853	-8.35511836963524	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1706100	"CRISTALANDIA"	17	-49.1863002912612	-10.5907246371177	1701	'Ocidental do Tocantins'	17004	'Rio Formoso'
1706258	"CRIXAS DO TOCANTINS"	17	-48.9155138256477	-11.1042742936043	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1706506	"DARCINOPOLIS"	17	-47.7521611102799	-6.71235100148176	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1707009	"DIANOPOLIS"	17	-46.8204090669435	-11.625231878065	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1707108	"DIVINOPOLIS DO TOCANTINS"	17	-49.2054131873503	-9.79530114022946	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1707207	"DOIS IRMAOS DO TOCANTINS"	17	-49.0673386442723	-9.26129670979711	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1707306	"DUERE"	17	-49.2658759161628	-11.3412854167798	1701	'Ocidental do Tocantins'	17004	'Rio Formoso'
1707405	"ESPERANTINA"	17	-48.5441476004124	-5.36660805940451	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1707553	"FATIMA"	17	-48.8989826586808	-10.7525087280848	1701	'Ocidental do Tocantins'	17004	'Rio Formoso'
1707652	"FIGUEIROPOLIS"	17	-49.1738467307434	-12.1367799832225	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1707702	"FILADELFIA"	17	-47.484964141532	-7.3376119059308	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1708205	"FORMOSO DO ARAGUAIA"	17	-49.5268603629125	-11.8051419686495	1701	'Ocidental do Tocantins'	17004	'Rio Formoso'
1708254	"FORTALEZA DO TABOCAO"	17	-48.5174264210488	-9.05896530114982	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1708304	"GOIANORTE"	17	-48.9368901923611	-8.77052080482939	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1709005	"GOIATINS"	17	-47.3154354891583	-7.7091723901957	1702	'Oriental do Tocantins'	17007	'Jalapão'
1709302	"GUARAI"	17	-48.5086406064702	-8.83616565750443	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1709500	"GURUPI"	17	-49.0714774689303	-11.72977232286	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1709807	"IPUEIRAS"	17	-48.4519262288947	-11.2462886215917	1702	'Oriental do Tocantins'	17006	'Porto Nacional'
1710508	"ITACAJA"	17	-47.768112402678	-8.39098055231856	1702	'Oriental do Tocantins'	17007	'Jalapão'
1710706	"ITAGUATINS"	17	-47.4799359489833	-5.77538508840222	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1710904	"ITAPIRATINS"	17	-48.1111996094691	-8.38432959344297	1702	'Oriental do Tocantins'	17007	'Jalapão'
1711100	"ITAPORA DO TOCANTINS"	17	-48.6932637032248	-8.56882861156054	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1711506	"JAU DO TOCANTINS"	17	-48.5946082927248	-12.6529263692706	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1711803	"JUARINA"	17	-49.0986431854272	-8.11742396760678	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1711902	"LAGOA DA CONFUSAO"	17	-49.620085339146	-10.7886955575898	1701	'Ocidental do Tocantins'	17004	'Rio Formoso'
1711951	"LAGOA DO TOCANTINS"	17	-47.5614466302738	-10.2968866969998	1702	'Oriental do Tocantins'	17007	'Jalapão'
1712009	"LAJEADO"	17	-48.3585039506901	-9.74468243573559	1702	'Oriental do Tocantins'	17006	'Porto Nacional'
1712157	"LAVANDEIRA"	17	-46.5066757157435	-12.7916587876518	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1712405	"LIZARDA"	17	-46.6751654558461	-9.59457028780967	1702	'Oriental do Tocantins'	17007	'Jalapão'
1712454	"LUZINOPOLIS"	17	-47.856828041414	-6.19398966023577	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1712504	"MARIANOPOLIS DO TOCANTINS"	17	-49.6510339944378	-9.79888035935058	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1712702	"MATEIROS"	17	-46.412465743092	-10.5444288460778	1702	'Oriental do Tocantins'	17007	'Jalapão'
1712801	"MAURILANDIA DO TOCANTINS"	17	-47.5048799601751	-5.95256642121045	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1713205	"MIRACEMA DO TOCANTINS"	17	-48.3879913115193	-9.56834607764652	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1713304	"MIRANORTE"	17	-48.5926319369139	-9.51740473109312	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1713601	"MONTE DO CARMO"	17	-48.1104200299112	-10.7635421946238	1702	'Oriental do Tocantins'	17006	'Porto Nacional'
1713700	"MONTE SANTO DO TOCANTINS"	17	-48.9908906033935	-10.005591431794	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1713957	"MURICILANDIA"	17	-48.6067452770067	-7.13851928516033	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1714203	"NATIVIDADE"	17	-47.7272575338232	-11.7053573825042	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1714302	"NAZARE"	17	-47.6669771825263	-6.37255796928561	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1714880	"NOVA OLINDA"	17	-48.4248067900164	-7.6333149106925	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1715002	"NOVA ROSALANDIA"	17	-48.9061807245023	-10.5668711393323	1701	'Ocidental do Tocantins'	17004	'Rio Formoso'
1715101	"NOVO ACORDO"	17	-47.6681483922167	-9.96848646570169	1702	'Oriental do Tocantins'	17007	'Jalapão'
1715150	"NOVO ALEGRE"	17	-46.5772973536675	-12.9099386744081	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1715259	"NOVO JARDIM"	17	-46.6307872958899	-11.815875050149	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1715507	"OLIVEIRA DE FATIMA"	17	-48.9074015689032	-10.7083627090618	1701	'Ocidental do Tocantins'	17004	'Rio Formoso'
1721000	"PALMAS"	17	-48.3510437082462	-10.1632533267928	1702	'Oriental do Tocantins'	17006	'Porto Nacional'
1715705	"PALMEIRANTE"	17	-47.9342497089842	-7.85756137614505	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1713809	"PALMEIRAS DO TOCANTINS"	17	-47.5586835262825	-6.61186233456171	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1715754	"PALMEIROPOLIS"	17	-48.4134139552316	-13.0398884336692	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1716109	"PARAISO DO TOCANTINS"	17	-48.8866300840169	-10.1712207549999	1701	'Ocidental do Tocantins'	17004	'Rio Formoso'
1716208	"PARANA"	17	-47.8840837284426	-12.6204814887183	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1716307	"PAU D'ARCO"	17	-49.3633064810091	-7.53999835569997	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1716505	"PEDRO AFONSO"	17	-48.1775561127387	-8.96444959242294	1702	'Oriental do Tocantins'	17006	'Porto Nacional'
1716604	"PEIXE"	17	-48.537810626336	-12.029773830853	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1716653	"PEQUIZEIRO"	17	-48.9351798669158	-8.59334065444845	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1717008	"PINDORAMA DO TOCANTINS"	17	-47.5756877172877	-11.1382025846808	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1717206	"PIRAQUE"	17	-48.2937073910932	-6.76977703340735	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1717503	"PIUM"	17	-49.1666580115747	-10.4409311179305	1701	'Ocidental do Tocantins'	17004	'Rio Formoso'
1717800	"PONTE ALTA DO BOM JESUS"	17	-46.4695867923952	-12.0878129084344	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1717909	"PONTE ALTA DO TOCANTINS"	17	-47.5411803583019	-10.7406728486815	1702	'Oriental do Tocantins'	17007	'Jalapão'
1718006	"PORTO ALEGRE DO TOCANTINS"	17	-47.0474256004295	-11.6072590990885	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1718204	"PORTO NACIONAL"	17	-48.4121534584309	-10.708569917	1702	'Oriental do Tocantins'	17006	'Porto Nacional'
1718303	"PRAIA NORTE"	17	-47.8147317333423	-5.39671287737827	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1718402	"PRESIDENTE KENNEDY"	17	-48.504330670109	-8.52996082761918	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1718451	"PUGMIL"	17	-48.8942204487831	-10.4243071562468	1701	'Ocidental do Tocantins'	17004	'Rio Formoso'
1718501	"RECURSOLANDIA"	17	-47.2380411950208	-8.73536045388012	1702	'Oriental do Tocantins'	17007	'Jalapão'
1718550	"RIACHINHO"	17	-48.141045502038	-6.44221138769741	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1718659	"RIO DA CONCEICAO"	17	-46.8803997045722	-11.404940023899	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1718709	"RIO DOS BOIS"	17	-48.5330479716014	-9.3437422386879	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1718758	"RIO SONO"	17	-47.8999416391395	-9.34778933411611	1702	'Oriental do Tocantins'	17007	'Jalapão'
1718808	"SAMPAIO"	17	-47.8757924571994	-5.3492956164967	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1718840	"SANDOLANDIA"	17	-49.9333881543012	-12.5416001674833	1701	'Ocidental do Tocantins'	17004	'Rio Formoso'
1718865	"SANTA FE DO ARAGUAIA"	17	-48.6939418034376	-7.1499363850312	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1718881	"SANTA MARIA DO TOCANTINS"	17	-47.7452704192246	-8.77497644926651	1702	'Oriental do Tocantins'	17006	'Porto Nacional'
1718899	"SANTA RITA DO TOCANTINS"	17	-48.909294007359	-10.8664553694029	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1718907	"SANTA ROSA DO TOCANTINS"	17	-48.1199542217524	-11.4514039985494	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1719004	"SANTA TEREZA DO TOCANTINS"	17	-47.8062883215081	-10.2823615278187	1702	'Oriental do Tocantins'	17007	'Jalapão'
1720002	"SANTA TEREZINHA DO TOCANTINS"	17	-47.6842853630081	-6.43699761844425	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1720101	"SAO BENTO DO TOCANTINS"	17	-47.9193922870534	-6.04499925719239	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1720150	"SAO FELIX DO TOCANTINS"	17	-46.6549808310123	-10.1732858539628	1702	'Oriental do Tocantins'	17007	'Jalapão'
1720200	"SAO MIGUEL DO TOCANTINS"	17	-47.5730023393731	-5.55381952879429	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1720259	"SAO SALVADOR DO TOCANTINS"	17	-48.2320849916811	-12.7474334144954	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1720309	"SAO SEBASTIAO DO TOCANTINS"	17	-48.2038341490288	-5.25896145373507	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1720499	"SAO VALERIO DA NATIVIDADE"	17	-48.2329484333802	-11.9730674594797	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1720655	"SILVANOPOLIS"	17	-48.1798241355321	-11.1498613085628	1702	'Oriental do Tocantins'	17006	'Porto Nacional'
1720804	"SITIO NOVO DO TOCANTINS"	17	-47.6374226504604	-5.60472685665309	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1720853	"SUCUPIRA"	17	-48.9111262826871	-11.98622151086	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1720903	"TAGUATINGA"	17	-46.4387317008831	-12.3961417386813	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1720937	"TAIPAS DO TOCANTINS"	17	-46.9845717959323	-12.1928372090542	1702	'Oriental do Tocantins'	17008	'Dianópolis'
1720978	"TALISMA"	17	-49.0911184339335	-12.7875384068603	1701	'Ocidental do Tocantins'	17005	'Gurupi'
1721109	"TOCANTINIA"	17	-48.3758796714267	-9.55814773400572	1702	'Oriental do Tocantins'	17006	'Porto Nacional'
1721208	"TOCANTINOPOLIS"	17	-47.4274129286927	-6.32563437602796	1701	'Ocidental do Tocantins'	17001	'Bico do Papagaio'
1721257	"TUPIRAMA"	17	-48.2066848030641	-8.98056954941714	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1721307	"TUPIRATINS"	17	-48.1229957408688	-8.39552999695801	1701	'Ocidental do Tocantins'	17003	'Miracema do Tocantins'
1722081	"WANDERLANDIA"	17	-47.9562677260283	-6.8501255166885	1701	'Ocidental do Tocantins'	17002	'Araguaína'
1722107	"XAMBIOA"	17	-48.531601072817	-6.41188502017984	1701	'Ocidental do Tocantins'	17002	'Araguaína'
2113009	"VITORINO FREIRE"	21	-45.244185143155	-4.29118650014099	2102	'Oeste Maranhense'	21008	'Pindaré'
2114007	"ZE DOCA"	21	-45.657697860605	-3.2754805	2102	'Oeste Maranhense'	21008	'Pindaré'
