--
--Copyright (C) 2019 Centro de Computacao Cientifica e Software Livre
--Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR
--
--This file is part of SMPPIR-Tables.
--
--SMPPIR-Tables is free software: you can redistribute it and/or modify
--it under the terms of the GNU General Public License as published by
--the Free Software Foundation, either version 3 of the License, or
--(at your option) any later version.
--
--SMPPIR-Tables is distributed in the hope that it will be useful,
--but WITHOUT ANY WARRANTY; without even the implied warranty of
--MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--GNU General Public License for more details.
--
--You should have received a copy of the GNU General Public License
--along with SMPPIR-Tables.  If not, see <https://www.gnu.org/licenses/>.
--

CREATE TABLE prouni_ag 
AS 
SELECT 
    prouni.genero_beneficiario,
    prouni.raca_beneficiario,
    prouni.nome_curso,
    prouni.nome_ies,
    prouni.tipo,
    prouni.sigla_uf_beneficiario,
    prouni.regiao_beneficiario,
    prouni.ano_censo,
    prouni.nome_turno_curso,
    COUNT(*) AS total 

FROM 
    prouni 

GROUP BY 
    prouni.genero_beneficiario, 
    prouni.raca_beneficiario, 
    prouni.nome_curso, 
    prouni.nome_ies, 
    prouni.tipo, 
    prouni.sigla_uf_beneficiario, 
    prouni.regiao_beneficiario, 
    prouni.nome_turno_curso,
    prouni.ano_censo

ORDER BY 
    prouni.genero_beneficiario ASC, 
    prouni.raca_beneficiario ASC, 
    prouni.nome_curso ASC, 
    prouni.nome_ies ASC, 
    prouni.tipo ASC, 
    prouni.sigla_uf_beneficiario ASC, 
    prouni.regiao_beneficiario ASC, 
    prouni.nome_turno_curso ASC,
    prouni.ano_censo ASC
;
