--
--Copyright (C) 2019 Centro de Computacao Cientifica e Software Livre
--Departamento de Informatica - Universidade Federal do Parana - C3SL/UFPR
--
--This file is part of SMPPIR-Tables.
--
--SMPPIR-Tables is free software: you can redistribute it and/or modify
--it under the terms of the GNU General Public License as published by
--the Free Software Foundation, either version 3 of the License, or
--(at your option) any later version.
--
--SMPPIR-Tables is distributed in the hope that it will be useful,
--but WITHOUT ANY WARRANTY; without even the implied warranty of
--MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--GNU General Public License for more details.
--
--You should have received a copy of the GNU General Public License
--along with SMPPIR-Tables.  If not, see <https://www.gnu.org/licenses/>.
--

CREATE TABLE student_loans_ag 
AS 
SELECT 
    aluno_ens_superior.turno_aluno,
    aluno_ens_superior.descricao_genero_aluno,
    aluno_ens_superior.cor_raca_aluno,
    aluno_ens_superior.nome_curso,
    aluno_ens_superior.cod_ies,
    aluno_ens_superior.nome_ies,
    aluno_ens_superior.financiamento_reembolsavel_fies,
    aluno_ens_superior.financiamento_reembolsavel_estadual,
    aluno_ens_superior.financiamento_reembolsavel_municipal,
    aluno_ens_superior.financiamento_reembolsavel_prog_ies,
    aluno_ens_superior.financiamento_reembolsavel_entidade_externa,
    aluno_ens_superior.financiamento_reembolsavel_outra,
    aluno_ens_superior.financiamento_naoreembolsavel_prouni_integral,
    aluno_ens_superior.financiamento_naoreembolsavel_prouni_parcial,
    aluno_ens_superior.financiamento_naoreembolsavel_estadual,
    aluno_ens_superior.financiamento_naoreembolsavel_municipal,
    aluno_ens_superior.financiamento_naoreembolsavel_prog_ies,
    aluno_ens_superior.financiamento_naoreembolsavel_entidade_externa,
    aluno_ens_superior.financiamento_naoreembolsavel_outra,
    aluno_ens_superior.ano_censo,
    COUNT(*) AS total 
    
FROM 
    aluno_ens_superior 
    
WHERE 
    (reserva_vagas = 1) AND 
    (financiamento_estudantil = 1) AND 
    (cod_organizacao_academica IN (1, 4, 5)) 

GROUP BY  
    aluno_ens_superior.turno_aluno, 
    aluno_ens_superior.descricao_genero_aluno, 
    aluno_ens_superior.cor_raca_aluno, 
    aluno_ens_superior.nome_curso, 
    aluno_ens_superior.cod_ies, 
    aluno_ens_superior.nome_ies, 
    aluno_ens_superior.financiamento_reembolsavel_fies, 
    aluno_ens_superior.financiamento_reembolsavel_estadual, 
    aluno_ens_superior.financiamento_reembolsavel_municipal, 
    aluno_ens_superior.financiamento_reembolsavel_prog_ies, 
    aluno_ens_superior.financiamento_reembolsavel_entidade_externa, 
    aluno_ens_superior.financiamento_reembolsavel_outra, 
    aluno_ens_superior.financiamento_naoreembolsavel_prouni_integral, 
    aluno_ens_superior.financiamento_naoreembolsavel_prouni_parcial, 
    aluno_ens_superior.financiamento_naoreembolsavel_estadual, 
    aluno_ens_superior.financiamento_naoreembolsavel_municipal, 
    aluno_ens_superior.financiamento_naoreembolsavel_prog_ies, 
    aluno_ens_superior.financiamento_naoreembolsavel_entidade_externa, 
    aluno_ens_superior.financiamento_naoreembolsavel_outra, 
    aluno_ens_superior.ano_censo 

ORDER BY  
    aluno_ens_superior.turno_aluno ASC, 
    aluno_ens_superior.descricao_genero_aluno ASC, 
    aluno_ens_superior.cor_raca_aluno ASC, 
    aluno_ens_superior.nome_curso ASC, 
    aluno_ens_superior.cod_ies ASC, 
    aluno_ens_superior.nome_ies ASC, 
    aluno_ens_superior.financiamento_reembolsavel_fies ASC, 
    aluno_ens_superior.financiamento_reembolsavel_estadual ASC, 
    aluno_ens_superior.financiamento_reembolsavel_municipal ASC, 
    aluno_ens_superior.financiamento_reembolsavel_prog_ies ASC, 
    aluno_ens_superior.financiamento_reembolsavel_entidade_externa ASC, 
    aluno_ens_superior.financiamento_reembolsavel_outra ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_prouni_integral ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_prouni_parcial ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_estadual ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_municipal ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_prog_ies ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_entidade_externa ASC, 
    aluno_ens_superior.financiamento_naoreembolsavel_outra ASC, 
    aluno_ens_superior.ano_censo ASC
;