CREATE TABLE transporte AS (

WITH matricula_mod AS
        (SELECT count(*) as total, matricula.regiao_id AS regiao_id, estado_id, estado.nome AS estado_nome, municipio_id,
        escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural, dependencia_adm_id, dependencia_adm_priv, responsavel_transp,
        ano_censo, transporte_vans_kombi, transporte_micro_onibus, transporte_onibus, transporte_bicicleta,
        transporte_animal, transporte_outro, transporte_embar_0_5, transporte_embar_5_15, transporte_embar_15_35,
        transporte_embar_35, transporte_trem_metro, transporte_escolar_publico
        FROM matricula JOIN estado ON matricula.estado_id = estado.id
        WHERE tipo <= 3
        GROUP BY matricula.regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, transporte_vans_kombi,
        transporte_micro_onibus, transporte_onibus, transporte_bicicleta, transporte_animal, transporte_outro,
        transporte_embar_0_5, transporte_embar_5_15, transporte_embar_15_35, transporte_embar_35, transporte_trem_metro,
        transporte_escolar_publico
        ),

    matricula_mod_total AS
        (SELECT SUM(total) as total, regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, 0 as transporte_id
        FROM matricula_mod
        GROUP BY regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo),

    transporte_publico_total AS
        (SELECT SUM(total) as total, regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, 1 as transporte_id
        FROM matricula_mod
        WHERE transporte_escolar_publico = 1
        GROUP BY regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo),

    vans_kombi AS
        (SELECT SUM(total) as total, regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, 2 as transporte_id
        FROM matricula_mod
        WHERE transporte_vans_kombi = 1
        GROUP BY regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo),

    micro_bus AS
        (SELECT SUM(total) as total, regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, 3 as transporte_id
        FROM matricula_mod
        WHERE transporte_micro_onibus = 1
        GROUP BY regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo),

    bus AS
        (SELECT SUM(total) as total, regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, 4 as transporte_id
        FROM matricula_mod
        WHERE transporte_onibus = 1
        GROUP BY regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo),

    bike AS
        (SELECT SUM(total) as total, regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, 5 as transporte_id
        FROM matricula_mod
        WHERE transporte_bicicleta = 1
        GROUP BY regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo),

    animal_traction AS
        (SELECT SUM(total) as total, regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, 6 as transporte_id
        FROM matricula_mod
        WHERE transporte_animal = 1
        GROUP BY regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo),

    other_vehicle AS
        (SELECT SUM(total) as total, regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, 7 as transporte_id
        FROM matricula_mod
        WHERE transporte_outro = 1
        GROUP BY regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo),

    waterway_5 AS
        (SELECT SUM(total) as total, regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, 8 as transporte_id
        FROM matricula_mod
        WHERE transporte_embar_0_5 = 1
        GROUP BY regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo),

    waterway_15 AS
        (SELECT SUM(total) as total, regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, 9 as transporte_id
        FROM matricula_mod
        WHERE transporte_embar_5_15 = 1
        GROUP BY regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo),

    waterway_35 AS
        (SELECT SUM(total) as total, regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, 10 as transporte_id
        FROM matricula_mod
        WHERE transporte_embar_15_35 = 1
        GROUP BY regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo),

    waterway_35_upper AS
        (SELECT SUM(total) as total, regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, 11 as transporte_id
        FROM matricula_mod
        WHERE transporte_embar_35 = 1
        GROUP BY regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo),

    subway_train AS
        (SELECT SUM(total) as total, regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo, 12 as transporte_id
        FROM matricula_mod
        WHERE transporte_trem_metro = 1
        GROUP BY regiao_id, estado_id, estado_nome, municipio_id, escola_id, etapas_mod_ensino_segmento_id, localizacao_id, localidade_area_rural,
        dependencia_adm_id, dependencia_adm_priv, responsavel_transp, ano_censo)

SELECT * FROM matricula_mod_total
UNION ALL
SELECT * FROM transporte_publico_total
UNION ALL
SELECT * FROM vans_kombi
UNION ALL
SELECT * FROM micro_bus
UNION ALL
SELECT * FROM bus
UNION ALL
SELECT * FROM bike
UNION ALL
SELECT * FROM animal_traction
UNION ALL
SELECT * FROM other_vehicle
UNION ALL
SELECT * FROM waterway_5
UNION ALL
SELECT * FROM waterway_15
UNION ALL
SELECT * FROM waterway_35
UNION ALL
SELECT * FROM waterway_35_upper
UNION ALL
SELECT * FROM subway_train
);